/* *** Copyright Freescale Semiconductor, Inc, 2010 *** */ 

#ifndef __PROTOTYPE_SC3900_H
#define __PROTOTYPE_SC3900_H

# pragma reject_floats off

#ifdef WIN32
#	ifdef PROTOTYPE_EXPORTS
#		define PROTOTYPE_API __declspec(dllexport)
#	else
#		define PROTOTYPE_API __declspec(dllimport)
#	endif
#else
#	define PROTOTYPE_API extern
#endif

#ifdef __cplusplus
	extern "C" {
#endif

/*Conditionnal replacement of prototype functions                                       */
/* _ENTERPRISE_C_ is always defined by scc/IDE, and may appear in customers applications*/
/* _CW_NO_PROTO_REPLACE_ can be defined to prevent replacement of prototype functions   */
/*Replacement performed iff first defined, second undefined. Otherwise use definitions  */
/*in prototype.c                                                                        */

#undef _CW_X_PROTO_
#if defined(_ENTERPRISE_C_) && !defined(_CW_NO_PROTO_REPLACE_)
#define _CW_X_PROTO_
#endif

#ifdef _ENTERPRISE_C_
#	define __FUNC_CONST		__attribute__((const))
#	define __FUNC_PURE		__attribute__((pure))
#	ifdef PROTOTYPE_API
#		undef PROTOTYPE_API
#		define PROTOTYPE_API
#	endif
#else
#	define __FUNC_CONST
#	define __FUNC_PURE
#	define inline
#	define _HOST_EMULATION_ 1
#endif

/*shr_r and L_shr_r are not macros but inlined functions instead when defined	*/
/*the macro implementation causes problems with reentrant code MTWX12460	*/

#define _CW_X_NEW_SHR_R_

/*_____________________
 |                     |
 | Basic types.        |
 |_____________________|
*/

#include <stdint.h>

typedef int8_t Word8;
typedef uint8_t UWord8;
typedef int16_t Word16;
typedef uint16_t UWord16;
typedef int32_t Word32;
typedef uint32_t UWord32;
typedef int32_t Flag;

#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
typedef int64_t Int64;
typedef uint64_t UInt64;
#endif


#define WORD16(x) ( (Word16) ( (Word32) ((x + 1.0)*((float) (1<<15))) - (1<<15))) 
#define WORD32(x) ((Word32)-(x*(1<<31) + 0.5))


#ifdef BIG_ENDIAN
typedef struct Word40 {
        UWord32 body;
        int8_t gap[3];    /* Needed because of extension layout in memory */
        int8_t ext;
} Word40;

typedef struct UWord40 {
        UWord32 body;
        uint8_t gap[3];    /* Needed because of extension layout in memory */
        uint8_t ext;
} UWord40;
#else
typedef struct Word40 {
        UWord32 body;
        int8_t ext;
} Word40;

typedef struct UWord40 {
        UWord32 body;
        uint8_t ext;
} UWord40;
#endif

#ifdef _ENTERPRISE_C_
typedef struct Word64 {
    Word32  msb;
    UWord32 lsb;
} __attribute__((aligned(8))) Word64;
#else
typedef struct Word64 {
    Word32  msb;
    UWord32 lsb;
} Word64;
#pragma align Word64 8
#endif

typedef Word64 Complex32;

#define creal32(c)		((c).msb)
#define cimag32(c)		((Word32)((c).lsb))

/* Vector Support Types */

typedef int32_t Vector_Type32;					/*32-bits vector variable*/
typedef Vector_Type32 Complex16;			/* 32-bit complex fractional  (2x16)*/
typedef int8_t Vector_Component8;		/*8-bits vector component*/
typedef int16_t Vector_Component16;			/*16-bits vector component*/
typedef uint8_t Vector_ComponentU8;	/*8-bits unsigned vector component*/
typedef uint16_t Vector_ComponentU16;	/*16-bits unsigned vector component*/

typedef Word40 Vector_Type40;				/*40-bits vector variable*/
typedef int32_t Vector_Component20;				/*20-bits vector component*/
typedef Vector_Type40 Complex20;			/*20-bit complex vector*/



/* End Vector Support */

/*___________________________________________________________________________
 |                                                                           |
 |   Constants and Globals                                                   |
 |___________________________________________________________________________|
*/

#ifdef _SC3900_
/* Set Rounding Mode */ 
static inline asm void __set2crm(void) 
{
asm_header
asm_body
   bmseta #$0008,sr.l
asm_end
}

static inline asm void __setcnvrm(void) 
{
asm_header
asm_body
 bmclra #$0008,sr.l
asm_end
}

/*scaling off*/
static inline asm void __setscoff(void) 
{
asm_header
asm_body
 bmclra #$0130,sr.l
asm_end
}

/*scaling up 1 bit*/
static inline asm void __setscup1(void) 
{
asm_header
asm_body
 bmclra #$0130,sr.l
 bmseta #$0020,sr.l
asm_end
}

/*scaling down 1 bit*/
static inline asm void __setscdown1(void) 
{
asm_header
asm_body
 bmclra #$0130,sr.l
 bmseta #$0010,sr.l
asm_end
}

/*scaling down 2 bits*/
static inline asm void __setscdown2(void) 
{
asm_header
asm_body
 bmclra #$0130,sr.l
 bmseta #$0030,sr.l
asm_end
}

/*scaling down 3 bits*/
static inline asm void __setscdown3(void) 
{
asm_header
asm_body
 bmclra #$0130,sr.l
 bmseta #$0100,sr.l
asm_end
}
#endif

#define MAX_32			(Word32)0x7fffffffL
#define MIN_32			(Word32)0x80000000L
#define MAX_16			(Word16)0x7fff
#define MIN_16			(Word16)0x8000
#define X_MAX_32 		(Word40)X_set(0x00L, 0x7fffffffL)
#define X_MIN_32 		(Word40)X_set(0xFFL, 0x80000000L)
#define V_X_MAX_16 		(Word40)X_set(0x00L, 0x7FFF7FFFL)
#define V_X_MIN_16 		(Word40)X_set(0xFFL, 0x80008000L)
/* Builtin vector typedefs for packed moves */
#ifndef USE_CW_VECTOR_LOAD_STORE
#define USE_CW_VECTOR_LOAD_STORE	1
#endif
#if __FSOPT__ && USE_CW_VECTOR_LOAD_STORE
	typedef __vectype__<Word8, 2>     __vec_2b;
	typedef __vectype__<Word8, 4>     __vec_4b;
	typedef __vectype__<Word8, 8>     __vec_8b;
	typedef __vectype__<Word8, 16>    __vec_16b;
	typedef __vectype__<UWord8, 2>    __vec_2ub;
	typedef __vectype__<UWord8, 4>    __vec_4ub;
	typedef __vectype__<UWord8, 8>    __vec_8ub;
	typedef __vectype__<UWord8, 16>   __vec_16ub;
	typedef __vectype__<Word16, 2>    __vec_2w;
	typedef __vectype__<Word16, 4>    __vec_4w;
	typedef __vectype__<Word16, 8>    __vec_8w;
	typedef __vectype__<Word16, 16>   __vec_16w;
	typedef __vectype__<UWord16, 2>   __vec_2uw;
	typedef __vectype__<UWord16, 4>   __vec_4uw;
	typedef __vectype__<UWord16, 8>   __vec_8uw;
	typedef __vectype__<Word32, 2>    __vec_2l;
	typedef __vectype__<Word32, 4>    __vec_4l;
	typedef __vectype__<Word32, 8>    __vec_8l;
	typedef __vectype__<Word32, 16>   __vec_16l;
	typedef __vectype__<UWord32, 2>   __vec_2ul;
	typedef __vectype__<UWord32, 4>   __vec_4ul;
	typedef __vectype__<UWord32, 8>   __vec_8ul;
#else
	#undef USE_CW_VECTOR_LOAD_STORE
	#define USE_CW_VECTOR_LOAD_STORE 0
#endif

PROTOTYPE_API Word40 __x_set(Word32 val1, UWord32 val2);
PROTOTYPE_API UWord40 __ux_set(UWord32 val1, UWord32 val2);
PROTOTYPE_API Word32 __x_guard(Word40 val);
PROTOTYPE_API UWord32 __ux_guard(UWord40 val);
PROTOTYPE_API Word32 __x_to_l(Word40 val);
PROTOTYPE_API UWord32 __x_to_ul(Word40 val);
PROTOTYPE_API UWord32 __ux_to_ul(UWord40 val);
PROTOTYPE_API Word40 __l_to_x(Word32 val);
PROTOTYPE_API Word32 __Db_get_msb(double val);
PROTOTYPE_API UWord32 __Db_get_lsb(double val);
PROTOTYPE_API Word16 __l_get_lsb(Word32 val);
PROTOTYPE_API Word32 __l_put_lsb(Word16 val);
PROTOTYPE_API Word16 __l_get_msb(Word32 val);
PROTOTYPE_API Word32 __l_put_msb(Word16 val);
PROTOTYPE_API UWord40 __x_to_ux(Word40 val);
PROTOTYPE_API Word40 __ux_to_x(UWord40 val);
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Word32 __LL_get_msb(Int64 val);
PROTOTYPE_API UWord32 __LL_get_lsb(Int64 val);
PROTOTYPE_API long long __Lli_set(Word32 val1, UWord32 val2);
PROTOTYPE_API double __Db_set(Word32 val1, UWord32 val2);
#endif

#define cw_assert(val) __cw_assert(val)
PROTOTYPE_API void __writeSR2( int val);
PROTOTYPE_API int __readSR2( void);
PROTOTYPE_API void cw_assert( int);

	/*ID:    1, INST: abs.l Da,Dn*/
PROTOTYPE_API Word32 __abs_l(Word32 __Da);

	/*ID:    2, INST: abs.2t Da,Dn*/
PROTOTYPE_API Word40 __abs_2t(Word40 __Da);

	/*ID:    3, INST: abs.4t Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __abs_4t_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __abs_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __abs_4t_dup(__Da);
	*__Dn =  __abs_4t_dup(__Db);
}
#else 
PROTOTYPE_API void __abs_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:    4, INST: abs.2w Da,Dn*/
PROTOTYPE_API Word32 __abs_2w(Word32 __Da);

	/*ID:    5, INST: abs.4w Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __abs_4w_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __abs_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __abs_4w_dup(__Da);
	*__Dn =  __abs_4w_dup(__Db);
}
#else 
PROTOTYPE_API void __abs_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:    6, INST: abs.x Da,Dn*/
PROTOTYPE_API Word40 __abs_x(Word40 __Da);

	/*ID:    7, INST: abs.2x Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __abs_2x_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __abs_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __abs_2x_dup(__Da);
	*__Dn =  __abs_2x_dup(__Db);
}
#else 
PROTOTYPE_API void __abs_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:    8, INST: abs.leg.x Da,Dn*/

	/*ID:    9, INST: abs.s.l Da,Dn*/
PROTOTYPE_API Word32 __abs_s_l(Word32 __Da);

	/*ID:   10, INST: abs.s.2w Da,Dn*/
PROTOTYPE_API Word32 __abs_s_2w(Word32 __Da);

	/*ID:   11, INST: abs.s.4w Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __abs_s_4w_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __abs_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __abs_s_4w_dup(__Da);
	*__Dn =  __abs_s_4w_dup(__Db);
}
#else 
PROTOTYPE_API void __abs_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:   12, INST: abs.s.x Da,Dn*/
PROTOTYPE_API Word40 __abs_s_x(Word40 __Da);

	/*ID:   13, INST: abs.s.2x Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __abs_s_2x_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __abs_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __abs_s_2x_dup(__Da);
	*__Dn =  __abs_s_2x_dup(__Db);
}
#else 
PROTOTYPE_API void __abs_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:   14, INST: abs.s40.x Da,Dn*/
PROTOTYPE_API Word40 __abs_s40_x(Word40 __Da);

	/*ID:   15, INST: absa Ra,Rn*/
PROTOTYPE_API Word32 __absa(Word32 __Ra);

	/*ID:   16, INST: absa Ra,Rn*/

	/*ID:   17, INST: acator #u6_t4*/

	/*ID:   18, INST: acator.p #u6_t4,#u4_t6*/

	/*ID:   19, INST: acs.h.2w Da.h,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_h_2w_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_h_2w_hh_aux(__acs_h_2w_hh_read(__acs_h_2w_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   20, INST: acs.h.2w Da.l,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_h_2w_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_h_2w_ll_aux(__acs_h_2w_ll_read(__acs_h_2w_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   21, INST: acs.h.2w Da.h,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_h_2w_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_h_2w_hl_aux(__acs_h_2w_hl_read(__acs_h_2w_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   22, INST: acs.h.2w Da.l,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_h_2w_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_h_2w_lh_aux(__acs_h_2w_lh_read(__acs_h_2w_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   23, INST: acs.h.2w -Da.h,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_ss_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_ss_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_ss_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_h_2w_ss_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_h_2w_ss_hh_aux(__acs_h_2w_ss_hh_read(__acs_h_2w_ss_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_ss_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   24, INST: acs.h.2w -Da.h,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_sa_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_sa_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_sa_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_h_2w_sa_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_h_2w_sa_hh_aux(__acs_h_2w_sa_hh_read(__acs_h_2w_sa_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_sa_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   25, INST: acs.h.2w Da.h,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_as_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_as_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_as_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_h_2w_as_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_h_2w_as_hh_aux(__acs_h_2w_as_hh_read(__acs_h_2w_as_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_as_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   26, INST: acs.h.2w -Da.l,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_ss_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_ss_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_ss_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_h_2w_ss_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_h_2w_ss_ll_aux(__acs_h_2w_ss_ll_read(__acs_h_2w_ss_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_ss_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   27, INST: acs.h.2w -Da.l,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_sa_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_sa_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_sa_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_h_2w_sa_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_h_2w_sa_ll_aux(__acs_h_2w_sa_ll_read(__acs_h_2w_sa_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_sa_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   28, INST: acs.h.2w Da.l,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_as_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_as_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_as_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_h_2w_as_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_h_2w_as_ll_aux(__acs_h_2w_as_ll_read(__acs_h_2w_as_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_as_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   29, INST: acs.h.2w -Da.h,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_ss_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_ss_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_ss_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_h_2w_ss_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_h_2w_ss_hl_aux(__acs_h_2w_ss_hl_read(__acs_h_2w_ss_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_ss_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   30, INST: acs.h.2w -Da.h,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_sa_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_sa_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_sa_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_h_2w_sa_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_h_2w_sa_hl_aux(__acs_h_2w_sa_hl_read(__acs_h_2w_sa_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_sa_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   31, INST: acs.h.2w -Da.l,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_ss_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_ss_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_ss_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_h_2w_ss_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_h_2w_ss_lh_aux(__acs_h_2w_ss_lh_read(__acs_h_2w_ss_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_ss_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   32, INST: acs.h.2w -Da.l,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_sa_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_sa_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_sa_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_h_2w_sa_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_h_2w_sa_lh_aux(__acs_h_2w_sa_lh_read(__acs_h_2w_sa_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_sa_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   33, INST: acs.h.2w Da.h,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_as_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_h_2w_as_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_as_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_h_2w_as_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_h_2w_as_hl_aux(__acs_h_2w_as_hl_read(__acs_h_2w_as_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_as_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   34, INST: acs.h.2w Da.l,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_h_2w_as_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_h_2w_as_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_h_2w_as_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_h_2w_as_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_h_2w_as_lh_aux(__acs_h_2w_as_lh_read(__acs_h_2w_as_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_h_2w_as_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   35, INST: acs.l.2w Da.h,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_l_2w_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_l_2w_hh_aux(__acs_l_2w_hh_read(__acs_l_2w_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   36, INST: acs.l.2w Da.l,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_l_2w_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_l_2w_ll_aux(__acs_l_2w_ll_read(__acs_l_2w_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   37, INST: acs.l.2w Da.h,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_l_2w_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_l_2w_hl_aux(__acs_l_2w_hl_read(__acs_l_2w_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   38, INST: acs.l.2w Da.l,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_l_2w_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_l_2w_lh_aux(__acs_l_2w_lh_read(__acs_l_2w_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   39, INST: acs.l.2w -Da.h,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_ss_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_ss_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_ss_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_l_2w_ss_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_l_2w_ss_hh_aux(__acs_l_2w_ss_hh_read(__acs_l_2w_ss_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_ss_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   40, INST: acs.l.2w -Da.h,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_sa_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_sa_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_sa_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_l_2w_sa_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_l_2w_sa_hh_aux(__acs_l_2w_sa_hh_read(__acs_l_2w_sa_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_sa_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   41, INST: acs.l.2w Da.h,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_as_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_as_hh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_as_hh_read(Word32 __Da_h, Word32 __Da_h_2);
#define __acs_l_2w_as_hh(__Dn, __Da_h, __Da_h_2, __Db) __acs_l_2w_as_hh_aux(__acs_l_2w_as_hh_read(__acs_l_2w_as_hh_read(__Da_h, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_as_hh(Word32 __Dn, Word32 __Da_h, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   42, INST: acs.l.2w -Da.l,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_ss_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_ss_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_ss_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_l_2w_ss_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_l_2w_ss_ll_aux(__acs_l_2w_ss_ll_read(__acs_l_2w_ss_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_ss_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   43, INST: acs.l.2w -Da.l,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_sa_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_sa_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_sa_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_l_2w_sa_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_l_2w_sa_ll_aux(__acs_l_2w_sa_ll_read(__acs_l_2w_sa_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_sa_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   44, INST: acs.l.2w Da.l,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_as_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_as_ll_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_as_ll_read(Word32 __Da_l, Word32 __Da_l_2);
#define __acs_l_2w_as_ll(__Dn, __Da_l, __Da_l_2, __Db) __acs_l_2w_as_ll_aux(__acs_l_2w_as_ll_read(__acs_l_2w_as_ll_read(__Da_l, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_as_ll(Word32 __Dn, Word32 __Da_l, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   45, INST: acs.l.2w -Da.h,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_ss_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_ss_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_ss_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_l_2w_ss_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_l_2w_ss_hl_aux(__acs_l_2w_ss_hl_read(__acs_l_2w_ss_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_ss_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   46, INST: acs.l.2w -Da.h,Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_sa_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_sa_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_sa_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_l_2w_sa_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_l_2w_sa_hl_aux(__acs_l_2w_sa_hl_read(__acs_l_2w_sa_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_sa_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   47, INST: acs.l.2w -Da.l,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_ss_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_ss_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_ss_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_l_2w_ss_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_l_2w_ss_lh_aux(__acs_l_2w_ss_lh_read(__acs_l_2w_ss_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_ss_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   48, INST: acs.l.2w -Da.l,Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_sa_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_sa_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_sa_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_l_2w_sa_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_l_2w_sa_lh_aux(__acs_l_2w_sa_lh_read(__acs_l_2w_sa_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_sa_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   49, INST: acs.l.2w Da.h,-Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_as_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
Word32 __acs_l_2w_as_hl_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_as_hl_read(Word32 __Da_h, Word32 __Da_l_2);
#define __acs_l_2w_as_hl(__Dn, __Da_h, __Da_l_2, __Db) __acs_l_2w_as_hl_aux(__acs_l_2w_as_hl_read(__acs_l_2w_as_hl_read(__Da_h, __Da_l_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_as_hl(Word32 __Dn, Word32 __Da_h, Word32 __Da_l_2, Word32 __Db);
#endif 

	/*ID:   50, INST: acs.l.2w Da.l,-Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __acs_l_2w_as_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
Word32 __acs_l_2w_as_lh_aux(Word32 __Dres, Word32 __Dn);
Word32 __acs_l_2w_as_lh_read(Word32 __Da_l, Word32 __Da_h_2);
#define __acs_l_2w_as_lh(__Dn, __Da_l, __Da_h_2, __Db) __acs_l_2w_as_lh_aux(__acs_l_2w_as_lh_read(__acs_l_2w_as_lh_read(__Da_l, __Da_h_2), __Db), __Dn)
#else 
PROTOTYPE_API Word32 __acs_l_2w_as_lh(Word32 __Dn, Word32 __Da_l, Word32 __Da_h_2, Word32 __Db);
#endif 

	/*ID:   51, INST: add.ll Dab,Dcd,Dmn*/

	/*ID:   52, INST: add.t Da.h,Dn.h*/
PROTOTYPE_API Word40 __add_t_hh(Word40 __Dn_h, Word40 __Da_h);

	/*ID:   53, INST: add.t Da.l,Dn.l*/
PROTOTYPE_API Word40 __add_t_ll(Word40 __Dn_l, Word40 __Da_l);

	/*ID:   54, INST: add.t Da.h,Dn.l*/
PROTOTYPE_API Word40 __add_t_hl(Word40 __Dn_l, Word40 __Da_h);

	/*ID:   55, INST: add.t Da.l,Dn.h*/
PROTOTYPE_API Word40 __add_t_lh(Word40 __Dn_h, Word40 __Da_l);

	/*ID:   56, INST: add.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __add_2t(Word40 __Da, Word40 __Db);

	/*ID:   57, INST: add.x #u5,Da,Dn*/
PROTOTYPE_API Word40 __add_x_imm(UWord32 __imm1, Word40 __Da);

	/*ID:   58, INST: add.x Da,Db,Dn*/
PROTOTYPE_API Word40 __add_x(Word40 __Da, Word40 __Db);

	/*ID:   59, INST: add.leg.x #u5,Da,Dn*/

	/*ID:   60, INST: add.leg.x Da,Db,Dn*/

	/*ID:   61, INST: add.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __add_s_x(Word40 __Da, Word40 __Db);

	/*ID:   62, INST: adda #s16_t7,Ra,Rn*/

	/*ID:   63, INST: adda #u5,Ra,Rn*/

	/*ID:   64, INST: adda Ra,Rb,Rn*/

	/*ID:   65, INST: adda.lin #s16,Ra,Rn*/
PROTOTYPE_API Word32 __adda_lin(Word32 __imm1, Word32 __Ra);

	/*ID:   66, INST: adda.lin #s16_t7,Ra,Rn*/

	/*ID:   67, INST: adda.lin #s9,sp,Rn*/

	/*ID:   68, INST: adda.lin #s9,sp,Rn*/

	/*ID:   69, INST: adda.lin #s9_3,sp*/

	/*ID:   70, INST: adda.lin #u5,Ra,Rn*/

	/*ID:   71, INST: adda.lin #u5,Ra,Rn*/

	/*ID:   72, INST: adda.lin Ra,Rb,Rn*/

	/*ID:   73, INST: adda.lin Ra,Rb,Rn*/

	/*ID:   74, INST: addc.ro.x Da,Db,Dn*/

	/*ID:   75, INST: addc.rw.leg.l Da,Db,Dn*/

	/*ID:   76, INST: addc.wo.l #u5,Da,Dn*/

	/*ID:   77, INST: addc.wo.l Da,Db,Dn*/

	/*ID:   78, INST: addc.wo.x #u5,Da,Dn*/

	/*ID:   79, INST: addc.wo.x Da,Db,Dn*/

	/*ID:   80, INST: addc.wo.leg.x #u5,Da,Dn*/

	/*ID:   81, INST: addc.wo.leg.x Da,Db,Dn*/

	/*ID:   82, INST: addla.2 Ra,Rb,Rn*/

	/*ID:   83, INST: addla.4 Ra,Rb,Rn*/

	/*ID:   84, INST: addla.1 Ra,Rb,Rn*/

	/*ID:   85, INST: addla.3 Ra,Rb,Rn*/

	/*ID:   86, INST: addla.5 Ra,Rb,Rn*/

	/*ID:   87, INST: addla.6 Ra,Rb,Rn*/

	/*ID:   88, INST: addla.1.lin Ra,Rb,Rn*/
PROTOTYPE_API Word32 __addla_1_lin(Word32 __Ra, Word32 __Rb);

	/*ID:   89, INST: addla.1.lin Ra,Rb,Rn*/

	/*ID:   90, INST: addla.2.lin Ra,Rb,Rn*/
PROTOTYPE_API Word32 __addla_2_lin(Word32 __Ra, Word32 __Rb);

	/*ID:   91, INST: addla.2.lin Ra,Rb,Rn*/

	/*ID:   92, INST: addla.3.lin Ra,Rb,Rn*/
PROTOTYPE_API Word32 __addla_3_lin(Word32 __Ra, Word32 __Rb);

	/*ID:   93, INST: addla.3.lin Ra,Rb,Rn*/

	/*ID:   94, INST: addla.4.lin Ra,Rb,Rn*/
PROTOTYPE_API Word32 __addla_4_lin(Word32 __Ra, Word32 __Rb);

	/*ID:   95, INST: addla.4.lin Ra,Rb,Rn*/

	/*ID:   96, INST: addla.5.lin Ra,Rb,Rn*/
PROTOTYPE_API Word32 __addla_5_lin(Word32 __Ra, Word32 __Rb);

	/*ID:   97, INST: addla.5.lin Ra,Rb,Rn*/

	/*ID:   98, INST: addla.6.lin Ra,Rb,Rn*/
PROTOTYPE_API Word32 __addla_6_lin(Word32 __Ra, Word32 __Rb);

	/*ID:   99, INST: addla.6.lin Ra,Rb,Rn*/

	/*ID:  100, INST: addm.x Da.h,Db,Dn*/
PROTOTYPE_API Word40 __addm_x_h(Word32 __Da_h, Word40 __Db);

	/*ID:  101, INST: addm.x Da.l,Db,Dn*/
PROTOTYPE_API Word40 __addm_x_l(Word32 __Da_l, Word40 __Db);

	/*ID:  102, INST: addm.hl.x Da,Db,Dn*/
PROTOTYPE_API Word40 __addm_hl_x(Word32 __Da, Word40 __Db);

	/*ID:  103, INST: addm.hl.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __addm_hl_2x_dup(Word32 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __addm_hl_2x(Word32 __Da, Word32 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __addm_hl_2x_dup(__Da, __Dc);
	*__Dn =  __addm_hl_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __addm_hl_2x(Word32 __Da, Word32 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  104, INST: aextc.lft Da,Db*/

	/*ID:  105, INST: aextc.rgt Da,Db*/

	/*ID:  106, INST: and.l #u32,Da,Dn*/

	/*ID:  107, INST: and.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __and_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  108, INST: and.x Da,Db,Dn*/
PROTOTYPE_API Word40 __and_x(Word40 __Da, Word40 __Db);

	/*ID:  109, INST: and.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __and_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __and_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __and_2x_dup(__Da, __Dc);
	*__Dn =  __and_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __and_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  110, INST: anda Ra,Rb,Rn*/

	/*ID:  111, INST: anda Ra,Rb,Rn*/

	/*ID:  112, INST: ash.lft.l Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_lft_l(Word32 __Da, Word32 __Db);

	/*ID:  113, INST: ash.lft.l #u5,Da,Dn*/

	/*ID:  114, INST: ash.lft.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_lft_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_lft_2l_dup(__Da, __Dc);
	*__Dn =  __ash_lft_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  115, INST: ash.lft.2l #u5,Dab,Dmn*/

	/*ID:  116, INST: ash.lft.ll Da,Dcd,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __ash_lft_ll(Word32 __Da, Int64 __Dcd);
#endif

	/*ID:  117, INST: ash.lft.ll #u6_t3,Dab,Dmn*/

	/*ID:  118, INST: ash.lft.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_lft_2t(Word32 __Da, Word40 __Db);

	/*ID:  119, INST: ash.lft.2t #u5,Da,Dn*/

	/*ID:  120, INST: ash.lft.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_lft_4t_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_lft_4t_dup(__Da, __Dc);
	*__Dn =  __ash_lft_4t_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  121, INST: ash.lft.4t #u5,Dab,Dmn*/

	/*ID:  122, INST: ash.lft.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_lft_2w(Word32 __Da, Word32 __Db);

	/*ID:  123, INST: ash.lft.2w #u5,Da,Dn*/

	/*ID:  124, INST: ash.lft.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_lft_4w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_lft_4w_dup(__Da, __Dc);
	*__Dn =  __ash_lft_4w_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  125, INST: ash.lft.4w #u4,Dab,Dmn*/

	/*ID:  126, INST: ash.lft.x Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_lft_x(Word32 __Da, Word40 __Db);

	/*ID:  127, INST: ash.lft.x #ue5,Da,Dn*/

	/*ID:  128, INST: ash.lft.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_lft_2x_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_lft_2x_dup(__Da, __Dc);
	*__Dn =  __ash_lft_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  129, INST: ash.lft.2x #ue5,Dab,Dmn*/

	/*ID:  130, INST: ash.lft.leg.x Da,Db,Dn*/

	/*ID:  131, INST: ash.lft.leg.x #u5,Da,Dn*/

	/*ID:  132, INST: ash.lft.s.l Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_lft_s_l(Word32 __Da, Word32 __Db);

	/*ID:  133, INST: ash.lft.s.l #u5,Da,Dn*/

	/*ID:  134, INST: ash.lft.s.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_lft_s_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_s_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_lft_s_2l_dup(__Da, __Dc);
	*__Dn =  __ash_lft_s_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_s_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  135, INST: ash.lft.s.2l #u5,Dab,Dmn*/

	/*ID:  136, INST: ash.lft.s.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_lft_s_2t(Word32 __Da, Word40 __Db);

	/*ID:  137, INST: ash.lft.s.2t #u5,Da,Dn*/

	/*ID:  138, INST: ash.lft.s.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_lft_s_4t_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_s_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_lft_s_4t_dup(__Da, __Dc);
	*__Dn =  __ash_lft_s_4t_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_s_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  139, INST: ash.lft.s.4t #u5,Dab,Dmn*/

	/*ID:  140, INST: ash.lft.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_lft_s_2w(Word32 __Da, Word32 __Db);

	/*ID:  141, INST: ash.lft.s.2w #u5,Da,Dn*/

	/*ID:  142, INST: ash.lft.s.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_lft_s_4w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_s_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_lft_s_4w_dup(__Da, __Dc);
	*__Dn =  __ash_lft_s_4w_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_s_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  143, INST: ash.lft.s.4w #u4,Dab,Dmn*/

	/*ID:  144, INST: ash.lft.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_lft_s_x(Word32 __Da, Word40 __Db);

	/*ID:  145, INST: ash.lft.s.x #ue5,Da,Dn*/

	/*ID:  146, INST: ash.lft.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_lft_s_2x_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_s_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_lft_s_2x_dup(__Da, __Dc);
	*__Dn =  __ash_lft_s_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_s_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  147, INST: ash.lft.s.2x #ue5,Dab,Dmn*/

	/*ID:  148, INST: ash.lft.s20.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_lft_s20_2t(Word32 __Da, Word40 __Db);

	/*ID:  149, INST: ash.lft.s20.2t #u5,Da,Dn*/

	/*ID:  150, INST: ash.lft.s20.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_lft_s20_4t_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_lft_s20_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_lft_s20_4t_dup(__Da, __Dc);
	*__Dn =  __ash_lft_s20_4t_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_lft_s20_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  151, INST: ash.lft.s20.4t #u5,Dab,Dmn*/

	/*ID:  152, INST: ash.rgt.l Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_rgt_l(Word32 __Da, Word32 __Db);

	/*ID:  153, INST: ash.rgt.l #u5,Da,Dn*/

	/*ID:  154, INST: ash.rgt.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_rgt_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_rgt_2l_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  155, INST: ash.rgt.2l #u5,Dab,Dmn*/

	/*ID:  156, INST: ash.rgt.ll Da,Dcd,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __ash_rgt_ll(Word32 __Da, Int64 __Dcd);
#endif

	/*ID:  157, INST: ash.rgt.ll #u6_t3,Dab,Dmn*/

	/*ID:  158, INST: ash.rgt.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_rgt_2t(Word32 __Da, Word40 __Db);

	/*ID:  159, INST: ash.rgt.2t #u5,Da,Dn*/

	/*ID:  160, INST: ash.rgt.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_rgt_4t_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_rgt_4t_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_4t_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  161, INST: ash.rgt.4t #u5,Dab,Dmn*/

	/*ID:  162, INST: ash.rgt.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_rgt_2w(Word32 __Da, Word32 __Db);

	/*ID:  163, INST: ash.rgt.2w #u5,Da,Dn*/

	/*ID:  164, INST: ash.rgt.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_rgt_4w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_rgt_4w_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_4w_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  165, INST: ash.rgt.4w #u4,Dab,Dmn*/

	/*ID:  166, INST: ash.rgt.x Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_rgt_x(Word32 __Da, Word40 __Db);

	/*ID:  167, INST: ash.rgt.x #ue5,Da,Dn*/

	/*ID:  168, INST: ash.rgt.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_rgt_2x_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_rgt_2x_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  169, INST: ash.rgt.2x #ue5,Dab,Dmn*/

	/*ID:  170, INST: ash.rgt.leg.x Da,Db,Dn*/

	/*ID:  171, INST: ash.rgt.leg.x #u5,Da,Dn*/

	/*ID:  172, INST: ash.rgt.s.l Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_rgt_s_l(Word32 __Da, Word32 __Db);

	/*ID:  173, INST: ash.rgt.s.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_rgt_s_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_s_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_rgt_s_2l_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_s_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_s_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  174, INST: ash.rgt.s.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_rgt_s_2t(Word32 __Da, Word40 __Db);

	/*ID:  175, INST: ash.rgt.s.2t #u5,Da,Dn*/

	/*ID:  176, INST: ash.rgt.s.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_rgt_s_4t_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_s_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_rgt_s_4t_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_s_4t_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_s_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  177, INST: ash.rgt.s.4t #u5,Dab,Dmn*/

	/*ID:  178, INST: ash.rgt.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __ash_rgt_s_2w(Word32 __Da, Word32 __Db);

	/*ID:  179, INST: ash.rgt.s.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __ash_rgt_s_4w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_s_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __ash_rgt_s_4w_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_s_4w_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_s_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  180, INST: ash.rgt.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_rgt_s_x(Word32 __Da, Word40 __Db);

	/*ID:  181, INST: ash.rgt.s.x #ue5,Da,Dn*/

	/*ID:  182, INST: ash.rgt.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_rgt_s_2x_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_s_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_rgt_s_2x_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_s_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_s_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  183, INST: ash.rgt.s.2x #ue5,Dab,Dmn*/

	/*ID:  184, INST: ash.rgt.s20.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __ash_rgt_s20_2t(Word32 __Da, Word40 __Db);

	/*ID:  185, INST: ash.rgt.s20.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __ash_rgt_s20_4t_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __ash_rgt_s20_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __ash_rgt_s20_4t_dup(__Da, __Dc);
	*__Dn =  __ash_rgt_s20_4t_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __ash_rgt_s20_4t(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  186, INST: asha.lft Ra,Rb,Rn*/
PROTOTYPE_API Word32 __asha_lft(Word32 __Ra, Word32 __Rb);

	/*ID:  187, INST: asha.lft #u5,Ra,Rn*/

	/*ID:  188, INST: asha.lft #u5,Ra,Rn*/

	/*ID:  189, INST: asha.rgt Ra,Rb,Rn*/
PROTOTYPE_API Word32 __asha_rgt(Word32 __Ra, Word32 __Rb);

	/*ID:  190, INST: asha.rgt #u5,Ra,Rn*/

	/*ID:  191, INST: asha.rgt #u5,Ra,Rn*/

	/*ID:  192, INST: avg.u.4b Da,Db,Dn*/
PROTOTYPE_API UWord32 __avg_u_4b(UWord32 __Da, UWord32 __Db);

	/*ID:  193, INST: bccas Ra*/
PROTOTYPE_API void __bccas(Word32 __Ra);

	/*ID:  194, INST: bit.colpsh.b Dab,Dn.hh*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_b_hh(Word32 __Dn_hh, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_b_hh(Word32 __Dn_hh, Int64 __Dab);
#endif 

	/*ID:  195, INST: bit.colpsh.b Dab,Dn.hl*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_b_hl(Word32 __Dn_hl, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_b_hl(Word32 __Dn_hl, Int64 __Dab);
#endif 

	/*ID:  196, INST: bit.colpsh.b Dab,Dn.lh*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_b_lh(Word32 __Dn_lh, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_b_lh(Word32 __Dn_lh, Int64 __Dab);
#endif 

	/*ID:  197, INST: bit.colpsh.b Dab,Dn.ll*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_b_ll(Word32 __Dn_ll, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_b_ll(Word32 __Dn_ll, Int64 __Dab);
#endif 

	/*ID:  198, INST: bit.colpsh.rev.b Dab,Dn.hh*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_rev_b_hh(Word32 __Dn_hh, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_rev_b_hh(Word32 __Dn_hh, Int64 __Dab);
#endif 

	/*ID:  199, INST: bit.colpsh.rev.b Dab,Dn.hl*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_rev_b_hl(Word32 __Dn_hl, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_rev_b_hl(Word32 __Dn_hl, Int64 __Dab);
#endif 

	/*ID:  200, INST: bit.colpsh.rev.b Dab,Dn.lh*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_rev_b_lh(Word32 __Dn_lh, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_rev_b_lh(Word32 __Dn_lh, Int64 __Dab);
#endif 

	/*ID:  201, INST: bit.colpsh.rev.b Dab,Dn.ll*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_rev_b_ll(Word32 __Dn_ll, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_rev_b_ll(Word32 __Dn_ll, Int64 __Dab);
#endif 

	/*ID:  202, INST: bit.colpsh.sh.w Da,Dn*/
PROTOTYPE_API Word32 __bit_colpsh_sh_w_da(Word32 __Dn, Word32 __Da);

	/*ID:  203, INST: bit.colpsh.sh.w Dab,Dn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsh_sh_w(Word32 __Dn, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsh_sh_w(Word32 __Dn, Int64 __Dab);
#endif 

	/*ID:  204, INST: bit.colpsl.b Dab,Dn.ll*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsl_b(Word32 __Dn_ll, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsl_b(Word32 __Dn_ll, Int64 __Dab);
#endif 

	/*ID:  205, INST: bit.colpsl.rev.b Dab,Dn.ll*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word32 __bit_colpsl_rev_b(Word32 __Dn_ll, Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word32 __bit_colpsl_rev_b(Word32 __Dn_ll, Int64 __Dab);
#endif 

	/*ID:  206, INST: bit.dintlv2bi.l Da,Dn*/
PROTOTYPE_API Word32 __bit_dintlv2bi_l(Word32 __Da);

	/*ID:  207, INST: bit.dintlv2bi.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __bit_dintlv2bi_2l_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __bit_dintlv2bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __bit_dintlv2bi_2l_dup(__Da);
	*__Dn =  __bit_dintlv2bi_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __bit_dintlv2bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  208, INST: bit.dintlv3bi.l Da,Dn*/
PROTOTYPE_API Word32 __bit_dintlv3bi_l(Word32 __Da);

	/*ID:  209, INST: bit.dintlv3bi.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __bit_dintlv3bi_2l_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __bit_dintlv3bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __bit_dintlv3bi_2l_dup(__Da);
	*__Dn =  __bit_dintlv3bi_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __bit_dintlv3bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  210, INST: bit.dintlv3bi.rev.l Da,Dn*/
PROTOTYPE_API Word32 __bit_dintlv3bi_rev_l(Word32 __Da);

	/*ID:  211, INST: bit.dintlv3bi.rev.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __bit_dintlv3bi_rev_2l_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __bit_dintlv3bi_rev_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __bit_dintlv3bi_rev_2l_dup(__Da);
	*__Dn =  __bit_dintlv3bi_rev_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __bit_dintlv3bi_rev_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  212, INST: bit.expnd.8b Da.hh,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_8b_hh(Word32 __Da_hh);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_8b_hh(Word32 __Da_hh);
#endif 

	/*ID:  213, INST: bit.expnd.8b Da.hl,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_8b_hl(Word32 __Da_hl);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_8b_hl(Word32 __Da_hl);
#endif 

	/*ID:  214, INST: bit.expnd.8b Da.lh,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_8b_lh(Word32 __Da_lh);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_8b_lh(Word32 __Da_lh);
#endif 

	/*ID:  215, INST: bit.expnd.8b Da.ll,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_8b_ll(Word32 __Da_ll);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_8b_ll(Word32 __Da_ll);
#endif 

	/*ID:  216, INST: bit.expnd.2w Da,Dn*/
PROTOTYPE_API Word32 __bit_expnd_2w(Word32 __Da);

	/*ID:  217, INST: bit.expnd.4w Da,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_4w(Word32 __Da);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_4w(Word32 __Da);
#endif 

	/*ID:  218, INST: bit.expnd.rev.8b Da.hh,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_rev_8b_hh(Word32 __Da_hh);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_rev_8b_hh(Word32 __Da_hh);
#endif 

	/*ID:  219, INST: bit.expnd.rev.8b Da.hl,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_rev_8b_hl(Word32 __Da_hl);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_rev_8b_hl(Word32 __Da_hl);
#endif 

	/*ID:  220, INST: bit.expnd.rev.8b Da.lh,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_rev_8b_lh(Word32 __Da_lh);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_rev_8b_lh(Word32 __Da_lh);
#endif 

	/*ID:  221, INST: bit.expnd.rev.8b Da.ll,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __bit_expnd_rev_8b_ll(Word32 __Da_ll);
#endif
#else 
PROTOTYPE_API Int64 __bit_expnd_rev_8b_ll(Word32 __Da_ll);
#endif 

	/*ID:  222, INST: bit.intlv2bi.l Da,Dn*/
PROTOTYPE_API Word32 __bit_intlv2bi_l(Word32 __Da);

	/*ID:  223, INST: bit.intlv2bi.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __bit_intlv2bi_2l_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __bit_intlv2bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __bit_intlv2bi_2l_dup(__Da);
	*__Dn =  __bit_intlv2bi_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __bit_intlv2bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  224, INST: bit.intlv3bi.l Da,Dn*/
PROTOTYPE_API Word32 __bit_intlv3bi_l(Word32 __Da);

	/*ID:  225, INST: bit.intlv3bi.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __bit_intlv3bi_2l_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __bit_intlv3bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __bit_intlv3bi_2l_dup(__Da);
	*__Dn =  __bit_intlv3bi_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __bit_intlv3bi_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  226, INST: bit.intlv3bi.rev.l Da,Dn*/
PROTOTYPE_API Word32 __bit_intlv3bi_rev_l(Word32 __Da);

	/*ID:  227, INST: bit.intlv3bi.rev.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __bit_intlv3bi_rev_2l_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __bit_intlv3bi_rev_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __bit_intlv3bi_rev_2l_dup(__Da);
	*__Dn =  __bit_intlv3bi_rev_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __bit_intlv3bi_rev_2l(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  228, INST: bit.rev.4b Da,Dn*/
PROTOTYPE_API Word32 __bit_rev_4b(Word32 __Da);

	/*ID:  229, INST: bit.rev.l Da,Dn*/
PROTOTYPE_API Word32 __bit_rev_l(Word32 __Da);

	/*ID:  230, INST: bmchga #u16,C4.h*/

	/*ID:  231, INST: bmchga #u16,Rn.h*/
PROTOTYPE_API Word32 __bmchga_h(Word32 __Rn_h, Word32 __imm1);

	/*ID:  232, INST: bmchga #u16,C4.l*/

	/*ID:  233, INST: bmchga #u16,Rn.l*/
PROTOTYPE_API Word32 __bmchga_l(Word32 __Rn_l, Word32 __imm1);

	/*ID:  234, INST: bmclra #u16,C4.h*/

	/*ID:  235, INST: bmclra #u16,Rn.h*/
PROTOTYPE_API Word32 __bmclra_h(Word32 __Rn_h, Word32 __imm1);

	/*ID:  236, INST: bmclra #u16,C4.l*/

	/*ID:  237, INST: bmclra #u16,Rn.l*/
PROTOTYPE_API Word32 __bmclra_l(Word32 __Rn_l, Word32 __imm1);

	/*ID:  238, INST: bmseta #u16,C4.h*/

	/*ID:  239, INST: bmseta #u16,Rn.h*/
PROTOTYPE_API Word32 __bmseta_h(Word32 __Rn_h, Word32 __imm1);

	/*ID:  240, INST: bmseta #u16,C4.l*/

	/*ID:  241, INST: bmseta #u16,Rn.l*/
PROTOTYPE_API Word32 __bmseta_l(Word32 __Rn_l, Word32 __imm1);

	/*ID:  242, INST: bmtsta.c #u16,C4.h,Pmn*/

	/*ID:  243, INST: bmtsta.c #u16,C4.h,Pn*/

	/*ID:  244, INST: bmtsta.c #u16,Ra.h,Pmn*/
PROTOTYPE_API int __bmtsta_c_h(Word32 __imm1, Word32 __Ra_h);

	/*ID:  245, INST: bmtsta.c #u16,Ra.h,Pn*/

	/*ID:  246, INST: bmtsta.c #u16,C4.l,Pmn*/

	/*ID:  247, INST: bmtsta.c #u16,C4.l,Pn*/

	/*ID:  248, INST: bmtsta.c #u16,Ra.l,Pmn*/
PROTOTYPE_API int __bmtsta_c_l(Word32 __imm1, Word32 __Ra_l);

	/*ID:  249, INST: bmtsta.c #u16,Ra.l,Pn*/

	/*ID:  250, INST: bmtsta.s #u16,C4.h,Pmn*/

	/*ID:  251, INST: bmtsta.s #u16,C4.h,Pn*/

	/*ID:  252, INST: bmtsta.s #u16,Ra.h,Pmn*/
PROTOTYPE_API int __bmtsta_s_h(Word32 __imm1, Word32 __Ra_h);

	/*ID:  253, INST: bmtsta.s #u16,Ra.h,Pn*/

	/*ID:  254, INST: bmtsta.s #u16,C4.l,Pmn*/

	/*ID:  255, INST: bmtsta.s #u16,C4.l,Pn*/

	/*ID:  256, INST: bmtsta.s #u16,Ra.l,Pmn*/
PROTOTYPE_API int __bmtsta_s_l(Word32 __imm1, Word32 __Ra_l);

	/*ID:  257, INST: bmtsta.s #u16,Ra.l,Pn*/

	/*ID:  258, INST: bra RelAdd19_t2*/

	/*ID:  259, INST: bra.nobtb RelAdd19_t2*/

	/*ID:  260, INST: break.2 RelAdd19_t1*/

	/*ID:  261, INST: break.1 RelAdd19_t1*/

	/*ID:  262, INST: break.3 RelAdd19_t1*/

	/*ID:  263, INST: break.0 RelAdd19_t1*/

	/*ID:  264, INST: bsr RelAdd19_t2*/

	/*ID:  265, INST: bsr.nobtb RelAdd19_t2*/

	/*ID:  266, INST: cast.t.x Da.h,Dn*/
PROTOTYPE_API Word40 __cast_t_x_h(Word40 __Da_h);

	/*ID:  267, INST: cast.t.x Da.l,Dn*/
PROTOTYPE_API Word40 __cast_t_x_l(Word40 __Da_l);

	/*ID:  268, INST: cast.t.leg.x Da.h,Dn*/

	/*ID:  269, INST: cast.t.leg.x Da.l,Dn*/

	/*ID:  270, INST: cast.x.ll Da,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __cast_x_ll(Word40 __Da);
#endif

	/*ID:  271, INST: ccmd.resm*/
PROTOTYPE_API void __ccmd_resm();

	/*ID:  272, INST: ccmd.susp*/
PROTOTYPE_API void __ccmd_susp();

	/*ID:  273, INST: chcf #u1_t2,SR.RM*/

	/*ID:  274, INST: chcf #u1_t2,SR.SM*/

	/*ID:  275, INST: chcf #u2_t2,SR.SWM2*/

	/*ID:  276, INST: chcf #u2_t2,SR2.ASP*/

	/*ID:  277, INST: chcf #u3_t3,SR.SCM*/

	/*ID:  278, INST: chcf Ra,SR2.ASP*/

	/*ID:  279, INST: chcf Ra,SR2.IPM*/

	/*ID:  280, INST: clb.leg.x Da,Dn*/

	/*ID:  281, INST: clb.lft.x Da,Dn*/
PROTOTYPE_API Word40 __clb_lft_x(Word40 __Da);

	/*ID:  282, INST: clba.lft Ra,Rn*/
PROTOTYPE_API Word32 __clba_lft(Word32 __Ra);

	/*ID:  283, INST: clba.lft Ra,Rn*/

	/*ID:  284, INST: clip.t.u.2b #u5,Da,Dn*/
PROTOTYPE_API UWord32 __clip_t_u_2b(UWord32 __imm1, UWord40 __Da);

	/*ID:  285, INST: clip.w.u.2b #u5,Da,Dn*/
PROTOTYPE_API UWord32 __clip_w_u_2b(UWord32 __imm1, UWord32 __Da);

	/*ID:  286, INST: clip.x.u.b #u5,Da,Dn*/
PROTOTYPE_API UWord32 __clip_x_u_b(UWord32 __imm1, UWord40 __Da);

	/*ID:  287, INST: clric #u5_t2*/
PROTOTYPE_API void __clric(Word32 __imm1);

	/*ID:  288, INST: cmp.eq.l #s32,Da,Pmn*/

	/*ID:  289, INST: cmp.eq.l #s32,Da,Pn*/

	/*ID:  290, INST: cmp.eq.l #ux5,Da,Pmn*/

	/*ID:  291, INST: cmp.eq.l #ux5,Da,Pn*/

	/*ID:  292, INST: cmp.eq.l Da,Db,Pmn*/

	/*ID:  293, INST: cmp.eq.l Da,Db,Pn*/

	/*ID:  294, INST: cmp.eq.w Da.l,Db.l,Pmn*/

	/*ID:  295, INST: cmp.eq.w Da.l,Db.l,Pn*/

	/*ID:  296, INST: cmp.eq.x #s32,Da,Pmn*/
PROTOTYPE_API int __cmp_eq_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  297, INST: cmp.eq.x #s32,Da,Pn*/

	/*ID:  298, INST: cmp.eq.x #ux5,Da,Pmn*/

	/*ID:  299, INST: cmp.eq.x #ux5,Da,Pn*/

	/*ID:  300, INST: cmp.eq.x Da,Db,Pmn*/
PROTOTYPE_API int __cmp_eq_x(Word40 __Da, Word40 __Db);

	/*ID:  301, INST: cmp.eq.x Da,Db,Pn*/

	/*ID:  302, INST: cmp.ge.l Da,Db,Pmn*/

	/*ID:  303, INST: cmp.ge.l Da,Db,Pn*/

	/*ID:  304, INST: cmp.ge.w Da.l,Db.l,Pmn*/

	/*ID:  305, INST: cmp.ge.w Da.l,Db.l,Pn*/

	/*ID:  306, INST: cmp.ge.x Da,Db,Pmn*/
PROTOTYPE_API int __cmp_ge_x(Word40 __Da, Word40 __Db);

	/*ID:  307, INST: cmp.ge.x Da,Db,Pn*/

	/*ID:  308, INST: cmp.ge.u.l Da,Db,Pmn*/

	/*ID:  309, INST: cmp.ge.u.l Da,Db,Pn*/

	/*ID:  310, INST: cmp.ge.u.w Da.l,Db.l,Pmn*/

	/*ID:  311, INST: cmp.ge.u.w Da.l,Db.l,Pn*/

	/*ID:  312, INST: cmp.ge.u.x Da,Db,Pmn*/
PROTOTYPE_API int __cmp_ge_u_x(UWord40 __Da, UWord40 __Db);

	/*ID:  313, INST: cmp.ge.u.x Da,Db,Pn*/

	/*ID:  314, INST: cmp.gt.l #s32,Da,Pmn*/

	/*ID:  315, INST: cmp.gt.l #s32,Da,Pn*/

	/*ID:  316, INST: cmp.gt.l #ux5,Da,Pmn*/

	/*ID:  317, INST: cmp.gt.l #ux5,Da,Pn*/

	/*ID:  318, INST: cmp.gt.l Da,Db,Pmn*/

	/*ID:  319, INST: cmp.gt.l Da,Db,Pn*/

	/*ID:  320, INST: cmp.gt.w Da.l,Db.l,Pmn*/

	/*ID:  321, INST: cmp.gt.w Da.l,Db.l,Pn*/

	/*ID:  322, INST: cmp.gt.x #s32,Da,Pmn*/
PROTOTYPE_API int __cmp_gt_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  323, INST: cmp.gt.x #s32,Da,Pn*/

	/*ID:  324, INST: cmp.gt.x #ux5,Da,Pmn*/

	/*ID:  325, INST: cmp.gt.x #ux5,Da,Pn*/

	/*ID:  326, INST: cmp.gt.x Da,Db,Pmn*/
PROTOTYPE_API int __cmp_gt_x(Word40 __Da, Word40 __Db);

	/*ID:  327, INST: cmp.gt.x Da,Db,Pn*/

	/*ID:  328, INST: cmp.gt.u.l #u32,Da,Pmn*/

	/*ID:  329, INST: cmp.gt.u.l #u32,Da,Pn*/

	/*ID:  330, INST: cmp.gt.u.l #u5,Da,Pmn*/

	/*ID:  331, INST: cmp.gt.u.l #u5,Da,Pn*/

	/*ID:  332, INST: cmp.gt.u.l Da,Db,Pmn*/

	/*ID:  333, INST: cmp.gt.u.l Da,Db,Pn*/

	/*ID:  334, INST: cmp.gt.u.w Da.l,Db.l,Pmn*/

	/*ID:  335, INST: cmp.gt.u.w Da.l,Db.l,Pn*/

	/*ID:  336, INST: cmp.gt.u.x Da,Db,Pmn*/
PROTOTYPE_API int __cmp_gt_u_x(UWord40 __Da, UWord40 __Db);

	/*ID:  337, INST: cmp.gt.u.x Da,Db,Pn*/

	/*ID:  338, INST: cmp.le.l #s32,Da,Pmn*/

	/*ID:  339, INST: cmp.le.l #s32,Da,Pn*/

	/*ID:  340, INST: cmp.le.l #ux5,Da,Pmn*/

	/*ID:  341, INST: cmp.le.l #ux5,Da,Pn*/

	/*ID:  342, INST: cmp.le.x #s32,Da,Pmn*/
PROTOTYPE_API int __cmp_le_x(Word32 __imm1, Word40 __Da);

	/*ID:  343, INST: cmp.le.x #s32,Da,Pn*/

	/*ID:  344, INST: cmp.le.x #ux5,Da,Pmn*/

	/*ID:  345, INST: cmp.le.x #ux5,Da,Pn*/

	/*ID:  346, INST: cmp.le.u.l #u32,Da,Pmn*/

	/*ID:  347, INST: cmp.le.u.l #u32,Da,Pn*/

	/*ID:  348, INST: cmp.le.u.l #u5,Da,Pmn*/

	/*ID:  349, INST: cmp.le.u.l #u5,Da,Pn*/

	/*ID:  350, INST: cmp.ne.l #s32,Da,Pmn*/

	/*ID:  351, INST: cmp.ne.l #s32,Da,Pn*/

	/*ID:  352, INST: cmp.ne.l #ux5,Da,Pmn*/

	/*ID:  353, INST: cmp.ne.l #ux5,Da,Pn*/

	/*ID:  354, INST: cmp.ne.l Da,Db,Pmn*/

	/*ID:  355, INST: cmp.ne.l Da,Db,Pn*/

	/*ID:  356, INST: cmp.ne.w Da.l,Db.l,Pmn*/

	/*ID:  357, INST: cmp.ne.w Da.l,Db.l,Pn*/

	/*ID:  358, INST: cmp.ne.x #s32,Da,Pmn*/
PROTOTYPE_API int __cmp_ne_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  359, INST: cmp.ne.x #s32,Da,Pn*/

	/*ID:  360, INST: cmp.ne.x #ux5,Da,Pmn*/

	/*ID:  361, INST: cmp.ne.x #ux5,Da,Pn*/

	/*ID:  362, INST: cmp.ne.x Da,Db,Pmn*/
PROTOTYPE_API int __cmp_ne_x(Word40 __Da, Word40 __Db);

	/*ID:  363, INST: cmp.ne.x Da,Db,Pn*/

	/*ID:  364, INST: cmpa.eq #s16,Ra,Pmn*/

	/*ID:  365, INST: cmpa.eq #s16,Ra,Pn*/

	/*ID:  366, INST: cmpa.eq #s16_t7,Ra,Pmn*/

	/*ID:  367, INST: cmpa.eq #s16_t7,Ra,Pn*/

	/*ID:  368, INST: cmpa.eq #ux5,Ra,Pmn*/

	/*ID:  369, INST: cmpa.eq #ux5,Ra,Pmn*/

	/*ID:  370, INST: cmpa.eq #ux5,Ra,Pn*/

	/*ID:  371, INST: cmpa.eq #ux5,Ra,Pn*/

	/*ID:  372, INST: cmpa.eq Ra,Rb,Pmn*/

	/*ID:  373, INST: cmpa.eq Ra,Rb,Pmn*/

	/*ID:  374, INST: cmpa.eq Ra,Rb,Pn*/

	/*ID:  375, INST: cmpa.eq Ra,Rb,Pn*/

	/*ID:  376, INST: cmpa.ge Ra,Rb,Pmn*/

	/*ID:  377, INST: cmpa.ge Ra,Rb,Pmn*/

	/*ID:  378, INST: cmpa.ge Ra,Rb,Pn*/

	/*ID:  379, INST: cmpa.ge Ra,Rb,Pn*/

	/*ID:  380, INST: cmpa.gt #s16,Ra,Pmn*/

	/*ID:  381, INST: cmpa.gt #s16,Ra,Pn*/

	/*ID:  382, INST: cmpa.gt #s16_t7,Ra,Pmn*/

	/*ID:  383, INST: cmpa.gt #s16_t7,Ra,Pn*/

	/*ID:  384, INST: cmpa.gt #ux5,Ra,Pmn*/

	/*ID:  385, INST: cmpa.gt #ux5,Ra,Pmn*/

	/*ID:  386, INST: cmpa.gt #ux5,Ra,Pn*/

	/*ID:  387, INST: cmpa.gt #ux5,Ra,Pn*/

	/*ID:  388, INST: cmpa.gt Ra,Rb,Pmn*/

	/*ID:  389, INST: cmpa.gt Ra,Rb,Pmn*/

	/*ID:  390, INST: cmpa.gt Ra,Rb,Pn*/

	/*ID:  391, INST: cmpa.gt Ra,Rb,Pn*/

	/*ID:  392, INST: cmpa.le #s16,Ra,Pmn*/

	/*ID:  393, INST: cmpa.le #s16,Ra,Pn*/

	/*ID:  394, INST: cmpa.le #s16_t7,Ra,Pmn*/

	/*ID:  395, INST: cmpa.le #s16_t7,Ra,Pn*/

	/*ID:  396, INST: cmpa.le #ux5,Ra,Pmn*/

	/*ID:  397, INST: cmpa.le #ux5,Ra,Pmn*/

	/*ID:  398, INST: cmpa.le #ux5,Ra,Pn*/

	/*ID:  399, INST: cmpa.le #ux5,Ra,Pn*/

	/*ID:  400, INST: cmpa.ne #s16,Ra,Pmn*/

	/*ID:  401, INST: cmpa.ne #s16,Ra,Pn*/

	/*ID:  402, INST: cmpa.ne #s16_t7,Ra,Pmn*/

	/*ID:  403, INST: cmpa.ne #s16_t7,Ra,Pn*/

	/*ID:  404, INST: cmpa.ne #ux5,Ra,Pmn*/

	/*ID:  405, INST: cmpa.ne #ux5,Ra,Pmn*/

	/*ID:  406, INST: cmpa.ne #ux5,Ra,Pn*/

	/*ID:  407, INST: cmpa.ne #ux5,Ra,Pn*/

	/*ID:  408, INST: cmpa.ne Ra,Rb,Pmn*/

	/*ID:  409, INST: cmpa.ne Ra,Rb,Pmn*/

	/*ID:  410, INST: cmpa.ne Ra,Rb,Pn*/

	/*ID:  411, INST: cmpa.ne Ra,Rb,Pn*/

	/*ID:  412, INST: cmpa.ge.u Ra,Rb,Pmn*/

	/*ID:  413, INST: cmpa.ge.u Ra,Rb,Pmn*/

	/*ID:  414, INST: cmpa.ge.u Ra,Rb,Pn*/

	/*ID:  415, INST: cmpa.ge.u Ra,Rb,Pn*/

	/*ID:  416, INST: cmpa.gt.u #u16,Ra,Pmn*/

	/*ID:  417, INST: cmpa.gt.u #u16,Ra,Pn*/

	/*ID:  418, INST: cmpa.gt.u #u16_t7,Ra,Pmn*/

	/*ID:  419, INST: cmpa.gt.u #u16_t7,Ra,Pn*/

	/*ID:  420, INST: cmpa.gt.u Ra,Rb,Pmn*/

	/*ID:  421, INST: cmpa.gt.u Ra,Rb,Pmn*/

	/*ID:  422, INST: cmpa.gt.u Ra,Rb,Pn*/

	/*ID:  423, INST: cmpa.gt.u Ra,Rb,Pn*/

	/*ID:  424, INST: cmpa.le.u #u16,Ra,Pmn*/

	/*ID:  425, INST: cmpa.le.u #u16,Ra,Pn*/

	/*ID:  426, INST: cmpa.le.u #u16_t7,Ra,Pmn*/

	/*ID:  427, INST: cmpa.le.u #u16_t7,Ra,Pn*/

	/*ID:  428, INST: cmpd.eq.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_eq_2t(Word40 __Da, Word40 __Db);

	/*ID:  429, INST: cmpd.eq.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_eq_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_eq_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_eq_4t_dup(__Da, __Dc);
	*__Dn =  __cmpd_eq_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_eq_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  430, INST: cmpd.eq.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __cmpd_eq_2w(Word32 __Da, Word32 __Db);

	/*ID:  431, INST: cmpd.eq.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __cmpd_eq_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __cmpd_eq_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __cmpd_eq_4w_dup(__Da, __Dc);
	*__Dn =  __cmpd_eq_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_eq_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  432, INST: cmpd.eq.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __cmpd_eq_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  433, INST: cmpd.eq.x Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_eq_x(Word40 __Da, Word40 __Db);

	/*ID:  434, INST: cmpd.eq.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_eq_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_eq_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_eq_2x_dup(__Da, __Dc);
	*__Dn =  __cmpd_eq_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_eq_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  435, INST: cmpd.ge.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_ge_2t(Word40 __Da, Word40 __Db);

	/*ID:  436, INST: cmpd.ge.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_ge_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_ge_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_ge_4t_dup(__Da, __Dc);
	*__Dn =  __cmpd_ge_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_ge_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  437, INST: cmpd.ge.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __cmpd_ge_2w(Word32 __Da, Word32 __Db);

	/*ID:  438, INST: cmpd.ge.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __cmpd_ge_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __cmpd_ge_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __cmpd_ge_4w_dup(__Da, __Dc);
	*__Dn =  __cmpd_ge_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_ge_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  439, INST: cmpd.ge.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __cmpd_ge_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  440, INST: cmpd.ge.x Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_ge_x(Word40 __Da, Word40 __Db);

	/*ID:  441, INST: cmpd.ge.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_ge_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_ge_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_ge_2x_dup(__Da, __Dc);
	*__Dn =  __cmpd_ge_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_ge_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  442, INST: cmpd.gt.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_gt_2t(Word40 __Da, Word40 __Db);

	/*ID:  443, INST: cmpd.gt.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_gt_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_gt_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_gt_4t_dup(__Da, __Dc);
	*__Dn =  __cmpd_gt_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_gt_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  444, INST: cmpd.gt.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __cmpd_gt_2w(Word32 __Da, Word32 __Db);

	/*ID:  445, INST: cmpd.gt.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __cmpd_gt_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __cmpd_gt_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __cmpd_gt_4w_dup(__Da, __Dc);
	*__Dn =  __cmpd_gt_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_gt_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  446, INST: cmpd.gt.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __cmpd_gt_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  447, INST: cmpd.gt.x Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_gt_x(Word40 __Da, Word40 __Db);

	/*ID:  448, INST: cmpd.gt.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_gt_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_gt_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_gt_2x_dup(__Da, __Dc);
	*__Dn =  __cmpd_gt_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_gt_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  449, INST: cmpd.le.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __cmpd_le_x(Word32 __imm1, Word40 __Da);

	/*ID:  450, INST: cmpd.lt.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __cmpd_lt_x(Word32 __imm1, Word40 __Da);

	/*ID:  451, INST: cmpd.ne.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_ne_2t(Word40 __Da, Word40 __Db);

	/*ID:  452, INST: cmpd.ne.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_ne_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_ne_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_ne_4t_dup(__Da, __Dc);
	*__Dn =  __cmpd_ne_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_ne_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  453, INST: cmpd.ne.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __cmpd_ne_2w(Word32 __Da, Word32 __Db);

	/*ID:  454, INST: cmpd.ne.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __cmpd_ne_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __cmpd_ne_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __cmpd_ne_4w_dup(__Da, __Dc);
	*__Dn =  __cmpd_ne_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_ne_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  455, INST: cmpd.ne.x #s32,Da,Dn*/
PROTOTYPE_API Word40 __cmpd_ne_x_imm(Word32 __imm1, Word40 __Da);

	/*ID:  456, INST: cmpd.ne.x Da,Db,Dn*/
PROTOTYPE_API Word40 __cmpd_ne_x(Word40 __Da, Word40 __Db);

	/*ID:  457, INST: cmpd.ne.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cmpd_ne_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __cmpd_ne_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cmpd_ne_2x_dup(__Da, __Dc);
	*__Dn =  __cmpd_ne_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __cmpd_ne_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  458, INST: cneg.n.4b #u3_2,Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __cneg_n_4b(Word32 __imm1, Word32 __Da, Word32 __Db);
Word32 __cneg_n_4b_aux(Word32 __Dres, Word32 __Db);
Word32 __cneg_n_4b_read(Word32 __imm1, Word32 __Da);
#define __cneg_n_4b(__imm1, __Da, __Db) __cneg_n_4b_aux(__cneg_n_4b_read(__imm1, __Da), __Db)
#else 
PROTOTYPE_API Word32 __cneg_n_4b(Word32 __imm1, Word32 __Da, Word32 __Db);
#endif 

	/*ID:  459, INST: cneg.n.4t #u3_2,Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cneg_n_4t_dup(Word32 __imm1, Word40 __Da, Word40 __Dcd);
Word40 __cneg_n_4t_dup_aux(Word32 __Dres, Word40 __Dcd);
Word32 __cneg_n_4t_dup_read(Word32 __imm1, Word40 __Da);
#define __cneg_n_4t_dup(__imm1, __Da, __Dcd) __cneg_n_4t_dup_aux(__cneg_n_4t_dup_read(__imm1, __Da), __Dcd)
__attribute__((always_inline)) inline void __cneg_n_4t(Word32 __imm1, Word40 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cneg_n_4t_dup(__imm1, __Da, __Dc);
	*__Dn =  __cneg_n_4t_dup(__imm1, __Da, __Dd);
}
#else 
PROTOTYPE_API void __cneg_n_4t(Word32 __imm1, Word40 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  460, INST: cneg.n.4w #u3_2,Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __cneg_n_4w_dup(Word32 __imm1, Word32 __Da, Word32 __Dcd);
Word32 __cneg_n_4w_dup_aux(Word32 __Dres, Word32 __Dcd);
Word32 __cneg_n_4w_dup_read(Word32 __imm1, Word32 __Da);
#define __cneg_n_4w_dup(__imm1, __Da, __Dcd) __cneg_n_4w_dup_aux(__cneg_n_4w_dup_read(__imm1, __Da), __Dcd)
__attribute__((always_inline)) inline void __cneg_n_4w(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __cneg_n_4w_dup(__imm1, __Da, __Dc);
	*__Dn =  __cneg_n_4w_dup(__imm1, __Da, __Dd);
}
#else 
PROTOTYPE_API void __cneg_n_4w(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  461, INST: cneg.n.rev.4b #u3_2,Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __cneg_n_rev_4b(Word32 __imm1, Word32 __Da, Word32 __Db);
Word32 __cneg_n_rev_4b_aux(Word32 __Dres, Word32 __Db);
Word32 __cneg_n_rev_4b_read(Word32 __imm1, Word32 __Da);
#define __cneg_n_rev_4b(__imm1, __Da, __Db) __cneg_n_rev_4b_aux(__cneg_n_rev_4b_read(__imm1, __Da), __Db)
#else 
PROTOTYPE_API Word32 __cneg_n_rev_4b(Word32 __imm1, Word32 __Da, Word32 __Db);
#endif 

	/*ID:  462, INST: cneg.n.rev.4t #u3_2,Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cneg_n_rev_4t_dup(Word32 __imm1, Word40 __Da, Word40 __Dcd);
Word40 __cneg_n_rev_4t_dup_aux(Word32 __Dres, Word40 __Dcd);
Word32 __cneg_n_rev_4t_dup_read(Word32 __imm1, Word40 __Da);
#define __cneg_n_rev_4t_dup(__imm1, __Da, __Dcd) __cneg_n_rev_4t_dup_aux(__cneg_n_rev_4t_dup_read(__imm1, __Da), __Dcd)
__attribute__((always_inline)) inline void __cneg_n_rev_4t(Word32 __imm1, Word40 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cneg_n_rev_4t_dup(__imm1, __Da, __Dc);
	*__Dn =  __cneg_n_rev_4t_dup(__imm1, __Da, __Dd);
}
#else 
PROTOTYPE_API void __cneg_n_rev_4t(Word32 __imm1, Word40 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  463, INST: cneg.n.rev.4w #u3_2,Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __cneg_n_rev_4w_dup(Word32 __imm1, Word32 __Da, Word32 __Dcd);
Word32 __cneg_n_rev_4w_dup_aux(Word32 __Dres, Word32 __Dcd);
Word32 __cneg_n_rev_4w_dup_read(Word32 __imm1, Word32 __Da);
#define __cneg_n_rev_4w_dup(__imm1, __Da, __Dcd) __cneg_n_rev_4w_dup_aux(__cneg_n_rev_4w_dup_read(__imm1, __Da), __Dcd)
__attribute__((always_inline)) inline void __cneg_n_rev_4w(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __cneg_n_rev_4w_dup(__imm1, __Da, __Dc);
	*__Dn =  __cneg_n_rev_4w_dup(__imm1, __Da, __Dd);
}
#else 
PROTOTYPE_API void __cneg_n_rev_4w(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  464, INST: cnegadd.n.2x #u3_2,Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cnegadd_n_2x_dup(Word40 __Dmn, Word32 __imm1, Word32 __Da, Word32 __Dcd);
Word40 __cnegadd_n_2x_dup_aux(Word32 __Dres, Word40 __Dmn);
Word32 __cnegadd_n_2x_dup_read(Word32 __imm1, Word32 __Da);
#define __cnegadd_n_2x_dup(__Dmn, __imm1, __Da, __Dcd) __cnegadd_n_2x_dup_aux(__cnegadd_n_2x_dup_read(__cnegadd_n_2x_dup_read(__imm1, __Da), __Dcd), __Dmn)
__attribute__((always_inline)) inline void __cnegadd_n_2x(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cnegadd_n_2x_dup(*__Dm, __imm1, __Da, __Dc);
	*__Dn =  __cnegadd_n_2x_dup(*__Dn, __imm1, __Da, __Dd);
}
#else 
PROTOTYPE_API void __cnegadd_n_2x(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  465, INST: cnegadd.n.rev.2x #u3_2,Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __cnegadd_n_rev_2x_dup(Word40 __Dmn, Word32 __imm1, Word32 __Da, Word32 __Dcd);
Word40 __cnegadd_n_rev_2x_dup_aux(Word32 __Dres, Word40 __Dmn);
Word32 __cnegadd_n_rev_2x_dup_read(Word32 __imm1, Word32 __Da);
#define __cnegadd_n_rev_2x_dup(__Dmn, __imm1, __Da, __Dcd) __cnegadd_n_rev_2x_dup_aux(__cnegadd_n_rev_2x_dup_read(__cnegadd_n_rev_2x_dup_read(__imm1, __Da), __Dcd), __Dmn)
__attribute__((always_inline)) inline void __cnegadd_n_rev_2x(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __cnegadd_n_rev_2x_dup(*__Dm, __imm1, __Da, __Dc);
	*__Dn =  __cnegadd_n_rev_2x_dup(*__Dn, __imm1, __Da, __Dd);
}
#else 
PROTOTYPE_API void __cnegadd_n_rev_2x(Word32 __imm1, Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  466, INST: cob.4b Da,Dn*/
PROTOTYPE_API Word32 __cob_4b(Word32 __Da);

	/*ID:  467, INST: cob.l Da,Dn*/
PROTOTYPE_API Word32 __cob_l(Word32 __Da);

	/*ID:  468, INST: cont.2 RelAdd19_t1,Ra*/

	/*ID:  469, INST: cont.1 RelAdd19_t1,Ra*/

	/*ID:  470, INST: cont.3 RelAdd19_t1,Ra*/

	/*ID:  471, INST: cont.0 RelAdd19_t1,Ra*/

	/*ID:  472, INST: dbar.eieio*/
PROTOTYPE_API void __dbar_eieio();

	/*ID:  473, INST: dbar.hwsync*/
PROTOTYPE_API void __dbar_hwsync();

	/*ID:  474, INST: dbar.ibll*/
PROTOTYPE_API void __dbar_ibll();

	/*ID:  475, INST: dbar.ibsl*/
PROTOTYPE_API void __dbar_ibsl();

	/*ID:  476, INST: dbar.l1sync*/
PROTOTYPE_API void __dbar_l1sync();

	/*ID:  477, INST: dbar.scfg*/
PROTOTYPE_API void __dbar_scfg();

	/*ID:  478, INST: dbars.ibss.l1*/
PROTOTYPE_API void __dbars_ibss_l1();

	/*ID:  479, INST: dbars.ibss.l12*/
PROTOTYPE_API void __dbars_ibss_l12();

	/*ID:  480, INST: dcm.flush.l1 (Rn)*/
PROTOTYPE_API void __dcm_flush_l1(Word8* __p);

	/*ID:  481, INST: dcm.flush.l12 (Rn)*/
PROTOTYPE_API void __dcm_flush_l12(Word8* __p);

	/*ID:  482, INST: dcm.inval.l1 (Rn)*/
PROTOTYPE_API void __dcm_inval_l1(Word8* __p);

	/*ID:  483, INST: dcm.inval.l12 (Rn)*/
PROTOTYPE_API void __dcm_inval_l12(Word8* __p);

	/*ID:  484, INST: dcm.sync.l12 (Rn)*/
PROTOTYPE_API void __dcm_sync_l12(Word8* __p);

	/*ID:  485, INST: dcmb.flush.l12 Ra,Rn*/
PROTOTYPE_API Word32 __dcmb_flush_l12(Word32 __Ra);

	/*ID:  486, INST: dcmb.inval.l1 Ra,Rn*/
PROTOTYPE_API Word32 __dcmb_inval_l1(Word32 __Ra);

	/*ID:  487, INST: dcmb.inval.l12 Ra,Rn*/
PROTOTYPE_API Word32 __dcmb_inval_l12(Word32 __Ra);

	/*ID:  488, INST: dcmb.sync.l1 Ra,Rn*/
PROTOTYPE_API Word32 __dcmb_sync_l1(Word32 __Ra);

	/*ID:  489, INST: dcmb.sync.l2 Ra,Rn*/
PROTOTYPE_API Word32 __dcmb_sync_l2(Word32 __Ra);

	/*ID:  490, INST: debuge.2 #u10*/
PROTOTYPE_API void __debuge_2(Word32 __imm1);

	/*ID:  491, INST: debuge.1 #u10*/
PROTOTYPE_API void __debuge_1(Word32 __imm1);

	/*ID:  492, INST: debuge.3 #u10*/
PROTOTYPE_API void __debuge_3(Word32 __imm1);

	/*ID:  493, INST: debuge.0 #u10*/
PROTOTYPE_API void __debuge_0(Word32 __imm1);

	/*ID:  494, INST: debugev.2*/
PROTOTYPE_API void __debugev_2();

	/*ID:  495, INST: debugev.4*/
PROTOTYPE_API void __debugev_4();

	/*ID:  496, INST: debugev.1*/
PROTOTYPE_API void __debugev_1();

	/*ID:  497, INST: debugev.3*/
PROTOTYPE_API void __debugev_3();

	/*ID:  498, INST: debugev.0*/
PROTOTYPE_API void __debugev_0();

	/*ID:  499, INST: debugev.5*/
PROTOTYPE_API void __debugev_5();

	/*ID:  500, INST: debugev.6*/
PROTOTYPE_API void __debugev_6();

	/*ID:  501, INST: debugev.7*/
PROTOTYPE_API void __debugev_7();

	/*ID:  502, INST: debugm.2*/
PROTOTYPE_API void __debugm_2();

	/*ID:  503, INST: debugm.1*/
PROTOTYPE_API void __debugm_1();

	/*ID:  504, INST: debugm.3*/
PROTOTYPE_API void __debugm_3();

	/*ID:  505, INST: debugm.0*/
PROTOTYPE_API void __debugm_0();

	/*ID:  506, INST: dec.ge.x Dn,Pmn*/

	/*ID:  507, INST: dec.ge.x Dn,Pn*/

	/*ID:  508, INST: dec.ne.x Dn,Pmn*/

	/*ID:  509, INST: dec.ne.x Dn,Pn*/

	/*ID:  510, INST: deca.ge Rn,Pmn*/

	/*ID:  511, INST: deca.ge Rn,Pmn*/

	/*ID:  512, INST: deca.ge Rn,Pn*/

	/*ID:  513, INST: deca.ge Rn,Pn*/

	/*ID:  514, INST: deca.ne Rn,Pmn*/

	/*ID:  515, INST: deca.ne Rn,Pmn*/

	/*ID:  516, INST: deca.ne Rn,Pn*/

	/*ID:  517, INST: deca.ne Rn,Pn*/

	/*ID:  518, INST: decor #u4_t6*/

	/*ID:  519, INST: dfetch.l12 (Rn)*/
PROTOTYPE_API void __dfetch_l12(Word8* __p);

	/*ID:  520, INST: dfetch.l2 (Rn)*/
PROTOTYPE_API void __dfetch_l2(Word8* __p);

	/*ID:  521, INST: dfetchb.l12 Ra,Rn*/
PROTOTYPE_API Word32 __dfetchb_l12(Word32 __Ra);

	/*ID:  522, INST: dfetchb.l2 Ra,Rn*/
PROTOTYPE_API Word32 __dfetchb_l2(Word32 __Ra);

	/*ID:  523, INST: dfetchb.lck.l2 Ra,Rn*/
PROTOTYPE_API Word32 __dfetchb_lck_l2(Word32 __Ra);

	/*ID:  524, INST: divp.2 Da,Dn*/
PROTOTYPE_API Word40 __divp_2(Word40 __Dn, Word40 __Da);

	/*ID:  525, INST: divp.1 Da,Dn*/
PROTOTYPE_API Word40 __divp_1(Word40 __Dn, Word40 __Da);

	/*ID:  526, INST: divp.3 Da,Dn*/
PROTOTYPE_API Word40 __divp_3(Word40 __Dn, Word40 __Da);

	/*ID:  527, INST: divp.0 Da,Dn*/
PROTOTYPE_API Word40 __divp_0(Word40 __Dn, Word40 __Da);

	/*ID:  528, INST: doalign.l Da,Db,Dn*/
PROTOTYPE_API Word32 __doalign_l(Word32 __Da, Word32 __Db);

	/*ID:  529, INST: doen.2 #u16_t8*/

	/*ID:  530, INST: doen.2 Ra*/

	/*ID:  531, INST: doen.1 #u16_t8*/

	/*ID:  532, INST: doen.1 Ra*/

	/*ID:  533, INST: doen.3 #u16_t8*/

	/*ID:  534, INST: doen.3 Ra*/

	/*ID:  535, INST: doen.0 #u16_t8*/

	/*ID:  536, INST: doen.0 Ra*/

	/*ID:  537, INST: dqsync*/
PROTOTYPE_API void __dqsync();

	/*ID:  538, INST: dquery.l1 (Rn),Rab*/
#ifndef _HOST_EMULATION_ 
Word32 __dquery_l1_dup(Word8* __p);
__attribute__((always_inline)) inline void __dquery_l1(Word8* __p, Word32* __Ra, Word32* __Rb)
{
	*__Ra =  __dquery_l1_dup(__p);
	*__Rb =  __dquery_l1_dup(__p);
}
#else 
PROTOTYPE_API void __dquery_l1(Word8* __p, Word32* __Ra, Word32* __Rb);
#endif 

	/*ID:  539, INST: dquery.l12 (Rn),Rab*/
#ifndef _HOST_EMULATION_ 
Word32 __dquery_l12_dup(Word8* __p);
__attribute__((always_inline)) inline void __dquery_l12(Word8* __p, Word32* __Ra, Word32* __Rb)
{
	*__Ra =  __dquery_l12_dup(__p);
	*__Rb =  __dquery_l12_dup(__p);
}
#else 
PROTOTYPE_API void __dquery_l12(Word8* __p, Word32* __Ra, Word32* __Rb);
#endif 

	/*ID:  540, INST: dunlockb.l2 Ra,Rn*/
PROTOTYPE_API Word32 __dunlockb_l2(Word32 __Ra);

	/*ID:  541, INST: eor.l #u32,Da,Dn*/

	/*ID:  542, INST: eor.x Da,Db,Dn*/
PROTOTYPE_API Word40 __eor_x(Word40 __Da, Word40 __Db);

	/*ID:  543, INST: eor.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __eor_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __eor_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __eor_2x_dup(__Da, __Dc);
	*__Dn =  __eor_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __eor_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  544, INST: eora Ra,Rb,Rn*/

	/*ID:  545, INST: eora Ra,Rb,Rn*/

	/*ID:  546, INST: extc.lft #u5,Da*/

	/*ID:  547, INST: extc.rgt #u5,Da*/

	/*ID:  548, INST: extins.ll Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Int64 __extins_ll(Int64 __Dmn, Int64 __Dab, Int64 __Dcd);
Int64 __extins_ll_aux(Int64 __Dres, Int64 __Dmn);
Int64 __extins_ll_read(Int64 __Dab, Int64 __Dcd);
#define __extins_ll(__Dmn, __Dab, __Dcd) __extins_ll_aux(__extins_ll_read(__Dab, __Dcd), __Dmn)
#endif
#else 
PROTOTYPE_API Int64 __extins_ll(Int64 __Dmn, Int64 __Dab, Int64 __Dcd);
#endif 

	/*ID:  549, INST: extins.x Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word40 __extins_x(Word40 __Dn, Int64 __Dab, Int64 __Dcd);
Word40 __extins_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __extins_x_read(Int64 __Dab, Int64 __Dcd);
#define __extins_x(__Dn, __Dab, __Dcd) __extins_x_aux(__extins_x_read(__Dab, __Dcd), __Dn)
#endif
#else 
PROTOTYPE_API Word40 __extins_x(Word40 __Dn, Int64 __Dab, Int64 __Dcd);
#endif 

	/*ID:  550, INST: extract.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __extract_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __extract_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __extract_2l_dup(__Da, __Dc);
	*__Dn =  __extract_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __extract_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  551, INST: extract.x #U6,#u6,Da,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __extract_x_imm(Word32 __imm1, Word32 __imm2, Word40 __Da);
Word40 __extract_x_imm_aux(Word32 __Dres, Word40 __Da);
Word32 __extract_x_imm_read(Word32 __imm1, Word32 __imm2);
#define __extract_x_imm(__imm1, __imm2, __Da) __extract_x_imm_aux(__extract_x_imm_read(__imm1, __imm2), __Da)
#else 
PROTOTYPE_API Word40 __extract_x_imm(Word32 __imm1, Word32 __imm2, Word40 __Da);
#endif 

	/*ID:  552, INST: extract.x Da,Db,Dn*/
PROTOTYPE_API Word40 __extract_x(Word40 __Da, Word40 __Db);

	/*ID:  553, INST: extract.ll.x Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word40 __extract_ll_x(Word32 __Da, Int64 __Dcd);
#endif
#else 
PROTOTYPE_API Word40 __extract_ll_x(Word32 __Da, Int64 __Dcd);
#endif 

	/*ID:  554, INST: extract.ll.u.x Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
UWord40 __extract_ll_u_x(UWord32 __Da, UInt64 __Dcd);
#endif
#else 
PROTOTYPE_API UWord40 __extract_ll_u_x(UWord32 __Da, UInt64 __Dcd);
#endif 

	/*ID:  555, INST: extract.u.x #U6,#u6,Da,Dn*/
#ifndef _HOST_EMULATION_ 
UWord40 __extract_u_x_imm(Word32 __imm1, UWord32 __imm2, UWord40 __Da);
UWord40 __extract_u_x_imm_aux(Word32 __Dres, UWord40 __Da);
Word32 __extract_u_x_imm_read(Word32 __imm1, UWord32 __imm2);
#define __extract_u_x_imm(__imm1, __imm2, __Da) __extract_u_x_imm_aux(__extract_u_x_imm_read(__imm1, __imm2), __Da)
#else 
PROTOTYPE_API UWord40 __extract_u_x_imm(Word32 __imm1, UWord32 __imm2, UWord40 __Da);
#endif 

	/*ID:  556, INST: extract.u.x Da,Db,Dn*/
PROTOTYPE_API UWord40 __extract_u_x(UWord40 __Da, UWord40 __Db);

	/*ID:  557, INST: extracta #U5,#u5,Ra,Rn*/
#ifndef _HOST_EMULATION_ 
Word32 __extracta_imm(Word32 __imm1, Word32 __imm2, Word32 __Ra);
Word32 __extracta_imm_aux(Word32 __Rres, Word32 __Ra);
Word32 __extracta_imm_read(Word32 __imm1, Word32 __imm2);
#define __extracta_imm(__imm1, __imm2, __Ra) __extracta_imm_aux(__extracta_imm_read(__imm1, __imm2), __Ra)
#else 
PROTOTYPE_API Word32 __extracta_imm(Word32 __imm1, Word32 __imm2, Word32 __Ra);
#endif 

	/*ID:  558, INST: extracta.u #U5,#u5,Ra,Rn*/
#ifndef _HOST_EMULATION_ 
UWord32 __extracta_u_imm(Word32 __imm1, UWord32 __imm2, UWord32 __Ra);
UWord32 __extracta_u_imm_aux(Word32 __Rres, UWord32 __Ra);
Word32 __extracta_u_imm_read(Word32 __imm1, UWord32 __imm2);
#define __extracta_u_imm(__imm1, __imm2, __Ra) __extracta_u_imm_aux(__extracta_u_imm_read(__imm1, __imm2), __Ra)
#else 
PROTOTYPE_API UWord32 __extracta_u_imm(Word32 __imm1, UWord32 __imm2, UWord32 __Ra);
#endif 

	/*ID:  559, INST: fft.r2.s1.4t Da,Db,Dzw*/

	/*ID:  560, INST: fft.r3.ip2.8t Dab,Dc,Dd,Def,Dg,Dh,Duv,Dwx*/

	/*ID:  561, INST: fft.r3.isp1.4t Dab,Dcd,Duv*/

	/*ID:  562, INST: fft.r3.p2.8t Dab,Dc,Dd,Def,Dg,Dh,Duv,Dwx*/

	/*ID:  563, INST: fft.r3.sp1.4t Dab,Dcd,Duv*/

	/*ID:  564, INST: fft.r4.is1.8t Da,Dcd,Db,Dgh,Dxy,Dzw*/

	/*ID:  565, INST: fft.r4.isn.8t Da,Dcd,Def,Db,Dgh,Di,Dxy,Dmn*/

	/*ID:  566, INST: fft.r4.isn.8t Da,Dcd,Def,Db,Dgh,Di,Dxy,Dzw*/

	/*ID:  567, INST: fft.r4.s1.8t Da,Dcd,Db,Dgh,Dxy,Dzw*/

	/*ID:  568, INST: fft.r4.sn.8t Da,Dcd,Def,Db,Dgh,Di,Dxy,Dmn*/

	/*ID:  569, INST: fft.r4.sn.8t Da,Dcd,Def,Db,Dgh,Di,Dxy,Dzw*/

	/*ID:  570, INST: fft.r5.2t Dab,Dcd,Dn*/

	/*ID:  571, INST: fft.r5.4t Dab,Dcd,De,Dgh,Dij,Dk,Dm,Dn*/

	/*ID:  572, INST: fft.r5.i.2t Dab,Dcd,Dn*/

	/*ID:  573, INST: fft.r5.i.4t Dab,Dcd,De,Dgh,Dij,Dk,Dm,Dn*/

	/*ID:  574, INST: fft.r5.ip11.4t Dab,Dcd,Dmn*/

	/*ID:  575, INST: fft.r5.ip12.4t Dab,Dcd,Dmn*/

	/*ID:  576, INST: fft.r5.ip2.8t Dab,Dcd,De,Dgh,Dij,Dk,Duv,Dwx*/

	/*ID:  577, INST: fft.r5.p11.4t Dab,Dcd,Dmn*/

	/*ID:  578, INST: fft.r5.p12.4t Dab,Dcd,Dmn*/

	/*ID:  579, INST: fft.r5.p2.8t Dab,Dcd,De,Dgh,Dij,Dk,Duv,Dwx*/

	/*ID:  580, INST: fnd.max.4t #u2_t3,Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __fnd_max_4t_dup(Word40 __Dmn, Word32 __imm1, Word40 __Da, Word40 __Db);
Word40 __fnd_max_4t_dup_aux(Word32 __Dres, Word40 __Dmn);
Word32 __fnd_max_4t_dup_read(Word32 __imm1, Word40 __Da);
#define __fnd_max_4t_dup(__Dmn, __imm1, __Da, __Db) __fnd_max_4t_dup_aux(__fnd_max_4t_dup_read(__fnd_max_4t_dup_read(__imm1, __Da), __Db), __Dmn)
__attribute__((always_inline)) inline void __fnd_max_4t(Word32 __imm1, Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __fnd_max_4t_dup(*__Dm, __imm1, __Da, __Db);
	*__Dn =  __fnd_max_4t_dup(*__Dn, __imm1, __Da, __Db);
}
#else 
PROTOTYPE_API void __fnd_max_4t(Word32 __imm1, Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  581, INST: fnd.max.4w #u2_t3,Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __fnd_max_4w_dup(Word32 __Dmn, Word32 __imm1, Word32 __Da, Word32 __Db);
Word32 __fnd_max_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __fnd_max_4w_dup_read(Word32 __imm1, Word32 __Da);
#define __fnd_max_4w_dup(__Dmn, __imm1, __Da, __Db) __fnd_max_4w_dup_aux(__fnd_max_4w_dup_read(__fnd_max_4w_dup_read(__imm1, __Da), __Db), __Dmn)
__attribute__((always_inline)) inline void __fnd_max_4w(Word32 __imm1, Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __fnd_max_4w_dup(*__Dm, __imm1, __Da, __Db);
	*__Dn =  __fnd_max_4w_dup(*__Dn, __imm1, __Da, __Db);
}
#else 
PROTOTYPE_API void __fnd_max_4w(Word32 __imm1, Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  582, INST: fnd.maxm.4t #u2_t3,Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __fnd_maxm_4t_dup(Word40 __Dmn, Word32 __imm1, Word40 __Da, Word40 __Db);
Word40 __fnd_maxm_4t_dup_aux(Word32 __Dres, Word40 __Dmn);
Word32 __fnd_maxm_4t_dup_read(Word32 __imm1, Word40 __Da);
#define __fnd_maxm_4t_dup(__Dmn, __imm1, __Da, __Db) __fnd_maxm_4t_dup_aux(__fnd_maxm_4t_dup_read(__fnd_maxm_4t_dup_read(__imm1, __Da), __Db), __Dmn)
__attribute__((always_inline)) inline void __fnd_maxm_4t(Word32 __imm1, Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __fnd_maxm_4t_dup(*__Dm, __imm1, __Da, __Db);
	*__Dn =  __fnd_maxm_4t_dup(*__Dn, __imm1, __Da, __Db);
}
#else 
PROTOTYPE_API void __fnd_maxm_4t(Word32 __imm1, Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  583, INST: fnd.maxm.4w #u2_t3,Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __fnd_maxm_4w_dup(Word32 __Dmn, Word32 __imm1, Word32 __Da, Word32 __Db);
Word32 __fnd_maxm_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __fnd_maxm_4w_dup_read(Word32 __imm1, Word32 __Da);
#define __fnd_maxm_4w_dup(__Dmn, __imm1, __Da, __Db) __fnd_maxm_4w_dup_aux(__fnd_maxm_4w_dup_read(__fnd_maxm_4w_dup_read(__imm1, __Da), __Db), __Dmn)
__attribute__((always_inline)) inline void __fnd_maxm_4w(Word32 __imm1, Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __fnd_maxm_4w_dup(*__Dm, __imm1, __Da, __Db);
	*__Dn =  __fnd_maxm_4w_dup(*__Dn, __imm1, __Da, __Db);
}
#else 
PROTOTYPE_API void __fnd_maxm_4w(Word32 __imm1, Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  584, INST: fnd.min.4t #u2_t3,Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __fnd_min_4t_dup(Word40 __Dmn, Word32 __imm1, Word40 __Da, Word40 __Db);
Word40 __fnd_min_4t_dup_aux(Word32 __Dres, Word40 __Dmn);
Word32 __fnd_min_4t_dup_read(Word32 __imm1, Word40 __Da);
#define __fnd_min_4t_dup(__Dmn, __imm1, __Da, __Db) __fnd_min_4t_dup_aux(__fnd_min_4t_dup_read(__fnd_min_4t_dup_read(__imm1, __Da), __Db), __Dmn)
__attribute__((always_inline)) inline void __fnd_min_4t(Word32 __imm1, Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __fnd_min_4t_dup(*__Dm, __imm1, __Da, __Db);
	*__Dn =  __fnd_min_4t_dup(*__Dn, __imm1, __Da, __Db);
}
#else 
PROTOTYPE_API void __fnd_min_4t(Word32 __imm1, Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  585, INST: fnd.min.4w #u2_t3,Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __fnd_min_4w_dup(Word32 __Dmn, Word32 __imm1, Word32 __Da, Word32 __Db);
Word32 __fnd_min_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __fnd_min_4w_dup_read(Word32 __imm1, Word32 __Da);
#define __fnd_min_4w_dup(__Dmn, __imm1, __Da, __Db) __fnd_min_4w_dup_aux(__fnd_min_4w_dup_read(__fnd_min_4w_dup_read(__imm1, __Da), __Db), __Dmn)
__attribute__((always_inline)) inline void __fnd_min_4w(Word32 __imm1, Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __fnd_min_4w_dup(*__Dm, __imm1, __Da, __Db);
	*__Dn =  __fnd_min_4w_dup(*__Dn, __imm1, __Da, __Db);
}
#else 
PROTOTYPE_API void __fnd_min_4w(Word32 __imm1, Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID:  586, INST: illegal*/
PROTOTYPE_API void __illegal();

	/*ID:  587, INST: insert.x #U6,#u6,Da,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __insert_x_imm(Word40 __Dn, Word32 __imm1, Word32 __imm2, Word40 __Da);
Word40 __insert_x_imm_aux(Word40 __Dres, Word40 __Dn);
Word40 __insert_x_imm_read(Word40 __imm1, Word32 __imm2);
#define __insert_x_imm(__Dn, __imm1, __imm2, __Da) __insert_x_imm_aux(__insert_x_imm_read(__insert_x_imm_read(__Da, __imm1), __imm2), __Dn)
#else 
PROTOTYPE_API Word40 __insert_x_imm(Word40 __Dn, Word32 __imm1, Word32 __imm2, Word40 __Da);
#endif 

	/*ID:  588, INST: insert.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __insert_x(Word40 __Dn, Word40 __Da, Word40 __Db);
Word40 __insert_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __insert_x_read(Word40 __Da, Word40 __Db);
#define __insert_x(__Dn, __Da, __Db) __insert_x_aux(__insert_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __insert_x(Word40 __Dn, Word40 __Da, Word40 __Db);
#endif 

	/*ID:  589, INST: inserta #U5,#u5_t3,Ra,Rn*/
#ifndef _HOST_EMULATION_ 
Word32 __inserta(Word32 __Rn, Word32 __imm1, Word32 __imm2, Word32 __Ra);
Word32 __inserta_aux(Word32 __Rres, Word32 __Rn);
Word32 __inserta_read(Word32 __imm1, Word32 __imm2);
#define __inserta(__Rn, __imm1, __imm2, __Ra) __inserta_aux(__inserta_read(__inserta_read(__imm1, __imm2), __Ra), __Rn)
#else 
PROTOTYPE_API Word32 __inserta(Word32 __Rn, Word32 __imm1, Word32 __imm2, Word32 __Ra);
#endif 

	/*ID:  590, INST: invsqrt.2x Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __invsqrt_2x_dup(Word32 __Da);
__attribute__((always_inline)) inline void __invsqrt_2x(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __invsqrt_2x_dup(__Da);
	*__Dn =  __invsqrt_2x_dup(__Da);
}
#else 
PROTOTYPE_API void __invsqrt_2x(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID:  591, INST: jmp AbsAdd31_t2*/

	/*ID:  592, INST: jmp Rn*/

	/*ID:  593, INST: jmp.nobtb AbsAdd31_t2*/

	/*ID:  594, INST: jmprf AbsAdd31_t2*/

	/*ID:  595, INST: jsr AbsAdd31_t2*/

	/*ID:  596, INST: jsr Rn*/

	/*ID:  597, INST: jsr.nobtb AbsAdd31_t2*/

	/*ID:  598, INST: ld.b (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_b(const Word8* __p, Word32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_b(const Word8* __p, Word32* __Da);
#endif 

	/*ID:  599, INST: ld.b (Rn)+,Ra*/

	/*ID:  600, INST: ld.b (Rn)+Rk,Da*/

	/*ID:  601, INST: ld.b (Rn)+Rk,Ra*/

	/*ID:  602, INST: ld.b (Rn),Da*/

	/*ID:  603, INST: ld.b (Rn),Ra*/

	/*ID:  604, INST: ld.b (Rn)-,Da*/

	/*ID:  605, INST: ld.b (Rn)-,Ra*/

	/*ID:  606, INST: ld.b (Rn+Rk),Da*/

	/*ID:  607, INST: ld.b (Rn+Rk),Ra*/

	/*ID:  608, INST: ld.b (Rn+s16_t7),Da*/

	/*ID:  609, INST: ld.b (Rn+s16_t7),Ra*/

	/*ID:  610, INST: ld.b (sp+s16_t7),Da*/

	/*ID:  611, INST: ld.b (sp+s16_t7),Ra*/

	/*ID:  612, INST: ld.b (sp-u9),Da*/

	/*ID:  613, INST: ld.b (sp-u9),Ra*/

	/*ID:  614, INST: ld.2b (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_2b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_2b(const Word8* __p, Word32* __Da, Word32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word8 __t1, __t2;
	__builtin_vunpack(*(__vec_2b*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_2b_dup(__p);
	*__Db =  __ld_2b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_2b(const Word8* __p, Word32* __Da, Word32* __Db);
#endif 

	/*ID:  615, INST: ld.2b (Rn)+,Rab*/

	/*ID:  616, INST: ld.2b (Rn)+Rk,Dab*/

	/*ID:  617, INST: ld.2b (Rn)+Rk,Rab*/

	/*ID:  618, INST: ld.2b (Rn),Dab*/

	/*ID:  619, INST: ld.2b (Rn),Rab*/

	/*ID:  620, INST: ld.2b (Rn)-,Dab*/

	/*ID:  621, INST: ld.2b (Rn)-,Rab*/

	/*ID:  622, INST: ld.2b (Rn+Rk),Dab*/

	/*ID:  623, INST: ld.2b (Rn+Rk),Rab*/

	/*ID:  624, INST: ld.2b (Rn+s16_t7),Dab*/

	/*ID:  625, INST: ld.2b (Rn+s16_t7),Rab*/

	/*ID:  626, INST: ld.4b (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_4b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_4b(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word8 __t1, __t2, __t3, __t4;
	__builtin_vunpack(*(__vec_4b*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_4b_dup(__p);
	*__Db =  __ld_4b_dup(__p);
	*__Dc =  __ld_4b_dup(__p);
	*__Dd =  __ld_4b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_4b(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd);
#endif 

	/*ID:  627, INST: ld.4b (Rn)+,Rabcd*/

	/*ID:  628, INST: ld.4b (Rn)+Rk,Dabcd*/

	/*ID:  629, INST: ld.4b (Rn)+Rk,Rabcd*/

	/*ID:  630, INST: ld.4b (Rn),Dabcd*/

	/*ID:  631, INST: ld.4b (Rn),Rabcd*/

	/*ID:  632, INST: ld.4b (Rn)-,Dabcd*/

	/*ID:  633, INST: ld.4b (Rn)-,Rabcd*/

	/*ID:  634, INST: ld.4b (Rn+Rk),Dabcd*/

	/*ID:  635, INST: ld.4b (Rn+Rk),Rabcd*/

	/*ID:  636, INST: ld.4b (Rn+s16_t7),Dabcd*/

	/*ID:  637, INST: ld.4b (Rn+s16_t7),Rabcd*/

	/*ID:  638, INST: ld.8b (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_8b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_8b(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word8 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_vunpack(*(__vec_8b*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_8b_dup(__p);
	*__Db =  __ld_8b_dup(__p);
	*__Dc =  __ld_8b_dup(__p);
	*__Dd =  __ld_8b_dup(__p);
	*__De =  __ld_8b_dup(__p);
	*__Df =  __ld_8b_dup(__p);
	*__Dg =  __ld_8b_dup(__p);
	*__Dh =  __ld_8b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_8b(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh);
#endif 

	/*ID:  639, INST: ld.8b (Rn)+Rk,Da__Dh*/

	/*ID:  640, INST: ld.8b (Rn),Da__Dh*/

	/*ID:  641, INST: ld.8b (Rn)-,Da__Dh*/

	/*ID:  642, INST: ld.8b (Rn+Rk),Da__Dh*/

	/*ID:  643, INST: ld.8b (Rn+s16_t7),Da__Dh*/

	/*ID:  644, INST: ld.bf (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_bf(const Word8* __p, Word32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1;
	__builtin_loadf(__p, __t1);
	*__Da = __t1;
#else
	*__Da =  __ld_bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_bf(const Word8* __p, Word32* __Da);
#endif 

	/*ID:  645, INST: ld.bf (Rn)+Rk,Da*/

	/*ID:  646, INST: ld.bf (Rn),Da*/

	/*ID:  647, INST: ld.bf (Rn)-,Da*/

	/*ID:  648, INST: ld.bf (Rn+Rk),Da*/

	/*ID:  649, INST: ld.bf (Rn+s16_t7),Da*/

	/*ID:  650, INST: ld.bf (sp+s16_t7),Da*/

	/*ID:  651, INST: ld.bf (sp-u9),Da*/

	/*ID:  652, INST: ld.2bf (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_2bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_2bf(const Word8* __p, Word32* __Da, Word32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2;
	__builtin_loadf((__vec_2b*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_2bf_dup(__p);
	*__Db =  __ld_2bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_2bf(const Word8* __p, Word32* __Da, Word32* __Db);
#endif 

	/*ID:  653, INST: ld.2bf (Rn)+Rk,Dab*/

	/*ID:  654, INST: ld.2bf (Rn),Dab*/

	/*ID:  655, INST: ld.2bf (Rn)-,Dab*/

	/*ID:  656, INST: ld.2bf (Rn+Rk),Dab*/

	/*ID:  657, INST: ld.2bf (Rn+s16_t7),Dab*/

	/*ID:  658, INST: ld.4bf (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_4bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_4bf(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4;
	__builtin_loadf((__vec_4b*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_4bf_dup(__p);
	*__Db =  __ld_4bf_dup(__p);
	*__Dc =  __ld_4bf_dup(__p);
	*__Dd =  __ld_4bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_4bf(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd);
#endif 

	/*ID:  659, INST: ld.4bf (Rn)+Rk,Dabcd*/

	/*ID:  660, INST: ld.4bf (Rn),Dabcd*/

	/*ID:  661, INST: ld.4bf (Rn)-,Dabcd*/

	/*ID:  662, INST: ld.4bf (Rn+Rk),Dabcd*/

	/*ID:  663, INST: ld.4bf (Rn+s16_t7),Dabcd*/

	/*ID:  664, INST: ld.8bf (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_8bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld_8bf(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_loadf((__vec_8b*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_8bf_dup(__p);
	*__Db =  __ld_8bf_dup(__p);
	*__Dc =  __ld_8bf_dup(__p);
	*__Dd =  __ld_8bf_dup(__p);
	*__De =  __ld_8bf_dup(__p);
	*__Df =  __ld_8bf_dup(__p);
	*__Dg =  __ld_8bf_dup(__p);
	*__Dh =  __ld_8bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_8bf(const Word8* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh);
#endif 

	/*ID:  665, INST: ld.8bf (Rn)+Rk,Da__Dh*/

	/*ID:  666, INST: ld.8bf (Rn),Da__Dh*/

	/*ID:  667, INST: ld.8bf (Rn)-,Da__Dh*/

	/*ID:  668, INST: ld.8bf (Rn+Rk),Da__Dh*/

	/*ID:  669, INST: ld.8bf (Rn+s16_t7),Da__Dh*/

	/*ID:  670, INST: ld.f (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_f(const Word16* __p, Word32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1;
	__builtin_loadf(__p, __t1);
	*__Da = __t1;
#else
	*__Da =  __ld_f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_f(const Word16* __p, Word32* __Da);
#endif 

	/*ID:  671, INST: ld.f (Rn)+Rk,Da*/

	/*ID:  672, INST: ld.f (Rn),Da*/

	/*ID:  673, INST: ld.f (Rn)-,Da*/

	/*ID:  674, INST: ld.f (Rn+Rk),Da*/

	/*ID:  675, INST: ld.f (Rn+s16_t7),Da*/

	/*ID:  676, INST: ld.f (sp+s16_t7),Da*/

	/*ID:  677, INST: ld.f (sp-u9_1),Da*/

	/*ID:  678, INST: ld.2f (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_2f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_2f(const Word16* __p, Word32* __Da, Word32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2;
	__builtin_loadf((__vec_2w*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_2f_dup(__p);
	*__Db =  __ld_2f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_2f(const Word16* __p, Word32* __Da, Word32* __Db);
#endif 

	/*ID:  679, INST: ld.2f (Rn)+Rk,Dab*/

	/*ID:  680, INST: ld.2f (Rn),Dab*/

	/*ID:  681, INST: ld.2f (Rn)-,Dab*/

	/*ID:  682, INST: ld.2f (Rn+Rk),Dab*/

	/*ID:  683, INST: ld.2f (Rn+s16_t7),Dab*/

	/*ID:  684, INST: ld.4f (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_4f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_4f(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4;
	__builtin_loadf((__vec_4w*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_4f_dup(__p);
	*__Db =  __ld_4f_dup(__p);
	*__Dc =  __ld_4f_dup(__p);
	*__Dd =  __ld_4f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_4f(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd);
#endif 

	/*ID:  685, INST: ld.4f (Rn)+Rk,Dabcd*/

	/*ID:  686, INST: ld.4f (Rn),Dabcd*/

	/*ID:  687, INST: ld.4f (Rn)-,Dabcd*/

	/*ID:  688, INST: ld.4f (Rn+Rk),Dabcd*/

	/*ID:  689, INST: ld.4f (Rn+s16_t7),Dabcd*/

	/*ID:  690, INST: ld.8f (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_8f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_8f(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_loadf((__vec_8w*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_8f_dup(__p);
	*__Db =  __ld_8f_dup(__p);
	*__Dc =  __ld_8f_dup(__p);
	*__Dd =  __ld_8f_dup(__p);
	*__De =  __ld_8f_dup(__p);
	*__Df =  __ld_8f_dup(__p);
	*__Dg =  __ld_8f_dup(__p);
	*__Dh =  __ld_8f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_8f(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh);
#endif 

	/*ID:  691, INST: ld.8f (Rn)+Rk,Da__Dh*/

	/*ID:  692, INST: ld.8f (Rn),Da__Dh*/

	/*ID:  693, INST: ld.8f (Rn)-,Da__Dh*/

	/*ID:  694, INST: ld.8f (Rn+Rk),Da__Dh*/

	/*ID:  695, INST: ld.8f (Rn+s16_t7),Da__Dh*/

	/*ID:  696, INST: ld.l (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_l_dup(const Word32* __p);
__attribute__((always_inline)) inline void __ld_l(const Word32* __p, Word32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_l(const Word32* __p, Word32* __Da);
#endif 

	/*ID:  697, INST: ld.l (Rn)+,Ra*/

	/*ID:  698, INST: ld.l (Rn)+Rk,Da*/

	/*ID:  699, INST: ld.l (Rn)+Rk,Ra*/

	/*ID:  700, INST: ld.l (Rn),BTRN*/

	/*ID:  701, INST: ld.l (Rn),Da*/

	/*ID:  702, INST: ld.l (Rn),Ra*/

	/*ID:  703, INST: ld.l (Rn)-,Da*/

	/*ID:  704, INST: ld.l (Rn)-,Ra*/

	/*ID:  705, INST: ld.l (Rn+Rk),Da*/

	/*ID:  706, INST: ld.l (Rn+Rk),Ra*/

	/*ID:  707, INST: ld.l (Rn+s16_t7),Da*/

	/*ID:  708, INST: ld.l (Rn+s16_t7),Ra*/

	/*ID:  709, INST: ld.l (sp+s16_t7),Da*/

	/*ID:  710, INST: ld.l (sp+s16_t7),Ra*/

	/*ID:  711, INST: ld.l (sp-u9_2),Da*/

	/*ID:  712, INST: ld.l (sp-u9_2),Ra*/

	/*ID:  713, INST: ld.2l (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_2l_dup(const Word32* __p);
__attribute__((always_inline)) inline void __ld_2l(const Word32* __p, Word32* __Da, Word32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2;
	__builtin_vunpack(*(__vec_2l*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_2l_dup(__p);
	*__Db =  __ld_2l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_2l(const Word32* __p, Word32* __Da, Word32* __Db);
#endif 

	/*ID:  714, INST: ld.2l (Rn)+,Dac*/

	/*ID:  715, INST: ld.2l (Rn)+,Rab*/

	/*ID:  716, INST: ld.2l (Rn)+Rk,Dab*/

	/*ID:  717, INST: ld.2l (Rn)+Rk,Dac*/

	/*ID:  718, INST: ld.2l (Rn)+Rk,Rab*/

	/*ID:  719, INST: ld.2l (Rn),Dab*/

	/*ID:  720, INST: ld.2l (Rn),Dac*/

	/*ID:  721, INST: ld.2l (Rn),Rab*/

	/*ID:  722, INST: ld.2l (Rn)-,Dab*/

	/*ID:  723, INST: ld.2l (Rn)-,Dac*/

	/*ID:  724, INST: ld.2l (Rn)-,Rab*/

	/*ID:  725, INST: ld.2l (Rn+Rk),Dab*/

	/*ID:  726, INST: ld.2l (Rn+Rk),Dac*/

	/*ID:  727, INST: ld.2l (Rn+Rk),Rab*/

	/*ID:  728, INST: ld.2l (Rn+s16_t7),Dab*/

	/*ID:  729, INST: ld.2l (Rn+s16_t7),Dac*/

	/*ID:  730, INST: ld.2l (Rn+s16_t7),Rab*/

	/*ID:  731, INST: ld.2l (sp+s16_t7),Dab*/

	/*ID:  732, INST: ld.2l (sp+s16_t7),Rab*/

	/*ID:  733, INST: ld.4l (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_4l_dup(const Word32* __p);
__attribute__((always_inline)) inline void __ld_4l(const Word32* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4;
	__builtin_vunpack(*(__vec_4l*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_4l_dup(__p);
	*__Db =  __ld_4l_dup(__p);
	*__Dc =  __ld_4l_dup(__p);
	*__Dd =  __ld_4l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_4l(const Word32* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd);
#endif 

	/*ID:  734, INST: ld.4l (Rn)+,Dacbd*/

	/*ID:  735, INST: ld.4l (Rn)+,Daceg*/

	/*ID:  736, INST: ld.4l (Rn)+,Rabcd*/

	/*ID:  737, INST: ld.4l (Rn)+Rk,Dabcd*/

	/*ID:  738, INST: ld.4l (Rn)+Rk,Dacbd*/

	/*ID:  739, INST: ld.4l (Rn)+Rk,Daceg*/

	/*ID:  740, INST: ld.4l (Rn)+Rk,Rabcd*/

	/*ID:  741, INST: ld.4l (Rn),Dabcd*/

	/*ID:  742, INST: ld.4l (Rn),Dacbd*/

	/*ID:  743, INST: ld.4l (Rn),Daceg*/

	/*ID:  744, INST: ld.4l (Rn),Rabcd*/

	/*ID:  745, INST: ld.4l (Rn)-,Dabcd*/

	/*ID:  746, INST: ld.4l (Rn)-,Dacbd*/

	/*ID:  747, INST: ld.4l (Rn)-,Daceg*/

	/*ID:  748, INST: ld.4l (Rn)-,Rabcd*/

	/*ID:  749, INST: ld.4l (Rn+Rk),Dabcd*/

	/*ID:  750, INST: ld.4l (Rn+Rk),Dacbd*/

	/*ID:  751, INST: ld.4l (Rn+Rk),Daceg*/

	/*ID:  752, INST: ld.4l (Rn+Rk),Rabcd*/

	/*ID:  753, INST: ld.4l (Rn+s16_t7),Dabcd*/

	/*ID:  754, INST: ld.4l (Rn+s16_t7),Dacbd*/

	/*ID:  755, INST: ld.4l (Rn+s16_t7),Daceg*/

	/*ID:  756, INST: ld.4l (Rn+s16_t7),Rabcd*/

	/*ID:  757, INST: ld.8l (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_8l_dup(const Word32* __p);
__attribute__((always_inline)) inline void __ld_8l(const Word32* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_vunpack(*(__vec_8l*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_8l_dup(__p);
	*__Db =  __ld_8l_dup(__p);
	*__Dc =  __ld_8l_dup(__p);
	*__Dd =  __ld_8l_dup(__p);
	*__De =  __ld_8l_dup(__p);
	*__Df =  __ld_8l_dup(__p);
	*__Dg =  __ld_8l_dup(__p);
	*__Dh =  __ld_8l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_8l(const Word32* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh);
#endif 

	/*ID:  758, INST: ld.8l (Rn)+,Dacegbdfh*/

	/*ID:  759, INST: ld.8l (Rn)+,Daceghjln*/

	/*ID:  760, INST: ld.8l (Rn)+Rk,Da__Dh*/

	/*ID:  761, INST: ld.8l (Rn)+Rk,Dacegbdfh*/

	/*ID:  762, INST: ld.8l (Rn)+Rk,Daceghjln*/

	/*ID:  763, INST: ld.8l (Rn),Da__Dh*/

	/*ID:  764, INST: ld.8l (Rn),Dacegbdfh*/

	/*ID:  765, INST: ld.8l (Rn),Daceghjln*/

	/*ID:  766, INST: ld.8l (Rn)-,Da__Dh*/

	/*ID:  767, INST: ld.8l (Rn)-,Dacegbdfh*/

	/*ID:  768, INST: ld.8l (Rn)-,Daceghjln*/

	/*ID:  769, INST: ld.8l (Rn+Rk),Da__Dh*/

	/*ID:  770, INST: ld.8l (Rn+Rk),Dacegbdfh*/

	/*ID:  771, INST: ld.8l (Rn+Rk),Daceghjln*/

	/*ID:  772, INST: ld.8l (Rn+s16_t7),Da__Dh*/

	/*ID:  773, INST: ld.8l (Rn+s16_t7),Dacegbdfh*/

	/*ID:  774, INST: ld.8l (Rn+s16_t7),Daceghjln*/

	/*ID:  775, INST: ld.16l (Rn)+,Da__Dp*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_16l_dup(const Word32* __p);
__attribute__((always_inline)) inline void __ld_16l(const Word32* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh, Word32* __Di, Word32* __Dj, Word32* __Dk, Word32* __Dl, Word32* __Dm, Word32* __Dn, Word32* __Do, Word32* __Dp)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word32 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8, __t9, __t10, __t11, __t12, __t13, __t14, __t15, __t16;
	__builtin_vunpack(*(__vec_16l*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8, __t9, __t10, __t11, __t12, __t13, __t14, __t15, __t16);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
	*__Di = __t9;
	*__Dj = __t10;
	*__Dk = __t11;
	*__Dl = __t12;
	*__Dm = __t13;
	*__Dn = __t14;
	*__Do = __t15;
	*__Dp = __t16;
#else
	*__Da =  __ld_16l_dup(__p);
	*__Db =  __ld_16l_dup(__p);
	*__Dc =  __ld_16l_dup(__p);
	*__Dd =  __ld_16l_dup(__p);
	*__De =  __ld_16l_dup(__p);
	*__Df =  __ld_16l_dup(__p);
	*__Dg =  __ld_16l_dup(__p);
	*__Dh =  __ld_16l_dup(__p);
	*__Di =  __ld_16l_dup(__p);
	*__Dj =  __ld_16l_dup(__p);
	*__Dk =  __ld_16l_dup(__p);
	*__Dl =  __ld_16l_dup(__p);
	*__Dm =  __ld_16l_dup(__p);
	*__Dn =  __ld_16l_dup(__p);
	*__Do =  __ld_16l_dup(__p);
	*__Dp =  __ld_16l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_16l(const Word32* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh, Word32* __Di, Word32* __Dj, Word32* __Dk, Word32* __Dl, Word32* __Dm, Word32* __Dn, Word32* __Do, Word32* __Dp);
#endif 

	/*ID:  776, INST: ld.16l (Rn)+Rk,Da__Dp*/

	/*ID:  777, INST: ld.16l (Rn),Da__Dp*/

	/*ID:  778, INST: ld.16l (Rn)-,Da__Dp*/

	/*ID:  779, INST: ld.16l (Rn+Rk),Da__Dp*/

	/*ID:  780, INST: ld.16l (Rn+s16_t7),Da__Dp*/

	/*ID:  781, INST: ld.w (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_w_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_w(const Word16* __p, Word32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_w(const Word16* __p, Word32* __Da);
#endif 

	/*ID:  782, INST: ld.w (Rn)+,Ra*/

	/*ID:  783, INST: ld.w (Rn)+Rk,Da*/

	/*ID:  784, INST: ld.w (Rn)+Rk,Ra*/

	/*ID:  785, INST: ld.w (Rn),Da*/

	/*ID:  786, INST: ld.w (Rn),Ra*/

	/*ID:  787, INST: ld.w (Rn)-,Da*/

	/*ID:  788, INST: ld.w (Rn)-,Ra*/

	/*ID:  789, INST: ld.w (Rn+Rk),Da*/

	/*ID:  790, INST: ld.w (Rn+Rk),Ra*/

	/*ID:  791, INST: ld.w (Rn+s16_t7),Da*/

	/*ID:  792, INST: ld.w (Rn+s16_t7),Ra*/

	/*ID:  793, INST: ld.w (sp+s16_t7),Da*/

	/*ID:  794, INST: ld.w (sp+s16_t7),Ra*/

	/*ID:  795, INST: ld.w (sp-u9_1),Da*/

	/*ID:  796, INST: ld.w (sp-u9_1),Ra*/

	/*ID:  797, INST: ld.2w (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_2w_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_2w(const Word16* __p, Word32* __Da, Word32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word16 __t1, __t2;
	__builtin_vunpack(*(__vec_2w*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_2w_dup(__p);
	*__Db =  __ld_2w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_2w(const Word16* __p, Word32* __Da, Word32* __Db);
#endif 

	/*ID:  798, INST: ld.2w (Rn)+,Rab*/

	/*ID:  799, INST: ld.2w (Rn)+Rk,Dab*/

	/*ID:  800, INST: ld.2w (Rn)+Rk,Rab*/

	/*ID:  801, INST: ld.2w (Rn),Dab*/

	/*ID:  802, INST: ld.2w (Rn),Rab*/

	/*ID:  803, INST: ld.2w (Rn)-,Dab*/

	/*ID:  804, INST: ld.2w (Rn)-,Rab*/

	/*ID:  805, INST: ld.2w (Rn+Rk),Dab*/

	/*ID:  806, INST: ld.2w (Rn+Rk),Rab*/

	/*ID:  807, INST: ld.2w (Rn+s16_t7),Dab*/

	/*ID:  808, INST: ld.2w (Rn+s16_t7),Rab*/

	/*ID:  809, INST: ld.4w (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_4w_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_4w(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word16 __t1, __t2, __t3, __t4;
	__builtin_vunpack(*(__vec_4w*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_4w_dup(__p);
	*__Db =  __ld_4w_dup(__p);
	*__Dc =  __ld_4w_dup(__p);
	*__Dd =  __ld_4w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_4w(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd);
#endif 

	/*ID:  810, INST: ld.4w (Rn)+,Rabcd*/

	/*ID:  811, INST: ld.4w (Rn)+Rk,Dabcd*/

	/*ID:  812, INST: ld.4w (Rn)+Rk,Rabcd*/

	/*ID:  813, INST: ld.4w (Rn),Dabcd*/

	/*ID:  814, INST: ld.4w (Rn),Rabcd*/

	/*ID:  815, INST: ld.4w (Rn)-,Dabcd*/

	/*ID:  816, INST: ld.4w (Rn)-,Rabcd*/

	/*ID:  817, INST: ld.4w (Rn+Rk),Dabcd*/

	/*ID:  818, INST: ld.4w (Rn+Rk),Rabcd*/

	/*ID:  819, INST: ld.4w (Rn+s16_t7),Dabcd*/

	/*ID:  820, INST: ld.4w (Rn+s16_t7),Rabcd*/

	/*ID:  821, INST: ld.8w (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_8w_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld_8w(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word16 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_vunpack(*(__vec_8w*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_8w_dup(__p);
	*__Db =  __ld_8w_dup(__p);
	*__Dc =  __ld_8w_dup(__p);
	*__Dd =  __ld_8w_dup(__p);
	*__De =  __ld_8w_dup(__p);
	*__Df =  __ld_8w_dup(__p);
	*__Dg =  __ld_8w_dup(__p);
	*__Dh =  __ld_8w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_8w(const Word16* __p, Word32* __Da, Word32* __Db, Word32* __Dc, Word32* __Dd, Word32* __De, Word32* __Df, Word32* __Dg, Word32* __Dh);
#endif 

	/*ID:  822, INST: ld.8w (Rn)+Rk,Da__Dh*/

	/*ID:  823, INST: ld.8w (Rn),Da__Dh*/

	/*ID:  824, INST: ld.8w (Rn)-,Da__Dh*/

	/*ID:  825, INST: ld.8w (Rn+Rk),Da__Dh*/

	/*ID:  826, INST: ld.8w (Rn+s16_t7),Da__Dh*/

	/*ID:  827, INST: ld.x (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word40 __ld_x_dup(const Word40* __p);
__attribute__((always_inline)) inline void __ld_x(const Word40* __p, Word40* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_x_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_x(const Word40* __p, Word40* __Da);
#endif 

	/*ID:  828, INST: ld.x (Rn)+Rk,Da*/

	/*ID:  829, INST: ld.x (Rn),Da*/

	/*ID:  830, INST: ld.x (Rn)-,Da*/

	/*ID:  831, INST: ld.x (Rn+Rk),Da*/

	/*ID:  832, INST: ld.x (Rn+s16_t7),Da*/

	/*ID:  833, INST: ld.x (sp+s16_t7),Da*/

	/*ID:  834, INST: ld.x (sp-u9_3),Da*/

	/*ID:  835, INST: ld.2x (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word40 __ld_2x_dup(const Word40* __p);
__attribute__((always_inline)) inline void __ld_2x(const Word40* __p, Word40* __Da, Word40* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2;
	__builtin_loadf(__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_2x_dup(__p);
	*__Db =  __ld_2x_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_2x(const Word40* __p, Word40* __Da, Word40* __Db);
#endif 

	/*ID:  836, INST: ld.2x (Rn)+Rk,Dab*/

	/*ID:  837, INST: ld.2x (Rn),Dab*/

	/*ID:  838, INST: ld.2x (Rn)-,Dab*/

	/*ID:  839, INST: ld.2x (Rn+Rk),Dab*/

	/*ID:  840, INST: ld.2x (Rn+s16_t7),Dab*/

	/*ID:  841, INST: ld.4x (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word40 __ld_4x_dup(const Word40* __p);
__attribute__((always_inline)) inline void __ld_4x(const Word40* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4;
	__builtin_loadf(__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_4x_dup(__p);
	*__Db =  __ld_4x_dup(__p);
	*__Dc =  __ld_4x_dup(__p);
	*__Dd =  __ld_4x_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_4x(const Word40* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd);
#endif 

	/*ID:  842, INST: ld.4x (Rn)+Rk,Dabcd*/

	/*ID:  843, INST: ld.4x (Rn),Dabcd*/

	/*ID:  844, INST: ld.4x (Rn)-,Dabcd*/

	/*ID:  845, INST: ld.4x (Rn+Rk),Dabcd*/

	/*ID:  846, INST: ld.4x (Rn+s16_t7),Dabcd*/

	/*ID:  847, INST: ld.8x (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word40 __ld_8x_dup(const Word40* __p);
__attribute__((always_inline)) inline void __ld_8x(const Word40* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_loadf(__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_8x_dup(__p);
	*__Db =  __ld_8x_dup(__p);
	*__Dc =  __ld_8x_dup(__p);
	*__Dd =  __ld_8x_dup(__p);
	*__De =  __ld_8x_dup(__p);
	*__Df =  __ld_8x_dup(__p);
	*__Dg =  __ld_8x_dup(__p);
	*__Dh =  __ld_8x_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_8x(const Word40* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh);
#endif 

	/*ID:  848, INST: ld.8x (Rn)+Rk,Da__Dh*/

	/*ID:  849, INST: ld.8x (Rn),Da__Dh*/

	/*ID:  850, INST: ld.8x (Rn)-,Da__Dh*/

	/*ID:  851, INST: ld.8x (Rn+Rk),Da__Dh*/

	/*ID:  852, INST: ld.8x (Rn+s16_t7),Da__Dh*/

	/*ID:  853, INST: ld.par.w (Rn)+,Da.h*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_par_w_h_dup(Word32 __Da_h, const Word16* __p);
__attribute__((always_inline)) inline void __ld_par_w_h(const Word16* __p, Word32* __Da_h)
{
	*__Da_h =  __ld_par_w_h_dup(*__Da_h, __p);
}
#else 
PROTOTYPE_API void __ld_par_w_h(const Word16* __p, Word32* __Da_h);
#endif 

	/*ID:  854, INST: ld.par.w (Rn)+Rk,Da.h*/

	/*ID:  855, INST: ld.par.w (Rn),Da.h*/

	/*ID:  856, INST: ld.par.w (Rn)-,Da.h*/

	/*ID:  857, INST: ld.par.w (Rn+Rk),Da.h*/

	/*ID:  858, INST: ld.par.w (Rn+s16_t7),Da.h*/

	/*ID:  859, INST: ld.par.w (sp+s16_t7),Da.h*/

	/*ID:  860, INST: ld.par.w (Rn)+,Da.l*/
#ifndef _HOST_EMULATION_ 
Word32 __ld_par_w_l_dup(Word32 __Da_l, const Word16* __p);
__attribute__((always_inline)) inline void __ld_par_w_l(const Word16* __p, Word32* __Da_l)
{
	*__Da_l =  __ld_par_w_l_dup(*__Da_l, __p);
}
#else 
PROTOTYPE_API void __ld_par_w_l(const Word16* __p, Word32* __Da_l);
#endif 

	/*ID:  861, INST: ld.par.w (Rn)+Rk,Da.l*/

	/*ID:  862, INST: ld.par.w (Rn),Da.l*/

	/*ID:  863, INST: ld.par.w (Rn)-,Da.l*/

	/*ID:  864, INST: ld.par.w (Rn+Rk),Da.l*/

	/*ID:  865, INST: ld.par.w (Rn+s16_t7),Da.l*/

	/*ID:  866, INST: ld.par.w (sp+s16_t7),Da.l*/

	/*ID:  867, INST: ld.u.b (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld_u_b(const UWord8* __p, UWord32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_u_b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_b(const UWord8* __p, UWord32* __Da);
#endif 

	/*ID:  868, INST: ld.u.b (Rn)+,Ra*/

	/*ID:  869, INST: ld.u.b (Rn)+Rk,Da*/

	/*ID:  870, INST: ld.u.b (Rn)+Rk,Ra*/

	/*ID:  871, INST: ld.u.b (Rn),Da*/

	/*ID:  872, INST: ld.u.b (Rn),Ra*/

	/*ID:  873, INST: ld.u.b (Rn)-,Da*/

	/*ID:  874, INST: ld.u.b (Rn)-,Ra*/

	/*ID:  875, INST: ld.u.b (Rn+Rk),Da*/

	/*ID:  876, INST: ld.u.b (Rn+Rk),Ra*/

	/*ID:  877, INST: ld.u.b (Rn+s16_t7),Da*/

	/*ID:  878, INST: ld.u.b (Rn+s16_t7),Ra*/

	/*ID:  879, INST: ld.u.b (sp+s16_t7),Da*/

	/*ID:  880, INST: ld.u.b (sp+s16_t7),Ra*/

	/*ID:  881, INST: ld.u.b (sp-u9),Da*/

	/*ID:  882, INST: ld.u.b (sp-u9),Ra*/

	/*ID:  883, INST: ld.u.2b (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_2b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld_u_2b(const UWord8* __p, UWord32* __Da, UWord32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord8 __t1, __t2;
	__builtin_vunpack(*(__vec_2ub*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_u_2b_dup(__p);
	*__Db =  __ld_u_2b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_2b(const UWord8* __p, UWord32* __Da, UWord32* __Db);
#endif 

	/*ID:  884, INST: ld.u.2b (Rn)+,Rab*/

	/*ID:  885, INST: ld.u.2b (Rn)+Rk,Dab*/

	/*ID:  886, INST: ld.u.2b (Rn)+Rk,Rab*/

	/*ID:  887, INST: ld.u.2b (Rn),Dab*/

	/*ID:  888, INST: ld.u.2b (Rn),Rab*/

	/*ID:  889, INST: ld.u.2b (Rn)-,Dab*/

	/*ID:  890, INST: ld.u.2b (Rn)-,Rab*/

	/*ID:  891, INST: ld.u.2b (Rn+Rk),Dab*/

	/*ID:  892, INST: ld.u.2b (Rn+Rk),Rab*/

	/*ID:  893, INST: ld.u.2b (Rn+s16_t7),Dab*/

	/*ID:  894, INST: ld.u.2b (Rn+s16_t7),Rab*/

	/*ID:  895, INST: ld.u.4b (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_4b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld_u_4b(const UWord8* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord8 __t1, __t2, __t3, __t4;
	__builtin_vunpack(*(__vec_4ub*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_u_4b_dup(__p);
	*__Db =  __ld_u_4b_dup(__p);
	*__Dc =  __ld_u_4b_dup(__p);
	*__Dd =  __ld_u_4b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_4b(const UWord8* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd);
#endif 

	/*ID:  896, INST: ld.u.4b (Rn)+,Rabcd*/

	/*ID:  897, INST: ld.u.4b (Rn)+Rk,Dabcd*/

	/*ID:  898, INST: ld.u.4b (Rn)+Rk,Rabcd*/

	/*ID:  899, INST: ld.u.4b (Rn),Dabcd*/

	/*ID:  900, INST: ld.u.4b (Rn),Rabcd*/

	/*ID:  901, INST: ld.u.4b (Rn)-,Dabcd*/

	/*ID:  902, INST: ld.u.4b (Rn)-,Rabcd*/

	/*ID:  903, INST: ld.u.4b (Rn+Rk),Dabcd*/

	/*ID:  904, INST: ld.u.4b (Rn+Rk),Rabcd*/

	/*ID:  905, INST: ld.u.4b (Rn+s16_t7),Dabcd*/

	/*ID:  906, INST: ld.u.4b (Rn+s16_t7),Rabcd*/

	/*ID:  907, INST: ld.u.8b (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_8b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld_u_8b(const UWord8* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd, UWord32* __De, UWord32* __Df, UWord32* __Dg, UWord32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord8 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_vunpack(*(__vec_8ub*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_u_8b_dup(__p);
	*__Db =  __ld_u_8b_dup(__p);
	*__Dc =  __ld_u_8b_dup(__p);
	*__Dd =  __ld_u_8b_dup(__p);
	*__De =  __ld_u_8b_dup(__p);
	*__Df =  __ld_u_8b_dup(__p);
	*__Dg =  __ld_u_8b_dup(__p);
	*__Dh =  __ld_u_8b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_8b(const UWord8* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd, UWord32* __De, UWord32* __Df, UWord32* __Dg, UWord32* __Dh);
#endif 

	/*ID:  908, INST: ld.u.8b (Rn)+Rk,Da__Dh*/

	/*ID:  909, INST: ld.u.8b (Rn),Da__Dh*/

	/*ID:  910, INST: ld.u.8b (Rn)-,Da__Dh*/

	/*ID:  911, INST: ld.u.8b (Rn+Rk),Da__Dh*/

	/*ID:  912, INST: ld.u.8b (Rn+s16_t7),Da__Dh*/

	/*ID:  913, INST: ld.u.l (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_l_dup(const UWord32* __p);
__attribute__((always_inline)) inline void __ld_u_l(const UWord32* __p, UWord32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_u_l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_l(const UWord32* __p, UWord32* __Da);
#endif 

	/*ID:  914, INST: ld.u.l (Rn)+Rk,Da*/

	/*ID:  915, INST: ld.u.l (Rn),Da*/

	/*ID:  916, INST: ld.u.l (Rn)-,Da*/

	/*ID:  917, INST: ld.u.l (Rn+Rk),Da*/

	/*ID:  918, INST: ld.u.l (Rn+s16_t7),Da*/

	/*ID:  919, INST: ld.u.l (sp+s16_t7),Da*/

	/*ID:  920, INST: ld.u.l (sp-u9_2),Da*/

	/*ID:  921, INST: ld.u.2l (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_2l_dup(const UWord32* __p);
__attribute__((always_inline)) inline void __ld_u_2l(const UWord32* __p, UWord32* __Da, UWord32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord32 __t1, __t2;
	__builtin_vunpack(*(__vec_2ul*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_u_2l_dup(__p);
	*__Db =  __ld_u_2l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_2l(const UWord32* __p, UWord32* __Da, UWord32* __Db);
#endif 

	/*ID:  922, INST: ld.u.2l (Rn)+Rk,Dab*/

	/*ID:  923, INST: ld.u.2l (Rn),Dab*/

	/*ID:  924, INST: ld.u.2l (Rn)-,Dab*/

	/*ID:  925, INST: ld.u.2l (Rn+Rk),Dab*/

	/*ID:  926, INST: ld.u.2l (Rn+s16_t7),Dab*/

	/*ID:  927, INST: ld.u.2l (sp+s16_t7),Dab*/

	/*ID:  928, INST: ld.u.4l (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_4l_dup(const UWord32* __p);
__attribute__((always_inline)) inline void __ld_u_4l(const UWord32* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord32 __t1, __t2, __t3, __t4;
	__builtin_vunpack(*(__vec_4ul*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_u_4l_dup(__p);
	*__Db =  __ld_u_4l_dup(__p);
	*__Dc =  __ld_u_4l_dup(__p);
	*__Dd =  __ld_u_4l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_4l(const UWord32* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd);
#endif 

	/*ID:  929, INST: ld.u.4l (Rn)+Rk,Dabcd*/

	/*ID:  930, INST: ld.u.4l (Rn),Dabcd*/

	/*ID:  931, INST: ld.u.4l (Rn)-,Dabcd*/

	/*ID:  932, INST: ld.u.4l (Rn+Rk),Dabcd*/

	/*ID:  933, INST: ld.u.4l (Rn+s16_t7),Dabcd*/

	/*ID:  934, INST: ld.u.8l (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_8l_dup(const UWord32* __p);
__attribute__((always_inline)) inline void __ld_u_8l(const UWord32* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd, UWord32* __De, UWord32* __Df, UWord32* __Dg, UWord32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord32 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_vunpack(*(__vec_8ul*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_u_8l_dup(__p);
	*__Db =  __ld_u_8l_dup(__p);
	*__Dc =  __ld_u_8l_dup(__p);
	*__Dd =  __ld_u_8l_dup(__p);
	*__De =  __ld_u_8l_dup(__p);
	*__Df =  __ld_u_8l_dup(__p);
	*__Dg =  __ld_u_8l_dup(__p);
	*__Dh =  __ld_u_8l_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_8l(const UWord32* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd, UWord32* __De, UWord32* __Df, UWord32* __Dg, UWord32* __Dh);
#endif 

	/*ID:  935, INST: ld.u.8l (Rn)+Rk,Da__Dh*/

	/*ID:  936, INST: ld.u.8l (Rn),Da__Dh*/

	/*ID:  937, INST: ld.u.8l (Rn)-,Da__Dh*/

	/*ID:  938, INST: ld.u.8l (Rn+Rk),Da__Dh*/

	/*ID:  939, INST: ld.u.8l (Rn+s16_t7),Da__Dh*/

	/*ID:  940, INST: ld.u.w (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_w_dup(const UWord16* __p);
__attribute__((always_inline)) inline void __ld_u_w(const UWord16* __p, UWord32* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	*__Da = *__p;
#else
	*__Da =  __ld_u_w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_w(const UWord16* __p, UWord32* __Da);
#endif 

	/*ID:  941, INST: ld.u.w (Rn)+,Ra*/

	/*ID:  942, INST: ld.u.w (Rn)+Rk,Da*/

	/*ID:  943, INST: ld.u.w (Rn)+Rk,Ra*/

	/*ID:  944, INST: ld.u.w (Rn),Da*/

	/*ID:  945, INST: ld.u.w (Rn),Ra*/

	/*ID:  946, INST: ld.u.w (Rn)-,Da*/

	/*ID:  947, INST: ld.u.w (Rn)-,Ra*/

	/*ID:  948, INST: ld.u.w (Rn+Rk),Da*/

	/*ID:  949, INST: ld.u.w (Rn+Rk),Ra*/

	/*ID:  950, INST: ld.u.w (Rn+s16_t7),Da*/

	/*ID:  951, INST: ld.u.w (Rn+s16_t7),Ra*/

	/*ID:  952, INST: ld.u.w (sp+s16_t7),Da*/

	/*ID:  953, INST: ld.u.w (sp+s16_t7),Ra*/

	/*ID:  954, INST: ld.u.w (sp-u9_1),Da*/

	/*ID:  955, INST: ld.u.w (sp-u9_1),Ra*/

	/*ID:  956, INST: ld.u.2w (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_2w_dup(const UWord16* __p);
__attribute__((always_inline)) inline void __ld_u_2w(const UWord16* __p, UWord32* __Da, UWord32* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord16 __t1, __t2;
	__builtin_vunpack(*(__vec_2uw*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld_u_2w_dup(__p);
	*__Db =  __ld_u_2w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_2w(const UWord16* __p, UWord32* __Da, UWord32* __Db);
#endif 

	/*ID:  957, INST: ld.u.2w (Rn)+,Rab*/

	/*ID:  958, INST: ld.u.2w (Rn)+Rk,Dab*/

	/*ID:  959, INST: ld.u.2w (Rn)+Rk,Rab*/

	/*ID:  960, INST: ld.u.2w (Rn),Dab*/

	/*ID:  961, INST: ld.u.2w (Rn),Rab*/

	/*ID:  962, INST: ld.u.2w (Rn)-,Dab*/

	/*ID:  963, INST: ld.u.2w (Rn)-,Rab*/

	/*ID:  964, INST: ld.u.2w (Rn+Rk),Dab*/

	/*ID:  965, INST: ld.u.2w (Rn+Rk),Rab*/

	/*ID:  966, INST: ld.u.2w (Rn+s16_t7),Dab*/

	/*ID:  967, INST: ld.u.2w (Rn+s16_t7),Rab*/

	/*ID:  968, INST: ld.u.4w (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_4w_dup(const UWord16* __p);
__attribute__((always_inline)) inline void __ld_u_4w(const UWord16* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord16 __t1, __t2, __t3, __t4;
	__builtin_vunpack(*(__vec_4uw*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld_u_4w_dup(__p);
	*__Db =  __ld_u_4w_dup(__p);
	*__Dc =  __ld_u_4w_dup(__p);
	*__Dd =  __ld_u_4w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_4w(const UWord16* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd);
#endif 

	/*ID:  969, INST: ld.u.4w (Rn)+,Rabcd*/

	/*ID:  970, INST: ld.u.4w (Rn)+Rk,Dabcd*/

	/*ID:  971, INST: ld.u.4w (Rn)+Rk,Rabcd*/

	/*ID:  972, INST: ld.u.4w (Rn),Dabcd*/

	/*ID:  973, INST: ld.u.4w (Rn),Rabcd*/

	/*ID:  974, INST: ld.u.4w (Rn)-,Dabcd*/

	/*ID:  975, INST: ld.u.4w (Rn)-,Rabcd*/

	/*ID:  976, INST: ld.u.4w (Rn+Rk),Dabcd*/

	/*ID:  977, INST: ld.u.4w (Rn+Rk),Rabcd*/

	/*ID:  978, INST: ld.u.4w (Rn+s16_t7),Dabcd*/

	/*ID:  979, INST: ld.u.4w (Rn+s16_t7),Rabcd*/

	/*ID:  980, INST: ld.u.8w (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
UWord32 __ld_u_8w_dup(const UWord16* __p);
__attribute__((always_inline)) inline void __ld_u_8w(const UWord16* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd, UWord32* __De, UWord32* __Df, UWord32* __Dg, UWord32* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord16 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_vunpack(*(__vec_8uw*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld_u_8w_dup(__p);
	*__Db =  __ld_u_8w_dup(__p);
	*__Dc =  __ld_u_8w_dup(__p);
	*__Dd =  __ld_u_8w_dup(__p);
	*__De =  __ld_u_8w_dup(__p);
	*__Df =  __ld_u_8w_dup(__p);
	*__Dg =  __ld_u_8w_dup(__p);
	*__Dh =  __ld_u_8w_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld_u_8w(const UWord16* __p, UWord32* __Da, UWord32* __Db, UWord32* __Dc, UWord32* __Dd, UWord32* __De, UWord32* __Df, UWord32* __Dg, UWord32* __Dh);
#endif 

	/*ID:  981, INST: ld.u.8w (Rn)+Rk,Da__Dh*/

	/*ID:  982, INST: ld.u.8w (Rn),Da__Dh*/

	/*ID:  983, INST: ld.u.8w (Rn)-,Da__Dh*/

	/*ID:  984, INST: ld.u.8w (Rn+Rk),Da__Dh*/

	/*ID:  985, INST: ld.u.8w (Rn+s16_t7),Da__Dh*/

	/*ID:  986, INST: ld2.2b (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_2b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_2b(const Word8* __p, Word40* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1;
	__builtin_load2((__vec_2b*)__p, __t1);
	*__Da = __t1;
#else
	*__Da =  __ld2_2b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_2b(const Word8* __p, Word40* __Da);
#endif 

	/*ID:  987, INST: ld2.2b (Rn)+Rk,Da*/

	/*ID:  988, INST: ld2.2b (Rn),Da*/

	/*ID:  989, INST: ld2.2b (Rn)-,Da*/

	/*ID:  990, INST: ld2.2b (Rn+Rk),Da*/

	/*ID:  991, INST: ld2.2b (Rn+s16_t7),Da*/

	/*ID:  992, INST: ld2.4b (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_4b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_4b(const Word8* __p, Word40* __Da, Word40* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2;
	__builtin_load2((__vec_4b*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld2_4b_dup(__p);
	*__Db =  __ld2_4b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_4b(const Word8* __p, Word40* __Da, Word40* __Db);
#endif 

	/*ID:  993, INST: ld2.4b (Rn)+Rk,Dab*/

	/*ID:  994, INST: ld2.4b (Rn),Dab*/

	/*ID:  995, INST: ld2.4b (Rn)-,Dab*/

	/*ID:  996, INST: ld2.4b (Rn+Rk),Dab*/

	/*ID:  997, INST: ld2.4b (Rn+s16_t7),Dab*/

	/*ID:  998, INST: ld2.8b (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_8b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_8b(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4;
	__builtin_load2((__vec_8b*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld2_8b_dup(__p);
	*__Db =  __ld2_8b_dup(__p);
	*__Dc =  __ld2_8b_dup(__p);
	*__Dd =  __ld2_8b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_8b(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd);
#endif 

	/*ID:  999, INST: ld2.8b (Rn)+Rk,Dabcd*/

	/*ID: 1000, INST: ld2.8b (Rn),Dabcd*/

	/*ID: 1001, INST: ld2.8b (Rn)-,Dabcd*/

	/*ID: 1002, INST: ld2.8b (Rn+Rk),Dabcd*/

	/*ID: 1003, INST: ld2.8b (Rn+s16_t7),Dabcd*/

	/*ID: 1004, INST: ld2.16b (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_16b_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_16b(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_load2((__vec_16b*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld2_16b_dup(__p);
	*__Db =  __ld2_16b_dup(__p);
	*__Dc =  __ld2_16b_dup(__p);
	*__Dd =  __ld2_16b_dup(__p);
	*__De =  __ld2_16b_dup(__p);
	*__Df =  __ld2_16b_dup(__p);
	*__Dg =  __ld2_16b_dup(__p);
	*__Dh =  __ld2_16b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_16b(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh);
#endif 

	/*ID: 1005, INST: ld2.16b (Rn)+Rk,Da__Dh*/

	/*ID: 1006, INST: ld2.16b (Rn),Da__Dh*/

	/*ID: 1007, INST: ld2.16b (Rn)-,Da__Dh*/

	/*ID: 1008, INST: ld2.16b (Rn+Rk),Da__Dh*/

	/*ID: 1009, INST: ld2.16b (Rn+s16_t7),Da__Dh*/

	/*ID: 1010, INST: ld2.2bf (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_2bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_2bf(const Word8* __p, Word40* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1;
	__builtin_load2f((__vec_2b*)__p, __t1);
	*__Da = __t1;
#else
	*__Da =  __ld2_2bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_2bf(const Word8* __p, Word40* __Da);
#endif 

	/*ID: 1011, INST: ld2.2bf (Rn)+Rk,Da*/

	/*ID: 1012, INST: ld2.2bf (Rn),Da*/

	/*ID: 1013, INST: ld2.2bf (Rn)-,Da*/

	/*ID: 1014, INST: ld2.2bf (Rn+Rk),Da*/

	/*ID: 1015, INST: ld2.2bf (Rn+s16_t7),Da*/

	/*ID: 1016, INST: ld2.4bf (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_4bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_4bf(const Word8* __p, Word40* __Da, Word40* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2;
	__builtin_load2f((__vec_4b*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld2_4bf_dup(__p);
	*__Db =  __ld2_4bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_4bf(const Word8* __p, Word40* __Da, Word40* __Db);
#endif 

	/*ID: 1017, INST: ld2.4bf (Rn)+Rk,Dab*/

	/*ID: 1018, INST: ld2.4bf (Rn),Dab*/

	/*ID: 1019, INST: ld2.4bf (Rn)-,Dab*/

	/*ID: 1020, INST: ld2.4bf (Rn+Rk),Dab*/

	/*ID: 1021, INST: ld2.4bf (Rn+s16_t7),Dab*/

	/*ID: 1022, INST: ld2.8bf (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_8bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_8bf(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4;
	__builtin_load2f((__vec_8b*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld2_8bf_dup(__p);
	*__Db =  __ld2_8bf_dup(__p);
	*__Dc =  __ld2_8bf_dup(__p);
	*__Dd =  __ld2_8bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_8bf(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd);
#endif 

	/*ID: 1023, INST: ld2.8bf (Rn)+Rk,Dabcd*/

	/*ID: 1024, INST: ld2.8bf (Rn),Dabcd*/

	/*ID: 1025, INST: ld2.8bf (Rn)-,Dabcd*/

	/*ID: 1026, INST: ld2.8bf (Rn+Rk),Dabcd*/

	/*ID: 1027, INST: ld2.8bf (Rn+s16_t7),Dabcd*/

	/*ID: 1028, INST: ld2.16bf (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_16bf_dup(const Word8* __p);
__attribute__((always_inline)) inline void __ld2_16bf(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_load2f((__vec_16b*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld2_16bf_dup(__p);
	*__Db =  __ld2_16bf_dup(__p);
	*__Dc =  __ld2_16bf_dup(__p);
	*__Dd =  __ld2_16bf_dup(__p);
	*__De =  __ld2_16bf_dup(__p);
	*__Df =  __ld2_16bf_dup(__p);
	*__Dg =  __ld2_16bf_dup(__p);
	*__Dh =  __ld2_16bf_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_16bf(const Word8* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh);
#endif 

	/*ID: 1029, INST: ld2.16bf (Rn)+Rk,Da__Dh*/

	/*ID: 1030, INST: ld2.16bf (Rn),Da__Dh*/

	/*ID: 1031, INST: ld2.16bf (Rn)-,Da__Dh*/

	/*ID: 1032, INST: ld2.16bf (Rn+Rk),Da__Dh*/

	/*ID: 1033, INST: ld2.16bf (Rn+s16_t7),Da__Dh*/

	/*ID: 1034, INST: ld2.2f (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_2f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld2_2f(const Word16* __p, Word40* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1;
	__builtin_load2f((__vec_2w*)__p, __t1);
	*__Da = __t1;
#else
	*__Da =  __ld2_2f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_2f(const Word16* __p, Word40* __Da);
#endif 

	/*ID: 1035, INST: ld2.2f (Rn)+Rk,Da*/

	/*ID: 1036, INST: ld2.2f (Rn),Da*/

	/*ID: 1037, INST: ld2.2f (Rn)-,Da*/

	/*ID: 1038, INST: ld2.2f (Rn+Rk),Da*/

	/*ID: 1039, INST: ld2.2f (Rn+s16_t7),Da*/

	/*ID: 1040, INST: ld2.4f (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_4f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld2_4f(const Word16* __p, Word40* __Da, Word40* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2;
	__builtin_load2f((__vec_4w*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld2_4f_dup(__p);
	*__Db =  __ld2_4f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_4f(const Word16* __p, Word40* __Da, Word40* __Db);
#endif 

	/*ID: 1041, INST: ld2.4f (Rn)+Rk,Dab*/

	/*ID: 1042, INST: ld2.4f (Rn),Dab*/

	/*ID: 1043, INST: ld2.4f (Rn)-,Dab*/

	/*ID: 1044, INST: ld2.4f (Rn+Rk),Dab*/

	/*ID: 1045, INST: ld2.4f (Rn+s16_t7),Dab*/

	/*ID: 1046, INST: ld2.8f (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_8f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld2_8f(const Word16* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4;
	__builtin_load2f((__vec_8w*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld2_8f_dup(__p);
	*__Db =  __ld2_8f_dup(__p);
	*__Dc =  __ld2_8f_dup(__p);
	*__Dd =  __ld2_8f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_8f(const Word16* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd);
#endif 

	/*ID: 1047, INST: ld2.8f (Rn)+,Dacdb*/

	/*ID: 1048, INST: ld2.8f (Rn)+Rk,Dabcd*/

	/*ID: 1049, INST: ld2.8f (Rn)+Rk,Dacdb*/

	/*ID: 1050, INST: ld2.8f (Rn),Dabcd*/

	/*ID: 1051, INST: ld2.8f (Rn),Dacdb*/

	/*ID: 1052, INST: ld2.8f (Rn)-,Dabcd*/

	/*ID: 1053, INST: ld2.8f (Rn)-,Dacdb*/

	/*ID: 1054, INST: ld2.8f (Rn+Rk),Dabcd*/

	/*ID: 1055, INST: ld2.8f (Rn+Rk),Dacdb*/

	/*ID: 1056, INST: ld2.8f (Rn+s16_t7),Dabcd*/

	/*ID: 1057, INST: ld2.8f (Rn+s16_t7),Dacdb*/

	/*ID: 1058, INST: ld2.16f (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_16f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld2_16f(const Word16* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	Word40 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_load2f((__vec_16w*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld2_16f_dup(__p);
	*__Db =  __ld2_16f_dup(__p);
	*__Dc =  __ld2_16f_dup(__p);
	*__Dd =  __ld2_16f_dup(__p);
	*__De =  __ld2_16f_dup(__p);
	*__Df =  __ld2_16f_dup(__p);
	*__Dg =  __ld2_16f_dup(__p);
	*__Dh =  __ld2_16f_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_16f(const Word16* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh);
#endif 

	/*ID: 1059, INST: ld2.16f (Rn)+,Da__DhMod8*/

	/*ID: 1060, INST: ld2.16f (Rn)+,Da__DhMod8p*/

	/*ID: 1061, INST: ld2.16f (Rn)+,Da__DhR3*/

	/*ID: 1062, INST: ld2.16f (Rn)+,Da__DhR5*/

	/*ID: 1063, INST: ld2.16f (Rn)+Rk,Da__Dh*/

	/*ID: 1064, INST: ld2.16f (Rn)+Rk,Da__DhMod8*/

	/*ID: 1065, INST: ld2.16f (Rn)+Rk,Da__DhMod8p*/

	/*ID: 1066, INST: ld2.16f (Rn)+Rk,Da__DhR3*/

	/*ID: 1067, INST: ld2.16f (Rn)+Rk,Da__DhR5*/

	/*ID: 1068, INST: ld2.16f (Rn),Da__Dh*/

	/*ID: 1069, INST: ld2.16f (Rn),Da__DhMod8*/

	/*ID: 1070, INST: ld2.16f (Rn),Da__DhMod8p*/

	/*ID: 1071, INST: ld2.16f (Rn),Da__DhR3*/

	/*ID: 1072, INST: ld2.16f (Rn),Da__DhR5*/

	/*ID: 1073, INST: ld2.16f (Rn)-,Da__Dh*/

	/*ID: 1074, INST: ld2.16f (Rn)-,Da__DhMod8*/

	/*ID: 1075, INST: ld2.16f (Rn)-,Da__DhMod8p*/

	/*ID: 1076, INST: ld2.16f (Rn)-,Da__DhR3*/

	/*ID: 1077, INST: ld2.16f (Rn)-,Da__DhR5*/

	/*ID: 1078, INST: ld2.16f (Rn+Rk),Da__Dh*/

	/*ID: 1079, INST: ld2.16f (Rn+Rk),Da__DhMod8*/

	/*ID: 1080, INST: ld2.16f (Rn+Rk),Da__DhMod8p*/

	/*ID: 1081, INST: ld2.16f (Rn+Rk),Da__DhR3*/

	/*ID: 1082, INST: ld2.16f (Rn+Rk),Da__DhR5*/

	/*ID: 1083, INST: ld2.16f (Rn+s16_t7),Da__Dh*/

	/*ID: 1084, INST: ld2.16f (Rn+s16_t7),Da__DhMod8*/

	/*ID: 1085, INST: ld2.16f (Rn+s16_t7),Da__DhMod8p*/

	/*ID: 1086, INST: ld2.16f (Rn+s16_t7),Da__DhR3*/

	/*ID: 1087, INST: ld2.16f (Rn+s16_t7),Da__DhR5*/

	/*ID: 1088, INST: ld2.32f (Rn)+,Da__Dp*/
#ifndef _HOST_EMULATION_ 
Word40 __ld2_32f_dup(const Word16* __p);
__attribute__((always_inline)) inline void __ld2_32f(const Word16* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh, Word40* __Di, Word40* __Dj, Word40* __Dk, Word40* __Dl, Word40* __Dm, Word40* __Dn, Word40* __Do, Word40* __Dp)
{
	*__Da =  __ld2_32f_dup(__p);
	*__Db =  __ld2_32f_dup(__p);
	*__Dc =  __ld2_32f_dup(__p);
	*__Dd =  __ld2_32f_dup(__p);
	*__De =  __ld2_32f_dup(__p);
	*__Df =  __ld2_32f_dup(__p);
	*__Dg =  __ld2_32f_dup(__p);
	*__Dh =  __ld2_32f_dup(__p);
	*__Di =  __ld2_32f_dup(__p);
	*__Dj =  __ld2_32f_dup(__p);
	*__Dk =  __ld2_32f_dup(__p);
	*__Dl =  __ld2_32f_dup(__p);
	*__Dm =  __ld2_32f_dup(__p);
	*__Dn =  __ld2_32f_dup(__p);
	*__Do =  __ld2_32f_dup(__p);
	*__Dp =  __ld2_32f_dup(__p);
}
#else 
PROTOTYPE_API void __ld2_32f(const Word16* __p, Word40* __Da, Word40* __Db, Word40* __Dc, Word40* __Dd, Word40* __De, Word40* __Df, Word40* __Dg, Word40* __Dh, Word40* __Di, Word40* __Dj, Word40* __Dk, Word40* __Dl, Word40* __Dm, Word40* __Dn, Word40* __Do, Word40* __Dp);
#endif 

	/*ID: 1089, INST: ld2.32f (Rn)+,Da__DpMod16*/

	/*ID: 1090, INST: ld2.32f (Rn)+Rk,Da__Dp*/

	/*ID: 1091, INST: ld2.32f (Rn)+Rk,Da__DpMod16*/

	/*ID: 1092, INST: ld2.32f (Rn),Da__Dp*/

	/*ID: 1093, INST: ld2.32f (Rn),Da__DpMod16*/

	/*ID: 1094, INST: ld2.32f (Rn)-,Da__Dp*/

	/*ID: 1095, INST: ld2.32f (Rn)-,Da__DpMod16*/

	/*ID: 1096, INST: ld2.32f (Rn+Rk),Da__Dp*/

	/*ID: 1097, INST: ld2.32f (Rn+Rk),Da__DpMod16*/

	/*ID: 1098, INST: ld2.32f (Rn+s16_t7),Da__Dp*/

	/*ID: 1099, INST: ld2.32f (Rn+s16_t7),Da__DpMod16*/

	/*ID: 1100, INST: ld2.u.2b (Rn)+,Da*/
#ifndef _HOST_EMULATION_ 
UWord40 __ld2_u_2b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld2_u_2b(const UWord8* __p, UWord40* __Da)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord40 __t1;
	__builtin_load2((__vec_2ub*)__p, __t1);
	*__Da = __t1;
#else
	*__Da =  __ld2_u_2b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_u_2b(const UWord8* __p, UWord40* __Da);
#endif 

	/*ID: 1101, INST: ld2.u.2b (Rn)+Rk,Da*/

	/*ID: 1102, INST: ld2.u.2b (Rn),Da*/

	/*ID: 1103, INST: ld2.u.2b (Rn)-,Da*/

	/*ID: 1104, INST: ld2.u.2b (Rn+Rk),Da*/

	/*ID: 1105, INST: ld2.u.2b (Rn+s16_t7),Da*/

	/*ID: 1106, INST: ld2.u.4b (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
UWord40 __ld2_u_4b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld2_u_4b(const UWord8* __p, UWord40* __Da, UWord40* __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord40 __t1, __t2;
	__builtin_load2((__vec_4ub*)__p, __t1, __t2);
	*__Da = __t1;
	*__Db = __t2;
#else
	*__Da =  __ld2_u_4b_dup(__p);
	*__Db =  __ld2_u_4b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_u_4b(const UWord8* __p, UWord40* __Da, UWord40* __Db);
#endif 

	/*ID: 1107, INST: ld2.u.4b (Rn)+Rk,Dab*/

	/*ID: 1108, INST: ld2.u.4b (Rn),Dab*/

	/*ID: 1109, INST: ld2.u.4b (Rn)-,Dab*/

	/*ID: 1110, INST: ld2.u.4b (Rn+Rk),Dab*/

	/*ID: 1111, INST: ld2.u.4b (Rn+s16_t7),Dab*/

	/*ID: 1112, INST: ld2.u.8b (Rn)+,Dabcd*/
#ifndef _HOST_EMULATION_ 
UWord40 __ld2_u_8b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld2_u_8b(const UWord8* __p, UWord40* __Da, UWord40* __Db, UWord40* __Dc, UWord40* __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord40 __t1, __t2, __t3, __t4;
	__builtin_load2((__vec_8ub*)__p, __t1, __t2, __t3, __t4);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
#else
	*__Da =  __ld2_u_8b_dup(__p);
	*__Db =  __ld2_u_8b_dup(__p);
	*__Dc =  __ld2_u_8b_dup(__p);
	*__Dd =  __ld2_u_8b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_u_8b(const UWord8* __p, UWord40* __Da, UWord40* __Db, UWord40* __Dc, UWord40* __Dd);
#endif 

	/*ID: 1113, INST: ld2.u.8b (Rn)+Rk,Dabcd*/

	/*ID: 1114, INST: ld2.u.8b (Rn),Dabcd*/

	/*ID: 1115, INST: ld2.u.8b (Rn)-,Dabcd*/

	/*ID: 1116, INST: ld2.u.8b (Rn+Rk),Dabcd*/

	/*ID: 1117, INST: ld2.u.8b (Rn+s16_t7),Dabcd*/

	/*ID: 1118, INST: ld2.u.16b (Rn)+,Da__Dh*/
#ifndef _HOST_EMULATION_ 
UWord40 __ld2_u_16b_dup(const UWord8* __p);
__attribute__((always_inline)) inline void __ld2_u_16b(const UWord8* __p, UWord40* __Da, UWord40* __Db, UWord40* __Dc, UWord40* __Dd, UWord40* __De, UWord40* __Df, UWord40* __Dg, UWord40* __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	UWord40 __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8;
	__builtin_load2((__vec_16ub*)__p, __t1, __t2, __t3, __t4, __t5, __t6, __t7, __t8);
	*__Da = __t1;
	*__Db = __t2;
	*__Dc = __t3;
	*__Dd = __t4;
	*__De = __t5;
	*__Df = __t6;
	*__Dg = __t7;
	*__Dh = __t8;
#else
	*__Da =  __ld2_u_16b_dup(__p);
	*__Db =  __ld2_u_16b_dup(__p);
	*__Dc =  __ld2_u_16b_dup(__p);
	*__Dd =  __ld2_u_16b_dup(__p);
	*__De =  __ld2_u_16b_dup(__p);
	*__Df =  __ld2_u_16b_dup(__p);
	*__Dg =  __ld2_u_16b_dup(__p);
	*__Dh =  __ld2_u_16b_dup(__p);
#endif
}
#else 
PROTOTYPE_API void __ld2_u_16b(const UWord8* __p, UWord40* __Da, UWord40* __Db, UWord40* __Dc, UWord40* __Dd, UWord40* __De, UWord40* __Df, UWord40* __Dg, UWord40* __Dh);
#endif 

	/*ID: 1119, INST: ld2.u.16b (Rn)+Rk,Da__Dh*/

	/*ID: 1120, INST: ld2.u.16b (Rn),Da__Dh*/

	/*ID: 1121, INST: ld2.u.16b (Rn)-,Da__Dh*/

	/*ID: 1122, INST: ld2.u.16b (Rn+Rk),Da__Dh*/

	/*ID: 1123, INST: ld2.u.16b (Rn+s16_t7),Da__Dh*/

	/*ID: 1124, INST: ldrstc*/

	/*ID: 1125, INST: ldsh2.dn.2f (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word40 __ldsh2_dn_2f_dup(Word40 __Dab, const Word16* __p);
__attribute__((always_inline)) inline void __ldsh2_dn_2f(const Word16* __p, Word40* __Da, Word40* __Db)
{
	Word40 __tmp = *__Da;
	*__Da =  __ldsh2_dn_2f_dup(*__Da, __p);
	*__Db =  __ldsh2_dn_2f_dup(__tmp, __p);
}
#else 
PROTOTYPE_API void __ldsh2_dn_2f(const Word16* __p, Word40* __Da, Word40* __Db);
#endif 

	/*ID: 1126, INST: ldsh2.dn.2f (Rn)+Rk,Dab*/

	/*ID: 1127, INST: ldsh2.dn.2f (Rn),Dab*/

	/*ID: 1128, INST: ldsh2.dn.2f (Rn)-,Dab*/

	/*ID: 1129, INST: ldsh2.dn.2f (Rn+Rk),Dab*/

	/*ID: 1130, INST: ldsh2.dn.2f (Rn+s16_t7),Dab*/

	/*ID: 1131, INST: ldsh2.dn.2f (sp+s16_t7),Dab*/

	/*ID: 1132, INST: ldsh2.up.2f (Rn)+,Dab*/
#ifndef _HOST_EMULATION_ 
Word40 __ldsh2_up_2f_dup(Word40 __Dab, const Word16* __p);
__attribute__((always_inline)) inline void __ldsh2_up_2f(const Word16* __p, Word40* __Da, Word40* __Db)
{
	Word40 __tmp = *__Da;
	*__Da =  __ldsh2_up_2f_dup(*__Da, __p);
	*__Db =  __ldsh2_up_2f_dup(__tmp, __p);
}
#else 
PROTOTYPE_API void __ldsh2_up_2f(const Word16* __p, Word40* __Da, Word40* __Db);
#endif 

	/*ID: 1133, INST: ldsh2.up.2f (Rn)+Rk,Dab*/

	/*ID: 1134, INST: ldsh2.up.2f (Rn),Dab*/

	/*ID: 1135, INST: ldsh2.up.2f (Rn)-,Dab*/

	/*ID: 1136, INST: ldsh2.up.2f (Rn+Rk),Dab*/

	/*ID: 1137, INST: ldsh2.up.2f (Rn+s16_t7),Dab*/

	/*ID: 1138, INST: ldsh2.up.2f (sp+s16_t7),Dab*/

	/*ID: 1139, INST: lextc.lft.x Da,Db*/

	/*ID: 1140, INST: lextc.rgt.l Da,Db*/

	/*ID: 1141, INST: lextc.rgt.x Da,Db*/

	/*ID: 1142, INST: log2 Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __log2_dup(Word32 __Da);
__attribute__((always_inline)) inline void __log2(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __log2_dup(__Da);
	*__Dn =  __log2_dup(__Da);
}
#else 
PROTOTYPE_API void __log2(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1143, INST: lpend.2 RelAdd19_t2*/

	/*ID: 1144, INST: lpend.1 RelAdd19_t2*/

	/*ID: 1145, INST: lpend.3 RelAdd19_t2*/

	/*ID: 1146, INST: lpend.0 RelAdd19_t2*/

	/*ID: 1147, INST: lpend.sq0 RelAdd19_t2*/

	/*ID: 1148, INST: lpend.sq1 RelAdd19_t2*/

	/*ID: 1149, INST: lpend.sq2 RelAdd19_t2*/

	/*ID: 1150, INST: lpend.sq3 RelAdd19_t2*/

	/*ID: 1151, INST: lpskip.2 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1152, INST: lpskip.1 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1153, INST: lpskip.3 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1154, INST: lpskip.0 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1155, INST: lpskip.sq0 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1156, INST: lpskip.sq1 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1157, INST: lpskip.sq2 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1158, INST: lpskip.sq3 RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1159, INST: lpskip.0.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1160, INST: lpskip.1.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1161, INST: lpskip.2.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1162, INST: lpskip.3.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1163, INST: lpskip.sq0.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1164, INST: lpskip.sq1.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1165, INST: lpskip.sq2.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1166, INST: lpskip.sq3.u RelAdd19_t3,URRelAdd4_t3*/

	/*ID: 1167, INST: lpst.2 RelAdd19_t2*/

	/*ID: 1168, INST: lpst.1 RelAdd19_t2*/

	/*ID: 1169, INST: lpst.3 RelAdd19_t2*/

	/*ID: 1170, INST: lpst.0 RelAdd19_t2*/

	/*ID: 1171, INST: lpst.sq0 RelAdd19_t2*/

	/*ID: 1172, INST: lpst.sq1 RelAdd19_t2*/

	/*ID: 1173, INST: lpst.sq2 RelAdd19_t2*/

	/*ID: 1174, INST: lpst.sq3 RelAdd19_t2*/

	/*ID: 1175, INST: lsh.lft.l Da,Db,Dn*/
PROTOTYPE_API Word32 __lsh_lft_l(Word32 __Da, Word32 __Db);

	/*ID: 1176, INST: lsh.lft.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __lsh_lft_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __lsh_lft_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __lsh_lft_2l_dup(__Da, __Dc);
	*__Dn =  __lsh_lft_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __lsh_lft_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1177, INST: lsh.lft.ll Da,Dcd,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __lsh_lft_ll(Word32 __Da, Int64 __Dcd);
#endif

	/*ID: 1178, INST: lsh.lft.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __lsh_lft_2w(Word32 __Da, Word32 __Db);

	/*ID: 1179, INST: lsh.lft.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __lsh_lft_4w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __lsh_lft_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __lsh_lft_4w_dup(__Da, __Dc);
	*__Dn =  __lsh_lft_4w_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __lsh_lft_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1180, INST: lsh.lft.x Da,Db,Dn*/
PROTOTYPE_API Word40 __lsh_lft_x(Word32 __Da, Word40 __Db);

	/*ID: 1181, INST: lsh.lft.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __lsh_lft_2x_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __lsh_lft_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __lsh_lft_2x_dup(__Da, __Dc);
	*__Dn =  __lsh_lft_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __lsh_lft_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1182, INST: lsh.rgt.l Da,Db,Dn*/
PROTOTYPE_API Word32 __lsh_rgt_l(Word32 __Da, Word32 __Db);

	/*ID: 1183, INST: lsh.rgt.l #u5,Da,Dn*/

	/*ID: 1184, INST: lsh.rgt.2l Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __lsh_rgt_2l_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __lsh_rgt_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __lsh_rgt_2l_dup(__Da, __Dc);
	*__Dn =  __lsh_rgt_2l_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __lsh_rgt_2l(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1185, INST: lsh.rgt.2l #u5,Dab,Dmn*/

	/*ID: 1186, INST: lsh.rgt.ll Da,Dcd,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __lsh_rgt_ll(Word32 __Da, Int64 __Dcd);
#endif

	/*ID: 1187, INST: lsh.rgt.ll #u6_t3,Dab,Dmn*/

	/*ID: 1188, INST: lsh.rgt.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __lsh_rgt_2w(Word32 __Da, Word32 __Db);

	/*ID: 1189, INST: lsh.rgt.2w #u5,Da,Dn*/

	/*ID: 1190, INST: lsh.rgt.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __lsh_rgt_4w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __lsh_rgt_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __lsh_rgt_4w_dup(__Da, __Dc);
	*__Dn =  __lsh_rgt_4w_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __lsh_rgt_4w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1191, INST: lsh.rgt.4w #u4,Dab,Dmn*/

	/*ID: 1192, INST: lsh.rgt.x Da,Db,Dn*/
PROTOTYPE_API Word40 __lsh_rgt_x(Word32 __Da, Word40 __Db);

	/*ID: 1193, INST: lsh.rgt.x #ue5,Da,Dn*/

	/*ID: 1194, INST: lsh.rgt.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __lsh_rgt_2x_dup(Word32 __Da, Word40 __Dcd);
__attribute__((always_inline)) inline void __lsh_rgt_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __lsh_rgt_2x_dup(__Da, __Dc);
	*__Dn =  __lsh_rgt_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __lsh_rgt_2x(Word32 __Da, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1195, INST: lsh.rgt.2x #ue5,Dab,Dmn*/

	/*ID: 1196, INST: lsha.lft Ra,Rb,Rn*/
PROTOTYPE_API Word32 __lsha_lft(Word32 __Ra, Word32 __Rb);

	/*ID: 1197, INST: lsha.rgt Ra,Rb,Rn*/
PROTOTYPE_API Word32 __lsha_rgt(Word32 __Ra, Word32 __Rb);

	/*ID: 1198, INST: lsha.rgt #u5,Ra,Rn*/

	/*ID: 1199, INST: lsha.rgt #u5,Ra,Rn*/

	/*ID: 1200, INST: mac.2t Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac_2t_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_2t_read(Word32 __Da, Word32 __Db);
#define __mac_2t(__Dn, __Da, __Db) __mac_2t_aux(__mac_2t_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1201, INST: mac.2t -Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_2t_m(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac_2t_m_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_2t_m_read(Word32 __Da, Word32 __Db);
#define __mac_2t_m(__Dn, __Da, __Db) __mac_2t_m_aux(__mac_2t_m_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac_2t_m(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1202, INST: mac.x #s16_t2,Da.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_x_h(Word40 __Dn, Word32 __imm1, Word32 __Da_h);
Word40 __mac_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_x_h_read(Word32 __imm1, Word32 __Da_h);
#define __mac_x_h(__Dn, __imm1, __Da_h) __mac_x_h_aux(__mac_x_h_read(__imm1, __Da_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_x_h(Word40 __Dn, Word32 __imm1, Word32 __Da_h);
#endif 

	/*ID: 1203, INST: mac.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __mac_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __mac_x_hh(__Dn, __Da_h, __Db_h) __mac_x_hh_aux(__mac_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1204, INST: mac.x #s16_t2,Da.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_x_l(Word40 __Dn, Word32 __imm1, Word32 __Da_l);
Word40 __mac_x_l_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_x_l_read(Word32 __imm1, Word32 __Da_l);
#define __mac_x_l(__Dn, __imm1, __Da_l) __mac_x_l_aux(__mac_x_l_read(__imm1, __Da_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_x_l(Word40 __Dn, Word32 __imm1, Word32 __Da_l);
#endif 

	/*ID: 1205, INST: mac.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_x_ll(__Dn, __Da_l, __Db_l) __mac_x_ll_aux(__mac_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1206, INST: mac.x Da.h,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_x_hl(Word40 __Dn, Word32 __Da_h, Word32 __Db_l);
Word40 __mac_x_hl_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_x_hl_read(Word32 __Da_h, Word32 __Db_l);
#define __mac_x_hl(__Dn, __Da_h, __Db_l) __mac_x_hl_aux(__mac_x_hl_read(__Da_h, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_x_hl(Word40 __Dn, Word32 __Da_h, Word32 __Db_l);
#endif 

	/*ID: 1207, INST: mac.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __mac_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_2x_dup_read(Word32 __Da, Word32 __Db);
#define __mac_2x_dup(__Dmn, __Da, __Db) __mac_2x_dup_aux(__mac_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __mac_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __mac_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __mac_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1208, INST: mac.h.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_h_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __mac_h_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_h_2x_dup_read(Word32 __Da, Word32 __Db);
#define __mac_h_2x_dup(__Dmn, __Da, __Db) __mac_h_2x_dup_aux(__mac_h_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __mac_h_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_h_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __mac_h_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __mac_h_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1209, INST: mac.h.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_h_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __mac_h_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_h_s_2x_dup_read(Word32 __Da, Word32 __Db);
#define __mac_h_s_2x_dup(__Dmn, __Da, __Db) __mac_h_s_2x_dup_aux(__mac_h_s_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __mac_h_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_h_s_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __mac_h_s_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __mac_h_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1210, INST: mac.hh.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_hh_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac_hh_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_hh_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_hh_2x_dup(__Dmn, __Dab, __Dcd) __mac_hh_2x_dup_aux(__mac_hh_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_hh_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_hh_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_hh_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_hh_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1211, INST: mac.hh.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_hh_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac_hh_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_hh_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_hh_s_2x_dup(__Dmn, __Dab, __Dcd) __mac_hh_s_2x_dup_aux(__mac_hh_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_hh_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_hh_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_hh_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_hh_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1212, INST: mac.i.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mac_i_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __mac_i_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __mac_i_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_i_4w_dup(__Dmn, __Dab, __Dcd) __mac_i_4w_dup_aux(__mac_i_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_i_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mac_i_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_i_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_i_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1213, INST: mac.i.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_i_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_i_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_i_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_i_x_ll(__Dn, __Da_l, __Db_l) __mac_i_x_ll_aux(__mac_i_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_i_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1214, INST: mac.i.x -Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_i_x_m_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_i_x_m_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_i_x_m_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_i_x_m_ll(__Dn, __Da_l, __Db_l) __mac_i_x_m_ll_aux(__mac_i_x_m_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_i_x_m_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1215, INST: mac.l.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_l_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __mac_l_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_l_2x_dup_read(Word32 __Da, Word32 __Db);
#define __mac_l_2x_dup(__Dmn, __Da, __Db) __mac_l_2x_dup_aux(__mac_l_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __mac_l_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_l_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __mac_l_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __mac_l_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1216, INST: mac.l.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_l_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __mac_l_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_l_s_2x_dup_read(Word32 __Da, Word32 __Db);
#define __mac_l_s_2x_dup(__Dmn, __Da, __Db) __mac_l_s_2x_dup_aux(__mac_l_s_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __mac_l_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_l_s_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __mac_l_s_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __mac_l_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1217, INST: mac.leg.x #s16_t2,Da.h,Dn*/

	/*ID: 1218, INST: mac.leg.x Da.h,Db.h,Dn*/

	/*ID: 1219, INST: mac.leg.x #s16_t2,Da.l,Dn*/

	/*ID: 1220, INST: mac.leg.x Da.l,Db.l,Dn*/

	/*ID: 1221, INST: mac.leg.x Da.h,Db.l,Dn*/

	/*ID: 1222, INST: mac.leg.x -Da.h,Db.h,Dn*/

	/*ID: 1223, INST: mac.leg.x -Da.l,Db.l,Dn*/

	/*ID: 1224, INST: mac.leg.x -Da.h,Db.l,Dn*/

	/*ID: 1225, INST: mac.ll.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_ll_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac_ll_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_ll_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_ll_2x_dup(__Dmn, __Dab, __Dcd) __mac_ll_2x_dup_aux(__mac_ll_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_ll_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_ll_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_ll_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_ll_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1226, INST: mac.ll.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_ll_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac_ll_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_ll_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_ll_i_2x_dup(__Dmn, __Dab, __Dcd) __mac_ll_i_2x_dup_aux(__mac_ll_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_ll_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_ll_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_ll_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_ll_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1227, INST: mac.ll.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_ll_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac_ll_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_ll_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_ll_s_2x_dup(__Dmn, __Dab, __Dcd) __mac_ll_s_2x_dup_aux(__mac_ll_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_ll_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_ll_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_ll_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_ll_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1228, INST: mac.r.2t Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_r_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac_r_2t_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_r_2t_read(Word32 __Da, Word32 __Db);
#define __mac_r_2t(__Dn, __Da, __Db) __mac_r_2t_aux(__mac_r_2t_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac_r_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1229, INST: mac.r.2t -Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_r_2t_m(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac_r_2t_m_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_r_2t_m_read(Word32 __Da, Word32 __Db);
#define __mac_r_2t_m(__Dn, __Da, __Db) __mac_r_2t_m_aux(__mac_r_2t_m_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac_r_2t_m(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1230, INST: mac.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_r_4t_dup(__Dmn, __Dab, __Dcd) __mac_r_4t_dup_aux(__mac_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1231, INST: mac.r.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_r_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __mac_r_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_r_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __mac_r_x_hh(__Dn, __Da_h, __Db_h) __mac_r_x_hh_aux(__mac_r_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_r_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1232, INST: mac.r.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_r_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_r_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_r_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_r_x_ll(__Dn, __Da_l, __Db_l) __mac_r_x_ll_aux(__mac_r_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_r_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1233, INST: mac.r.x Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_r_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
Word40 __mac_r_x_lh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_r_x_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __mac_r_x_lh(__Dn, __Da_l, __Db_h) __mac_r_x_lh_aux(__mac_r_x_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_r_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1234, INST: mac.rleg.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_rleg_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __mac_rleg_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_rleg_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __mac_rleg_x_hh(__Dn, __Da_h, __Db_h) __mac_rleg_x_hh_aux(__mac_rleg_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_rleg_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1235, INST: mac.rleg.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_rleg_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_rleg_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_rleg_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_rleg_x_ll(__Dn, __Da_l, __Db_l) __mac_rleg_x_ll_aux(__mac_rleg_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_rleg_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1236, INST: mac.rleg.x Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_rleg_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
Word40 __mac_rleg_x_lh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_rleg_x_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __mac_rleg_x_lh(__Dn, __Da_l, __Db_h) __mac_rleg_x_lh_aux(__mac_rleg_x_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_rleg_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1237, INST: mac.rleg.x -Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_rleg_x_m_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __mac_rleg_x_m_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_rleg_x_m_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __mac_rleg_x_m_hh(__Dn, __Da_h, __Db_h) __mac_rleg_x_m_hh_aux(__mac_rleg_x_m_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_rleg_x_m_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1238, INST: mac.rleg.x -Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_rleg_x_m_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_rleg_x_m_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_rleg_x_m_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_rleg_x_m_ll(__Dn, __Da_l, __Db_l) __mac_rleg_x_m_ll_aux(__mac_rleg_x_m_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_rleg_x_m_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1239, INST: mac.rleg.x -Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_rleg_x_m_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
Word40 __mac_rleg_x_m_lh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_rleg_x_m_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __mac_rleg_x_m_lh(__Dn, __Da_l, __Db_h) __mac_rleg_x_m_lh_aux(__mac_rleg_x_m_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_rleg_x_m_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1240, INST: mac.s.2w Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mac_s_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __mac_s_2w_aux(Word32 __Dres, Word32 __Dn);
Word32 __mac_s_2w_read(Word32 __Da, Word32 __Db);
#define __mac_s_2w(__Dn, __Da, __Db) __mac_s_2w_aux(__mac_s_2w_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __mac_s_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1241, INST: mac.s.x #s16_t2,Da.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_s_x_h(Word40 __Dn, Word32 __imm1, Word32 __Da_h);
Word40 __mac_s_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_s_x_h_read(Word32 __imm1, Word32 __Da_h);
#define __mac_s_x_h(__Dn, __imm1, __Da_h) __mac_s_x_h_aux(__mac_s_x_h_read(__imm1, __Da_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_s_x_h(Word40 __Dn, Word32 __imm1, Word32 __Da_h);
#endif 

	/*ID: 1242, INST: mac.s.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_s_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __mac_s_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_s_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __mac_s_x_hh(__Dn, __Da_h, __Db_h) __mac_s_x_hh_aux(__mac_s_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_s_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1243, INST: mac.s.x #s16_t2,Da.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_s_x_l(Word40 __Dn, Word32 __imm1, Word32 __Da_l);
Word40 __mac_s_x_l_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_s_x_l_read(Word32 __imm1, Word32 __Da_l);
#define __mac_s_x_l(__Dn, __imm1, __Da_l) __mac_s_x_l_aux(__mac_s_x_l_read(__imm1, __Da_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_s_x_l(Word40 __Dn, Word32 __imm1, Word32 __Da_l);
#endif 

	/*ID: 1244, INST: mac.s.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_s_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_s_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_s_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_s_x_ll(__Dn, __Da_l, __Db_l) __mac_s_x_ll_aux(__mac_s_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_s_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1245, INST: mac.s.x Da.h,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_s_x_hl(Word40 __Dn, Word32 __Da_h, Word32 __Db_l);
Word40 __mac_s_x_hl_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_s_x_hl_read(Word32 __Da_h, Word32 __Db_l);
#define __mac_s_x_hl(__Dn, __Da_h, __Db_l) __mac_s_x_hl_aux(__mac_s_x_hl_read(__Da_h, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_s_x_hl(Word40 __Dn, Word32 __Da_h, Word32 __Db_l);
#endif 

	/*ID: 1246, INST: mac.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __mac_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac_s_2x_dup_read(Word32 __Da, Word32 __Db);
#define __mac_s_2x_dup(__Dmn, __Da, __Db) __mac_s_2x_dup_aux(__mac_s_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __mac_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac_s_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __mac_s_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __mac_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1247, INST: mac.sr.2w Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mac_sr_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __mac_sr_2w_aux(Word32 __Dres, Word32 __Dn);
Word32 __mac_sr_2w_read(Word32 __Da, Word32 __Db);
#define __mac_sr_2w(__Dn, __Da, __Db) __mac_sr_2w_aux(__mac_sr_2w_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __mac_sr_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1248, INST: mac.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mac_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __mac_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __mac_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac_sr_4w_dup(__Dmn, __Dab, __Dcd) __mac_sr_4w_dup_aux(__mac_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mac_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1249, INST: mac.sr.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_sr_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __mac_sr_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_sr_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __mac_sr_x_hh(__Dn, __Da_h, __Db_h) __mac_sr_x_hh_aux(__mac_sr_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_sr_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1250, INST: mac.sr.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_sr_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_sr_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_sr_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_sr_x_ll(__Dn, __Da_l, __Db_l) __mac_sr_x_ll_aux(__mac_sr_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_sr_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1251, INST: mac.sr.x Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_sr_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
Word40 __mac_sr_x_lh_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_sr_x_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __mac_sr_x_lh(__Dn, __Da_l, __Db_h) __mac_sr_x_lh_aux(__mac_sr_x_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __mac_sr_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1252, INST: mac.su.i.2t Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_su_i_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac_su_i_2t_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_su_i_2t_read(Word32 __Da, Word32 __Db);
#define __mac_su_i_2t(__Dn, __Da, __Db) __mac_su_i_2t_aux(__mac_su_i_2t_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac_su_i_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1253, INST: mac.us.i.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac_us_i_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
Word40 __mac_us_i_x_ll_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac_us_i_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_us_i_x_ll(__Dn, __Da_l, __Db_l) __mac_us_i_x_ll_aux(__mac_us_i_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __mac_us_i_x_ll(Word40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1254, INST: mac.uu.i.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
UWord40 __mac_uu_i_x_ll(UWord40 __Dn, Word32 __Da_l, Word32 __Db_l);
UWord40 __mac_uu_i_x_ll_aux(UWord40 __Dres, UWord40 __Dn);
UWord40 __mac_uu_i_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_uu_i_x_ll(__Dn, __Da_l, __Db_l) __mac_uu_i_x_ll_aux(__mac_uu_i_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API UWord40 __mac_uu_i_x_ll(UWord40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1255, INST: mac.uu.i.x -Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
UWord40 __mac_uu_i_x_m_ll(UWord40 __Dn, Word32 __Da_l, Word32 __Db_l);
UWord40 __mac_uu_i_x_m_ll_aux(UWord40 __Dres, UWord40 __Dn);
UWord40 __mac_uu_i_x_m_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __mac_uu_i_x_m_ll(__Dn, __Da_l, __Db_l) __mac_uu_i_x_m_ll_aux(__mac_uu_i_x_m_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API UWord40 __mac_uu_i_x_m_ll(UWord40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1256, INST: mac32.il.l Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mac32_il_l(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __mac32_il_l_aux(Word32 __Dres, Word32 __Dn);
Word32 __mac32_il_l_read(Word32 __Da, Word32 __Db);
#define __mac32_il_l(__Dn, __Da, __Db) __mac32_il_l_aux(__mac32_il_l_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __mac32_il_l(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1257, INST: mac32.il.l -Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mac32_il_l_m(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __mac32_il_l_m_aux(Word32 __Dres, Word32 __Dn);
Word32 __mac32_il_l_m_read(Word32 __Da, Word32 __Db);
#define __mac32_il_l_m(__Dn, __Da, __Db) __mac32_il_l_m_aux(__mac32_il_l_m_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __mac32_il_l_m(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1258, INST: mac32.r.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac32_r_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac32_r_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac32_r_x_read(Word32 __Da, Word32 __Db);
#define __mac32_r_x(__Dn, __Da, __Db) __mac32_r_x_aux(__mac32_r_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac32_r_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1259, INST: mac32.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac32_r_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __mac32_r_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac32_r_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __mac32_r_2x_da_dup(__Dmn, __Da, __Dcd) __mac32_r_2x_da_dup_aux(__mac32_r_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac32_r_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac32_r_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac32_r_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __mac32_r_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1260, INST: mac32.r.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac32_r_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac32_r_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac32_r_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac32_r_2x_dup(__Dmn, __Dab, __Dcd) __mac32_r_2x_dup_aux(__mac32_r_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac32_r_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac32_r_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac32_r_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac32_r_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1261, INST: mac32.sr.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac32_sr_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __mac32_sr_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __mac32_sr_x_read(Word32 __Da, Word32 __Db);
#define __mac32_sr_x(__Dn, __Da, __Db) __mac32_sr_x_aux(__mac32_sr_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __mac32_sr_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1262, INST: mac32.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac32_sr_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __mac32_sr_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac32_sr_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __mac32_sr_2x_da_dup(__Dmn, __Da, __Dcd) __mac32_sr_2x_da_dup_aux(__mac32_sr_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac32_sr_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac32_sr_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac32_sr_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __mac32_sr_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1263, INST: mac32.sr.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mac32_sr_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __mac32_sr_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __mac32_sr_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __mac32_sr_2x_dup(__Dmn, __Dab, __Dcd) __mac32_sr_2x_dup_aux(__mac32_sr_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __mac32_sr_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mac32_sr_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __mac32_sr_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __mac32_sr_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1264, INST: maccx.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_2x_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_2x_dup(__Dmn, __Da, __Db) __maccx_2x_dup_aux(__maccx_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1265, INST: maccx.2x -Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_2x_m_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_2x_m_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_2x_m_dup(__Dmn, __Da, __Db) __maccx_2x_m_dup_aux(__maccx_2x_m_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_2x_m(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_2x_m_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_2x_m_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_2x_m(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1266, INST: maccx.c.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_c_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_2x_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_c_2x_dup(__Dmn, __Da, __Db) __maccx_c_2x_dup_aux(__maccx_c_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_c_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_c_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1267, INST: maccx.c.2x -Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_2x_m_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_c_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_2x_m_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_c_2x_m_dup(__Dmn, __Da, __Db) __maccx_c_2x_m_dup_aux(__maccx_c_2x_m_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_2x_m(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_2x_m_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_c_2x_m_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_c_2x_m(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1268, INST: maccx.c.ir.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_ir_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccx_c_ir_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_ir_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_c_ir_4t_dup(__Dmn, __Dab, __Dcd) __maccx_c_ir_4t_dup_aux(__maccx_c_ir_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_ir_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_ir_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_c_ir_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_ir_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1269, INST: maccx.c.isr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_c_isr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __maccx_c_isr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __maccx_c_isr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_c_isr_4w_dup(__Dmn, __Dab, __Dcd) __maccx_c_isr_4w_dup_aux(__maccx_c_isr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_isr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __maccx_c_isr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_c_isr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_isr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1270, INST: maccx.c.r.2t Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_r_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __maccx_c_r_2t_aux(Word40 __Dres, Word40 __Dn);
Word40 __maccx_c_r_2t_read(Word32 __Da, Word32 __Db);
#define __maccx_c_r_2t(__Dn, __Da, __Db) __maccx_c_r_2t_aux(__maccx_c_r_2t_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __maccx_c_r_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1271, INST: maccx.c.r.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_r_4t_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccx_c_r_4t_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_r_4t_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccx_c_r_4t_da_dup(__Dmn, __Da, __Dcd) __maccx_c_r_4t_da_dup_aux(__maccx_c_r_4t_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_r_4t_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_c_r_4t_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1272, INST: maccx.c.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccx_c_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_c_r_4t_dup(__Dmn, __Dab, __Dcd) __maccx_c_r_4t_dup_aux(__maccx_c_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_c_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1273, INST: maccx.c.r.4t -Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_r_4t_m_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccx_c_r_4t_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_r_4t_m_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_c_r_4t_m_dup(__Dmn, __Dab, __Dcd) __maccx_c_r_4t_m_dup_aux(__maccx_c_r_4t_m_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_r_4t_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_r_4t_m_dup(*__Dm, __Ra, __Dc);
	*__Dn =  __maccx_c_r_4t_m_dup(*__Dn, __Rb, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_r_4t_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1274, INST: maccx.c.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_c_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_c_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_c_s_2x_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_c_s_2x_dup(__Dmn, __Da, __Db) __maccx_c_s_2x_dup_aux(__maccx_c_s_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_c_s_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_c_s_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_c_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1275, INST: maccx.c.sr.2w Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_c_sr_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __maccx_c_sr_2w_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccx_c_sr_2w_read(Word32 __Da, Word32 __Db);
#define __maccx_c_sr_2w(__Dn, __Da, __Db) __maccx_c_sr_2w_aux(__maccx_c_sr_2w_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __maccx_c_sr_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1276, INST: maccx.c.sr.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_c_sr_4w_da_dup(Word32 __Dmn, Word32 __Da, Word32 __Dcd);
Word32 __maccx_c_sr_4w_da_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __maccx_c_sr_4w_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccx_c_sr_4w_da_dup(__Dmn, __Da, __Dcd) __maccx_c_sr_4w_da_dup_aux(__maccx_c_sr_4w_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __maccx_c_sr_4w_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_c_sr_4w_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1277, INST: maccx.c.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_c_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __maccx_c_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __maccx_c_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_c_sr_4w_dup(__Dmn, __Dab, __Dcd) __maccx_c_sr_4w_dup_aux(__maccx_c_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_c_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __maccx_c_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_c_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_c_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1278, INST: maccx.i.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_i_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_i_2x_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_i_2x_dup(__Dmn, __Da, __Db) __maccx_i_2x_dup_aux(__maccx_i_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_i_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_i_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_i_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_i_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1279, INST: maccx.ir.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_ir_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccx_ir_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_ir_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_ir_4t_dup(__Dmn, __Dab, __Dcd) __maccx_ir_4t_dup_aux(__maccx_ir_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_ir_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_ir_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_ir_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_ir_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1280, INST: maccx.is.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_is_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_is_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_is_2x_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_is_2x_dup(__Dmn, __Da, __Db) __maccx_is_2x_dup_aux(__maccx_is_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_is_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_is_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_is_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_is_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1281, INST: maccx.r.2t Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_r_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __maccx_r_2t_aux(Word40 __Dres, Word40 __Dn);
Word40 __maccx_r_2t_read(Word32 __Da, Word32 __Db);
#define __maccx_r_2t(__Dn, __Da, __Db) __maccx_r_2t_aux(__maccx_r_2t_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __maccx_r_2t(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1282, INST: maccx.r.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_r_4t_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccx_r_4t_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_r_4t_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccx_r_4t_da_dup(__Dmn, __Da, __Dcd) __maccx_r_4t_da_dup_aux(__maccx_r_4t_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_r_4t_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_r_4t_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccx_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1283, INST: maccx.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccx_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_r_4t_dup(__Dmn, __Dab, __Dcd) __maccx_r_4t_dup_aux(__maccx_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1284, INST: maccx.r.4t -Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_r_4t_m_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccx_r_4t_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_r_4t_m_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_r_4t_m_dup(__Dmn, __Dab, __Dcd) __maccx_r_4t_m_dup_aux(__maccx_r_4t_m_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_r_4t_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_r_4t_m_dup(*__Dm, __Ra, __Dc);
	*__Dn =  __maccx_r_4t_m_dup(*__Dn, __Rb, __Dd);
}
#else 
PROTOTYPE_API void __maccx_r_4t_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1285, INST: maccx.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccx_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Db);
Word40 __maccx_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccx_s_2x_dup_read(Word32 __Da, Word32 __Db);
#define __maccx_s_2x_dup(__Dmn, __Da, __Db) __maccx_s_2x_dup_aux(__maccx_s_2x_dup_read(__Da, __Db), __Dmn)
__attribute__((always_inline)) inline void __maccx_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccx_s_2x_dup(*__Dm, __Da, __Db);
	*__Dn =  __maccx_s_2x_dup(*__Dn, __Da, __Db);
}
#else 
PROTOTYPE_API void __maccx_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1286, INST: maccx.sr.2w Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_sr_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __maccx_sr_2w_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccx_sr_2w_read(Word32 __Da, Word32 __Db);
#define __maccx_sr_2w(__Dn, __Da, __Db) __maccx_sr_2w_aux(__maccx_sr_2w_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __maccx_sr_2w(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1287, INST: maccx.sr.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_sr_4w_da_dup(Word32 __Dmn, Word32 __Da, Word32 __Dcd);
Word32 __maccx_sr_4w_da_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __maccx_sr_4w_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccx_sr_4w_da_dup(__Dmn, __Da, __Dcd) __maccx_sr_4w_da_dup_aux(__maccx_sr_4w_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __maccx_sr_4w_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_sr_4w_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccx_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1288, INST: maccx.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccx_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __maccx_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __maccx_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccx_sr_4w_dup(__Dmn, __Dab, __Dcd) __maccx_sr_4w_dup_aux(__maccx_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccx_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __maccx_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccx_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccx_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1289, INST: maccxd.cpn.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpn_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_cpn_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpn_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_cpn_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_cpn_2x_da_dup_aux(__maccxd_cpn_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpn_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpn_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1290, INST: maccxd.cpn.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpn_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpn_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpn_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpn_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_cpn_2x_dup_aux(__maccxd_cpn_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpn_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpn_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1291, INST: maccxd.cpn.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpn_s_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_cpn_s_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpn_s_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_cpn_s_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_cpn_s_2x_da_dup_aux(__maccxd_cpn_s_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpn_s_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpn_s_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1292, INST: maccxd.cpn.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpn_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpn_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpn_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpn_s_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_cpn_s_2x_dup_aux(__maccxd_cpn_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpn_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpn_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1293, INST: maccxd.cpn.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_cpn_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_cpn_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_cpn_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpn_sr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_cpn_sr_2w_dup_aux(__maccxd_cpn_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_cpn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_cpn_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_cpn_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1294, INST: maccxd.cpp.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_cpp_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpp_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_cpp_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_cpp_2x_da_dup_aux(__maccxd_cpp_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpp_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpp_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1295, INST: maccxd.cpp.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpp_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpp_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_cpp_2x_dup_aux(__maccxd_cpp_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpp_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpp_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1296, INST: maccxd.cpp.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpp_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpp_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_i_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_cpp_i_2x_dup_aux(__maccxd_cpp_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpp_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpp_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1297, INST: maccxd.cpp.ir.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_ir_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpp_ir_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __maccxd_cpp_ir_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_ir_2t_dup(__Dn, __Dab, __Dcd) __maccxd_cpp_ir_2t_dup_aux(__maccxd_cpp_ir_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_cpp_ir_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __maccxd_cpp_ir_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_cpp_ir_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_ir_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1298, INST: maccxd.cpp.is.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_is_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpp_is_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpp_is_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_is_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_cpp_is_2x_dup_aux(__maccxd_cpp_is_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpp_is_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpp_is_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1299, INST: maccxd.cpp.isr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_cpp_isr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_cpp_isr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_cpp_isr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_isr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_cpp_isr_2w_dup_aux(__maccxd_cpp_isr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_cpp_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_cpp_isr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_cpp_isr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1300, INST: maccxd.cpp.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_r_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpp_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __maccxd_cpp_r_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_r_2t_dup(__Dn, __Dab, __Dcd) __maccxd_cpp_r_2t_dup_aux(__maccxd_cpp_r_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_cpp_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __maccxd_cpp_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_cpp_r_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1301, INST: maccxd.cpp.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_s_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_cpp_s_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpp_s_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_cpp_s_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_cpp_s_2x_da_dup_aux(__maccxd_cpp_s_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpp_s_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpp_s_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1302, INST: maccxd.cpp.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_cpp_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_cpp_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_cpp_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_s_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_cpp_s_2x_dup_aux(__maccxd_cpp_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_cpp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_cpp_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_cpp_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1303, INST: maccxd.cpp.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_cpp_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_cpp_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_cpp_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_cpp_sr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_cpp_sr_2w_dup_aux(__maccxd_cpp_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_cpp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_cpp_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_cpp_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_cpp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1304, INST: maccxd.pn.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pn_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_pn_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pn_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_pn_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_pn_2x_da_dup_aux(__maccxd_pn_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pn_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pn_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1305, INST: maccxd.pn.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pn_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pn_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pn_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pn_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pn_2x_dup_aux(__maccxd_pn_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pn_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pn_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1306, INST: maccxd.pn.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pn_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pn_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pn_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pn_i_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pn_i_2x_dup_aux(__maccxd_pn_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pn_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pn_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pn_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1307, INST: maccxd.pn.is.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pn_is_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pn_is_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pn_is_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pn_is_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pn_is_2x_dup_aux(__maccxd_pn_is_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pn_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pn_is_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pn_is_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1308, INST: maccxd.pn.isr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_pn_isr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_pn_isr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_pn_isr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pn_isr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_pn_isr_2w_dup_aux(__maccxd_pn_isr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_pn_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_pn_isr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_pn_isr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1309, INST: maccxd.pn.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pn_s_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_pn_s_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pn_s_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_pn_s_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_pn_s_2x_da_dup_aux(__maccxd_pn_s_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pn_s_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pn_s_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1310, INST: maccxd.pn.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pn_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pn_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pn_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pn_s_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pn_s_2x_dup_aux(__maccxd_pn_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pn_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pn_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1311, INST: maccxd.pn.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_pn_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_pn_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_pn_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pn_sr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_pn_sr_2w_dup_aux(__maccxd_pn_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_pn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_pn_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_pn_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1312, INST: maccxd.pp.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_pp_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pp_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_pp_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_pp_2x_da_dup_aux(__maccxd_pp_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pp_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pp_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1313, INST: maccxd.pp.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pp_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pp_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pp_2x_dup_aux(__maccxd_pp_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pp_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pp_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1314, INST: maccxd.pp.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pp_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pp_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_i_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pp_i_2x_dup_aux(__maccxd_pp_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pp_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pp_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1315, INST: maccxd.pp.ir.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_ir_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pp_ir_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __maccxd_pp_ir_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_ir_2t_dup(__Dn, __Dab, __Dcd) __maccxd_pp_ir_2t_dup_aux(__maccxd_pp_ir_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_pp_ir_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __maccxd_pp_ir_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_pp_ir_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_ir_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1316, INST: maccxd.pp.is.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_is_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pp_is_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pp_is_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_is_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pp_is_2x_dup_aux(__maccxd_pp_is_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pp_is_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pp_is_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1317, INST: maccxd.pp.isr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_pp_isr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_pp_isr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_pp_isr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_isr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_pp_isr_2w_dup_aux(__maccxd_pp_isr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_pp_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_pp_isr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_pp_isr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1318, INST: maccxd.pp.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_r_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pp_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __maccxd_pp_r_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_r_2t_dup(__Dn, __Dab, __Dcd) __maccxd_pp_r_2t_dup_aux(__maccxd_pp_r_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_pp_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __maccxd_pp_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_pp_r_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1319, INST: maccxd.pp.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_s_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxd_pp_s_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pp_s_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxd_pp_s_2x_da_dup(__Dmn, __Da, __Dcd) __maccxd_pp_s_2x_da_dup_aux(__maccxd_pp_s_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pp_s_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pp_s_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1320, INST: maccxd.pp.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_pp_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_pp_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_pp_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_s_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_pp_s_2x_dup_aux(__maccxd_pp_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_pp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_pp_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_pp_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1321, INST: maccxd.pp.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_pp_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_pp_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_pp_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_pp_sr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_pp_sr_2w_dup_aux(__maccxd_pp_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_pp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_pp_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_pp_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_pp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1322, INST: maccxd.ppx.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_ppx_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_ppx_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_ppx_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_ppx_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_ppx_2x_dup_aux(__maccxd_ppx_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_ppx_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_ppx_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_ppx_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_ppx_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1323, INST: maccxd.ppx.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxd_ppx_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __maccxd_ppx_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxd_ppx_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_ppx_s_2x_dup(__Dmn, __Dab, __Dcd) __maccxd_ppx_s_2x_dup_aux(__maccxd_ppx_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxd_ppx_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxd_ppx_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxd_ppx_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_ppx_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1324, INST: maccxd.ppx.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __maccxd_ppx_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __maccxd_ppx_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __maccxd_ppx_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __maccxd_ppx_sr_2w_dup(__Dn, __Dab, __Dcd) __maccxd_ppx_sr_2w_dup_aux(__maccxd_ppx_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __maccxd_ppx_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __maccxd_ppx_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __maccxd_ppx_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __maccxd_ppx_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1325, INST: maccxm.c.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_c_r_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_c_r_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_c_r_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_c_r_2x_dup(__Dmn, __Da, __Dcd) __maccxm_c_r_2x_dup_aux(__maccxm_c_r_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_c_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_c_r_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_c_r_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_c_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1326, INST: maccxm.c.r.2x -Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_c_r_2x_m_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_c_r_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_c_r_2x_m_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_c_r_2x_m_dup(__Dmn, __Da, __Dcd) __maccxm_c_r_2x_m_dup_aux(__maccxm_c_r_2x_m_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_c_r_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_c_r_2x_m_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_c_r_2x_m_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_c_r_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1327, INST: maccxm.c.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_c_sr_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_c_sr_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_c_sr_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_c_sr_2x_dup(__Dmn, __Da, __Dcd) __maccxm_c_sr_2x_dup_aux(__maccxm_c_sr_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_c_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_c_sr_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_c_sr_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_c_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1328, INST: maccxm.c.sr.2x -Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_c_sr_2x_m_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_c_sr_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_c_sr_2x_m_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_c_sr_2x_m_dup(__Dmn, __Da, __Dcd) __maccxm_c_sr_2x_m_dup_aux(__maccxm_c_sr_2x_m_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_c_sr_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_c_sr_2x_m_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_c_sr_2x_m_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_c_sr_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1329, INST: maccxm.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_r_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_r_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_r_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_r_2x_dup(__Dmn, __Da, __Dcd) __maccxm_r_2x_dup_aux(__maccxm_r_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_r_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_r_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1330, INST: maccxm.r.2x -Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_r_2x_m_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_r_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_r_2x_m_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_r_2x_m_dup(__Dmn, __Da, __Dcd) __maccxm_r_2x_m_dup_aux(__maccxm_r_2x_m_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_r_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_r_2x_m_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_r_2x_m_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_r_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1331, INST: maccxm.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_sr_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_sr_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_sr_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_sr_2x_dup(__Dmn, __Da, __Dcd) __maccxm_sr_2x_dup_aux(__maccxm_sr_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_sr_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_sr_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1332, INST: maccxm.sr.2x -Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maccxm_sr_2x_m_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __maccxm_sr_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __maccxm_sr_2x_m_dup_read(Word32 __Da, Word32 __Dcd);
#define __maccxm_sr_2x_m_dup(__Dmn, __Da, __Dcd) __maccxm_sr_2x_m_dup_aux(__maccxm_sr_2x_m_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __maccxm_sr_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maccxm_sr_2x_m_dup(*__Dm, __Da, __Dc);
	*__Dn =  __maccxm_sr_2x_m_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __maccxm_sr_2x_m(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1333, INST: macd.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_x_read(Word32 __Da, Word32 __Db);
#define __macd_x(__Dn, __Da, __Db) __macd_x_aux(__macd_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1334, INST: macd.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macd_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __macd_2x_da_dup(__Dmn, __Da, __Dcd) __macd_2x_da_dup_aux(__macd_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macd_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1335, INST: macd.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_2x_dup(__Dmn, __Dab, __Dcd) __macd_2x_dup_aux(__macd_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1336, INST: macd.2x -Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_2x_m_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_2x_m_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_2x_m_dup(__Dmn, __Dab, __Dcd) __macd_2x_m_dup_aux(__macd_2x_m_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_2x_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_2x_m_dup(*__Dm, __Ra, __Dc);
	*__Dn =  __macd_2x_m_dup(*__Dn, __Rb, __Dd);
}
#else 
PROTOTYPE_API void __macd_2x_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1337, INST: macd.cim.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_cim_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_cim_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_cim_x_read(Word32 __Da, Word32 __Db);
#define __macd_cim_x(__Dn, __Da, __Db) __macd_cim_x_aux(__macd_cim_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_cim_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1338, INST: macd.cim.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_cim_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_cim_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_cim_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_cim_2x_dup(__Dmn, __Dab, __Dcd) __macd_cim_2x_dup_aux(__macd_cim_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_cim_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_cim_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_cim_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_cim_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1339, INST: macd.cim.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_cim_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_cim_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_cim_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_cim_i_2x_dup(__Dmn, __Dab, __Dcd) __macd_cim_i_2x_dup_aux(__macd_cim_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_cim_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_cim_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_cim_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_cim_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1340, INST: macd.cim.leg.x -Da,Db,Dn*/

	/*ID: 1341, INST: macd.cim.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_cim_r_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_cim_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_cim_r_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_cim_r_2t_dup(__Dn, __Dab, __Dcd) __macd_cim_r_2t_dup_aux(__macd_cim_r_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_cim_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macd_cim_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_cim_r_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_cim_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1342, INST: macd.cim.s.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_cim_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_cim_s_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_cim_s_x_read(Word32 __Da, Word32 __Db);
#define __macd_cim_s_x(__Dn, __Da, __Db) __macd_cim_s_x_aux(__macd_cim_s_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_cim_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1343, INST: macd.cim.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_cim_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_cim_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_cim_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_cim_s_2x_dup(__Dmn, __Dab, __Dcd) __macd_cim_s_2x_dup_aux(__macd_cim_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_cim_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_cim_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_cim_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_cim_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1344, INST: macd.cim.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macd_cim_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __macd_cim_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __macd_cim_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_cim_sr_2w_dup(__Dn, __Dab, __Dcd) __macd_cim_sr_2w_dup_aux(__macd_cim_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_cim_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __macd_cim_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_cim_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_cim_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1345, INST: macd.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_i_2x_dup(__Dmn, __Dab, __Dcd) __macd_i_2x_dup_aux(__macd_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1346, INST: macd.im.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_im_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_im_x_read(Word32 __Da, Word32 __Db);
#define __macd_im_x(__Dn, __Da, __Db) __macd_im_x_aux(__macd_im_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_im_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1347, INST: macd.im.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_im_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_im_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_im_2x_dup(__Dmn, __Dab, __Dcd) __macd_im_2x_dup_aux(__macd_im_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_im_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_im_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_im_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_im_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1348, INST: macd.im.2x -Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_2x_m_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_im_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_im_2x_m_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_im_2x_m_dup(__Dmn, __Dab, __Dcd) __macd_im_2x_m_dup_aux(__macd_im_2x_m_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_im_2x_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_im_2x_m_dup(*__Dm, __Ra, __Dc);
	*__Dn =  __macd_im_2x_m_dup(*__Dn, __Rb, __Dd);
}
#else 
PROTOTYPE_API void __macd_im_2x_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1349, INST: macd.im.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_im_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_im_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_im_i_2x_dup(__Dmn, __Dab, __Dcd) __macd_im_i_2x_dup_aux(__macd_im_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_im_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_im_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_im_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_im_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1350, INST: macd.im.leg.x Da,Db,Dn*/

	/*ID: 1351, INST: macd.im.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_r_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_im_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_im_r_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_im_r_2t_dup(__Dn, __Dab, __Dcd) __macd_im_r_2t_dup_aux(__macd_im_r_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_im_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macd_im_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_im_r_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_im_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1352, INST: macd.im.s.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_im_s_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_im_s_x_read(Word32 __Da, Word32 __Db);
#define __macd_im_s_x(__Dn, __Da, __Db) __macd_im_s_x_aux(__macd_im_s_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_im_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1353, INST: macd.im.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_im_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_im_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_im_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_im_s_2x_dup(__Dmn, __Dab, __Dcd) __macd_im_s_2x_dup_aux(__macd_im_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_im_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_im_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_im_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_im_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1354, INST: macd.im.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macd_im_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __macd_im_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __macd_im_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_im_sr_2w_dup(__Dn, __Dab, __Dcd) __macd_im_sr_2w_dup_aux(__macd_im_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_im_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __macd_im_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_im_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_im_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1355, INST: macd.leg.x Da,Db,Dn*/

	/*ID: 1356, INST: macd.leg.x -Da,Db,Dn*/

	/*ID: 1357, INST: macd.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_r_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_r_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_r_2t_dup(__Dn, __Dab, __Dcd) __macd_r_2t_dup_aux(__macd_r_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macd_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_r_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1358, INST: macd.re.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_re_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_re_x_read(Word32 __Da, Word32 __Db);
#define __macd_re_x(__Dn, __Da, __Db) __macd_re_x_aux(__macd_re_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_re_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1359, INST: macd.re.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_re_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_re_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_re_2x_dup(__Dmn, __Dab, __Dcd) __macd_re_2x_dup_aux(__macd_re_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_re_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_re_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_re_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_re_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1360, INST: macd.re.2x -Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_2x_m_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_re_2x_m_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_re_2x_m_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_re_2x_m_dup(__Dmn, __Dab, __Dcd) __macd_re_2x_m_dup_aux(__macd_re_2x_m_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_re_2x_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_re_2x_m_dup(*__Dm, __Ra, __Dc);
	*__Dn =  __macd_re_2x_m_dup(*__Dn, __Rb, __Dd);
}
#else 
PROTOTYPE_API void __macd_re_2x_m(Word32 __Ra, Word32 __Rb, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1361, INST: macd.re.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_i_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_re_i_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_re_i_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_re_i_2x_dup(__Dmn, __Dab, __Dcd) __macd_re_i_2x_dup_aux(__macd_re_i_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_re_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_re_i_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_re_i_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_re_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1362, INST: macd.re.leg.x Da,Db,Dn*/

	/*ID: 1363, INST: macd.re.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_r_2t_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_re_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_re_r_2t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_re_r_2t_dup(__Dn, __Dab, __Dcd) __macd_re_r_2t_dup_aux(__macd_re_r_2t_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_re_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macd_re_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_re_r_2t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_re_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1364, INST: macd.re.s.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_re_s_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_re_s_x_read(Word32 __Da, Word32 __Db);
#define __macd_re_s_x(__Dn, __Da, __Db) __macd_re_s_x_aux(__macd_re_s_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_re_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1365, INST: macd.re.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_re_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_re_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_re_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_re_s_2x_dup(__Dmn, __Dab, __Dcd) __macd_re_s_2x_dup_aux(__macd_re_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_re_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_re_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_re_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_re_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1366, INST: macd.re.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macd_re_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __macd_re_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __macd_re_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_re_sr_2w_dup(__Dn, __Dab, __Dcd) __macd_re_sr_2w_dup_aux(__macd_re_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_re_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __macd_re_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_re_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_re_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1367, INST: macd.s.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macd_s_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macd_s_x_read(Word32 __Da, Word32 __Db);
#define __macd_s_x(__Dn, __Da, __Db) __macd_s_x_aux(__macd_s_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macd_s_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1368, INST: macd.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_s_2x_da_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macd_s_2x_da_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_s_2x_da_dup_read(Word32 __Da, Word32 __Dcd);
#define __macd_s_2x_da_dup(__Dmn, __Da, __Dcd) __macd_s_2x_da_dup_aux(__macd_s_2x_da_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_s_2x_da_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_s_2x_da_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macd_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1369, INST: macd.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macd_s_2x_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macd_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macd_s_2x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_s_2x_dup(__Dmn, __Dab, __Dcd) __macd_s_2x_dup_aux(__macd_s_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macd_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macd_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macd_s_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1370, INST: macd.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macd_sr_2w_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __macd_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __macd_sr_2w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macd_sr_2w_dup(__Dn, __Dab, __Dcd) __macd_sr_2w_dup_aux(__macd_sr_2w_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macd_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __macd_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macd_sr_2w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macd_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1371, INST: macdcf.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdcf_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdcf_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdcf_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdcf_2x_dup(__Dmn, __Da, __Dcd) __macdcf_2x_dup_aux(__macdcf_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdcf_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1372, INST: macdcf.h.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdcf_h_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdcf_h_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdcf_h_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdcf_h_r_4t_dup(__Dmn, __Dab, __Dcd) __macdcf_h_r_4t_dup_aux(__macdcf_h_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdcf_h_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_h_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1373, INST: macdcf.h.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __macdcf_h_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __macdcf_h_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __macdcf_h_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdcf_h_sr_4w_dup(__Dmn, __Dab, __Dcd) __macdcf_h_sr_4w_dup_aux(__macdcf_h_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_h_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __macdcf_h_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_h_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_h_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1374, INST: macdcf.inv.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdcf_inv_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdcf_inv_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdcf_inv_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdcf_inv_2x_dup(__Dmn, __Da, __Dcd) __macdcf_inv_2x_dup_aux(__macdcf_inv_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_inv_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdcf_inv_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_inv_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_inv_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1375, INST: macdcf.invh.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdcf_invh_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdcf_invh_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdcf_invh_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdcf_invh_r_4t_dup(__Dmn, __Dab, __Dcd) __macdcf_invh_r_4t_dup_aux(__macdcf_invh_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_invh_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdcf_invh_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_invh_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_invh_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1376, INST: macdcf.invl.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdcf_invl_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdcf_invl_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdcf_invl_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdcf_invl_r_4t_dup(__Dmn, __Dab, __Dcd) __macdcf_invl_r_4t_dup_aux(__macdcf_invl_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_invl_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdcf_invl_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_invl_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_invl_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1377, INST: macdcf.l.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdcf_l_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdcf_l_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdcf_l_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdcf_l_r_4t_dup(__Dmn, __Dab, __Dcd) __macdcf_l_r_4t_dup_aux(__macdcf_l_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdcf_l_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_l_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1378, INST: macdcf.l.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __macdcf_l_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __macdcf_l_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __macdcf_l_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdcf_l_sr_4w_dup(__Dmn, __Dab, __Dcd) __macdcf_l_sr_4w_dup_aux(__macdcf_l_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdcf_l_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __macdcf_l_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdcf_l_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdcf_l_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1379, INST: macdrf.h.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_h_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_h_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_h_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_h_2x_dup(__Dmn, __Da, __Dcd) __macdrf_h_2x_dup_aux(__macdrf_h_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_h_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_h_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_h_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_h_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1380, INST: macdrf.h.r.2t Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_h_r_2t_dup(Word40 __Dn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_h_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macdrf_h_r_2t_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_h_r_2t_dup(__Dn, __Da, __Dcd) __macdrf_h_r_2t_dup_aux(__macdrf_h_r_2t_dup_read(__Da, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macdrf_h_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macdrf_h_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macdrf_h_r_2t_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_h_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1381, INST: macdrf.h.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_h_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdrf_h_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_h_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdrf_h_r_4t_dup(__Dmn, __Dab, __Dcd) __macdrf_h_r_4t_dup_aux(__macdrf_h_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_h_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_h_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1382, INST: macdrf.h.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_h_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_h_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_h_s_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_h_s_2x_dup(__Dmn, __Da, __Dcd) __macdrf_h_s_2x_dup_aux(__macdrf_h_s_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_h_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_h_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_h_s_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_h_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1383, INST: macdrf.h.sr.2w Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macdrf_h_sr_2w_dup(Word32 __Dn, Word32 __Da, Word32 __Dcd);
Word32 __macdrf_h_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __macdrf_h_sr_2w_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_h_sr_2w_dup(__Dn, __Da, __Dcd) __macdrf_h_sr_2w_dup_aux(__macdrf_h_sr_2w_dup_read(__Da, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macdrf_h_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __macdrf_h_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macdrf_h_sr_2w_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_h_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1384, INST: macdrf.h.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __macdrf_h_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __macdrf_h_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __macdrf_h_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdrf_h_sr_4w_dup(__Dmn, __Dab, __Dcd) __macdrf_h_sr_4w_dup_aux(__macdrf_h_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_h_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __macdrf_h_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_h_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_h_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1385, INST: macdrf.invh.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_invh_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_invh_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_invh_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_invh_2x_dup(__Dmn, __Da, __Dcd) __macdrf_invh_2x_dup_aux(__macdrf_invh_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_invh_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_invh_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_invh_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_invh_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1386, INST: macdrf.invh.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_invh_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdrf_invh_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_invh_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdrf_invh_r_4t_dup(__Dmn, __Dab, __Dcd) __macdrf_invh_r_4t_dup_aux(__macdrf_invh_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_invh_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_invh_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_invh_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_invh_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1387, INST: macdrf.invl.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_invl_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_invl_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_invl_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_invl_2x_dup(__Dmn, __Da, __Dcd) __macdrf_invl_2x_dup_aux(__macdrf_invl_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_invl_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_invl_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_invl_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_invl_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1388, INST: macdrf.invl.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_invl_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdrf_invl_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_invl_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdrf_invl_r_4t_dup(__Dmn, __Dab, __Dcd) __macdrf_invl_r_4t_dup_aux(__macdrf_invl_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_invl_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_invl_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_invl_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_invl_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1389, INST: macdrf.l.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_l_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_l_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_l_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_l_2x_dup(__Dmn, __Da, __Dcd) __macdrf_l_2x_dup_aux(__macdrf_l_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_l_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_l_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_l_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_l_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1390, INST: macdrf.l.r.2t Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_l_r_2t_dup(Word40 __Dn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_l_r_2t_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macdrf_l_r_2t_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_l_r_2t_dup(__Dn, __Da, __Dcd) __macdrf_l_r_2t_dup_aux(__macdrf_l_r_2t_dup_read(__Da, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macdrf_l_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macdrf_l_r_2t_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macdrf_l_r_2t_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_l_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1391, INST: macdrf.l.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_l_r_4t_dup(Word40 __Dmn, Word32 __Dab, Word32 __Dcd);
Word40 __macdrf_l_r_4t_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_l_r_4t_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdrf_l_r_4t_dup(__Dmn, __Dab, __Dcd) __macdrf_l_r_4t_dup_aux(__macdrf_l_r_4t_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_l_r_4t_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_l_r_4t_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1392, INST: macdrf.l.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macdrf_l_s_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macdrf_l_s_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macdrf_l_s_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_l_s_2x_dup(__Dmn, __Da, __Dcd) __macdrf_l_s_2x_dup_aux(__macdrf_l_s_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_l_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macdrf_l_s_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_l_s_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_l_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1393, INST: macdrf.l.sr.2w Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macdrf_l_sr_2w_dup(Word32 __Dn, Word32 __Da, Word32 __Dcd);
Word32 __macdrf_l_sr_2w_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __macdrf_l_sr_2w_dup_read(Word32 __Da, Word32 __Dcd);
#define __macdrf_l_sr_2w_dup(__Dn, __Da, __Dcd) __macdrf_l_sr_2w_dup_aux(__macdrf_l_sr_2w_dup_read(__Da, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macdrf_l_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __macdrf_l_sr_2w_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macdrf_l_sr_2w_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_l_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1394, INST: macdrf.l.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __macdrf_l_sr_4w_dup(Word32 __Dmn, Word32 __Dab, Word32 __Dcd);
Word32 __macdrf_l_sr_4w_dup_aux(Word32 __Dres, Word32 __Dmn);
Word32 __macdrf_l_sr_4w_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macdrf_l_sr_4w_dup(__Dmn, __Dab, __Dcd) __macdrf_l_sr_4w_dup_aux(__macdrf_l_sr_4w_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macdrf_l_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __macdrf_l_sr_4w_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macdrf_l_sr_4w_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macdrf_l_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1395, INST: macem32.ss.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macem32_ss_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __macem32_ss_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __macem32_ss_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __macem32_ss_x_hh(__Dn, __Da_h, __Db_h) __macem32_ss_x_hh_aux(__macem32_ss_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __macem32_ss_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1396, INST: macem32.su.x Da.h,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macem32_su_x_hl(Word40 __Dn, Word32 __Da_h, Word32 __Db_l);
Word40 __macem32_su_x_hl_aux(Word40 __Dres, Word40 __Dn);
Word40 __macem32_su_x_hl_read(Word32 __Da_h, Word32 __Db_l);
#define __macem32_su_x_hl(__Dn, __Da_h, __Db_l) __macem32_su_x_hl_aux(__macem32_su_x_hl_read(__Da_h, __Db_l), __Dn)
#else 
PROTOTYPE_API Word40 __macem32_su_x_hl(Word40 __Dn, Word32 __Da_h, Word32 __Db_l);
#endif 

	/*ID: 1397, INST: macem32.us.x Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macem32_us_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
Word40 __macem32_us_x_lh_aux(Word40 __Dres, Word40 __Dn);
Word40 __macem32_us_x_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __macem32_us_x_lh(__Dn, __Da_l, __Db_h) __macem32_us_x_lh_aux(__macem32_us_x_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __macem32_us_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1398, INST: macem32.us.i.x Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macem32_us_i_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
Word40 __macem32_us_i_x_lh_aux(Word40 __Dres, Word40 __Dn);
Word40 __macem32_us_i_x_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __macem32_us_i_x_lh(__Dn, __Da_l, __Db_h) __macem32_us_i_x_lh_aux(__macem32_us_i_x_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __macem32_us_i_x_lh(Word40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1399, INST: macem32.uu.x Da.l,Db.l,Dn*/
#ifndef _HOST_EMULATION_ 
UWord40 __macem32_uu_x_ll(UWord40 __Dn, Word32 __Da_l, Word32 __Db_l);
UWord40 __macem32_uu_x_ll_aux(UWord40 __Dres, UWord40 __Dn);
UWord40 __macem32_uu_x_ll_read(Word32 __Da_l, Word32 __Db_l);
#define __macem32_uu_x_ll(__Dn, __Da_l, __Db_l) __macem32_uu_x_ll_aux(__macem32_uu_x_ll_read(__Da_l, __Db_l), __Dn)
#else 
PROTOTYPE_API UWord40 __macem32_uu_x_ll(UWord40 __Dn, Word32 __Da_l, Word32 __Db_l);
#endif 

	/*ID: 1400, INST: macem32.uu.i.x Da.l,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
UWord40 __macem32_uu_i_x_lh(UWord40 __Dn, Word32 __Da_l, Word32 __Db_h);
UWord40 __macem32_uu_i_x_lh_aux(UWord40 __Dres, UWord40 __Dn);
UWord40 __macem32_uu_i_x_lh_read(Word32 __Da_l, Word32 __Db_h);
#define __macem32_uu_i_x_lh(__Dn, __Da_l, __Db_h) __macem32_uu_i_x_lh_aux(__macem32_uu_i_x_lh_read(__Da_l, __Db_h), __Dn)
#else 
PROTOTYPE_API UWord40 __macem32_uu_i_x_lh(UWord40 __Dn, Word32 __Da_l, Word32 __Db_h);
#endif 

	/*ID: 1401, INST: macem32.xsu.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macem32_xsu_x(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macem32_xsu_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __macem32_xsu_x_read(Word32 __Da, Word32 __Db);
#define __macem32_xsu_x(__Dn, __Da, __Db) __macem32_xsu_x_aux(__macem32_xsu_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macem32_xsu_x(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1402, INST: macem32.xsu.x -Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macem32_xsu_x_m(Word40 __Dn, Word32 __Da, Word32 __Db);
Word40 __macem32_xsu_x_m_aux(Word40 __Dres, Word40 __Dn);
Word40 __macem32_xsu_x_m_read(Word32 __Da, Word32 __Db);
#define __macem32_xsu_x_m(__Dn, __Da, __Db) __macem32_xsu_x_m_aux(__macem32_xsu_x_m_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macem32_xsu_x_m(Word40 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1403, INST: macm.x Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_x_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_x_h(__Dn, __Da_h, __Db) __macm_x_h_aux(__macm_x_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1404, INST: macm.r.x Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_r_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_r_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_r_x_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_r_x_h(__Dn, __Da_h, __Db) __macm_r_x_h_aux(__macm_r_x_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_r_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1405, INST: macm.r.x Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_r_x_l(Word40 __Dn, Word32 __Da_l, Word32 __Db);
Word40 __macm_r_x_l_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_r_x_l_read(Word32 __Da_l, Word32 __Db);
#define __macm_r_x_l(__Dn, __Da_l, __Db) __macm_r_x_l_aux(__macm_r_x_l_read(__Da_l, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_r_x_l(Word40 __Dn, Word32 __Da_l, Word32 __Db);
#endif 

	/*ID: 1406, INST: macm.r.x -Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_r_x_m_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_r_x_m_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_r_x_m_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_r_x_m_h(__Dn, __Da_h, __Db) __macm_r_x_m_h_aux(__macm_r_x_m_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_r_x_m_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1407, INST: macm.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_r_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macm_r_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macm_r_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macm_r_2x_dup(__Dmn, __Da, __Dcd) __macm_r_2x_dup_aux(__macm_r_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macm_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macm_r_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macm_r_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macm_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1408, INST: macm.r.2x Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_r_2x_h_dup(Word40 __Dmn, Word32 __Da_h, Word32 __Dcd);
Word40 __macm_r_2x_h_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macm_r_2x_h_dup_read(Word32 __Da_h, Word32 __Dcd);
#define __macm_r_2x_h_dup(__Dmn, __Da_h, __Dcd) __macm_r_2x_h_dup_aux(__macm_r_2x_h_dup_read(__Da_h, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macm_r_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macm_r_2x_h_dup(*__Dm, __Da_h, __Dc);
	*__Dn =  __macm_r_2x_h_dup(*__Dn, __Da_h, __Dd);
}
#else 
PROTOTYPE_API void __macm_r_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1409, INST: macm.r.2x Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_r_2x_l_dup(Word40 __Dmn, Word32 __Da_l, Word32 __Dcd);
Word40 __macm_r_2x_l_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macm_r_2x_l_dup_read(Word32 __Da_l, Word32 __Dcd);
#define __macm_r_2x_l_dup(__Dmn, __Da_l, __Dcd) __macm_r_2x_l_dup_aux(__macm_r_2x_l_dup_read(__Da_l, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macm_r_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macm_r_2x_l_dup(*__Dm, __Da_l, __Dc);
	*__Dn =  __macm_r_2x_l_dup(*__Dn, __Da_l, __Dd);
}
#else 
PROTOTYPE_API void __macm_r_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1410, INST: macm.sr.x Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_sr_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_sr_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_sr_x_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_sr_x_h(__Dn, __Da_h, __Db) __macm_sr_x_h_aux(__macm_sr_x_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_sr_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1411, INST: macm.sr.x Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_sr_x_l(Word40 __Dn, Word32 __Da_l, Word32 __Db);
Word40 __macm_sr_x_l_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_sr_x_l_read(Word32 __Da_l, Word32 __Db);
#define __macm_sr_x_l(__Dn, __Da_l, __Db) __macm_sr_x_l_aux(__macm_sr_x_l_read(__Da_l, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_sr_x_l(Word40 __Dn, Word32 __Da_l, Word32 __Db);
#endif 

	/*ID: 1412, INST: macm.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_sr_2x_dup(Word40 __Dmn, Word32 __Da, Word32 __Dcd);
Word40 __macm_sr_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macm_sr_2x_dup_read(Word32 __Da, Word32 __Dcd);
#define __macm_sr_2x_dup(__Dmn, __Da, __Dcd) __macm_sr_2x_dup_aux(__macm_sr_2x_dup_read(__Da, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macm_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macm_sr_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __macm_sr_2x_dup(*__Dn, __Da, __Dd);
}
#else 
PROTOTYPE_API void __macm_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1413, INST: macm.sr.2x Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_sr_2x_h_dup(Word40 __Dmn, Word32 __Da_h, Word32 __Dcd);
Word40 __macm_sr_2x_h_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macm_sr_2x_h_dup_read(Word32 __Da_h, Word32 __Dcd);
#define __macm_sr_2x_h_dup(__Dmn, __Da_h, __Dcd) __macm_sr_2x_h_dup_aux(__macm_sr_2x_h_dup_read(__Da_h, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macm_sr_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macm_sr_2x_h_dup(*__Dm, __Da_h, __Dc);
	*__Dn =  __macm_sr_2x_h_dup(*__Dn, __Da_h, __Dd);
}
#else 
PROTOTYPE_API void __macm_sr_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1414, INST: macm.sr.2x Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_sr_2x_l_dup(Word40 __Dmn, Word32 __Da_l, Word32 __Dcd);
Word40 __macm_sr_2x_l_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __macm_sr_2x_l_dup_read(Word32 __Da_l, Word32 __Dcd);
#define __macm_sr_2x_l_dup(__Dmn, __Da_l, __Dcd) __macm_sr_2x_l_dup_aux(__macm_sr_2x_l_dup_read(__Da_l, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __macm_sr_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __macm_sr_2x_l_dup(*__Dm, __Da_l, __Dc);
	*__Dn =  __macm_sr_2x_l_dup(*__Dn, __Da_l, __Dd);
}
#else 
PROTOTYPE_API void __macm_sr_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1415, INST: macm.su.x Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_su_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_su_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_su_x_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_su_x_h(__Dn, __Da_h, __Db) __macm_su_x_h_aux(__macm_su_x_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_su_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1416, INST: macm.su.x -Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_su_x_m_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_su_x_m_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_su_x_m_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_su_x_m_h(__Dn, __Da_h, __Db) __macm_su_x_m_h_aux(__macm_su_x_m_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_su_x_m_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1417, INST: macm.su.log2.x Da.h,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macm_su_log2_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
Word40 __macm_su_log2_x_h_aux(Word40 __Dres, Word40 __Dn);
Word40 __macm_su_log2_x_h_read(Word32 __Da_h, Word32 __Db);
#define __macm_su_log2_x_h(__Dn, __Da_h, __Db) __macm_su_log2_x_h_aux(__macm_su_log2_x_h_read(__Da_h, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __macm_su_log2_x_h(Word40 __Dn, Word32 __Da_h, Word32 __Db);
#endif 

	/*ID: 1418, INST: macm.us.il.l Da.l,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __macm_us_il_l_l(Word32 __Dn, Word32 __Da_l, Word32 __Db);
Word32 __macm_us_il_l_l_aux(Word32 __Dres, Word32 __Dn);
Word32 __macm_us_il_l_l_read(Word32 __Da_l, Word32 __Db);
#define __macm_us_il_l_l(__Dn, __Da_l, __Db) __macm_us_il_l_l_aux(__macm_us_il_l_l_read(__Da_l, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __macm_us_il_l_l(Word32 __Dn, Word32 __Da_l, Word32 __Db);
#endif 

	/*ID: 1419, INST: macq.x Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macq_x_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __macq_x_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macq_x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macq_x_dup(__Dn, __Dab, __Dcd) __macq_x_dup_aux(__macq_x_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macq_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macq_x_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macq_x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macq_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1420, INST: macq.i.x Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macq_i_x_dup(Word40 __Dn, Word32 __Dab, Word32 __Dcd);
Word40 __macq_i_x_dup_aux(Word40 __Dres, Word40 __Dn);
Word40 __macq_i_x_dup_read(Word32 __Dab, Word32 __Dcd);
#define __macq_i_x_dup(__Dn, __Dab, __Dcd) __macq_i_x_dup_aux(__macq_i_x_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __macq_i_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn)
{
	*__Dn =  __macq_i_x_dup(*__Dn, __Da, __Dc);
	*__Dn =  __macq_i_x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __macq_i_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dn);
#endif 

	/*ID: 1421, INST: macshl.s.x Da.h,Db.h,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __macshl_s_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
Word40 __macshl_s_x_hh_aux(Word40 __Dres, Word40 __Dn);
Word40 __macshl_s_x_hh_read(Word32 __Da_h, Word32 __Db_h);
#define __macshl_s_x_hh(__Dn, __Da_h, __Db_h) __macshl_s_x_hh_aux(__macshl_s_x_hh_read(__Da_h, __Db_h), __Dn)
#else 
PROTOTYPE_API Word40 __macshl_s_x_hh(Word40 __Dn, Word32 __Da_h, Word32 __Db_h);
#endif 

	/*ID: 1422, INST: masksel.x Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __masksel_x(Word40 __Dn, Word40 __Da, Word40 __Db);
Word40 __masksel_x_aux(Word40 __Dres, Word40 __Dn);
Word40 __masksel_x_read(Word40 __Da, Word40 __Db);
#define __masksel_x(__Dn, __Da, __Db) __masksel_x_aux(__masksel_x_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word40 __masksel_x(Word40 __Dn, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 1423, INST: masksel.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __masksel_2x_dup(Word40 __Dmn, Word40 __Dab, Word40 __Dcd);
Word40 __masksel_2x_dup_aux(Word40 __Dres, Word40 __Dmn);
Word40 __masksel_2x_dup_read(Word40 __Dab, Word40 __Dcd);
#define __masksel_2x_dup(__Dmn, __Dab, __Dcd) __masksel_2x_dup_aux(__masksel_2x_dup_read(__Dab, __Dcd), __Dmn)
__attribute__((always_inline)) inline void __masksel_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __masksel_2x_dup(*__Dm, __Da, __Dc);
	*__Dn =  __masksel_2x_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __masksel_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1424, INST: max.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __max_2t(Word40 __Da, Word40 __Db);

	/*ID: 1425, INST: max.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __max_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __max_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __max_4t_dup(__Da, __Dc);
	*__Dn =  __max_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __max_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1426, INST: max.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __max_2w(Word32 __Da, Word32 __Db);

	/*ID: 1427, INST: max.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __max_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __max_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __max_4w_dup(__Da, __Dc);
	*__Dn =  __max_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __max_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1428, INST: max.x Da,Db,Dn*/
PROTOTYPE_API Word40 __max_x(Word40 __Da, Word40 __Db);

	/*ID: 1429, INST: max.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __max_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __max_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __max_2x_dup(__Da, __Dc);
	*__Dn =  __max_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __max_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1430, INST: maxa Ra,Rb,Rn*/
PROTOTYPE_API Word32 __maxa(Word32 __Ra, Word32 __Rb);

	/*ID: 1431, INST: maxa Ra,Rb,Rn*/

	/*ID: 1432, INST: maxm.x Da,Db,Dn*/
PROTOTYPE_API Word40 __maxm_x(Word40 __Da, Word40 __Db);

	/*ID: 1433, INST: maxm.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __maxm_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __maxm_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __maxm_2x_dup(__Da, __Dc);
	*__Dn =  __maxm_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __maxm_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1434, INST: min.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __min_2t(Word40 __Da, Word40 __Db);

	/*ID: 1435, INST: min.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __min_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __min_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __min_4t_dup(__Da, __Dc);
	*__Dn =  __min_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __min_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1436, INST: min.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __min_2w(Word32 __Da, Word32 __Db);

	/*ID: 1437, INST: min.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __min_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __min_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __min_4w_dup(__Da, __Dc);
	*__Dn =  __min_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __min_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1438, INST: min.x Da,Db,Dn*/
PROTOTYPE_API Word40 __min_x(Word40 __Da, Word40 __Db);

	/*ID: 1439, INST: min.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __min_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __min_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __min_2x_dup(__Da, __Dc);
	*__Dn =  __min_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __min_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1440, INST: mina Ra,Rb,Rn*/
PROTOTYPE_API Word32 __mina(Word32 __Ra, Word32 __Rb);

	/*ID: 1441, INST: mina Ra,Rb,Rn*/

	/*ID: 1442, INST: move.l #s32_t6,Dn*/

	/*ID: 1443, INST: move.l #s32_t6,Dn*/

	/*ID: 1444, INST: move.l #s9,Dn*/

	/*ID: 1445, INST: move.l #s9,Dn*/

	/*ID: 1446, INST: move.l Da,Dn*/

	/*ID: 1447, INST: move.l Da,Rn*/

	/*ID: 1448, INST: move.l Da,Rn*/

	/*ID: 1449, INST: move.l Da,TMDAT*/

	/*ID: 1450, INST: move.l Ra,Dn*/

	/*ID: 1451, INST: move.l Ra,Dn*/

	/*ID: 1452, INST: move.2l Dab,Dmn*/

	/*ID: 1453, INST: move.2l Dab,Rm,Rn*/

	/*ID: 1454, INST: move.x Da,Dn*/

	/*ID: 1455, INST: move.2x Da,Dmn*/

	/*ID: 1456, INST: move.2x Dab,Dmn*/

	/*ID: 1457, INST: move.4x Da,Db,Dc,Dd,Dmnop*/

	/*ID: 1458, INST: move.par.w #u16_t7,Dn.h*/
PROTOTYPE_API Word32 __move_par_w_h(Word32 __Dn_h, Word32 __imm1);

	/*ID: 1459, INST: move.par.w #u16_t7,Dn.l*/
PROTOTYPE_API Word32 __move_par_w_l(Word32 __Dn_l, Word32 __imm1);

	/*ID: 1460, INST: mpy.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __mpy_2t(Word32 __Da, Word32 __Db);

	/*ID: 1461, INST: mpy.x Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __mpy_x_hh(Word32 __Da_h, Word32 __Db_h);

	/*ID: 1462, INST: mpy.x Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1463, INST: mpy.x Da.h,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_x_hl(Word32 __Da_h, Word32 __Db_l);

	/*ID: 1464, INST: mpy.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpy_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_2x_dup(__Da, __Db);
	*__Dn =  __mpy_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpy_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1465, INST: mpy.h.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_h_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpy_h_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_h_2x_dup(__Da, __Db);
	*__Dn =  __mpy_h_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpy_h_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1466, INST: mpy.h.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_h_s_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpy_h_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_h_s_2x_dup(__Da, __Db);
	*__Dn =  __mpy_h_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpy_h_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1467, INST: mpy.h.sr.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __mpy_h_sr_2w(Word32 __Da, Word32 __Db);

	/*ID: 1468, INST: mpy.hh.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_hh_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_hh_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_hh_2x_dup(__Da, __Dc);
	*__Dn =  __mpy_hh_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_hh_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1469, INST: mpy.hh.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_hh_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_hh_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_hh_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpy_hh_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_hh_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1470, INST: mpy.hh.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpy_hh_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpy_hh_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpy_hh_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpy_hh_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpy_hh_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1471, INST: mpy.i.x #s16_t2,Da.l,Dn*/
PROTOTYPE_API Word40 __mpy_i_x_l(Word32 __imm1, Word32 __Da_l);

	/*ID: 1472, INST: mpy.i.x Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_i_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1473, INST: mpy.l.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_l_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpy_l_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_l_2x_dup(__Da, __Db);
	*__Dn =  __mpy_l_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpy_l_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1474, INST: mpy.l.i.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_l_i_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_l_i_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_l_i_4t_dup(__Da, __Dc);
	*__Dn =  __mpy_l_i_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_l_i_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1475, INST: mpy.l.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_l_s_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpy_l_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_l_s_2x_dup(__Da, __Db);
	*__Dn =  __mpy_l_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpy_l_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1476, INST: mpy.l.sr.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __mpy_l_sr_2w(Word32 __Da, Word32 __Db);

	/*ID: 1477, INST: mpy.leg.x Da.h,Db.h,Dn*/

	/*ID: 1478, INST: mpy.leg.x Da.l,Db.l,Dn*/

	/*ID: 1479, INST: mpy.leg.x Da.h,Db.l,Dn*/

	/*ID: 1480, INST: mpy.ll.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_ll_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_ll_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_ll_2x_dup(__Da, __Dc);
	*__Dn =  __mpy_ll_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_ll_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1481, INST: mpy.ll.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_ll_i_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_ll_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_ll_i_2x_dup(__Da, __Dc);
	*__Dn =  __mpy_ll_i_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_ll_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1482, INST: mpy.ll.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_ll_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_ll_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_ll_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpy_ll_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_ll_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1483, INST: mpy.ll.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpy_ll_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpy_ll_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpy_ll_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpy_ll_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpy_ll_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1484, INST: mpy.r.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __mpy_r_2t(Word32 __Da, Word32 __Db);

	/*ID: 1485, INST: mpy.r.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_r_4t_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_r_4t_da_dup(__Da, __Dc);
	*__Dn =  __mpy_r_4t_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpy_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1486, INST: mpy.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpy_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1487, INST: mpy.r.x Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __mpy_r_x_hh(Word32 __Da_h, Word32 __Db_h);

	/*ID: 1488, INST: mpy.r.x Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_r_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1489, INST: mpy.r.x Da.l,Db.h,Dn*/
PROTOTYPE_API Word40 __mpy_r_x_lh(Word32 __Da_l, Word32 __Db_h);

	/*ID: 1490, INST: mpy.rleg.x Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __mpy_rleg_x_hh(Word32 __Da_h, Word32 __Db_h);

	/*ID: 1491, INST: mpy.rleg.x Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_rleg_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1492, INST: mpy.rleg.x Da.l,Db.h,Dn*/
PROTOTYPE_API Word40 __mpy_rleg_x_lh(Word32 __Da_l, Word32 __Db_h);

	/*ID: 1493, INST: mpy.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __mpy_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1494, INST: mpy.s.x Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __mpy_s_x_hh(Word32 __Da_h, Word32 __Db_h);

	/*ID: 1495, INST: mpy.s.x Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_s_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1496, INST: mpy.s.x Da.h,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_s_x_hl(Word32 __Da_h, Word32 __Db_l);

	/*ID: 1497, INST: mpy.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy_s_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpy_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy_s_2x_dup(__Da, __Db);
	*__Dn =  __mpy_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpy_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1498, INST: mpy.sr.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __mpy_sr_2w(Word32 __Da, Word32 __Db);

	/*ID: 1499, INST: mpy.sr.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpy_sr_4w_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpy_sr_4w_da_dup(__Da, __Dc);
	*__Dn =  __mpy_sr_4w_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpy_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1500, INST: mpy.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpy_sr_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpy_sr_4w_dup(__Da, __Dc);
	*__Dn =  __mpy_sr_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1501, INST: mpy.su.i.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __mpy_su_i_2t(Word32 __Da, Word32 __Db);

	/*ID: 1502, INST: mpy.us.i.x Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __mpy_us_i_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1503, INST: mpy.uu.i.x Da.l,Db.l,Dn*/
PROTOTYPE_API UWord40 __mpy_uu_i_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1504, INST: mpy32.ll Da,Db,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __mpy32_ll(Word32 __Da, Word32 __Db);
#endif

	/*ID: 1505, INST: mpy32.i.ll Da,Db,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __mpy32_i_ll(Word32 __Da, Word32 __Db);
#endif

	/*ID: 1506, INST: mpy32.il.l Da,Db,Dn*/
PROTOTYPE_API Word32 __mpy32_il_l(Word32 __Da, Word32 __Db);

	/*ID: 1507, INST: mpy32.pnx.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy32_pnx_r_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy32_pnx_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy32_pnx_r_2x_dup(__Da, __Dc);
	*__Dn =  __mpy32_pnx_r_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpy32_pnx_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1508, INST: mpy32.r.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpy32_r_x(Word32 __Da, Word32 __Db);

	/*ID: 1509, INST: mpy32.r.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy32_r_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy32_r_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy32_r_2x_dup(__Da, __Dc);
	*__Dn =  __mpy32_r_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy32_r_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1510, INST: mpy32.sr.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpy32_sr_x(Word32 __Da, Word32 __Db);

	/*ID: 1511, INST: mpy32.sr.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpy32_sr_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpy32_sr_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpy32_sr_2x_dup(__Da, __Dc);
	*__Dn =  __mpy32_sr_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpy32_sr_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1512, INST: mpy32.su.i.ll Da,Db,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __mpy32_su_i_ll(Word32 __Da, Word32 __Db);
#endif

	/*ID: 1513, INST: mpy32.uu.i.ll Da,Db,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API UInt64 __mpy32_uu_i_ll(Word32 __Da, Word32 __Db);
#endif

	/*ID: 1514, INST: mpy32a.i #s16,Ra,Rn*/
PROTOTYPE_API Word32 __mpy32a_i(Word32 __imm1, Word32 __Ra);

	/*ID: 1515, INST: mpy32a.i Ra,Rb,Rn*/

	/*ID: 1516, INST: mpyadda.i #u16_t6,Ra,Rb,Rn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpyadda_i(Word32 __imm1, Word32 __Ra, Word32 __Rb);
Word32 __mpyadda_i_aux(Word32 __Rres, Word32 __Rb);
Word32 __mpyadda_i_read(Word32 __imm1, Word32 __Ra);
#define __mpyadda_i(__imm1, __Ra, __Rb) __mpyadda_i_aux(__mpyadda_i_read(__imm1, __Ra), __Rb)
#else 
PROTOTYPE_API Word32 __mpyadda_i(Word32 __imm1, Word32 __Ra, Word32 __Rb);
#endif 

	/*ID: 1517, INST: mpycx.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpycx_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_2x_dup(__Da, __Db);
	*__Dn =  __mpycx_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpycx_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1518, INST: mpycx.c.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_c_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpycx_c_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_c_2x_dup(__Da, __Db);
	*__Dn =  __mpycx_c_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpycx_c_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1519, INST: mpycx.c.r.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __mpycx_c_r_2t(Word32 __Da, Word32 __Db);

	/*ID: 1520, INST: mpycx.c.r.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_c_r_4t_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_c_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_c_r_4t_da_dup(__Da, __Dc);
	*__Dn =  __mpycx_c_r_4t_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_c_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1521, INST: mpycx.c.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_c_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_c_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_c_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpycx_c_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_c_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1522, INST: mpycx.c.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_c_s_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpycx_c_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_c_s_2x_dup(__Da, __Db);
	*__Dn =  __mpycx_c_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpycx_c_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1523, INST: mpycx.c.sr.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __mpycx_c_sr_2w(Word32 __Da, Word32 __Db);

	/*ID: 1524, INST: mpycx.c.sr.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycx_c_sr_4w_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_c_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpycx_c_sr_4w_da_dup(__Da, __Dc);
	*__Dn =  __mpycx_c_sr_4w_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_c_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1525, INST: mpycx.c.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycx_c_sr_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_c_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpycx_c_sr_4w_dup(__Da, __Dc);
	*__Dn =  __mpycx_c_sr_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_c_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1526, INST: mpycx.i.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_i_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpycx_i_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_i_2x_dup(__Da, __Db);
	*__Dn =  __mpycx_i_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpycx_i_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1527, INST: mpycx.ir.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_ir_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_ir_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_ir_4t_dup(__Da, __Dc);
	*__Dn =  __mpycx_ir_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_ir_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1528, INST: mpycx.r.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __mpycx_r_2t(Word32 __Da, Word32 __Db);

	/*ID: 1529, INST: mpycx.r.4t Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_r_4t_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_r_4t_da_dup(__Da, __Dc);
	*__Dn =  __mpycx_r_4t_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_r_4t_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1530, INST: mpycx.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpycx_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1531, INST: mpycx.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycx_s_2x_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __mpycx_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycx_s_2x_dup(__Da, __Db);
	*__Dn =  __mpycx_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __mpycx_s_2x(Word32 __Da, Word32 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1532, INST: mpycx.sr.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __mpycx_sr_2w(Word32 __Da, Word32 __Db);

	/*ID: 1533, INST: mpycx.sr.4w Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycx_sr_4w_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpycx_sr_4w_da_dup(__Da, __Dc);
	*__Dn =  __mpycx_sr_4w_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_sr_4w_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1534, INST: mpycx.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycx_sr_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycx_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpycx_sr_4w_dup(__Da, __Dc);
	*__Dn =  __mpycx_sr_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycx_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1535, INST: mpycxd.cpn.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpn_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpn_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpn_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1536, INST: mpycxd.cpn.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpn_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpn_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpn_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1537, INST: mpycxd.cpn.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpn_s_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpn_s_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpn_s_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1538, INST: mpycxd.cpn.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpn_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpn_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpn_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1539, INST: mpycxd.cpn.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycxd_cpn_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpycxd_cpn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpycxd_cpn_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpycxd_cpn_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpycxd_cpn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1540, INST: mpycxd.cpp.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpp_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpp_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpp_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1541, INST: mpycxd.cpp.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpp_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpp_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpp_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1542, INST: mpycxd.cpp.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpp_i_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpp_i_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpp_i_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1543, INST: mpycxd.cpp.is.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpp_is_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpp_is_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpp_is_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1544, INST: mpycxd.cpp.isr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycxd_cpp_isr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpycxd_cpp_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpycxd_cpp_isr_2w_dup(__Da, __Dc);
	__Dn =  __mpycxd_cpp_isr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpycxd_cpp_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1545, INST: mpycxd.cpp.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpp_s_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpp_s_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpp_s_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1546, INST: mpycxd.cpp.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_cpp_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_cpp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_cpp_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_cpp_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_cpp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1547, INST: mpycxd.cpp.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycxd_cpp_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpycxd_cpp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpycxd_cpp_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpycxd_cpp_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpycxd_cpp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1548, INST: mpycxd.pn.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pn_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pn_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pn_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pn_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1549, INST: mpycxd.pn.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pn_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pn_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pn_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pn_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1550, INST: mpycxd.pn.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pn_i_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pn_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pn_i_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pn_i_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pn_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1551, INST: mpycxd.pn.is.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pn_is_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pn_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pn_is_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pn_is_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pn_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1552, INST: mpycxd.pn.isr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycxd_pn_isr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpycxd_pn_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpycxd_pn_isr_2w_dup(__Da, __Dc);
	__Dn =  __mpycxd_pn_isr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpycxd_pn_isr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1553, INST: mpycxd.pn.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pn_s_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pn_s_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pn_s_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pn_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1554, INST: mpycxd.pn.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pn_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pn_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pn_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pn_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1555, INST: mpycxd.pn.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycxd_pn_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpycxd_pn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpycxd_pn_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpycxd_pn_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpycxd_pn_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1556, INST: mpycxd.pp.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pp_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pp_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pp_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pp_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1557, INST: mpycxd.pp.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pp_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pp_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pp_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pp_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1558, INST: mpycxd.pp.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pp_i_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pp_i_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pp_i_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pp_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1559, INST: mpycxd.pp.is.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pp_is_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pp_is_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pp_is_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pp_is_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1560, INST: mpycxd.pp.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pp_s_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pp_s_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pp_s_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pp_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1561, INST: mpycxd.pp.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxd_pp_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxd_pp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxd_pp_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxd_pp_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpycxd_pp_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1562, INST: mpycxd.pp.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpycxd_pp_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpycxd_pp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpycxd_pp_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpycxd_pp_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpycxd_pp_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1563, INST: mpycxm.c.ir.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxm_c_ir_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxm_c_ir_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxm_c_ir_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxm_c_ir_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxm_c_ir_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1564, INST: mpycxm.c.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxm_c_r_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxm_c_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxm_c_r_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxm_c_r_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxm_c_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1565, INST: mpycxm.c.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxm_c_sr_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxm_c_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxm_c_sr_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxm_c_sr_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxm_c_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1566, INST: mpycxm.ir.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxm_ir_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxm_ir_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxm_ir_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxm_ir_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxm_ir_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1567, INST: mpycxm.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxm_r_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxm_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxm_r_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxm_r_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxm_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1568, INST: mpycxm.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpycxm_sr_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpycxm_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpycxm_sr_2x_dup(__Da, __Dc);
	*__Dn =  __mpycxm_sr_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpycxm_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1569, INST: mpyd.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_x(Word32 __Da, Word32 __Db);

	/*ID: 1570, INST: mpyd.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpyd_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1571, INST: mpyd.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1572, INST: mpyd.cim.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_cim_x(Word32 __Da, Word32 __Db);

	/*ID: 1573, INST: mpyd.cim.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_cim_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_cim_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_cim_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_cim_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_cim_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1574, INST: mpyd.cim.leg.x -Da,Db,Dn*/

	/*ID: 1575, INST: mpyd.cim.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_cim_r_2t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpyd_cim_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpyd_cim_r_2t_dup(__Da, __Dc);
	__Dn =  __mpyd_cim_r_2t_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpyd_cim_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1576, INST: mpyd.cim.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_cim_s_x(Word32 __Da, Word32 __Db);

	/*ID: 1577, INST: mpyd.cim.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_cim_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_cim_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_cim_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_cim_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_cim_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1578, INST: mpyd.cim.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpyd_cim_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpyd_cim_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpyd_cim_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpyd_cim_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpyd_cim_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1579, INST: mpyd.i.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_i_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_i_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_i_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_i_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1580, INST: mpyd.im.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_im_x(Word32 __Da, Word32 __Db);

	/*ID: 1581, INST: mpyd.im.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_im_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_im_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_im_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_im_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_im_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1582, INST: mpyd.im.leg.x Da,Db,Dn*/

	/*ID: 1583, INST: mpyd.im.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_im_r_2t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpyd_im_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpyd_im_r_2t_dup(__Da, __Dc);
	__Dn =  __mpyd_im_r_2t_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpyd_im_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1584, INST: mpyd.im.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_im_s_x(Word32 __Da, Word32 __Db);

	/*ID: 1585, INST: mpyd.im.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_im_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_im_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_im_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_im_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_im_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1586, INST: mpyd.im.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpyd_im_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpyd_im_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpyd_im_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpyd_im_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpyd_im_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1587, INST: mpyd.leg.x Da,Db,Dn*/

	/*ID: 1588, INST: mpyd.leg.x -Da,Db,Dn*/

	/*ID: 1589, INST: mpyd.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_r_2t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpyd_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpyd_r_2t_dup(__Da, __Dc);
	__Dn =  __mpyd_r_2t_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpyd_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1590, INST: mpyd.re.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_re_x(Word32 __Da, Word32 __Db);

	/*ID: 1591, INST: mpyd.re.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_re_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_re_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_re_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_re_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_re_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1592, INST: mpyd.re.leg.x Da,Db,Dn*/

	/*ID: 1593, INST: mpyd.re.r.2t Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_re_r_2t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpyd_re_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpyd_re_r_2t_dup(__Da, __Dc);
	__Dn =  __mpyd_re_r_2t_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpyd_re_r_2t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1594, INST: mpyd.re.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_re_s_x(Word32 __Da, Word32 __Db);

	/*ID: 1595, INST: mpyd.re.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_re_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_re_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_re_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_re_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_re_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1596, INST: mpyd.re.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpyd_re_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpyd_re_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpyd_re_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpyd_re_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpyd_re_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1597, INST: mpyd.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyd_s_x(Word32 __Da, Word32 __Db);

	/*ID: 1598, INST: mpyd.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_s_2x_da_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_s_2x_da_dup(__Da, __Dc);
	*__Dn =  __mpyd_s_2x_da_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_s_2x_da(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1599, INST: mpyd.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyd_s_2x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpyd_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpyd_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpyd_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpyd_s_2x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1600, INST: mpyd.sr.2w Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpyd_sr_2w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpyd_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpyd_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpyd_sr_2w_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpyd_sr_2w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1601, INST: mpydcf.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydcf_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydcf_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydcf_2x_dup(__Da, __Dc);
	*__Dn =  __mpydcf_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpydcf_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1602, INST: mpydcf.h.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydcf_h_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydcf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydcf_h_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpydcf_h_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydcf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1603, INST: mpydcf.inv.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydcf_inv_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydcf_inv_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydcf_inv_2x_dup(__Da, __Dc);
	*__Dn =  __mpydcf_inv_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpydcf_inv_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1604, INST: mpydcf.invh.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydcf_invh_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydcf_invh_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydcf_invh_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpydcf_invh_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydcf_invh_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1605, INST: mpydcf.invl.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydcf_invl_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydcf_invl_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydcf_invl_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpydcf_invl_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydcf_invl_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1606, INST: mpydcf.l.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydcf_l_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydcf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydcf_l_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpydcf_l_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydcf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1607, INST: mpydem32.su.i.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpydem32_su_i_x(Word32 __Da, Word32 __Db);

	/*ID: 1608, INST: mpydem32.uu.i.x Da,Db,Dn*/
PROTOTYPE_API UWord40 __mpydem32_uu_i_x(Word32 __Da, Word32 __Db);

	/*ID: 1609, INST: mpydrf.h.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_h_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_h_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydrf_h_2x_dup(__Da, __Dc);
	*__Dn =  __mpydrf_h_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_h_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1610, INST: mpydrf.h.r.2t Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_h_r_2t_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpydrf_h_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpydrf_h_r_2t_dup(__Da, __Dc);
	__Dn =  __mpydrf_h_r_2t_dup(__Da, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpydrf_h_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1611, INST: mpydrf.h.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_h_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydrf_h_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpydrf_h_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_h_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1612, INST: mpydrf.h.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_h_s_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_h_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydrf_h_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpydrf_h_s_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_h_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1613, INST: mpydrf.h.sr.2w Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpydrf_h_sr_2w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpydrf_h_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpydrf_h_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpydrf_h_sr_2w_dup(__Da, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpydrf_h_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1614, INST: mpydrf.h.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpydrf_h_sr_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_h_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpydrf_h_sr_4w_dup(__Da, __Dc);
	*__Dn =  __mpydrf_h_sr_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_h_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1615, INST: mpydrf.l.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_l_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_l_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydrf_l_2x_dup(__Da, __Dc);
	*__Dn =  __mpydrf_l_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_l_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1616, INST: mpydrf.l.r.2t Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_l_r_2t_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpydrf_l_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpydrf_l_r_2t_dup(__Da, __Dc);
	__Dn =  __mpydrf_l_r_2t_dup(__Da, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpydrf_l_r_2t(Word32 __Da, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1617, INST: mpydrf.l.r.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_l_r_4t_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydrf_l_r_4t_dup(__Da, __Dc);
	*__Dn =  __mpydrf_l_r_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_l_r_4t(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1618, INST: mpydrf.l.s.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpydrf_l_s_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_l_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpydrf_l_s_2x_dup(__Da, __Dc);
	*__Dn =  __mpydrf_l_s_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_l_s_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1619, INST: mpydrf.l.sr.2w Da,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpydrf_l_sr_2w_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline Word32 __mpydrf_l_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd)
{
	Word32 __Dn;
	__Dn =  __mpydrf_l_sr_2w_dup(__Da, __Dc);
	__Dn =  __mpydrf_l_sr_2w_dup(__Da, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word32 __mpydrf_l_sr_2w(Word32 __Da, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1620, INST: mpydrf.l.sr.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __mpydrf_l_sr_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpydrf_l_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __mpydrf_l_sr_4w_dup(__Da, __Dc);
	*__Dn =  __mpydrf_l_sr_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __mpydrf_l_sr_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1621, INST: mpyem32.su.i.x Da.h,Db.l,Dn*/
PROTOTYPE_API Word40 __mpyem32_su_i_x_hl(Word32 __Da_h, Word32 __Db_l);

	/*ID: 1622, INST: mpyem32.us.x Da.l,Db.h,Dn*/
PROTOTYPE_API Word40 __mpyem32_us_x_lh(Word32 __Da_l, Word32 __Db_h);

	/*ID: 1623, INST: mpyem32.uu.x Da.l,Db.l,Dn*/
PROTOTYPE_API UWord40 __mpyem32_uu_x_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1624, INST: mpyem32.uu.i.x Da.h,Db.l,Dn*/
PROTOTYPE_API UWord40 __mpyem32_uu_i_x_hl(Word32 __Da_h, Word32 __Db_l);

	/*ID: 1625, INST: mpyem32.xsu.x Da,Db,Dn*/
PROTOTYPE_API Word40 __mpyem32_xsu_x(Word32 __Da, Word32 __Db);

	/*ID: 1626, INST: mpym.x Da.h,Db,Dn*/
PROTOTYPE_API Word40 __mpym_x_h(Word32 __Da_h, Word32 __Db);

	/*ID: 1627, INST: mpym.i.ll Da.h,Db,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __mpym_i_ll_h(Word32 __Da_h, Word32 __Db);
#endif

	/*ID: 1628, INST: mpym.i.ll Da.l,Db,Dmn*/
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
PROTOTYPE_API Int64 __mpym_i_ll_l(Word32 __Da_l, Word32 __Db);
#endif

	/*ID: 1629, INST: mpym.r.x Da.h,Db,Dn*/
PROTOTYPE_API Word40 __mpym_r_x_h(Word32 __Da_h, Word32 __Db);

	/*ID: 1630, INST: mpym.r.x Da.l,Db,Dn*/
PROTOTYPE_API Word40 __mpym_r_x_l(Word32 __Da_l, Word32 __Db);

	/*ID: 1631, INST: mpym.r.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpym_r_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpym_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpym_r_2x_dup(__Da, __Dc);
	*__Dn =  __mpym_r_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpym_r_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1632, INST: mpym.r.2x Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpym_r_2x_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpym_r_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpym_r_2x_h_dup(__Da_h, __Dc);
	*__Dn =  __mpym_r_2x_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __mpym_r_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1633, INST: mpym.r.2x Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpym_r_2x_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpym_r_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpym_r_2x_l_dup(__Da_l, __Dc);
	*__Dn =  __mpym_r_2x_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __mpym_r_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1634, INST: mpym.sr.x Da.h,Db,Dn*/
PROTOTYPE_API Word40 __mpym_sr_x_h(Word32 __Da_h, Word32 __Db);

	/*ID: 1635, INST: mpym.sr.x Da.l,Db,Dn*/
PROTOTYPE_API Word40 __mpym_sr_x_l(Word32 __Da_l, Word32 __Db);

	/*ID: 1636, INST: mpym.sr.2x Da,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpym_sr_2x_dup(Word32 __Da, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpym_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpym_sr_2x_dup(__Da, __Dc);
	*__Dn =  __mpym_sr_2x_dup(__Da, __Dd);
}
#else 
PROTOTYPE_API void __mpym_sr_2x(Word32 __Da, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1637, INST: mpym.sr.2x Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpym_sr_2x_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpym_sr_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpym_sr_2x_h_dup(__Da_h, __Dc);
	*__Dn =  __mpym_sr_2x_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __mpym_sr_2x_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1638, INST: mpym.sr.2x Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpym_sr_2x_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __mpym_sr_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __mpym_sr_2x_l_dup(__Da_l, __Dc);
	*__Dn =  __mpym_sr_2x_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __mpym_sr_2x_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1639, INST: mpym.us.il.l Da.l,Db,Dn*/
PROTOTYPE_API Word32 __mpym_us_il_l_l(Word32 __Da_l, Word32 __Db);

	/*ID: 1640, INST: mpyq.x Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyq_x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpyq_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpyq_x_dup(__Da, __Dc);
	__Dn =  __mpyq_x_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpyq_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1641, INST: mpyq.i.x Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word40 __mpyq_i_x_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline Word40 __mpyq_i_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
	Word40 __Dn;
	__Dn =  __mpyq_i_x_dup(__Da, __Dc);
	__Dn =  __mpyq_i_x_dup(__Db, __Dd);
	return __Dn;
}
#else 
PROTOTYPE_API Word40 __mpyq_i_x(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1642, INST: mpyshl.s.x Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __mpyshl_s_x_hh(Word32 __Da_h, Word32 __Db_h);

	/*ID: 1643, INST: msgsnd Ra*/
PROTOTYPE_API void __msgsnd(Word32 __Ra);

	/*ID: 1644, INST: nand.x Da,Db,Dn*/
PROTOTYPE_API Word40 __nand_x(Word40 __Da, Word40 __Db);

	/*ID: 1645, INST: nand.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __nand_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __nand_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __nand_2x_dup(__Da, __Dc);
	*__Dn =  __nand_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __nand_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1646, INST: neg.2t Da,Dn*/
PROTOTYPE_API Word40 __neg_2t(Word40 __Da);

	/*ID: 1647, INST: neg.4t Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __neg_4t_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __neg_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __neg_4t_dup(__Da);
	*__Dn =  __neg_4t_dup(__Db);
}
#else 
PROTOTYPE_API void __neg_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1648, INST: neg.x Da,Dn*/
PROTOTYPE_API Word40 __neg_x(Word40 __Da);

	/*ID: 1649, INST: neg.2x Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __neg_2x_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __neg_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __neg_2x_dup(__Da);
	*__Dn =  __neg_2x_dup(__Db);
}
#else 
PROTOTYPE_API void __neg_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1650, INST: neg.leg.x Da,Dn*/

	/*ID: 1651, INST: neg.s.l Da,Dn*/
PROTOTYPE_API Word32 __neg_s_l(Word32 __Da);

	/*ID: 1652, INST: neg.s.2w Da,Dn*/
PROTOTYPE_API Word32 __neg_s_2w(Word32 __Da);

	/*ID: 1653, INST: neg.s.4w Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __neg_s_4w_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __neg_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __neg_s_4w_dup(__Da);
	*__Dn =  __neg_s_4w_dup(__Db);
}
#else 
PROTOTYPE_API void __neg_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1654, INST: neg.s.x Da,Dn*/
PROTOTYPE_API Word40 __neg_s_x(Word40 __Da);

	/*ID: 1655, INST: neg.s.2x Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __neg_s_2x_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __neg_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __neg_s_2x_dup(__Da);
	*__Dn =  __neg_s_2x_dup(__Db);
}
#else 
PROTOTYPE_API void __neg_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1656, INST: nega Ra,Rn*/
PROTOTYPE_API Word32 __nega(Word32 __Ra);

	/*ID: 1657, INST: nega Ra,Rn*/

	/*ID: 1658, INST: neor.x Da,Db,Dn*/
PROTOTYPE_API Word40 __neor_x(Word40 __Da, Word40 __Db);

	/*ID: 1659, INST: neor.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __neor_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __neor_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __neor_2x_dup(__Da, __Dc);
	*__Dn =  __neor_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __neor_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1660, INST: nop.agu*/
PROTOTYPE_API void __nop_agu();

	/*ID: 1661, INST: nop.agu*/

	/*ID: 1662, INST: nop.dalu*/
PROTOTYPE_API void __nop_dalu();

	/*ID: 1663, INST: nop.dalu*/

	/*ID: 1664, INST: nor.x Da,Db,Dn*/
PROTOTYPE_API Word40 __nor_x(Word40 __Da, Word40 __Db);

	/*ID: 1665, INST: nor.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __nor_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __nor_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __nor_2x_dup(__Da, __Dc);
	*__Dn =  __nor_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __nor_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1666, INST: not.x Da,Dn*/
PROTOTYPE_API Word40 __not_x(Word40 __Da);

	/*ID: 1667, INST: not.2x Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __not_2x_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __not_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __not_2x_dup(__Da);
	*__Dn =  __not_2x_dup(__Db);
}
#else 
PROTOTYPE_API void __not_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1668, INST: nota Ra,Rn*/
PROTOTYPE_API Word32 __nota(Word32 __Ra);

	/*ID: 1669, INST: nota Ra,Rn*/

	/*ID: 1670, INST: notify (Rn)*/
PROTOTYPE_API void __notify(Word8* __p);

	/*ID: 1671, INST: or.l #u32,Da,Dn*/

	/*ID: 1672, INST: or.x Da,Db,Dn*/
PROTOTYPE_API Word40 __or_x(Word40 __Da, Word40 __Db);

	/*ID: 1673, INST: or.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __or_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __or_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __or_2x_dup(__Da, __Dc);
	*__Dn =  __or_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __or_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1674, INST: ora Ra,Rb,Rn*/

	/*ID: 1675, INST: ora Ra,Rb,Rn*/

	/*ID: 1676, INST: pack.b.4b Da,Db,Dn*/
PROTOTYPE_API Word32 __pack_b_4b(Word32 __Da, Word32 __Db);

	/*ID: 1677, INST: pack.bh.8b Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_bh_8b_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_bh_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_bh_8b_dup(__Da, __Dc);
	*__Dn =  __pack_bh_8b_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_bh_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1678, INST: pack.bl.8b Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_bl_8b_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_bl_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_bl_8b_dup(__Da, __Dc);
	*__Dn =  __pack_bl_8b_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_bl_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1679, INST: pack.f.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __pack_f_2t(Word40 __Da, Word40 __Db);

	/*ID: 1680, INST: pack.h.4b Da,Db,Dn*/
PROTOTYPE_API Word32 __pack_h_4b(Word32 __Da, Word32 __Db);

	/*ID: 1681, INST: pack.h.8b Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_h_8b_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_h_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_h_8b_dup(__Da, __Dc);
	*__Dn =  __pack_h_8b_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_h_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1682, INST: pack.hhhh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hhhh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hhhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hhhh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hhhh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hhhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1683, INST: pack.hhhl.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hhhl_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hhhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hhhl_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hhhl_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hhhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1684, INST: pack.hhlh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hhlh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hhlh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hhlh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hhlh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hhlh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1685, INST: pack.hhll.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hhll_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hhll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hhll_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hhll_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hhll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1686, INST: pack.hl.8b Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_hl_8b_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __pack_hl_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_hl_8b_dup(__Da, __Db);
	*__Dn =  __pack_hl_8b_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __pack_hl_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1687, INST: pack.hlhh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hlhh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hlhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hlhh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hlhh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hlhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1688, INST: pack.hlhl.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hlhl_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hlhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hlhl_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hlhl_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hlhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1689, INST: pack.hllh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hllh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hllh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hllh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hllh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hllh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1690, INST: pack.hlll.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_hlll_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_hlll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_hlll_4t_dup(__Da, __Dc);
	*__Dn =  __pack_hlll_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_hlll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1691, INST: pack.ins0.h3.4w Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins0_h3_4w_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins0_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins0_h3_4w_h_dup(__Da_h, __Dc);
	*__Dn =  __pack_ins0_h3_4w_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins0_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1692, INST: pack.ins0.h3.4w Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins0_h3_4w_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins0_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins0_h3_4w_l_dup(__Da_l, __Dc);
	*__Dn =  __pack_ins0_h3_4w_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins0_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1693, INST: pack.ins0.l3.4w Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins0_l3_4w_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins0_l3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins0_l3_4w_h_dup(__Da_h, __Dc);
	*__Dn =  __pack_ins0_l3_4w_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins0_l3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1694, INST: pack.ins0.l3.4w Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins0_l3_4w_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins0_l3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins0_l3_4w_l_dup(__Da_l, __Dc);
	*__Dn =  __pack_ins0_l3_4w_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins0_l3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1695, INST: pack.ins1.h3.4w Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins1_h3_4w_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins1_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins1_h3_4w_h_dup(__Da_h, __Dc);
	*__Dn =  __pack_ins1_h3_4w_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins1_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1696, INST: pack.ins1.h3.4w Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins1_h3_4w_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins1_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins1_h3_4w_l_dup(__Da_l, __Dc);
	*__Dn =  __pack_ins1_h3_4w_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins1_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1697, INST: pack.ins2.h3.4w Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins2_h3_4w_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins2_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins2_h3_4w_h_dup(__Da_h, __Dc);
	*__Dn =  __pack_ins2_h3_4w_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins2_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1698, INST: pack.ins2.h3.4w Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins2_h3_4w_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins2_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins2_h3_4w_l_dup(__Da_l, __Dc);
	*__Dn =  __pack_ins2_h3_4w_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins2_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1699, INST: pack.ins3.h3.4w Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins3_h3_4w_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins3_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins3_h3_4w_h_dup(__Da_h, __Dc);
	*__Dn =  __pack_ins3_h3_4w_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins3_h3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1700, INST: pack.ins3.h3.4w Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins3_h3_4w_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins3_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins3_h3_4w_l_dup(__Da_l, __Dc);
	*__Dn =  __pack_ins3_h3_4w_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins3_h3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1701, INST: pack.ins3.l3.4w Da.h,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins3_l3_4w_h_dup(Word32 __Da_h, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins3_l3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins3_l3_4w_h_dup(__Da_h, __Dc);
	*__Dn =  __pack_ins3_l3_4w_h_dup(__Da_h, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins3_l3_4w_h(Word32 __Da_h, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1702, INST: pack.ins3.l3.4w Da.l,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_ins3_l3_4w_l_dup(Word32 __Da_l, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_ins3_l3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_ins3_l3_4w_l_dup(__Da_l, __Dc);
	*__Dn =  __pack_ins3_l3_4w_l_dup(__Da_l, __Dd);
}
#else 
PROTOTYPE_API void __pack_ins3_l3_4w_l(Word32 __Da_l, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1703, INST: pack.l.4b Da,Db,Dn*/
PROTOTYPE_API Word32 __pack_l_4b(Word32 __Da, Word32 __Db);

	/*ID: 1704, INST: pack.l.8b Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_l_8b_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_l_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_l_8b_dup(__Da, __Dc);
	*__Dn =  __pack_l_8b_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_l_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1705, INST: pack.l.s.2w Da,Db,Dn*/
PROTOTYPE_API Word40 __pack_l_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1706, INST: pack.l.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_l_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __pack_l_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_l_s_4w_dup(__Da, __Dc);
	*__Dn =  __pack_l_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_l_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1707, INST: pack.lh.8b Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_lh_8b_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __pack_lh_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_lh_8b_dup(__Da, __Db);
	*__Dn =  __pack_lh_8b_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __pack_lh_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1708, INST: pack.lhhh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_lhhh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_lhhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_lhhh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_lhhh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_lhhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1709, INST: pack.lhhl.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_lhhl_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_lhhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_lhhl_4t_dup(__Da, __Dc);
	*__Dn =  __pack_lhhl_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_lhhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1710, INST: pack.lhlh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_lhlh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_lhlh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_lhlh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_lhlh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_lhlh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1711, INST: pack.lhll.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_lhll_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_lhll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_lhll_4t_dup(__Da, __Dc);
	*__Dn =  __pack_lhll_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_lhll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1712, INST: pack.llhh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_llhh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_llhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_llhh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_llhh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_llhh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1713, INST: pack.llhl.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_llhl_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_llhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_llhl_4t_dup(__Da, __Dc);
	*__Dn =  __pack_llhl_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_llhl_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1714, INST: pack.lllh.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_lllh_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_lllh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_lllh_4t_dup(__Da, __Dc);
	*__Dn =  __pack_lllh_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_lllh_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1715, INST: pack.llll.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_llll_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_llll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_llll_4t_dup(__Da, __Dc);
	*__Dn =  __pack_llll_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_llll_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1716, INST: pack.t.2t Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __pack_t_2t_hh(Word40 __Da_h, Word40 __Db_h);

	/*ID: 1717, INST: pack.t.2t Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __pack_t_2t_ll(Word40 __Da_l, Word40 __Db_l);

	/*ID: 1718, INST: pack.t.2t Da.h,Db.l,Dn*/
PROTOTYPE_API Word40 __pack_t_2t_hl(Word40 __Da_h, Word40 __Db_l);

	/*ID: 1719, INST: pack.t.2t Da.l,Db.h,Dn*/
PROTOTYPE_API Word40 __pack_t_2t_lh(Word40 __Da_l, Word40 __Db_h);

	/*ID: 1720, INST: pack.w.2w Da.h,Db.h,Dn*/
PROTOTYPE_API Word40 __pack_w_2w_hh(Word32 __Da_h, Word32 __Db_h);

	/*ID: 1721, INST: pack.w.2w Da.l,Db.l,Dn*/
PROTOTYPE_API Word40 __pack_w_2w_ll(Word32 __Da_l, Word32 __Db_l);

	/*ID: 1722, INST: pack.w.2w Da.h,Db.l,Dn*/
PROTOTYPE_API Word40 __pack_w_2w_hl(Word32 __Da_h, Word32 __Db_l);

	/*ID: 1723, INST: pack.w.2w Da.l,Db.h,Dn*/
PROTOTYPE_API Word40 __pack_w_2w_lh(Word32 __Da_l, Word32 __Db_h);

	/*ID: 1724, INST: pack.x.s.2f Da,Db,Dn*/
PROTOTYPE_API Word32 __pack_x_s_2f(Word40 __Da, Word40 __Db);

	/*ID: 1725, INST: pack.x.s.4f Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __pack_x_s_4f_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_x_s_4f(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __pack_x_s_4f_dup(__Da, __Dc);
	*__Dn =  __pack_x_s_4f_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_x_s_4f(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1726, INST: pack.x.s.2w Da,Db,Dn*/
PROTOTYPE_API Word40 __pack_x_s_2w(Word40 __Da, Word40 __Db);

	/*ID: 1727, INST: pack.x.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __pack_x_s_4w_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __pack_x_s_4w(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __pack_x_s_4w_dup(__Da, __Dc);
	*__Dn =  __pack_x_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __pack_x_s_4w(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1728, INST: pcalc #u8_t2,Pabc,Pmn*/

	/*ID: 1729, INST: pcalc #u8_t2,Pabc,Pn*/

	/*ID: 1730, INST: pcalca #u8_t2,Pabc,Pmn*/

	/*ID: 1731, INST: pcalca #u8_t2,Pabc,Pn*/

	/*ID: 1732, INST: pcmb.inval.l1 Ra,Rn*/
PROTOTYPE_API Word32 __pcmb_inval_l1(Word32 __Ra);

	/*ID: 1733, INST: pcmb.inval.l12 Ra,Rn*/
PROTOTYPE_API Word32 __pcmb_inval_l12(Word32 __Ra);

	/*ID: 1734, INST: pfetchb.l12 Ra,Rn*/
PROTOTYPE_API Word32 __pfetchb_l12(Word32 __Ra);

	/*ID: 1735, INST: pfetchb.l2 Ra,Rn*/
PROTOTYPE_API Word32 __pfetchb_l2(Word32 __Ra);

	/*ID: 1736, INST: pfetchb.lck.l2 Ra,Rn*/
PROTOTYPE_API Word32 __pfetchb_lck_l2(Word32 __Ra);

	/*ID: 1737, INST: pinita #uena,#uval*/

	/*ID: 1738, INST: pop.l Ca*/

	/*ID: 1739, INST: pop.l Da*/

	/*ID: 1740, INST: pop.l Ra*/

	/*ID: 1741, INST: pop.2l Deo*/

	/*ID: 1742, INST: pop.2l Reo*/

	/*ID: 1743, INST: pop.4l Cxyzw*/

	/*ID: 1744, INST: pop.4l Rxyzw*/

	/*ID: 1745, INST: pop.4x Dxyzw*/

	/*ID: 1746, INST: popc.l Ca*/

	/*ID: 1747, INST: popc.l Da*/

	/*ID: 1748, INST: popc.l Ra*/

	/*ID: 1749, INST: popc.2l Deo*/

	/*ID: 1750, INST: popc.2l Reo*/

	/*ID: 1751, INST: popc.4l Cxyzw*/

	/*ID: 1752, INST: popc.4l Rxyzw*/

	/*ID: 1753, INST: popc.4x Dxyzw*/

	/*ID: 1754, INST: prda.rst #uena,#u12_t1,Ra*/

	/*ID: 1755, INST: prda.swp #uena,#u12_t1,Rn*/

	/*ID: 1756, INST: punlockb.l2 Ra,Rn*/
PROTOTYPE_API Word32 __punlockb_l2(Word32 __Ra);

	/*ID: 1757, INST: push.l Ca*/

	/*ID: 1758, INST: push.l Da*/

	/*ID: 1759, INST: push.l Ra*/

	/*ID: 1760, INST: push.2l Deo*/

	/*ID: 1761, INST: push.2l Reo*/

	/*ID: 1762, INST: push.4l Cxyzw*/

	/*ID: 1763, INST: push.4l Rxyzw*/

	/*ID: 1764, INST: push.4x Dxyzw*/

	/*ID: 1765, INST: pushc.l Ca*/

	/*ID: 1766, INST: pushc.l Da*/

	/*ID: 1767, INST: pushc.l Ra*/

	/*ID: 1768, INST: pushc.2l Deo*/

	/*ID: 1769, INST: pushc.2l Reo*/

	/*ID: 1770, INST: pushc.4l Cxyzw*/

	/*ID: 1771, INST: pushc.4l Rxyzw*/

	/*ID: 1772, INST: pushc.4x Dxyzw*/

	/*ID: 1773, INST: recip Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __recip_dup(Word32 __Da);
__attribute__((always_inline)) inline void __recip(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __recip_dup(__Da);
	*__Dn =  __recip_dup(__Da);
}
#else 
PROTOTYPE_API void __recip(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1774, INST: rnd.leg.x Da,Dn*/

	/*ID: 1775, INST: rol.x Da,Dn*/

	/*ID: 1776, INST: ror.x Da,Dn*/

	/*ID: 1777, INST: rte*/

	/*ID: 1778, INST: rte.cic #u5_t2*/

	/*ID: 1779, INST: rts*/

	/*ID: 1780, INST: rts.nobtb*/

	/*ID: 1781, INST: rts.stk*/

	/*ID: 1782, INST: sad.4b Da,Db,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __sad_4b(Word32 __Dn, Word32 __Da, Word32 __Db);
Word32 __sad_4b_aux(Word32 __Dres, Word32 __Dn);
Word32 __sad_4b_read(Word32 __Da, Word32 __Db);
#define __sad_4b(__Dn, __Da, __Db) __sad_4b_aux(__sad_4b_read(__Da, __Db), __Dn)
#else 
PROTOTYPE_API Word32 __sad_4b(Word32 __Dn, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1783, INST: sad.8b Dab,Dcd,Dn*/
#ifndef _HOST_EMULATION_ 
Word32 __sad_8b_dup(Word32 __Dn, Word32 __Dab, Word32 __Dcd);
Word32 __sad_8b_dup_aux(Word32 __Dres, Word32 __Dn);
Word32 __sad_8b_dup_read(Word32 __Dab, Word32 __Dcd);
#define __sad_8b_dup(__Dn, __Dab, __Dcd) __sad_8b_dup_aux(__sad_8b_dup_read(__Dab, __Dcd), __Dn)
__attribute__((always_inline)) inline void __sad_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn)
{
	*__Dn =  __sad_8b_dup(*__Dn, __Da, __Dc);
	*__Dn =  __sad_8b_dup(*__Dn, __Db, __Dd);
}
#else 
PROTOTYPE_API void __sad_8b(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dn);
#endif 

	/*ID: 1784, INST: sat.l.w Da,Dn*/
PROTOTYPE_API Word40 __sat_l_w(Word32 __Da);

	/*ID: 1785, INST: sat.l.u.w Da,Dn*/
PROTOTYPE_API UWord32 __sat_l_u_w(UWord32 __Da);

	/*ID: 1786, INST: sat.ll.x Dab,Dn*/
#ifndef _HOST_EMULATION_ 
#if defined(_CW_X_SLLD_) || !defined(_ENTERPRISE_C_)
Word40 __sat_ll_x(Int64 __Dab);
#endif
#else 
PROTOTYPE_API Word40 __sat_ll_x(Int64 __Dab);
#endif 

	/*ID: 1787, INST: sat.sc.f Da,Dn*/
PROTOTYPE_API Word40 __sat_sc_f(Word40 __Da);

	/*ID: 1788, INST: sat.sc.2f Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sat_sc_2f_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __sat_sc_2f(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sat_sc_2f_dup(__Da);
	*__Dn =  __sat_sc_2f_dup(__Db);
}
#else 
PROTOTYPE_API void __sat_sc_2f(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1789, INST: sat.t.2w Da,Dn*/
PROTOTYPE_API Word40 __sat_t_2w(Word40 __Da);

	/*ID: 1790, INST: sat.t.4w Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sat_t_4w_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __sat_t_4w(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sat_t_4w_dup(__Da);
	*__Dn =  __sat_t_4w_dup(__Db);
}
#else 
PROTOTYPE_API void __sat_t_4w(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1791, INST: sat.t.u.2w Da,Dn*/
PROTOTYPE_API UWord32 __sat_t_u_2w(UWord40 __Da);

	/*ID: 1792, INST: sat.w.2b Da,Dn*/
PROTOTYPE_API Word32 __sat_w_2b(Word32 __Da);

	/*ID: 1793, INST: sat.w.u.4b Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
UWord32 __sat_w_u_4b_dup(UWord32 __Dab);
__attribute__((always_inline)) inline void __sat_w_u_4b(UWord32 __Da, UWord32 __Db, UWord32* __Dm, UWord32* __Dn)
{
	*__Dm =  __sat_w_u_4b_dup(__Da);
	*__Dn =  __sat_w_u_4b_dup(__Db);
}
#else 
PROTOTYPE_API void __sat_w_u_4b(UWord32 __Da, UWord32 __Db, UWord32* __Dm, UWord32* __Dn);
#endif 

	/*ID: 1794, INST: sat.x.f Da,Dn*/
PROTOTYPE_API Word32 __sat_x_f(Word40 __Da);

	/*ID: 1795, INST: sat.x.l Da,Dn*/
PROTOTYPE_API Word32 __sat_x_l(Word40 __Da);

	/*ID: 1796, INST: sat.x.2l Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sat_x_2l_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __sat_x_2l(Word40 __Da, Word40 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sat_x_2l_dup(__Da);
	*__Dn =  __sat_x_2l_dup(__Db);
}
#else 
PROTOTYPE_API void __sat_x_2l(Word40 __Da, Word40 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1797, INST: sat.x.w Da,Dn*/
PROTOTYPE_API Word40 __sat_x_w(Word40 __Da);

	/*ID: 1798, INST: sat.x.u.l Da,Dn*/
PROTOTYPE_API UWord32 __sat_x_u_l(UWord40 __Da);

	/*ID: 1799, INST: sat.x.u.2w Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
UWord32 __sat_x_u_2w_dup(UWord40 __Dab);
__attribute__((always_inline)) inline void __sat_x_u_2w(UWord40 __Da, UWord40 __Db, UWord32* __Dm, UWord32* __Dn)
{
	*__Dm =  __sat_x_u_2w_dup(__Da);
	*__Dn =  __sat_x_u_2w_dup(__Db);
}
#else 
PROTOTYPE_API void __sat_x_u_2w(UWord40 __Da, UWord40 __Db, UWord32* __Dm, UWord32* __Dn);
#endif 

	/*ID: 1800, INST: scale.f Da,Dn*/
PROTOTYPE_API Word40 __scale_f(Word40 __Da);

	/*ID: 1801, INST: scale.2f Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __scale_2f_dup(Word40 __Dab);
__attribute__((always_inline)) inline void __scale_2f(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __scale_2f_dup(__Da);
	*__Dn =  __scale_2f_dup(__Db);
}
#else 
PROTOTYPE_API void __scale_2f(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1802, INST: setalign Ra,GCR.BAM*/
PROTOTYPE_API void __setalign(Word32 __Ra);

	/*ID: 1803, INST: sign.4w Dab,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sign_4w_dup(Word32 __Dab);
__attribute__((always_inline)) inline void __sign_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sign_4w_dup(__Da);
	*__Dn =  __sign_4w_dup(__Db);
}
#else 
PROTOTYPE_API void __sign_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1804, INST: skip.2 RelAdd19_t1*/

	/*ID: 1805, INST: skip.1 RelAdd19_t1*/

	/*ID: 1806, INST: skip.3 RelAdd19_t1*/

	/*ID: 1807, INST: skip.0 RelAdd19_t1*/

	/*ID: 1808, INST: skip.0.u RelAdd19_t1*/

	/*ID: 1809, INST: skip.1.u RelAdd19_t1*/

	/*ID: 1810, INST: skip.2.u RelAdd19_t1*/

	/*ID: 1811, INST: skip.3.u RelAdd19_t1*/

	/*ID: 1812, INST: sod.aaaai.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aaaai_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_aaaai_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aaaai_4t_dup(__Da, __Dc);
	*__Dn =  __sod_aaaai_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaaai_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1813, INST: sod.aaaai.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_aaaai_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_aaaai_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_aaaai_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_aaaai_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaaai_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1814, INST: sod.aaaax.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aaaax_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_aaaax_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aaaax_4t_dup(__Da, __Dc);
	*__Dn =  __sod_aaaax_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaaax_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1815, INST: sod.aaaax.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_aaaax_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_aaaax_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_aaaax_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_aaaax_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaaax_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1816, INST: sod.aaii.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_aaii_2t(Word40 __Da, Word40 __Db);

	/*ID: 1817, INST: sod.aaii.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aaii_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_aaii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aaii_2x_dup(__Da, __Dc);
	*__Dn =  __sod_aaii_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1818, INST: sod.aaii.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_aaii_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1819, INST: sod.aaii.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aaii_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_aaii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aaii_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_aaii_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1820, INST: sod.aassi.4t Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aassi_4t_dup(Word40 __Da, Word40 __Db);
__attribute__((always_inline)) inline void __sod_aassi_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aassi_4t_dup(__Da, __Db);
	*__Dn =  __sod_aassi_4t_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_aassi_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1821, INST: sod.aassi.s.4w Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_aassi_s_4w_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __sod_aassi_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_aassi_s_4w_dup(__Da, __Db);
	*__Dn =  __sod_aassi_s_4w_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_aassi_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1822, INST: sod.aaxx.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_aaxx_2t(Word40 __Da, Word40 __Db);

	/*ID: 1823, INST: sod.aaxx.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aaxx_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_aaxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aaxx_2x_dup(__Da, __Dc);
	*__Dn =  __sod_aaxx_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1824, INST: sod.aaxx.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_aaxx_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1825, INST: sod.aaxx.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_aaxx_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_aaxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_aaxx_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_aaxx_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_aaxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1826, INST: sod.as.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_as_2x_dup(Word40 __Da, Word40 __Db);
__attribute__((always_inline)) inline void __sod_as_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_as_2x_dup(__Da, __Db);
	*__Dn =  __sod_as_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_as_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1827, INST: sod.as.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_as_s_2x_dup(Word40 __Da, Word40 __Db);
__attribute__((always_inline)) inline void __sod_as_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_as_s_2x_dup(__Da, __Db);
	*__Dn =  __sod_as_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_as_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1828, INST: sod.asasi.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_asasi_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_asasi_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_asasi_4t_dup(__Da, __Dc);
	*__Dn =  __sod_asasi_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asasi_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1829, INST: sod.asasi.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_asasi_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_asasi_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_asasi_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_asasi_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asasi_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1830, INST: sod.asasx.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_asasx_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_asasx_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_asasx_4t_dup(__Da, __Dc);
	*__Dn =  __sod_asasx_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asasx_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1831, INST: sod.asasx.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_asasx_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_asasx_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_asasx_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_asasx_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asasx_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1832, INST: sod.asii.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_asii_2t(Word40 __Da, Word40 __Db);

	/*ID: 1833, INST: sod.asii.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_asii_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_asii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_asii_2x_dup(__Da, __Dc);
	*__Dn =  __sod_asii_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1834, INST: sod.asii.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_asii_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1835, INST: sod.asii.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_asii_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_asii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_asii_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_asii_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1836, INST: sod.asxx.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_asxx_2t(Word40 __Da, Word40 __Db);

	/*ID: 1837, INST: sod.asxx.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_asxx_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_asxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_asxx_2x_dup(__Da, __Dc);
	*__Dn =  __sod_asxx_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1838, INST: sod.asxx.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_asxx_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1839, INST: sod.asxx.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_asxx_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_asxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_asxx_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_asxx_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_asxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1840, INST: sod.sa.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_sa_2x_dup(Word40 __Da, Word40 __Db);
__attribute__((always_inline)) inline void __sod_sa_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_sa_2x_dup(__Da, __Db);
	*__Dn =  __sod_sa_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_sa_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1841, INST: sod.sa.s.2x Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_sa_s_2x_dup(Word40 __Da, Word40 __Db);
__attribute__((always_inline)) inline void __sod_sa_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_sa_s_2x_dup(__Da, __Db);
	*__Dn =  __sod_sa_s_2x_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_sa_s_2x(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1842, INST: sod.saii.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_saii_2t(Word40 __Da, Word40 __Db);

	/*ID: 1843, INST: sod.saii.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_saii_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_saii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_saii_2x_dup(__Da, __Dc);
	*__Dn =  __sod_saii_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_saii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1844, INST: sod.saii.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_saii_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1845, INST: sod.saii.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_saii_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_saii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_saii_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_saii_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_saii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1846, INST: sod.sasai.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_sasai_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_sasai_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_sasai_4t_dup(__Da, __Dc);
	*__Dn =  __sod_sasai_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_sasai_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1847, INST: sod.sasai.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_sasai_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_sasai_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_sasai_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_sasai_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_sasai_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1848, INST: sod.sasax.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_sasax_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_sasax_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_sasax_4t_dup(__Da, __Dc);
	*__Dn =  __sod_sasax_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_sasax_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1849, INST: sod.sasax.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_sasax_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_sasax_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_sasax_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_sasax_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_sasax_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1850, INST: sod.saxx.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_saxx_2t(Word40 __Da, Word40 __Db);

	/*ID: 1851, INST: sod.saxx.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_saxx_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_saxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_saxx_2x_dup(__Da, __Dc);
	*__Dn =  __sod_saxx_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_saxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1852, INST: sod.saxx.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_saxx_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1853, INST: sod.saxx.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_saxx_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_saxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_saxx_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_saxx_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_saxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1854, INST: sod.ssaai.4t Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssaai_4t_dup(Word40 __Da, Word40 __Db);
__attribute__((always_inline)) inline void __sod_ssaai_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssaai_4t_dup(__Da, __Db);
	*__Dn =  __sod_ssaai_4t_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_ssaai_4t(Word40 __Da, Word40 __Db, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1855, INST: sod.ssaai.s.4w Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_ssaai_s_4w_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __sod_ssaai_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_ssaai_s_4w_dup(__Da, __Db);
	*__Dn =  __sod_ssaai_s_4w_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __sod_ssaai_s_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1856, INST: sod.ssii.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_ssii_2t(Word40 __Da, Word40 __Db);

	/*ID: 1857, INST: sod.ssii.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssii_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_ssii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssii_2x_dup(__Da, __Dc);
	*__Dn =  __sod_ssii_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssii_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1858, INST: sod.ssii.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_ssii_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1859, INST: sod.ssii.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssii_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_ssii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssii_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_ssii_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssii_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1860, INST: sod.ssssi.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssssi_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_ssssi_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssssi_4t_dup(__Da, __Dc);
	*__Dn =  __sod_ssssi_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssssi_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1861, INST: sod.ssssi.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_ssssi_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_ssssi_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_ssssi_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_ssssi_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssssi_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1862, INST: sod.ssssx.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssssx_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_ssssx_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssssx_4t_dup(__Da, __Dc);
	*__Dn =  __sod_ssssx_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssssx_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1863, INST: sod.ssssx.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sod_ssssx_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sod_ssssx_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sod_ssssx_s_4w_dup(__Da, __Dc);
	*__Dn =  __sod_ssssx_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssssx_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1864, INST: sod.ssxx.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sod_ssxx_2t(Word40 __Da, Word40 __Db);

	/*ID: 1865, INST: sod.ssxx.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssxx_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_ssxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssxx_2x_dup(__Da, __Dc);
	*__Dn =  __sod_ssxx_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssxx_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1866, INST: sod.ssxx.s.2w Da,Db,Dn*/
PROTOTYPE_API Word32 __sod_ssxx_s_2w(Word32 __Da, Word32 __Db);

	/*ID: 1867, INST: sod.ssxx.s.2x Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sod_ssxx_s_2x_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sod_ssxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sod_ssxx_s_2x_dup(__Da, __Dc);
	*__Dn =  __sod_ssxx_s_2x_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sod_ssxx_s_2x(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1868, INST: sodhl.asas.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sodhl_asas_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sodhl_asas_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sodhl_asas_4t_dup(__Da, __Dc);
	*__Dn =  __sodhl_asas_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sodhl_asas_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1869, INST: sodhl.asas.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sodhl_asas_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sodhl_asas_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sodhl_asas_s_4w_dup(__Da, __Dc);
	*__Dn =  __sodhl_asas_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sodhl_asas_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1870, INST: sodhl.sasa.4t Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __sodhl_sasa_4t_dup(Word40 __Dab, Word40 __Dcd);
__attribute__((always_inline)) inline void __sodhl_sasa_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __sodhl_sasa_4t_dup(__Da, __Dc);
	*__Dn =  __sodhl_sasa_4t_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sodhl_sasa_4t(Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 1871, INST: sodhl.sasa.s.4w Dab,Dcd,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __sodhl_sasa_s_4w_dup(Word32 __Dab, Word32 __Dcd);
__attribute__((always_inline)) inline void __sodhl_sasa_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __sodhl_sasa_s_4w_dup(__Da, __Dc);
	*__Dn =  __sodhl_sasa_s_4w_dup(__Db, __Dd);
}
#else 
PROTOTYPE_API void __sodhl_sasa_s_4w(Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 1872, INST: st.b Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_b(Word8* __p, Word32 __Da)
{
	*__p = __Da;
}
#else
void __st_b(Word8* __p, Word32 __Da);
#endif
#else 
PROTOTYPE_API void __st_b(Word8* __p, Word32 __Da);
#endif 

	/*ID: 1873, INST: st.b Da,(Rn)+*/

	/*ID: 1874, INST: st.b Da,(Rn)+Rk*/

	/*ID: 1875, INST: st.b Da,(Rn)-*/

	/*ID: 1876, INST: st.b Da,(Rn+Rk)*/

	/*ID: 1877, INST: st.b Da,(Rn+s16_t7)*/

	/*ID: 1878, INST: st.b Da,(sp+s16_t7)*/

	/*ID: 1879, INST: st.b Da,(sp-u9)*/

	/*ID: 1880, INST: st.b Ra,(Rn)*/

	/*ID: 1881, INST: st.b Ra,(Rn)+*/

	/*ID: 1882, INST: st.b Ra,(Rn)+Rk*/

	/*ID: 1883, INST: st.b Ra,(Rn)-*/

	/*ID: 1884, INST: st.b Ra,(Rn+Rk)*/

	/*ID: 1885, INST: st.b Ra,(Rn+s16_t7)*/

	/*ID: 1886, INST: st.b Ra,(sp+s16_t7)*/

	/*ID: 1887, INST: st.b Ra,(sp-u9)*/

	/*ID: 1888, INST: st.2b Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_2b_dup(Word8* __p, Word32 __Dab);
__attribute__((always_inline)) inline void __st_2b(Word8* __p, Word32 __Da, Word32 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_2b*)__p = __builtin_vpack(__Da, __Db);
#else
	 __st_2b_dup(__p, __Da);
	 __st_2b_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_2b(Word8* __p, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1889, INST: st.2b Dab,(Rn)+*/

	/*ID: 1890, INST: st.2b Dab,(Rn)+Rk*/

	/*ID: 1891, INST: st.2b Dab,(Rn)-*/

	/*ID: 1892, INST: st.2b Dab,(Rn+Rk)*/

	/*ID: 1893, INST: st.2b Dab,(Rn+s16_t7)*/

	/*ID: 1894, INST: st.2b Rab,(Rn)*/

	/*ID: 1895, INST: st.2b Rab,(Rn)+*/

	/*ID: 1896, INST: st.2b Rab,(Rn)+Rk*/

	/*ID: 1897, INST: st.2b Rab,(Rn)-*/

	/*ID: 1898, INST: st.2b Rab,(Rn+Rk)*/

	/*ID: 1899, INST: st.2b Rab,(Rn+s16_t7)*/

	/*ID: 1900, INST: st.4b Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_4b_dup(Word8* __p, Word32 __Dabcd);
__attribute__((always_inline)) inline void __st_4b(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_4b*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd);
#else
	 __st_4b_dup(__p, __Da);
	 __st_4b_dup(__p, __Db);
	 __st_4b_dup(__p, __Dc);
	 __st_4b_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_4b(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1901, INST: st.4b Dabcd,(Rn)+*/

	/*ID: 1902, INST: st.4b Dabcd,(Rn)+Rk*/

	/*ID: 1903, INST: st.4b Dabcd,(Rn)-*/

	/*ID: 1904, INST: st.4b Dabcd,(Rn+Rk)*/

	/*ID: 1905, INST: st.4b Dabcd,(Rn+s16_t7)*/

	/*ID: 1906, INST: st.4b Rabcd,(Rn)*/

	/*ID: 1907, INST: st.4b Rabcd,(Rn)+*/

	/*ID: 1908, INST: st.4b Rabcd,(Rn)+Rk*/

	/*ID: 1909, INST: st.4b Rabcd,(Rn)-*/

	/*ID: 1910, INST: st.4b Rabcd,(Rn+Rk)*/

	/*ID: 1911, INST: st.4b Rabcd,(Rn+s16_t7)*/

	/*ID: 1912, INST: st.8b Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_8b_dup(Word8* __p, Word32  __Da__Dh);
__attribute__((always_inline)) inline void __st_8b(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_8b*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_8b_dup(__p, __Da);
	 __st_8b_dup(__p, __Db);
	 __st_8b_dup(__p, __Dc);
	 __st_8b_dup(__p, __Dd);
	 __st_8b_dup(__p, __De);
	 __st_8b_dup(__p, __Df);
	 __st_8b_dup(__p, __Dg);
	 __st_8b_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_8b(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh);
#endif 

	/*ID: 1913, INST: st.8b Da__Dh,(Rn)+*/

	/*ID: 1914, INST: st.8b Da__Dh,(Rn)+Rk*/

	/*ID: 1915, INST: st.8b Da__Dh,(Rn)-*/

	/*ID: 1916, INST: st.8b Da__Dh,(Rn+Rk)*/

	/*ID: 1917, INST: st.8b Da__Dh,(Rn+s16_t7)*/

	/*ID: 1918, INST: st.bf BTR1,(Rn)*/

	/*ID: 1919, INST: st.bf BTR1,(Rn)+*/

	/*ID: 1920, INST: st.bf BTR1,(Rn)-*/

	/*ID: 1921, INST: st.bf Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_bf(Word8* __p, Word32 __Da)
{
	__builtin_storef(__p,__Da);
}
#else
void __st_bf(Word8* __p, Word32 __Da);
#endif
#else 
PROTOTYPE_API void __st_bf(Word8* __p, Word32 __Da);
#endif 

	/*ID: 1922, INST: st.bf Da,(Rn)+*/

	/*ID: 1923, INST: st.bf Da,(Rn)+Rk*/

	/*ID: 1924, INST: st.bf Da,(Rn)-*/

	/*ID: 1925, INST: st.bf Da,(Rn+Rk)*/

	/*ID: 1926, INST: st.bf Da,(Rn+s16_t7)*/

	/*ID: 1927, INST: st.bf Da,(sp+s16_t7)*/

	/*ID: 1928, INST: st.bf Da,(sp-u9)*/

	/*ID: 1929, INST: st.2bf Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_2bf_dup(Word8* __p, Word32 __Dab);
__attribute__((always_inline)) inline void __st_2bf(Word8* __p, Word32 __Da, Word32 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef((__vec_2b*)__p,__Da, __Db);
#else
	 __st_2bf_dup(__p, __Da);
	 __st_2bf_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_2bf(Word8* __p, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1930, INST: st.2bf Dab,(Rn)+*/

	/*ID: 1931, INST: st.2bf Dab,(Rn)+Rk*/

	/*ID: 1932, INST: st.2bf Dab,(Rn)-*/

	/*ID: 1933, INST: st.2bf Dab,(Rn+Rk)*/

	/*ID: 1934, INST: st.2bf Dab,(Rn+s16_t7)*/

	/*ID: 1935, INST: st.4bf Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_4bf_dup(Word8* __p, Word32 __Dabcd);
__attribute__((always_inline)) inline void __st_4bf(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef((__vec_4b*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st_4bf_dup(__p, __Da);
	 __st_4bf_dup(__p, __Db);
	 __st_4bf_dup(__p, __Dc);
	 __st_4bf_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_4bf(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1936, INST: st.4bf Dabcd,(Rn)+*/

	/*ID: 1937, INST: st.4bf Dabcd,(Rn)+Rk*/

	/*ID: 1938, INST: st.4bf Dabcd,(Rn)-*/

	/*ID: 1939, INST: st.4bf Dabcd,(Rn+Rk)*/

	/*ID: 1940, INST: st.4bf Dabcd,(Rn+s16_t7)*/

	/*ID: 1941, INST: st.8bf Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_8bf_dup(Word8* __p, Word32  __Da__Dh);
__attribute__((always_inline)) inline void __st_8bf(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef((__vec_8b*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_8bf_dup(__p, __Da);
	 __st_8bf_dup(__p, __Db);
	 __st_8bf_dup(__p, __Dc);
	 __st_8bf_dup(__p, __Dd);
	 __st_8bf_dup(__p, __De);
	 __st_8bf_dup(__p, __Df);
	 __st_8bf_dup(__p, __Dg);
	 __st_8bf_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_8bf(Word8* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh);
#endif 

	/*ID: 1942, INST: st.8bf Da__Dh,(Rn)+*/

	/*ID: 1943, INST: st.8bf Da__Dh,(Rn)+Rk*/

	/*ID: 1944, INST: st.8bf Da__Dh,(Rn)-*/

	/*ID: 1945, INST: st.8bf Da__Dh,(Rn+Rk)*/

	/*ID: 1946, INST: st.8bf Da__Dh,(Rn+s16_t7)*/

	/*ID: 1947, INST: st.f BTR1,(Rn)*/

	/*ID: 1948, INST: st.f BTR1,(Rn)+*/

	/*ID: 1949, INST: st.f BTR1,(Rn)-*/

	/*ID: 1950, INST: st.f Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_f(Word16* __p, Word32 __Da)
{
	__builtin_storef(__p,__Da);
}
#else
void __st_f(Word16* __p, Word32 __Da);
#endif
#else 
PROTOTYPE_API void __st_f(Word16* __p, Word32 __Da);
#endif 

	/*ID: 1951, INST: st.f Da,(Rn)+*/

	/*ID: 1952, INST: st.f Da,(Rn)+Rk*/

	/*ID: 1953, INST: st.f Da,(Rn)-*/

	/*ID: 1954, INST: st.f Da,(Rn+Rk)*/

	/*ID: 1955, INST: st.f Da,(Rn+s16_t7)*/

	/*ID: 1956, INST: st.f Da,(sp+s16_t7)*/

	/*ID: 1957, INST: st.f Da,(sp-u9_1)*/

	/*ID: 1958, INST: st.2f Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_2f_dup(Word16* __p, Word32 __Dab);
__attribute__((always_inline)) inline void __st_2f(Word16* __p, Word32 __Da, Word32 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef((__vec_2w*)__p,__Da, __Db);
#else
	 __st_2f_dup(__p, __Da);
	 __st_2f_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_2f(Word16* __p, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1959, INST: st.2f Dab,(Rn)+*/

	/*ID: 1960, INST: st.2f Dab,(Rn)+Rk*/

	/*ID: 1961, INST: st.2f Dab,(Rn)-*/

	/*ID: 1962, INST: st.2f Dab,(Rn+Rk)*/

	/*ID: 1963, INST: st.2f Dab,(Rn+s16_t7)*/

	/*ID: 1964, INST: st.4f Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_4f_dup(Word16* __p, Word32 __Dabcd);
__attribute__((always_inline)) inline void __st_4f(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef((__vec_4w*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st_4f_dup(__p, __Da);
	 __st_4f_dup(__p, __Db);
	 __st_4f_dup(__p, __Dc);
	 __st_4f_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_4f(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 1965, INST: st.4f Dabcd,(Rn)+*/

	/*ID: 1966, INST: st.4f Dabcd,(Rn)+Rk*/

	/*ID: 1967, INST: st.4f Dabcd,(Rn)-*/

	/*ID: 1968, INST: st.4f Dabcd,(Rn+Rk)*/

	/*ID: 1969, INST: st.4f Dabcd,(Rn+s16_t7)*/

	/*ID: 1970, INST: st.8f Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_8f_dup(Word16* __p, Word32  __Da__Dh);
__attribute__((always_inline)) inline void __st_8f(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef((__vec_8w*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_8f_dup(__p, __Da);
	 __st_8f_dup(__p, __Db);
	 __st_8f_dup(__p, __Dc);
	 __st_8f_dup(__p, __Dd);
	 __st_8f_dup(__p, __De);
	 __st_8f_dup(__p, __Df);
	 __st_8f_dup(__p, __Dg);
	 __st_8f_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_8f(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh);
#endif 

	/*ID: 1971, INST: st.8f Da__Dh,(Rn)+*/

	/*ID: 1972, INST: st.8f Da__Dh,(Rn)+Rk*/

	/*ID: 1973, INST: st.8f Da__Dh,(Rn)-*/

	/*ID: 1974, INST: st.8f Da__Dh,(Rn+Rk)*/

	/*ID: 1975, INST: st.8f Da__Dh,(Rn+s16_t7)*/

	/*ID: 1976, INST: st.l BTR1,(Rn)+*/

	/*ID: 1977, INST: st.l BTR1,(Rn)-*/

	/*ID: 1978, INST: st.l BTRN,(Rn)*/

	/*ID: 1979, INST: st.l Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_l(Word32* __p, Word32 __Da)
{
	*__p = __Da;
}
#else
void __st_l(Word32* __p, Word32 __Da);
#endif
#else 
PROTOTYPE_API void __st_l(Word32* __p, Word32 __Da);
#endif 

	/*ID: 1980, INST: st.l Da,(Rn)+*/

	/*ID: 1981, INST: st.l Da,(Rn)+Rk*/

	/*ID: 1982, INST: st.l Da,(Rn)-*/

	/*ID: 1983, INST: st.l Da,(Rn+Rk)*/

	/*ID: 1984, INST: st.l Da,(Rn+s16_t7)*/

	/*ID: 1985, INST: st.l Da,(sp+s16_t7)*/

	/*ID: 1986, INST: st.l Da,(sp-u9_2)*/

	/*ID: 1987, INST: st.l Ra,(Rn)*/

	/*ID: 1988, INST: st.l Ra,(Rn)+*/

	/*ID: 1989, INST: st.l Ra,(Rn)+Rk*/

	/*ID: 1990, INST: st.l Ra,(Rn)-*/

	/*ID: 1991, INST: st.l Ra,(Rn+Rk)*/

	/*ID: 1992, INST: st.l Ra,(Rn+s16_t7)*/

	/*ID: 1993, INST: st.l Ra,(sp+s16_t7)*/

	/*ID: 1994, INST: st.l Ra,(sp-u9_2)*/

	/*ID: 1995, INST: st.2l BTR0:BTR1,(Rn)*/

	/*ID: 1996, INST: st.2l BTR0:BTR1,(Rn)+*/

	/*ID: 1997, INST: st.2l BTR0:BTR1,(Rn)-*/

	/*ID: 1998, INST: st.2l Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_2l_dup(Word32* __p, Word32 __Dab);
__attribute__((always_inline)) inline void __st_2l(Word32* __p, Word32 __Da, Word32 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_2l*)__p = __builtin_vpack(__Da, __Db);
#else
	 __st_2l_dup(__p, __Da);
	 __st_2l_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_2l(Word32* __p, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 1999, INST: st.2l Dab,(Rn)+*/

	/*ID: 2000, INST: st.2l Dab,(Rn)+Rk*/

	/*ID: 2001, INST: st.2l Dab,(Rn)-*/

	/*ID: 2002, INST: st.2l Dab,(Rn+Rk)*/

	/*ID: 2003, INST: st.2l Dab,(Rn+s16_t7)*/

	/*ID: 2004, INST: st.2l Dab,(sp+s16_t7)*/

	/*ID: 2005, INST: st.2l Dac,(Rn)*/

	/*ID: 2006, INST: st.2l Dac,(Rn)+*/

	/*ID: 2007, INST: st.2l Dac,(Rn)+Rk*/

	/*ID: 2008, INST: st.2l Dac,(Rn)-*/

	/*ID: 2009, INST: st.2l Dac,(Rn+Rk)*/

	/*ID: 2010, INST: st.2l Dac,(Rn+s16_t7)*/

	/*ID: 2011, INST: st.2l Rab,(Rn)*/

	/*ID: 2012, INST: st.2l Rab,(Rn)+*/

	/*ID: 2013, INST: st.2l Rab,(Rn)+Rk*/

	/*ID: 2014, INST: st.2l Rab,(Rn)-*/

	/*ID: 2015, INST: st.2l Rab,(Rn+Rk)*/

	/*ID: 2016, INST: st.2l Rab,(Rn+s16_t7)*/

	/*ID: 2017, INST: st.2l Rab,(sp+s16_t7)*/

	/*ID: 2018, INST: st.4l Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_4l_dup(Word32* __p, Word32 __Dabcd);
__attribute__((always_inline)) inline void __st_4l(Word32* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_4l*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd);
#else
	 __st_4l_dup(__p, __Da);
	 __st_4l_dup(__p, __Db);
	 __st_4l_dup(__p, __Dc);
	 __st_4l_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_4l(Word32* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 2019, INST: st.4l Dabcd,(Rn)+*/

	/*ID: 2020, INST: st.4l Dabcd,(Rn)+Rk*/

	/*ID: 2021, INST: st.4l Dabcd,(Rn)-*/

	/*ID: 2022, INST: st.4l Dabcd,(Rn+Rk)*/

	/*ID: 2023, INST: st.4l Dabcd,(Rn+s16_t7)*/

	/*ID: 2024, INST: st.4l Rabcd,(Rn)*/

	/*ID: 2025, INST: st.4l Rabcd,(Rn)+*/

	/*ID: 2026, INST: st.4l Rabcd,(Rn)+Rk*/

	/*ID: 2027, INST: st.4l Rabcd,(Rn)-*/

	/*ID: 2028, INST: st.4l Rabcd,(Rn+Rk)*/

	/*ID: 2029, INST: st.4l Rabcd,(Rn+s16_t7)*/

	/*ID: 2030, INST: st.8l Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_8l_dup(Word32* __p, Word32  __Da__Dh);
__attribute__((always_inline)) inline void __st_8l(Word32* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_8l*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_8l_dup(__p, __Da);
	 __st_8l_dup(__p, __Db);
	 __st_8l_dup(__p, __Dc);
	 __st_8l_dup(__p, __Dd);
	 __st_8l_dup(__p, __De);
	 __st_8l_dup(__p, __Df);
	 __st_8l_dup(__p, __Dg);
	 __st_8l_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_8l(Word32* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh);
#endif 

	/*ID: 2031, INST: st.8l Da__Dh,(Rn)+*/

	/*ID: 2032, INST: st.8l Da__Dh,(Rn)+Rk*/

	/*ID: 2033, INST: st.8l Da__Dh,(Rn)-*/

	/*ID: 2034, INST: st.8l Da__Dh,(Rn+Rk)*/

	/*ID: 2035, INST: st.8l Da__Dh,(Rn+s16_t7)*/

	/*ID: 2036, INST: st.16l Da__Dp,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_16l_dup(Word32* __p, Word32  __Da__Dp);
__attribute__((always_inline)) inline void __st_16l(Word32* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh, Word32 __Di, Word32 __Dj, Word32 __Dk, Word32 __Dl, Word32 __Dm, Word32 __Dn, Word32 __Do, Word32 __Dp)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_16l*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh, __Di, __Dj, __Dk, __Dl, __Dm, __Dn, __Do, __Dp);
#else
	 __st_16l_dup(__p, __Da);
	 __st_16l_dup(__p, __Db);
	 __st_16l_dup(__p, __Dc);
	 __st_16l_dup(__p, __Dd);
	 __st_16l_dup(__p, __De);
	 __st_16l_dup(__p, __Df);
	 __st_16l_dup(__p, __Dg);
	 __st_16l_dup(__p, __Dh);
	 __st_16l_dup(__p, __Di);
	 __st_16l_dup(__p, __Dj);
	 __st_16l_dup(__p, __Dk);
	 __st_16l_dup(__p, __Dl);
	 __st_16l_dup(__p, __Dm);
	 __st_16l_dup(__p, __Dn);
	 __st_16l_dup(__p, __Do);
	 __st_16l_dup(__p, __Dp);
#endif
}
#else 
PROTOTYPE_API void __st_16l(Word32* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh, Word32 __Di, Word32 __Dj, Word32 __Dk, Word32 __Dl, Word32 __Dm, Word32 __Dn, Word32 __Do, Word32 __Dp);
#endif 

	/*ID: 2037, INST: st.16l Da__Dp,(Rn)+*/

	/*ID: 2038, INST: st.16l Da__Dp,(Rn)+Rk*/

	/*ID: 2039, INST: st.16l Da__Dp,(Rn)-*/

	/*ID: 2040, INST: st.16l Da__Dp,(Rn+Rk)*/

	/*ID: 2041, INST: st.16l Da__Dp,(Rn+s16_t7)*/

	/*ID: 2042, INST: st.w Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_w(Word16* __p, Word32 __Da)
{
	*__p = __Da;
}
#else
void __st_w(Word16* __p, Word32 __Da);
#endif
#else 
PROTOTYPE_API void __st_w(Word16* __p, Word32 __Da);
#endif 

	/*ID: 2043, INST: st.w Da,(Rn)+*/

	/*ID: 2044, INST: st.w Da,(Rn)+Rk*/

	/*ID: 2045, INST: st.w Da,(Rn)-*/

	/*ID: 2046, INST: st.w Da,(Rn+Rk)*/

	/*ID: 2047, INST: st.w Da,(Rn+s16_t7)*/

	/*ID: 2048, INST: st.w Da,(sp+s16_t7)*/

	/*ID: 2049, INST: st.w Da,(sp-u9_1)*/

	/*ID: 2050, INST: st.w Ra,(Rn)*/

	/*ID: 2051, INST: st.w Ra,(Rn)+*/

	/*ID: 2052, INST: st.w Ra,(Rn)+Rk*/

	/*ID: 2053, INST: st.w Ra,(Rn)-*/

	/*ID: 2054, INST: st.w Ra,(Rn+Rk)*/

	/*ID: 2055, INST: st.w Ra,(Rn+s16_t7)*/

	/*ID: 2056, INST: st.w Ra,(sp+s16_t7)*/

	/*ID: 2057, INST: st.w Ra,(sp-u9_1)*/

	/*ID: 2058, INST: st.2w Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_2w_dup(Word16* __p, Word32 __Dab);
__attribute__((always_inline)) inline void __st_2w(Word16* __p, Word32 __Da, Word32 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_2w*)__p = __builtin_vpack(__Da, __Db);
#else
	 __st_2w_dup(__p, __Da);
	 __st_2w_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_2w(Word16* __p, Word32 __Da, Word32 __Db);
#endif 

	/*ID: 2059, INST: st.2w Dab,(Rn)+*/

	/*ID: 2060, INST: st.2w Dab,(Rn)+Rk*/

	/*ID: 2061, INST: st.2w Dab,(Rn)-*/

	/*ID: 2062, INST: st.2w Dab,(Rn+Rk)*/

	/*ID: 2063, INST: st.2w Dab,(Rn+s16_t7)*/

	/*ID: 2064, INST: st.2w Rab,(Rn)*/

	/*ID: 2065, INST: st.2w Rab,(Rn)+*/

	/*ID: 2066, INST: st.2w Rab,(Rn)+Rk*/

	/*ID: 2067, INST: st.2w Rab,(Rn)-*/

	/*ID: 2068, INST: st.2w Rab,(Rn+Rk)*/

	/*ID: 2069, INST: st.2w Rab,(Rn+s16_t7)*/

	/*ID: 2070, INST: st.4w Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_4w_dup(Word16* __p, Word32 __Dabcd);
__attribute__((always_inline)) inline void __st_4w(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_4w*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd);
#else
	 __st_4w_dup(__p, __Da);
	 __st_4w_dup(__p, __Db);
	 __st_4w_dup(__p, __Dc);
	 __st_4w_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_4w(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd);
#endif 

	/*ID: 2071, INST: st.4w Dabcd,(Rn)+*/

	/*ID: 2072, INST: st.4w Dabcd,(Rn)+Rk*/

	/*ID: 2073, INST: st.4w Dabcd,(Rn)-*/

	/*ID: 2074, INST: st.4w Dabcd,(Rn+Rk)*/

	/*ID: 2075, INST: st.4w Dabcd,(Rn+s16_t7)*/

	/*ID: 2076, INST: st.4w Rabcd,(Rn)*/

	/*ID: 2077, INST: st.4w Rabcd,(Rn)+*/

	/*ID: 2078, INST: st.4w Rabcd,(Rn)+Rk*/

	/*ID: 2079, INST: st.4w Rabcd,(Rn)-*/

	/*ID: 2080, INST: st.4w Rabcd,(Rn+Rk)*/

	/*ID: 2081, INST: st.4w Rabcd,(Rn+s16_t7)*/

	/*ID: 2082, INST: st.8w Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_8w_dup(Word16* __p, Word32  __Da__Dh);
__attribute__((always_inline)) inline void __st_8w(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	*(__vec_8w*)__p = __builtin_vpack(__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_8w_dup(__p, __Da);
	 __st_8w_dup(__p, __Db);
	 __st_8w_dup(__p, __Dc);
	 __st_8w_dup(__p, __Dd);
	 __st_8w_dup(__p, __De);
	 __st_8w_dup(__p, __Df);
	 __st_8w_dup(__p, __Dg);
	 __st_8w_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_8w(Word16* __p, Word32 __Da, Word32 __Db, Word32 __Dc, Word32 __Dd, Word32 __De, Word32 __Df, Word32 __Dg, Word32 __Dh);
#endif 

	/*ID: 2083, INST: st.8w Da__Dh,(Rn)+*/

	/*ID: 2084, INST: st.8w Da__Dh,(Rn)+Rk*/

	/*ID: 2085, INST: st.8w Da__Dh,(Rn)-*/

	/*ID: 2086, INST: st.8w Da__Dh,(Rn+Rk)*/

	/*ID: 2087, INST: st.8w Da__Dh,(Rn+s16_t7)*/

	/*ID: 2088, INST: st.x Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_x(Word40* __p, Word40 __Da)
{
	*__p = __Da;
}
#else
void __st_x(Word40* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st_x(Word40* __p, Word40 __Da);
#endif 

	/*ID: 2089, INST: st.x Da,(Rn)+*/

	/*ID: 2090, INST: st.x Da,(Rn)+Rk*/

	/*ID: 2091, INST: st.x Da,(Rn)-*/

	/*ID: 2092, INST: st.x Da,(Rn+Rk)*/

	/*ID: 2093, INST: st.x Da,(Rn+s16_t7)*/

	/*ID: 2094, INST: st.x Da,(sp+s16_t7)*/

	/*ID: 2095, INST: st.x Da,(sp-u9_3)*/

	/*ID: 2096, INST: st.2x Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_2x_dup(Word40* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st_2x(Word40* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef(__p,__Da, __Db);
#else
	 __st_2x_dup(__p, __Da);
	 __st_2x_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_2x(Word40* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2097, INST: st.2x Dab,(Rn)+*/

	/*ID: 2098, INST: st.2x Dab,(Rn)+Rk*/

	/*ID: 2099, INST: st.2x Dab,(Rn)-*/

	/*ID: 2100, INST: st.2x Dab,(Rn+Rk)*/

	/*ID: 2101, INST: st.2x Dab,(Rn+s16_t7)*/

	/*ID: 2102, INST: st.4x Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_4x_dup(Word40* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st_4x(Word40* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef(__p,__Da, __Db, __Dc, __Dd);
#else
	 __st_4x_dup(__p, __Da);
	 __st_4x_dup(__p, __Db);
	 __st_4x_dup(__p, __Dc);
	 __st_4x_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_4x(Word40* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2103, INST: st.4x Dabcd,(Rn)+*/

	/*ID: 2104, INST: st.4x Dabcd,(Rn)+Rk*/

	/*ID: 2105, INST: st.4x Dabcd,(Rn)-*/

	/*ID: 2106, INST: st.4x Dabcd,(Rn+Rk)*/

	/*ID: 2107, INST: st.4x Dabcd,(Rn+s16_t7)*/

	/*ID: 2108, INST: st.8x Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_8x_dup(Word40* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st_8x(Word40* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storef(__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_8x_dup(__p, __Da);
	 __st_8x_dup(__p, __Db);
	 __st_8x_dup(__p, __Dc);
	 __st_8x_dup(__p, __Dd);
	 __st_8x_dup(__p, __De);
	 __st_8x_dup(__p, __Df);
	 __st_8x_dup(__p, __Dg);
	 __st_8x_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_8x(Word40* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2109, INST: st.8x Da__Dh,(Rn)+*/

	/*ID: 2110, INST: st.8x Da__Dh,(Rn)+Rk*/

	/*ID: 2111, INST: st.8x Da__Dh,(Rn)-*/

	/*ID: 2112, INST: st.8x Da__Dh,(Rn+Rk)*/

	/*ID: 2113, INST: st.8x Da__Dh,(Rn+s16_t7)*/

	/*ID: 2114, INST: st.srs.bf Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_srs_bf(Word8* __p, Word40 __Da)
{
	__builtin_storerf(__p,__Da);
}
#else
void __st_srs_bf(Word8* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st_srs_bf(Word8* __p, Word40 __Da);
#endif 

	/*ID: 2115, INST: st.srs.bf Da,(Rn)+*/

	/*ID: 2116, INST: st.srs.bf Da,(Rn)+Rk*/

	/*ID: 2117, INST: st.srs.bf Da,(Rn)-*/

	/*ID: 2118, INST: st.srs.bf Da,(Rn+Rk)*/

	/*ID: 2119, INST: st.srs.bf Da,(Rn+s16_t7)*/

	/*ID: 2120, INST: st.srs.2bf Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_2bf_dup(Word8* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st_srs_2bf(Word8* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_2b*)__p,__Da, __Db);
#else
	 __st_srs_2bf_dup(__p, __Da);
	 __st_srs_2bf_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_srs_2bf(Word8* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2121, INST: st.srs.2bf Dab,(Rn)+*/

	/*ID: 2122, INST: st.srs.2bf Dab,(Rn)+Rk*/

	/*ID: 2123, INST: st.srs.2bf Dab,(Rn)-*/

	/*ID: 2124, INST: st.srs.2bf Dab,(Rn+Rk)*/

	/*ID: 2125, INST: st.srs.2bf Dab,(Rn+s16_t7)*/

	/*ID: 2126, INST: st.srs.4bf Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_4bf_dup(Word8* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st_srs_4bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_4b*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st_srs_4bf_dup(__p, __Da);
	 __st_srs_4bf_dup(__p, __Db);
	 __st_srs_4bf_dup(__p, __Dc);
	 __st_srs_4bf_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_srs_4bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2127, INST: st.srs.4bf Dabcd,(Rn)+*/

	/*ID: 2128, INST: st.srs.4bf Dabcd,(Rn)+Rk*/

	/*ID: 2129, INST: st.srs.4bf Dabcd,(Rn)-*/

	/*ID: 2130, INST: st.srs.4bf Dabcd,(Rn+Rk)*/

	/*ID: 2131, INST: st.srs.4bf Dabcd,(Rn+s16_t7)*/

	/*ID: 2132, INST: st.srs.8bf Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_8bf_dup(Word8* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st_srs_8bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_8b*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_srs_8bf_dup(__p, __Da);
	 __st_srs_8bf_dup(__p, __Db);
	 __st_srs_8bf_dup(__p, __Dc);
	 __st_srs_8bf_dup(__p, __Dd);
	 __st_srs_8bf_dup(__p, __De);
	 __st_srs_8bf_dup(__p, __Df);
	 __st_srs_8bf_dup(__p, __Dg);
	 __st_srs_8bf_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_srs_8bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2133, INST: st.srs.8bf Da__Dh,(Rn)+*/

	/*ID: 2134, INST: st.srs.8bf Da__Dh,(Rn)+Rk*/

	/*ID: 2135, INST: st.srs.8bf Da__Dh,(Rn)-*/

	/*ID: 2136, INST: st.srs.8bf Da__Dh,(Rn+Rk)*/

	/*ID: 2137, INST: st.srs.8bf Da__Dh,(Rn+s16_t7)*/

	/*ID: 2138, INST: st.srs.f Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_srs_f(Word16* __p, Word40 __Da)
{
	__builtin_storerf(__p,__Da);
}
#else
void __st_srs_f(Word16* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st_srs_f(Word16* __p, Word40 __Da);
#endif 

	/*ID: 2139, INST: st.srs.f Da,(Rn)+*/

	/*ID: 2140, INST: st.srs.f Da,(Rn)+Rk*/

	/*ID: 2141, INST: st.srs.f Da,(Rn)-*/

	/*ID: 2142, INST: st.srs.f Da,(Rn+Rk)*/

	/*ID: 2143, INST: st.srs.f Da,(Rn+s16_t7)*/

	/*ID: 2144, INST: st.srs.2f Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_2f_dup(Word16* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st_srs_2f(Word16* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_2w*)__p,__Da, __Db);
#else
	 __st_srs_2f_dup(__p, __Da);
	 __st_srs_2f_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_srs_2f(Word16* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2145, INST: st.srs.2f Dab,(Rn)+*/

	/*ID: 2146, INST: st.srs.2f Dab,(Rn)+Rk*/

	/*ID: 2147, INST: st.srs.2f Dab,(Rn)-*/

	/*ID: 2148, INST: st.srs.2f Dab,(Rn+Rk)*/

	/*ID: 2149, INST: st.srs.2f Dab,(Rn+s16_t7)*/

	/*ID: 2150, INST: st.srs.4f Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_4f_dup(Word16* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st_srs_4f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_4w*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st_srs_4f_dup(__p, __Da);
	 __st_srs_4f_dup(__p, __Db);
	 __st_srs_4f_dup(__p, __Dc);
	 __st_srs_4f_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_srs_4f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2151, INST: st.srs.4f Dabcd,(Rn)+*/

	/*ID: 2152, INST: st.srs.4f Dabcd,(Rn)+Rk*/

	/*ID: 2153, INST: st.srs.4f Dabcd,(Rn)-*/

	/*ID: 2154, INST: st.srs.4f Dabcd,(Rn+Rk)*/

	/*ID: 2155, INST: st.srs.4f Dabcd,(Rn+s16_t7)*/

	/*ID: 2156, INST: st.srs.8f Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_8f_dup(Word16* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st_srs_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_8w*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_srs_8f_dup(__p, __Da);
	 __st_srs_8f_dup(__p, __Db);
	 __st_srs_8f_dup(__p, __Dc);
	 __st_srs_8f_dup(__p, __Dd);
	 __st_srs_8f_dup(__p, __De);
	 __st_srs_8f_dup(__p, __Df);
	 __st_srs_8f_dup(__p, __Dg);
	 __st_srs_8f_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_srs_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2157, INST: st.srs.8f Da__Dh,(Rn)+*/

	/*ID: 2158, INST: st.srs.8f Da__Dh,(Rn)+Rk*/

	/*ID: 2159, INST: st.srs.8f Da__Dh,(Rn)-*/

	/*ID: 2160, INST: st.srs.8f Da__Dh,(Rn+Rk)*/

	/*ID: 2161, INST: st.srs.8f Da__Dh,(Rn+s16_t7)*/

	/*ID: 2162, INST: st.srs.l Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st_srs_l(Word32* __p, Word40 __Da)
{
	__builtin_storerf(__p,__Da);
}
#else
void __st_srs_l(Word32* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st_srs_l(Word32* __p, Word40 __Da);
#endif 

	/*ID: 2163, INST: st.srs.l Da,(Rn)+*/

	/*ID: 2164, INST: st.srs.l Da,(Rn)+Rk*/

	/*ID: 2165, INST: st.srs.l Da,(Rn)-*/

	/*ID: 2166, INST: st.srs.l Da,(Rn+Rk)*/

	/*ID: 2167, INST: st.srs.l Da,(Rn+s16_t7)*/

	/*ID: 2168, INST: st.srs.2l Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_2l_dup(Word32* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st_srs_2l(Word32* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_2l*)__p,__Da, __Db);
#else
	 __st_srs_2l_dup(__p, __Da);
	 __st_srs_2l_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st_srs_2l(Word32* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2169, INST: st.srs.2l Dab,(Rn)+*/

	/*ID: 2170, INST: st.srs.2l Dab,(Rn)+Rk*/

	/*ID: 2171, INST: st.srs.2l Dab,(Rn)-*/

	/*ID: 2172, INST: st.srs.2l Dab,(Rn+Rk)*/

	/*ID: 2173, INST: st.srs.2l Dab,(Rn+s16_t7)*/

	/*ID: 2174, INST: st.srs.4l Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_4l_dup(Word32* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st_srs_4l(Word32* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_4l*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st_srs_4l_dup(__p, __Da);
	 __st_srs_4l_dup(__p, __Db);
	 __st_srs_4l_dup(__p, __Dc);
	 __st_srs_4l_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st_srs_4l(Word32* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2175, INST: st.srs.4l Dabcd,(Rn)+*/

	/*ID: 2176, INST: st.srs.4l Dabcd,(Rn)+Rk*/

	/*ID: 2177, INST: st.srs.4l Dabcd,(Rn)-*/

	/*ID: 2178, INST: st.srs.4l Dabcd,(Rn+Rk)*/

	/*ID: 2179, INST: st.srs.4l Dabcd,(Rn+s16_t7)*/

	/*ID: 2180, INST: st.srs.8l Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_8l_dup(Word32* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st_srs_8l(Word32* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storerf((__vec_8l*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st_srs_8l_dup(__p, __Da);
	 __st_srs_8l_dup(__p, __Db);
	 __st_srs_8l_dup(__p, __Dc);
	 __st_srs_8l_dup(__p, __Dd);
	 __st_srs_8l_dup(__p, __De);
	 __st_srs_8l_dup(__p, __Df);
	 __st_srs_8l_dup(__p, __Dg);
	 __st_srs_8l_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st_srs_8l(Word32* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2181, INST: st.srs.8l Da__Dh,(Rn)+*/

	/*ID: 2182, INST: st.srs.8l Da__Dh,(Rn)+Rk*/

	/*ID: 2183, INST: st.srs.8l Da__Dh,(Rn)-*/

	/*ID: 2184, INST: st.srs.8l Da__Dh,(Rn+Rk)*/

	/*ID: 2185, INST: st.srs.8l Da__Dh,(Rn+s16_t7)*/

	/*ID: 2186, INST: st.srs.wh.8f Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_wh_8f_dup(Word16* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st_srs_wh_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
	 __st_srs_wh_8f_dup(__p, __Da);
	 __st_srs_wh_8f_dup(__p, __Db);
	 __st_srs_wh_8f_dup(__p, __Dc);
	 __st_srs_wh_8f_dup(__p, __Dd);
	 __st_srs_wh_8f_dup(__p, __De);
	 __st_srs_wh_8f_dup(__p, __Df);
	 __st_srs_wh_8f_dup(__p, __Dg);
	 __st_srs_wh_8f_dup(__p, __Dh);
}
#else 
PROTOTYPE_API void __st_srs_wh_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2187, INST: st.srs.wh.8f Da__Dh,(Rn)+*/

	/*ID: 2188, INST: st.srs.wh.8f Da__Dh,(Rn)+Rk*/

	/*ID: 2189, INST: st.srs.wh.8f Da__Dh,(Rn)-*/

	/*ID: 2190, INST: st.srs.wh.8f Da__Dh,(Rn+Rk)*/

	/*ID: 2191, INST: st.srs.wh.8f Da__Dh,(Rn+s16_t7)*/

	/*ID: 2192, INST: st.srs.wl.8f Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st_srs_wl_8f_dup(Word16* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st_srs_wl_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
	 __st_srs_wl_8f_dup(__p, __Da);
	 __st_srs_wl_8f_dup(__p, __Db);
	 __st_srs_wl_8f_dup(__p, __Dc);
	 __st_srs_wl_8f_dup(__p, __Dd);
	 __st_srs_wl_8f_dup(__p, __De);
	 __st_srs_wl_8f_dup(__p, __Df);
	 __st_srs_wl_8f_dup(__p, __Dg);
	 __st_srs_wl_8f_dup(__p, __Dh);
}
#else 
PROTOTYPE_API void __st_srs_wl_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2193, INST: st.srs.wl.8f Da__Dh,(Rn)+*/

	/*ID: 2194, INST: st.srs.wl.8f Da__Dh,(Rn)+Rk*/

	/*ID: 2195, INST: st.srs.wl.8f Da__Dh,(Rn)-*/

	/*ID: 2196, INST: st.srs.wl.8f Da__Dh,(Rn+Rk)*/

	/*ID: 2197, INST: st.srs.wl.8f Da__Dh,(Rn+s16_t7)*/

	/*ID: 2198, INST: st2.2b Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st2_2b(Word8* __p, Word40 __Da)
{
	__builtin_store2((__vec_2b*)__p,__Da);
}
#else
void __st2_2b(Word8* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st2_2b(Word8* __p, Word40 __Da);
#endif 

	/*ID: 2199, INST: st2.2b Da,(Rn)+*/

	/*ID: 2200, INST: st2.2b Da,(Rn)+Rk*/

	/*ID: 2201, INST: st2.2b Da,(Rn)-*/

	/*ID: 2202, INST: st2.2b Da,(Rn+Rk)*/

	/*ID: 2203, INST: st2.2b Da,(Rn+s16_t7)*/

	/*ID: 2204, INST: st2.4b Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_4b_dup(Word8* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st2_4b(Word8* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2((__vec_4b*)__p,__Da, __Db);
#else
	 __st2_4b_dup(__p, __Da);
	 __st2_4b_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st2_4b(Word8* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2205, INST: st2.4b Dab,(Rn)+*/

	/*ID: 2206, INST: st2.4b Dab,(Rn)+Rk*/

	/*ID: 2207, INST: st2.4b Dab,(Rn)-*/

	/*ID: 2208, INST: st2.4b Dab,(Rn+Rk)*/

	/*ID: 2209, INST: st2.4b Dab,(Rn+s16_t7)*/

	/*ID: 2210, INST: st2.8b Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_8b_dup(Word8* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st2_8b(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2((__vec_8b*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st2_8b_dup(__p, __Da);
	 __st2_8b_dup(__p, __Db);
	 __st2_8b_dup(__p, __Dc);
	 __st2_8b_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st2_8b(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2211, INST: st2.8b Dabcd,(Rn)+*/

	/*ID: 2212, INST: st2.8b Dabcd,(Rn)+Rk*/

	/*ID: 2213, INST: st2.8b Dabcd,(Rn)-*/

	/*ID: 2214, INST: st2.8b Dabcd,(Rn+Rk)*/

	/*ID: 2215, INST: st2.8b Dabcd,(Rn+s16_t7)*/

	/*ID: 2216, INST: st2.16b Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_16b_dup(Word8* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st2_16b(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2((__vec_16b*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st2_16b_dup(__p, __Da);
	 __st2_16b_dup(__p, __Db);
	 __st2_16b_dup(__p, __Dc);
	 __st2_16b_dup(__p, __Dd);
	 __st2_16b_dup(__p, __De);
	 __st2_16b_dup(__p, __Df);
	 __st2_16b_dup(__p, __Dg);
	 __st2_16b_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st2_16b(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2217, INST: st2.16b Da__Dh,(Rn)+*/

	/*ID: 2218, INST: st2.16b Da__Dh,(Rn)+Rk*/

	/*ID: 2219, INST: st2.16b Da__Dh,(Rn)-*/

	/*ID: 2220, INST: st2.16b Da__Dh,(Rn+Rk)*/

	/*ID: 2221, INST: st2.16b Da__Dh,(Rn+s16_t7)*/

	/*ID: 2222, INST: st2.2bf Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st2_2bf(Word8* __p, Word40 __Da)
{
	__builtin_storer2f((__vec_2b*)__p,__Da);
}
#else
void __st2_2bf(Word8* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st2_2bf(Word8* __p, Word40 __Da);
#endif 

	/*ID: 2223, INST: st2.2bf Da,(Rn)+*/

	/*ID: 2224, INST: st2.2bf Da,(Rn)+Rk*/

	/*ID: 2225, INST: st2.2bf Da,(Rn)-*/

	/*ID: 2226, INST: st2.2bf Da,(Rn+Rk)*/

	/*ID: 2227, INST: st2.2bf Da,(Rn+s16_t7)*/

	/*ID: 2228, INST: st2.4bf Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_4bf_dup(Word8* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st2_4bf(Word8* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storer2f((__vec_4b*)__p,__Da, __Db);
#else
	 __st2_4bf_dup(__p, __Da);
	 __st2_4bf_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st2_4bf(Word8* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2229, INST: st2.4bf Dab,(Rn)+*/

	/*ID: 2230, INST: st2.4bf Dab,(Rn)+Rk*/

	/*ID: 2231, INST: st2.4bf Dab,(Rn)-*/

	/*ID: 2232, INST: st2.4bf Dab,(Rn+Rk)*/

	/*ID: 2233, INST: st2.4bf Dab,(Rn+s16_t7)*/

	/*ID: 2234, INST: st2.8bf Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_8bf_dup(Word8* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st2_8bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storer2f((__vec_8b*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st2_8bf_dup(__p, __Da);
	 __st2_8bf_dup(__p, __Db);
	 __st2_8bf_dup(__p, __Dc);
	 __st2_8bf_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st2_8bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2235, INST: st2.8bf Dabcd,(Rn)+*/

	/*ID: 2236, INST: st2.8bf Dabcd,(Rn)+Rk*/

	/*ID: 2237, INST: st2.8bf Dabcd,(Rn)-*/

	/*ID: 2238, INST: st2.8bf Dabcd,(Rn+Rk)*/

	/*ID: 2239, INST: st2.8bf Dabcd,(Rn+s16_t7)*/

	/*ID: 2240, INST: st2.16bf Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_16bf_dup(Word8* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st2_16bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_storer2f((__vec_16b*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st2_16bf_dup(__p, __Da);
	 __st2_16bf_dup(__p, __Db);
	 __st2_16bf_dup(__p, __Dc);
	 __st2_16bf_dup(__p, __Dd);
	 __st2_16bf_dup(__p, __De);
	 __st2_16bf_dup(__p, __Df);
	 __st2_16bf_dup(__p, __Dg);
	 __st2_16bf_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st2_16bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2241, INST: st2.16bf Da__Dh,(Rn)+*/

	/*ID: 2242, INST: st2.16bf Da__Dh,(Rn)+Rk*/

	/*ID: 2243, INST: st2.16bf Da__Dh,(Rn)-*/

	/*ID: 2244, INST: st2.16bf Da__Dh,(Rn+Rk)*/

	/*ID: 2245, INST: st2.16bf Da__Dh,(Rn+s16_t7)*/

	/*ID: 2246, INST: st2.srs.2bf Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st2_srs_2bf(Word8* __p, Word40 __Da)
{
	__builtin_store2f((__vec_2b*)__p,__Da);
}
#else
void __st2_srs_2bf(Word8* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st2_srs_2bf(Word8* __p, Word40 __Da);
#endif 

	/*ID: 2247, INST: st2.srs.2bf Da,(Rn)+*/

	/*ID: 2248, INST: st2.srs.2bf Da,(Rn)+Rk*/

	/*ID: 2249, INST: st2.srs.2bf Da,(Rn)-*/

	/*ID: 2250, INST: st2.srs.2bf Da,(Rn+Rk)*/

	/*ID: 2251, INST: st2.srs.2bf Da,(Rn+s16_t7)*/

	/*ID: 2252, INST: st2.srs.4bf Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_4bf_dup(Word8* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st2_srs_4bf(Word8* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2f((__vec_4b*)__p,__Da, __Db);
#else
	 __st2_srs_4bf_dup(__p, __Da);
	 __st2_srs_4bf_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st2_srs_4bf(Word8* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2253, INST: st2.srs.4bf Dab,(Rn)+*/

	/*ID: 2254, INST: st2.srs.4bf Dab,(Rn)+Rk*/

	/*ID: 2255, INST: st2.srs.4bf Dab,(Rn)-*/

	/*ID: 2256, INST: st2.srs.4bf Dab,(Rn+Rk)*/

	/*ID: 2257, INST: st2.srs.4bf Dab,(Rn+s16_t7)*/

	/*ID: 2258, INST: st2.srs.8bf Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_8bf_dup(Word8* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st2_srs_8bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2f((__vec_8b*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st2_srs_8bf_dup(__p, __Da);
	 __st2_srs_8bf_dup(__p, __Db);
	 __st2_srs_8bf_dup(__p, __Dc);
	 __st2_srs_8bf_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st2_srs_8bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2259, INST: st2.srs.8bf Dabcd,(Rn)+*/

	/*ID: 2260, INST: st2.srs.8bf Dabcd,(Rn)+Rk*/

	/*ID: 2261, INST: st2.srs.8bf Dabcd,(Rn)-*/

	/*ID: 2262, INST: st2.srs.8bf Dabcd,(Rn+Rk)*/

	/*ID: 2263, INST: st2.srs.8bf Dabcd,(Rn+s16_t7)*/

	/*ID: 2264, INST: st2.srs.16bf Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_16bf_dup(Word8* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st2_srs_16bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2f((__vec_16b*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st2_srs_16bf_dup(__p, __Da);
	 __st2_srs_16bf_dup(__p, __Db);
	 __st2_srs_16bf_dup(__p, __Dc);
	 __st2_srs_16bf_dup(__p, __Dd);
	 __st2_srs_16bf_dup(__p, __De);
	 __st2_srs_16bf_dup(__p, __Df);
	 __st2_srs_16bf_dup(__p, __Dg);
	 __st2_srs_16bf_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st2_srs_16bf(Word8* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2265, INST: st2.srs.16bf Da__Dh,(Rn)+*/

	/*ID: 2266, INST: st2.srs.16bf Da__Dh,(Rn)+Rk*/

	/*ID: 2267, INST: st2.srs.16bf Da__Dh,(Rn)-*/

	/*ID: 2268, INST: st2.srs.16bf Da__Dh,(Rn+Rk)*/

	/*ID: 2269, INST: st2.srs.16bf Da__Dh,(Rn+s16_t7)*/

	/*ID: 2270, INST: st2.srs.2f Da,(Rn)*/
#ifndef _HOST_EMULATION_ 
#if USE_CW_VECTOR_LOAD_STORE
__attribute__((always_inline)) inline void __st2_srs_2f(Word16* __p, Word40 __Da)
{
	__builtin_store2f((__vec_2w*)__p,__Da);
}
#else
void __st2_srs_2f(Word16* __p, Word40 __Da);
#endif
#else 
PROTOTYPE_API void __st2_srs_2f(Word16* __p, Word40 __Da);
#endif 

	/*ID: 2271, INST: st2.srs.2f Da,(Rn)+*/

	/*ID: 2272, INST: st2.srs.2f Da,(Rn)+Rk*/

	/*ID: 2273, INST: st2.srs.2f Da,(Rn)-*/

	/*ID: 2274, INST: st2.srs.2f Da,(Rn+Rk)*/

	/*ID: 2275, INST: st2.srs.2f Da,(Rn+s16_t7)*/

	/*ID: 2276, INST: st2.srs.4f Dab,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_4f_dup(Word16* __p, Word40 __Dab);
__attribute__((always_inline)) inline void __st2_srs_4f(Word16* __p, Word40 __Da, Word40 __Db)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2f((__vec_4w*)__p,__Da, __Db);
#else
	 __st2_srs_4f_dup(__p, __Da);
	 __st2_srs_4f_dup(__p, __Db);
#endif
}
#else 
PROTOTYPE_API void __st2_srs_4f(Word16* __p, Word40 __Da, Word40 __Db);
#endif 

	/*ID: 2277, INST: st2.srs.4f Dab,(Rn)+*/

	/*ID: 2278, INST: st2.srs.4f Dab,(Rn)+Rk*/

	/*ID: 2279, INST: st2.srs.4f Dab,(Rn)-*/

	/*ID: 2280, INST: st2.srs.4f Dab,(Rn+Rk)*/

	/*ID: 2281, INST: st2.srs.4f Dab,(Rn+s16_t7)*/

	/*ID: 2282, INST: st2.srs.8f Dabcd,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_8f_dup(Word16* __p, Word40 __Dabcd);
__attribute__((always_inline)) inline void __st2_srs_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2f((__vec_8w*)__p,__Da, __Db, __Dc, __Dd);
#else
	 __st2_srs_8f_dup(__p, __Da);
	 __st2_srs_8f_dup(__p, __Db);
	 __st2_srs_8f_dup(__p, __Dc);
	 __st2_srs_8f_dup(__p, __Dd);
#endif
}
#else 
PROTOTYPE_API void __st2_srs_8f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd);
#endif 

	/*ID: 2283, INST: st2.srs.8f Dabcd,(Rn)+*/

	/*ID: 2284, INST: st2.srs.8f Dabcd,(Rn)+Rk*/

	/*ID: 2285, INST: st2.srs.8f Dabcd,(Rn)-*/

	/*ID: 2286, INST: st2.srs.8f Dabcd,(Rn+Rk)*/

	/*ID: 2287, INST: st2.srs.8f Dabcd,(Rn+s16_t7)*/

	/*ID: 2288, INST: st2.srs.16f Da__Dh,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_16f_dup(Word16* __p, Word40  __Da__Dh);
__attribute__((always_inline)) inline void __st2_srs_16f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh)
{
#if USE_CW_VECTOR_LOAD_STORE
	__builtin_store2f((__vec_16w*)__p,__Da, __Db, __Dc, __Dd, __De, __Df, __Dg, __Dh);
#else
	 __st2_srs_16f_dup(__p, __Da);
	 __st2_srs_16f_dup(__p, __Db);
	 __st2_srs_16f_dup(__p, __Dc);
	 __st2_srs_16f_dup(__p, __Dd);
	 __st2_srs_16f_dup(__p, __De);
	 __st2_srs_16f_dup(__p, __Df);
	 __st2_srs_16f_dup(__p, __Dg);
	 __st2_srs_16f_dup(__p, __Dh);
#endif
}
#else 
PROTOTYPE_API void __st2_srs_16f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh);
#endif 

	/*ID: 2289, INST: st2.srs.16f Da__Dh,(Rn)+*/

	/*ID: 2290, INST: st2.srs.16f Da__Dh,(Rn)+Rk*/

	/*ID: 2291, INST: st2.srs.16f Da__Dh,(Rn)-*/

	/*ID: 2292, INST: st2.srs.16f Da__Dh,(Rn+Rk)*/

	/*ID: 2293, INST: st2.srs.16f Da__Dh,(Rn+s16_t7)*/

	/*ID: 2294, INST: st2.srs.16f Da__DhMod8,(Rn)*/

	/*ID: 2295, INST: st2.srs.16f Da__DhMod8,(Rn)+*/

	/*ID: 2296, INST: st2.srs.16f Da__DhMod8,(Rn)+Rk*/

	/*ID: 2297, INST: st2.srs.16f Da__DhMod8,(Rn)-*/

	/*ID: 2298, INST: st2.srs.16f Da__DhMod8,(Rn+Rk)*/

	/*ID: 2299, INST: st2.srs.16f Da__DhMod8,(Rn+s16_t7)*/

	/*ID: 2300, INST: st2.srs.16f Da__DhMod8p,(Rn)*/

	/*ID: 2301, INST: st2.srs.16f Da__DhMod8p,(Rn)+*/

	/*ID: 2302, INST: st2.srs.16f Da__DhMod8p,(Rn)+Rk*/

	/*ID: 2303, INST: st2.srs.16f Da__DhMod8p,(Rn)-*/

	/*ID: 2304, INST: st2.srs.16f Da__DhMod8p,(Rn+Rk)*/

	/*ID: 2305, INST: st2.srs.16f Da__DhMod8p,(Rn+s16_t7)*/

	/*ID: 2306, INST: st2.srs.32f Da__Dp,(Rn)*/
#ifndef _HOST_EMULATION_ 
void __st2_srs_32f_dup(Word16* __p, Word40  __Da__Dp);
__attribute__((always_inline)) inline void __st2_srs_32f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh, Word40 __Di, Word40 __Dj, Word40 __Dk, Word40 __Dl, Word40 __Dm, Word40 __Dn, Word40 __Do, Word40 __Dp)
{
	 __st2_srs_32f_dup(__p, __Da);
	 __st2_srs_32f_dup(__p, __Db);
	 __st2_srs_32f_dup(__p, __Dc);
	 __st2_srs_32f_dup(__p, __Dd);
	 __st2_srs_32f_dup(__p, __De);
	 __st2_srs_32f_dup(__p, __Df);
	 __st2_srs_32f_dup(__p, __Dg);
	 __st2_srs_32f_dup(__p, __Dh);
	 __st2_srs_32f_dup(__p, __Di);
	 __st2_srs_32f_dup(__p, __Dj);
	 __st2_srs_32f_dup(__p, __Dk);
	 __st2_srs_32f_dup(__p, __Dl);
	 __st2_srs_32f_dup(__p, __Dm);
	 __st2_srs_32f_dup(__p, __Dn);
	 __st2_srs_32f_dup(__p, __Do);
	 __st2_srs_32f_dup(__p, __Dp);
}
#else 
PROTOTYPE_API void __st2_srs_32f(Word16* __p, Word40 __Da, Word40 __Db, Word40 __Dc, Word40 __Dd, Word40 __De, Word40 __Df, Word40 __Dg, Word40 __Dh, Word40 __Di, Word40 __Dj, Word40 __Dk, Word40 __Dl, Word40 __Dm, Word40 __Dn, Word40 __Do, Word40 __Dp);
#endif 

	/*ID: 2307, INST: st2.srs.32f Da__Dp,(Rn)+*/

	/*ID: 2308, INST: st2.srs.32f Da__Dp,(Rn)+Rk*/

	/*ID: 2309, INST: st2.srs.32f Da__Dp,(Rn)-*/

	/*ID: 2310, INST: st2.srs.32f Da__Dp,(Rn+Rk)*/

	/*ID: 2311, INST: st2.srs.32f Da__Dp,(Rn+s16_t7)*/

	/*ID: 2312, INST: sub.ll Dab,Dcd,Dmn*/

	/*ID: 2313, INST: sub.t Da.h,Dn.h*/
PROTOTYPE_API Word40 __sub_t_hh(Word40 __Dn_h, Word40 __Da_h);

	/*ID: 2314, INST: sub.t Da.l,Dn.l*/
PROTOTYPE_API Word40 __sub_t_ll(Word40 __Dn_l, Word40 __Da_l);

	/*ID: 2315, INST: sub.t Da.h,Dn.l*/
PROTOTYPE_API Word40 __sub_t_hl(Word40 __Dn_l, Word40 __Da_h);

	/*ID: 2316, INST: sub.t Da.l,Dn.h*/
PROTOTYPE_API Word40 __sub_t_lh(Word40 __Dn_h, Word40 __Da_l);

	/*ID: 2317, INST: sub.2t Da,Db,Dn*/
PROTOTYPE_API Word40 __sub_2t(Word40 __Da, Word40 __Db);

	/*ID: 2318, INST: sub.x #u5,Da,Dn*/
PROTOTYPE_API Word40 __sub_x_imm(UWord32 __imm1, Word40 __Da);

	/*ID: 2319, INST: sub.x Da,Db,Dn*/
PROTOTYPE_API Word40 __sub_x(Word40 __Da, Word40 __Db);

	/*ID: 2320, INST: sub.leg.x #u5,Da,Dn*/

	/*ID: 2321, INST: sub.leg.x Da,Db,Dn*/

	/*ID: 2322, INST: sub.s.x Da,Db,Dn*/
PROTOTYPE_API Word40 __sub_s_x(Word40 __Da, Word40 __Db);

	/*ID: 2323, INST: suba #u5,Ra,Rn*/

	/*ID: 2324, INST: suba Ra,Rb,Rn*/

	/*ID: 2325, INST: suba.lin #u5,Ra,Rn*/
PROTOTYPE_API Word32 __suba_lin(Word32 __imm1, Word32 __Ra);

	/*ID: 2326, INST: suba.lin #u5,Ra,Rn*/

	/*ID: 2327, INST: suba.lin Ra,Rb,Rn*/

	/*ID: 2328, INST: suba.lin Ra,Rb,Rn*/

	/*ID: 2329, INST: subc.ro.x Da,Db,Dn*/

	/*ID: 2330, INST: subc.rw.leg.l Da,Db,Dn*/

	/*ID: 2331, INST: subc.wo.l #u5,Da,Dn*/

	/*ID: 2332, INST: subc.wo.l Da,Db,Dn*/

	/*ID: 2333, INST: subc.wo.x #u5,Da,Dn*/

	/*ID: 2334, INST: subc.wo.x Da,Db,Dn*/

	/*ID: 2335, INST: subc.wo.leg.x #u5,Da,Dn*/

	/*ID: 2336, INST: subc.wo.leg.x Da,Db,Dn*/

	/*ID: 2337, INST: swap.dx.4b Da,Dn*/
PROTOTYPE_API Word32 __swap_dx_4b(Word32 __Da);

	/*ID: 2338, INST: swap.dx.8b Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __swap_dx_8b_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __swap_dx_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __swap_dx_8b_dup(__Da, __Db);
	*__Dn =  __swap_dx_8b_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __swap_dx_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 2339, INST: swap.ixi.4w Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __swap_ixi_4w_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __swap_ixi_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __swap_ixi_4w_dup(__Da, __Db);
	*__Dn =  __swap_ixi_4w_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __swap_ixi_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 2340, INST: swap.sx.4b Da,Dn*/
PROTOTYPE_API Word32 __swap_sx_4b(Word32 __Da);

	/*ID: 2341, INST: swap.sx.8b Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __swap_sx_8b_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __swap_sx_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __swap_sx_8b_dup(__Da, __Db);
	*__Dn =  __swap_sx_8b_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __swap_sx_8b(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 2342, INST: swap.sx.4w Da,Db,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __swap_sx_4w_dup(Word32 __Da, Word32 __Db);
__attribute__((always_inline)) inline void __swap_sx_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __swap_sx_4w_dup(__Da, __Db);
	*__Dn =  __swap_sx_4w_dup(__Da, __Db);
}
#else 
PROTOTYPE_API void __swap_sx_4w(Word32 __Da, Word32 __Db, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 2343, INST: swb*/
PROTOTYPE_API void __swb();

	/*ID: 2344, INST: swbe*/
PROTOTYPE_API void __swbe();

	/*ID: 2345, INST: sxt.b.2t Da,Dn*/

	/*ID: 2346, INST: sxt.b.4t Dab,Dmn*/

	/*ID: 2347, INST: sxt.b.x Da,Dn*/

	/*ID: 2348, INST: sxt.b.2x Dab,Dmn*/

	/*ID: 2349, INST: sxt.l.x Da,Dn*/

	/*ID: 2350, INST: sxt.l.2x Dab,Dmn*/

	/*ID: 2351, INST: sxt.w.2t Da,Dn*/

	/*ID: 2352, INST: sxt.w.4t Dab,Dmn*/

	/*ID: 2353, INST: sxt.w.x Da,Dn*/

	/*ID: 2354, INST: sxt.w.2x Dab,Dmn*/

	/*ID: 2355, INST: sxta.b.l Ra,Rn*/

	/*ID: 2356, INST: sxta.b.l Ra,Rn*/

	/*ID: 2357, INST: sxta.w.l Ra,Rn*/

	/*ID: 2358, INST: sxta.w.l Ra,Rn*/

	/*ID: 2359, INST: sync.b*/
PROTOTYPE_API void __sync_b();

	/*ID: 2360, INST: sync.d*/
PROTOTYPE_API void __sync_d();

	/*ID: 2361, INST: sync.b.dl*/
PROTOTYPE_API void __sync_b_dl();

	/*ID: 2362, INST: tfr.x #s32,Dn*/

	/*ID: 2363, INST: tfr.x Da,Dn*/

	/*ID: 2364, INST: tfr.2x #s32,Dmn*/

	/*ID: 2365, INST: tfr.2x Da,Db,Dmn*/

	/*ID: 2366, INST: tfra C8,Rn*/

	/*ID: 2367, INST: tfra Ra,C7*/

	/*ID: 2368, INST: tfra Ra,sp*/

	/*ID: 2369, INST: tfra sp,Rn*/

	/*ID: 2370, INST: tfra.l #s32_t5,Rn*/

	/*ID: 2371, INST: tfra.l #s32_t5,Rn*/

	/*ID: 2372, INST: tfra.l #s9,Rn*/

	/*ID: 2373, INST: tfra.l #s9,Rn*/

	/*ID: 2374, INST: tfrca Ra,sp*/

	/*ID: 2375, INST: tfrca sp,Rn*/

	/*ID: 2376, INST: trap.1 #u10*/

	/*ID: 2377, INST: trap.0 #u10*/

	/*ID: 2378, INST: tstbm.c.l #u32,Da,Pmn*/
PROTOTYPE_API int __tstbm_c_l(Word32 __imm1, Word32 __Da);

	/*ID: 2379, INST: tstbm.c.l #u32,Da,Pn*/

	/*ID: 2380, INST: tstbm.s.l #u32,Da,Pmn*/
PROTOTYPE_API int __tstbm_s_l(Word32 __imm1, Word32 __Da);

	/*ID: 2381, INST: tstbm.s.l #u32,Da,Pn*/

	/*ID: 2382, INST: unpack.b.4t Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_b_4t_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_b_4t(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_b_4t_dup(__Da);
	*__Dn =  __unpack_b_4t_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_b_4t(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2383, INST: unpack.b.4w Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word32 __unpack_b_4w_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_b_4w(Word32 __Da, Word32* __Dm, Word32* __Dn)
{
	*__Dm =  __unpack_b_4w_dup(__Da);
	*__Dn =  __unpack_b_4w_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_b_4w(Word32 __Da, Word32* __Dm, Word32* __Dn);
#endif 

	/*ID: 2384, INST: unpack.b.u.4t Da,Dmn*/
#ifndef _HOST_EMULATION_ 
UWord40 __unpack_b_u_4t_dup(UWord32 __Da);
__attribute__((always_inline)) inline void __unpack_b_u_4t(UWord32 __Da, UWord40* __Dm, UWord40* __Dn)
{
	*__Dm =  __unpack_b_u_4t_dup(__Da);
	*__Dn =  __unpack_b_u_4t_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_b_u_4t(UWord32 __Da, UWord40* __Dm, UWord40* __Dn);
#endif 

	/*ID: 2385, INST: unpack.bf.4t Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_bf_4t_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_bf_4t(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_bf_4t_dup(__Da);
	*__Dn =  __unpack_bf_4t_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_bf_4t(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2386, INST: unpack.bh.u.2t Da,Dn*/
PROTOTYPE_API UWord40 __unpack_bh_u_2t(UWord32 __Da);

	/*ID: 2387, INST: unpack.bl.u.2t Da,Dn*/
PROTOTYPE_API UWord40 __unpack_bl_u_2t(UWord32 __Da);

	/*ID: 2388, INST: unpack.thl.2f Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_thl_2f_dup(Word40 __Da);
__attribute__((always_inline)) inline void __unpack_thl_2f(Word40 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_thl_2f_dup(__Da);
	*__Dn =  __unpack_thl_2f_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_thl_2f(Word40 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2389, INST: unpack.thl.2x Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_thl_2x_dup(Word40 __Da);
__attribute__((always_inline)) inline void __unpack_thl_2x(Word40 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_thl_2x_dup(__Da);
	*__Dn =  __unpack_thl_2x_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_thl_2x(Word40 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2390, INST: unpack.tlh.2f Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_tlh_2f_dup(Word40 __Da);
__attribute__((always_inline)) inline void __unpack_tlh_2f(Word40 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_tlh_2f_dup(__Da);
	*__Dn =  __unpack_tlh_2f_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_tlh_2f(Word40 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2391, INST: unpack.tlh.2x Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_tlh_2x_dup(Word40 __Da);
__attribute__((always_inline)) inline void __unpack_tlh_2x(Word40 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_tlh_2x_dup(__Da);
	*__Dn =  __unpack_tlh_2x_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_tlh_2x(Word40 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2392, INST: unpack.whl.2f Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_whl_2f_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_whl_2f(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_whl_2f_dup(__Da);
	*__Dn =  __unpack_whl_2f_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_whl_2f(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2393, INST: unpack.whl.2x Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_whl_2x_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_whl_2x(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_whl_2x_dup(__Da);
	*__Dn =  __unpack_whl_2x_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_whl_2x(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2394, INST: unpack.wlh.2f Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_wlh_2f_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_wlh_2f(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_wlh_2f_dup(__Da);
	*__Dn =  __unpack_wlh_2f_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_wlh_2f(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2395, INST: unpack.wlh.2x Da,Dmn*/
#ifndef _HOST_EMULATION_ 
Word40 __unpack_wlh_2x_dup(Word32 __Da);
__attribute__((always_inline)) inline void __unpack_wlh_2x(Word32 __Da, Word40* __Dm, Word40* __Dn)
{
	*__Dm =  __unpack_wlh_2x_dup(__Da);
	*__Dn =  __unpack_wlh_2x_dup(__Da);
}
#else 
PROTOTYPE_API void __unpack_wlh_2x(Word32 __Da, Word40* __Dm, Word40* __Dn);
#endif 

	/*ID: 2396, INST: vtrace.l #0,#2,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_0_2(Word32 __Dn, Word32 __Da);

	/*ID: 2397, INST: vtrace.l #0,#3,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_0_3(Word32 __Dn, Word32 __Da);

	/*ID: 2398, INST: vtrace.l #0,#4,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_0_4(Word32 __Dn, Word32 __Da);

	/*ID: 2399, INST: vtrace.l #1,#4,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_1_4(Word32 __Dn, Word32 __Da);

	/*ID: 2400, INST: vtrace.l #2,#4,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_2_4(Word32 __Dn, Word32 __Da);

	/*ID: 2401, INST: vtrace.l #3,#4,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_3_4(Word32 __Dn, Word32 __Da);

	/*ID: 2402, INST: vtrace.l #4,#4,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_4_4(Word32 __Dn, Word32 __Da);

	/*ID: 2403, INST: vtrace.l #5,#4,Da,Dn*/
PROTOTYPE_API Word32 __vtrace_l_5_4(Word32 __Dn, Word32 __Da);

	/*ID: 2404, INST: zxt.b.x Da,Dn*/

	/*ID: 2405, INST: zxt.l.x Da,Dn*/

	/*ID: 2406, INST: zxt.w.x Da,Dn*/

	/*ID: 2407, INST: zxta.b.l Ra,Rn*/

	/*ID: 2408, INST: zxta.b.l Ra,Rn*/

	/*ID: 2409, INST: zxta.w.l Ra,Rn*/

	/*ID: 2410, INST: zxta.w.l Ra,Rn*/

#include <prototype_sc3900_32bit.h>

#ifdef __cplusplus
	}
#endif

# pragma reject_floats reset
#endif /* __PROTOTYPE_SC3900_H */
