/*
 * Test Case for _ext
 * This is an example test case
 * 
 * Created by:  Michael Fleischer
 * Created on: 09-12-2008
 * 
 */

#ifdef   PA_TEST 
#include "portTItoPA.h"
#endif

#include <stdio.h>
#include <math.h>
#include "testdefs.h"

#define INSTRUMENT 
//#define USE_ATB 
#ifdef INSTRUMENT

__attribute__ ((noinline))  volatile unsigned long
get_atb (void)
{
  unsigned long x;
#ifdef USE_ATB
  asm volatile ("mfspr %0,526":"=r" (x));       // atb
#else
  asm volatile ("mftb %0":"=r" (x));    // tb
#endif
  return x;
}

#endif


extern void test_print_start(char *function);
void test_print_inputs(int number, ...);
extern void test_print_output(UWORD32 val);
extern void test_print_end(char *function);


void test__ext()
{
	UWORD32 result;
	UWORD8	start;
	UWORD8  finish;
	int i;
#ifdef INSTRUMENT
  unsigned long atb_start, atb_stop;
  unsigned long time;
#endif 

	
	
		/* Start of tests */
	test_print_start("_ext");
	for(i=0;i<30;i++)
	{
		start = i;
		finish = i+2;		
#ifdef INSTRUMENT
  atb_start = get_atb();
#endif

  result = _ext(srcW32[i],start, finish);

#ifdef INSTRUMENT
  atb_stop = get_atb();
#endif

  test_print_inputs(3, srcW32[i],start, finish);		
								

#ifdef INSTRUMENT
  time = atb_stop-atb_start;
  //  printf ("\n start %x",atb_start);
  //  printf ("\n stop %x",atb_stop);
  printf ("\n took 0x%x",time);
#endif

		test_print_output(result);
		
	}
	/* End of tests */		
	test_print_end("_ext");
	
	return;
			
}
