#!/bin/bash

for a in "$@"; do
    case $a in
	-avg)
	    AVG="Y"
	    ;;
	*)
	    stag=$a
	    ;;
    esac
done

if [ "$stag" = "" ]; then
    echo "Need argument <tag>"
    exit 1
fi

echo "${stag}.target_log"

# Process input one line at a tume
declare -a LINE
IFS=","
CORE=""
while true; do
    read -a LINE
    if [ "${LINE[1]}" = "" ]; then
	break
    fi
    tag=${LINE[1]}
    if [ "$tag" != "$stag" ]; then
	continue
    fi
    rep=${LINE[7]}
    bmk=${LINE[13]}
    n=${LINE[21]}
    val=${LINE[23]}
    res=${LINE[25]}
    if [ "$val" = "NOTVALID" ]; then
	val="N"
    else
	val="Y"
    fi
    if [ "$res" = "" -o "$res" = "Valid" -o "$res" = "VALID"  -o "$res" = "NOTVALID" ]; then
	val="N"
	res="0"
    fi
    if [ "$CORE" = "" ]; then
	echo "CORE=${LINE[11]}"
	CORE=${LINE[11]}
    fi
    if [ "${bmk:0:6}" = "spec2k" ]; then x="spec2k"; else x=""; fi
    if [ "$x" != "" ]; then
	if [ "$n" = "1" ]; then
	    # First iteration, start collecting best result"
	    BEST=$res
	else
	    if [ "$AVG" != "" ]; then
		BEST=`echo "$BEST $res" | awk '{print $1+$2}'`
	    else
		BEST=`echo "$BEST $res" | awk '{if ($1 < $2) print $1; else print $2}'`
	    fi
	fi
	if [ "$n" = "$rep" ]; then
	    # Output best
	    [ "$AVG" != "" ] && BEST=`echo "$BEST $rep" | awk '{print $1/$2}'`
	    echo "BMK=$bmk EXEC=$val TIME=$BEST"
	fi
    else
	if [ "$n" = "1" ]; then
	    # First iteration, start collecting best result"
	    BEST=$res
	else
	    if [ "$AVG" != "" ]; then
		BEST=`echo "$BEST $res" | awk '{print $1+$2}'`
	    else
		BEST=`echo "$BEST $res" | awk '{if ($1 > $2) print $1; else print $2}'`
	    fi
	fi
	if [ "$n" = "$rep" ]; then
	    # Output best
	    [ "$AVG" != "" ] && BEST=`echo "$BEST $rep" | awk '{print $1/$2}'`
	    echo "BMK=$bmk EXEC=$val ITER=$BEST"
	fi
    fi
done
