#!/usr/bin/bash
declare -A BUILDS

EXTBUILD=""
SRCSET="F460"
NORM='#'
TARGETS=()
DRYRUN=""

scriptdir=`dirname $0`
hnfull=`hostname`
hn=`basename $hnfull .am.freescale.net`
hn=`basename $hn .mtwk.freescale.net`
source $scriptdir/build.env-$hn

#    "build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe XLMe500v1"
BUILDS=(
    # XL
    ["XLMe500v1"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe XLMe500v1"
    ["XLMe500v2"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe XLMe500v2"
    ["XLMe600"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XLMe600"
    ["XLM603e"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XLM603e"
    ["XLe300c2"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe XLe300c2"
    ["XLMe300c3"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XLMe300c3"
    ["XLMe500mc"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XLMe500mc"
    ["XLMe5500"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XLMe5500"
    ["XLMe6500"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XLMe6500"
    # X
    ["Xe500v1"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe Xe500v1"
    ["Xe500v2"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe Xe500v2"
    ["XMe600"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XMe600"
    ["Xe300c2"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMspe Xe300c2"
    ["XMe300c3"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XMe300c3"
    ["XMe500mc"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XMe500mc"
    ["XMe5500"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XMe5500"
    ["XMe6500"]="build.sh s=\$SRCSET \$EXTBUILD t=DGREMalt XMe6500"
    # E
    ["ELe500v1"]="build.sh s=\$SRCSET \$EXTBUILD ELe500v1"
    ["ELe500v2"]="build.sh s=\$SRCSET \$EXTBUILD ELe500v2"
    ["ELe600"]="build.sh s=\$SRCSET \$EXTBUILD ELe600"
    ["EL603e"]="build.sh s=\$SRCSET \$EXTBUILD EL603e"
    ["ELe300c2"]="build.sh s=\$SRCSET \$EXTBUILD ELe300c2"
    ["ELe300c3"]="build.sh s=\$SRCSET \$EXTBUILD ELe300c3"
    ["ELe500mc"]="build.sh s=\$SRCSET \$EXTBUILD ELe500mc"
    ["ELe5500"]="build.sh s=\${SRCSET} \$EXTBUILD ELe5500"
    ["ELe6500"]="build.sh s=\${SRCSET} \$EXTBUILD ELe6500"
    # N
    ["NLe600"]="build.sh s=\$SRCSET \$EXTBUILD t=DGNAT NLe600"
    ["NLe500mc"]="build.sh s=\$SRCSET \$EXTBUILD t=DGNAT NLe500mc"
    ["NLe5500"]="build.sh s=\$SRCSET \$EXTBUILD t=DGNAT NLe5500"
    ["NLe6500"]="build.sh s=\$SRCSET \$EXTBUILD t=DGNAT NLe6500"
    # NSPE
    # We use DGNOBOARD here as the DGNAT causes a lot of trouble during emulation
    # (libgomp mutex soft-float) (..and is way too slow)
    ["NLe500v2"]="build.sh s=\$SRCSET \$EXTBUILD t=DGNOBOARD NLe500v2"
)

report_input () {
    local dryrunstr="false"
    echo "######################################################"
    echo "RELEASE:       $RELEASE"
    echo "Release type:  $RELTYPE"
    echo "Targets:       ${TARGETS[@]}"
    echo "Source set:    $SRCSET"
    echo "Extra build:   $EXTBUILD"
    if [ "$DRYRUN" = "#" ]; then
        dryrunstr="true"
    fi 
    echo "Dry run:       $dryrunstr"
    echo "######################################################"
}

for a in "$@"; do
    case $a in
        -n) 
            DRYRUN='#'
            ;;
	-h)
	    cat <<EOF
Usage is:
    build_release.sh [<options>] [r=<tag>_<type>] [t=<target_type>] [s=<source set>] 
                     [b=<extra build opts>] <target1> .. <targetN>

Where <options> is any of:
    -h              Print this help and exit
    -n              Dry run, do not execute
    -no-log         Do not log output
    -no-deja        Do not run gcc dejagnu tests
    -no-tar         Do not create tar ball
    -no-Wtar        Do not create windows tar ball
    -rm-build       Remove build directories after each step
                    (for CDE disk space challenged machines)
    s=<source set>  Default is F460
    r=<tag>_<type>  The way logs file will be named: <tag>_<type>_<source set>_<target>
                    <type> must be one of: "Lcross" "cross" "eabi" "native" "native_spe"
    b=<build opt>   List of extra build.sh options to add to every build
EOF
            echo "    \"targets\" may be one or more of the following (but must be the same target_type):"
            for i in ${!BUILDS[@]}; do
                echo "$i" 
            done
	    exit 0
	    ;;
	-no-log)
	    NOLOG='#'
	    ;;
	-no-deja)
	    NOTEST='#'
	    ;;
        -no-tar)
            NOTAR='#'
            ;;
        -no-Wtar)
            NOWTAR='#'
            ;;
        -rm-build)
            NORM=""
            ;;
	r=*)
	    x=${a:2}
	    RELEASE=`echo $x | awk -F "_" '{print $1}'`
	    RELTYPE=`echo $x | awk -F "_" '{print $2}'`
	    if [ "$RELTYPE" != "Lcross" -a "$RELTYPE" != "cross" -a "$RELTYPE" != "eabi" \
		-a "$RELTYPE" != "native" -a "$RELTYPE" != "native-spe" ]; then
		echo "Release type must be one of: \"Lcross\" \"cross\" \"eabi\" \"native\" \"native-spe\""
		echo "    RELEASE=$RELEASE"
		echo "    RELTYPE=$RELTYPE"
		exit 1;
	    fi
	    ;;
        s=*)
	    SRCSET=${a:2}
	    ;;
        b=*)
	    EXTBUILD="${a:2}"
	    ;;
        *)
            if [ "${BUILDS[$a]}" = "" ]; then
                echo "Unknown target name: $a"
                exit 1;
            fi
            # Save array of targets
            TARGETS[${#TARGETS[@]}]="$a"
            ;;
    esac
done

for target in ${TARGETS[@]}; do
    report_input
    eval "echo    ${BUILDS[$target]}"
    eval $DRYRUN "${BUILDS[$target]}" $NOLOG -V ${RELEASE}_${RELTYPE}_${SRCSET}_$target
    eval $DRYRUN "${BUILDS[$target]}" -s spec $NOLOG -V ${RELEASE}_${RELTYPE}_${SRCSET}_$target
    eval $DRYRUN $NOTEST "${BUILDS[$target]}" -s Tgcc $NOLOG -V ${RELEASE}_${RELTYPE}_${SRCSET}_$target
    eval $DRYRUN $NOTAR  "${BUILDS[$target]}" -s tar $NOLOG -V ${RELEASE}_${RELTYPE}_${SRCSET}_$target
    eval $DRYRUN $NOWTAR "${BUILDS[$target]}" -s Wtar $NOLOG -V ${RELEASE}_${RELTYPE}_${SRCSET}_$target
    job=`echo "${BUILDS[$target]}" | awk '{print $NF}'`
    if [ "$job" != "" ]; then
	eval $DRYRUN $NORM rm -rf opt/freescale/$job opt/freescale/$job.descriptors
    fi
done
