#!/bin/bash

# Arguments
REV=$1
SRC=$2
JOB=$3
LOG=$4
DO_SPEC=$5
DEBUG=$6

if [ "$REV" = "" -o "$SRC" = "" -o "$JOB" = "" -o "$LOG" = "" -o "$DO_SPEC" = "" ]; then
    echo "Error on job submission REV=$REV SRC=$SRC JOB=$JOB LOG=$LOG DO_SPEC=$DO_SPEC"
    echo "Examples:"
    echo "  bsub -q normal -P nmg.devtech.tools -R \"select[rhel5] span[hosts=1]\" -R \"rusage[tmp=10000] && mem>4096\" -n 8 -J XLMe300c3 ./build_lsf.sh 905 F481 XLMe300c3 release_r905_build_CDE_$XLMe300c3 Y"
    echo "  bsub -q normal -P nmg.devtech.tools -R \"select[rhel5] span[hosts=1]\" -R \"rusage[tmp=10000] && mem>4096\" -n 8 -J ELe300c3  ./build_lsf.sh 905 F481 ELe300c3 release_r905_build_CDE_ELe300c3 N"
    exit 1
fi

if [ "$DEBUG" = "" ]; then
    mkdir -p /tmp/$USER/$JOB && cd /tmp/$USER/$JOB
else
    mkdir -p /proj/ppc/DT/labhome/edmar/$JOB && cd /proj/ppc/DT/labhome/edmar/$JOB
fi
build.sh -LSF s=$SRC -i /pkg/fs-DTgnu- $JOB -V $LOG
if [ "$DO_SPEC" = "Y" ]; then
    build.sh s=$SRC -i /pkg/fs-DTgnu- $JOB -s spec -V $LOG
fi
build.sh s=$SRC -i /pkg/fs-DTgnu- $JOB -s tar -V $LOG
if [ "$DEBUG" = "" ]; then
    rm -rf /tmp/$USER/$JOB
fi
