/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class InputWindow
implements Runnable {
    private String buffer;
    GridData headerData;
    int nameMaxWidth = Integer.MIN_VALUE;
    int style = 0;
    public static final int DEFAULT = 0;
    public static final int DIGITAL = 1;
    public static final int TEXT_SIZE_TWO = 2;
    private Input[] inputs;
    private InputData[] inputData;
    private Response response;
    private int numOfInputs;
    String type;
    Display disp;
    Shell shell;
    String title = "";
    String header = "";
    private Label headerLabel;
    private Canvas inputsCanvas;

    InputWindow() {
    }

    public InputData[] getInputData() {
        return this.inputData;
    }

    public void run() {
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        GridLayout shellLayout = new GridLayout(1, true);
        this.disp = Display.getDefault();
        this.shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 67680);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                ((InputWindow)InputWindow.this).response.buttonPressed = 1;
                int i = 0;
                while (i < InputWindow.this.numOfInputs) {
                    ((InputWindow)InputWindow.this).response.value[i] = ((InputWindow)InputWindow.this).inputs[i].value.getText();
                    ++i;
                }
            }
        });
        this.shell.setMinimumSize(150, -1);
        this.shell.setLayout((Layout)shellLayout);
        this.drawTitle();
        this.headerLabel = new Label((Composite)this.shell, 64);
        this.headerData = new GridData(576);
        this.headerData.widthHint = 0;
        this.headerData.heightHint = 0;
        this.headerLabel.setLayoutData((Object)this.headerData);
        this.drawHeader();
        this.inputsCanvas = new Canvas((Composite)this.shell, 0);
        GridLayout layout = new GridLayout(1, true);
        if (this.numOfInputs > 4 && this.numOfInputs < 16) {
            layout.numColumns = 2;
        }
        GridData canvasData = new GridData(576);
        this.inputsCanvas.setLayout((Layout)layout);
        this.inputsCanvas.setLayoutData((Object)canvasData);
        this.inputs = new Input[this.numOfInputs];
        this.response = new Response((Composite)this.shell);
        int i = 0;
        while (i < this.numOfInputs) {
            this.inputs[i] = new Input((Composite)this.inputsCanvas);
            this.inputs[i].setEnabled(this.inputData[i].enabled);
            this.inputs[i].setName(this.inputData[i].name);
            this.inputs[i].setValue(this.inputData[i].value);
            if (this.inputData[i].getMin() != null) {
                this.inputs[i].value.setData("min", (Object)Float.valueOf(Float.parseFloat(this.inputData[i].min)));
            }
            if (this.inputData[i].getMax() != null) {
                this.inputs[i].value.setData("max", (Object)Float.valueOf(Float.parseFloat(this.inputData[i].max)));
            }
            this.inputs[i].setUnit(this.inputData[i].unit);
            ++i;
        }
        i = 0;
        while (i < this.numOfInputs) {
            this.inputs[i].nameData.widthHint = this.nameMaxWidth;
            ++i;
        }
        this.inputsCanvas.pack();
        this.shell.pack();
        this.shell.setLocation(bounds.x + (bounds.width - this.shell.getSize().x) / 2, bounds.y + (bounds.height - this.shell.getSize().y) / 2);
        this.shell.open();
        this.shell.layout();
        this.shell.setActive();
        while (!this.shell.isDisposed()) {
            if (this.disp.readAndDispatch()) continue;
            this.disp.sleep();
        }
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public Input[] getInputs() {
        return this.inputs;
    }

    public Response getResponse() {
        return this.response;
    }

    public void drawTitle() {
        this.shell.setText(this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNumOfInputs(int numOfInputs) {
        this.numOfInputs = numOfInputs;
        this.inputData = new InputData[numOfInputs];
        int i = 0;
        while (i < numOfInputs) {
            this.inputData[i] = new InputData();
            ++i;
        }
    }

    public void drawHeader() {
        if (!this.header.equals("")) {
            this.headerData.widthHint = 190;
            this.headerData.heightHint = -1;
        }
        this.headerLabel.setText(this.header);
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public Label getHeader() {
        return this.headerLabel;
    }

    public void enableHeader(boolean enable) {
        if (!enable) {
            this.headerLabel.setSize(0, 0);
        }
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public class Input {
        GridData nameData;
        GridData valueData;
        Canvas canvas;
        int number;
        int offset = 0;
        Label name;
        Text value;
        Label unit;
        int nameWidth;
        int valueWidth;
        boolean hasUnit = true;
        boolean isEnabled = true;
        String nameStr;
        String valueStr;
        String unitStr;

        Input(Composite parent) {
            this.canvas = new Canvas(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            GridData canvasData = new GridData(32);
            this.canvas.setLayout((Layout)layout);
            this.canvas.setLayoutData((Object)canvasData);
            this.nameData = new GridData();
            this.valueData = new GridData();
            this.valueData.widthHint = 40;
            this.name = new Label((Composite)this.canvas, 0);
            this.name.setLayoutData((Object)this.nameData);
            this.value = new Text((Composite)this.canvas, 2048);
            this.value.setLayoutData((Object)this.valueData);
            if ((InputWindow.this.style & 2) == 2) {
                this.value.setTextLimit(2);
            } else if ((InputWindow.this.style & 1) == 1) {
                this.value.setTextLimit(4);
            }
            if ((InputWindow.this.style & 1) == 1) {
                this.value.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent event) {
                        char[] chrArray;
                        char[] cArray = chrArray = event.text.toCharArray();
                        int n = chrArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char chr = cArray[n2];
                            if (!(chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'f' || chr >= 'A' && chr <= 'F' || event.character == '\b' || event.character == '\u007f')) {
                                event.doit = false;
                            }
                            ++n2;
                        }
                    }
                });
            } else {
                this.value.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent event) {
                        block2: {
                            try {
                                Float.parseFloat(event.text);
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (event.character >= '0' && event.character <= '9' || event.character == '.' || event.character == '\b' || event.character == '\u007f') break block2;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.value.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent event) {
                        InputWindow.this.buffer = Input.this.value.getText();
                    }

                    public void focusLost(FocusEvent event) {
                        try {
                            if (Input.this.value.getData("max") != null && Input.this.value.getData("min") != null) {
                                float max = ((Float)Input.this.value.getData("max")).floatValue();
                                float min = ((Float)Input.this.value.getData("min")).floatValue();
                                if (Float.parseFloat(Input.this.value.getText()) > max) {
                                    Input.this.value.setText(String.format("%.2f", Float.valueOf(max)));
                                }
                                if (Float.parseFloat(Input.this.value.getText()) < min) {
                                    Input.this.value.setText(String.format("%.2f", Float.valueOf(min)));
                                }
                            }
                            Input.this.value.setText(String.format("%.2f", Float.valueOf(Float.parseFloat(Input.this.value.getText()))));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Input.this.value.setText(InputWindow.this.buffer);
                        }
                    }
                });
            }
            this.unit = new Label((Composite)this.canvas, 0);
        }

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public void setName(String nameStr) {
            this.nameStr = nameStr;
            this.drawName();
        }

        public void drawName() {
            this.name.setText(this.nameStr);
            int width = this.name.computeSize((int)-1, (int)-1).x;
            if (width > InputWindow.this.nameMaxWidth) {
                InputWindow.this.nameMaxWidth = width;
            }
            this.name.setEnabled(this.isEnabled);
        }

        public void setValue(String valueStr) {
            this.valueStr = valueStr;
            this.drawValue();
        }

        public void drawValue() {
            this.value.setText(this.valueStr);
            this.value.setEnabled(this.isEnabled);
        }

        public void setUnit(String unitStr) {
            this.unitStr = unitStr;
            this.drawUnit();
        }

        public void drawUnit() {
            this.unit.setText(this.unitStr);
            this.unit.setEnabled(this.isEnabled);
        }

        public boolean checkRange() {
            return true;
        }
    }

    public class InputData {
        String name;
        String value;
        String unit;
        String max;
        String min;
        boolean enabled;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setMax(String max) {
            this.max = max;
        }

        public String getMax() {
            return this.max;
        }

        public void setMin(String min) {
            this.min = min;
        }

        public String getMin() {
            return this.min;
        }
    }

    public class Response {
        Canvas canvas;
        Button okButton;
        Button cancelButton;
        int buttonPressed = 1;
        String[] value;

        Response(Composite parent) {
            this.value = new String[InputWindow.this.numOfInputs];
            this.canvas = new Canvas(parent, 0);
            GridLayout layout = new GridLayout(2, true);
            GridData canvasData = new GridData(64);
            this.canvas.setLayout((Layout)layout);
            this.canvas.setLayoutData((Object)canvasData);
            GridData data = new GridData(1808);
            this.okButton = new Button((Composite)this.canvas, 0);
            this.okButton.setLayoutData((Object)data);
            this.okButton.setText("Ok");
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Response.this.buttonPressed = 0;
                    int i = 0;
                    while (i < InputWindow.this.numOfInputs) {
                        Response.this.value[i] = ((InputWindow)((Response)Response.this).InputWindow.this).inputs[i].value.getText();
                        ++i;
                    }
                    InputWindow.this.close();
                }
            });
            this.cancelButton = new Button((Composite)this.canvas, 0);
            this.cancelButton.setLayoutData((Object)data);
            this.cancelButton.setText("Cancel");
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Response.this.buttonPressed = 1;
                    int i = 0;
                    while (i < InputWindow.this.numOfInputs) {
                        Response.this.value[i] = ((InputWindow)((Response)Response.this).InputWindow.this).inputs[i].value.getText();
                        ++i;
                    }
                    InputWindow.this.close();
                }
            });
            this.canvas.pack();
        }
    }
}

