/***************************************************************** 
 * PROJECT     : MPC5604P
 * FILE        : 5604P_Header_v2_00.h
 * 
 * DESCRIPTION : This is the header file describing the register
 *               set for the named projects. This Header file is inline with the RM Rev.6.
 * 
 * COPYRIGHT   :(c) 2015, Freescale
 * 
 * VERSION	   : 02.00
 * DATE	   	   : 3.3.2014  
 * AUTHOR       : B37643
 *----------------------------------------------------------------*
 * HISTORY		Rev 2.0 : Change Header file according to the RM Rev 6
 *				Repaired chapter: ADC, MCM -> ECSM, SIU -> SIUL, SSCM, STM, SWT, WKUP, LINFLEX, ME, CGM, RGM, PCU, 
 *								  FLEXPWM, eTimer, CTU, FCU, PIT, EDMA, INTC, DSPI0,1,2,3, DMAMUX, FlexRay, CRC0,1
 *								  DFLASH, CFLASH 				
 *				Removed: CANSP, RTC, LINFLEX2,3, FlexPWM1, CTU1, SMC, EMIOS0,1, I2C0,1,2,3, MPU, CAN1,2,3,4,5, LCD, EBI, DCU,  
 * HISTORY		: Changes: remove IMRH and IFRH register and rename IMRL -> IMASK1, IFRL->IFLAG1 in the FlexCAN and safety port
 * HISTORY		: changes: repaired wrong definition of CRC module (b37643)
 * HISTORY		: Changes: typo fixed in PSR1 register:SCP -> CSP, MCR: PRESCALE->BITRATE (b16991)
 * HISTORY		: Changes: typo fixed in ME register MTC bit, SSCM fix, CMU changes(b16991)
 * HISTORY		: Changes to CTU Module:  CR register (LC->FC), CLR changed to 24 bits  (b16991)
 
 * HISTORY	    : Modified to add reserved space in CTU (b16991)
 * HISTORY      : Modified to support ADC on Pictus cut 2 - do not distribute! (ttz778)
 * HISTORY      : Modified to support CRC on Pictus cut 2 - do not distribute! (r60321)
 * HISTORY      : Modified to support DSPI0 CS7&8 and new FlexPWM naming on Pictus cut 2 (r60321)
 * HISTORY      : Modified to update MIDR1&2 registers and LINCR1-SFTM and LINESR-BDEF bit on Pictus (r60321)
 * HISTORY      : Modified to update RGM, CFLASH & DFLASH registers and FlexCAN & CTU Registers on Pictus (r60321)
 * HISTORY      : Modified to update DSPI Registers (FIFO deep) on Pictus  (b16991)
 *
 ***************************************************************** 
 * Copyright:
 *	Freescale Semiconductor, INC. All Rights Reserved.
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Freescale
 *  Semiconductor, Inc. This software is provided on an "AS IS"
 *  basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, Freescale
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH
 *  REGARD TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF)
 *  AND ANY ACCOMPANYING WRITTEN MATERIALS.
 *
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.
 *
 *  Freescale Semiconductor assumes no responsibility for the
 *  maintenance and support of this software
 *
 ******************************************************************/
/***************************************************************** 
* Example instantiation and use:            
*                                           
*  <MODULE>.<REGISTER>.B.<BIT> = 1;         
*  <MODULE>.<REGISTER>.R       = 0x10000000;
*                                           
******************************************************************/

#ifndef _JDP_H_
#define _JDP_H_

#include "typedefs.h"

#ifdef  __cplusplus
extern "C" {
#endif

#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
/****************************************************************************/
/*                          MODULE : ADC                                   */
/****************************************************************************/
    struct ADC_tag {

        union {
            vuint32_t R;
            struct {
                vuint32_t OWREN:1;
                vuint32_t WLSIDE:1;
                vuint32_t MODE:1;
				vuint32_t :4;
                vuint32_t NSTART:1;
                vuint32_t:1;
                vuint32_t JTRGEN:1;
                vuint32_t JEDGE:1;
                vuint32_t JSTART:1;
                vuint32_t:2;
                vuint32_t CTUEN:1;
                vuint32_t:8;
                vuint32_t ADCLKSEL:1;
                vuint32_t ABORTCHAIN:1;
                vuint32_t ABORT:1;
                vuint32_t ACK0:1;
                vuint32_t:4;
                vuint32_t PWDN:1;
            } B;
        } MCR;                 /* MAIN CONFIGURATION REGISTER */

        union {
            vuint32_t R;
            struct {
                vuint32_t:7;
                vuint32_t NSTART:1;
                vuint32_t JABORT:1;
                vuint32_t:2;
                vuint32_t JSTART:1;
                vuint32_t:3;
                vuint32_t CTUSTART:1;
                vuint32_t CHADDR:7;
                vuint32_t:3;
                vuint32_t ACK0:1;
				vuint32_t :2;
                vuint32_t ADCSTATUS:3;
            } B;
        } MSR;                 /* MAIN STATUS REGISTER */

        int32_t ADC_reserved1[2];       /* (0x008 - 0x00F+1)/4 = 0x02 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:27;
                vuint32_t EOCTU:1;
                vuint32_t JEOC:1;
                vuint32_t JECH:1;
                vuint32_t EOC:1;
                vuint32_t ECH:1;
            } B;
        } ISR;                 /* INTERRUPT STATUS REGISTER */

		int32_t ADC_reserved2[3];       /* (0x014 - 0x01F+1)/4 = 0x03 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:27;			//One bit added
                vuint32_t MSKEOCTU:1;		//New for cut 2
                vuint32_t MSKJEOC:1;
                vuint32_t MSKJECH:1;
                vuint32_t MSKEOC:1;
                vuint32_t MSKECH:1;
            } B;
        } IMR;                 /* INTERRUPT MASK REGISTER */

		int32_t ADC_reserved3[3];		/* (0x024 - 0x02F+1)/4 = 0x03 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:24;
                vuint32_t WDG3H:1;
                vuint32_t WDG2H:1;
                vuint32_t WDG1H:1;
                vuint32_t WDG0H:1;
                vuint32_t WDG3L:1;
                vuint32_t WDG2L:1;
                vuint32_t WDG1L:1;
                vuint32_t WDG0L:1;
            } B;
        } WTISR;               /* WATCHDOG INTERRUPT THRESHOLD REGISTER was WDGTHR */

        union {
            vuint32_t R;
            struct {
                vuint32_t:24;
                vuint32_t MSKWDG3H:1;
                vuint32_t MSKWDG2H:1;
                vuint32_t MSKWDG1H:1;
                vuint32_t MSKWDG0H:1;
                vuint32_t MSKWDG3L:1;
                vuint32_t MSKWDG2L:1;
                vuint32_t MSKWDG1L:1;
                vuint32_t MSKWDG0L:1;
            } B;
        } WTIMR;				/* WATCHDOG INTERRUPT MASK REGISTER was IMWDGTHR */

        int32_t ADC_reserved4[2];       /* (0x038 - 0x03F+1)/4 = 0x02 */

		union {
            vuint32_t R;
            struct {
                vuint32_t:30;			//was 16
                vuint32_t DCLR:1;		//moved
                vuint32_t DMAEN:1;		//moved
            } B;
        } DMAE;                /* DMAE REGISTER */

		union {
            vuint32_t R;
            struct {
                vuint32_t :16;
                vuint32_t DMA15:1;
                vuint32_t DMA14:1;
                vuint32_t DMA13:1;
                vuint32_t DMA12:1;
                vuint32_t DMA11:1;
                vuint32_t DMA10:1;
                vuint32_t DMA9:1;
                vuint32_t DMA8:1;
                vuint32_t DMA7:1;
                vuint32_t DMA6:1;
                vuint32_t DMA5:1;
                vuint32_t DMA4:1;
                vuint32_t DMA3:1;
                vuint32_t DMA2:1;
                vuint32_t DMA1:1;
                vuint32_t DMA0:1;
            } B;
        } DMAR0;				/* DMA REGISTER  was [6] */

		int32_t ADC_reserved5[2];       /* (0x048 - 0x04F+1)/4 = 0x03 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t THREN:1;
                vuint32_t THRINV:1;
                vuint32_t THROP:1;
                  vuint32_t:6;
                vuint32_t THRCH:7;
            } B;
        } TRC[4];              /* ADC THRESHOLD REGISTER REGISTER */

        union {
            vuint32_t R;
            struct {		//were in TRA & TRB
                vuint32_t:6;
                vuint32_t THRH:10;
                vuint32_t:6;
                vuint32_t THRL:10;
            } B;
        } THRHLR[4];           /* THRESHOLD REGISTER */
		
		int32_t ADC_reserved6[9];       /* (0x070 - 0x093+1)/4 = 0x09 */

		union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t INPLATCH:1;
                  vuint32_t:1;
                vuint32_t OFFSHIFT:2;		//!!! This field only in CTR[0]
                  vuint32_t:1;
                vuint32_t INPCMP:2;
                  vuint32_t:1;
                vuint32_t INPSAMP:8;
            } B;
        } CTR0;                /* CONVERSION TIMING REGISTER was CT[3] */

        int32_t ADC_reserved7[3];       /* (0x098 - 0x0A3+1)/4 = 0x03 */

		union {
            vuint32_t R;
            struct {
                vuint32_t :16;
                vuint32_t CH15:1;
                vuint32_t CH14:1;
                vuint32_t CH13:1;
                vuint32_t CH12:1;
                vuint32_t CH11:1;
                vuint32_t CH10:1;
                vuint32_t CH9:1;
                vuint32_t CH8:1;
                vuint32_t CH7:1;
                vuint32_t CH6:1;
                vuint32_t CH5:1;
                vuint32_t CH4:1;
                vuint32_t CH3:1;
                vuint32_t CH2:1;
                vuint32_t CH1:1;
                vuint32_t CH0:1;
            } B;
        } NCMR0;				/* NORMAL CONVERSION MASK REGISTER was [6] */

        int32_t ADC_reserved8[3];       /* (0x0A8 - 0x0B3+1)/4 = 0x03 */

        union {
            vuint32_t R;
            struct {
                vuint32_t :16;
                vuint32_t CH15:1;
                vuint32_t CH14:1;
                vuint32_t CH13:1;
                vuint32_t CH12:1;
                vuint32_t CH11:1;
                vuint32_t CH10:1;
                vuint32_t CH9:1;
                vuint32_t CH8:1;
                vuint32_t CH7:1;
                vuint32_t CH6:1;
                vuint32_t CH5:1;
                vuint32_t CH4:1;
                vuint32_t CH3:1;
                vuint32_t CH2:1;
                vuint32_t CH1:1;
                vuint32_t CH0:1;
            } B;
        } JCMR0;             /* Injected CONVERSION MASK REGISTER was ICMR[6] */

	int32_t ADC_reserved9[4];       /* (0x0B8 - 0x0C7+1)/4 = 0x04 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:24;
                vuint32_t PDED:8;	//was PDD
            } B;
        } PDEDR;               /* POWER DOWN DELAY REGISTER was PDD */

        int32_t ADC_reserved10[13];			/* (0x0CC - 0x0FF+1)/4 = 0x0D */

        union {
            vuint32_t R;
            struct {
                vuint32_t:12;
                vuint32_t VALID:1;
                vuint32_t OVERW:1;
                vuint32_t RESULT:2;
                vuint32_t:6;
                vuint32_t CDATA:10;
            } B_R;
			struct {
                vuint32_t:12;
                vuint32_t VALID:1;
                vuint32_t OVERW:1;
                vuint32_t RESULT:2;
                vuint32_t CDATA:10;
				vuint32_t:6;
            } B_L;
        } CDR[16];      /* Channel 0-15 Data REGISTER */

    };                          /* end of ADC_tag */
/****************************************************************************/
/*                          MODULE : ECSM                                   */
/****************************************************************************/
    struct ECSM_tag {

        union {
            vuint16_t R;
        } PCT;                  /* ECSM Processor Core Type Register */

        union {
            vuint16_t R;
        } REV;                  /* ECSM  Revision Register */

		union {
            vuint16_t R;
			struct {
                vuint8_t :8;
                vuint8_t AMC:8;
            } B;
        } PLAMC;                /* ECSM  Platform XBAR Master Configuration Register */

		union {
            vuint16_t R;
			struct {
				vuint8_t DP64:1;
                vuint8_t :7;
                vuint8_t ASC:8;
            } B;
        } PLASC;                /* ECSM  Paltform XBAR Slave Configuration Register */

        union {
            vuint32_t R;
        } IMC;                  /* ECSM IPS Configuration Register */

        int8_t ECSM_reserved1[5];		/* (0x00A- 0x00E+1) = 0x05 */

        union {
            vuint8_t R;
            struct {
                vuint8_t POR:1;
                vuint8_t DIR:1;
                  vuint8_t:6;
            } B;
        } MRSR;                 /* ECSM Miscellaneous Reset Status Register */

        int8_t ECSM_reserved2[15];		/* (0x010- 0x01E+1) = 0x0F */

        union {
            vuint8_t R;
            struct {
                vuint8_t FB0AI:1;
                vuint8_t FB0SI:1;
                vuint8_t FB1AI:1;
                vuint8_t FB1SI:1;
                  vuint8_t:4;
            } B;
        } MIR;                  /* ECSM Miscellaneous Interrupt Register */

        int8_t ECSM_reserved3[4];		/* (0x020- 0x023+1) = 0x04 */

        union {
            vuint32_t R;
			struct {
				vuint32_t MUDCR31:1;
				vuint32_t :31;
			}B;
        } MUDCR;                /* ECSM Miscellaneous User-Defined Control Register */

        int8_t ECSM_reserved4[27];       /* (0x028- 0x042+1) = 0x1B */

        union {
            vuint8_t R;
            struct {
                vuint8_t:2;
                vuint8_t ER1BR:1;
                vuint8_t EF1BR:1;
                  vuint8_t:2;
                vuint8_t ERNCR:1;
                vuint8_t EFNCR:1;
            } B;
        } ECR;                  /* ECSM ECC Configuration Register */

        int8_t ECSM_reserved5[3];       /* (0x044- 0x046+1) = 0x03 */

        union {
            vuint8_t R;
            struct {
                vuint8_t:2;
                vuint8_t R1BC:1;
                vuint8_t F1BC:1;
                  vuint8_t:2;
                vuint8_t RNCE:1;
                vuint8_t FNCE:1;
            } B;
        } ESR;                  /* ECSM ECC Status Register */

        int8_t ECSM_reserved6[2];       /* (0x048- 0x049+1) = 0x02 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:2;
                vuint16_t FRC1BI:1;
                vuint16_t FR11BI:1;
                  vuint16_t:2;
                vuint16_t FRCNCI:1;
                vuint16_t FR1NCI:1;
                  vuint16_t:1;
                vuint16_t ERRBIT:7;
            } B;
        } EEGR;                 /* ECSM ECC Error Generation Register */

        int8_t ECSM_reserved7[4];       /* (0x04C- 0x04F+1) = 0x04 */

        union {
            vuint32_t R;
        } FEAR;                 /* ECSM Flash ECC Address Register */

        int8_t ECSM_reserved8[2];       /* (0x054- 0x055+1) = 0x02 */

        union {
            vuint8_t R;
            struct {
                vuint8_t:4;
                vuint8_t FEMR:4;
            } B;
        } FEMR;                 /* ECSM Flash ECC Master Number Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t WRITE:1;
                vuint8_t SIZE:3;
                vuint8_t PROTECTION:4;
            } B;
        } FEAT;                 /* ECSM Flash ECC Attributes Register */

        int8_t ECSM_reserved9[4];       /* (0x058- 0x05B+1) = 0x04 */

        union {
            vuint32_t R;
        } FEDR;                 /* ECSM Flash ECC Data Register */

        union {
            vuint32_t R;
        } REAR;                 /* ECSM RAM ECC Address Register */

        int8_t ECSM_reserved10[1];       /* (0x064) = 0x01 */

        union {
            vuint8_t R;
        } RESR;                 /* ECSM RAM ECC Address Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:4;
                vuint8_t REMR:4;
            } B;
        } REMR;                 /* ECSM RAM ECC Master Number Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t WRITE:1;
                vuint8_t SIZE:3;
                vuint8_t PROTECTION:4;
            } B;
        } REAT;                 /* ECSM RAM ECC Attributes Register */

        int8_t ECSM_reserved11[4];       /* (0x068- 0x06B+1) = 0x1B */

        union {
            vuint32_t R;
        } REDR;                 /* ECSM RAM ECC Data Register */

    };                          /* end of MCM_tag */
/****************************************************************************/
/*                     MODULE : SIUL                                         */
/****************************************************************************/
    struct SIUL_tag {
		
        int32_t SIUL_reserved1[1];		/* (0x000- 0x003+1)/4 = 0x01 */

        union {                 /* MCU ID Register 1 */
            vuint32_t R;
            struct {
                vuint32_t PARTNUM:16;
				vuint32_t CSP:1;
                vuint32_t PKG:5;
				vuint32_t:2;
                vuint32_t MAJOR_MASK:4;
				vuint32_t MINOR_MASK:4;
            } B;
        } MIDR1;

        union {                 /* MCU ID Register 2 */
            vuint32_t R;
            struct {
                vuint32_t SF:1;
                vuint32_t FLASH_SIZE_1:4;
                vuint32_t FLASH_SIZE_2:4;
				vuint32_t:7;
                vuint32_t PARTNUM:8;
				vuint32_t:3;
                vuint32_t EE:1;
				vuint32_t:3;
				vuint32_t FR:1;
            } B;
        } MIDR2;

        int32_t SIUL_reserved2[2];		/* (0x00C- 0x013+1)/4 = 0x02 */

        union {                 /* Interrupt Status Flag Register */
            vuint32_t R;
            struct {
                vuint32_t EIF31:1;
                vuint32_t EIF30:1;
                vuint32_t EIF29:1;
                vuint32_t EIF28:1;
                vuint32_t EIF27:1;
                vuint32_t EIF26:1;
                vuint32_t EIF25:1;
                vuint32_t EIF24:1;
                vuint32_t EIF23:1;
                vuint32_t EIF22:1;
                vuint32_t EIF21:1;
                vuint32_t EIF20:1;
                vuint32_t EIF19:1;
                vuint32_t EIF18:1;
                vuint32_t EIF17:1;
                vuint32_t EIF16:1;
                vuint32_t EIF15:1;
                vuint32_t EIF14:1;
                vuint32_t EIF13:1;
                vuint32_t EIF12:1;
                vuint32_t EIF11:1;
                vuint32_t EIF10:1;
                vuint32_t EIF9:1;
                vuint32_t EIF8:1;
                vuint32_t EIF7:1;
                vuint32_t EIF6:1;
                vuint32_t EIF5:1;
                vuint32_t EIF4:1;
                vuint32_t EIF3:1;
                vuint32_t EIF2:1;
                vuint32_t EIF1:1;
                vuint32_t EIF0:1;
            } B;
        } ISR;

        union {                 /* Interrupt Request Enable Register */
            vuint32_t R;
            struct {
                vuint32_t IRE31:1;
                vuint32_t IRE30:1;
                vuint32_t IRE29:1;
                vuint32_t IRE28:1;
                vuint32_t IRE27:1;
                vuint32_t IRE26:1;
                vuint32_t IRE25:1;
                vuint32_t IRE24:1;
                vuint32_t IRE23:1;
                vuint32_t IRE22:1;
                vuint32_t IRE21:1;
                vuint32_t IRE20:1;
                vuint32_t IRE19:1;
                vuint32_t IRE18:1;
                vuint32_t IRE17:1;
                vuint32_t IRE16:1;
                vuint32_t IRE15:1;
                vuint32_t IRE14:1;
                vuint32_t IRE13:1;
                vuint32_t IRE12:1;
                vuint32_t IRE11:1;
                vuint32_t IRE10:1;
                vuint32_t IRE9:1;
                vuint32_t IRE8:1;
                vuint32_t IRE7:1;
                vuint32_t IRE6:1;
                vuint32_t IRE5:1;
                vuint32_t IRE4:1;
                vuint32_t IRE3:1;
                vuint32_t IRE2:1;
                vuint32_t IRE1:1;
                vuint32_t IRE0:1;
            } B;
        } IRER;

        int32_t SIUL_reserved3[3];		/* (0x01C- 0x027+1)/4 = 0x03 */

        union {                 /* Interrupt Rising-Edge Event Enable Register */
            vuint32_t R;
            struct {
                vuint32_t IREE31:1;
                vuint32_t IREE30:1;
                vuint32_t IREE29:1;
                vuint32_t IREE28:1;
                vuint32_t IREE27:1;
                vuint32_t IREE26:1;
                vuint32_t IREE25:1;
                vuint32_t IREE24:1;
                vuint32_t IREE23:1;
                vuint32_t IREE22:1;
                vuint32_t IREE21:1;
                vuint32_t IREE20:1;
                vuint32_t IREE19:1;
                vuint32_t IREE18:1;
                vuint32_t IREE17:1;
                vuint32_t IREE16:1;
                vuint32_t IREE15:1;
                vuint32_t IREE14:1;
                vuint32_t IREE13:1;
                vuint32_t IREE12:1;
                vuint32_t IREE11:1;
                vuint32_t IREE10:1;
                vuint32_t IREE9:1;
                vuint32_t IREE8:1;
                vuint32_t IREE7:1;
                vuint32_t IREE6:1;
                vuint32_t IREE5:1;
                vuint32_t IREE4:1;
                vuint32_t IREE3:1;
                vuint32_t IREE2:1;
                vuint32_t IREE1:1;
                vuint32_t IREE0:1;
            } B;
        } IREER;

        union {                 /* Interrupt Falling-Edge Event Enable Register */
            vuint32_t R;
            struct {
                vuint32_t IFEE31:1;
                vuint32_t IFEE30:1;
                vuint32_t IFEE29:1;
                vuint32_t IFEE28:1;
                vuint32_t IFEE27:1;
                vuint32_t IFEE26:1;
                vuint32_t IFEE25:1;
                vuint32_t IFEE24:1;
                vuint32_t IFEE23:1;
                vuint32_t IFEE22:1;
                vuint32_t IFEE21:1;
                vuint32_t IFEE20:1;
                vuint32_t IFEE19:1;
                vuint32_t IFEE18:1;
                vuint32_t IFEE17:1;
                vuint32_t IFEE16:1;
                vuint32_t IFEE15:1;
                vuint32_t IFEE14:1;
                vuint32_t IFEE13:1;
                vuint32_t IFEE12:1;
                vuint32_t IFEE11:1;
                vuint32_t IFEE10:1;
                vuint32_t IFEE9:1;
                vuint32_t IFEE8:1;
                vuint32_t IFEE7:1;
                vuint32_t IFEE6:1;
                vuint32_t IFEE5:1;
                vuint32_t IFEE4:1;
                vuint32_t IFEE3:1;
                vuint32_t IFEE2:1;
                vuint32_t IFEE1:1;
                vuint32_t IFEE0:1;
            } B;
        } IFEER;

        union {                 /* Interrupt Filter Enable Register */
            vuint32_t R;
            struct {
                vuint32_t IFE31:1;
                vuint32_t IFE30:1;
                vuint32_t IFE29:1;
                vuint32_t IFE28:1;
                vuint32_t IFE27:1;
                vuint32_t IFE26:1;
                vuint32_t IFE25:1;
                vuint32_t IFE24:1;
                vuint32_t IFE23:1;
                vuint32_t IFE22:1;
                vuint32_t IFE21:1;
                vuint32_t IFE20:1;
                vuint32_t IFE19:1;
                vuint32_t IFE18:1;
                vuint32_t IFE17:1;
                vuint32_t IFE16:1;
                vuint32_t IFE15:1;
                vuint32_t IFE14:1;
                vuint32_t IFE13:1;
                vuint32_t IFE12:1;
                vuint32_t IFE11:1;
                vuint32_t IFE10:1;
                vuint32_t IFE9:1;
                vuint32_t IFE8:1;
                vuint32_t IFE7:1;
                vuint32_t IFE6:1;
                vuint32_t IFE5:1;
                vuint32_t IFE4:1;
                vuint32_t IFE3:1;
                vuint32_t IFE2:1;
                vuint32_t IFE1:1;
                vuint32_t IFE0:1;
            } B;
        } IFER;

        int32_t SIUL_reserved4[3];		/* (0x034- 0x03F+1)/4 = 0x03 */

        union {                 /* Pad Configuration Registers */
            vuint16_t R;
            struct {
                vuint16_t:1;
                vuint16_t SMC:1;
                vuint16_t APC:1;
                vuint16_t:1;
                vuint16_t PA:2;
                vuint16_t OBE:1;
                vuint16_t IBE:1;
                vuint16_t:2;
                vuint16_t ODE:1;
                vuint16_t:2;
                vuint16_t SRC:1;
                vuint16_t WPE:1;
                vuint16_t WPS:1;
            } B;
        } PCR[107];

        int32_t SIUL_reserved5[250];		/* (0x118- 0x4FF+1)/4 = 0xFA */

        union {                 /* Pad Selection for Multiplexed Input Register */
            vuint8_t R;
            struct {
                vuint8_t:4;
                vuint8_t PADSEL:4;
            } B;
        } PSMI[35];

		int32_t SIUL_reserved6[55];		/* (0x524- 0x5FF+1)/4 = 0x37 */

        union {                 /* GPIO Pin Data Output Registers */
            vuint8_t R;
            struct {
                vuint8_t:7;
                vuint8_t PDO:1;
            } B;
        } GPDO[107];

		int32_t SIUL_reserved7[101];		/* (0x66C- 0x7FF+1)/4 = 0x65 */

        union {                 /* GPIO Pin Data Input Registers */
            vuint8_t R;
            struct {
                vuint8_t:7;
                vuint8_t PDI:1;
            } B;
        } GPDI[107];

        int32_t SIUL_reserved8[229];		/* (0x86C- 0xBFF+1)/4 = 0xE5 */

        union {                 /* Parallel GPIO Pin Data Output Register */
            vuint32_t R;
            struct {
                vuint32_t PPD0:32;
            } B;
        } PGPDO[4];

		int32_t SIUL_reserved9[12];		/* (0xC10- 0xC3F+1)/4 = 0xC */

        union {                 /* Parallel GPIO Pin Data Input Register */
            vuint32_t R;
            struct {
                vuint32_t PPDI:32;
            } B;
        } PGPDI[4];

		int32_t SIUL_reserved10[12];		/* (0xC50- 0xC7F+1)/4 = 0xC */

        union {                 /* Masked Parallel GPIO Pin Data Out Register */
            vuint32_t R;
            struct {
                vuint32_t MASK:16;
                vuint32_t MPPDO:16;
            } B;
        } MPGPDO[7];

      	int32_t SIUL_reserved11[217];		/* (0xC9C- 0xFFF+1)/4 = 0xD9 */

        union {                 /* Interrupt Filter Maximum Counter Register */
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t MAXCNT:4;
            } B;
        } IFMC[32];

        union {                 /* Interrupt Filter Clock Prescaler Register */
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t IFCP:4;
            } B;
        } IFCPR;

    };                          /* end of SIU_tag */
/****************************************************************************/
/*                          MODULE : SSCM                                   */
/****************************************************************************/
    struct SSCM_tag {
        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
                vuint16_t NXEN:1;
                vuint16_t PUB:1;
                vuint16_t SEC:1;
                vuint16_t:1;
                vuint16_t BMODE:3;
                vuint16_t:1;
                vuint16_t ABD:1;
                vuint16_t:3;
            } B;
        } STATUS;               /* Status Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t :10;
                vuint16_t IVLD:1;
                vuint16_t :4;
                vuint16_t DVLD:1;
            } B;
        } MEMCONFIG;            /* System Memory Configuration Register */

		int16_t SSCM_reserved1[1];		/* (0x004) = 0x1 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:14;
                vuint16_t PAE:1;
                vuint16_t RAE:1;
            } B;
        } ERROR;                /* Error Configuration Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:13;
                vuint16_t DEBUG_MODE:3;
            } B;
        } DEBUGPORT;            /* Debug Status Port Register */

		int16_t SSCM_reserved2[1];		/* (0x00A) = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t PWD_HI:32;
            } B;
        } PWCMPH;               /* Password Comparison Register High Word */

        union {
            vuint32_t R;
            struct {
                vuint32_t PWD_LO:32;
            } B;
        } PWCMPL;               /* Password Comparison Register Low Word */

    };                          /* end of SSCM_tag */
/****************************************************************************/
/*                          MODULE : STM                                   */
/****************************************************************************/
    struct STM_tag {

		union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t CPS:8;
                vuint32_t:6;
                vuint32_t FRZ:1;
                vuint32_t TEN:1;
            } B;
        } CR;                  /* STM Control Register */

        union {
            vuint32_t R;
        } CNT;                 /* STM Count Register */

		int32_t STM_reserved1[2];		/* (0x008 - 0x00F+1)/4 = 0x2 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CEN:1;
            } B;
        } CCR0;                 /* STM Channel Control Register 0 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CIF:1;
            } B;
        } CIR0;                 /* STM Channel Interrupt Register 0 */

        union {
            vuint32_t R;
        } CMP0;                 /* STM Channel Compare Register 0 */

        int32_t STM_reserved2[1];		/* (0x01C - 0x01F+1)/4 = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CEN:1;
            } B;
        } CCR1;                 /* STM Channel Control Register 1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CIF:1;
            } B;
        } CIR1;                 /* STM Channel Interrupt Register 1 */

        union {
            vuint32_t R;
        } CMP1;                 /* STM Channel Compare Register 1 */

		int32_t STM_reserved3[1];		/* (0x02C - 0x02F+1)/4 = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CEN:1;
            } B;
        } CCR2;                 /* STM Channel Control Register 2 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CIF:1;
            } B;
        } CIR2;                 /* STM Channel Interrupt Register 2 */

        union {
            vuint32_t R;
        } CMP2;                 /* STM Channel Compare Register 2 */

		int32_t STM_reserved4[1];		/* (0x03C - 0x03F+1)/4 = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CEN:1;
            } B;
        } CCR3;                 /* STM Channel Control Register 3 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t CIF:1;
            } B;
        } CIR3;                 /* STM Channel Interrupt Register 3 */

        union {
            vuint32_t R;
        } CMP3;                 /* STM Channel Compare Register 3 */

    };                          /* end of STM_tag */
/****************************************************************************/
/*                          MODULE : SWT                                   */
/****************************************************************************/
    struct SWT_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t MAP0:1;
                vuint32_t MAP1:1;
                vuint32_t MAP2:1;
                vuint32_t MAP3:1;
                vuint32_t MAP4:1;
                vuint32_t MAP5:1;
                vuint32_t MAP6:1;
                vuint32_t MAP7:1;
                vuint32_t:14;
				vuint32_t KEY:1;
                vuint32_t RIA:1;
                vuint32_t WND:1;
                vuint32_t ITR:1;
                vuint32_t HLK:1;
                vuint32_t SLK:1;
                vuint32_t CSL:1;
                vuint32_t STP:1;
                vuint32_t FRZ:1;
                vuint32_t WEN:1;
            } B;
        } CR;                   /* SWT Control Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t TIF:1;
            } B;
        } IR;                   /* SWT Interrupt Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t WTO:32;
            } B;
        } TO;                   /* SWT Time-Out Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t WST:32;
            } B;
        } WN;                   /* SWT Window Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t WSC:16;
            } B;
        } SR;                   /* SWT Service Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t CNT:32;
            } B;
        } CO;                   /* SWT Counter Output Register */

		union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t SK:16;
            } B;
        } SK;                   /* SWT Service Key Register */

    };                          /* end of SWT_tag */
/****************************************************************************/
/*                          MODULE : WKUP                                   */
/****************************************************************************/
    struct WKUP_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t NIF:1;
                vuint32_t NOVF:1;
                vuint32_t:30;
            } B;
        } NSR;                  /* NMI Status Register */

        int32_t WKUP_reserved1[1];		/* (0x004 - 0x007+1)/4 = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t NLOCK:1;
                vuint32_t NDSS:2;
                vuint32_t:2;
                vuint32_t NREE:1;
                vuint32_t NFEE:1;
                vuint32_t NFE:1;
                vuint32_t:24;
            } B;
        } NCR;                  /* NMI Configuration Register */
    };                          /* end of WKUP_tag */
/****************************************************************************/
/*                          MODULE : LINFLEX                                */
/****************************************************************************/
    struct LINFLEX_tag {

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t CCD:1;
                vuint32_t CFD:1;
                vuint32_t LASE:1;
                vuint32_t AWUM:1;       // LCH vuint32_t AUTOWU:1;
                vuint32_t MBL:4;
                vuint32_t BF:1;
                vuint32_t SFTM:1;
                vuint32_t LBKM:1;
                vuint32_t MME:1;
                vuint32_t SBDT:1;       // LCH vuint32_t SSBL:1;
                vuint32_t RBLM:1;
                vuint32_t SLEEP:1;
                vuint32_t INIT:1;
            } B;
        } LINCR1;               /* LINFLEX LIN Control Register 1 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t SZIE:1;
                vuint32_t OCIE:1;
                vuint32_t BEIE:1;
                vuint32_t CEIE:1;
                vuint32_t HEIE:1;
                vuint32_t:2;
                vuint32_t FEIE:1;
                vuint32_t BOIE:1;
                vuint32_t LSIE:1;
                vuint32_t WUIE:1;
                vuint32_t DBFIE:1;
                vuint32_t DBEIE:1;
                vuint32_t DRIE:1;
                vuint32_t DTIE:1;
                vuint32_t HRIE:1;
            } B;
        } LINIER;               /* LINFLEX LIN Interrupt Enable Register */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t LINS:4;
                vuint32_t:2;
                vuint32_t RMB:1;
                vuint32_t:1;
                vuint32_t RBSY:1;       // LCH vuint32_t RXBUSY:1;
                vuint32_t RPS:1;        // LCH vuint32_t RDI:1;
                vuint32_t WUF:1;
                vuint32_t DBFF:1;
                vuint32_t DBEF:1;
                vuint32_t DRF:1;
                vuint32_t DTF:1;
                vuint32_t HRF:1;
            } B;
        } LINSR;                /* LINFLEX LIN Status Register */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t SZF:1;
                vuint32_t OCF:1;
                vuint32_t BEF:1;
                vuint32_t CEF:1;
                vuint32_t SFEF:1;
                vuint32_t BDEF:1;
                vuint32_t IDPEF:1;
                vuint32_t FEF:1;
                vuint32_t BOF:1;
                vuint32_t:6;
                vuint32_t NF:1;
            } B;
        } LINESR;               /* LINFLEX LIN Error Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:17;
                vuint32_t TDFL:2;
                vuint32_t:1;
                vuint32_t RDFL:2;
                vuint32_t:4;
                vuint32_t RXEN:1;
                vuint32_t TXEN:1;
                vuint32_t OP:1; //LCH vuint32_t PARITYODD:1;
                vuint32_t PCE:1;
                vuint32_t WL:1;
                vuint32_t UART:1;
            } B;
        } UARTCR;               /* LINFLEX UART Mode Control Register */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t SZF:1;
                vuint32_t OCF:1;
                vuint32_t PE3:1;
				vuint32_t PE2:1;
				vuint32_t PE1:1;
				vuint32_t PE0:1;
                vuint32_t RMB:1;
                vuint32_t FEF:1;
                vuint32_t BOF:1;
                vuint32_t RPS:1;        // LCH vuint32_t RDI:1;
                vuint32_t WUF:1;
                vuint32_t:2;
                vuint32_t DRF:1;
                vuint32_t DTF:1;
                vuint32_t NF:1;
            } B;
        } UARTSR;               /* LINFLEX UART Mode Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:21;
                vuint32_t LTOM:1;       //LCH vuint32_t MODE:1;
                vuint32_t IOT:1;
                vuint32_t TOCE:1;
                vuint32_t CNT:8;
            } B;
        } LINTCSR;              /* LINFLEX LIN Time-Out Control Status Register */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t OC2:8;
                vuint32_t OC1:8;
            } B;
        } LINOCR;               /* LINFLEX LIN Output Compare Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:20;
                vuint32_t RTO:4;        // LCH vuint32_t RTC:4;
                vuint32_t:1;
                vuint32_t HTO:7;        // LCH vuint32_t HTC:7;
            } B;
        } LINTOCR;              /* LINFLEX LIN Output Compare Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t DIV_F:4;      // LCH vuint32_t FBR:4;
            } B;
        } LINFBRR;              /* LINFLEX LIN Fractional Baud Rate Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:19;
                vuint32_t DIV_M:13;     // LCH vuint32_t IBR:13;
            } B;
        } LINIBRR;              /* LINFLEX LIN Integer Baud Rate Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:24;
                vuint32_t CF:8;
            } B;
        } LINCFR;               /* LINFLEX LIN Checksum Field Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:17;
                vuint32_t IOBE:1;
                vuint32_t IOPE:1;
                vuint32_t WURQ:1;
                vuint32_t DDRQ:1;
                vuint32_t DTRQ:1;
                vuint32_t ABRQ:1;
                vuint32_t HTRQ:1;
                vuint32_t:8;
            } B;
        } LINCR2;               /* LINFLEX LIN Control Register 2 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t DFL:6;
                vuint32_t DIR:1;
                vuint32_t CCS:1;
                vuint32_t:2;  // LCH vuint32_t:1;
                vuint32_t ID:6;
            } B;
        } BIDR;                 /* LINFLEX Buffer Identifier Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t DATA3:8;
                vuint32_t DATA2:8;
                vuint32_t DATA1:8;
                vuint32_t DATA0:8;
            } B;
        } BDRL;                 /* LINFLEX Buffer Data Register Least Significant */

        union {
            vuint32_t R;
            struct {
                vuint32_t DATA7:8;
                vuint32_t DATA6:8;
                vuint32_t DATA5:8;
                vuint32_t DATA4:8;
            } B;
        } BDRM;                 /* LINFLEX Buffer Data Register Most Significant */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t FACT:16;
            } B;
        } IFER;                 /* LINFLEX Identifier Filter Enable Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:27;
                vuint32_t IFMI:5;
            } B;
        } IFMI;                 /* LINFLEX Identifier Filter Match Index Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:24;
                vuint32_t IFM:8;
            } B;
        } IFMR;                 /* LINFLEX Identifier Filter Mode Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:19;
                vuint32_t DFL:3;
                vuint32_t DIR:1;
                vuint32_t CCS:1;
                vuint32_t:2;
                vuint32_t ID:6;
            } B;
        } IFCR[16];                /* LINFLEX Identifier Filter Control Register 0 */
        
    };                          /* end of LINFLEX_tag */
/****************************************************************************/
/*                          MODULE : ME                                   */
/****************************************************************************/
    struct ME_tag {

        union {
            vuint32_t R;
            struct {
                vuint32_t S_CURRENTMODE:4;
                vuint32_t S_MTRANS:1;
                vuint32_t:3;
                vuint32_t S_PDO:1;
                vuint32_t:2;
                vuint32_t S_MVR:1;
                vuint32_t S_DFLA:2;
                vuint32_t S_CFLA:2;
                vuint32_t:8;
                vuint32_t S_PLL1:1;
                vuint32_t S_PLL0:1;
                vuint32_t S_XOSC0:1;
                vuint32_t S_IRC:1;
                vuint32_t S_SYSCLK:4;
            } B;
        } GS;                   /* Global Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t TARGET_MODE:4;
                vuint32_t:12;
                vuint32_t KEY:16;
            } B;
        } MCTL;                 /* Mode Control Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:21;
                vuint32_t STOP0:1;
                vuint32_t:1;
                vuint32_t HALT0:1;
                vuint32_t RUN3:1;
                vuint32_t RUN2:1;
                vuint32_t RUN1:1;
                vuint32_t RUN0:1;
                vuint32_t DRUN:1;
                vuint32_t SAFE:1;
                vuint32_t TEST:1;
                vuint32_t RESET:1;
            } B;
        } MER;                  /* Mode Enable Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t I_ICONF:1;
                vuint32_t I_IMODE:1;
                vuint32_t I_SAFE:1;
                vuint32_t I_MTC:1;
            } B;
        } IS;                   /* Interrupt Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t M_ICONF:1;
                vuint32_t M_IMODE:1;
                vuint32_t M_SAFE:1;
                vuint32_t M_MTC:1;
            } B;
        } IM;                   /* Interrupt Mask Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:27;
                vuint32_t S_MTI:1;
                vuint32_t S_MRI:1;
                vuint32_t S_DMA:1;
                vuint32_t S_NMA:1;
                vuint32_t S_SEA:1;
            } B;
        } IMTS;                 /* Invalid Mode Transition Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
				vuint32_t MPH_BUSY:1;
				vuint32_t:2;
                vuint32_t PMC_PROG:1;
                vuint32_t CORE_DBG:1;
				vuint32_t:2;
                vuint32_t SMR:1;
				vuint32_t:1;
                vuint32_t PLL0_SC:1;
                vuint32_t XOSC0_SC:1;
				vuint32_t:1;
				vuint32_t SSCLK_SC:1;
				vuint32_t SYSCLK_SW:1;
				vuint32_t DFLASH_SC:1;
				vuint32_t CFLASH_SC:1;
				vuint32_t CDP_PRPH_0_143:1;
				vuint32_t:4;
				vuint32_t CDP_PRPH_64_95:1;
				vuint32_t CDP_PRPH_32_63:1;
				vuint32_t CDP_PRPH_0_31:1;
            } B;
        } DMTS;                 /* Debug Mode Transition Status Register */

		int32_t ME_reserved1[1];		/* (0x01C - 0x01F+1)/4 = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } RESET_MC;                /* Reset Mode Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } TEST_MC;                 /* Test Mode Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } SAFE_MC;                 /* Safe Mode Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } DRUN_MC;                 /* DRUN Mode Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } RUN0_MC;               /* RUN 0->4 Mode Configuration Register */

	    union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } RUN1_MC;               /* RUN 0->4 Mode Configuration Register */

	union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } RUN2_MC;               /* RUN 0->4 Mode Configuration Register */

	union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } RUN3_MC;               /* RUN 0->4 Mode Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } HALT0_MC;                /* HALT0 Mode Configuration Register */

		int32_t ME_reserved2[1];		/* (0x044 - 0x047+1)/4 = 0x1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t PDO:1;
                vuint32_t:2;
                vuint32_t MVRON:1;
                vuint32_t DFLAON:2;
                vuint32_t CFLAON:2;
                vuint32_t:8;
                vuint32_t PLL1ON:1;
                vuint32_t PLL0ON:1;
                vuint32_t XOSC0ON:1;
                vuint32_t IRCON:1;
                vuint32_t SYSCLK:4;
            } B;
        } STOP0_MC;                /* STOP0 Mode Configuration Register */

		int32_t ME_reserved3[5];		/* (0x04C - 0x05F+1)/4 = 0x5 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:5;
				vuint32_t S_SafetyPort:1;
				vuint32_t:1;
				vuint32_t S_FlexRay:1;
				vuint32_t:7;
				vuint32_t S_FlexCAN0:1;
				vuint32_t:8;
				vuint32_t S_DSPI3:1;
				vuint32_t S_DSPI2:1;
				vuint32_t S_DSPI1:1;
				vuint32_t S_DSPI0:1;
                vuint32_t:4;
            } B;
        } PS0;                /* Peripheral Status 0->4 Register */

		union {
            vuint32_t R;
            struct {
				vuint32_t:14;
				vuint32_t S_LIN_FLEX1:1;
				vuint32_t S_LIN_FLEX0:1;
				vuint32_t:6;
				vuint32_t S_FlexPWM0:1;
				vuint32_t:1;
				vuint32_t S_eTimer1:1;
				vuint32_t S_eTimer0:1;
				vuint32_t:2;
				vuint32_t S_CTU:1;
				vuint32_t:1;
				vuint32_t S_ADC1:1;
				vuint32_t S_ADC0:1;
            } B;
        } PS1;                /* Peripheral Status 0->4 Register */

		union {
            vuint32_t R;
            struct {
				vuint32_t :3;
				vuint32_t S_PIT_RTI:1;
				vuint32_t:5;
				vuint32_t S_SSCM:1;
				vuint32_t:22;
            } B;
        } PS2;                /* Peripheral Status 0->4 Register */

		int32_t ME_reserved4[5];		/* (0x06C - 0x07F+1)/4 = 0x5 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:24;
                vuint32_t RUN3:1;
                vuint32_t RUN2:1;
                vuint32_t RUN1:1;
                vuint32_t RUN0:1;
                vuint32_t DRUN:1;
                vuint32_t SAFE:1;
                vuint32_t TEST:1;
                vuint32_t RESET:1;
            } B;
        } RUN_PC[8];             /* RUN Peripheral Configuration 0->7 Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:21;
                vuint32_t STOP0:1;
                vuint32_t:1;
                vuint32_t HALT0:1;
                vuint32_t:8;
            } B;
        } LP_PC[8];              /* Low Power Peripheral Configuration 0->7 Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t DBG_F:1;
                vuint8_t LP_CFG:3;
                vuint8_t RUN_CFG:3;
            } B;
        } PCTL[92];            /* Peripheral Control 0->143 Register */

    };                          /* end of ME_tag */
/****************************************************************************/
/*                          MODULE : CGM                                   */
/****************************************************************************/
    struct CGM_tag {

        /* The CGM provides a unified register interface, enabling access to 
           all clock sources:
           
           Starting		| Associated 
		   Address Map	| Clock Sources
           ------------------------------------------------------------
           C3FE0000		| OSC_CTL
           C3FE0060		| IRC_CTL
           C3FE00A0		| FMPLL_0
           C3FE00C0		| FMPLL_1
           C3FE0100		| CMU_0 
		   C3FE0120		| CMU_1
		   C3FE0370		| CGM		
         */
	/*********************************************************/
    /* OSC_CTL General Registers @ CGM base address + 0x0000 */
    /*********************************************************/
        union {
            vuint32_t R;
            struct {
                vuint32_t OSCBYP:1;
                vuint32_t:7;
                vuint32_t EOCV:8;
                vuint32_t M_OSC:1;
                vuint32_t:7;
                vuint32_t I_OSC:1;
                vuint32_t:7;
            } B;
        } XOSC_CTL;              /* Main OSC Control Register */

		int32_t CGM_reserved1[23];		/* (0x004- 0x05F+1)/4 = 0x23 */

   	/*********************************************************/
    /* IRC_CTL General Registers @ CGM base address + 0x0060 */
    /*********************************************************/
        union {
            vuint32_t R;
            struct {
                vuint32_t:10;
                vuint32_t RCTRIM:6;
                vuint32_t:16;
            } B;
        } IRC_CTL;               /* RC OSC Control Register */

		int32_t CGM_reserved2[15];		/* (0x064- 0x09F+1)/4 = 0x7 */

 	/*********************************************************/
	/* FMPLL_0 General Registers @ CGM base address + 0x00A0 */
    /*********************************************************/
   
	/*********************************************************/
    /* FMPLL_1 General Registers @ CGM base address + 0x00C0 */
    /*********************************************************/     
		struct{
			union {
                vuint32_t R;
                struct {
                    vuint32_t:2;
                    vuint32_t IDF:4;
                    vuint32_t ODF:2;
                    vuint32_t:1;
                    vuint32_t NDIV:7;
                    vuint32_t:7;
                    vuint32_t EN_PLL_SW:1;
                    vuint32_t:1;
                    vuint32_t UNLOCK_ONCE:1;
                    vuint32_t:1;
                    vuint32_t I_LOCK:1;
                    vuint32_t S_LOCK:1;
                    vuint32_t PLL_FAIL_MASK:1;
                    vuint32_t PLL_FAIL_FLAG:1;
                    vuint32_t:1;
                } B;
            } CR;               /* FMPLL Control Register */

			union {
                vuint32_t R;
                struct {
                    vuint32_t STRB_BYPASS:1;
                      vuint32_t:1;
                    vuint32_t SPRD_SEL:1;
                    vuint32_t MOD_PERIOD:13;
                    vuint32_t FM_EN:1;
                    vuint32_t INC_STEP:15;
                } B;
            } MR;               /* FMPLL Modulation Register */

		int32_t CGM_reserved3[6];		/* (0x0A8 - 0x0BF+1)/4 = 0x6 */

		}FMPLL[2];
       
		int32_t CGM_reserved4[8];		/* (0x0C8 - 0x0FF+1)/4 = 0x14 */

	/*******************************************************/
    /* CMU_0 General Registers @ CGM base address + 0x0100 */
    /*******************************************************/
        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t SFM:1;
                vuint32_t:20;
                vuint32_t RCDIV:2;
                vuint32_t CME_0:1;
            } B;
        } CMU_0_CSR;            /* Control Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:12;
                vuint32_t FD:20;
            } B;
        } CMU_0_FDR;            /* Frequency Display Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:20;
                vuint32_t HFREF_A:12;
            } B;
        } CMU_0_HFREFR_A;       /* High Frequency Reference Register PLL_A Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:20;
                vuint32_t LFREF_A:12;
            } B;
        } CMU_0_LFREFR_A;       /* Low Frequency Reference Register PLL_A Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t FLCI_0:1;
                vuint32_t FHHI_0:1;
                vuint32_t FLLI_0:1;
                vuint32_t OLRI:1;
            } B;
        } CMU_0_ISR;            /* Interrupt Status Register */

		int32_t CGM_reserved5[1];		/* (0x114) = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:12;
                vuint32_t MD:20;
            } B;
        } CMU_0_MDR;            /* Measurement Duration Register */

		int32_t CGM_reserved6[1];			/* (0x11C) = 0x01 */

	/*******************************************************/
    /* CMU_1 General Registers @ CGM base address + 0x0120 */
    /*******************************************************/
        union {
            vuint32_t R;
            struct {
                vuint32_t:8;
                vuint32_t SFM:1;
                  vuint32_t:13;
                vuint32_t CLKSEL1:2;
                  vuint32_t:5;
                vuint32_t RCDIV:2;
                vuint32_t CME_A:1;
            } B;
        } CMU_1_CSR;            /* Control Status Register */

        int32_t CGM_reserved7[1];		/* (0x124) = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:20;
                vuint32_t HFREF_A:12;
            } B;
        } CMU_1_HFREFR_A;       /* High Frequency Reference Register PLL_A Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:20;
                vuint32_t LFREF_A:12;
            } B;
        } CMU_1_LFREFR_A;       /* Low Frequency Reference Register PLL_A Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t FLCI_1:1;
                vuint32_t FHHI_1:1;
                vuint32_t FLLI_1:1;
                  vuint32_t:1;
            } B;
        } CMU_1_ISR;            /* Interrupt Status Register */

		int32_t CGM_reserved8[143];		/* (0x134 - 0x36F+1)/4 = 0x8F */

    /*******************************************************/
    /* CGM General Registers @ CGM base address + 0x0370	*/
    /*******************************************************/
        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t EN:1;
            } B;
        } OC_EN;                 /* Output Clock Enable Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:2;
                vuint32_t SELDIV:2;
                vuint32_t SELCTL:4;
                vuint32_t:24;
            } B;
        } OCDS_SC;               /* Output Clock Division Select Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t SELSTAT:4;
                vuint32_t:24;
            } B;
        } SC_SS;                 /* System Clock Select Status */

		int32_t CGM_reserved9[1];		/* (0x37C) = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t SELCTL:4;
                vuint32_t:24;
            } B;
        } AC0_SC;                /* Aux Clock 0 Select Control */

        union {
            vuint32_t R;
            struct {
                vuint32_t DE0:1;
                vuint32_t:3;
                vuint32_t DIV0:4;
                vuint32_t:24;
            } B;
        } AC0_DC0;                /* Aux Clock 0 Divider Configuration*/

        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t SELCTL:4;
                vuint32_t:24;
            } B;
        } AC1_SC;                /* Aux Clock 1 Select Control */

        union {
            vuint32_t R;
            struct {
                vuint32_t DE0:1;
                vuint32_t:3;
                vuint32_t DIV0:4;
                vuint32_t:24;
            } B;
        } AC1_DC0;                /* Aux Clock 1 Divider Configuration*/

        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t SELCTL:4;
                vuint32_t:24;
            } B;
        } AC2_SC;                /* Aux Clock 2 Select Control */

        union {
            vuint32_t R;
            struct {
                vuint32_t DE0:1;
                vuint32_t:3;
                vuint32_t DIV0:4;
                vuint32_t:24;
            } B;
        } AC2_DC0;                /* Aux Clock 2 Divider Configuratio*/

        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t SELCTL:4;
                vuint32_t:24;
            } B;
        } AC3_SC;                /* Aux Clock 3 Select Control */

        union {
            vuint32_t R;
            struct {
                vuint32_t DE0:1;
                vuint32_t:3;
                vuint32_t DIV0:4;
                vuint32_t:24;
            } B;
        } AC3_DC0;                /* Aux Clock 3 Divider Configuration*/
       
    };                          /* end of CGM_tag */
/****************************************************************************/
/*                          MODULE : RGM                                   */
/****************************************************************************/
    struct RGM_tag {

        union {
            vuint16_t R;
            struct {
                vuint16_t F_EXR:1;
                vuint16_t:3;
                vuint16_t F_CMU1_FHL:1;
                vuint16_t:1;
                vuint16_t F_PLL1:1;
                vuint16_t F_FLASH:1;
                vuint16_t F_LVD45:1;
                vuint16_t F_CMU0_FHL:1;
                vuint16_t F_CMU0_OLR:1;
                vuint16_t F_PLL0:1;
                vuint16_t F_CHKSTOP:1;
                vuint16_t F_SOFT:1;
                vuint16_t F_CORE:1;
                vuint16_t F_JTAG:1;
            } B;
        } FES;                  /* Functional Event Status */

        union {
            vuint16_t R;
            struct {
                vuint16_t POR:1;
                vuint16_t:8;
                vuint16_t F_LVD27_IO:1;
                vuint16_t F_LVD27_FLASH:1;
                vuint16_t F_LVD27_VREG:1;
                vuint16_t:1;
                vuint16_t F_SWT:1;
				vuint16_t:1;
                vuint16_t F_LVD12_PD0:1;
            } B;
        } DES;                  /* Destructive Event Status */

        union {
            vuint16_t R;
            struct {
                vuint16_t D_EXR:1;
                vuint16_t:3;
                vuint16_t D_CMU1_FHL:1;
                vuint16_t:1;
                vuint16_t D_PLL1:1;
                vuint16_t D_FLASH:1;
                vuint16_t D_LVD45:1;
                vuint16_t D_CMU0_FHL:1;
                vuint16_t D_CMU0_OLR:1;
                vuint16_t D_PLL0:1;
                vuint16_t D_CHKSTOP:1;
                vuint16_t D_SOFT:1;
                vuint16_t D_CORE:1;
                vuint16_t D_JTAG:1;
            } B;
        } FERD;                 /* Functional Event Reset Disable */

        union {
            vuint16_t R;
            struct {
                vuint16_t:9;
                vuint16_t D_LVD27_IO:1;
                vuint16_t D_LVD27_FLASH:1;
                vuint16_t D_LVD27_VREG:1;
                vuint16_t:1;
                vuint16_t D_SWT:1;
                vuint16_t:1;
                vuint16_t D_LVD12_PD0:1;
            } B;
        } DERD;                 /* Destructive Event Reset Disable */

		int16_t RGM_reserved1[4];		/* (0x008- 0x00F+1)/2 = 0x04 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
                vuint16_t AR_CMU1_FHL:1;
                vuint16_t:1;
                vuint16_t AR_PLL1:1;
                vuint16_t AR_FLASH:1;
                vuint16_t AR_LVD45:1;
                vuint16_t AR_CMU0_FHL:1;
                vuint16_t AR_CMU0_OLR:1;
                vuint16_t AR_PLL0:1;
                vuint16_t AR_CHKSTOP:1;
                vuint16_t AR_SOFT:1;
                vuint16_t AR_CORE:1;
                vuint16_t AR_JTAG:1;
            } B;
        } FEAR;                 /* Functional Event Alternate Request */

		int16_t RGM_reserved2[3];		/* (0x012- 0x017+1)/2 = 0x03 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
				vuint16_t SS_CMU1_FHL:1;
				vuint16_t:1;
				vuint16_t SS_PLL1:1;
                vuint16_t SS_FLASH:1;
                vuint16_t SS_LVD45:1;
                vuint16_t SS_CMU0_FHL:1;
                vuint16_t SS_CMU0_OLR:1;
                vuint16_t SS_PLL0:1;
                vuint16_t SS_CHKSTOP:1;
                vuint16_t SS_SOFT:1;
                vuint16_t SS_CORE:1;
                vuint16_t SS_JTAG:1;
            } B;
        } FESS;                 /* Functional Event Short Sequence */

		int16_t RGM_reserved3[1];		/* (0x01A- 0x01B+1)/2 = 0x01 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
				vuint16_t BE_CMU1_FHL:1;
				vuint16_t:1;
				vuint16_t BE_PLL1:1;
                vuint16_t BE_FLASH:1;
                vuint16_t BE_LVD45:1;
                vuint16_t BE_CMU0_FHL:1;
                vuint16_t BE_CMU0_OLR:1;
                vuint16_t BE_PLL0:1;
                vuint16_t BE_CHKSTOP:1;
                vuint16_t BE_SOFT:1;
                vuint16_t BE_CORE:1;
                vuint16_t BE_JTAG:1;
            } B;
        } FBRE;                 /* Functional Bidirectional Reset Enable */

    };                          /* end of RGM_tag */
/****************************************************************************/
/*                          MODULE : PCU                                   */
/****************************************************************************/
    struct PCU_tag {

        union {
            vuint32_t R;
            struct {
                vuint32_t:21;
				vuint32_t STOP0:1;
                vuint32_t:1;
                vuint32_t HALT0:1;
                vuint32_t RUN3:1;
                vuint32_t RUN2:1;
                vuint32_t RUN1:1;
                vuint32_t RUN0:1;
                vuint32_t DRUN:1;
                vuint32_t SAFE:1;
                vuint32_t TEST:1;
                vuint32_t RST:1;
            } B;
        } PCONF0;            /* Power domain 0 configuration register */

		int32_t PCU_reserved1[15];		/* (0x004- 0x03F+1)/4 = 0x0F */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t PD0:1;
            } B;
        } PSTAT;                /* Power Domain Status Register */

        int32_t PCU_reserved2[15];		/* (0x044- 0x07F+1)/4 = 0x0F */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t MASK_5VLVD:1;
            } B;
        } VREG_CTL;                 /* Voltage Regulator Control Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t STATUS_5VLVD:1;
            } B;
        } VREG_STATUS;                 /* Voltage Regulator Control Register */

    };                          /* end of PCU_tag */
/****************************************************************************/
/*                          MODULE : FLEXPWM                                   */
/****************************************************************************/
    struct FLEXPWM_SUB_tag {

        union {
            vuint16_t R;
        } CNT;                  /* Counter Register */

        union {
            vuint16_t R;
        } INIT;                 /* Initial Count Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t DBGEN:1;
                vuint16_t WAITEN:1;
                vuint16_t INDEP:1;
                vuint16_t PWMA_INIT:1;
                vuint16_t PWMB_INIT:1;
                vuint16_t PWMX_INIT:1;
                vuint16_t INIT_SEL:2;
                vuint16_t FRCEN:1;
                vuint16_t FORCE:1;
                vuint16_t FORCE_SEL:3;
                vuint16_t RELOAD_SEL:1;
                vuint16_t CLK_SEL:2;
            } B;
        } CTRL2;                /* Control 2 Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t LDFQ:4;
                vuint16_t HALF:1;
                vuint16_t FULL:1;
                vuint16_t DT:2;
                vuint16_t:1;
                vuint16_t PRSC:3;
                vuint16_t:3;
                vuint16_t DBLEN:1;
            } B;
        } CTRL1;                 /* Control Register */

        union {
            vuint16_t R;
        } VAL[6];               /* Value Register 0->5 */

		int16_t PWM_SUB_reserved1[2];		/* (0x014- 0x017+1)/2 = 0x02 */

        union {
            vuint16_t R;
            struct {
                vuint16_t PWMA_IN:1;
                vuint16_t PWMB_IN:1;
                vuint16_t PWMX_IN:1;
                vuint16_t:2;
                vuint16_t POLA:1;
                vuint16_t POLB:1;
                vuint16_t POLX:1;
                vuint16_t:2;
                vuint16_t PWMAFS:2;
                vuint16_t PWMBFS:2;
                vuint16_t PWMXFS:2;
            } B;
        } OCTRL;                /* Output Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:1;
                vuint16_t RUF:1;
                vuint16_t REF:1;
                vuint16_t RF:1;
                vuint16_t:4;
                vuint16_t CFX1:1;
                vuint16_t CFX0:1;
                vuint16_t CMPF:6;
            } B;
        } STS;                  /* Status Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:2;
                vuint16_t REIE:1;
                vuint16_t RIE:1;
                vuint16_t:4;
                vuint16_t CX1IE:1;
                vuint16_t CX0IE:1;
                vuint16_t CMPIE:6;
            } B;
        } INTEN;                /* Interrupt Enable Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:6;
                vuint16_t VALDE:1;
                vuint16_t FAND:1;
                vuint16_t CAPTDE:2;
                vuint16_t:4;
                vuint16_t CX1DE:1;
                vuint16_t CX0DE:1;
            } B;
        } DMAEN;                /* DMA Enable Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:10;
                vuint16_t OUT_TRIG_EN:6;
            } B;
        } TCTRL;                /* Output Trigger Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
                vuint16_t DISX:4;
                vuint16_t DISB:4;
                vuint16_t DISA:4;
            } B;
        } DISMAP;               /* Fault Disable Mapping Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:5;
                vuint16_t DTCNT0:11;
            } B;
        } DTCNT0;               /* Deadtime Count Register 0 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:5;
                vuint16_t DTCNT1:11;
            } B;
        } DTCNT1;               /* Deadtime Count Register 1 */

		int16_t PWM_SUB_reserved2[4];		/* (0x028- 0x02F+1)/2 = 0x04 */

        union {
            vuint16_t R;
            struct {
                vuint16_t CX1CNT:3;
                vuint16_t CX0CNT:3;
                vuint16_t CFXWM:2;
                vuint16_t EDGCNTX_EN:1;
                vuint16_t INP_SELX:1;
                vuint16_t EDGX1:2;
                vuint16_t EDGX0:2;
                vuint16_t ONESHOTX:1;
                vuint16_t ARMX:1;
            } B;
        } CAPTCTRLX;            /* Capture Control Register B */

        union {
            vuint16_t R;
            struct {
                vuint16_t EDGCNTX:8;
                vuint16_t EDGCMPX:8;
            } B;
        } CAPTCMPX;            /* Capture Compare Register X */

        union {
            vuint16_t R;
            struct {
                vuint16_t CAPTVAL0:16;
            } B;
        } CVAL0;                /* Capture Value 0 Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:13;
                vuint16_t CVAL0CYC:3;
            } B;
        } CVAL0C;               /* Capture Value 0 Cycle Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t CAPTVAL1:16;
            } B;
        } CVAL1;                /* Capture Value 1 Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:13;
                vuint16_t CVAL1CYC:3;
            } B;
        } CVAL1C;               /* Capture Value 1 Cycle Register */

		int16_t PWM_SUB_reserved3[10];		/* (0x03C- 0x04F+1)/2 = 0x0A */

    };                          /* end of FLEXPWM_SUB_tag */

    struct FLEXPWM_tag {

        /* eg. FLEXPWM.SUB<[x]>.CNT.R  {x = 0->3} */
        struct FLEXPWM_SUB_tag SUB[4];

        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
                vuint16_t PWMA_EN:4;
                vuint16_t PWMB_EN:4;
                vuint16_t PWMX_EN:4;
            } B;
        } OUTEN;                /* Output Enable Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:4;
                vuint16_t MASKA:4;
                vuint16_t MASKB:4;
                vuint16_t MASKX:4;
            } B;
        } MASK;                 /* Output Mask Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:8;
                vuint16_t OUTA_3:1;
                vuint16_t OUTB_3:1;
                vuint16_t OUTA_2:1;
                vuint16_t OUTB_2:1;
                vuint16_t OUTA_1:1;
                vuint16_t OUTB_1:1;
                vuint16_t OUTA_0:1;
                vuint16_t OUTB_0:1;
            } B;
        } SWCOUT;               /* Software Controlled Output Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t SELA_3:2;
                vuint16_t SELB_3:2;
                vuint16_t SELA_2:2;
                vuint16_t SELB_2:2;
                vuint16_t SELA_1:2;
                vuint16_t SELB_1:2;
                vuint16_t SELA_0:2;
                vuint16_t SELB_0:2;
            } B;
        } DTSRCSEL;             /* Deadtime Source Select Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t IPOL:4;
                vuint16_t RUN:4;
                vuint16_t CLDOK:4;
                vuint16_t LDOK:4;
            } B;
        } MCTRL;                /* Master Control Register */

		int16_t PWM_reserved1[1];		/* (0x014A) = 0x01 */

        union {
            vuint16_t R;
            struct {
                vuint16_t FLVL:4;
                vuint16_t FAUTO:4;
                vuint16_t FSAFE:4;
                vuint16_t FIE:4;
            } B;
        } FCTRL;                /* Fault Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:3;
                vuint16_t FTEST:1;
                vuint16_t FFPIN:4;
                vuint16_t:4;
                vuint16_t FFLAG:4;
            } B;
        } FSTS;                 /* Fault Status Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:5;
                vuint16_t FILT_CNT:3;
                vuint16_t FILT_PER:8;
            } B;
        } FFILT;                /* Fault FilterRegister */

    };                          /* end of FLEXPWM_tag */
/****************************************************************************/
/*                          MODULE : ETIMER                                   */
/****************************************************************************/
    struct ETIMER_CHANNEL_tag {

        union {
            vuint16_t R;
            struct {
                vuint16_t COMP1:16;
            } B;
        } COMP1;                /* Compare Register 1 */

        union {
            vuint16_t R;
            struct {
                vuint16_t COMP2:16;
            } B;
        } COMP2;                /* Compare Register 2 */

        union {
            vuint16_t R;
            struct {
                vuint16_t CAPT1:16;
            } B;
        } CAPT1;                /* Capture Register 1 */

        union {
            vuint16_t R;
            struct {
                vuint16_t CAPT2:16;
            } B;
        } CAPT2;                /* Capture Register 2 */

        union {
            vuint16_t R;
            struct {
                vuint16_t LOAD:16;
            } B;
        } LOAD;                 /* Load Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t HOLD:16;
            } B;
        } HOLD;                 /* Hold Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t CNTR:16;
            } B;
        } CNTR;                 /* Counter Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t CNTMODE:3;
                vuint16_t PRISRC:5;
                vuint16_t ONCE:1;
                vuint16_t LENGTH:1;
                vuint16_t DIR:1;
                vuint16_t SECSRC:5;
            } B;
        } CTRL1;                 /* Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t OEN:1;
                vuint16_t RDNT:1;
                vuint16_t INPUT:1;
                vuint16_t VAL:1;
                vuint16_t FORCE:1;
                vuint16_t COFRC:1;
                vuint16_t COINIT:2;
                vuint16_t SIPS:1;
                vuint16_t PIPS:1;
                vuint16_t OPS:1;
                vuint16_t MSTR:1;
                vuint16_t OUTMODE:4;
            } B;
        } CTRL2;                /* Control Register 2 */

        union {
            vuint16_t R;
            struct {
                vuint16_t STPEN:1;
                vuint16_t ROC:2;
                vuint16_t:5;
                vuint16_t C2FCNT:3;
                vuint16_t C1FCNT:3;
                vuint16_t DBGEN:2;
            } B;
        } CTRL3;                /* Control Register 3 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:6;
                vuint16_t WDF:1;
                vuint16_t RCF:1;
                vuint16_t ICF2:1;
                vuint16_t ICF1:1;
                vuint16_t IEHF:1;
                vuint16_t IELF:1;
                vuint16_t TOF:1;
                vuint16_t TCF2:1;
                vuint16_t TCF1:1;
                vuint16_t TCF:1;
            } B;
        } STS;                  /* Status Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t ICF2DE:1;
                vuint16_t ICF1DE:1;
                vuint16_t CMPLD2DE:1;
                vuint16_t CMPLD1DE:1;
                vuint16_t:2;
                vuint16_t WDFIE:1;
                vuint16_t RCFIE:1;
                vuint16_t ICF2IE:1;
                vuint16_t ICF1IE:1;
                vuint16_t IEHFIE:1;
                vuint16_t IELFIE:1;
                vuint16_t TOFIE:1;
                vuint16_t TCF2IE:1;
                vuint16_t TCF1IE:1;
                vuint16_t TCFIE:1;
            } B;
        } INTDMA;               /* Interrupt and DMA Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t CMPLD1:16;
            } B;
        } CMPLD1;               /* Compare Load Register 1 */

        union {
            vuint16_t R;
            struct {
                vuint16_t CMPLD2:16;
            } B;
        } CMPLD2;               /* Compare Load Register 2 */

        union {
            vuint16_t R;
            struct {
                vuint16_t CLC2:3;
                vuint16_t CLC1:3;
                vuint16_t CMPMODE:2;
                vuint16_t CPT2MODE:2;
                vuint16_t CPT1MODE:2;
                vuint16_t CFWM:2;
                vuint16_t ONESHOT:1;
                vuint16_t ARM:1;
            } B;
        } CCCTRL;               /* Compare and Capture Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:5;
                vuint16_t FILT_CNT:3;
                vuint16_t FILT_PER:8;
            } B;
        } FILT;                 /* Input Filter Register */

    };                          /* end of ETIMER_CHANNEL_tag */

    struct ETIMER_tag {

        struct ETIMER_CHANNEL_tag CHANNEL[6];

		int16_t ETIMER_reserved1[32];		/* (0x0C0- 0x0FF+1)/2 = 0x20 */

        union {
            vuint16_t R;
            struct {
                vuint16_t WDTOL:16;
            } B;
        } WDTOL;                /* Watchdog Time-out Low Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t WDTOH:16;
            } B;
        } WDTOH;                /* Watchdog Time-out High Register */

		int16_t ETIMER_reserved2[4];		/* (0x104- 0x10B+1)/2 = 0x04 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:10;
                vuint16_t ENBL:6;
            } B;
        } ENBL;                 /* Channel Enable Register */

        int16_t ETIMER_reserved3[1];			/* (0x10E- 0x10F+1)/2 = 0x01 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:11;
                vuint16_t DREQ:5;
            } B;
        } DREQ[2];              /* DMA Request 0->3 Select Register */

    };                          /* end of ETIMER_tag */

/****************************************************************************/
/*                          MODULE : CTU                                   */
/****************************************************************************/
    struct CTU_tag {

        union {
            vuint32_t R;
            struct {
                vuint32_t I15_FE:1;
                vuint32_t I15_RE:1;
                vuint32_t I14_FE:1;
                vuint32_t I14_RE:1;
                vuint32_t I13_FE:1;
                vuint32_t I13_RE:1;
                vuint32_t I12_FE:1;
                vuint32_t I12_RE:1;
                vuint32_t I11_FE:1;
                vuint32_t I11_RE:1;
                vuint32_t I10_FE:1;
                vuint32_t I10_RE:1;
                vuint32_t I9_FE:1;
                vuint32_t I9_RE:1;
                vuint32_t I8_FE:1;
                vuint32_t I8_RE:1;
                vuint32_t I7_FE:1;
                vuint32_t I7_RE:1;
                vuint32_t I6_FE:1;
                vuint32_t I6_RE:1;
                vuint32_t I5_FE:1;
                vuint32_t I5_RE:1;
                vuint32_t I4_FE:1;
                vuint32_t I4_RE:1;
                vuint32_t I3_FE:1;
                vuint32_t I3_RE:1;
                vuint32_t I2_FE:1;
                vuint32_t I2_RE:1;
                vuint32_t I1_FE:1;
                vuint32_t I1_RE:1;
                vuint32_t I0_FE:1;
                vuint32_t I0_RE:1;
            } B;
        } TGSISR;               /* -Trigger Generator Subunit Input Selection Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:7;
                vuint16_t ETTM:1;
                vuint16_t PRES:2;
                vuint16_t MRS_SM:5;
                vuint16_t TGS_M:1;
            } B;
        } TGSCR;                /* Trigger Generator Subunit Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t TCRV:16;
            } B;
        } TCR[8];               /* Trigger 0->7 Compare Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t TGSCCV:16;
            } B;
        } TGSCCR;               /* TGS Counter Compare Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t TGSCRV:16;
            } B;
        } TGSCRR;               /* TGS Counter Reload Register */

		int16_t CTU_reserved1[1];		/* (0x01A) = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:3;
                vuint32_t T3INDEX:5;
                vuint32_t:3;
                vuint32_t T2INDEX:5;
                vuint32_t:3;
                vuint32_t T1INDEX:5;
                vuint32_t:3;
                vuint32_t T0INDEX:5;
            } B;
        } CLCR1;                /* Command List Control Register 1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:3;
                vuint32_t T7INDEX:5;
                vuint32_t:3;
                vuint32_t T6INDEX:5;
                vuint32_t:3;
                vuint32_t T5INDEX:5;
                vuint32_t:3;
                vuint32_t T4INDEX:5;
            } B;
        } CLCR2;                /* Command List Control Register 2 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:3;
                vuint32_t T3_E:1;
                vuint32_t T3_ETE:1;
                vuint32_t T3_T1E:1;
                vuint32_t T3_T0E:1;
                vuint32_t T3_ADCE:1;
                vuint32_t:3;
                vuint32_t T2_E:1;
                vuint32_t T2_ETE:1;
                vuint32_t T2_T1E:1;
                vuint32_t T2_T0E:1;
                vuint32_t T2_ADCE:1;
                vuint32_t:3;
                vuint32_t T1_E:1;
                vuint32_t T1_ETE:1;
                vuint32_t T1_T1E:1;
                vuint32_t T1_T0E:1;
                vuint32_t T1_ADCE:1;
                vuint32_t:3;
                vuint32_t T0_E:1;
                vuint32_t T0_ETE:1;
                vuint32_t T0_T1E:1;
                vuint32_t T0_T0E:1;
                vuint32_t T0_ADCE:1;
            } B;
        } THCR1;                /* Trigger Handler Control Register 1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:3;
                vuint32_t T7_E:1;
                vuint32_t T7_ETE:1;
                vuint32_t T7_T1E:1;
                vuint32_t T7_T0E:1;
                vuint32_t T7_ADCE:1;
                vuint32_t:3;
                vuint32_t T6_E:1;
                vuint32_t T6_ETE:1;
                vuint32_t T6_T1E:1;
                vuint32_t T6_T0E:1;
                vuint32_t T6_ADCE:1;
                vuint32_t:3;
                vuint32_t T5_E:1;
                vuint32_t T5_ETE:1;
                vuint32_t T5_T1E:1;
                vuint32_t T5_T0E:1;
                vuint32_t T5_ADCE:1;
                vuint32_t:3;
                vuint32_t T4_E:1;
                vuint32_t T4_ETE:1;
                vuint32_t T4_T1E:1;
                vuint32_t T4_T0E:1;
                vuint32_t T4_ADCE:1;
            } B;
        } THCR2;                /* Trigger Handler Control Register 2 */

        union {
            vuint16_t R;
            struct {
                vuint16_t CIR:1;
                vuint16_t FC:1;
                vuint16_t CMS:1;
				vuint16_t:1;
                vuint16_t FIFO:2;
                vuint16_t:4;
                vuint16_t SU:1;
                vuint16_t:1;
                vuint16_t CH:4;
            } B_SINGLE; /* Single Conversion Mode*/
			struct {                          
				vuint16_t CIR:1;                
				vuint16_t FC:1;                 
				vuint16_t CMS:1;        
				vuint16_t:1;
				vuint16_t FIFO:2;
				vuint16_t:1;
				vuint16_t CH_B:4;
				vuint16_t:1;
				vuint16_t CH_A:4;                
           } B_DUAL;    /* Dual Conversion Mode */
        } CLR[24];              /* Commands List Register x (double-buffered) (x = 1,...,24) */

		int16_t CTU_reserved2[8];		/* (0x05C - 0x06B+1/2) = 0x08 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:12;
                vuint16_t DE3:1;
                vuint16_t DE2:1;
                vuint16_t DE1:1;
                vuint16_t DE0:1;
            } B;
        } FDCR;                   /* Control Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t OR_EN3:1;
                vuint32_t OF_EN3:1;
                vuint32_t EMPTY_EN3:1;
                vuint32_t FULL_EN3:1;
                vuint32_t OR_EN2:1;
                vuint32_t OF_EN2:1;
                vuint32_t EMPTY_EN2:1;
                vuint32_t FULL_EN2:1;
                vuint32_t OR_EN1:1;
                vuint32_t OF_EN1:1;
                vuint32_t EMPTY_EN1:1;
                vuint32_t FULL_EN1:1;
                vuint32_t OR_EN0:1;
                vuint32_t OF_EN0:1;
                vuint32_t EMPTY_EN0:1;
                vuint32_t FULL_EN0:1;
            } B;
        } FCR;                  /* CONTROL REGISTER FIFO */

        union {
            vuint32_t R;
            struct {
                vuint32_t TH3:8;
                vuint32_t TH2:8;
                vuint32_t TH1:8;
                vuint32_t TH0:8;
            } B;
        } FTH;                  /* Threshold Register */

		int16_t CTU_reserved3[2];		/* (0x078 - 0x07B+1/2) = 0x02 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t OR3:1;
                vuint32_t OF3:1;
                vuint32_t EMP3:1;
                vuint32_t FULL3:1;
                vuint32_t OR2:1;
                vuint32_t OF2:1;
                vuint32_t EMP2:1;
                vuint32_t FULL2:1;
                vuint32_t OR1:1;
                vuint32_t OF1:1;
                vuint32_t EMP1:1;
                vuint32_t FULL1:1;
                vuint32_t OR0:1;
                vuint32_t OF0:1;
                vuint32_t EMP0:1;
                vuint32_t FULL0:1;
            } B;
        } FST;               /* STATUS REGISTER */

        union {
            vuint32_t R;
            struct {
                vuint32_t:11;
                vuint32_t N_CH:5;
                vuint32_t:6;
                vuint32_t DATA:10;
            } B;
        } FR[4];               /* FIFO RIGHT aligned REGISTER */

		int16_t CTU_reserved4[16];		/* (0x080 - 0x09F+1/2) = 0x10 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:11;
                vuint32_t N_CH:5;
				vuint32_t:1;
                vuint32_t DATA:10;
                vuint32_t:5;
            } B;
        } FL[4];               /* FIFO LEFT aligned REGISTER */

		int16_t CTU_reserved5[4];		/* (0x0B0 - 0x0BF+1/2) = 0x04 */

        union {
            vuint16_t R;
            struct {
                vuint16_t:7;
                vuint16_t ET_OE:1;
                vuint16_t T1_OE:1;
                vuint16_t T0_OE:1;
                vuint16_t ADC_OE:1;
                vuint16_t TGS_OSM:1;
                vuint16_t MRS_O:1;
                vuint16_t ICE:1;
                vuint16_t SM_TO:1;
                vuint16_t MRS_RE:1;
            } B;
        } CTUEFR;               /* Cross Triggering Unit Error Flag Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:6;
                vuint16_t ADC_I:1;
                vuint16_t T7_I:1;
                vuint16_t T6_I:1;
                vuint16_t T5_I:1;
                vuint16_t T4_I:1;
                vuint16_t T3_I:1;
                vuint16_t T2_I:1;
                vuint16_t T1_I:1;
                vuint16_t T0_I:1;
                vuint16_t MRS_I:1;
            } B;
        } CTUIFR;               /* Cross Triggering Unit Interrupt Flag Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t T7_IE:1;
                vuint16_t T6_IE:1;
                vuint16_t T5_IE:1;
                vuint16_t T4_IE:1;
                vuint16_t T3_IE:1;
                vuint16_t T2_IE:1;
                vuint16_t T1_IE:1;
                vuint16_t T0_IE:1;
                vuint16_t:5;
                vuint16_t MRS_DMAE:1;
                vuint16_t MRS_IE:1;
                vuint16_t IEE:1;
            } B;
        } CTUIR;                /* Cross Triggering Unit Interrupt/DMA Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:8;
                vuint16_t COTR:8;
            } B;
        } COTR;                 /* Control On-Time Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t T7_SG:1;
                vuint16_t T6_SG:1;
                vuint16_t T5_SG:1;
                vuint16_t T4_SG:1;
                vuint16_t T3_SG:1;
                vuint16_t T2_SG:1;
                vuint16_t T1_SG:1;
                vuint16_t T0_SG:1;
                vuint16_t CTU_ADC_R:1;
                vuint16_t CTU_ODIS:1;
                vuint16_t DFE:1;
                vuint16_t CGRE:1;
                vuint16_t FGRE:1;
                vuint16_t MRS_SG:1;
                vuint16_t GRE:1;
                vuint16_t TGSISR_RE:1;
            } B;
        } CTUCR;                /* Cross Triggering Unit Control Register */

        union {
            vuint16_t R;
            struct {
                vuint16_t:8;
                vuint16_t N:8;
            } B;
        } CTUDF;            /* Cross Triggering Unit Digital Filter */

        union {
            vuint16_t R;
            struct {
                vuint16_t:15;
                vuint16_t MDIS:1;
            } B;
        } CTUPCR;               /* Cross Triggering Unit Power Control */

    };                          /* end of CTU_tag */
/****************************************************************************/
/*                          MODULE : FCU                                   */
/****************************************************************************/
    struct FCU_tag {

        union {
            vuint32_t R;
            struct {
                vuint32_t MCL:1;
                vuint32_t TM:2;
                vuint32_t:19;
                vuint32_t PS:2;
                vuint32_t FOM:2;
                vuint32_t FOP:6;
            } B;
        } MCR;                  /* Module Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t SRF0:1;
                vuint32_t:1;
                vuint32_t SRF2:1;
                vuint32_t SRF3:1;
                vuint32_t SRF4:1;
                vuint32_t:11;
                vuint32_t HRF15:1;
                vuint32_t HRF14:1;
                vuint32_t HRF13:1;
                vuint32_t HRF12:1;
                vuint32_t HRF11:1;
                vuint32_t HRF10:1;
                vuint32_t HRF9:1;
                vuint32_t HRF8:1;
                vuint32_t HRF7:1;
                vuint32_t HRF6:1;
                vuint32_t HRF5:1;
                vuint32_t HRF4:1;
                vuint32_t HRF3:1;
                vuint32_t HRF2:1;
                vuint32_t HRF1:1;
                vuint32_t HRF0:1;
            } B;
        } FFR;                  /* Fault Flag Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t FRSRF0:1;
                vuint32_t:1;
                vuint32_t FRSRF2:1;
                vuint32_t FRSRF3:1;
                vuint32_t FRSRF4:1;
                vuint32_t:11;
                vuint32_t FRHRF15:1;
                vuint32_t FRHRF14:1;
                vuint32_t FRHRF13:1;
                vuint32_t FRHRF12:1;
                vuint32_t FRHRF11:1;
                vuint32_t FRHRF10:1;
                vuint32_t FRHRF9:1;
                vuint32_t FRHRF8:1;
                vuint32_t FRHRF7:1;
                vuint32_t FRHRF6:1;
                vuint32_t FRHRF5:1;
                vuint32_t FRHRF4:1;
                vuint32_t FRHRF3:1;
                vuint32_t FRHRF2:1;
                vuint32_t FRHRF1:1;
                vuint32_t FRHRF0:1;
            } B;
        } FFFR;                 /* Frozen Fault Flag Register */

        union {
            vuint32_t R;
            struct {
				vuint32_t FSRF0:1;
                vuint32_t FSRF1:1;
                vuint32_t FSRF2:1;
                vuint32_t FSRF3:1;
                vuint32_t FSRF4:1;
                vuint32_t:11;
                vuint32_t FSRF15:1;
                vuint32_t FHRF15:1;
                vuint32_t FHRF14:1;
                vuint32_t FHRF13:1;
                vuint32_t FHRF12:1;
                vuint32_t FHRF11:1;
                vuint32_t FHRF10:1;
                vuint32_t FHRF9:1;
                vuint32_t FHRF8:1;
                vuint32_t FHRF7:1;
                vuint32_t FHRF6:1;
                vuint32_t FHRF5:1;
                vuint32_t FHRF4:1;
                vuint32_t FHRF3:1;
                vuint32_t FHRF2:1;
                vuint32_t FHRF1:1;
                vuint32_t FHRF0:1;
            } B;
        } FFGR;                 /* Fake Fault Generation Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t ESF0:1;
                vuint32_t ESF1:1;
                vuint32_t ESF2:1;
                vuint32_t ESF3:1;
                vuint32_t ESF4:1;
                vuint32_t:11;
                vuint32_t EHF15:1;
                vuint32_t EHF14:1;
                vuint32_t EHF13:1;
                vuint32_t EHF12:1;
                vuint32_t EHF11:1;
                vuint32_t EHF10:1;
                vuint32_t EHF9:1;
                vuint32_t EHF8:1;
                vuint32_t EHF7:1;
                vuint32_t EHF6:1;
                vuint32_t EHF5:1;
                vuint32_t EHF4:1;
                vuint32_t EHF3:1;
                vuint32_t EHF2:1;
                vuint32_t EHF1:1;
                vuint32_t EHF0:1;
            } B;
        } FER;                  /* Fault Enable Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t KR:32;
            } B;
        } KR;                   /* Fault Collection Unit Key Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t TR:32;
            } B;
        } TR;                   /* Fault Collection Unit Timeout Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t TESF0:1;
                vuint32_t TESF1:1;
                vuint32_t TESF2:1;
                vuint32_t TESF3:1;
                vuint32_t TESF4:1;
                vuint32_t:11;
                vuint32_t TEHF15:1;
                vuint32_t TEHF14:1;
                vuint32_t TEHF13:1;
                vuint32_t TEHF12:1;
                vuint32_t TEHF11:1;
                vuint32_t TEHF10:1;
                vuint32_t TEHF9:1;
                vuint32_t TEHF8:1;
                vuint32_t TEHF7:1;
                vuint32_t TEHF6:1;
                vuint32_t TEHF5:1;
                vuint32_t TEHF4:1;
                vuint32_t TEHF3:1;
                vuint32_t TEHF2:1;
                vuint32_t TEHF1:1;
                vuint32_t TEHF0:1;
            } B;
        } TER;                  /* Fault Collection Unit Timeout Enable Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t S3:1;
                vuint32_t S2:1;
                vuint32_t S1:1;
                vuint32_t S0:1;
            } B;
        } MSR;                  /* Module state register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:12;
                vuint32_t MCPS:4;
                vuint32_t:12;
                vuint32_t MCAS:4;
            } B;
        } MCSR;                 /* MC state register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:12;
                vuint32_t FRMCPS:4;
                vuint32_t:12;
                vuint32_t FRMCAS:4;
            } B;
        } FMCSR;                /* Frozen MC State Register */

    };                          /* end of FCU_tag */
/****************************************************************************/
/*                          MODULE : PIT                                    */
/****************************************************************************/
    struct PIT_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t:30;
		vuint32_t MDIS:1;
                vuint32_t FRZ:1;
            } B;
        } PITMCR;						/* PIT Module Control Register */

        uint32_t PIT_reserved1[63];     /* (0x0004 - 0x00FF+1)/4 = 0x3F */

        struct {
            union {
                vuint32_t R;
                struct {
                    vuint32_t TSV:32;
                } B;
            } LDVAL;					/* Timer x Load Value Register*/

            union {
                vuint32_t R;
                struct {
                    vuint32_t TVL:32;
                } B;
            } CVAL;						/* Timer x Current Value Register*/

            union {
                vuint32_t R;
                struct {
                    vuint32_t:30;
                    vuint32_t TIE:1;
                    vuint32_t TEN:1;
                } B;
            } TCTRL;					/* Timer x Control Register*/

            union {
                vuint32_t R;
                struct {
                    vuint32_t:31;
                    vuint32_t TIF:1;
                } B;
            } TFLG;						/* Timer x Flag Register*/
        } CH[4];

    };                          /* end of PIT_tag */
/****************************************************************************/
/*                          MODULE : eDMA                                   */
/****************************************************************************/
    struct EDMA_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t:29;
                vuint32_t ERCA:1;
                vuint32_t EDBG:1;
                vuint32_t:1;
            } B;
        } CR;                   /* Control Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t VLD:1;
                vuint32_t:16;
                vuint32_t CPE:1;
                vuint32_t ERRCHN:6;
                vuint32_t SAE:1;
                vuint32_t SOE:1;
                vuint32_t DAE:1;
                vuint32_t DOE:1;
                vuint32_t NCE:1;
                vuint32_t SGE:1;
                vuint32_t SBE:1;
                vuint32_t DBE:1;
            } B;
        } ESR;                  /* Error Status Register */

		int16_t EDMA_reserved1[2];      /* (0x008 - 0x00B+1)/2 = 0x02 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t ERQ15:1;
                vuint32_t ERQ14:1;
                vuint32_t ERQ13:1;
                vuint32_t ERQ12:1;
                vuint32_t ERQ11:1;
                vuint32_t ERQ10:1;
                vuint32_t ERQ09:1;
                vuint32_t ERQ08:1;
                vuint32_t ERQ07:1;
                vuint32_t ERQ06:1;
                vuint32_t ERQ05:1;
                vuint32_t ERQ04:1;
                vuint32_t ERQ03:1;
                vuint32_t ERQ02:1;
                vuint32_t ERQ01:1;
                vuint32_t ERQ00:1;
            } B;
        } ERQRL;                /* DMA Enable Request Register Low */

		int16_t EDMA_reserved2[2];      /* (0x010 - 0x0013+1)/2 = 0x02 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t EEI15:1;
                vuint32_t EEI14:1;
                vuint32_t EEI13:1;
                vuint32_t EEI12:1;
                vuint32_t EEI11:1;
                vuint32_t EEI10:1;
                vuint32_t EEI09:1;
                vuint32_t EEI08:1;
                vuint32_t EEI07:1;
                vuint32_t EEI06:1;
                vuint32_t EEI05:1;
                vuint32_t EEI04:1;
                vuint32_t EEI03:1;
                vuint32_t EEI02:1;
                vuint32_t EEI01:1;
                vuint32_t EEI00:1;
            } B;
        } EEIRL;                /* DMA Enable Error Interrupt Register Low */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t SERQ:7;
            } B;
        } SERQR;                /* DMA Set Enable Request Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t CERQ:7;
            } B;
        } CERQR;                /* DMA Clear Enable Request Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t SEEI:7;
            } B;
        } SEEIR;                /* DMA Set Enable Error Interrupt Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t CEEI:7;
            } B;
        } CEEIR;                /* DMA Clear Enable Error Interrupt Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t CINT:7;
            } B;
        } CIRQR;                /* DMA Clear Interrupt Request Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t CER:7;
            } B;
        } CER;                 /* DMA Clear error Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t SSB:7;
            } B;
        } SSBR;                 /* Set Start Bit Register */

        union {
            vuint8_t R;
            struct {
                vuint8_t:1;
                vuint8_t CDSB:7;
            } B;
        } CDSBR;                /* Clear Done Status Bit Register */

		int16_t EDMA_reserved3[2];      /* (0x020 - 0x023+1)/2 = 0x02 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t INT15:1;
                vuint32_t INT14:1;
                vuint32_t INT13:1;
                vuint32_t INT12:1;
                vuint32_t INT11:1;
                vuint32_t INT10:1;
                vuint32_t INT09:1;
                vuint32_t INT08:1;
                vuint32_t INT07:1;
                vuint32_t INT06:1;
                vuint32_t INT05:1;
                vuint32_t INT04:1;
                vuint32_t INT03:1;
                vuint32_t INT02:1;
                vuint32_t INT01:1;
                vuint32_t INT00:1;
            } B;
        } IRQRL;                /* DMA Interrupt Request Low */

		int16_t EDMA_reserved4[3];      /* (0x026 - 0x02B+1)/2 = 0x03 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t ERR15:1;
                vuint32_t ERR14:1;
                vuint32_t ERR13:1;
                vuint32_t ERR12:1;
                vuint32_t ERR11:1;
                vuint32_t ERR10:1;
                vuint32_t ERR09:1;
                vuint32_t ERR08:1;
                vuint32_t ERR07:1;
                vuint32_t ERR06:1;
                vuint32_t ERR05:1;
                vuint32_t ERR04:1;
                vuint32_t ERR03:1;
                vuint32_t ERR02:1;
                vuint32_t ERR01:1;
                vuint32_t ERR00:1;
            } B;
        } ERL;                  /* DMA Error Low */

		int16_t EDMA_reserved5[3];      /* (0x02E - 0x033+1)/2 = 0x03 */

        union {
            vuint32_t R;
            struct {
				vuint32_t:16;
                vuint32_t HRS15:1;
                vuint32_t HRS14:1;
                vuint32_t HRS13:1;
                vuint32_t HRS12:1;
                vuint32_t HRS11:1;
                vuint32_t HRS10:1;
                vuint32_t HRS09:1;
                vuint32_t HRS08:1;
                vuint32_t HRS07:1;
                vuint32_t HRS06:1;
                vuint32_t HRS05:1;
                vuint32_t HRS04:1;
                vuint32_t HRS03:1;
                vuint32_t HRS02:1;
                vuint32_t HRS01:1;
                vuint32_t HRS00:1;
            } B;
        } HRSL;                 /* DMA Hardware Request Status Low */

		int16_t EDMA_reserved6[50];      /* (0x036 - 0x0FF+1)/2 = 0x32 */

        union {
            vuint8_t R;
            struct {
                vuint8_t ECP:1;
                vuint8_t:3;
                vuint8_t CHPRI:4;
            } B;
        } CPR[16];              /* Channel n Priority */

		int16_t EDMA_reserved7[1912];      /* (0x110 - 0xFFF+1)/2 = 0x778 */

        /*for "standard" format TCD (when EDMA.TCD[x].CITER.E_LINK==BITER.E_LINK=0) */
		union {
			struct {
				/* WORD 0 */
				vuint32_t SADDR;        /* source address */
				/* WORD 1 */
				vuint16_t SMOD:5;       /* source address modulo */
				vuint16_t SSIZE:3;      /* source transfer size */
				vuint16_t DMOD:5;       /* destination address modulo */
				vuint16_t DSIZE:3;      /* destination transfer size */
				vint16_t SOFF;          /* signed source address offset */
				/* WORD 2 */
				vuint32_t NBYTES;       /* inner (minor) byte count */
				/* WORD 3 */
				vint32_t SLAST;         /* last destination address adjustment, or
										   scatter/gather address (if e_sg = 1) */
				/* WORD 4 */
				vuint32_t DADDR;        /* destination address */
				/* WORD 5 */
				vuint16_t CITER_E_LINK:1;
				vuint16_t CITER:15;
				vint16_t DOFF;          /* signed destination address offset */
				/* WORD 6 */
				vint32_t DLAST_SGA;
				/* WORD 7 */
				vuint16_t BITER_E_LINK:1;        /* beginning ("major") iteration count */
				vuint16_t BITER:15;
				vuint16_t BWC:2;        /* bandwidth control */
				vuint16_t MAJOR_LINKCH:6;        /* enable channel-to-channel link */
				vuint16_t DONE:1;       /* channel done */
				vuint16_t ACTIVE:1;     /* channel active */
				vuint16_t MAJOR_E_LINK:1;        /* enable channel-to-channel link */
				vuint16_t E_SG:1;       /* enable scatter/gather descriptor */
				vuint16_t D_REQ:1;      /* disable ipd_req when done */
				vuint16_t INT_HALF:1;   /* interrupt on citer = (biter >> 1) */
				vuint16_t INT_MAJ:1;    /* interrupt on major loop completion */
				vuint16_t START:1;      /* explicit channel start */
			} STD;                          /* end of EDMA_TCD_STD_tag */
		/*for "channel link" format TCD (when EDMA.TCD[x].CITER.E_LINK==BITER.E_LINK=1)*/
			struct {
				/* WORD 0 */
				vuint32_t SADDR;        /* source address */
				/* WORD 1 */
				vuint16_t SMOD:5;       /* source address modulo */
				vuint16_t SSIZE:3;      /* source transfer size */
				vuint16_t DMOD:5;       /* destination address modulo */
				vuint16_t DSIZE:3;      /* destination transfer size */
				vint16_t SOFF;          /* signed source address offset */
				/* WORD 2 */
				vuint32_t NBYTES;       /* inner (minor) byte count */
				/* WORD 3 */
				vint32_t SLAST;         /* last destination address adjustment, or
										   scatter/gather address (if e_sg = 1) */
				/* WORD 4 */
				vuint32_t DADDR;        /* destination address */
				/* WORD 5 */
				vuint16_t CITER_E_LINK:1;
				vuint16_t CITER_LINKCH:6;
				vuint16_t CITER:9;
				vint16_t DOFF;          /* signed destination address offset */
				/* WORD 6 */
				vint32_t DLAST_SGA;
				/* WORD 7 */
				vuint16_t BITER_E_LINK:1;        /* beginning (major) iteration count */
				vuint16_t BITER_LINKCH:6;
				vuint16_t BITER:9;
				vuint16_t BWC:2;        /* bandwidth control */
				vuint16_t MAJOR_LINKCH:6;        /* enable channel-to-channel link */
				vuint16_t DONE:1;       /* channel done */
				vuint16_t ACTIVE:1;     /* channel active */
				vuint16_t MAJOR_E_LINK:1;        /* enable channel-to-channel link */
				vuint16_t E_SG:1;       /* enable scatter/gather descriptor */
				vuint16_t D_REQ:1;      /* disable ipd_req when done */
				vuint16_t INT_HALF:1;   /* interrupt on citer = (biter >> 1) */
				vuint16_t INT_MAJ:1;    /* interrupt on major loop completion */
				vuint16_t START:1;      /* explicit channel start */
			} CHLINK;                          /* end of EDMA_TCD_CHLINK_tag */
		} TCD[16];
    };                          /* end of EDMA_tag */
/****************************************************************************/
/*                          MODULE : INTC                                   */
/****************************************************************************/
    struct INTC_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t:26;
                vuint32_t VTES:1;
                vuint32_t:4;
                vuint32_t HVEN:1;
            } B;
        } MCR;                  /* Module Configuration Register */

        int32_t INTC_reserved1[1]; /* (0x004 - 0x007+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t PRI:4;
            } B;
        } CPR;                  /* Current Priority Register */

        int32_t INTC_reserved2[1]; /* (0x00C - 0x00F+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t VTBA:21;
                vuint32_t INTVEC:9;
                vuint32_t:2;
            } B;
        } IACKR;                /* Interrupt Acknowledge Register */

        int32_t INTC_reserved3[1]; /* (0x014 - 0x017+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t:32;
            } B;
        } EOIR;                 /* End of Interrupt Register */

        int32_t INTC_reserved4[1]; /* (0x01C - 0x01F)/4 = 0x01 */

        union {
            vuint8_t R;
            struct {
                vuint8_t:6;
                vuint8_t SET:1;
                vuint8_t CLR:1;
            } B;
        } SSCIR[8];             /* Software Set/Clear Interruput Register */

        uint32_t intc_reserved5[6];     /* (0x028 - 0x03F+1)/4 = 0x06 */

        union {
            vuint8_t R;
            struct {
                vuint8_t:4;
                vuint8_t PRI:4;
            } B;
        } PSR[222];             /* Software Set/Clear Interrupt Register */

    };                          /* end of INTC_tag */
/****************************************************************************/
/*                          MODULE : DSPI                                   */
/****************************************************************************/
    struct DSPI_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t MSTR:1;
                vuint32_t CONT_SCKE:1;
                vuint32_t DCONF:2;
                vuint32_t FRZ:1;
                vuint32_t MTFE:1;
                vuint32_t PCSSE:1;
                vuint32_t ROOE:1;
				vuint32_t PCSIS7:1;
				vuint32_t PCSIS6:1;
                vuint32_t PCSIS5:1;
                vuint32_t PCSIS4:1;
                vuint32_t PCSIS3:1;
                vuint32_t PCSIS2:1;
                vuint32_t PCSIS1:1;
                vuint32_t PCSIS0:1;
                vuint32_t:1;
                vuint32_t MDIS:1;
                vuint32_t DIS_TXF:1;
                vuint32_t DIS_RXF:1;
                vuint32_t CLR_TXF:1;
                vuint32_t CLR_RXF:1;
                vuint32_t SMPL_PT:2;
                vuint32_t:7;
                vuint32_t HALT:1;
            } B;
        } MCR;                  /* Module Configuration Register */

        int32_t DSPI_reserved1[1];	/* (0x004 - 0x007+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t TCNT:16;
                  vuint32_t:16;
            } B;
        } TCR;

        union {
            vuint32_t R;
            struct {
                vuint32_t DBR:1;
                vuint32_t FMSZ:4;
                vuint32_t CPOL:1;
                vuint32_t CPHA:1;
                vuint32_t LSBFE:1;
                vuint32_t PCSSCK:2;
                vuint32_t PASC:2;
                vuint32_t PDT:2;
                vuint32_t PBR:2;
                vuint32_t CSSCK:4;
                vuint32_t ASC:4;
                vuint32_t DT:4;
                vuint32_t BR:4;
            } B;
			struct {
                vuint32_t:1;
                vuint32_t FMSZ:4;
                vuint32_t CPOL:1;
                vuint32_t CPHA:1;
                vuint32_t:25;
            } B_SLAVE;
        } CTAR[8];              /* Clock and Transfer Attributes Registers */

        union {
            vuint32_t R;
            struct {
                vuint32_t TCF:1;
                vuint32_t TXRXS:1;
                vuint32_t:1;
                vuint32_t EOQF:1;
                vuint32_t TFUF:1;
                vuint32_t:1;
                vuint32_t TFFF:1;
                vuint32_t:5;
                vuint32_t RFOF:1;
                vuint32_t:1;
                vuint32_t RFDF:1;
                vuint32_t:1;
                vuint32_t TXCTR:4;
                vuint32_t TXNXTPTR:4;
                vuint32_t RXCTR:4;
                vuint32_t POPNXTPTR:4;
            } B;
        } SR;                   /* Status Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t TCF_RE:1;
                vuint32_t:2;
                vuint32_t EOQF_RE:1;
                vuint32_t TFUF_RE:1;
                vuint32_t:1;
                vuint32_t TFFF_RE:1;
                vuint32_t TFFF_DIRS:1;
                vuint32_t:4;
                vuint32_t RFOF_RE:1;
                vuint32_t:1;
                vuint32_t RFDF_RE:1;
                vuint32_t RFDF_DIRS:1;
                vuint32_t:16;
            } B;
        } RSER;                 /* DMA/Interrupt Request Select and Enable Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t CONT:1;
                vuint32_t CTAS:3;
                vuint32_t EOQ:1;
                vuint32_t CTCNT:1;
                vuint32_t:2;
				vuint32_t PCS7:1;
				vuint32_t PCS6:1;
                vuint32_t PCS5:1;
                vuint32_t PCS4:1;
                vuint32_t PCS3:1;
                vuint32_t PCS2:1;
                vuint32_t PCS1:1;
                vuint32_t PCS0:1;
                vuint32_t TXDATA:16;
            } B;
        } PUSHR;                /* PUSH TX FIFO Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t RXDATA:16;
            } B;
        } POPR;                 /* POP RX FIFO Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t TXCMD:16;
                vuint32_t TXDATA:16;
            } B;
        } TXFR[5];              /* Transmit FIFO Registers */

		int32_t DSPI_reserved2[11];	/* (0x050 - 0x07B+1)/4 = 0x0B */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t RXDATA:16;
            } B;
        } RXFR[5];              /* Receive FIFO Registers */
      
    };                          /* end of DSPI_tag */
/****************************************************************************/
/*                          MODULE : FlexCAN                                */
/****************************************************************************/
     struct FLEXCAN_BUF_t {
	union {		
        struct {
                vuint32_t:4;
                vuint32_t CODE:4;
                vuint32_t:1;
                vuint32_t SRR:1;
                vuint32_t IDE:1;
                vuint32_t RTR:1;
                vuint32_t LENGTH:4;
                vuint32_t TIME_STAMP:16;
				vuint32_t PRIO:3;
                vuint32_t ID:11;
				vuint32_t:18;
            } B_STD;
	    struct {
                vuint32_t:4;
                vuint32_t CODE:4;
                vuint32_t:1;
                vuint32_t SRR:1;
                vuint32_t IDE:1;
                vuint32_t RTR:1;
                vuint32_t LENGTH:4;
                vuint32_t TIME_STAMP:16;
                vuint32_t PRIO:3;
                vuint32_t ID:29;
            } B_EXT;
        vuint32_t R[2];
	} HEADER;		
        union {
            vuint8_t  B[8]; /* Data buffer in Bytes (8 bits) */
            vuint16_t H[4]; /* Data buffer in Half-words (16 bits) */
            vuint32_t W[2];     /* Data buffer in words (32 bits) */
            vuint32_t R[2]; /* Data buffer in words (32 bits) */
        } DATA;
    }; 

     struct FLEXCAN_RXFIFO_t {
        union {
			struct {
                vuint32_t:9;
                vuint32_t SRR:1;
                vuint32_t IDE:1;
                vuint32_t RTR:1;
                vuint32_t LENGTH:4;
                vuint32_t TIME_STAMP:16;
				vuint32_t:3;
                vuint32_t ID:11;
				vuint32_t:18;
            } B_STD;
            struct {
				vuint32_t:9;
                vuint32_t SRR:1;
                vuint32_t IDE:1;
                vuint32_t RTR:1;
                vuint32_t LENGTH:4;
                vuint32_t TIME_STAMP:16;
				vuint32_t :3;
                vuint32_t ID:29;
            } B_EXT;
			vuint32_t R[2];
        } HEADER;
	
        union {
            vuint8_t  B[8]; /* Data buffer in Bytes (8 bits) */
            vuint16_t H[4]; /* Data buffer in Half-words (16 bits) */
            vuint32_t W[2]; /* Data buffer in words (32 bits) */
            vuint32_t R[2]; /* Data buffer in words (32 bits) */
        } DATA;
    
        uint32_t FLEXCAN_RXFIFO_reserved[20];   /* {0x0090-0x00DF+1}/0x4 = 0x14 */

        union {
            vuint32_t R;

			struct {
				struct {
				vuint32_t REM:1;
				vuint32_t EXT:1;
				vuint32_t RXIDA:11;
				vuint32_t:19;
				} STD;
				struct {
				vuint32_t REM:1;
				vuint32_t EXT:1;
				vuint32_t RXIDA:29;
				vuint32_t:1;
				} EXT;
			}FORMAT_A;

			struct {
				union {
				vuint16_t R;
				struct {
					vuint32_t REM:1;
					vuint32_t EXT:1;
					vuint32_t RXIDB:11;
					vuint32_t:3;
				}B;
				} STD[2];

				union {
				vuint16_t R;
				struct {
					vuint32_t REM:1;
					vuint32_t EXT:1;
					vuint32_t RXIDB:14;
				}B;
				} EXT[2];
			}FORMAT_B;

			struct {
				vuint8_t RXIDC[4];
			} FORMAT_C;

        } ID_TABLE[8];
    };                          /* end of FLEXCAN_RXFIFO_t */





    struct FLEXCAN_tag {
        union {
            vuint32_t R;
            struct {
                vuint32_t MDIS:1;
                vuint32_t FRZ:1;
                vuint32_t FEN:1;
                vuint32_t HALT:1;
                vuint32_t NOT_RDY:1;
                vuint32_t WAK_MSK:1;
                vuint32_t SOFT_RST:1;
                vuint32_t FRZ_ACK:1;
                vuint32_t SUPV:1;
                vuint32_t :1;
                vuint32_t WRN_EN:1;
                vuint32_t LPM_ACK:1;
                vuint32_t:2;
                vuint32_t SRX_DIS:1;
                vuint32_t BCC:1;
                  vuint32_t:2;
                vuint32_t LPRIO_EN:1;
                vuint32_t AEN:1;
                  vuint32_t:2;
                vuint32_t IDAM:2;
                  vuint32_t:2;
                vuint32_t MAXMB:6;
            } B;
        } MCR;                  /* Module Configuration Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t PRESDIV:8;
                vuint32_t RJW:2;
                vuint32_t PSEG1:3;
                vuint32_t PSEG2:3;
                vuint32_t BOFF_MSK:1;
                vuint32_t ERR_MSK:1;
                vuint32_t CLK_SRC:1;
                vuint32_t LPB:1;
                vuint32_t TWRN_MSK:1;
                vuint32_t RWRN_MSK:1;
                  vuint32_t:2;
                vuint32_t SMP:1;
                vuint32_t BOFF_REC:1;
                vuint32_t TSYN:1;
                vuint32_t LBUF:1;
                vuint32_t LOM:1;
                vuint32_t PROPSEG:3;
            } B;
        } CTRL;                   /* Control Register */

        union {
            vuint32_t R;
			struct {
				vuint32_t:16;
				vuint32_t TIMER:16;
			} B;
        } TIMER;                /* Free Running Timer */

        uint32_t FLEXCAN_reserved1[1];	/* (0x0C - 0x0F+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t MI31:1;
				vuint32_t MI30:1;
				vuint32_t MI29:1;
				vuint32_t MI28:1;
				vuint32_t MI27:1;
				vuint32_t MI26:1;
				vuint32_t MI25:1;
				vuint32_t MI24:1;
				vuint32_t MI23:1;
				vuint32_t MI22:1;
				vuint32_t MI21:1;
				vuint32_t MI20:1;
				vuint32_t MI19:1;
				vuint32_t MI18:1;
				vuint32_t MI17:1;
				vuint32_t MI16:1;
				vuint32_t MI15:1;
				vuint32_t MI14:1;
				vuint32_t MI13:1;
				vuint32_t MI12:1;
				vuint32_t MI11:1;
				vuint32_t MI10:1;
				vuint32_t MI9:1;
				vuint32_t MI8:1;
				vuint32_t MI7:1;
				vuint32_t MI6:1;
				vuint32_t MI5:1;
				vuint32_t MI4:1;
				vuint32_t MI3:1;
				vuint32_t MI2:1;
				vuint32_t MI1:1;
				vuint32_t MI0:1;
            } B;
        } RXGMASK;              /* RX Global Mask */

        union {
            vuint32_t R;
            struct {
                vuint32_t MI31:1;
				vuint32_t MI30:1;
				vuint32_t MI29:1;
				vuint32_t MI28:1;
				vuint32_t MI27:1;
				vuint32_t MI26:1;
				vuint32_t MI25:1;
				vuint32_t MI24:1;
				vuint32_t MI23:1;
				vuint32_t MI22:1;
				vuint32_t MI21:1;
				vuint32_t MI20:1;
				vuint32_t MI19:1;
				vuint32_t MI18:1;
				vuint32_t MI17:1;
				vuint32_t MI16:1;
				vuint32_t MI15:1;
				vuint32_t MI14:1;
				vuint32_t MI13:1;
				vuint32_t MI12:1;
				vuint32_t MI11:1;
				vuint32_t MI10:1;
				vuint32_t MI9:1;
				vuint32_t MI8:1;
				vuint32_t MI7:1;
				vuint32_t MI6:1;
				vuint32_t MI5:1;
				vuint32_t MI4:1;
				vuint32_t MI3:1;
				vuint32_t MI2:1;
				vuint32_t MI1:1;
				vuint32_t MI0:1;
            } B;
        } RX14MASK;             /* RX 14 Mask */

        union {
            vuint32_t R;
            struct {
                vuint32_t MI31:1;
				vuint32_t MI30:1;
				vuint32_t MI29:1;
				vuint32_t MI28:1;
				vuint32_t MI27:1;
				vuint32_t MI26:1;
				vuint32_t MI25:1;
				vuint32_t MI24:1;
				vuint32_t MI23:1;
				vuint32_t MI22:1;
				vuint32_t MI21:1;
				vuint32_t MI20:1;
				vuint32_t MI19:1;
				vuint32_t MI18:1;
				vuint32_t MI17:1;
				vuint32_t MI16:1;
				vuint32_t MI15:1;
				vuint32_t MI14:1;
				vuint32_t MI13:1;
				vuint32_t MI12:1;
				vuint32_t MI11:1;
				vuint32_t MI10:1;
				vuint32_t MI9:1;
				vuint32_t MI8:1;
				vuint32_t MI7:1;
				vuint32_t MI6:1;
				vuint32_t MI5:1;
				vuint32_t MI4:1;
				vuint32_t MI3:1;
				vuint32_t MI2:1;
				vuint32_t MI1:1;
				vuint32_t MI0:1;
            } B;
        } RX15MASK;             /* RX 15 Mask */

        union {
            vuint32_t R;
            struct {
                vuint32_t:16;
                vuint32_t RX_ERR_COUNTER:8;
                vuint32_t TX_ERR_COUNTER:8;
            } B;
        } ECR;                  /* Error Counter Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t:14;
                vuint32_t TWRN_INT:1;
                vuint32_t RWRN_INT:1;
                vuint32_t BIT1_ERR:1;
                vuint32_t BIT0_ERR:1;
                vuint32_t ACK_ERR:1;
                vuint32_t CRC_ERR:1;
                vuint32_t FRM_ERR:1;
                vuint32_t STF_ERR:1;
                vuint32_t TX_WRN:1;
                vuint32_t RX_WRN:1;
                vuint32_t IDLE:1;
                vuint32_t TXRX:1;
                vuint32_t FLT_CONF:2;
                vuint32_t:1;
                vuint32_t BOFF_INT:1;
                vuint32_t ERR_INT:1;
                vuint32_t WAK_INT:1;
            } B;
        } ESR;                  /* Error and Status Register */

	   uint32_t FLEXCAN_reserved2[1];	/* (0x24 - 0x27+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t BUF31M:1;
                vuint32_t BUF30M:1;
                vuint32_t BUF29M:1;
                vuint32_t BUF28M:1;
                vuint32_t BUF27M:1;
                vuint32_t BUF26M:1;
                vuint32_t BUF25M:1;
                vuint32_t BUF24M:1;
                vuint32_t BUF23M:1;
                vuint32_t BUF22M:1;
                vuint32_t BUF21M:1;
                vuint32_t BUF20M:1;
                vuint32_t BUF19M:1;
                vuint32_t BUF18M:1;
                vuint32_t BUF17M:1;
                vuint32_t BUF16M:1;
                vuint32_t BUF15M:1;
                vuint32_t BUF14M:1;
                vuint32_t BUF13M:1;
                vuint32_t BUF12M:1;
                vuint32_t BUF11M:1;
                vuint32_t BUF10M:1;
                vuint32_t BUF9M:1;
                vuint32_t BUF8M:1;
                vuint32_t BUF7M:1;
                vuint32_t BUF6M:1;
                vuint32_t BUF5M:1;
                vuint32_t BUF4M:1;
                vuint32_t BUF3M:1;
                vuint32_t BUF2M:1;
                vuint32_t BUF1M:1;
                vuint32_t BUF0M:1;
            } B;
        } IMASK1;                 /* Interruput Masks Register */

	   uint32_t FLEXCAN_reserved3[1];	/* (0x2C - 0x2F+1)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t BUF31I:1;
                vuint32_t BUF30I:1;
                vuint32_t BUF29I:1;
                vuint32_t BUF28I:1;
                vuint32_t BUF27I:1;
                vuint32_t BUF26I:1;
                vuint32_t BUF25I:1;
                vuint32_t BUF24I:1;
                vuint32_t BUF23I:1;
                vuint32_t BUF22I:1;
                vuint32_t BUF21I:1;
                vuint32_t BUF20I:1;
                vuint32_t BUF19I:1;
                vuint32_t BUF18I:1;
                vuint32_t BUF17I:1;
                vuint32_t BUF16I:1;
                vuint32_t BUF15I:1;
                vuint32_t BUF14I:1;
                vuint32_t BUF13I:1;
                vuint32_t BUF12I:1;
                vuint32_t BUF11I:1;
                vuint32_t BUF10I:1;
                vuint32_t BUF9I:1;
                vuint32_t BUF8I:1;
                vuint32_t BUF7I:1;
                vuint32_t BUF6I:1;
                vuint32_t BUF5I:1;
                vuint32_t BUF4I:1;
                vuint32_t BUF3I:1;
                vuint32_t BUF2I:1;
                vuint32_t BUF1I:1;
                vuint32_t BUF0I:1;
            } B;
        } IFLAG1;                 /* Interruput Flag Register */

		uint32_t FLEXCAN_reserved4[19];	/* (0x034 - 0x07F+1)/4 = 0x13 */

/****************************************************************************/
/* Use either Standard Buffer Structure OR RX FIFO and Buffer Structure     */
/****************************************************************************/
        /* Standard Buffer Structure */
        struct FLEXCAN_BUF_t MB[32];

        /* RX FIFO and Buffer Structure */
        struct FLEXCAN_RXFIFO_t RXFIFO; //the RXFIFO structure is on the same addresses as first 8 MBs
        /*struct FLEXCAN_BUF_t MB[24];   */
/****************************************************************************/

		uint32_t FLEXCAN_reserved5[384];	/* (0x280 - 0x87F+1)/4 = 0x180 */

        union {
            vuint32_t R;
            struct {
                vuint32_t MI31:1;
				vuint32_t MI30:1;
				vuint32_t MI29:1;
				vuint32_t MI28:1;
				vuint32_t MI27:1;
				vuint32_t MI26:1;
				vuint32_t MI25:1;
				vuint32_t MI24:1;
				vuint32_t MI23:1;
				vuint32_t MI22:1;
				vuint32_t MI21:1;
				vuint32_t MI20:1;
				vuint32_t MI19:1;
				vuint32_t MI18:1;
				vuint32_t MI17:1;
				vuint32_t MI16:1;
				vuint32_t MI15:1;
				vuint32_t MI14:1;
				vuint32_t MI13:1;
				vuint32_t MI12:1;
				vuint32_t MI11:1;
				vuint32_t MI10:1;
				vuint32_t MI9:1;
				vuint32_t MI8:1;
				vuint32_t MI7:1;
				vuint32_t MI6:1;
				vuint32_t MI5:1;
				vuint32_t MI4:1;
				vuint32_t MI3:1;
				vuint32_t MI2:1;
				vuint32_t MI1:1;
				vuint32_t MI0:1;
            } B;
        } RXIMR[32];            /* RX Individual Mask Registers */

    };                          /* end of FLEXCAN_tag */
/****************************************************************************/
/*                          MODULE : DMAMUX                                 */
/****************************************************************************/
    struct DMAMUX_tag {
        union {
            vuint8_t R;
            struct {
                vuint8_t ENBL:1;
                vuint8_t TRIG:1;
                vuint8_t SOURCE:6;
            } B;
        } CHCONFIG[16];         /* DMA Channel Configuration Register */

    };                          /* end of DMAMUX_tag */
/****************************************************************************/
/*                          MODULE : FlexRay                                */
/****************************************************************************/

	/*Module Configuration and Control*/
    typedef union uMVR {
        vuint16_t R;
        struct {
            vuint16_t CHIVER:8; /* CHI Version Number */
            vuint16_t PEVER:8;  /* PE Version Number */
        } B;
    } MVR_t;

    typedef union uMCR {
        vuint16_t R;
        struct {
            vuint16_t MEN:1;    /* module enable */
            vuint16_t SBFF:1;
            vuint16_t SCM:1;   /* single channel mode */
            vuint16_t CHB:1;    /* channel B enable */
            vuint16_t CHA:1;    /* channel A enable */
            vuint16_t SFFE:1;   /* synchronization frame filter enable */
              vuint16_t:5;
            vuint16_t CLKSEL:1; /* protocol engine clock source select */
            vuint16_t BITRATE:3;       /* protocol engine clock prescaler */
              vuint16_t:1;
        } B;
    } MCR_t;

	typedef union uSYMBADHR {
        vuint16_t R;
    } SYMBADHR_t;

    typedef union uSYMBADLR {
        vuint16_t R;
    } SYMBADLR_t;

    typedef union uSTBSCR {
        vuint16_t R;
        struct {
            vuint16_t WMD:1;    /* write mode */
            vuint16_t SEL:7;        /* strobe signal select */
              vuint16_t:3;
            vuint16_t ENB:1;    /* strobe signal enable */
              vuint16_t:2;
            vuint16_t STBPSEL:2;        /* strobe port select */
        } B;
    } STBSCR_t;

    typedef union uMBDSR {
        vuint16_t R;
        struct {
            vuint16_t:1;
            vuint16_t MBSEG2DS:7;       /* message buffer segment 2 data size */
            vuint16_t:1;
            vuint16_t MBSEG1DS:7;       /* message buffer segment 1 data size */
        } B;
    } MBDSR_t;

    typedef union uMBSSUTR {
        vuint16_t R;
        struct {

            vuint16_t:3;
            vuint16_t LAST_MB_SEG1:5;   /* last message buffer control register for message buffer segment 1 */
            vuint16_t:3;
            vuint16_t LAST_MB_UTIL:6;   /* last message buffer utilized */
        } B;
    } MBSSUTR_t;

	/*Interrupt and Error Handling*/
    typedef union uPOCR {
        vuint16_t R;
        vuint8_t byte[2];
        struct {
            vuint16_t WME:1;    /* write mode external correction command */
            vuint16_t:3;
            vuint16_t EOC_AP:2; /* external offset correction application */
            vuint16_t ERC_AP:2; /* external rate correction application */
            vuint16_t BSY:1;    /* command write busy / write mode command */
            vuint16_t:3;
            vuint16_t POCCMD:4; /* protocol command */
        } B;
    } POCR_t;

    typedef union uGIFER {
        vuint16_t R;
        struct {
            vuint16_t MIF:1;    /* module interrupt flag */
            vuint16_t PRIF:1;   /* protocol interrupt flag */
            vuint16_t CHIF:1;   /* CHI interrupt flag */
            vuint16_t WUPIF:1; /* wakeup interrupt flag */
            vuint16_t FNEBIF:1; /* receive FIFO channel B not empty interrupt flag */
            vuint16_t FNEAIF:1; /* receive FIFO channel A not empty interrupt flag */
            vuint16_t RBIF:1;   /* receive message buffer interrupt flag */
            vuint16_t TBIF:1;   /* transmit buffer interrupt flag */
            vuint16_t MIE:1;    /* module interrupt enable */
            vuint16_t PRIE:1;   /* protocol interrupt enable */
            vuint16_t CHIE:1;   /* CHI interrupt enable */
            vuint16_t WUPIE:1; /* wakeup interrupt enable */
            vuint16_t FNEBIE:1; /* receive FIFO channel B not empty interrupt enable */
            vuint16_t FNEAIE:1; /* receive FIFO channel A not empty interrupt enable */
            vuint16_t RBIE:1;   /* receive message buffer interrupt enable */
            vuint16_t TBIE:1;   /* transmit buffer interrupt enable */
        } B;
    } GIFER_t;

    typedef union uPIFR0 {
        vuint16_t R;
        struct {
            vuint16_t FATL_IF:1; /* fatal protocol error interrupt flag */
            vuint16_t INTL_IF:1; /* internal protocol error interrupt flag */
            vuint16_t ILCF_IF:1; /* illegal protocol configuration flag */
            vuint16_t CSA_IF:1;  /* cold start abort interrupt flag */
            vuint16_t MRC_IF:1;  /* missing rate correctio interrupt flag */
            vuint16_t MOC_IF:1;  /* missing offset correctio interrupt flag */
            vuint16_t CCL_IF:1;  /* clock correction limit reached interrupt flag */
            vuint16_t MXS_IF:1;  /* max sync frames detected interrupt flag */
            vuint16_t MTX_IF:1;  /* media access test symbol received flag */
            vuint16_t LTXB_IF:1; /* pdLatestTx violation on channel B interrupt flag */
            vuint16_t LTXA_IF:1; /* pdLatestTx violation on channel A interrupt flag */
            vuint16_t TBVB_IF:1; /* Transmission across boundary on channel B Interrupt Flag */
            vuint16_t TBVA_IF:1; /* Transmission across boundary on channel A Interrupt Flag */
            vuint16_t TI2_IF:1;  /* timer 2 expired interrupt flag */
            vuint16_t TI1_IF:1;  /* timer 1 expired interrupt flag */
            vuint16_t CYS_IF:1;  /* cycle start interrupt flag */
        } B;
    } PIFR0_t;

    typedef union uPIFR1 {
        vuint16_t R;
        struct {
            vuint16_t EMC_IF:1;  /* error mode changed interrupt flag */
            vuint16_t IPC_IF:1;  /* illegal protocol command interrupt flag */
            vuint16_t PECF_IF:1; /* protocol engine communication failure interrupt flag */
            vuint16_t PSC_IF:1;  /* Protocol State Changed Interrupt Flag */
            vuint16_t SSI3_IF:1; /* slot status counter incremented interrupt flag */
            vuint16_t SSI2_IF:1; /* slot status counter incremented interrupt flag */
            vuint16_t SSI1_IF:1; /* slot status counter incremented interrupt flag */
            vuint16_t SSI0_IF:1; /* slot status counter incremented interrupt flag */
            vuint16_t:2;
            vuint16_t EVT_IF:1;  /* even cycle table written interrupt flag */
            vuint16_t ODT_IF:1;  /* odd cycle table written interrupt flag */
            vuint16_t:4;
        } B;
    } PIFR1_t;

    typedef union uPIER0 {
        vuint16_t R;
        struct {
            vuint16_t FATL_IE:1; /* fatal protocol error interrupt enable */
            vuint16_t INTL_IE:1; /* internal protocol error interrupt interrupt enable  */
            vuint16_t ILCF_IE:1; /* illegal protocol configuration interrupt enable */
            vuint16_t CSA_IE:1;  /* cold start abort interrupt enable */
            vuint16_t MRC_IE:1;  /* missing rate correctio interrupt enable */
            vuint16_t MOC_IE:1;  /* missing offset correctio interrupt enable */
            vuint16_t CCL_IE:1;  /* clock correction limit reached interrupt enable */
            vuint16_t MXS_IE:1;  /* max sync frames detected interrupt enable */
            vuint16_t MTX_IE:1;  /* media access test symbol received interrupt enable */
            vuint16_t LTXB_IE:1; /* pdLatestTx violation on channel B interrupt enable */
            vuint16_t LTXA_IE:1; /* pdLatestTx violation on channel A interrupt enable */
            vuint16_t TBVB_IE:1; /* Transmission across boundary on channel B Interrupt enable */
            vuint16_t TBVA_IE:1; /* Transmission across boundary on channel A Interrupt enable */
            vuint16_t TI2_IE:1;  /* timer 2 expired interrupt enable */
            vuint16_t TI1_IE:1;  /* timer 1 expired interrupt enable */
            vuint16_t CYS_IE:1;  /* cycle start interrupt enable */
        } B;
    } PIER0_t;

    typedef union uPIER1 {
        vuint16_t R;
        struct {
            vuint16_t EMC_IE:1;  /* error mode changed interrupt enable */
            vuint16_t IPC_IE:1;  /* illegal protocol command interrupt enable */
            vuint16_t PECF_IE:1; /* protocol engine communication failure interrupt enable */
            vuint16_t PSC_IE:1;  /* Protocol State Changed Interrupt enable */
            vuint16_t SSI3_IE:1; /* slot status counter incremented interrupt enable */
            vuint16_t SSI2_IE:1; /* slot status counter incremented interrupt enable */
            vuint16_t SSI1_IE:1; /* slot status counter incremented interrupt enable */
            vuint16_t SSI0_IE:1; /* slot status counter incremented interrupt enable */
            vuint16_t:2;
            vuint16_t EVT_IE:1;  /* even cycle table written interrupt enable */
            vuint16_t ODT_IE:1;  /* odd cycle table written interrupt enable */
            vuint16_t:4;
        } B;
    } PIER1_t;

    typedef union uCHIERFR {
        vuint16_t R;
        struct {
            vuint16_t FRLB_EF:1; /* flame lost channel B error flag */
            vuint16_t FRLA_EF:1; /* frame lost channel A error flag */
            vuint16_t PCMI_EF:1; /* command ignored error flag */
            vuint16_t FOVB_EF:1; /* receive FIFO overrun channel B error flag */
            vuint16_t FOVA_EF:1; /* receive FIFO overrun channel A error flag */
            vuint16_t MBS_EF:1;  /* message buffer search error flag */
            vuint16_t MBU_EF:1;  /* message buffer utilization error flag */
            vuint16_t LCK_EF:1;  /* lock error flag */
            vuint16_t DBL_EF:1;  /* double transmit message buffer lock error flag */
            vuint16_t SBCF_EF:1; /* system bus communication failure error flag */
            vuint16_t FID_EF:1;  /* frame ID error flag */
            vuint16_t DPL_EF:1;  /* dynamic payload length error flag */
            vuint16_t SPL_EF:1;  /* static payload length error flag */
            vuint16_t NML_EF:1;  /* network management length error flag */
            vuint16_t NMF_EF:1;  /* network management frame error flag */
            vuint16_t ILSA_EF:1; /* illegal access error flag */
        } B;
    } CHIERFR_t;

    typedef union uMBIVEC {
        vuint16_t R;
        struct {
            vuint16_t:3;
            vuint16_t TBIVEC:5; /* transmit buffer interrupt vector */
            vuint16_t:3;
            vuint16_t RBIVEC:5; /* receive buffer interrupt vector */
        } B;
    } MBIVEC_t;

	typedef union uCASERCR {
        vuint16_t R;
    } CASERCR_t;

    typedef union uCBSERCR {
        vuint16_t R;
    } CBSERCR_t;

	/*protocol Status*/
    typedef union uPSR0 {
        vuint16_t R;
        struct {
            vuint16_t ERRMODE:2;        /* error mode */
            vuint16_t SLOTMODE:2;       /* slot mode */
            vuint16_t:1;
            vuint16_t PROTSTATE:3;      /* protocol state */
            vuint16_t STARTUPSTATE:4;       /* protocol sub state */
            vuint16_t:1;
            vuint16_t WAKEUPSTATUS:3;   /* wakeup status */
        } B;
    } PSR0_t;

    typedef union uPSR1 {
        vuint16_t R;
        struct {
            vuint16_t CSAA:1;   /* cold start attempt abort flag */
            vuint16_t CSP:1;    /* cold start path */
            vuint16_t:1;
            vuint16_t REMCSAT:5;        /* remanining coldstart attempts */
            vuint16_t CPN:1;    /* cold start noise path */
            vuint16_t HHR:1;    /* host halt request pending */
            vuint16_t FRZ:1;    /* freeze occured */
            vuint16_t APTAC:5;  /* allow passive to active counter */
        } B;
    } PSR1_t;

    typedef union uPSR2 {
        vuint16_t R;
        struct {
            vuint16_t NBVB:1;   /* NIT boundary violation on channel B */
            vuint16_t NSEB:1;   /* NIT syntax error on channel B */
            vuint16_t STCB:1;   /* symbol window transmit conflict on channel B */
            vuint16_t SBVB:1;   /* symbol window boundary violation on channel B */
            vuint16_t SSEB:1;   /* symbol window syntax error on channel B */
            vuint16_t MTB:1;    /* media access test symbol MTS received on channel B */
            vuint16_t NBVA:1;   /* NIT boundary violation on channel A */
            vuint16_t NSEA:1;   /* NIT syntax error on channel A */
            vuint16_t STCA:1;   /* symbol window transmit conflict on channel A */
            vuint16_t SBVA:1;   /* symbol window boundary violation on channel A */
            vuint16_t SSEA:1;   /* symbol window syntax error on channel A */
            vuint16_t MTA:1;    /* media access test symbol MTS received on channel A */
            vuint16_t CLKCORRFAILCNT:4; /* clock correction failed counter */
        } B;
    } PSR2_t;

	typedef union uPSR3 {
        vuint16_t R;
        struct {
            vuint16_t:2;
            vuint16_t WUB:1;    /* wakeup symbol received on channel B */
            vuint16_t ABVB:1;   /* aggregated boundary violation on channel B */
            vuint16_t AACB:1;   /* aggregated additional communication on channel B */
            vuint16_t ACEB:1;   /* aggregated content error on channel B */
            vuint16_t ASEB:1;   /* aggregated syntax error on channel B */
            vuint16_t AVFB:1;   /* aggregated valid frame on channel B */
            vuint16_t:2;
            vuint16_t WUA:1;    /* wakeup symbol received on channel A */
            vuint16_t ABVA:1;   /* aggregated boundary violation on channel A */
            vuint16_t AACA:1;   /* aggregated additional communication on channel A */
            vuint16_t ACEA:1;   /* aggregated content error on channel A */
            vuint16_t ASEA:1;   /* aggregated syntax error on channel A */
            vuint16_t AVFA:1;   /* aggregated valid frame on channel A */
        } B;
    } PSR3_t;

    typedef union uMTCTR {
        vuint16_t R;
		struct {
			vuint16_t:2;
			vuint16_t MTCT:14;
		} B;
    } MTCTR_t;
	
	typedef union uCYCTR {
        vuint16_t R;
		struct {
			vuint16_t:10;
			vuint16_t CYCCNT;
		}B;
    } CYCTR_t;
    
    typedef union uSLTCTAR {
        vuint16_t R;
		struct{
			vuint16_t:5;
			vuint16_t SLOTCNTA:11;
		}B;
    } SLTCTAR_t;

    typedef union uSLTCTBR {
        vuint16_t R;
		struct{
			vuint16_t:5;
			vuint16_t SLOTCNTB:11;
		}B;
    } SLTCTBR_t;

    typedef union uRTCORVR {
        vuint16_t R;
    } RTCORVR_t;

    typedef union uOFCORVR {
        vuint16_t R;
    } OFCORVR_t;

    typedef union uCIFRR {
        vuint16_t R;
        struct {
            vuint16_t:8;
            vuint16_t MIF:1;   /* module interrupt flag */
            vuint16_t PRIF:1;  /* protocol interrupt flag */
            vuint16_t CHIF:1;  /* CHI interrupt flag */
            vuint16_t WUPIF:1; /* wakeup interrupt flag */
            vuint16_t FNEBIF:1;        /* receive fifo channel B no empty interrupt flag */
            vuint16_t FNEAIF:1;        /* receive fifo channel A no empty interrupt flag */
            vuint16_t RBIF:1;  /* receive message buffer interrupt flag */
            vuint16_t TBIF:1;  /* transmit buffer interrupt flag */
        } B;
    } CIFRR_t;

	typedef union uSYMATOR {
        vuint16_t R;
        struct {
            vuint16_t:11;  
            vuint16_t TIMEOUT:5;  /* System Memory Access Time-Out */
        } B;
    } SYMATOR_t;

	/*Sync Frame Counter and Tables*/
	typedef union uSFCNTR {
        vuint16_t R;
        struct {
            vuint16_t SFEVB:4;  /* sync frames channel B, even cycle */
            vuint16_t SFEVA:4;  /* sync frames channel A, even cycle */
            vuint16_t SFODB:4;  /* sync frames channel B, odd cycle */
            vuint16_t SFODA:4;  /* sync frames channel A, odd cycle */
        } B;
    } SFCNTR_t;

	typedef union uSFTOR {
        vuint16_t R;
    } SFTOR_t;

    typedef union uSFTCCSR {
        vuint16_t R;
        struct {
            vuint16_t ELKT:1;   /* even cycle tables lock and unlock trigger */
            vuint16_t OLKT:1;   /* odd cycle tables lock and unlock trigger */
            vuint16_t CYCNUM:6; /* cycle number */
            vuint16_t ELKS:1;   /* even cycle tables lock status */
            vuint16_t OLKS:1;   /* odd cycle tables lock status */
            vuint16_t EVAL:1;   /* even cycle tables valid */
            vuint16_t OVAL:1;   /* odd cycle tables valid */
            vuint16_t:1;
            vuint16_t OPT:1;    /*one pair trigger */
            vuint16_t SDVEN:1;  /* sync frame deviation table enable */
            vuint16_t SIDEN:1;  /* sync frame ID table enable */
        } B;
    } SFTCCSR_t;

	/*Sync Frame Filter*/
    typedef union uSFIDRFR {
        vuint16_t R;
        struct {
            vuint16_t:6;
            vuint16_t SYNFRID:10;       /* sync frame rejection ID */
        } B;
    } SFIDRFR_t;

    typedef union uSFIDAFVR {
        vuint16_t R;
		struct {
			vuint16_t:6;
			vuint16_t FVAL:10;
		}B;
    } SFIDAFVR_t;

    typedef union uSFIDAFMR {
        vuint16_t R;
		struct {
			vuint16_t:6;
			vuint16_t FMSK:10;
		}B;
    } SFIDAFMR_t;

	/*Network management Vector*/

    typedef union uNMVR {
        vuint16_t R;
    } NMVR_t;

    typedef union uNMVLR {
        vuint16_t R;
		struct {
			vuint16_t:12;
			vuint16_t NMVL:4;
		}B;
    } NMVLR_t;

	/*Timer Configuration*/
    typedef union uTICCR {
        vuint16_t R;
        struct {
            vuint16_t:2;
            vuint16_t T2_CFG:1;  /* timer 2 configuration */
            vuint16_t T2_REP:1;  /* timer 2 repetitive mode */
            vuint16_t:1;
            vuint16_t T2SP:1;   /* timer 2 stop */
            vuint16_t T2TR:1;   /* timer 2 trigger */
            vuint16_t T2ST:1;   /* timer 2 state */
            vuint16_t:3;
            vuint16_t T1_REP:1;  /* timer 1 repetitive mode */
            vuint16_t:1;
            vuint16_t T1SP:1;   /* timer 1 stop */
            vuint16_t T1TR:1;   /* timer 1 trigger */
            vuint16_t T1ST:1;   /* timer 1 state */
        } B;
    } TICCR_t;

    typedef union uTI1CYSR {
        vuint16_t R;
        struct {
            vuint16_t:2;
            vuint16_t TI1_CYC_VAL:6;      /* timer 1 cycle filter value */
            vuint16_t:2;
            vuint16_t TI1_CYC_MSK:6;      /* timer 1 cycle filter mask */

        } B;
    } TI1CYSR_t;

    typedef union uTI1MTOR {
        vuint16_t R;
		struct {
			vuint16_t:2;
			vuint16_t T1_MTOFFSET:14;
		}B;
    } TI1MTOR_t;

    typedef union uTI2CR0 {
        vuint16_t R;
		struct {
			vuint16_t:2;
			vuint16_t T2_CYC_VAL:6;
			vuint16_t:2;
			vuint16_t T2_CYC_MSK:6;
		}B;//Fields for absolute timer T2 (TICCR[T2_CFG] = 0)
    } TI2CR0_t;

    typedef union uTI2CR1 {
        vuint16_t R;
		struct {
			vuint16_t:2;
			vuint16_t T2_MTOFFSET:14;
		}B;//Fields for absolute timer T2 (TICCR[T2_CFG] = 0)
    } TI2CR1_t;

	/*Slot Status Configuration*/
    typedef union uSSSR {
        vuint16_t R;
        struct {
            vuint16_t WMD:1;    /* write mode */
            vuint16_t:1;
            vuint16_t SEL:2;    /* static slot number */
            vuint16_t:1;
            vuint16_t SLOTNUMBER:11;    /* selector */
        } B;
    } SSSR_t;

    typedef union uSSCCR {
        vuint16_t R;
        struct {
            vuint16_t WMD:1;    /* write mode */
            vuint16_t:1;
            vuint16_t SEL:2;    /* selector */
            vuint16_t:1;
            vuint16_t CNTCFG:2; /* counter configuration */
            vuint16_t MCY:1;    /* multi cycle selection */
            vuint16_t VFR:1;    /* valid frame selection */
            vuint16_t SYF:1;    /* sync frame selection */
            vuint16_t NUF:1;    /* null frame selection  */
            vuint16_t SUF:1;    /* startup frame selection */
            vuint16_t STATUSMASK:4;     /* slot status mask */
        } B;
    } SSCCR_t;

	/*Slot Status*/
    typedef union uSSR {
        vuint16_t R;
        struct {
            vuint16_t VFB:1;    /* valid frame on channel B */
            vuint16_t SYB:1;    /* valid sync frame on channel B */
            vuint16_t NFB:1;    /* valid null frame on channel B */
            vuint16_t SUB:1;    /* valid startup frame on channel B */
            vuint16_t SEB:1;    /* syntax error on channel B */
            vuint16_t CEB:1;    /* content error on channel B */
            vuint16_t BVB:1;    /* boundary violation on channel B */
            vuint16_t TCB:1;    /* tx conflict on channel B */
            vuint16_t VFA:1;    /* valid frame on channel A */
            vuint16_t SYA:1;    /* valid sync frame on channel A */
            vuint16_t NFA:1;    /* valid null frame on channel A */
            vuint16_t SUA:1;    /* valid startup frame on channel A */
            vuint16_t SEA:1;    /* syntax error on channel A */
            vuint16_t CEA:1;    /* content error on channel A */
            vuint16_t BVA:1;    /* boundary violation on channel A */
            vuint16_t TCA:1;    /* tx conflict on channel A */
        } B;
    } SSR_t;

	typedef union uSSCR {
        vuint16_t R;
    } SSCR_t;

	/*MTS Generation*/
    typedef union uMTSCFR {
        vuint16_t R;
        struct {
            vuint16_t MTE:1;    /* media access test symbol transmission enable */
            vuint16_t:1;
            vuint16_t CYCCNTMSK:6;      /* cycle counter mask */
            vuint16_t:2;
            vuint16_t CYCCNTVAL:6;      /* cycle counter value */
        } B;
    } MTSCFR_t;

	/*Shadow Buffer Configuration*/
    typedef union uRSBIR {
        vuint16_t R;
        struct {
            vuint16_t WMD:1;    /* write mode */
            vuint16_t:1;
            vuint16_t SEL:2;    /* selector */
            vuint16_t:6;
            vuint16_t RSBIDX:6; /* receive shadow buffer index */
        } B;
    } RSBIR_t;

	/*Receive FIFO Configuration*/
	typedef union uRFSR {
        vuint16_t R;
		struct {
			vuint16_t:15;
			vuint16_t SEL:1;
		}B;
    } RFSR_t;

    typedef union uRFSIR {
        vuint16_t R;
		struct {
			vuint16_t:6;
			vuint16_t SIDX:10;
		}B;
    } RFSIR_t;

    typedef union uRFDSR {
        vuint16_t R;
        struct {
            vuint16_t FIFO_DEPTH:8;      /* fifo depth */
            vuint16_t:1;
            vuint16_t ENTRY_SIZE:7;      /* entry size */
        } B;
    } RFDSR_t;

	/*Receive FIFO Status*/
	typedef union uRFARIR {
        vuint16_t R;
		struct {
			vuint16_t:6;
			vuint16_t RDIDX:10;
		}B;
    } RFARIR_t;

    typedef union uRFBRIR {
        vuint16_t R;
		struct {
			vuint16_t:6;
			vuint16_t RDIDX:10;
		}B;
    } RFBRIR_t;

	/*Receive FIFO Filter*/
	typedef union uRFMIDAFVR {
        vuint16_t R;
    } RFMIDAFVR_t;

    typedef union uRFMIAFMR {
        vuint16_t R;
    } RFMIAFMR_t;

    typedef union uRFFIDRFVR {
        vuint16_t R;
		struct {
			vuint16_t:5;
			vuint16_t FIDRFVAL:11;
		}B;
    } RFFIDRFVR_t;

    typedef union uRFFIDRFMR {
        vuint16_t R;
		struct {
			vuint16_t:5;
			vuint16_t FIDRFMSK:11;
		}B;
    } RFFIDRFMR_t;

    typedef union uRFRFCFR {
        vuint16_t R;
        struct {
            vuint16_t WMD:1;    /* write mode */
            vuint16_t IBD:1;    /* interval boundary */
            vuint16_t SEL:2;    /* filter number */
            vuint16_t:1;
            vuint16_t SID:11;   /* slot ID */
        } B;
    } RFRFCFR_t;

    typedef union uRFRFCTR {
        vuint16_t R;
        struct {
            vuint16_t:4;
            vuint16_t F3MD:1;   /* filter mode */
            vuint16_t F2MD:1;   /* filter mode */
            vuint16_t F1MD:1;   /* filter mode */
            vuint16_t F0MD:1;   /* filter mode */
              vuint16_t:4;
            vuint16_t F3EN:1;   /* filter enable */
            vuint16_t F2EN:1;   /* filter enable */
            vuint16_t F1EN:1;   /* filter enable */
            vuint16_t F0EN:1;   /* filter enable */
        } B;
    } RFRFCTR_t;

	/*Dynamic Segment Status*/
	typedef union uLDTXSLAR {
        vuint16_t R;
		struct {
			vuint16_t:5;
			vuint16_t LASTDYNTXSLOTA:11;
		}B;
    } LDTXSLAR_t;

    typedef union uLDTXSLBR {
        vuint16_t R;
		struct {
			vuint16_t:5;
			vuint16_t LASTDYNTXSLOTB:11;
		}B;
    } LDTXSLBR_t;

	/*Protocol Configutarion*/
    typedef union uPCR0 {
        vuint16_t R;
        struct {
            vuint16_t ACTION_POINT_OFFSET:6;
            vuint16_t STATIC_SLOT_LENGTH:10;
        } B;
    } PCR0_t;

    typedef union uPCR1 {
        vuint16_t R;
        struct {
            vuint16_t:2;
            vuint16_t MACRO_AFTER_FIRST_STATIC_SLOT:14;
        } B;
    } PCR1_t;

    typedef union uPCR2 {
        vuint16_t R;
        struct {
            vuint16_t MINISLOT_AFTER_ACTION_POINT:6;
            vuint16_t NUMBER_OF_STATIC_SLOTS:10;
        } B;
    } PCR2_t;

    typedef union uPCR3 {
        vuint16_t R;
        struct {
            vuint16_t WAKEUP_SYMBOL_RX_LOW:6;
            vuint16_t MINISLOT_ACTION_POINT_OFFSET:5;
            vuint16_t COLDSTART_ATTEMPTS:5;
        } B;
    } PCR3_t;

    typedef union uPCR4 {
        vuint16_t R;
        struct {
            vuint16_t CAS_RX_LOW_MAX:7;
            vuint16_t WAKEUP_SYMBOL_RX_WINDOW:9;
        } B;
    } PCR4_t;

    typedef union uPCR5 {
        vuint16_t R;
        struct {
            vuint16_t TSS_TRANSMITTER:4;
            vuint16_t WAKEUP_SYMBOL_TX_LOW:6;
            vuint16_t WAKEUP_SYMBOL_RX_IDLE:6;
        } B;
    } PCR5_t;

    typedef union uPCR6 {
        vuint16_t R;
        struct {
            vuint16_t:1;
            vuint16_t SYMBOL_WINDOW_AFTER_ACTION_POINT:8;
            vuint16_t MACRO_INITIAL_OFFSET_A:7;
        } B;
    } PCR6_t;

    typedef union uPCR7 {
        vuint16_t R;
        struct {
            vuint16_t DECODING_CORRECTION_B:9;
            vuint16_t MICRO_PER_MACRO_NOM_HALF:7;
        } B;
    } PCR7_t;

    typedef union uPCR8 {
        vuint16_t R;
        struct {
            vuint16_t MAX_WITHOUT_CLOCK_CORRECTION_FATAL:4;
            vuint16_t MAX_WITHOUT_CLOCK_CORRECTION_PASSIVE:4;
            vuint16_t WAKEUP_SYMBOL_TX_IDLE:8;
        } B;
    } PCR8_t;

    typedef union uPCR9 {
        vuint16_t R;
        struct {
            vuint16_t MINISLOT_EXISTS:1;
            vuint16_t SYMBOL_WINDOW_EXISTS:1;
            vuint16_t OFFSET_CORRECTION_OUT:14;
        } B;
    } PCR9_t;

    typedef union uPCR10 {
        vuint16_t R;
        struct {
            vuint16_t SINGLE_SLOT_ENABLED:1;
            vuint16_t WAKEUP_CHANNEL:1;
            vuint16_t MACRO_PER_CYCLE:14;
        } B;
    } PCR10_t;

    typedef union uPCR11 {
        vuint16_t R;
        struct {
            vuint16_t KEY_SLOT_USED_FOR_STARTUP:1;
            vuint16_t KEY_SLOT_USED_FOR_SYNC:1;
            vuint16_t OFFSET_CORRECTION_START:14;
        } B;
    } PCR11_t;

    typedef union uPCR12 {
        vuint16_t R;
        struct {
            vuint16_t ALLOW_PASSIVE_TO_ACTIVE:5;
            vuint16_t KEY_SLOT_HEADER_CRC:11;
        } B;
    } PCR12_t;

    typedef union uPCR13 {
        vuint16_t R;
        struct {
            vuint16_t FIRST_MINISLOT_ACTION_POINT_OFFSET:6;
            vuint16_t STATIC_SLOT_AFTER_ACTION_POINT:10;
        } B;
    } PCR13_t;

    typedef union uPCR14 {
        vuint16_t R;
        struct {
            vuint16_t RATE_CORRECTION_OUT:11;
            vuint16_t LISTEN_TIMEOUT_H:5;
        } B;
    } PCR14_t;

    typedef union uPCR15 {
        vuint16_t R;
        struct {
            vuint16_t LISTEN_TIMEOUT_L:16;
        } B;
    } PCR15_t;

    typedef union uPCR16 {
        vuint16_t R;
        struct {
            vuint16_t MACRO_INITIAL_OFFSET_B:7;
            vuint16_t NOISE_LISTEN_TIMEOUT_H:9;
        } B;
    } PCR16_t;

    typedef union uPCR17 {
        vuint16_t R;
        struct {
            vuint16_t NOISE_LISTEN_TIMEOUT_L:16;
        } B;
    } PCR17_t;

    typedef union uPCR18 {
        vuint16_t R;
        struct {
            vuint16_t WAKEUP_PATTERN:6;
            vuint16_t KEY_SLOT_ID:10;
        } B;
    } PCR18_t;

    typedef union uPCR19 {
        vuint16_t R;
        struct {
            vuint16_t DECODING_CORRECTION_A:9;
            vuint16_t PAYLOAD_LENGTH_STATIC:7;
        } B;
    } PCR19_t;

    typedef union uPCR20 {
        vuint16_t R;
        struct {
            vuint16_t MICRO_INITIAL_OFFSET_B:8;
            vuint16_t MICRO_INITIAL_OFFSET_A:8;
        } B;
    } PCR20_t;

    typedef union uPCR21 {
        vuint16_t R;
        struct {
            vuint16_t EXTERN_RATE_CORRECTION:3;
            vuint16_t LATEST_TX:13;
        } B;
    } PCR21_t;

    typedef union uPCR22 {
        vuint16_t R;
        struct {
            vuint16_t:1;
            vuint16_t COMP_ACCEPTED_STARTUP_RANGE_A:11;
            vuint16_t MICRO_PER_CYCLE_H:4;
        } B;
    } PCR22_t;

    typedef union uPCR23 {
        vuint16_t R;
        struct {
            vuint16_t micro_per_cycle_l:16;
        } B;
    } PCR23_t;

    typedef union uPCR24 {
        vuint16_t R;
        struct {
            vuint16_t CLUSTER_DRIFT_DAMPING:5;
            vuint16_t MAX_PAYLOAD_LENGTH_DYNAMIC:7;
            vuint16_t MICRO_PER_CYCLE_MIN_H:4;
        } B;
    } PCR24_t;

    typedef union uPCR25 {
        vuint16_t R;
        struct {
            vuint16_t MICRO_PER_CYCLE_MIN_L:16;
        } B;
    } PCR25_t;

    typedef union uPCR26 {
        vuint16_t R;
        struct {
            vuint16_t ALLOW_HALT_DUE_TO_CLOCK:1;
            vuint16_t COMP_ACCEPTED_STARTUP_RANGE_B:11;
            vuint16_t MICRO_PER_CYCLE_MAX_H:4;
        } B;
    } PCR26_t;

    typedef union uPCR27 {
        vuint16_t R;
        struct {
            vuint16_t MICRO_PER_CYCLE_MAX_L:16;
        } B;
    } PCR27_t;

    typedef union uPCR28 {
        vuint16_t R;
        struct {
            vuint16_t DYNAMIC_SLOT_IDLE_PHASE:2;
            vuint16_t MACRO_AFTER_OFFSET_CORRECTION:14;
        } B;
    } PCR28_t;

    typedef union uPCR29 {
        vuint16_t R;
        struct {
            vuint16_t EXTERN_OFFSET_CORRECTION:3;
            vuint16_t MINISLOTS_MAX:13;
        } B;
    } PCR29_t;

    typedef union uPCR30 {
        vuint16_t R;
        struct {
            vuint16_t:12;
            vuint16_t SYNC_NODE_MAX:4;
        } B;
    } PCR30_t;

	typedef union uPCR {
        struct {
            vuint16_t ACTION_POINT_OFFSET:6;
            vuint16_t STATIC_SLOT_LENGTH:10;
            vuint16_t:2;
            vuint16_t MACRO_AFTER_FIRST_STATIC_SLOT:14;
            vuint16_t MINISLOT_AFTER_ACTION_POINT:6;
            vuint16_t NUMBER_OF_STATIC_SLOTS:10;
            vuint16_t WAKEUP_SYMBOL_RX_LOW:6;
            vuint16_t MINISLOT_ACTION_POINT_OFFSET:5;
            vuint16_t COLDSTART_ATTEMPTS:5;
            vuint16_t CAS_RX_LOW_MAX:7;
            vuint16_t WAKEUP_SYMBOL_RX_WINDOW:9;
            vuint16_t TSS_TRANSMITTER:4;
            vuint16_t WAKEUP_SYMBOL_TX_LOW:6;
            vuint16_t WAKEUP_SYMBOL_RX_IDLE:6;
            vuint16_t:1;
            vuint16_t SYMBOL_WINDOW_AFTER_ACTION_POINT:8;
            vuint16_t MACRO_INITIAL_OFFSET_A:7;
            vuint16_t DECODING_CORRECTION_B:9;
            vuint16_t MICRO_PER_MACRO_NOM_HALF:7;
            vuint16_t MAX_WITHOUT_CLOCK_CORRECTION_FATAL:4;
            vuint16_t MAX_WITHOUT_CLOCK_CORRECTION_PASSIVE:4;
            vuint16_t WAKEUP_SYMBOL_TX_IDLE:8;
            vuint16_t MINISLOT_EXISTS:1;
            vuint16_t SYMBOL_WINDOW_EXISTS:1;
            vuint16_t OFFSET_CORRECTION_OUT:14;
            vuint16_t SINGLE_SLOT_ENABLED:1;
            vuint16_t WAKEUP_CHANNEL:1;
            vuint16_t MACRO_PER_CYCLE:14;
            vuint16_t KEY_SLOT_USED_FOR_STARTUP:1;
            vuint16_t KEY_SLOT_USED_FOR_SYNC:1;
            vuint16_t OFFSET_CORRECTION_START:14;
            vuint16_t ALLOW_PASSIVE_TO_ACTIVE:5;
            vuint16_t KEY_SLOT_HEADER_CRC:11;
            vuint16_t FIRST_MINISLOT_ACTION_POINT_OFFSET:6;
            vuint16_t STATIC_SLOT_AFTER_ACTION_POINT:10;
            vuint16_t RATE_CORRECTION_OUT:11;
            vuint32_t LISTEN_TIMEOUT:21;
            vuint16_t MACRO_INITIAL_OFFSET_B:7;
            vuint32_t NOISE_LISTEN_TIMEOUT:25;
            vuint16_t WAKEUP_PATTERN:6;
            vuint16_t KEY_SLOT_ID:10;
            vuint16_t DECODING_CORRECTION_A:9;
            vuint16_t PAYLOAD_LENGTH_STATIC:7;
            vuint16_t MICRO_INITIAL_OFFSET_B:8;
            vuint16_t MICRO_INITIAL_OFFSET_A:8;
            vuint16_t EXTERN_RATE_CORRECTION:3;
            vuint16_t LATEST_TX:13;
            vuint16_t:1;
            vuint16_t COMP_ACCEPTED_STARTUP_RANGE_A:11;
            vuint32_t MICRO_PER_CYCLE:20;
            vuint16_t CLUSTER_DRIFT_DAMPING:5;
            vuint16_t MAX_PAYLOAD_LENGTH_DYNAMIC:7;
            vuint32_t MICRO_PER_CYCLE_MIN:20;
            vuint16_t ALLOW_HALT_DUE_TO_CLOCK:1;
            vuint16_t COMP_ACCEPTED_STARTUP_RANGE_B:11;
            vuint32_t MICRO_PER_CYCLE_MAX:20;
            vuint16_t DYNAMIC_SLOT_IDLE_PHASE:2;
            vuint16_t MACRO_AFTER_OFFSET_CORRECTION:14;
            vuint16_t EXTERN_OFFSET_CORRECTION:3;
            vuint16_t MINISLOTS_MAX:13;
            vuint16_t:12;
            vuint16_t SYNC_NODE_MAX:4;
        } B;
    } PCR_t;

	/*Message Buffers Configuration, Control, Status*/
    typedef struct uMSG_BUFF_CCS {
        union {
            vuint16_t R;
            struct {
                vuint16_t:1;
                vuint16_t MCM:1;        /* message buffer commit mode */
                vuint16_t MBT:1;        /* message buffer type */
                vuint16_t MTD:1;        /* message buffer direction */
                vuint16_t CMT:1;        /* commit for transmission */
                vuint16_t EDT:1;        /* enable / disable trigger */
                vuint16_t LCKT:1;       /* lock request trigger */
                vuint16_t MBIE:1;       /* message buffer interrupt enable */
                  vuint16_t:3;
                vuint16_t DUP:1;        /* data updated  */
                vuint16_t DVAL:1;       /* data valid */
                vuint16_t EDS:1;        /* lock status */
                vuint16_t LCKS:1;       /* enable / disable status */
                vuint16_t MBIF:1;       /* message buffer interrupt flag */
            } B;
        } MBCCSR;
        union {
            vuint16_t R;
            struct {
                vuint16_t MTM:1;        /* message buffer transmission mode */
                vuint16_t CHA:1;      /* channel assignement */
                vuint16_t CHB:1;      /* channel assignement */
                vuint16_t CCFE:1;       /* cycle counter filter enable */
                vuint16_t CCFMSK:6;     /* cycle counter filter mask */
                vuint16_t CCFVAL:6;     /* cycle counter filter value */
            } B;
        } MBCCFR;
        union {
            vuint16_t R;
            struct {
                vuint16_t:5;
                vuint16_t FID:11;       /* frame ID */
            } B;
        } MBFIDR;
        union {
            vuint16_t R;
            struct {
                vuint16_t:10;
                vuint16_t MBIDX:6;      /* message buffer index */
            } B;
        } MBIDXR;
    } MSG_BUFF_CCS_t;

    typedef struct FR_tag {
		/*Module Configuration and Control*/
        volatile MVR_t MVR;     /*module version register *//*0  */
        volatile MCR_t MCR;     /*module configuration register *//*2  */
        volatile SYMBADHR_t SYMBADHR;   /*system memory base address high register *//*4        */
        volatile SYMBADLR_t SYMBADLR;   /*system memory base address low register *//*6         */
        volatile STBSCR_t STBSCR;       /*strobe signal control register *//*8      */
        vuint16_t FR_Reserved1[1];
        volatile MBDSR_t MBDSR; /*message buffer data size register *//*C  */
        volatile MBSSUTR_t MBSSUTR;     /*message buffer segment size and utilization register *//*E  */
		vuint16_t FR_Reserved2[2];
		/*Interrupt and Error Handling*/
        volatile POCR_t POCR;   /*Protocol operation control register *//*14 */
        volatile GIFER_t GIFER; /*global interrupt flag and enable register *//*16 */
        volatile PIFR0_t PIFR0; /*protocol interrupt flag register 0 *//*18 */
        volatile PIFR1_t PIFR1; /*protocol interrupt flag register 1 *//*1A */
        volatile PIER0_t PIER0; /*protocol interrupt enable register 0 *//*1C */
        volatile PIER1_t PIER1; /*protocol interrupt enable register 1 *//*1E */
        volatile CHIERFR_t CHIERFR;     /*CHI error flag register *//*20 */
        volatile MBIVEC_t MBIVEC;       /*message buffer interrupt vector register *//*22 */
        volatile CASERCR_t CASERCR;     /*channel A status error counter register *//*24 */
        volatile CBSERCR_t CBSERCR;     /*channel B status error counter register *//*26 */
		/*Protocol Status*/
        volatile PSR0_t PSR0;   /*protocol status register 0 *//*28 */
        volatile PSR1_t PSR1;   /*protocol status register 1 *//*2A */
        volatile PSR2_t PSR2;   /*protocol status register 2 *//*2C */
        volatile PSR3_t PSR3;   /*protocol status register 3 *//*2E */
        volatile MTCTR_t MTCTR; /*macrotick counter register *//*30 */
        volatile CYCTR_t CYCTR; /*cycle counter register *//*32 */
        volatile SLTCTAR_t SLTCTAR;     /*slot counter channel A register *//*34 */
        volatile SLTCTBR_t SLTCTBR;     /*slot counter channel B register *//*36 */
        volatile RTCORVR_t RTCORVR;     /*rate correction value register *//*38 */
        volatile OFCORVR_t OFCORVR;     /*offset correction value register *//*3A */
        volatile CIFRR_t CIFRR; /*combined interrupt flag register *//*3C */
        volatile SYMATOR_t SYMATOR;
		/*Sync Frame Counter and Tables*/
        volatile SFCNTR_t SFCNTR;       /*sync frame counter register *//*40 */
        volatile SFTOR_t SFTOR; /*sync frame table offset register *//*42 */
        volatile SFTCCSR_t SFTCCSR;     /*sync frame table configuration, control, status register *//*44 */
		/*Sync Frame Filter*/
        volatile SFIDRFR_t SFIDRFR;     /*sync frame ID rejection filter register *//*46 */
        volatile SFIDAFVR_t SFIDAFVR;   /*sync frame ID acceptance filter value regiater *//*48 */
        volatile SFIDAFMR_t SFIDAFMR;   /*sync frame ID acceptance filter mask register *//*4A */
		/*Network Management vector*/
        volatile NMVR_t NMVR[6];        /*network management vector registers (12 bytes) *//*4C */
        volatile NMVLR_t NMVLR; /*network management vector length register *//*58 */
		/*Timer Configuration*/
        volatile TICCR_t TICCR; /*timer configuration and control register *//*5A */
        volatile TI1CYSR_t TI1CYSR;     /*timer 1 cycle set register *//*5C */
        volatile TI1MTOR_t TI1MTOR;       /*timer 1 macrotick offset register *//*5E */
        volatile TI2CR0_t TI2CR0;       /*timer 2 configuration register 0 *//*60 */
        volatile TI2CR1_t TI2CR1;       /*timer 2 configuration register 1 *//*62 */
		/*Slot Status Configuration*/
        volatile SSSR_t SSSR;   /*slot status selection register *//*64 */
        volatile SSCCR_t SSCCR; /*slot status counter condition register *//*66 */
		/*Slot Status*/
        volatile SSR_t SSR[8];  /*slot status registers 0-7 *//*68 */
        volatile SSCR_t SSCR[4];        /*slot status counter registers 0-3 *//*78 */
		/*MTS Generation*/
        volatile MTSCFR_t MTSACFR;      /*mts a config register *//*80 */
        volatile MTSCFR_t MTSBCFR;      /*mts b config register *//*82 */
		/*Shadow Buffer Configuration*/
        volatile RSBIR_t RSBIR; /*receive shadow buffer index register *//*84 */
		/*Receive FIFO Configuration*/
        volatile RFSR_t RFSR;   /*receive fifo selection register *//*86 */
        volatile RFSIR_t RFSIR; /*receive fifo start index register *//*88 */
        volatile RFDSR_t RFDSR; /*receive fifo depth and size register *//*8A */
		/*Receive FIFO Status*/
        volatile RFARIR_t RFARIR;       /*receive fifo a read index register *//*8C */
        volatile RFBRIR_t RFBRIR;       /*receive fifo b read index register *//*8E */
		/*Receive FIFO Filter*/
        volatile RFMIDAFVR_t RFMIDAFVR; /*receive fifo message ID acceptance filter value register *//*90 */
        volatile RFMIAFMR_t RFMIAFMR;   /*receive fifo message ID acceptance filter mask register *//*92 */
        volatile RFFIDRFVR_t RFFIDRFVR; /*receive fifo frame ID rejection filter value register *//*94 */
        volatile RFFIDRFMR_t RFFIDRFMR; /*receive fifo frame ID rejection filter mask register *//*96 */
        volatile RFRFCFR_t RFRFCFR;     /*receive fifo range filter configuration register *//*98 */
        volatile RFRFCTR_t RFRFCTR;     /*receive fifo range filter control register *//*9A */
		/*Dynamic Segment Status*/
        volatile LDTXSLAR_t LDTXSLAR;   /*last dynamic transmit slot channel A register *//*9C */
        volatile LDTXSLBR_t LDTXSLBR;   /*last dynamic transmit slot channel B register *//*9E */
		/*Protocol Configuration*/
		volatile PCR_t PCR; //this or PCR0 - PCR30
        //volatile PCR0_t PCR0;   /*protocol configuration register 0 *//*A0 */
        //volatile PCR1_t PCR1;   /*protocol configuration register 1 *//*A2 */
        //volatile PCR2_t PCR2;   /*protocol configuration register 2 *//*A4 */
        //volatile PCR3_t PCR3;   /*protocol configuration register 3 *//*A6 */
        //volatile PCR4_t PCR4;   /*protocol configuration register 4 *//*A8 */
        //volatile PCR5_t PCR5;   /*protocol configuration register 5 *//*AA */
        //volatile PCR6_t PCR6;   /*protocol configuration register 6 *//*AC */
        //volatile PCR7_t PCR7;   /*protocol configuration register 7 *//*AE */
        //volatile PCR8_t PCR8;   /*protocol configuration register 8 *//*B0 */
        //volatile PCR9_t PCR9;   /*protocol configuration register 9 *//*B2 */
        //volatile PCR10_t PCR10; /*protocol configuration register 10 *//*B4 */
        //volatile PCR11_t PCR11; /*protocol configuration register 11 *//*B6 */
        //volatile PCR12_t PCR12; /*protocol configuration register 12 *//*B8 */
        //volatile PCR13_t PCR13; /*protocol configuration register 13 *//*BA */
        //volatile PCR14_t PCR14; /*protocol configuration register 14 *//*BC */
        //volatile PCR15_t PCR15; /*protocol configuration register 15 *//*BE */
        //volatile PCR16_t PCR16; /*protocol configuration register 16 *//*C0 */
        //volatile PCR17_t PCR17; /*protocol configuration register 17 *//*C2 */
        //volatile PCR18_t PCR18; /*protocol configuration register 18 *//*C4 */
        //volatile PCR19_t PCR19; /*protocol configuration register 19 *//*C6 */
        //volatile PCR20_t PCR20; /*protocol configuration register 20 *//*C8 */
        //volatile PCR21_t PCR21; /*protocol configuration register 21 *//*CA */
        //volatile PCR22_t PCR22; /*protocol configuration register 22 *//*CC */
        //volatile PCR23_t PCR23; /*protocol configuration register 23 *//*CE */
        //volatile PCR24_t PCR24; /*protocol configuration register 24 *//*D0 */
        //volatile PCR25_t PCR25; /*protocol configuration register 25 *//*D2 */
        //volatile PCR26_t PCR26; /*protocol configuration register 26 *//*D4 */
        //volatile PCR27_t PCR27; /*protocol configuration register 27 *//*D6 */
        //volatile PCR28_t PCR28; /*protocol configuration register 28 *//*D8 */
        //volatile PCR29_t PCR29; /*protocol configuration register 29 *//*DA */
        //volatile PCR30_t PCR30; /*protocol configuration register 30 *//*DC */
		vuint16_t FR_Reserved3[17];
        volatile MSG_BUFF_CCS_t MB[32];     /* message buffer configuration, control & status registers 0-31 *//*100 */
    } FR_tag_t;

    typedef union uF_HEADER     /* frame header */
    {
		vuint16_t WORDS[3];
        struct {
			vuint16_t:1;
            vuint16_t PPI:1;    /* Payload Preamble Indicator */
            vuint16_t NUF:1;    /* Null Frame Indicator */
            vuint16_t SYF:1;    /* Sync Frame Indicator */
            vuint16_t SUF:1;    /* Startup Frame Indicator */
            vuint16_t FID:11;   /* Frame ID */
			vuint16_t:2;
            vuint16_t CYCCNT:6; /* Cycle Count */
            vuint16_t:1;
            vuint16_t PLDLEN:7; /* Payload Length */
            vuint16_t:5;
            vuint16_t HDCRC:11; /* Header CRC */
        } B;
    } F_HEADER_t;

    typedef union uS_STSTUS     /* slot status */
    {
        struct {
            vuint16_t VFB:1;    /* Valid Frame on channel B */
            vuint16_t SYB:1;    /* Sync Frame Indicator channel B */
            vuint16_t NFB:1;    /* Null Frame Indicator channel B */
            vuint16_t SUB:1;    /* Startup Frame Indicator channel B */
            vuint16_t SEB:1;    /* Syntax Error on channel B */
            vuint16_t CEB:1;    /* Content Error on channel B */
            vuint16_t BVB:1;    /* Boundary Violation on channel B */
            vuint16_t CH:1;     /* Channel */
            vuint16_t VFA:1;    /* Valid Frame on channel A */
            vuint16_t SYA:1;    /* Sync Frame Indicator channel A */
            vuint16_t NFA:1;    /* Null Frame Indicator channel A */
            vuint16_t SUA:1;    /* Startup Frame Indicator channel A */
            vuint16_t SEA:1;    /* Syntax Error on channel A */
            vuint16_t CEA:1;    /* Content Error on channel A */
            vuint16_t BVA:1;    /* Boundary Violation on channel A */
            vuint16_t:1;
        } RX;
        struct {
            vuint16_t VFB:1;    /* Valid Frame on channel B */
            vuint16_t SYB:1;    /* Sync Frame Indicator channel B */
            vuint16_t NFB:1;    /* Null Frame Indicator channel B */
            vuint16_t SUB:1;    /* Startup Frame Indicator channel B */
            vuint16_t SEB:1;    /* Syntax Error on channel B */
            vuint16_t CEB:1;    /* Content Error on channel B */
            vuint16_t BVB:1;    /* Boundary Violation on channel B */
            vuint16_t TCB:1;    /* Tx Conflict on channel B */
            vuint16_t VFA:1;    /* Valid Frame on channel A */
            vuint16_t SYA:1;    /* Sync Frame Indicator channel A */
            vuint16_t NFA:1;    /* Null Frame Indicator channel A */
            vuint16_t SUA:1;    /* Startup Frame Indicator channel A */
            vuint16_t SEA:1;    /* Syntax Error on channel A */
            vuint16_t CEA:1;    /* Content Error on channel A */
            vuint16_t BVA:1;    /* Boundary Violation on channel A */
            vuint16_t TCA:1;    /* Tx Conflict on channel A */
        } TX;
        vuint16_t R;
    } S_STATUS_t;

    typedef struct uMB_HEADER   /* message buffer header */
    {
        F_HEADER_t FRAME_HEADER;
        vuint16_t DATA_OFFSET;
        S_STATUS_t SLOT_STATUS;
    } MB_HEADER_t;

/****************************************************************************/
/*                     MODULE : DFLASH                                       */
/****************************************************************************/
    struct DFLASH_tag {
        union {                 /* Module Configuration Register */
            vuint32_t R;
            struct {
                vuint32_t EDC:1;
                vuint32_t:4;
                vuint32_t SIZE:3;
                  vuint32_t:1;
                vuint32_t LAS:3;
                  vuint32_t:3;
                vuint32_t MAS:1;
                vuint32_t EER:1;
                vuint32_t RWE:1;
                  vuint32_t:2;
                vuint32_t PEAS:1;
                vuint32_t DONE:1;
                vuint32_t PEG:1;
                  vuint32_t:4;
                vuint32_t PGM:1;
                vuint32_t PSUS:1;
                vuint32_t ERS:1;
                vuint32_t ESUS:1;
                vuint32_t EHV:1;
            } B;
        } MCR;

        union {                 /* LML Register */
            vuint32_t R;
            struct {
                vuint32_t LME:1;
                vuint32_t:10;
                vuint32_t TSLK:1;
                vuint32_t:16;
				vuint32_t LLK3:1;
				vuint32_t LLK2:1;
				vuint32_t LLK1:1;
                vuint32_t LLK0:1;
            } B;
        } LML;

        int32_t Dflash_reserved0[1];

        union {                 /* SLML Register */
            vuint32_t R;
            struct {
                vuint32_t SLE:1;
                  vuint32_t:10;
                vuint32_t STSLK:1;
                  vuint32_t:16;
				vuint32_t SLK3:1;
				vuint32_t SLK2:1;
				vuint32_t SLK1:1;
                vuint32_t SLK0:1;
            } B;
        } SLL;

        union {                 /* LMS Register */
            vuint32_t R;
            struct {
                vuint32_t:28;
                vuint32_t LSL3:1;
				vuint32_t LSL2:1;
				vuint32_t LSL1:1;
				vuint32_t LSL0:1;
            } B;
        } LMS;

        int32_t Dflash_reserved1[1];

        union {                 /* Address Register */
            vuint32_t R;
            struct {
                vuint32_t:9;
                vuint32_t ADD:20;
                vuint32_t:3;
            } B;
        } ADR;

        int32_t Dflash_reserved2[8];    /* {0x003C-0x001C}/0x4 = 0x08 */

        union {                 /* User Test Register 0 */
            vuint32_t R;
            struct {
                vuint32_t UTE:1;
                vuint32_t:7;
                vuint32_t DSI7:1;
				vuint32_t DSI6:1;
				vuint32_t DSI5:1;
				vuint32_t DSI4:1;
				vuint32_t DSI3:1;
				vuint32_t DSI2:1;
				vuint32_t DSI1:1;
				vuint32_t DSI0:1;
                vuint32_t:10;
                vuint32_t MRE:1;
                vuint32_t MRV:1;
                vuint32_t EIE:1;
                vuint32_t AIS:1;
                vuint32_t AIE:1;
                vuint32_t AID:1;
            } B;
        } UT0;

        union {                 /* User Test Register 1 */
            vuint32_t R;
            struct {
                vuint32_t DAI31:1;
				vuint32_t DAI30:1;
				vuint32_t DAI29:1;
				vuint32_t DAI28:1;
				vuint32_t DAI27:1;
				vuint32_t DAI26:1;
				vuint32_t DAI25:1;
				vuint32_t DAI24:1;
				vuint32_t DAI23:1;
				vuint32_t DAI22:1;
				vuint32_t DAI21:1;
				vuint32_t DAI20:1;
				vuint32_t DAI19:1;
				vuint32_t DAI18:1;
				vuint32_t DAI17:1;
				vuint32_t DAI16:1;
				vuint32_t DAI15:1;
				vuint32_t DAI14:1;
				vuint32_t DAI13:1;
				vuint32_t DAI12:1;
				vuint32_t DAI11:1;
				vuint32_t DAI10:1;
				vuint32_t DAI9:1;
				vuint32_t DAI8:1;
				vuint32_t DAI7:1;
				vuint32_t DAI6:1;
				vuint32_t DAI5:1;
				vuint32_t DAI4:1;
				vuint32_t DAI3:1;
				vuint32_t DAI2:1;
				vuint32_t DAI1:1;
				vuint32_t DAI0:1;
            } B;
        } UT1;

        union {                 /* User Test Register 2 */
            vuint32_t R;
            struct {
                vuint32_t DAI63:1;
				vuint32_t DAI62:1;
				vuint32_t DAI61:1;
				vuint32_t DAI60:1;
				vuint32_t DAI59:1;
				vuint32_t DAI58:1;
				vuint32_t DAI57:1;
				vuint32_t DAI56:1;
				vuint32_t DAI55:1;
				vuint32_t DAI54:1;
				vuint32_t DAI53:1;
				vuint32_t DAI52:1;
				vuint32_t DAI51:1;
				vuint32_t DAI50:1;
				vuint32_t DAI49:1;
				vuint32_t DAI48:1;
				vuint32_t DAI47:1;
				vuint32_t DAI46:1;
				vuint32_t DAI45:1;
				vuint32_t DAI44:1;
				vuint32_t DAI43:1;
				vuint32_t DAI42:1;
				vuint32_t DAI41:1;
				vuint32_t DAI40:1;
				vuint32_t DAI39:1;
				vuint32_t DAI38:1;
				vuint32_t DAI37:1;
				vuint32_t DAI36:1;
				vuint32_t DAI35:1;
				vuint32_t DAI34:1;
				vuint32_t DAI33:1;
				vuint32_t DAI32:1;
            } B;
        } UT2;

        union {                 /* User Multiple Input Signature Register 0 */
            vuint32_t R;
            struct {
                vuint32_t MS031:1;
				vuint32_t MS030:1;
				vuint32_t MS029:1;
				vuint32_t MS028:1;
				vuint32_t MS027:1;
				vuint32_t MS026:1;
				vuint32_t MS025:1;
				vuint32_t MS024:1;
				vuint32_t MS023:1;
				vuint32_t MS022:1;
				vuint32_t MS021:1;
				vuint32_t MS020:1;
				vuint32_t MS019:1;
				vuint32_t MS018:1;
				vuint32_t MS017:1;
				vuint32_t MS016:1;
				vuint32_t MS015:1;
				vuint32_t MS014:1;
				vuint32_t MS013:1;
				vuint32_t MS012:1;
				vuint32_t MS011:1;
				vuint32_t MS010:1;
				vuint32_t MS009:1;
				vuint32_t MS008:1;
				vuint32_t MS007:1;
				vuint32_t MS006:1;
				vuint32_t MS005:1;
				vuint32_t MS004:1;
				vuint32_t MS003:1;
				vuint32_t MS002:1;
				vuint32_t MS001:1;
				vuint32_t MS000:1;
            } B;
        } UMISR0;

		union {                 /* User Multiple Input Signature Register 1 */
            vuint32_t R;
            struct {
				vuint32_t MS063:1;
				vuint32_t MS062:1;
                vuint32_t MS061:1;
				vuint32_t MS060:1;
				vuint32_t MS059:1;
				vuint32_t MS058:1;
				vuint32_t MS057:1;
				vuint32_t MS056:1;
				vuint32_t MS055:1;
				vuint32_t MS054:1;
				vuint32_t MS053:1;
				vuint32_t MS052:1;
				vuint32_t MS051:1;
				vuint32_t MS050:1;
				vuint32_t MS049:1;
				vuint32_t MS048:1;
				vuint32_t MS047:1;
				vuint32_t MS046:1;
				vuint32_t MS045:1;
				vuint32_t MS044:1;
				vuint32_t MS043:1;
				vuint32_t MS042:1;
				vuint32_t MS041:1;
				vuint32_t MS040:1;
				vuint32_t MS039:1;
				vuint32_t MS038:1;
				vuint32_t MS037:1;
				vuint32_t MS036:1;
				vuint32_t MS035:1;
				vuint32_t MS034:1;
				vuint32_t MS033:1;
				vuint32_t MS032:1;
            } B;
        } UMISR1;

		union {                 /* User Multiple Input Signature Register 2 */
            vuint32_t R;
            struct {
				vuint32_t MS095:1;
				vuint32_t MS094:1;
				vuint32_t MS093:1;
				vuint32_t MS092:1;
                vuint32_t MS091:1;
				vuint32_t MS090:1;
				vuint32_t MS089:1;
				vuint32_t MS088:1;
				vuint32_t MS087:1;
				vuint32_t MS086:1;
				vuint32_t MS085:1;
				vuint32_t MS084:1;
				vuint32_t MS083:1;
				vuint32_t MS082:1;
				vuint32_t MS081:1;
				vuint32_t MS080:1;
				vuint32_t MS079:1;
				vuint32_t MS078:1;
				vuint32_t MS077:1;
				vuint32_t MS076:1;
				vuint32_t MS075:1;
				vuint32_t MS074:1;
				vuint32_t MS073:1;
				vuint32_t MS072:1;
				vuint32_t MS071:1;
				vuint32_t MS070:1;
				vuint32_t MS069:1;
				vuint32_t MS068:1;
				vuint32_t MS067:1;
				vuint32_t MS066:1;
				vuint32_t MS065:1;
				vuint32_t MS064:1;
            } B;
        } UMISR2;

		union {                 /* User Multiple Input Signature Register 3 */
            vuint32_t R;
            struct {
				vuint32_t MS127:1;
				vuint32_t MS126:1;
				vuint32_t MS125:1;
				vuint32_t MS124:1;
				vuint32_t MS123:1;
				vuint32_t MS122:1;
                vuint32_t MS121:1;
				vuint32_t MS120:1;
				vuint32_t MS119:1;
				vuint32_t MS118:1;
				vuint32_t MS117:1;
				vuint32_t MS116:1;
				vuint32_t MS115:1;
				vuint32_t MS114:1;
				vuint32_t MS113:1;
				vuint32_t MS112:1;
				vuint32_t MS111:1;
				vuint32_t MS110:1;
				vuint32_t MS109:1;
				vuint32_t MS108:1;
				vuint32_t MS107:1;
				vuint32_t MS106:1;
				vuint32_t MS105:1;
				vuint32_t MS104:1;
				vuint32_t MS103:1;
				vuint32_t MS102:1;
				vuint32_t MS101:1;
				vuint32_t MS100:1;
				vuint32_t MS099:1;
				vuint32_t MS098:1;
				vuint32_t MS097:1;
				vuint32_t MS096:1;
            } B;
        } UMISR3;

		union {                 /* User Multiple Input Signature Register 4 */
            vuint32_t R;
            struct {
				vuint32_t MS159:1;
				vuint32_t MS158:1;
				vuint32_t MS157:1;
				vuint32_t MS156:1;
				vuint32_t MS155:1;
				vuint32_t MS154:1;
				vuint32_t MS153:1;
				vuint32_t MS152:1;
                vuint32_t MS151:1;
				vuint32_t MS150:1;
				vuint32_t MS149:1;
				vuint32_t MS148:1;
				vuint32_t MS147:1;
				vuint32_t MS146:1;
				vuint32_t MS145:1;
				vuint32_t MS144:1;
				vuint32_t MS143:1;
				vuint32_t MS142:1;
				vuint32_t MS141:1;
				vuint32_t MS140:1;
				vuint32_t MS139:1;
				vuint32_t MS138:1;
				vuint32_t MS137:1;
				vuint32_t MS136:1;
				vuint32_t MS135:1;
				vuint32_t MS134:1;
				vuint32_t MS133:1;
				vuint32_t MS132:1;
				vuint32_t MS131:1;
				vuint32_t MS130:1;
				vuint32_t MS129:1;
				vuint32_t MS128:1;
            } B;
        } UMISR4;
    };                          /* end of Dflash_tag */
/****************************************************************************/
/*                     MODULE : CFLASH                                       */
/****************************************************************************/
    struct CFLASH_tag {
        union {                 /* Module Configuration Register */
            vuint32_t R;
            struct {
                vuint32_t EDC:1;
                  vuint32_t:4;
                vuint32_t SIZE:3;
                  vuint32_t:1;
                vuint32_t LAS:3;
                  vuint32_t:3;
                vuint32_t MAS:1;
                vuint32_t EER:1;
                vuint32_t RWE:1;
                  vuint32_t:2;
                vuint32_t PEAS:1;
                vuint32_t DONE:1;
                vuint32_t PEG:1;
                  vuint32_t:4;
                vuint32_t PGM:1;
                vuint32_t PSUS:1;
                vuint32_t ERS:1;
                vuint32_t ESUS:1;
                vuint32_t EHV:1;
            } B;
        } MCR;

        union {                 /* LML Register */
            vuint32_t R;
            struct {
                vuint32_t LME:1;
                  vuint32_t:10;
                vuint32_t TSLK:1;
                  vuint32_t:2;
                vuint32_t MLK1:1;
                vuint32_t MLK0:1;
				vuint32_t:10; 
				vuint32_t LLK5:1;
				vuint32_t LLK4:1;
                vuint32_t LLK3:1;
				vuint32_t LLK2:1;
				vuint32_t LLK1:1;
                vuint32_t LLK0:1;
            } B;
        } LML;

        int32_t Dflash_reserved0[1];

        union {                 /* SLML Register */
            vuint32_t R;
            struct {
                vuint32_t SLE:1;
                  vuint32_t:10;
                vuint32_t STSLK:1;
                  vuint32_t:2;
                vuint32_t SMK1:1;
				vuint32_t SMK0:1;
				vuint32_t:10;
                vuint32_t SLK5:1;
				vuint32_t SLK4:1;
				vuint32_t SLK3:1;
				vuint32_t SLK2:1;
				vuint32_t SLK1:1;
				vuint32_t SLK0:1;
            } B;
        } SLL;

        union {                 /* LMS Register */
            vuint32_t R;
            struct {
                vuint32_t:14;
                vuint32_t MSL1:1;
				vuint32_t MSL0:1;
				vuint32_t:10;
                vuint32_t LSL5:1;
				vuint32_t LSL4:1;
				vuint32_t LSL3:1;
				vuint32_t LSL2:1;
				vuint32_t LSL1:1;
				vuint32_t LSL0:1;
            } B;
        } LMS;

        int32_t Dflash_reserved1[1];

        union {                 /* Address Register */
            vuint32_t R;
            struct {
                vuint32_t:9;
                vuint32_t ADD:20;
                  vuint32_t:3;
            } B;
        } ADR;

        union {                 /* CFLASH Configuration Register 0 */
            vuint32_t R;
            struct {
                vuint32_t BK0_APC:5;
                vuint32_t BK0_WWSC:5;
                vuint32_t BK0_RWSC:5;
                vuint32_t BK0_RWWC2:1;
                vuint32_t BK0_RWWC1:1;
                vuint32_t:7;
                vuint32_t BK0_RWWC0:1;
                vuint32_t B0_P0_BCFG:2;
                vuint32_t B0_P0_DPFE:1;
                vuint32_t B0_P0_IPFE:1;
                vuint32_t B0_P0_PFLM:2;
                vuint32_t B0_P0_BFE:1;
            } B;
        } PFCR0;

        union {                 /* CFLASH Configuration Register 1 */
            vuint32_t R;
            struct {
                vuint32_t BK1_APC:5;
                vuint32_t BK1_WWSC:5;
                vuint32_t BK1_RWSC:5;
                vuint32_t BK1_RWWC2:1;
                vuint32_t BK1_RWWC1:1;
                  vuint32_t:6;
                vuint32_t B0_P1_BFE:1;
                vuint32_t BK1_RWWC0:1;
                  vuint32_t:6;
                vuint32_t B1_P0_BFE:1;
            } B;
        } PFCR1;

        union {                 /* cflash Access Protection Register */
            vuint32_t R;
            struct {
                vuint32_t:6;
                vuint32_t ARBM:2;
                vuint32_t M7PFD:1;
                vuint32_t M6PFD:1;
                vuint32_t M5PFD:1;
                vuint32_t M4PFD:1;
                vuint32_t M3PFD:1;
                vuint32_t M2PFD:1;
                vuint32_t M1PFD:1;
                vuint32_t M0PFD:1;
                vuint32_t M7AP:2;
                vuint32_t M6AP:2;
                vuint32_t M5AP:2;
                vuint32_t M4AP:2;
                vuint32_t M3AP:2;
                vuint32_t M2AP:2;
                vuint32_t M1AP:2;
                vuint32_t M0AP:2;
            } B;
        } PFAPR;

        int32_t CFLASH_reserved2[5];    /* {0x003C-0x0028}/0x4 = 0x05 */

        union {                 /* User Test Register 0 */
            vuint32_t R;
            struct {
                vuint32_t UTE:1;
                  vuint32_t:7;
                vuint32_t DSI7:1;
				vuint32_t DSI6:1;
				vuint32_t DSI5:1;
				vuint32_t DSI4:1;
				vuint32_t DSI3:1;
				vuint32_t DSI2:1;
				vuint32_t DSI1:1;
				vuint32_t DSI0:1;
                  vuint32_t:10;
                vuint32_t MRE:1;
                vuint32_t MRV:1;
                vuint32_t EIE:1;
                vuint32_t AIS:1;
                vuint32_t AIE:1;
                vuint32_t AID:1;
            } B;
        } UT0;

        union {                 /* User Test Register 1 */
            vuint32_t R;
            struct {
                vuint32_t DAI31:1;
				vuint32_t DAI30:1;
				vuint32_t DAI29:1;
				vuint32_t DAI28:1;
				vuint32_t DAI27:1;
				vuint32_t DAI26:1;
				vuint32_t DAI25:1;
				vuint32_t DAI24:1;
				vuint32_t DAI23:1;
				vuint32_t DAI22:1;
				vuint32_t DAI21:1;
				vuint32_t DAI20:1;
				vuint32_t DAI19:1;
				vuint32_t DAI18:1;
				vuint32_t DAI17:1;
				vuint32_t DAI16:1;
				vuint32_t DAI15:1;
				vuint32_t DAI14:1;
				vuint32_t DAI13:1;
				vuint32_t DAI12:1;
				vuint32_t DAI11:1;
				vuint32_t DAI10:1;
				vuint32_t DAI9:1;
				vuint32_t DAI8:1;
				vuint32_t DAI7:1;
				vuint32_t DAI6:1;
				vuint32_t DAI5:1;
				vuint32_t DAI4:1;
				vuint32_t DAI3:1;
				vuint32_t DAI2:1;
				vuint32_t DAI1:1;
				vuint32_t DAI0:1;
            } B;
        } UT1;

        union {                 /* User Test Register 2 */
            vuint32_t R;
            struct {
                vuint32_t DAI63:1;
				vuint32_t DAI62:1;
				vuint32_t DAI61:1;
				vuint32_t DAI60:1;
				vuint32_t DAI59:1;
				vuint32_t DAI58:1;
				vuint32_t DAI57:1;
				vuint32_t DAI56:1;
				vuint32_t DAI55:1;
				vuint32_t DAI54:1;
				vuint32_t DAI53:1;
				vuint32_t DAI52:1;
				vuint32_t DAI51:1;
				vuint32_t DAI50:1;
				vuint32_t DAI49:1;
				vuint32_t DAI48:1;
				vuint32_t DAI47:1;
				vuint32_t DAI46:1;
				vuint32_t DAI45:1;
				vuint32_t DAI44:1;
				vuint32_t DAI43:1;
				vuint32_t DAI42:1;
				vuint32_t DAI41:1;
				vuint32_t DAI40:1;
				vuint32_t DAI39:1;
				vuint32_t DAI38:1;
				vuint32_t DAI37:1;
				vuint32_t DAI36:1;
				vuint32_t DAI35:1;
				vuint32_t DAI34:1;
				vuint32_t DAI33:1;
				vuint32_t DAI32:1;
            } B;
        } UT2;

                union {                 /* User Multiple Input Signature Register 0 */
            vuint32_t R;
            struct {
                vuint32_t MS031:1;
				vuint32_t MS030:1;
				vuint32_t MS029:1;
				vuint32_t MS028:1;
				vuint32_t MS027:1;
				vuint32_t MS026:1;
				vuint32_t MS025:1;
				vuint32_t MS024:1;
				vuint32_t MS023:1;
				vuint32_t MS022:1;
				vuint32_t MS021:1;
				vuint32_t MS020:1;
				vuint32_t MS019:1;
				vuint32_t MS018:1;
				vuint32_t MS017:1;
				vuint32_t MS016:1;
				vuint32_t MS015:1;
				vuint32_t MS014:1;
				vuint32_t MS013:1;
				vuint32_t MS012:1;
				vuint32_t MS011:1;
				vuint32_t MS010:1;
				vuint32_t MS009:1;
				vuint32_t MS008:1;
				vuint32_t MS007:1;
				vuint32_t MS006:1;
				vuint32_t MS005:1;
				vuint32_t MS004:1;
				vuint32_t MS003:1;
				vuint32_t MS002:1;
				vuint32_t MS001:1;
				vuint32_t MS000:1;
            } B;
        } UMISR0;

		union {                 /* User Multiple Input Signature Register 1 */
            vuint32_t R;
            struct {
				vuint32_t MS063:1;
				vuint32_t MS062:1;
                vuint32_t MS061:1;
				vuint32_t MS060:1;
				vuint32_t MS059:1;
				vuint32_t MS058:1;
				vuint32_t MS057:1;
				vuint32_t MS056:1;
				vuint32_t MS055:1;
				vuint32_t MS054:1;
				vuint32_t MS053:1;
				vuint32_t MS052:1;
				vuint32_t MS051:1;
				vuint32_t MS050:1;
				vuint32_t MS049:1;
				vuint32_t MS048:1;
				vuint32_t MS047:1;
				vuint32_t MS046:1;
				vuint32_t MS045:1;
				vuint32_t MS044:1;
				vuint32_t MS043:1;
				vuint32_t MS042:1;
				vuint32_t MS041:1;
				vuint32_t MS040:1;
				vuint32_t MS039:1;
				vuint32_t MS038:1;
				vuint32_t MS037:1;
				vuint32_t MS036:1;
				vuint32_t MS035:1;
				vuint32_t MS034:1;
				vuint32_t MS033:1;
				vuint32_t MS032:1;
            } B;
        } UMISR1;

		union {                 /* User Multiple Input Signature Register 2 */
            vuint32_t R;
            struct {
				vuint32_t MS095:1;
				vuint32_t MS094:1;
				vuint32_t MS093:1;
				vuint32_t MS092:1;
                vuint32_t MS091:1;
				vuint32_t MS090:1;
				vuint32_t MS089:1;
				vuint32_t MS088:1;
				vuint32_t MS087:1;
				vuint32_t MS086:1;
				vuint32_t MS085:1;
				vuint32_t MS084:1;
				vuint32_t MS083:1;
				vuint32_t MS082:1;
				vuint32_t MS081:1;
				vuint32_t MS080:1;
				vuint32_t MS079:1;
				vuint32_t MS078:1;
				vuint32_t MS077:1;
				vuint32_t MS076:1;
				vuint32_t MS075:1;
				vuint32_t MS074:1;
				vuint32_t MS073:1;
				vuint32_t MS072:1;
				vuint32_t MS071:1;
				vuint32_t MS070:1;
				vuint32_t MS069:1;
				vuint32_t MS068:1;
				vuint32_t MS067:1;
				vuint32_t MS066:1;
				vuint32_t MS065:1;
				vuint32_t MS064:1;
            } B;
        } UMISR2;

		union {                 /* User Multiple Input Signature Register 3 */
            vuint32_t R;
            struct {
				vuint32_t MS127:1;
				vuint32_t MS126:1;
				vuint32_t MS125:1;
				vuint32_t MS124:1;
				vuint32_t MS123:1;
				vuint32_t MS122:1;
                vuint32_t MS121:1;
				vuint32_t MS120:1;
				vuint32_t MS119:1;
				vuint32_t MS118:1;
				vuint32_t MS117:1;
				vuint32_t MS116:1;
				vuint32_t MS115:1;
				vuint32_t MS114:1;
				vuint32_t MS113:1;
				vuint32_t MS112:1;
				vuint32_t MS111:1;
				vuint32_t MS110:1;
				vuint32_t MS109:1;
				vuint32_t MS108:1;
				vuint32_t MS107:1;
				vuint32_t MS106:1;
				vuint32_t MS105:1;
				vuint32_t MS104:1;
				vuint32_t MS103:1;
				vuint32_t MS102:1;
				vuint32_t MS101:1;
				vuint32_t MS100:1;
				vuint32_t MS099:1;
				vuint32_t MS098:1;
				vuint32_t MS097:1;
				vuint32_t MS096:1;
            } B;
        } UMISR3;

		union {                 /* User Multiple Input Signature Register 4 */
            vuint32_t R;
            struct {
				vuint32_t MS159:1;
				vuint32_t MS158:1;
				vuint32_t MS157:1;
				vuint32_t MS156:1;
				vuint32_t MS155:1;
				vuint32_t MS154:1;
				vuint32_t MS153:1;
				vuint32_t MS152:1;
                vuint32_t MS151:1;
				vuint32_t MS150:1;
				vuint32_t MS149:1;
				vuint32_t MS148:1;
				vuint32_t MS147:1;
				vuint32_t MS146:1;
				vuint32_t MS145:1;
				vuint32_t MS144:1;
				vuint32_t MS143:1;
				vuint32_t MS142:1;
				vuint32_t MS141:1;
				vuint32_t MS140:1;
				vuint32_t MS139:1;
				vuint32_t MS138:1;
				vuint32_t MS137:1;
				vuint32_t MS136:1;
				vuint32_t MS135:1;
				vuint32_t MS134:1;
				vuint32_t MS133:1;
				vuint32_t MS132:1;
				vuint32_t MS131:1;
				vuint32_t MS130:1;
				vuint32_t MS129:1;
				vuint32_t MS128:1;
            } B;
        } UMISR4;

    };                          /* end of CFLASH_tag */
    
/****************************************************************************/
/*                          MODULE : CRC                                    */
/****************************************************************************/
    struct CRC_tag {
    union {
   	    	vuint32_t R;
            struct {
            vuint32_t:29;
            vuint32_t POLYG:1;
            vuint32_t SWAP:1;
            vuint32_t INV:1;
            }B;
        } CRC_CFG;                   /* CRC Configuration Register */

	union {
			vuint32_t R;
            vuint8_t  B[4];  /* Data buffer in Bytes (8 bits) */
            vuint16_t H[2];  /* Data buffer in Half-words (16 bits) */
            vuint32_t W;     /* Data buffer in words (32 bits) */
        } CRC_INP;	     /* CRC Input Register */

	union {
			vuint32_t R;
            vuint8_t  B[4];  /* Data buffer in Bytes (8 bits) */
            vuint16_t H[2];  /* Data buffer in Half-words (16 bits) */
            vuint32_t W;     /* Data buffer in words (32 bits) */
        } CRC_CSTAT;         /*CRC Current Status Register */

	union {
			vuint32_t R;
            vuint8_t  B[4];  /* Data buffer in Bytes (8 bits) */
            vuint16_t H[2];  /* Data buffer in Half-words (16 bits) */
            vuint32_t W;     /* Data buffer in words (32 bits) */
        } CRC_OUTP;          /* CRC Output Register */

    };                          /* end of CRC_tag */
   
    
/****************************************************************** 
| defines and macros (scope: module-local) 
|-----------------------------------------------------------------*/
/* Define instances of modules */
#define ADC_0     (*(volatile struct ADC_tag *)       0xFFE00000UL)
#define ADC_1     (*(volatile struct ADC_tag *)       0xFFE04000UL)
#define CAN_0     (*(volatile struct FLEXCAN_tag *)   0xFFFC0000UL)
#define CFLASH    (*(volatile struct CFLASH_tag *)    0xC3F88000UL)
#define CGM       (*(volatile struct CGM_tag *)       0xC3FE0000UL)
#define CTU_0     (*(volatile struct CTU_tag *)       0xFFE0C000UL)
#define DFLASH    (*(volatile struct DFLASH_tag *)    0xC3F8C000UL)
#define DMAMUX    (*(volatile struct DMAMUX_tag *)    0xFFFDC000UL)
#define DSPI_0    (*(volatile struct DSPI_tag *)      0xFFF90000UL)
#define DSPI_1    (*(volatile struct DSPI_tag *)      0xFFF94000UL)
#define DSPI_2    (*(volatile struct DSPI_tag *)      0xFFF98000UL)
#define DSPI_3    (*(volatile struct DSPI_tag *)      0xFFF9C000UL)
#define EDMA      (*(volatile struct EDMA_tag *)      0xFFF44000UL)
#define ETIMER_0  (*(volatile struct ETIMER_tag *)    0xFFE18000UL)
#define ETIMER_1  (*(volatile struct ETIMER_tag *)    0xFFE1C000UL)
#define FCU       (*(volatile struct FCU_tag *)       0xFFE6C000UL)
#define FLEXPWM_0 (*(volatile struct FLEXPWM_tag *)   0xFFE24000UL)
#define FR        (*(volatile struct FR_tag *)        0xFFFE0000UL)
#define INTC      (*(volatile struct INTC_tag *)      0xFFF48000UL)
#define LINFLEX_0 (*(volatile struct LINFLEX_tag *)   0xFFE40000UL)
#define LINFLEX_1 (*(volatile struct LINFLEX_tag *)   0xFFE44000UL)
#define ECSM      (*(volatile struct ECSM_tag *)      0xFFF40000UL)
#define ME        (*(volatile struct ME_tag *)        0xC3FDC000UL)
#define PCU       (*(volatile struct PCU_tag *)       0xC3FE8000UL)
#define PIT       (*(volatile struct PIT_tag *)       0xC3FF0000UL)
#define RGM       (*(volatile struct RGM_tag *)       0xC3FE4000UL)
#define SAFEPORT  (*(volatile struct FLEXCAN_tag *)   0xFFFE8000UL)
#define SIUL      (*(volatile struct SIUL_tag *)       0xC3F90000UL)
#define SSCM      (*(volatile struct SSCM_tag *)      0xC3FD8000UL)
#define STM_0     (*(volatile struct STM_tag *)       0xFFF3C000UL)
#define SWT_0     (*(volatile struct SWT_tag *)       0xFFF38000UL)
#define WKUP      (*(volatile struct WKUP_tag *)      0xC3F94000UL)
#define CRC_0     (*(volatile struct CRC_tag *)       0xFFE68000UL)
#define CRC_1     (*(volatile struct CRC_tag *)       0xFFE68010UL)


#ifdef __MWERKS__
#pragma pop
#endif

#ifdef  __cplusplus
}
#endif
#endif                          /* ifdef _JDP_H */
/* End of file */
