/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.core;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.spt.core.ISptVersionResolver;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public abstract class ASptVersionResolver
implements ISptVersionResolver {
    protected static final String EMPTY = "";
    private final String version;
    private final String coreId;

    protected ASptVersionResolver(String version, String coreId) {
        this.version = version;
        this.coreId = coreId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCoreId() {
        return this.coreId;
    }

    @Override
    public String resolve(Object object) {
        IProject project = null;
        if (object instanceof IAdaptable) {
            Object obj = ((IAdaptable)object).getAdapter(object.getClass());
            if (obj instanceof ICElement) {
                project = ((ICElement)obj).getCProject().getProject();
            } else if (obj instanceof IResource) {
                project = ((IResource)obj).getProject();
            } else {
                obj = ((IAdaptable)object).getAdapter(ICProject.class);
                if (obj instanceof ICProject) {
                    project = ((ICProject)obj).getProject();
                }
            }
        }
        return project != null ? this.getVersion(project) : null;
    }

    protected String getVersion(IProject project) {
        ProjectContextSettings projectSettings = new ProjectContextSettings(project);
        String coreId = projectSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        if (!coreId.isEmpty() && coreId.equals(this.coreId)) {
            return this.version;
        }
        String deviceId = projectSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        if (deviceId.isEmpty()) {
            return EMPTY;
        }
        List coreDescriptors = DeviceDescriptors.getCoreDescriptors((String)deviceId);
        for (CoreDescriptor core : coreDescriptors) {
            if (!core.getId().equals(this.coreId)) continue;
            return this.version;
        }
        return EMPTY;
    }
}

