/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.e200.mbs.wizard;

import com.freescale.s32ds.cross.core.model.DefaultWizardValueProvider;
import com.freescale.s32ds.cross.core.model.IWizardValueProvider;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.sdk.SDKContextUtil;
import java.util.Map;
import java.util.regex.Pattern;

public class E200WizardValueProvider
extends DefaultWizardValueProvider
implements IWizardValueProvider {
    public static final String OP_PPC_CODETYPE = "PPC_CodeType";
    public static final String OP_PPC_LIBS = "PPC-Libs";
    public static final String OP_CORE_KIND = "CORE_KIND_ID";
    public static final String OP_TOOLCHAIN = "toolchain";
    public static final String TOOLCHAIN_GCC = "gcc";
    public static final String TOOLCHAIN_GHS = "ghs";
    public static final String TOOLCHAIN_DIAB = "diab";
    public static final String OP_LINKER_EXT = "LinkerExt";
    public static final String LINKER_EXT_DLD = "dld";
    public static final String LINKER_EXT_LD = "ld";
    public static final String OP_DIAB_VERSION = "DiabVerison";
    public static final String DIAB_VERSION = "diab-5.9.4.8";
    private static final String TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE = "project.base.template";

    public Map<String, String> createValueMap(ProjectContext context, String location) {
        Map res = super.createValueMap(context, location);
        if (!(context instanceof CProjectContext)) {
            return res;
        }
        CProjectContext projectContext = (CProjectContext)context;
        ProcessorContext processorContext = projectContext.getProcessorContext();
        res.put("GROUP_NAME", projectContext.getProjectBaseName());
        res.put("DEVICE_NAME", processorContext.getProcessor().getId());
        res.put("projectNameSafe", Pattern.quote(projectContext.getProjectName()));
        res.put("GROUP_SAFE", Pattern.quote(projectContext.getProjectBaseName()));
        if (projectContext.isExecutable()) {
            res.put("FLASH_START", "0x" + Long.toHexString(projectContext.getLongValue("flashStart")));
            res.put("RAM_START", "0x" + Long.toHexString(projectContext.getLongValue("ramStart")));
            res.put("FLASH_LENGTH", Long.toString(projectContext.getLongValue("flashSize") / 1024L));
            res.put("RAM_LENGTH", Long.toString(projectContext.getLongValue("ramSize") / 1024L));
        } else {
            res.put(OP_CORE_KIND, projectContext.getRootData().getCoreKindId());
        }
        String tcId = projectContext.getTemplate().getTemplateInfo(true).getToolChainId();
        if (tcId.contains("gnu.e200")) {
            res.put(OP_TOOLCHAIN, TOOLCHAIN_GCC);
            res.put(OP_LINKER_EXT, LINKER_EXT_LD);
        } else if (tcId.contains("ghs.managedmake.ppc")) {
            res.put(OP_TOOLCHAIN, TOOLCHAIN_GHS);
            res.put(OP_LINKER_EXT, LINKER_EXT_LD);
        } else if (tcId.contains("diab.toolChain")) {
            res.put(OP_TOOLCHAIN, TOOLCHAIN_DIAB);
            res.put(OP_LINKER_EXT, LINKER_EXT_DLD);
            res.put(OP_DIAB_VERSION, DIAB_VERSION);
        }
        int cnt = 0;
        for (CProjectContext c : processorContext.getProjectContexts()) {
            if (c.isExecutable()) {
                String f = "FLASH_START_" + (cnt + 1);
                String r = "RAM_START_" + (cnt + 1);
                res.put(f, "0x" + Long.toHexString(c.getLongValue("flashStart")));
                res.put(r, "0x" + Long.toHexString(c.getLongValue("ramStart")));
            }
            String p = "TURN_ON_CPU" + cnt;
            String projectName = "PROJECT_NAME_" + cnt;
            res.put(p, c.isActive() ? "true" : "false");
            res.put(projectName, c.getProjectName());
            ++cnt;
        }
        res.put("pex", Boolean.toString(SDKContextUtil.isPex((CProjectContext)projectContext)));
        res.put(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE, Boolean.FALSE.toString());
        Map mapSdkByTargetProjectTemplate = SDKContextUtil.getSdksTargetProjectTemplateIds((CProjectContext)projectContext);
        if (mapSdkByTargetProjectTemplate != null && mapSdkByTargetProjectTemplate.containsKey(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE)) {
            res.put(TEMPLATE_VARIABLE_PROJECT_BASE_TEMPLATE, Boolean.TRUE.toString());
        }
        return res;
    }
}

