/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.ppc;

import com.pemicro.debug.gdbjtag.ppc.Activator;
import com.pemicro.debug.gdbjtag.ppc.ui.TabDebugger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.internal.core.envvar.EnvVarCollector;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.ini4j.Config;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Wini;

public class Utils {
    private static final String PROPERTY_OS_NAME = "os.name";
    public static final String PROPERTY_OS_VALUE_WINDOWS = "windows";
    public static final String PROPERTY_OS_VALUE_LINUX = "linux";
    public static final String PROPERTY_OS_VALUE_MACOSX = "macosx";
    private static boolean DEBUG = false;

    public static String getGdbServerPath() {
        String path = Utils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (Utils.isWindows()) {
            path = String.valueOf(path) + "win32";
        } else if (Utils.isLinux()) {
            path = String.valueOf(path) + "lin";
        } else if (Utils.isMacOSX()) {
            path = String.valueOf(path) + "osx";
        }
        File serverExecutable = new File(path);
        try {
            return String.valueOf(serverExecutable.getCanonicalPath()) + File.separator;
        }
        catch (IOException e) {
            e.printStackTrace();
            return String.valueOf(serverExecutable.getAbsolutePath()) + File.separator;
        }
    }

    public static void debugPrint(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public static int getNumberOfCores(String deviceName) {
        int numCores;
        String addFileFullPath = String.valueOf(Utils.getGdbServerPath()) + "gdi" + File.separator + "P&E" + File.separator + "pedebug_ppcnexus_" + deviceName.toLowerCase() + ".add";
        Wini addIni = new Wini();
        Config config = new Config();
        addIni.setConfig(config);
        try {
            addIni.load(new File(addFileFullPath));
        }
        catch (InvalidFileFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            numCores = Integer.parseInt(addIni.get((Object)deviceName.toUpperCase(), (Object)"NUMCORES"));
        }
        catch (NumberFormatException e) {
            numCores = 1;
            e.printStackTrace();
        }
        return numCores;
    }

    public static void addMultiLine(String multiLine, List<String> commandsList) throws CoreException {
        if (multiLine.length() > 0) {
            String[] commandsStr;
            multiLine = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(multiLine);
            String[] stringArray = commandsStr = multiLine.split("\\r?\\n");
            int n = commandsStr.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if ((str = str.trim()).length() > 0) {
                    commandsList.add(str);
                }
                ++n2;
            }
        }
    }

    public static String composeCommandWithLf(Collection<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = commands.iterator();
        while (it.hasNext()) {
            String s = it.next().trim();
            if (s.length() == 0 || s.startsWith("#")) continue;
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = (path = path.trim()).split("\\s");
        if (segments.length > 1) {
            if (Utils.isWindows()) {
                return "\"" + path + "\"";
            }
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_WINDOWS);
    }

    public static boolean isLinux() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_LINUX);
    }

    public static boolean isMacOSX() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_MACOSX);
    }

    public static IPath getGDBPath(ILaunchConfiguration configuration) {
        String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
        Path retVal = new Path(defaultGdbCommand);
        try {
            String gdb = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            gdb = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdb, false);
            ICConfigurationDescription buildConfig = Utils.getBuildConfig(configuration);
            if (buildConfig != null) {
                gdb = Utils.resolveAll(gdb, buildConfig);
            }
            retVal = new Path(gdb);
        }
        catch (CoreException coreException) {}
        return retVal;
    }

    public static String getGDBVersion(ILaunchConfiguration configuration) throws CoreException {
        Process process;
        String[] cmdArray = new String[]{TabDebugger.getGdbClientCommand(configuration), "--version"};
        try {
            process = ProcessFactory.getFactory().exec(cmdArray, Utils.getLaunchEnvironment(configuration));
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.ppc", 5012, "Error while launching command: " + Utils.join(cmdArray, " "), e.getCause()));
        }
        Job timeoutJob = new Job("GDB version timeout job"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor arg) {
                process.destroy();
                return Status.OK_STATUS;
            }
        };
        timeoutJob.schedule(10000L);
        InputStream stream = null;
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            try {
                String line;
                stream = process.getInputStream();
                InputStreamReader r = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    cmdOutput.append(line);
                    cmdOutput.append('\n');
                }
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.ppc", 5012, "Error reading GDB STDOUT after sending: " + Utils.join(cmdArray, " ") + ", response: " + cmdOutput, e.getCause()));
            }
        }
        catch (Throwable throwable) {
            timeoutJob.cancel();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            process.destroy();
            throw throwable;
        }
        timeoutJob.cancel();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        process.destroy();
        String gdbVersion = LaunchUtils.getGDBVersionFromText((String)cmdOutput.toString());
        if (gdbVersion == null || gdbVersion.isEmpty()) {
            throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.ppc", 5012, "Could not determine GDB version after sending: " + Utils.join(cmdArray, " ") + ", response: " + cmdOutput, null));
        }
        return gdbVersion;
    }

    public static String[] getLaunchEnvironment(ILaunchConfiguration config) throws CoreException {
        ICdtVariable[] build_vars;
        IEnvironmentVariable[] vars;
        ICConfigurationDescription cfg = Utils.getBuildConfig(config);
        if (cfg == null) {
            return Utils.getLaunchEnvironmentWithoutProject();
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            envMap.put(var.getName(), var.getValue());
            ++n2;
        }
        ICdtVariable[] iCdtVariableArray = build_vars = CCorePlugin.getDefault().getCdtVariableManager().getVariables(cfg);
        int n3 = build_vars.length;
        n = 0;
        while (n < n3) {
            ICdtVariable var = iCdtVariableArray[n];
            try {
                if (!"project_classpath".equals(var.getName())) {
                    envMap.put(var.getName(), var.getStringValue());
                }
            }
            catch (CdtVariableException cdtVariableException) {}
            ++n;
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static ICConfigurationDescription getBuildConfig(ILaunchConfiguration config) {
        ICProjectDescription projDesc;
        ICConfigurationDescription cfg;
        block11: {
            IProject project;
            block10: {
                String projectName;
                block9: {
                    block8: {
                        cfg = null;
                        try {
                            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
                            if (projectName != null) break block8;
                            return null;
                        }
                        catch (CoreException coreException) {}
                    }
                    projectName = projectName.trim();
                    if (projectName.length() != 0) break block9;
                    return null;
                }
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.isAccessible()) break block10;
                return null;
            }
            projDesc = CoreModel.getDefault().getProjectDescription(project, false);
            if (projDesc != null) break block11;
            return null;
        }
        String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
        if (buildConfigID.length() != 0) {
            cfg = projDesc.getConfigurationById(buildConfigID);
        }
        if (cfg == null) {
            cfg = projDesc.getActiveConfiguration();
        }
        return cfg;
    }

    public static String resolveAll(String value, ICConfigurationDescription cfgDescription) {
        try {
            return CCorePlugin.getDefault().getCdtVariableManager().resolveValue(value, "", " ", cfgDescription);
        }
        catch (CdtVariableException e) {
            Activator.log(e);
            return value;
        }
    }

    public static String join(String[] strArray, String joiner) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            sb.append(item);
            sb.append(joiner);
            ++n2;
        }
        return sb.toString().trim();
    }

    public static File getProjectOsPath(ILaunchConfiguration configuration) throws CoreException {
        IPath path = null;
        File dir = null;
        if (configuration != null) {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.length() > 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                path = project.getLocation();
            } else {
                String executableName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                path = new Path(executableName).removeLastSegments(1);
            }
        }
        if (path != null) {
            dir = new File(path.toOSString());
        }
        return dir;
    }

    public static int compareVersions(String v1, String v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int i = 0;
        while (i < v1Parts.length && i < v2Parts.length) {
            int v2PartValue;
            int v1PartValue;
            block16: {
                try {
                    v1PartValue = Integer.parseInt(v1Parts[i]);
                    v2PartValue = Integer.parseInt(v2Parts[i]);
                    if (v1PartValue <= v2PartValue) break block16;
                    return 1;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (v1PartValue < v2PartValue) {
                return -1;
            }
            ++i;
        }
        if (v1Parts.length < v2Parts.length) {
            i = v1Parts.length;
            while (i < v2Parts.length) {
                try {
                    if (Integer.parseInt(v2Parts[i]) != 0) {
                        return -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        if (v1Parts.length > v2Parts.length) {
            i = v2Parts.length;
            while (i < v1Parts.length) {
                try {
                    if (Integer.parseInt(v1Parts[i]) != 0) {
                        return 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        return 0;
    }

    public static String[] getLaunchEnvironmentWithoutProject() throws CoreException {
        String[] retVal = null;
        IEnvironmentContextInfo contextInfo = EnvironmentVariableManager.getDefault().getContextInfo(null);
        EnvVarCollector envVarMergedColletion = EnvironmentVariableManager.getVariables((IEnvironmentContextInfo)contextInfo, (boolean)true);
        if (envVarMergedColletion != null) {
            EnvVarDescriptor[] envVars = envVarMergedColletion.toArray(false);
            if (envVars != null) {
                ArrayList<String> strings = new ArrayList<String>();
                int i = 0;
                while (i < envVars.length) {
                    IEnvironmentVariable resolved = EnvironmentVariableManager.getDefault().calculateResolvedVariable(envVars[i], contextInfo);
                    if (resolved != null && !"project_classpath".equals(resolved.getName())) {
                        StringBuffer buffer = new StringBuffer(resolved.getName());
                        buffer.append('=').append(resolved.getValue());
                        strings.add(buffer.toString());
                    }
                    ++i;
                }
                retVal = strings.toArray(new String[strings.size()]);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.ppc", "Error retrieving workspace environment."));
        }
        return retVal;
    }
}

