/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.edit;

import com.pemicro.forms.chip.ChipResponse;
import com.pemicro.forms.chip.Signal;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class ValueEditingSupport
extends EditingSupport {
    private final TableViewer viewer;

    public ValueEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return new TextCellEditor((Composite)this.viewer.getTable());
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        Signal s = (Signal)element;
        if (s.getDataType() == 0) {
            return Integer.toString(s.getValue());
        }
        return String.format("%.2f", Float.valueOf((float)s.getValue() / 100.0f));
    }

    protected void setValue(Object element, Object value) {
        try {
            Signal signal = (Signal)element;
            if (signal.getDataType() == 0 && (String.valueOf(value).equals("0") || String.valueOf(value).equals("1")) && Integer.parseInt(String.valueOf(value)) != signal.getPinData().getDigitalValue()) {
                ChipResponse.processDoubleClick(signal.getPinData(), 2);
            }
            if (signal.getDataType() == 1 && Float.parseFloat(String.valueOf(value)) * 100.0f < (float)signal.getAnalogMax()) {
                ChipResponse.setControlChanged(true);
                ChipResponse.setPinValueChanged(true);
                ChipResponse.setPinID(signal.getID());
                ChipResponse.setModuleName(signal.getPinName());
                ChipResponse.setDataType(signal.getDataType());
                ChipResponse.setAnalogValue((int)(Float.parseFloat(String.valueOf(value)) * 100.0f));
                ChipResponse.setAnalogMax(signal.getAnalogMax());
                ChipResponse.setAnalogMin(signal.getAnalogMin());
            }
        }
        catch (Exception exception) {}
    }
}

