/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.model;

import com.nxp.s32ds.cle.spt.model.Activator;
import com.nxp.s32ds.cle.spt.model.ISptInstructionOption;
import com.nxp.s32ds.cle.spt.model.SptDefinition;
import com.nxp.s32ds.cle.spt.model.SptDirective;
import com.nxp.s32ds.cle.spt.model.SptInstructionOption;
import com.nxp.s32ds.cle.spt.model.SptInstructionParam;
import com.nxp.s32ds.cle.spt.model.SptInstructionParamType;
import com.nxp.s32ds.cle.spt.model.SptInstructionParamValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SptIncludeDirective
extends SptDirective {
    private static final String OPTION_NAME = "include";
    private static final String INCLUDE_DIR = "/inc";
    private static final String INCLUDE_EXT = ".inc";

    public SptIncludeDirective() {
        super(SptInstructionParamType.INCLUDE);
    }

    @Override
    public void init(SptDefinition sptDefinition) {
        super.init(sptDefinition);
        this.initIncludeList(sptDefinition.getToolsLocation());
    }

    private void initIncludeList(String toolsLocation) {
        this.params.clear();
        if (toolsLocation == null || toolsLocation.isEmpty()) {
            this.setDefaultInstructionParam("Unable to load includes: SPT tools location is undefined.");
        }
        String path = String.valueOf(toolsLocation) + INCLUDE_DIR;
        try {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            Files.list(Paths.get(path, new String[0])).map(p -> p.toFile()).filter(this::acceptIncludeFile).forEach(this::addIncludeFileOptionValue);
            if (this.getParams().isEmpty() || ((ISptInstructionOption)this.getParams().get(0)).getValues().isEmpty()) {
                this.setDefaultInstructionParam(NLS.bind((String)"Unable to load includes from: path {0}", (Object)path));
            }
        }
        catch (IOException | CoreException e) {
            this.setDefaultInstructionParam(NLS.bind((String)"Unable to load includes: {0}", (Object)e.getMessage()));
        }
    }

    private boolean acceptIncludeFile(File f) {
        return f != null && f.exists() && f.isFile() && f.canRead() && f.getName().endsWith(INCLUDE_EXT);
    }

    private void addIncludeFileOptionValue(File f) {
        ISptInstructionOption option = null;
        if (this.getParams().isEmpty()) {
            option = new SptInstructionOption(OPTION_NAME, false);
            this.addParam(option);
        } else {
            option = (ISptInstructionOption)this.getParams().get(0);
        }
        if (option != null) {
            option.addValue(new SptInstructionParamValue(f.getName(), option, true));
        }
    }

    private void setDefaultInstructionParam(String errorMessage) {
        this.params.clear();
        if (errorMessage != null && !errorMessage.isEmpty()) {
            Activator.logError(errorMessage);
        }
        this.addParam(new SptInstructionParam(OPTION_NAME, SptInstructionParamType.INCLUDE.name(), false));
    }
}

