/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.spt.ui.navigator;

import com.nxp.s32ds.cle.spt.model.ISptInstruction;
import com.nxp.s32ds.cle.spt.model.ISptInstructionGroup;
import com.nxp.s32ds.cle.spt.ui.navigator.Activator;
import com.nxp.s32ds.cle.spt.ui.navigator.SptInstructionParamsDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;

public class SptExplorerDragAdapterAssistant
extends CommonDragAdapterAssistant {
    public Transfer[] getSupportedTransferTypes() {
        return new Transfer[]{TextTransfer.getInstance()};
    }

    public void dragStart(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        anEvent.doit = false;
        Object selected = aSelection.getFirstElement();
        if (selected instanceof ISptInstruction && !(selected instanceof ISptInstructionGroup)) {
            anEvent.doit = true;
        }
    }

    public boolean setDragData(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        Object selected = aSelection.getFirstElement();
        if (selected instanceof ISptInstruction) {
            String command = this.getCommandString((ISptInstruction)selected);
            anEvent.data = command != null ? command : "\u0000";
            this.focusOnActiveEditor();
            return true;
        }
        return false;
    }

    private String getCommandString(final ISptInstruction selectedInstruction) {
        final String[] result = new String[1];
        if (!selectedInstruction.getParams().isEmpty()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    SptInstructionParamsDialog ipd = new SptInstructionParamsDialog(SptExplorerDragAdapterAssistant.this.getShell(), selectedInstruction);
                    if (ipd.open() == 0) {
                        result[0] = ipd.getResult();
                    }
                }
            });
        } else {
            result[0] = selectedInstruction.getSignature();
        }
        return result[0];
    }

    private void focusOnActiveEditor() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
        }
        catch (Exception exception) {
            Activator.log((IStatus)new Status(4, "com.nxp.s32ds.cle.spt.ui.navigator", "Can't focus on active editor: ignore"));
        }
    }
}

