/**************************************************************************
 * FILE NAME: mpc5775k.h                     COPYRIGHT (c) Freescale 2016 *
 * REVISION:  6.0.0                                   All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the mpc5775k.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       DESCRIPTION OF CHANGE                  *
 * ---   -----------  ---------    ---------------------                  *
 * 1.0     M.Doidge   15-Jan-13       Initial Release                     *
 *                                                                        *
 * 1.1     M.Doidge   15-Mar-13    Updated RDP                            *
 *                                 -Module: AFE                           *
 *                                  VREGCNTRL now array, FILTCOEFF        *
 *                                  compressed differently                *
 *                                 -Module: CGM                           *
 *                                  PCS_DIVC, PCS_DIVS, PCS_DIVE now      *
 *                                  expanded, previously array            *
 *                                 -Module: CTU                           *
 *                                  struct {union {A,B,C} CLR} CHANNEL[24]*
 *                                  now union {A,B,C} CLR[24]             *
 *                                 -Module: ENET                          *
 *                                  RMON_T_DROP,..., IEEE_R_OCTETS_OK new *
 *                                  registers                             *
 *                                  TCSR, TCCR was struct {SR,CR} TC[4],  *
 *                                  now struct {TCSR,TCCR} TIMER[4]       *
 *                                 -Module: SMPU                          *
 *                                  EAR and EDR now in ERROR[16] struct   *
 *                                  array instead of CHANNEL[16]          *
 *                                 -Module: SRX                           *
 *                                  CH1 struct array now CH, CH2 struct   *
 *                                  array now CHANNEL                     *
 *                                 -Module: XBAR                          *
 *                                  new array; struct {PRS,CRS} PORT[8]   *
 *                                 -Module: eDMA                          *
 *                                  some array name changes               *
 *                                                                        *
 * 1.2     M.Doidge   27-Mar-13   Updates per feedback from A.Robertson   *
 *                                -Module: MC_ME                          *
 *                                 Correct order of PLL1ON and SDPLLON in *
 *                                 DRUN_MC, SAFE_MC, RUN_MC, RESET_MC,    *
 *                                 TEST_MC, HALT0_MC, STOP0_MC and GS     *
 *                                 registers                              *
 *                                 Correct reserved memory allocation     *
 *                                 before & after F124 register           *
 *                                 Correct generation of PCTL208 & PCTL209*
 *                                 registers                              *
 *                                -Mocule: CAN                            *
 *                                 Added some #define macros for Message  *
 *                                 Buffers                                *
 *                                                                        *
 * 1.3     M.Doidge   11-Apr-13   Updated per issues found                *
 *                                -Added Register comments throughout     *
 *                                -Removed '_' from SIPI reg CDR2 name    *
 *                                                                        *
 * 1.4     M.Doidge   10-Jun-13   Updated per RM v1.2                     *
 *                                                                        *
 * 1.5     M.Doidge   16-Aug-13   Updated per PEx updates & issue resolved*
 *                                regarding bit naming order in FCCU.     *
 *                                                                        *
 * 2.0     M.Doidge   15-Jan-14   Regenerated per RDP Rev 2 Draft A       *   
 *                                                                        *
 * 2.1     M.Doidge   27-Jan-14   Regenerated per RDP Rev 2               *   
 *                                                                        *
 * 2.2     M.Doidge   28-Jan-14   Regenerated per RDP Rev 2.1             *   
 *                                                                        *
 * 2.3	   A.Robertson 23-April-14 Added IRCOSC Registers                 *
 * 				                         Added reserved1 to CMU           *
 * 				                         Removed INT_EXT_MODE from PMCCR  *
 *				                         Added PMC_PMC_STATUS			  *
 *                                                                        *
 * 3.0     M.Doidge   08-Jan-15   Regenerated per RDP Rev 3.0             *
 *                                                                        *
 * 3.1     M.Doidge   09-Jan-15   Regenerated per RDP Rev 3.1             *
 *                                                                        *
 * 3.1.1   M.Doidge   19-Jan-15   Corrected reserved memory defines in    *
 *                                PIT, PRAM_XBAR, XBAR                    *
 *                                                                        *
 * 3.1.2   G.Kerr	  26-Jan-15   Corrected base addresses of XBIC_0      *
 *                                and XBIC_1. Added IMCR registers up to  *
 *                                IMCR[93].	(Corrections provided by      *
 *                                Cristian Zamifirescu)                   *
 *                                                                        *
 * 3.1.3   M.Doidge   30-Jan-15   Corrected constant defines in SIUL2     *
 *                                                                        *
 * 3.1.4   G.Kerr     03-Feb-15   Added defines for IMCR 85-93 in SIUL2   *
 *                                (per Cristian Zamifirescu's findings)   *
 * 4.0     M.Doidge   21-MaR-16   Regenerated per RDP Rev 4.0             *
 *                                                                        *
 * 6.0     M.Doidge   25-Oct-16   Regenerated per RDP Rev 6.0             *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5775K_H_
#define _MPC5775K_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif
#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wpedantic"
#endif


/* ============================================================================
   =============================== Module: ADC ================================
   ============================================================================ */

typedef union ADC_MCR_union_tag {      /* Main Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t OWREN:1;                 /* Overwrite enable. */
    vuint32_t WLSIDE:1;                /* Write Left/Right aligned. */
    vuint32_t MODE:1;                  /* One_Shot/Scan. */
    vuint32_t _unused_28:1;
    vuint32_t _unused_27:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_25:1;
    vuint32_t NSTART:1;
    vuint32_t _unused_23:1;
    vuint32_t JTRGEN:1;                /* Injection external trigger enable. */
    vuint32_t JEDGE:1;                 /* Injection trigger edge selection. */
    vuint32_t JSTART:1;                /* Injection start. */
    vuint32_t _unused_18:2;
    vuint32_t CTUEN:1;                 /* Crosstrigger Unit Enable. */
    vuint32_t _unused_16:1;
    vuint32_t STCL:1;                  /* Self Testing Configuration Lock. */
    vuint32_t _unused_9:6;
    vuint32_t ADCLKSEL:1;              /* Analog Clock frequency Selector. */
    vuint32_t ABORT_CHAIN:1;           /* Abort Chain. */
    vuint32_t ABORT:1;                 /* Abort Conversion. */
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t REFSEL:2;                /* Reference voltage selection for ADC analog part. */
    vuint32_t PWDN:1;                  /* Power-down enable. */
  } B;
} ADC_MCR_tag;

typedef union ADC_MSR_union_tag {      /* Main Status register */
  vuint32_t R;
  struct {
    vuint32_t CALIBRTD:1;              /* This bit indicates the ADC calibration status. */
    vuint32_t _unused_25:6;
    vuint32_t NSTART:1;                /* This status bit is used to signal that a Normal conversion is ongoing. */
    vuint32_t JABORT:1;
    vuint32_t _unused_21:2;
    vuint32_t JSTART:1;                /* This status bit is used to signal that an Injected conversion is ongoing. */
    vuint32_t _unused_19:1;
    vuint32_t SELF_TEST_S:1;           /* This status bit signals that self test conversion is ongoing. */
    vuint32_t _unused_17:1;
    vuint32_t CTUSTART:1;              /* This status bit is used to signal that a CTU conversion is ongoing. */
    vuint32_t CHADDR:7;                /* Channel under measure address. */
    vuint32_t _unused_6:3;
    vuint32_t ACKO:1;                  /* Auto clock off enable. */
    vuint32_t _unused_3:2;
    vuint32_t ADCSTATUS:3;             /* Status of the ADC. */
  } B;
} ADC_MSR_tag;

typedef union ADC_ISR_union_tag {      /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t EOCTU:1;
    vuint32_t JEOC:1;                  /* End of injected channel conversion. */
    vuint32_t JECH:1;                  /* End of injected chain conversion. */
    vuint32_t EOC:1;                   /* End of channel conversion. */
    vuint32_t ECH:1;                   /* End of chain conversion. */
  } B;
} ADC_ISR_tag;

typedef union ADC_CEOCFR0_union_tag {  /* Channel Pending register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t EOCCH15:1;               /* EOC Channel 15. */
    vuint32_t EOCCH14:1;               /* EOC Channel 14. */
    vuint32_t EOCCH13:1;               /* EOC Channel 13. */
    vuint32_t EOCCH12:1;               /* EOC Channel 12. */
    vuint32_t EOCCH11:1;               /* EOC Channel 11. */
    vuint32_t EOCCH10:1;               /* EOC Channel 10. */
    vuint32_t EOCCH9:1;                /* EOC Channel 9. */
    vuint32_t EOCCH8:1;                /* EOC Channel 8. */
    vuint32_t EOCCH7:1;                /* EOC Channel 7. */
    vuint32_t EOCCH6:1;                /* EOC Channel 6. */
    vuint32_t EOCCH5:1;                /* EOC Channel 5. */
    vuint32_t EOCCH4:1;                /* EOC Channel 4. */
    vuint32_t EOCCH3:1;                /* EOC Channel 3. */
    vuint32_t EOCCH2:1;                /* EOC Channel 2. */
    vuint32_t EOCCH1:1;                /* EOC Channel 1. */
    vuint32_t EOCCH0:1;                /* EOC Channel 0. */
  } B;
} ADC_CEOCFR0_tag;

typedef union ADC_IMR_union_tag {      /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_5:10;
    vuint32_t MSKEOCTU:1;              /* Mask bit for EOCTU. */
    vuint32_t MSKJEOC:1;               /* Mask bit for JEOC. */
    vuint32_t MSKJECH:1;               /* Mask bit for JECH. */
    vuint32_t MSKEOC:1;                /* Mask bit for EOC. */
    vuint32_t MSKECH:1;                /* Mask bit for ECH. */
  } B;
} ADC_IMR_tag;

typedef union ADC_CIMR0_union_tag {    /* Channel Interrupt Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CIM15:1;                 /* Channel 15 interrupt enable. */
    vuint32_t CIM14:1;                 /* Channel 14 interrupt enable. */
    vuint32_t CIM13:1;                 /* Channel 13 interrupt enable. */
    vuint32_t CIM12:1;                 /* Channel 12 interrupt enable. */
    vuint32_t CIM11:1;                 /* Channel 11 interrupt enable. */
    vuint32_t CIM10:1;                 /* Channel 10 interrupt enable. */
    vuint32_t CIM9:1;                  /* Channel 9 interrupt enable. */
    vuint32_t CIM8:1;                  /* Channel 8 interrupt enable. */
    vuint32_t CIM7:1;                  /* Channel 7 interrupt enable. */
    vuint32_t CIM6:1;                  /* Channel 6 interrupt enable. */
    vuint32_t CIM5:1;                  /* Channel 5 interrupt enable. */
    vuint32_t CIM4:1;                  /* Channel 4 interrupt enable. */
    vuint32_t CIM3:1;                  /* Channel 3 interrupt enable. */
    vuint32_t CIM2:1;                  /* Channel 2 interrupt enable. */
    vuint32_t CIM1:1;                  /* Channel 1 interrupt enable. */
    vuint32_t CIM0:1;                  /* Channel 0 interrupt enable. */
  } B;
} ADC_CIMR0_tag;

typedef union ADC_WTISR_union_tag {    /* Watchdog Threshold Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t WDG15H:1;
    vuint32_t WDG15L:1;
    vuint32_t WDG14H:1;
    vuint32_t WDG14L:1;
    vuint32_t WDG13H:1;
    vuint32_t WDG13L:1;
    vuint32_t WDG12H:1;
    vuint32_t WDG12L:1;
    vuint32_t WDG11H:1;
    vuint32_t WDG11L:1;
    vuint32_t WDG10H:1;
    vuint32_t WDG10L:1;
    vuint32_t WDG9H:1;
    vuint32_t WDG9L:1;
    vuint32_t WDG8H:1;
    vuint32_t WDG8L:1;
    vuint32_t WDG7H:1;
    vuint32_t WDG7L:1;
    vuint32_t WDG6H:1;
    vuint32_t WDG6L:1;
    vuint32_t WDG5H:1;
    vuint32_t WDG5L:1;
    vuint32_t WDG4H:1;
    vuint32_t WDG4L:1;
    vuint32_t WDG3H:1;
    vuint32_t WDG3L:1;
    vuint32_t WDG2H:1;
    vuint32_t WDG2L:1;
    vuint32_t WDG1H:1;
    vuint32_t WDG1L:1;
    vuint32_t WDG0H:1;
    vuint32_t WDG0L:1;
  } B;
} ADC_WTISR_tag;

typedef union ADC_WTIMR_union_tag {    /* Watchdog Threshold Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MSKWDG15H:1;
    vuint32_t MSKWDG15L:1;
    vuint32_t MSKWDG14H:1;
    vuint32_t MSKWDG14L:1;
    vuint32_t MSKWDG13H:1;
    vuint32_t MSKWDG13L:1;
    vuint32_t MSKWDG12H:1;
    vuint32_t MSKWDG12L:1;
    vuint32_t MSKWDG11H:1;
    vuint32_t MSKWDG11L:1;
    vuint32_t MSKWDG10H:1;
    vuint32_t MSKWDG10L:1;
    vuint32_t MSKWDG9H:1;
    vuint32_t MSKWDG9L:1;
    vuint32_t MSKWDG8H:1;
    vuint32_t MSKWDG8L:1;
    vuint32_t MSKWDG7H:1;
    vuint32_t MSKWDG7L:1;
    vuint32_t MSKWDG6H:1;
    vuint32_t MSKWDG6L:1;
    vuint32_t MSKWDG5H:1;
    vuint32_t MSKWDG5L:1;
    vuint32_t MSKWDG4H:1;
    vuint32_t MSKWDG4L:1;
    vuint32_t MSKWDG3H:1;
    vuint32_t MSKWDG3L:1;
    vuint32_t MSKWDG2H:1;
    vuint32_t MSKWDG2L:1;
    vuint32_t MSKWDG1H:1;
    vuint32_t MSKWDG1L:1;
    vuint32_t MSKWDG0H:1;
    vuint32_t MSKWDG0L:1;
  } B;
} ADC_WTIMR_tag;

typedef union ADC_DMAE_union_tag {     /* DMA Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t DCLR:1;                  /* DMA Clear sequence enable. */
    vuint32_t DMAEN:1;                 /* DMA global enable. */
  } B;
} ADC_DMAE_tag;

typedef union ADC_DMAR0_union_tag {    /* DMA Channel Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DMA15:1;                 /* DMA enable for channel 15. */
    vuint32_t DMA14:1;                 /* DMA enable for channel 14. */
    vuint32_t DMA13:1;                 /* DMA enable for channel 13. */
    vuint32_t DMA12:1;                 /* DMA enable for channel 12. */
    vuint32_t DMA11:1;                 /* DMA enable for channel 11. */
    vuint32_t DMA10:1;                 /* DMA enable for channel 10. */
    vuint32_t DMA9:1;                  /* DMA enable for channel 9. */
    vuint32_t DMA8:1;                  /* DMA enable for channel 8. */
    vuint32_t DMA7:1;                  /* DMA enable for channel 7. */
    vuint32_t DMA6:1;                  /* DMA enable for channel 6. */
    vuint32_t DMA5:1;                  /* DMA enable for channel 5. */
    vuint32_t DMA4:1;                  /* DMA enable for channel 4. */
    vuint32_t DMA3:1;                  /* DMA enable for channel 3. */
    vuint32_t DMA2:1;                  /* DMA enable for channel 2. */
    vuint32_t DMA1:1;                  /* DMA enable for channel 1. */
    vuint32_t DMA0:1;                  /* DMA enable for channel 0. */
  } B;
} ADC_DMAR0_tag;

typedef union ADC_THRHLR0_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR0_tag;

typedef union ADC_THRHLR1_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR1_tag;

typedef union ADC_THRHLR2_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR2_tag;

typedef union ADC_THRHLR3_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for watchdog n. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for watchdog n. */
  } B;
} ADC_THRHLR3_tag;

typedef union ADC_PSCR_union_tag {     /* Presampling Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t _unused_5:2;
    vuint32_t _unused_3:2;
    vuint32_t PREVAL0:2;               /* Internal voltage selection for Presampling. */
    vuint32_t PRECONV:1;               /* Convert Presampled value */
  } B;
} ADC_PSCR_tag;

typedef union ADC_PSR0_union_tag {     /* Presampling register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t PRES15:1;                /* Presampling enable for channel 15. */
    vuint32_t PRES14:1;                /* Presampling enable for channel 14. */
    vuint32_t PRES13:1;                /* Presampling enable for channel 13. */
    vuint32_t PRES12:1;                /* Presampling enable for channel 12. */
    vuint32_t PRES11:1;                /* Presampling enable for channel 11. */
    vuint32_t PRES10:1;                /* Presampling enable for channel 10. */
    vuint32_t PRES9:1;                 /* Presampling enable for channel 9. */
    vuint32_t PRES8:1;                 /* Presampling enable for channel 8. */
    vuint32_t PRES7:1;                 /* Presampling enable for channel 7. */
    vuint32_t PRES6:1;                 /* Presampling enable for channel 6. */
    vuint32_t PRES5:1;                 /* Presampling enable for channel 5. */
    vuint32_t PRES4:1;                 /* Presampling enable for channel 4. */
    vuint32_t PRES3:1;                 /* Presampling enable for channel 3. */
    vuint32_t PRES2:1;                 /* Presampling enable for channel 2. */
    vuint32_t PRES1:1;                 /* Presampling enable for channel 1. */
    vuint32_t PRES0:1;                 /* Presampling enable for channel 0. */
  } B;
} ADC_PSR0_tag;

typedef union ADC_CTR0_union_tag {     /* Conversion Timing Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR0_tag;

typedef union ADC_CTR1_union_tag {     /* Conversion Timing Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t INPSAMP:8;               /* Configuration of sampling phase duration. */
  } B;
} ADC_CTR1_tag;

typedef union ADC_NCMR0_union_tag {    /* Normal Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH15:1;                  /* Normal sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Normal sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Normal sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Normal sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Normal sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Normal sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Normal sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Normal sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Normal sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Normal sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Normal sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Normal sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Normal sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Normal sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Normal sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Normal sampling enable for channel 0. */
  } B;
} ADC_NCMR0_tag;

typedef union ADC_JCMR0_union_tag {    /* Injected Conversion Mask Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH15:1;                  /* Injected sampling enable for channel 15. */
    vuint32_t CH14:1;                  /* Injected sampling enable for channel 14. */
    vuint32_t CH13:1;                  /* Injected sampling enable for channel 13. */
    vuint32_t CH12:1;                  /* Injected sampling enable for channel 12. */
    vuint32_t CH11:1;                  /* Injected sampling enable for channel 11. */
    vuint32_t CH10:1;                  /* Injected sampling enable for channel 10. */
    vuint32_t CH9:1;                   /* Injected sampling enable for channel 9. */
    vuint32_t CH8:1;                   /* Injected sampling enable for channel 8. */
    vuint32_t CH7:1;                   /* Injected sampling enable for channel 7. */
    vuint32_t CH6:1;                   /* Injected sampling enable for channel 6. */
    vuint32_t CH5:1;                   /* Injected sampling enable for channel 5. */
    vuint32_t CH4:1;                   /* Injected sampling enable for channel 4. */
    vuint32_t CH3:1;                   /* Injected sampling enable for channel 3. */
    vuint32_t CH2:1;                   /* Injected sampling enable for channel 2. */
    vuint32_t CH1:1;                   /* Injected sampling enable for channel 1. */
    vuint32_t CH0:1;                   /* Injected sampling enable for channel 0. */
  } B;
} ADC_JCMR0_tag;

typedef union ADC_PDEDR_union_tag {    /* Power Down Exit Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t PDED:8;
  } B;
} ADC_PDEDR_tag;

typedef union ADC_CDR_union_tag {      /* Channel Data Register n (Precision Channels) */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t VALID:1;                 /* Used to notify when the data is valid (a new value has been written). It is automatically cleared when data is read. */
    vuint32_t OVERW:1;                 /* Overwrite data */
    vuint32_t RESULT:2;
    vuint32_t CDATA:16;                /* Converted Data 11:0. */
  } B;
} ADC_CDR_tag;

typedef union ADC_THRHLR4_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR4_tag;

typedef union ADC_THRHLR5_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR5_tag;

typedef union ADC_THRHLR6_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR6_tag;

typedef union ADC_THRHLR7_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR7_tag;

typedef union ADC_THRHLR8_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR8_tag;

typedef union ADC_THRHLR9_union_tag {  /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR9_tag;

typedef union ADC_THRHLR10_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR10_tag;

typedef union ADC_THRHLR11_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR11_tag;

typedef union ADC_THRHLR12_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR12_tag;

typedef union ADC_THRHLR13_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR13_tag;

typedef union ADC_THRHLR14_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR14_tag;

typedef union ADC_THRHLR15_union_tag { /* Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for channel x. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for channel x. */
  } B;
} ADC_THRHLR15_tag;

typedef union ADC_CWSELR0_union_tag {  /* Channel Watchdog Select Register 0 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH7:4;              /* Channel Watchdog select for channel 7. */
    vuint32_t WSEL_CH6:4;              /* Channel Watchdog select for channel 6. */
    vuint32_t WSEL_CH5:4;              /* Channel Watchdog select for channel 5. */
    vuint32_t WSEL_CH4:4;              /* Channel Watchdog select for channel 4. */
    vuint32_t WSEL_CH3:4;              /* Channel Watchdog select for channel 3. */
    vuint32_t WSEL_CH2:4;              /* Channel Watchdog select for channel 2. */
    vuint32_t WSEL_CH1:4;              /* Channel Watchdog select for channel 1. */
    vuint32_t WSEL_CH0:4;              /* Channel Watchdog select for channel 0. */
  } B;
} ADC_CWSELR0_tag;

typedef union ADC_CWSELR1_union_tag {  /* Channel Watchdog Select Register 1 */
  vuint32_t R;
  struct {
    vuint32_t WSEL_CH15:4;             /* Channel Watchdog select for channel 15. */
    vuint32_t WSEL_CH14:4;             /* Channel Watchdog select for channel 14. */
    vuint32_t WSEL_CH13:4;             /* Channel Watchdog select for channel 13. */
    vuint32_t WSEL_CH12:4;             /* Channel Watchdog select for channel 12. */
    vuint32_t WSEL_CH11:4;             /* Channel Watchdog select for channel 11. */
    vuint32_t WSEL_CH10:4;             /* Channel Watchdog select for channel 10. */
    vuint32_t WSEL_CH9:4;              /* Channel Watchdog select for channel 9. */
    vuint32_t WSEL_CH8:4;              /* Channel Watchdog select for channel 8. */
  } B;
} ADC_CWSELR1_tag;

typedef union ADC_CWENR0_union_tag {   /* Channel Watchdog Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CWEN15:1;                /* Watchdog enable for channel 15. */
    vuint32_t CWEN14:1;                /* Watchdog enable for channel 14. */
    vuint32_t CWEN13:1;                /* Watchdog enable for channel 13. */
    vuint32_t CWEN12:1;                /* Watchdog enable for channel 12. */
    vuint32_t CWEN11:1;                /* Watchdog enable for channel 11. */
    vuint32_t CWEN10:1;                /* Watchdog enable for channel 10. */
    vuint32_t CWEN9:1;                 /* Watchdog enable for channel 9. */
    vuint32_t CWEN8:1;                 /* Watchdog enable for channel 8. */
    vuint32_t CWEN7:1;                 /* Watchdog enable for channel 7. */
    vuint32_t CWEN6:1;                 /* Watchdog enable for channel 6. */
    vuint32_t CWEN5:1;                 /* Watchdog enable for channel 5. */
    vuint32_t CWEN4:1;                 /* Watchdog enable for channel 4. */
    vuint32_t CWEN3:1;                 /* Watchdog enable for channel 3. */
    vuint32_t CWEN2:1;                 /* Watchdog enable for channel 2. */
    vuint32_t CWEN1:1;                 /* Watchdog enable for channel 1. */
    vuint32_t CWEN0:1;                 /* Watchdog enable for channel 0. */
  } B;
} ADC_CWENR0_tag;

typedef union ADC_AWORR0_union_tag {   /* Analog Watchdog Out of Range Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t AWOR_CH15:1;             /* Analog watchdog out of range for channel 15. */
    vuint32_t AWOR_CH14:1;             /* Analog watchdog out of range for channel 14. */
    vuint32_t AWOR_CH13:1;             /* Analog watchdog out of range for channel 13. */
    vuint32_t AWOR_CH12:1;             /* Analog watchdog out of range for channel 12. */
    vuint32_t AWOR_CH11:1;             /* Analog watchdog out of range for channel 11. */
    vuint32_t AWOR_CH10:1;             /* Analog watchdog out of range for channel 10. */
    vuint32_t AWOR_CH9:1;              /* Analog watchdog out of range for channel 9. */
    vuint32_t AWOR_CH8:1;              /* Analog watchdog out of range for channel 8. */
    vuint32_t AWOR_CH7:1;              /* Analog watchdog out of range for channel 7. */
    vuint32_t AWOR_CH6:1;              /* Analog watchdog out of range for channel 6. */
    vuint32_t AWOR_CH5:1;              /* Analog watchdog out of range for channel 5. */
    vuint32_t AWOR_CH4:1;              /* Analog watchdog out of range for channel 4. */
    vuint32_t AWOR_CH3:1;              /* Analog watchdog out of range for channel 3. */
    vuint32_t AWOR_CH2:1;              /* Analog watchdog out of range for channel 2. */
    vuint32_t AWOR_CH1:1;              /* Analog watchdog out of range for channel 1. */
    vuint32_t AWOR_CH0:1;              /* Analog watchdog out of range for channel 0. */
  } B;
} ADC_AWORR0_tag;

typedef union ADC_STCR1_union_tag {    /* Self Test Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INPSAMP_C:8;
    vuint32_t _unused_16:8;
    vuint32_t INPSAMP_S:8;
    vuint32_t _unused_3:5;
    vuint32_t _unused_0:3;
  } B;
} ADC_STCR1_tag;

typedef union ADC_STCR2_union_tag {    /* Self Test Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MSKWDSERR:1;
    vuint32_t SERR:1;
    vuint32_t MSKWDTERR:1;             /* Interrupt enable (STSR[WDTERR] status bit) */
    vuint32_t _unused_24:1;
    vuint32_t MSKST_EOC:1;             /* Interrupt Enable bit for STSR2[ST_EOC] */
    vuint32_t _unused_19:4;
    vuint32_t MSKWDG_EOA_C:1;          /* Interrupt enable (WDG_EOA_C status bit) */
    vuint32_t _unused_17:1;
    vuint32_t MSKWDG_EOA_S:1;          /* Interrupt enable (WDG_EOA_S status bit) */
    vuint32_t MSKERR_C:1;              /* Interrupt enable (ERR_C status bit) */
    vuint32_t _unused_14:1;
    vuint32_t MSKERR_S2:1;             /* Interrupt enable (ERR_S2 status bit) */
    vuint32_t MSKERR_S1:1;             /* Interrupt enable (ERR_S1 status bit) */
    vuint32_t MSKERR_S0:1;             /* Interrupt enable (ERR_S0 status bit) */
    vuint32_t _unused_8:3;
    vuint32_t EN:1;                    /* Self testing channel enable. The TEST conversions are enabled. */
    vuint32_t _unused_5:2;
    vuint32_t FMA_WDSERR:1;            /* Fault mapping for the Watchdog Sequence error. */
    vuint32_t FMA_WDTERR:1;            /* Fault mapping for the Watchdog Timer error. */
    vuint32_t FMA_C:1;                 /* Fault mapping for self test algorithm C. */
    vuint32_t _unused_1:1;
    vuint32_t FMA_S:1;                 /* Fault mapping for the self test algorithm BGAP. */
  } B;
} ADC_STCR2_tag;

typedef union ADC_STCR3_union_tag {    /* Self Test Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t ALG:2;                   /* Algorithm scheduling. */
    vuint32_t _unused_5:3;
    vuint32_t MSTEP:5;
  } B;
} ADC_STCR3_tag;

typedef union ADC_STBRR_union_tag {    /* Self Test Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t WDT:3;
    vuint32_t _unused_8:8;
    vuint32_t BR:8;                    /* Baud rate for the selected algorithm in SCAN mode (MCR[MODE] = 1). */
  } B;
} ADC_STBRR_tag;

typedef union ADC_STSR1_union_tag {    /* Self Test Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t WDSERR:1;
    vuint32_t _unused_26:1;
    vuint32_t WDTERR:1;
    vuint32_t OVERWR:1;                /* Overwrite error. */
    vuint32_t ST_EOC:1;                /* Self Test EOC Bit. */
    vuint32_t _unused_19:4;
    vuint32_t WDG_EOA_C:1;
    vuint32_t _unused_17:1;
    vuint32_t WDG_EOA_S:1;
    vuint32_t ERR_C:1;
    vuint32_t _unused_14:1;
    vuint32_t ERR_S2:1;
    vuint32_t ERR_S1:1;
    vuint32_t ERR_S0:1;
    vuint32_t _unused_10:1;
    vuint32_t STEP_C:5;                /* Step of the algorithm C when an ERR_C has occurred. */
    vuint32_t _unused_0:5;
  } B;
} ADC_STSR1_tag;

typedef union ADC_STSR2_union_tag {    /* Self Test Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t OVFL:1;                  /* Overflow Bit */
    vuint32_t _unused_28:3;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_S1 has occurred. */
    vuint32_t _unused_12:4;
    vuint32_t DATA0:12;                /* Test channel converted data when the ERR_S1 has occurred. */
  } B;
} ADC_STSR2_tag;

typedef union ADC_STSR3_union_tag {    /* Self Test Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_S2 has occurred. */
    vuint32_t _unused_12:4;
    vuint32_t DATA0:12;                /* Test channel converted data when the ERR_S0 has occurred. */
  } B;
} ADC_STSR3_tag;

typedef union ADC_STSR4_union_tag {    /* Self Test Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t DATA1:12;                /* Test channel converted data when the ERR_C has occurred. */
    vuint32_t _unused_12:4;
    vuint32_t _unused_0:12;
  } B;
} ADC_STSR4_tag;

typedef union ADC_STDR1_union_tag {    /* Self Test Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t VALID:1;                 /* Valid data. */
    vuint32_t OWERWR:1;                /* Overwrite data. */
    vuint32_t _unused_12:6;
    vuint32_t TCDATA:12;               /* Test channel converted data. */
  } B;
} ADC_STDR1_tag;

typedef union ADC_STDR2_union_tag {    /* Self Test Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t FDATA:12;
    vuint32_t VALID:1;                 /* Valid data. */
    vuint32_t OWERWR:1;                /* Overwrite data. */
    vuint32_t _unused_12:6;
    vuint32_t IDATA:12;
  } B;
} ADC_STDR2_tag;

typedef union ADC_STAW0R_union_tag {   /* Self Test Analog Watchdog Register 0 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable (related to the algorithm S (step 0)) */
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the algorithm S) */
    vuint32_t _unused_28:2;
    vuint32_t THRH:12;                 /* High threshold value for Algorithm S step 0 */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for Algorithm S step 0 */
  } B;
} ADC_STAW0R_tag;

typedef union ADC_STAW1AR_union_tag {  /* Self Test Analog Watchdog Register 1A */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable related to the algorithm S (step1). */
    vuint32_t _unused_28:3;
    vuint32_t THRH:12;                 /* High threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value (integer part) for test channel for algorithm S (step 1) (unsigned coding). */
  } B;
} ADC_STAW1AR_tag;

typedef union ADC_STAW1BR_union_tag {  /* Self Test Analog Watchdog Register 1B */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value (fractional part) for test channel for algorithm S (step 1)(unsigned coding). */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value (fractional part) for test channel for algorithm S (step 1) (unsigned coding). */
  } B;
} ADC_STAW1BR_tag;

typedef union ADC_STAW2R_union_tag {   /* Self Test Analog Watchdog Register 2 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable related to the algorithm S (step2). */
    vuint32_t _unused_12:19;
    vuint32_t THRL:12;                 /* Low threshold value for channel x (unsigned coding). If the analog watchdog is enabled, the STSR1[ERR_S2] status bit is set if STDR1[TCDATA] < THRL. */
  } B;
} ADC_STAW2R_tag;

typedef union ADC_STAW4R_union_tag {   /* Self Test Analog Watchdog Register 4 */
  vuint32_t R;
  struct {
    vuint32_t AWDE:1;                  /* Analog watchdog enable (related to the algorithm C) */
    vuint32_t WDTE:1;                  /* Watchdog timer enable (related to the algorithm C). */
    vuint32_t _unused_28:2;
    vuint32_t THRH:12;                 /* High threshold value for step 0 of C algorithm. */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for step 0 of C algorithm. */
  } B;
} ADC_STAW4R_tag;

typedef union ADC_STAW5R_union_tag {   /* Self Test Analog Watchdog Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t THRH:12;                 /* High threshold value for step N of C algorithm (N = 1 to CS-1). */
    vuint32_t _unused_12:4;
    vuint32_t THRL:12;                 /* Low threshold value for step 0 of C algorithm. */
  } B;
} ADC_STAW5R_tag;

typedef union ADC_CALBISTREG_union_tag { /* Calibration, BIST Control and status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_29:2;
    vuint32_t TSAMP:2;                 /* Test Sample period in Calibration, BIST and Offset calculation process. */
    vuint32_t _unused_24:3;
    vuint32_t _unused_16:8;
    vuint32_t C_T_BUSY:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_7:1;
    vuint32_t NR_SMPL:2;               /* Number of Samples for averaging. */
    vuint32_t AVG_EN:1;                /* Average Enable (for Calibration only). */
    vuint32_t TEST_FAIL:1;             /* Test Fail. */
    vuint32_t _unused_1:2;
    vuint32_t TEST_EN:1;               /* Enable the test. */
  } B;
} ADC_CALBISTREG_tag;

typedef union ADC_OFSGNUSR_union_tag { /* Offset and Gain User Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t GAIN_USER:10;
    vuint32_t _unused_8:8;
    vuint32_t OFFSET_USER:8;
  } B;
} ADC_OFSGNUSR_tag;

struct ADC_tag {
  ADC_MCR_tag MCR;                     /* Main Configuration Register */
  ADC_MSR_tag MSR;                     /* Main Status register */
  uint8_t ADC_reserved0[8];
  ADC_ISR_tag ISR;                     /* Interrupt Status Register */
  ADC_CEOCFR0_tag CEOCFR0;             /* Channel Pending register 0 */
  uint8_t ADC_reserved1[8];
  ADC_IMR_tag IMR;                     /* Interrupt Mask Register */
  ADC_CIMR0_tag CIMR0;                 /* Channel Interrupt Mask Register 0 */
  uint8_t ADC_reserved2[8];
  ADC_WTISR_tag WTISR;                 /* Watchdog Threshold Interrupt Status Register */
  ADC_WTIMR_tag WTIMR;                 /* Watchdog Threshold Interrupt Mask Register */
  uint8_t ADC_reserved3[8];
  ADC_DMAE_tag DMAE;                   /* DMA Enable register */
  ADC_DMAR0_tag DMAR0;                 /* DMA Channel Select Register 0 */
  uint8_t ADC_reserved4[24];
  ADC_THRHLR0_tag THRHLR0;             /* Threshold Register */
  ADC_THRHLR1_tag THRHLR1;             /* Threshold Register */
  ADC_THRHLR2_tag THRHLR2;             /* Threshold Register */
  ADC_THRHLR3_tag THRHLR3;             /* Threshold Register */
  uint8_t ADC_reserved5[16];
  ADC_PSCR_tag PSCR;                   /* Presampling Control Register */
  ADC_PSR0_tag PSR0;                   /* Presampling register 0 */
  uint8_t ADC_reserved6[12];
  ADC_CTR0_tag CTR0;                   /* Conversion Timing Register 0 */
  ADC_CTR1_tag CTR1;                   /* Conversion Timing Register 1 */
  uint8_t ADC_reserved7[8];
  ADC_NCMR0_tag NCMR0;                 /* Normal Conversion Mask Register 0 */
  uint8_t ADC_reserved8[12];
  ADC_JCMR0_tag JCMR0;                 /* Injected Conversion Mask Register 0 */
  uint8_t ADC_reserved9[16];
  ADC_PDEDR_tag PDEDR;                 /* Power Down Exit Delay Register */
  uint8_t ADC_reserved10[52];
  ADC_CDR_tag CDR[16];                 /* Channel Data Register n (Precision Channels) */
  uint8_t ADC_reserved11[320];
  ADC_THRHLR4_tag THRHLR4;             /* Threshold Register */
  ADC_THRHLR5_tag THRHLR5;             /* Threshold Register */
  ADC_THRHLR6_tag THRHLR6;             /* Threshold Register */
  ADC_THRHLR7_tag THRHLR7;             /* Threshold Register */
  ADC_THRHLR8_tag THRHLR8;             /* Threshold Register */
  ADC_THRHLR9_tag THRHLR9;             /* Threshold Register */
  ADC_THRHLR10_tag THRHLR10;           /* Threshold Register */
  ADC_THRHLR11_tag THRHLR11;           /* Threshold Register */
  ADC_THRHLR12_tag THRHLR12;           /* Threshold Register */
  ADC_THRHLR13_tag THRHLR13;           /* Threshold Register */
  ADC_THRHLR14_tag THRHLR14;           /* Threshold Register */
  ADC_THRHLR15_tag THRHLR15;           /* Threshold Register */
  ADC_CWSELR0_tag CWSELR0;             /* Channel Watchdog Select Register 0 */
  ADC_CWSELR1_tag CWSELR1;             /* Channel Watchdog Select Register 1 */
  uint8_t ADC_reserved12[40];
  ADC_CWENR0_tag CWENR0;               /* Channel Watchdog Enable Register 0 */
  uint8_t ADC_reserved13[12];
  ADC_AWORR0_tag AWORR0;               /* Analog Watchdog Out of Range Register 0 */
  uint8_t ADC_reserved14[76];
  ADC_STCR1_tag STCR1;                 /* Self Test Configuration Register 1 */
  ADC_STCR2_tag STCR2;                 /* Self Test Configuration Register 2 */
  ADC_STCR3_tag STCR3;                 /* Self Test Configuration Register 3 */
  ADC_STBRR_tag STBRR;                 /* Self Test Baud Rate Register */
  ADC_STSR1_tag STSR1;                 /* Self Test Status Register 1 */
  ADC_STSR2_tag STSR2;                 /* Self Test Status Register 2 */
  ADC_STSR3_tag STSR3;                 /* Self Test Status Register 3 */
  ADC_STSR4_tag STSR4;                 /* Self Test Status Register 4 */
  uint8_t ADC_reserved15[16];
  ADC_STDR1_tag STDR1;                 /* Self Test Data Register 1 */
  ADC_STDR2_tag STDR2;                 /* Self Test Data Register 2 */
  uint8_t ADC_reserved16[8];
  ADC_STAW0R_tag STAW0R;               /* Self Test Analog Watchdog Register 0 */
  ADC_STAW1AR_tag STAW1AR;             /* Self Test Analog Watchdog Register 1A */
  ADC_STAW1BR_tag STAW1BR;             /* Self Test Analog Watchdog Register 1B */
  ADC_STAW2R_tag STAW2R;               /* Self Test Analog Watchdog Register 2 */
  uint8_t ADC_reserved17[4];
  ADC_STAW4R_tag STAW4R;               /* Self Test Analog Watchdog Register 4 */
  ADC_STAW5R_tag STAW5R;               /* Self Test Analog Watchdog Register 5 */
  uint8_t ADC_reserved18[4];
  ADC_CALBISTREG_tag CALBISTREG;       /* Calibration, BIST Control and status Register */
  uint8_t ADC_reserved19[4];
  ADC_OFSGNUSR_tag OFSGNUSR;           /* Offset and Gain User Register */
};


/* ============================================================================
   =============================== Module: AFE ================================
   ============================================================================ */

typedef union AFE_OSCCTRL_union_tag {  /* Oscillator Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t _unused_16:4;
    vuint32_t _unused_15:1;
    vuint32_t IE:1;
    vuint32_t _unused_12:2;
    vuint32_t EN_EXT:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t ICAL:4;
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} AFE_OSCCTRL_tag;

typedef union AFE_OSCSTS_union_tag {   /* Oscillator Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t _unused_1:1;
    vuint32_t STS:1;                   /* Oscillator status */
  } B;
} AFE_OSCSTS_tag;

typedef union AFE_OSCDLY_union_tag {   /* Oscillator Delay Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EOCV:8;
  } B;
} AFE_OSCDLY_tag;

typedef union AFE_PLLCTRL1_union_tag { /* SDPLL Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t DCBIAS_HI_LIM:4;
    vuint32_t DCBIAS_LO_LIM:4;
    vuint32_t CLKGEN_EN:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_11:3;
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t RST_B:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_1:3;
    vuint32_t _unused_0:1;
  } B;
} AFE_PLLCTRL1_tag;

typedef union AFE_PLLCTRL2_union_tag { /* SDPLL Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FCAP_HI_LIM:6;
    vuint32_t _unused_22:2;
    vuint32_t FCAP_LO_LIM:6;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t START:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_PLLCTRL2_tag;

typedef union AFE_PLLCTRL3_union_tag { /* SDPLL Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t LW64:1;
    vuint32_t _unused_12:1;
    vuint32_t LORIE:1;
    vuint32_t CP_I_SEL:3;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t LCKHIIE:1;
    vuint32_t LCKLOIE:1;
  } B;
} AFE_PLLCTRL3_tag;

typedef union AFE_PLLCTRL8_union_tag { /* SDPLL Control Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t REFCLK_CNT:4;            /* Programmable reference clock count */
    vuint32_t _unused_11:1;
    vuint32_t FCLKBY2_CNT:11;          /* Programmable Fvco/2 clock count */
  } B;
} AFE_PLLCTRL8_tag;

typedef union AFE_PLLSTS_union_tag {   /* SDPLL Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t LCKLOSS:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t CALERR:1;
    vuint32_t LOR:1;
    vuint32_t LOCK:1;                  /* SDPLL lock indicator */
  } B;
} AFE_PLLSTS_tag;

typedef union AFE_ADCCTRL1_union_tag { /* ADC Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t _unused_16:1;
    vuint32_t MM_SEL:2;
    vuint32_t MM_BYP:1;
    vuint32_t MM_RST:1;
    vuint32_t MM_DTHEN:4;
    vuint32_t _unused_6:2;
    vuint32_t _unused_4:2;
    vuint32_t _unused_2:2;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_ADCCTRL1_tag;

typedef union AFE_ADCCTRL2_union_tag { /* ADC Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t _unused_21:5;
    vuint32_t _unused_16:5;
    vuint32_t _unused_13:3;
    vuint32_t RT_PWRDN:1;
    vuint32_t _unused_10:2;
    vuint32_t _unused_9:1;
    vuint32_t _unused_4:5;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_ADCCTRL2_tag;

typedef union AFE_ADCTOT_union_tag {   /* ADC Tracking Oscillator Trim Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TCP_HY_H:8;
    vuint32_t TCP_HY_L:8;
  } B;
} AFE_ADCTOT_tag;

typedef union AFE_ADCRST_union_tag {   /* ADC Reset Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DFFRST:8;
    vuint32_t INTRST:8;
  } B;
} AFE_ADCRST_tag;

typedef union AFE_ADCTRIM_union_tag {  /* ADC Trim Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t _unused_25:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_20:3;
    vuint32_t COVRD:1;
    vuint32_t OVRD_CAP:3;
    vuint32_t RMASK:1;
    vuint32_t RESRDY:1;
    vuint32_t _unused_13:1;
    vuint32_t RESCODE:5;
    vuint32_t _unused_6:2;
    vuint32_t _unused_5:1;
    vuint32_t _unused_0:5;
  } B;
} AFE_ADCTRIM_tag;

typedef union AFE_ADCCTRL7_union_tag { /* ADC Control Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_23:1;
    vuint32_t _unused_21:2;
    vuint32_t _unused_16:5;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t OVPWRDN:1;
    vuint32_t _unused_8:3;
    vuint32_t PWRDN:8;
  } B;
} AFE_ADCCTRL7_tag;

typedef union AFE_ADCOVLD_union_tag {  /* ADC Overload Detect Register */
  vuint32_t R;
  struct {
    vuint32_t OVERVOLT:8;
    vuint32_t OVERVOLTS:8;
    vuint32_t _unused_0:16;
  } B;
} AFE_ADCOVLD_tag;

typedef union AFE_DACCTRL_union_tag {  /* DAC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t FS_ADJ:2;
    vuint32_t _unused_9:1;
    vuint32_t RST:1;
    vuint32_t _unused_3:5;
    vuint32_t _unused_1:2;
    vuint32_t PWRDN:1;
  } B;
} AFE_DACCTRL_tag;

typedef union AFE_VRFCTRL1_union_tag { /* VREF Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t _unused_16:6;
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_7:1;
    vuint32_t _unused_5:2;
    vuint32_t _unused_4:1;
    vuint32_t _unused_1:3;
    vuint32_t PWRDN:1;
  } B;
} AFE_VRFCTRL1_tag;

typedef union AFE_LVDSTS_union_tag {   /* Low Voltage Detect Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t BGOK:1;
    vuint32_t _unused_0:25;
  } B;
} AFE_LVDSTS_tag;

typedef union AFE_VRGRSVD_union_tag {  /* VREG Reserved Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;
  } B;
} AFE_VRGRSVD_tag;

typedef union AFE_VRGCTRL2_union_tag { /* VREG2 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL2_tag;

typedef union AFE_VRGCTRL3_union_tag { /* VREG3 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL3_tag;

typedef union AFE_VRGCTRL4_union_tag { /* VREG4 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL4_tag;

typedef union AFE_VRGCTRL5_union_tag { /* VREG5 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL5_tag;

typedef union AFE_VRGCTRL6_union_tag { /* VREG6 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL6_tag;

typedef union AFE_VRGCTRL7_union_tag { /* VREG7 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL7_tag;

typedef union AFE_VRGCTRL8_union_tag { /* VREG8 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL8_tag;

typedef union AFE_VRGCTRL9_union_tag { /* VREG9 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_4:4;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_VRGCTRL9_tag;

typedef union AFE_FILTCTRL_union_tag { /* Decimation Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t OSR:2;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} AFE_FILTCTRL_tag;

typedef union AFE_FILTCOEFF_union_tag { /* Decimation Filter Coefficient Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t COEFF:14;
  } B;
} AFE_FILTCOEFF_tag;

struct AFE_tag {
  AFE_OSCCTRL_tag OSCCTRL;             /* Oscillator Control Register */
  AFE_OSCSTS_tag OSCSTS;               /* Oscillator Status Register */
  AFE_OSCDLY_tag OSCDLY;               /* Oscillator Delay Register */
  AFE_PLLCTRL1_tag PLLCTRL1;           /* SDPLL Control Register 1 */
  AFE_PLLCTRL2_tag PLLCTRL2;           /* SDPLL Control Register 2 */
  AFE_PLLCTRL3_tag PLLCTRL3;           /* SDPLL Control Register 3 */
  uint8_t AFE_reserved0[16];
  AFE_PLLCTRL8_tag PLLCTRL8;           /* SDPLL Control Register 8 */
  AFE_PLLSTS_tag PLLSTS;               /* SDPLL Status Register */
  AFE_ADCCTRL1_tag ADCCTRL1;           /* ADC Control Register 1 */
  AFE_ADCCTRL2_tag ADCCTRL2;           /* ADC Control Register 2 */
  AFE_ADCTOT_tag ADCTOT;               /* ADC Tracking Oscillator Trim Register */
  AFE_ADCRST_tag ADCRST;               /* ADC Reset Register */
  AFE_ADCTRIM_tag ADCTRIM;             /* ADC Trim Register */
  uint8_t AFE_reserved1[4];
  AFE_ADCCTRL7_tag ADCCTRL7;           /* ADC Control Register 7 */
  AFE_ADCOVLD_tag ADCOVLD;             /* ADC Overload Detect Register */
  AFE_DACCTRL_tag DACCTRL;             /* DAC Control Register */
  AFE_VRFCTRL1_tag VRFCTRL1;           /* VREF Control Register 1 */
  uint8_t AFE_reserved2[4];
  AFE_LVDSTS_tag LVDSTS;               /* Low Voltage Detect Status Register */
  AFE_VRGRSVD_tag VRGRSVD;             /* VREG Reserved Register */
  AFE_VRGCTRL2_tag VRGCTRL2;           /* VREG2 Control Register */
  AFE_VRGCTRL3_tag VRGCTRL3;           /* VREG3 Control Register */
  AFE_VRGCTRL4_tag VRGCTRL4;           /* VREG4 Control Register */
  AFE_VRGCTRL5_tag VRGCTRL5;           /* VREG5 Control Register */
  AFE_VRGCTRL6_tag VRGCTRL6;           /* VREG6 Control Register */
  AFE_VRGCTRL7_tag VRGCTRL7;           /* VREG7 Control Register */
  AFE_VRGCTRL8_tag VRGCTRL8;           /* VREG8 Control Register */
  uint8_t AFE_reserved3[4];
  AFE_VRGCTRL9_tag VRGCTRL9;           /* VREG9 Control Register */
  uint8_t AFE_reserved4[24];
  AFE_FILTCTRL_tag FILTCTRL[8];        /* Decimation Filter Control Register */
  AFE_FILTCOEFF_tag FILTCOEFF[8][16];  /* Decimation Filter Coefficient Register 0 */
};


/* ============================================================================
   =============================== Module: AIPS ===============================
   ============================================================================ */

typedef union AIPS_MPRA_union_tag {    /* Master Privilege Register A */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR0:1;                  /* Master 0 Trusted For Read */
    vuint32_t MTW0:1;                  /* Master 0 Trusted For Writes */
    vuint32_t MPL0:1;                  /* Master 0 Privilege Level */
    vuint32_t _unused_27:1;
    vuint32_t MTR1:1;                  /* Master 1 trusted for read */
    vuint32_t MTW1:1;                  /* Master 1 trusted for writes */
    vuint32_t MPL1:1;                  /* Master 1 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t MTR2:1;                  /* Master 2 Trusted For Read */
    vuint32_t MTW2:1;                  /* Master 2 Trusted For Writes */
    vuint32_t MPL2:1;                  /* Master 2 Privilege Level */
    vuint32_t _unused_19:1;
    vuint32_t MTR3:1;                  /* Master 3 Trusted For Read */
    vuint32_t MTW3:1;                  /* Master 3 Trusted For Writes */
    vuint32_t MPL3:1;                  /* Master 3 Privilege Level */
    vuint32_t _unused_15:1;
    vuint32_t MTR4:1;                  /* Master 4 Trusted For Read */
    vuint32_t MTW4:1;                  /* Master 4 Trusted For Writes */
    vuint32_t MPL4:1;                  /* Master 4 Privilege Level */
    vuint32_t _unused_11:1;
    vuint32_t MTR5:1;                  /* Master 5 Trusted For Read */
    vuint32_t MTW5:1;                  /* Master 5 Trusted For Writes */
    vuint32_t MPL5:1;                  /* Master 5 Privilege Level */
    vuint32_t _unused_7:1;
    vuint32_t MTR6:1;                  /* Master 6 trusted for read */
    vuint32_t MTW6:1;                  /* Master 6 trusted for writes */
    vuint32_t MPL6:1;                  /* Master 6 privilege level */
    vuint32_t _unused_3:1;
    vuint32_t MTR7:1;                  /* Master 7 trusted for read */
    vuint32_t MTW7:1;                  /* Master 7 trusted for writes */
    vuint32_t MPL7:1;                  /* Master 7 privilege level */
  } B;
} AIPS_MPRA_tag;

typedef union AIPS_MPRB_union_tag {    /* Master Privilege Register B */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MTR8:1;                  /* Master 8 trusted for read */
    vuint32_t MTW8:1;                  /* Master 8 trusted for writes */
    vuint32_t MPL8:1;                  /* Master 8 privilege level */
    vuint32_t _unused_27:1;
    vuint32_t MTR9:1;                  /* Master 9 trusted for read */
    vuint32_t MTW9:1;                  /* Master 9 trusted for writes */
    vuint32_t MPL9:1;                  /* Master 9 privilege level */
    vuint32_t _unused_23:1;
    vuint32_t _unused_20:3;
    vuint32_t _unused_19:1;
    vuint32_t _unused_16:3;
    vuint32_t _unused_15:1;
    vuint32_t _unused_12:3;
    vuint32_t _unused_11:1;
    vuint32_t MTR13:1;                 /* Master 13 trusted for read */
    vuint32_t MTW13:1;                 /* Master 13 trusted for writes */
    vuint32_t MPL13:1;                 /* Master 13 Privilege Level */
    vuint32_t _unused_7:1;
    vuint32_t MTR14:1;                 /* Master 14 trusted for read */
    vuint32_t MTW14:1;                 /* Master 14 Trusted For Writes */
    vuint32_t MP14:1;                  /* Master 14 privilege level */
    vuint32_t _unused_3:1;
    vuint32_t MTR15:1;                 /* Master 15 Trusted For Read */
    vuint32_t MTW15:1;                 /* Master 15 trusted for writes */
    vuint32_t MPL15:1;                 /* Master 15 privilege level */
  } B;
} AIPS_MPRB_tag;

typedef union AIPS_PACRA_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRA_tag;

typedef union AIPS_PACRB_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRB_tag;

typedef union AIPS_PACRC_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRC_tag;

typedef union AIPS_PACRD_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRD_tag;

typedef union AIPS_PACR_Reserved_union_tag { /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACR_Reserved_tag;

typedef union AIPS_PACRF_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRF_tag;

typedef union AIPS_PACRG_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRG_tag;

typedef union AIPS_PACRH_union_tag {   /* Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_PACRH_tag;

typedef union AIPS_OPACRA_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRA_tag;

typedef union AIPS_OPACRB_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRB_tag;

typedef union AIPS_OPACRC_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRC_tag;

typedef union AIPS_OPACRD_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRD_tag;

typedef union AIPS_OPACRE_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRE_tag;

typedef union AIPS_OPACRF_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRF_tag;

typedef union AIPS_OPACRG_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRG_tag;

typedef union AIPS_OPACRH_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRH_tag;

typedef union AIPS_OPACRI_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRI_tag;

typedef union AIPS_OPACRJ_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRJ_tag;

typedef union AIPS_OPACRK_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRK_tag;

typedef union AIPS_OPACRL_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRL_tag;

typedef union AIPS_OPACRM_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRM_tag;

typedef union AIPS_OPACRN_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRN_tag;

typedef union AIPS_OPACRO_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRO_tag;

typedef union AIPS_OPACRP_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRP_tag;

typedef union AIPS_OPACRQ_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRQ_tag;

typedef union AIPS_OPACRR_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRR_tag;

typedef union AIPS_OPACRS_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRS_tag;

typedef union AIPS_OPACRT_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRT_tag;

typedef union AIPS_OPACRU_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRU_tag;

typedef union AIPS_OPACRV_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRV_tag;

typedef union AIPS_OPACRW_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRW_tag;

typedef union AIPS_OPACRX_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRX_tag;

typedef union AIPS_OPACRY_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRY_tag;

typedef union AIPS_OPACRZ_union_tag {  /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRZ_tag;

typedef union AIPS_OPACRAA_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRAA_tag;

typedef union AIPS_OPACRAB_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRAB_tag;

typedef union AIPS_OPACRAC_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRAC_tag;

typedef union AIPS_OPACRAD_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRAD_tag;

typedef union AIPS_OPACRAE_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRAE_tag;

typedef union AIPS_OPACRAF_union_tag { /* Off-Platform Peripheral Access Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t SP0:1;                   /* Supervisor Protect */
    vuint32_t WP0:1;                   /* Write Protect */
    vuint32_t TP0:1;                   /* Trusted Protect */
    vuint32_t _unused_27:1;
    vuint32_t SP1:1;                   /* Supervisor Protect */
    vuint32_t WP1:1;                   /* Write Protect */
    vuint32_t TP1:1;                   /* Trusted Protect */
    vuint32_t _unused_23:1;
    vuint32_t SP2:1;                   /* Supervisor Protect */
    vuint32_t WP2:1;                   /* Write Protect */
    vuint32_t TP2:1;                   /* Trusted Protect */
    vuint32_t _unused_19:1;
    vuint32_t SP3:1;                   /* Supervisor Protect */
    vuint32_t WP3:1;                   /* Write Protect */
    vuint32_t TP3:1;                   /* Trusted Protect */
    vuint32_t _unused_15:1;
    vuint32_t SP4:1;                   /* Supervisor Protect */
    vuint32_t WP4:1;                   /* Write Protect */
    vuint32_t TP4:1;                   /* Trusted Protect */
    vuint32_t _unused_11:1;
    vuint32_t SP5:1;                   /* Supervisor Protect */
    vuint32_t WP5:1;                   /* Write Protect */
    vuint32_t TP5:1;                   /* Trusted Protect */
    vuint32_t _unused_7:1;
    vuint32_t SP6:1;                   /* Supervisor Protect */
    vuint32_t WP6:1;                   /* Write Protect */
    vuint32_t TP6:1;                   /* Trusted Protect */
    vuint32_t _unused_3:1;
    vuint32_t SP7:1;                   /* Supervisor Protect */
    vuint32_t WP7:1;                   /* Write Protect */
    vuint32_t TP7:1;                   /* Trusted Protect */
  } B;
} AIPS_OPACRAF_tag;

struct AIPS_tag {
  AIPS_MPRA_tag MPRA;                  /* Master Privilege Register A */
  AIPS_MPRB_tag MPRB;                  /* Master Privilege Register B */
  uint8_t AIPS_reserved0[248];
  AIPS_PACRA_tag PACRA;                /* Peripheral Access Control Register */
  AIPS_PACRB_tag PACRB;                /* Peripheral Access Control Register */
  AIPS_PACRC_tag PACRC;                /* Peripheral Access Control Register */
  AIPS_PACRD_tag PACRD;                /* Peripheral Access Control Register */
  AIPS_PACR_Reserved_tag PACR_Reserved; /* Peripheral Access Control Register */
  AIPS_PACRF_tag PACRF;                /* Peripheral Access Control Register */
  AIPS_PACRG_tag PACRG;                /* Peripheral Access Control Register */
  AIPS_PACRH_tag PACRH;                /* Peripheral Access Control Register */
  uint8_t AIPS_reserved1[32];
  AIPS_OPACRA_tag OPACRA;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRB_tag OPACRB;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRC_tag OPACRC;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRD_tag OPACRD;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRE_tag OPACRE;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRF_tag OPACRF;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRG_tag OPACRG;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRH_tag OPACRH;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRI_tag OPACRI;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRJ_tag OPACRJ;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRK_tag OPACRK;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRL_tag OPACRL;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRM_tag OPACRM;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRN_tag OPACRN;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRO_tag OPACRO;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRP_tag OPACRP;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRQ_tag OPACRQ;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRR_tag OPACRR;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRS_tag OPACRS;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRT_tag OPACRT;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRU_tag OPACRU;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRV_tag OPACRV;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRW_tag OPACRW;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRX_tag OPACRX;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRY_tag OPACRY;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRZ_tag OPACRZ;              /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRAA_tag OPACRAA;            /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRAB_tag OPACRAB;            /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRAC_tag OPACRAC;            /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRAD_tag OPACRAD;            /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRAE_tag OPACRAE;            /* Off-Platform Peripheral Access Control Register */
  AIPS_OPACRAF_tag OPACRAF;            /* Off-Platform Peripheral Access Control Register */
};


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

typedef union C55FMC_MCR_union_tag {   /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t RVE:1;                   /* Read Voltage Error */
    vuint32_t RRE:1;                   /* Read Reference Error */
    vuint32_t AEE:1;                   /* Address Encode Error */
    vuint32_t EEE:1;                   /* ECC after ECC Error */
    vuint32_t _unused_16:12;
    vuint32_t EER:1;                   /* ECC Event Error */
    vuint32_t RWE:1;                   /* Read-While-Write Event Error */
    vuint32_t SBC:1;                   /* Single Bit Correction */
    vuint32_t _unused_12:1;
    vuint32_t PEAS:1;                  /* Program Access Space */
    vuint32_t DONE:1;                  /* State Machine Status */
    vuint32_t PEG:1;                   /* Program/Erase Good */
    vuint32_t PECIE:1;                 /* Program/Erase Complete Interrupt Enable */
    vuint32_t _unused_5:3;
    vuint32_t PGM:1;                   /* Program */
    vuint32_t PSUS:1;                  /* Program Suspend */
    vuint32_t ERS:1;                   /* Erase */
    vuint32_t ESUS:1;                  /* Erase Suspend */
    vuint32_t EHV:1;                   /* Enable High Voltage */
  } B;
} C55FMC_MCR_tag;

typedef union C55FMC_MCRE_union_tag {  /* Extended Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t HT:1;                    /* High Temperature Enabled. */
    vuint32_t _unused_29:2;
    vuint32_t n256K:5;
    vuint32_t n64Kh:3;
    vuint32_t n32Kh:2;
    vuint32_t n16Kh:3;
    vuint32_t n64Km:3;
    vuint32_t n32Km:2;
    vuint32_t n16Km:3;
    vuint32_t n64Kl:3;
    vuint32_t n32Kl:2;
    vuint32_t n16Kl:3;
  } B;
} C55FMC_MCRE_tag;

typedef union C55FMC_LOCK0_union_tag { /* Lock 0 register */
  vuint32_t R;
  struct {
    vuint32_t TSLOCK:1;                /* UTest NVM Lock. */
    vuint32_t _unused_30:1;
    vuint32_t LOWLOCK:14;              /* Low Block Lock */
    vuint32_t MIDLOCK:16;              /* Mid Block Lock */
  } B;
} C55FMC_LOCK0_tag;

typedef union C55FMC_LOCK1_union_tag { /* Lock 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHLOCK:16;             /* High Block Lock */
  } B;
} C55FMC_LOCK1_tag;

typedef union C55FMC_LOCK2_union_tag { /* Lock 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KLOCK:32;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK2_tag;

typedef union C55FMC_LOCK3_union_tag { /* Lock 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KLOCK:16;            /* 256 KB Block Lock */
  } B;
} C55FMC_LOCK3_tag;

typedef union C55FMC_SEL0_union_tag {  /* Select 0 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t LOWSEL:14;               /* LOW Block Select. */
    vuint32_t MIDSEL:16;               /* Mid Block Select. */
  } B;
} C55FMC_SEL0_tag;

typedef union C55FMC_SEL1_union_tag {  /* Select 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t HIGHSEL:16;              /* High Block Select. */
  } B;
} C55FMC_SEL1_tag;

typedef union C55FMC_SEL2_union_tag {  /* Select 2 register */
  vuint32_t R;
  struct {
    vuint32_t A256KSEL:32;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL2_tag;

typedef union C55FMC_SEL3_union_tag {  /* Select 3 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t A256KSEL:16;             /* 256 KB Block Select. */
  } B;
} C55FMC_SEL3_tag;

typedef union C55FMC_ADR_union_tag {   /* Address register */
  vuint32_t R;
  struct {
    vuint32_t SAD:1;
    vuint32_t aH:1;
    vuint32_t aM:1;
    vuint32_t aL:1;
    vuint32_t a256k:1;
    vuint32_t a64k:1;
    vuint32_t a32k:1;
    vuint32_t a16k:1;
    vuint32_t ADDR:21;
    vuint32_t _unused_0:3;
  } B;
} C55FMC_ADR_tag;

typedef union C55FMC_UT0_union_tag {   /* UTest 0 register */
  vuint32_t R;
  struct {
    vuint32_t UTE:1;
    vuint32_t SBCE:1;
    vuint32_t _unused_19:11;
    vuint32_t CPR:1;
    vuint32_t CPA:1;
    vuint32_t CPE:1;
    vuint32_t _unused_10:6;
    vuint32_t NAIBP:1;
    vuint32_t AIBPE:1;
    vuint32_t _unused_7:1;
    vuint32_t AISUS:1;
    vuint32_t MRE:1;
    vuint32_t MRV:1;
    vuint32_t _unused_3:1;
    vuint32_t AIS:1;
    vuint32_t AIE:1;
    vuint32_t AID:1;
  } B;
} C55FMC_UT0_tag;

typedef union C55FMC_UM_union_tag {    /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t MISR:32;
  } B;
} C55FMC_UM_tag;

typedef union C55FMC_UM9_union_tag {   /* UMISR register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t MISR:1;                  /* MISR[288]. */
  } B;
} C55FMC_UM9_tag;

typedef union C55FMC_TMD_union_tag {   /* Test Mode Disable Password Check register */
  vuint32_t R;
  struct {
    vuint32_t PWD:32;                  /* Password challenge */
  } B;
} C55FMC_TMD_tag;
struct C55FMC_tag {
  C55FMC_MCR_tag MCR;                  /* Module Configuration Register */
  uint8_t C55FMC_reserved0[4];
  C55FMC_MCRE_tag MCRE;                /* Extended Module Configuration Register */
  uint8_t C55FMC_reserved1[4];
  C55FMC_LOCK0_tag LOCK0;              /* Lock 0 register */
  C55FMC_LOCK1_tag LOCK1;              /* Lock 1 register */
  C55FMC_LOCK2_tag LOCK2;              /* Lock 2 register */
  C55FMC_LOCK3_tag LOCK3;              /* Lock 3 register */
  uint8_t C55FMC_reserved2[24];
  C55FMC_SEL0_tag SEL0;                /* Select 0 register */
  C55FMC_SEL1_tag SEL1;                /* Select 1 register */
  C55FMC_SEL2_tag SEL2;                /* Select 2 register */
  C55FMC_SEL3_tag SEL3;                /* Select 3 register */
  uint8_t C55FMC_reserved3[8];
  C55FMC_ADR_tag ADR;                  /* Address register */
  C55FMC_UT0_tag UT0;                  /* UTest 0 register */
  C55FMC_UM_tag UM[9];                 /* UMISR register */
  C55FMC_UM9_tag UM9;                  /* UMISR register */
  uint8_t C55FMC_reserved4[16];
  C55FMC_TMD_tag TMD;                  /* Test Mode Disable Password Check register */
};


/* ============================================================================
   =============================== Module: CAN ================================
   ============================================================================ */

typedef union CAN_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t RFEN:1;                  /* Rx FIFO Enable */
    vuint32_t HALT:1;                  /* Halt FlexCAN */
    vuint32_t NOTRDY:1;                /* FlexCAN Not Ready */
    vuint32_t _unused_26:1;
    vuint32_t SOFTRST:1;               /* Soft Reset */
    vuint32_t FRZACK:1;                /* Freeze Mode Acknowledge */
    vuint32_t SUPV:1;                  /* Supervisor Mode */
    vuint32_t _unused_22:1;
    vuint32_t WRNEN:1;                 /* Warning Interrupt Enable */
    vuint32_t LPMACK:1;                /* Low-Power Mode Acknowledge */
    vuint32_t _unused_19:1;
    vuint32_t _unused_18:1;
    vuint32_t SRXDIS:1;                /* Self Reception Disable */
    vuint32_t IRMQ:1;                  /* Individual Rx Masking And Queue Enable */
    vuint32_t _unused_15:1;
    vuint32_t _unused_14:1;
    vuint32_t LPRIOEN:1;               /* Local Priority Enable */
    vuint32_t AEN:1;                   /* Abort Enable */
    vuint32_t _unused_10:2;
    vuint32_t IDAM:2;                  /* ID Acceptance Mode */
    vuint32_t _unused_7:1;
    vuint32_t MAXMB:7;                 /* Number Of The Last Message Buffer */
  } B;
} CAN_MCR_tag;

typedef union CAN_CTRL1_union_tag {    /* Control 1 register */
  vuint32_t R;
  struct {
    vuint32_t PRESDIV:8;               /* Prescaler Division Factor */
    vuint32_t RJW:2;                   /* Resync Jump Width */
    vuint32_t PSEG1:3;                 /* Phase Segment 1 */
    vuint32_t PSEG2:3;                 /* Phase Segment 2 */
    vuint32_t BOFFMSK:1;               /* Bus Off Mask */
    vuint32_t ERRMSK:1;                /* Error Mask */
    vuint32_t CLKSRC:1;                /* CAN Engine Clock Source */
    vuint32_t LPB:1;                   /* Loop Back Mode */
    vuint32_t TWRNMSK:1;               /* Tx Warning Interrupt Mask */
    vuint32_t RWRNMSK:1;               /* Rx Warning Interrupt Mask */
    vuint32_t _unused_8:2;
    vuint32_t SMP:1;                   /* CAN Bit Sampling */
    vuint32_t BOFFREC:1;               /* Bus Off Recovery */
    vuint32_t TSYN:1;                  /* Timer Sync */
    vuint32_t LBUF:1;                  /* Lowest Buffer Transmitted First */
    vuint32_t LOM:1;                   /* Listen-Only Mode */
    vuint32_t PROPSEG:3;               /* Propagation Segment */
  } B;
} CAN_CTRL1_tag;

typedef union CAN_TIMER_union_tag {    /* Free Running Timer */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TIMER:16;                /* Timer Value */
  } B;
} CAN_TIMER_tag;

typedef union CAN_RXMGMASK_union_tag { /* Rx Mailboxes Global Mask Register */
  vuint32_t R;
  struct {
    vuint32_t MG:32;                   /* Rx Mailboxes Global Mask Bits */
  } B;
} CAN_RXMGMASK_tag;

typedef union CAN_RX14MASK_union_tag { /* Rx 14 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX14M:32;                /* Rx Buffer 14 Mask Bits */
  } B;
} CAN_RX14MASK_tag;

typedef union CAN_RX15MASK_union_tag { /* Rx 15 Mask register */
  vuint32_t R;
  struct {
    vuint32_t RX15M:32;                /* Rx Buffer 15 Mask Bits */
  } B;
} CAN_RX15MASK_tag;

typedef union CAN_ECR_union_tag {      /* Error Counter */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RXERRCNT:8;              /* Receive Error Counter */
    vuint32_t TXERRCNT:8;              /* Transmit Error Counter */
  } B;
} CAN_ECR_tag;

typedef union CAN_ESR1_union_tag {     /* Error and Status 1 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t SYNCH:1;                 /* CAN Synchronization Status */
    vuint32_t TWRNINT:1;               /* Tx Warning Interrupt Flag */
    vuint32_t RWRNINT:1;               /* Rx Warning Interrupt Flag */
    vuint32_t BIT1ERR:1;               /* Bit1 Error */
    vuint32_t BIT0ERR:1;               /* Bit0 Error */
    vuint32_t ACKERR:1;                /* Acknowledge Error */
    vuint32_t CRCERR:1;                /* Cyclic Redundancy Check Error */
    vuint32_t FRMERR:1;                /* Form Error */
    vuint32_t STFERR:1;                /* Stuffing Error */
    vuint32_t TXWRN:1;                 /* TX Error Warning */
    vuint32_t RXWRN:1;                 /* Rx Error Warning */
    vuint32_t IDLE:1;
    vuint32_t TX:1;                    /* FlexCAN In Transmission */
    vuint32_t FLTCONF:2;               /* Fault Confinement State */
    vuint32_t RX:1;                    /* FlexCAN In Reception */
    vuint32_t BOFFINT:1;               /* Bus Off Interrupt */
    vuint32_t ERRINT:1;                /* Error Interrupt */
    vuint32_t _unused_0:1;
  } B;
} CAN_ESR1_tag;

typedef union CAN_IMASK2_union_tag {   /* Interrupt Masks 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUFHM:32;                /* Buffer MB i Mask */
  } B;
} CAN_IMASK2_tag;

typedef union CAN_IMASK1_union_tag {   /* Interrupt Masks 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUFLM:32;                /* Buffer MB i Mask */
  } B;
} CAN_IMASK1_tag;

typedef union CAN_IFLAG2_union_tag {   /* Interrupt Flags 2 register */
  vuint32_t R;
  struct {
    vuint32_t BUFHI:32;                /* Buffer MB i Interrupt */
  } B;
} CAN_IFLAG2_tag;

typedef union CAN_IFLAG1_union_tag {   /* Interrupt Flags 1 register */
  vuint32_t R;
  struct {
    vuint32_t BUF31TO8I:24;            /* Buffer MBi Interrupt */
    vuint32_t BUF7I:1;                 /* Buffer MB7 Interrupt Or "Rx FIFO Overflow" */
    vuint32_t BUF6I:1;                 /* Buffer MB6 Interrupt Or "Rx FIFO Warning" */
    vuint32_t BUF5I:1;                 /* Buffer MB5 Interrupt Or "Frames available in Rx FIFO" */
    vuint32_t BUF4TO1I:4;              /* Buffer MB i Interrupt Or "reserved" */
    vuint32_t BUF0I:1;                 /* Buffer MB0 Interrupt Or "reserved" */
  } B;
} CAN_IFLAG1_tag;

typedef union CAN_CTRL2_union_tag {    /* Control 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t ECRWRE:1;                /* Error-correction Configuration Register Write Enable */
    vuint32_t WRMFRZ:1;                /* Write-Access To Memory In Freeze Mode */
    vuint32_t RFFN:4;                  /* Number Of Rx FIFO Filters */
    vuint32_t TASD:5;                  /* Tx Arbitration Start Delay */
    vuint32_t MRP:1;                   /* Mailboxes Reception Priority */
    vuint32_t RRS:1;                   /* Remote Request Storing */
    vuint32_t EACEN:1;                 /* Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes */
    vuint32_t _unused_0:16;
  } B;
} CAN_CTRL2_tag;

typedef union CAN_ESR2_union_tag {     /* Error and Status 2 register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LPTM:7;                  /* Lowest Priority Tx Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t VPS:1;                   /* Valid Priority Status */
    vuint32_t IMB:1;                   /* Inactive Mailbox */
    vuint32_t _unused_0:13;
  } B;
} CAN_ESR2_tag;

typedef union CAN_CRCR_union_tag {     /* CRC Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t MBCRC:7;                 /* CRC Mailbox */
    vuint32_t _unused_15:1;
    vuint32_t TXCRC:15;                /* CRC Transmitted */
  } B;
} CAN_CRCR_tag;

typedef union CAN_RXFGMASK_union_tag { /* Rx FIFO Global Mask register */
  vuint32_t R;
  struct {
    vuint32_t FGM:32;                  /* Rx FIFO Global Mask Bits */
  } B;
} CAN_RXFGMASK_tag;

typedef union CAN_RXFIR_union_tag {    /* Rx FIFO Information Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t IDHIT:9;                 /* Identifier Acceptance Filter Hit Indicator */
  } B;
} CAN_RXFIR_tag;

typedef union CAN_MB_CS_union_tag {    /* Message Buffer 0 CS Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t CODE:4;                  /* Message Buffer Code */
    vuint32_t _unused_23:1;
    vuint32_t SRR:1;                   /* Substitute Remote Request. Contains a fixed recessive bit. */
    vuint32_t IDE:1;                   /* ID Extended. One/zero for extended/standard format frame. */
    vuint32_t RTR:1;                   /* Remote Transmission Request. One/zero for remote/data frame. */
    vuint32_t DLC:4;                   /* Length of the data to be stored/transmitted. */
    vuint32_t TIMESTAMP:16;            /* Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus. */
  } B;
} CAN_MB_CS_tag;

typedef union CAN_MB_ID_union_tag {    /* Message Buffer 0 ID Register */
  vuint32_t R;
  struct {
    vuint32_t PRIO:3;                  /* Local Priority */
    vuint32_t ID_STD:11;               /* Frame Identifier Standard */
    vuint32_t ID_EXT:18;               /* Frame Identifier Extended */
  } B;
} CAN_MB_ID_tag;

typedef union CAN_MB_DATA_union_tag {
  vuint8_t B[8];
  vuint16_t H[4];
  vuint32_t W[2];
} CAN_MB_DATA_tag;

typedef struct CAN_MB_struct_tag {
  CAN_MB_CS_tag CS;                    /* Message Buffer 0 CS Register */
  CAN_MB_ID_tag ID;                    /* Message Buffer 0 ID Register */
  CAN_MB_DATA_tag DATA;
} CAN_MB_tag;

typedef union CAN_RXIMR_union_tag {    /* Rx Individual Mask Registers */
  vuint32_t R;
  struct {
    vuint32_t MI:32;                   /* Individual Mask Bits */
  } B;
} CAN_RXIMR_tag;

typedef union CAN_MECR_union_tag {     /* Memory Error Control Register */
  vuint32_t R;
  struct {
    vuint32_t ECRWRDIS:1;              /* Error Configuration Register Write Disable */
    vuint32_t _unused_17:14;
    vuint32_t CEI_MSK:1;               /* Correctable Errors Interrupt Mask */
    vuint32_t HAERRIE:1;               /* Host Access Error Injection Enable */
    vuint32_t FAERRIE:1;               /* FlexCAN Access Error Injection Enable */
    vuint32_t EXTERRIE:1;              /* Extended Error Injection Enable */
    vuint32_t _unused_10:3;
    vuint32_t RERRDIS:1;               /* Error Report Disable */
    vuint32_t ECCDIS:1;                /* Error Correction Disable */
    vuint32_t NCEFAFRZ:1;              /* Non-Correctable Errors In FlexCAN Access Put Device In Freeze Mode */
    vuint32_t _unused_0:7;
  } B;
} CAN_MECR_tag;

typedef union CAN_ERRIAR_union_tag {   /* Error Injection Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t INJADDR:14;              /* Address Where Error Is To Be Injected */
  } B;
} CAN_ERRIAR_tag;

typedef union CAN_ERRIDPR_union_tag {  /* Error Injection Data Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t DFLIP:32;                /* Data flip pattern */
  } B;
} CAN_ERRIDPR_tag;

typedef union CAN_ERRIPPR_union_tag {  /* Error Injection Parity Pattern Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t PFLIP3:5;                /* Parity Flip Pattern For Byte 3 (most significant) */
    vuint32_t _unused_21:3;
    vuint32_t PFLIP2:5;                /* Parity Flip Pattern For Byte 2 */
    vuint32_t _unused_13:3;
    vuint32_t PFLIP1:5;                /* Parity Flip Pattern For Byte 1 */
    vuint32_t _unused_5:3;
    vuint32_t PFLIP0:5;                /* Parity Flip Pattern For Byte 0 (Least Significant) */
  } B;
} CAN_ERRIPPR_tag;

typedef union CAN_RERRAR_union_tag {   /* Error Report Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t NCE:1;                   /* Non-Correctable Error */
    vuint32_t _unused_19:5;
    vuint32_t SAID:3;
    vuint32_t _unused_14:2;
    vuint32_t ERRADDR:14;              /* Address Where The Error Was Detected */
  } B;
} CAN_RERRAR_tag;

typedef union CAN_RERRDR_union_tag {   /* Error Report Data Register */
  vuint32_t R;
  struct {
    vuint32_t RDATA:32;                /* Raw data word read from memory with error */
  } B;
} CAN_RERRDR_tag;

typedef union CAN_RERRSYNR_union_tag { /* Error Report Syndrome Register */
  vuint32_t R;
  struct {
    vuint32_t BE3:1;                   /* Byte Enabled For Byte 3 (Most Significant) */
    vuint32_t _unused_29:2;
    vuint32_t SYND3:5;                 /* Error Syndrome For Byte 3 (Most Significant) */
    vuint32_t BE2:1;                   /* Byte Enabled For Byte 2 */
    vuint32_t _unused_21:2;
    vuint32_t SYND2:5;                 /* Error Syndrome For Byte 2 */
    vuint32_t BE1:1;                   /* Byte Enabled For Byte 1 */
    vuint32_t _unused_13:2;
    vuint32_t SYND1:5;                 /* Error Syndrome for Byte 1 */
    vuint32_t BE0:1;                   /* Byte Enabled For Byte 0 (least significant) */
    vuint32_t _unused_5:2;
    vuint32_t SYND0:5;                 /* Error Syndrome For Byte 0 (least significant) */
  } B;
} CAN_RERRSYNR_tag;

typedef union CAN_ERRSR_union_tag {    /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t HANCEIF:1;               /* Host Access With Non-Correctable Error Interrupt Flag */
    vuint32_t FANCEIF:1;               /* FlexCAN Access With Non-Correctable Error Interrupt Flag */
    vuint32_t _unused_17:1;
    vuint32_t CEIF:1;                  /* Correctable Error Interrupt Flag */
    vuint32_t _unused_4:12;
    vuint32_t HANCEIOF:1;              /* Host Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t FANCEIOF:1;              /* FlexCAN Access With Non-Correctable Error Interrupt Overrun Flag */
    vuint32_t _unused_1:1;
    vuint32_t CEIOF:1;                 /* Correctable Error Interrupt Overrun Flag */
  } B;
} CAN_ERRSR_tag;

struct CAN_tag {
  CAN_MCR_tag MCR;                     /* Module Configuration Register */
  CAN_CTRL1_tag CTRL1;                 /* Control 1 register */
  CAN_TIMER_tag TIMER;                 /* Free Running Timer */
  uint8_t CAN_reserved0[4];
  CAN_RXMGMASK_tag RXMGMASK;           /* Rx Mailboxes Global Mask Register */
  CAN_RX14MASK_tag RX14MASK;           /* Rx 14 Mask register */
  CAN_RX15MASK_tag RX15MASK;           /* Rx 15 Mask register */
  CAN_ECR_tag ECR;                     /* Error Counter */
  CAN_ESR1_tag ESR1;                   /* Error and Status 1 register */
  CAN_IMASK2_tag IMASK2;               /* Interrupt Masks 2 register */
  CAN_IMASK1_tag IMASK1;               /* Interrupt Masks 1 register */
  CAN_IFLAG2_tag IFLAG2;               /* Interrupt Flags 2 register */
  CAN_IFLAG1_tag IFLAG1;               /* Interrupt Flags 1 register */
  CAN_CTRL2_tag CTRL2;                 /* Control 2 register */
  CAN_ESR2_tag ESR2;                   /* Error and Status 2 register */
  uint8_t CAN_reserved1[8];
  CAN_CRCR_tag CRCR;                   /* CRC Register */
  CAN_RXFGMASK_tag RXFGMASK;           /* Rx FIFO Global Mask register */
  CAN_RXFIR_tag RXFIR;                 /* Rx FIFO Information Register */
  uint8_t CAN_reserved2[48];
  CAN_MB_tag MB[64];
  uint8_t CAN_reserved3[1024];
  CAN_RXIMR_tag RXIMR[64];             /* Rx Individual Mask Registers */
  uint8_t CAN_reserved4[352];
  CAN_MECR_tag MECR;                   /* Memory Error Control Register */
  CAN_ERRIAR_tag ERRIAR;               /* Error Injection Address Register */
  CAN_ERRIDPR_tag ERRIDPR;             /* Error Injection Data Pattern Register */
  CAN_ERRIPPR_tag ERRIPPR;             /* Error Injection Parity Pattern Register */
  CAN_RERRAR_tag RERRAR;               /* Error Report Address Register */
  CAN_RERRDR_tag RERRDR;               /* Error Report Data Register */
  CAN_RERRSYNR_tag RERRSYNR;           /* Error Report Syndrome Register */
  CAN_ERRSR_tag ERRSR;                 /* Error Status Register */
};


/* ============================================================================
   =============================== Module: CGM ================================
   ============================================================================ */

typedef union CGM_PCS_SDUR_union_tag { /* PCS Switch Duration Register */
  vuint8_t R;
  struct {
    vuint8_t SDUR:8;
  } B;
} CGM_PCS_SDUR_tag;

typedef union CGM_PCS_DIVC1_union_tag { /* PCS Divider Change Register 1 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} CGM_PCS_DIVC1_tag;

typedef union CGM_PCS_DIVE1_union_tag { /* PCS Divider End Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} CGM_PCS_DIVE1_tag;

typedef union CGM_PCS_DIVS1_union_tag { /* PCS Divider Start Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} CGM_PCS_DIVS1_tag;

typedef union CGM_PCS_DIVC2_union_tag { /* PCS Divider Change Register 2 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} CGM_PCS_DIVC2_tag;

typedef union CGM_PCS_DIVE2_union_tag { /* PCS Divider End Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} CGM_PCS_DIVE2_tag;

typedef union CGM_PCS_DIVS2_union_tag { /* PCS Divider Start Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} CGM_PCS_DIVS2_tag;

typedef union CGM_PCS_DIVC4_union_tag { /* PCS Divider Change Register 4 */
  vuint32_t R;
  struct {
    vuint32_t INIT:16;
    vuint32_t _unused_8:8;
    vuint32_t RATE:8;
  } B;
} CGM_PCS_DIVC4_tag;

typedef union CGM_PCS_DIVE4_union_tag { /* PCS Divider End Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVE:20;
  } B;
} CGM_PCS_DIVE4_tag;

typedef union CGM_PCS_DIVS4_union_tag { /* PCS Divider Start Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DIVS:20;
  } B;
} CGM_PCS_DIVS4_tag;

typedef union CGM_DIV_UPD_STAT_union_tag { /* Divider Update Status Register */
  vuint32_t R;
  struct {
    vuint32_t SYS_UPD_STAT:1;          /* System Clock Divider Update Status */
    vuint32_t _unused_16:15;
    vuint32_t AUX15_UPD_STAT:1;        /* Auxiliary Clock 15 Divider Update Status */
    vuint32_t AUX14_UPD_STAT:1;        /* Auxiliary Clock 14 Divider Update Status */
    vuint32_t AUX13_UPD_STAT:1;        /* Auxiliary Clock 13Divider Update Status */
    vuint32_t _unused_12:1;
    vuint32_t AUX11_UPD_STAT:1;        /* Auxiliary Clock 11 Divider Update Status */
    vuint32_t AUX10_UPD_STAT:1;        /* Auxiliary Clock 10 Divider Update Status */
    vuint32_t AUX9_UPD_STAT:1;         /* Auxiliary Clock 9 Divider Update Status */
    vuint32_t AUX8_UPD_STAT:1;         /* Auxiliary Clock 8 Divider Update Status */
    vuint32_t AUX7_UPD_STAT:1;         /* Auxiliary Clock 7 Divider Update Status */
    vuint32_t _unused_5:2;
    vuint32_t AUX4_UPD_STAT:1;         /* Auxiliary Clock 4 Divider Update Status */
    vuint32_t AUX3_UPD_STAT:1;         /* Auxiliary Clock 3 Divider Update Status */
    vuint32_t AUX2_UPD_STAT:1;         /* Auxiliary Clock 2 Divider Update Status */
    vuint32_t AUX1_UPD_STAT:1;         /* Auxiliary Clock 1 Divider Update Status */
    vuint32_t AUX0_UPD_STAT:1;         /* Auxiliary Clock 0 Divider Update Status */
  } B;
} CGM_DIV_UPD_STAT_tag;

typedef union CGM_SC_SS_union_tag {    /* System Clock Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELSTAT:4;
    vuint32_t _unused_20:4;
    vuint32_t SWTRG:3;
    vuint32_t SWIP:1;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_SS_tag;

typedef union CGM_SC_DC0_union_tag {   /* System Clock Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_DC0_tag;

typedef union CGM_SC_DC1_union_tag {   /* System Clock Divider 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t _unused_20:1;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_DC1_tag;

typedef union CGM_SC_DC2_union_tag {   /* System Clock Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_DC2_tag;

typedef union CGM_SC_DC3_union_tag {   /* System Clock Divider 3 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_DC3_tag;

typedef union CGM_SC_DC4_union_tag {   /* System Clock Divider 4 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_DC4_tag;

typedef union CGM_SC_DC5_union_tag {   /* System Clock Divider 5 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} CGM_SC_DC5_tag;

typedef union CGM_AC0_SC_union_tag {   /* Auxiliary Clock 0 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC0_SC_tag;

typedef union CGM_AC0_SS_union_tag {   /* Auxiliary Clock 0 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC0_SS_tag;

typedef union CGM_AC0_DC0_union_tag {  /* Auxiliary Clock 0 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC0_DC0_tag;


typedef union CGM_AC0_DC2_union_tag {  /* Auxiliary Clock 0 Divider 2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC0_DC2_tag;

typedef union CGM_AC1_SC_union_tag {   /* Auxiliary Clock 1 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC1_SC_tag;

typedef union CGM_AC1_SS_union_tag {   /* Auxiliary Clock 1 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC1_SS_tag;

typedef union CGM_AC1_DC0_union_tag {  /* Auxiliary Clock 1 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC1_DC0_tag;

typedef union CGM_AC2_SC_union_tag {   /* Auxiliary Clock 2 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC2_SC_tag;

typedef union CGM_AC2_SS_union_tag {   /* Auxiliary Clock 2 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC2_SS_tag;

typedef union CGM_AC2_DC0_union_tag {  /* Auxiliary Clock 2 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC2_DC0_tag;

typedef union CGM_AC3_SC_union_tag {   /* Auxiliary Clock 3 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC3_SC_tag;

typedef union CGM_AC3_SS_union_tag {   /* Auxiliary Clock 3 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC3_SS_tag;

typedef union CGM_AC4_SC_union_tag {   /* Auxiliary Clock 4 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELCTL:1;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC4_SC_tag;

typedef union CGM_AC4_SS_union_tag {   /* Auxiliary Clock 4 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t SELSTAT:1;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC4_SS_tag;

typedef union CGM_AC7_SC_union_tag {   /* Auxiliary Clock 7 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC7_SC_tag;

typedef union CGM_AC7_SS_union_tag {   /* Auxiliary Clock 7 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC7_SS_tag;

typedef union CGM_AC7_DC0_union_tag {  /* Auxiliary Clock 7 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC7_DC0_tag;

typedef union CGM_AC8_SC_union_tag {   /* Auxiliary Clock 8 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC8_SC_tag;

typedef union CGM_AC8_SS_union_tag {   /* Auxiliary Clock 8 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC8_SS_tag;

typedef union CGM_AC8_DC0_union_tag {  /* Auxiliary Clock 8 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_21:10;
    vuint32_t DIV:5;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC8_DC0_tag;

typedef union CGM_AC9_DC0_union_tag {  /* Auxiliary Clock 9 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC9_DC0_tag;

typedef union CGM_AC10_SC_union_tag {  /* Auxiliary Clock 10 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC10_SC_tag;

typedef union CGM_AC10_SS_union_tag {  /* Auxiliary Clock 10 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC10_SS_tag;

typedef union CGM_AC10_DC0_union_tag { /* Auxiliary Clock 10 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC10_DC0_tag;

typedef union CGM_AC11_SC_union_tag {  /* Auxiliary Clock 11 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC11_SC_tag;

typedef union CGM_AC11_SS_union_tag {  /* Auxiliary Clock 11 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC11_SS_tag;

typedef union CGM_AC11_DC0_union_tag { /* Auxiliary Clock 11 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_20:11;
    vuint32_t DIV:4;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC11_DC0_tag;

typedef union CGM_AC12_SC_union_tag {  /* Auxiliary Clock 12 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC12_SC_tag;

typedef union CGM_AC12_SS_union_tag {  /* Auxiliary Clock 12 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC12_SS_tag;

typedef union CGM_AC12_DC0_union_tag { /* Auxiliary Clock 12 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC12_DC0_tag;

typedef union CGM_AC13_SC_union_tag {  /* Auxiliary Clock 13 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELCTL:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC13_SC_tag;

typedef union CGM_AC13_SS_union_tag {  /* Auxiliary Clock 13 Select Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC13_SS_tag;

typedef union CGM_AC13_DC0_union_tag { /* Auxiliary Clock 13 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC13_DC0_tag;

typedef union CGM_AC14_DC0_union_tag { /* Auxiliary Clock 14 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC14_DC0_tag;

typedef union CGM_AC15_SC_union_tag {  /* Aux Clock 15 Select Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t SELCTL:4;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC15_SC_tag;

typedef union CGM_AC15_SS_union_tag {  /* Auxiliary Clock 15 Select Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t SELSTAT:3;
    vuint32_t _unused_0:24;
  } B;
} CGM_AC15_SS_tag;

typedef union CGM_AC15_DC0_union_tag { /* Auxiliary Clock 15 Divider 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t DE:1;
    vuint32_t _unused_23:8;
    vuint32_t DIV:7;
    vuint32_t _unused_0:16;
  } B;
} CGM_AC15_DC0_tag;

struct CGM_tag {
  uint8_t CGM_reserved0[1792];
  CGM_PCS_SDUR_tag PCS_SDUR;           /* PCS Switch Duration Register */
  uint8_t CGM_reserved1[3];
  CGM_PCS_DIVC1_tag PCS_DIVC1;         /* PCS Divider Change Register 1 */
  CGM_PCS_DIVE1_tag PCS_DIVE1;         /* PCS Divider End Register 1 */
  CGM_PCS_DIVS1_tag PCS_DIVS1;         /* PCS Divider Start Register 1 */
  CGM_PCS_DIVC2_tag PCS_DIVC2;         /* PCS Divider Change Register 2 */
  CGM_PCS_DIVE2_tag PCS_DIVE2;         /* PCS Divider End Register 2 */
  CGM_PCS_DIVS2_tag PCS_DIVS2;         /* PCS Divider Start Register 2 */
  uint8_t CGM_reserved2[12];
  CGM_PCS_DIVC4_tag PCS_DIVC4;         /* PCS Divider Change Register 4 */
  CGM_PCS_DIVE4_tag PCS_DIVE4;         /* PCS Divider End Register 4 */
  CGM_PCS_DIVS4_tag PCS_DIVS4;         /* PCS Divider Start Register 4 */
  uint8_t CGM_reserved3[168];
  CGM_DIV_UPD_STAT_tag DIV_UPD_STAT;   /* Divider Update Status Register */
  uint8_t CGM_reserved4[4];
  CGM_SC_SS_tag SC_SS;                 /* System Clock Select Status Register */
  CGM_SC_DC0_tag SC_DC0;               /* System Clock Divider 0 Configuration Register */
  CGM_SC_DC1_tag SC_DC1;               /* System Clock Divider 1 Configuration Register */
  CGM_SC_DC2_tag SC_DC2;               /* System Clock Divider 2 Configuration Register */
  CGM_SC_DC3_tag SC_DC3;               /* System Clock Divider 3 Configuration Register */
  CGM_SC_DC4_tag SC_DC4;               /* System Clock Divider 4 Configuration Register */
  CGM_SC_DC5_tag SC_DC5;               /* System Clock Divider 5 Configuration Register */
  CGM_AC0_SC_tag AC0_SC;               /* Auxiliary Clock 0 Select Control Register */
  CGM_AC0_SS_tag AC0_SS;               /* Auxiliary Clock 0 Select Status Register */
  CGM_AC0_DC0_tag AC0_DC0;             /* Auxiliary Clock 0 Divider 0 Configuration Register */
  uint8_t CGM_reserved5[4];
  CGM_AC0_DC2_tag AC0_DC2;             /* Auxiliary Clock 0 Divider 2 Configuration Register */
  uint8_t CGM_reserved6[12];
  CGM_AC1_SC_tag AC1_SC;               /* Auxiliary Clock 1 Select Control Register */
  CGM_AC1_SS_tag AC1_SS;               /* Auxiliary Clock 1 Select Status Register */
  CGM_AC1_DC0_tag AC1_DC0;             /* Auxiliary Clock 1 Divider 0 Configuration Register */
  uint8_t CGM_reserved7[20];
  CGM_AC2_SC_tag AC2_SC;               /* Auxiliary Clock 2 Select Control Register */
  CGM_AC2_SS_tag AC2_SS;               /* Auxiliary Clock 2 Select Status Register */
  CGM_AC2_DC0_tag AC2_DC0;             /* Auxiliary Clock 2 Divider 0 Configuration Register */
  uint8_t CGM_reserved8[20];
  CGM_AC3_SC_tag AC3_SC;               /* Auxiliary Clock 3 Select Control Register */
  CGM_AC3_SS_tag AC3_SS;               /* Auxiliary Clock 3 Select Status Register */
  uint8_t CGM_reserved9[24];
  CGM_AC4_SC_tag AC4_SC;               /* Auxiliary Clock 4 Select Control Register */
  CGM_AC4_SS_tag AC4_SS;               /* Auxiliary Clock 4 Select Status Register */
  uint8_t CGM_reserved10[88];
  CGM_AC7_SC_tag AC7_SC;               /* Auxiliary Clock 7 Select Control Register */
  CGM_AC7_SS_tag AC7_SS;               /* Auxiliary Clock 7 Select Status Register */
  CGM_AC7_DC0_tag AC7_DC0;             /* Auxiliary Clock 7 Divider 0 Configuration Register */
  uint8_t CGM_reserved11[20];
  CGM_AC8_SC_tag AC8_SC;               /* Auxiliary Clock 8 Select Control Register */
  CGM_AC8_SS_tag AC8_SS;               /* Auxiliary Clock 8 Select Status Register */
  CGM_AC8_DC0_tag AC8_DC0;             /* Auxiliary Clock 8 Divider 0 Configuration Register */
  uint8_t CGM_reserved12[28];
  CGM_AC9_DC0_tag AC9_DC0;             /* Auxiliary Clock 9 Divider 0 Configuration Register */
  uint8_t CGM_reserved13[20];
  CGM_AC10_SC_tag AC10_SC;             /* Auxiliary Clock 10 Select Control Register */
  CGM_AC10_SS_tag AC10_SS;             /* Auxiliary Clock 10 Select Status Register */
  CGM_AC10_DC0_tag AC10_DC0;           /* Auxiliary Clock 10 Divider 0 Configuration Register */
  uint8_t CGM_reserved14[20];
  CGM_AC11_SC_tag AC11_SC;             /* Auxiliary Clock 11 Select Control Register */
  CGM_AC11_SS_tag AC11_SS;             /* Auxiliary Clock 11 Select Status Register */
  CGM_AC11_DC0_tag AC11_DC0;           /* Auxiliary Clock 11 Divider 0 Configuration Register */
  uint8_t CGM_reserved15[20];
  CGM_AC12_SC_tag AC12_SC;             /* Auxiliary Clock 12 Select Control Register */
  CGM_AC12_SS_tag AC12_SS;             /* Auxiliary Clock 12 Select Status Register */
  CGM_AC12_DC0_tag AC12_DC0;           /* Auxiliary Clock 12 Divider 0 Configuration Register */
  uint8_t CGM_reserved16[20];
  CGM_AC13_SC_tag AC13_SC;             /* Auxiliary Clock 13 Select Control Register */
  CGM_AC13_SS_tag AC13_SS;             /* Auxiliary Clock 13 Select Status Register */
  CGM_AC13_DC0_tag AC13_DC0;           /* Auxiliary Clock 13 Divider 0 Configuration Register */
  uint8_t CGM_reserved17[28];
  CGM_AC14_DC0_tag AC14_DC0;           /* Auxiliary Clock 14 Divider 0 Configuration Register */
  uint8_t CGM_reserved18[20];
  CGM_AC15_SC_tag AC15_SC;             /* Aux Clock 15 Select Control */
  CGM_AC15_SS_tag AC15_SS;             /* Auxiliary Clock 15 Select Control Register */
  CGM_AC15_DC0_tag AC15_DC0;           /* Auxiliary Clock 15 Divider 0 Configuration Register */
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

typedef union CMU_CSR_union_tag {      /* CMU Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t SFM:1;                   /* Start frequency measure. */
    vuint32_t _unused_10:13;
    vuint32_t CKSEL1:2;                /* Frequency measure clock selection bit. */
    vuint32_t _unused_3:5;
    vuint32_t RCDIV:2;                 /* CLKMT0_RMN division factor. */
    vuint32_t CME:1;                   /* CLKMN1 monitor enable. */
  } B;
} CMU_CSR_tag;

typedef union CMU_FDR_union_tag {      /* CMU Frequency Display Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t FD:20;                   /* Measured frequency bits. */
  } B;
} CMU_FDR_tag;

typedef union CMU_HFREFR_union_tag {   /* CMU High Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t HFREF:12;                /* High Frequency reference value. */
  } B;
} CMU_HFREFR_tag;

typedef union CMU_LFREFR_union_tag {   /* CMU Low Frequency Reference Register CLKMN1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t LFREF:12;                /* Low Frequency reference value. */
  } B;
} CMU_LFREFR_tag;

typedef union CMU_ISR_union_tag {      /* CMU Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t _unused_3:1;
    vuint32_t FHHI:1;                  /* CLKMN1 frequency higher than high reference event status. */
    vuint32_t FLLI:1;                  /* CLKMN1 frequency less than low reference event status. */
    vuint32_t OLRI:1;                  /* Oscillator frequency less than f CLKMT0_RMN * 2CMU_CSR[RCDIV]event status. */
  } B;
} CMU_ISR_tag;

typedef union CMU_MDR_union_tag {      /* CMU Measurement Duration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t MD:20;                   /* Measurement duration bits */
  } B;
} CMU_MDR_tag;

struct CMU_tag {
  CMU_CSR_tag CSR;                     /* CMU Control Status Register */
  CMU_FDR_tag FDR;                     /* CMU Frequency Display Register */
  CMU_HFREFR_tag HFREFR;               /* CMU High Frequency Reference Register CLKMN1 */
  CMU_LFREFR_tag LFREFR;               /* CMU Low Frequency Reference Register CLKMN1 */
  CMU_ISR_tag ISR;                     /* CMU Interrupt Status Register */
  uint8_t CMU_reserved0[4];
  CMU_MDR_tag MDR;                     /* CMU Measurement Duration Register */
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

typedef union CRC_CHANNEL_CFG_union_tag { /* Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_6:18;
    vuint32_t SWAP_BYTEWISE:1;         /* Swap CRC_INP byte-wise */
    vuint32_t SWAP_BITWISE:1;          /* Swap CRC_INP bit-wise */
    vuint32_t POLYG:2;                 /* Polynomial selection */
    vuint32_t SWAP:1;                  /* Swap selection */
    vuint32_t INV:1;                   /* Inversion selection */
  } B;
} CRC_CHANNEL_CFG_tag;

typedef union CRC_CHANNEL_INP_union_tag { /* Input Register */
  vuint32_t R;
  struct {
    vuint32_t INP:32;                  /* Input data for the CRC computation */
  } B;
} CRC_CHANNEL_INP_tag;

typedef union CRC_CHANNEL_CSTAT_union_tag { /* Current Status Register */
  vuint32_t R;
  struct {
    vuint32_t CSTAT:32;                /* CRC signature status */
  } B;
} CRC_CHANNEL_CSTAT_tag;

typedef union CRC_CHANNEL_OUTP_union_tag { /* Output Register */
  vuint32_t R;
  struct {
    vuint32_t OUTP:32;                 /* Final CRC signature */
  } B;
} CRC_CHANNEL_OUTP_tag;

typedef struct CRC_CHANNEL_struct_tag {
  CRC_CHANNEL_CFG_tag CFG;             /* Configuration Register */
  CRC_CHANNEL_INP_tag INP;             /* Input Register */
  CRC_CHANNEL_CSTAT_tag CSTAT;         /* Current Status Register */
  CRC_CHANNEL_OUTP_tag OUTP;           /* Output Register */
} CRC_CHANNEL_tag;

struct CRC_tag {
  CRC_CHANNEL_tag CHANNEL[3];
};


/* ============================================================================
   =============================== Module: CTE ================================
   ============================================================================ */

typedef union CTE_CNTRL_union_tag {    /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t RFS_PGEN:1;              /* RFS Pulse Generation Enable */
    vuint32_t CTE_RST:1;               /* CTE synchronous Reset */
    vuint32_t MA_SL_ST:1;              /* master/slave select */
    vuint32_t eDMA_CTL:2;              /* eDMA trigger control */
    vuint32_t OPMOD_SL:2;              /* CTE FSM operation mode select. */
    vuint32_t RCS_DLY:4;               /* Radar Chirp Synchronization Delay Control */
    vuint32_t RFS_DLY:4;               /* Radar Frame Synchronization Delay Control */
    vuint32_t REP_CNT:16;              /* Timing Table Repetition Counter */
  } B;
} CTE_CNTRL_tag;

typedef union CTE_CNTRL1_union_tag {   /* CTE Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t _unused_29:1;
    vuint32_t _unused_28:1;
    vuint32_t CKSM_RST:1;              /* Checksum Reset */
    vuint32_t CHKSM_MD:1;              /* Checksum Mode */
    vuint32_t CTE_EN:1;                /* CTE Enable */
    vuint32_t TIMEMODE:1;              /* Time mode type */
    vuint32_t _unused_22:2;
    vuint32_t CLKDIV_4:3;              /* 4th Clock divider */
    vuint32_t CLKDIV_3:3;              /* 3rd Clock divider */
    vuint32_t _unused_14:2;
    vuint32_t CLKDIV_2:3;              /* 2nd Clock divider */
    vuint32_t CLKDIV_1:3;              /* 1st Clock divider */
    vuint32_t _unused_6:2;
    vuint32_t CTECK_DV:6;              /* CTE Clock divider */
  } B;
} CTE_CNTRL1_tag;

typedef union CTE_LUT_LSB_union_tag {  /* First Timing Table Register (LSB) */
  vuint32_t R;
  struct {
    vuint32_t SPT_EVT:4;               /* SPT Event */
    vuint32_t SPT_PHIV:1;              /* SPT phase invert. */
    vuint32_t DAC_ADE:1;               /* DAC active data edge */
    vuint32_t _unused_24:2;            /* This field is reserved. */
    vuint32_t WG_CLD:1;                /* WGM counter load */
    vuint32_t WG_RST:1;                /* WGM reset */
    vuint32_t WG_TGM:1;                /* WGM toggle mode */
    vuint32_t WG_UDM:1;                /* WGM up/down mode */
    vuint32_t WG_HLD:1;                /* WGM hold */
    vuint32_t WG_RUN:1;                /* WGM run */
    vuint32_t _unused_16:2;
    vuint32_t TIME:16;                 /* Time instance */
  } B;
} CTE_LUT_LSB_tag;

typedef union CTE_LUT_MSB_union_tag {  /* First Timing Table Register (MSB) */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;            /* This field is reserved. */
    vuint32_t _unused_23:1;
    vuint32_t ETIME_AX:2;              /* ETimer Auxiliary */
    vuint32_t ACQ_WIN:1;               /* CTE Acquisition Window */
    vuint32_t RFS_DEF:2;               /* RFS definition */
    vuint32_t RCS_DEF:2;               /* RCS definition */
    vuint32_t CTE_TYP7:2;              /* CTE Pulses */
    vuint32_t CTE_TYP6:2;              /* CTE Pulses */
    vuint32_t CTE_TYP5:2;              /* CTE Pulses */
    vuint32_t CTE_TYP4:2;              /* CTE Pulses */
    vuint32_t CTE_TYP3:2;              /* CTE Pulses */
    vuint32_t CTE_TYP2:2;              /* CTE Pulses */
    vuint32_t CTE_TYP1:2;              /* CTE Pulses */
    vuint32_t CTE_TYP0:2;              /* CTE Pulses */
  } B;
} CTE_LUT_MSB_tag;

typedef struct CTE_LUT_struct_tag {
  CTE_LUT_LSB_tag LSB[32];             /* First Timing Table Register (LSB) */
  CTE_LUT_MSB_tag MSB[32];             /* First Timing Table Register (MSB) */
} CTE_LUT_tag;

typedef union CTE_SIGTYPE0_union_tag { /* Signal Type Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CTE_TYP7:2;              /* CTE pulse type */
    vuint32_t CTE_TYP6:2;              /* CTE pulse type */
    vuint32_t CTE_TYP5:2;              /* CTE pulse type */
    vuint32_t CTE_TYP4:2;              /* CTE pulse type */
    vuint32_t CTE_TYP3:2;              /* CTE pulse type */
    vuint32_t CTE_TYP2:2;              /* CTE pulse type */
    vuint32_t CTE_TYP1:2;              /* CTE pulse type */
    vuint32_t CTE_TYP0:2;              /* CTE pulse type */
    vuint32_t _unused_15:1;
    vuint32_t STP_EVT:4;               /* SPT event type */
    vuint32_t PH_INVT:1;               /* Phase invert type */
    vuint32_t DAC_ADE:1;               /* DAC active data edge type */
    vuint32_t _unused_8:1;             /* This field is reserved. */
    vuint32_t WG_CLD:1;                /* WGM counter load type */
    vuint32_t WG_RST:1;                /* WGM reset type */
    vuint32_t WG_TGM:1;                /* WGM toggle mode type */
    vuint32_t WG_UDM:1;                /* WGM up/down mode type */
    vuint32_t WG_HLD:1;                /* WGM hold type */
    vuint32_t WG_RUN:1;                /* WGM run type */
    vuint32_t _unused_0:2;
  } B;
} CTE_SIGTYPE0_tag;

typedef union CTE_SIGTYPE1_union_tag { /* Signal Type Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t ETIME_AUX:2;             /* Etime Aux Type */
    vuint32_t ACQ_WIN:1;               /* Acquisition Window Type */
    vuint32_t RFS:2;                   /* Radar Frame Synchronization */
    vuint32_t RCS:2;                   /* Radar Chirp Synchronization */
  } B;
} CTE_SIGTYPE1_tag;

typedef union CTE_INTEN_union_tag {    /* CTE Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t LST_EXEN:1;              /* Last Table Execution Enable */
    vuint32_t eDMA_TEN:1;              /* eDMA Trigger Interrupt Enable */
    vuint32_t RFS_EN:1;                /* RFS interrupt enable (rising edge) */
    vuint32_t RCS_EN:1;                /* RCS interrupt enable (rising edge) */
    vuint32_t _unused_5:1;
    vuint32_t AC_WD_EN:1;              /* Acquisition window (rising) */
    vuint32_t TT1_EDEN:1;              /* Timing table end (rsising) */
    vuint32_t TT0_EDEN:1;              /* Timing table end (rsising) */
    vuint32_t TT1_STEN:1;              /* Timing table start (rising) */
    vuint32_t TT0_STEN:1;              /* Timing table start (rising) */
  } B;
} CTE_INTEN_tag;

typedef union CTE_INTSTAT_union_tag {  /* CTE Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t LAST_EXC:1;              /* Last Execution */
    vuint32_t eDMA_TRG:1;              /* eDMA Trigger */
    vuint32_t RFS:1;                   /* Radar Frame Synchronization */
    vuint32_t RCS:1;                   /* Radar Chirp Synchronization */
    vuint32_t _unused_5:1;
    vuint32_t ACQ_WIN:1;               /* Acquisition window (rising) */
    vuint32_t TT1_END:1;               /* TT1 end */
    vuint32_t TT0_END:1;               /* TT0 end */
    vuint32_t TT1_STRT:1;              /* TT1 start */
    vuint32_t TT0_STRT:1;              /* TT0 start */
  } B;
} CTE_INTSTAT_tag;

typedef union CTE_CKSM_LSB_union_tag { /* LUT Checksum Register */
  vuint32_t R;
  struct {
    vuint32_t CHKS_LSB:32;             /* Checksum Result LSB */
  } B;
} CTE_CKSM_LSB_tag;

typedef union CTE_CKSM_MSB_union_tag { /* LUT Checksum Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t _unused_8:1;
    vuint32_t CHKS_MSB:8;              /* Checksum Result LSB */
  } B;
} CTE_CKSM_MSB_tag;

typedef union CTE_DBG_REG_union_tag {  /* Debug Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t FSM_ST:2;                /* OPMOD FSM state */
    vuint32_t SLV_ALGN:1;              /* RFS/RCS align status */
    vuint32_t CONT_ERR:1;              /* Timing Table contention error */
    vuint32_t LUT_SEL:1;               /* TT Select */
  } B;
} CTE_DBG_REG_tag;

typedef union CTE_LUT_DUR_union_tag {  /* TT0 Execution Duration Register */
  vuint32_t R;
  struct {
    vuint32_t TT0_DUR:32;              /* TT0 Duration */
  } B;
} CTE_LUT_DUR_tag;

typedef union CTE_LUT_DUR1_union_tag { /* TT1 Execution Duration Register */
  vuint32_t R;
  struct {
    vuint32_t TT1_DUR:32;              /* TT1_DURATION */
  } B;
} CTE_LUT_DUR1_tag;

typedef union CTE_CLKSEL_union_tag {   /* Clock Select Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t CLK_SEL9:2;              /* Clock Select */
    vuint32_t CLK_SEL8:2;              /* Clock Select */
    vuint32_t CLK_SEL7:2;              /* Clock Select */
    vuint32_t CLK_SEL6:2;              /* Clock Select */
    vuint32_t CLK_SEL5:2;              /* Clock Select */
    vuint32_t CLK_SEL4:2;              /* Clock Select */
    vuint32_t CLK_SEL3:2;              /* Clock Select */
    vuint32_t CLK_SEL2:2;              /* Clock Select */
    vuint32_t CLK_SEL1:2;              /* Clock Select. These bits are used to select one of the 4 available clock dividers for ctep1 when it is defined as clock type. */
    vuint32_t CLK_SEL0:2;              /* Clock Select */
  } B;
} CTE_CLKSEL_tag;

struct CTE_tag {
  CTE_CNTRL_tag CNTRL;                 /* Control Register */
  CTE_CNTRL1_tag CNTRL1;               /* CTE Control Register 1 */
  CTE_LUT_tag LUT[2];
  CTE_SIGTYPE0_tag SIGTYPE0[2];        /* Signal Type Register 0 */
  CTE_SIGTYPE1_tag SIGTYPE1[2];        /* Signal Type Register 1 */
  uint8_t CTE_reserved0[8];
  CTE_INTEN_tag INTEN;                 /* CTE Interrupt Enable Register */
  CTE_INTSTAT_tag INTSTAT;             /* CTE Interrupt Status Register */
  uint8_t CTE_reserved1[72];
  CTE_CKSM_LSB_tag CKSM_LSB;           /* LUT Checksum Register */
  CTE_CKSM_MSB_tag CKSM_MSB;           /* LUT Checksum Register */
  CTE_DBG_REG_tag DBG_REG;             /* Debug Register */
  CTE_LUT_DUR_tag LUT_DUR;             /* TT0 Execution Duration Register */
  CTE_LUT_DUR1_tag LUT_DUR1;           /* TT1 Execution Duration Register */
  CTE_CLKSEL_tag CLKSEL;               /* Clock Select Register */
};


/* ============================================================================
   =============================== Module: CTU ================================
   ============================================================================ */

typedef union CTU_TGSISR_union_tag {   /* Trigger Generator Subunit Input Selection Register */
  vuint32_t R;
  struct {
    vuint32_t I15_FE:1;                /* Input 15 Falling Edge Enable. */
    vuint32_t I15_RE:1;                /* Input 15 Rising Edge Enable. */
    vuint32_t I14_FE:1;                /* Input 14 Falling Edge Enable. */
    vuint32_t I14_RE:1;                /* Input 14 Rising Edge Enable. */
    vuint32_t I13_FE:1;                /* Input 13 Falling Edge Enable. */
    vuint32_t I13_RE:1;                /* Input 13 Rising Edge Enable. */
    vuint32_t I12_FE:1;                /* Input 12 Falling Edge Enable. */
    vuint32_t I12_RE:1;                /* Input 12 Rising Edge Enable. */
    vuint32_t I11_FE:1;                /* Input 11 Falling Edge Enable. */
    vuint32_t I11_RE:1;                /* Input 11 Rising Edge Enable. */
    vuint32_t I10_FE:1;                /* Input 10 Falling Edge Enable. */
    vuint32_t I10_RE:1;                /* Input 10 Rising Edge Enable. */
    vuint32_t I9_FE:1;                 /* Input 9 Falling Edge Enable. */
    vuint32_t I9_RE:1;                 /* Input 9 Rising Edge Enable. */
    vuint32_t I8_FE:1;                 /* Input 8 Falling Edge Enable. */
    vuint32_t I8_RE:1;                 /* Input 8 Rising Edge Enable. */
    vuint32_t I7_FE:1;                 /* Input 7 Falling Edge Enable. */
    vuint32_t I7_RE:1;                 /* Input 7 Rising Edge Enable. */
    vuint32_t I6_FE:1;                 /* Input 6 Falling Edge Enable. */
    vuint32_t I6_RE:1;                 /* Input 6 Rising Edge Enable. */
    vuint32_t I5_FE:1;                 /* Input 5 Falling Edge Enable. */
    vuint32_t I5_RE:1;                 /* Input 5 Rising Edge Enable. */
    vuint32_t I4_FE:1;                 /* Input 4 Falling Edge Enable. */
    vuint32_t I4_RE:1;                 /* Input 4 Rising Edge Enable. */
    vuint32_t I3_FE:1;                 /* Input 3 Falling Edge Enable. */
    vuint32_t I3_RE:1;                 /* Input 3 Rising edge Enable */
    vuint32_t I2_FE:1;                 /* Input 2 Falling Edge Enable. */
    vuint32_t I2_RE:1;                 /* Input 2 Rising Edge Enable. */
    vuint32_t I1_FE:1;                 /* Input 1 Falling Edge Enable. */
    vuint32_t I1_RE:1;                 /* Input 1 Rising edge Enable */
    vuint32_t I0_FE:1;                 /* Input 0 Falling Edge Enable. */
    vuint32_t I0_RE:1;                 /* Input 0 Rising Edge Enable. */
  } B;
} CTU_TGSISR_tag;

typedef union CTU_TGSCR_union_tag {    /* Trigger Generator Subunit Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_9:7;
    vuint16_t ET_TM:1;
    vuint16_t PRES:2;
    vuint16_t MRS_SM:5;
    vuint16_t TGS_M:1;
  } B;
} CTU_TGSCR_tag;

typedef union CTU_TCR_union_tag {      /* Trigger Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TCRV:16;
  } B;
} CTU_TCR_tag;

typedef union CTU_TGSCCR_union_tag {   /* TGS Counter Compare Register */
  vuint16_t R;
  struct {
    vuint16_t TGSCCV:16;
  } B;
} CTU_TGSCCR_tag;

typedef union CTU_TGSCRR_union_tag {   /* TGS Counter Reload Register */
  vuint16_t R;
  struct {
    vuint16_t TGSCRV:16;
  } B;
} CTU_TGSCRR_tag;

typedef union CTU_CLCR1_union_tag {    /* Commands List Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t T3_INDEX:5;
    vuint32_t _unused_21:3;
    vuint32_t T2_INDEX:5;
    vuint32_t _unused_13:3;
    vuint32_t T1_INDEX:5;
    vuint32_t _unused_5:3;
    vuint32_t T0_INDEX:5;
  } B;
} CTU_CLCR1_tag;

typedef union CTU_CLCR2_union_tag {    /* Commands List Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t T7_INDEX:5;
    vuint32_t _unused_21:3;
    vuint32_t T6_INDEX:5;
    vuint32_t _unused_13:3;
    vuint32_t T5_INDEX:5;
    vuint32_t _unused_5:3;
    vuint32_t T4_INDEX:5;
  } B;
} CTU_CLCR2_tag;

typedef union CTU_THCR1_union_tag {    /* Trigger Handler Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t T3_E:1;
    vuint32_t T3_ETE:1;
    vuint32_t T3_T4E:1;
    vuint32_t T3_T3E:1;
    vuint32_t T3_T2E:1;
    vuint32_t T3_T1E:1;
    vuint32_t T3_ADCE:1;
    vuint32_t _unused_23:1;
    vuint32_t T2_E:1;
    vuint32_t T2_ETE:1;
    vuint32_t T2_T4E:1;
    vuint32_t T2_T3E:1;
    vuint32_t T2_T2E:1;
    vuint32_t T2_T1E:1;
    vuint32_t T2_ADCE:1;
    vuint32_t _unused_15:1;
    vuint32_t T1_E:1;
    vuint32_t T1_ETE:1;
    vuint32_t T1_T4E:1;
    vuint32_t T1_T3E:1;
    vuint32_t T1_T2E:1;
    vuint32_t T1_T1E:1;
    vuint32_t T1_ADCE:1;
    vuint32_t _unused_7:1;
    vuint32_t T0_E:1;
    vuint32_t T0_ETE:1;
    vuint32_t T0_T4E:1;
    vuint32_t T0_T3E:1;
    vuint32_t T0_T2E:1;
    vuint32_t T0_T1E:1;
    vuint32_t T0_ADCE:1;
  } B;
} CTU_THCR1_tag;

typedef union CTU_THCR2_union_tag {    /* Trigger Handler Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t T7_E:1;
    vuint32_t T7_ETE:1;
    vuint32_t T7_T4E:1;
    vuint32_t T7_T3E:1;
    vuint32_t T7_T2E:1;
    vuint32_t T7_T1E:1;
    vuint32_t T7_ADCE:1;
    vuint32_t _unused_23:1;
    vuint32_t T6_E:1;
    vuint32_t T6_ETE:1;
    vuint32_t T6_T4E:1;
    vuint32_t T6_T3E:1;
    vuint32_t T6_T2E:1;
    vuint32_t T6_T1E:1;
    vuint32_t T6_ADCE:1;
    vuint32_t _unused_15:1;
    vuint32_t T5_E:1;
    vuint32_t T5_ETE:1;
    vuint32_t T5_T4E:1;
    vuint32_t T5_T3E:1;
    vuint32_t T5_T2E:1;
    vuint32_t T5_T1E:1;
    vuint32_t T5_ADCE:1;
    vuint32_t _unused_7:1;
    vuint32_t T4_E:1;
    vuint32_t T4_ETE:1;
    vuint32_t T4_T4E:1;
    vuint32_t T4_T3E:1;
    vuint32_t T4_T2E:1;
    vuint32_t T4_T1E:1;
    vuint32_t T4_ADCE:1;
  } B;
} CTU_THCR2_tag;

typedef union CTU_CLR_A_union_tag {    /* Commands List Register A for ADC single-conversion mode commands */
  vuint16_t R;
  struct {
    vuint16_t CIR:1;
    vuint16_t LC:1;
    vuint16_t CMS:1;
    vuint16_t FIFO:3;                  /* FIFO used for ADC Port A / Port B. */
    vuint16_t ST0:1;
    vuint16_t _unused_6:3;
    vuint16_t SU:1;                    /* ADC Port A / Port B selection. */
    vuint16_t _unused_4:1;
    vuint16_t CH:4;                    /* ADC Port channel number. */
  } B;
} CTU_CLR_A_tag;

typedef union CTU_CLR_B_union_tag {    /* Command List Register B for ADC dual-conversion mode commands */
  vuint16_t R;
  struct {
    vuint16_t CIR:1;
    vuint16_t LC:1;
    vuint16_t CMS:1;
    vuint16_t FIFO:3;                  /* FIFO used for ADC Port A / Port B. */
    vuint16_t ST0:1;                   /* Sel-Test mode control 0. Must be 0 in this register format. */
    vuint16_t CH_B:4;                  /* ADC Port B channel number. */
    vuint16_t _unused_4:1;             /* Reserved. */
    vuint16_t CH_A:4;                  /* ADC Port A channel number. */
  } B;
} CTU_CLR_B_tag;

typedef union CTU_CLR_C_union_tag {    /* Command List Register C for self-test commands */
  vuint16_t R;
  struct {
    vuint16_t CIR:1;
    vuint16_t LC:1;
    vuint16_t ST1:1;
    vuint16_t ST_CMS:1;
    vuint16_t ST_SU:1;
    vuint16_t _unused_10:1;
    vuint16_t ST0:1;
    vuint16_t ALG:2;
    vuint16_t BSIZE:7;
  } B;
} CTU_CLR_C_tag;

typedef union CTU_CLR_union_tag {
  CTU_CLR_A_tag A;                     /* Commands List Register A for ADC single-conversion mode commands */
  CTU_CLR_B_tag B;                     /* Command List Register B for ADC dual-conversion mode commands */
  CTU_CLR_C_tag C;                     /* Command List Register C for self-test commands */
} CTU_CLR_tag;

typedef union CTU_FDCR_union_tag {     /* FIFO DMA Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t _unused_11:1;
    vuint16_t _unused_10:1;
    vuint16_t _unused_9:1;
    vuint16_t _unused_8:1;
    vuint16_t _unused_4:4;
    vuint16_t DE3:1;
    vuint16_t DE2:1;
    vuint16_t DE1:1;
    vuint16_t DE0:1;
  } B;
} CTU_FDCR_tag;

typedef union CTU_FCR_union_tag {      /* FIFO Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OR_EN3:1;
    vuint32_t OF_EN3:1;
    vuint32_t EMPTY_EN3:1;
    vuint32_t FULL_EN3:1;
    vuint32_t OR_EN2:1;
    vuint32_t OF_EN2:1;
    vuint32_t EMPTY_EN2:1;
    vuint32_t FULL_EN2:1;
    vuint32_t OR_EN1:1;
    vuint32_t OF_EN1:1;
    vuint32_t EMPTY_EN1:1;
    vuint32_t FULL_EN1:1;
    vuint32_t OR_EN0:1;
    vuint32_t OF_EN0:1;
    vuint32_t EMPTY_EN0:1;
    vuint32_t FULL_EN0:1;
  } B;
} CTU_FCR_tag;

typedef union CTU_FTH_union_tag {      /* FIFO Threshold Register */
  vuint32_t R;
  struct {
    vuint32_t TH3:8;
    vuint32_t TH2:8;
    vuint32_t TH1:8;
    vuint32_t TH0:8;
  } B;
} CTU_FTH_tag;

typedef union CTU_FST_union_tag {      /* FIFO Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OR3:1;
    vuint32_t OF3:1;
    vuint32_t EMP3:1;
    vuint32_t FULL3:1;
    vuint32_t OR2:1;
    vuint32_t OF2:1;
    vuint32_t EMP2:1;
    vuint32_t FULL2:1;
    vuint32_t OR1:1;
    vuint32_t OF1:1;
    vuint32_t EMP1:1;
    vuint32_t FULL1:1;
    vuint32_t OR0:1;
    vuint32_t OF0:1;
    vuint32_t EMP0:1;
    vuint32_t FULL0:1;
  } B;
} CTU_FST_tag;

typedef union CTU_FR_union_tag {       /* FIFO Right Aligned Data Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t ADC:1;                   /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
    vuint32_t N_CH:4;
    vuint32_t _unused_12:4;
    vuint32_t DATA:12;
  } B;
} CTU_FR_tag;

typedef union CTU_FL_union_tag {       /* FIFO Signed Left Aligned Data Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t ADC:1;                   /* This bit indicates from which ADC Port the value in the DATA field corresponds to. */
    vuint32_t N_CH:4;
    vuint32_t _unused_15:1;
    vuint32_t LA_DATA:12;
    vuint32_t _unused_0:3;
  } B;
} CTU_FL_tag;

typedef union CTU_EFR_union_tag {      /* Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t LIST_BE:1;
    vuint16_t CS:1;
    vuint16_t ET_OE:1;
    vuint16_t ERRCMP:1;
    vuint16_t T4_OE:1;
    vuint16_t T3_OE:1;
    vuint16_t T2_OE:1;
    vuint16_t T1_OE:1;
    vuint16_t ADC_OE:1;
    vuint16_t TGS_OSM:1;
    vuint16_t MRS_O:1;
    vuint16_t ICE:1;
    vuint16_t SM_TO:1;
    vuint16_t MRS_RE:1;
  } B;
} CTU_EFR_tag;

typedef union CTU_IFR_union_tag {      /* Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t SERR_B:1;
    vuint16_t SERR_A:1;
    vuint16_t ADC_I:1;
    vuint16_t T7_I:1;
    vuint16_t T6_I:1;
    vuint16_t T5_I:1;
    vuint16_t T4_I:1;
    vuint16_t T3_I:1;
    vuint16_t T2_I:1;
    vuint16_t T1_I:1;
    vuint16_t T0_I:1;
    vuint16_t MRS_I:1;
  } B;
} CTU_IFR_tag;

typedef union CTU_IR_union_tag {       /* Interrupt/DMA Register */
  vuint16_t R;
  struct {
    vuint16_t T7_IE:1;
    vuint16_t T6_IE:1;
    vuint16_t T5_IE:1;
    vuint16_t T4_IE:1;
    vuint16_t T3_IE:1;
    vuint16_t T2_IE:1;
    vuint16_t T1_IE:1;
    vuint16_t T0_IE:1;
    vuint16_t _unused_6:2;
    vuint16_t SAF_CNT_B_EN:1;          /* Enable the ADC Port B counter to check the conversion time. */
    vuint16_t SAF_CNT_A_EN:1;          /* Enable the ADC Port A counter to check the conversion time. */
    vuint16_t DMA_DE:1;
    vuint16_t MRS_DMAE:1;
    vuint16_t MRS_IE:1;
    vuint16_t IEE:1;
  } B;
} CTU_IR_tag;

typedef union CTU_COTR_union_tag {     /* Control ON Time Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t COTGT:8;
  } B;
} CTU_COTR_tag;

typedef union CTU_CR_union_tag {       /* Control Register */
  vuint16_t R;
  struct {
    vuint16_t T7_SG:1;
    vuint16_t T6_SG:1;
    vuint16_t T5_SG:1;
    vuint16_t T4_SG:1;
    vuint16_t T3_SG:1;
    vuint16_t T2_SG:1;
    vuint16_t T1_SG:1;
    vuint16_t T0_SG:1;
    vuint16_t CTU_ADC_R:1;
    vuint16_t CTU_ODIS:1;
    vuint16_t DFE:1;
    vuint16_t CGRE:1;
    vuint16_t FGRE:1;
    vuint16_t MRS_SG:1;
    vuint16_t GRE:1;
    vuint16_t TGSISR_RE:1;
  } B;
} CTU_CR_tag;

typedef union CTU_DFR_union_tag {      /* Digital Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t FILTER_N:8;
  } B;
} CTU_DFR_tag;

typedef union CTU_EXPAR_union_tag {    /* Expected Value A Register */
  vuint16_t R;
  struct {
    vuint16_t EXPA:16;                 /* This value is the expected number of system clock cycles needed by ADC Port A to complete a conversion. */
  } B;
} CTU_EXPAR_tag;

typedef union CTU_EXPBR_union_tag {    /* Expected Value B Register */
  vuint16_t R;
  struct {
    vuint16_t EXPB:16;                 /* This value is the expected number of system clock cycles needed by ADC Port B to complete a conversion. */
  } B;
} CTU_EXPBR_tag;

typedef union CTU_CNTRNGR_union_tag {  /* Counter Range Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t CNTRNG:8;
  } B;
} CTU_CNTRNGR_tag;

typedef union CTU_LISTCSR_union_tag {  /* List Control/Status Register */
  vuint32_t R;
  struct {
    vuint32_t LIST1_BLK:1;
    vuint32_t _unused_29:2;
    vuint32_t LIST1_ADDR:5;
    vuint32_t LIST0_BLK:1;
    vuint32_t _unused_21:2;
    vuint32_t LIST0_ADDR:5;            /* List Address 0. Indicates the command address being executed when LIST_BE flag in EFR register was set. */
    vuint32_t _unused_1:15;
    vuint32_t PAR_LIST:1;
  } B;
} CTU_LISTCSR_tag;

struct CTU_tag {
  CTU_TGSISR_tag TGSISR;               /* Trigger Generator Subunit Input Selection Register */
  CTU_TGSCR_tag TGSCR;                 /* Trigger Generator Subunit Control Register */
  CTU_TCR_tag TCR[8];                  /* Trigger Compare Register */
  CTU_TGSCCR_tag TGSCCR;               /* TGS Counter Compare Register */
  CTU_TGSCRR_tag TGSCRR;               /* TGS Counter Reload Register */
  uint8_t CTU_reserved0[2];
  CTU_CLCR1_tag CLCR1;                 /* Commands List Control Register 1 */
  CTU_CLCR2_tag CLCR2;                 /* Commands List Control Register 2 */
  CTU_THCR1_tag THCR1;                 /* Trigger Handler Control Register 1 */
  CTU_THCR2_tag THCR2;                 /* Trigger Handler Control Register 2 */
  CTU_CLR_tag CLR[24];
  uint8_t CTU_reserved1[16];
  CTU_FDCR_tag FDCR;                   /* FIFO DMA Control Register */
  uint8_t CTU_reserved2[2];
  CTU_FCR_tag FCR;                     /* FIFO Control Register */
  CTU_FTH_tag FTH;                     /* FIFO Threshold Register */
  uint8_t CTU_reserved3[4];
  CTU_FST_tag FST;                     /* FIFO Status Register */
  CTU_FR_tag FR[4];                    /* FIFO Right Aligned Data Register */
  uint8_t CTU_reserved4[16];
  CTU_FL_tag FL[4];                    /* FIFO Signed Left Aligned Data Register */
  uint8_t CTU_reserved5[16];
  CTU_EFR_tag EFR;                     /* Error Flag Register */
  CTU_IFR_tag IFR;                     /* Interrupt Flag Register */
  CTU_IR_tag IR;                       /* Interrupt/DMA Register */
  CTU_COTR_tag COTR;                   /* Control ON Time Register */
  CTU_CR_tag CR;                       /* Control Register */
  CTU_DFR_tag DFR;                     /* Digital Filter Register */
  CTU_EXPAR_tag EXPAR;                 /* Expected Value A Register */
  CTU_EXPBR_tag EXPBR;                 /* Expected Value B Register */
  CTU_CNTRNGR_tag CNTRNGR;             /* Counter Range Register */
  uint8_t CTU_reserved6[2];
  CTU_LISTCSR_tag LISTCSR;             /* List Control/Status Register */
};


/* ============================================================================
   =============================== Module: DMA ================================
   ============================================================================ */

typedef union DMA_CR_union_tag {       /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t CX:1;                    /* Cancel Transfer */
    vuint32_t ECX:1;                   /* Error Cancel Transfer */
    vuint32_t _unused_11:5;
    vuint32_t GRP1PRI:1;               /* Channel Group 1 Priority */
    vuint32_t _unused_9:1;
    vuint32_t GRP0PRI:1;               /* Channel Group 0 Priority */
    vuint32_t EMLM:1;                  /* Enable Minor Loop Mapping */
    vuint32_t CLM:1;                   /* Continuous Link Mode */
    vuint32_t HALT:1;                  /* Halt DMA Operations */
    vuint32_t HOE:1;                   /* Halt On Error */
    vuint32_t ERGA:1;                  /* Enable Round Robin Group Arbitration */
    vuint32_t ERCA:1;                  /* Enable Round Robin Channel Arbitration */
    vuint32_t EDBG:1;                  /* Enable Debug */
    vuint32_t _unused_0:1;
  } B;
} DMA_CR_tag;

typedef union DMA_ES_union_tag {       /* Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_18:13;
    vuint32_t UCE:1;                   /* Uncorrectable ECC error during channel execution. */
    vuint32_t ECX:1;                   /* Transfer Canceled */
    vuint32_t GPE:1;                   /* Group Priority Error */
    vuint32_t CPE:1;                   /* Channel Priority Error */
    vuint32_t _unused_13:1;
    vuint32_t ERRCHN:5;                /* Error Channel Number or Canceled Channel Number */
    vuint32_t SAE:1;                   /* Source Address Error */
    vuint32_t SOE:1;                   /* Source Offset Error */
    vuint32_t DAE:1;                   /* Destination Address Error */
    vuint32_t DOE:1;                   /* Destination Offset Error */
    vuint32_t NCE:1;                   /* NBYTES/CITER Configuration Error */
    vuint32_t SGE:1;                   /* Scatter/Gather Configuration Error */
    vuint32_t SBE:1;                   /* Source Bus Error */
    vuint32_t DBE:1;                   /* Destination Bus Error */
  } B;
} DMA_ES_tag;

typedef union DMA_ERQ_union_tag {      /* Enable Request Register */
  vuint32_t R;
  struct {
    vuint32_t ERQ31:1;                 /* Enable DMA Request 31 */
    vuint32_t ERQ30:1;                 /* Enable DMA Request 30 */
    vuint32_t ERQ29:1;                 /* Enable DMA Request 29 */
    vuint32_t ERQ28:1;                 /* Enable DMA Request 28 */
    vuint32_t ERQ27:1;                 /* Enable DMA Request 27 */
    vuint32_t ERQ26:1;                 /* Enable DMA Request 26 */
    vuint32_t ERQ25:1;                 /* Enable DMA Request 25 */
    vuint32_t ERQ24:1;                 /* Enable DMA Request 24 */
    vuint32_t ERQ23:1;                 /* Enable DMA Request 23 */
    vuint32_t ERQ22:1;                 /* Enable DMA Request 22 */
    vuint32_t ERQ21:1;                 /* Enable DMA Request 21 */
    vuint32_t ERQ20:1;                 /* Enable DMA Request 20 */
    vuint32_t ERQ19:1;                 /* Enable DMA Request 19 */
    vuint32_t ERQ18:1;                 /* Enable DMA Request 18 */
    vuint32_t ERQ17:1;                 /* Enable DMA Request 17 */
    vuint32_t ERQ16:1;                 /* Enable DMA Request 16 */
    vuint32_t ERQ15:1;                 /* Enable DMA Request 15 */
    vuint32_t ERQ14:1;                 /* Enable DMA Request 14 */
    vuint32_t ERQ13:1;                 /* Enable DMA Request 13 */
    vuint32_t ERQ12:1;                 /* Enable DMA Request 12 */
    vuint32_t ERQ11:1;                 /* Enable DMA Request 11 */
    vuint32_t ERQ10:1;                 /* Enable DMA Request 10 */
    vuint32_t ERQ9:1;                  /* Enable DMA Request 9 */
    vuint32_t ERQ8:1;                  /* Enable DMA Request 8 */
    vuint32_t ERQ7:1;                  /* Enable DMA Request 7 */
    vuint32_t ERQ6:1;                  /* Enable DMA Request 6 */
    vuint32_t ERQ5:1;                  /* Enable DMA Request 5 */
    vuint32_t ERQ4:1;                  /* Enable DMA Request 4 */
    vuint32_t ERQ3:1;                  /* Enable DMA Request 3 */
    vuint32_t ERQ2:1;                  /* Enable DMA Request 2 */
    vuint32_t ERQ1:1;                  /* Enable DMA Request 1 */
    vuint32_t ERQ0:1;                  /* Enable DMA Request 0 */
  } B;
} DMA_ERQ_tag;

typedef union DMA_EEI_union_tag {      /* Enable Error Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t EEI31:1;                 /* Enable Error Interrupt 31 */
    vuint32_t EEI30:1;                 /* Enable Error Interrupt 30 */
    vuint32_t EEI29:1;                 /* Enable Error Interrupt 29 */
    vuint32_t EEI28:1;                 /* Enable Error Interrupt 28 */
    vuint32_t EEI27:1;                 /* Enable Error Interrupt 27 */
    vuint32_t EEI26:1;                 /* Enable Error Interrupt 26 */
    vuint32_t EEI25:1;                 /* Enable Error Interrupt 25 */
    vuint32_t EEI24:1;                 /* Enable Error Interrupt 24 */
    vuint32_t EEI23:1;                 /* Enable Error Interrupt 23 */
    vuint32_t EEI22:1;                 /* Enable Error Interrupt 22 */
    vuint32_t EEI21:1;                 /* Enable Error Interrupt 21 */
    vuint32_t EEI20:1;                 /* Enable Error Interrupt 20 */
    vuint32_t EEI19:1;                 /* Enable Error Interrupt 19 */
    vuint32_t EEI18:1;                 /* Enable Error Interrupt 18 */
    vuint32_t EEI17:1;                 /* Enable Error Interrupt 17 */
    vuint32_t EEI16:1;                 /* Enable Error Interrupt 16 */
    vuint32_t EEI15:1;                 /* Enable Error Interrupt 15 */
    vuint32_t EEI14:1;                 /* Enable Error Interrupt 14 */
    vuint32_t EEI13:1;                 /* Enable Error Interrupt 13 */
    vuint32_t EEI12:1;                 /* Enable Error Interrupt 12 */
    vuint32_t EEI11:1;                 /* Enable Error Interrupt 11 */
    vuint32_t EEI10:1;                 /* Enable Error Interrupt 10 */
    vuint32_t EEI9:1;                  /* Enable Error Interrupt 9 */
    vuint32_t EEI8:1;                  /* Enable Error Interrupt 8 */
    vuint32_t EEI7:1;                  /* Enable Error Interrupt 7 */
    vuint32_t EEI6:1;                  /* Enable Error Interrupt 6 */
    vuint32_t EEI5:1;                  /* Enable Error Interrupt 5 */
    vuint32_t EEI4:1;                  /* Enable Error Interrupt 4 */
    vuint32_t EEI3:1;                  /* Enable Error Interrupt 3 */
    vuint32_t EEI2:1;                  /* Enable Error Interrupt 2 */
    vuint32_t EEI1:1;                  /* Enable Error Interrupt 1 */
    vuint32_t EEI0:1;                  /* Enable Error Interrupt 0 */
  } B;
} DMA_EEI_tag;

typedef union DMA_SERQ_union_tag {     /* Set Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAER:1;                   /* Set All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t SERQ:5;                   /* Set Enable Request */
  } B;
} DMA_SERQ_tag;

typedef union DMA_CERQ_union_tag {     /* Clear Enable Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAER:1;                   /* Clear All Enable Requests */
    vuint8_t _unused_5:1;
    vuint8_t CERQ:5;                   /* Clear Enable Request */
  } B;
} DMA_CERQ_tag;

typedef union DMA_SEEI_union_tag {     /* Set Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAEE:1;                   /* Sets All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t SEEI:5;                   /* Set Enable Error Interrupt */
  } B;
} DMA_SEEI_tag;

typedef union DMA_CEEI_union_tag {     /* Clear Enable Error Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEE:1;                   /* Clear All Enable Error Interrupts */
    vuint8_t _unused_5:1;
    vuint8_t CEEI:5;                   /* Clear Enable Error Interrupt */
  } B;
} DMA_CEEI_tag;

typedef union DMA_CINT_union_tag {     /* Clear Interrupt Request Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAIR:1;                   /* Clear All Interrupt Requests */
    vuint8_t _unused_5:1;
    vuint8_t CINT:5;                   /* Clear Interrupt Request */
  } B;
} DMA_CINT_tag;

typedef union DMA_CERR_union_tag {     /* Clear Error Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CAEI:1;                   /* Clear All Error Indicators */
    vuint8_t _unused_5:1;
    vuint8_t CERR:5;                   /* Clear Error Indicator */
  } B;
} DMA_CERR_tag;

typedef union DMA_SSRT_union_tag {     /* Set START Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t SAST:1;                   /* Set All START Bits (activates all channels) */
    vuint8_t _unused_5:1;
    vuint8_t SSRT:5;                   /* Set START Bit */
  } B;
} DMA_SSRT_tag;

typedef union DMA_CDNE_union_tag {     /* Clear DONE Status Bit Register */
  vuint8_t R;
  struct {
    vuint8_t NOP:1;                    /* No Op enable */
    vuint8_t CADN:1;                   /* Clears All DONE Bits */
    vuint8_t _unused_5:1;
    vuint8_t CDNE:5;                   /* Clear DONE Bit */
  } B;
} DMA_CDNE_tag;

typedef union DMA_INT_union_tag {      /* Interrupt Request Register */
  vuint32_t R;
  struct {
    vuint32_t INT31:1;                 /* Interrupt Request 31 */
    vuint32_t INT30:1;                 /* Interrupt Request 30 */
    vuint32_t INT29:1;                 /* Interrupt Request 29 */
    vuint32_t INT28:1;                 /* Interrupt Request 28 */
    vuint32_t INT27:1;                 /* Interrupt Request 27 */
    vuint32_t INT26:1;                 /* Interrupt Request 26 */
    vuint32_t INT25:1;                 /* Interrupt Request 25 */
    vuint32_t INT24:1;                 /* Interrupt Request 24 */
    vuint32_t INT23:1;                 /* Interrupt Request 23 */
    vuint32_t INT22:1;                 /* Interrupt Request 22 */
    vuint32_t INT21:1;                 /* Interrupt Request 21 */
    vuint32_t INT20:1;                 /* Interrupt Request 20 */
    vuint32_t INT19:1;                 /* Interrupt Request 19 */
    vuint32_t INT18:1;                 /* Interrupt Request 18 */
    vuint32_t INT17:1;                 /* Interrupt Request 17 */
    vuint32_t INT16:1;                 /* Interrupt Request 16 */
    vuint32_t INT15:1;                 /* Interrupt Request 15 */
    vuint32_t INT14:1;                 /* Interrupt Request 14 */
    vuint32_t INT13:1;                 /* Interrupt Request 13 */
    vuint32_t INT12:1;                 /* Interrupt Request 12 */
    vuint32_t INT11:1;                 /* Interrupt Request 11 */
    vuint32_t INT10:1;                 /* Interrupt Request 10 */
    vuint32_t INT9:1;                  /* Interrupt Request 9 */
    vuint32_t INT8:1;                  /* Interrupt Request 8 */
    vuint32_t INT7:1;                  /* Interrupt Request 7 */
    vuint32_t INT6:1;                  /* Interrupt Request 6 */
    vuint32_t INT5:1;                  /* Interrupt Request 5 */
    vuint32_t INT4:1;                  /* Interrupt Request 4 */
    vuint32_t INT3:1;                  /* Interrupt Request 3 */
    vuint32_t INT2:1;                  /* Interrupt Request 2 */
    vuint32_t INT1:1;                  /* Interrupt Request 1 */
    vuint32_t INT0:1;                  /* Interrupt Request 0 */
  } B;
} DMA_INT_tag;

typedef union DMA_ERR_union_tag {      /* Error Register */
  vuint32_t R;
  struct {
    vuint32_t ERR31:1;                 /* Error In Channel 31 */
    vuint32_t ERR30:1;                 /* Error In Channel 30 */
    vuint32_t ERR29:1;                 /* Error In Channel 29 */
    vuint32_t ERR28:1;                 /* Error In Channel 28 */
    vuint32_t ERR27:1;                 /* Error In Channel 27 */
    vuint32_t ERR26:1;                 /* Error In Channel 26 */
    vuint32_t ERR25:1;                 /* Error In Channel 25 */
    vuint32_t ERR24:1;                 /* Error In Channel 24 */
    vuint32_t ERR23:1;                 /* Error In Channel 23 */
    vuint32_t ERR22:1;                 /* Error In Channel 22 */
    vuint32_t ERR21:1;                 /* Error In Channel 21 */
    vuint32_t ERR20:1;                 /* Error In Channel 20 */
    vuint32_t ERR19:1;                 /* Error In Channel 19 */
    vuint32_t ERR18:1;                 /* Error In Channel 18 */
    vuint32_t ERR17:1;                 /* Error In Channel 17 */
    vuint32_t ERR16:1;                 /* Error In Channel 16 */
    vuint32_t ERR15:1;                 /* Error In Channel 15 */
    vuint32_t ERR14:1;                 /* Error In Channel 14 */
    vuint32_t ERR13:1;                 /* Error In Channel 13 */
    vuint32_t ERR12:1;                 /* Error In Channel 12 */
    vuint32_t ERR11:1;                 /* Error In Channel 11 */
    vuint32_t ERR10:1;                 /* Error In Channel 10 */
    vuint32_t ERR9:1;                  /* Error In Channel 9 */
    vuint32_t ERR8:1;                  /* Error In Channel 8 */
    vuint32_t ERR7:1;                  /* Error In Channel 7 */
    vuint32_t ERR6:1;                  /* Error In Channel 6 */
    vuint32_t ERR5:1;                  /* Error In Channel 5 */
    vuint32_t ERR4:1;                  /* Error In Channel 4 */
    vuint32_t ERR3:1;                  /* Error In Channel 3 */
    vuint32_t ERR2:1;                  /* Error In Channel 2 */
    vuint32_t ERR1:1;                  /* Error In Channel 1 */
    vuint32_t ERR0:1;                  /* Error In Channel 0 */
  } B;
} DMA_ERR_tag;

typedef union DMA_HRS_union_tag {      /* Hardware Request Status Register */
  vuint32_t R;
  struct {
    vuint32_t HRS31:1;                 /* Hardware Request Status Channel 31 */
    vuint32_t HRS30:1;                 /* Hardware Request Status Channel 30 */
    vuint32_t HRS29:1;                 /* Hardware Request Status Channel 29 */
    vuint32_t HRS28:1;                 /* Hardware Request Status Channel 28 */
    vuint32_t HRS27:1;                 /* Hardware Request Status Channel 27 */
    vuint32_t HRS26:1;                 /* Hardware Request Status Channel 26 */
    vuint32_t HRS25:1;                 /* Hardware Request Status Channel 25 */
    vuint32_t HRS24:1;                 /* Hardware Request Status Channel 24 */
    vuint32_t HRS23:1;                 /* Hardware Request Status Channel 23 */
    vuint32_t HRS22:1;                 /* Hardware Request Status Channel 22 */
    vuint32_t HRS21:1;                 /* Hardware Request Status Channel 21 */
    vuint32_t HRS20:1;                 /* Hardware Request Status Channel 20 */
    vuint32_t HRS19:1;                 /* Hardware Request Status Channel 19 */
    vuint32_t HRS18:1;                 /* Hardware Request Status Channel 18 */
    vuint32_t HRS17:1;                 /* Hardware Request Status Channel 17 */
    vuint32_t HRS16:1;                 /* Hardware Request Status Channel 16 */
    vuint32_t HRS15:1;                 /* Hardware Request Status Channel 15 */
    vuint32_t HRS14:1;                 /* Hardware Request Status Channel 14 */
    vuint32_t HRS13:1;                 /* Hardware Request Status Channel 13 */
    vuint32_t HRS12:1;                 /* Hardware Request Status Channel 12 */
    vuint32_t HRS11:1;                 /* Hardware Request Status Channel 11 */
    vuint32_t HRS10:1;                 /* Hardware Request Status Channel 10 */
    vuint32_t HRS9:1;                  /* Hardware Request Status Channel 9 */
    vuint32_t HRS8:1;                  /* Hardware Request Status Channel 8 */
    vuint32_t HRS7:1;                  /* Hardware Request Status Channel 7 */
    vuint32_t HRS6:1;                  /* Hardware Request Status Channel 6 */
    vuint32_t HRS5:1;                  /* Hardware Request Status Channel 5 */
    vuint32_t HRS4:1;                  /* Hardware Request Status Channel 4 */
    vuint32_t HRS3:1;                  /* Hardware Request Status Channel 3 */
    vuint32_t HRS2:1;                  /* Hardware Request Status Channel 2 */
    vuint32_t HRS1:1;                  /* Hardware Request Status Channel 1 */
    vuint32_t HRS0:1;                  /* Hardware Request Status Channel 0 */
  } B;
} DMA_HRS_tag;

typedef union DMA_GPOR_union_tag {     /* General-Purpose Output Register */
  vuint32_t R;
  struct {
    vuint32_t GPOR:32;                 /* General-purpose output */
  } B;
} DMA_GPOR_tag;
typedef union DMA_DCHPRI_union_tag {   /* Channel n Priority Register */
  vuint8_t R;
  struct {
    vuint8_t ECP:1;                    /* Enable Channel Preemption. */
    vuint8_t DPA:1;                    /* Disable Preempt Ability. */
    vuint8_t GRPPRI:2;                 /* Channel n Current Group Priority */
    vuint8_t CHPRI:4;                  /* Channel n Arbitration Priority */
  } B;
} DMA_DCHPRI_tag;

typedef union DMA_DCHMID_union_tag {   /* Channel n Master ID Register */
  vuint8_t R;
  struct {
    vuint8_t EMI:1;                    /* Enable Master ID replication */
    vuint8_t PAL:1;                    /* Privileged Access Level */
    vuint8_t _unused_4:2;
    vuint8_t MID:4;                    /* Master ID */
  } B;
} DMA_DCHMID_tag;

typedef union DMA_TCD_SADDR_union_tag { /* TCD Source Address */
  vuint32_t R;
  struct {
    vuint32_t SADDR:32;                /* Source Address */
  } B;
} DMA_TCD_SADDR_tag;

typedef union DMA_TCD_ATTR_union_tag { /* TCD Transfer Attributes */
  vuint16_t R;
  struct {
    vuint16_t SMOD:5;                  /* Source Address Modulo */
    vuint16_t SSIZE:3;                 /* Source data transfer size */
    vuint16_t DMOD:5;                  /* Destination Address Modulo */
    vuint16_t DSIZE:3;                 /* Destination data transfer size */
  } B;
} DMA_TCD_ATTR_tag;

typedef union DMA_TCD_SOFF_union_tag { /* TCD Signed Source Address Offset */
  vuint16_t R;
  struct {
    vuint16_t SOFF:16;                 /* Source address signed offset */
  } B;
} DMA_TCD_SOFF_tag;

typedef union DMA_TCD_NBYTES_MLNO_union_tag { /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  vuint32_t R;
  struct {
    vuint32_t NBYTES:32;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFNO_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t NBYTES:30;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFNO_tag;

typedef union DMA_TCD_NBYTES_MLOFFYES_union_tag { /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
  vuint32_t R;
  struct {
    vuint32_t SMLOE:1;                 /* Source Minor Loop Offset Enable */
    vuint32_t DMLOE:1;                 /* Destination Minor Loop Offset enable */
    vuint32_t MLOFF:20;                /* If SMLOE or DMLOE is set, this field represents a sign-extended offset applied to the source or destination address to form the next-state value after the minor loop completes. */
    vuint32_t NBYTES:10;               /* Minor Byte Transfer Count */
  } B;
} DMA_TCD_NBYTES_MLOFFYES_tag;

typedef union DMA_TCD_NBYTES_union_tag {
  DMA_TCD_NBYTES_MLNO_tag MLNO;        /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
  DMA_TCD_NBYTES_MLOFFNO_tag MLOFFNO;  /* TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled) */
  DMA_TCD_NBYTES_MLOFFYES_tag MLOFFYES; /* TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled) */
} DMA_TCD_NBYTES_tag;

typedef union DMA_TCD_SLAST_union_tag { /* TCD Last Source Address Adjustment */
  vuint32_t R;
  struct {
    vuint32_t SLAST:32;                /* Last Source Address Adjustment */
  } B;
} DMA_TCD_SLAST_tag;

typedef union DMA_TCD_DADDR_union_tag { /* TCD Destination Address */
  vuint32_t R;
  struct {
    vuint32_t DADDR:32;                /* Destination Address */
  } B;
} DMA_TCD_DADDR_tag;

typedef union DMA_TCD_CITER_ELINKNO_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t CITER:15;                /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKNO_tag;

typedef union DMA_TCD_CITER_ELINKYES_union_tag { /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enable channel-to-channel linking on minor-loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Minor Loop Link Channel Number */
    vuint16_t CITER:9;                 /* Current Major Iteration Count */
  } B;
} DMA_TCD_CITER_ELINKYES_tag;

typedef union DMA_TCD_CITER_union_tag {
  DMA_TCD_CITER_ELINKNO_tag ELINKNO;   /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_CITER_ELINKYES_tag ELINKYES; /* TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_CITER_tag;

typedef union DMA_TCD_DOFF_union_tag { /* TCD Signed Destination Address Offset */
  vuint16_t R;
  struct {
    vuint16_t DOFF:16;                 /* Destination Address Signed Offset */
  } B;
} DMA_TCD_DOFF_tag;

typedef union DMA_TCD_DLASTSGA_union_tag { /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  vuint32_t R;
  struct {
    vuint32_t DLASTSGA:32;
  } B;
} DMA_TCD_DLASTSGA_tag;

typedef union DMA_TCD_BITER_ELINKNO_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t BITER:15;                /* Starting Major Iteration Count */
  } B;
} DMA_TCD_BITER_ELINKNO_tag;

typedef union DMA_TCD_BITER_ELINKYES_union_tag { /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
  vuint16_t R;
  struct {
    vuint16_t ELINK:1;                 /* Enables channel-to-channel linking on minor loop complete */
    vuint16_t _unused_14:1;
    vuint16_t LINKCH:5;                /* Link Channel Number */
    vuint16_t BITER:9;                 /* Starting major iteration count */
  } B;
} DMA_TCD_BITER_ELINKYES_tag;

typedef union DMA_TCD_BITER_union_tag {
  DMA_TCD_BITER_ELINKNO_tag ELINKNO;   /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
  DMA_TCD_BITER_ELINKYES_tag ELINKYES; /* TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
} DMA_TCD_BITER_tag;

typedef union DMA_TCD_CSR_union_tag {  /* TCD Control and Status */
  vuint16_t R;
  struct {
    vuint16_t BWC:2;                   /* Bandwidth Control */
    vuint16_t _unused_13:1;
    vuint16_t MAJORLINKCH:5;           /* Major Loop Link Channel Number */
    vuint16_t DONE:1;                  /* Channel Done */
    vuint16_t ACTIVE:1;                /* Channel Active */
    vuint16_t MAJORELINK:1;            /* Enable channel-to-channel linking on major loop complete */
    vuint16_t ESG:1;                   /* Enable Scatter/Gather Processing */
    vuint16_t DREQ:1;                  /* Disable Request */
    vuint16_t INTHALF:1;               /* Enable an interrupt when major counter is half complete. */
    vuint16_t INTMAJOR:1;              /* Enable an interrupt when major iteration count completes. */
    vuint16_t START:1;                 /* Channel Start */
  } B;
} DMA_TCD_CSR_tag;

typedef struct DMA_TCD_struct_tag {
  DMA_TCD_SADDR_tag SADDR;             /* TCD Source Address */
  DMA_TCD_ATTR_tag ATTR;               /* TCD Transfer Attributes */
  DMA_TCD_SOFF_tag SOFF;               /* TCD Signed Source Address Offset */
  DMA_TCD_NBYTES_tag NBYTES;
  DMA_TCD_SLAST_tag SLAST;             /* TCD Last Source Address Adjustment */
  DMA_TCD_DADDR_tag DADDR;             /* TCD Destination Address */
  DMA_TCD_CITER_tag CITER;
  DMA_TCD_DOFF_tag DOFF;               /* TCD Signed Destination Address Offset */
  DMA_TCD_DLASTSGA_tag DLASTSGA;       /* TCD Last Destination Address Adjustment/Scatter Gather Address */
  DMA_TCD_BITER_tag BITER;
  DMA_TCD_CSR_tag CSR;                 /* TCD Control and Status */
} DMA_TCD_tag;

struct DMA_tag {
  DMA_CR_tag CR;                       /* Control Register */
  DMA_ES_tag ES;                       /* Error Status Register */
  uint8_t DMA_reserved0[4];
  DMA_ERQ_tag ERQ;                     /* Enable Request Register */
  uint8_t DMA_reserved1[4];
  DMA_EEI_tag EEI;                     /* Enable Error Interrupt Register */
  DMA_SERQ_tag SERQ;                   /* Set Enable Request Register */
  DMA_CERQ_tag CERQ;                   /* Clear Enable Request Register */
  DMA_SEEI_tag SEEI;                   /* Set Enable Error Interrupt Register */
  DMA_CEEI_tag CEEI;                   /* Clear Enable Error Interrupt Register */
  DMA_CINT_tag CINT;                   /* Clear Interrupt Request Register */
  DMA_CERR_tag CERR;                   /* Clear Error Register */
  DMA_SSRT_tag SSRT;                   /* Set START Bit Register */
  DMA_CDNE_tag CDNE;                   /* Clear DONE Status Bit Register */
  uint8_t DMA_reserved2[4];
  DMA_INT_tag INT;                     /* Interrupt Request Register */
  uint8_t DMA_reserved3[4];
  DMA_ERR_tag ERR;                     /* Error Register */
  uint8_t DMA_reserved4[4];
  DMA_HRS_tag HRS;                     /* Hardware Request Status Register */
  DMA_GPOR_tag GPOR[2];                /* General-Purpose Output Register */
  uint8_t DMA_reserved5[192];
  DMA_DCHPRI_tag DCHPRI[32];           /* Channel n Priority Register */
  uint8_t DMA_reserved6[32];
  DMA_DCHMID_tag DCHMID[32];           /* Channel n Master ID Register */
  uint8_t DMA_reserved7[3744];
  DMA_TCD_tag TCD[32];
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

typedef union DMAMUX_CHCFG_union_tag { /* Channel Configuration register */
  vuint8_t R;
  struct {
    vuint8_t ENBL:1;                   /* DMA Channel Enable */
    vuint8_t TRIG:1;                   /* DMA Channel Trigger Enable */
    vuint8_t SOURCE:6;                 /* DMA Channel Source (Slot) */
  } B;
} DMAMUX_CHCFG_tag;

struct DMAMUX_tag {
  DMAMUX_CHCFG_tag CHCFG[16];          /* Channel Configuration register */
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

typedef union DTS_ENABLE_union_tag {   /* Output Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t DTS_EN_B:1;
    vuint32_t DTS_EN:1;
  } B;
} DTS_ENABLE_tag;

typedef union DTS_STARTUP_union_tag {  /* Startup Register */
  vuint32_t R;
  struct {
    vuint32_t AD:32;
  } B;
} DTS_STARTUP_tag;

typedef union DTS_SEMAPHORE_union_tag { /* Semaphore Register */
  vuint32_t R;
  struct {
    vuint32_t ST:32;
  } B;
} DTS_SEMAPHORE_tag;

typedef union DTS_SEMAPHORE_B_union_tag { /* Semaphore Extension */
  vuint32_t R;
  struct {
    vuint32_t ST_B:32;
  } B;
} DTS_SEMAPHORE_B_tag;

struct DTS_tag {
  DTS_ENABLE_tag ENABLE;               /* Output Enable Register */
  DTS_STARTUP_tag STARTUP;             /* Startup Register */
  DTS_SEMAPHORE_tag SEMAPHORE;         /* Semaphore Register */
  DTS_SEMAPHORE_B_tag SEMAPHORE_B;     /* Semaphore Extension */
};


/* ============================================================================
   =============================== Module: EIM ================================
   ============================================================================ */

typedef union EIM_EIMCR_union_tag {    /* Error Injection Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t GEIEN:1;                 /* Global Error Injection Enable */
  } B;
} EIM_EIMCR_tag;

typedef union EIM_EICHEN_union_tag {   /* Error Injection Channel Enable register */
  vuint32_t R;
  struct {
    vuint32_t EICH0EN:1;               /* Error Injection Channel 0 Enable */
    vuint32_t _unused_0:31;
  } B;
} EIM_EICHEN_tag;

typedef union EIM_EICHD_WORD0_union_tag { /* Error Injection Channel Descriptor, Word0 */
  vuint32_t R;
  struct {
    vuint32_t CHKBIT_MASK:8;           /* Checkbit Mask */
    vuint32_t _unused_0:24;
  } B;
} EIM_EICHD_WORD0_tag;

typedef union EIM_EICHD_WORD1_union_tag { /* Error Injection Channel Descriptor, Word1 */
  vuint32_t R;
  struct {
    vuint32_t B0_3DATA_MASK:32;        /* Data Mask Bytes 0-3 */
  } B;
} EIM_EICHD_WORD1_tag;

typedef union EIM_EICHD_WORD2_union_tag { /* Error Injection Channel Descriptor, Word2 */
  vuint32_t R;
  struct {
    vuint32_t B4_7DATA_MASK:32;        /* Data Mask Bytes 4-7 */
  } B;
} EIM_EICHD_WORD2_tag;

struct EIM_tag {
  EIM_EIMCR_tag EIMCR;                 /* Error Injection Module Configuration Register */
  EIM_EICHEN_tag EICHEN;               /* Error Injection Channel Enable register */
  uint8_t EIM_reserved0[248];
  EIM_EICHD_WORD0_tag EICHD_WORD0;     /* Error Injection Channel Descriptor, Word0 */
  EIM_EICHD_WORD1_tag EICHD_WORD1;     /* Error Injection Channel Descriptor, Word1 */
  EIM_EICHD_WORD2_tag EICHD_WORD2;     /* Error Injection Channel Descriptor, Word2 */
};


/* ============================================================================
   =============================== Module: ENET ===============================
   ============================================================================ */

typedef union ENET_EIR_union_tag {     /* Interrupt Event Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t BABR:1;                  /* Babbling Receive Error */
    vuint32_t BABT:1;                  /* Babbling Transmit Error */
    vuint32_t GRA:1;                   /* Graceful Stop Complete */
    vuint32_t TXF:1;                   /* Transmit Frame Interrupt */
    vuint32_t TXB:1;                   /* Transmit Buffer Interrupt */
    vuint32_t RXF:1;                   /* Receive Frame Interrupt */
    vuint32_t RXB:1;                   /* Receive Buffer Interrupt */
    vuint32_t MII:1;                   /* MII Interrupt. */
    vuint32_t EBERR:1;                 /* Ethernet Bus Error */
    vuint32_t LC:1;                    /* Late Collision */
    vuint32_t RL:1;                    /* Collision Retry Limit */
    vuint32_t UN:1;                    /* Transmit FIFO Underrun */
    vuint32_t PLR:1;                   /* Payload Receive Error */
    vuint32_t WAKEUP:1;                /* Node Wakeup Request Indication */
    vuint32_t TS_AVAIL:1;              /* Transmit Timestamp Available */
    vuint32_t TS_TIMER:1;              /* Timestamp Timer */
    vuint32_t _unused_13:2;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t _unused_8:1;
    vuint32_t _unused_0:8;
  } B;
} ENET_EIR_tag;

typedef union ENET_EIMR_union_tag {    /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t BABR:1;                  /* BABR Interrupt Mask */
    vuint32_t BABT:1;                  /* BABT Interrupt Mask */
    vuint32_t GRA:1;                   /* GRA Interrupt Mask */
    vuint32_t TXF:1;                   /* TXF Interrupt Mask */
    vuint32_t TXB:1;                   /* TXB Interrupt Mask */
    vuint32_t RXF:1;                   /* RXF Interrupt Mask */
    vuint32_t RXB:1;                   /* RXB Interrupt Mask */
    vuint32_t MII:1;                   /* MII Interrupt Mask */
    vuint32_t EBERR:1;                 /* EBERR Interrupt Mask */
    vuint32_t LC:1;                    /* LC Interrupt Mask */
    vuint32_t RL:1;                    /* RL Interrupt Mask */
    vuint32_t UN:1;                    /* UN Interrupt Mask */
    vuint32_t PLR:1;                   /* PLR Interrupt Mask */
    vuint32_t WAKEUP:1;                /* WAKEUP Interrupt Mask */
    vuint32_t TS_AVAIL:1;              /* TS_AVAIL Interrupt Mask */
    vuint32_t TS_TIMER:1;              /* TS_TIMER Interrupt Mask */
    vuint32_t _unused_13:2;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t _unused_8:1;
    vuint32_t _unused_0:8;
  } B;
} ENET_EIMR_tag;

typedef union ENET_RDAR_union_tag {    /* Receive Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t RDAR:1;                  /* Receive Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_RDAR_tag;

typedef union ENET_TDAR_union_tag {    /* Transmit Descriptor Active Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t TDAR:1;                  /* Transmit Descriptor Active */
    vuint32_t _unused_0:24;
  } B;
} ENET_TDAR_tag;

typedef union ENET_ECR_union_tag {     /* Ethernet Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t _unused_12:6;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t _unused_9:1;
    vuint32_t DBSWP:1;                 /* Descriptor Byte Swapping Enable */
    vuint32_t STOPEN:1;                /* STOPEN Signal Control */
    vuint32_t DBGEN:1;                 /* Debug Enable */
    vuint32_t _unused_5:1;
    vuint32_t EN1588:1;                /* EN1588 Enable */
    vuint32_t SLEEP:1;                 /* Sleep Mode Enable */
    vuint32_t MAGICEN:1;               /* Magic Packet Detection Enable */
    vuint32_t ETHEREN:1;               /* Ethernet Enable */
    vuint32_t RESET:1;                 /* Ethernet MAC Reset */
  } B;
} ENET_ECR_tag;

typedef union ENET_MMFR_union_tag {    /* MII Management Frame Register */
  vuint32_t R;
  struct {
    vuint32_t ST:2;                    /* Start Of Frame Delimiter */
    vuint32_t OP:2;                    /* Operation Code */
    vuint32_t PA:5;                    /* PHY Address */
    vuint32_t RA:5;                    /* Register Address */
    vuint32_t TA:2;                    /* Turn Around */
    vuint32_t DATA:16;                 /* Management Frame Data */
  } B;
} ENET_MMFR_tag;

typedef union ENET_MSCR_union_tag {    /* MII Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t HOLDTIME:3;              /* Hold time On MDIO Output */
    vuint32_t DIS_PRE:1;               /* Disable Preamble */
    vuint32_t MII_SPEED:6;             /* MII Speed */
    vuint32_t _unused_0:1;
  } B;
} ENET_MSCR_tag;

typedef union ENET_MIBC_union_tag {    /* MIB Control Register */
  vuint32_t R;
  struct {
    vuint32_t MIB_DIS:1;               /* Disable MIB Logic */
    vuint32_t MIB_IDLE:1;              /* MIB Idle */
    vuint32_t MIB_CLEAR:1;             /* MIB Clear */
    vuint32_t _unused_0:29;
  } B;
} ENET_MIBC_tag;

typedef union ENET_RCR_union_tag {     /* Receive Control Register */
  vuint32_t R;
  struct {
    vuint32_t GRS:1;                   /* Graceful Receive Stopped */
    vuint32_t NLC:1;                   /* Payload Length Check Disable */
    vuint32_t MAX_FL:14;               /* Maximum Frame Length */
    vuint32_t CFEN:1;                  /* MAC Control Frame Enable */
    vuint32_t CRCFWD:1;                /* Terminate/Forward Received CRC */
    vuint32_t PAUFWD:1;                /* Terminate/Forward Pause Frames */
    vuint32_t PADEN:1;                 /* Enable Frame Padding Remove On Receive */
    vuint32_t _unused_10:2;
    vuint32_t RMII_10T:1;
    vuint32_t RMII_MODE:1;             /* RMII Mode Enable */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t FCE:1;                   /* Flow Control Enable */
    vuint32_t BC_REJ:1;                /* Broadcast Frame Reject */
    vuint32_t PROM:1;                  /* Promiscuous Mode */
    vuint32_t MII_MODE:1;              /* Media Independent Interface Mode */
    vuint32_t DRT:1;                   /* Disable Receive On Transmit */
    vuint32_t LOOP:1;                  /* Internal Loopback */
  } B;
} ENET_RCR_tag;

typedef union ENET_TCR_union_tag {     /* Transmit Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CRCFWD:1;                /* Forward Frame From Application With CRC */
    vuint32_t ADDINS:1;                /* Set MAC Address On Transmit */
    vuint32_t ADDSEL:3;                /* Source MAC Address Select On Transmit */
    vuint32_t RFC_PAUSE:1;             /* Receive Frame Control Pause */
    vuint32_t TFC_PAUSE:1;             /* Transmit Frame Control Pause */
    vuint32_t FDEN:1;                  /* Full-Duplex Enable */
    vuint32_t _unused_1:1;
    vuint32_t GTS:1;                   /* Graceful Transmit Stop */
  } B;
} ENET_TCR_tag;

typedef union ENET_PALR_union_tag {    /* Physical Address Lower Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR1:32;               /* Pause Address */
  } B;
} ENET_PALR_tag;

typedef union ENET_PAUR_union_tag {    /* Physical Address Upper Register */
  vuint32_t R;
  struct {
    vuint32_t PADDR2:16;
    vuint32_t TYPE:16;                 /* Type Field In PAUSE Frames */
  } B;
} ENET_PAUR_tag;

typedef union ENET_OPD_union_tag {     /* Opcode/Pause Duration Register */
  vuint32_t R;
  struct {
    vuint32_t OPCODE:16;               /* Opcode Field In PAUSE Frames */
    vuint32_t PAUSE_DUR:16;            /* Pause Duration */
  } B;
} ENET_OPD_tag;

typedef union ENET_IAUR_union_tag {    /* Descriptor Individual Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR1:32;
  } B;
} ENET_IAUR_tag;

typedef union ENET_IALR_union_tag {    /* Descriptor Individual Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t IADDR2:32;
  } B;
} ENET_IALR_tag;

typedef union ENET_GAUR_union_tag {    /* Descriptor Group Upper Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR1:32;
  } B;
} ENET_GAUR_tag;

typedef union ENET_GALR_union_tag {    /* Descriptor Group Lower Address Register */
  vuint32_t R;
  struct {
    vuint32_t GADDR2:32;
  } B;
} ENET_GALR_tag;

typedef union ENET_TFWR_union_tag {    /* Transmit FIFO Watermark Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t STRFWD:1;                /* Store And Forward Enable */
    vuint32_t _unused_6:2;
    vuint32_t TFWR:6;                  /* Transmit FIFO Write */
  } B;
} ENET_TFWR_tag;

typedef union ENET_RDSR_union_tag {    /* Receive Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t R_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_RDSR_tag;

typedef union ENET_TDSR_union_tag {    /* Transmit Buffer Descriptor Ring Start Register */
  vuint32_t R;
  struct {
    vuint32_t X_DES_START:29;
    vuint32_t _unused_2:1;
    vuint32_t _unused_0:2;
  } B;
} ENET_TDSR_tag;

typedef union ENET_MRBR_union_tag {    /* Maximum Receive Buffer Size Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t R_BUF_SIZE:7;
    vuint32_t _unused_0:4;             /* This field, which is always zero, is the four least-significant bits of the maximum receive buffer size. */
  } B;
} ENET_MRBR_tag;

typedef union ENET_RSFL_union_tag {    /* Receive FIFO Section Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_SECTION_FULL:8;       /* Value Of Receive FIFO Section Full Threshold */
  } B;
} ENET_RSFL_tag;

typedef union ENET_RSEM_union_tag {    /* Receive FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t STAT_SECTION_EMPTY:5;    /* RX Status FIFO Section Empty Threshold */
    vuint32_t _unused_8:8;
    vuint32_t RX_SECTION_EMPTY:8;      /* Value Of The Receive FIFO Section Empty Threshold */
  } B;
} ENET_RSEM_tag;

typedef union ENET_RAEM_union_tag {    /* Receive FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_ALMOST_EMPTY:8;       /* Value Of The Receive FIFO Almost Empty Threshold */
  } B;
} ENET_RAEM_tag;

typedef union ENET_RAFL_union_tag {    /* Receive FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RX_ALMOST_FULL:8;        /* Value Of The Receive FIFO Almost Full Threshold */
  } B;
} ENET_RAFL_tag;

typedef union ENET_TSEM_union_tag {    /* Transmit FIFO Section Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_SECTION_EMPTY:8;      /* Value Of The Transmit FIFO Section Empty Threshold */
  } B;
} ENET_TSEM_tag;

typedef union ENET_TAEM_union_tag {    /* Transmit FIFO Almost Empty Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_ALMOST_EMPTY:8;       /* Value of Transmit FIFO Almost Empty Threshold */
  } B;
} ENET_TAEM_tag;

typedef union ENET_TAFL_union_tag {    /* Transmit FIFO Almost Full Threshold */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TX_ALMOST_FULL:8;        /* Value Of The Transmit FIFO Almost Full Threshold */
  } B;
} ENET_TAFL_tag;

typedef union ENET_TIPG_union_tag {    /* Transmit Inter-Packet Gap */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IPG:5;                   /* Transmit Inter-Packet Gap */
  } B;
} ENET_TIPG_tag;

typedef union ENET_FTRL_union_tag {    /* Frame Truncation Length */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t TRUNC_FL:14;             /* Frame Truncation Length */
  } B;
} ENET_FTRL_tag;

typedef union ENET_TACC_union_tag {    /* Transmit Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t PROCHK:1;
    vuint32_t IPCHK:1;
    vuint32_t _unused_1:2;
    vuint32_t SHIFT16:1;               /* TX FIFO Shift-16 */
  } B;
} ENET_TACC_tag;

typedef union ENET_RACC_union_tag {    /* Receive Accelerator Function Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t SHIFT16:1;               /* RX FIFO Shift-16 */
    vuint32_t LINEDIS:1;               /* Enable Discard Of Frames With MAC Layer Errors */
    vuint32_t _unused_3:3;
    vuint32_t PRODIS:1;                /* Enable Discard Of Frames With Wrong Protocol Checksum */
    vuint32_t IPDIS:1;                 /* Enable Discard Of Frames With Wrong IPv4 Header Checksum */
    vuint32_t PADREM:1;                /* Enable Padding Removal For Short IP Frames */
  } B;
} ENET_RACC_tag;

typedef union ENET_RMON_T_DROP_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_RMON_T_DROP_tag;

typedef union ENET_RMON_T_PACKETS_union_tag { /* Tx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Packet count */
    vuint32_t TXPKTS14:1;              /* Packet count */
    vuint32_t TXPKTS13:1;              /* Packet count */
    vuint32_t TXPKTS12:1;              /* Packet count */
    vuint32_t TXPKTS11:1;              /* Packet count */
    vuint32_t TXPKTS10:1;              /* Packet count */
    vuint32_t TXPKTS9:1;               /* Packet count */
    vuint32_t TXPKTS8:1;               /* Packet count */
    vuint32_t TXPKTS7:1;               /* Packet count */
    vuint32_t TXPKTS6:1;               /* Packet count */
    vuint32_t TXPKTS5:1;               /* Packet count */
    vuint32_t TXPKTS4:1;               /* Packet count */
    vuint32_t TXPKTS3:1;               /* Packet count */
    vuint32_t TXPKTS2:1;               /* Packet count */
    vuint32_t TXPKTS1:1;               /* Packet count */
    vuint32_t TXPKTS0:1;               /* Packet count */
  } B;
} ENET_RMON_T_PACKETS_tag;

typedef union ENET_RMON_T_BC_PKT_union_tag { /* Tx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Broadcast packets */
    vuint32_t TXPKTS14:1;              /* Broadcast packets */
    vuint32_t TXPKTS13:1;              /* Broadcast packets */
    vuint32_t TXPKTS12:1;              /* Broadcast packets */
    vuint32_t TXPKTS11:1;              /* Broadcast packets */
    vuint32_t TXPKTS10:1;              /* Broadcast packets */
    vuint32_t TXPKTS9:1;               /* Broadcast packets */
    vuint32_t TXPKTS8:1;               /* Broadcast packets */
    vuint32_t TXPKTS7:1;               /* Broadcast packets */
    vuint32_t TXPKTS6:1;               /* Broadcast packets */
    vuint32_t TXPKTS5:1;               /* Broadcast packets */
    vuint32_t TXPKTS4:1;               /* Broadcast packets */
    vuint32_t TXPKTS3:1;               /* Broadcast packets */
    vuint32_t TXPKTS2:1;               /* Broadcast packets */
    vuint32_t TXPKTS1:1;               /* Broadcast packets */
    vuint32_t TXPKTS0:1;               /* Broadcast packets */
  } B;
} ENET_RMON_T_BC_PKT_tag;

typedef union ENET_RMON_T_MC_PKT_union_tag { /* Tx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Multicast packets */
    vuint32_t TXPKTS14:1;              /* Multicast packets */
    vuint32_t TXPKTS13:1;              /* Multicast packets */
    vuint32_t TXPKTS12:1;              /* Multicast packets */
    vuint32_t TXPKTS11:1;              /* Multicast packets */
    vuint32_t TXPKTS10:1;              /* Multicast packets */
    vuint32_t TXPKTS9:1;               /* Multicast packets */
    vuint32_t TXPKTS8:1;               /* Multicast packets */
    vuint32_t TXPKTS7:1;               /* Multicast packets */
    vuint32_t TXPKTS6:1;               /* Multicast packets */
    vuint32_t TXPKTS5:1;               /* Multicast packets */
    vuint32_t TXPKTS4:1;               /* Multicast packets */
    vuint32_t TXPKTS3:1;               /* Multicast packets */
    vuint32_t TXPKTS2:1;               /* Multicast packets */
    vuint32_t TXPKTS1:1;               /* Multicast packets */
    vuint32_t TXPKTS0:1;               /* Multicast packets */
  } B;
} ENET_RMON_T_MC_PKT_tag;

typedef union ENET_RMON_T_CRC_ALIGN_union_tag { /* Tx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS14:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS13:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS12:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS11:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS10:1;              /* Packets with CRC/align error */
    vuint32_t TXPKTS9:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS8:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS7:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS6:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS5:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS4:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS3:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS2:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS1:1;               /* Packets with CRC/align error */
    vuint32_t TXPKTS0:1;               /* Packets with CRC/align error */
  } B;
} ENET_RMON_T_CRC_ALIGN_tag;

typedef union ENET_RMON_T_UNDERSIZE_union_tag { /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets less than 64 bytes with good CRC */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets less than 64 bytes with good CRC */
  } B;
} ENET_RMON_T_UNDERSIZE_tag;

typedef union ENET_RMON_T_OVERSIZE_union_tag { /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets greater than MAX_FL bytes with good CRC */
  } B;
} ENET_RMON_T_OVERSIZE_tag;

typedef union ENET_RMON_T_FRAG_union_tag { /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS14:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS13:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS12:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS11:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS10:1;              /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS9:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS8:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS7:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS6:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS5:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS4:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS3:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS2:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS1:1;               /* Number of packets less than 64 bytes with bad CRC */
    vuint32_t TXPKTS0:1;               /* Number of packets less than 64 bytes with bad CRC */
  } B;
} ENET_RMON_T_FRAG_tag;

typedef union ENET_RMON_T_JAB_union_tag { /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets greater than MAX_FL bytes and bad CRC */
  } B;
} ENET_RMON_T_JAB_tag;

typedef union ENET_RMON_T_COL_union_tag { /* Tx Collision Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS14:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS13:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS12:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS11:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS10:1;              /* Number of transmit collisions */
    vuint32_t TXPKTS9:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS8:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS7:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS6:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS5:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS4:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS3:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS2:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS1:1;               /* Number of transmit collisions */
    vuint32_t TXPKTS0:1;               /* Number of transmit collisions */
  } B;
} ENET_RMON_T_COL_tag;

typedef union ENET_RMON_T_P64_union_tag { /* Tx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 64-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 64-byte transmit packets */
  } B;
} ENET_RMON_T_P64_tag;

typedef union ENET_RMON_T_P65TO127_union_tag { /* Tx 65- to 127-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 65- to 127-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 65- to 127-byte transmit packets */
  } B;
} ENET_RMON_T_P65TO127_tag;

typedef union ENET_RMON_T_P128TO255_union_tag { /* Tx 128- to 255-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 128- to 255-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 128- to 255-byte transmit packets */
  } B;
} ENET_RMON_T_P128TO255_tag;

typedef union ENET_RMON_T_P256TO511_union_tag { /* Tx 256- to 511-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 256- to 511-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 256- to 511-byte transmit packets */
  } B;
} ENET_RMON_T_P256TO511_tag;

typedef union ENET_RMON_T_P512TO1023_union_tag { /* Tx 512- to 1023-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 512- to 1023-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 512- to 1023-byte transmit packets */
  } B;
} ENET_RMON_T_P512TO1023_tag;

typedef union ENET_RMON_T_P1024TO2047_union_tag { /* Tx 1024- to 2047-byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS14:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS13:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS12:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS11:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS10:1;              /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS9:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS8:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS7:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS6:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS5:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS4:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS3:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS2:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS1:1;               /* Number of 1024- to 2047-byte transmit packets */
    vuint32_t TXPKTS0:1;               /* Number of 1024- to 2047-byte transmit packets */
  } B;
} ENET_RMON_T_P1024TO2047_tag;

typedef union ENET_RMON_T_P_GTE2048_union_tag { /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXPKTS15:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS14:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS13:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS12:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS11:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS10:1;              /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS9:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS8:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS7:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS6:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS5:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS4:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS3:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS2:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS1:1;               /* Number of transmit packets greater than 2048 bytes */
    vuint32_t TXPKTS0:1;               /* Number of transmit packets greater than 2048 bytes */
  } B;
} ENET_RMON_T_P_GTE2048_tag;

typedef union ENET_RMON_T_OCTETS_union_tag { /* Tx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t TXOCTS31:1;              /* Number of transmit octets */
    vuint32_t TXOCTS30:1;              /* Number of transmit octets */
    vuint32_t TXOCTS29:1;              /* Number of transmit octets */
    vuint32_t TXOCTS28:1;              /* Number of transmit octets */
    vuint32_t TXOCTS27:1;              /* Number of transmit octets */
    vuint32_t TXOCTS26:1;              /* Number of transmit octets */
    vuint32_t TXOCTS25:1;              /* Number of transmit octets */
    vuint32_t TXOCTS24:1;              /* Number of transmit octets */
    vuint32_t TXOCTS23:1;              /* Number of transmit octets */
    vuint32_t TXOCTS22:1;              /* Number of transmit octets */
    vuint32_t TXOCTS21:1;              /* Number of transmit octets */
    vuint32_t TXOCTS20:1;              /* Number of transmit octets */
    vuint32_t TXOCTS19:1;              /* Number of transmit octets */
    vuint32_t TXOCTS18:1;              /* Number of transmit octets */
    vuint32_t TXOCTS17:1;              /* Number of transmit octets */
    vuint32_t TXOCTS16:1;              /* Number of transmit octets */
    vuint32_t TXOCTS15:1;              /* Number of transmit octets */
    vuint32_t TXOCTS14:1;              /* Number of transmit octets */
    vuint32_t TXOCTS13:1;              /* Number of transmit octets */
    vuint32_t TXOCTS12:1;              /* Number of transmit octets */
    vuint32_t TXOCTS11:1;              /* Number of transmit octets */
    vuint32_t TXOCTS10:1;              /* Number of transmit octets */
    vuint32_t TXOCTS9:1;               /* Number of transmit octets */
    vuint32_t TXOCTS8:1;               /* Number of transmit octets */
    vuint32_t TXOCTS7:1;               /* Number of transmit octets */
    vuint32_t TXOCTS6:1;               /* Number of transmit octets */
    vuint32_t TXOCTS5:1;               /* Number of transmit octets */
    vuint32_t TXOCTS4:1;               /* Number of transmit octets */
    vuint32_t TXOCTS3:1;               /* Number of transmit octets */
    vuint32_t TXOCTS2:1;               /* Number of transmit octets */
    vuint32_t TXOCTS1:1;               /* Number of transmit octets */
    vuint32_t TXOCTS0:1;               /* Number of transmit octets */
  } B;
} ENET_RMON_T_OCTETS_tag;

typedef union ENET_IEEE_T_DROP_union_tag { /* IEEE_T_DROP Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_0:32;            /* This read-only field always has the value 0. */
  } B;
} ENET_IEEE_T_DROP_tag;

typedef union ENET_IEEE_T_FRAME_OK_union_tag { /* Frames Transmitted OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT14:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT13:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT12:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT11:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT10:1;               /* Number of frames transmitted OK */
    vuint32_t COUNT9:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT8:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT7:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT6:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT5:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT4:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT3:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT2:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT1:1;                /* Number of frames transmitted OK */
    vuint32_t COUNT0:1;                /* Number of frames transmitted OK */
  } B;
} ENET_IEEE_T_FRAME_OK_tag;

typedef union ENET_IEEE_T_1COL_union_tag { /* Frames Transmitted with Single Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with one collision */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with one collision */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with one collision */
  } B;
} ENET_IEEE_T_1COL_tag;

typedef union ENET_IEEE_T_MCOL_union_tag { /* Frames Transmitted with Multiple Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with multiple collisions */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with multiple collisions */
  } B;
} ENET_IEEE_T_MCOL_tag;

typedef union ENET_IEEE_T_DEF_union_tag { /* Frames Transmitted after Deferral Delay Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with deferral delay */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with deferral delay */
  } B;
} ENET_IEEE_T_DEF_tag;

typedef union ENET_IEEE_T_LCOL_union_tag { /* Frames Transmitted with Late Collision Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with late collision */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with late collision */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with late collision */
  } B;
} ENET_IEEE_T_LCOL_tag;

typedef union ENET_IEEE_T_EXCOL_union_tag { /* Frames Transmitted with Excessive Collisions Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with excessive collisions */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with excessive collisions */
  } B;
} ENET_IEEE_T_EXCOL_tag;

typedef union ENET_IEEE_T_MACERR_union_tag { /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with transmit FIFO underrun */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with transmit FIFO underrun */
  } B;
} ENET_IEEE_T_MACERR_tag;

typedef union ENET_IEEE_T_CSERR_union_tag { /* Frames Transmitted with Carrier Sense Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with carrier sense error */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with carrier sense error */
  } B;
} ENET_IEEE_T_CSERR_tag;

typedef union ENET_IEEE_T_SQE_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames transmitted with SQE error */
    vuint32_t COUNT14:1;               /* Number of frames transmitted with SQE error */
    vuint32_t COUNT13:1;               /* Number of frames transmitted with SQE error */
    vuint32_t COUNT12:1;               /* Number of frames transmitted with SQE error */
    vuint32_t COUNT11:1;               /* Number of frames transmitted with SQE error */
    vuint32_t COUNT10:1;               /* Number of frames transmitted with SQE error */
    vuint32_t COUNT9:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT8:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT7:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT6:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT5:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT4:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT3:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT2:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT1:1;                /* Number of frames transmitted with SQE error */
    vuint32_t COUNT0:1;                /* Number of frames transmitted with SQE error */
  } B;
} ENET_IEEE_T_SQE_tag;

typedef union ENET_IEEE_T_FDXFC_union_tag { /* Flow Control Pause Frames Transmitted Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT14:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT13:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT12:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT11:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT10:1;               /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT9:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT8:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT7:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT6:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT5:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT4:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT3:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT2:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT1:1;                /* Number of flow-control pause frames transmitted */
    vuint32_t COUNT0:1;                /* Number of flow-control pause frames transmitted */
  } B;
} ENET_IEEE_T_FDXFC_tag;

typedef union ENET_IEEE_T_OCTETS_OK_union_tag { /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT31:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT30:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT29:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT28:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT27:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT26:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT25:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT24:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT23:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT22:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT21:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT20:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT19:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT18:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT17:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT16:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT15:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT14:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT13:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT12:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT11:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT10:1;               /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT9:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT8:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT7:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT6:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT5:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT4:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT3:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT2:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT1:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
    vuint32_t COUNT0:1;                /* Octet count for frames transmitted without error Counts total octets (includes header and FCS fields). */
  } B;
} ENET_IEEE_T_OCTETS_OK_tag;

typedef union ENET_RMON_R_PACKETS_union_tag { /* Rx Packet Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of packets received */
    vuint32_t COUNT14:1;               /* Number of packets received */
    vuint32_t COUNT13:1;               /* Number of packets received */
    vuint32_t COUNT12:1;               /* Number of packets received */
    vuint32_t COUNT11:1;               /* Number of packets received */
    vuint32_t COUNT10:1;               /* Number of packets received */
    vuint32_t COUNT9:1;                /* Number of packets received */
    vuint32_t COUNT8:1;                /* Number of packets received */
    vuint32_t COUNT7:1;                /* Number of packets received */
    vuint32_t COUNT6:1;                /* Number of packets received */
    vuint32_t COUNT5:1;                /* Number of packets received */
    vuint32_t COUNT4:1;                /* Number of packets received */
    vuint32_t COUNT3:1;                /* Number of packets received */
    vuint32_t COUNT2:1;                /* Number of packets received */
    vuint32_t COUNT1:1;                /* Number of packets received */
    vuint32_t COUNT0:1;                /* Number of packets received */
  } B;
} ENET_RMON_R_PACKETS_tag;

typedef union ENET_RMON_R_BC_PKT_union_tag { /* Rx Broadcast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT14:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT13:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT12:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT11:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT10:1;               /* Number of receive broadcast packets */
    vuint32_t COUNT9:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT8:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT7:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT6:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT5:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT4:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT3:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT2:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT1:1;                /* Number of receive broadcast packets */
    vuint32_t COUNT0:1;                /* Number of receive broadcast packets */
  } B;
} ENET_RMON_R_BC_PKT_tag;

typedef union ENET_RMON_R_MC_PKT_union_tag { /* Rx Multicast Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive multicast packets */
    vuint32_t COUNT14:1;               /* Number of receive multicast packets */
    vuint32_t COUNT13:1;               /* Number of receive multicast packets */
    vuint32_t COUNT12:1;               /* Number of receive multicast packets */
    vuint32_t COUNT11:1;               /* Number of receive multicast packets */
    vuint32_t COUNT10:1;               /* Number of receive multicast packets */
    vuint32_t COUNT9:1;                /* Number of receive multicast packets */
    vuint32_t COUNT8:1;                /* Number of receive multicast packets */
    vuint32_t COUNT7:1;                /* Number of receive multicast packets */
    vuint32_t COUNT6:1;                /* Number of receive multicast packets */
    vuint32_t COUNT5:1;                /* Number of receive multicast packets */
    vuint32_t COUNT4:1;                /* Number of receive multicast packets */
    vuint32_t COUNT3:1;                /* Number of receive multicast packets */
    vuint32_t COUNT2:1;                /* Number of receive multicast packets */
    vuint32_t COUNT1:1;                /* Number of receive multicast packets */
    vuint32_t COUNT0:1;                /* Number of receive multicast packets */
  } B;
} ENET_RMON_R_MC_PKT_tag;

typedef union ENET_RMON_R_CRC_ALIGN_union_tag { /* Rx Packets with CRC/Align Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT14:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT13:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT12:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT11:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT10:1;               /* Number of receive packets with CRC or align error */
    vuint32_t COUNT9:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT8:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT7:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT6:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT5:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT4:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT3:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT2:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT1:1;                /* Number of receive packets with CRC or align error */
    vuint32_t COUNT0:1;                /* Number of receive packets with CRC or align error */
  } B;
} ENET_RMON_R_CRC_ALIGN_tag;

typedef union ENET_RMON_R_UNDERSIZE_union_tag { /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets with less than 64 bytes and good CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets with less than 64 bytes and good CRC */
  } B;
} ENET_RMON_R_UNDERSIZE_tag;

typedef union ENET_RMON_R_OVERSIZE_union_tag { /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets greater than MAX_FL and good CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets greater than MAX_FL and good CRC */
  } B;
} ENET_RMON_R_OVERSIZE_tag;

typedef union ENET_RMON_R_FRAG_union_tag { /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets with less than 64 bytes and bad CRC */
  } B;
} ENET_RMON_R_FRAG_tag;

typedef union ENET_RMON_R_JAB_union_tag { /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT14:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT13:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT12:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT11:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT10:1;               /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT9:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT8:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT7:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT6:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT5:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT4:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT3:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT2:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT1:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
    vuint32_t COUNT0:1;                /* Number of receive packets greater than MAX_FL and bad CRC */
  } B;
} ENET_RMON_R_JAB_tag;

typedef union ENET_RMON_R_RESVD_0_union_tag { /* Reserved Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t _unused_0:16;
  } B;
} ENET_RMON_R_RESVD_0_tag;

typedef union ENET_RMON_R_P64_union_tag { /* Rx 64-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT14:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT13:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT12:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT11:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT10:1;               /* Number of 64-byte receive packets */
    vuint32_t COUNT9:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT8:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT7:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT6:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT5:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT4:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT3:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT2:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT1:1;                /* Number of 64-byte receive packets */
    vuint32_t COUNT0:1;                /* Number of 64-byte receive packets */
  } B;
} ENET_RMON_R_P64_tag;

typedef union ENET_RMON_R_P65TO127_union_tag { /* Rx 65- to 127-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 65- to 127-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 65- to 127-byte recieve packets */
  } B;
} ENET_RMON_R_P65TO127_tag;

typedef union ENET_RMON_R_P128TO255_union_tag { /* Rx 128- to 255-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 128- to 255-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 128- to 255-byte recieve packets */
  } B;
} ENET_RMON_R_P128TO255_tag;

typedef union ENET_RMON_R_P256TO511_union_tag { /* Rx 256- to 511-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 256- to 511-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 256- to 511-byte recieve packets */
  } B;
} ENET_RMON_R_P256TO511_tag;

typedef union ENET_RMON_R_P512TO1023_union_tag { /* Rx 512- to 1023-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 512- to 1023-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 512- to 1023-byte recieve packets */
  } B;
} ENET_RMON_R_P512TO1023_tag;

typedef union ENET_RMON_R_P1024TO2047_union_tag { /* Rx 1024- to 2047-Byte Packets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of 1024- to 2047-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of 1024- to 2047-byte recieve packets */
  } B;
} ENET_RMON_R_P1024TO2047_tag;

typedef union ENET_RMON_R_P_GTE2048_union_tag { /* Rx Packets Greater than 2048 Bytes Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT14:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT13:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT12:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT11:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT10:1;               /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT9:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT8:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT7:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT6:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT5:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT4:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT3:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT2:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT1:1;                /* Number of greater-than-2048-byte recieve packets */
    vuint32_t COUNT0:1;                /* Number of greater-than-2048-byte recieve packets */
  } B;
} ENET_RMON_R_P_GTE2048_tag;

typedef union ENET_RMON_R_OCTETS_union_tag { /* Rx Octets Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT31:1;               /* Number of receive octets */
    vuint32_t COUNT30:1;               /* Number of receive octets */
    vuint32_t COUNT29:1;               /* Number of receive octets */
    vuint32_t COUNT28:1;               /* Number of receive octets */
    vuint32_t COUNT27:1;               /* Number of receive octets */
    vuint32_t COUNT26:1;               /* Number of receive octets */
    vuint32_t COUNT25:1;               /* Number of receive octets */
    vuint32_t COUNT24:1;               /* Number of receive octets */
    vuint32_t COUNT23:1;               /* Number of receive octets */
    vuint32_t COUNT22:1;               /* Number of receive octets */
    vuint32_t COUNT21:1;               /* Number of receive octets */
    vuint32_t COUNT20:1;               /* Number of receive octets */
    vuint32_t COUNT19:1;               /* Number of receive octets */
    vuint32_t COUNT18:1;               /* Number of receive octets */
    vuint32_t COUNT17:1;               /* Number of receive octets */
    vuint32_t COUNT16:1;               /* Number of receive octets */
    vuint32_t COUNT15:1;               /* Number of receive octets */
    vuint32_t COUNT14:1;               /* Number of receive octets */
    vuint32_t COUNT13:1;               /* Number of receive octets */
    vuint32_t COUNT12:1;               /* Number of receive octets */
    vuint32_t COUNT11:1;               /* Number of receive octets */
    vuint32_t COUNT10:1;               /* Number of receive octets */
    vuint32_t COUNT9:1;                /* Number of receive octets */
    vuint32_t COUNT8:1;                /* Number of receive octets */
    vuint32_t COUNT7:1;                /* Number of receive octets */
    vuint32_t COUNT6:1;                /* Number of receive octets */
    vuint32_t COUNT5:1;                /* Number of receive octets */
    vuint32_t COUNT4:1;                /* Number of receive octets */
    vuint32_t COUNT3:1;                /* Number of receive octets */
    vuint32_t COUNT2:1;                /* Number of receive octets */
    vuint32_t COUNT1:1;                /* Number of receive octets */
    vuint32_t COUNT0:1;                /* Number of receive octets */
  } B;
} ENET_RMON_R_OCTETS_tag;

typedef union ENET_IEEE_R_DROP_union_tag { /* Frames not Counted Correctly Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Frame count */
    vuint32_t COUNT14:1;               /* Frame count */
    vuint32_t COUNT13:1;               /* Frame count */
    vuint32_t COUNT12:1;               /* Frame count */
    vuint32_t COUNT11:1;               /* Frame count */
    vuint32_t COUNT10:1;               /* Frame count */
    vuint32_t COUNT9:1;                /* Frame count */
    vuint32_t COUNT8:1;                /* Frame count */
    vuint32_t COUNT7:1;                /* Frame count */
    vuint32_t COUNT6:1;                /* Frame count */
    vuint32_t COUNT5:1;                /* Frame count */
    vuint32_t COUNT4:1;                /* Frame count */
    vuint32_t COUNT3:1;                /* Frame count */
    vuint32_t COUNT2:1;                /* Frame count */
    vuint32_t COUNT1:1;                /* Frame count */
    vuint32_t COUNT0:1;                /* Frame count */
  } B;
} ENET_IEEE_R_DROP_tag;

typedef union ENET_IEEE_R_FRAME_OK_union_tag { /* Frames Received OK Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames received OK */
    vuint32_t COUNT14:1;               /* Number of frames received OK */
    vuint32_t COUNT13:1;               /* Number of frames received OK */
    vuint32_t COUNT12:1;               /* Number of frames received OK */
    vuint32_t COUNT11:1;               /* Number of frames received OK */
    vuint32_t COUNT10:1;               /* Number of frames received OK */
    vuint32_t COUNT9:1;                /* Number of frames received OK */
    vuint32_t COUNT8:1;                /* Number of frames received OK */
    vuint32_t COUNT7:1;                /* Number of frames received OK */
    vuint32_t COUNT6:1;                /* Number of frames received OK */
    vuint32_t COUNT5:1;                /* Number of frames received OK */
    vuint32_t COUNT4:1;                /* Number of frames received OK */
    vuint32_t COUNT3:1;                /* Number of frames received OK */
    vuint32_t COUNT2:1;                /* Number of frames received OK */
    vuint32_t COUNT1:1;                /* Number of frames received OK */
    vuint32_t COUNT0:1;                /* Number of frames received OK */
  } B;
} ENET_IEEE_R_FRAME_OK_tag;

typedef union ENET_IEEE_R_CRC_union_tag { /* Frames Received with CRC Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT14:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT13:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT12:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT11:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT10:1;               /* Number of frames received with CRC error */
    vuint32_t COUNT9:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT8:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT7:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT6:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT5:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT4:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT3:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT2:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT1:1;                /* Number of frames received with CRC error */
    vuint32_t COUNT0:1;                /* Number of frames received with CRC error */
  } B;
} ENET_IEEE_R_CRC_tag;

typedef union ENET_IEEE_R_ALIGN_union_tag { /* Frames Received with Alignment Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT14:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT13:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT12:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT11:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT10:1;               /* Number of frames received with alignment error */
    vuint32_t COUNT9:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT8:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT7:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT6:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT5:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT4:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT3:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT2:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT1:1;                /* Number of frames received with alignment error */
    vuint32_t COUNT0:1;                /* Number of frames received with alignment error */
  } B;
} ENET_IEEE_R_ALIGN_tag;

typedef union ENET_IEEE_R_MACERR_union_tag { /* Receive FIFO Overflow Count Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT14:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT13:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT12:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT11:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT10:1;               /* Receive FIFO overflow count */
    vuint32_t COUNT9:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT8:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT7:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT6:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT5:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT4:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT3:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT2:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT1:1;                /* Receive FIFO overflow count */
    vuint32_t COUNT0:1;                /* Receive FIFO overflow count */
  } B;
} ENET_IEEE_R_MACERR_tag;

typedef union ENET_IEEE_R_FDXFC_union_tag { /* Flow Control Pause Frames Received Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t COUNT15:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT14:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT13:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT12:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT11:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT10:1;               /* Number of flow-control pause frames received */
    vuint32_t COUNT9:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT8:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT7:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT6:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT5:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT4:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT3:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT2:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT1:1;                /* Number of flow-control pause frames received */
    vuint32_t COUNT0:1;                /* Number of flow-control pause frames received */
  } B;
} ENET_IEEE_R_FDXFC_tag;

typedef union ENET_IEEE_R_OCTETS_OK_union_tag { /* Octet Count for Frames Received without Error Statistic Register */
  vuint32_t R;
  struct {
    vuint32_t COUNT31:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT30:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT29:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT28:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT27:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT26:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT25:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT24:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT23:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT22:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT21:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT20:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT19:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT18:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT17:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT16:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT15:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT14:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT13:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT12:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT11:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT10:1;               /* Number of octets for frames received without error */
    vuint32_t COUNT9:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT8:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT7:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT6:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT5:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT4:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT3:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT2:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT1:1;                /* Number of octets for frames received without error */
    vuint32_t COUNT0:1;                /* Number of octets for frames received without error */
  } B;
} ENET_IEEE_R_OCTETS_OK_tag;

typedef union ENET_ATCR_union_tag {    /* Adjustable Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t SLAVE:1;                 /* Enable Timer Slave Mode */
    vuint32_t _unused_12:1;
    vuint32_t CAPTURE:1;               /* Capture Timer Value */
    vuint32_t _unused_10:1;
    vuint32_t RESTART:1;               /* Reset Timer */
    vuint32_t _unused_8:1;
    vuint32_t PINPER:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t PEREN:1;                 /* Enable Periodical Event */
    vuint32_t OFFRST:1;                /* Reset Timer On Offset Event */
    vuint32_t OFFEN:1;                 /* Enable One-Shot Offset Event */
    vuint32_t _unused_1:1;
    vuint32_t EN:1;                    /* Enable Timer */
  } B;
} ENET_ATCR_tag;

typedef union ENET_ATVR_union_tag {    /* Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t ATIME:32;
  } B;
} ENET_ATVR_tag;

typedef union ENET_ATOFF_union_tag {   /* Timer Offset Register */
  vuint32_t R;
  struct {
    vuint32_t OFFSET:32;
  } B;
} ENET_ATOFF_tag;

typedef union ENET_ATPER_union_tag {   /* Timer Period Register */
  vuint32_t R;
  struct {
    vuint32_t PERIOD:32;
  } B;
} ENET_ATPER_tag;

typedef union ENET_ATCOR_union_tag {   /* Timer Correction Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t COR:31;                  /* Correction Counter Wrap-Around Value */
  } B;
} ENET_ATCOR_tag;

typedef union ENET_ATINC_union_tag {   /* Time-Stamping Clock Period Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t INC_CORR:7;              /* Correction Increment Value */
    vuint32_t _unused_7:1;
    vuint32_t INC:7;                   /* Clock Period Of The Timestamping Clock (ts_clk) In Nanoseconds */
  } B;
} ENET_ATINC_tag;

typedef union ENET_ATSTMP_union_tag {  /* Timestamp of Last Transmitted Frame */
  vuint32_t R;
  struct {
    vuint32_t TIMESTAMP:32;
  } B;
} ENET_ATSTMP_tag;

typedef union ENET_TGSR_union_tag {    /* Timer Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t TF3:1;                   /* Copy Of Timer Flag For Channel 3 */
    vuint32_t TF2:1;                   /* Copy Of Timer Flag For Channel 2 */
    vuint32_t TF1:1;                   /* Copy Of Timer Flag For Channel 1 */
    vuint32_t TF0:1;                   /* Copy Of Timer Flag For Channel 0 */
  } B;
} ENET_TGSR_tag;

typedef union ENET_TIMER_TCSR_union_tag { /* Timer Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TF:1;                    /* Timer Flag */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TMODE:4;                 /* Timer Mode */
    vuint32_t _unused_1:1;
    vuint32_t TDRE:1;                  /* Timer DMA Request Enable */
  } B;
} ENET_TIMER_TCSR_tag;

typedef union ENET_TIMER_TCCR_union_tag { /* Timer Compare Capture Register */
  vuint32_t R;
  struct {
    vuint32_t TCC:32;                  /* Timer Capture Compare */
  } B;
} ENET_TIMER_TCCR_tag;

typedef struct ENET_TIMER_struct_tag {
  ENET_TIMER_TCSR_tag TCSR;            /* Timer Control Status Register */
  ENET_TIMER_TCCR_tag TCCR;            /* Timer Compare Capture Register */
} ENET_TIMER_tag;

struct ENET_tag {
  uint8_t ENET_reserved0[4];
  ENET_EIR_tag EIR;                    /* Interrupt Event Register */
  ENET_EIMR_tag EIMR;                  /* Interrupt Mask Register */
  uint8_t ENET_reserved1[4];
  ENET_RDAR_tag RDAR;                  /* Receive Descriptor Active Register */
  ENET_TDAR_tag TDAR;                  /* Transmit Descriptor Active Register */
  uint8_t ENET_reserved2[12];
  ENET_ECR_tag ECR;                    /* Ethernet Control Register */
  uint8_t ENET_reserved3[24];
  ENET_MMFR_tag MMFR;                  /* MII Management Frame Register */
  ENET_MSCR_tag MSCR;                  /* MII Speed Control Register */
  uint8_t ENET_reserved4[28];
  ENET_MIBC_tag MIBC;                  /* MIB Control Register */
  uint8_t ENET_reserved5[28];
  ENET_RCR_tag RCR;                    /* Receive Control Register */
  uint8_t ENET_reserved6[60];
  ENET_TCR_tag TCR;                    /* Transmit Control Register */
  uint8_t ENET_reserved7[28];
  ENET_PALR_tag PALR;                  /* Physical Address Lower Register */
  ENET_PAUR_tag PAUR;                  /* Physical Address Upper Register */
  ENET_OPD_tag OPD;                    /* Opcode/Pause Duration Register */
  uint8_t ENET_reserved8[40];
  ENET_IAUR_tag IAUR;                  /* Descriptor Individual Upper Address Register */
  ENET_IALR_tag IALR;                  /* Descriptor Individual Lower Address Register */
  ENET_GAUR_tag GAUR;                  /* Descriptor Group Upper Address Register */
  ENET_GALR_tag GALR;                  /* Descriptor Group Lower Address Register */
  uint8_t ENET_reserved9[28];
  ENET_TFWR_tag TFWR;                  /* Transmit FIFO Watermark Register */
  uint8_t ENET_reserved10[56];
  ENET_RDSR_tag RDSR;                  /* Receive Descriptor Ring Start Register */
  ENET_TDSR_tag TDSR;                  /* Transmit Buffer Descriptor Ring Start Register */
  ENET_MRBR_tag MRBR;                  /* Maximum Receive Buffer Size Register */
  uint8_t ENET_reserved11[4];
  ENET_RSFL_tag RSFL;                  /* Receive FIFO Section Full Threshold */
  ENET_RSEM_tag RSEM;                  /* Receive FIFO Section Empty Threshold */
  ENET_RAEM_tag RAEM;                  /* Receive FIFO Almost Empty Threshold */
  ENET_RAFL_tag RAFL;                  /* Receive FIFO Almost Full Threshold */
  ENET_TSEM_tag TSEM;                  /* Transmit FIFO Section Empty Threshold */
  ENET_TAEM_tag TAEM;                  /* Transmit FIFO Almost Empty Threshold */
  ENET_TAFL_tag TAFL;                  /* Transmit FIFO Almost Full Threshold */
  ENET_TIPG_tag TIPG;                  /* Transmit Inter-Packet Gap */
  ENET_FTRL_tag FTRL;                  /* Frame Truncation Length */
  uint8_t ENET_reserved12[12];
  ENET_TACC_tag TACC;                  /* Transmit Accelerator Function Configuration */
  ENET_RACC_tag RACC;                  /* Receive Accelerator Function Configuration */
  uint8_t ENET_reserved13[56];
  ENET_RMON_T_DROP_tag RMON_T_DROP;    /* Reserved Statistic Register */
  ENET_RMON_T_PACKETS_tag RMON_T_PACKETS; /* Tx Packet Count Statistic Register */
  ENET_RMON_T_BC_PKT_tag RMON_T_BC_PKT; /* Tx Broadcast Packets Statistic Register */
  ENET_RMON_T_MC_PKT_tag RMON_T_MC_PKT; /* Tx Multicast Packets Statistic Register */
  ENET_RMON_T_CRC_ALIGN_tag RMON_T_CRC_ALIGN; /* Tx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_T_UNDERSIZE_tag RMON_T_UNDERSIZE; /* Tx Packets Less Than Bytes and Good CRC Statistic Register */
  ENET_RMON_T_OVERSIZE_tag RMON_T_OVERSIZE; /* Tx Packets GT MAX_FL bytes and Good CRC Statistic Register */
  ENET_RMON_T_FRAG_tag RMON_T_FRAG;    /* Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_T_JAB_tag RMON_T_JAB;      /* Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register */
  ENET_RMON_T_COL_tag RMON_T_COL;      /* Tx Collision Count Statistic Register */
  ENET_RMON_T_P64_tag RMON_T_P64;      /* Tx 64-Byte Packets Statistic Register */
  ENET_RMON_T_P65TO127_tag RMON_T_P65TO127; /* Tx 65- to 127-byte Packets Statistic Register */
  ENET_RMON_T_P128TO255_tag RMON_T_P128TO255; /* Tx 128- to 255-byte Packets Statistic Register */
  ENET_RMON_T_P256TO511_tag RMON_T_P256TO511; /* Tx 256- to 511-byte Packets Statistic Register */
  ENET_RMON_T_P512TO1023_tag RMON_T_P512TO1023; /* Tx 512- to 1023-byte Packets Statistic Register */
  ENET_RMON_T_P1024TO2047_tag RMON_T_P1024TO2047; /* Tx 1024- to 2047-byte Packets Statistic Register */
  ENET_RMON_T_P_GTE2048_tag RMON_T_P_GTE2048; /* Tx Packets Greater Than 2048 Bytes Statistic Register */
  ENET_RMON_T_OCTETS_tag RMON_T_OCTETS; /* Tx Octets Statistic Register */
  ENET_IEEE_T_DROP_tag IEEE_T_DROP;    /* IEEE_T_DROP Reserved Statistic Register */
  ENET_IEEE_T_FRAME_OK_tag IEEE_T_FRAME_OK; /* Frames Transmitted OK Statistic Register */
  ENET_IEEE_T_1COL_tag IEEE_T_1COL;    /* Frames Transmitted with Single Collision Statistic Register */
  ENET_IEEE_T_MCOL_tag IEEE_T_MCOL;    /* Frames Transmitted with Multiple Collisions Statistic Register */
  ENET_IEEE_T_DEF_tag IEEE_T_DEF;      /* Frames Transmitted after Deferral Delay Statistic Register */
  ENET_IEEE_T_LCOL_tag IEEE_T_LCOL;    /* Frames Transmitted with Late Collision Statistic Register */
  ENET_IEEE_T_EXCOL_tag IEEE_T_EXCOL;  /* Frames Transmitted with Excessive Collisions Statistic Register */
  ENET_IEEE_T_MACERR_tag IEEE_T_MACERR; /* Frames Transmitted with Tx FIFO Underrun Statistic Register */
  ENET_IEEE_T_CSERR_tag IEEE_T_CSERR;  /* Frames Transmitted with Carrier Sense Error Statistic Register */
  ENET_IEEE_T_SQE_tag IEEE_T_SQE;
  ENET_IEEE_T_FDXFC_tag IEEE_T_FDXFC;  /* Flow Control Pause Frames Transmitted Statistic Register */
  ENET_IEEE_T_OCTETS_OK_tag IEEE_T_OCTETS_OK; /* Octet Count for Frames Transmitted w/o Error Statistic Register */
  uint8_t ENET_reserved14[12];
  ENET_RMON_R_PACKETS_tag RMON_R_PACKETS; /* Rx Packet Count Statistic Register */
  ENET_RMON_R_BC_PKT_tag RMON_R_BC_PKT; /* Rx Broadcast Packets Statistic Register */
  ENET_RMON_R_MC_PKT_tag RMON_R_MC_PKT; /* Rx Multicast Packets Statistic Register */
  ENET_RMON_R_CRC_ALIGN_tag RMON_R_CRC_ALIGN; /* Rx Packets with CRC/Align Error Statistic Register */
  ENET_RMON_R_UNDERSIZE_tag RMON_R_UNDERSIZE; /* Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register */
  ENET_RMON_R_OVERSIZE_tag RMON_R_OVERSIZE; /* Rx Packets Greater Than MAX_FL and Good CRC Statistic Register */
  ENET_RMON_R_FRAG_tag RMON_R_FRAG;    /* Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_JAB_tag RMON_R_JAB;      /* Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register */
  ENET_RMON_R_RESVD_0_tag RMON_R_RESVD_0; /* Reserved Statistic Register */
  ENET_RMON_R_P64_tag RMON_R_P64;      /* Rx 64-Byte Packets Statistic Register */
  ENET_RMON_R_P65TO127_tag RMON_R_P65TO127; /* Rx 65- to 127-Byte Packets Statistic Register */
  ENET_RMON_R_P128TO255_tag RMON_R_P128TO255; /* Rx 128- to 255-Byte Packets Statistic Register */
  ENET_RMON_R_P256TO511_tag RMON_R_P256TO511; /* Rx 256- to 511-Byte Packets Statistic Register */
  ENET_RMON_R_P512TO1023_tag RMON_R_P512TO1023; /* Rx 512- to 1023-Byte Packets Statistic Register */
  ENET_RMON_R_P1024TO2047_tag RMON_R_P1024TO2047; /* Rx 1024- to 2047-Byte Packets Statistic Register */
  ENET_RMON_R_P_GTE2048_tag RMON_R_P_GTE2048; /* Rx Packets Greater than 2048 Bytes Statistic Register */
  ENET_RMON_R_OCTETS_tag RMON_R_OCTETS; /* Rx Octets Statistic Register */
  ENET_IEEE_R_DROP_tag IEEE_R_DROP;    /* Frames not Counted Correctly Statistic Register */
  ENET_IEEE_R_FRAME_OK_tag IEEE_R_FRAME_OK; /* Frames Received OK Statistic Register */
  ENET_IEEE_R_CRC_tag IEEE_R_CRC;      /* Frames Received with CRC Error Statistic Register */
  ENET_IEEE_R_ALIGN_tag IEEE_R_ALIGN;  /* Frames Received with Alignment Error Statistic Register */
  ENET_IEEE_R_MACERR_tag IEEE_R_MACERR; /* Receive FIFO Overflow Count Statistic Register */
  ENET_IEEE_R_FDXFC_tag IEEE_R_FDXFC;  /* Flow Control Pause Frames Received Statistic Register */
  ENET_IEEE_R_OCTETS_OK_tag IEEE_R_OCTETS_OK; /* Octet Count for Frames Received without Error Statistic Register */
  uint8_t ENET_reserved15[284];
  ENET_ATCR_tag ATCR;                  /* Adjustable Timer Control Register */
  ENET_ATVR_tag ATVR;                  /* Timer Value Register */
  ENET_ATOFF_tag ATOFF;                /* Timer Offset Register */
  ENET_ATPER_tag ATPER;                /* Timer Period Register */
  ENET_ATCOR_tag ATCOR;                /* Timer Correction Register */
  ENET_ATINC_tag ATINC;                /* Time-Stamping Clock Period Register */
  ENET_ATSTMP_tag ATSTMP;              /* Timestamp of Last Transmitted Frame */
  uint8_t ENET_reserved16[488];
  ENET_TGSR_tag TGSR;                  /* Timer Global Status Register */
  ENET_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: ETIMER =============================
   ============================================================================ */

typedef union ETIMER_CH_COMP1_union_tag { /* Channel n Compare Register 1 */
  vuint16_t R;
  struct {
    vuint16_t COMP1:16;
  } B;
} ETIMER_CH_COMP1_tag;

typedef union ETIMER_CH_COMP2_union_tag { /* Channel n Compare Register 2 */
  vuint16_t R;
  struct {
    vuint16_t COMP2:16;
  } B;
} ETIMER_CH_COMP2_tag;

typedef union ETIMER_CH_CAPT1_union_tag { /* Channel n Capture Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CAPT1:16;
  } B;
} ETIMER_CH_CAPT1_tag;

typedef union ETIMER_CH_CAPT2_union_tag { /* Channel n Capture Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CAPT2:16;
  } B;
} ETIMER_CH_CAPT2_tag;

typedef union ETIMER_CH_LOAD_union_tag { /* Channel n Load Register */
  vuint16_t R;
  struct {
    vuint16_t LOAD:16;
  } B;
} ETIMER_CH_LOAD_tag;

typedef union ETIMER_CH_HOLD_union_tag { /* Channel n Hold Register */
  vuint16_t R;
  struct {
    vuint16_t HOLD:16;
  } B;
} ETIMER_CH_HOLD_tag;

typedef union ETIMER_CH_CNTR_union_tag { /* Channel n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNTR:16;
  } B;
} ETIMER_CH_CNTR_tag;

typedef union ETIMER_CH_CTRL1_union_tag { /* Channel n Control Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CNTMODE:3;               /* Count mode */
    vuint16_t PRISRC:5;                /* Primary Count Source */
    vuint16_t ONCE:1;                  /* Count once */
    vuint16_t LENGTH:1;                /* Count Length */
    vuint16_t DIR:1;                   /* Count Direction */
    vuint16_t SECSRC:5;                /* Secondary Count Source */
  } B;
} ETIMER_CH_CTRL1_tag;

typedef union ETIMER_CH_CTRL2_union_tag { /* Channel n Control Register 2 */
  vuint16_t R;
  struct {
    vuint16_t OEN:1;                   /* Output Enable */
    vuint16_t RDNT:1;                  /* Redundant Channel Enable */
    vuint16_t INPUT:1;                 /* External input signal */
    vuint16_t VAL:1;                   /* Forced OFLAG Value */
    vuint16_t FORCE:1;                 /* Force the OFLAG output */
    vuint16_t COFRC:1;                 /* Co-channel OFLAG Force */
    vuint16_t COINIT:2;                /* Co-channel Initialization */
    vuint16_t SIPS:1;                  /* Secondary Source Input Polarity Select */
    vuint16_t PIPS:1;                  /* Primary Source Input Polarity Select */
    vuint16_t OPS:1;                   /* Output Polarity Select. */
    vuint16_t MSTR:1;                  /* Master Mode */
    vuint16_t OUTMODE:4;               /* Output Mode */
  } B;
} ETIMER_CH_CTRL2_tag;

typedef union ETIMER_CH_CTRL3_union_tag { /* Channel n Control Register 3 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t ROC:2;                   /* Reload on Capture */
    vuint16_t _unused_8:5;
    vuint16_t C2FCNT:3;                /* Capture 2 FIFO count */
    vuint16_t C1FCNT:3;                /* Capture 1 FIFO count */
    vuint16_t DBGEN:2;                 /* Debug Actions Enable */
  } B;
} ETIMER_CH_CTRL3_tag;

typedef union ETIMER_CH_STS_union_tag { /* Channel n Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t WDF:1;                   /* Watchdog Time-out Flag */
    vuint16_t RCF:1;                   /* Redundant Channel Flag */
    vuint16_t ICF2:1;                  /* Input Capture 2 Flag */
    vuint16_t ICF1:1;                  /* Input Capture 1 Flag */
    vuint16_t IEHF:1;                  /* Input Edge High Flag */
    vuint16_t IELF:1;                  /* Input Edge Low Flag */
    vuint16_t TOF:1;                   /* Timer Overflow Flag */
    vuint16_t TCF2:1;                  /* Timer Compare 2 Flag */
    vuint16_t TCF1:1;                  /* Timer Compare 1 Flag */
    vuint16_t TCF:1;
  } B;
} ETIMER_CH_STS_tag;

typedef union ETIMER_CH_INTDMA_union_tag { /* Channel n Interrupt and DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t ICF2DE:1;                /* Input Capture 2 Flag DMA Enable */
    vuint16_t ICF1DE:1;                /* Input Capture 1 Flag DMA Enable */
    vuint16_t CMPLD2DE:1;              /* Comparator Load Register 2 Flag DMA Enable */
    vuint16_t CMPLD1DE:1;              /* Comparator Load Register 1 Flag DMA Enable */
    vuint16_t _unused_10:2;
    vuint16_t WDFIE:1;                 /* Watchdog Flag Interrupt Enable */
    vuint16_t RCFIE:1;                 /* Redundant Channel Flag Interrupt Enable */
    vuint16_t ICF2IE:1;                /* Input Capture 2 Flag Interrupt Enable */
    vuint16_t ICF1IE:1;                /* Input Capture 1 Flag Interrupt Enable */
    vuint16_t IEHFIE:1;                /* Input Edge High Flag Interrupt Enable */
    vuint16_t IELFIE:1;                /* Input Edge Low Flag Interrupt Enable */
    vuint16_t TOFIE:1;                 /* Timer Overflow Flag Interrupt Enable */
    vuint16_t TCF2IE:1;                /* Timer Compare 2 Flag Interrupt Enable */
    vuint16_t TCF1IE:1;                /* Timer Compare 1 Flag Interrupt Enable */
    vuint16_t TCFIE:1;                 /* Timer Compare Flag Interrupt Enable */
  } B;
} ETIMER_CH_INTDMA_tag;

typedef union ETIMER_CH_CMPLD1_union_tag { /* Channel n Comparator Load Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CMPLD1:16;
  } B;
} ETIMER_CH_CMPLD1_tag;

typedef union ETIMER_CH_CMPLD2_union_tag { /* Channel n Comparator Load Register 2 */
  vuint16_t R;
  struct {
    vuint16_t CMPLD2:16;
  } B;
} ETIMER_CH_CMPLD2_tag;

typedef union ETIMER_CH_CCCTRL_union_tag { /* Channel n Compare and Capture Control Register */
  vuint16_t R;
  struct {
    vuint16_t CLC2:3;                  /* Compare Load Control 2 */
    vuint16_t CLC1:3;                  /* Compare Load Control 1 */
    vuint16_t CMPMODE:2;               /* Compare Mode */
    vuint16_t CPT2MODE:2;              /* Capture 2 Mode Control */
    vuint16_t CPT1MODE:2;              /* Capture 1 Mode Control */
    vuint16_t CFWM:2;                  /* Capture FIFO Water Mark */
    vuint16_t ONESHOT:1;               /* One Shot Capture Mode */
    vuint16_t ARM:1;                   /* Arm Capture */
  } B;
} ETIMER_CH_CCCTRL_tag;

typedef union ETIMER_CH_FILT_union_tag { /* Channel n Input Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FILT_CNT:3;              /* Input Filter Sample Count */
    vuint16_t FILT_PER:8;              /* Input Filter Sample Period */
  } B;
} ETIMER_CH_FILT_tag;

typedef struct ETIMER_CH_struct_tag {
  ETIMER_CH_COMP1_tag COMP1;           /* Channel n Compare Register 1 */
  ETIMER_CH_COMP2_tag COMP2;           /* Channel n Compare Register 2 */
  ETIMER_CH_CAPT1_tag CAPT1;           /* Channel n Capture Register 1 */
  ETIMER_CH_CAPT2_tag CAPT2;           /* Channel n Capture Register 2 */
  ETIMER_CH_LOAD_tag LOAD;             /* Channel n Load Register */
  ETIMER_CH_HOLD_tag HOLD;             /* Channel n Hold Register */
  ETIMER_CH_CNTR_tag CNTR;             /* Channel n Counter Register */
  ETIMER_CH_CTRL1_tag CTRL1;           /* Channel n Control Register 1 */
  ETIMER_CH_CTRL2_tag CTRL2;           /* Channel n Control Register 2 */
  ETIMER_CH_CTRL3_tag CTRL3;           /* Channel n Control Register 3 */
  ETIMER_CH_STS_tag STS;               /* Channel n Status Register */
  ETIMER_CH_INTDMA_tag INTDMA;         /* Channel n Interrupt and DMA Enable Register */
  ETIMER_CH_CMPLD1_tag CMPLD1;         /* Channel n Comparator Load Register 1 */
  ETIMER_CH_CMPLD2_tag CMPLD2;         /* Channel n Comparator Load Register 2 */
  ETIMER_CH_CCCTRL_tag CCCTRL;         /* Channel n Compare and Capture Control Register */
  ETIMER_CH_FILT_tag FILT;             /* Channel n Input Filter Register */
} ETIMER_CH_tag;

typedef union ETIMER_WDTOL_union_tag { /* Watchdog Time-out Low Word Register */
  vuint16_t R;
  struct {
    vuint16_t WDTOL:16;
  } B;
} ETIMER_WDTOL_tag;

typedef union ETIMER_WDTOH_union_tag { /* Watchdog Time-out High Word Register */
  vuint16_t R;
  struct {
    vuint16_t WDTOH:16;
  } B;
} ETIMER_WDTOH_tag;

typedef union ETIMER_ENBL_union_tag {  /* Channel Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t ENBL:8;                  /* Timer Channel Enable */
  } B;
} ETIMER_ENBL_tag;

typedef union ETIMER_DREQ0_union_tag { /* DMA Request 0 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ0_EN:1;
    vuint16_t _unused_5:10;
    vuint16_t DREQ0:5;
  } B;
} ETIMER_DREQ0_tag;

typedef union ETIMER_DREQ1_union_tag { /* DMA Request 1 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ1_EN:1;
    vuint16_t _unused_5:10;
    vuint16_t DREQ1:5;                 /* DMA Request Select */
  } B;
} ETIMER_DREQ1_tag;

typedef union ETIMER_DREQ2_union_tag { /* DMA Request 2 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ2_EN:1;
    vuint16_t _unused_5:10;
    vuint16_t DREQ2:5;                 /* DMA Request Select */
  } B;
} ETIMER_DREQ2_tag;

typedef union ETIMER_DREQ3_union_tag { /* DMA Request 3 Select Register */
  vuint16_t R;
  struct {
    vuint16_t DREQ3_EN:1;
    vuint16_t _unused_5:10;
    vuint16_t DREQ3:5;                 /* DMA Request Select */
  } B;
} ETIMER_DREQ3_tag;

struct ETIMER_tag {
  ETIMER_CH_tag CH[8];
  ETIMER_WDTOL_tag WDTOL;              /* Watchdog Time-out Low Word Register */
  ETIMER_WDTOH_tag WDTOH;              /* Watchdog Time-out High Word Register */
  uint8_t ETIMER_reserved0[8];
  ETIMER_ENBL_tag ENBL;                /* Channel Enable Register */
  uint8_t ETIMER_reserved1[2];
  ETIMER_DREQ0_tag DREQ0;              /* DMA Request 0 Select Register */
  ETIMER_DREQ1_tag DREQ1;              /* DMA Request 1 Select Register */
  ETIMER_DREQ2_tag DREQ2;              /* DMA Request 2 Select Register */
  ETIMER_DREQ3_tag DREQ3;              /* DMA Request 3 Select Register */
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

typedef union FCCU_CTRL_union_tag {    /* Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_29:2;
    vuint32_t _unused_10:19;
    vuint32_t DEBUG:1;                 /* Debug Mode Enable */
    vuint32_t _unused_8:1;
    vuint32_t OPS:2;
    vuint32_t _unused_5:1;
    vuint32_t OPR:5;
  } B;
} FCCU_CTRL_tag;

typedef union FCCU_CTRLK_union_tag {   /* Control Key */
  vuint32_t R;
  struct {
    vuint32_t CTRLK:32;
  } B;
} FCCU_CTRLK_tag;

typedef union FCCU_CFG_union_tag {     /* Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t FCCU_SET_AFTER_RESET:1;
    vuint32_t FCCU_SET_CLEAR:2;
    vuint32_t _unused_20:2;
    vuint32_t _unused_16:4;
    vuint32_t FOPE:1;                  /* Fault-Output (EOUT) Prescaler Extension */
    vuint32_t _unused_13:2;
    vuint32_t OD:1;
    vuint32_t _unused_11:1;
    vuint32_t SM:1;                    /* Fault-Output (EOUT) Switching Mode */
    vuint32_t PS:1;                    /* Fault-Output (EOUT) Polarity Selection */
    vuint32_t FOM:3;                   /* Fault-Output (EOUT) Mode */
    vuint32_t FOP:6;                   /* Fault-Output (EOUT) Prescaler */
  } B;
} FCCU_CFG_tag;

typedef union FCCU_NCF_CFG_union_tag { /* Noncritical Fault Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFC31:1;
    vuint32_t NCFC30:1;
    vuint32_t NCFC29:1;
    vuint32_t NCFC28:1;
    vuint32_t NCFC27:1;
    vuint32_t NCFC26:1;
    vuint32_t NCFC25:1;
    vuint32_t NCFC24:1;
    vuint32_t NCFC23:1;
    vuint32_t NCFC22:1;
    vuint32_t NCFC21:1;
    vuint32_t NCFC20:1;
    vuint32_t NCFC19:1;
    vuint32_t NCFC18:1;
    vuint32_t NCFC17:1;
    vuint32_t NCFC16:1;
    vuint32_t NCFC15:1;
    vuint32_t NCFC14:1;
    vuint32_t NCFC13:1;
    vuint32_t NCFC12:1;
    vuint32_t NCFC11:1;
    vuint32_t NCFC10:1;
    vuint32_t NCFC9:1;
    vuint32_t NCFC8:1;
    vuint32_t NCFC7:1;
    vuint32_t NCFC6:1;
    vuint32_t NCFC5:1;
    vuint32_t NCFC4:1;
    vuint32_t NCFC3:1;
    vuint32_t NCFC2:1;
    vuint32_t NCFC1:1;
    vuint32_t NCFC0:1;
  } B;
} FCCU_NCF_CFG_tag;

typedef union FCCU_NCFS_CFG_union_tag { /* Noncritical Fault State Configuration */
  vuint32_t R;
  struct {
    vuint32_t NCFSC31:1;
    vuint32_t NCFSC30:1;
    vuint32_t NCFSC29:1;
    vuint32_t NCFSC28:1;
    vuint32_t NCFSC27:1;
    vuint32_t NCFSC26:1;
    vuint32_t NCFSC25:1;
    vuint32_t NCFSC24:1;
    vuint32_t NCFSC23:1;
    vuint32_t NCFSC22:1;
    vuint32_t NCFSC21:1;
    vuint32_t NCFSC20:1;
    vuint32_t NCFSC19:1;
    vuint32_t NCFSC18:1;
    vuint32_t NCFSC17:1;
    vuint32_t NCFSC16:1;
    vuint32_t NCFSC15:1;
    vuint32_t NCFSC14:1;
    vuint32_t NCFSC13:1;
    vuint32_t NCFSC12:1;
    vuint32_t NCFSC11:1;
    vuint32_t NCFSC10:1;
    vuint32_t NCFSC9:1;
    vuint32_t NCFSC8:1;
    vuint32_t NCFSC7:1;
    vuint32_t NCFSC6:1;
    vuint32_t NCFSC5:1;
    vuint32_t NCFSC4:1;
    vuint32_t NCFSC3:1;
    vuint32_t NCFSC2:1;
    vuint32_t NCFSC1:1;
    vuint32_t NCFSC0:1;
  } B;
} FCCU_NCFS_CFG_tag;

typedef union FCCU_NCF_S_union_tag {   /* Noncritical Fault Status */
  vuint32_t R;
  struct {
    vuint32_t NCFS31:1;
    vuint32_t NCFS30:1;
    vuint32_t NCFS29:1;
    vuint32_t NCFS28:1;
    vuint32_t NCFS27:1;
    vuint32_t NCFS26:1;
    vuint32_t NCFS25:1;
    vuint32_t NCFS24:1;
    vuint32_t NCFS23:1;
    vuint32_t NCFS22:1;
    vuint32_t NCFS21:1;
    vuint32_t NCFS20:1;
    vuint32_t NCFS19:1;
    vuint32_t NCFS18:1;
    vuint32_t NCFS17:1;
    vuint32_t NCFS16:1;
    vuint32_t NCFS15:1;
    vuint32_t NCFS14:1;
    vuint32_t NCFS13:1;
    vuint32_t NCFS12:1;
    vuint32_t NCFS11:1;
    vuint32_t NCFS10:1;
    vuint32_t NCFS9:1;
    vuint32_t NCFS8:1;
    vuint32_t NCFS7:1;
    vuint32_t NCFS6:1;
    vuint32_t NCFS5:1;
    vuint32_t NCFS4:1;
    vuint32_t NCFS3:1;
    vuint32_t NCFS2:1;
    vuint32_t NCFS1:1;
    vuint32_t NCFS0:1;
  } B;
} FCCU_NCF_S_tag;

typedef union FCCU_NCFK_union_tag {    /* Noncritical Fault Key */
  vuint32_t R;
  struct {
    vuint32_t NCFK:32;
  } B;
} FCCU_NCFK_tag;

typedef union FCCU_NCF_E_union_tag {   /* Noncritical Fault Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFE31:1;
    vuint32_t NCFE30:1;
    vuint32_t NCFE29:1;
    vuint32_t NCFE28:1;
    vuint32_t NCFE27:1;
    vuint32_t NCFE26:1;
    vuint32_t NCFE25:1;
    vuint32_t NCFE24:1;
    vuint32_t NCFE23:1;
    vuint32_t NCFE22:1;
    vuint32_t NCFE21:1;
    vuint32_t NCFE20:1;
    vuint32_t NCFE19:1;
    vuint32_t NCFE18:1;
    vuint32_t NCFE17:1;
    vuint32_t NCFE16:1;
    vuint32_t NCFE15:1;
    vuint32_t NCFE14:1;
    vuint32_t NCFE13:1;
    vuint32_t NCFE12:1;
    vuint32_t NCFE11:1;
    vuint32_t NCFE10:1;
    vuint32_t NCFE9:1;
    vuint32_t NCFE8:1;
    vuint32_t NCFE7:1;
    vuint32_t NCFE6:1;
    vuint32_t NCFE5:1;
    vuint32_t NCFE4:1;
    vuint32_t NCFE3:1;
    vuint32_t NCFE2:1;
    vuint32_t NCFE1:1;
    vuint32_t NCFE0:1;
  } B;
} FCCU_NCF_E_tag;

typedef union FCCU_NCF_TOE_union_tag { /* Noncritical Fault Timeout Enable */
  vuint32_t R;
  struct {
    vuint32_t NCFTOE31:1;
    vuint32_t NCFTOE30:1;
    vuint32_t NCFTOE29:1;
    vuint32_t NCFTOE28:1;
    vuint32_t NCFTOE27:1;
    vuint32_t NCFTOE26:1;
    vuint32_t NCFTOE25:1;
    vuint32_t NCFTOE24:1;
    vuint32_t NCFTOE23:1;
    vuint32_t NCFTOE22:1;
    vuint32_t NCFTOE21:1;
    vuint32_t NCFTOE20:1;
    vuint32_t NCFTOE19:1;
    vuint32_t NCFTOE18:1;
    vuint32_t NCFTOE17:1;
    vuint32_t NCFTOE16:1;
    vuint32_t NCFTOE15:1;
    vuint32_t NCFTOE14:1;
    vuint32_t NCFTOE13:1;
    vuint32_t NCFTOE12:1;
    vuint32_t NCFTOE11:1;
    vuint32_t NCFTOE10:1;
    vuint32_t NCFTOE9:1;
    vuint32_t NCFTOE8:1;
    vuint32_t NCFTOE7:1;
    vuint32_t NCFTOE6:1;
    vuint32_t NCFTOE5:1;
    vuint32_t NCFTOE4:1;
    vuint32_t NCFTOE3:1;
    vuint32_t NCFTOE2:1;
    vuint32_t NCFTOE1:1;
    vuint32_t NCFTOE0:1;
  } B;
} FCCU_NCF_TOE_tag;

typedef union FCCU_NCF_TO_union_tag {  /* Noncritical Fault Timeout */
  vuint32_t R;
  struct {
    vuint32_t TO:32;
  } B;
} FCCU_NCF_TO_tag;

typedef union FCCU_CFG_TO_union_tag {  /* Configuration-State Timeout */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TO:3;
  } B;
} FCCU_CFG_TO_tag;

typedef union FCCU_EINOUT_union_tag {  /* IO Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t EIN1:1;
    vuint32_t EIN0:1;
    vuint32_t _unused_2:2;
    vuint32_t EOUT1:1;
    vuint32_t EOUT0:1;
  } B;
} FCCU_EINOUT_tag;

typedef union FCCU_STAT_union_tag {    /* Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t PhysicErrorPin:2;
    vuint32_t ESTAT:1;
    vuint32_t STATUS:3;
  } B;
} FCCU_STAT_tag;

typedef union FCCU_N2AF_STATUS_union_tag { /* NA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t NAFS:8;
  } B;
} FCCU_N2AF_STATUS_tag;

typedef union FCCU_A2FF_STATUS_union_tag { /* AF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t AF_SRC:2;
    vuint32_t AFFS:8;
  } B;
} FCCU_A2FF_STATUS_tag;

typedef union FCCU_N2FF_STATUS_union_tag { /* NF Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t NF_SRC:2;
    vuint32_t NFFS:8;
  } B;
} FCCU_N2FF_STATUS_tag;

typedef union FCCU_F2A_STATUS_union_tag { /* FA Freeze Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t FAFS:9;
  } B;
} FCCU_F2A_STATUS_tag;

typedef union FCCU_NCFF_union_tag {    /* Noncritical Fault Fake */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t FNCFC:7;
  } B;
} FCCU_NCFF_tag;

typedef union FCCU_IRQ_STAT_union_tag { /* IRQ Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;
    vuint32_t NMI_STAT:1;
    vuint32_t ALRM_STAT:1;
    vuint32_t CFG_TO_STAT:1;
  } B;
} FCCU_IRQ_STAT_tag;

typedef union FCCU_IRQ_EN_union_tag {  /* IRQ Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t _unused_3:1;
    vuint32_t _unused_1:2;
    vuint32_t CFG_TO_IEN:1;
  } B;
} FCCU_IRQ_EN_tag;

typedef union FCCU_XTMR_union_tag {    /* XTMR */
  vuint32_t R;
  struct {
    vuint32_t XTMR:32;
  } B;
} FCCU_XTMR_tag;

typedef union FCCU_MCS_union_tag {     /* Mode Controller Status */
  vuint32_t R;
  struct {
    vuint32_t VL3:1;
    vuint32_t FS3:1;
    vuint32_t _unused_28:2;
    vuint32_t MCS3:4;
    vuint32_t VL2:1;
    vuint32_t FS2:1;
    vuint32_t _unused_20:2;
    vuint32_t MCS2:4;
    vuint32_t VL1:1;
    vuint32_t FS1:1;
    vuint32_t _unused_12:2;
    vuint32_t MCS1:4;
    vuint32_t VL0:1;
    vuint32_t FS0:1;
    vuint32_t _unused_4:2;
    vuint32_t MCS0:4;
  } B;
} FCCU_MCS_tag;

typedef union FCCU_TRANS_LOCK_union_tag { /* Transient Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t TRANSKEY:9;
  } B;
} FCCU_TRANS_LOCK_tag;

typedef union FCCU_PERMNT_LOCK_union_tag { /* Permanent Lock */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t PERMNTKEY:9;
  } B;
} FCCU_PERMNT_LOCK_tag;

typedef union FCCU_DELTA_T_union_tag { /* Delta T */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t _unused_16:14;
    vuint32_t _unused_14:2;
    vuint32_t DELTA_T:14;
  } B;
} FCCU_DELTA_T_tag;

typedef union FCCU_IRQ_ALARM_EN_union_tag { /* IRQ Alarm Enable */
  vuint32_t R;
  struct {
    vuint32_t IRQEN31:1;
    vuint32_t IRQEN30:1;
    vuint32_t IRQEN29:1;
    vuint32_t IRQEN28:1;
    vuint32_t IRQEN27:1;
    vuint32_t IRQEN26:1;
    vuint32_t IRQEN25:1;
    vuint32_t IRQEN24:1;
    vuint32_t IRQEN23:1;
    vuint32_t IRQEN22:1;
    vuint32_t IRQEN21:1;
    vuint32_t IRQEN20:1;
    vuint32_t IRQEN19:1;
    vuint32_t IRQEN18:1;
    vuint32_t IRQEN17:1;
    vuint32_t IRQEN16:1;
    vuint32_t IRQEN15:1;
    vuint32_t IRQEN14:1;
    vuint32_t IRQEN13:1;
    vuint32_t IRQEN12:1;
    vuint32_t IRQEN11:1;
    vuint32_t IRQEN10:1;
    vuint32_t IRQEN9:1;
    vuint32_t IRQEN8:1;
    vuint32_t IRQEN7:1;
    vuint32_t IRQEN6:1;
    vuint32_t IRQEN5:1;
    vuint32_t IRQEN4:1;
    vuint32_t IRQEN3:1;
    vuint32_t IRQEN2:1;
    vuint32_t IRQEN1:1;
    vuint32_t IRQEN0:1;
  } B;
} FCCU_IRQ_ALARM_EN_tag;

typedef union FCCU_NMI_EN_union_tag {  /* NMI Enable */
  vuint32_t R;
  struct {
    vuint32_t NMIEN31:1;
    vuint32_t NMIEN30:1;
    vuint32_t NMIEN29:1;
    vuint32_t NMIEN28:1;
    vuint32_t NMIEN27:1;
    vuint32_t NMIEN26:1;
    vuint32_t NMIEN25:1;
    vuint32_t NMIEN24:1;
    vuint32_t NMIEN23:1;
    vuint32_t NMIEN22:1;
    vuint32_t NMIEN21:1;
    vuint32_t NMIEN20:1;
    vuint32_t NMIEN19:1;
    vuint32_t NMIEN18:1;
    vuint32_t NMIEN17:1;
    vuint32_t NMIEN16:1;
    vuint32_t NMIEN15:1;
    vuint32_t NMIEN14:1;
    vuint32_t NMIEN13:1;
    vuint32_t NMIEN12:1;
    vuint32_t NMIEN11:1;
    vuint32_t NMIEN10:1;
    vuint32_t NMIEN9:1;
    vuint32_t NMIEN8:1;
    vuint32_t NMIEN7:1;
    vuint32_t NMIEN6:1;
    vuint32_t NMIEN5:1;
    vuint32_t NMIEN4:1;
    vuint32_t NMIEN3:1;
    vuint32_t NMIEN2:1;
    vuint32_t NMIEN1:1;
    vuint32_t NMIEN0:1;
  } B;
} FCCU_NMI_EN_tag;

typedef union FCCU_EOUT_SIG_EN_union_tag { /* EOUT Signaling Enable */
  vuint32_t R;
  struct {
    vuint32_t EOUTEN31:1;
    vuint32_t EOUTEN30:1;
    vuint32_t EOUTEN29:1;
    vuint32_t EOUTEN28:1;
    vuint32_t EOUTEN27:1;
    vuint32_t EOUTEN26:1;
    vuint32_t EOUTEN25:1;
    vuint32_t EOUTEN24:1;
    vuint32_t EOUTEN23:1;
    vuint32_t EOUTEN22:1;
    vuint32_t EOUTEN21:1;
    vuint32_t EOUTEN20:1;
    vuint32_t EOUTEN19:1;
    vuint32_t EOUTEN18:1;
    vuint32_t EOUTEN17:1;
    vuint32_t EOUTEN16:1;
    vuint32_t EOUTEN15:1;
    vuint32_t EOUTEN14:1;
    vuint32_t EOUTEN13:1;
    vuint32_t EOUTEN12:1;
    vuint32_t EOUTEN11:1;
    vuint32_t EOUTEN10:1;
    vuint32_t EOUTEN9:1;
    vuint32_t EOUTEN8:1;
    vuint32_t EOUTEN7:1;
    vuint32_t EOUTEN6:1;
    vuint32_t EOUTEN5:1;
    vuint32_t EOUTEN4:1;
    vuint32_t EOUTEN3:1;
    vuint32_t EOUTEN2:1;
    vuint32_t EOUTEN1:1;
    vuint32_t EOUTEN0:1;
  } B;
} FCCU_EOUT_SIG_EN_tag;

struct FCCU_tag {
  FCCU_CTRL_tag CTRL;                  /* Control */
  FCCU_CTRLK_tag CTRLK;                /* Control Key */
  FCCU_CFG_tag CFG;                    /* Configuration */
  uint8_t FCCU_reserved0[16];
  FCCU_NCF_CFG_tag NCF_CFG[4];         /* Noncritical Fault Configuration */
  uint8_t FCCU_reserved1[32];
  FCCU_NCFS_CFG_tag NCFS_CFG[8];       /* Noncritical Fault State Configuration */
  uint8_t FCCU_reserved2[20];
  FCCU_NCF_S_tag NCF_S[4];             /* Noncritical Fault Status */
  FCCU_NCFK_tag NCFK;                  /* Noncritical Fault Key */
  FCCU_NCF_E_tag NCF_E[4];             /* Noncritical Fault Enable */
  FCCU_NCF_TOE_tag NCF_TOE[4];         /* Noncritical Fault Timeout Enable */
  FCCU_NCF_TO_tag NCF_TO;              /* Noncritical Fault Timeout */
  FCCU_CFG_TO_tag CFG_TO;              /* Configuration-State Timeout */
  FCCU_EINOUT_tag EINOUT;              /* IO Control */
  FCCU_STAT_tag STAT;                  /* Status */
  FCCU_N2AF_STATUS_tag N2AF_STATUS;    /* NA Freeze Status */
  FCCU_A2FF_STATUS_tag A2FF_STATUS;    /* AF Freeze Status */
  FCCU_N2FF_STATUS_tag N2FF_STATUS;    /* NF Freeze Status */
  FCCU_F2A_STATUS_tag F2A_STATUS;      /* FA Freeze Status */
  uint8_t FCCU_reserved3[8];
  FCCU_NCFF_tag NCFF;                  /* Noncritical Fault Fake */
  FCCU_IRQ_STAT_tag IRQ_STAT;          /* IRQ Status */
  FCCU_IRQ_EN_tag IRQ_EN;              /* IRQ Enable */
  FCCU_XTMR_tag XTMR;                  /* XTMR */
  FCCU_MCS_tag MCS;                    /* Mode Controller Status */
  FCCU_TRANS_LOCK_tag TRANS_LOCK;      /* Transient Lock */
  FCCU_PERMNT_LOCK_tag PERMNT_LOCK;    /* Permanent Lock */
  FCCU_DELTA_T_tag DELTA_T;            /* Delta T */
  FCCU_IRQ_ALARM_EN_tag IRQ_ALARM_EN[4]; /* IRQ Alarm Enable */
  FCCU_NMI_EN_tag NMI_EN[4];           /* NMI Enable */
  FCCU_EOUT_SIG_EN_tag EOUT_SIG_EN[4]; /* EOUT Signaling Enable */
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

typedef union FR_MVR_union_tag {       /* Module Version Register */
  vuint16_t R;
  struct {
    vuint16_t CHIVER:8;
    vuint16_t PEVER:8;
  } B;
} FR_MVR_tag;

typedef union FR_MCR_union_tag {       /* Module Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MEN:1;
    vuint16_t SBFF:1;                  /* System Bus Failure Freeze */
    vuint16_t SCM:1;
    vuint16_t CHB:1;
    vuint16_t CHA:1;
    vuint16_t SFFE:1;
    vuint16_t ECCE:1;
    vuint16_t _unused_8:1;             /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t FUM:1;
    vuint16_t FAM:1;
    vuint16_t _unused_5:1;
    vuint16_t CLKSEL:1;
    vuint16_t BITRATE:3;
    vuint16_t _unused_0:1;
  } B;
} FR_MCR_tag;

typedef union FR_SYMBADHR_union_tag {  /* System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;                 /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
  } B;
} FR_SYMBADHR_tag;

typedef union FR_SYMBADLR_union_tag {  /* System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t _unused_0:4;
  } B;
} FR_SYMBADLR_tag;

typedef union FR_STBSCR_union_tag {    /* Strobe Signal Control Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_12:3;
    vuint16_t SEL:4;
    vuint16_t _unused_5:3;
    vuint16_t ENB:1;
    vuint16_t _unused_2:2;
    vuint16_t STBPSEL:2;
  } B;
} FR_STBSCR_tag;

typedef union FR_MBDSR_union_tag {     /* Message Buffer Data Size Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t MBSEG2DS:7;
    vuint16_t _unused_7:1;
    vuint16_t MBSEG1DS:7;
  } B;
} FR_MBDSR_tag;

typedef union FR_MBSSUTR_union_tag {   /* Message Buffer Segment Size and Utilization Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t LAST_MB_SEG1:7;
    vuint16_t _unused_7:1;
    vuint16_t LAST_MB_UTIL:7;
  } B;
} FR_MBSSUTR_tag;

typedef union FR_PEDRAR_union_tag {    /* PE DRAM Access Register */
  vuint16_t R;
  struct {
    vuint16_t INST:4;
    vuint16_t ADDR:11;
    vuint16_t DAD:1;
  } B;
} FR_PEDRAR_tag;

typedef union FR_PEDRDR_union_tag {    /* PE DRAM Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_PEDRDR_tag;

typedef union FR_POCR_union_tag {      /* Protocol Operation Control Register */
  vuint16_t R;
  struct {
    vuint16_t WME:1;
    vuint16_t _unused_12:3;
    vuint16_t EOC_AP:2;
    vuint16_t ERC_AP:2;
    vuint16_t BSY_WMC:1;
    vuint16_t _unused_4:3;
    vuint16_t POCCMD:4;
  } B;
} FR_POCR_tag;

typedef union FR_GIFER_union_tag {     /* Global Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
    vuint16_t MIE:1;
    vuint16_t PRIE:1;
    vuint16_t CHIE:1;
    vuint16_t WUPIE:1;
    vuint16_t FAFBIE:1;
    vuint16_t FAFAIE:1;
    vuint16_t RBIE:1;
    vuint16_t TBIE:1;
  } B;
} FR_GIFER_tag;

typedef union FR_PIFR0_union_tag {     /* Protocol Interrupt Flag Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IF:1;
    vuint16_t INTL_IF:1;
    vuint16_t ILCF_IF:1;
    vuint16_t CSA_IF:1;
    vuint16_t MRC_IF:1;
    vuint16_t MOC_IF:1;
    vuint16_t CCL_IF:1;
    vuint16_t MXS_IF:1;
    vuint16_t MTX_IF:1;
    vuint16_t LTXB_IF:1;
    vuint16_t LTXA_IF:1;
    vuint16_t TBVB_IF:1;
    vuint16_t TBVA_IF:1;
    vuint16_t TI2_IF:1;
    vuint16_t TI1_IF:1;
    vuint16_t CYS_IF:1;
  } B;
} FR_PIFR0_tag;

typedef union FR_PIFR1_union_tag {     /* Protocol Interrupt Flag Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IF:1;
    vuint16_t IPC_IF:1;
    vuint16_t PECF_IF:1;
    vuint16_t PSC_IF:1;
    vuint16_t SSI3_IF:1;
    vuint16_t SSI2_IF:1;
    vuint16_t SSI1_IF:1;
    vuint16_t SSI0_IF:1;
    vuint16_t _unused_6:2;
    vuint16_t EVT_IF:1;
    vuint16_t ODT_IF:1;
    vuint16_t _unused_0:4;
  } B;
} FR_PIFR1_tag;

typedef union FR_PIER0_union_tag {     /* Protocol Interrupt Enable Register 0 */
  vuint16_t R;
  struct {
    vuint16_t FATL_IE:1;
    vuint16_t INTL_IE:1;
    vuint16_t ILCF_IE:1;
    vuint16_t CSA_IE:1;
    vuint16_t MRC_IE:1;
    vuint16_t MOC_IE:1;
    vuint16_t CCL_IE:1;
    vuint16_t MXS_IE:1;
    vuint16_t MTX_IE:1;
    vuint16_t LTXB_IE:1;
    vuint16_t LTXA_IE:1;
    vuint16_t TBVB_IE:1;
    vuint16_t TBVA_IE:1;
    vuint16_t TI2_IE:1;
    vuint16_t TI1_IE:1;
    vuint16_t CYS_IE:1;
  } B;
} FR_PIER0_tag;

typedef union FR_PIER1_union_tag {     /* Protocol Interrupt Enable Register 1 */
  vuint16_t R;
  struct {
    vuint16_t EMC_IE:1;
    vuint16_t IPC_IE:1;
    vuint16_t PECF_IE:1;
    vuint16_t PSC_IE:1;
    vuint16_t SSI3_IE:1;
    vuint16_t SSI2_IE:1;
    vuint16_t SSI1_IE:1;
    vuint16_t SSI0_IE:1;
    vuint16_t _unused_6:2;
    vuint16_t EVT_IE:1;
    vuint16_t ODT_IE:1;
    vuint16_t _unused_0:4;
  } B;
} FR_PIER1_tag;

typedef union FR_CHIERFR_union_tag {   /* CHI Error Flag Register */
  vuint16_t R;
  struct {
    vuint16_t FRLB_EF:1;
    vuint16_t FRLA_EF:1;
    vuint16_t PCMI_EF:1;
    vuint16_t FOVB_EF:1;
    vuint16_t FOVA_EF:1;
    vuint16_t MBS_EF:1;
    vuint16_t MBU_EF:1;
    vuint16_t LCK_EF:1;
    vuint16_t _unused_7:1;
    vuint16_t SBCF_EF:1;
    vuint16_t FID_EF:1;
    vuint16_t DPL_EF:1;
    vuint16_t SPL_EF:1;
    vuint16_t NML_EF:1;
    vuint16_t NMF_EF:1;
    vuint16_t ILSA_EF:1;
  } B;
} FR_CHIERFR_tag;

typedef union FR_MBIVEC_union_tag {    /* Message Buffer Interrupt Vector Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t TBIVEC:7;
    vuint16_t _unused_7:1;
    vuint16_t RBIVEC:7;
  } B;
} FR_MBIVEC_tag;

typedef union FR_CASERCR_union_tag {   /* Channel A Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHAERSCNT:16;
  } B;
} FR_CASERCR_tag;

typedef union FR_CBSERCR_union_tag {   /* Channel B Status Error Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CHBERSCNT:16;
  } B;
} FR_CBSERCR_tag;

typedef union FR_PSR0_union_tag {      /* Protocol Status Register 0 */
  vuint16_t R;
  struct {
    vuint16_t ERRMODE:2;
    vuint16_t SLOTMODE:2;
    vuint16_t _unused_11:1;
    vuint16_t PROTSTATE:3;
    vuint16_t STARTUPSTATE:4;
    vuint16_t _unused_3:1;
    vuint16_t WAKEUPSTATUS:3;
  } B;
} FR_PSR0_tag;

typedef union FR_PSR1_union_tag {      /* Protocol Status Register 1 */
  vuint16_t R;
  struct {
    vuint16_t CSAA:1;
    vuint16_t CSP:1;
    vuint16_t _unused_13:1;
    vuint16_t REMCSAT:5;
    vuint16_t CPN:1;
    vuint16_t HHR:1;
    vuint16_t FRZ:1;
    vuint16_t APTAC:5;
  } B;
} FR_PSR1_tag;

typedef union FR_PSR2_union_tag {      /* Protocol Status Register 2 */
  vuint16_t R;
  struct {
    vuint16_t NBVB:1;
    vuint16_t NSEB:1;
    vuint16_t STCB:1;
    vuint16_t SBVB:1;
    vuint16_t SSEB:1;
    vuint16_t MTB:1;
    vuint16_t NBVA:1;
    vuint16_t NSEA:1;
    vuint16_t STCA:1;
    vuint16_t SBVA:1;
    vuint16_t SSEA:1;
    vuint16_t MTA:1;
    vuint16_t CKCORFCNT:4;
  } B;
} FR_PSR2_tag;

typedef union FR_PSR3_union_tag {      /* Protocol Status Register 3 */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t WUB:1;
    vuint16_t ABVB:1;
    vuint16_t AACB:1;
    vuint16_t ACEB:1;
    vuint16_t ASEB:1;
    vuint16_t AVFB:1;
    vuint16_t _unused_6:2;
    vuint16_t WUA:1;
    vuint16_t ABVA:1;
    vuint16_t AACA:1;
    vuint16_t ACEA:1;
    vuint16_t ASEA:1;
    vuint16_t AVFA:1;
  } B;
} FR_PSR3_tag;

typedef union FR_MTCTR_union_tag {     /* Macrotick Counter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t MTCT:14;
  } B;
} FR_MTCTR_tag;

typedef union FR_CYCTR_union_tag {     /* Cycle Counter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_6:10;
    vuint16_t CYCCNT:6;
  } B;
} FR_CYCTR_tag;

typedef union FR_SLTCTAR_union_tag {   /* Slot Counter Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t SLOTCNTA:11;
  } B;
} FR_SLTCTAR_tag;

typedef union FR_SLTCTBR_union_tag {   /* Slot Counter Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t SLOTCNTB:11;
  } B;
} FR_SLTCTBR_tag;

typedef union FR_RTCORVR_union_tag {   /* Rate Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t RATECORR:16;
  } B;
} FR_RTCORVR_tag;

typedef union FR_OFCORVR_union_tag {   /* Offset Correction Value Register */
  vuint16_t R;
  struct {
    vuint16_t OFFSETCORR:16;
  } B;
} FR_OFCORVR_tag;

typedef union FR_CIFR_union_tag {      /* Combined Interrupt Flag Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t MIF:1;
    vuint16_t PRIF:1;
    vuint16_t CHIF:1;
    vuint16_t WUPIF:1;
    vuint16_t FAFBIF:1;
    vuint16_t FAFAIF:1;
    vuint16_t RBIF:1;
    vuint16_t TBIF:1;
  } B;
} FR_CIFR_tag;

typedef union FR_SYMATOR_union_tag {   /* System Memory Access Time-Out Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t TIMEOUT:8;
  } B;
} FR_SYMATOR_tag;

typedef union FR_SFCNTR_union_tag {    /* Sync Frame Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SFEVB:4;
    vuint16_t SFEVA:4;
    vuint16_t SFODB:4;
    vuint16_t SFODA:4;
  } B;
} FR_SFCNTR_tag;

typedef union FR_SFTOR_union_tag {     /* Sync Frame Table Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SFT_OFFSET:15;
    vuint16_t _unused_0:1;
  } B;
} FR_SFTOR_tag;

typedef union FR_SFTCCSR_union_tag {   /* Sync Frame Table Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t ELKT:1;
    vuint16_t OLKT:1;
    vuint16_t CYCNUM:6;
    vuint16_t ELKS:1;
    vuint16_t OLKS:1;
    vuint16_t EVAL:1;
    vuint16_t OVAL:1;
    vuint16_t _unused_3:1;
    vuint16_t OPT:1;
    vuint16_t SDVEN:1;
    vuint16_t SIDEN:1;
  } B;
} FR_SFTCCSR_tag;

typedef union FR_SFIDRFR_union_tag {   /* Sync Frame ID Rejection Filter Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t SYNFRID:10;
  } B;
} FR_SFIDRFR_tag;

typedef union FR_SFIDAFVR_union_tag {  /* Sync Frame ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t FVAL:10;
  } B;
} FR_SFIDAFVR_tag;

typedef union FR_SFIDAFMR_union_tag {  /* Sync Frame ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t FMSK:10;
  } B;
} FR_SFIDAFMR_tag;

typedef union FR_NMVR_union_tag {      /* Network Management Vector Register */
  vuint16_t R;
  struct {
    vuint16_t NMVP:16;
  } B;
} FR_NMVR_tag;

typedef union FR_NMVLR_union_tag {     /* Network Management Vector Length Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t NMVL:4;
  } B;
} FR_NMVLR_tag;

typedef union FR_TICCR_union_tag {     /* Timer Configuration and Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2_CFG:1;
    vuint16_t T2_REP:1;
    vuint16_t _unused_11:1;
    vuint16_t T2SP:1;
    vuint16_t T2TR:1;
    vuint16_t T2ST:1;
    vuint16_t _unused_5:3;
    vuint16_t T1_REP:1;
    vuint16_t _unused_3:1;
    vuint16_t T1SP:1;
    vuint16_t T1TR:1;
    vuint16_t T1ST:1;
  } B;
} FR_TICCR_tag;

typedef union FR_TI1CYSR_union_tag {   /* Timer 1 Cycle Set Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T1_CYC_VAL:6;
    vuint16_t _unused_6:2;
    vuint16_t T1_CYC_MSK:6;
  } B;
} FR_TI1CYSR_tag;

typedef union FR_TI1MTOR_union_tag {   /* Timer 1 Macrotick Offset Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T1_MTOFFSET:14;
  } B;
} FR_TI1MTOR_tag;

typedef union FR_TI2CR0_ABS_union_tag { /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2CYCVAL:6;              /* Timer T2 Cycle Filter Mask */
    vuint16_t _unused_6:2;
    vuint16_t T2CYCMSK:6;              /* Timer T2 Cycle Filter Mask */
  } B;
} FR_TI2CR0_ABS_tag;

typedef union FR_TI2CR0_REL_union_tag { /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;              /* Timer T2 Macrotick High Word */
  } B;
} FR_TI2CR0_REL_tag;

typedef union FR_TI2CR0_union_tag {
  FR_TI2CR0_ABS_tag ABS;               /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
  FR_TI2CR0_REL_tag REL;               /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
} FR_TI2CR0_tag;

typedef union FR_TI2CR1_ABS_union_tag { /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t T2MOFF:14;               /* Timer T2 Macrotick Offset */
  } B;
} FR_TI2CR1_ABS_tag;

typedef union FR_TI2CR1_REL_union_tag { /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
  vuint16_t R;
  struct {
    vuint16_t T2MTCNT:16;
  } B;
} FR_TI2CR1_REL_tag;

typedef union FR_TI2CR1_union_tag {
  FR_TI2CR1_ABS_tag ABS;               /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
  FR_TI2CR1_REL_tag REL;               /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
} FR_TI2CR1_tag;

typedef union FR_SSSR_union_tag {      /* Slot Status Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t SLOTNUMBER:11;
  } B;
} FR_SSSR_tag;

typedef union FR_SSCCR_union_tag {     /* Slot Status Counter Condition Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t CNTCFG:2;
    vuint16_t MCY:1;
    vuint16_t VFR:1;
    vuint16_t SYF:1;
    vuint16_t NUF:1;
    vuint16_t SUF:1;
    vuint16_t STATUSMASK:4;
  } B;
} FR_SSCCR_tag;

typedef union FR_SSR_union_tag {       /* Slot Status Register */
  vuint16_t R;
  struct {
    vuint16_t VFB:1;
    vuint16_t SYB:1;
    vuint16_t NFB:1;
    vuint16_t SUB:1;
    vuint16_t SEB:1;
    vuint16_t CEB:1;
    vuint16_t BVB:1;
    vuint16_t TCB:1;
    vuint16_t VFA:1;
    vuint16_t SYA:1;
    vuint16_t NFA:1;
    vuint16_t SUA:1;
    vuint16_t SEA:1;
    vuint16_t CEA:1;
    vuint16_t BVA:1;
    vuint16_t TCA:1;
  } B;
} FR_SSR_tag;

typedef union FR_SSCR_union_tag {      /* Slot Status Counter Register */
  vuint16_t R;
  struct {
    vuint16_t SLOTSTATUSCNT:16;
  } B;
} FR_SSCR_tag;

typedef union FR_MTSACFR_union_tag {   /* MTS A Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t _unused_14:1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSACFR_tag;

typedef union FR_MTSBCFR_union_tag {   /* MTS B Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t MTE:1;
    vuint16_t _unused_14:1;
    vuint16_t CYCCNTMSK:6;
    vuint16_t _unused_6:2;
    vuint16_t CYCCNTVAL:6;
  } B;
} FR_MTSBCFR_tag;

typedef union FR_RSBIR_union_tag {     /* Receive Shadow Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t _unused_14:1;
    vuint16_t SEL:2;
    vuint16_t _unused_8:4;
    vuint16_t RSBIDX:8;                /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
  } B;
} FR_RSBIR_tag;

typedef union FR_RFWMSR_union_tag {    /* Receive FIFO Watermark and Selection Register */
  vuint16_t R;
  struct {
    vuint16_t WM:8;                    /* WMA/WMB - Watermark */
    vuint16_t _unused_1:7;
    vuint16_t SEL:1;
  } B;
} FR_RFWMSR_tag;

typedef union FR_RFSIR_union_tag {     /* Receive FIFO Start Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t SIDX:10;                 /* SIDXA/SIDXB - Start Index */
  } B;
} FR_RFSIR_tag;

typedef union FR_RFDSR_union_tag {     /* Receive FIFO Depth and Size Register */
  vuint16_t R;
  struct {
    vuint16_t FIFO_DEPTH:8;            /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
    vuint16_t _unused_7:1;
    vuint16_t ENTRY_SIZE:7;            /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
  } B;
} FR_RFDSR_tag;

typedef union FR_RFARIR_union_tag {    /* Receive FIFO A Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFARIR_tag;

typedef union FR_RFBRIR_union_tag {    /* Receive FIFO B Read Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t RDIDX:10;
  } B;
} FR_RFBRIR_tag;

typedef union FR_RFMIDAFVR_union_tag { /* Receive FIFO Message ID Acceptance Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFVAL:16;             /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
  } B;
} FR_RFMIDAFVR_tag;

typedef union FR_RFMIDAFMR_union_tag { /* Receive FIFO Message ID Acceptance Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t MIDAFMSK:16;             /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
  } B;
} FR_RFMIDAFMR_tag;

typedef union FR_RFFIDRFVR_union_tag { /* Receive FIFO Frame ID Rejection Filter Value Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FIDRFVAL:11;             /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
  } B;
} FR_RFFIDRFVR_tag;

typedef union FR_RFFIDRFMR_union_tag { /* Receive FIFO Frame ID Rejection Filter Mask Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FIDRFMSK:11;
  } B;
} FR_RFFIDRFMR_tag;

typedef union FR_RFRFCFR_union_tag {   /* Receive FIFO Range Filter Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t WMD:1;
    vuint16_t IBD:1;
    vuint16_t SEL:2;
    vuint16_t _unused_11:1;
    vuint16_t SID:11;                  /* Slot ID */
  } B;
} FR_RFRFCFR_tag;

typedef union FR_RFRFCTR_union_tag {   /* Receive FIFO Range Filter Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t F3MD:1;
    vuint16_t F2MD:1;
    vuint16_t F1MD:1;
    vuint16_t F0MD:1;
    vuint16_t _unused_4:4;
    vuint16_t F3EN:1;
    vuint16_t F2EN:1;
    vuint16_t F1EN:1;
    vuint16_t F0EN:1;
  } B;
} FR_RFRFCTR_tag;

typedef union FR_LDTXSLAR_union_tag {  /* Last Dynamic Transmit Slot Channel A Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t LDYNTXSLOTA:11;
  } B;
} FR_LDTXSLAR_tag;

typedef union FR_LDTXSLBR_union_tag {  /* Last Dynamic Transmit Slot Channel B Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t LDYNTXSLOTB:11;
  } B;
} FR_LDTXSLBR_tag;

typedef union FR_PCR0_union_tag {      /* Protocol Configuration Register 0 */
  vuint16_t R;
  struct {
    vuint16_t action_point_offset:6;
    vuint16_t static_slot_length:10;
  } B;
} FR_PCR0_tag;

typedef union FR_PCR1_union_tag {      /* Protocol Configuration Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t macro_after_first_static_slot:14;
  } B;
} FR_PCR1_tag;

typedef union FR_PCR2_union_tag {      /* Protocol Configuration Register 2 */
  vuint16_t R;
  struct {
    vuint16_t minislot_after_action_point:6;
    vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
  } B;
} FR_PCR2_tag;

typedef union FR_PCR3_union_tag {      /* Protocol Configuration Register 3 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_symbol_rx_low:6;
    vuint16_t minislot_action_point_offset:5;
    vuint16_t coldstart_attempts:5;
  } B;
} FR_PCR3_tag;

typedef union FR_PCR4_union_tag {      /* Protocol Configuration Register 4 */
  vuint16_t R;
  struct {
    vuint16_t cas_rx_low_max:7;
    vuint16_t wakeup_symbol_rx_window:9;
  } B;
} FR_PCR4_tag;

typedef union FR_PCR5_union_tag {      /* Protocol Configuration Register 5 */
  vuint16_t R;
  struct {
    vuint16_t tss_transmitter:4;
    vuint16_t wakeup_symbol_tx_low:6;
    vuint16_t wakeup_symbol_rx_idle:6;
  } B;
} FR_PCR5_tag;

typedef union FR_PCR6_union_tag {      /* Protocol Configuration Register 6 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t symbol_window_after_action_point:8;
    vuint16_t macro_initial_offset_a:7;
  } B;
} FR_PCR6_tag;

typedef union FR_PCR7_union_tag {      /* Protocol Configuration Register 7 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_b:9;
    vuint16_t micro_per_macro_nom_half:7;
  } B;
} FR_PCR7_tag;

typedef union FR_PCR8_union_tag {      /* Protocol Configuration Register 8 */
  vuint16_t R;
  struct {
    vuint16_t max_without_clock_correction_fatal:4;
    vuint16_t max_without_clock_correction_passive:4;
    vuint16_t wakeup_symbol_tx_idle:8;
  } B;
} FR_PCR8_tag;

typedef union FR_PCR9_union_tag {      /* Protocol Configuration Register 9 */
  vuint16_t R;
  struct {
    vuint16_t minislot_exists:1;
    vuint16_t symbol_window_exists:1;
    vuint16_t offset_correction_out:14;
  } B;
} FR_PCR9_tag;

typedef union FR_PCR10_union_tag {     /* Protocol Configuration Register 10 */
  vuint16_t R;
  struct {
    vuint16_t single_slot_enabled:1;
    vuint16_t wakeup_channel:1;
    vuint16_t macro_per_cycle:14;
  } B;
} FR_PCR10_tag;

typedef union FR_PCR11_union_tag {     /* Protocol Configuration Register 11 */
  vuint16_t R;
  struct {
    vuint16_t key_slot_used_for_startup:1;
    vuint16_t key_slot_used_for_sync:1;
    vuint16_t offset_correction_start:14;
  } B;
} FR_PCR11_tag;

typedef union FR_PCR12_union_tag {     /* Protocol Configuration Register 12 */
  vuint16_t R;
  struct {
    vuint16_t allow_passive_to_active:5;
    vuint16_t key_slot_header_crc:11;
  } B;
} FR_PCR12_tag;

typedef union FR_PCR13_union_tag {     /* Protocol Configuration Register 13 */
  vuint16_t R;
  struct {
    vuint16_t first_minislot_action_point_offset:6;
    vuint16_t static_slot_after_action_point:10;
  } B;
} FR_PCR13_tag;

typedef union FR_PCR14_union_tag {     /* Protocol Configuration Register 14 */
  vuint16_t R;
  struct {
    vuint16_t rate_correction_out:11;
    vuint16_t listen_timeout:5;
  } B;
} FR_PCR14_tag;

typedef union FR_PCR15_union_tag {     /* Protocol Configuration Register 15 */
  vuint16_t R;
  struct {
    vuint16_t listen_timeout:16;
  } B;
} FR_PCR15_tag;

typedef union FR_PCR16_union_tag {     /* Protocol Configuration Register 16 */
  vuint16_t R;
  struct {
    vuint16_t macro_initial_offset_b:7;
    vuint16_t noise_listen_timeout:9;
  } B;
} FR_PCR16_tag;

typedef union FR_PCR17_union_tag {     /* Protocol Configuration Register 17 */
  vuint16_t R;
  struct {
    vuint16_t noise_listen_timeout:16;
  } B;
} FR_PCR17_tag;

typedef union FR_PCR18_union_tag {     /* Protocol Configuration Register 18 */
  vuint16_t R;
  struct {
    vuint16_t wakeup_pattern:6;
    vuint16_t key_slot_id:10;
  } B;
} FR_PCR18_tag;

typedef union FR_PCR19_union_tag {     /* Protocol Configuration Register 19 */
  vuint16_t R;
  struct {
    vuint16_t decoding_correction_a:9;
    vuint16_t payload_length_static:7;
  } B;
} FR_PCR19_tag;

typedef union FR_PCR20_union_tag {     /* Protocol Configuration Register 20 */
  vuint16_t R;
  struct {
    vuint16_t micro_initial_offset_b:8;
    vuint16_t micro_initial_offset_a:8;
  } B;
} FR_PCR20_tag;

typedef union FR_PCR21_union_tag {     /* Protocol Configuration Register 21 */
  vuint16_t R;
  struct {
    vuint16_t extern_rate_correction:3;
    vuint16_t latest_tx:13;
  } B;
} FR_PCR21_tag;

typedef union FR_PCR22_union_tag {     /* Protocol Configuration Register 22 */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;            /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
    vuint16_t comp_accepted_startup_range_a:11;
    vuint16_t micro_per_cycle:4;
  } B;
} FR_PCR22_tag;

typedef union FR_PCR23_union_tag {     /* Protocol Configuration Register 23 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle:16;
  } B;
} FR_PCR23_tag;

typedef union FR_PCR24_union_tag {     /* Protocol Configuration Register 24 */
  vuint16_t R;
  struct {
    vuint16_t cluster_drift_damping:5;
    vuint16_t max_payload_length_dynamic:7;
    vuint16_t micro_per_cycle_min:4;
  } B;
} FR_PCR24_tag;

typedef union FR_PCR25_union_tag {     /* Protocol Configuration Register 25 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_min:16;
  } B;
} FR_PCR25_tag;

typedef union FR_PCR26_union_tag {     /* Protocol Configuration Register 26 */
  vuint16_t R;
  struct {
    vuint16_t allow_halt_due_to_clock:1;
    vuint16_t comp_accepted_startup_range_b:11;
    vuint16_t micro_per_cycle_max:4;
  } B;
} FR_PCR26_tag;

typedef union FR_PCR27_union_tag {     /* Protocol Configuration Register 27 */
  vuint16_t R;
  struct {
    vuint16_t micro_per_cycle_max:16;
  } B;
} FR_PCR27_tag;

typedef union FR_PCR28_union_tag {     /* Protocol Configuration Register 28 */
  vuint16_t R;
  struct {
    vuint16_t dynamic_slot_idle_phase:2;
    vuint16_t macro_after_offset_correction:14;
  } B;
} FR_PCR28_tag;

typedef union FR_PCR29_union_tag {     /* Protocol Configuration Register 29 */
  vuint16_t R;
  struct {
    vuint16_t extern_offset_correction:3;
    vuint16_t minislots_max:13;
  } B;
} FR_PCR29_tag;

typedef union FR_PCR30_union_tag {     /* Protocol Configuration Register 30 */
  vuint16_t R;
  struct {
    vuint16_t _unused_4:12;
    vuint16_t sync_node_max:4;
  } B;
} FR_PCR30_tag;

typedef union FR_RFSDOR_union_tag {    /* Receive FIFO Start Data Offset Register */
  vuint16_t R;
  struct {
    vuint16_t SDO:16;                  /* SDOA/SDOB - Start Data Field Offset */
  } B;
} FR_RFSDOR_tag;

typedef union FR_RFSYMBADHR_union_tag { /* Receive FIFO System Memory Base Address High Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:16;
  } B;
} FR_RFSYMBADHR_tag;

typedef union FR_RFSYMBADLR_union_tag { /* Receive FIFO System Memory Base Address Low Register */
  vuint16_t R;
  struct {
    vuint16_t SMBA:12;
    vuint16_t _unused_0:4;
  } B;
} FR_RFSYMBADLR_tag;

typedef union FR_RFPTR_union_tag {     /* Receive FIFO Periodic Timer Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t PTD:14;
  } B;
} FR_RFPTR_tag;

typedef union FR_RFFLPCR_union_tag {   /* Receive FIFO Fill Level and POP Count Register */
  vuint16_t R;
  struct {
    vuint16_t FLB_or_PCB:8;
    vuint16_t FLA_or_PCA:8;
  } B;
} FR_RFFLPCR_tag;

typedef union FR_EEIFER_union_tag {    /* ECC Error Interrupt Flag and Enable Register */
  vuint16_t R;
  struct {
    vuint16_t LRNE_OF:1;
    vuint16_t LRCE_OF:1;
    vuint16_t DRNE_OF:1;
    vuint16_t DRCE_OF:1;
    vuint16_t LRNE_IF:1;
    vuint16_t LRCE_IF:1;
    vuint16_t DRNE_IF:1;
    vuint16_t DRCE_IF:1;
    vuint16_t _unused_4:4;
    vuint16_t LRNE_IE:1;
    vuint16_t LRCE_IE:1;
    vuint16_t DRNE_IE:1;
    vuint16_t DRCE_IE:1;
  } B;
} FR_EEIFER_tag;

typedef union FR_EERICR_union_tag {    /* ECC Error Report and Injection Control Register */
  vuint16_t R;
  struct {
    vuint16_t BSY:1;
    vuint16_t _unused_10:5;
    vuint16_t ERS:2;
    vuint16_t _unused_5:3;
    vuint16_t ERM:1;
    vuint16_t _unused_2:2;
    vuint16_t EIM:1;
    vuint16_t EIE:1;
  } B;
} FR_EERICR_tag;

typedef union FR_EERAR_union_tag {     /* ECC Error Report Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EERAR_tag;

typedef union FR_EERDR_union_tag {     /* ECC Error Report Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EERDR_tag;

typedef union FR_EERCR_union_tag {     /* ECC Error Report Code Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_5:11;
    vuint16_t CODE:5;
  } B;
} FR_EERCR_tag;

typedef union FR_EEIAR_union_tag {     /* ECC Error Injection Address Register */
  vuint16_t R;
  struct {
    vuint16_t MID:1;
    vuint16_t BANK:3;
    vuint16_t ADDR:12;
  } B;
} FR_EEIAR_tag;

typedef union FR_EEIDR_union_tag {     /* ECC Error Injection Data Register */
  vuint16_t R;
  struct {
    vuint16_t DATA:16;
  } B;
} FR_EEIDR_tag;

typedef union FR_EEICR_union_tag {     /* ECC Error Injection Code Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_5:11;
    vuint16_t CODE:5;
  } B;
} FR_EEICR_tag;

typedef union FR_MB_CCSR_union_tag {   /* Message Buffer Configuration, Control, Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_13:3;
    vuint16_t MTD:1;
    vuint16_t CMT:1;
    vuint16_t EDT:1;
    vuint16_t LCKT:1;
    vuint16_t MBIE:1;
    vuint16_t _unused_5:3;
    vuint16_t DUP:1;
    vuint16_t DVAL:1;
    vuint16_t EDS:1;
    vuint16_t LCKS:1;
    vuint16_t MBIF:1;
  } B;
} FR_MB_CCSR_tag;

typedef union FR_MB_CCFR_union_tag {   /* Message Buffer Cycle Counter Filter Register */
  vuint16_t R;
  struct {
    vuint16_t MTM:1;
    vuint16_t CHA:1;
    vuint16_t CHB:1;
    vuint16_t CCFE:1;
    vuint16_t CCFMSK:6;
    vuint16_t CCFVAL:6;
  } B;
} FR_MB_CCFR_tag;

typedef union FR_MB_FIDR_union_tag {   /* Message Buffer Frame ID Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t FID:11;
  } B;
} FR_MB_FIDR_tag;

typedef union FR_MB_IDXR_union_tag {   /* Message Buffer Index Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t MBIDX:8;
  } B;
} FR_MB_IDXR_tag;

typedef struct FR_MB_struct_tag {
  FR_MB_CCSR_tag CCSR;                 /* Message Buffer Configuration, Control, Status Register */
  FR_MB_CCFR_tag CCFR;                 /* Message Buffer Cycle Counter Filter Register */
  FR_MB_FIDR_tag FIDR;                 /* Message Buffer Frame ID Register */
  FR_MB_IDXR_tag IDXR;                 /* Message Buffer Index Register */
} FR_MB_tag;

typedef union FR_MBDOR_union_tag {     /* Message Buffer Data Field Offset Register */
  vuint16_t R;
  struct {
    vuint16_t MBDO:16;
  } B;
} FR_MBDOR_tag;

typedef union FR_LEETR_union_tag {     /* LRAM ECC Error Test Register */
  vuint16_t R;
  struct {
    vuint16_t LEETD:16;
  } B;
} FR_LEETR_tag;

struct FR_tag {
  FR_MVR_tag MVR;                      /* Module Version Register */
  FR_MCR_tag MCR;                      /* Module Configuration Register */
  FR_SYMBADHR_tag SYMBADHR;            /* System Memory Base Address High Register */
  FR_SYMBADLR_tag SYMBADLR;            /* System Memory Base Address Low Register */
  FR_STBSCR_tag STBSCR;                /* Strobe Signal Control Register */
  uint8_t FR_reserved0[2];
  FR_MBDSR_tag MBDSR;                  /* Message Buffer Data Size Register */
  FR_MBSSUTR_tag MBSSUTR;              /* Message Buffer Segment Size and Utilization Register */
  FR_PEDRAR_tag PEDRAR;                /* PE DRAM Access Register */
  FR_PEDRDR_tag PEDRDR;                /* PE DRAM Data Register */
  FR_POCR_tag POCR;                    /* Protocol Operation Control Register */
  FR_GIFER_tag GIFER;                  /* Global Interrupt Flag and Enable Register */
  FR_PIFR0_tag PIFR0;                  /* Protocol Interrupt Flag Register 0 */
  FR_PIFR1_tag PIFR1;                  /* Protocol Interrupt Flag Register 1 */
  FR_PIER0_tag PIER0;                  /* Protocol Interrupt Enable Register 0 */
  FR_PIER1_tag PIER1;                  /* Protocol Interrupt Enable Register 1 */
  FR_CHIERFR_tag CHIERFR;              /* CHI Error Flag Register */
  FR_MBIVEC_tag MBIVEC;                /* Message Buffer Interrupt Vector Register */
  FR_CASERCR_tag CASERCR;              /* Channel A Status Error Counter Register */
  FR_CBSERCR_tag CBSERCR;              /* Channel B Status Error Counter Register */
  FR_PSR0_tag PSR0;                    /* Protocol Status Register 0 */
  FR_PSR1_tag PSR1;                    /* Protocol Status Register 1 */
  FR_PSR2_tag PSR2;                    /* Protocol Status Register 2 */
  FR_PSR3_tag PSR3;                    /* Protocol Status Register 3 */
  FR_MTCTR_tag MTCTR;                  /* Macrotick Counter Register */
  FR_CYCTR_tag CYCTR;                  /* Cycle Counter Register */
  FR_SLTCTAR_tag SLTCTAR;              /* Slot Counter Channel A Register */
  FR_SLTCTBR_tag SLTCTBR;              /* Slot Counter Channel B Register */
  FR_RTCORVR_tag RTCORVR;              /* Rate Correction Value Register */
  FR_OFCORVR_tag OFCORVR;              /* Offset Correction Value Register */
  FR_CIFR_tag CIFR;                    /* Combined Interrupt Flag Register */
  FR_SYMATOR_tag SYMATOR;              /* System Memory Access Time-Out Register */
  FR_SFCNTR_tag SFCNTR;                /* Sync Frame Counter Register */
  FR_SFTOR_tag SFTOR;                  /* Sync Frame Table Offset Register */
  FR_SFTCCSR_tag SFTCCSR;              /* Sync Frame Table Configuration, Control, Status Register */
  FR_SFIDRFR_tag SFIDRFR;              /* Sync Frame ID Rejection Filter Register */
  FR_SFIDAFVR_tag SFIDAFVR;            /* Sync Frame ID Acceptance Filter Value Register */
  FR_SFIDAFMR_tag SFIDAFMR;            /* Sync Frame ID Acceptance Filter Mask Register */
  FR_NMVR_tag NMVR[6];                 /* Network Management Vector Register */
  FR_NMVLR_tag NMVLR;                  /* Network Management Vector Length Register */
  FR_TICCR_tag TICCR;                  /* Timer Configuration and Control Register */
  FR_TI1CYSR_tag TI1CYSR;              /* Timer 1 Cycle Set Register */
  FR_TI1MTOR_tag TI1MTOR;              /* Timer 1 Macrotick Offset Register */
  FR_TI2CR0_tag TI2CR0;
  FR_TI2CR1_tag TI2CR1;
  FR_SSSR_tag SSSR;                    /* Slot Status Selection Register */
  FR_SSCCR_tag SSCCR;                  /* Slot Status Counter Condition Register */
  FR_SSR_tag SSR[8];                   /* Slot Status Register */
  FR_SSCR_tag SSCR[4];                 /* Slot Status Counter Register */
  FR_MTSACFR_tag MTSACFR;              /* MTS A Configuration Register */
  FR_MTSBCFR_tag MTSBCFR;              /* MTS B Configuration Register */
  FR_RSBIR_tag RSBIR;                  /* Receive Shadow Buffer Index Register */
  FR_RFWMSR_tag RFWMSR;                /* Receive FIFO Watermark and Selection Register */
  FR_RFSIR_tag RFSIR;                  /* Receive FIFO Start Index Register */
  FR_RFDSR_tag RFDSR;                  /* Receive FIFO Depth and Size Register */
  FR_RFARIR_tag RFARIR;                /* Receive FIFO A Read Index Register */
  FR_RFBRIR_tag RFBRIR;                /* Receive FIFO B Read Index Register */
  FR_RFMIDAFVR_tag RFMIDAFVR;          /* Receive FIFO Message ID Acceptance Filter Value Register */
  FR_RFMIDAFMR_tag RFMIDAFMR;          /* Receive FIFO Message ID Acceptance Filter Mask Register */
  FR_RFFIDRFVR_tag RFFIDRFVR;          /* Receive FIFO Frame ID Rejection Filter Value Register */
  FR_RFFIDRFMR_tag RFFIDRFMR;          /* Receive FIFO Frame ID Rejection Filter Mask Register */
  FR_RFRFCFR_tag RFRFCFR;              /* Receive FIFO Range Filter Configuration Register */
  FR_RFRFCTR_tag RFRFCTR;              /* Receive FIFO Range Filter Control Register */
  FR_LDTXSLAR_tag LDTXSLAR;            /* Last Dynamic Transmit Slot Channel A Register */
  FR_LDTXSLBR_tag LDTXSLBR;            /* Last Dynamic Transmit Slot Channel B Register */
  FR_PCR0_tag PCR0;                    /* Protocol Configuration Register 0 */
  FR_PCR1_tag PCR1;                    /* Protocol Configuration Register 1 */
  FR_PCR2_tag PCR2;                    /* Protocol Configuration Register 2 */
  FR_PCR3_tag PCR3;                    /* Protocol Configuration Register 3 */
  FR_PCR4_tag PCR4;                    /* Protocol Configuration Register 4 */
  FR_PCR5_tag PCR5;                    /* Protocol Configuration Register 5 */
  FR_PCR6_tag PCR6;                    /* Protocol Configuration Register 6 */
  FR_PCR7_tag PCR7;                    /* Protocol Configuration Register 7 */
  FR_PCR8_tag PCR8;                    /* Protocol Configuration Register 8 */
  FR_PCR9_tag PCR9;                    /* Protocol Configuration Register 9 */
  FR_PCR10_tag PCR10;                  /* Protocol Configuration Register 10 */
  FR_PCR11_tag PCR11;                  /* Protocol Configuration Register 11 */
  FR_PCR12_tag PCR12;                  /* Protocol Configuration Register 12 */
  FR_PCR13_tag PCR13;                  /* Protocol Configuration Register 13 */
  FR_PCR14_tag PCR14;                  /* Protocol Configuration Register 14 */
  FR_PCR15_tag PCR15;                  /* Protocol Configuration Register 15 */
  FR_PCR16_tag PCR16;                  /* Protocol Configuration Register 16 */
  FR_PCR17_tag PCR17;                  /* Protocol Configuration Register 17 */
  FR_PCR18_tag PCR18;                  /* Protocol Configuration Register 18 */
  FR_PCR19_tag PCR19;                  /* Protocol Configuration Register 19 */
  FR_PCR20_tag PCR20;                  /* Protocol Configuration Register 20 */
  FR_PCR21_tag PCR21;                  /* Protocol Configuration Register 21 */
  FR_PCR22_tag PCR22;                  /* Protocol Configuration Register 22 */
  FR_PCR23_tag PCR23;                  /* Protocol Configuration Register 23 */
  FR_PCR24_tag PCR24;                  /* Protocol Configuration Register 24 */
  FR_PCR25_tag PCR25;                  /* Protocol Configuration Register 25 */
  FR_PCR26_tag PCR26;                  /* Protocol Configuration Register 26 */
  FR_PCR27_tag PCR27;                  /* Protocol Configuration Register 27 */
  FR_PCR28_tag PCR28;                  /* Protocol Configuration Register 28 */
  FR_PCR29_tag PCR29;                  /* Protocol Configuration Register 29 */
  FR_PCR30_tag PCR30;                  /* Protocol Configuration Register 30 */
  uint8_t FR_reserved1[8];
  FR_RFSDOR_tag RFSDOR;                /* Receive FIFO Start Data Offset Register */
  FR_RFSYMBADHR_tag RFSYMBADHR;        /* Receive FIFO System Memory Base Address High Register */
  FR_RFSYMBADLR_tag RFSYMBADLR;        /* Receive FIFO System Memory Base Address Low Register */
  FR_RFPTR_tag RFPTR;                  /* Receive FIFO Periodic Timer Register */
  FR_RFFLPCR_tag RFFLPCR;              /* Receive FIFO Fill Level and POP Count Register */
  FR_EEIFER_tag EEIFER;                /* ECC Error Interrupt Flag and Enable Register */
  FR_EERICR_tag EERICR;                /* ECC Error Report and Injection Control Register */
  FR_EERAR_tag EERAR;                  /* ECC Error Report Address Register */
  FR_EERDR_tag EERDR;                  /* ECC Error Report Data Register */
  FR_EERCR_tag EERCR;                  /* ECC Error Report Code Register */
  FR_EEIAR_tag EEIAR;                  /* ECC Error Injection Address Register */
  FR_EEIDR_tag EEIDR;                  /* ECC Error Injection Data Register */
  FR_EEICR_tag EEICR;                  /* ECC Error Injection Code Register */
  uint8_t FR_reserved2[1792];
  FR_MB_tag MB[128];
  uint8_t FR_reserved3[1024];
  FR_MBDOR_tag MBDOR[132];             /* Message Buffer Data Field Offset Register */
  FR_LEETR_tag LEETR[6];               /* LRAM ECC Error Test Register */
};


/* ============================================================================
   =============================== Module: FlexPWM ============================
   ============================================================================ */

typedef union FlexPWM_SUB_CNT_union_tag { /* Submodule n Counter Register */
  vuint16_t R;
  struct {
    vuint16_t CNT:16;                  /* Count */
  } B;
} FlexPWM_SUB_CNT_tag;

typedef union FlexPWM_SUB_INIT_union_tag { /* Submodule n Initial Count Register */
  vuint16_t R;
  struct {
    vuint16_t INIT:16;                 /* Initial count */
  } B;
} FlexPWM_SUB_INIT_tag;

typedef union FlexPWM_SUB_CTRL2_union_tag { /* Submodule n Control 2 Register */
  vuint16_t R;
  struct {
    vuint16_t DBGEN:1;                 /* Debug Enable */
    vuint16_t _unused_14:1;
    vuint16_t INDEP:1;                 /* Independent or Complementary Pair Operation */
    vuint16_t PWM23_INIT:1;            /* PWM23 Initial Value */
    vuint16_t PWM45_INIT:1;            /* PWM45 Initial Value */
    vuint16_t PWMX_INIT:1;             /* PWMX Initial Value */
    vuint16_t INIT_SEL:2;              /* Initialization Control Select */
    vuint16_t FRCEN:1;                 /* Force Initialization Enable */
    vuint16_t FORCE:1;                 /* Force Initialization */
    vuint16_t FORCE_SEL:3;             /* Force Source Select */
    vuint16_t RELOAD_SEL:1;            /* Reload Source Select */
    vuint16_t CLK_SEL:2;               /* Clock Source Select */
  } B;
} FlexPWM_SUB_CTRL2_tag;

typedef union FlexPWM_SUB_CTRL1_union_tag { /* Submodule n Control 1 Register */
  vuint16_t R;
  struct {
    vuint16_t LDFQ:4;                  /* Load Frequency */
    vuint16_t HALF:1;                  /* Half Cycle Reload */
    vuint16_t FULL:1;                  /* Full Cycle Reload */
    vuint16_t DT:2;                    /* Deadtime */
    vuint16_t _unused_7:1;
    vuint16_t PRSC:3;                  /* Prescaler */
    vuint16_t PHSSHFT:1;               /* Phase Shift Mode Enable */
    vuint16_t LDMOD:1;                 /* Load Mode Select */
    vuint16_t _unused_1:1;
    vuint16_t DBLEN:1;                 /* Double Switching Enable */
  } B;
} FlexPWM_SUB_CTRL1_tag;

typedef union FlexPWM_SUB_VAL0_union_tag { /* Submodule n Value Register 0 */
  vuint16_t R;
  struct {
    vuint16_t VAL0:16;                 /* Value 0 */
  } B;
} FlexPWM_SUB_VAL0_tag;

typedef union FlexPWM_SUB_VAL1_union_tag { /* Submodule n Value Register 1 */
  vuint16_t R;
  struct {
    vuint16_t VAL1:16;                 /* Value 1 */
  } B;
} FlexPWM_SUB_VAL1_tag;

typedef union FlexPWM_SUB_VAL2_union_tag { /* Submodule n Value Register 2 */
  vuint16_t R;
  struct {
    vuint16_t VAL2:16;                 /* Value 2 */
  } B;
} FlexPWM_SUB_VAL2_tag;

typedef union FlexPWM_SUB_VAL3_union_tag { /* Submodule n Value Register 3 */
  vuint16_t R;
  struct {
    vuint16_t VAL3:16;                 /* Value 3 */
  } B;
} FlexPWM_SUB_VAL3_tag;

typedef union FlexPWM_SUB_VAL4_union_tag { /* Submodule n Value Register 4 */
  vuint16_t R;
  struct {
    vuint16_t VAL4:16;
  } B;
} FlexPWM_SUB_VAL4_tag;

typedef union FlexPWM_SUB_VAL5_union_tag { /* Submodule n Value Register 5 */
  vuint16_t R;
  struct {
    vuint16_t VAL5:16;
  } B;
} FlexPWM_SUB_VAL5_tag;

typedef union FlexPWM_SUB_OCTRL_union_tag { /* Submodule n Output Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t _unused_14:1;
    vuint16_t PWMX_IN:1;
    vuint16_t _unused_11:2;
    vuint16_t POLA:1;
    vuint16_t POLB:1;
    vuint16_t POLX:1;
    vuint16_t _unused_6:2;
    vuint16_t PWMAFS:2;                /* PWMA Fault State */
    vuint16_t PWMBFS:2;                /* PWMB Fault State */
    vuint16_t PWMXFS:2;                /* PWMX Fault State */
  } B;
} FlexPWM_SUB_OCTRL_tag;

typedef union FlexPWM_SUB_STS_union_tag { /* Submodule n Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t RUF:1;
    vuint16_t REF:1;
    vuint16_t RF:1;
    vuint16_t _unused_8:4;
    vuint16_t CFX1:1;
    vuint16_t CFX0:1;
    vuint16_t CMPF:6;
  } B;
} FlexPWM_SUB_STS_tag;

typedef union FlexPWM_SUB_INTEN_union_tag { /* Submodule n Interrupt Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_14:2;
    vuint16_t REIE:1;
    vuint16_t RIE:1;
    vuint16_t _unused_8:4;
    vuint16_t CX1IE:1;
    vuint16_t CX0IE:1;
    vuint16_t CMPIE:6;
  } B;
} FlexPWM_SUB_INTEN_tag;

typedef union FlexPWM_SUB_DMAEN_union_tag { /* Submodule n DMA Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_10:6;
    vuint16_t VALDE:1;
    vuint16_t FAND:1;
    vuint16_t CAPTDE:2;
    vuint16_t _unused_2:4;
    vuint16_t CX1DE:1;
    vuint16_t CX0DE:1;
  } B;
} FlexPWM_SUB_DMAEN_tag;

typedef union FlexPWM_SUB_TCTRL_union_tag { /* Submodule n Output Trigger Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_6:10;
    vuint16_t OUT_TRIG_EN:6;
  } B;
} FlexPWM_SUB_TCTRL_tag;

typedef union FlexPWM_SUB_DISMAP_union_tag { /* Submodule n Fault Disable Mapping Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t DISX:4;
    vuint16_t DISB:4;
    vuint16_t DISA:4;
  } B;
} FlexPWM_SUB_DISMAP_tag;

typedef union FlexPWM_SUB_DTCNT0_union_tag { /* Submodule n Deadtime Count Register 0 */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t DTCNT0:11;
  } B;
} FlexPWM_SUB_DTCNT0_tag;

typedef union FlexPWM_SUB_DTCNT1_union_tag { /* Submodule n Deadtime Count Register 1 */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t DTCNT1:11;
  } B;
} FlexPWM_SUB_DTCNT1_tag;

typedef union FlexPWM_SUB_CAPTCTRLX_union_tag { /* Submodule n Capture Control X Register */
  vuint16_t R;
  struct {
    vuint16_t CX1CNT:3;
    vuint16_t CX0CNT:3;
    vuint16_t CFXWM:2;                 /* Capture X FIFOs Watermark */
    vuint16_t EDGCNTX_EN:1;
    vuint16_t INPSELX:1;
    vuint16_t EDGX1:2;
    vuint16_t EDGX0:2;
    vuint16_t ONESHOTX:1;
    vuint16_t ARMX:1;
  } B;
} FlexPWM_SUB_CAPTCTRLX_tag;

typedef union FlexPWM_SUB_CAPTCMPX_union_tag { /* Submodule n Capture Compare X Register */
  vuint16_t R;
  struct {
    vuint16_t EDGCNTX:8;
    vuint16_t EDGCMPX:8;
  } B;
} FlexPWM_SUB_CAPTCMPX_tag;

typedef union FlexPWM_SUB_CVAL0_union_tag { /* Submodule n Capture Value 0 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL0:16;
  } B;
} FlexPWM_SUB_CVAL0_tag;

typedef union FlexPWM_SUB_CVAL0CYC_union_tag { /* Submodule n Capture Value 0 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_3:13;
    vuint16_t CVAL0CYC:3;              /* CVAL0 Cycle */
  } B;
} FlexPWM_SUB_CVAL0CYC_tag;

typedef union FlexPWM_SUB_CVAL1_union_tag { /* Submodule n Capture Value 1 Register */
  vuint16_t R;
  struct {
    vuint16_t CAPTVAL1:16;
  } B;
} FlexPWM_SUB_CVAL1_tag;

typedef union FlexPWM_SUB_CVAL1CYC_union_tag { /* Submodule n Capture Value 1 Cycle Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_3:13;
    vuint16_t CVAL1CYC:3;              /* CVAL1 Cycle */
  } B;
} FlexPWM_SUB_CVAL1CYC_tag;

typedef struct FlexPWM_SUB_struct_tag {
  FlexPWM_SUB_CNT_tag CNT;             /* Submodule n Counter Register */
  FlexPWM_SUB_INIT_tag INIT;           /* Submodule n Initial Count Register */
  FlexPWM_SUB_CTRL2_tag CTRL2;         /* Submodule n Control 2 Register */
  FlexPWM_SUB_CTRL1_tag CTRL1;         /* Submodule n Control 1 Register */
  FlexPWM_SUB_VAL0_tag VAL0;           /* Submodule n Value Register 0 */
  FlexPWM_SUB_VAL1_tag VAL1;           /* Submodule n Value Register 1 */
  FlexPWM_SUB_VAL2_tag VAL2;           /* Submodule n Value Register 2 */
  FlexPWM_SUB_VAL3_tag VAL3;           /* Submodule n Value Register 3 */
  FlexPWM_SUB_VAL4_tag VAL4;           /* Submodule n Value Register 4 */
  FlexPWM_SUB_VAL5_tag VAL5;           /* Submodule n Value Register 5 */
  uint8_t SUB_reserved0[4];
  FlexPWM_SUB_OCTRL_tag OCTRL;         /* Submodule n Output Control Register */
  FlexPWM_SUB_STS_tag STS;             /* Submodule n Status Register */
  FlexPWM_SUB_INTEN_tag INTEN;         /* Submodule n Interrupt Enable Register */
  FlexPWM_SUB_DMAEN_tag DMAEN;         /* Submodule n DMA Enable Register */
  FlexPWM_SUB_TCTRL_tag TCTRL;         /* Submodule n Output Trigger Control Register */
  FlexPWM_SUB_DISMAP_tag DISMAP;       /* Submodule n Fault Disable Mapping Register */
  FlexPWM_SUB_DTCNT0_tag DTCNT0;       /* Submodule n Deadtime Count Register 0 */
  FlexPWM_SUB_DTCNT1_tag DTCNT1;       /* Submodule n Deadtime Count Register 1 */
  uint8_t SUB_reserved1[8];
  FlexPWM_SUB_CAPTCTRLX_tag CAPTCTRLX; /* Submodule n Capture Control X Register */
  FlexPWM_SUB_CAPTCMPX_tag CAPTCMPX;   /* Submodule n Capture Compare X Register */
  FlexPWM_SUB_CVAL0_tag CVAL0;         /* Submodule n Capture Value 0 Register */
  FlexPWM_SUB_CVAL0CYC_tag CVAL0CYC;   /* Submodule n Capture Value 0 Cycle Register */
  FlexPWM_SUB_CVAL1_tag CVAL1;         /* Submodule n Capture Value 1 Register */
  FlexPWM_SUB_CVAL1CYC_tag CVAL1CYC;   /* Submodule n Capture Value 1 Cycle Register */
  uint8_t SUB_reserved2[20];
} FlexPWM_SUB_tag;

typedef union FlexPWM_OUTEN_union_tag { /* Output Enable Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_12:4;
    vuint16_t PWMA_EN:4;
    vuint16_t PWMB_EN:4;
    vuint16_t PWMX_EN:4;
  } B;
} FlexPWM_OUTEN_tag;

typedef union FlexPWM_MASK_union_tag { /* Mask Register */
  vuint16_t R;
  struct {
    vuint16_t UPDATE_MASK:4;           /* Update Mask */
    vuint16_t MASKA:4;
    vuint16_t MASKB:4;
    vuint16_t MASKX:4;
  } B;
} FlexPWM_MASK_tag;

typedef union FlexPWM_SWCOUT_union_tag { /* Software Controlled Output Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_8:8;
    vuint16_t OUT23_3:1;
    vuint16_t OUT45_3:1;
    vuint16_t OUT23_2:1;
    vuint16_t OUT45_2:1;
    vuint16_t OUT23_1:1;
    vuint16_t OUT45_1:1;
    vuint16_t OUT23_0:1;
    vuint16_t OUT45_0:1;
  } B;
} FlexPWM_SWCOUT_tag;

typedef union FlexPWM_DTSRCSEL_union_tag { /* Deadtime Source Select Register */
  vuint16_t R;
  struct {
    vuint16_t SEL23_3:2;
    vuint16_t SEL45_3:2;
    vuint16_t SEL23_2:2;
    vuint16_t SEL45_2:2;
    vuint16_t SEL23_1:2;
    vuint16_t SEL45_1:2;
    vuint16_t SEL23_0:2;
    vuint16_t SEL45_0:2;
  } B;
} FlexPWM_DTSRCSEL_tag;

typedef union FlexPWM_MCTRL_union_tag { /* Master Control Register */
  vuint16_t R;
  struct {
    vuint16_t IPOL:4;                  /* Current Polarity */
    vuint16_t RUN:4;                   /* Run */
    vuint16_t CLDOK:4;                 /* Clear Load Okay */
    vuint16_t LDOK:4;                  /* Load Okay */
  } B;
} FlexPWM_MCTRL_tag;

typedef union FlexPWM_FCTRL_union_tag { /* Fault Control Register */
  vuint16_t R;
  struct {
    vuint16_t FLVL:4;
    vuint16_t FAUTO:4;
    vuint16_t FSAFE:4;
    vuint16_t FIE:4;
  } B;
} FlexPWM_FCTRL_tag;

typedef union FlexPWM_FSTS_union_tag { /* Fault Status Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_13:3;
    vuint16_t FTEST:1;
    vuint16_t FFPIN:4;
    vuint16_t FFULL:4;
    vuint16_t FFLAG:4;
  } B;
} FlexPWM_FSTS_tag;

typedef union FlexPWM_FFILT_union_tag { /* Fault Filter Register */
  vuint16_t R;
  struct {
    vuint16_t GSTR:1;
    vuint16_t _unused_11:4;
    vuint16_t FILT_CNT:3;
    vuint16_t FILT_PER:8;
  } B;
} FlexPWM_FFILT_tag;

struct FlexPWM_tag {
  FlexPWM_SUB_tag SUB[4];
  FlexPWM_OUTEN_tag OUTEN;             /* Output Enable Register */
  FlexPWM_MASK_tag MASK;               /* Mask Register */
  FlexPWM_SWCOUT_tag SWCOUT;           /* Software Controlled Output Register */
  FlexPWM_DTSRCSEL_tag DTSRCSEL;       /* Deadtime Source Select Register */
  FlexPWM_MCTRL_tag MCTRL;             /* Master Control Register */
  uint8_t FlexPWM_reserved0[2];
  FlexPWM_FCTRL_tag FCTRL;             /* Fault Control Register */
  FlexPWM_FSTS_tag FSTS;               /* Fault Status Register */
  FlexPWM_FFILT_tag FFILT;             /* Fault Filter Register */
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

typedef union I2C_IBAD_union_tag {     /* I2C Bus Address Register */
  vuint8_t R;
  struct {
    vuint8_t ADR:7;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBAD_tag;

typedef union I2C_IBFD_union_tag {     /* I2C Bus Frequency Divider Register */
  vuint8_t R;
  struct {
    vuint8_t IBC:8;
  } B;
} I2C_IBFD_tag;

typedef union I2C_IBCR_union_tag {     /* I2C Bus Control Register */
  vuint8_t R;
  struct {
    vuint8_t MDIS:1;
    vuint8_t IBIE:1;
    vuint8_t MSSL:1;
    vuint8_t TXRX:1;
    vuint8_t NOACK:1;
    vuint8_t RSTA:1;
    vuint8_t DMAEN:1;
    vuint8_t _unused_0:1;
  } B;
} I2C_IBCR_tag;

typedef union I2C_IBSR_union_tag {     /* I2C Bus Status Register */
  vuint8_t R;
  struct {
    vuint8_t TCF:1;
    vuint8_t IAAS:1;
    vuint8_t IBB:1;
    vuint8_t IBAL:1;
    vuint8_t _unused_3:1;
    vuint8_t SRW:1;
    vuint8_t IBIF:1;
    vuint8_t RXAK:1;
  } B;
} I2C_IBSR_tag;

typedef union I2C_IBDR_union_tag {     /* I2C Bus Data I/O Register */
  vuint8_t R;
  struct {
    vuint8_t DATA:8;
  } B;
} I2C_IBDR_tag;

typedef union I2C_IBIC_union_tag {     /* I2C Bus Interrupt Config Register */
  vuint8_t R;
  struct {
    vuint8_t BIIE:1;
    vuint8_t _unused_6:1;
    vuint8_t _unused_0:6;
  } B;
} I2C_IBIC_tag;

typedef union I2C_IBDBG_union_tag {    /* I2C Bus Debug Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_2:6;
    vuint8_t IPG_DEBUG_HALTED:1;
    vuint8_t IPG_DEBUG_EN:1;
  } B;
} I2C_IBDBG_tag;

struct I2C_tag {
  I2C_IBAD_tag IBAD;                   /* I2C Bus Address Register */
  I2C_IBFD_tag IBFD;                   /* I2C Bus Frequency Divider Register */
  I2C_IBCR_tag IBCR;                   /* I2C Bus Control Register */
  I2C_IBSR_tag IBSR;                   /* I2C Bus Status Register */
  I2C_IBDR_tag IBDR;                   /* I2C Bus Data I/O Register */
  I2C_IBIC_tag IBIC;                   /* I2C Bus Interrupt Config Register */
  I2C_IBDBG_tag IBDBG;                 /* I2C Bus Debug Register */
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

typedef union INTC_BCR_union_tag {     /* INTC Block Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t _unused_12:1;
    vuint32_t _unused_9:3;
    vuint32_t HVEN2:1;
    vuint32_t _unused_5:3;
    vuint32_t HVEN1:1;
    vuint32_t _unused_1:3;
    vuint32_t HVEN0:1;
  } B;
} INTC_BCR_tag;

typedef union INTC_CPR_union_tag {     /* INTC Current Priority Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t PRI:5;
  } B;
} INTC_CPR_tag;

typedef union INTC_IACKR_union_tag {   /* INTC Interrupt Acknowledge Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t VTBA:20;
    vuint32_t INTVEC:10;
    vuint32_t _unused_0:2;
  } B;
} INTC_IACKR_tag;

typedef union INTC_EOIR_union_tag {    /* INTC End Of Interrupt Register for Processor 0 */
  vuint32_t R;
  struct {
    vuint32_t EOI:32;
  } B;
} INTC_EOIR_tag;

typedef union INTC_SSCIR_union_tag {   /* INTC Software Set/Clear Interrupt Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_2:6;
    vuint8_t SET:1;
    vuint8_t CLR:1;
  } B;
} INTC_SSCIR_tag;

typedef union INTC_PSR_union_tag {     /* INTC Priority Select Register */
  vuint16_t R;
  struct {
    vuint16_t PRC_SELN0:1;
    vuint16_t PRC_SELN1:1;
    vuint16_t PRC_SELN2:1;
    vuint16_t _unused_12:1;
    vuint16_t _unused_9:3;
    vuint16_t SWTN:1;
    vuint16_t _unused_5:3;
    vuint16_t PRIN:5;
  } B;
} INTC_PSR_tag;

typedef union INTC_CHANNEL_MMRC_union_tag { /* INTC Monitor Mode Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t MM:2;
  } B;
} INTC_CHANNEL_MMRC_tag;

typedef union INTC_CHANNEL_HIPRIC_union_tag { /* INTC HIPRI Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t IRQ:10;
  } B;
} INTC_CHANNEL_HIPRIC_tag;

typedef union INTC_CHANNEL_LATC_union_tag { /* INTC LAT Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t LAT:24;
  } B;
} INTC_CHANNEL_LATC_tag;

typedef union INTC_CHANNEL_TIMERC_union_tag { /* INTC Timer Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t TIMER:24;
  } B;
} INTC_CHANNEL_TIMERC_tag;

typedef struct INTC_CHANNEL_struct_tag {
  INTC_CHANNEL_MMRC_tag MMRC;          /* INTC Monitor Mode Register 0 */
  INTC_CHANNEL_HIPRIC_tag HIPRIC[3];   /* INTC HIPRI Register */
  uint8_t CHANNEL_reserved0[4];
  INTC_CHANNEL_LATC_tag LATC[3];       /* INTC LAT Register */
  uint8_t CHANNEL_reserved1[4];
  INTC_CHANNEL_TIMERC_tag TIMERC[3];   /* INTC Timer Register */
  uint8_t CHANNEL_reserved2[4];
} INTC_CHANNEL_tag;

struct INTC_tag {
  INTC_BCR_tag BCR;                    /* INTC Block Configuration Register */
  uint8_t INTC_reserved0[12];
  INTC_CPR_tag CPR[3];                 /* INTC Current Priority Register for Processor 0 */
  uint8_t INTC_reserved1[4];
  INTC_IACKR_tag IACKR[3];             /* INTC Interrupt Acknowledge Register for Processor 0 */
  uint8_t INTC_reserved2[4];
  INTC_EOIR_tag EOIR[3];               /* INTC End Of Interrupt Register for Processor 0 */
  uint8_t INTC_reserved3[4];
  INTC_SSCIR_tag SSCIR[16];            /* INTC Software Set/Clear Interrupt Register */
  uint8_t INTC_reserved4[16];
  INTC_PSR_tag PSR[1024];              /* INTC Priority Select Register */
  uint8_t INTC_reserved5[1952];
  INTC_CHANNEL_tag CHANNEL[3];
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

typedef union IRCOSC_CTL_union_tag {   /* IRCOSC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t _unused_21:3;
    vuint32_t USER_TRIM:5;
    vuint32_t _unused_13:3;
    vuint32_t _unused_8:5;
    vuint32_t _unused_6:2;
    vuint32_t _unused_5:1;
    vuint32_t _unused_0:5;
  } B;
} IRCOSC_CTL_tag;

struct IRCOSC_tag {
  IRCOSC_CTL_tag CTL;                  /* IRCOSC Control Register */
};


/* ============================================================================
   =============================== Module: JTAGM ==============================
   ============================================================================ */

typedef union JTAGM_MCR_union_tag {    /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t SWRESET:1;
    vuint32_t _unused_14:17;
    vuint32_t inter_jtag_frame_timer:6;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t IIE:1;
    vuint32_t TCKSEL:3;
    vuint32_t jtagm_JCOMP:1;
    vuint32_t DTM:1;
  } B;
} JTAGM_MCR_tag;

typedef union JTAGM_SR_union_tag {     /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_30:1;
    vuint32_t _unused_24:6;
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t JTAGEN:1;
    vuint32_t _unused_20:1;
    vuint32_t JTAGSAFE:1;
    vuint32_t _unused_18:1;
    vuint32_t _unused_17:1;
    vuint32_t TOOL:1;
    vuint32_t _unused_14:2;
    vuint32_t _unused_13:1;
    vuint32_t _unused_12:1;
    vuint32_t _unused_11:1;
    vuint32_t Nexus_err:1;
    vuint32_t Idle:1;
    vuint32_t NR:1;
    vuint32_t _unused_0:8;
  } B;
} JTAGM_SR_tag;

typedef union JTAGM_DOR0_union_tag {   /* Data Out Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TMS_HIGH:32;
  } B;
} JTAGM_DOR0_tag;

typedef union JTAGM_DOR1_union_tag {   /* Data Out Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TMS_LOW:28;
    vuint32_t _unused_0:4;
  } B;
} JTAGM_DOR1_tag;

typedef union JTAGM_DOR2_union_tag {   /* Data Out Register 2 */
  vuint32_t R;
  struct {
    vuint32_t TDI_HIGH:32;
  } B;
} JTAGM_DOR2_tag;

typedef union JTAGM_DOR3_union_tag {   /* Data Out Register 3 */
  vuint32_t R;
  struct {
    vuint32_t TDI_LOW:28;
    vuint32_t _unused_1:3;
    vuint32_t Send:1;
  } B;
} JTAGM_DOR3_tag;

typedef union JTAGM_DIR0_union_tag {   /* Data Input Register 0 */
  vuint32_t R;
  struct {
    vuint32_t TDO_LOW:32;
  } B;
} JTAGM_DIR0_tag;

typedef union JTAGM_DIR1_union_tag {   /* Data Input Register 1 */
  vuint32_t R;
  struct {
    vuint32_t TDO_HIGH:28;
    vuint32_t _unused_0:4;
  } B;
} JTAGM_DIR1_tag;

struct JTAGM_tag {
  JTAGM_MCR_tag MCR;                   /* Module Configuration Register */
  JTAGM_SR_tag SR;                     /* Status Register */
  JTAGM_DOR0_tag DOR0;                 /* Data Out Register 0 */
  JTAGM_DOR1_tag DOR1;                 /* Data Out Register 1 */
  JTAGM_DOR2_tag DOR2;                 /* Data Out Register 2 */
  JTAGM_DOR3_tag DOR3;                 /* Data Out Register 3 */
  uint8_t JTAGM_reserved0[4];
  JTAGM_DIR0_tag DIR0;                 /* Data Input Register 0 */
  JTAGM_DIR1_tag DIR1;                 /* Data Input Register 1 */
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

typedef union LFAST_MCR_union_tag {    /* LFAST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSEN:1;
    vuint32_t _unused_25:6;
    vuint32_t IPGDBG:1;
    vuint32_t _unused_17:7;
    vuint32_t LSSEL:1;
    vuint32_t DRFEN:1;
    vuint32_t RXEN:1;
    vuint32_t TXEN:1;
    vuint32_t _unused_5:8;
    vuint32_t TXARBD:1;
    vuint32_t CTSEN:1;
    vuint32_t _unused_2:1;
    vuint32_t DRFRST:1;
    vuint32_t DATAEN:1;
  } B;
} LFAST_MCR_tag;

typedef union LFAST_SCR_union_tag {    /* LFAST Speed Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t DRMD:1;
    vuint32_t _unused_9:7;
    vuint32_t RDR:1;
    vuint32_t _unused_1:7;
    vuint32_t TDR:1;
  } B;
} LFAST_SCR_tag;

typedef union LFAST_COCR_union_tag {   /* LFAST Correlator Control Register */
  vuint32_t R;
  struct {
    vuint32_t SMPSEL:8;
    vuint32_t _unused_18:6;
    vuint32_t _unused_16:2;
    vuint32_t _unused_4:12;
    vuint32_t CORRTH:3;
    vuint32_t PHSSEL:1;
  } B;
} LFAST_COCR_tag;

typedef union LFAST_TMCR_union_tag {   /* LFAST Test Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t CLKTST:1;
    vuint32_t LPON:1;
    vuint32_t _unused_19:5;
    vuint32_t LPMOD:3;
    vuint32_t LPFRMTH:16;
  } B;
} LFAST_TMCR_tag;

typedef union LFAST_ALCR_union_tag {   /* LFAST Auto Loopback Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t LPCNTEN:1;
    vuint32_t LPFMCNT:16;
  } B;
} LFAST_ALCR_tag;

typedef union LFAST_RCDCR_union_tag {  /* LFAST Rate Change Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t DRCNT:4;
    vuint32_t _unused_0:16;
  } B;
} LFAST_RCDCR_tag;

typedef union LFAST_SLCR_union_tag {   /* LFAST Wakeup Delay Control Register */
  vuint32_t R;
  struct {
    vuint32_t HSCNT:8;
    vuint32_t _unused_20:4;
    vuint32_t LSCNT:4;
    vuint32_t HWKCNT:8;
    vuint32_t _unused_4:4;
    vuint32_t LWKCNT:4;
  } B;
} LFAST_SLCR_tag;

typedef union LFAST_ICR_union_tag {    /* LFAST ICLC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t ICLCSEQ:1;
    vuint32_t SNDICLC:1;
    vuint32_t _unused_8:8;
    vuint32_t ICLCPLD:8;
  } B;
} LFAST_ICR_tag;

typedef union LFAST_PICR_union_tag {   /* LFAST Ping Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t PNGREQ:1;
    vuint32_t PNGAUTO:1;
    vuint32_t _unused_8:7;
    vuint32_t PNGPYLD:8;
  } B;
} LFAST_PICR_tag;

typedef union LFAST_RFCR_union_tag {   /* LFAST Rx FIFO CTS Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t RCTSMX:6;
    vuint32_t _unused_6:10;
    vuint32_t RCTSMN:6;
  } B;
} LFAST_RFCR_tag;

typedef union LFAST_TIER_union_tag {   /* LFAST Tx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t TXIIE:1;
    vuint32_t TXOVIE:1;
    vuint32_t _unused_5:11;
    vuint32_t TXPNGIE:1;
    vuint32_t _unused_3:1;
    vuint32_t TXUNSIE:1;
    vuint32_t TXICLCIE:1;
    vuint32_t TXDTIE:1;
  } B;
} LFAST_TIER_tag;

typedef union LFAST_RIER_union_tag {   /* LFAST Rx Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t RXUOIE:1;
    vuint32_t RXMNIE:1;
    vuint32_t RXMXIE:1;
    vuint32_t RXUFIE:1;
    vuint32_t RXOFIE:1;
    vuint32_t RXSZIE:1;
    vuint32_t RXICIE:1;
    vuint32_t RXLCEIE:1;
    vuint32_t _unused_4:12;
    vuint32_t RXCTSIE:1;
    vuint32_t RXDIE:1;
    vuint32_t RXUNSIE:1;
    vuint32_t _unused_0:1;
  } B;
} LFAST_RIER_tag;

typedef union LFAST_RIIER_union_tag {  /* LFAST Rx ICLC Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t ICPFIE:1;
    vuint32_t ICPSIE:1;
    vuint32_t ICPRIE:1;
    vuint32_t ICTOIE:1;
    vuint32_t ICLPIE:1;
    vuint32_t ICCTIE:1;
    vuint32_t ICTDIE:1;
    vuint32_t ICTEIE:1;
    vuint32_t ICRFIE:1;
    vuint32_t ICRSIE:1;
    vuint32_t ICTFIE:1;
    vuint32_t ICTSIE:1;
    vuint32_t ICPOFIE:1;
    vuint32_t ICPONIE:1;
  } B;
} LFAST_RIIER_tag;

typedef union LFAST_PLLCR_union_tag {  /* LFAST PLL Control Register */
  vuint32_t R;
  struct {
    vuint32_t IPTMOD:3;
    vuint32_t _unused_18:11;
    vuint32_t SWPOFF:1;
    vuint32_t SWPON:1;
    vuint32_t REFINV:1;
    vuint32_t LPCFG:2;
    vuint32_t _unused_11:2;
    vuint32_t PLCKCW:2;
    vuint32_t FDIVEN:1;
    vuint32_t FBDIV:6;
    vuint32_t PREDIV:2;
  } B;
} LFAST_PLLCR_tag;

typedef union LFAST_LCR_union_tag {    /* LFAST LVDS Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t SWWKLD:1;
    vuint32_t SWSLPLD:1;
    vuint32_t SWWKLR:1;
    vuint32_t SWSLPLR:1;
    vuint32_t SWOFFLD:1;
    vuint32_t SWONLD:1;
    vuint32_t SWOFFLR:1;
    vuint32_t SWONLR:1;
    vuint32_t LVRXOFF:1;
    vuint32_t LVTXOE:1;
    vuint32_t TXCMUX:1;
    vuint32_t LVRFEN:1;
    vuint32_t LVLPEN:1;                /* Tx LVDS internal loopback enable */
    vuint32_t _unused_6:5;
    vuint32_t LVRXOP_TR:1;
    vuint32_t _unused_4:1;
    vuint32_t LVRXOP_BR:1;
    vuint32_t _unused_2:1;
    vuint32_t LVCKSS:1;                /* LVDS Clock Sync Select */
    vuint32_t LVCKP:1;
  } B;
} LFAST_LCR_tag;

typedef union LFAST_UNSTCR_union_tag { /* LFAST Unsolicited Tx Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t USNDRQ:1;
    vuint32_t _unused_7:9;
    vuint32_t UNSHDR:7;
  } B;
} LFAST_UNSTCR_tag;

typedef union LFAST_UNSTDR_union_tag { /* LFAST Unsolicited Tx Data Registers */
  vuint32_t R;
  struct {
    vuint32_t UNTXD:32;
  } B;
} LFAST_UNSTDR_tag;

typedef union LFAST_GSR_union_tag {    /* LFAST Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t DUALMD:1;
    vuint32_t _unused_19:12;
    vuint32_t LRMD:1;
    vuint32_t LDSM:1;
    vuint32_t DRSM:1;
    vuint32_t _unused_5:11;
    vuint32_t LPTXDN:1;
    vuint32_t LPFPDV:1;
    vuint32_t LPCPDV:1;
    vuint32_t LPCHDV:1;
    vuint32_t LPCSDV:1;
  } B;
} LFAST_GSR_tag;

typedef union LFAST_PISR_union_tag {   /* LFAST Ping Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RXPNGD:8;
  } B;
} LFAST_PISR_tag;

typedef union LFAST_DFSR_union_tag {   /* LFAST Data Frame Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t RXDCNT:6;
    vuint32_t _unused_19:5;
    vuint32_t RXFCNT:3;
    vuint32_t _unused_14:2;
    vuint32_t TXDCNT:6;
    vuint32_t _unused_3:5;
    vuint32_t TXFCNT:3;
  } B;
} LFAST_DFSR_tag;

typedef union LFAST_TISR_union_tag {   /* LFAST Tx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t TXIEF:1;
    vuint32_t TXOVF:1;
    vuint32_t _unused_5:11;
    vuint32_t TXPNGF:1;
    vuint32_t _unused_3:1;
    vuint32_t TXUNSF:1;
    vuint32_t TXICLCF:1;
    vuint32_t TXDTF:1;
  } B;
} LFAST_TISR_tag;

typedef union LFAST_RISR_union_tag {   /* LFAST Rx Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t RXUOF:1;
    vuint32_t RXMNF:1;
    vuint32_t RXMXF:1;
    vuint32_t RXUFF:1;
    vuint32_t RXOFF:1;
    vuint32_t RXSZF:1;
    vuint32_t RXICF:1;
    vuint32_t RXLCEF:1;
    vuint32_t _unused_4:12;
    vuint32_t RXCTSF:1;
    vuint32_t RXDF:1;
    vuint32_t RXUNSF:1;
    vuint32_t _unused_0:1;
  } B;
} LFAST_RISR_tag;

typedef union LFAST_RIISR_union_tag {  /* LFAST Rx ICLC Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t ICPFF:1;
    vuint32_t ICPSF:1;
    vuint32_t ICPRF:1;
    vuint32_t ICTOF:1;
    vuint32_t ICLPF:1;
    vuint32_t ICCTF:1;
    vuint32_t ICTDF:1;
    vuint32_t ICTEF:1;
    vuint32_t ICRFF:1;
    vuint32_t ICRSF:1;
    vuint32_t ICTFF:1;
    vuint32_t ICTSF:1;
    vuint32_t ICPOFF:1;
    vuint32_t ICPONF:1;
  } B;
} LFAST_RIISR_tag;

typedef union LFAST_PLLLSR_union_tag { /* LFAST PLL and LVDS Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t PLLDIS:1;
    vuint32_t PLDCR:1;
    vuint32_t _unused_4:12;
    vuint32_t LRSLPS:1;
    vuint32_t LDSLPS:1;
    vuint32_t LDPDS:1;
    vuint32_t LRPDS:1;
  } B;
} LFAST_PLLLSR_tag;

typedef union LFAST_UNSRSR_union_tag { /* LFAST Unsolicited Rx Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t URXDV:1;
    vuint32_t _unused_3:5;
    vuint32_t URPCNT:3;
  } B;
} LFAST_UNSRSR_tag;

typedef union LFAST_UNSRDR_union_tag { /* LFAST Unsolicited Rx Data Register */
  vuint32_t R;
  struct {
    vuint32_t UNRXD:32;
  } B;
} LFAST_UNSRDR_tag;

struct LFAST_tag {
  LFAST_MCR_tag MCR;                   /* LFAST Mode Configuration Register */
  LFAST_SCR_tag SCR;                   /* LFAST Speed Control Register */
  LFAST_COCR_tag COCR;                 /* LFAST Correlator Control Register */
  LFAST_TMCR_tag TMCR;                 /* LFAST Test Mode Control Register */
  LFAST_ALCR_tag ALCR;                 /* LFAST Auto Loopback Control Register */
  LFAST_RCDCR_tag RCDCR;               /* LFAST Rate Change Delay Control Register */
  LFAST_SLCR_tag SLCR;                 /* LFAST Wakeup Delay Control Register */
  LFAST_ICR_tag ICR;                   /* LFAST ICLC Control Register */
  LFAST_PICR_tag PICR;                 /* LFAST Ping Control Register */
  uint8_t LFAST_reserved0[8];
  LFAST_RFCR_tag RFCR;                 /* LFAST Rx FIFO CTS Control Register */
  LFAST_TIER_tag TIER;                 /* LFAST Tx Interrupt Enable Register */
  LFAST_RIER_tag RIER;                 /* LFAST Rx Interrupt Enable Register */
  LFAST_RIIER_tag RIIER;               /* LFAST Rx ICLC Interrupt Enable Register */
  LFAST_PLLCR_tag PLLCR;               /* LFAST PLL Control Register */
  LFAST_LCR_tag LCR;                   /* LFAST LVDS Control Register */
  LFAST_UNSTCR_tag UNSTCR;             /* LFAST Unsolicited Tx Control Register */
  LFAST_UNSTDR_tag UNSTDR[9];          /* LFAST Unsolicited Tx Data Registers */
  uint8_t LFAST_reserved1[20];
  LFAST_GSR_tag GSR;                   /* LFAST Global Status Register */
  LFAST_PISR_tag PISR;                 /* LFAST Ping Status Register */
  uint8_t LFAST_reserved2[12];
  LFAST_DFSR_tag DFSR;                 /* LFAST Data Frame Status Register */
  LFAST_TISR_tag TISR;                 /* LFAST Tx Interrupt Status Register */
  LFAST_RISR_tag RISR;                 /* LFAST Rx Interrupt Status Register */
  LFAST_RIISR_tag RIISR;               /* LFAST Rx ICLC Interrupt Status Register */
  LFAST_PLLLSR_tag PLLLSR;             /* LFAST PLL and LVDS Status Register */
  LFAST_UNSRSR_tag UNSRSR;             /* LFAST Unsolicited Rx Status Register */
  LFAST_UNSRDR_tag UNSRDR[9];          /* LFAST Unsolicited Rx Data Register */
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

typedef union LINFlexD_LINCR1_union_tag { /* LIN Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CCD:1;
    vuint32_t CFD:1;
    vuint32_t LASE:1;
    vuint32_t AUTOWU:1;
    vuint32_t MBL:4;
    vuint32_t BF:1;
    vuint32_t _unused_6:1;
    vuint32_t LBKM:1;
    vuint32_t MME:1;
    vuint32_t SSBL:1;
    vuint32_t RBLM:1;
    vuint32_t SLEEP:1;
    vuint32_t INIT:1;
  } B;
} LINFlexD_LINCR1_tag;

typedef union LINFlexD_LINIER_union_tag { /* LIN Interrupt enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZIE:1;
    vuint32_t OCIE:1;
    vuint32_t BEIE:1;
    vuint32_t CEIE:1;
    vuint32_t HEIE:1;
    vuint32_t _unused_9:2;
    vuint32_t FEIE:1;
    vuint32_t BOIE:1;
    vuint32_t LSIE:1;
    vuint32_t WUIE:1;
    vuint32_t DBFIE:1;
    vuint32_t DBEIETOIE:1;
    vuint32_t DRIE:1;
    vuint32_t DTIE:1;
    vuint32_t HRIE:1;
  } B;
} LINFlexD_LINIER_tag;

typedef union LINFlexD_LINSR_union_tag { /* LIN Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t AUTOSYNC_COMP:1;
    vuint32_t RDC:3;
    vuint32_t LINS:4;                  /* LIN state */
    vuint32_t _unused_10:2;
    vuint32_t RMB:1;
    vuint32_t DRBNE:1;
    vuint32_t RXbusy:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t DBFF:1;
    vuint32_t DBEF:1;
    vuint32_t DRF:1;
    vuint32_t DTF:1;
    vuint32_t HRF:1;
  } B;
} LINFlexD_LINSR_tag;

typedef union LINFlexD_LINESR_union_tag { /* LIN Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t BEF:1;
    vuint32_t CEF:1;
    vuint32_t SFEF:1;
    vuint32_t SDEF:1;
    vuint32_t IDPEF:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t _unused_1:6;
    vuint32_t NF:1;
  } B;
} LINFlexD_LINESR_tag;

typedef union LINFlexD_UARTCR_union_tag { /* UART Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_23:8;
    vuint32_t NEF:3;
    vuint32_t DTU_PCETX:1;             /* Disable Timeout in UART mode */
    vuint32_t SBUR:2;
    vuint32_t WLS:1;
    vuint32_t TDFL_TFC:3;
    vuint32_t RDFL_RFC:3;
    vuint32_t RFBM:1;
    vuint32_t TFBM:1;
    vuint32_t WL1:1;
    vuint32_t PC1:1;
    vuint32_t RxEn:1;
    vuint32_t TxEn:1;
    vuint32_t PC0:1;
    vuint32_t PCE:1;
    vuint32_t WL0:1;
    vuint32_t UART:1;
  } B;
} LINFlexD_UARTCR_tag;

typedef union LINFlexD_UARTSR_union_tag { /* UART Mode Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SZF:1;
    vuint32_t OCF:1;
    vuint32_t PE:4;
    vuint32_t RMB:1;
    vuint32_t FEF:1;
    vuint32_t BOF:1;
    vuint32_t RDI:1;
    vuint32_t WUF:1;
    vuint32_t RFNE:1;
    vuint32_t TO:1;
    vuint32_t DRFRFE:1;
    vuint32_t DTFTFF:1;
    vuint32_t NF:1;
  } B;
} LINFlexD_UARTSR_tag;

typedef union LINFlexD_LINTCSR_union_tag { /* LIN Time-Out Control Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t MODE:1;
    vuint32_t IOT:1;
    vuint32_t TOCE:1;
    vuint32_t CNT:8;
  } B;
} LINFlexD_LINTCSR_tag;

typedef union LINFlexD_LINOCR_union_tag { /* LIN Output Compare Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t OC2:8;
    vuint32_t OC1:8;
  } B;
} LINFlexD_LINOCR_tag;

typedef union LINFlexD_LINTOCR_union_tag { /* LIN Time-Out Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t RTO:4;
    vuint32_t _unused_7:1;
    vuint32_t HTO:7;
  } B;
} LINFlexD_LINTOCR_tag;

typedef union LINFlexD_LINFBRR_union_tag { /* LIN Fractional Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t FBR:4;
  } B;
} LINFlexD_LINFBRR_tag;

typedef union LINFlexD_LINIBRR_union_tag { /* LIN Integer Baud Rate Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t IBR:20;
  } B;
} LINFlexD_LINIBRR_tag;

typedef union LINFlexD_LINCFR_union_tag { /* LIN Checksum Field Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CF:8;
  } B;
} LINFlexD_LINCFR_tag;

typedef union LINFlexD_LINCR2_union_tag { /* LIN Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TBDE:1;
    vuint32_t IOBE:1;
    vuint32_t IOPE:1;
    vuint32_t WURQ:1;
    vuint32_t DDRQ:1;
    vuint32_t DTRQ:1;
    vuint32_t ABRQ:1;
    vuint32_t HTRQ:1;
    vuint32_t _unused_0:8;
  } B;
} LINFlexD_LINCR2_tag;

typedef union LINFlexD_BIDR_union_tag { /* Buffer Identifier Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DFL:6;
    vuint32_t DIR:1;
    vuint32_t CCS:1;
    vuint32_t _unused_6:2;
    vuint32_t ID:6;
  } B;
} LINFlexD_BIDR_tag;

typedef union LINFlexD_BDRL_union_tag { /* Buffer Data Register Least Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA3:8;
    vuint32_t DATA2:8;
    vuint32_t DATA1:8;
    vuint32_t DATA0:8;
  } B;
} LINFlexD_BDRL_tag;

typedef union LINFlexD_BDRM_union_tag { /* Buffer Data Register Most Significant */
  vuint32_t R;
  struct {
    vuint32_t DATA7:8;
    vuint32_t DATA6:8;
    vuint32_t DATA5:8;
    vuint32_t DATA4:8;
  } B;
} LINFlexD_BDRM_tag;

typedef union LINFlexD_IFER_union_tag { /* Identifier Filter Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t FACT:16;
  } B;
} LINFlexD_IFER_tag;

typedef union LINFlexD_IFMI_union_tag { /* Identifier Filter Match Index */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t IFMI:5;
  } B;
} LINFlexD_IFMI_tag;

typedef union LINFlexD_IFMR_union_tag { /* Identifier Filter Mode Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t IFM:8;
  } B;
} LINFlexD_IFMR_tag;

typedef union LINFlexD_IFCR_union_tag { /* Identifier Filter Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DFL:6;                   /* Data Field Length */
    vuint32_t DIR:1;                   /* Direction */
    vuint32_t CCS:1;                   /* Classic Checksum */
    vuint32_t _unused_6:2;
    vuint32_t ID:6;                    /* Identifier */
  } B;
} LINFlexD_IFCR_tag;

typedef union LINFlexD_GCR_union_tag { /* Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t TDFBM:1;
    vuint32_t RDFBM:1;
    vuint32_t TDLIS:1;
    vuint32_t RDLIS:1;
    vuint32_t STOP:1;
    vuint32_t SR:1;
  } B;
} LINFlexD_GCR_tag;

typedef union LINFlexD_UARTPTO_union_tag { /* UART Preset Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t PTO:12;
  } B;
} LINFlexD_UARTPTO_tag;

typedef union LINFlexD_UARTCTO_union_tag { /* UART Current Timeout Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t CTO:12;
  } B;
} LINFlexD_UARTCTO_tag;

typedef union LINFlexD_DMATXE_union_tag { /* DMA Tx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DTE:16;
  } B;
} LINFlexD_DMATXE_tag;

typedef union LINFlexD_DMARXE_union_tag { /* DMA Rx Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t DRE:16;
  } B;
} LINFlexD_DMARXE_tag;

struct LINFlexD_tag {
  LINFlexD_LINCR1_tag LINCR1;          /* LIN Control Register 1 */
  LINFlexD_LINIER_tag LINIER;          /* LIN Interrupt enable register */
  LINFlexD_LINSR_tag LINSR;            /* LIN Status Register */
  LINFlexD_LINESR_tag LINESR;          /* LIN Error Status Register */
  LINFlexD_UARTCR_tag UARTCR;          /* UART Mode Control Register */
  LINFlexD_UARTSR_tag UARTSR;          /* UART Mode Status Register */
  LINFlexD_LINTCSR_tag LINTCSR;        /* LIN Time-Out Control Status Register */
  LINFlexD_LINOCR_tag LINOCR;          /* LIN Output Compare Register */
  LINFlexD_LINTOCR_tag LINTOCR;        /* LIN Time-Out Control Register */
  LINFlexD_LINFBRR_tag LINFBRR;        /* LIN Fractional Baud Rate Register */
  LINFlexD_LINIBRR_tag LINIBRR;        /* LIN Integer Baud Rate Register */
  LINFlexD_LINCFR_tag LINCFR;          /* LIN Checksum Field Register */
  LINFlexD_LINCR2_tag LINCR2;          /* LIN Control Register 2 */
  LINFlexD_BIDR_tag BIDR;              /* Buffer Identifier Register */
  LINFlexD_BDRL_tag BDRL;              /* Buffer Data Register Least Significant */
  LINFlexD_BDRM_tag BDRM;              /* Buffer Data Register Most Significant */
  LINFlexD_IFER_tag IFER;              /* Identifier Filter Enable Register */
  LINFlexD_IFMI_tag IFMI;              /* Identifier Filter Match Index */
  LINFlexD_IFMR_tag IFMR;              /* Identifier Filter Mode Register */
  LINFlexD_IFCR_tag IFCR[16];          /* Identifier Filter Control Register */
  LINFlexD_GCR_tag GCR;                /* Global Control Register */
  LINFlexD_UARTPTO_tag UARTPTO;        /* UART Preset Timeout Register */
  LINFlexD_UARTCTO_tag UARTCTO;        /* UART Current Timeout Register */
  LINFlexD_DMATXE_tag DMATXE;          /* DMA Tx Enable Register */
  LINFlexD_DMARXE_tag DMARXE;          /* DMA Rx Enable Register */
};


/* ============================================================================
   =============================== Module: MCB ================================
   ============================================================================ */

typedef union MCB_AFE_FILTEN_union_tag { /* AFE Filter Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t GLOBAL_FILTEN:1;         /* Filter Enable */
  } B;
} MCB_AFE_FILTEN_tag;

typedef union MCB_AFE_CLK_CTRL_union_tag { /* AFE Clock Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t AUX_CLK_EN:1;
    vuint32_t PDI_40_EN:1;
  } B;
} MCB_AFE_CLK_CTRL_tag;

typedef union MCB_NPC_SPECIAL_ENABLE_union_tag { /* NPC Special Enable Control */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t WATER_MARK:4;            /* WATER MARK LEVEL */
    vuint32_t FIFO_DEPTH:4;            /* NAL FIFO DEPTH */
    vuint32_t _unused_1:7;             /* RESERVED */
    vuint32_t DISABLE_SPECIAL_ENABLE:1; /* Disable special enable fuinctionality of NPC auxilary ports */
  } B;
} MCB_NPC_SPECIAL_ENABLE_tag;

typedef union MCB_AFE_LVD_MASK_union_tag { /* AFE LVD Mask */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t Z7_HW_VEC_CONTROL:1;
    vuint32_t AFE_LVD9_MASK:1;         /* Mask LVD on AFE DAC internal capacitor circuitry */
    vuint32_t AFE_LVD8_MASK:1;         /* Mask LVD on level shifter logic */
    vuint32_t AFE_LVD7_MASK:1;         /* Mask LVD on AFE SDPLL digital circuitry */
    vuint32_t AFE_LVD6_MASK:1;         /* Mask LVD on AFE SDPLL analog circuitry */
    vuint32_t AFE_LVD5_MASK:1;         /* Mask LVD on AFE OSC circuitry */
    vuint32_t AFE_LVD4_MASK:1;         /* Mask LVD on AFE DAC external capacitor circuitry */
    vuint32_t AFE_LVD3_MASK:1;         /* Mask LVD on AFE ADC digital circuitry */
    vuint32_t AFE_LVD2_MASK:1;         /* Mask LVD on AFE ADC analog circuitry */
    vuint32_t _unused_1:1;
    vuint32_t AFE_REF_LVD_MASK:1;      /* Mask LVD on VDD_HV_RAW and VDD_HV_DAC */
  } B;
} MCB_AFE_LVD_MASK_tag;

typedef union MCB_MISC2_union_tag {    /* SPT Nexus client throttle */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t SPT_NEXUS_THROTTLE_CONTROL:7; /* SPT NEXUS THROTTLE CONTROL */
    vuint32_t RCCU_DMA_STATUS:1;       /* RCCU DMA STATUS */
    vuint32_t RCCU_Z4_STATUS:1;        /* RCCU Z4 STATUS */
  } B;
} MCB_MISC2_tag;

typedef union MCB_MISC3_union_tag {
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* RESERVED */
    vuint32_t RMII_MODE:1;             /* RMII MODE SELECTION */
  } B;
} MCB_MISC3_tag;

typedef union MCB_AFE_FILT0_PHASE_union_tag { /* AFE_FILT0_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT0_PHASE_tag;

typedef union MCB_AFE_FILT1_PHASE_union_tag { /* AFE_FILT1_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT1_PHASE_tag;

typedef union MCB_AFE_FILT2_PHASE_union_tag { /* AFE_FILT2_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT2_PHASE_tag;

typedef union MCB_AFE_FILT3_PHASE_union_tag { /* AFE_FILT3_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT3_PHASE_tag;

typedef union MCB_AFE_FILT4_PHASE_union_tag { /* AFE_FILT4_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT4_PHASE_tag;

typedef union MCB_AFE_FILT5_PHASE_union_tag { /* AFE_FILT5_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT5_PHASE_tag;

typedef union MCB_AFE_FILT6_PHASE_union_tag { /* AFE_FILT6_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT6_PHASE_tag;

typedef union MCB_AFE_FILT7_PHASE_union_tag { /* AFE_FILT7_PHASE */
  vuint32_t R;
  struct {
    vuint32_t _unused_7:25;
    vuint32_t MODE:1;                  /* MODE */
    vuint32_t PHASE:6;                 /* PHASE */
  } B;
} MCB_AFE_FILT7_PHASE_tag;

typedef union MCB_CLKOUT_SEL_union_tag { /* CLKOUT Source Select */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CLKOUT0:4;               /* Clock Out */
    vuint32_t CLKOUT1:4;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} MCB_CLKOUT_SEL_tag;

struct MCB_tag {
  MCB_AFE_FILTEN_tag AFE_FILTEN;       /* AFE Filter Enable */
  MCB_AFE_CLK_CTRL_tag AFE_CLK_CTRL;   /* AFE Clock Control */
  MCB_NPC_SPECIAL_ENABLE_tag NPC_SPECIAL_ENABLE; /* NPC Special Enable Control */
  MCB_AFE_LVD_MASK_tag AFE_LVD_MASK;   /* AFE LVD Mask */
  uint8_t MCB_reserved0[4];
  MCB_MISC2_tag MISC2;                 /* SPT Nexus client throttle */
  MCB_MISC3_tag MISC3;
  MCB_AFE_FILT0_PHASE_tag AFE_FILT0_PHASE; /* AFE_FILT0_PHASE */
  MCB_AFE_FILT1_PHASE_tag AFE_FILT1_PHASE; /* AFE_FILT1_PHASE */
  MCB_AFE_FILT2_PHASE_tag AFE_FILT2_PHASE; /* AFE_FILT2_PHASE */
  MCB_AFE_FILT3_PHASE_tag AFE_FILT3_PHASE; /* AFE_FILT3_PHASE */
  MCB_AFE_FILT4_PHASE_tag AFE_FILT4_PHASE; /* AFE_FILT4_PHASE */
  MCB_AFE_FILT5_PHASE_tag AFE_FILT5_PHASE; /* AFE_FILT5_PHASE */
  MCB_AFE_FILT6_PHASE_tag AFE_FILT6_PHASE; /* AFE_FILT6_PHASE */
  MCB_AFE_FILT7_PHASE_tag AFE_FILT7_PHASE; /* AFE_FILT7_PHASE */
  uint8_t MCB_reserved1[16364];
  MCB_CLKOUT_SEL_tag CLKOUT_SEL;       /* CLKOUT Source Select */
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

typedef union MC_ME_GS_union_tag {     /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t S_CURRENT_MODE:4;
    vuint32_t S_MTRANS:1;
    vuint32_t _unused_26:1;
    vuint32_t _unused_24:2;
    vuint32_t S_PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t S_MVR:1;
    vuint32_t _unused_18:2;
    vuint32_t S_FLA:2;
    vuint32_t _unused_9:7;
    vuint32_t S_SDPLL:1;
    vuint32_t S_PLL1:1;
    vuint32_t S_PLL0:1;
    vuint32_t S_XOSC:1;
    vuint32_t S_IRC:1;
    vuint32_t S_SYSCLK:4;
  } B;
} MC_ME_GS_tag;

typedef union MC_ME_MCTL_union_tag {   /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t TARGET_MODE:4;
    vuint32_t _unused_16:12;
    vuint32_t KEY:16;
  } B;
} MC_ME_MCTL_tag;

typedef union MC_ME_ME_union_tag {     /* Mode Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RESET_DEST:1;
    vuint32_t _unused_11:4;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET_FUNC:1;
  } B;
} MC_ME_ME_tag;

typedef union MC_ME_IS_union_tag {     /* Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t I_ICONF_CC:1;
    vuint32_t I_ICONF_CU:1;
    vuint32_t I_ICONF:1;
    vuint32_t I_IMODE:1;
    vuint32_t I_SAFE:1;
    vuint32_t I_MTC:1;
  } B;
} MC_ME_IS_tag;

typedef union MC_ME_IM_union_tag {     /* Interrupt Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t M_ICONF_CC:1;
    vuint32_t M_ICONF_CU:1;
    vuint32_t M_ICONF:1;
    vuint32_t M_IMODE:1;
    vuint32_t M_SAFE:1;
    vuint32_t M_MTC:1;
  } B;
} MC_ME_IM_tag;

typedef union MC_ME_IMTS_union_tag {   /* Invalid Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t S_MRIG:1;
    vuint32_t S_MTI:1;
    vuint32_t S_MRI:1;
    vuint32_t S_DMA:1;
    vuint32_t S_NMA:1;
    vuint32_t S_SEA:1;
  } B;
} MC_ME_IMTS_tag;

typedef union MC_ME_DMTS_union_tag {   /* Debug Mode Transition Status Register */
  vuint32_t R;
  struct {
    vuint32_t PREVIOUS_MODE:4;
    vuint32_t _unused_24:4;
    vuint32_t MPH_BUSY:1;
    vuint32_t _unused_21:2;
    vuint32_t PMC_PROG:1;
    vuint32_t DBG_MODE:1;
    vuint32_t CCKL_PROG:1;
    vuint32_t PCS_PROG:1;
    vuint32_t SMR:1;
    vuint32_t _unused_15:1;
    vuint32_t VREG_CSRC_SC:1;
    vuint32_t CSRC_CSRC_SC:1;
    vuint32_t IRC_SC:1;
    vuint32_t SCSRC_SC:1;
    vuint32_t SYSCLK_SW:1;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t CDP_PRPH_224_255:1;
    vuint32_t CDP_PRPH_192_223:1;
    vuint32_t CDP_PRPH_160_191:1;
    vuint32_t CDP_PRPH_128_159:1;
    vuint32_t CDP_PRPH_96_127:1;
    vuint32_t CDP_PRPH_64_95:1;
    vuint32_t CDP_PRPH_32_63:1;
    vuint32_t CDP_PRPH_0_31:1;
  } B;
} MC_ME_DMTS_tag;

typedef union MC_ME_RESET_MC_union_tag { /* RESET Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RESET_MC_tag;

typedef union MC_ME_TEST_MC_union_tag { /* TEST Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_TEST_MC_tag;

typedef union MC_ME_SAFE_MC_union_tag { /* SAFE Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_SAFE_MC_tag;

typedef union MC_ME_DRUN_MC_union_tag { /* DRUN Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_DRUN_MC_tag;

typedef union MC_ME_RUN_MC_union_tag { /* RUN0 3 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_RUN_MC_tag;

typedef union MC_ME_HALT0_MC_union_tag { /* HALT0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_HALT0_MC_tag;

typedef union MC_ME_STOP0_MC_union_tag { /* STOP0 Mode Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PWRLVL:3;
    vuint32_t _unused_24:4;
    vuint32_t PDO:1;
    vuint32_t _unused_21:2;
    vuint32_t MVRON:1;
    vuint32_t _unused_18:2;
    vuint32_t FLAON:2;
    vuint32_t _unused_9:7;
    vuint32_t SDPLLON:1;
    vuint32_t PLL1ON:1;
    vuint32_t PLL0ON:1;
    vuint32_t XOSCON:1;
    vuint32_t IRCON:1;
    vuint32_t SYSCLK:4;
  } B;
} MC_ME_STOP0_MC_tag;

typedef union MC_ME_PS0_union_tag {    /* Peripheral Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t S_PIT_RTC_1:1;
    vuint32_t S_PIT_RTC_0:1;
    vuint32_t _unused_13:17;
    vuint32_t S_Ethernet_0:1;
    vuint32_t S_SIPI_0:1;
    vuint32_t _unused_10:1;
    vuint32_t S_LFAST_0:1;
    vuint32_t _unused_0:9;
  } B;
} MC_ME_PS0_tag;

typedef union MC_ME_PS1_union_tag {    /* Peripheral Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t S_RADAR:1;
    vuint32_t _unused_24:4;
    vuint32_t S_PDI:1;
    vuint32_t _unused_18:5;
    vuint32_t S_DTS:1;
    vuint32_t _unused_7:10;
    vuint32_t S_CRC_0:1;
    vuint32_t _unused_5:1;
    vuint32_t S_DMAMUX_0:1;
    vuint32_t _unused_3:1;
    vuint32_t S_ATX:1;
    vuint32_t _unused_0:2;
  } B;
} MC_ME_PS1_tag;

typedef union MC_ME_PS2_union_tag {    /* Peripheral Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t S_LIN_3:1;
    vuint32_t S_LIN_1:1;
    vuint32_t S_LIN_2:1;
    vuint32_t _unused_16:10;
    vuint32_t S_FLEXCAN_0:1;
    vuint32_t S_FLEXCAN_1:1;
    vuint32_t S_FLEXCAN_2:1;
    vuint32_t S_FLEXCAN_3:1;
    vuint32_t _unused_0:12;
  } B;
} MC_ME_PS2_tag;

typedef union MC_ME_PS3_union_tag {    /* Peripheral Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t S_SAR_ADC_1:1;
    vuint32_t _unused_29:1;
    vuint32_t S_SAR_ADC_3:1;
    vuint32_t _unused_16:12;
    vuint32_t S_PSI5_0:1;
    vuint32_t _unused_12:3;
    vuint32_t S_FLEXRAY_0:1;
    vuint32_t _unused_9:2;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t S_IIC_1:1;
    vuint32_t S_IIC_0:1;
    vuint32_t S_IIC_2:1;
    vuint32_t S_DSPI_0:1;
    vuint32_t S_DSPI_1:1;
    vuint32_t _unused_0:2;
  } B;
} MC_ME_PS3_tag;

typedef union MC_ME_PS4_union_tag {    /* Peripheral Status Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t S_CRC_1:1;
    vuint32_t _unused_19:1;
    vuint32_t S_DMAMUX_1:1;
    vuint32_t _unused_17:1;
    vuint32_t S_FlexPWM_1:1;
    vuint32_t _unused_14:2;
    vuint32_t S_CTU_1:1;
    vuint32_t _unused_10:3;
    vuint32_t S_ETIMER_1:1;
    vuint32_t _unused_0:9;
  } B;
} MC_ME_PS4_tag;

typedef union MC_ME_PS5_union_tag {    /* Peripheral Status Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t S_RADAR_CTE:1;
    vuint32_t S_SPT:1;
    vuint32_t _unused_24:3;
    vuint32_t _unused_23:1;
    vuint32_t _unused_0:23;
  } B;
} MC_ME_PS5_tag;

typedef union MC_ME_PS6_union_tag {    /* Peripheral Status Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;
    vuint32_t S_DSPI_2:1;
    vuint32_t S_DSPI_3:1;
    vuint32_t _unused_14:2;
    vuint32_t _unused_13:1;
    vuint32_t S_LIN_0:1;
    vuint32_t _unused_0:12;
  } B;
} MC_ME_PS6_tag;

typedef union MC_ME_PS7_union_tag {    /* Peripheral Status Register 7 */
  vuint32_t R;
  struct {
    vuint32_t S_FlexPWM_0:1;
    vuint32_t _unused_28:3;
    vuint32_t S_CTU_0:1;
    vuint32_t _unused_24:3;
    vuint32_t S_ETIMER_0:1;
    vuint32_t _unused_22:1;
    vuint32_t S_ETIMER_2:1;
    vuint32_t _unused_15:6;
    vuint32_t S_WGM_0:1;
    vuint32_t S_SAR_ADC_0:1;
    vuint32_t _unused_12:1;
    vuint32_t S_SAR_ADC_2:1;
    vuint32_t _unused_0:11;
  } B;
} MC_ME_PS7_tag;

typedef union MC_ME_RUN_PC_union_tag { /* Run Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RUN3:1;
    vuint32_t RUN2:1;
    vuint32_t RUN1:1;
    vuint32_t RUN0:1;
    vuint32_t DRUN:1;
    vuint32_t SAFE:1;
    vuint32_t TEST:1;
    vuint32_t RESET:1;
  } B;
} MC_ME_RUN_PC_tag;

typedef union MC_ME_LP_PC_union_tag {  /* Low-Power Peripheral Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t STOP0:1;
    vuint32_t _unused_9:1;
    vuint32_t HALT0:1;
    vuint32_t _unused_0:8;
  } B;
} MC_ME_LP_PC_tag;

    /* Note on PCTL registers: There are only some PCTL implemented         */
    /*  In order to make the PCTL easily addressable, these are defined     */
    /*  as an array (ie ME.PCTL[x].R). This means you have to be careful    */
    /*  when addressing these registers in order not to access a PCTL that  */
    /*  is not implemented. Following are available: 9, 11-12, 30-31, 36,   */
    /*  38, 49, 55, 76-79, 90-92, 98-100, 102, 107, 124, 126, 137, 141,     */
    /*  146, 148, 183, 187-188, 209, 214, 235, 237-239, 245, 251            */

typedef union MC_ME_PCTL_union_tag {
  vuint8_t R;
  struct {
    vuint8_t _unused_7:1;
    vuint8_t DBG_F:1;
    vuint8_t LP_CFG:3;
    vuint8_t RUN_CFG:3;
  } B;
} MC_ME_PCTL_tag;

typedef union MC_ME_CS_union_tag {     /* Core Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t S_CORE3:1;
    vuint32_t S_CORE2:1;
    vuint32_t S_CORE1:1;
    vuint32_t _unused_0:1;
  } B;
} MC_ME_CS_tag;

typedef union MC_ME_CCTL1_union_tag {  /* Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL1_tag;

typedef union MC_ME_CCTL2_union_tag {  /* Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL2_tag;

typedef union MC_ME_CCTL3_union_tag {  /* Core Control Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_11:5;
    vuint16_t STOP0:1;
    vuint16_t _unused_9:1;
    vuint16_t HALT0:1;
    vuint16_t RUN3:1;
    vuint16_t RUN2:1;
    vuint16_t RUN1:1;
    vuint16_t RUN0:1;
    vuint16_t DRUN:1;
    vuint16_t SAFE:1;
    vuint16_t TEST:1;
    vuint16_t RESET:1;
  } B;
} MC_ME_CCTL3_tag;

typedef union MC_ME_CADDR1_union_tag { /* Core Control Registers */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR1_tag;

typedef union MC_ME_CADDR2_union_tag { /* Core Control Registers */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR2_tag;

typedef union MC_ME_CADDR3_union_tag { /* Core Control Registers */
  vuint32_t R;
  struct {
    vuint32_t ADDR:30;
    vuint32_t _unused_1:1;
    vuint32_t RMC:1;
  } B;
} MC_ME_CADDR3_tag;

struct MC_ME_tag {
  MC_ME_GS_tag GS;                     /* Global Status Register */
  MC_ME_MCTL_tag MCTL;                 /* Mode Control Register */
  MC_ME_ME_tag ME;                     /* Mode Enable Register */
  MC_ME_IS_tag IS;                     /* Interrupt Status Register */
  MC_ME_IM_tag IM;                     /* Interrupt Mask Register */
  MC_ME_IMTS_tag IMTS;                 /* Invalid Mode Transition Status Register */
  MC_ME_DMTS_tag DMTS;                 /* Debug Mode Transition Status Register */
  uint8_t MC_ME_reserved0[4];
  MC_ME_RESET_MC_tag RESET_MC;         /* RESET Mode Configuration Register */
  MC_ME_TEST_MC_tag TEST_MC;           /* TEST Mode Configuration Register */
  MC_ME_SAFE_MC_tag SAFE_MC;           /* SAFE Mode Configuration Register */
  MC_ME_DRUN_MC_tag DRUN_MC;           /* DRUN Mode Configuration Register */
  MC_ME_RUN_MC_tag RUN_MC[4];          /* RUN0 3 Mode Configuration Register */
  MC_ME_HALT0_MC_tag HALT0_MC;         /* HALT0 Mode Configuration Register */
  uint8_t MC_ME_reserved1[4];
  MC_ME_STOP0_MC_tag STOP0_MC;         /* STOP0 Mode Configuration Register */
  uint8_t MC_ME_reserved2[20];
  MC_ME_PS0_tag PS0;                   /* Peripheral Status Register 0 */
  MC_ME_PS1_tag PS1;                   /* Peripheral Status Register 1 */
  MC_ME_PS2_tag PS2;                   /* Peripheral Status Register 2 */
  MC_ME_PS3_tag PS3;                   /* Peripheral Status Register 3 */
  MC_ME_PS4_tag PS4;                   /* Peripheral Status Register 4 */
  MC_ME_PS5_tag PS5;                   /* Peripheral Status Register 5 */
  MC_ME_PS6_tag PS6;                   /* Peripheral Status Register 6 */
  MC_ME_PS7_tag PS7;                   /* Peripheral Status Register 7 */
  MC_ME_RUN_PC_tag RUN_PC[8];          /* Run Peripheral Configuration Register */
  MC_ME_LP_PC_tag LP_PC[8];            /* Low-Power Peripheral Configuration Register */
  MC_ME_PCTL_tag PCTL[256];
  MC_ME_CS_tag CS;                     /* Core Status Register */
  uint8_t MC_ME_reserved3[2];
  MC_ME_CCTL1_tag CCTL1;               /* Core Control Register */
  MC_ME_CCTL2_tag CCTL2;               /* Core Control Register */
  MC_ME_CCTL3_tag CCTL3;               /* Core Control Register */
  uint8_t MC_ME_reserved4[24];
  MC_ME_CADDR1_tag CADDR1;             /* Core Control Registers */
  MC_ME_CADDR2_tag CADDR2;             /* Core Control Registers */
  MC_ME_CADDR3_tag CADDR3;             /* Core Control Registers */
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

typedef union MC_PCU_PSTAT_union_tag { /* Power Domain Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t _unused_0:1;
  } B;
} MC_PCU_PSTAT_tag;

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  MC_PCU_PSTAT_tag PSTAT;              /* Power Domain Status Register */
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

typedef union MEMU_CTRL_union_tag {    /* Control register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SWR:1;
    vuint32_t _unused_0:15;
  } B;
} MEMU_CTRL_tag;

typedef union MEMU_ERR_FLAG_union_tag { /* Error flag register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t PR_CE:1;
    vuint32_t PR_UCE:1;
    vuint32_t PR_CEO:1;
    vuint32_t PR_UCO:1;
    vuint32_t PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t F_CE:1;
    vuint32_t F_UCE:1;
    vuint32_t F_CEO:1;
    vuint32_t F_UCO:1;
    vuint32_t F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t SR_CE:1;
    vuint32_t SR_UCE:1;
    vuint32_t SR_CEO:1;
    vuint32_t SR_UCO:1;
    vuint32_t SR_EBO:1;
  } B;
} MEMU_ERR_FLAG_tag;

typedef union MEMU_DEBUG_union_tag {   /* Debug register */
  vuint32_t R;
  struct {
    vuint32_t _unused_21:11;
    vuint32_t FR_PR_CE:1;
    vuint32_t FR_PR_UCE:1;
    vuint32_t FR_PR_CEO:1;
    vuint32_t FR_PR_UCO:1;
    vuint32_t FR_PR_EBO:1;
    vuint32_t _unused_13:3;
    vuint32_t FR_F_CE:1;
    vuint32_t FR_F_UCE:1;
    vuint32_t FR_F_CEO:1;
    vuint32_t FR_F_UCO:1;
    vuint32_t FR_F_EBO:1;
    vuint32_t _unused_5:3;
    vuint32_t FR_SR_CE:1;
    vuint32_t FR_SR_UCE:1;
    vuint32_t FR_SR_CEO:1;
    vuint32_t FR_SR_UCO:1;
    vuint32_t FR_SR_EBO:1;
  } B;
} MEMU_DEBUG_tag;

typedef union MEMU_SYS_RAM_CERR_STS_union_tag { /* System RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_SYS_RAM_CERR_STS_tag;

typedef union MEMU_SYS_RAM_CERR_ADDR_union_tag { /* System RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_CERR_ADDR_tag;

typedef struct MEMU_SYS_RAM_CERR_struct_tag {
  MEMU_SYS_RAM_CERR_STS_tag STS;       /* System RAM correctable error reporting table status register */
  MEMU_SYS_RAM_CERR_ADDR_tag ADDR;     /* System RAM correctable error reporting table address register */
} MEMU_SYS_RAM_CERR_tag;

typedef union MEMU_SYS_RAM_UNCERR_STS_union_tag { /* System RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_SYS_RAM_UNCERR_STS_tag;

typedef union MEMU_SYS_RAM_UNCERR_ADDR_union_tag { /* System RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_SYS_RAM_UNCERR_ADDR_tag;

typedef union MEMU_SYS_RAM_OFLW_union_tag { /* System RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_SYS_RAM_OFLW_tag;

typedef union MEMU_PERIPH_RAM_CERR_STS_union_tag { /* Peripheral RAM correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_PERIPH_RAM_CERR_STS_tag;

typedef union MEMU_PERIPH_RAM_CERR_ADDR_union_tag { /* Peripheral RAM correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_CERR_ADDR_tag;

typedef struct MEMU_PERIPH_RAM_CERR_struct_tag {
  MEMU_PERIPH_RAM_CERR_STS_tag STS;    /* Peripheral RAM correctable error reporting table status register */
  MEMU_PERIPH_RAM_CERR_ADDR_tag ADDR;  /* Peripheral RAM correctable error reporting table address register */
} MEMU_PERIPH_RAM_CERR_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_STS_union_tag { /* Peripheral RAM uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_PERIPH_RAM_UNCERR_STS_tag;

typedef union MEMU_PERIPH_RAM_UNCERR_ADDR_union_tag { /* Peripheral RAM uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_PERIPH_RAM_UNCERR_ADDR_tag;

typedef union MEMU_PERIPH_RAM_OFLW0_union_tag { /* Peripheral RAM concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_PERIPH_RAM_OFLW0_tag;

typedef union MEMU_FLASH_CERR_STS_union_tag { /* Flash memory correctable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_8:23;
    vuint32_t BAD_BIT:8;
  } B;
} MEMU_FLASH_CERR_STS_tag;

typedef union MEMU_FLASH_CERR_ADDR_union_tag { /* Flash memory correctable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_CERR_ADDR_tag;

typedef struct MEMU_FLASH_CERR_struct_tag {
  MEMU_FLASH_CERR_STS_tag STS;         /* Flash memory correctable error reporting table status register */
  MEMU_FLASH_CERR_ADDR_tag ADDR;       /* Flash memory correctable error reporting table address register */
} MEMU_FLASH_CERR_tag;

typedef union MEMU_FLASH_UNCERR_STS_union_tag { /* Flash memory uncorrectable error reporting table status register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t _unused_0:31;
  } B;
} MEMU_FLASH_UNCERR_STS_tag;

typedef union MEMU_FLASH_UNCERR_ADDR_union_tag { /* Flash memory uncorrectable error reporting table address register */
  vuint32_t R;
  struct {
    vuint32_t ERR_ADD:32;
  } B;
} MEMU_FLASH_UNCERR_ADDR_tag;

typedef union MEMU_FLASH_OFLW0_union_tag { /* Flash memory concurrent overflow register */
  vuint32_t R;
  struct {
    vuint32_t OFLW:32;
  } B;
} MEMU_FLASH_OFLW0_tag;

struct MEMU_tag {
  MEMU_CTRL_tag CTRL;                  /* Control register */
  MEMU_ERR_FLAG_tag ERR_FLAG;          /* Error flag register */
  uint8_t MEMU_reserved0[4];
  MEMU_DEBUG_tag DEBUG;                /* Debug register */
  uint8_t MEMU_reserved1[16];
  MEMU_SYS_RAM_CERR_tag SYS_RAM_CERR[10];
  MEMU_SYS_RAM_UNCERR_STS_tag SYS_RAM_UNCERR_STS; /* System RAM uncorrectable error reporting table status register */
  MEMU_SYS_RAM_UNCERR_ADDR_tag SYS_RAM_UNCERR_ADDR; /* System RAM uncorrectable error reporting table address register */
  MEMU_SYS_RAM_OFLW_tag SYS_RAM_OFLW[2]; /* System RAM concurrent overflow register */
  uint8_t MEMU_reserved2[1440];
  MEMU_PERIPH_RAM_CERR_tag PERIPH_RAM_CERR[2];
  MEMU_PERIPH_RAM_UNCERR_STS_tag PERIPH_RAM_UNCERR_STS; /* Peripheral RAM uncorrectable error reporting table status register */
  MEMU_PERIPH_RAM_UNCERR_ADDR_tag PERIPH_RAM_UNCERR_ADDR; /* Peripheral RAM uncorrectable error reporting table address register */
  MEMU_PERIPH_RAM_OFLW0_tag PERIPH_RAM_OFLW0; /* Peripheral RAM concurrent overflow register */
  uint8_t MEMU_reserved3[1508];
  MEMU_FLASH_CERR_tag FLASH_CERR[20];
  MEMU_FLASH_UNCERR_STS_tag FLASH_UNCERR_STS; /* Flash memory uncorrectable error reporting table status register */
  MEMU_FLASH_UNCERR_ADDR_tag FLASH_UNCERR_ADDR; /* Flash memory uncorrectable error reporting table address register */
  MEMU_FLASH_OFLW0_tag FLASH_OFLW0;    /* Flash memory concurrent overflow register */
};


/* ============================================================================
   =============================== Module: M_CAN ==============================
   ============================================================================ */

typedef union M_CAN_CREL_union_tag {   /* Core Release Register */
  vuint32_t R;
  struct {
    vuint32_t REL:4;                   /* Core Release */
    vuint32_t STEP:4;                  /* Step of Core Release */
    vuint32_t SUBSTEP:4;               /* Sub-step of Core Release */
    vuint32_t YEAR:4;                  /* Time Stamp Year */
    vuint32_t MON:8;                   /* Time Stamp Month */
    vuint32_t DAY:8;                   /* Time Stamp Day */
  } B;
} M_CAN_CREL_tag;

typedef union M_CAN_ENDN_union_tag {   /* Endian Register */
  vuint32_t R;
  struct {
    vuint32_t ETV:32;                  /* Endianness Test Value */
  } B;
} M_CAN_ENDN_tag;

typedef union M_CAN_FBTP_union_tag {   /* Fast Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t TDCO:5;                  /* Transceiver Delay Compensation Offset */
    vuint32_t TDC:1;                   /* Transceiver Delay Compensation */
    vuint32_t _unused_21:2;
    vuint32_t FBRP:5;                  /* Fast Baud Rate Prescaler */
    vuint32_t _unused_12:4;
    vuint32_t FTSEG1:4;                /* Fast time segment before sample point */
    vuint32_t _unused_7:1;
    vuint32_t FTSEG2:3;                /* Fast time segment after sample point */
    vuint32_t _unused_2:2;
    vuint32_t FSJW:2;                  /* Fast (Re) Synchronization Jump Width */
  } B;
} M_CAN_FBTP_tag;

typedef union M_CAN_TEST_union_tag {   /* Test Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t TDCV:6;                  /* Transceiver Delay Compensation Value */
    vuint32_t RX:1;                    /* Receive Pin */
    vuint32_t TX:2;                    /* Control of Transmit Pin */
    vuint32_t LBCK:1;                  /* Loopback mode */
    vuint32_t _unused_0:4;
  } B;
} M_CAN_TEST_tag;

typedef union M_CAN_RWD_union_tag {    /* RAM Watchdog Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t WDV:8;                   /* Watchdog Value */
    vuint32_t WDC:8;                   /* Watchdog Configuration */
  } B;
} M_CAN_RWD_tag;

typedef union M_CAN_CCCR_union_tag {   /* CC Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t TXP:1;                   /* Transmit Pause */
    vuint32_t FDBS:1;                  /* CAN FD Bit Rate Switching */
    vuint32_t FDO:1;                   /* CAN FD Operation */
    vuint32_t CMR:2;                   /* CAN Mode Request */
    vuint32_t CME:2;                   /* CAN Mode Enable */
    vuint32_t TEST:1;                  /* Test Mode Enable */
    vuint32_t DAR:1;                   /* Disable Automatic Retransmission */
    vuint32_t MON:1;                   /* Bus Monitoring Mode */
    vuint32_t CSR:1;                   /* Clock Stop Request */
    vuint32_t CSA:1;                   /* Clock Stop Acknowledge */
    vuint32_t ASM:1;                   /* Restricted Operation Mode */
    vuint32_t CCE:1;                   /* Configuration Change Enable */
    vuint32_t INIT:1;                  /* Initialization */
  } B;
} M_CAN_CCCR_tag;

typedef union M_CAN_BTP_union_tag {    /* Bit Timing and Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t BRP:6;                   /* Baud Rate Prescaler */
    vuint32_t _unused_14:2;
    vuint32_t TSEG1:6;                 /* Time segment before sample point */
    vuint32_t TSEG2:4;                 /* Time segment after sample point */
    vuint32_t SJW:4;                   /* (Re) Synchronization Jump Width */
  } B;
} M_CAN_BTP_tag;

typedef union M_CAN_TSCC_union_tag {   /* Timestamp Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_20:12;
    vuint32_t TCP:4;                   /* Timestamp Counter Prescaler */
    vuint32_t _unused_2:14;
    vuint32_t TSS:2;                   /* Timestamp Select */
  } B;
} M_CAN_TSCC_tag;

typedef union M_CAN_TSCV_union_tag {   /* Timestamp Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TSC:16;                  /* Timestamp Counter */
  } B;
} M_CAN_TSCV_tag;

typedef union M_CAN_TOCC_union_tag {   /* Timeout Counter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t TOP:16;                  /* Timeout Period */
    vuint32_t _unused_3:13;
    vuint32_t TOS:2;                   /* Timeout Select */
    vuint32_t ETOC:1;                  /* Enable Timeout Counte */
  } B;
} M_CAN_TOCC_tag;

typedef union M_CAN_TOCV_union_tag {   /* Timeout Counter Value Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TOC:16;                  /* Timeout Counter */
  } B;
} M_CAN_TOCV_tag;

typedef union M_CAN_ECR_union_tag {    /* Error Counter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t CEL:8;                   /* CAN Error Logging */
    vuint32_t RP:1;                    /* Receive Error Passive */
    vuint32_t REC:7;                   /* Receive Error Counter */
    vuint32_t TEC:8;                   /* Transmit Error Counter */
  } B;
} M_CAN_ECR_tag;

typedef union M_CAN_PSR_union_tag {    /* Protocol Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_14:18;
    vuint32_t REDL:1;                  /* Received a CAN FD Message */
    vuint32_t RBRS:1;                  /* BRS flag of last received CAN FD Message */
    vuint32_t RESI:1;                  /* ESI flag of last received CAN FD Message */
    vuint32_t FLEC:3;                  /* Fast Last Error Code */
    vuint32_t BO:1;                    /* Bus_Off Status */
    vuint32_t EW:1;                    /* Warning Status */
    vuint32_t EP:1;                    /* Error Passive */
    vuint32_t ACT:2;                   /* Activity */
    vuint32_t LEC:3;                   /* Last Error Code */
  } B;
} M_CAN_PSR_tag;

typedef union M_CAN_IR_union_tag {     /* Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t STE:1;                   /* Stuff Error */
    vuint32_t FOE:1;                   /* Format Error */
    vuint32_t ACKE:1;                  /* Acknowledge Error */
    vuint32_t BE:1;                    /* Bit Error */
    vuint32_t CRCE:1;                  /* CRC Error */
    vuint32_t WDI:1;                   /* Watchdog Interrupt */
    vuint32_t BO:1;                    /* Bus_Off Status */
    vuint32_t EW:1;                    /* Warning Status */
    vuint32_t EP:1;                    /* Error Passive */
    vuint32_t ELO:1;                   /* Error Logging Overflow */
    vuint32_t BEU:1;                   /* Bit Error Uncorrected */
    vuint32_t BEC:1;                   /* Bit Error Corrected */
    vuint32_t DRX:1;                   /* Message stored to Dedicated Rx Buffer */
    vuint32_t TOO:1;                   /* Timeout Occurred */
    vuint32_t MRAF:1;                  /* Message RAM Access Failure */
    vuint32_t TSW:1;                   /* Timestamp Wraparound */
    vuint32_t TEFL:1;                  /* Tx Event FIFO Element Lost */
    vuint32_t TEFF:1;                  /* Tx Event FIFO Full */
    vuint32_t TEFW:1;                  /* Tx Event FIFO Watermark Reached */
    vuint32_t TEFN:1;                  /* Tx Event FIFO New Entry */
    vuint32_t TFE:1;                   /* Tx FIFO Empty */
    vuint32_t TCF:1;                   /* Transmission Cancellation Finished */
    vuint32_t TC:1;
    vuint32_t HPM:1;                   /* High Priority Message */
    vuint32_t RF1L:1;                  /* Rx FIFO 1 Message Lost */
    vuint32_t RF1F:1;                  /* Rx FIFO 1 Full */
    vuint32_t RF1W:1;                  /* Rx FIFO 1 Watermark Reached */
    vuint32_t RF1N:1;                  /* Rx FIFO 1 New Message */
    vuint32_t RF0L:1;                  /* Rx FIFO 0 Message Lost */
    vuint32_t RF0F:1;                  /* Rx FIFO 0 Full */
    vuint32_t RF0W:1;                  /* Rx FIFO 0 Watermark Reached */
    vuint32_t RF0N:1;                  /* Rx FIFO 0 New Message */
  } B;
} M_CAN_IR_tag;

typedef union M_CAN_IE_union_tag {     /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t STEE:1;                  /* Stuff Error Interrupt Enable */
    vuint32_t FOEE:1;                  /* Format Error Interrupt Enable */
    vuint32_t ACKEE:1;                 /* Acknowledge Error Interrupt Enable */
    vuint32_t BEE:1;                   /* Bit Error Interrupt Enable */
    vuint32_t CRCEE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t WDIE:1;                  /* Watchdog Interrupt Enable */
    vuint32_t BOE:1;                   /* Bus_Off Status Interrupt Enable */
    vuint32_t EWE:1;                   /* Warning Status Interrupt Enable */
    vuint32_t EPE:1;                   /* Error Passive Interrupt Enable */
    vuint32_t ELOE:1;                  /* Error Logging Overflow Interrupt Enable */
    vuint32_t BEUE:1;                  /* Bit Error Uncorrected Interrupt Enable */
    vuint32_t BECE:1;                  /* Bit Error Corrected Interrupt Enable */
    vuint32_t DRXE:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Enable */
    vuint32_t TOOE:1;                  /* Timeout Occurred Interrupt Enable */
    vuint32_t MRAFE:1;                 /* Message RAM Access Failure Interrupt Enable */
    vuint32_t TSWE:1;                  /* Timestamp Wraparound Interrupt Enable */
    vuint32_t TEFLE:1;                 /* Tx Event FIFO Element Lost Interrupt Enable */
    vuint32_t TEFFE:1;                 /* Tx Event FIFO Full Interrupt Enable */
    vuint32_t TEFWE:1;                 /* Tx Event FIFO Watermark Reached Interrupt Enable */
    vuint32_t TEFNE:1;                 /* Tx Event FIFO New Entry Interrupt Enable */
    vuint32_t TFEE:1;                  /* Tx FIFO Empty Interrupt Enable */
    vuint32_t TCFE:1;                  /* Transmission Cancellation Finished Interrupt Enable */
    vuint32_t TCE:1;                   /* Transmission Completed Interrupt Enable */
    vuint32_t HPME:1;                  /* High Priority Message Interrupt Enable */
    vuint32_t RF1LE:1;                 /* Rx FIFO 1 Message Lost Interrupt Enable */
    vuint32_t RF1FE:1;                 /* Rx FIFO 1 Full Interrupt Enable */
    vuint32_t RF1WE:1;                 /* Rx FIFO 1 Watermark Reached Interrupt Enable */
    vuint32_t RF1NE:1;                 /* Rx FIFO 1 New Message Interrupt Enable */
    vuint32_t RF0LE:1;                 /* Rx FIFO 0 Message Lost Interrupt Enable */
    vuint32_t RF0FE:1;                 /* Rx FIFO 0 Full Interrupt Enable */
    vuint32_t RF0WE:1;                 /* Rx FIFO 0 Watermark Reached Interrupt Enable */
    vuint32_t RF0NE:1;                 /* Rx FIFO 0 New Message Interrupt Enable */
  } B;
} M_CAN_IE_tag;

typedef union M_CAN_ILS_union_tag {    /* Interrupt Line Select Register */
  vuint32_t R;
  struct {
    vuint32_t STEL:1;                  /* Stuff Error Interrupt Line */
    vuint32_t FOEL:1;                  /* Format Error Interrupt Line */
    vuint32_t ACKEL:1;                 /* Acknowledge Error Interrupt Line */
    vuint32_t BEL:1;                   /* Bit Error Interrupt Line */
    vuint32_t CRCEL:1;                 /* CRC Error Interrupt Line */
    vuint32_t WDIL:1;                  /* Watchdog Interrupt Line */
    vuint32_t BOL:1;                   /* Bus_Off Status Interrupt Line */
    vuint32_t EWL:1;                   /* Warning Status Interrupt Line */
    vuint32_t EPL:1;                   /* Error Passive Interrupt Line */
    vuint32_t ELOL:1;                  /* Error Logging Overflow Interrupt Line */
    vuint32_t BEUL:1;                  /* Bit Error Uncorrected Interrupt Line */
    vuint32_t BECL:1;                  /* Bit Error Corrected Interrupt Line */
    vuint32_t DRXL:1;                  /* Message stored to Dedicated Rx Buffer Interrupt Line */
    vuint32_t TOOL:1;                  /* Timeout Occurred Interrupt Line */
    vuint32_t MRAFL:1;                 /* Message RAM Access Failure Interrupt Line */
    vuint32_t TSWL:1;                  /* Timestamp Wraparound Interrupt Line */
    vuint32_t TEFLL:1;                 /* Tx Event FIFO Element Lost Interrupt Line */
    vuint32_t TEFFL:1;                 /* Tx Event FIFO Full Interrupt Line */
    vuint32_t TEFWL:1;                 /* Tx Event FIFO Watermark Reached Interrupt Line */
    vuint32_t TEFNL:1;                 /* Tx Event FIFO New Entry Interrupt Line */
    vuint32_t TFEL:1;                  /* Tx FIFO Empty Interrupt Line */
    vuint32_t TCFL:1;                  /* Transmission Cancellation Finished Interrupt Line */
    vuint32_t TCL:1;                   /* Transmission Completed Interrupt Line */
    vuint32_t HPML:1;                  /* High Priority Message Interrupt Line */
    vuint32_t RF1LL:1;                 /* Rx FIFO 1 Message Lost Interrupt Line */
    vuint32_t RF1FL:1;                 /* Rx FIFO 1 Full Interrupt Line */
    vuint32_t RF1WL:1;                 /* Rx FIFO 1 Watermark Reached Interrupt Line */
    vuint32_t RF1NL:1;                 /* Rx FIFO 1 New Message Interrupt Line */
    vuint32_t RF0LL:1;                 /* Rx FIFO 0 Message Lost Interrupt Line */
    vuint32_t RF0FL:1;                 /* Rx FIFO 0 Full Interrupt Line */
    vuint32_t RF0WL:1;                 /* Rx FIFO 0 Watermark Reached Interrupt Line */
    vuint32_t RF0NL:1;                 /* Rx FIFO 0 New Message Interrupt Line */
  } B;
} M_CAN_ILS_tag;

typedef union M_CAN_ILE_union_tag {    /* Interrupt Line Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t EINT1:1;                 /* Enable Interrupt Line 1 */
    vuint32_t EINT0:1;                 /* Enable Interrupt Line 0 */
  } B;
} M_CAN_ILE_tag;

typedef union M_CAN_GFC_union_tag {    /* Global Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t ANFS:2;                  /* Accept Non-matching Frames Standard */
    vuint32_t ANFE:2;                  /* Accept Non-matching Frames Extended */
    vuint32_t RRFS:1;                  /* Reject Remote Frames Standard */
    vuint32_t RRFE:1;                  /* Reject Remote Frames Extended */
  } B;
} M_CAN_GFC_tag;

typedef union M_CAN_SIDFC_union_tag {  /* Standard ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t LSS:8;                   /* List Size Standard */
    vuint32_t FLSSA:14;                /* Filter List Standard Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_SIDFC_tag;

typedef union M_CAN_XIDFC_union_tag {  /* Extended ID Filter Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t LSE:7;                   /* List Size Extended */
    vuint32_t FLESA:14;                /* Filter List Extended Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_XIDFC_tag;

typedef union M_CAN_XIDAM_union_tag {  /* Extended ID and Mask Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_29:3;
    vuint32_t EIDM:29;                 /* Extended ID Mask */
  } B;
} M_CAN_XIDAM_tag;

typedef union M_CAN_HPMS_union_tag {   /* High Priority Message Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t FLST:1;                  /* Filter List */
    vuint32_t FIDX:7;                  /* Filter Index */
    vuint32_t MSI:2;                   /* Message Storage Indicator */
    vuint32_t BIDX:6;                  /* Buffer Index */
  } B;
} M_CAN_HPMS_tag;

typedef union M_CAN_NDAT1_union_tag {  /* New Data 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ND1:32;                  /* New Data[0:31] */
  } B;
} M_CAN_NDAT1_tag;

typedef union M_CAN_NDAT2_union_tag {  /* New Data 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ND2:32;                  /* New Data[32:63] */
  } B;
} M_CAN_NDAT2_tag;

typedef union M_CAN_RXF0C_union_tag {  /* Rx FIFO 0 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t F0OM:1;                  /* FIFO 0 Operation Mode */
    vuint32_t F0WM:7;                  /* Rx FIFO 0 Watermark */
    vuint32_t _unused_23:1;
    vuint32_t F0S:7;                   /* Rx FIFO 0 Size */
    vuint32_t F0SA:14;                 /* Rx FIFO 0 Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_RXF0C_tag;

typedef union M_CAN_RXF0S_union_tag {  /* Rx FIFO 0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t RF0L:1;
    vuint32_t F0F:1;
    vuint32_t _unused_22:2;
    vuint32_t F0PI:6;                  /* Rx FIFO 0 Put Index */
    vuint32_t _unused_14:2;
    vuint32_t F0GI:6;
    vuint32_t _unused_7:1;
    vuint32_t F0FL:7;
  } B;
} M_CAN_RXF0S_tag;

typedef union M_CAN_RXF0A_union_tag {  /* Rx FIFO 0 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t F0AI:6;                  /* Rx FIFO 0 Acknowledge Index */
  } B;
} M_CAN_RXF0A_tag;

typedef union M_CAN_RXBC_union_tag {   /* Rx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t RBSA:14;                 /* Rx Buffer Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_RXBC_tag;

typedef union M_CAN_RXF1C_union_tag {  /* Rx FIFO 1 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t F1OM:1;                  /* FIFO 1 Operation Mode */
    vuint32_t F1WM:7;                  /* Rx FIFO 1 Watermark */
    vuint32_t _unused_23:1;
    vuint32_t F1S:7;                   /* Rx FIFO 1 Size */
    vuint32_t F1SA:14;                 /* Rx FIFO 1 Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_RXF1C_tag;

typedef union M_CAN_RXF1S_union_tag {  /* Rx FIFO 1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t DMS:2;                   /* Debug Message Status */
    vuint32_t _unused_26:4;
    vuint32_t RF1L:1;                  /* Rx FIFO 1 Message Lost */
    vuint32_t F1F:1;                   /* Rx FIFO 1 Full */
    vuint32_t _unused_22:2;
    vuint32_t F1PI:6;                  /* Rx FIFO 1 Put Index */
    vuint32_t _unused_14:2;
    vuint32_t F1GI:6;                  /* Rx FIFO 1 Get Index */
    vuint32_t _unused_7:1;
    vuint32_t F1FL:7;                  /* Rx FIFO 1 Fill Level */
  } B;
} M_CAN_RXF1S_tag;

typedef union M_CAN_RXF1A_union_tag {  /* Rx FIFO 1 Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t F1AI:6;                  /* Rx FIFO 1 Acknowledge Index */
  } B;
} M_CAN_RXF1A_tag;

typedef union M_CAN_RXESC_union_tag {  /* Rx Buffer / FIFO Element Size Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t RBDS:3;                  /* Rx Buffer Data Field Size */
    vuint32_t _unused_7:1;
    vuint32_t F1DS:3;                  /* Rx FIFO 1 Data Field Size */
    vuint32_t _unused_3:1;
    vuint32_t F0DS:3;                  /* Rx FIFO 0 Data Field Size */
  } B;
} M_CAN_RXESC_tag;

typedef union M_CAN_TXBC_union_tag {   /* Tx Buffer Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t TFQM:1;                  /* Tx FIFO/Queue Mode */
    vuint32_t TFQS:6;                  /* Transmit FIFO/Queue Size */
    vuint32_t _unused_22:2;
    vuint32_t NDTB:6;                  /* Number of Dedicated Transmit Buffers */
    vuint32_t TBSA:14;                 /* Tx Buffers Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_TXBC_tag;

typedef union M_CAN_TXFQS_union_tag {  /* Tx FIFO/Queue Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t TFQF:1;                  /* Tx FIFO/Queue Full */
    vuint32_t TFQPI:5;                 /* Tx FIFO/Queue Put Index */
    vuint32_t _unused_13:3;
    vuint32_t TFGI:5;                  /* Tx FIFO Get Index */
    vuint32_t _unused_6:2;
    vuint32_t TFFL:6;                  /* Tx FIFO Free Level */
  } B;
} M_CAN_TXFQS_tag;

typedef union M_CAN_TXESC_union_tag {  /* Tx Buffer Element Size Configuration */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t TBDS:3;                  /* Tx Buffer Data Field Size */
  } B;
} M_CAN_TXESC_tag;

typedef union M_CAN_TXBRP_union_tag {  /* Tx Buffer Request Pending Register */
  vuint32_t R;
  struct {
    vuint32_t TRP:32;                  /* Transmission Request Pending */
  } B;
} M_CAN_TXBRP_tag;

typedef union M_CAN_TXBAR_union_tag {  /* Tx Buffer Add Request Register */
  vuint32_t R;
  struct {
    vuint32_t AR:32;                   /* Add Request */
  } B;
} M_CAN_TXBAR_tag;

typedef union M_CAN_TXBCR_union_tag {  /* Tx Buffer Cancellation Request Register */
  vuint32_t R;
  struct {
    vuint32_t CR:32;                   /* Cancellation Request */
  } B;
} M_CAN_TXBCR_tag;

typedef union M_CAN_TXBTO_union_tag {  /* Tx Buffer Transmission Occurred Register */
  vuint32_t R;
  struct {
    vuint32_t TO:32;                   /* Transmission Occurred */
  } B;
} M_CAN_TXBTO_tag;

typedef union M_CAN_TXBCF_union_tag {  /* Tx Buffer Cancellation Finished Register */
  vuint32_t R;
  struct {
    vuint32_t CF:32;                   /* Cancellation Finished */
  } B;
} M_CAN_TXBCF_tag;

typedef union M_CAN_TXBTIE_union_tag { /* Tx Buffer Transmission Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TIE:32;                  /* Transmission Interrupt Enable */
  } B;
} M_CAN_TXBTIE_tag;

typedef union M_CAN_TXBCIE_union_tag { /* Tx Buffer Cancellation Finished Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CFIE:32;                 /* Cancellation Finished Interrupt Enable */
  } B;
} M_CAN_TXBCIE_tag;

typedef union M_CAN_TXEFC_union_tag {  /* Tx Event FIFO Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t EFWM:6;                  /* Event FIFO Watermark */
    vuint32_t _unused_22:2;
    vuint32_t EFS:6;                   /* Event FIFO Size */
    vuint32_t EFSA:14;                 /* Event FIFO Start Address */
    vuint32_t _unused_0:2;
  } B;
} M_CAN_TXEFC_tag;

typedef union M_CAN_TXEFS_union_tag {  /* Tx Event FIFO Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t TEFL:1;                  /* Tx Event FIFO Element Lost */
    vuint32_t EFF:1;                   /* Event FIFO Full */
    vuint32_t _unused_21:3;
    vuint32_t EFPI:5;                  /* Event FIFO Put Index */
    vuint32_t _unused_13:3;
    vuint32_t EFGI:5;                  /* Event FIFO Get Index */
    vuint32_t _unused_6:2;
    vuint32_t EFFL:6;                  /* Event FIFO Fill Level */
  } B;
} M_CAN_TXEFS_tag;

typedef union M_CAN_TXEFA_union_tag {  /* Tx Event FIFO Acknowledge Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t EFAI:5;                  /* Event FIFO Acknowledge Index */
  } B;
} M_CAN_TXEFA_tag;

struct M_CAN_tag {
  M_CAN_CREL_tag CREL;                 /* Core Release Register */
  M_CAN_ENDN_tag ENDN;                 /* Endian Register */
  uint8_t M_CAN_reserved0[4];
  M_CAN_FBTP_tag FBTP;                 /* Fast Bit Timing and Prescaler Register */
  M_CAN_TEST_tag TEST;                 /* Test Register */
  M_CAN_RWD_tag RWD;                   /* RAM Watchdog Register */
  M_CAN_CCCR_tag CCCR;                 /* CC Control Register */
  M_CAN_BTP_tag BTP;                   /* Bit Timing and Prescaler Register */
  M_CAN_TSCC_tag TSCC;                 /* Timestamp Counter Configuration Register */
  M_CAN_TSCV_tag TSCV;                 /* Timestamp Counter Value Register */
  M_CAN_TOCC_tag TOCC;                 /* Timeout Counter Configuration Register */
  M_CAN_TOCV_tag TOCV;                 /* Timeout Counter Value Register */
  uint8_t M_CAN_reserved1[16];
  M_CAN_ECR_tag ECR;                   /* Error Counter Register */
  M_CAN_PSR_tag PSR;                   /* Protocol Status Register */
  uint8_t M_CAN_reserved2[8];
  M_CAN_IR_tag IR;                     /* Interrupt Register */
  M_CAN_IE_tag IE;                     /* Interrupt Enable Register */
  M_CAN_ILS_tag ILS;                   /* Interrupt Line Select Register */
  M_CAN_ILE_tag ILE;                   /* Interrupt Line Enable Register */
  uint8_t M_CAN_reserved3[32];
  M_CAN_GFC_tag GFC;                   /* Global Filter Configuration Register */
  M_CAN_SIDFC_tag SIDFC;               /* Standard ID Filter Configuration Register */
  M_CAN_XIDFC_tag XIDFC;               /* Extended ID Filter Configuration Register */
  uint8_t M_CAN_reserved4[4];
  M_CAN_XIDAM_tag XIDAM;               /* Extended ID and Mask Register */
  M_CAN_HPMS_tag HPMS;                 /* High Priority Message Status Register */
  M_CAN_NDAT1_tag NDAT1;               /* New Data 1 Register */
  M_CAN_NDAT2_tag NDAT2;               /* New Data 2 Register */
  M_CAN_RXF0C_tag RXF0C;               /* Rx FIFO 0 Configuration Register */
  M_CAN_RXF0S_tag RXF0S;               /* Rx FIFO 0 Status Register */
  M_CAN_RXF0A_tag RXF0A;               /* Rx FIFO 0 Acknowledge Register */
  M_CAN_RXBC_tag RXBC;                 /* Rx Buffer Configuration Register */
  M_CAN_RXF1C_tag RXF1C;               /* Rx FIFO 1 Configuration Register */
  M_CAN_RXF1S_tag RXF1S;               /* Rx FIFO 1 Status Register */
  M_CAN_RXF1A_tag RXF1A;               /* Rx FIFO 1 Acknowledge Register */
  M_CAN_RXESC_tag RXESC;               /* Rx Buffer / FIFO Element Size Configuration Register */
  M_CAN_TXBC_tag TXBC;                 /* Tx Buffer Configuration Register */
  M_CAN_TXFQS_tag TXFQS;               /* Tx FIFO/Queue Status Register */
  M_CAN_TXESC_tag TXESC;               /* Tx Buffer Element Size Configuration */
  M_CAN_TXBRP_tag TXBRP;               /* Tx Buffer Request Pending Register */
  M_CAN_TXBAR_tag TXBAR;               /* Tx Buffer Add Request Register */
  M_CAN_TXBCR_tag TXBCR;               /* Tx Buffer Cancellation Request Register */
  M_CAN_TXBTO_tag TXBTO;               /* Tx Buffer Transmission Occurred Register */
  M_CAN_TXBCF_tag TXBCF;               /* Tx Buffer Cancellation Finished Register */
  M_CAN_TXBTIE_tag TXBTIE;             /* Tx Buffer Transmission Interrupt Enable Register */
  M_CAN_TXBCIE_tag TXBCIE;             /* Tx Buffer Cancellation Finished Interrupt Enable Register */
  uint8_t M_CAN_reserved5[8];
  M_CAN_TXEFC_tag TXEFC;               /* Tx Event FIFO Configuration Register */
  M_CAN_TXEFS_tag TXEFS;               /* Tx Event FIFO Status Register */
  M_CAN_TXEFA_tag TXEFA;               /* Tx Event FIFO Acknowledge Register */
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

typedef union PCM_IAHB_BE1_union_tag { /* IAHB Burst Enable 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t RSV:3;
    vuint32_t _unused_19:5;
    vuint32_t PRE_DMA:1;
    vuint32_t BRE_DMA:1;
    vuint32_t BWE_DMA:1;
    vuint32_t _unused_11:5;
    vuint32_t PRE_D2I:1;
    vuint32_t BRE_D2I:1;
    vuint32_t BWE_D2I:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_I2D:1;
    vuint32_t BRE_I2D:1;
    vuint32_t BWE_I2D:1;
  } B;
} PCM_IAHB_BE1_tag;

typedef union PCM_IAHB_BE2_union_tag { /* IAHB Burst Enable 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t RSV2:3;
    vuint32_t _unused_11:5;
    vuint32_t PRE_FEC:1;
    vuint32_t BRE_FEC:1;
    vuint32_t BWE_FEC:1;
    vuint32_t _unused_3:5;
    vuint32_t RSV1:3;
  } B;
} PCM_IAHB_BE2_tag;

typedef union PCM_IAHB_BE3_union_tag { /* IAHB Burst Enable 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PRE_AIPS1:1;
    vuint32_t BRE_AIPS1:1;
    vuint32_t BWE_AIPS1:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_AIPS0:1;
    vuint32_t BRE_AIPS0:1;
    vuint32_t BWE_AIPS0:1;
  } B;
} PCM_IAHB_BE3_tag;

typedef union PCM_IAHB_BE4_union_tag { /* IAHB Burst Enable 4 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t PRE_PRAM2:1;
    vuint32_t BRE_PRAM2:1;
    vuint32_t BWE_PRAM2:1;
    vuint32_t _unused_11:5;
    vuint32_t PRE_PRAM1:1;
    vuint32_t BRE_PRAM1:1;
    vuint32_t BWE_PRAM1:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_PRAM0:1;
    vuint32_t BRE_PRAM0:1;
    vuint32_t BWE_PRAM0:1;
  } B;
} PCM_IAHB_BE4_tag;

typedef union PCM_IAHB_BE5_union_tag { /* IAHB Burst Enable 5 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t PRE_Z7B:1;
    vuint32_t BRE_Z7B:1;
    vuint32_t BWE_Z7B:1;
    vuint32_t _unused_11:5;
    vuint32_t PRE_Z7A:1;
    vuint32_t BRE_Z7A:1;
    vuint32_t BWE_Z7A:1;
    vuint32_t _unused_3:5;
    vuint32_t PRE_SPT:1;
    vuint32_t BRE_SPT:1;
    vuint32_t BWE_SPT:1;
  } B;
} PCM_IAHB_BE5_tag;

struct PCM_tag {
  uint8_t PCM_reserved0[4];
  PCM_IAHB_BE1_tag IAHB_BE1;           /* IAHB Burst Enable 1 Register */
  PCM_IAHB_BE2_tag IAHB_BE2;           /* IAHB Burst Enable 2 Register */
  PCM_IAHB_BE3_tag IAHB_BE3;           /* IAHB Burst Enable 3 Register */
  PCM_IAHB_BE4_tag IAHB_BE4;           /* IAHB Burst Enable 4 Register */
  PCM_IAHB_BE5_tag IAHB_BE5;           /* IAHB Burst Enable 5 Register */
};


/* ============================================================================
   =============================== Module: PDI3 ===============================
   ============================================================================ */

typedef union PDI3_PDIMCR_union_tag {  /* PDI3 Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MODE:2;
    vuint32_t DAL:1;
    vuint32_t DEN:1;
    vuint32_t DMAEN:1;
    vuint32_t DMACON:1;
    vuint32_t DBIN:3;
    vuint32_t WIDTH:3;
    vuint32_t SCKE:1;
    vuint32_t FVP:1;
    vuint32_t LVP:1;
    vuint32_t INVD:1;
    vuint32_t FIFORST:1;
    vuint32_t _unused_14:1;
    vuint32_t BE:1;
    vuint32_t PBS:1;
    vuint32_t _unused_3:9;
    vuint32_t FIFOHIPRIOTRIG:3;
  } B;
} PDI3_PDIMCR_tag;

typedef union PDI3_PDIADCCR_union_tag { /* PDI3 ADC Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t ADCVALIDDELAY:8;
    vuint32_t ACTIVE_CHAN_NUM:4;
    vuint32_t ADC8283:1;
    vuint32_t LVKL:1;
    vuint32_t ADC_BE:1;
    vuint32_t DBA_EN:1;
    vuint32_t AUX_TC:1;
    vuint32_t AUX_DLY:3;
    vuint32_t _unused_11:1;
    vuint32_t AUX_LENGTH:3;
    vuint32_t _unused_7:1;
    vuint32_t STARTC:3;
    vuint32_t _unused_3:1;
    vuint32_t ENDC:3;
  } B;
} PDI3_PDIADCCR_tag;

typedef union PDI3_PDISR_union_tag {   /* PDI3 Status Register */
  vuint32_t R;
  struct {
    vuint32_t FF:1;
    vuint32_t FE:1;
    vuint32_t FO:1;
    vuint32_t FU:1;
    vuint32_t _unused_24:4;
    vuint32_t LVS:1;
    vuint32_t FVS:1;
    vuint32_t LC:1;
    vuint32_t FC:1;
    vuint32_t _unused_18:2;
    vuint32_t HE:1;
    vuint32_t DD:1;
    vuint32_t _unused_6:10;
    vuint32_t FIFO_COUNT:6;
  } B;
} PDI3_PDISR_tag;

typedef union PDI3_PDIINTER_union_tag { /* PDI3 Interrupt Enable */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t FOE:1;
    vuint32_t FUE:1;
    vuint32_t _unused_23:5;
    vuint32_t BCE:1;
    vuint32_t LCE:1;
    vuint32_t FCE:1;
    vuint32_t _unused_18:2;
    vuint32_t HEE:1;
    vuint32_t DDE:1;
    vuint32_t _unused_0:16;
  } B;
} PDI3_PDIINTER_tag;

typedef union PDI3_PDIAFOR_union_tag { /* PDI3 Active Frame Origin Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t ACT_FRM_ORG_Y:12;
    vuint32_t ACT_FRM_ORG_X:16;
  } B;
} PDI3_PDIAFOR_tag;

typedef union PDI3_PDIAFSR_union_tag { /* PDI3 Active Frame Size Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t ACTIVE_FRM_HEIGHT:12;
    vuint32_t ACTIVE_FRM_WIDTH:16;
  } B;
} PDI3_PDIAFSR_tag;

typedef union PDI3_PDIDMABAR_union_tag { /* PDI3 DMA Base Address Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_BASE_ADDR:27;
    vuint32_t _unused_0:5;
  } B;
} PDI3_PDIDMABAR_tag;

typedef union PDI3_PDIDMAASR_union_tag { /* PDI3 DMA Address Status Register */
  vuint32_t R;
  struct {
    vuint32_t DMA_ADDR_STAT:29;
    vuint32_t _unused_0:3;
  } B;
} PDI3_PDIDMAASR_tag;

typedef union PDI3_PDIDMASR_union_tag { /* PDI3 DMA Size */
  vuint32_t R;
  struct {
    vuint32_t DMA_SIZE:32;
  } B;
} PDI3_PDIDMASR_tag;

typedef union PDI3_PDIT1R_union_tag {  /* PDI3 Test 1 Register */
  vuint32_t R;
  struct {
    vuint32_t MC:1;
    vuint32_t _unused_16:15;
    vuint32_t TEST_VALUE_1:16;
  } B;
} PDI3_PDIT1R_tag;

typedef union PDI3_PDIT2R_union_tag {  /* PDI3 Test 2 Register */
  vuint32_t R;
  struct {
    vuint32_t TEST_VALUE_2:16;
    vuint32_t TEST_VALUE_3:16;
  } B;
} PDI3_PDIT2R_tag;

struct PDI3_tag {
  PDI3_PDIMCR_tag PDIMCR;              /* PDI3 Module Configuration Register */
  PDI3_PDIADCCR_tag PDIADCCR;          /* PDI3 ADC Configuration Register */
  PDI3_PDISR_tag PDISR;                /* PDI3 Status Register */
  PDI3_PDIINTER_tag PDIINTER;          /* PDI3 Interrupt Enable */
  PDI3_PDIAFOR_tag PDIAFOR;            /* PDI3 Active Frame Origin Register */
  PDI3_PDIAFSR_tag PDIAFSR;            /* PDI3 Active Frame Size Register */
  PDI3_PDIDMABAR_tag PDIDMABAR;        /* PDI3 DMA Base Address Register */
  PDI3_PDIDMAASR_tag PDIDMAASR;        /* PDI3 DMA Address Status Register */
  PDI3_PDIDMASR_tag PDIDMASR;          /* PDI3 DMA Size */
  PDI3_PDIT1R_tag PDIT1R;              /* PDI3 Test 1 Register */
  PDI3_PDIT2R_tag PDIT2R;              /* PDI3 Test 2 Register */
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

typedef union PFLASH_PFCR1_union_tag { /* Platform Flash Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t P0_M15PFE:1;
    vuint32_t P0_M14PFE:1;
    vuint32_t P0_M13PFE:1;
    vuint32_t P0_M12PFE:1;
    vuint32_t P0_M11PFE:1;
    vuint32_t P0_M10PFE:1;
    vuint32_t P0_M9PFE:1;
    vuint32_t P0_M8PFE:1;
    vuint32_t P0_M7PFE:1;
    vuint32_t P0_M6PFE:1;
    vuint32_t P0_M5PFE:1;
    vuint32_t P0_M4PFE:1;
    vuint32_t P0_M3PFE:1;
    vuint32_t P0_M2PFE:1;
    vuint32_t P0_M1PFE:1;
    vuint32_t P0_M0PFE:1;
    vuint32_t APC:3;
    vuint32_t _unused_12:1;
    vuint32_t RWSC:4;
    vuint32_t _unused_7:1;
    vuint32_t P0_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P0_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P0_PFLIM:2;
    vuint32_t P0_BFEN:1;
  } B;
} PFLASH_PFCR1_tag;

typedef union PFLASH_PFCR2_union_tag { /* Platform Flash Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t P1_M15PFE:1;
    vuint32_t P1_M14PFE:1;
    vuint32_t P1_M13PFE:1;
    vuint32_t P1_M12PFE:1;
    vuint32_t P1_M11PFE:1;
    vuint32_t P1_M10PFE:1;
    vuint32_t P1_M9PFE:1;
    vuint32_t P1_M8PFE:1;
    vuint32_t P1_M7PFE:1;
    vuint32_t P1_M6PFE:1;
    vuint32_t P1_M5PFE:1;
    vuint32_t P1_M4PFE:1;
    vuint32_t P1_M3PFE:1;
    vuint32_t P1_M2PFE:1;
    vuint32_t P1_M1PFE:1;
    vuint32_t P1_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P1_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P1_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P1_PFLIM:2;
    vuint32_t P1_BFEN:1;
  } B;
} PFLASH_PFCR2_tag;

typedef union PFLASH_PFCR3_union_tag { /* Platform Flash Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t P0_WCFG:2;
    vuint32_t P1_WCFG:2;
    vuint32_t P2_WCFG:2;
    vuint32_t _unused_21:5;
    vuint32_t _unused_20:1;
    vuint32_t _unused_17:3;
    vuint32_t BFEN_LK:1;
    vuint32_t ARBM:4;                  /* Arbitration Mode. This 4-bit field controls the arbitration of concurrent flash access requests from the three AHB ports of the flash memory controller. In both fixed priority or round-robin modes, write requests are prioritized higher than read requests, and read requests are prioritized higher than speculative prefetch requests whenever multiple ports issue concurrent requests. This field is initialized by hardware reset. Specifying a reserved value in this field causes it to default to round-robin arbitration. */
    vuint32_t _unused_1:11;
    vuint32_t _unused_0:1;
  } B;
} PFLASH_PFCR3_tag;

typedef union PFLASH_PFAPR_union_tag { /* Platform Flash Access Protection Register */
  vuint32_t R;
  struct {
    vuint32_t M0AP:2;
    vuint32_t M1AP:2;
    vuint32_t M2AP:2;
    vuint32_t M3AP:2;
    vuint32_t M4AP:2;
    vuint32_t M5AP:2;
    vuint32_t M6AP:2;
    vuint32_t M7AP:2;
    vuint32_t M8AP:2;
    vuint32_t M9AP:2;
    vuint32_t M10AP:2;
    vuint32_t M11AP:2;
    vuint32_t M12AP:2;
    vuint32_t M13AP:2;
    vuint32_t M14AP:2;
    vuint32_t M15AP:2;
  } B;
} PFLASH_PFAPR_tag;

typedef union PFLASH_PFCRCR_union_tag { /* Platform Flash Remap Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;
    vuint32_t SAFE_CAL:1;
    vuint32_t _unused_5:3;
    vuint32_t IRMEN:1;
    vuint32_t _unused_1:3;
    vuint32_t GRMEN:1;
  } B;
} PFLASH_PFCRCR_tag;

typedef union PFLASH_PFCRDE_union_tag { /* Platform Flash Remap Descriptor Enable Register */
  vuint32_t R;
  struct {
    vuint32_t CRD0EN:1;
    vuint32_t CRD1EN:1;
    vuint32_t CRD2EN:1;
    vuint32_t CRD3EN:1;
    vuint32_t CRD4EN:1;
    vuint32_t CRD5EN:1;
    vuint32_t CRD6EN:1;
    vuint32_t CRD7EN:1;
    vuint32_t _unused_0:24;
  } B;
} PFLASH_PFCRDE_tag;

typedef union PFLASH_PFCR4_union_tag { /* Platform Flash Configuration Register 4 */
  vuint32_t R;
  struct {
    vuint32_t P2_M15PFE:1;
    vuint32_t P2_M14PFE:1;
    vuint32_t P2_M13PFE:1;
    vuint32_t P2_M12PFE:1;
    vuint32_t P2_M11PFE:1;
    vuint32_t P2_M10PFE:1;
    vuint32_t P2_M9PFE:1;
    vuint32_t P2_M8PFE:1;
    vuint32_t P2_M7PFE:1;
    vuint32_t P2_M6PFE:1;
    vuint32_t P2_M5PFE:1;
    vuint32_t P2_M4PFE:1;
    vuint32_t P2_M3PFE:1;
    vuint32_t P2_M2PFE:1;
    vuint32_t P2_M1PFE:1;
    vuint32_t P2_M0PFE:1;
    vuint32_t _unused_7:9;
    vuint32_t P2_DPFEN:1;
    vuint32_t _unused_5:1;
    vuint32_t P2_IPFEN:1;
    vuint32_t _unused_3:1;
    vuint32_t P2_PFLIM:2;
    vuint32_t P2_BFEN:1;
  } B;
} PFLASH_PFCR4_tag;

typedef union PFLASH_PFCRD_Word0_union_tag { /* Platform Flash Calibration Region Descriptor n Word0 */
  vuint32_t R;
  struct {
    vuint32_t LSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word0_tag;

typedef union PFLASH_PFCRD_Word1_union_tag { /* Platform Flash Calibration Region Descriptor n Word1 */
  vuint32_t R;
  struct {
    vuint32_t PSTARTADDR:28;
    vuint32_t _unused_0:4;
  } B;
} PFLASH_PFCRD_Word1_tag;

typedef union PFLASH_PFCRD_Word2_union_tag { /* Platform Flash Calibration Region Descriptor n Word2 */
  vuint32_t R;
  struct {
    vuint32_t M0EN:1;
    vuint32_t M1EN:1;
    vuint32_t M2EN:1;
    vuint32_t M3EN:1;
    vuint32_t M4EN:1;
    vuint32_t M5EN:1;
    vuint32_t M6EN:1;
    vuint32_t M7EN:1;
    vuint32_t M8EN:1;
    vuint32_t M9EN:1;
    vuint32_t M10EN:1;
    vuint32_t M11EN:1;
    vuint32_t M12EN:1;
    vuint32_t M13EN:1;
    vuint32_t M14EN:1;
    vuint32_t M15EN:1;
    vuint32_t _unused_5:11;
    vuint32_t CRDSize:5;
  } B;
} PFLASH_PFCRD_Word2_tag;

typedef struct PFLASH_PFCRD_struct_tag {
  PFLASH_PFCRD_Word0_tag Word0;        /* Platform Flash Calibration Region Descriptor n Word0 */
  PFLASH_PFCRD_Word1_tag Word1;        /* Platform Flash Calibration Region Descriptor n Word1 */
  PFLASH_PFCRD_Word2_tag Word2;        /* Platform Flash Calibration Region Descriptor n Word2 */
  uint8_t PFCRD_reserved0[4];
} PFLASH_PFCRD_tag;

struct PFLASH_tag {
  PFLASH_PFCR1_tag PFCR1;              /* Platform Flash Configuration Register 1 */
  PFLASH_PFCR2_tag PFCR2;              /* Platform Flash Configuration Register 2 */
  PFLASH_PFCR3_tag PFCR3;              /* Platform Flash Configuration Register 3 */
  PFLASH_PFAPR_tag PFAPR;              /* Platform Flash Access Protection Register */
  PFLASH_PFCRCR_tag PFCRCR;            /* Platform Flash Remap Control Register */
  PFLASH_PFCRDE_tag PFCRDE;            /* Platform Flash Remap Descriptor Enable Register */
  PFLASH_PFCR4_tag PFCR4;              /* Platform Flash Configuration Register 4 */
  uint8_t PFLASH_reserved0[228];
  PFLASH_PFCRD_tag PFCRD[8];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

typedef union PIT_MCR_union_tag {      /* PIT Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t _unused_2:1;
    vuint32_t MDIS:1;                  /* Module Disable - (PIT section) */
    vuint32_t FRZ:1;                   /* Freeze */
  } B;
} PIT_MCR_tag;

typedef union PIT_LTMR64H_union_tag {  /* PIT Upper Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTH:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64H_tag;

typedef union PIT_LTMR64L_union_tag {  /* PIT Lower Lifetime Timer Register */
  vuint32_t R;
  struct {
    vuint32_t LTL:32;                  /* Life Timer value */
  } B;
} PIT_LTMR64L_tag;

typedef union PIT_TIMER_LDVAL_union_tag { /* Timer Load Value Register */
  vuint32_t R;
  struct {
    vuint32_t TSV:32;                  /* Timer Start Value */
  } B;
} PIT_TIMER_LDVAL_tag;

typedef union PIT_TIMER_CVAL_union_tag { /* Current Timer Value Register */
  vuint32_t R;
  struct {
    vuint32_t TVL:32;                  /* Current Timer Value */
  } B;
} PIT_TIMER_CVAL_tag;

typedef union PIT_TIMER_TCTRL_union_tag { /* Timer Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t CHN:1;                   /* Chain Mode */
    vuint32_t TIE:1;                   /* Timer Interrupt Enable */
    vuint32_t TEN:1;                   /* Timer Enable */
  } B;
} PIT_TIMER_TCTRL_tag;

typedef union PIT_TIMER_TFLG_union_tag { /* Timer Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Timer Interrupt Flag */
  } B;
} PIT_TIMER_TFLG_tag;

typedef struct PIT_TIMER_struct_tag {
  PIT_TIMER_LDVAL_tag LDVAL;           /* Timer Load Value Register */
  PIT_TIMER_CVAL_tag CVAL;             /* Current Timer Value Register */
  PIT_TIMER_TCTRL_tag TCTRL;           /* Timer Control Register */
  PIT_TIMER_TFLG_tag TFLG;             /* Timer Flag Register */
} PIT_TIMER_tag;

struct PIT_tag {
  PIT_MCR_tag MCR;                     /* PIT Module Control Register */
  uint8_t PIT_reserved0[220];
  PIT_LTMR64H_tag LTMR64H;             /* PIT Upper Lifetime Timer Register */
  PIT_LTMR64L_tag LTMR64L;             /* PIT Lower Lifetime Timer Register */
  uint8_t PIT_reserved1[24];
  PIT_TIMER_tag TIMER[4];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

typedef union PLLDIG_PLL0CR_union_tag { /* PLLDIG PLL0 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL0CR_tag;

typedef union PLLDIG_PLL0SR_union_tag { /* PLLDIG PLL0 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL0SR_tag;

typedef union PLLDIG_PLL0DV_union_tag { /* PLLDIG PLL0 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t RFDPHI1:4;               /* PHI1 reduced frequency divider. */
    vuint32_t _unused_22:5;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_15:1;
    vuint32_t PREDIV:3;                /* Input clock predivider. */
    vuint32_t _unused_7:5;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL0DV_tag;

typedef union PLLDIG_PLL1CR_union_tag { /* PLLDIG PLL1 Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t _unused_10:1;
    vuint32_t CLKCFG:2;                /* Clock Configuration */
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLIE:1;                 /* Loss-of-lock interrupt enable. */
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL1CR_tag;

typedef union PLLDIG_PLL1SR_union_tag { /* PLLDIG PLL1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_9:1;
    vuint32_t _unused_8:1;
    vuint32_t _unused_7:1;
    vuint32_t _unused_6:1;
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t LOLF:1;                  /* Loss-of-lock flag. */
    vuint32_t LOCK:1;
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} PLLDIG_PLL1SR_tag;

typedef union PLLDIG_PLL1DV_union_tag { /* PLLDIG PLL1 Divider Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_22:10;
    vuint32_t RFDPHI:6;                /* PHI reduced frequency divider. */
    vuint32_t _unused_11:5;
    vuint32_t _unused_7:4;
    vuint32_t MFD:7;                   /* Loop multiplication factor divider. */
  } B;
} PLLDIG_PLL1DV_tag;

typedef union PLLDIG_PLL1FM_union_tag { /* PLLDIG PLL1 Frequency Modulation Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t MODEN:1;                 /* Modulation enable. */
    vuint32_t MODSEL:1;                /* Modulation selection. */
    vuint32_t MODPRD:13;               /* Modulation period. */
    vuint32_t _unused_15:1;
    vuint32_t INCSTP:15;               /* Increment step. */
  } B;
} PLLDIG_PLL1FM_tag;

typedef union PLLDIG_PLL1FD_union_tag { /* PLLDIG PLL1 Fractional Divide Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t FDEN:1;                  /* Fractional Divide Enable */
    vuint32_t _unused_18:12;
    vuint32_t _unused_16:2;            /* Reserved. */
    vuint32_t _unused_12:4;
    vuint32_t FRCDIV:12;
  } B;
} PLLDIG_PLL1FD_tag;

struct PLLDIG_tag {
  PLLDIG_PLL0CR_tag PLL0CR;            /* PLLDIG PLL0 Control Register */
  PLLDIG_PLL0SR_tag PLL0SR;            /* PLLDIG PLL0 Status Register */
  PLLDIG_PLL0DV_tag PLL0DV;            /* PLLDIG PLL0 Divider Register */
  uint8_t PLLDIG_reserved0[20];
  PLLDIG_PLL1CR_tag PLL1CR;            /* PLLDIG PLL1 Control Register */
  PLLDIG_PLL1SR_tag PLL1SR;            /* PLLDIG PLL1 Status Register */
  PLLDIG_PLL1DV_tag PLL1DV;            /* PLLDIG PLL1 Divider Register */
  PLLDIG_PLL1FM_tag PLL1FM;            /* PLLDIG PLL1 Frequency Modulation Register */
  PLLDIG_PLL1FD_tag PLL1FD;            /* PLLDIG PLL1 Fractional Divide Register */
};


/* ============================================================================
   =============================== Module: PMC ================================
   ============================================================================ */

typedef union PMC_SMPS_CNTRL_union_tag { /* SMPS Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t _unused_16:8;
    vuint32_t _unused_15:1;            /* Reserved */
    vuint32_t PMC_SMPS_GI:4;           /* SMPS Overshoot Current Trimming */
    vuint32_t _unused_10:1;
    vuint32_t PMC_SMPS_ENILIM:1;       /* SMPS Inductor Current Limitation Enable */
    vuint32_t PMC_SMPS_ENCOR:1;        /* SMPS Hysteretic Correction Enable */
    vuint32_t _unused_6:2;             /* Reserved */
    vuint32_t PMC_SMPS_GD_SLOPE:2;     /* SMPS gate driver strength */
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t PMC_SMPS_SS:2;           /* SMPS spread spectrum control */
    vuint32_t PMC_SMPS_EN:1;           /* SMPS controller enable */
  } B;
} PMC_SMPS_CNTRL_tag;

typedef union PMC_STTW_union_tag {     /* LVD Self Test Time Window Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;           /* Reserved */
    vuint32_t STTW:12;                 /* Self Test Time Window. */
  } B;
} PMC_STTW_tag;

typedef union PMC_SELF_TEST_UM_VD_REG_union_tag { /* Voltage Detect User Mode Test Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_18:14;           /* Reserved */
    vuint32_t ST_RESULT:1;             /* ST_RESULT. Self Test result status. */
    vuint32_t ST_DONE:1;               /* Self Test Done status. */
    vuint32_t _unused_8:8;             /* Reserved */
    vuint32_t ST_MODE:2;               /* Self Test mode bits for testing of LVDs and HVDs. */
    vuint32_t _unused_4:2;             /* Reserved */
    vuint32_t VD_ST_CTRL:4;            /* Voltage Detect Self Test Control */
  } B;
} PMC_SELF_TEST_UM_VD_REG_tag;

typedef union PMC_AFE_INTR_ENA_union_tag { /* AFE Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t IE_EN:1;
    vuint32_t _unused_9:22;            /* Reserved */
    vuint32_t AFE_INT_EN_VREG9:1;      /* AFE-9 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG8:1;
    vuint32_t AFE_INT_EN_VREG7:1;      /* AFE-7 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG6:1;      /* AFE-6 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG5:1;      /* AFE-5 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG4:1;      /* AFE-4 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG3:1;      /* AFE-3 Interrupt Enable/Disable Control */
    vuint32_t AFE_INT_EN_VREG2:1;      /* AFE-2 Interrupt Enable/Disable Control */
    vuint32_t _unused_0:1;
  } B;
} PMC_AFE_INTR_ENA_tag;

typedef union PMC_AFE_INTR_STATUS_union_tag { /* AFE Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_9:23;            /* Reserved */
    vuint32_t AFE_INT_STATUS_VREG9:1;  /* AFE9-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG8:1;
    vuint32_t AFE_INT_STATUS_VREG7:1;  /* AFE7-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG6:1;  /* AFE6-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG5:1;  /* AFE5-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG4:1;  /* AFE4-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG3:1;  /* AFE3-Interrupt Status */
    vuint32_t AFE_INT_STATUS_VREG2:1;  /* AFE2-Interrupt Status */
    vuint32_t _unused_0:1;
  } B;
} PMC_AFE_INTR_STATUS_tag;

typedef union PMC_FIR_union_tag {      /* FCCU Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;            /* Reserved */
    vuint32_t STEST_FAULT:1;           /* A write to this bit sends a FCCU fault (single cycle) for LVD SELF TEST. This is self Clearing bit. */
    vuint32_t _unused_2:1;             /* Reserved. */
    vuint32_t HVD_FAULT:1;             /* High Voltage Detect Fault injection. */
    vuint32_t LVD_FAULT:1;             /* Low Voltage Detect Fault injection. */
  } B;
} PMC_FIR_tag;

typedef union PMC_PMCCR_union_tag {    /* PMC Control Register */
  vuint32_t R;
  struct {
    vuint32_t PMC_ENABLE:1;            /* PMC Enable Control */
    vuint32_t _unused_30:1;            /* Reserved */
    vuint32_t _unused_9:21;            /* Reserved */
    vuint32_t _unused_8:1;
    vuint32_t LVD_PMC_ENABLE:1;
    vuint32_t LVD_IO_ENABLE:1;
    vuint32_t _unused_5:1;
    vuint32_t LVD_FLASH_ENABLE:1;
    vuint32_t HVD_ADC_ENABLE:1;
    vuint32_t LVD_ADC_ENABLE:1;
    vuint32_t HVD_CORE_INT_ENABLE:1;
    vuint32_t LVD_CORE_INT_ENABLE_AND_LVD_PLL_ENABLE:1; /* LVD Core and LVD_PLL Enable Disable control bit. */
  } B;
} PMC_PMCCR_tag;

typedef union PMC_TS_IER_union_tag {   /* Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TS_EN:1;                 /* Temperature Sensor interrupts Enable */
    vuint32_t _unused_6:25;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TS1_2IE:1;               /* Temperature Sensor 1 input 2 Interrupt Enable. */
    vuint32_t TS1_0IE:1;               /* Temperature Sensor 1 input 0 Interrupt Enable. */
    vuint32_t _unused_2:1;
    vuint32_t TS0_2IE:1;               /* Temperature Sensor 0 input 2 Interrupt Enable. */
    vuint32_t TS0_0IE:1;               /* Temperature Sensor 0 input 0 Interrupt Enable. */
  } B;
} PMC_TS_IER_tag;

typedef union PMC_ESR_TD_union_tag {   /* Temperature Event Status register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t _unused_2:1;
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_ESR_TD_tag;

typedef union PMC_REE_TD_union_tag {   /* Temperature Reset Event Enable register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TEMP1_2:1;
    vuint32_t TEMP1_0:1;
    vuint32_t _unused_2:1;
    vuint32_t TEMP0_2:1;
    vuint32_t TEMP0_0:1;
  } B;
} PMC_REE_TD_tag;

typedef union PMC_RES_TD_union_tag {   /* Temperature Reset Event Selection register */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;            /* Reserved */
    vuint32_t _unused_5:1;
    vuint32_t TEMP1_2:1;               /* TEMP1_2 Reset Event Select. */
    vuint32_t TEMP1_0:1;               /* TEMP1_0 Reset Event Select. */
    vuint32_t _unused_2:1;
    vuint32_t TEMP0_2:1;               /* TEMP0_2 Reset Event Select. */
    vuint32_t TEMP0_0:1;               /* TEMP0_0 Reset Event Select. */
  } B;
} PMC_RES_TD_tag;

typedef union PMC_CTL_TD_union_tag {   /* Temperature detector configuration register */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;           /* Reserved */
    vuint32_t TS1_TRIM_ADJ:5;
    vuint32_t TS1_DOUT_EN:1;
    vuint32_t TS1_AOUT_EN:1;
    vuint32_t _unused_7:1;             /* Reserved */
    vuint32_t TS0_TRIM_ADJ:5;
    vuint32_t TS0_DOUT_EN:1;
    vuint32_t TS0_AOUT_EN:1;
  } B;
} PMC_CTL_TD_tag;

typedef union PMC_TS_FIR_union_tag {   /* Fault Injection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;            /* Reserved */
    vuint32_t TSNS_FAULT:1;            /* Temperature Sensor Fault injection. */
  } B;
} PMC_TS_FIR_tag;

struct PMC_tag {
  uint8_t PMC_reserved0[100];
  PMC_SMPS_CNTRL_tag SMPS_CNTRL;       /* SMPS Control Register */
  PMC_STTW_tag STTW;                   /* LVD Self Test Time Window Register */
  PMC_SELF_TEST_UM_VD_REG_tag SELF_TEST_UM_VD_REG; /* Voltage Detect User Mode Test Register */
  uint8_t PMC_reserved1[8];
  PMC_AFE_INTR_ENA_tag AFE_INTR_ENA;   /* AFE Interrupt Enable Register */
  uint8_t PMC_reserved2[4];
  PMC_AFE_INTR_STATUS_tag AFE_INTR_STATUS; /* AFE Interrupt Status Register */
  uint8_t PMC_reserved3[8];
  PMC_FIR_tag FIR;                     /* FCCU Fault Injection Register */
  uint8_t PMC_reserved4[4];
  PMC_PMCCR_tag PMCCR;                 /* PMC Control Register */
  PMC_TS_IER_tag TS_IER;               /* Interrupt Enable Register */
  PMC_ESR_TD_tag ESR_TD;               /* Temperature Event Status register */
  PMC_REE_TD_tag REE_TD;               /* Temperature Reset Event Enable register */
  PMC_RES_TD_tag RES_TD;               /* Temperature Reset Event Selection register */
  PMC_CTL_TD_tag CTL_TD;               /* Temperature detector configuration register */
  uint8_t PMC_reserved5[8];
  PMC_TS_FIR_tag TS_FIR;               /* Fault Injection Register */
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

typedef union PRAMC_PRCR1_union_tag {  /* Platform RAM Configuration Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR1_tag;

typedef union PRAMC_PRCR2_union_tag {  /* Platform RAM Configuration Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR2_tag;

typedef union PRAMC_PRCR3_union_tag {  /* Platform RAM Configuration Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR3_tag;

typedef union PRAMC_PRCR4_union_tag {  /* Platform RAM Configuration Register 4 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR4_tag;

typedef union PRAMC_PRCR5_union_tag {  /* Platform RAM Configuration Register 5 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR5_tag;

typedef union PRAMC_PRCR6_union_tag {  /* Platform RAM Configuration Register 6 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR6_tag;

typedef union PRAMC_PRCR7_union_tag {  /* Platform RAM Configuration Register 7 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t _unused_8:2;
    vuint32_t _unused_7:1;
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable. */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR7_tag;

typedef union PRAMC_PRCR8_union_tag {  /* Platform RAM Configuration Register 8 */
  vuint32_t R;
  struct {
    vuint32_t _unused_10:22;
    vuint32_t PRI:2;                   /* AHB port arbitration mode. */
    vuint32_t P1_BO_DIS:1;             /* Port p1 read burst optimization disable. */
    vuint32_t P0_BO_DIS:1;             /* Port p0 read burst optimization disable */
    vuint32_t _unused_1:5;
    vuint32_t FT_DIS:1;                /* Flow through disabled. */
  } B;
} PRAMC_PRCR8_tag;

struct PRAMC_tag {
  PRAMC_PRCR1_tag PRCR1;               /* Platform RAM Configuration Register 1 */
  PRAMC_PRCR2_tag PRCR2;               /* Platform RAM Configuration Register 2 */
  PRAMC_PRCR3_tag PRCR3;               /* Platform RAM Configuration Register 3 */
  PRAMC_PRCR4_tag PRCR4;               /* Platform RAM Configuration Register 4 */
  PRAMC_PRCR5_tag PRCR5;               /* Platform RAM Configuration Register 5 */
  PRAMC_PRCR6_tag PRCR6;               /* Platform RAM Configuration Register 6 */
  PRAMC_PRCR7_tag PRCR7;               /* Platform RAM Configuration Register 7 */
  PRAMC_PRCR8_tag PRCR8;               /* Platform RAM Configuration Register 8 */
};


/* ============================================================================
   =============================== Module: PRAM_XBAR ==========================
   ============================================================================ */

typedef union PRAM_XBAR_CHANNEL_PRS_union_tag { /* Priority Register Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_15:17;
    vuint32_t M3:3;                    /* Master 3 Priority */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority */
  } B;
} PRAM_XBAR_CHANNEL_PRS_tag;

typedef union PRAM_XBAR_CHANNEL_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t _unused_10:21;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} PRAM_XBAR_CHANNEL_CRS_tag;

typedef struct PRAM_XBAR_CHANNEL_struct_tag {
  PRAM_XBAR_CHANNEL_PRS_tag PRS;       /* Priority Register Slave */
  uint8_t CHANNEL_reserved0[12];
  PRAM_XBAR_CHANNEL_CRS_tag CRS;       /* Control Register */
  uint8_t CHANNEL_reserved1[236];
} PRAM_XBAR_CHANNEL_tag;

struct PRAM_XBAR_tag {
  PRAM_XBAR_CHANNEL_tag CHANNEL[8];
};


/* ============================================================================
   =============================== Module: RGM ================================
   ============================================================================ */

typedef union RGM_DES_union_tag {      /* 'Destructive' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t F_AFE_LVD9:1;
    vuint32_t F_AFE_LVD6:1;
    vuint32_t F_AFE_LVD8:1;
    vuint32_t F_AFE_LVD7:1;
    vuint32_t F_TSR_DEST:1;
    vuint32_t F_AFE_LVD5:1;
    vuint32_t F_AFE_LVD4:1;
    vuint32_t F_AFE_LVD3:1;
    vuint32_t F_AFE_LVD2:1;
    vuint32_t _unused_18:1;
    vuint32_t F_AFE_LVD0:1;
    vuint32_t F_LVD_PMC:1;
    vuint32_t F_LVD_IO:1;
    vuint32_t F_LVD_PLL:1;
    vuint32_t F_LVD_FLASH:1;
    vuint32_t F_HVD_ADC:1;
    vuint32_t F_LVD_ADC:1;
    vuint32_t F_HVD_CORE:1;
    vuint32_t F_LVD_CORE:1;
    vuint32_t F_EDR:1;
    vuint32_t _unused_6:2;
    vuint32_t F_STCU_SUF:1;
    vuint32_t F_FFRR:1;
    vuint32_t F_SOFT_DEST:1;
    vuint32_t _unused_1:2;
    vuint32_t F_POR:1;
  } B;
} RGM_DES_tag;

typedef union RGM_DERD_union_tag {     /* 'Destructive' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t D_AFE_LVD9:1;
    vuint32_t D_AFE_LVD6:1;
    vuint32_t D_AFE_LVD8:1;
    vuint32_t D_AFE_LVD7:1;
    vuint32_t D_TSR_DEST:1;
    vuint32_t D_AFE_LVD5:1;
    vuint32_t D_AFE_LVD4:1;
    vuint32_t D_AFE_LVD3:1;
    vuint32_t D_AFE_LVD2:1;
    vuint32_t D_AFE_LVD1:1;
    vuint32_t D_AFE_LVD0:1;
    vuint32_t D_LVD_PMC:1;
    vuint32_t D_LVD_IO:1;
    vuint32_t D_LVD_PLL:1;
    vuint32_t D_LVD_FLASH:1;
    vuint32_t D_HVD_ADC:1;
    vuint32_t D_LVD_ADC:1;
    vuint32_t D_HVD_CORE:1;
    vuint32_t D_LVD_CORE:1;
    vuint32_t D_EDR:1;
    vuint32_t _unused_6:2;
    vuint32_t D_STCU_SUF:1;
    vuint32_t D_FFRR:1;
    vuint32_t D_SOFT_DEST:1;
    vuint32_t _unused_1:2;
    vuint32_t D_POR:1;
  } B;
} RGM_DERD_tag;

typedef union RGM_DEAR_union_tag {     /* 'Destructive' Event Alternate Request Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t AR_TSR_DEST:1;
    vuint32_t _unused_0:23;
  } B;
} RGM_DEAR_tag;

typedef union RGM_FES_union_tag {      /* 'Functional' Event Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t F_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t F_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t F_FCCU_SOFT:1;
    vuint32_t F_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t F_SOFT_FUNC:1;
    vuint32_t F_ST_DONE:1;
    vuint32_t _unused_1:1;
    vuint32_t F_EXR:1;
  } B;
} RGM_FES_tag;

typedef union RGM_FERD_union_tag {     /* 'Functional' Event Reset Disable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_24:8;
    vuint32_t D_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t D_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t D_FCCU_SOFT:1;
    vuint32_t D_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t D_SOFT_FUNC:1;
    vuint32_t D_ST_DONE:1;
    vuint32_t _unused_0:2;
  } B;
} RGM_FERD_tag;

typedef union RGM_FEAR_union_tag {     /* 'Functional' Event Alternate Request Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t AR_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t AR_JTAG_FUNC:1;
    vuint32_t _unused_1:9;
    vuint32_t _unused_0:1;
  } B;
} RGM_FEAR_tag;

typedef union RGM_FBRE_union_tag {     /* 'Functional' Bidirectional Reset Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t BE_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t BE_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t BE_FCCU_SOFT:1;
    vuint32_t BE_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t BE_SOFT_FUNC:1;
    vuint32_t BE_ST_DONE:1;
    vuint32_t _unused_1:1;
    vuint32_t BE_EXR:1;
  } B;
} RGM_FBRE_tag;

typedef union RGM_FESS_union_tag {     /* 'Functional' Event Short Sequence Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_25:7;
    vuint32_t _unused_24:1;
    vuint32_t SS_TSR_FUNC:1;
    vuint32_t _unused_11:12;
    vuint32_t SS_JTAG_FUNC:1;
    vuint32_t _unused_7:3;
    vuint32_t SS_FCCU_SOFT:1;
    vuint32_t SS_FCCU_HARD:1;
    vuint32_t _unused_4:1;
    vuint32_t SS_SOFT_FUNC:1;
    vuint32_t SS_ST_DONE:1;
    vuint32_t _unused_1:1;
    vuint32_t SS_EXR:1;
  } B;
} RGM_FESS_tag;

typedef union RGM_FRET_union_tag {     /* 'Functional' Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t FRET:4;
  } B;
} RGM_FRET_tag;

typedef union RGM_DRET_union_tag {     /* Destructive Reset Escalation Threshold Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t DRET:4;
  } B;
} RGM_DRET_tag;

struct RGM_tag {
  RGM_DES_tag DES;                     /* 'Destructive' Event Status Register */
  uint8_t RGM_reserved0[12];
  RGM_DERD_tag DERD;                   /* 'Destructive' Event Reset Disable Register */
  uint8_t RGM_reserved1[12];
  RGM_DEAR_tag DEAR;                   /* 'Destructive' Event Alternate Request Register */
  uint8_t RGM_reserved2[732];
  RGM_FES_tag FES;                     /* 'Functional' Event Status Register */
  uint8_t RGM_reserved3[12];
  RGM_FERD_tag FERD;                   /* 'Functional' Event Reset Disable Register */
  uint8_t RGM_reserved4[12];
  RGM_FEAR_tag FEAR;                   /* 'Functional' Event Alternate Request Register */
  uint8_t RGM_reserved5[12];
  RGM_FBRE_tag FBRE;                   /* 'Functional' Bidirectional Reset Enable Register */
  uint8_t RGM_reserved6[12];
  RGM_FESS_tag FESS;                   /* 'Functional' Event Short Sequence Register */
  uint8_t RGM_reserved7[704];
  RGM_FRET_tag FRET;                   /* 'Functional' Reset Escalation Threshold Register */
  uint8_t RGM_reserved8[3];
  RGM_DRET_tag DRET;                   /* Destructive Reset Escalation Threshold Register */
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

typedef union SEMA42_GATE_union_tag {  /* Gate Register */
  vuint8_t R;
  struct {
    vuint8_t _unused_4:4;
    vuint8_t GTFSM:4;                  /* Gate Finite State Machine. */
  } B;
} SEMA42_GATE_tag;

typedef union SEMA42_RSTGT_R_union_tag { /* Reset Gate Read */
  vuint16_t R;
  struct {
    vuint16_t ROZ:2;
    vuint16_t RSTGSM:2;
    vuint16_t RSTGMS:4;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_R_tag;

typedef union SEMA42_RSTGT_W_union_tag { /* Reset Gate Write */
  vuint16_t R;
  struct {
    vuint16_t RSTGDP:8;
    vuint16_t RSTGTN:8;
  } B;
} SEMA42_RSTGT_W_tag;

typedef union SEMA42_RSTGT_union_tag {
  SEMA42_RSTGT_R_tag R;                /* Reset Gate Read */
  SEMA42_RSTGT_W_tag W;                /* Reset Gate Write */
} SEMA42_RSTGT_tag;

struct SEMA42_tag {
  SEMA42_GATE_tag GATE[16];            /* Gate Register */
  uint8_t SEMA42_reserved0[48];
  SEMA42_RSTGT_tag RSTGT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

typedef union SIPI_CCR0_union_tag {    /* SIPI Channel Control Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_8:8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR0_tag;

typedef union SIPI_CSR0_union_tag {    /* SIPI Channel Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t _unused_0:2;
  } B;
} SIPI_CSR0_tag;

typedef union SIPI_CIR0_union_tag {    /* SIPI Channel Interrupt Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t WAIE:1;                  /* Write Acknowledge Interrupt Enable. */
    vuint32_t RAIE:1;                  /* Read Answer Interrupt Enable. */
    vuint32_t TCIE:1;                  /* Trigger Command Interrupt Enable. */
    vuint32_t TOIE:1;                  /* Timeout Error Interrupt Enabled. */
    vuint32_t TIDIE:1;                 /* Transaction ID Error Interrupt Enable. */
    vuint32_t ACKIE:1;                 /* Acknowledge Error Interrupt Enable. */
  } B;
} SIPI_CIR0_tag;

typedef union SIPI_CTOR0_union_tag {   /* SIPI Channel Timeout Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR0_tag;

typedef union SIPI_CCRC0_union_tag {   /* SIPI Channel CRC Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC0_tag;

typedef union SIPI_CAR0_union_tag {    /* SIPI Channel Address Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR0_tag;

typedef union SIPI_CDR0_union_tag {    /* SIPI Channel Data Register 0 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR0_tag;

typedef union SIPI_CCR1_union_tag {    /* SIPI Channel Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_8:8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR1_tag;

typedef union SIPI_CSR1_union_tag {    /* SIPI Channel Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RAR:1;
    vuint32_t TID:3;
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t _unused_0:2;
  } B;
} SIPI_CSR1_tag;

typedef union SIPI_CIR1_union_tag {    /* SIPI Channel Interrupt Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR1_tag;

typedef union SIPI_CTOR1_union_tag {   /* SIPI Channel Timeout Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR1_tag;

typedef union SIPI_CCRC1_union_tag {   /* SIPI Channel CRC Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC1_tag;

typedef union SIPI_CAR1_union_tag {    /* SIPI Channel Address Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR1_tag;

typedef union SIPI_CDR1_union_tag {    /* SIPI Channel Data Register 1 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR1_tag;

typedef union SIPI_CCR2_union_tag {    /* SIPI Channel Control Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_8:8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR2_tag;

typedef union SIPI_CSR2_union_tag {    /* SIPI Channel Status Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t _unused_0:2;
  } B;
} SIPI_CSR2_tag;

typedef union SIPI_CIR2_union_tag {    /* SIPI Channel Interrupt Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR2_tag;

typedef union SIPI_CTOR2_union_tag {   /* SIPI Channel Timeout Register 2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TOR:8;
  } B;
} SIPI_CTOR2_tag;

typedef union SIPI_CCRC2_union_tag {   /* SIPI Channel CRC Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC2_tag;

typedef union SIPI_CAR2_union_tag {    /* SIPI Channel Address Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR2_tag;

typedef union SIPI_CDR2_union_tag {    /* SIPI Channel Data Register 2 */
  vuint32_t R;
  struct {
    vuint32_t CDR2:32;
  } B;
} SIPI_CDR2_tag;

typedef union SIPI_CCR3_union_tag {    /* SIPI Channel Control Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_17:15;
    vuint32_t TC:1;                    /* Send Trigger Command. */
    vuint32_t _unused_8:8;
    vuint32_t WL:2;                    /* Word Length Transfer. */
    vuint32_t CHEN:1;                  /* Channel Enable. */
    vuint32_t ST:1;                    /* Streaming Transfer. */
    vuint32_t IDT:1;                   /* ID Read Request Transfer. */
    vuint32_t RRT:1;                   /* Read Request Transfer. */
    vuint32_t WRT:1;                   /* Write Request Transfer. */
    vuint32_t DEN:1;                   /* DMA Enable. */
  } B;
} SIPI_CCR3_tag;

typedef union SIPI_CSR3_union_tag {    /* SIPI Channel Status Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t RAR:1;
    vuint32_t TID:3;                   /* Transaction ID of transmitted frame. */
    vuint32_t ACKR:1;
    vuint32_t CB:1;                    /* Channel Busy. */
    vuint32_t _unused_0:2;
  } B;
} SIPI_CSR3_tag;

typedef union SIPI_CIR3_union_tag {    /* SIPI Channel Interrupt Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_6:26;
    vuint32_t WAIE:1;
    vuint32_t RAIE:1;
    vuint32_t TCIE:1;
    vuint32_t TOIE:1;
    vuint32_t TIDIE:1;
    vuint32_t ACKIE:1;
  } B;
} SIPI_CIR3_tag;

typedef union SIPI_CTOR3_union_tag {   /* SIPI Channel Timeout Register 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TOR:8;                   /* Timeout value for transmitted requests. */
  } B;
} SIPI_CTOR3_tag;

typedef union SIPI_CCRC3_union_tag {   /* SIPI Channel CRC Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CRCI:16;
    vuint32_t CRCT:16;
  } B;
} SIPI_CCRC3_tag;

typedef union SIPI_CAR3_union_tag {    /* SIPI Channel Address Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CAR:32;
  } B;
} SIPI_CAR3_tag;

typedef union SIPI_CDR3_union_tag {    /* SIPI Channel Data Register 3 */
  vuint32_t R;
  struct {
    vuint32_t CDR:32;
  } B;
} SIPI_CDR3_tag;

typedef union SIPI_MCR_union_tag {     /* SIPI Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t FRZ:1;                   /* Freeze Enable */
    vuint32_t _unused_30:1;
    vuint32_t HALT:1;                  /* Halt Mode Enable */
    vuint32_t _unused_27:2;
    vuint32_t PRSCLR:11;               /* Timeout counter prescaler */
    vuint32_t AID:2;                   /* Address Increment/Decrement */
    vuint32_t _unused_11:3;
    vuint32_t CRCIE:1;                 /* CRC Error Interrupt Enable */
    vuint32_t MCRIE:1;                 /* Max Count Reached Interrupt Enable */
    vuint32_t _unused_5:4;
    vuint32_t CHNSB:1;                 /* Channel coding select bit. */
    vuint32_t TEN:1;                   /* Target Enable */
    vuint32_t INIT:1;                  /* Initialization Mode */
    vuint32_t MOEN:1;                  /* Module Enable */
    vuint32_t SR:1;                    /* Soft Reset */
  } B;
} SIPI_MCR_tag;

typedef union SIPI_SR_union_tag {      /* SIPI Status Register */
  vuint32_t R;
  struct {
    vuint32_t FRZACK:1;
    vuint32_t LPMACK:1;                /* Low Power Mode Acknowledge. */
    vuint32_t _unused_11:19;
    vuint32_t GCRCE:1;
    vuint32_t MCR:1;                   /* Maximum Count Reached. */
    vuint32_t _unused_8:1;
    vuint32_t TE:4;
    vuint32_t STATE:4;
  } B;
} SIPI_SR_tag;

typedef union SIPI_MAXCR_union_tag {   /* SIPI Max Count Register */
  vuint32_t R;
  struct {
    vuint32_t MXCNT:30;
    vuint32_t _unused_0:2;
  } B;
} SIPI_MAXCR_tag;

typedef union SIPI_ARR_union_tag {     /* SIPI Address Reload Register */
  vuint32_t R;
  struct {
    vuint32_t ADRLD:30;
    vuint32_t _unused_0:2;
  } B;
} SIPI_ARR_tag;

typedef union SIPI_ACR_union_tag {     /* SIPI Address Count Register */
  vuint32_t R;
  struct {
    vuint32_t ADCNT:30;                /* Feflects the count value of address counter at target node. */
    vuint32_t _unused_0:2;
  } B;
} SIPI_ACR_tag;

typedef union SIPI_ERR_union_tag {     /* SIPI Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t TOE3:1;
    vuint32_t TIDE3:1;
    vuint32_t ACKE3:1;
    vuint32_t _unused_19:5;
    vuint32_t TOE2:1;
    vuint32_t TIDE2:1;
    vuint32_t ACKE2:1;
    vuint32_t _unused_11:5;
    vuint32_t TOE1:1;
    vuint32_t TIDE1:1;
    vuint32_t ACKE1:1;
    vuint32_t _unused_3:5;
    vuint32_t TOE0:1;
    vuint32_t TIDE0:1;
    vuint32_t ACKE0:1;
  } B;
} SIPI_ERR_tag;

struct SIPI_tag {
  SIPI_CCR0_tag CCR0;                  /* SIPI Channel Control Register 0 */
  SIPI_CSR0_tag CSR0;                  /* SIPI Channel Status Register 0 */
  uint8_t SIPI_reserved0[4];
  SIPI_CIR0_tag CIR0;                  /* SIPI Channel Interrupt Register 0 */
  SIPI_CTOR0_tag CTOR0;                /* SIPI Channel Timeout Register 0 */
  SIPI_CCRC0_tag CCRC0;                /* SIPI Channel CRC Register 0 */
  SIPI_CAR0_tag CAR0;                  /* SIPI Channel Address Register 0 */
  SIPI_CDR0_tag CDR0;                  /* SIPI Channel Data Register 0 */
  SIPI_CCR1_tag CCR1;                  /* SIPI Channel Control Register 1 */
  SIPI_CSR1_tag CSR1;                  /* SIPI Channel Status Register 1 */
  uint8_t SIPI_reserved1[4];
  SIPI_CIR1_tag CIR1;                  /* SIPI Channel Interrupt Register 1 */
  SIPI_CTOR1_tag CTOR1;                /* SIPI Channel Timeout Register 1 */
  SIPI_CCRC1_tag CCRC1;                /* SIPI Channel CRC Register 1 */
  SIPI_CAR1_tag CAR1;                  /* SIPI Channel Address Register 1 */
  SIPI_CDR1_tag CDR1;                  /* SIPI Channel Data Register 1 */
  SIPI_CCR2_tag CCR2;                  /* SIPI Channel Control Register 2 */
  SIPI_CSR2_tag CSR2;                  /* SIPI Channel Status Register 2 */
  uint8_t SIPI_reserved2[4];
  SIPI_CIR2_tag CIR2;                  /* SIPI Channel Interrupt Register 2 */
  SIPI_CTOR2_tag CTOR2;                /* SIPI Channel Timeout Register 2 */
  SIPI_CCRC2_tag CCRC2;                /* SIPI Channel CRC Register 2 */
  SIPI_CAR2_tag CAR2;                  /* SIPI Channel Address Register 2 */
  SIPI_CDR2_tag CDR2[8];               /* SIPI Channel Data Register 2 */
  SIPI_CCR3_tag CCR3;                  /* SIPI Channel Control Register 3 */
  SIPI_CSR3_tag CSR3;                  /* SIPI Channel Status Register 3 */
  uint8_t SIPI_reserved3[4];
  SIPI_CIR3_tag CIR3;                  /* SIPI Channel Interrupt Register 3 */
  SIPI_CTOR3_tag CTOR3;                /* SIPI Channel Timeout Register 3 */
  SIPI_CCRC3_tag CCRC3;                /* SIPI Channel CRC Register 3 */
  SIPI_CAR3_tag CAR3;                  /* SIPI Channel Address Register 3 */
  SIPI_CDR3_tag CDR3;                  /* SIPI Channel Data Register 3 */
  SIPI_MCR_tag MCR;                    /* SIPI Module Configuration Register */
  SIPI_SR_tag SR;                      /* SIPI Status Register */
  SIPI_MAXCR_tag MAXCR;                /* SIPI Max Count Register */
  SIPI_ARR_tag ARR;                    /* SIPI Address Reload Register */
  SIPI_ACR_tag ACR;                    /* SIPI Address Count Register */
  SIPI_ERR_tag ERR;                    /* SIPI Error Register */
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

typedef union SIUL2_MIDR1_union_tag {  /* SIUL2 MCU ID Register #1 */
  vuint32_t R;
  struct {
    vuint32_t PARTNUM:16;              /* MCU Part Number */
    vuint32_t ED:1;
    vuint32_t PKG:5;                   /* Package Settings */
    vuint32_t _unused_8:2;
    vuint32_t MAJOR_MASK:4;            /* Major Mask Revision */
    vuint32_t MINOR_MASK:4;            /* Minor Mask Revision */
  } B;
} SIUL2_MIDR1_tag;

typedef union SIUL2_MIDR2_union_tag {  /* SIUL2 MCU ID Register #2 */
  vuint32_t R;
  struct {
    vuint32_t SF:1;                    /* Manufacturer */
    vuint32_t FLASH_SIZE_1:4;          /* Coarse granularity for flash memory size */
    vuint32_t FLASH_SIZE_2:4;          /* Fine granularity for flash memory size */
    vuint32_t _unused_16:7;
    vuint32_t PARTNUM:8;               /* ASCII character in MCU Part Number */
    vuint32_t _unused_0:8;
  } B;
} SIUL2_MIDR2_tag;

typedef union SIUL2_DISR0_union_tag {  /* SIUL2 DMA/Interrupt Status Flag Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIF31:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF30:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF29:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF28:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF27:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF26:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF25:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF24:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF23:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF22:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF21:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF20:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF19:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF18:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF17:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF16:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF15:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF14:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF13:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF12:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF11:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF10:1;                 /* External Interrupt Status Flag x */
    vuint32_t EIF9:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF8:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF7:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF6:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF5:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF4:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF3:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF2:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF1:1;                  /* External Interrupt Status Flag x */
    vuint32_t EIF0:1;                  /* External Interrupt Status Flag x */
  } B;
} SIUL2_DISR0_tag;

typedef union SIUL2_DIRER0_union_tag { /* SIUL2 DMA/Interrupt Request Enable Register0 */
  vuint32_t R;
  struct {
    vuint32_t EIRE31:1;
    vuint32_t EIRE30:1;
    vuint32_t EIRE29:1;
    vuint32_t EIRE28:1;
    vuint32_t EIRE27:1;
    vuint32_t EIRE26:1;
    vuint32_t EIRE25:1;
    vuint32_t EIRE24:1;
    vuint32_t EIRE23:1;
    vuint32_t EIRE22:1;
    vuint32_t EIRE21:1;
    vuint32_t EIRE20:1;
    vuint32_t EIRE19:1;
    vuint32_t EIRE18:1;
    vuint32_t EIRE17:1;
    vuint32_t EIRE16:1;
    vuint32_t EIRE15:1;
    vuint32_t EIRE14:1;
    vuint32_t EIRE13:1;
    vuint32_t EIRE12:1;
    vuint32_t EIRE11:1;
    vuint32_t EIRE10:1;
    vuint32_t EIRE9:1;
    vuint32_t EIRE8:1;
    vuint32_t EIRE7:1;
    vuint32_t EIRE6:1;
    vuint32_t EIRE5:1;
    vuint32_t EIRE4:1;
    vuint32_t EIRE3:1;
    vuint32_t EIRE2:1;
    vuint32_t EIRE1:1;
    vuint32_t EIRE0:1;
  } B;
} SIUL2_DIRER0_tag;

typedef union SIUL2_DIRSR0_union_tag { /* SIUL2 DMA/Interrupt Request Select Register0 */
  vuint32_t R;
  struct {
    vuint32_t DIRSR31:1;
    vuint32_t DIRSR30:1;
    vuint32_t DIRSR29:1;
    vuint32_t DIRSR28:1;
    vuint32_t DIRSR27:1;
    vuint32_t DIRSR26:1;
    vuint32_t DIRSR25:1;
    vuint32_t DIRSR24:1;
    vuint32_t DIRSR23:1;
    vuint32_t DIRSR22:1;
    vuint32_t DIRSR21:1;
    vuint32_t DIRSR20:1;
    vuint32_t DIRSR19:1;
    vuint32_t DIRSR18:1;
    vuint32_t DIRSR17:1;
    vuint32_t DIRSR16:1;
    vuint32_t DIRSR15:1;
    vuint32_t DIRSR14:1;
    vuint32_t DIRSR13:1;
    vuint32_t DIRSR12:1;
    vuint32_t DIRSR11:1;
    vuint32_t DIRSR10:1;
    vuint32_t DIRSR9:1;
    vuint32_t DIRSR8:1;
    vuint32_t DIRSR7:1;
    vuint32_t DIRSR6:1;
    vuint32_t DIRSR5:1;
    vuint32_t DIRSR4:1;
    vuint32_t DIRSR3:1;
    vuint32_t DIRSR2:1;
    vuint32_t DIRSR1:1;
    vuint32_t DIRSR0:1;
  } B;
} SIUL2_DIRSR0_tag;

typedef union SIUL2_IREER0_union_tag { /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IREE31:1;
    vuint32_t IREE30:1;
    vuint32_t IREE29:1;
    vuint32_t IREE28:1;
    vuint32_t IREE27:1;
    vuint32_t IREE26:1;
    vuint32_t IREE25:1;
    vuint32_t IREE24:1;
    vuint32_t IREE23:1;
    vuint32_t IREE22:1;
    vuint32_t IREE21:1;
    vuint32_t IREE20:1;
    vuint32_t IREE19:1;
    vuint32_t IREE18:1;
    vuint32_t IREE17:1;
    vuint32_t IREE16:1;
    vuint32_t IREE15:1;
    vuint32_t IREE14:1;
    vuint32_t IREE13:1;
    vuint32_t IREE12:1;
    vuint32_t IREE11:1;
    vuint32_t IREE10:1;
    vuint32_t IREE9:1;
    vuint32_t IREE8:1;
    vuint32_t IREE7:1;
    vuint32_t IREE6:1;
    vuint32_t IREE5:1;
    vuint32_t IREE4:1;
    vuint32_t IREE3:1;
    vuint32_t IREE2:1;
    vuint32_t IREE1:1;
    vuint32_t IREE0:1;
  } B;
} SIUL2_IREER0_tag;

typedef union SIUL2_IFEER0_union_tag { /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFEE31:1;
    vuint32_t IFEE30:1;
    vuint32_t IFEE29:1;
    vuint32_t IFEE28:1;
    vuint32_t IFEE27:1;
    vuint32_t IFEE26:1;
    vuint32_t IFEE25:1;
    vuint32_t IFEE24:1;
    vuint32_t IFEE23:1;
    vuint32_t IFEE22:1;
    vuint32_t IFEE21:1;
    vuint32_t IFEE20:1;
    vuint32_t IFEE19:1;
    vuint32_t IFEE18:1;
    vuint32_t IFEE17:1;
    vuint32_t IFEE16:1;
    vuint32_t IFEE15:1;
    vuint32_t IFEE14:1;
    vuint32_t IFEE13:1;
    vuint32_t IFEE12:1;
    vuint32_t IFEE11:1;
    vuint32_t IFEE10:1;
    vuint32_t IFEE9:1;
    vuint32_t IFEE8:1;
    vuint32_t IFEE7:1;
    vuint32_t IFEE6:1;
    vuint32_t IFEE5:1;
    vuint32_t IFEE4:1;
    vuint32_t IFEE3:1;
    vuint32_t IFEE2:1;
    vuint32_t IFEE1:1;
    vuint32_t IFEE0:1;
  } B;
} SIUL2_IFEER0_tag;

typedef union SIUL2_IFER0_union_tag {  /* SIUL2 Interrupt Filter Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t IFE31:1;
    vuint32_t IFE30:1;
    vuint32_t IFE29:1;
    vuint32_t IFE28:1;
    vuint32_t IFE27:1;
    vuint32_t IFE26:1;
    vuint32_t IFE25:1;
    vuint32_t IFE24:1;
    vuint32_t IFE23:1;
    vuint32_t IFE22:1;
    vuint32_t IFE21:1;
    vuint32_t IFE20:1;
    vuint32_t IFE19:1;
    vuint32_t IFE18:1;
    vuint32_t IFE17:1;
    vuint32_t IFE16:1;
    vuint32_t IFE15:1;
    vuint32_t IFE14:1;
    vuint32_t IFE13:1;
    vuint32_t IFE12:1;
    vuint32_t IFE11:1;
    vuint32_t IFE10:1;
    vuint32_t IFE9:1;
    vuint32_t IFE8:1;
    vuint32_t IFE7:1;
    vuint32_t IFE6:1;
    vuint32_t IFE5:1;
    vuint32_t IFE4:1;
    vuint32_t IFE3:1;
    vuint32_t IFE2:1;
    vuint32_t IFE1:1;
    vuint32_t IFE0:1;
  } B;
} SIUL2_IFER0_tag;

typedef union SIUL2_IFMCR_union_tag {  /* SIUL2 Interrupt Filter Maximum Counter Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t MAXCNT:4;                /* Maximum Interrupt Filter Counter setting */
  } B;
} SIUL2_IFMCR_tag;

typedef union SIUL2_IFCPR_union_tag {  /* SIUL2 Interrupt Filter Clock Prescaler Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t IFCP:4;                  /* Interrupt Filter Clock Prescaler setting */
  } B;
} SIUL2_IFCPR_tag;

typedef union SIUL2_MSCR_union_tag {   /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t SRC:2;                   /* Slew Rate Control */
    vuint32_t _unused_26:2;
    vuint32_t OBE:1;                   /* GPIO Output Buffer Enable */
    vuint32_t ODE:1;                   /* Open Drain Enable To enable open drain both OBE and ODE bits need to be set. */
    vuint32_t SMC:1;                   /* Safe Mode Control */
    vuint32_t APC:1;                   /* Analog Pad Control */
    vuint32_t _unused_20:2;
    vuint32_t IBE:1;                   /* Input Buffer Enable */
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t PUS:1;                   /* Pull Select */
    vuint32_t PUE:1;                   /* Pull Enable */
    vuint32_t INV:1;                   /* Invert */
    vuint32_t _unused_8:7;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_MSCR_tag;

typedef union SIUL2_MSCR198_union_tag { /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t HYS:1;                   /* Input Hysteresis */
    vuint32_t _unused_0:18;
  } B;
} SIUL2_MSCR198_tag;

typedef union SIUL2_MSCR199_union_tag { /* SIUL2 Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t _unused_18:1;
    vuint32_t _unused_0:18;
  } B;
} SIUL2_MSCR199_tag;

typedef union SIUL2_IMCR_union_tag {   /* SIUL2 Input Multiplexed Signal Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t INV:1;                   /* Invert */
    vuint32_t _unused_15:16;
    vuint32_t _unused_8:7;
    vuint32_t _unused_4:4;
    vuint32_t SSS:4;                   /* Source Signal Select */
  } B;
} SIUL2_IMCR_tag;

typedef union SIUL2_GPDO_union_tag {   /* SIUL2 GPIO Pad Data Output Register */
  vuint8_t R;
  struct {
	vuint8_t _unused_1:7;					 
	vuint8_t PDO_4n:1;					 /* Pad Data Out */
  } B;
} SIUL2_GPDO_tag;

typedef union SIUL2_GPDI_union_tag {   /* SIUL2 GPIO Pad Data Input Register */
  vuint8_t R;
  struct {
  	vuint8_t _unused_1:7;					 
	vuint8_t PDI_4n:1;					/* Pad Data In */
  } B;
} SIUL2_GPDI_tag;

typedef union SIUL2_PGPDO_union_tag {  /* SIUL2 Parallel GPIO Pad Data Out Register */
  vuint16_t R;
  struct {
    vuint16_t PPDO:16;                 /* Parallel Pad Data Out */
  } B;
} SIUL2_PGPDO_tag;

typedef union SIUL2_PGPDI_union_tag {  /* SIUL2 Parallel GPIO Pad Data In Register */
  vuint16_t R;
  struct {
    vuint16_t PPDI:16;                 /* Parallel Pad Data In */
  } B;
} SIUL2_PGPDI_tag;

typedef union SIUL2_MPGPDO_union_tag { /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
  vuint32_t R;
  struct {
    vuint32_t MASK:16;                 /* Mask Field */
    vuint32_t MPPDO:16;                /* Masked Parallel Pad Data Out */
  } B;
} SIUL2_MPGPDO_tag;

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  SIUL2_MIDR1_tag MIDR1;               /* SIUL2 MCU ID Register #1 */
  SIUL2_MIDR2_tag MIDR2;               /* SIUL2 MCU ID Register #2 */
  uint8_t SIUL2_reserved1[4];
  SIUL2_DISR0_tag DISR0;               /* SIUL2 DMA/Interrupt Status Flag Register0 */
  uint8_t SIUL2_reserved2[4];
  SIUL2_DIRER0_tag DIRER0;             /* SIUL2 DMA/Interrupt Request Enable Register0 */
  uint8_t SIUL2_reserved3[4];
  SIUL2_DIRSR0_tag DIRSR0;             /* SIUL2 DMA/Interrupt Request Select Register0 */
  uint8_t SIUL2_reserved4[4];
  SIUL2_IREER0_tag IREER0;             /* SIUL2 Interrupt Rising-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved5[4];
  SIUL2_IFEER0_tag IFEER0;             /* SIUL2 Interrupt Falling-Edge Event Enable Register 0 */
  uint8_t SIUL2_reserved6[4];
  SIUL2_IFER0_tag IFER0;               /* SIUL2 Interrupt Filter Enable Register 0 */
  uint8_t SIUL2_reserved7[4];
  SIUL2_IFMCR_tag IFMCR[32];           /* SIUL2 Interrupt Filter Maximum Counter Register */
  SIUL2_IFCPR_tag IFCPR;               /* SIUL2 Interrupt Filter Clock Prescaler Register */
  uint8_t SIUL2_reserved8[380];
  SIUL2_MSCR_tag MSCR[197];            /* SIUL2 Multiplexed Signal Configuration Register */
  SIUL2_MSCR198_tag MSCR198;           /* SIUL2 Multiplexed Signal Configuration Register */
  SIUL2_MSCR199_tag MSCR199;           /* SIUL2 Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved9[1252];
  SIUL2_IMCR_tag IMCR[94];             /* SIUL2 Input Multiplexed Signal Configuration Register */
  uint8_t SIUL2_reserved10[1864];
  SIUL2_GPDO_tag GPDO[200];             /* SIUL2 GPIO Pad Data Output Register */
  uint8_t SIUL2_reserved11[312];
  SIUL2_GPDI_tag GPDI[200];             /* SIUL2 GPIO Pad Data Input Register */
  uint8_t SIUL2_reserved12[312];
  SIUL2_PGPDO_tag PGPDO[13];           /* SIUL2 Parallel GPIO Pad Data Out Register */
  uint8_t SIUL2_reserved13[38];
  SIUL2_PGPDI_tag PGPDI[13];           /* SIUL2 Parallel GPIO Pad Data In Register */
  uint8_t SIUL2_reserved14[38];
  SIUL2_MPGPDO_tag MPGPDO[13];         /* SIUL2 Masked Parallel GPIO Pad Data Out Register */
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

typedef union SMPU_CESR0_union_tag {   /* Control/Error Status Register 0 */
  vuint32_t R;
  struct {
    vuint32_t MERR:16;                 /* Master n error, where the bus master number matches the bit number */
    vuint32_t _unused_15:1;
    vuint32_t _unused_4:11;
    vuint32_t HRL:3;                   /* Hardware revision level */
    vuint32_t GVLD:1;                  /* Global Valid (global enable/disable for the SMPU) */
  } B;
} SMPU_CESR0_tag;

typedef union SMPU_CESR1_union_tag {   /* Control/Error Status Register 1 */
  vuint32_t R;
  struct {
    vuint32_t MEOVR:16;                /* Master n error overrun, where the bus master number matches the bit number */
    vuint32_t _unused_15:1;
    vuint32_t _unused_4:11;
    vuint32_t NRGD:4;                  /* Number of region descriptors */
  } B;
} SMPU_CESR1_tag;

typedef union SMPU_ERROR_EAR_union_tag { /* Error Address Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EADDR:32;                /* Error address */
  } B;
} SMPU_ERROR_EAR_tag;

typedef union SMPU_ERROR_EDR_union_tag { /* Error Detail Register, Bus Master n */
  vuint32_t R;
  struct {
    vuint32_t EACD:24;                 /* Error access control detail */
    vuint32_t _unused_7:1;
    vuint32_t EATTR:2;                 /* Error attributes */
    vuint32_t ERW:1;                   /* Error read/write */
    vuint32_t EMN:4;                   /* Error master number */
  } B;
} SMPU_ERROR_EDR_tag;

typedef struct SMPU_ERROR_struct_tag {
  SMPU_ERROR_EAR_tag EAR;              /* Error Address Register, Bus Master n */
  SMPU_ERROR_EDR_tag EDR;              /* Error Detail Register, Bus Master n */
} SMPU_ERROR_tag;

typedef union SMPU_RGD_WORD0_union_tag { /* Region Descriptor n, Word 0 */
  vuint32_t R;
  struct {
    vuint32_t SRTADDR:32;              /* Start address */
  } B;
} SMPU_RGD_WORD0_tag;

typedef union SMPU_RGD_WORD1_union_tag { /* Region Descriptor n, Word 1 */
  vuint32_t R;
  struct {
    vuint32_t ENDADDR:32;              /* End address */
  } B;
} SMPU_RGD_WORD1_tag;

typedef union SMPU_RGD_WORD2_union_tag { /* Region Descriptor n, Word 2 */
  vuint32_t R;
  struct {
    vuint32_t M0P:2;                   /* Bus master 0 permissions */
    vuint32_t M1P:2;                   /* Bus master 1 permissions */
    vuint32_t M2P:2;                   /* Bus master 2 permissions */
    vuint32_t M3P:2;                   /* Bus master 3 permissions */
    vuint32_t M4P:2;                   /* Bus master 4 permissions */
    vuint32_t M5P:2;                   /* Bus master 5 permissions */
    vuint32_t M6P:2;                   /* Bus master 6 permissions */
    vuint32_t M7P:2;                   /* Bus master 7 permissions */
    vuint32_t M8P:2;                   /* Bus master 8 permissions */
    vuint32_t M9P:2;                   /* Bus master 9 permissions */
    vuint32_t M10P:2;                  /* Bus master 10 permissions */
    vuint32_t M11P:2;                  /* Bus master 11 permissions */
    vuint32_t M12P:2;                  /* Bus master 12 permissions */
    vuint32_t M13P:2;                  /* Bus master 13 permissions */
    vuint32_t M14P:2;                  /* Bus master 14 permissions */
    vuint32_t M15P:2;                  /* Bus master 15 permissions */
  } B;
} SMPU_RGD_WORD2_tag;

typedef union SMPU_RGD_WORD3_union_tag { /* Region Descriptor n, Word 3 */
  vuint32_t R;
  struct {
    vuint32_t _unused_4:28;
    vuint32_t RO:1;                    /* Read-Only */
    vuint32_t _unused_2:1;
    vuint32_t CI:1;                    /* Cache Inhibit */
    vuint32_t VLD:1;                   /* Valid */
  } B;
} SMPU_RGD_WORD3_tag;

typedef struct SMPU_RGD_struct_tag {
  SMPU_RGD_WORD0_tag WORD0;            /* Region Descriptor n, Word 0 */
  SMPU_RGD_WORD1_tag WORD1;            /* Region Descriptor n, Word 1 */
  SMPU_RGD_WORD2_tag WORD2;            /* Region Descriptor n, Word 2 */
  SMPU_RGD_WORD3_tag WORD3;            /* Region Descriptor n, Word 3 */
} SMPU_RGD_tag;

struct SMPU_tag {
  SMPU_CESR0_tag CESR0;                /* Control/Error Status Register 0 */
  SMPU_CESR1_tag CESR1;                /* Control/Error Status Register 1 */
  uint8_t SMPU_reserved0[248];
  SMPU_ERROR_tag ERROR[16];
  uint8_t SMPU_reserved1[640];
  SMPU_RGD_tag RGD[16];
};


/* ============================================================================
   =============================== Module: SPI ================================
   ============================================================================ */

typedef union SPI_MCR_union_tag {      /* Module Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t MSTR:1;                  /* Master/Slave Mode Select */
    vuint32_t CONT_SCKE:1;             /* Continuous SCK Enable */
    vuint32_t DCONF:2;                 /* SPI Configuration. */
    vuint32_t FRZ:1;                   /* Freeze */
    vuint32_t MTFE:1;                  /* Modified Transfer Format Enable */
    vuint32_t PCSSE:1;                 /* Peripheral Chip Select Strobe Enable */
    vuint32_t ROOE:1;                  /* Receive FIFO Overflow Overwrite Enable */
    vuint32_t PCSIS:8;                 /* Peripheral Chip Select x Inactive State */
    vuint32_t _unused_15:1;
    vuint32_t MDIS:1;                  /* Module Disable */
    vuint32_t DIS_TXF:1;               /* Disable Transmit FIFO */
    vuint32_t DIS_RXF:1;               /* Disable Receive FIFO */
    vuint32_t CLR_TXF:1;               /* Clear TX FIFO */
    vuint32_t CLR_RXF:1;               /* CLR_RXF */
    vuint32_t SMPL_PT:2;               /* Sample Point */
    vuint32_t _unused_3:5;
    vuint32_t FCPCS:1;                 /* Fast Continuous PCS Mode. */
    vuint32_t PES:1;                   /* Parity Error Stop */
    vuint32_t HALT:1;                  /* Halt */
  } B;
} SPI_MCR_tag;

typedef union SPI_TCR_union_tag {      /* Transfer Count Register */
  vuint32_t R;
  struct {
    vuint32_t SPI_TCNT:16;             /* SPI Transfer Counter */
    vuint32_t _unused_0:16;
  } B;
} SPI_TCR_tag;

typedef union SPI_MODE_CTAR_union_tag { /* Clock and Transfer Attributes Register (In Master Mode) */
  vuint32_t R;
  struct {
    vuint32_t DBR:1;                   /* Double Baud Rate */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t LSBFE:1;                 /* LSB First */
    vuint32_t PCSSCK:2;                /* PCS to SCK Delay Prescaler */
    vuint32_t PASC:2;                  /* After SCK Delay Prescaler */
    vuint32_t PDT:2;                   /* Delay after Transfer Prescaler */
    vuint32_t PBR:2;                   /* Baud Rate Prescaler */
    vuint32_t CSSCK:4;                 /* PCS to SCK Delay Scaler */
    vuint32_t ASC:4;                   /* After SCK Delay Scaler */
    vuint32_t DT:4;                    /* Delay After Transfer Scaler */
    vuint32_t BR:4;                    /* Baud Rate Scaler */
  } B;
} SPI_MODE_CTAR_tag;

typedef union SPI_MODE_CTAR_SLAVE_union_tag { /* Clock and Transfer Attributes Register (In Slave Mode) */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;            /* Always write the reset value to this field. */
    vuint32_t FMSZ:4;                  /* Frame Size */
    vuint32_t CPOL:1;                  /* Clock Polarity */
    vuint32_t CPHA:1;                  /* Clock Phase */
    vuint32_t PE:1;                    /* Parity Enable */
    vuint32_t PP:1;                    /* Parity Polarity */
    vuint32_t _unused_22:1;
    vuint32_t _unused_0:22;
  } B;
} SPI_MODE_CTAR_SLAVE_tag;

typedef union SPI_MODE_union_tag {
  SPI_MODE_CTAR_tag CTAR[8];           /* Clock and Transfer Attributes Register (In Master Mode) */
  SPI_MODE_CTAR_SLAVE_tag CTAR_SLAVE[1]; /* Clock and Transfer Attributes Register (In Slave Mode) */
} SPI_MODE_tag;

typedef union SPI_SR_union_tag {       /* Status Register */
  vuint32_t R;
  struct {
    vuint32_t TCF:1;                   /* Transfer Complete Flag */
    vuint32_t TXRXS:1;                 /* TX and RX Status */
    vuint32_t _unused_29:1;
    vuint32_t EOQF:1;                  /* End of Queue Flag */
    vuint32_t TFUF:1;                  /* Transmit FIFO Underflow Flag */
    vuint32_t _unused_26:1;
    vuint32_t TFFF:1;                  /* Transmit FIFO Fill Flag */
    vuint32_t _unused_24:1;
    vuint32_t _unused_23:1;
    vuint32_t _unused_22:1;
    vuint32_t SPEF:1;                  /* SPI Parity Error Flag */
    vuint32_t _unused_20:1;
    vuint32_t RFOF:1;                  /* Receive FIFO Overflow Flag */
    vuint32_t _unused_18:1;
    vuint32_t RFDF:1;                  /* Receive FIFO Drain Flag */
    vuint32_t _unused_16:1;
    vuint32_t TXCTR:4;                 /* TX FIFO Counter */
    vuint32_t TXNXTPTR:4;              /* Transmit Next Pointer */
    vuint32_t RXCTR:4;                 /* RX FIFO Counter */
    vuint32_t POPNXTPTR:4;             /* Pop Next Pointer */
  } B;
} SPI_SR_tag;

typedef union SPI_RSER_union_tag {     /* DMA/Interrupt Request Select and Enable Register */
  vuint32_t R;
  struct {
    vuint32_t TCF_RE:1;                /* Transmission Complete Request Enable */
    vuint32_t _unused_30:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_29:1;            /* Always write the reset value to this field. */
    vuint32_t EOQF_RE:1;               /* Finished Request Enable */
    vuint32_t TFUF_RE:1;               /* Transmit FIFO Underflow Request Enable */
    vuint32_t _unused_26:1;            /* Always write the reset value to this field. */
    vuint32_t TFFF_RE:1;               /* Transmit FIFO Fill Request Enable */
    vuint32_t TFFF_DIRS:1;             /* Transmit FIFO Fill DMA or Interrupt Request Select */
    vuint32_t _unused_23:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_22:1;            /* Always write the reset value to this field. */
    vuint32_t SPEF_RE:1;               /* SPI Parity Error Request Enable */
    vuint32_t _unused_20:1;            /* Always write the reset value to this field. */
    vuint32_t RFOF_RE:1;               /* Receive FIFO Overflow Request Enable */
    vuint32_t _unused_18:1;            /* Always write the reset value to this field. */
    vuint32_t RFDF_RE:1;               /* Receive FIFO Drain Request Enable */
    vuint32_t RFDF_DIRS:1;             /* Receive FIFO Drain DMA or Interrupt Request Select */
    vuint32_t _unused_15:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_14:1;            /* Always write the reset value to this field. */
    vuint32_t _unused_0:14;
  } B;
} SPI_RSER_tag;

typedef union SPI_PUSHR_PUSHR_union_tag { /* PUSH TX FIFO Register In Master Mode */
  vuint32_t R;
  struct {
    vuint32_t CONT:1;                  /* Continuous Peripheral Chip Select Enable */
    vuint32_t CTAS:3;                  /* Clock and Transfer Attributes Select */
    vuint32_t EOQ:1;                   /* End Of Queue */
    vuint32_t CTCNT:1;                 /* Clear Transfer Counter */
    vuint32_t PE_MASC:1;               /* Parity Enable or Mask T ASC delay in the current frame */
    vuint32_t PP_MCSC:1;               /* Parity Polarity or Mask T CSC delay in the next frame */
    vuint32_t PCS:8;                   /* PCS */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_tag;

typedef union SPI_PUSHR_PUSHR_SLAVE_union_tag { /* PUSH TX FIFO Register In Slave Mode */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_PUSHR_PUSHR_SLAVE_tag;

typedef union SPI_PUSHR_union_tag {
  SPI_PUSHR_PUSHR_tag PUSHR;           /* PUSH TX FIFO Register In Master Mode */
  SPI_PUSHR_PUSHR_SLAVE_tag PUSHR_SLAVE; /* PUSH TX FIFO Register In Slave Mode */
} SPI_PUSHR_tag;

typedef union SPI_POPR_union_tag {     /* POP RX FIFO Register */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Received Data */
  } B;
} SPI_POPR_tag;

typedef union SPI_TXFR_union_tag {     /* Transmit FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t TXCMD_TXDATA:16;         /* Transmit Command or Transmit Data */
    vuint32_t TXDATA:16;               /* Transmit Data */
  } B;
} SPI_TXFR_tag;

typedef union SPI_RXFR_union_tag {     /* Receive FIFO Registers */
  vuint32_t R;
  struct {
    vuint32_t RXDATA:32;               /* Receive Data */
  } B;
} SPI_RXFR_tag;

struct SPI_tag {
  SPI_MCR_tag MCR;                     /* Module Configuration Register */
  uint8_t SPI_reserved0[4];
  SPI_TCR_tag TCR;                     /* Transfer Count Register */
  SPI_MODE_tag MODE;
  SPI_SR_tag SR;                       /* Status Register */
  SPI_RSER_tag RSER;                   /* DMA/Interrupt Request Select and Enable Register */
  SPI_PUSHR_tag PUSHR;
  SPI_POPR_tag POPR;                   /* POP RX FIFO Register */
  SPI_TXFR_tag TXFR[5];                /* Transmit FIFO Registers */
  uint8_t SPI_reserved1[44];
  SPI_RXFR_tag RXFR[5];                /* Receive FIFO Registers */
};


/* ============================================================================
   =============================== Module: SPT ================================
   ============================================================================ */

typedef union SPT_GBL_CTRL_union_tag { /* SPT Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t AHB_MUX_SEL:1;           /* AHB MUX Select */
    vuint32_t AHB_BYTE_SWAP:1;         /* Bit to control data byte swapping on the AHB interface. */
    vuint32_t PG_ST_CTRL:1;            /* Program start control */
    vuint32_t ACQ_EN:1;                /* Acquisition Enable. */
    vuint32_t SPT_EN:1;                /* SPT Enable */
  } B;
} SPT_GBL_CTRL_tag;

typedef union SPT_ACQ_GBL_CTRL_0_union_tag { /* Acquistion Global Control Register */
  vuint32_t R;
  struct {
    vuint32_t CH_H_SEL:2;              /* Channel H Select */
    vuint32_t CH_G_SEL:2;              /* Channel G Select */
    vuint32_t CH_F_SEL:2;              /* Channel F Select */
    vuint32_t CH_E_SEL:2;              /* Channel E Select */
    vuint32_t CH_D_SEL:2;              /* Channel D Select */
    vuint32_t CH_C_SEL:2;              /* Channel C Select */
    vuint32_t CH_B_SEL:2;              /* Channel B Select */
    vuint32_t CH_A_SEL:2;              /* Channel A Select */
    vuint32_t PDI_ADC_SEL:1;           /* PDI/ADC SEL */
    vuint32_t INF_CHRPS:1;             /* Infinite Chirps in a Frame */
    vuint32_t INF_SMPLS:1;             /* Infinite Samples in a Chirp */
    vuint32_t _unused_0:13;
  } B;
} SPT_ACQ_GBL_CTRL_0_tag;

typedef union SPT_ACQ_GBL_CTRL_1_union_tag { /* Acquistion Global Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t NUM_SMPL:16;             /* Number of Samples in a Chirp */
    vuint32_t NUM_CHRP:16;             /* Number of chirps in a frame */
  } B;
} SPT_ACQ_GBL_CTRL_1_tag;

typedef union SPT_ACQ_CTRL0_union_tag { /* Acquisition Control 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_A_DC:15;              /* Channel A Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_B_DC:15;              /* Channel B Offset Compensation value */
  } B;
} SPT_ACQ_CTRL0_tag;

typedef union SPT_ACQ_CTRL1_union_tag { /* Acquisition Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_C_DC:15;              /* Channel C Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_D_DC:15;              /* Channel D Offset Compensation value */
  } B;
} SPT_ACQ_CTRL1_tag;

typedef union SPT_ACQ_CTRL2_union_tag { /* Acquisition Control 2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_E_DC:15;              /* Channel E Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_F_DC:15;              /* Channel F Offset Compensation value */
  } B;
} SPT_ACQ_CTRL2_tag;

typedef union SPT_ACQ_CTRL3_union_tag { /* Acquisition Control 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t CH_G_DC:15;              /* Channel G Offset Compensation value */
    vuint32_t _unused_15:1;
    vuint32_t CH_H_DC:15;              /* Channel H Offset Compensation value */
  } B;
} SPT_ACQ_CTRL3_tag;

typedef union SPT_SDMA_CTRL0_union_tag { /* SDMA Control 0 Register */
  vuint32_t R;
  struct {
    vuint32_t SDMA_START_ADDR:29;      /* SDMA Start Address */
    vuint32_t _unused_0:3;
  } B;
} SPT_SDMA_CTRL0_tag;

typedef union SPT_SDMA_CTRL1_union_tag { /* SDMA Control 1 Register */
  vuint32_t R;
  struct {
    vuint32_t SDMA_BUF_LEN:16;         /* SDMA Buffer Length */
    vuint32_t HMASTER_ENC_DIS:1;       /* AHB Master ID generation disable */
    vuint32_t _unused_14:1;
    vuint32_t DATA_ORG_CFG:2;          /* Data Organization Configuration */
    vuint32_t TRF_MOD:1;               /* Transfer Mode */
    vuint32_t LINE_LEN:11;             /* Line Length */
  } B;
} SPT_SDMA_CTRL1_tag;

typedef union SPT_ACQ_STATUS_A0_union_tag { /* Acquisition Status Register A0 */
  vuint32_t R;
  struct {
    vuint32_t CH_A_SUM:32;             /* Channel A Sum */
  } B;
} SPT_ACQ_STATUS_A0_tag;

typedef union SPT_ACQ_STATUS_A1_union_tag { /* Acquisition Status Register A1 */
  vuint32_t R;
  struct {
    vuint32_t CH_A_MAX:16;             /* Channel A Maximum */
    vuint32_t CH_A_MIN:16;             /* Channel A Minimum */
  } B;
} SPT_ACQ_STATUS_A1_tag;

typedef union SPT_ACQ_STATUS_A2_union_tag { /* Acquisition Status Register A2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_A_BT:16;              /* Channel A Bit Toggle */
  } B;
} SPT_ACQ_STATUS_A2_tag;

typedef union SPT_ACQ_STATUS_B0_union_tag { /* Acquisition Status Register B0 */
  vuint32_t R;
  struct {
    vuint32_t CH_B_SUM:32;             /* Channel B Sum */
  } B;
} SPT_ACQ_STATUS_B0_tag;

typedef union SPT_ACQ_STATUS_B1_union_tag { /* Acquisition Status Register B1 */
  vuint32_t R;
  struct {
    vuint32_t CH_B_MAX:16;             /* Channel B Maximum */
    vuint32_t CH_B_MIN:16;             /* Channel B Minimum */
  } B;
} SPT_ACQ_STATUS_B1_tag;

typedef union SPT_ACQ_STATUS_B2_union_tag { /* Acquisition Status Register B2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_B_BT:16;              /* Channel B Bit Toggle */
  } B;
} SPT_ACQ_STATUS_B2_tag;

typedef union SPT_ACQ_STATUS_C0_union_tag { /* Acquisition Status Register C0 */
  vuint32_t R;
  struct {
    vuint32_t CH_C_SUM:32;             /* Channel C Sum */
  } B;
} SPT_ACQ_STATUS_C0_tag;

typedef union SPT_ACQ_STATUS_C1_union_tag { /* Acquisition Status Register C1 */
  vuint32_t R;
  struct {
    vuint32_t CH_C_MAX:16;             /* Channel C Maximum */
    vuint32_t CH_C_MIN:16;             /* Channel C Minimum */
  } B;
} SPT_ACQ_STATUS_C1_tag;

typedef union SPT_ACQ_STATUS_C2_union_tag { /* Acquisition Status Register C2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_C_BT:16;              /* Channel C Bit Toggle */
  } B;
} SPT_ACQ_STATUS_C2_tag;

typedef union SPT_ACQ_STATUS_D0_union_tag { /* Acquisition Status Register D0 */
  vuint32_t R;
  struct {
    vuint32_t CH_D_SUM:32;             /* Channel D Sum */
  } B;
} SPT_ACQ_STATUS_D0_tag;

typedef union SPT_ACQ_STATUS_D1_union_tag { /* Acquisition Status Register D1 */
  vuint32_t R;
  struct {
    vuint32_t CH_D_MAX:16;             /* Channel D Maximum */
    vuint32_t CH_D_MIN:16;             /* Channel D Minimum */
  } B;
} SPT_ACQ_STATUS_D1_tag;

typedef union SPT_ACQ_STATUS_D2_union_tag { /* Acquisition Status Register D2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_D_BT:16;              /* Channel D Bit Toggle */
  } B;
} SPT_ACQ_STATUS_D2_tag;

typedef union SPT_ACQ_STATUS_E0_union_tag { /* Acquisition Status Register E0 */
  vuint32_t R;
  struct {
    vuint32_t CH_E_SUM:32;             /* Channel E Sum */
  } B;
} SPT_ACQ_STATUS_E0_tag;

typedef union SPT_ACQ_STATUS_E1_union_tag { /* Acquisition Status Register E1 */
  vuint32_t R;
  struct {
    vuint32_t CH_E_MAX:16;             /* Channel E Maximum */
    vuint32_t CH_E_MIN:16;             /* Channel E Minimum */
  } B;
} SPT_ACQ_STATUS_E1_tag;

typedef union SPT_ACQ_STATUS_E2_union_tag { /* Acquisition Status Register E2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_E_BT:16;              /* Channel E Bit Toggle */
  } B;
} SPT_ACQ_STATUS_E2_tag;

typedef union SPT_ACQ_STATUS_F0_union_tag { /* Acquisition Status Register F0 */
  vuint32_t R;
  struct {
    vuint32_t CH_F_SUM:32;             /* Channel F Sum */
  } B;
} SPT_ACQ_STATUS_F0_tag;

typedef union SPT_ACQ_STATUS_F1_union_tag { /* Acquisition Status Register F1 */
  vuint32_t R;
  struct {
    vuint32_t CH_F_MAX:16;             /* Channel F Maximum */
    vuint32_t CH_F_MIN:16;             /* Channel F Minimum */
  } B;
} SPT_ACQ_STATUS_F1_tag;

typedef union SPT_ACQ_STATUS_F2_union_tag { /* Acquisition Status Register F2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_F_BT:16;              /* Channel F Bit Toggle */
  } B;
} SPT_ACQ_STATUS_F2_tag;

typedef union SPT_ACQ_STATUS_G0_union_tag { /* Acquisition Status Register G0 */
  vuint32_t R;
  struct {
    vuint32_t CH_G_SUM:32;             /* Channel G Sum */
  } B;
} SPT_ACQ_STATUS_G0_tag;

typedef union SPT_ACQ_STATUS_G1_union_tag { /* Acquisition Status Register G1 */
  vuint32_t R;
  struct {
    vuint32_t CH_G_MAX:16;             /* Channel G Maximum */
    vuint32_t CH_G_MIN:16;             /* Channel G Minimum */
  } B;
} SPT_ACQ_STATUS_G1_tag;

typedef union SPT_ACQ_STATUS_G2_union_tag { /* Acquisition Status Register G2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_G_BT:16;              /* Channel G Bit Toggle */
  } B;
} SPT_ACQ_STATUS_G2_tag;

typedef union SPT_ACQ_STATUS_H0_union_tag { /* Acquisition Status Register H0 */
  vuint32_t R;
  struct {
    vuint32_t CH_H_SUM:32;             /* Channel H Sum */
  } B;
} SPT_ACQ_STATUS_H0_tag;

typedef union SPT_ACQ_STATUS_H1_union_tag { /* Acquisition Status Register H1 */
  vuint32_t R;
  struct {
    vuint32_t CH_H_MAX:16;             /* Channel H Maximum */
    vuint32_t CH_H_MIN:16;             /* Channel H Minimum */
  } B;
} SPT_ACQ_STATUS_H1_tag;

typedef union SPT_ACQ_STATUS_H2_union_tag { /* Acquisition Status Register H2 */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CH_H_BT:16;              /* Channel H Bit Toggle */
  } B;
} SPT_ACQ_STATUS_H2_tag;

typedef union SPT_CS_PG_ST_ADDR_union_tag { /* Program Start Addr Register */
  vuint32_t R;
  struct {
    vuint32_t PG_ST_ADDR:32;           /* Program start address */
  } B;
} SPT_CS_PG_ST_ADDR_tag;

typedef union SPT_CS_MODE_CTRL_union_tag { /* Mode Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_19:13;
    vuint32_t _unused_17:2;
    vuint32_t ERROR_EN:1;              /* Error Enable */
    vuint32_t PREFETCH:1;              /* Early Pre-fetch Enable */
    vuint32_t BKPT3_RE:1;              /* Breakpoint 3 remains enabled */
    vuint32_t BKPT3_EN:1;              /* Breakpoint 3 enabled */
    vuint32_t BKPT2_RE:1;              /* Breakpoint 2 remains enabled */
    vuint32_t BKPT2_EN:1;              /* Breakpoint 2 enabled */
    vuint32_t BKPT1_RE:1;              /* Breakpoint 1 remains enabled */
    vuint32_t BKPT1_EN:1;              /* Breakpoint 1 enabled */
    vuint32_t BKPT0_RE:1;              /* Breakpoint 0 remains enabled */
    vuint32_t BKPT0_EN:1;              /* Breakpoint 0 enabled */
    vuint32_t CS_SYS_DEBUG:1;          /* System debug enable */
    vuint32_t CS_BKPT_DEBUG:1;         /* Breakpoint debug enable */
    vuint32_t CS_IMM_DEBUG:1;          /* IMM DEBUG enable */
    vuint32_t DEBUG_MD:2;              /* DEBUG MODE control */
    vuint32_t ASYNCSTOP:1;             /* Asynchronous STOP bit */
    vuint32_t STOP:1;                  /* STOP bit */
  } B;
} SPT_CS_MODE_CTRL_tag;

typedef union SPT_CS_BKPT0_ADDR_union_tag { /* Breakpoint0 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT0:32;                /* Breakpoint 0 address */
  } B;
} SPT_CS_BKPT0_ADDR_tag;

typedef union SPT_CS_BKPT1_ADDR_union_tag { /* Breakpoint1 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT1:32;                /* Breakpoint 1 address */
  } B;
} SPT_CS_BKPT1_ADDR_tag;

typedef union SPT_CS_BKPT2_ADDR_union_tag { /* Breakpoint2 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT2:32;                /* Breakpoint 2 address */
  } B;
} SPT_CS_BKPT2_ADDR_tag;

typedef union SPT_CS_BKPT3_ADDR_union_tag { /* Breakpoint3 Addr Register */
  vuint32_t R;
  struct {
    vuint32_t BKPT3:32;                /* Breakpoint 3 address */
  } B;
} SPT_CS_BKPT3_ADDR_tag;

typedef union SPT_CS_JAM_INST0_union_tag { /* Jamming Instruction0 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_127_96:32;      /* Jamming instruction bits 127:96 */
  } B;
} SPT_CS_JAM_INST0_tag;

typedef union SPT_CS_JAM_INST1_union_tag { /* Jamming Instruction1 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_95_64:32;       /* Jamming instruction bits 95:64 */
  } B;
} SPT_CS_JAM_INST1_tag;

typedef union SPT_CS_JAM_INST2_union_tag { /* Jamming Instruction2 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_63_32:32;       /* Jamming instruction bits 63:32 */
  } B;
} SPT_CS_JAM_INST2_tag;

typedef union SPT_CS_JAM_INST3_union_tag { /* Jamming Instruction3 Register */
  vuint32_t R;
  struct {
    vuint32_t JAM_INST_31_0:32;        /* Jamming instruction bits 31:0 */
  } B;
} SPT_CS_JAM_INST3_tag;

typedef union SPT_CS_CURR_INST_ADDR_union_tag { /* Current Instruction Addr Register */
  vuint32_t R;
  struct {
    vuint32_t CURRENT_INST_ADDR:32;    /* Current instruction pointer */
  } B;
} SPT_CS_CURR_INST_ADDR_tag;

typedef union SPT_CS_CURR_INST0_union_tag { /* Current Instruction0 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_127_96:32;     /* Current instruction bits 127:96 */
  } B;
} SPT_CS_CURR_INST0_tag;

typedef union SPT_CS_CURR_INST1_union_tag { /* Current Instruction1 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_95_64:32;      /* Current instruction bits 95:64 */
  } B;
} SPT_CS_CURR_INST1_tag;

typedef union SPT_CS_CURR_INST2_union_tag { /* Current Instruction2 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_63_32:32;      /* Current instruction bits 63:32 */
  } B;
} SPT_CS_CURR_INST2_tag;

typedef union SPT_CS_CURR_INST3_union_tag { /* Current Instruction3 Register */
  vuint32_t R;
  struct {
    vuint32_t CURR_INST_31_0:32;       /* Current instruction bits 31:0 */
  } B;
} SPT_CS_CURR_INST3_tag;

typedef union SPT_CS_LOOPCNTR01_union_tag { /* Loop Counter 0 and 1 Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP_CNTR1:16;           /* Loop count of counter 1 */
    vuint32_t LOOP_CNTR0:16;           /* Loop count of counter 0 */
  } B;
} SPT_CS_LOOPCNTR01_tag;

typedef union SPT_CS_LOOPCNTR23_union_tag { /* Loop Counter 2 and 3 Register */
  vuint32_t R;
  struct {
    vuint32_t LOOP_CNTR3:16;           /* Loop count of counter 3 */
    vuint32_t LOOP_CNTR2:16;           /* Loop count of counter 2 */
  } B;
} SPT_CS_LOOPCNTR23_tag;

typedef union SPT_CS_ERR_INST_ADDR_union_tag { /* Error Instruction Addr Register */
  vuint32_t R;
  struct {
    vuint32_t ERROR_INST_ADDR:32;      /* Error instruction pointer */
  } B;
} SPT_CS_ERR_INST_ADDR_tag;

typedef union SPT_CS_ERR_INST0_union_tag { /* Error Instruction 0 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_127_96:32;      /* Error instruction bits 127:96 */
  } B;
} SPT_CS_ERR_INST0_tag;

typedef union SPT_CS_ERR_INST1_union_tag { /* Error Instruction 1 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_95_64:32;       /* Error instruction bits 95:64 */
  } B;
} SPT_CS_ERR_INST1_tag;

typedef union SPT_CS_ERR_INST2_union_tag { /* Error Instruction 2 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_63_32:32;       /* Error instruction bits 63:32 */
  } B;
} SPT_CS_ERR_INST2_tag;

typedef union SPT_CS_ERR_INST3_union_tag { /* Error Instruction 3 Register */
  vuint32_t R;
  struct {
    vuint32_t ERR_INST_31_0:32;        /* Error instruction bits 31:0 */
  } B;
} SPT_CS_ERR_INST3_tag;

typedef union SPT_CS_STATUS0_union_tag { /* General Status 0 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_17:14;
    vuint32_t BKPT3_OCC:1;             /* 'Breakpoint 3 hit' indication */
    vuint32_t BKPT2_OCC:1;             /* 'Breakpoint 2 hit' indication */
    vuint32_t BKPT1_OCC:1;             /* 'Breakpoint 1 hit' indication */
    vuint32_t BKPT0_OCC:1;             /* 'Breakpoint 0 hit' indication */
    vuint32_t JAM_OVR:1;               /* Jamming mode instruction completion indication */
    vuint32_t STEP_JUMP_OVR:1;         /* STEP JUMP mode break indication */
    vuint32_t STEP_ONCE_OVR:1;         /* STEP ONCE mode instruction completion indication */
    vuint32_t MD_JAM:1;                /* INSTRUCTION JAMMING mode indicator */
    vuint32_t MD_STEP_JUMP:1;          /* STEP JUMP mode indicator */
    vuint32_t MD_STEP_ONCE:1;          /* STEP ONCE mode indicator */
    vuint32_t MD_HALT:1;               /* HALT MODE indicator */
    vuint32_t PS_RUN:1;                /* RUN state indicator */
    vuint32_t PS_ASYNCSTOP:1;          /* ASYNCSTOP state indicator */
    vuint32_t PS_STOP:1;               /* STOP state indicator */
    vuint32_t PS_DEBUG:1;              /* DEBUG state indicator */
    vuint32_t PS_WAIT:1;               /* WAIT state indicator */
    vuint32_t PS_START:1;              /* START state indicator */
  } B;
} SPT_CS_STATUS0_tag;

typedef union SPT_CS_STATUS1_union_tag { /* General Status 1 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t _unused_11:1;
    vuint32_t JAM_ILL_NEXT:1;          /* Illegal NEXT in jamming mode */
    vuint32_t JAM_ILL_LOOP:1;          /* illegal LOOP in jamming mode */
    vuint32_t JAM_ILL_SYNC:1;          /* Illegal SYNC in jamming mode */
    vuint32_t JAM_ILL_OPCODE:1;        /* Illegal opcode in jamming mode */
    vuint32_t ILL_ADD:1;               /* Illegal ADD */
    vuint32_t ILL_GET:1;               /* Illegal GET */
    vuint32_t ILL_SET:1;               /* Illegal SET */
    vuint32_t ILL_NEXT:1;              /* Illegal NEXT */
    vuint32_t ILL_0CNTLOOP:1;          /* Illegal loop count error */
    vuint32_t ILL_LOOP:1;              /* illegal LOOP */
    vuint32_t ILL_OPCODE:1;            /* Illegal opcode */
  } B;
} SPT_CS_STATUS1_tag;

typedef union SPT_CS_STATUS2_union_tag { /* General Status2 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_27:5;
    vuint32_t _unused_25:2;
    vuint32_t _unused_23:2;
    vuint32_t _unused_19:4;
    vuint32_t _unused_17:2;
    vuint32_t WAITREG_PXD:1;           /* WAIT status for 'pdma transfer done' signal */
    vuint32_t WAITREG_FAD:1;           /* WAIT status for 'frame acquisition done' signal */
    vuint32_t WAITREG_CAD:1;           /* WAIT status for 'chirp acquisition done' signal */
    vuint32_t WAITREG_RFS:1;           /* WAIT status for cte_rfs */
    vuint32_t WAITREG_RCS:1;           /* WAIT status for cte_rcs */
    vuint32_t WAITREG_CTE:4;           /* WAIT status for CTE event */
    vuint32_t WAITREG_SW:8;            /* WAIT status for SW-enforced event */
  } B;
} SPT_CS_STATUS2_tag;

typedef union SPT_CS_STATUS3_union_tag { /* General Status 3 Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CS_DMA_ON:1;             /* Command sequencer DMA ON */
    vuint32_t PROC_STATE:4;            /* Processing state */
    vuint32_t LOOP_DEPTH:3;            /* Loop depth */
  } B;
} SPT_CS_STATUS3_tag;

typedef union SPT_CS_EVTREG1_union_tag { /* EVT1 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVTREG1:8;               /* EVT1 register */
  } B;
} SPT_CS_EVTREG1_tag;

typedef union SPT_CS_EVTREG2_union_tag { /* EVT2 Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVTREG2:8;               /* EVT2 register */
  } B;
} SPT_CS_EVTREG2_tag;

typedef union SPT_CS_SW_EVTREG_union_tag { /* SW Event Trigger Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t SW_EVTREG:8;             /* SW event trigger */
  } B;
} SPT_CS_SW_EVTREG_tag;

typedef union SPT_CORE1_VER_EVT_union_tag { /* Core 1 Version Register Events */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PDMA_TRANS_DONE_EVT1:1;  /* Event for PDMA transfer done for CPU core 1 */
    vuint32_t ACQ_FRM_DONE_EVT1:1;     /* Event for acquisition frame done for CPU core 1 */
    vuint32_t ACQ_WIN_DONE_EVT1:1;     /* Event for acquisition window finished for CPU core 1 */
    vuint32_t EVTREG1:8;               /* EVT1 register */
  } B;
} SPT_CORE1_VER_EVT_tag;

typedef union SPT_CORE2_VER_EVT_union_tag { /* Core 2 Version Register Events */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t PDMA_TRANS_DONE_EVT2:1;  /* Event for PDMA transfer done for CPU core 2 */
    vuint32_t ACQ_FRM_DONE_EVT2:1;     /* Event for acquisition frame done for CPU core 2 */
    vuint32_t ACQ_WIN_DONE_EVT2:1;     /* Event for acquisition window finished for CPU core 2 */
    vuint32_t EVTREG2:8;               /* EVT2 register */
  } B;
} SPT_CORE2_VER_EVT_tag;

typedef union SPT_EVENT_RST_CTRL_union_tag { /* SPT Event Reset Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PDMA_TRANS_DONE_RST:1;
    vuint32_t FRM_ACQ_DONE_RST:1;
    vuint32_t CHRP_ACQ_DONE_RST:1;
  } B;
} SPT_EVENT_RST_CTRL_tag;

typedef union SPT_PDMA_CONTROL_union_tag { /* PDMA Control Register */
  vuint32_t R;
  struct {
    vuint32_t PDMA_COUNT_CS_PRIORITY:16; /* PDMA Count register for Command sequencer to get priority */
    vuint32_t _unused_4:12;
    vuint32_t PDMA_MAX_BURST_SIZE:2;   /* Maximum AHB burst size */
    vuint32_t _unused_1:1;
    vuint32_t _unused_0:1;
  } B;
} SPT_PDMA_CONTROL_tag;

typedef union SPT_PDMA_TRANSFER_COUNT_STATUS_union_tag { /* PDMA Transfer Count Status */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t TRANSFER_COUNT:16;       /* Number of words transfered via PDMA */
  } B;
} SPT_PDMA_TRANSFER_COUNT_STATUS_tag;

typedef union SPT_MEM_ERR_INJECT_CTRL_union_tag { /* Memory Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t TR_PAR_ERR_INJ:4;        /* Twiddle RAM parity error Injection */
    vuint32_t OR_PAR_ERR_INJ:4;        /* Operand RAM parity error Injection */
  } B;
} SPT_MEM_ERR_INJECT_CTRL_tag;

typedef union SPT_MEM_ERR_STATUS_union_tag { /* Memory Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t OR_MOD_PAR_ERR:1;        /* Operand RAM module parity error */
    vuint32_t OR_DMA_PAR_ERR:1;        /* Operand RAM DMA parity error */
    vuint32_t OR_2_ACC_CONTN:1;        /* Operand RAM two access contention */
    vuint32_t OR_3_ACC_CONTN:1;        /* Operand RAM three access contention */
    vuint32_t _unused_16:12;
    vuint32_t TR_PAR_ERR:1;            /* Twiddle RAM parity error */
    vuint32_t _unused_2:13;
    vuint32_t WR_LCK_VIOL:1;           /* Work register lock violation */
    vuint32_t _unused_0:1;
  } B;
} SPT_MEM_ERR_STATUS_tag;

typedef union SPT_MEM_ERR_INT_EN_union_tag { /* Memory Interrupt Enable register */
  vuint32_t R;
  struct {
    vuint32_t OR_MOD_PAR_IE:1;         /* Operand RAM module parity interrupt enable */
    vuint32_t OR_DMA_PAR_IE:1;         /* Operand RAM DMA parity interrupt enable */
    vuint32_t OR_2_ACC_IE:1;           /* Operand RAM two access contention interrupt enable */
    vuint32_t OR_3_ACC_IE:1;           /* Operand RAM three access contention interrupt enable */
    vuint32_t _unused_16:12;
    vuint32_t TR_PAR_IE:1;             /* Twiddle RAM parity error interrupt enable */
    vuint32_t _unused_2:13;
    vuint32_t WR_LCK_IE:1;             /* Work register lock interrupt enable */
    vuint32_t _unused_0:1;
  } B;
} SPT_MEM_ERR_INT_EN_tag;

typedef union SPT_DMA_ERR_STATUS_union_tag { /* DMA Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CS_AHB_ERR:1;            /* Command Sequencer AHB error Response */
    vuint32_t SDMA_AHB_ERR:1;          /* SDMA AHB Error Response */
    vuint32_t PDMA_AHB_ERR:1;          /* PDMA AHB Error */
    vuint32_t SDMA_RD_ERR:1;           /* SDMA Read Error */
    vuint32_t SDMA_WR_ERR:1;           /* SDMA Write Error */
    vuint32_t DMA_COMMAND_ERR:1;
    vuint32_t ILLEGAL_COMMAND_ERR:1;
    vuint32_t _unused_0:1;
  } B;
} SPT_DMA_ERR_STATUS_tag;

typedef union SPT_DMA_ERR_INT_EN_union_tag { /* Interrupt Enable for DMA_ERROR_STATUS */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t CS_AHB_ERR_IE:1;         /* Command Sequencer AHB Interrupt Enable */
    vuint32_t SDMA_AHB_ERR_IE:1;       /* SDMA AHB Error Interrupt Enable */
    vuint32_t PDMA_AHB_ERR_IE:1;       /* Interrupt Enable for PDMA AHB Error */
    vuint32_t SDMA_RD_ERR_IE:1;        /* SDMA Read Error Interrupt Enable */
    vuint32_t SDMA_WR_ERR_IE:1;        /* SDMA Write Error Interrupt Enable */
    vuint32_t DMA_COMMAND_ERR_IE:1;
    vuint32_t ILLEGAL_COMMAND_ERR_IE:1;
    vuint32_t _unused_0:1;             /* Interrupt Enable bit */
  } B;
} SPT_DMA_ERR_INT_EN_tag;

typedef union SPT_GBL_STATUS_union_tag { /* Global Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PDMA_TRANS_DONE:1;       /* PDMA tranfer done */
    vuint32_t FRM_ACQ_DONE:1;          /* Frame Acquisition Done */
    vuint32_t CHRP_ACQ_DONE:1;         /* Chirp Acquisition Done */
  } B;
} SPT_GBL_STATUS_tag;

typedef union SPT_GBL_STATUS_IE_union_tag { /* Global Status Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_3:29;
    vuint32_t PDMA_TRANS_DONE_IE:1;    /* PDMA transfer done interrupt enable */
    vuint32_t FRM_ACQ_DONE_IE:1;       /* Frame Acquisition Done Interrupt Enable */
    vuint32_t CHRP_ACQ_DONE_IE:1;      /* Chirp Acquisition Done Interrupt Enable */
  } B;
} SPT_GBL_STATUS_IE_tag;

typedef union SPT_HW_ACC_ERR_STATUS_union_tag { /* Hardware Accelerator Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t FFT_RDX2_RND_ERR:1;      /* FFT Radix2 Round Error */
    vuint32_t FFT_OPR_ADDR_ERR:1;      /* Operand Address Error */
    vuint32_t FFT_MULT_COEF2_ERR:1;    /* FFT MULT Co-efficient 2 Error */
    vuint32_t FFT_MULT_COEF1_ERR:1;    /* FFT MULT Co-efficient 1 Error */
    vuint32_t FFT_TW_OVS_ERR:1;        /* FFT Twiddle Oversampling Error */
    vuint32_t FFT_QE_VL_OVS_ERR:1;     /* Quadrature Extension Vector Length Oversampling Error */
    vuint32_t FFT_RDX4_RND_ERR:1;      /* FFT Radix4 Round Error */
    vuint32_t FFT_WIN_RND_ERR:1;       /* FFT Window Round Error */
    vuint32_t _unused_23:1;
    vuint32_t _unused_20:3;
    vuint32_t COPY_IP_CMD_ERR:1;       /* COPY input command error */
    vuint32_t _unused_16:3;
    vuint32_t _unused_15:1;
    vuint32_t _unused_6:9;
    vuint32_t _unused_0:6;
  } B;
} SPT_HW_ACC_ERR_STATUS_tag;

typedef union SPT_HW_ACC_ERR_IE_union_tag { /* Hardware Accelerator Error Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t FFT_RDX2_RND_IE:1;       /* FFT Radix2 Round Error Interrupt Enable */
    vuint32_t FFT_OPR_ADDR_IE:1;       /* Operand Address Interrupt Enable */
    vuint32_t FFT_MULT_COEF2_IE:1;     /* FFT MULT Co-efficient 2 Interrupt Enable */
    vuint32_t FFT_MULT_COEF1_IE:1;     /* FFT MULT Co-efficient 1 Interrupt Enable */
    vuint32_t FFT_TW_OVS_IE:1;         /* FFT Twiddle Oversampling Interrupt Enable */
    vuint32_t FFT_QE_VL_OVS_IE:1;      /* Quadrature Extension Vector Length Oversampling Interrupt Enable */
    vuint32_t FFT_RDX4_RND_IE:1;       /* FFT Radix4 Round Error Interrupt Enable */
    vuint32_t FFT_WIN_RND_IE:1;        /* FFT Window Round Interrupt Enable */
    vuint32_t _unused_23:1;
    vuint32_t _unused_20:3;
    vuint32_t COPY_IP_CMD_IE:1;        /* COPY input command interrupt enable */
    vuint32_t _unused_16:3;
    vuint32_t _unused_15:1;
    vuint32_t _unused_6:9;
    vuint32_t _unused_0:6;
  } B;
} SPT_HW_ACC_ERR_IE_tag;

typedef union SPT_CS_INTEN0_union_tag { /* Interrupt Enable Register 0 */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t _unused_17:14;
    vuint32_t BKPT3_OCC_INTEN:1;       /* BKPT3 interrupt enable */
    vuint32_t BKPT2_OCC_INTEN:1;       /* BKPT2 interrupt enable */
    vuint32_t BKPT1_OCC_INTEN:1;       /* BKPT1 interrupt enable */
    vuint32_t BKPT0_OCC_INTEN:1;       /* BKPT0 interrupt enable */
    vuint32_t JAM_OVR_INTEN:1;         /* Jamming instruction over interrupt enable */
    vuint32_t STEP_JUMP_OVR_INTEN:1;   /* 'Breakpoint hit in STEP JUMP mode' interrupt enable */
    vuint32_t STEP_ONCE_OVR_INTEN:1;   /* STEP ONCE mode instruction over interrupt enable */
    vuint32_t MD_JAM_INTEN:1;          /* Interrupt enable for instruction jamming mode */
    vuint32_t MD_STEP_JUMP_INTEN:1;    /* Interrupt enable for STEP JUMP mode */
    vuint32_t MD_STEP_ONCE_INTEN:1;    /* Interrupt enable for STEP ONCE mode */
    vuint32_t MD_HALT_INTEN:1;         /* Interrupt enable for HALT mode */
    vuint32_t PS_RUN_INTEN:1;          /* Interrupt enable for RUN state */
    vuint32_t PS_ASYNCSTOP_INTEN:1;    /* Interrupt enable for ASYNCSTOP state */
    vuint32_t PS_STOP_INTEN:1;         /* Interrupt enable for STOP state */
    vuint32_t PS_DEBUG_INTEN:1;        /* Interrupt enable for DEBUG state */
    vuint32_t PS_WAIT_INTEN:1;         /* Interrupt enable for WAIT state */
    vuint32_t PS_START_INTEN:1;        /* Interrupt enable for START state */
  } B;
} SPT_CS_INTEN0_tag;

typedef union SPT_CS_INTEN1_union_tag { /* Interrupt Enable Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t _unused_11:1;
    vuint32_t JAM_ILL_NEXT_INTEN:1;    /* Illegal NEXT in jamming mode interrupt enable */
    vuint32_t JAM_ILL_LOOP_INTEN:1;    /* Illegal LOOP in jamming mode interrupt enable */
    vuint32_t JAM_ILL_SYNC_INTEN:1;    /* Illegal SYNC in jamming mode interrupt enable */
    vuint32_t JAM_ILL_OPCODE_INTEN:1;  /* Illegal Opcode in jamming mode interrupt enable */
    vuint32_t ILL_ADD_INTEN:1;         /* Illegal ADD interrupt enable */
    vuint32_t ILL_GET_INTEN:1;         /* Illegal GET interrupt enable */
    vuint32_t ILL_SET_INTEN:1;         /* Illegal SET interrupt enable */
    vuint32_t ILL_NEXT_INTEN:1;        /* Illegal NEXT interrupt enable */
    vuint32_t ILL_0CNTLOOP_INTEN:1;    /* Illegal loop count error interrupt */
    vuint32_t ILL_LOOP_INTEN:1;        /* Illegal LOOP interrupt enable */
    vuint32_t ILL_OPCODE_INTEN:1;      /* Illegal Opcode interrupt enable */
  } B;
} SPT_CS_INTEN1_tag;

typedef union SPT_CS_EVT1_INTEN_union_tag { /* EVT1 Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVT1_INTEN:8;            /* EVT interrupt enable for CPU core 1 */
  } B;
} SPT_CS_EVT1_INTEN_tag;

typedef union SPT_CS_EVT2_INTEN_union_tag { /* EVT2 Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t EVT2_INTEN:8;            /* EVT interrupt enable for CPU core 2 */
  } B;
} SPT_CS_EVT2_INTEN_tag;

typedef union SPT_WR_0_15_CTRL_REG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WR15_ACC_CTRL:1;         /* Work register 15 access control */
    vuint32_t WR15_LCK:1;              /* Work register 15 lock */
    vuint32_t WR14_ACC_CTRL:1;         /* Work register 14 access control */
    vuint32_t WR14_LCK:1;              /* Work register 14 lock */
    vuint32_t WR13_ACC_CTRL:1;         /* Work register 13 access control */
    vuint32_t WR13_LCK:1;              /* Work register 13 lock */
    vuint32_t WR12_ACC_CTRL:1;         /* Work register 12 access control */
    vuint32_t WR12_LCK:1;              /* Work register 12 lock */
    vuint32_t WR11_ACC_CTRL:1;         /* Work register 11 access control */
    vuint32_t WR11_LCK:1;              /* Work register 11 lock */
    vuint32_t WR10_ACC_CTRL:1;         /* Work register 10 access control */
    vuint32_t WR10_LCK:1;              /* Work register 10 lock */
    vuint32_t WR9_ACC_CTRL:1;          /* Work register 9 access control */
    vuint32_t WR9_LCK:1;               /* Work register 9 lock */
    vuint32_t WR8_ACC_CTRL:1;          /* Work register 8 access control */
    vuint32_t WR8_LCK:1;               /* Work register 8 lock */
    vuint32_t WR7_ACC_CTRL:1;          /* Work register 7 access control */
    vuint32_t WR7_LCK:1;               /* Work register 7 lock */
    vuint32_t WR6_ACC_CTRL:1;          /* Work register 6 access control */
    vuint32_t WR6_LCK:1;               /* Work register 6 lock */
    vuint32_t WR5_ACC_CTRL:1;          /* Work register 5 access control */
    vuint32_t WR5_LCK:1;               /* Work register 5 lock */
    vuint32_t WR4_ACC_CTRL:1;          /* Work register 4 access control */
    vuint32_t WR4_LCK:1;               /* Work register 4 lock */
    vuint32_t WR3_ACC_CTRL:1;          /* Work register 3 access control */
    vuint32_t WR3_LCK:1;               /* Work register 3 lock */
    vuint32_t WR2_ACC_CTRL:1;          /* Work register 2 access control */
    vuint32_t WR2_LCK:1;               /* Work register 2 lock */
    vuint32_t WR1_ACC_CTRL:1;          /* Work register 1 access control */
    vuint32_t WR1_LCK:1;               /* Work register 1 lock */
    vuint32_t WR0_ACC_CTRL:1;          /* Work register 0 access control */
    vuint32_t WR0_LCK:1;               /* Work register 0 lock */
  } B;
} SPT_WR_0_15_CTRL_REG_tag;

typedef union SPT_WR_16_31_CTRL_REG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WR31_ACC_CTRL:1;         /* Work register 31 access control */
    vuint32_t WR31_LCK:1;              /* Work register 31 lock */
    vuint32_t WR30_ACC_CTRL:1;         /* Work register 30 access control */
    vuint32_t WR30_LCK:1;              /* Work register 30 lock */
    vuint32_t WR29_ACC_CTRL:1;         /* Work register 29 access control */
    vuint32_t WR29_LCK:1;              /* Work register 29 lock */
    vuint32_t WR28_ACC_CTRL:1;         /* Work register 28 access control */
    vuint32_t WR28_LCK:1;              /* Work register 28 lock */
    vuint32_t WR27_ACC_CTRL:1;         /* Work register 27 access control */
    vuint32_t WR27_LCK:1;              /* Work register 27 lock */
    vuint32_t WR26_ACC_CTRL:1;         /* Work register 26 access control */
    vuint32_t WR26_LCK:1;              /* Work register 26 lock */
    vuint32_t WR25_ACC_CTRL:1;         /* Work register 25 access control */
    vuint32_t WR25_LCK:1;              /* Work register 25 lock */
    vuint32_t WR24_ACC_CTRL:1;         /* Work register 24 access control */
    vuint32_t WR24_LCK:1;              /* Work register 24 lock */
    vuint32_t WR23_ACC_CTRL:1;         /* Work register 23 access control */
    vuint32_t WR23_LCK:1;              /* Work register 23 lock */
    vuint32_t WR22_ACC_CTRL:1;         /* Work register 22 access control */
    vuint32_t WR22_LCK:1;              /* Work register 22 lock */
    vuint32_t WR21_ACC_CTRL:1;         /* Work register 21 access control */
    vuint32_t WR21_LCK:1;              /* Work register 21 lock */
    vuint32_t WR20_ACC_CTRL:1;         /* Work register 20 access control */
    vuint32_t WR20_LCK:1;              /* Work register 20 lock */
    vuint32_t WR19_ACC_CTRL:1;         /* Work register 19 access control */
    vuint32_t WR19_LCK:1;              /* Work register 19 lock */
    vuint32_t WR18_ACC_CTRL:1;         /* Work register 18 access control */
    vuint32_t WR18_LCK:1;              /* Work register 18 lock */
    vuint32_t WR17_ACC_CTRL:1;         /* Work register 1 access control */
    vuint32_t WR17_LCK:1;              /* Work register 17 lock */
    vuint32_t WR16_ACC_CTRL:1;         /* Work register 15 access control */
    vuint32_t WR16_LCK:1;              /* Work register 15 lock */
  } B;
} SPT_WR_16_31_CTRL_REG_tag;

typedef union SPT_WR_32_47_CTRL_REG_union_tag {
  vuint32_t R;
  struct {
    vuint32_t WR47_ACC_CTRL:1;         /* Work register 47 access control */
    vuint32_t WR47_LCK:1;              /* Work register 31 lock */
    vuint32_t WR46_ACC_CTRL:1;         /* Work register 46 access control */
    vuint32_t WR46_LCK:1;              /* Work register 46 lock */
    vuint32_t WR45_ACC_CTRL:1;         /* Work register 45 access control */
    vuint32_t WR45_LCK:1;              /* Work register 45 lock */
    vuint32_t WR44_ACC_CTRL:1;         /* Work register 44 access control */
    vuint32_t WR44_LCK:1;              /* Work register 44 lock */
    vuint32_t WR43_ACC_CTRL:1;         /* Work register 43 access control */
    vuint32_t WR43_LCK:1;              /* Work register 43 lock */
    vuint32_t WR42_ACC_CTRL:1;         /* Work register 42 access control */
    vuint32_t WR42_LCK:1;              /* Work register 42 lock */
    vuint32_t WR41_ACC_CTRL:1;         /* Work register 41 access control */
    vuint32_t WR41_LCK:1;              /* Work register 41 lock */
    vuint32_t WR40_ACC_CTRL:1;         /* Work register 40 access control */
    vuint32_t WR40_LCK:1;              /* Work register 40 lock */
    vuint32_t WR39_ACC_CTRL:1;         /* Work register 39 access control */
    vuint32_t WR39_LCK:1;              /* Work register 39 lock */
    vuint32_t WR38_ACC_CTRL:1;         /* Work register 38 access control */
    vuint32_t WR38_LCK:1;              /* Work register 38 lock */
    vuint32_t WR37_ACC_CTRL:1;         /* Work register 37 access control */
    vuint32_t WR37_LCK:1;              /* Work register 37 lock */
    vuint32_t WR36_ACC_CTRL:1;         /* Work register 36 access control */
    vuint32_t WR36_LCK:1;              /* Work register 36 lock */
    vuint32_t WR35_ACC_CTRL:1;         /* Work register 35 access control */
    vuint32_t WR35_LCK:1;              /* Work register 35 lock */
    vuint32_t WR34_ACC_CTRL:1;         /* Work register 34 access control */
    vuint32_t WR34_LCK:1;              /* Work register 34 lock */
    vuint32_t WR33_ACC_CTRL:1;         /* Work register 33 access control */
    vuint32_t WR33_LCK:1;              /* Work register 33 lock */
    vuint32_t WR32_ACC_CTRL:1;         /* Work register 32 access control */
    vuint32_t WR32_LCK:1;              /* Work register 32 lock */
  } B;
} SPT_WR_32_47_CTRL_REG_tag;

typedef union SPT_WR_R0_RE_union_tag { /* Work Register R0 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R0:24;              /* Real part of Work Register R0 */
  } B;
} SPT_WR_R0_RE_tag;

typedef union SPT_WR_R0_IM_union_tag { /* Work Register R0 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R0:24;                /* Imaginary part of Work Register R0 */
  } B;
} SPT_WR_R0_IM_tag;

typedef union SPT_WR_R1_RE_union_tag { /* Work Register R1 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R1:24;              /* Real part of Work Register R1 */
  } B;
} SPT_WR_R1_RE_tag;

typedef union SPT_WR_R1_IM_union_tag { /* Work Register R1 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R1:24;                /* Imaginary part of Work Register R1 */
  } B;
} SPT_WR_R1_IM_tag;

typedef union SPT_WR_R2_RE_union_tag { /* Work Register R0 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R2:24;              /* Real part of Work Register R2 */
  } B;
} SPT_WR_R2_RE_tag;

typedef union SPT_WR_R2_IM_union_tag { /* Work Register R2 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R2:24;                /* Imaginary part of Work Register R2 */
  } B;
} SPT_WR_R2_IM_tag;

typedef union SPT_WR_R3_RE_union_tag { /* Work Register R3 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R3:24;              /* Real part of Work Register R3 */
  } B;
} SPT_WR_R3_RE_tag;

typedef union SPT_WR_R3_IM_union_tag { /* Work Register R3 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R3:24;                /* Imaginary part of Work Register R3 */
  } B;
} SPT_WR_R3_IM_tag;

typedef union SPT_WR_R4_RE_union_tag { /* Work Register R4 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R4:24;              /* Real part of Work Register R4 */
  } B;
} SPT_WR_R4_RE_tag;

typedef union SPT_WR_R4_IM_union_tag { /* Work Register R4 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R4:24;                /* Imaginary part of Work Register R4 */
  } B;
} SPT_WR_R4_IM_tag;

typedef union SPT_WR_R5_RE_union_tag { /* Work Register R5 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R5:24;              /* Real part of Work Register R5 */
  } B;
} SPT_WR_R5_RE_tag;

typedef union SPT_WR_R5_IM_union_tag { /* Work Register R5 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R5:24;                /* Imaginary part of Work Register R5 */
  } B;
} SPT_WR_R5_IM_tag;

typedef union SPT_WR_R6_RE_union_tag { /* Work Register R6 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R6:24;              /* Real part of Work Register R6 */
  } B;
} SPT_WR_R6_RE_tag;

typedef union SPT_WR_R6_IM_union_tag { /* Work Register R6 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R6:24;                /* Imaginary part of Work Register R6 */
  } B;
} SPT_WR_R6_IM_tag;

typedef union SPT_WR_R7_RE_union_tag { /* Work Register R7 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R7:24;              /* Real part of Work Register R7 */
  } B;
} SPT_WR_R7_RE_tag;

typedef union SPT_WR_R7_IM_union_tag { /* Work Register R7 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R7:24;                /* Imaginary part of Work Register R7 */
  } B;
} SPT_WR_R7_IM_tag;

typedef union SPT_WR_R8_RE_union_tag { /* Work Register R8 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R8:24;              /* Real part of Work Register R8 */
  } B;
} SPT_WR_R8_RE_tag;

typedef union SPT_WR_R8_IM_union_tag { /* Work Register R8 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R8:24;                /* Imaginary part of Work Register R8 */
  } B;
} SPT_WR_R8_IM_tag;

typedef union SPT_WR_R9_RE_union_tag { /* Work Register R9 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R9:24;              /* Real part of Work Register R9 */
  } B;
} SPT_WR_R9_RE_tag;

typedef union SPT_WR_R9_IM_union_tag { /* Work Register R9 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R9:24;                /* Imaginary part of Work Register R9 */
  } B;
} SPT_WR_R9_IM_tag;

typedef union SPT_WR_R10_RE_union_tag { /* Work Register R10 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R10:24;             /* Real part of Work Register R10 */
  } B;
} SPT_WR_R10_RE_tag;

typedef union SPT_WR_R10_IM_union_tag { /* Work Register R10 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R10:24;               /* Imaginary part of Work Register R10 */
  } B;
} SPT_WR_R10_IM_tag;

typedef union SPT_WR_R11_RE_union_tag { /* Work Register R11 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R11:24;             /* Real part of Work Register R11 */
  } B;
} SPT_WR_R11_RE_tag;

typedef union SPT_WR_R11_IM_union_tag { /* Work Register R11 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R11:24;               /* Imaginary part of Work Register R11 */
  } B;
} SPT_WR_R11_IM_tag;

typedef union SPT_WR_R12_RE_union_tag { /* Work Register R12 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R12:24;             /* Real part of Work Register R12 */
  } B;
} SPT_WR_R12_RE_tag;

typedef union SPT_WR_R12_IM_union_tag { /* Work Register R12 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R12:24;               /* Imaginary part of Work Register R12 */
  } B;
} SPT_WR_R12_IM_tag;

typedef union SPT_WR_R13_RE_union_tag { /* Work Register R13 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R13:24;             /* Real part of Work Register R13 */
  } B;
} SPT_WR_R13_RE_tag;

typedef union SPT_WR_R13_IM_union_tag { /* Work Register R13 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R13:24;               /* Imaginary part of Work Register R13 */
  } B;
} SPT_WR_R13_IM_tag;

typedef union SPT_WR_R14_RE_union_tag { /* Work Register R14 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R14:24;             /* Real part of Work Register R14 */
  } B;
} SPT_WR_R14_RE_tag;

typedef union SPT_WR_R14_IM_union_tag { /* Work Register R14 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R14:24;               /* Imaginary part of Work Register R14 */
  } B;
} SPT_WR_R14_IM_tag;

typedef union SPT_WR_R15_RE_union_tag { /* Work Register R15 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R15:24;             /* Real part of Work Register R15 */
  } B;
} SPT_WR_R15_RE_tag;

typedef union SPT_WR_R15_IM_union_tag { /* Work Register R15 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R15:24;               /* Imaginary part of Work Register R15 */
  } B;
} SPT_WR_R15_IM_tag;

typedef union SPT_WR_R16_RE_union_tag { /* Work Register R16 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R16:24;             /* Real part of Work Register R16 */
  } B;
} SPT_WR_R16_RE_tag;

typedef union SPT_WR_R16_IM_union_tag { /* Work Register R16 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R16:24;               /* Imaginary part of Work Register R16 */
  } B;
} SPT_WR_R16_IM_tag;

typedef union SPT_WR_R17_RE_union_tag { /* Work Register R17 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R17:24;             /* Real part of Work Register R17 */
  } B;
} SPT_WR_R17_RE_tag;

typedef union SPT_WR_R17_IM_union_tag { /* Work Register R17 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R17:24;               /* Imaginary part of Work Register R17 */
  } B;
} SPT_WR_R17_IM_tag;

typedef union SPT_WR_R18_RE_union_tag { /* Work Register R18 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R18:24;             /* Real part of Work Register R18 */
  } B;
} SPT_WR_R18_RE_tag;

typedef union SPT_WR_R18_IM_union_tag { /* Work Register R18 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R18:24;               /* Imaginary part of Work Register R18 */
  } B;
} SPT_WR_R18_IM_tag;

typedef union SPT_WR_R19_RE_union_tag { /* Work Register R19 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R19:24;             /* Real part of Work Register R19 */
  } B;
} SPT_WR_R19_RE_tag;

typedef union SPT_WR_R19_IM_union_tag { /* Work Register R19 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R19:24;               /* Imaginary part of Work Register R19 */
  } B;
} SPT_WR_R19_IM_tag;

typedef union SPT_WR_R20_RE_union_tag { /* Work Register R20 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R20:24;             /* Real part of Work Register R20 */
  } B;
} SPT_WR_R20_RE_tag;

typedef union SPT_WR_R20_IM_union_tag { /* Work Register R20 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R20:24;               /* Imaginary part of Work Register R20 */
  } B;
} SPT_WR_R20_IM_tag;

typedef union SPT_WR_R21_RE_union_tag { /* Work Register R21 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R21:24;             /* Real part of Work Register R21 */
  } B;
} SPT_WR_R21_RE_tag;

typedef union SPT_WR_R21_IM_union_tag { /* Work Register R21 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R21:24;               /* Imaginary part of Work Register R21 */
  } B;
} SPT_WR_R21_IM_tag;

typedef union SPT_WR_R22_RE_union_tag { /* Work Register R22 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R22:24;             /* Real part of Work Register R22 */
  } B;
} SPT_WR_R22_RE_tag;

typedef union SPT_WR_R22_IM_union_tag { /* Work Register R22 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R22:24;               /* Imaginary part of Work Register R22 */
  } B;
} SPT_WR_R22_IM_tag;

typedef union SPT_WR_R23_RE_union_tag { /* Work Register R23 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R23:24;             /* Real part of Work Register R23 */
  } B;
} SPT_WR_R23_RE_tag;

typedef union SPT_WR_R23_IM_union_tag { /* Work Register R23 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R23:24;               /* Imaginary part of Work Register R23 */
  } B;
} SPT_WR_R23_IM_tag;

typedef union SPT_WR_R24_RE_union_tag { /* Work Register R24 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R24:24;             /* Real part of Work Register R24 */
  } B;
} SPT_WR_R24_RE_tag;

typedef union SPT_WR_R24_IM_union_tag { /* Work Register R24 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R24:24;               /* Imaginary part of Work Register R24 */
  } B;
} SPT_WR_R24_IM_tag;

typedef union SPT_WR_R25_RE_union_tag { /* Work Register R25 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R25:24;             /* Real part of Work Register R25 */
  } B;
} SPT_WR_R25_RE_tag;

typedef union SPT_WR_R25_IM_union_tag { /* Work Register R25 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R25:24;               /* Imaginary part of Work Register R25 */
  } B;
} SPT_WR_R25_IM_tag;

typedef union SPT_WR_R26_RE_union_tag { /* Work Register R26 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R26:24;             /* Real part of Work Register R26 */
  } B;
} SPT_WR_R26_RE_tag;

typedef union SPT_WR_R26_IM_union_tag { /* Work Register R26 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R26:24;               /* Imaginary part of Work Register R26 */
  } B;
} SPT_WR_R26_IM_tag;

typedef union SPT_WR_R27_RE_union_tag { /* Work Register R27 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R27:24;             /* Real part of Work Register R27 */
  } B;
} SPT_WR_R27_RE_tag;

typedef union SPT_WR_R27_IM_union_tag { /* Work Register R27 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R27:24;               /* Imaginary part of Work Register R27 */
  } B;
} SPT_WR_R27_IM_tag;

typedef union SPT_WR_R28_RE_union_tag { /* Work Register R28 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R28:24;             /* Real part of Work Register R28 */
  } B;
} SPT_WR_R28_RE_tag;

typedef union SPT_WR_R28_IM_union_tag { /* Work Register R28 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R28:24;               /* Imaginary part of Work Register R28 */
  } B;
} SPT_WR_R28_IM_tag;

typedef union SPT_WR_R29_RE_union_tag { /* Work Register R29 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R29:24;             /* Real part of Work Register R29 */
  } B;
} SPT_WR_R29_RE_tag;

typedef union SPT_WR_R29_IM_union_tag { /* Work Register R29 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R29:24;               /* Imaginary part of Work Register R29 */
  } B;
} SPT_WR_R29_IM_tag;

typedef union SPT_WR_R30_RE_union_tag { /* Work Register R30 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R30:24;             /* Real part of Work Register R30 */
  } B;
} SPT_WR_R30_RE_tag;

typedef union SPT_WR_R30_IM_union_tag { /* Work Register R30 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R30:24;               /* Imaginary part of Work Register R30 */
  } B;
} SPT_WR_R30_IM_tag;

typedef union SPT_WR_R31_RE_union_tag { /* Work Register R31 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R31:24;             /* Real part of Work Register R31 */
  } B;
} SPT_WR_R31_RE_tag;

typedef union SPT_WR_R31_IM_union_tag { /* Work Register R31 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R31:24;               /* Imaginary part of Work Register R31 */
  } B;
} SPT_WR_R31_IM_tag;

typedef union SPT_WR_R32_RE_union_tag { /* Work Register R32 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R32:24;             /* Real part of Work Register R32 */
  } B;
} SPT_WR_R32_RE_tag;

typedef union SPT_WR_R32_IM_union_tag { /* Work Register R32 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R32:24;               /* Imaginary part of Work Register R32 */
  } B;
} SPT_WR_R32_IM_tag;

typedef union SPT_WR_R33_RE_union_tag { /* Work Register R33 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R33:24;             /* Real part of Work Register R33 */
  } B;
} SPT_WR_R33_RE_tag;

typedef union SPT_WR_R33_IM_union_tag { /* Work Register R33 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R33:24;               /* Imaginary part of Work Register R33 */
  } B;
} SPT_WR_R33_IM_tag;

typedef union SPT_WR_R34_RE_union_tag { /* Work Register R34 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R34:24;             /* Real part of Work Register R34 */
  } B;
} SPT_WR_R34_RE_tag;

typedef union SPT_WR_R34_IM_union_tag { /* Work Register R34 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R34:24;               /* Imaginary part of Work Register R34 */
  } B;
} SPT_WR_R34_IM_tag;

typedef union SPT_WR_R35_RE_union_tag { /* Work Register R35 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R35:24;             /* Real part of Work Register R35 */
  } B;
} SPT_WR_R35_RE_tag;

typedef union SPT_WR_R35_IM_union_tag { /* Work Register R35 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R35:24;               /* Imaginary part of Work Register R35 */
  } B;
} SPT_WR_R35_IM_tag;

typedef union SPT_WR_R36_RE_union_tag { /* Work Register R36 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R36:24;             /* Real part of Work Register R36 */
  } B;
} SPT_WR_R36_RE_tag;

typedef union SPT_WR_R36_IM_union_tag { /* Work Register R36 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R36:24;               /* Imaginary part of Work Register R36 */
  } B;
} SPT_WR_R36_IM_tag;

typedef union SPT_WR_R37_RE_union_tag { /* Work Register R37 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R37:24;             /* Real part of Work Register R37 */
  } B;
} SPT_WR_R37_RE_tag;

typedef union SPT_WR_R37_IM_union_tag { /* Work Register R37 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R37:24;               /* Imaginary part of Work Register R37 */
  } B;
} SPT_WR_R37_IM_tag;

typedef union SPT_WR_R38_RE_union_tag { /* Work Register R38 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R38:24;             /* Real part of Work Register R38 */
  } B;
} SPT_WR_R38_RE_tag;

typedef union SPT_WR_R38_IM_union_tag { /* Work Register R38 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R38:24;               /* Imaginary part of Work Register R38 */
  } B;
} SPT_WR_R38_IM_tag;

typedef union SPT_WR_R39_RE_union_tag { /* Work Register R39 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R39:24;             /* Real part of Work Register R39 */
  } B;
} SPT_WR_R39_RE_tag;

typedef union SPT_WR_R39_IM_union_tag { /* Work Register R39 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R39:24;               /* Imaginary part of Work Register R39 */
  } B;
} SPT_WR_R39_IM_tag;

typedef union SPT_WR_R40_RE_union_tag { /* Work Register R40 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R40:24;             /* Real part of Work Register R40 */
  } B;
} SPT_WR_R40_RE_tag;

typedef union SPT_WR_R40_IM_union_tag { /* Work Register R40 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R40:24;               /* Imaginary part of Work Register R40 */
  } B;
} SPT_WR_R40_IM_tag;

typedef union SPT_WR_R41_RE_union_tag { /* Work Register R41 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R41:24;             /* Real part of Work Register R41 */
  } B;
} SPT_WR_R41_RE_tag;

typedef union SPT_WR_R41_IM_union_tag { /* Work Register R41 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R41:24;               /* Imaginary part of Work Register R41 */
  } B;
} SPT_WR_R41_IM_tag;

typedef union SPT_WR_R42_RE_union_tag { /* Work Register R42 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R42:24;             /* Real part of Work Register R42 */
  } B;
} SPT_WR_R42_RE_tag;

typedef union SPT_WR_R42_IM_union_tag { /* Work Register R42 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R42:24;               /* Imaginary part of Work Register R42 */
  } B;
} SPT_WR_R42_IM_tag;

typedef union SPT_WR_R43_RE_union_tag { /* Work Register R43 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R43:24;             /* Real part of Work Register R43 */
  } B;
} SPT_WR_R43_RE_tag;

typedef union SPT_WR_R43_IM_union_tag { /* Work Register R43 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R43:24;               /* Imaginary part of Work Register R43 */
  } B;
} SPT_WR_R43_IM_tag;

typedef union SPT_WR_R44_RE_union_tag { /* Work Register R44 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R44:24;             /* Real part of Work Register R44 */
  } B;
} SPT_WR_R44_RE_tag;

typedef union SPT_WR_R44_IM_union_tag { /* Work Register R44 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R44:24;               /* Imaginary part of Work Register R44 */
  } B;
} SPT_WR_R44_IM_tag;

typedef union SPT_WR_R45_RE_union_tag { /* Work Register R45 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R45:24;             /* Real part of Work Register R45 */
  } B;
} SPT_WR_R45_RE_tag;

typedef union SPT_WR_R45_IM_union_tag { /* Work Register R45 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R45:24;               /* Imaginary part of Work Register R45 */
  } B;
} SPT_WR_R45_IM_tag;

typedef union SPT_WR_R46_RE_union_tag { /* Work Register R46 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R46:24;             /* Real part of Work Register R46 */
  } B;
} SPT_WR_R46_RE_tag;

typedef union SPT_WR_R46_IM_union_tag { /* Work Register R46 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R46:24;               /* Imaginary part of Work Register R46 */
  } B;
} SPT_WR_R46_IM_tag;

typedef union SPT_WR_R47_RE_union_tag { /* Work Register R47 Real */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t REAL_R47:24;             /* Real part of Work Register R47 */
  } B;
} SPT_WR_R47_RE_tag;

typedef union SPT_WR_R47_IM_union_tag { /* Work Register R47 Imaginary */
  vuint32_t R;
  struct {
    vuint32_t SIGN_EXT:8;              /* Sign Extension */
    vuint32_t IM_R47:24;               /* Imaginary part of Work Register R47 */
  } B;
} SPT_WR_R47_IM_tag;

struct SPT_tag {
  SPT_GBL_CTRL_tag GBL_CTRL;           /* SPT Global Control Register */
  SPT_ACQ_GBL_CTRL_0_tag ACQ_GBL_CTRL_0; /* Acquistion Global Control Register */
  SPT_ACQ_GBL_CTRL_1_tag ACQ_GBL_CTRL_1; /* Acquistion Global Control Register 1 */
  uint8_t SPT_reserved0[4];
  SPT_ACQ_CTRL0_tag ACQ_CTRL0;         /* Acquisition Control 0 Register */
  SPT_ACQ_CTRL1_tag ACQ_CTRL1;         /* Acquisition Control 1 Register */
  SPT_ACQ_CTRL2_tag ACQ_CTRL2;         /* Acquisition Control 2 Register */
  SPT_ACQ_CTRL3_tag ACQ_CTRL3;         /* Acquisition Control 3 Register */
  SPT_SDMA_CTRL0_tag SDMA_CTRL0;       /* SDMA Control 0 Register */
  SPT_SDMA_CTRL1_tag SDMA_CTRL1;       /* SDMA Control 1 Register */
  uint8_t SPT_reserved1[28];
  SPT_ACQ_STATUS_A0_tag ACQ_STATUS_A0; /* Acquisition Status Register A0 */
  SPT_ACQ_STATUS_A1_tag ACQ_STATUS_A1; /* Acquisition Status Register A1 */
  SPT_ACQ_STATUS_A2_tag ACQ_STATUS_A2; /* Acquisition Status Register A2 */
  SPT_ACQ_STATUS_B0_tag ACQ_STATUS_B0; /* Acquisition Status Register B0 */
  SPT_ACQ_STATUS_B1_tag ACQ_STATUS_B1; /* Acquisition Status Register B1 */
  SPT_ACQ_STATUS_B2_tag ACQ_STATUS_B2; /* Acquisition Status Register B2 */
  SPT_ACQ_STATUS_C0_tag ACQ_STATUS_C0; /* Acquisition Status Register C0 */
  SPT_ACQ_STATUS_C1_tag ACQ_STATUS_C1; /* Acquisition Status Register C1 */
  SPT_ACQ_STATUS_C2_tag ACQ_STATUS_C2; /* Acquisition Status Register C2 */
  SPT_ACQ_STATUS_D0_tag ACQ_STATUS_D0; /* Acquisition Status Register D0 */
  SPT_ACQ_STATUS_D1_tag ACQ_STATUS_D1; /* Acquisition Status Register D1 */
  SPT_ACQ_STATUS_D2_tag ACQ_STATUS_D2; /* Acquisition Status Register D2 */
  SPT_ACQ_STATUS_E0_tag ACQ_STATUS_E0; /* Acquisition Status Register E0 */
  SPT_ACQ_STATUS_E1_tag ACQ_STATUS_E1; /* Acquisition Status Register E1 */
  SPT_ACQ_STATUS_E2_tag ACQ_STATUS_E2; /* Acquisition Status Register E2 */
  SPT_ACQ_STATUS_F0_tag ACQ_STATUS_F0; /* Acquisition Status Register F0 */
  SPT_ACQ_STATUS_F1_tag ACQ_STATUS_F1; /* Acquisition Status Register F1 */
  SPT_ACQ_STATUS_F2_tag ACQ_STATUS_F2; /* Acquisition Status Register F2 */
  SPT_ACQ_STATUS_G0_tag ACQ_STATUS_G0; /* Acquisition Status Register G0 */
  SPT_ACQ_STATUS_G1_tag ACQ_STATUS_G1; /* Acquisition Status Register G1 */
  SPT_ACQ_STATUS_G2_tag ACQ_STATUS_G2; /* Acquisition Status Register G2 */
  SPT_ACQ_STATUS_H0_tag ACQ_STATUS_H0; /* Acquisition Status Register H0 */
  SPT_ACQ_STATUS_H1_tag ACQ_STATUS_H1; /* Acquisition Status Register H1 */
  SPT_ACQ_STATUS_H2_tag ACQ_STATUS_H2; /* Acquisition Status Register H2 */
  uint8_t SPT_reserved2[28];
  SPT_CS_PG_ST_ADDR_tag CS_PG_ST_ADDR; /* Program Start Addr Register */
  SPT_CS_MODE_CTRL_tag CS_MODE_CTRL;   /* Mode Control Register */
  uint8_t SPT_reserved3[4];
  SPT_CS_BKPT0_ADDR_tag CS_BKPT0_ADDR; /* Breakpoint0 Addr Register */
  SPT_CS_BKPT1_ADDR_tag CS_BKPT1_ADDR; /* Breakpoint1 Addr Register */
  SPT_CS_BKPT2_ADDR_tag CS_BKPT2_ADDR; /* Breakpoint2 Addr Register */
  SPT_CS_BKPT3_ADDR_tag CS_BKPT3_ADDR; /* Breakpoint3 Addr Register */
  SPT_CS_JAM_INST0_tag CS_JAM_INST0;   /* Jamming Instruction0 Register */
  SPT_CS_JAM_INST1_tag CS_JAM_INST1;   /* Jamming Instruction1 Register */
  SPT_CS_JAM_INST2_tag CS_JAM_INST2;   /* Jamming Instruction2 Register */
  SPT_CS_JAM_INST3_tag CS_JAM_INST3;   /* Jamming Instruction3 Register */
  SPT_CS_CURR_INST_ADDR_tag CS_CURR_INST_ADDR; /* Current Instruction Addr Register */
  SPT_CS_CURR_INST0_tag CS_CURR_INST0; /* Current Instruction0 Register */
  SPT_CS_CURR_INST1_tag CS_CURR_INST1; /* Current Instruction1 Register */
  SPT_CS_CURR_INST2_tag CS_CURR_INST2; /* Current Instruction2 Register */
  SPT_CS_CURR_INST3_tag CS_CURR_INST3; /* Current Instruction3 Register */
  SPT_CS_LOOPCNTR01_tag CS_LOOPCNTR01; /* Loop Counter 0 and 1 Register */
  SPT_CS_LOOPCNTR23_tag CS_LOOPCNTR23; /* Loop Counter 2 and 3 Register */
  SPT_CS_ERR_INST_ADDR_tag CS_ERR_INST_ADDR; /* Error Instruction Addr Register */
  SPT_CS_ERR_INST0_tag CS_ERR_INST0;   /* Error Instruction 0 Register */
  SPT_CS_ERR_INST1_tag CS_ERR_INST1;   /* Error Instruction 1 Register */
  SPT_CS_ERR_INST2_tag CS_ERR_INST2;   /* Error Instruction 2 Register */
  SPT_CS_ERR_INST3_tag CS_ERR_INST3;   /* Error Instruction 3 Register */
  SPT_CS_STATUS0_tag CS_STATUS0;       /* General Status 0 Register */
  SPT_CS_STATUS1_tag CS_STATUS1;       /* General Status 1 Register */
  SPT_CS_STATUS2_tag CS_STATUS2;       /* General Status2 Register */
  SPT_CS_STATUS3_tag CS_STATUS3;       /* General Status 3 Register */
  SPT_CS_EVTREG1_tag CS_EVTREG1;       /* EVT1 Status Register */
  SPT_CS_EVTREG2_tag CS_EVTREG2;       /* EVT2 Status Register */
  SPT_CS_SW_EVTREG_tag CS_SW_EVTREG;   /* SW Event Trigger Register */
  SPT_CORE1_VER_EVT_tag CORE1_VER_EVT; /* Core 1 Version Register Events */
  SPT_CORE2_VER_EVT_tag CORE2_VER_EVT; /* Core 2 Version Register Events */
  SPT_EVENT_RST_CTRL_tag EVENT_RST_CTRL; /* SPT Event Reset Control Register */
  uint8_t SPT_reserved4[68];
  SPT_PDMA_CONTROL_tag PDMA_CONTROL;   /* PDMA Control Register */
  uint8_t SPT_reserved5[52];
  SPT_PDMA_TRANSFER_COUNT_STATUS_tag PDMA_TRANSFER_COUNT_STATUS; /* PDMA Transfer Count Status */
  uint8_t SPT_reserved6[56];
  SPT_MEM_ERR_INJECT_CTRL_tag MEM_ERR_INJECT_CTRL; /* Memory Error Injection Register */
  SPT_MEM_ERR_STATUS_tag MEM_ERR_STATUS; /* Memory Error Status Register */
  SPT_MEM_ERR_INT_EN_tag MEM_ERR_INT_EN; /* Memory Interrupt Enable register */
  SPT_DMA_ERR_STATUS_tag DMA_ERR_STATUS; /* DMA Error Status Register */
  SPT_DMA_ERR_INT_EN_tag DMA_ERR_INT_EN; /* Interrupt Enable for DMA_ERROR_STATUS */
  SPT_GBL_STATUS_tag GBL_STATUS;       /* Global Status Register */
  SPT_GBL_STATUS_IE_tag GBL_STATUS_IE; /* Global Status Interrupt Enable Register */
  SPT_HW_ACC_ERR_STATUS_tag HW_ACC_ERR_STATUS; /* Hardware Accelerator Error Status Register */
  SPT_HW_ACC_ERR_IE_tag HW_ACC_ERR_IE; /* Hardware Accelerator Error Interrupt Enable Register */
  uint8_t SPT_reserved7[12];
  SPT_CS_INTEN0_tag CS_INTEN0;         /* Interrupt Enable Register 0 */
  SPT_CS_INTEN1_tag CS_INTEN1;         /* Interrupt Enable Register 1 */
  SPT_CS_EVT1_INTEN_tag CS_EVT1_INTEN; /* EVT1 Interrupt Enable Register */
  SPT_CS_EVT2_INTEN_tag CS_EVT2_INTEN; /* EVT2 Interrupt Enable Register */
  uint8_t SPT_reserved8[4];
  SPT_WR_0_15_CTRL_REG_tag WR_0_15_CTRL_REG;
  SPT_WR_16_31_CTRL_REG_tag WR_16_31_CTRL_REG;
  SPT_WR_32_47_CTRL_REG_tag WR_32_47_CTRL_REG;
  uint8_t SPT_reserved9[4];
  SPT_WR_R0_RE_tag WR_R0_RE;           /* Work Register R0 Real */
  SPT_WR_R0_IM_tag WR_R0_IM;           /* Work Register R0 Imaginary */
  SPT_WR_R1_RE_tag WR_R1_RE;           /* Work Register R1 Real */
  SPT_WR_R1_IM_tag WR_R1_IM;           /* Work Register R1 Imaginary */
  SPT_WR_R2_RE_tag WR_R2_RE;           /* Work Register R0 Real */
  SPT_WR_R2_IM_tag WR_R2_IM;           /* Work Register R2 Imaginary */
  SPT_WR_R3_RE_tag WR_R3_RE;           /* Work Register R3 Real */
  SPT_WR_R3_IM_tag WR_R3_IM;           /* Work Register R3 Imaginary */
  SPT_WR_R4_RE_tag WR_R4_RE;           /* Work Register R4 Real */
  SPT_WR_R4_IM_tag WR_R4_IM;           /* Work Register R4 Imaginary */
  SPT_WR_R5_RE_tag WR_R5_RE;           /* Work Register R5 Real */
  SPT_WR_R5_IM_tag WR_R5_IM;           /* Work Register R5 Imaginary */
  SPT_WR_R6_RE_tag WR_R6_RE;           /* Work Register R6 Real */
  SPT_WR_R6_IM_tag WR_R6_IM;           /* Work Register R6 Imaginary */
  SPT_WR_R7_RE_tag WR_R7_RE;           /* Work Register R7 Real */
  SPT_WR_R7_IM_tag WR_R7_IM;           /* Work Register R7 Imaginary */
  SPT_WR_R8_RE_tag WR_R8_RE;           /* Work Register R8 Real */
  SPT_WR_R8_IM_tag WR_R8_IM;           /* Work Register R8 Imaginary */
  SPT_WR_R9_RE_tag WR_R9_RE;           /* Work Register R9 Real */
  SPT_WR_R9_IM_tag WR_R9_IM;           /* Work Register R9 Imaginary */
  SPT_WR_R10_RE_tag WR_R10_RE;         /* Work Register R10 Real */
  SPT_WR_R10_IM_tag WR_R10_IM;         /* Work Register R10 Imaginary */
  SPT_WR_R11_RE_tag WR_R11_RE;         /* Work Register R11 Real */
  SPT_WR_R11_IM_tag WR_R11_IM;         /* Work Register R11 Imaginary */
  SPT_WR_R12_RE_tag WR_R12_RE;         /* Work Register R12 Real */
  SPT_WR_R12_IM_tag WR_R12_IM;         /* Work Register R12 Imaginary */
  SPT_WR_R13_RE_tag WR_R13_RE;         /* Work Register R13 Real */
  SPT_WR_R13_IM_tag WR_R13_IM;         /* Work Register R13 Imaginary */
  SPT_WR_R14_RE_tag WR_R14_RE;         /* Work Register R14 Real */
  SPT_WR_R14_IM_tag WR_R14_IM;         /* Work Register R14 Imaginary */
  SPT_WR_R15_RE_tag WR_R15_RE;         /* Work Register R15 Real */
  SPT_WR_R15_IM_tag WR_R15_IM;         /* Work Register R15 Imaginary */
  SPT_WR_R16_RE_tag WR_R16_RE;         /* Work Register R16 Real */
  SPT_WR_R16_IM_tag WR_R16_IM;         /* Work Register R16 Imaginary */
  SPT_WR_R17_RE_tag WR_R17_RE;         /* Work Register R17 Real */
  SPT_WR_R17_IM_tag WR_R17_IM;         /* Work Register R17 Imaginary */
  SPT_WR_R18_RE_tag WR_R18_RE;         /* Work Register R18 Real */
  SPT_WR_R18_IM_tag WR_R18_IM;         /* Work Register R18 Imaginary */
  SPT_WR_R19_RE_tag WR_R19_RE;         /* Work Register R19 Real */
  SPT_WR_R19_IM_tag WR_R19_IM;         /* Work Register R19 Imaginary */
  SPT_WR_R20_RE_tag WR_R20_RE;         /* Work Register R20 Real */
  SPT_WR_R20_IM_tag WR_R20_IM;         /* Work Register R20 Imaginary */
  SPT_WR_R21_RE_tag WR_R21_RE;         /* Work Register R21 Real */
  SPT_WR_R21_IM_tag WR_R21_IM;         /* Work Register R21 Imaginary */
  SPT_WR_R22_RE_tag WR_R22_RE;         /* Work Register R22 Real */
  SPT_WR_R22_IM_tag WR_R22_IM;         /* Work Register R22 Imaginary */
  SPT_WR_R23_RE_tag WR_R23_RE;         /* Work Register R23 Real */
  SPT_WR_R23_IM_tag WR_R23_IM;         /* Work Register R23 Imaginary */
  SPT_WR_R24_RE_tag WR_R24_RE;         /* Work Register R24 Real */
  SPT_WR_R24_IM_tag WR_R24_IM;         /* Work Register R24 Imaginary */
  SPT_WR_R25_RE_tag WR_R25_RE;         /* Work Register R25 Real */
  SPT_WR_R25_IM_tag WR_R25_IM;         /* Work Register R25 Imaginary */
  SPT_WR_R26_RE_tag WR_R26_RE;         /* Work Register R26 Real */
  SPT_WR_R26_IM_tag WR_R26_IM;         /* Work Register R26 Imaginary */
  SPT_WR_R27_RE_tag WR_R27_RE;         /* Work Register R27 Real */
  SPT_WR_R27_IM_tag WR_R27_IM;         /* Work Register R27 Imaginary */
  SPT_WR_R28_RE_tag WR_R28_RE;         /* Work Register R28 Real */
  SPT_WR_R28_IM_tag WR_R28_IM;         /* Work Register R28 Imaginary */
  SPT_WR_R29_RE_tag WR_R29_RE;         /* Work Register R29 Real */
  SPT_WR_R29_IM_tag WR_R29_IM;         /* Work Register R29 Imaginary */
  SPT_WR_R30_RE_tag WR_R30_RE;         /* Work Register R30 Real */
  SPT_WR_R30_IM_tag WR_R30_IM;         /* Work Register R30 Imaginary */
  SPT_WR_R31_RE_tag WR_R31_RE;         /* Work Register R31 Real */
  SPT_WR_R31_IM_tag WR_R31_IM;         /* Work Register R31 Imaginary */
  SPT_WR_R32_RE_tag WR_R32_RE;         /* Work Register R32 Real */
  SPT_WR_R32_IM_tag WR_R32_IM;         /* Work Register R32 Imaginary */
  SPT_WR_R33_RE_tag WR_R33_RE;         /* Work Register R33 Real */
  SPT_WR_R33_IM_tag WR_R33_IM;         /* Work Register R33 Imaginary */
  SPT_WR_R34_RE_tag WR_R34_RE;         /* Work Register R34 Real */
  SPT_WR_R34_IM_tag WR_R34_IM;         /* Work Register R34 Imaginary */
  SPT_WR_R35_RE_tag WR_R35_RE;         /* Work Register R35 Real */
  SPT_WR_R35_IM_tag WR_R35_IM;         /* Work Register R35 Imaginary */
  SPT_WR_R36_RE_tag WR_R36_RE;         /* Work Register R36 Real */
  SPT_WR_R36_IM_tag WR_R36_IM;         /* Work Register R36 Imaginary */
  SPT_WR_R37_RE_tag WR_R37_RE;         /* Work Register R37 Real */
  SPT_WR_R37_IM_tag WR_R37_IM;         /* Work Register R37 Imaginary */
  SPT_WR_R38_RE_tag WR_R38_RE;         /* Work Register R38 Real */
  SPT_WR_R38_IM_tag WR_R38_IM;         /* Work Register R38 Imaginary */
  SPT_WR_R39_RE_tag WR_R39_RE;         /* Work Register R39 Real */
  SPT_WR_R39_IM_tag WR_R39_IM;         /* Work Register R39 Imaginary */
  SPT_WR_R40_RE_tag WR_R40_RE;         /* Work Register R40 Real */
  SPT_WR_R40_IM_tag WR_R40_IM;         /* Work Register R40 Imaginary */
  SPT_WR_R41_RE_tag WR_R41_RE;         /* Work Register R41 Real */
  SPT_WR_R41_IM_tag WR_R41_IM;         /* Work Register R41 Imaginary */
  SPT_WR_R42_RE_tag WR_R42_RE;         /* Work Register R42 Real */
  SPT_WR_R42_IM_tag WR_R42_IM;         /* Work Register R42 Imaginary */
  SPT_WR_R43_RE_tag WR_R43_RE;         /* Work Register R43 Real */
  SPT_WR_R43_IM_tag WR_R43_IM;         /* Work Register R43 Imaginary */
  SPT_WR_R44_RE_tag WR_R44_RE;         /* Work Register R44 Real */
  SPT_WR_R44_IM_tag WR_R44_IM;         /* Work Register R44 Imaginary */
  SPT_WR_R45_RE_tag WR_R45_RE;         /* Work Register R45 Real */
  SPT_WR_R45_IM_tag WR_R45_IM;         /* Work Register R45 Imaginary */
  SPT_WR_R46_RE_tag WR_R46_RE;         /* Work Register R46 Real */
  SPT_WR_R46_IM_tag WR_R46_IM;         /* Work Register R46 Imaginary */
  SPT_WR_R47_RE_tag WR_R47_RE;         /* Work Register R47 Real */
  SPT_WR_R47_IM_tag WR_R47_IM;         /* Work Register R47 Imaginary */
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

typedef union SSCM_STATUS_union_tag {  /* SSCM System Status */
  vuint16_t R;
  struct {
    vuint16_t _unused_15:1;
    vuint16_t CER:1;                   /* Configuration Error */
    vuint16_t CERS:1;                  /* Configuration Error for Safe DCF Clients */
    vuint16_t NXEN1:1;                 /* Processor 1 Nexus enable status */
    vuint16_t NXEN:1;                  /* Processor 0 Nexus enable status */
    vuint16_t PUB:1;                   /* Public Serial Access Status */
    vuint16_t SEC:1;                   /* Security Status */
    vuint16_t _unused_8:1;
    vuint16_t BMODE:3;                 /* Device Boot Mode */
    vuint16_t _unused_4:1;
    vuint16_t _unused_3:1;
    vuint16_t _unused_2:1;
    vuint16_t _unused_0:2;
  } B;
} SSCM_STATUS_tag;

typedef union SSCM_MEMCONFIG_union_tag { /* SSCM System Memory and ID Register */
  vuint16_t R;
  struct {
    vuint16_t JPIN:10;
    vuint16_t IVLD:1;                  /* Instruction flash memory Valid */
    vuint16_t MREV:4;                  /* Minor Mask Revision */
    vuint16_t _unused_0:1;
  } B;
} SSCM_MEMCONFIG_tag;

typedef union SSCM_ERROR_union_tag {   /* SSCM Error Configuration Register */
  vuint16_t R;
  struct {
    vuint16_t _unused_2:14;
    vuint16_t PAE:1;                   /* Peripheral Bus Abort Enable. */
    vuint16_t RAE:1;                   /* Register Bus Abort Enable. */
  } B;
} SSCM_ERROR_tag;

typedef union SSCM_PWCMPH_union_tag {  /* Password comparison register low word */
  vuint32_t R;
  struct {
    vuint32_t PWD_HI:32;
  } B;
} SSCM_PWCMPH_tag;

typedef union SSCM_PWCMPL_union_tag {  /* Password comparison register low word */
  vuint32_t R;
  struct {
    vuint32_t PWD_LO:32;
  } B;
} SSCM_PWCMPL_tag;

typedef union SSCM_PSA_union_tag {     /* Processor Start Address Register */
  vuint32_t R;
  struct {
    vuint32_t SADR:32;                 /* Processor Start Address */
  } B;
} SSCM_PSA_tag;

struct SSCM_tag {
  SSCM_STATUS_tag STATUS;              /* SSCM System Status */
  SSCM_MEMCONFIG_tag MEMCONFIG;        /* SSCM System Memory and ID Register */
  uint8_t SSCM_reserved0[2];
  SSCM_ERROR_tag ERROR;                /* SSCM Error Configuration Register */
  uint8_t SSCM_reserved1[4];
  SSCM_PWCMPH_tag PWCMPH;              /* Password comparison register low word */
  SSCM_PWCMPL_tag PWCMPL;              /* Password comparison register low word */
  uint8_t SSCM_reserved2[20];
  SSCM_PSA_tag PSA;                    /* Processor Start Address Register */
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

typedef union STCU2_RUN_union_tag {    /* STCU2 Run Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t BYP:1;
    vuint32_t MBPLLEN:1;
    vuint32_t LBPLLEN:1;
    vuint32_t _unused_1:7;
    vuint32_t RUN:1;
  } B;
} STCU2_RUN_tag;

typedef union STCU2_RUNSW_union_tag {  /* STCU2 Run Software Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_12:20;
    vuint32_t _unused_11:1;
    vuint32_t _unused_10:1;
    vuint32_t MBSWPLLEN:1;
    vuint32_t LBSWPLLEN:1;
    vuint32_t _unused_2:6;
    vuint32_t _unused_1:1;
    vuint32_t RUNSW:1;
  } B;
} STCU2_RUNSW_tag;

typedef union STCU2_SKC_union_tag {    /* STCU2 SK Code Register */
  vuint32_t R;
  struct {
    vuint32_t SKC:32;
  } B;
} STCU2_SKC_tag;

typedef union STCU2_CFG_union_tag {    /* STCU2 Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t PTR:7;
    vuint32_t LB_DELAY:8;
    vuint32_t _unused_9:7;
    vuint32_t WRP:1;
    vuint32_t _unused_6:2;
    vuint32_t CRCEN:1;
    vuint32_t PMOSEN:1;
    vuint32_t MBU:1;
    vuint32_t CLK_CFG:3;
  } B;
} STCU2_CFG_tag;

typedef union STCU2_PLL_CFG_union_tag { /* STCU2 PLL Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_30:2;
    vuint32_t PLLODF:6;
    vuint32_t _unused_19:5;
    vuint32_t PLLIDF:3;
    vuint32_t _unused_7:9;
    vuint32_t PLLLDF:7;
  } B;
} STCU2_PLL_CFG_tag;

typedef union STCU2_WDG_union_tag {    /* STCU2 Watchdog Register Granularity */
  vuint32_t R;
  struct {
    vuint32_t WDGEOC:32;
  } B;
} STCU2_WDG_tag;

typedef union STCU2_CRCE_union_tag {   /* STCU2 CRC Expected Status Register */
  vuint32_t R;
  struct {
    vuint32_t CRCE:32;
  } B;
} STCU2_CRCE_tag;

typedef union STCU2_CRCR_union_tag {   /* STCU2 CRC Read Status Register */
  vuint32_t R;
  struct {
    vuint32_t CRCR:32;
  } B;
} STCU2_CRCR_tag;

typedef union STCU2_ERR_STAT_union_tag { /* STCU2 Error Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t ABORTHW:1;
    vuint32_t _unused_24:1;
    vuint32_t _unused_21:3;
    vuint32_t LOCKESW:1;
    vuint32_t WDTOSW:1;
    vuint32_t CRCSSW:1;
    vuint32_t ENGESW:1;
    vuint32_t INVPSW:1;
    vuint32_t _unused_10:6;
    vuint32_t UFSF:1;
    vuint32_t RFSF:1;
    vuint32_t _unused_5:3;
    vuint32_t LOCKE:1;
    vuint32_t WDTO:1;
    vuint32_t CRCS:1;
    vuint32_t ENGE:1;
    vuint32_t INVP:1;
  } B;
} STCU2_ERR_STAT_tag;

typedef union STCU2_ERR_FM_union_tag { /* STCU2 Error FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_5:27;
    vuint32_t LOCKEUFM:1;
    vuint32_t WDTOUFM:1;
    vuint32_t CRCSUFM:1;
    vuint32_t ENGEUFM:1;
    vuint32_t INVPUFM:1;
  } B;
} STCU2_ERR_FM_tag;

typedef union STCU2_LBS_union_tag {    /* STCU2 Off-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBS7:1;
    vuint32_t LBS6:1;
    vuint32_t LBS5:1;
    vuint32_t LBS4:1;
    vuint32_t LBS3:1;
    vuint32_t LBS2:1;
    vuint32_t LBS1:1;
    vuint32_t LBS0:1;
  } B;
} STCU2_LBS_tag;

typedef union STCU2_LBE_union_tag {    /* STCU2 Off-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBE7:1;
    vuint32_t LBE6:1;
    vuint32_t LBE5:1;
    vuint32_t LBE4:1;
    vuint32_t LBE3:1;
    vuint32_t LBE2:1;
    vuint32_t LBE1:1;
    vuint32_t LBE0:1;
  } B;
} STCU2_LBE_tag;

typedef union STCU2_LBSSW_union_tag {  /* STCU2 On-Line LBIST Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBSSW7:1;
    vuint32_t LBSSW6:1;
    vuint32_t LBSSW5:1;
    vuint32_t LBSSW4:1;
    vuint32_t LBSSW3:1;
    vuint32_t LBSSW2:1;
    vuint32_t LBSSW1:1;
    vuint32_t LBSSW0:1;
  } B;
} STCU2_LBSSW_tag;

typedef union STCU2_LBESW_union_tag {  /* STCU2 On-Line LBIST End Flag Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBESW7:1;
    vuint32_t LBESW6:1;
    vuint32_t LBESW5:1;
    vuint32_t LBESW4:1;
    vuint32_t LBESW3:1;
    vuint32_t LBESW2:1;
    vuint32_t LBESW1:1;
    vuint32_t LBESW0:1;
  } B;
} STCU2_LBESW_tag;

typedef union STCU2_LBRMSW_union_tag { /* STCU2 On-Line LBIST Reset Management */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBRMSW7:1;
    vuint32_t LBRMSW6:1;
    vuint32_t LBRMSW5:1;
    vuint32_t LBRMSW4:1;
    vuint32_t LBRMSW3:1;
    vuint32_t LBRMSW2:1;
    vuint32_t LBRMSW1:1;
    vuint32_t LBRMSW0:1;
  } B;
} STCU2_LBRMSW_tag;

typedef union STCU2_LBUFM_union_tag {  /* STCU2 LBIST Unrecoverable FM Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_8:24;
    vuint32_t LBUFM7:1;
    vuint32_t LBUFM6:1;
    vuint32_t LBUFM5:1;
    vuint32_t LBUFM4:1;
    vuint32_t LBUFM3:1;
    vuint32_t LBUFM2:1;
    vuint32_t LBUFM1:1;
    vuint32_t LBUFM0:1;
  } B;
} STCU2_LBUFM_tag;

typedef union STCU2_MBSL_union_tag {   /* STCU2 Off-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBS31:1;
    vuint32_t MBS30:1;
    vuint32_t MBS29:1;
    vuint32_t MBS28:1;
    vuint32_t MBS27:1;
    vuint32_t MBS26:1;
    vuint32_t MBS25:1;
    vuint32_t MBS24:1;
    vuint32_t MBS23:1;
    vuint32_t MBS22:1;
    vuint32_t MBS21:1;
    vuint32_t MBS20:1;
    vuint32_t MBS19:1;
    vuint32_t MBS18:1;
    vuint32_t MBS17:1;
    vuint32_t MBS16:1;
    vuint32_t MBS15:1;
    vuint32_t MBS14:1;
    vuint32_t MBS13:1;
    vuint32_t MBS12:1;
    vuint32_t MBS11:1;
    vuint32_t MBS10:1;
    vuint32_t MBS9:1;
    vuint32_t MBS8:1;
    vuint32_t MBS7:1;
    vuint32_t MBS6:1;
    vuint32_t MBS5:1;
    vuint32_t MBS4:1;
    vuint32_t MBS3:1;
    vuint32_t MBS2:1;
    vuint32_t MBS1:1;
    vuint32_t MBS0:1;
  } B;
} STCU2_MBSL_tag;

typedef union STCU2_MBSM_union_tag {   /* STCU2 Off-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBS63:1;
    vuint32_t MBS62:1;
    vuint32_t MBS61:1;
    vuint32_t MBS60:1;
    vuint32_t MBS59:1;
    vuint32_t MBS58:1;
    vuint32_t MBS57:1;
    vuint32_t MBS56:1;
    vuint32_t MBS55:1;
    vuint32_t MBS54:1;
    vuint32_t MBS53:1;
    vuint32_t MBS52:1;
    vuint32_t MBS51:1;
    vuint32_t MBS50:1;
    vuint32_t MBS49:1;
    vuint32_t MBS48:1;
    vuint32_t MBS47:1;
    vuint32_t MBS46:1;
    vuint32_t MBS45:1;
    vuint32_t MBS44:1;
    vuint32_t MBS43:1;
    vuint32_t MBS42:1;
    vuint32_t MBS41:1;
    vuint32_t MBS40:1;
    vuint32_t MBS39:1;
    vuint32_t MBS38:1;
    vuint32_t MBS37:1;
    vuint32_t MBS36:1;
    vuint32_t MBS35:1;
    vuint32_t MBS34:1;
    vuint32_t MBS33:1;
    vuint32_t MBS32:1;
  } B;
} STCU2_MBSM_tag;

typedef union STCU2_MBSH_union_tag {   /* STCU2 Off-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MBS91:1;
    vuint32_t MBS90:1;
    vuint32_t MBS89:1;
    vuint32_t MBS88:1;
    vuint32_t MBS87:1;
    vuint32_t MBS86:1;
    vuint32_t MBS85:1;
    vuint32_t MBS84:1;
    vuint32_t MBS83:1;
    vuint32_t MBS82:1;
    vuint32_t MBS81:1;
    vuint32_t MBS80:1;
    vuint32_t MBS79:1;
    vuint32_t MBS78:1;
    vuint32_t MBS77:1;
    vuint32_t MBS76:1;
    vuint32_t MBS75:1;
    vuint32_t MBS74:1;
    vuint32_t MBS73:1;
    vuint32_t MBS72:1;
    vuint32_t MBS71:1;
    vuint32_t MBS70:1;
    vuint32_t MBS69:1;
    vuint32_t MBS68:1;
    vuint32_t MBS67:1;
    vuint32_t MBS66:1;
    vuint32_t MBS65:1;
    vuint32_t MBS64:1;
  } B;
} STCU2_MBSH_tag;

typedef union STCU2_MBEL_union_tag {   /* STCU2 Off-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBE31:1;
    vuint32_t MBE30:1;
    vuint32_t MBE29:1;
    vuint32_t MBE28:1;
    vuint32_t MBE27:1;
    vuint32_t MBE26:1;
    vuint32_t MBE25:1;
    vuint32_t MBE24:1;
    vuint32_t MBE23:1;
    vuint32_t MBE22:1;
    vuint32_t MBE21:1;
    vuint32_t MBE20:1;
    vuint32_t MBE19:1;
    vuint32_t MBE18:1;
    vuint32_t MBE17:1;
    vuint32_t MBE16:1;
    vuint32_t MBE15:1;
    vuint32_t MBE14:1;
    vuint32_t MBE13:1;
    vuint32_t MBE12:1;
    vuint32_t MBE11:1;
    vuint32_t MBE10:1;
    vuint32_t MBE9:1;
    vuint32_t MBE8:1;
    vuint32_t MBE7:1;
    vuint32_t MBE6:1;
    vuint32_t MBE5:1;
    vuint32_t MBE4:1;
    vuint32_t MBE3:1;
    vuint32_t MBE2:1;
    vuint32_t MBE1:1;
    vuint32_t MBE0:1;
  } B;
} STCU2_MBEL_tag;

typedef union STCU2_MBEM_union_tag {   /* STCU2 Off-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBE63:1;
    vuint32_t MBE62:1;
    vuint32_t MBE61:1;
    vuint32_t MBE60:1;
    vuint32_t MBE59:1;
    vuint32_t MBE58:1;
    vuint32_t MBE57:1;
    vuint32_t MBE56:1;
    vuint32_t MBE55:1;
    vuint32_t MBE54:1;
    vuint32_t MBE53:1;
    vuint32_t MBE52:1;
    vuint32_t MBE51:1;
    vuint32_t MBE50:1;
    vuint32_t MBE49:1;
    vuint32_t MBE48:1;
    vuint32_t MBE47:1;
    vuint32_t MBE46:1;
    vuint32_t MBE45:1;
    vuint32_t MBE44:1;
    vuint32_t MBE43:1;
    vuint32_t MBE42:1;
    vuint32_t MBE41:1;
    vuint32_t MBE40:1;
    vuint32_t MBE39:1;
    vuint32_t MBE38:1;
    vuint32_t MBE37:1;
    vuint32_t MBE36:1;
    vuint32_t MBE35:1;
    vuint32_t MBE34:1;
    vuint32_t MBE33:1;
    vuint32_t MBE32:1;
  } B;
} STCU2_MBEM_tag;

typedef union STCU2_MBEH_union_tag {   /* STCU2 Off-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MBE91:1;
    vuint32_t MBE90:1;
    vuint32_t MBE89:1;
    vuint32_t MBE88:1;
    vuint32_t MBE87:1;
    vuint32_t MBE86:1;
    vuint32_t MBE85:1;
    vuint32_t MBE84:1;
    vuint32_t MBE83:1;
    vuint32_t MBE82:1;
    vuint32_t MBE81:1;
    vuint32_t MBE80:1;
    vuint32_t MBE79:1;
    vuint32_t MBE78:1;
    vuint32_t MBE77:1;
    vuint32_t MBE76:1;
    vuint32_t MBE75:1;
    vuint32_t MBE74:1;
    vuint32_t MBE73:1;
    vuint32_t MBE72:1;
    vuint32_t MBE71:1;
    vuint32_t MBE70:1;
    vuint32_t MBE69:1;
    vuint32_t MBE68:1;
    vuint32_t MBE67:1;
    vuint32_t MBE66:1;
    vuint32_t MBE65:1;
    vuint32_t MBE64:1;
  } B;
} STCU2_MBEH_tag;

typedef union STCU2_MBSLSW_union_tag { /* STCU2 On-Line MBIST Status Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW31:1;
    vuint32_t MBSSW30:1;
    vuint32_t MBSSW29:1;
    vuint32_t MBSSW28:1;
    vuint32_t MBSSW27:1;
    vuint32_t MBSSW26:1;
    vuint32_t MBSSW25:1;
    vuint32_t MBSSW24:1;
    vuint32_t MBSSW23:1;
    vuint32_t MBSSW22:1;
    vuint32_t MBSSW21:1;
    vuint32_t MBSSW20:1;
    vuint32_t MBSSW19:1;
    vuint32_t MBSSW18:1;
    vuint32_t MBSSW17:1;
    vuint32_t MBSSW16:1;
    vuint32_t MBSSW15:1;
    vuint32_t MBSSW14:1;
    vuint32_t MBSSW13:1;
    vuint32_t MBSSW12:1;
    vuint32_t MBSSW11:1;
    vuint32_t MBSSW10:1;
    vuint32_t MBSSW9:1;
    vuint32_t MBSSW8:1;
    vuint32_t MBSSW7:1;
    vuint32_t MBSSW6:1;
    vuint32_t MBSSW5:1;
    vuint32_t MBSSW4:1;
    vuint32_t MBSSW3:1;
    vuint32_t MBSSW2:1;
    vuint32_t MBSSW1:1;
    vuint32_t MBSSW0:1;
  } B;
} STCU2_MBSLSW_tag;

typedef union STCU2_MBSMSW_union_tag { /* STCU2 On-Line MBIST Status Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBSSW63:1;
    vuint32_t MBSSW62:1;
    vuint32_t MBSSW61:1;
    vuint32_t MBSSW60:1;
    vuint32_t MBSSW59:1;
    vuint32_t MBSSW58:1;
    vuint32_t MBSSW57:1;
    vuint32_t MBSSW56:1;
    vuint32_t MBSSW55:1;
    vuint32_t MBSSW54:1;
    vuint32_t MBSSW53:1;
    vuint32_t MBSSW52:1;
    vuint32_t MBSSW51:1;
    vuint32_t MBSSW50:1;
    vuint32_t MBSSW49:1;
    vuint32_t MBSSW48:1;
    vuint32_t MBSSW47:1;
    vuint32_t MBSSW46:1;
    vuint32_t MBSSW45:1;
    vuint32_t MBSSW44:1;
    vuint32_t MBSSW43:1;
    vuint32_t MBSSW42:1;
    vuint32_t MBSSW41:1;
    vuint32_t MBSSW40:1;
    vuint32_t MBSSW39:1;
    vuint32_t MBSSW38:1;
    vuint32_t MBSSW37:1;
    vuint32_t MBSSW36:1;
    vuint32_t MBSSW35:1;
    vuint32_t MBSSW34:1;
    vuint32_t MBSSW33:1;
    vuint32_t MBSSW32:1;
  } B;
} STCU2_MBSMSW_tag;

typedef union STCU2_MBSHSW_union_tag { /* STCU2 On-Line MBIST Status High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MBSSW91:1;
    vuint32_t MBSSW90:1;
    vuint32_t MBSSW89:1;
    vuint32_t MBSSW88:1;
    vuint32_t MBSSW87:1;
    vuint32_t MBSSW86:1;
    vuint32_t MBSSW85:1;
    vuint32_t MBSSW84:1;
    vuint32_t MBSSW83:1;
    vuint32_t MBSSW82:1;
    vuint32_t MBSSW81:1;
    vuint32_t MBSSW80:1;
    vuint32_t MBSSW79:1;
    vuint32_t MBSSW78:1;
    vuint32_t MBSSW77:1;
    vuint32_t MBSSW76:1;
    vuint32_t MBSSW75:1;
    vuint32_t MBSSW74:1;
    vuint32_t MBSSW73:1;
    vuint32_t MBSSW72:1;
    vuint32_t MBSSW71:1;
    vuint32_t MBSSW70:1;
    vuint32_t MBSSW69:1;
    vuint32_t MBSSW68:1;
    vuint32_t MBSSW67:1;
    vuint32_t MBSSW66:1;
    vuint32_t MBSSW65:1;
    vuint32_t MBSSW64:1;
  } B;
} STCU2_MBSHSW_tag;

typedef union STCU2_MBELSW_union_tag { /* STCU2 On-Line MBIST End Flag Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW31:1;
    vuint32_t MBESW30:1;
    vuint32_t MBESW29:1;
    vuint32_t MBESW28:1;
    vuint32_t MBESW27:1;
    vuint32_t MBESW26:1;
    vuint32_t MBESW25:1;
    vuint32_t MBESW24:1;
    vuint32_t MBESW23:1;
    vuint32_t MBESW22:1;
    vuint32_t MBESW21:1;
    vuint32_t MBESW20:1;
    vuint32_t MBESW19:1;
    vuint32_t MBESW18:1;
    vuint32_t MBESW17:1;
    vuint32_t MBESW16:1;
    vuint32_t MBESW15:1;
    vuint32_t MBESW14:1;
    vuint32_t MBESW13:1;
    vuint32_t MBESW12:1;
    vuint32_t MBESW11:1;
    vuint32_t MBESW10:1;
    vuint32_t MBESW9:1;
    vuint32_t MBESW8:1;
    vuint32_t MBESW7:1;
    vuint32_t MBESW6:1;
    vuint32_t MBESW5:1;
    vuint32_t MBESW4:1;
    vuint32_t MBESW3:1;
    vuint32_t MBESW2:1;
    vuint32_t MBESW1:1;
    vuint32_t MBESW0:1;
  } B;
} STCU2_MBELSW_tag;

typedef union STCU2_MBEMSW_union_tag { /* STCU2 On-Line MBIST End Flag Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBESW63:1;
    vuint32_t MBESW62:1;
    vuint32_t MBESW61:1;
    vuint32_t MBESW60:1;
    vuint32_t MBESW59:1;
    vuint32_t MBESW58:1;
    vuint32_t MBESW57:1;
    vuint32_t MBESW56:1;
    vuint32_t MBESW55:1;
    vuint32_t MBESW54:1;
    vuint32_t MBESW53:1;
    vuint32_t MBESW52:1;
    vuint32_t MBESW51:1;
    vuint32_t MBESW50:1;
    vuint32_t MBESW49:1;
    vuint32_t MBESW48:1;
    vuint32_t MBESW47:1;
    vuint32_t MBESW46:1;
    vuint32_t MBESW45:1;
    vuint32_t MBESW44:1;
    vuint32_t MBESW43:1;
    vuint32_t MBESW42:1;
    vuint32_t MBESW41:1;
    vuint32_t MBESW40:1;
    vuint32_t MBESW39:1;
    vuint32_t MBESW38:1;
    vuint32_t MBESW37:1;
    vuint32_t MBESW36:1;
    vuint32_t MBESW35:1;
    vuint32_t MBESW34:1;
    vuint32_t MBESW33:1;
    vuint32_t MBESW32:1;
  } B;
} STCU2_MBEMSW_tag;

typedef union STCU2_MBEHSW_union_tag { /* STCU2 On-Line MBIST End Flag High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MBESW91:1;
    vuint32_t MBESW90:1;
    vuint32_t MBESW89:1;
    vuint32_t MBESW88:1;
    vuint32_t MBESW87:1;
    vuint32_t MBESW86:1;
    vuint32_t MBESW85:1;
    vuint32_t MBESW84:1;
    vuint32_t MBESW83:1;
    vuint32_t MBESW82:1;
    vuint32_t MBESW81:1;
    vuint32_t MBESW80:1;
    vuint32_t MBESW79:1;
    vuint32_t MBESW78:1;
    vuint32_t MBESW77:1;
    vuint32_t MBESW76:1;
    vuint32_t MBESW75:1;
    vuint32_t MBESW74:1;
    vuint32_t MBESW73:1;
    vuint32_t MBESW72:1;
    vuint32_t MBESW71:1;
    vuint32_t MBESW70:1;
    vuint32_t MBESW69:1;
    vuint32_t MBESW68:1;
    vuint32_t MBESW67:1;
    vuint32_t MBESW66:1;
    vuint32_t MBESW65:1;
    vuint32_t MBESW64:1;
  } B;
} STCU2_MBEHSW_tag;

typedef union STCU2_MBUFML_union_tag { /* STCU2 MBIST Unrecoverable FM Low Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM31:1;
    vuint32_t MBUFM30:1;
    vuint32_t MBUFM29:1;
    vuint32_t MBUFM28:1;
    vuint32_t MBUFM27:1;
    vuint32_t MBUFM26:1;
    vuint32_t MBUFM25:1;
    vuint32_t MBUFM24:1;
    vuint32_t MBUFM23:1;
    vuint32_t MBUFM22:1;
    vuint32_t MBUFM21:1;
    vuint32_t MBUFM20:1;
    vuint32_t MBUFM19:1;
    vuint32_t MBUFM18:1;
    vuint32_t MBUFM17:1;
    vuint32_t MBUFM16:1;
    vuint32_t MBUFM15:1;
    vuint32_t MBUFM14:1;
    vuint32_t MBUFM13:1;
    vuint32_t MBUFM12:1;
    vuint32_t MBUFM11:1;
    vuint32_t MBUFM10:1;
    vuint32_t MBUFM9:1;
    vuint32_t MBUFM8:1;
    vuint32_t MBUFM7:1;
    vuint32_t MBUFM6:1;
    vuint32_t MBUFM5:1;
    vuint32_t MBUFM4:1;
    vuint32_t MBUFM3:1;
    vuint32_t MBUFM2:1;
    vuint32_t MBUFM1:1;
    vuint32_t MBUFM0:1;
  } B;
} STCU2_MBUFML_tag;

typedef union STCU2_MBUFMM_union_tag { /* STCU2 MBIST Unrecoverable FM Medium Register */
  vuint32_t R;
  struct {
    vuint32_t MBUFM63:1;
    vuint32_t MBUFM62:1;
    vuint32_t MBUFM61:1;
    vuint32_t MBUFM60:1;
    vuint32_t MBUFM59:1;
    vuint32_t MBUFM58:1;
    vuint32_t MBUFM57:1;
    vuint32_t MBUFM56:1;
    vuint32_t MBUFM55:1;
    vuint32_t MBUFM54:1;
    vuint32_t MBUFM53:1;
    vuint32_t MBUFM52:1;
    vuint32_t MBUFM51:1;
    vuint32_t MBUFM50:1;
    vuint32_t MBUFM49:1;
    vuint32_t MBUFM48:1;
    vuint32_t MBUFM47:1;
    vuint32_t MBUFM46:1;
    vuint32_t MBUFM45:1;
    vuint32_t MBUFM44:1;
    vuint32_t MBUFM43:1;
    vuint32_t MBUFM42:1;
    vuint32_t MBUFM41:1;
    vuint32_t MBUFM40:1;
    vuint32_t MBUFM39:1;
    vuint32_t MBUFM38:1;
    vuint32_t MBUFM37:1;
    vuint32_t MBUFM36:1;
    vuint32_t MBUFM35:1;
    vuint32_t MBUFM34:1;
    vuint32_t MBUFM33:1;
    vuint32_t MBUFM32:1;
  } B;
} STCU2_MBUFMM_tag;

typedef union STCU2_MBUFMH_union_tag { /* STCU2 MBIST Unrecoverable FM High Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_28:4;
    vuint32_t MBUFM91:1;
    vuint32_t MBUFM90:1;
    vuint32_t MBUFM89:1;
    vuint32_t MBUFM88:1;
    vuint32_t MBUFM87:1;
    vuint32_t MBUFM86:1;
    vuint32_t MBUFM85:1;
    vuint32_t MBUFM84:1;
    vuint32_t MBUFM83:1;
    vuint32_t MBUFM82:1;
    vuint32_t MBUFM81:1;
    vuint32_t MBUFM80:1;
    vuint32_t MBUFM79:1;
    vuint32_t MBUFM78:1;
    vuint32_t MBUFM77:1;
    vuint32_t MBUFM76:1;
    vuint32_t MBUFM75:1;
    vuint32_t MBUFM74:1;
    vuint32_t MBUFM73:1;
    vuint32_t MBUFM72:1;
    vuint32_t MBUFM71:1;
    vuint32_t MBUFM70:1;
    vuint32_t MBUFM69:1;
    vuint32_t MBUFM68:1;
    vuint32_t MBUFM67:1;
    vuint32_t MBUFM66:1;
    vuint32_t MBUFM65:1;
    vuint32_t MBUFM64:1;
  } B;
} STCU2_MBUFMH_tag;

typedef union STCU2_LB_CTRL_union_tag { /* STCU2 LBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_20:4;
    vuint32_t PRPGEN:1;
    vuint32_t SHS:3;
    vuint32_t SCEN_OFF:4;
    vuint32_t SCEN_ON:4;
    vuint32_t _unused_7:1;
    vuint32_t PFT:1;
    vuint32_t CWS:6;
  } B;
} STCU2_LB_CTRL_tag;

typedef union STCU2_LB_PCS_union_tag { /* STCU2 LBIST PC Stop Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t PCS:26;
  } B;
} STCU2_LB_PCS_tag;

typedef union STCU2_LB_PRPGL_union_tag { /* STCU2 LBIST PRPG Low Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_PRPGL_tag;

typedef union STCU2_LB_PRPGH_union_tag { /* STCU2 LBIST PRPG High Register */
  vuint32_t R;
  struct {
    vuint32_t PRPGx:32;
  } B;
} STCU2_LB_PRPGH_tag;

typedef union STCU2_LB_MISREL_union_tag { /* STCU2 Off-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREL_tag;

typedef union STCU2_LB_MISREH_union_tag { /* STCU2 Off-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISREx:32;
  } B;
} STCU2_LB_MISREH_tag;

typedef union STCU2_LB_MISRRL_union_tag { /* STCU2 Off-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRL_tag;

typedef union STCU2_LB_MISRRH_union_tag { /* STCU2 Off-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRx:32;
  } B;
} STCU2_LB_MISRRH_tag;

typedef union STCU2_LB_MISRELSW_union_tag { /* STCU2 On-Line LBIST MISR Expected Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISRELSW_tag;

typedef union STCU2_LB_MISREHSW_union_tag { /* STCU2 On-Line LBIST MISR Expected High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRESWx:32;
  } B;
} STCU2_LB_MISREHSW_tag;

typedef union STCU2_LB_MISRRLSW_union_tag { /* STCU2 On-Line LBIST MISR Read Low Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRLSW_tag;

typedef union STCU2_LB_MISRRHSW_union_tag { /* STCU2 On-Line LBIST MISR Read High Register */
  vuint32_t R;
  struct {
    vuint32_t MISRRSWx:32;
  } B;
} STCU2_LB_MISRRHSW_tag;

typedef struct STCU2_LB_struct_tag {
  STCU2_LB_CTRL_tag CTRL;              /* STCU2 LBIST Control Register */
  STCU2_LB_PCS_tag PCS;                /* STCU2 LBIST PC Stop Register */
  STCU2_LB_PRPGL_tag PRPGL;            /* STCU2 LBIST PRPG Low Register */
  STCU2_LB_PRPGH_tag PRPGH;            /* STCU2 LBIST PRPG High Register */
  STCU2_LB_MISREL_tag MISREL;          /* STCU2 Off-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREH_tag MISREH;          /* STCU2 Off-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRL_tag MISRRL;          /* STCU2 Off-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRH_tag MISRRH;          /* STCU2 Off-Line LBIST MISR Read High Register */
  STCU2_LB_MISRELSW_tag MISRELSW;      /* STCU2 On-Line LBIST MISR Expected Low Register */
  STCU2_LB_MISREHSW_tag MISREHSW;      /* STCU2 On-Line LBIST MISR Expected High Register */
  STCU2_LB_MISRRLSW_tag MISRRLSW;      /* STCU2 On-Line LBIST MISR Read Low Register */
  STCU2_LB_MISRRHSW_tag MISRRHSW;      /* STCU2 On-Line LBIST MISR Read High Register */
  uint8_t LB_reserved0[16];
} STCU2_LB_tag;

typedef union STCU2_MB_CTRL_union_tag { /* STCU2 MBIST Control Register */
  vuint32_t R;
  struct {
    vuint32_t CSM:1;
    vuint32_t PTR:7;
    vuint32_t _unused_0:24;
  } B;
} STCU2_MB_CTRL_tag;

struct STCU2_tag {
  STCU2_RUN_tag RUN;                   /* STCU2 Run Register */
  STCU2_RUNSW_tag RUNSW;               /* STCU2 Run Software Register */
  STCU2_SKC_tag SKC;                   /* STCU2 SK Code Register */
  STCU2_CFG_tag CFG;                   /* STCU2 Configuration Register */
  STCU2_PLL_CFG_tag PLL_CFG;           /* STCU2 PLL Configuration Register */
  STCU2_WDG_tag WDG;                   /* STCU2 Watchdog Register Granularity */
  uint8_t STCU2_reserved0[4];
  STCU2_CRCE_tag CRCE;                 /* STCU2 CRC Expected Status Register */
  STCU2_CRCR_tag CRCR;                 /* STCU2 CRC Read Status Register */
  STCU2_ERR_STAT_tag ERR_STAT;         /* STCU2 Error Register */
  STCU2_ERR_FM_tag ERR_FM;             /* STCU2 Error FM Register */
  STCU2_LBS_tag LBS;                   /* STCU2 Off-Line LBIST Status Register */
  STCU2_LBE_tag LBE;                   /* STCU2 Off-Line LBIST End Flag Register */
  STCU2_LBSSW_tag LBSSW;               /* STCU2 On-Line LBIST Status Register */
  STCU2_LBESW_tag LBESW;               /* STCU2 On-Line LBIST End Flag Register */
  STCU2_LBRMSW_tag LBRMSW;             /* STCU2 On-Line LBIST Reset Management */
  STCU2_LBUFM_tag LBUFM;               /* STCU2 LBIST Unrecoverable FM Register */
  STCU2_MBSL_tag MBSL;                 /* STCU2 Off-Line MBIST Status Low Register */
  STCU2_MBSM_tag MBSM;                 /* STCU2 Off-Line MBIST Status Medium Register */
  STCU2_MBSH_tag MBSH;                 /* STCU2 Off-Line MBIST Status High Register */
  STCU2_MBEL_tag MBEL;                 /* STCU2 Off-Line MBIST End Flag Low Register */
  STCU2_MBEM_tag MBEM;                 /* STCU2 Off-Line MBIST End Flag Medium Register */
  STCU2_MBEH_tag MBEH;                 /* STCU2 Off-Line MBIST End Flag High Register */
  STCU2_MBSLSW_tag MBSLSW;             /* STCU2 On-Line MBIST Status Low Register */
  STCU2_MBSMSW_tag MBSMSW;             /* STCU2 On-Line MBIST Status Medium Register */
  STCU2_MBSHSW_tag MBSHSW;             /* STCU2 On-Line MBIST Status High Register */
  STCU2_MBELSW_tag MBELSW;             /* STCU2 On-Line MBIST End Flag Low Register */
  STCU2_MBEMSW_tag MBEMSW;             /* STCU2 On-Line MBIST End Flag Medium Register */
  STCU2_MBEHSW_tag MBEHSW;             /* STCU2 On-Line MBIST End Flag High Register */
  STCU2_MBUFML_tag MBUFML;             /* STCU2 MBIST Unrecoverable FM Low Register */
  STCU2_MBUFMM_tag MBUFMM;             /* STCU2 MBIST Unrecoverable FM Medium Register */
  STCU2_MBUFMH_tag MBUFMH;             /* STCU2 MBIST Unrecoverable FM High Register */
  uint8_t STCU2_reserved1[128];
  STCU2_LB_tag LB[8];
  uint8_t STCU2_reserved2[768];
  STCU2_MB_CTRL_tag MB_CTRL[92];       /* STCU2 MBIST Control Register */
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

typedef union STM_CR_union_tag {       /* STM Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t CPS:8;                   /* Counter Prescaler. */
    vuint32_t _unused_2:6;
    vuint32_t FRZ:1;                   /* Freeze. */
    vuint32_t TEN:1;                   /* Timer counter Enabled. */
  } B;
} STM_CR_tag;

typedef union STM_CNT_union_tag {      /* STM Count Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;                  /* Timer count value used as the time base for all channels. */
  } B;
} STM_CNT_tag;

typedef union STM_CHANNEL_CCR_union_tag { /* STM Channel Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CEN:1;                   /* Channel Enable */
  } B;
} STM_CHANNEL_CCR_tag;

typedef union STM_CHANNEL_CIR_union_tag { /* STM Channel Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CIF:1;                   /* Channel Interrupt Flag */
  } B;
} STM_CHANNEL_CIR_tag;

typedef union STM_CHANNEL_CMP_union_tag { /* STM Channel Compare Register */
  vuint32_t R;
  struct {
    vuint32_t CMP:32;                  /* Compare value for channel n. */
  } B;
} STM_CHANNEL_CMP_tag;

typedef struct STM_CHANNEL_struct_tag {
  STM_CHANNEL_CCR_tag CCR;             /* STM Channel Control Register */
  STM_CHANNEL_CIR_tag CIR;             /* STM Channel Interrupt Register */
  STM_CHANNEL_CMP_tag CMP;             /* STM Channel Compare Register */
  uint8_t CHANNEL_reserved0[4];
} STM_CHANNEL_tag;

struct STM_tag {
  STM_CR_tag CR;                       /* STM Control Register */
  STM_CNT_tag CNT;                     /* STM Count Register */
  uint8_t STM_reserved0[8];
  STM_CHANNEL_tag CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

typedef union SWT_CR_union_tag {       /* SWT Control Register */
  vuint32_t R;
  struct {
    vuint32_t MAP0:1;
    vuint32_t MAP1:1;
    vuint32_t MAP2:1;
    vuint32_t MAP3:1;
    vuint32_t MAP4:1;
    vuint32_t MAP5:1;
    vuint32_t MAP6:1;
    vuint32_t MAP7:1;
    vuint32_t _unused_11:13;
    vuint32_t SMD:2;                   /* Service Mode. */
    vuint32_t RIA:1;
    vuint32_t WND:1;
    vuint32_t ITR:1;
    vuint32_t HLK:1;
    vuint32_t SLK:1;
    vuint32_t _unused_3:1;             /* Reserved */
    vuint32_t STP:1;
    vuint32_t FRZ:1;
    vuint32_t WEN:1;
  } B;
} SWT_CR_tag;

typedef union SWT_IR_union_tag {       /* SWT Interrupt Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t TIF:1;                   /* Time-out Interrupt Flag */
  } B;
} SWT_IR_tag;

typedef union SWT_TO_union_tag {       /* SWT Time-out Register */
  vuint32_t R;
  struct {
    vuint32_t WTO:32;
  } B;
} SWT_TO_tag;

typedef union SWT_WN_union_tag {       /* SWT Window Register */
  vuint32_t R;
  struct {
    vuint32_t WST:32;                  /* Window Start Value */
  } B;
} SWT_WN_tag;

typedef union SWT_SR_union_tag {       /* SWT Service Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t WSC:16;                  /* Watchdog Service Code */
  } B;
} SWT_SR_tag;

typedef union SWT_CO_union_tag {       /* SWT Counter Output Register */
  vuint32_t R;
  struct {
    vuint32_t CNT:32;
  } B;
} SWT_CO_tag;

typedef union SWT_SK_union_tag {       /* SWT Service Key Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_16:16;
    vuint32_t SK:16;                   /* Service Key */
  } B;
} SWT_SK_tag;

struct SWT_tag {
  SWT_CR_tag CR;                       /* SWT Control Register */
  SWT_IR_tag IR;                       /* SWT Interrupt Register */
  SWT_TO_tag TO;                       /* SWT Time-out Register */
  SWT_WN_tag WN;                       /* SWT Window Register */
  SWT_SR_tag SR;                       /* SWT Service Register */
  SWT_CO_tag CO;                       /* SWT Counter Output Register */
  SWT_SK_tag SK;                       /* SWT Service Key Register */
};


/* ============================================================================
   =============================== Module: WGM ================================
   ============================================================================ */

typedef union WGM_CTRL_union_tag {     /* WGM Control Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_26:6;
    vuint32_t SWAP_EN:1;               /* SWAP Enable */
    vuint32_t CLENR_MD:1;              /* CLENR Mode */
    vuint32_t CKSUM_MD:1;              /* Checksum Calculation Mode */
    vuint32_t CS_RST:1;                /* Checksum Reset */
    vuint32_t _unused_19:3;
    vuint32_t CSTEP:11;                /* Counter Step */
    vuint32_t CLENR:6;                 /* Counter LENR */
    vuint32_t AD_C_RST:1;              /* Address Counter Reset */
    vuint32_t _unused_0:1;
  } B;
} WGM_CTRL_tag;

typedef union WGM_CTRL_1_union_tag {   /* WGM Control Register 1 */
  vuint32_t R;
  struct {
    vuint32_t _unused_23:9;
    vuint32_t WG_HLD_S:1;              /* WG_HLD Synchronous/Asynchronous */
    vuint32_t _unused_21:1;
    vuint32_t WGM_MODE:1;              /* WGM mode */
    vuint32_t WGM_EN:1;                /* WGM Enable */
    vuint32_t VALD_CNT:11;             /* Valid Entry Counter */
    vuint32_t EDMA_CTL:2;              /* eDMA trigger control */
    vuint32_t _unused_5:1;
    vuint32_t _unused_4:1;
    vuint32_t _unused_3:1;
    vuint32_t _unused_2:1;
    vuint32_t _unused_1:1;
    vuint32_t WGM_RST:1;               /* WGM Reset */
  } B;
} WGM_CTRL_1_tag;

typedef union WGM_CVAL_union_tag {     /* CVAL Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t CVAL:11;                 /* Counter Value */
  } B;
} WGM_CVAL_tag;

typedef union WGM_FADR_union_tag {     /* Fixed Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_11:21;
    vuint32_t FADR_VAL:11;             /* Fixed Address */
  } B;
} WGM_FADR_tag;

typedef union WGM_LUT_ADDR_union_tag { /* LUT Address Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_13:19;
    vuint32_t ADDR:13;                 /* LUT address value */
  } B;
} WGM_LUT_ADDR_tag;

typedef union WGM_LUT_DATA_union_tag { /* LUT Data Register */
  vuint32_t R;
  struct {
    vuint32_t DAC_VAL:32;              /* DAC value for LUT */
  } B;
} WGM_LUT_DATA_tag;

typedef union WGM_INT_EN_union_tag {   /* WGM Interrupt Enable Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t L_END_EN:1;              /* LUT end enable */
    vuint32_t L_STR_EN:1;              /* LUT start enable */
  } B;
} WGM_INT_EN_tag;

typedef union WGM_INT_STAT_union_tag { /* WGM Interrupt Status Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_2:30;
    vuint32_t L_END_ST:1;              /* LUT end */
    vuint32_t L_STR_ST:1;              /* LUT start */
  } B;
} WGM_INT_STAT_tag;

typedef union WGM_LUT_CKSM_union_tag { /* LUT Checksum Register */
  vuint32_t R;
  struct {
    vuint32_t CKSUM:32;                /* Checksum */
  } B;
} WGM_LUT_CKSM_tag;

typedef union WGM_DEBUG_union_tag {    /* Debug Register */
  vuint32_t R;
  struct {
    vuint32_t _unused_1:31;
    vuint32_t CONT_ERR:1;              /* LUT contention error */
  } B;
} WGM_DEBUG_tag;

struct WGM_tag {
  WGM_CTRL_tag CTRL;                   /* WGM Control Register */
  WGM_CTRL_1_tag CTRL_1;               /* WGM Control Register 1 */
  WGM_CVAL_tag CVAL;                   /* CVAL Register */
  WGM_FADR_tag FADR;                   /* Fixed Address Register */
  WGM_LUT_ADDR_tag LUT_ADDR;           /* LUT Address Register */
  WGM_LUT_DATA_tag LUT_DATA;           /* LUT Data Register */
  uint8_t WGM_reserved0[8];
  WGM_INT_EN_tag INT_EN;               /* WGM Interrupt Enable Register */
  WGM_INT_STAT_tag INT_STAT;           /* WGM Interrupt Status Register */
  WGM_LUT_CKSM_tag LUT_CKSM;           /* LUT Checksum Register */
  WGM_DEBUG_tag DEBUG;                 /* Debug Register */
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

typedef union WKPU_NSR_union_tag {     /* NMI Status Flag Register */
  vuint32_t R;
  struct {
    vuint32_t NIF0:1;
    vuint32_t NOVF0:1;
    vuint32_t _unused_24:6;
    vuint32_t NIF1:1;
    vuint32_t NOVF1:1;
    vuint32_t _unused_16:6;
    vuint32_t NIF2:1;
    vuint32_t NOVF2:1;
    vuint32_t _unused_8:6;
    vuint32_t _unused_6:2;
    vuint32_t _unused_0:6;
  } B;
} WKPU_NSR_tag;

typedef union WKPU_NCR_union_tag {     /* NMI Configuration Register */
  vuint32_t R;
  struct {
    vuint32_t NLOCK0:1;
    vuint32_t NDSS0:2;
    vuint32_t NWRE0:1;
    vuint32_t _unused_27:1;
    vuint32_t NREE0:1;
    vuint32_t NFEE0:1;
    vuint32_t NFE0:1;
    vuint32_t NLOCK1:1;
    vuint32_t NDSS1:2;
    vuint32_t NWRE1:1;
    vuint32_t _unused_19:1;
    vuint32_t NREE1:1;
    vuint32_t NFEE1:1;
    vuint32_t NFE1:1;
    vuint32_t NLOCK2:1;
    vuint32_t NDSS2:2;
    vuint32_t NWRE2:1;
    vuint32_t _unused_11:1;
    vuint32_t NREE2:1;
    vuint32_t NFEE2:1;
    vuint32_t NFE2:1;
    vuint32_t _unused_0:8;
  } B;
} WKPU_NCR_tag;

struct WKPU_tag {
  WKPU_NSR_tag NSR;                    /* NMI Status Flag Register */
  uint8_t WKPU_reserved0[4];
  WKPU_NCR_tag NCR;                    /* NMI Configuration Register */
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

typedef union XBAR_PORT_PRS_union_tag { /* Priority Registers Slave */
  vuint32_t R;
  struct {
    vuint32_t _unused_31:1;
    vuint32_t M7:3;                    /* Master 7 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_27:1;
    vuint32_t M6:3;                    /* Master 6 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_23:1;
    vuint32_t M5:3;                    /* Master 5 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_19:1;
    vuint32_t M4:3;                    /* Master 4 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_15:1;
    vuint32_t M3:3;                    /* Master 3 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_11:1;
    vuint32_t M2:3;                    /* Master 2 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_7:1;
    vuint32_t M1:3;                    /* Master 1 Priority. Sets the arbitration priority for this port on the associated slave port. */
    vuint32_t _unused_3:1;
    vuint32_t M0:3;                    /* Master 0 Priority. Sets the arbitration priority for this port on the associated slave port. */
  } B;
} XBAR_PORT_PRS_tag;

typedef union XBAR_PORT_CRS_union_tag { /* Control Register */
  vuint32_t R;
  struct {
    vuint32_t RO:1;                    /* Read Only */
    vuint32_t _unused_30:1;
    vuint32_t _unused_10:20;
    vuint32_t ARB:2;                   /* Arbitration Mode */
    vuint32_t _unused_6:2;
    vuint32_t PCTL:2;                  /* Parking Control */
    vuint32_t _unused_3:1;
    vuint32_t PARK:3;                  /* Park */
  } B;
} XBAR_PORT_CRS_tag;

typedef struct XBAR_PORT_struct_tag {
  XBAR_PORT_PRS_tag PRS;               /* Priority Registers Slave */
  uint8_t PORT_reserved0[12];
  XBAR_PORT_CRS_tag CRS;               /* Control Register */
  uint8_t PORT_reserved1[236];
} XBAR_PORT_tag;

struct XBAR_tag {
  XBAR_PORT_tag PORT[8];
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

typedef union XBIC_MCR_union_tag {     /* XBIC Module Control Register */
  vuint32_t R;
  struct {
    vuint32_t SE0:1;
    vuint32_t SE1:1;
    vuint32_t SE2:1;
    vuint32_t SE3:1;
    vuint32_t SE4:1;
    vuint32_t SE5:1;
    vuint32_t SE6:1;
    vuint32_t SE7:1;
    vuint32_t ME0:1;
    vuint32_t ME1:1;
    vuint32_t ME2:1;
    vuint32_t ME3:1;
    vuint32_t ME4:1;
    vuint32_t ME5:1;
    vuint32_t ME6:1;
    vuint32_t ME7:1;
    vuint32_t _unused_0:16;
  } B;
} XBIC_MCR_tag;

typedef union XBIC_EIR_union_tag {     /* XBIC Error Injection Register */
  vuint32_t R;
  struct {
    vuint32_t EIE:1;
    vuint32_t _unused_15:16;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_EIR_tag;

typedef union XBIC_ESR_union_tag {     /* XBIC Error Status Register */
  vuint32_t R;
  struct {
    vuint32_t VLD:1;
    vuint32_t DPSE0:1;
    vuint32_t DPSE1:1;
    vuint32_t DPSE2:1;
    vuint32_t DPSE3:1;
    vuint32_t DPSE4:1;
    vuint32_t DPSE5:1;
    vuint32_t DPSE6:1;
    vuint32_t DPSE7:1;
    vuint32_t DPME0:1;
    vuint32_t DPME1:1;
    vuint32_t DPME2:1;
    vuint32_t DPME3:1;
    vuint32_t DPME4:1;
    vuint32_t DPME5:1;
    vuint32_t DPME6:1;
    vuint32_t DPME7:1;
    vuint32_t SLV:3;
    vuint32_t MST:4;
    vuint32_t SYN:8;
  } B;
} XBIC_ESR_tag;

typedef union XBIC_EAR_union_tag {     /* XBIC Error Address Register */
  vuint32_t R;
  struct {
    vuint32_t ADDR:32;
  } B;
} XBIC_EAR_tag;

struct XBIC_tag {
  XBIC_MCR_tag MCR;                    /* XBIC Module Control Register */
  XBIC_EIR_tag EIR;                    /* XBIC Error Injection Register */
  XBIC_ESR_tag ESR;                    /* XBIC Error Status Register */
  XBIC_EAR_tag EAR;                    /* XBIC Error Address Register */
};

#define SRAM0_START 0x40000000UL
#define ADC_0 (*(volatile struct ADC_tag *) 0xFBE00000UL)
#define ADC_1 (*(volatile struct ADC_tag *) 0xFFE04000UL)
#define ADC_2 (*(volatile struct ADC_tag *) 0xFBE08000UL)
#define ADC_3 (*(volatile struct ADC_tag *) 0xFFE0C000UL)
#define AFE (*(volatile struct AFE_tag *) 0xFBF0C000UL)
#define AIPS_0 (*(volatile struct AIPS_tag *) 0xFC000000UL)
#define AIPS_1 (*(volatile struct AIPS_tag *) 0xF8000000UL)
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CAN_0 (*(volatile struct CAN_tag *) 0xFFEC0000UL)
#define CAN_1 (*(volatile struct CAN_tag *) 0xFFEC4000UL)
#define CAN_2 (*(volatile struct CAN_tag *) 0xFBEC0000UL)
#define CAN_3 (*(volatile struct CAN_tag *) 0xFBEC4000UL)
#define CGM (*(volatile struct CGM_tag *) 0xFFFB0000UL)
#define CMU_0 (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_1 (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CMU_10 (*(volatile struct CMU_tag *) 0xFBFB0480UL)
#define CMU_11 (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_12 (*(volatile struct CMU_tag *) 0xFBFB0500UL)
#define CMU_2 (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_3 (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_5 (*(volatile struct CMU_tag *) 0xFBFB0340UL)
#define CMU_6 (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_7 (*(volatile struct CMU_tag *) 0xFBFB03C0UL)
#define CMU_8 (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_9 (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define CTE (*(volatile struct CTE_tag *) 0xFFD0C000UL)
#define CTU_0 (*(volatile struct CTU_tag *) 0xFBC10000UL)
#define CTU_1 (*(volatile struct CTU_tag *) 0xFFC14000UL)
#define DMA (*(volatile struct DMA_tag *) 0xFC0A0000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFBF6C000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define EIM (*(volatile struct EIM_tag *) 0xFC07C000UL)
#define ENET (*(volatile struct ENET_tag *) 0xFC0B0000UL)
#define ETIMER_0 (*(volatile struct ETIMER_tag *) 0xFBC20000UL)
#define ETIMER_1 (*(volatile struct ETIMER_tag *) 0xFFC24000UL)
#define ETIMER_2 (*(volatile struct ETIMER_tag *) 0xFBC28000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FR (*(volatile struct FR_tag *) 0xFFE50000UL)
#define FlexPWM_0 (*(volatile struct FlexPWM_tag *) 0xFBC00000UL)
#define FlexPWM_1 (*(volatile struct FlexPWM_tag *) 0xFFC04000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define I2C_2 (*(volatile struct I2C_tag *) 0xFBE6C000UL)
#define INTC (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LFAST (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFBE84000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define LINFlexD_3 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define MCB (*(volatile struct MCB_tag *) 0xFFC0C000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define M_CAN (*(volatile struct M_CAN_tag *) 0xFBED0000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PDI3 (*(volatile struct PDI3_tag *) 0xFFF20000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMC (*(volatile struct PMC_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PRAM_XBAR (*(volatile struct PRAM_XBAR_tag *) 0xFC00C000UL)
#define RGM (*(volatile struct RGM_tag *) 0xFFFA8000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIPI (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SPI_0 (*(volatile struct SPI_tag *) 0xFFE70000UL)
#define SPI_1 (*(volatile struct SPI_tag *) 0xFFE74000UL)
#define SPI_2 (*(volatile struct SPI_tag *) 0xFBE70000UL)
#define SPI_3 (*(volatile struct SPI_tag *) 0xFBE74000UL)
#define SPT (*(volatile struct SPT_tag *) 0xFFD10000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define STM_2 (*(volatile struct STM_tag *) 0xFC070000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0xFC058000UL)
#define WGM (*(volatile struct WGM_tag *) 0xFBC44000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBAR_1 (*(volatile struct XBAR_tag *) 0xFC008000UL)
#define XBIC_0 (*(volatile struct XBIC_tag *) 0xFC01C000UL)
#define XBIC_1 (*(volatile struct XBIC_tag *) 0xFC018000UL)
#define XBIC_2 (*(volatile struct XBIC_tag *) 0xFC024000UL)
#define XBIC_3 (*(volatile struct XBIC_tag *) 0xFC034000UL)
#define XBIC_4 (*(volatile struct XBIC_tag *) 0xFC038000UL)
#define XBIC_5 (*(volatile struct XBIC_tag *) 0xFC044000UL)

/* ADC */
#define ADC_0_MCR            ADC_0.MCR.R                   /* Main Configuration Register */
#define ADC_0_MSR            ADC_0.MSR.R                   /* Main Status register */
#define ADC_0_ISR            ADC_0.ISR.R                   /* Interrupt Status Register */
#define ADC_0_CEOCFR0        ADC_0.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_0_IMR            ADC_0.IMR.R                   /* Interrupt Mask Register */
#define ADC_0_CIMR0          ADC_0.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_0_WTISR          ADC_0.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_0_WTIMR          ADC_0.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_0_DMAE           ADC_0.DMAE.R                  /* DMA Enable register */
#define ADC_0_DMAR0          ADC_0.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_0_THRHLR0        ADC_0.THRHLR0.R               /* Threshold Register */
#define ADC_0_THRHLR1        ADC_0.THRHLR1.R               /* Threshold Register */
#define ADC_0_THRHLR2        ADC_0.THRHLR2.R               /* Threshold Register */
#define ADC_0_THRHLR3        ADC_0.THRHLR3.R               /* Threshold Register */
#define ADC_0_PSCR           ADC_0.PSCR.R                  /* Presampling Control Register */
#define ADC_0_PSR0           ADC_0.PSR0.R                  /* Presampling register 0 */
#define ADC_0_CTR0           ADC_0.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_0_CTR1           ADC_0.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_0_NCMR0          ADC_0.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_0_JCMR0          ADC_0.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_0_PDEDR          ADC_0.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_0_CDR0           ADC_0.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR1           ADC_0.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR2           ADC_0.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR3           ADC_0.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR4           ADC_0.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR5           ADC_0.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR6           ADC_0.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR7           ADC_0.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR8           ADC_0.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR9           ADC_0.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR10          ADC_0.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR11          ADC_0.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR12          ADC_0.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR13          ADC_0.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR14          ADC_0.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_CDR15          ADC_0.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_0_THRHLR4        ADC_0.THRHLR4.R               /* Threshold Register */
#define ADC_0_THRHLR5        ADC_0.THRHLR5.R               /* Threshold Register */
#define ADC_0_THRHLR6        ADC_0.THRHLR6.R               /* Threshold Register */
#define ADC_0_THRHLR7        ADC_0.THRHLR7.R               /* Threshold Register */
#define ADC_0_THRHLR8        ADC_0.THRHLR8.R               /* Threshold Register */
#define ADC_0_THRHLR9        ADC_0.THRHLR9.R               /* Threshold Register */
#define ADC_0_THRHLR10       ADC_0.THRHLR10.R              /* Threshold Register */
#define ADC_0_THRHLR11       ADC_0.THRHLR11.R              /* Threshold Register */
#define ADC_0_THRHLR12       ADC_0.THRHLR12.R              /* Threshold Register */
#define ADC_0_THRHLR13       ADC_0.THRHLR13.R              /* Threshold Register */
#define ADC_0_THRHLR14       ADC_0.THRHLR14.R              /* Threshold Register */
#define ADC_0_THRHLR15       ADC_0.THRHLR15.R              /* Threshold Register */
#define ADC_0_CWSELR0        ADC_0.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_0_CWSELR1        ADC_0.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_0_CWENR0         ADC_0.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_0_AWORR0         ADC_0.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_0_STCR1          ADC_0.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_0_STCR2          ADC_0.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_0_STCR3          ADC_0.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_0_STBRR          ADC_0.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_0_STSR1          ADC_0.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_0_STSR2          ADC_0.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_0_STSR3          ADC_0.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_0_STSR4          ADC_0.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_0_STDR1          ADC_0.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_0_STDR2          ADC_0.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_0_STAW0R         ADC_0.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_0_STAW1AR        ADC_0.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_0_STAW1BR        ADC_0.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_0_STAW2R         ADC_0.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_0_STAW4R         ADC_0.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_0_STAW5R         ADC_0.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_0_CALBISTREG     ADC_0.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_0_OFSGNUSR       ADC_0.OFSGNUSR.R              /* Offset and Gain User Register */

#define ADC_1_MCR            ADC_1.MCR.R                   /* Main Configuration Register */
#define ADC_1_MSR            ADC_1.MSR.R                   /* Main Status register */
#define ADC_1_ISR            ADC_1.ISR.R                   /* Interrupt Status Register */
#define ADC_1_CEOCFR0        ADC_1.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_1_IMR            ADC_1.IMR.R                   /* Interrupt Mask Register */
#define ADC_1_CIMR0          ADC_1.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_1_WTISR          ADC_1.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_1_WTIMR          ADC_1.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_1_DMAE           ADC_1.DMAE.R                  /* DMA Enable register */
#define ADC_1_DMAR0          ADC_1.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_1_THRHLR0        ADC_1.THRHLR0.R               /* Threshold Register */
#define ADC_1_THRHLR1        ADC_1.THRHLR1.R               /* Threshold Register */
#define ADC_1_THRHLR2        ADC_1.THRHLR2.R               /* Threshold Register */
#define ADC_1_THRHLR3        ADC_1.THRHLR3.R               /* Threshold Register */
#define ADC_1_PSCR           ADC_1.PSCR.R                  /* Presampling Control Register */
#define ADC_1_PSR0           ADC_1.PSR0.R                  /* Presampling register 0 */
#define ADC_1_CTR0           ADC_1.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_1_CTR1           ADC_1.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_1_NCMR0          ADC_1.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_1_JCMR0          ADC_1.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_1_PDEDR          ADC_1.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_1_CDR0           ADC_1.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR1           ADC_1.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR2           ADC_1.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR3           ADC_1.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR4           ADC_1.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR5           ADC_1.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR6           ADC_1.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR7           ADC_1.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR8           ADC_1.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR9           ADC_1.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR10          ADC_1.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR11          ADC_1.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR12          ADC_1.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR13          ADC_1.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR14          ADC_1.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_CDR15          ADC_1.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_1_THRHLR4        ADC_1.THRHLR4.R               /* Threshold Register */
#define ADC_1_THRHLR5        ADC_1.THRHLR5.R               /* Threshold Register */
#define ADC_1_THRHLR6        ADC_1.THRHLR6.R               /* Threshold Register */
#define ADC_1_THRHLR7        ADC_1.THRHLR7.R               /* Threshold Register */
#define ADC_1_THRHLR8        ADC_1.THRHLR8.R               /* Threshold Register */
#define ADC_1_THRHLR9        ADC_1.THRHLR9.R               /* Threshold Register */
#define ADC_1_THRHLR10       ADC_1.THRHLR10.R              /* Threshold Register */
#define ADC_1_THRHLR11       ADC_1.THRHLR11.R              /* Threshold Register */
#define ADC_1_THRHLR12       ADC_1.THRHLR12.R              /* Threshold Register */
#define ADC_1_THRHLR13       ADC_1.THRHLR13.R              /* Threshold Register */
#define ADC_1_THRHLR14       ADC_1.THRHLR14.R              /* Threshold Register */
#define ADC_1_THRHLR15       ADC_1.THRHLR15.R              /* Threshold Register */
#define ADC_1_CWSELR0        ADC_1.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_1_CWSELR1        ADC_1.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_1_CWENR0         ADC_1.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_1_AWORR0         ADC_1.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_1_STCR1          ADC_1.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_1_STCR2          ADC_1.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_1_STCR3          ADC_1.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_1_STBRR          ADC_1.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_1_STSR1          ADC_1.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_1_STSR2          ADC_1.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_1_STSR3          ADC_1.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_1_STSR4          ADC_1.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_1_STDR1          ADC_1.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_1_STDR2          ADC_1.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_1_STAW0R         ADC_1.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_1_STAW1AR        ADC_1.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_1_STAW1BR        ADC_1.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_1_STAW2R         ADC_1.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_1_STAW4R         ADC_1.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_1_STAW5R         ADC_1.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_1_CALBISTREG     ADC_1.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_1_OFSGNUSR       ADC_1.OFSGNUSR.R              /* Offset and Gain User Register */

#define ADC_2_MCR            ADC_2.MCR.R                   /* Main Configuration Register */
#define ADC_2_MSR            ADC_2.MSR.R                   /* Main Status register */
#define ADC_2_ISR            ADC_2.ISR.R                   /* Interrupt Status Register */
#define ADC_2_CEOCFR0        ADC_2.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_2_IMR            ADC_2.IMR.R                   /* Interrupt Mask Register */
#define ADC_2_CIMR0          ADC_2.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_2_WTISR          ADC_2.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_2_WTIMR          ADC_2.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_2_DMAE           ADC_2.DMAE.R                  /* DMA Enable register */
#define ADC_2_DMAR0          ADC_2.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_2_THRHLR0        ADC_2.THRHLR0.R               /* Threshold Register */
#define ADC_2_THRHLR1        ADC_2.THRHLR1.R               /* Threshold Register */
#define ADC_2_THRHLR2        ADC_2.THRHLR2.R               /* Threshold Register */
#define ADC_2_THRHLR3        ADC_2.THRHLR3.R               /* Threshold Register */
#define ADC_2_PSCR           ADC_2.PSCR.R                  /* Presampling Control Register */
#define ADC_2_PSR0           ADC_2.PSR0.R                  /* Presampling register 0 */
#define ADC_2_CTR0           ADC_2.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_2_CTR1           ADC_2.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_2_NCMR0          ADC_2.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_2_JCMR0          ADC_2.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_2_PDEDR          ADC_2.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_2_CDR0           ADC_2.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR1           ADC_2.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR2           ADC_2.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR3           ADC_2.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR4           ADC_2.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR5           ADC_2.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR6           ADC_2.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR7           ADC_2.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR8           ADC_2.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR9           ADC_2.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR10          ADC_2.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR11          ADC_2.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR12          ADC_2.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR13          ADC_2.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR14          ADC_2.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_CDR15          ADC_2.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_2_THRHLR4        ADC_2.THRHLR4.R               /* Threshold Register */
#define ADC_2_THRHLR5        ADC_2.THRHLR5.R               /* Threshold Register */
#define ADC_2_THRHLR6        ADC_2.THRHLR6.R               /* Threshold Register */
#define ADC_2_THRHLR7        ADC_2.THRHLR7.R               /* Threshold Register */
#define ADC_2_THRHLR8        ADC_2.THRHLR8.R               /* Threshold Register */
#define ADC_2_THRHLR9        ADC_2.THRHLR9.R               /* Threshold Register */
#define ADC_2_THRHLR10       ADC_2.THRHLR10.R              /* Threshold Register */
#define ADC_2_THRHLR11       ADC_2.THRHLR11.R              /* Threshold Register */
#define ADC_2_THRHLR12       ADC_2.THRHLR12.R              /* Threshold Register */
#define ADC_2_THRHLR13       ADC_2.THRHLR13.R              /* Threshold Register */
#define ADC_2_THRHLR14       ADC_2.THRHLR14.R              /* Threshold Register */
#define ADC_2_THRHLR15       ADC_2.THRHLR15.R              /* Threshold Register */
#define ADC_2_CWSELR0        ADC_2.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_2_CWSELR1        ADC_2.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_2_CWENR0         ADC_2.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_2_AWORR0         ADC_2.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_2_STCR1          ADC_2.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_2_STCR2          ADC_2.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_2_STCR3          ADC_2.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_2_STBRR          ADC_2.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_2_STSR1          ADC_2.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_2_STSR2          ADC_2.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_2_STSR3          ADC_2.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_2_STSR4          ADC_2.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_2_STDR1          ADC_2.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_2_STDR2          ADC_2.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_2_STAW0R         ADC_2.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_2_STAW1AR        ADC_2.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_2_STAW1BR        ADC_2.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_2_STAW2R         ADC_2.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_2_STAW4R         ADC_2.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_2_STAW5R         ADC_2.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_2_CALBISTREG     ADC_2.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_2_OFSGNUSR       ADC_2.OFSGNUSR.R              /* Offset and Gain User Register */

#define ADC_3_MCR            ADC_3.MCR.R                   /* Main Configuration Register */
#define ADC_3_MSR            ADC_3.MSR.R                   /* Main Status register */
#define ADC_3_ISR            ADC_3.ISR.R                   /* Interrupt Status Register */
#define ADC_3_CEOCFR0        ADC_3.CEOCFR0.R               /* Channel Pending register 0 */
#define ADC_3_IMR            ADC_3.IMR.R                   /* Interrupt Mask Register */
#define ADC_3_CIMR0          ADC_3.CIMR0.R                 /* Channel Interrupt Mask Register 0 */
#define ADC_3_WTISR          ADC_3.WTISR.R                 /* Watchdog Threshold Interrupt Status Register */
#define ADC_3_WTIMR          ADC_3.WTIMR.R                 /* Watchdog Threshold Interrupt Mask Register */
#define ADC_3_DMAE           ADC_3.DMAE.R                  /* DMA Enable register */
#define ADC_3_DMAR0          ADC_3.DMAR0.R                 /* DMA Channel Select Register 0 */
#define ADC_3_THRHLR0        ADC_3.THRHLR0.R               /* Threshold Register */
#define ADC_3_THRHLR1        ADC_3.THRHLR1.R               /* Threshold Register */
#define ADC_3_THRHLR2        ADC_3.THRHLR2.R               /* Threshold Register */
#define ADC_3_THRHLR3        ADC_3.THRHLR3.R               /* Threshold Register */
#define ADC_3_PSCR           ADC_3.PSCR.R                  /* Presampling Control Register */
#define ADC_3_PSR0           ADC_3.PSR0.R                  /* Presampling register 0 */
#define ADC_3_CTR0           ADC_3.CTR0.R                  /* Conversion Timing Register 0 */
#define ADC_3_CTR1           ADC_3.CTR1.R                  /* Conversion Timing Register 1 */
#define ADC_3_NCMR0          ADC_3.NCMR0.R                 /* Normal Conversion Mask Register 0 */
#define ADC_3_JCMR0          ADC_3.JCMR0.R                 /* Injected Conversion Mask Register 0 */
#define ADC_3_PDEDR          ADC_3.PDEDR.R                 /* Power Down Exit Delay Register */
#define ADC_3_CDR0           ADC_3.CDR[0].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR1           ADC_3.CDR[1].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR2           ADC_3.CDR[2].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR3           ADC_3.CDR[3].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR4           ADC_3.CDR[4].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR5           ADC_3.CDR[5].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR6           ADC_3.CDR[6].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR7           ADC_3.CDR[7].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR8           ADC_3.CDR[8].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR9           ADC_3.CDR[9].R                /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR10          ADC_3.CDR[10].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR11          ADC_3.CDR[11].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR12          ADC_3.CDR[12].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR13          ADC_3.CDR[13].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR14          ADC_3.CDR[14].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_CDR15          ADC_3.CDR[15].R               /* Channel Data Register n (Precision Channels) */
#define ADC_3_THRHLR4        ADC_3.THRHLR4.R               /* Threshold Register */
#define ADC_3_THRHLR5        ADC_3.THRHLR5.R               /* Threshold Register */
#define ADC_3_THRHLR6        ADC_3.THRHLR6.R               /* Threshold Register */
#define ADC_3_THRHLR7        ADC_3.THRHLR7.R               /* Threshold Register */
#define ADC_3_THRHLR8        ADC_3.THRHLR8.R               /* Threshold Register */
#define ADC_3_THRHLR9        ADC_3.THRHLR9.R               /* Threshold Register */
#define ADC_3_THRHLR10       ADC_3.THRHLR10.R              /* Threshold Register */
#define ADC_3_THRHLR11       ADC_3.THRHLR11.R              /* Threshold Register */
#define ADC_3_THRHLR12       ADC_3.THRHLR12.R              /* Threshold Register */
#define ADC_3_THRHLR13       ADC_3.THRHLR13.R              /* Threshold Register */
#define ADC_3_THRHLR14       ADC_3.THRHLR14.R              /* Threshold Register */
#define ADC_3_THRHLR15       ADC_3.THRHLR15.R              /* Threshold Register */
#define ADC_3_CWSELR0        ADC_3.CWSELR0.R               /* Channel Watchdog Select Register 0 */
#define ADC_3_CWSELR1        ADC_3.CWSELR1.R               /* Channel Watchdog Select Register 1 */
#define ADC_3_CWENR0         ADC_3.CWENR0.R                /* Channel Watchdog Enable Register 0 */
#define ADC_3_AWORR0         ADC_3.AWORR0.R                /* Analog Watchdog Out of Range Register 0 */
#define ADC_3_STCR1          ADC_3.STCR1.R                 /* Self Test Configuration Register 1 */
#define ADC_3_STCR2          ADC_3.STCR2.R                 /* Self Test Configuration Register 2 */
#define ADC_3_STCR3          ADC_3.STCR3.R                 /* Self Test Configuration Register 3 */
#define ADC_3_STBRR          ADC_3.STBRR.R                 /* Self Test Baud Rate Register */
#define ADC_3_STSR1          ADC_3.STSR1.R                 /* Self Test Status Register 1 */
#define ADC_3_STSR2          ADC_3.STSR2.R                 /* Self Test Status Register 2 */
#define ADC_3_STSR3          ADC_3.STSR3.R                 /* Self Test Status Register 3 */
#define ADC_3_STSR4          ADC_3.STSR4.R                 /* Self Test Status Register 4 */
#define ADC_3_STDR1          ADC_3.STDR1.R                 /* Self Test Data Register 1 */
#define ADC_3_STDR2          ADC_3.STDR2.R                 /* Self Test Data Register 2 */
#define ADC_3_STAW0R         ADC_3.STAW0R.R                /* Self Test Analog Watchdog Register 0 */
#define ADC_3_STAW1AR        ADC_3.STAW1AR.R               /* Self Test Analog Watchdog Register 1A */
#define ADC_3_STAW1BR        ADC_3.STAW1BR.R               /* Self Test Analog Watchdog Register 1B */
#define ADC_3_STAW2R         ADC_3.STAW2R.R                /* Self Test Analog Watchdog Register 2 */
#define ADC_3_STAW4R         ADC_3.STAW4R.R                /* Self Test Analog Watchdog Register 4 */
#define ADC_3_STAW5R         ADC_3.STAW5R.R                /* Self Test Analog Watchdog Register 5 */
#define ADC_3_CALBISTREG     ADC_3.CALBISTREG.R            /* Calibration, BIST Control and status Register */
#define ADC_3_OFSGNUSR       ADC_3.OFSGNUSR.R              /* Offset and Gain User Register */

/* AFE */
#define AFE_OSCCTRL          AFE.OSCCTRL.R                 /* Oscillator Control Register */
#define AFE_OSCSTS           AFE.OSCSTS.R                  /* Oscillator Status Register */
#define AFE_OSCDLY           AFE.OSCDLY.R                  /* Oscillator Delay Register */
#define AFE_PLLCTRL1         AFE.PLLCTRL1.R                /* SDPLL Control Register 1 */
#define AFE_PLLCTRL2         AFE.PLLCTRL2.R                /* SDPLL Control Register 2 */
#define AFE_PLLCTRL3         AFE.PLLCTRL3.R                /* SDPLL Control Register 3 */
#define AFE_PLLCTRL8         AFE.PLLCTRL8.R                /* SDPLL Control Register 8 */
#define AFE_PLLSTS           AFE.PLLSTS.R                  /* SDPLL Status Register */
#define AFE_ADCCTRL1         AFE.ADCCTRL1.R                /* ADC Control Register 1 */
#define AFE_ADCCTRL2         AFE.ADCCTRL2.R                /* ADC Control Register 2 */
#define AFE_ADCTOT           AFE.ADCTOT.R                  /* ADC Tracking Oscillator Trim Register */
#define AFE_ADCRST           AFE.ADCRST.R                  /* ADC Reset Register */
#define AFE_ADCTRIM          AFE.ADCTRIM.R                 /* ADC Trim Register */
#define AFE_ADCCTRL7         AFE.ADCCTRL7.R                /* ADC Control Register 7 */
#define AFE_ADCOVLD          AFE.ADCOVLD.R                 /* ADC Overload Detect Register */
#define AFE_DACCTRL          AFE.DACCTRL.R                 /* DAC Control Register */
#define AFE_VRFCTRL1         AFE.VRFCTRL1.R                /* VREF Control Register 1 */
#define AFE_LVDSTS           AFE.LVDSTS.R                  /* Low Voltage Detect Status Register */
#define AFE_VRGRSVD          AFE.VRGRSVD.R                 /* VREG Reserved Register */
#define AFE_VRGCTRL2         AFE.VRGCTRL2.R                /* VREG2 Control Register */
#define AFE_VRGCTRL3         AFE.VRGCTRL3.R                /* VREG3 Control Register */
#define AFE_VRGCTRL4         AFE.VRGCTRL4.R                /* VREG4 Control Register */
#define AFE_VRGCTRL5         AFE.VRGCTRL5.R                /* VREG5 Control Register */
#define AFE_VRGCTRL6         AFE.VRGCTRL6.R                /* VREG6 Control Register */
#define AFE_VRGCTRL7         AFE.VRGCTRL7.R                /* VREG7 Control Register */
#define AFE_VRGCTRL8         AFE.VRGCTRL8.R                /* VREG8 Control Register */
#define AFE_VRGCTRL9         AFE.VRGCTRL9.R                /* VREG9 Control Register */
#define AFE_FILTCTRL0        AFE.FILTCTRL[0].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL1        AFE.FILTCTRL[1].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL2        AFE.FILTCTRL[2].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL3        AFE.FILTCTRL[3].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL4        AFE.FILTCTRL[4].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL5        AFE.FILTCTRL[5].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL6        AFE.FILTCTRL[6].R             /* Decimation Filter Control Register */
#define AFE_FILTCTRL7        AFE.FILTCTRL[7].R             /* Decimation Filter Control Register */
#define AFE_FLCOEF00         AFE.FILTCOEFF[0][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF10         AFE.FILTCOEFF[0][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF20         AFE.FILTCOEFF[0][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF30         AFE.FILTCOEFF[0][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF40         AFE.FILTCOEFF[0][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF50         AFE.FILTCOEFF[0][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF60         AFE.FILTCOEFF[0][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF70         AFE.FILTCOEFF[0][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF80         AFE.FILTCOEFF[0][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF90         AFE.FILTCOEFF[0][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF100        AFE.FILTCOEFF[0][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF110        AFE.FILTCOEFF[0][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF120        AFE.FILTCOEFF[0][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF130        AFE.FILTCOEFF[0][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF140        AFE.FILTCOEFF[0][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF150        AFE.FILTCOEFF[0][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF01         AFE.FILTCOEFF[1][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF11         AFE.FILTCOEFF[1][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF21         AFE.FILTCOEFF[1][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF31         AFE.FILTCOEFF[1][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF41         AFE.FILTCOEFF[1][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF51         AFE.FILTCOEFF[1][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF61         AFE.FILTCOEFF[1][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF71         AFE.FILTCOEFF[1][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF81         AFE.FILTCOEFF[1][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF91         AFE.FILTCOEFF[1][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF101        AFE.FILTCOEFF[1][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF111        AFE.FILTCOEFF[1][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF121        AFE.FILTCOEFF[1][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF131        AFE.FILTCOEFF[1][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF141        AFE.FILTCOEFF[1][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF151        AFE.FILTCOEFF[1][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF02         AFE.FILTCOEFF[2][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF12         AFE.FILTCOEFF[2][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF22         AFE.FILTCOEFF[2][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF32         AFE.FILTCOEFF[2][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF42         AFE.FILTCOEFF[2][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF52         AFE.FILTCOEFF[2][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF62         AFE.FILTCOEFF[2][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF72         AFE.FILTCOEFF[2][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF82         AFE.FILTCOEFF[2][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF92         AFE.FILTCOEFF[2][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF102        AFE.FILTCOEFF[2][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF112        AFE.FILTCOEFF[2][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF122        AFE.FILTCOEFF[2][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF132        AFE.FILTCOEFF[2][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF142        AFE.FILTCOEFF[2][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF152        AFE.FILTCOEFF[2][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF03         AFE.FILTCOEFF[3][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF13         AFE.FILTCOEFF[3][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF23         AFE.FILTCOEFF[3][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF33         AFE.FILTCOEFF[3][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF43         AFE.FILTCOEFF[3][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF53         AFE.FILTCOEFF[3][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF63         AFE.FILTCOEFF[3][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF73         AFE.FILTCOEFF[3][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF83         AFE.FILTCOEFF[3][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF93         AFE.FILTCOEFF[3][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF103        AFE.FILTCOEFF[3][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF113        AFE.FILTCOEFF[3][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF123        AFE.FILTCOEFF[3][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF133        AFE.FILTCOEFF[3][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF143        AFE.FILTCOEFF[3][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF153        AFE.FILTCOEFF[3][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF04         AFE.FILTCOEFF[4][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF14         AFE.FILTCOEFF[4][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF24         AFE.FILTCOEFF[4][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF34         AFE.FILTCOEFF[4][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF44         AFE.FILTCOEFF[4][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF54         AFE.FILTCOEFF[4][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF64         AFE.FILTCOEFF[4][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF74         AFE.FILTCOEFF[4][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF84         AFE.FILTCOEFF[4][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF94         AFE.FILTCOEFF[4][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF104        AFE.FILTCOEFF[4][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF114        AFE.FILTCOEFF[4][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF124        AFE.FILTCOEFF[4][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF134        AFE.FILTCOEFF[4][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF144        AFE.FILTCOEFF[4][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF154        AFE.FILTCOEFF[4][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF05         AFE.FILTCOEFF[5][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF15         AFE.FILTCOEFF[5][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF25         AFE.FILTCOEFF[5][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF35         AFE.FILTCOEFF[5][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF45         AFE.FILTCOEFF[5][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF55         AFE.FILTCOEFF[5][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF65         AFE.FILTCOEFF[5][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF75         AFE.FILTCOEFF[5][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF85         AFE.FILTCOEFF[5][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF95         AFE.FILTCOEFF[5][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF105        AFE.FILTCOEFF[5][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF115        AFE.FILTCOEFF[5][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF125        AFE.FILTCOEFF[5][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF135        AFE.FILTCOEFF[5][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF145        AFE.FILTCOEFF[5][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF155        AFE.FILTCOEFF[5][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF06         AFE.FILTCOEFF[6][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF16         AFE.FILTCOEFF[6][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF26         AFE.FILTCOEFF[6][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF36         AFE.FILTCOEFF[6][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF46         AFE.FILTCOEFF[6][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF56         AFE.FILTCOEFF[6][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF66         AFE.FILTCOEFF[6][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF76         AFE.FILTCOEFF[6][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF86         AFE.FILTCOEFF[6][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF96         AFE.FILTCOEFF[6][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF106        AFE.FILTCOEFF[6][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF116        AFE.FILTCOEFF[6][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF126        AFE.FILTCOEFF[6][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF136        AFE.FILTCOEFF[6][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF146        AFE.FILTCOEFF[6][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF156        AFE.FILTCOEFF[6][15].R        /* Decimation Filter Coefficient Register 15 */
#define AFE_FLCOEF07         AFE.FILTCOEFF[7][0].R         /* Decimation Filter Coefficient Register 0 */
#define AFE_FLCOEF17         AFE.FILTCOEFF[7][1].R         /* Decimation Filter Coefficient Register 1 */
#define AFE_FLCOEF27         AFE.FILTCOEFF[7][2].R         /* Decimation Filter Coefficient Register 2 */
#define AFE_FLCOEF37         AFE.FILTCOEFF[7][3].R         /* Decimation Filter Coefficient Register 3 */
#define AFE_FLCOEF47         AFE.FILTCOEFF[7][4].R         /* Decimation Filter Coefficient Register 4 */
#define AFE_FLCOEF57         AFE.FILTCOEFF[7][5].R         /* Decimation Filter Coefficient Register 5 */
#define AFE_FLCOEF67         AFE.FILTCOEFF[7][6].R         /* Decimation Filter Coefficient Register 6 */
#define AFE_FLCOEF77         AFE.FILTCOEFF[7][7].R         /* Decimation Filter Coefficient Register 7 */
#define AFE_FLCOEF87         AFE.FILTCOEFF[7][8].R         /* Decimation Filter Coefficient Register 8 */
#define AFE_FLCOEF97         AFE.FILTCOEFF[7][9].R         /* Decimation Filter Coefficient Register 9 */
#define AFE_FLCOEF107        AFE.FILTCOEFF[7][10].R        /* Decimation Filter Coefficient Register 10 */
#define AFE_FLCOEF117        AFE.FILTCOEFF[7][11].R        /* Decimation Filter Coefficient Register 11 */
#define AFE_FLCOEF127        AFE.FILTCOEFF[7][12].R        /* Decimation Filter Coefficient Register 12 */
#define AFE_FLCOEF137        AFE.FILTCOEFF[7][13].R        /* Decimation Filter Coefficient Register 13 */
#define AFE_FLCOEF147        AFE.FILTCOEFF[7][14].R        /* Decimation Filter Coefficient Register 14 */
#define AFE_FLCOEF157        AFE.FILTCOEFF[7][15].R        /* Decimation Filter Coefficient Register 15 */

/* AIPS */
#define AIPS_0_MPRA          AIPS_0.MPRA.R                 /* Master Privilege Register A */
#define AIPS_0_MPRB          AIPS_0.MPRB.R                 /* Master Privilege Register B */
#define AIPS_0_PACRA         AIPS_0.PACRA.R                /* Peripheral Access Control Register */
#define AIPS_0_PACRB         AIPS_0.PACRB.R                /* Peripheral Access Control Register */
#define AIPS_0_PACRC         AIPS_0.PACRC.R                /* Peripheral Access Control Register */
#define AIPS_0_PACRD         AIPS_0.PACRD.R                /* Peripheral Access Control Register */
#define AIPS_0_PACR_Reserved AIPS_0.PACR_Reserved.R        /* Peripheral Access Control Register */
#define AIPS_0_PACRF         AIPS_0.PACRF.R                /* Peripheral Access Control Register */
#define AIPS_0_PACRG         AIPS_0.PACRG.R                /* Peripheral Access Control Register */
#define AIPS_0_PACRH         AIPS_0.PACRH.R                /* Peripheral Access Control Register */
#define AIPS_0_OPACRA        AIPS_0.OPACRA.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRB        AIPS_0.OPACRB.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRC        AIPS_0.OPACRC.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRD        AIPS_0.OPACRD.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRE        AIPS_0.OPACRE.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRF        AIPS_0.OPACRF.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRG        AIPS_0.OPACRG.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRH        AIPS_0.OPACRH.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRI        AIPS_0.OPACRI.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRJ        AIPS_0.OPACRJ.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRK        AIPS_0.OPACRK.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRL        AIPS_0.OPACRL.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRM        AIPS_0.OPACRM.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRN        AIPS_0.OPACRN.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRO        AIPS_0.OPACRO.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRP        AIPS_0.OPACRP.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRQ        AIPS_0.OPACRQ.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRR        AIPS_0.OPACRR.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRS        AIPS_0.OPACRS.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRT        AIPS_0.OPACRT.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRU        AIPS_0.OPACRU.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRV        AIPS_0.OPACRV.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRW        AIPS_0.OPACRW.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRX        AIPS_0.OPACRX.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRY        AIPS_0.OPACRY.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRZ        AIPS_0.OPACRZ.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAA       AIPS_0.OPACRAA.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAB       AIPS_0.OPACRAB.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAC       AIPS_0.OPACRAC.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAD       AIPS_0.OPACRAD.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAE       AIPS_0.OPACRAE.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_0_OPACRAF       AIPS_0.OPACRAF.R              /* Off-Platform Peripheral Access Control Register */

#define AIPS_1_MPRA          AIPS_1.MPRA.R                 /* Master Privilege Register A */
#define AIPS_1_MPRB          AIPS_1.MPRB.R                 /* Master Privilege Register B */
#define AIPS_1_PACRA         AIPS_1.PACRA.R                /* Peripheral Access Control Register */
#define AIPS_1_PACRB         AIPS_1.PACRB.R                /* Peripheral Access Control Register */
#define AIPS_1_PACRC         AIPS_1.PACRC.R                /* Peripheral Access Control Register */
#define AIPS_1_PACRD         AIPS_1.PACRD.R                /* Peripheral Access Control Register */
#define AIPS_1_PACR_Reserved AIPS_1.PACR_Reserved.R        /* Peripheral Access Control Register */
#define AIPS_1_PACRF         AIPS_1.PACRF.R                /* Peripheral Access Control Register */
#define AIPS_1_PACRG         AIPS_1.PACRG.R                /* Peripheral Access Control Register */
#define AIPS_1_PACRH         AIPS_1.PACRH.R                /* Peripheral Access Control Register */
#define AIPS_1_OPACRA        AIPS_1.OPACRA.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRB        AIPS_1.OPACRB.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRC        AIPS_1.OPACRC.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRD        AIPS_1.OPACRD.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRE        AIPS_1.OPACRE.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRF        AIPS_1.OPACRF.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRG        AIPS_1.OPACRG.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRH        AIPS_1.OPACRH.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRI        AIPS_1.OPACRI.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRJ        AIPS_1.OPACRJ.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRK        AIPS_1.OPACRK.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRL        AIPS_1.OPACRL.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRM        AIPS_1.OPACRM.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRN        AIPS_1.OPACRN.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRO        AIPS_1.OPACRO.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRP        AIPS_1.OPACRP.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRQ        AIPS_1.OPACRQ.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRR        AIPS_1.OPACRR.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRS        AIPS_1.OPACRS.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRT        AIPS_1.OPACRT.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRU        AIPS_1.OPACRU.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRV        AIPS_1.OPACRV.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRW        AIPS_1.OPACRW.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRX        AIPS_1.OPACRX.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRY        AIPS_1.OPACRY.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRZ        AIPS_1.OPACRZ.R               /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAA       AIPS_1.OPACRAA.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAB       AIPS_1.OPACRAB.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAC       AIPS_1.OPACRAC.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAD       AIPS_1.OPACRAD.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAE       AIPS_1.OPACRAE.R              /* Off-Platform Peripheral Access Control Register */
#define AIPS_1_OPACRAF       AIPS_1.OPACRAF.R              /* Off-Platform Peripheral Access Control Register */

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CAN */
#define CAN_0_MCR            CAN_0.MCR.R                   /* Module Configuration Register */
#define CAN_0_CTRL1          CAN_0.CTRL1.R                 /* Control 1 register */
#define CAN_0_TIMER          CAN_0.TIMER.R                 /* Free Running Timer */
#define CAN_0_RXMGMASK       CAN_0.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_0_RX14MASK       CAN_0.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_0_RX15MASK       CAN_0.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_0_ECR            CAN_0.ECR.R                   /* Error Counter */
#define CAN_0_ESR1           CAN_0.ESR1.R                  /* Error and Status 1 register */
#define CAN_0_IMASK2         CAN_0.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_0_IMASK1         CAN_0.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_0_IFLAG2         CAN_0.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_0_IFLAG1         CAN_0.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_0_CTRL2          CAN_0.CTRL2.R                 /* Control 2 register */
#define CAN_0_ESR2           CAN_0.ESR2.R                  /* Error and Status 2 register */
#define CAN_0_CRCR           CAN_0.CRCR.R                  /* CRC Register */
#define CAN_0_RXFGMASK       CAN_0.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_0_RXFIR          CAN_0.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_0_CS0            CAN_0.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_0_ID0            CAN_0.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_0_B0             CAN_0.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_0_H0             CAN_0.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_0_W0             CAN_0.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_0_CS1            CAN_0.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_0_ID1            CAN_0.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_0_B1             CAN_0.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_0_H1             CAN_0.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_0_W1             CAN_0.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_0_CS2            CAN_0.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_0_ID2            CAN_0.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_0_B2             CAN_0.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_0_H2             CAN_0.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_0_W2             CAN_0.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_0_CS3            CAN_0.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_0_ID3            CAN_0.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_0_B3             CAN_0.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_0_H3             CAN_0.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_0_W3             CAN_0.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_0_CS4            CAN_0.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_0_ID4            CAN_0.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_0_B4             CAN_0.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_0_H4             CAN_0.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_0_W4             CAN_0.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_0_CS5            CAN_0.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_0_ID5            CAN_0.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_0_B5             CAN_0.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_0_H5             CAN_0.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_0_W5             CAN_0.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_0_CS6            CAN_0.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_0_ID6            CAN_0.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_0_B6             CAN_0.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_0_H6             CAN_0.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_0_W6             CAN_0.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_0_CS7            CAN_0.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_0_ID7            CAN_0.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_0_B7             CAN_0.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_0_H7             CAN_0.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_0_W7             CAN_0.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_0_CS8            CAN_0.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_0_ID8            CAN_0.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_0_B8             CAN_0.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_0_H8             CAN_0.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_0_W8             CAN_0.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_0_CS9            CAN_0.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_0_ID9            CAN_0.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_0_B9             CAN_0.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_0_H9             CAN_0.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_0_W9             CAN_0.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_0_CS10           CAN_0.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_0_ID10           CAN_0.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_0_B10            CAN_0.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_0_H10            CAN_0.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_0_W10            CAN_0.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_0_CS11           CAN_0.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_0_ID11           CAN_0.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_0_B11            CAN_0.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_0_H11            CAN_0.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_0_W11            CAN_0.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_0_CS12           CAN_0.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_0_ID12           CAN_0.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_0_B12            CAN_0.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_0_H12            CAN_0.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_0_W12            CAN_0.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_0_CS13           CAN_0.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_0_ID13           CAN_0.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_0_B13            CAN_0.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_0_H13            CAN_0.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_0_W13            CAN_0.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_0_CS14           CAN_0.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_0_ID14           CAN_0.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_0_B14            CAN_0.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_0_H14            CAN_0.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_0_W14            CAN_0.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_0_CS15           CAN_0.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_0_ID15           CAN_0.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_0_B15            CAN_0.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_0_H15            CAN_0.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_0_W15            CAN_0.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_0_CS16           CAN_0.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_0_ID16           CAN_0.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_0_B16            CAN_0.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_0_H16            CAN_0.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_0_W16            CAN_0.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_0_CS17           CAN_0.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_0_ID17           CAN_0.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_0_B17            CAN_0.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_0_H17            CAN_0.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_0_W17            CAN_0.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_0_CS18           CAN_0.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_0_ID18           CAN_0.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_0_B18            CAN_0.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_0_H18            CAN_0.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_0_W18            CAN_0.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_0_CS19           CAN_0.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_0_ID19           CAN_0.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_0_B19            CAN_0.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_0_H19            CAN_0.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_0_W19            CAN_0.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_0_CS20           CAN_0.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_0_ID20           CAN_0.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_0_B20            CAN_0.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_0_H20            CAN_0.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_0_W20            CAN_0.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_0_CS21           CAN_0.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_0_ID21           CAN_0.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_0_B21            CAN_0.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_0_H21            CAN_0.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_0_W21            CAN_0.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_0_CS22           CAN_0.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_0_ID22           CAN_0.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_0_B22            CAN_0.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_0_H22            CAN_0.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_0_W22            CAN_0.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_0_CS23           CAN_0.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_0_ID23           CAN_0.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_0_B23            CAN_0.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_0_H23            CAN_0.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_0_W23            CAN_0.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_0_CS24           CAN_0.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_0_ID24           CAN_0.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_0_B24            CAN_0.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_0_H24            CAN_0.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_0_W24            CAN_0.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_0_CS25           CAN_0.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_0_ID25           CAN_0.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_0_B25            CAN_0.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_0_H25            CAN_0.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_0_W25            CAN_0.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_0_CS26           CAN_0.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_0_ID26           CAN_0.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_0_B26            CAN_0.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_0_H26            CAN_0.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_0_W26            CAN_0.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_0_CS27           CAN_0.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_0_ID27           CAN_0.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_0_B27            CAN_0.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_0_H27            CAN_0.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_0_W27            CAN_0.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_0_CS28           CAN_0.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_0_ID28           CAN_0.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_0_B28            CAN_0.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_0_H28            CAN_0.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_0_W28            CAN_0.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_0_CS29           CAN_0.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_0_ID29           CAN_0.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_0_B29            CAN_0.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_0_H29            CAN_0.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_0_W29            CAN_0.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_0_CS30           CAN_0.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_0_ID30           CAN_0.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_0_B30            CAN_0.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_0_H30            CAN_0.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_0_W30            CAN_0.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_0_CS31           CAN_0.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_0_ID31           CAN_0.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_0_B31            CAN_0.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_0_H31            CAN_0.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_0_W31            CAN_0.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_0_CS32           CAN_0.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_0_ID32           CAN_0.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_0_B32            CAN_0.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_0_H32            CAN_0.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_0_W32            CAN_0.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_0_CS33           CAN_0.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_0_ID33           CAN_0.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_0_B33            CAN_0.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_0_H33            CAN_0.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_0_W33            CAN_0.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_0_CS34           CAN_0.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_0_ID34           CAN_0.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_0_B34            CAN_0.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_0_H34            CAN_0.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_0_W34            CAN_0.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_0_CS35           CAN_0.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_0_ID35           CAN_0.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_0_B35            CAN_0.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_0_H35            CAN_0.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_0_W35            CAN_0.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_0_CS36           CAN_0.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_0_ID36           CAN_0.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_0_B36            CAN_0.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_0_H36            CAN_0.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_0_W36            CAN_0.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_0_CS37           CAN_0.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_0_ID37           CAN_0.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_0_B37            CAN_0.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_0_H37            CAN_0.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_0_W37            CAN_0.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_0_CS38           CAN_0.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_0_ID38           CAN_0.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_0_B38            CAN_0.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_0_H38            CAN_0.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_0_W38            CAN_0.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_0_CS39           CAN_0.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_0_ID39           CAN_0.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_0_B39            CAN_0.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_0_H39            CAN_0.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_0_W39            CAN_0.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_0_CS40           CAN_0.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_0_ID40           CAN_0.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_0_B40            CAN_0.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_0_H40            CAN_0.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_0_W40            CAN_0.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_0_CS41           CAN_0.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_0_ID41           CAN_0.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_0_B41            CAN_0.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_0_H41            CAN_0.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_0_W41            CAN_0.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_0_CS42           CAN_0.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_0_ID42           CAN_0.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_0_B42            CAN_0.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_0_H42            CAN_0.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_0_W42            CAN_0.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_0_CS43           CAN_0.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_0_ID43           CAN_0.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_0_B43            CAN_0.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_0_H43            CAN_0.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_0_W43            CAN_0.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_0_CS44           CAN_0.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_0_ID44           CAN_0.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_0_B44            CAN_0.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_0_H44            CAN_0.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_0_W44            CAN_0.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_0_CS45           CAN_0.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_0_ID45           CAN_0.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_0_B45            CAN_0.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_0_H45            CAN_0.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_0_W45            CAN_0.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_0_CS46           CAN_0.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_0_ID46           CAN_0.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_0_B46            CAN_0.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_0_H46            CAN_0.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_0_W46            CAN_0.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_0_CS47           CAN_0.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_0_ID47           CAN_0.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_0_B47            CAN_0.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_0_H47            CAN_0.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_0_W47            CAN_0.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_0_CS48           CAN_0.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_0_ID48           CAN_0.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_0_B48            CAN_0.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_0_H48            CAN_0.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_0_W48            CAN_0.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_0_CS49           CAN_0.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_0_ID49           CAN_0.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_0_B49            CAN_0.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_0_H49            CAN_0.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_0_W49            CAN_0.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_0_CS50           CAN_0.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_0_ID50           CAN_0.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_0_B50            CAN_0.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_0_H50            CAN_0.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_0_W50            CAN_0.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_0_CS51           CAN_0.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_0_ID51           CAN_0.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_0_B51            CAN_0.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_0_H51            CAN_0.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_0_W51            CAN_0.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_0_CS52           CAN_0.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_0_ID52           CAN_0.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_0_B52            CAN_0.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_0_H52            CAN_0.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_0_W52            CAN_0.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_0_CS53           CAN_0.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_0_ID53           CAN_0.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_0_B53            CAN_0.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_0_H53            CAN_0.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_0_W53            CAN_0.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_0_CS54           CAN_0.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_0_ID54           CAN_0.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_0_B54            CAN_0.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_0_H54            CAN_0.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_0_W54            CAN_0.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_0_CS55           CAN_0.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_0_ID55           CAN_0.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_0_B55            CAN_0.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_0_H55            CAN_0.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_0_W55            CAN_0.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_0_CS56           CAN_0.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_0_ID56           CAN_0.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_0_B56            CAN_0.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_0_H56            CAN_0.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_0_W56            CAN_0.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_0_CS57           CAN_0.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_0_ID57           CAN_0.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_0_B57            CAN_0.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_0_H57            CAN_0.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_0_W57            CAN_0.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_0_CS58           CAN_0.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_0_ID58           CAN_0.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_0_B58            CAN_0.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_0_H58            CAN_0.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_0_W58            CAN_0.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_0_CS59           CAN_0.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_0_ID59           CAN_0.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_0_B59            CAN_0.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_0_H59            CAN_0.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_0_W59            CAN_0.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_0_CS60           CAN_0.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_0_ID60           CAN_0.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_0_B60            CAN_0.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_0_H60            CAN_0.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_0_W60            CAN_0.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_0_CS61           CAN_0.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_0_ID61           CAN_0.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_0_B61            CAN_0.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_0_H61            CAN_0.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_0_W61            CAN_0.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_0_CS62           CAN_0.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_0_ID62           CAN_0.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_0_B62            CAN_0.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_0_H62            CAN_0.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_0_W62            CAN_0.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_0_CS63           CAN_0.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_0_ID63           CAN_0.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_0_B63            CAN_0.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_0_H63            CAN_0.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_0_W63            CAN_0.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_0_RXIMR0         CAN_0.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR1         CAN_0.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR2         CAN_0.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR3         CAN_0.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR4         CAN_0.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR5         CAN_0.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR6         CAN_0.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR7         CAN_0.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR8         CAN_0.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR9         CAN_0.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_0_RXIMR10        CAN_0.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR11        CAN_0.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR12        CAN_0.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR13        CAN_0.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR14        CAN_0.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR15        CAN_0.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR16        CAN_0.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR17        CAN_0.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR18        CAN_0.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR19        CAN_0.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR20        CAN_0.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR21        CAN_0.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR22        CAN_0.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR23        CAN_0.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR24        CAN_0.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR25        CAN_0.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR26        CAN_0.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR27        CAN_0.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR28        CAN_0.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR29        CAN_0.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR30        CAN_0.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR31        CAN_0.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR32        CAN_0.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR33        CAN_0.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR34        CAN_0.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR35        CAN_0.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR36        CAN_0.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR37        CAN_0.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR38        CAN_0.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR39        CAN_0.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR40        CAN_0.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR41        CAN_0.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR42        CAN_0.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR43        CAN_0.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR44        CAN_0.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR45        CAN_0.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR46        CAN_0.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR47        CAN_0.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR48        CAN_0.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR49        CAN_0.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR50        CAN_0.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR51        CAN_0.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR52        CAN_0.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR53        CAN_0.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR54        CAN_0.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR55        CAN_0.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR56        CAN_0.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR57        CAN_0.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR58        CAN_0.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR59        CAN_0.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR60        CAN_0.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR61        CAN_0.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR62        CAN_0.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_0_RXIMR63        CAN_0.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_0_MECR           CAN_0.MECR.R                  /* Memory Error Control Register */
#define CAN_0_ERRIAR         CAN_0.ERRIAR.R                /* Error Injection Address Register */
#define CAN_0_ERRIDPR        CAN_0.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_0_ERRIPPR        CAN_0.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_0_RERRAR         CAN_0.RERRAR.R                /* Error Report Address Register */
#define CAN_0_RERRDR         CAN_0.RERRDR.R                /* Error Report Data Register */
#define CAN_0_RERRSYNR       CAN_0.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_0_ERRSR          CAN_0.ERRSR.R                 /* Error Status Register */

#define CAN_1_MCR            CAN_1.MCR.R                   /* Module Configuration Register */
#define CAN_1_CTRL1          CAN_1.CTRL1.R                 /* Control 1 register */
#define CAN_1_TIMER          CAN_1.TIMER.R                 /* Free Running Timer */
#define CAN_1_RXMGMASK       CAN_1.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_1_RX14MASK       CAN_1.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_1_RX15MASK       CAN_1.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_1_ECR            CAN_1.ECR.R                   /* Error Counter */
#define CAN_1_ESR1           CAN_1.ESR1.R                  /* Error and Status 1 register */
#define CAN_1_IMASK2         CAN_1.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_1_IMASK1         CAN_1.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_1_IFLAG2         CAN_1.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_1_IFLAG1         CAN_1.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_1_CTRL2          CAN_1.CTRL2.R                 /* Control 2 register */
#define CAN_1_ESR2           CAN_1.ESR2.R                  /* Error and Status 2 register */
#define CAN_1_CRCR           CAN_1.CRCR.R                  /* CRC Register */
#define CAN_1_RXFGMASK       CAN_1.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_1_RXFIR          CAN_1.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_1_CS0            CAN_1.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_1_ID0            CAN_1.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_1_B0             CAN_1.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_1_H0             CAN_1.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_1_W0             CAN_1.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_1_CS1            CAN_1.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_1_ID1            CAN_1.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_1_B1             CAN_1.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_1_H1             CAN_1.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_1_W1             CAN_1.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_1_CS2            CAN_1.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_1_ID2            CAN_1.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_1_B2             CAN_1.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_1_H2             CAN_1.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_1_W2             CAN_1.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_1_CS3            CAN_1.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_1_ID3            CAN_1.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_1_B3             CAN_1.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_1_H3             CAN_1.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_1_W3             CAN_1.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_1_CS4            CAN_1.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_1_ID4            CAN_1.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_1_B4             CAN_1.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_1_H4             CAN_1.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_1_W4             CAN_1.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_1_CS5            CAN_1.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_1_ID5            CAN_1.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_1_B5             CAN_1.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_1_H5             CAN_1.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_1_W5             CAN_1.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_1_CS6            CAN_1.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_1_ID6            CAN_1.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_1_B6             CAN_1.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_1_H6             CAN_1.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_1_W6             CAN_1.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_1_CS7            CAN_1.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_1_ID7            CAN_1.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_1_B7             CAN_1.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_1_H7             CAN_1.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_1_W7             CAN_1.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_1_CS8            CAN_1.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_1_ID8            CAN_1.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_1_B8             CAN_1.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_1_H8             CAN_1.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_1_W8             CAN_1.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_1_CS9            CAN_1.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_1_ID9            CAN_1.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_1_B9             CAN_1.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_1_H9             CAN_1.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_1_W9             CAN_1.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_1_CS10           CAN_1.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_1_ID10           CAN_1.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_1_B10            CAN_1.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_1_H10            CAN_1.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_1_W10            CAN_1.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_1_CS11           CAN_1.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_1_ID11           CAN_1.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_1_B11            CAN_1.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_1_H11            CAN_1.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_1_W11            CAN_1.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_1_CS12           CAN_1.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_1_ID12           CAN_1.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_1_B12            CAN_1.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_1_H12            CAN_1.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_1_W12            CAN_1.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_1_CS13           CAN_1.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_1_ID13           CAN_1.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_1_B13            CAN_1.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_1_H13            CAN_1.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_1_W13            CAN_1.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_1_CS14           CAN_1.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_1_ID14           CAN_1.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_1_B14            CAN_1.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_1_H14            CAN_1.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_1_W14            CAN_1.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_1_CS15           CAN_1.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_1_ID15           CAN_1.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_1_B15            CAN_1.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_1_H15            CAN_1.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_1_W15            CAN_1.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_1_CS16           CAN_1.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_1_ID16           CAN_1.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_1_B16            CAN_1.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_1_H16            CAN_1.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_1_W16            CAN_1.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_1_CS17           CAN_1.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_1_ID17           CAN_1.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_1_B17            CAN_1.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_1_H17            CAN_1.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_1_W17            CAN_1.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_1_CS18           CAN_1.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_1_ID18           CAN_1.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_1_B18            CAN_1.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_1_H18            CAN_1.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_1_W18            CAN_1.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_1_CS19           CAN_1.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_1_ID19           CAN_1.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_1_B19            CAN_1.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_1_H19            CAN_1.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_1_W19            CAN_1.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_1_CS20           CAN_1.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_1_ID20           CAN_1.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_1_B20            CAN_1.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_1_H20            CAN_1.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_1_W20            CAN_1.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_1_CS21           CAN_1.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_1_ID21           CAN_1.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_1_B21            CAN_1.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_1_H21            CAN_1.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_1_W21            CAN_1.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_1_CS22           CAN_1.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_1_ID22           CAN_1.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_1_B22            CAN_1.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_1_H22            CAN_1.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_1_W22            CAN_1.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_1_CS23           CAN_1.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_1_ID23           CAN_1.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_1_B23            CAN_1.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_1_H23            CAN_1.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_1_W23            CAN_1.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_1_CS24           CAN_1.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_1_ID24           CAN_1.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_1_B24            CAN_1.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_1_H24            CAN_1.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_1_W24            CAN_1.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_1_CS25           CAN_1.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_1_ID25           CAN_1.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_1_B25            CAN_1.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_1_H25            CAN_1.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_1_W25            CAN_1.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_1_CS26           CAN_1.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_1_ID26           CAN_1.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_1_B26            CAN_1.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_1_H26            CAN_1.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_1_W26            CAN_1.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_1_CS27           CAN_1.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_1_ID27           CAN_1.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_1_B27            CAN_1.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_1_H27            CAN_1.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_1_W27            CAN_1.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_1_CS28           CAN_1.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_1_ID28           CAN_1.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_1_B28            CAN_1.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_1_H28            CAN_1.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_1_W28            CAN_1.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_1_CS29           CAN_1.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_1_ID29           CAN_1.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_1_B29            CAN_1.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_1_H29            CAN_1.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_1_W29            CAN_1.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_1_CS30           CAN_1.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_1_ID30           CAN_1.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_1_B30            CAN_1.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_1_H30            CAN_1.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_1_W30            CAN_1.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_1_CS31           CAN_1.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_1_ID31           CAN_1.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_1_B31            CAN_1.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_1_H31            CAN_1.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_1_W31            CAN_1.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_1_CS32           CAN_1.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_1_ID32           CAN_1.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_1_B32            CAN_1.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_1_H32            CAN_1.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_1_W32            CAN_1.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_1_CS33           CAN_1.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_1_ID33           CAN_1.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_1_B33            CAN_1.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_1_H33            CAN_1.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_1_W33            CAN_1.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_1_CS34           CAN_1.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_1_ID34           CAN_1.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_1_B34            CAN_1.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_1_H34            CAN_1.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_1_W34            CAN_1.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_1_CS35           CAN_1.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_1_ID35           CAN_1.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_1_B35            CAN_1.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_1_H35            CAN_1.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_1_W35            CAN_1.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_1_CS36           CAN_1.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_1_ID36           CAN_1.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_1_B36            CAN_1.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_1_H36            CAN_1.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_1_W36            CAN_1.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_1_CS37           CAN_1.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_1_ID37           CAN_1.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_1_B37            CAN_1.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_1_H37            CAN_1.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_1_W37            CAN_1.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_1_CS38           CAN_1.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_1_ID38           CAN_1.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_1_B38            CAN_1.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_1_H38            CAN_1.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_1_W38            CAN_1.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_1_CS39           CAN_1.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_1_ID39           CAN_1.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_1_B39            CAN_1.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_1_H39            CAN_1.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_1_W39            CAN_1.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_1_CS40           CAN_1.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_1_ID40           CAN_1.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_1_B40            CAN_1.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_1_H40            CAN_1.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_1_W40            CAN_1.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_1_CS41           CAN_1.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_1_ID41           CAN_1.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_1_B41            CAN_1.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_1_H41            CAN_1.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_1_W41            CAN_1.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_1_CS42           CAN_1.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_1_ID42           CAN_1.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_1_B42            CAN_1.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_1_H42            CAN_1.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_1_W42            CAN_1.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_1_CS43           CAN_1.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_1_ID43           CAN_1.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_1_B43            CAN_1.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_1_H43            CAN_1.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_1_W43            CAN_1.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_1_CS44           CAN_1.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_1_ID44           CAN_1.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_1_B44            CAN_1.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_1_H44            CAN_1.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_1_W44            CAN_1.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_1_CS45           CAN_1.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_1_ID45           CAN_1.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_1_B45            CAN_1.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_1_H45            CAN_1.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_1_W45            CAN_1.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_1_CS46           CAN_1.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_1_ID46           CAN_1.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_1_B46            CAN_1.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_1_H46            CAN_1.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_1_W46            CAN_1.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_1_CS47           CAN_1.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_1_ID47           CAN_1.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_1_B47            CAN_1.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_1_H47            CAN_1.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_1_W47            CAN_1.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_1_CS48           CAN_1.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_1_ID48           CAN_1.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_1_B48            CAN_1.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_1_H48            CAN_1.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_1_W48            CAN_1.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_1_CS49           CAN_1.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_1_ID49           CAN_1.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_1_B49            CAN_1.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_1_H49            CAN_1.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_1_W49            CAN_1.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_1_CS50           CAN_1.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_1_ID50           CAN_1.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_1_B50            CAN_1.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_1_H50            CAN_1.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_1_W50            CAN_1.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_1_CS51           CAN_1.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_1_ID51           CAN_1.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_1_B51            CAN_1.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_1_H51            CAN_1.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_1_W51            CAN_1.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_1_CS52           CAN_1.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_1_ID52           CAN_1.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_1_B52            CAN_1.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_1_H52            CAN_1.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_1_W52            CAN_1.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_1_CS53           CAN_1.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_1_ID53           CAN_1.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_1_B53            CAN_1.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_1_H53            CAN_1.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_1_W53            CAN_1.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_1_CS54           CAN_1.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_1_ID54           CAN_1.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_1_B54            CAN_1.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_1_H54            CAN_1.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_1_W54            CAN_1.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_1_CS55           CAN_1.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_1_ID55           CAN_1.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_1_B55            CAN_1.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_1_H55            CAN_1.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_1_W55            CAN_1.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_1_CS56           CAN_1.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_1_ID56           CAN_1.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_1_B56            CAN_1.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_1_H56            CAN_1.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_1_W56            CAN_1.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_1_CS57           CAN_1.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_1_ID57           CAN_1.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_1_B57            CAN_1.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_1_H57            CAN_1.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_1_W57            CAN_1.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_1_CS58           CAN_1.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_1_ID58           CAN_1.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_1_B58            CAN_1.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_1_H58            CAN_1.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_1_W58            CAN_1.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_1_CS59           CAN_1.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_1_ID59           CAN_1.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_1_B59            CAN_1.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_1_H59            CAN_1.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_1_W59            CAN_1.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_1_CS60           CAN_1.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_1_ID60           CAN_1.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_1_B60            CAN_1.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_1_H60            CAN_1.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_1_W60            CAN_1.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_1_CS61           CAN_1.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_1_ID61           CAN_1.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_1_B61            CAN_1.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_1_H61            CAN_1.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_1_W61            CAN_1.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_1_CS62           CAN_1.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_1_ID62           CAN_1.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_1_B62            CAN_1.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_1_H62            CAN_1.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_1_W62            CAN_1.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_1_CS63           CAN_1.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_1_ID63           CAN_1.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_1_B63            CAN_1.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_1_H63            CAN_1.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_1_W63            CAN_1.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_1_RXIMR0         CAN_1.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR1         CAN_1.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR2         CAN_1.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR3         CAN_1.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR4         CAN_1.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR5         CAN_1.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR6         CAN_1.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR7         CAN_1.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR8         CAN_1.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR9         CAN_1.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_1_RXIMR10        CAN_1.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR11        CAN_1.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR12        CAN_1.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR13        CAN_1.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR14        CAN_1.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR15        CAN_1.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR16        CAN_1.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR17        CAN_1.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR18        CAN_1.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR19        CAN_1.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR20        CAN_1.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR21        CAN_1.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR22        CAN_1.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR23        CAN_1.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR24        CAN_1.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR25        CAN_1.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR26        CAN_1.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR27        CAN_1.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR28        CAN_1.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR29        CAN_1.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR30        CAN_1.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR31        CAN_1.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR32        CAN_1.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR33        CAN_1.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR34        CAN_1.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR35        CAN_1.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR36        CAN_1.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR37        CAN_1.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR38        CAN_1.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR39        CAN_1.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR40        CAN_1.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR41        CAN_1.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR42        CAN_1.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR43        CAN_1.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR44        CAN_1.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR45        CAN_1.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR46        CAN_1.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR47        CAN_1.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR48        CAN_1.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR49        CAN_1.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR50        CAN_1.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR51        CAN_1.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR52        CAN_1.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR53        CAN_1.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR54        CAN_1.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR55        CAN_1.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR56        CAN_1.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR57        CAN_1.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR58        CAN_1.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR59        CAN_1.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR60        CAN_1.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR61        CAN_1.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR62        CAN_1.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_1_RXIMR63        CAN_1.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_1_MECR           CAN_1.MECR.R                  /* Memory Error Control Register */
#define CAN_1_ERRIAR         CAN_1.ERRIAR.R                /* Error Injection Address Register */
#define CAN_1_ERRIDPR        CAN_1.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_1_ERRIPPR        CAN_1.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_1_RERRAR         CAN_1.RERRAR.R                /* Error Report Address Register */
#define CAN_1_RERRDR         CAN_1.RERRDR.R                /* Error Report Data Register */
#define CAN_1_RERRSYNR       CAN_1.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_1_ERRSR          CAN_1.ERRSR.R                 /* Error Status Register */

#define CAN_2_MCR            CAN_2.MCR.R                   /* Module Configuration Register */
#define CAN_2_CTRL1          CAN_2.CTRL1.R                 /* Control 1 register */
#define CAN_2_TIMER          CAN_2.TIMER.R                 /* Free Running Timer */
#define CAN_2_RXMGMASK       CAN_2.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_2_RX14MASK       CAN_2.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_2_RX15MASK       CAN_2.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_2_ECR            CAN_2.ECR.R                   /* Error Counter */
#define CAN_2_ESR1           CAN_2.ESR1.R                  /* Error and Status 1 register */
#define CAN_2_IMASK2         CAN_2.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_2_IMASK1         CAN_2.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_2_IFLAG2         CAN_2.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_2_IFLAG1         CAN_2.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_2_CTRL2          CAN_2.CTRL2.R                 /* Control 2 register */
#define CAN_2_ESR2           CAN_2.ESR2.R                  /* Error and Status 2 register */
#define CAN_2_CRCR           CAN_2.CRCR.R                  /* CRC Register */
#define CAN_2_RXFGMASK       CAN_2.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_2_RXFIR          CAN_2.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_2_CS0            CAN_2.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_2_ID0            CAN_2.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_2_B0             CAN_2.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_2_H0             CAN_2.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_2_W0             CAN_2.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_2_CS1            CAN_2.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_2_ID1            CAN_2.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_2_B1             CAN_2.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_2_H1             CAN_2.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_2_W1             CAN_2.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_2_CS2            CAN_2.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_2_ID2            CAN_2.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_2_B2             CAN_2.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_2_H2             CAN_2.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_2_W2             CAN_2.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_2_CS3            CAN_2.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_2_ID3            CAN_2.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_2_B3             CAN_2.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_2_H3             CAN_2.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_2_W3             CAN_2.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_2_CS4            CAN_2.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_2_ID4            CAN_2.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_2_B4             CAN_2.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_2_H4             CAN_2.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_2_W4             CAN_2.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_2_CS5            CAN_2.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_2_ID5            CAN_2.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_2_B5             CAN_2.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_2_H5             CAN_2.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_2_W5             CAN_2.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_2_CS6            CAN_2.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_2_ID6            CAN_2.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_2_B6             CAN_2.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_2_H6             CAN_2.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_2_W6             CAN_2.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_2_CS7            CAN_2.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_2_ID7            CAN_2.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_2_B7             CAN_2.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_2_H7             CAN_2.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_2_W7             CAN_2.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_2_CS8            CAN_2.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_2_ID8            CAN_2.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_2_B8             CAN_2.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_2_H8             CAN_2.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_2_W8             CAN_2.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_2_CS9            CAN_2.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_2_ID9            CAN_2.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_2_B9             CAN_2.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_2_H9             CAN_2.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_2_W9             CAN_2.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_2_CS10           CAN_2.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_2_ID10           CAN_2.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_2_B10            CAN_2.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_2_H10            CAN_2.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_2_W10            CAN_2.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_2_CS11           CAN_2.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_2_ID11           CAN_2.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_2_B11            CAN_2.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_2_H11            CAN_2.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_2_W11            CAN_2.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_2_CS12           CAN_2.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_2_ID12           CAN_2.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_2_B12            CAN_2.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_2_H12            CAN_2.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_2_W12            CAN_2.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_2_CS13           CAN_2.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_2_ID13           CAN_2.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_2_B13            CAN_2.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_2_H13            CAN_2.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_2_W13            CAN_2.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_2_CS14           CAN_2.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_2_ID14           CAN_2.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_2_B14            CAN_2.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_2_H14            CAN_2.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_2_W14            CAN_2.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_2_CS15           CAN_2.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_2_ID15           CAN_2.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_2_B15            CAN_2.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_2_H15            CAN_2.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_2_W15            CAN_2.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_2_CS16           CAN_2.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_2_ID16           CAN_2.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_2_B16            CAN_2.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_2_H16            CAN_2.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_2_W16            CAN_2.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_2_CS17           CAN_2.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_2_ID17           CAN_2.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_2_B17            CAN_2.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_2_H17            CAN_2.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_2_W17            CAN_2.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_2_CS18           CAN_2.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_2_ID18           CAN_2.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_2_B18            CAN_2.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_2_H18            CAN_2.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_2_W18            CAN_2.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_2_CS19           CAN_2.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_2_ID19           CAN_2.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_2_B19            CAN_2.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_2_H19            CAN_2.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_2_W19            CAN_2.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_2_CS20           CAN_2.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_2_ID20           CAN_2.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_2_B20            CAN_2.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_2_H20            CAN_2.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_2_W20            CAN_2.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_2_CS21           CAN_2.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_2_ID21           CAN_2.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_2_B21            CAN_2.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_2_H21            CAN_2.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_2_W21            CAN_2.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_2_CS22           CAN_2.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_2_ID22           CAN_2.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_2_B22            CAN_2.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_2_H22            CAN_2.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_2_W22            CAN_2.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_2_CS23           CAN_2.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_2_ID23           CAN_2.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_2_B23            CAN_2.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_2_H23            CAN_2.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_2_W23            CAN_2.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_2_CS24           CAN_2.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_2_ID24           CAN_2.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_2_B24            CAN_2.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_2_H24            CAN_2.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_2_W24            CAN_2.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_2_CS25           CAN_2.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_2_ID25           CAN_2.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_2_B25            CAN_2.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_2_H25            CAN_2.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_2_W25            CAN_2.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_2_CS26           CAN_2.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_2_ID26           CAN_2.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_2_B26            CAN_2.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_2_H26            CAN_2.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_2_W26            CAN_2.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_2_CS27           CAN_2.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_2_ID27           CAN_2.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_2_B27            CAN_2.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_2_H27            CAN_2.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_2_W27            CAN_2.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_2_CS28           CAN_2.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_2_ID28           CAN_2.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_2_B28            CAN_2.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_2_H28            CAN_2.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_2_W28            CAN_2.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_2_CS29           CAN_2.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_2_ID29           CAN_2.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_2_B29            CAN_2.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_2_H29            CAN_2.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_2_W29            CAN_2.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_2_CS30           CAN_2.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_2_ID30           CAN_2.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_2_B30            CAN_2.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_2_H30            CAN_2.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_2_W30            CAN_2.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_2_CS31           CAN_2.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_2_ID31           CAN_2.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_2_B31            CAN_2.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_2_H31            CAN_2.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_2_W31            CAN_2.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_2_CS32           CAN_2.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_2_ID32           CAN_2.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_2_B32            CAN_2.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_2_H32            CAN_2.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_2_W32            CAN_2.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_2_CS33           CAN_2.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_2_ID33           CAN_2.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_2_B33            CAN_2.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_2_H33            CAN_2.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_2_W33            CAN_2.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_2_CS34           CAN_2.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_2_ID34           CAN_2.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_2_B34            CAN_2.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_2_H34            CAN_2.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_2_W34            CAN_2.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_2_CS35           CAN_2.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_2_ID35           CAN_2.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_2_B35            CAN_2.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_2_H35            CAN_2.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_2_W35            CAN_2.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_2_CS36           CAN_2.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_2_ID36           CAN_2.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_2_B36            CAN_2.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_2_H36            CAN_2.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_2_W36            CAN_2.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_2_CS37           CAN_2.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_2_ID37           CAN_2.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_2_B37            CAN_2.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_2_H37            CAN_2.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_2_W37            CAN_2.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_2_CS38           CAN_2.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_2_ID38           CAN_2.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_2_B38            CAN_2.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_2_H38            CAN_2.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_2_W38            CAN_2.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_2_CS39           CAN_2.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_2_ID39           CAN_2.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_2_B39            CAN_2.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_2_H39            CAN_2.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_2_W39            CAN_2.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_2_CS40           CAN_2.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_2_ID40           CAN_2.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_2_B40            CAN_2.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_2_H40            CAN_2.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_2_W40            CAN_2.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_2_CS41           CAN_2.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_2_ID41           CAN_2.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_2_B41            CAN_2.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_2_H41            CAN_2.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_2_W41            CAN_2.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_2_CS42           CAN_2.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_2_ID42           CAN_2.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_2_B42            CAN_2.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_2_H42            CAN_2.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_2_W42            CAN_2.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_2_CS43           CAN_2.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_2_ID43           CAN_2.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_2_B43            CAN_2.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_2_H43            CAN_2.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_2_W43            CAN_2.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_2_CS44           CAN_2.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_2_ID44           CAN_2.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_2_B44            CAN_2.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_2_H44            CAN_2.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_2_W44            CAN_2.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_2_CS45           CAN_2.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_2_ID45           CAN_2.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_2_B45            CAN_2.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_2_H45            CAN_2.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_2_W45            CAN_2.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_2_CS46           CAN_2.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_2_ID46           CAN_2.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_2_B46            CAN_2.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_2_H46            CAN_2.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_2_W46            CAN_2.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_2_CS47           CAN_2.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_2_ID47           CAN_2.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_2_B47            CAN_2.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_2_H47            CAN_2.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_2_W47            CAN_2.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_2_CS48           CAN_2.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_2_ID48           CAN_2.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_2_B48            CAN_2.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_2_H48            CAN_2.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_2_W48            CAN_2.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_2_CS49           CAN_2.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_2_ID49           CAN_2.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_2_B49            CAN_2.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_2_H49            CAN_2.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_2_W49            CAN_2.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_2_CS50           CAN_2.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_2_ID50           CAN_2.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_2_B50            CAN_2.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_2_H50            CAN_2.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_2_W50            CAN_2.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_2_CS51           CAN_2.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_2_ID51           CAN_2.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_2_B51            CAN_2.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_2_H51            CAN_2.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_2_W51            CAN_2.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_2_CS52           CAN_2.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_2_ID52           CAN_2.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_2_B52            CAN_2.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_2_H52            CAN_2.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_2_W52            CAN_2.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_2_CS53           CAN_2.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_2_ID53           CAN_2.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_2_B53            CAN_2.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_2_H53            CAN_2.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_2_W53            CAN_2.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_2_CS54           CAN_2.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_2_ID54           CAN_2.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_2_B54            CAN_2.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_2_H54            CAN_2.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_2_W54            CAN_2.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_2_CS55           CAN_2.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_2_ID55           CAN_2.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_2_B55            CAN_2.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_2_H55            CAN_2.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_2_W55            CAN_2.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_2_CS56           CAN_2.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_2_ID56           CAN_2.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_2_B56            CAN_2.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_2_H56            CAN_2.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_2_W56            CAN_2.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_2_CS57           CAN_2.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_2_ID57           CAN_2.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_2_B57            CAN_2.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_2_H57            CAN_2.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_2_W57            CAN_2.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_2_CS58           CAN_2.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_2_ID58           CAN_2.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_2_B58            CAN_2.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_2_H58            CAN_2.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_2_W58            CAN_2.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_2_CS59           CAN_2.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_2_ID59           CAN_2.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_2_B59            CAN_2.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_2_H59            CAN_2.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_2_W59            CAN_2.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_2_CS60           CAN_2.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_2_ID60           CAN_2.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_2_B60            CAN_2.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_2_H60            CAN_2.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_2_W60            CAN_2.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_2_CS61           CAN_2.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_2_ID61           CAN_2.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_2_B61            CAN_2.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_2_H61            CAN_2.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_2_W61            CAN_2.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_2_CS62           CAN_2.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_2_ID62           CAN_2.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_2_B62            CAN_2.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_2_H62            CAN_2.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_2_W62            CAN_2.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_2_CS63           CAN_2.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_2_ID63           CAN_2.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_2_B63            CAN_2.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_2_H63            CAN_2.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_2_W63            CAN_2.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_2_RXIMR0         CAN_2.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR1         CAN_2.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR2         CAN_2.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR3         CAN_2.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR4         CAN_2.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR5         CAN_2.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR6         CAN_2.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR7         CAN_2.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR8         CAN_2.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR9         CAN_2.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_2_RXIMR10        CAN_2.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR11        CAN_2.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR12        CAN_2.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR13        CAN_2.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR14        CAN_2.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR15        CAN_2.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR16        CAN_2.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR17        CAN_2.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR18        CAN_2.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR19        CAN_2.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR20        CAN_2.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR21        CAN_2.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR22        CAN_2.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR23        CAN_2.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR24        CAN_2.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR25        CAN_2.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR26        CAN_2.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR27        CAN_2.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR28        CAN_2.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR29        CAN_2.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR30        CAN_2.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR31        CAN_2.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR32        CAN_2.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR33        CAN_2.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR34        CAN_2.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR35        CAN_2.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR36        CAN_2.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR37        CAN_2.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR38        CAN_2.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR39        CAN_2.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR40        CAN_2.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR41        CAN_2.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR42        CAN_2.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR43        CAN_2.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR44        CAN_2.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR45        CAN_2.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR46        CAN_2.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR47        CAN_2.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR48        CAN_2.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR49        CAN_2.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR50        CAN_2.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR51        CAN_2.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR52        CAN_2.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR53        CAN_2.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR54        CAN_2.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR55        CAN_2.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR56        CAN_2.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR57        CAN_2.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR58        CAN_2.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR59        CAN_2.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR60        CAN_2.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR61        CAN_2.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR62        CAN_2.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_2_RXIMR63        CAN_2.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_2_MECR           CAN_2.MECR.R                  /* Memory Error Control Register */
#define CAN_2_ERRIAR         CAN_2.ERRIAR.R                /* Error Injection Address Register */
#define CAN_2_ERRIDPR        CAN_2.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_2_ERRIPPR        CAN_2.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_2_RERRAR         CAN_2.RERRAR.R                /* Error Report Address Register */
#define CAN_2_RERRDR         CAN_2.RERRDR.R                /* Error Report Data Register */
#define CAN_2_RERRSYNR       CAN_2.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_2_ERRSR          CAN_2.ERRSR.R                 /* Error Status Register */

#define CAN_3_MCR            CAN_3.MCR.R                   /* Module Configuration Register */
#define CAN_3_CTRL1          CAN_3.CTRL1.R                 /* Control 1 register */
#define CAN_3_TIMER          CAN_3.TIMER.R                 /* Free Running Timer */
#define CAN_3_RXMGMASK       CAN_3.RXMGMASK.R              /* Rx Mailboxes Global Mask Register */
#define CAN_3_RX14MASK       CAN_3.RX14MASK.R              /* Rx 14 Mask register */
#define CAN_3_RX15MASK       CAN_3.RX15MASK.R              /* Rx 15 Mask register */
#define CAN_3_ECR            CAN_3.ECR.R                   /* Error Counter */
#define CAN_3_ESR1           CAN_3.ESR1.R                  /* Error and Status 1 register */
#define CAN_3_IMASK2         CAN_3.IMASK2.R                /* Interrupt Masks 2 register */
#define CAN_3_IMASK1         CAN_3.IMASK1.R                /* Interrupt Masks 1 register */
#define CAN_3_IFLAG2         CAN_3.IFLAG2.R                /* Interrupt Flags 2 register */
#define CAN_3_IFLAG1         CAN_3.IFLAG1.R                /* Interrupt Flags 1 register */
#define CAN_3_CTRL2          CAN_3.CTRL2.R                 /* Control 2 register */
#define CAN_3_ESR2           CAN_3.ESR2.R                  /* Error and Status 2 register */
#define CAN_3_CRCR           CAN_3.CRCR.R                  /* CRC Register */
#define CAN_3_RXFGMASK       CAN_3.RXFGMASK.R              /* Rx FIFO Global Mask register */
#define CAN_3_RXFIR          CAN_3.RXFIR.R                 /* Rx FIFO Information Register */
#define CAN_3_CS0            CAN_3.MB[0].CS.R              /* Message Buffer 0 CS Register */
#define CAN_3_ID0            CAN_3.MB[0].ID.R              /* Message Buffer 0 ID Register */
#define CAN_3_B0             CAN_3.MB[0].DATA.B            /* Message Buffer 0 B Register */
#define CAN_3_H0             CAN_3.MB[0].DATA.H            /* Message Buffer 0 H Register */
#define CAN_3_W0             CAN_3.MB[0].DATA.W            /* Message Buffer 0 W Register */
#define CAN_3_CS1            CAN_3.MB[1].CS.R              /* Message Buffer 1 CS Register */
#define CAN_3_ID1            CAN_3.MB[1].ID.R              /* Message Buffer 1 ID Register */
#define CAN_3_B1             CAN_3.MB[1].DATA.B            /* Message Buffer 1 B Register */
#define CAN_3_H1             CAN_3.MB[1].DATA.H            /* Message Buffer 1 H Register */
#define CAN_3_W1             CAN_3.MB[1].DATA.W            /* Message Buffer 1 W Register */
#define CAN_3_CS2            CAN_3.MB[2].CS.R              /* Message Buffer 2 CS Register */
#define CAN_3_ID2            CAN_3.MB[2].ID.R              /* Message Buffer 2 ID Register */
#define CAN_3_B2             CAN_3.MB[2].DATA.B            /* Message Buffer 2 B Register */
#define CAN_3_H2             CAN_3.MB[2].DATA.H            /* Message Buffer 2 H Register */
#define CAN_3_W2             CAN_3.MB[2].DATA.W            /* Message Buffer 2 W Register */
#define CAN_3_CS3            CAN_3.MB[3].CS.R              /* Message Buffer 3 CS Register */
#define CAN_3_ID3            CAN_3.MB[3].ID.R              /* Message Buffer 3 ID Register */
#define CAN_3_B3             CAN_3.MB[3].DATA.B            /* Message Buffer 3 B Register */
#define CAN_3_H3             CAN_3.MB[3].DATA.H            /* Message Buffer 3 H Register */
#define CAN_3_W3             CAN_3.MB[3].DATA.W            /* Message Buffer 3 W Register */
#define CAN_3_CS4            CAN_3.MB[4].CS.R              /* Message Buffer 4 CS Register */
#define CAN_3_ID4            CAN_3.MB[4].ID.R              /* Message Buffer 4 ID Register */
#define CAN_3_B4             CAN_3.MB[4].DATA.B            /* Message Buffer 4 B Register */
#define CAN_3_H4             CAN_3.MB[4].DATA.H            /* Message Buffer 4 H Register */
#define CAN_3_W4             CAN_3.MB[4].DATA.W            /* Message Buffer 4 W Register */
#define CAN_3_CS5            CAN_3.MB[5].CS.R              /* Message Buffer 5 CS Register */
#define CAN_3_ID5            CAN_3.MB[5].ID.R              /* Message Buffer 5 ID Register */
#define CAN_3_B5             CAN_3.MB[5].DATA.B            /* Message Buffer 5 B Register */
#define CAN_3_H5             CAN_3.MB[5].DATA.H            /* Message Buffer 5 H Register */
#define CAN_3_W5             CAN_3.MB[5].DATA.W            /* Message Buffer 5 W Register */
#define CAN_3_CS6            CAN_3.MB[6].CS.R              /* Message Buffer 6 CS Register */
#define CAN_3_ID6            CAN_3.MB[6].ID.R              /* Message Buffer 6 ID Register */
#define CAN_3_B6             CAN_3.MB[6].DATA.B            /* Message Buffer 6 B Register */
#define CAN_3_H6             CAN_3.MB[6].DATA.H            /* Message Buffer 6 H Register */
#define CAN_3_W6             CAN_3.MB[6].DATA.W            /* Message Buffer 6 W Register */
#define CAN_3_CS7            CAN_3.MB[7].CS.R              /* Message Buffer 7 CS Register */
#define CAN_3_ID7            CAN_3.MB[7].ID.R              /* Message Buffer 7 ID Register */
#define CAN_3_B7             CAN_3.MB[7].DATA.B            /* Message Buffer 7 B Register */
#define CAN_3_H7             CAN_3.MB[7].DATA.H            /* Message Buffer 7 H Register */
#define CAN_3_W7             CAN_3.MB[7].DATA.W            /* Message Buffer 7 W Register */
#define CAN_3_CS8            CAN_3.MB[8].CS.R              /* Message Buffer 8 CS Register */
#define CAN_3_ID8            CAN_3.MB[8].ID.R              /* Message Buffer 8 ID Register */
#define CAN_3_B8             CAN_3.MB[8].DATA.B            /* Message Buffer 8 B Register */
#define CAN_3_H8             CAN_3.MB[8].DATA.H            /* Message Buffer 8 H Register */
#define CAN_3_W8             CAN_3.MB[8].DATA.W            /* Message Buffer 8 W Register */
#define CAN_3_CS9            CAN_3.MB[9].CS.R              /* Message Buffer 9 CS Register */
#define CAN_3_ID9            CAN_3.MB[9].ID.R              /* Message Buffer 9 ID Register */
#define CAN_3_B9             CAN_3.MB[9].DATA.B            /* Message Buffer 9 B Register */
#define CAN_3_H9             CAN_3.MB[9].DATA.H            /* Message Buffer 9 H Register */
#define CAN_3_W9             CAN_3.MB[9].DATA.W            /* Message Buffer 9 W Register */
#define CAN_3_CS10           CAN_3.MB[10].CS.R             /* Message Buffer 10 CS Register */
#define CAN_3_ID10           CAN_3.MB[10].ID.R             /* Message Buffer 10 ID Register */
#define CAN_3_B10            CAN_3.MB[10].DATA.B           /* Message Buffer 10 B Register */
#define CAN_3_H10            CAN_3.MB[10].DATA.H           /* Message Buffer 10 H Register */
#define CAN_3_W10            CAN_3.MB[10].DATA.W           /* Message Buffer 10 W Register */
#define CAN_3_CS11           CAN_3.MB[11].CS.R             /* Message Buffer 11 CS Register */
#define CAN_3_ID11           CAN_3.MB[11].ID.R             /* Message Buffer 11 ID Register */
#define CAN_3_B11            CAN_3.MB[11].DATA.B           /* Message Buffer 11 B Register */
#define CAN_3_H11            CAN_3.MB[11].DATA.H           /* Message Buffer 11 H Register */
#define CAN_3_W11            CAN_3.MB[11].DATA.W           /* Message Buffer 11 W Register */
#define CAN_3_CS12           CAN_3.MB[12].CS.R             /* Message Buffer 12 CS Register */
#define CAN_3_ID12           CAN_3.MB[12].ID.R             /* Message Buffer 12 ID Register */
#define CAN_3_B12            CAN_3.MB[12].DATA.B           /* Message Buffer 12 B Register */
#define CAN_3_H12            CAN_3.MB[12].DATA.H           /* Message Buffer 12 H Register */
#define CAN_3_W12            CAN_3.MB[12].DATA.W           /* Message Buffer 12 W Register */
#define CAN_3_CS13           CAN_3.MB[13].CS.R             /* Message Buffer 13 CS Register */
#define CAN_3_ID13           CAN_3.MB[13].ID.R             /* Message Buffer 13 ID Register */
#define CAN_3_B13            CAN_3.MB[13].DATA.B           /* Message Buffer 13 B Register */
#define CAN_3_H13            CAN_3.MB[13].DATA.H           /* Message Buffer 13 H Register */
#define CAN_3_W13            CAN_3.MB[13].DATA.W           /* Message Buffer 13 W Register */
#define CAN_3_CS14           CAN_3.MB[14].CS.R             /* Message Buffer 14 CS Register */
#define CAN_3_ID14           CAN_3.MB[14].ID.R             /* Message Buffer 14 ID Register */
#define CAN_3_B14            CAN_3.MB[14].DATA.B           /* Message Buffer 14 B Register */
#define CAN_3_H14            CAN_3.MB[14].DATA.H           /* Message Buffer 14 H Register */
#define CAN_3_W14            CAN_3.MB[14].DATA.W           /* Message Buffer 14 W Register */
#define CAN_3_CS15           CAN_3.MB[15].CS.R             /* Message Buffer 15 CS Register */
#define CAN_3_ID15           CAN_3.MB[15].ID.R             /* Message Buffer 15 ID Register */
#define CAN_3_B15            CAN_3.MB[15].DATA.B           /* Message Buffer 15 B Register */
#define CAN_3_H15            CAN_3.MB[15].DATA.H           /* Message Buffer 15 H Register */
#define CAN_3_W15            CAN_3.MB[15].DATA.W           /* Message Buffer 15 W Register */
#define CAN_3_CS16           CAN_3.MB[16].CS.R             /* Message Buffer 16 CS Register */
#define CAN_3_ID16           CAN_3.MB[16].ID.R             /* Message Buffer 16 ID Register */
#define CAN_3_B16            CAN_3.MB[16].DATA.B           /* Message Buffer 16 B Register */
#define CAN_3_H16            CAN_3.MB[16].DATA.H           /* Message Buffer 16 H Register */
#define CAN_3_W16            CAN_3.MB[16].DATA.W           /* Message Buffer 16 W Register */
#define CAN_3_CS17           CAN_3.MB[17].CS.R             /* Message Buffer 17 CS Register */
#define CAN_3_ID17           CAN_3.MB[17].ID.R             /* Message Buffer 17 ID Register */
#define CAN_3_B17            CAN_3.MB[17].DATA.B           /* Message Buffer 17 B Register */
#define CAN_3_H17            CAN_3.MB[17].DATA.H           /* Message Buffer 17 H Register */
#define CAN_3_W17            CAN_3.MB[17].DATA.W           /* Message Buffer 17 W Register */
#define CAN_3_CS18           CAN_3.MB[18].CS.R             /* Message Buffer 18 CS Register */
#define CAN_3_ID18           CAN_3.MB[18].ID.R             /* Message Buffer 18 ID Register */
#define CAN_3_B18            CAN_3.MB[18].DATA.B           /* Message Buffer 18 B Register */
#define CAN_3_H18            CAN_3.MB[18].DATA.H           /* Message Buffer 18 H Register */
#define CAN_3_W18            CAN_3.MB[18].DATA.W           /* Message Buffer 18 W Register */
#define CAN_3_CS19           CAN_3.MB[19].CS.R             /* Message Buffer 19 CS Register */
#define CAN_3_ID19           CAN_3.MB[19].ID.R             /* Message Buffer 19 ID Register */
#define CAN_3_B19            CAN_3.MB[19].DATA.B           /* Message Buffer 19 B Register */
#define CAN_3_H19            CAN_3.MB[19].DATA.H           /* Message Buffer 19 H Register */
#define CAN_3_W19            CAN_3.MB[19].DATA.W           /* Message Buffer 19 W Register */
#define CAN_3_CS20           CAN_3.MB[20].CS.R             /* Message Buffer 20 CS Register */
#define CAN_3_ID20           CAN_3.MB[20].ID.R             /* Message Buffer 20 ID Register */
#define CAN_3_B20            CAN_3.MB[20].DATA.B           /* Message Buffer 20 B Register */
#define CAN_3_H20            CAN_3.MB[20].DATA.H           /* Message Buffer 20 H Register */
#define CAN_3_W20            CAN_3.MB[20].DATA.W           /* Message Buffer 20 W Register */
#define CAN_3_CS21           CAN_3.MB[21].CS.R             /* Message Buffer 21 CS Register */
#define CAN_3_ID21           CAN_3.MB[21].ID.R             /* Message Buffer 21 ID Register */
#define CAN_3_B21            CAN_3.MB[21].DATA.B           /* Message Buffer 21 B Register */
#define CAN_3_H21            CAN_3.MB[21].DATA.H           /* Message Buffer 21 H Register */
#define CAN_3_W21            CAN_3.MB[21].DATA.W           /* Message Buffer 21 W Register */
#define CAN_3_CS22           CAN_3.MB[22].CS.R             /* Message Buffer 22 CS Register */
#define CAN_3_ID22           CAN_3.MB[22].ID.R             /* Message Buffer 22 ID Register */
#define CAN_3_B22            CAN_3.MB[22].DATA.B           /* Message Buffer 22 B Register */
#define CAN_3_H22            CAN_3.MB[22].DATA.H           /* Message Buffer 22 H Register */
#define CAN_3_W22            CAN_3.MB[22].DATA.W           /* Message Buffer 22 W Register */
#define CAN_3_CS23           CAN_3.MB[23].CS.R             /* Message Buffer 23 CS Register */
#define CAN_3_ID23           CAN_3.MB[23].ID.R             /* Message Buffer 23 ID Register */
#define CAN_3_B23            CAN_3.MB[23].DATA.B           /* Message Buffer 23 B Register */
#define CAN_3_H23            CAN_3.MB[23].DATA.H           /* Message Buffer 23 H Register */
#define CAN_3_W23            CAN_3.MB[23].DATA.W           /* Message Buffer 23 W Register */
#define CAN_3_CS24           CAN_3.MB[24].CS.R             /* Message Buffer 24 CS Register */
#define CAN_3_ID24           CAN_3.MB[24].ID.R             /* Message Buffer 24 ID Register */
#define CAN_3_B24            CAN_3.MB[24].DATA.B           /* Message Buffer 24 B Register */
#define CAN_3_H24            CAN_3.MB[24].DATA.H           /* Message Buffer 24 H Register */
#define CAN_3_W24            CAN_3.MB[24].DATA.W           /* Message Buffer 24 W Register */
#define CAN_3_CS25           CAN_3.MB[25].CS.R             /* Message Buffer 25 CS Register */
#define CAN_3_ID25           CAN_3.MB[25].ID.R             /* Message Buffer 25 ID Register */
#define CAN_3_B25            CAN_3.MB[25].DATA.B           /* Message Buffer 25 B Register */
#define CAN_3_H25            CAN_3.MB[25].DATA.H           /* Message Buffer 25 H Register */
#define CAN_3_W25            CAN_3.MB[25].DATA.W           /* Message Buffer 25 W Register */
#define CAN_3_CS26           CAN_3.MB[26].CS.R             /* Message Buffer 26 CS Register */
#define CAN_3_ID26           CAN_3.MB[26].ID.R             /* Message Buffer 26 ID Register */
#define CAN_3_B26            CAN_3.MB[26].DATA.B           /* Message Buffer 26 B Register */
#define CAN_3_H26            CAN_3.MB[26].DATA.H           /* Message Buffer 26 H Register */
#define CAN_3_W26            CAN_3.MB[26].DATA.W           /* Message Buffer 26 W Register */
#define CAN_3_CS27           CAN_3.MB[27].CS.R             /* Message Buffer 27 CS Register */
#define CAN_3_ID27           CAN_3.MB[27].ID.R             /* Message Buffer 27 ID Register */
#define CAN_3_B27            CAN_3.MB[27].DATA.B           /* Message Buffer 27 B Register */
#define CAN_3_H27            CAN_3.MB[27].DATA.H           /* Message Buffer 27 H Register */
#define CAN_3_W27            CAN_3.MB[27].DATA.W           /* Message Buffer 27 W Register */
#define CAN_3_CS28           CAN_3.MB[28].CS.R             /* Message Buffer 28 CS Register */
#define CAN_3_ID28           CAN_3.MB[28].ID.R             /* Message Buffer 28 ID Register */
#define CAN_3_B28            CAN_3.MB[28].DATA.B           /* Message Buffer 28 B Register */
#define CAN_3_H28            CAN_3.MB[28].DATA.H           /* Message Buffer 28 H Register */
#define CAN_3_W28            CAN_3.MB[28].DATA.W           /* Message Buffer 28 W Register */
#define CAN_3_CS29           CAN_3.MB[29].CS.R             /* Message Buffer 29 CS Register */
#define CAN_3_ID29           CAN_3.MB[29].ID.R             /* Message Buffer 29 ID Register */
#define CAN_3_B29            CAN_3.MB[29].DATA.B           /* Message Buffer 29 B Register */
#define CAN_3_H29            CAN_3.MB[29].DATA.H           /* Message Buffer 29 H Register */
#define CAN_3_W29            CAN_3.MB[29].DATA.W           /* Message Buffer 29 W Register */
#define CAN_3_CS30           CAN_3.MB[30].CS.R             /* Message Buffer 30 CS Register */
#define CAN_3_ID30           CAN_3.MB[30].ID.R             /* Message Buffer 30 ID Register */
#define CAN_3_B30            CAN_3.MB[30].DATA.B           /* Message Buffer 30 B Register */
#define CAN_3_H30            CAN_3.MB[30].DATA.H           /* Message Buffer 30 H Register */
#define CAN_3_W30            CAN_3.MB[30].DATA.W           /* Message Buffer 30 W Register */
#define CAN_3_CS31           CAN_3.MB[31].CS.R             /* Message Buffer 31 CS Register */
#define CAN_3_ID31           CAN_3.MB[31].ID.R             /* Message Buffer 31 ID Register */
#define CAN_3_B31            CAN_3.MB[31].DATA.B           /* Message Buffer 31 B Register */
#define CAN_3_H31            CAN_3.MB[31].DATA.H           /* Message Buffer 31 H Register */
#define CAN_3_W31            CAN_3.MB[31].DATA.W           /* Message Buffer 31 W Register */
#define CAN_3_CS32           CAN_3.MB[32].CS.R             /* Message Buffer 32 CS Register */
#define CAN_3_ID32           CAN_3.MB[32].ID.R             /* Message Buffer 32 ID Register */
#define CAN_3_B32            CAN_3.MB[32].DATA.B           /* Message Buffer 32 B Register */
#define CAN_3_H32            CAN_3.MB[32].DATA.H           /* Message Buffer 32 H Register */
#define CAN_3_W32            CAN_3.MB[32].DATA.W           /* Message Buffer 32 W Register */
#define CAN_3_CS33           CAN_3.MB[33].CS.R             /* Message Buffer 33 CS Register */
#define CAN_3_ID33           CAN_3.MB[33].ID.R             /* Message Buffer 33 ID Register */
#define CAN_3_B33            CAN_3.MB[33].DATA.B           /* Message Buffer 33 B Register */
#define CAN_3_H33            CAN_3.MB[33].DATA.H           /* Message Buffer 33 H Register */
#define CAN_3_W33            CAN_3.MB[33].DATA.W           /* Message Buffer 33 W Register */
#define CAN_3_CS34           CAN_3.MB[34].CS.R             /* Message Buffer 34 CS Register */
#define CAN_3_ID34           CAN_3.MB[34].ID.R             /* Message Buffer 34 ID Register */
#define CAN_3_B34            CAN_3.MB[34].DATA.B           /* Message Buffer 34 B Register */
#define CAN_3_H34            CAN_3.MB[34].DATA.H           /* Message Buffer 34 H Register */
#define CAN_3_W34            CAN_3.MB[34].DATA.W           /* Message Buffer 34 W Register */
#define CAN_3_CS35           CAN_3.MB[35].CS.R             /* Message Buffer 35 CS Register */
#define CAN_3_ID35           CAN_3.MB[35].ID.R             /* Message Buffer 35 ID Register */
#define CAN_3_B35            CAN_3.MB[35].DATA.B           /* Message Buffer 35 B Register */
#define CAN_3_H35            CAN_3.MB[35].DATA.H           /* Message Buffer 35 H Register */
#define CAN_3_W35            CAN_3.MB[35].DATA.W           /* Message Buffer 35 W Register */
#define CAN_3_CS36           CAN_3.MB[36].CS.R             /* Message Buffer 36 CS Register */
#define CAN_3_ID36           CAN_3.MB[36].ID.R             /* Message Buffer 36 ID Register */
#define CAN_3_B36            CAN_3.MB[36].DATA.B           /* Message Buffer 36 B Register */
#define CAN_3_H36            CAN_3.MB[36].DATA.H           /* Message Buffer 36 H Register */
#define CAN_3_W36            CAN_3.MB[36].DATA.W           /* Message Buffer 36 W Register */
#define CAN_3_CS37           CAN_3.MB[37].CS.R             /* Message Buffer 37 CS Register */
#define CAN_3_ID37           CAN_3.MB[37].ID.R             /* Message Buffer 37 ID Register */
#define CAN_3_B37            CAN_3.MB[37].DATA.B           /* Message Buffer 37 B Register */
#define CAN_3_H37            CAN_3.MB[37].DATA.H           /* Message Buffer 37 H Register */
#define CAN_3_W37            CAN_3.MB[37].DATA.W           /* Message Buffer 37 W Register */
#define CAN_3_CS38           CAN_3.MB[38].CS.R             /* Message Buffer 38 CS Register */
#define CAN_3_ID38           CAN_3.MB[38].ID.R             /* Message Buffer 38 ID Register */
#define CAN_3_B38            CAN_3.MB[38].DATA.B           /* Message Buffer 38 B Register */
#define CAN_3_H38            CAN_3.MB[38].DATA.H           /* Message Buffer 38 H Register */
#define CAN_3_W38            CAN_3.MB[38].DATA.W           /* Message Buffer 38 W Register */
#define CAN_3_CS39           CAN_3.MB[39].CS.R             /* Message Buffer 39 CS Register */
#define CAN_3_ID39           CAN_3.MB[39].ID.R             /* Message Buffer 39 ID Register */
#define CAN_3_B39            CAN_3.MB[39].DATA.B           /* Message Buffer 39 B Register */
#define CAN_3_H39            CAN_3.MB[39].DATA.H           /* Message Buffer 39 H Register */
#define CAN_3_W39            CAN_3.MB[39].DATA.W           /* Message Buffer 39 W Register */
#define CAN_3_CS40           CAN_3.MB[40].CS.R             /* Message Buffer 40 CS Register */
#define CAN_3_ID40           CAN_3.MB[40].ID.R             /* Message Buffer 40 ID Register */
#define CAN_3_B40            CAN_3.MB[40].DATA.B           /* Message Buffer 40 B Register */
#define CAN_3_H40            CAN_3.MB[40].DATA.H           /* Message Buffer 40 H Register */
#define CAN_3_W40            CAN_3.MB[40].DATA.W           /* Message Buffer 40 W Register */
#define CAN_3_CS41           CAN_3.MB[41].CS.R             /* Message Buffer 41 CS Register */
#define CAN_3_ID41           CAN_3.MB[41].ID.R             /* Message Buffer 41 ID Register */
#define CAN_3_B41            CAN_3.MB[41].DATA.B           /* Message Buffer 41 B Register */
#define CAN_3_H41            CAN_3.MB[41].DATA.H           /* Message Buffer 41 H Register */
#define CAN_3_W41            CAN_3.MB[41].DATA.W           /* Message Buffer 41 W Register */
#define CAN_3_CS42           CAN_3.MB[42].CS.R             /* Message Buffer 42 CS Register */
#define CAN_3_ID42           CAN_3.MB[42].ID.R             /* Message Buffer 42 ID Register */
#define CAN_3_B42            CAN_3.MB[42].DATA.B           /* Message Buffer 42 B Register */
#define CAN_3_H42            CAN_3.MB[42].DATA.H           /* Message Buffer 42 H Register */
#define CAN_3_W42            CAN_3.MB[42].DATA.W           /* Message Buffer 42 W Register */
#define CAN_3_CS43           CAN_3.MB[43].CS.R             /* Message Buffer 43 CS Register */
#define CAN_3_ID43           CAN_3.MB[43].ID.R             /* Message Buffer 43 ID Register */
#define CAN_3_B43            CAN_3.MB[43].DATA.B           /* Message Buffer 43 B Register */
#define CAN_3_H43            CAN_3.MB[43].DATA.H           /* Message Buffer 43 H Register */
#define CAN_3_W43            CAN_3.MB[43].DATA.W           /* Message Buffer 43 W Register */
#define CAN_3_CS44           CAN_3.MB[44].CS.R             /* Message Buffer 44 CS Register */
#define CAN_3_ID44           CAN_3.MB[44].ID.R             /* Message Buffer 44 ID Register */
#define CAN_3_B44            CAN_3.MB[44].DATA.B           /* Message Buffer 44 B Register */
#define CAN_3_H44            CAN_3.MB[44].DATA.H           /* Message Buffer 44 H Register */
#define CAN_3_W44            CAN_3.MB[44].DATA.W           /* Message Buffer 44 W Register */
#define CAN_3_CS45           CAN_3.MB[45].CS.R             /* Message Buffer 45 CS Register */
#define CAN_3_ID45           CAN_3.MB[45].ID.R             /* Message Buffer 45 ID Register */
#define CAN_3_B45            CAN_3.MB[45].DATA.B           /* Message Buffer 45 B Register */
#define CAN_3_H45            CAN_3.MB[45].DATA.H           /* Message Buffer 45 H Register */
#define CAN_3_W45            CAN_3.MB[45].DATA.W           /* Message Buffer 45 W Register */
#define CAN_3_CS46           CAN_3.MB[46].CS.R             /* Message Buffer 46 CS Register */
#define CAN_3_ID46           CAN_3.MB[46].ID.R             /* Message Buffer 46 ID Register */
#define CAN_3_B46            CAN_3.MB[46].DATA.B           /* Message Buffer 46 B Register */
#define CAN_3_H46            CAN_3.MB[46].DATA.H           /* Message Buffer 46 H Register */
#define CAN_3_W46            CAN_3.MB[46].DATA.W           /* Message Buffer 46 W Register */
#define CAN_3_CS47           CAN_3.MB[47].CS.R             /* Message Buffer 47 CS Register */
#define CAN_3_ID47           CAN_3.MB[47].ID.R             /* Message Buffer 47 ID Register */
#define CAN_3_B47            CAN_3.MB[47].DATA.B           /* Message Buffer 47 B Register */
#define CAN_3_H47            CAN_3.MB[47].DATA.H           /* Message Buffer 47 H Register */
#define CAN_3_W47            CAN_3.MB[47].DATA.W           /* Message Buffer 47 W Register */
#define CAN_3_CS48           CAN_3.MB[48].CS.R             /* Message Buffer 48 CS Register */
#define CAN_3_ID48           CAN_3.MB[48].ID.R             /* Message Buffer 48 ID Register */
#define CAN_3_B48            CAN_3.MB[48].DATA.B           /* Message Buffer 48 B Register */
#define CAN_3_H48            CAN_3.MB[48].DATA.H           /* Message Buffer 48 H Register */
#define CAN_3_W48            CAN_3.MB[48].DATA.W           /* Message Buffer 48 W Register */
#define CAN_3_CS49           CAN_3.MB[49].CS.R             /* Message Buffer 49 CS Register */
#define CAN_3_ID49           CAN_3.MB[49].ID.R             /* Message Buffer 49 ID Register */
#define CAN_3_B49            CAN_3.MB[49].DATA.B           /* Message Buffer 49 B Register */
#define CAN_3_H49            CAN_3.MB[49].DATA.H           /* Message Buffer 49 H Register */
#define CAN_3_W49            CAN_3.MB[49].DATA.W           /* Message Buffer 49 W Register */
#define CAN_3_CS50           CAN_3.MB[50].CS.R             /* Message Buffer 50 CS Register */
#define CAN_3_ID50           CAN_3.MB[50].ID.R             /* Message Buffer 50 ID Register */
#define CAN_3_B50            CAN_3.MB[50].DATA.B           /* Message Buffer 50 B Register */
#define CAN_3_H50            CAN_3.MB[50].DATA.H           /* Message Buffer 50 H Register */
#define CAN_3_W50            CAN_3.MB[50].DATA.W           /* Message Buffer 50 W Register */
#define CAN_3_CS51           CAN_3.MB[51].CS.R             /* Message Buffer 51 CS Register */
#define CAN_3_ID51           CAN_3.MB[51].ID.R             /* Message Buffer 51 ID Register */
#define CAN_3_B51            CAN_3.MB[51].DATA.B           /* Message Buffer 51 B Register */
#define CAN_3_H51            CAN_3.MB[51].DATA.H           /* Message Buffer 51 H Register */
#define CAN_3_W51            CAN_3.MB[51].DATA.W           /* Message Buffer 51 W Register */
#define CAN_3_CS52           CAN_3.MB[52].CS.R             /* Message Buffer 52 CS Register */
#define CAN_3_ID52           CAN_3.MB[52].ID.R             /* Message Buffer 52 ID Register */
#define CAN_3_B52            CAN_3.MB[52].DATA.B           /* Message Buffer 52 B Register */
#define CAN_3_H52            CAN_3.MB[52].DATA.H           /* Message Buffer 52 H Register */
#define CAN_3_W52            CAN_3.MB[52].DATA.W           /* Message Buffer 52 W Register */
#define CAN_3_CS53           CAN_3.MB[53].CS.R             /* Message Buffer 53 CS Register */
#define CAN_3_ID53           CAN_3.MB[53].ID.R             /* Message Buffer 53 ID Register */
#define CAN_3_B53            CAN_3.MB[53].DATA.B           /* Message Buffer 53 B Register */
#define CAN_3_H53            CAN_3.MB[53].DATA.H           /* Message Buffer 53 H Register */
#define CAN_3_W53            CAN_3.MB[53].DATA.W           /* Message Buffer 53 W Register */
#define CAN_3_CS54           CAN_3.MB[54].CS.R             /* Message Buffer 54 CS Register */
#define CAN_3_ID54           CAN_3.MB[54].ID.R             /* Message Buffer 54 ID Register */
#define CAN_3_B54            CAN_3.MB[54].DATA.B           /* Message Buffer 54 B Register */
#define CAN_3_H54            CAN_3.MB[54].DATA.H           /* Message Buffer 54 H Register */
#define CAN_3_W54            CAN_3.MB[54].DATA.W           /* Message Buffer 54 W Register */
#define CAN_3_CS55           CAN_3.MB[55].CS.R             /* Message Buffer 55 CS Register */
#define CAN_3_ID55           CAN_3.MB[55].ID.R             /* Message Buffer 55 ID Register */
#define CAN_3_B55            CAN_3.MB[55].DATA.B           /* Message Buffer 55 B Register */
#define CAN_3_H55            CAN_3.MB[55].DATA.H           /* Message Buffer 55 H Register */
#define CAN_3_W55            CAN_3.MB[55].DATA.W           /* Message Buffer 55 W Register */
#define CAN_3_CS56           CAN_3.MB[56].CS.R             /* Message Buffer 56 CS Register */
#define CAN_3_ID56           CAN_3.MB[56].ID.R             /* Message Buffer 56 ID Register */
#define CAN_3_B56            CAN_3.MB[56].DATA.B           /* Message Buffer 56 B Register */
#define CAN_3_H56            CAN_3.MB[56].DATA.H           /* Message Buffer 56 H Register */
#define CAN_3_W56            CAN_3.MB[56].DATA.W           /* Message Buffer 56 W Register */
#define CAN_3_CS57           CAN_3.MB[57].CS.R             /* Message Buffer 57 CS Register */
#define CAN_3_ID57           CAN_3.MB[57].ID.R             /* Message Buffer 57 ID Register */
#define CAN_3_B57            CAN_3.MB[57].DATA.B           /* Message Buffer 57 B Register */
#define CAN_3_H57            CAN_3.MB[57].DATA.H           /* Message Buffer 57 H Register */
#define CAN_3_W57            CAN_3.MB[57].DATA.W           /* Message Buffer 57 W Register */
#define CAN_3_CS58           CAN_3.MB[58].CS.R             /* Message Buffer 58 CS Register */
#define CAN_3_ID58           CAN_3.MB[58].ID.R             /* Message Buffer 58 ID Register */
#define CAN_3_B58            CAN_3.MB[58].DATA.B           /* Message Buffer 58 B Register */
#define CAN_3_H58            CAN_3.MB[58].DATA.H           /* Message Buffer 58 H Register */
#define CAN_3_W58            CAN_3.MB[58].DATA.W           /* Message Buffer 58 W Register */
#define CAN_3_CS59           CAN_3.MB[59].CS.R             /* Message Buffer 59 CS Register */
#define CAN_3_ID59           CAN_3.MB[59].ID.R             /* Message Buffer 59 ID Register */
#define CAN_3_B59            CAN_3.MB[59].DATA.B           /* Message Buffer 59 B Register */
#define CAN_3_H59            CAN_3.MB[59].DATA.H           /* Message Buffer 59 H Register */
#define CAN_3_W59            CAN_3.MB[59].DATA.W           /* Message Buffer 59 W Register */
#define CAN_3_CS60           CAN_3.MB[60].CS.R             /* Message Buffer 60 CS Register */
#define CAN_3_ID60           CAN_3.MB[60].ID.R             /* Message Buffer 60 ID Register */
#define CAN_3_B60            CAN_3.MB[60].DATA.B           /* Message Buffer 60 B Register */
#define CAN_3_H60            CAN_3.MB[60].DATA.H           /* Message Buffer 60 H Register */
#define CAN_3_W60            CAN_3.MB[60].DATA.W           /* Message Buffer 60 W Register */
#define CAN_3_CS61           CAN_3.MB[61].CS.R             /* Message Buffer 61 CS Register */
#define CAN_3_ID61           CAN_3.MB[61].ID.R             /* Message Buffer 61 ID Register */
#define CAN_3_B61            CAN_3.MB[61].DATA.B           /* Message Buffer 61 B Register */
#define CAN_3_H61            CAN_3.MB[61].DATA.H           /* Message Buffer 61 H Register */
#define CAN_3_W61            CAN_3.MB[61].DATA.W           /* Message Buffer 61 W Register */
#define CAN_3_CS62           CAN_3.MB[62].CS.R             /* Message Buffer 62 CS Register */
#define CAN_3_ID62           CAN_3.MB[62].ID.R             /* Message Buffer 62 ID Register */
#define CAN_3_B62            CAN_3.MB[62].DATA.B           /* Message Buffer 62 B Register */
#define CAN_3_H62            CAN_3.MB[62].DATA.H           /* Message Buffer 62 H Register */
#define CAN_3_W62            CAN_3.MB[62].DATA.W           /* Message Buffer 62 W Register */
#define CAN_3_CS63           CAN_3.MB[63].CS.R             /* Message Buffer 63 CS Register */
#define CAN_3_ID63           CAN_3.MB[63].ID.R             /* Message Buffer 63 ID Register */
#define CAN_3_B63            CAN_3.MB[63].DATA.B           /* Message Buffer 63 B Register */
#define CAN_3_H63            CAN_3.MB[63].DATA.H           /* Message Buffer 63 H Register */
#define CAN_3_W63            CAN_3.MB[63].DATA.W           /* Message Buffer 63 W Register */
#define CAN_3_RXIMR0         CAN_3.RXIMR[0].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR1         CAN_3.RXIMR[1].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR2         CAN_3.RXIMR[2].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR3         CAN_3.RXIMR[3].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR4         CAN_3.RXIMR[4].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR5         CAN_3.RXIMR[5].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR6         CAN_3.RXIMR[6].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR7         CAN_3.RXIMR[7].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR8         CAN_3.RXIMR[8].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR9         CAN_3.RXIMR[9].R              /* Rx Individual Mask Registers */
#define CAN_3_RXIMR10        CAN_3.RXIMR[10].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR11        CAN_3.RXIMR[11].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR12        CAN_3.RXIMR[12].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR13        CAN_3.RXIMR[13].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR14        CAN_3.RXIMR[14].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR15        CAN_3.RXIMR[15].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR16        CAN_3.RXIMR[16].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR17        CAN_3.RXIMR[17].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR18        CAN_3.RXIMR[18].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR19        CAN_3.RXIMR[19].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR20        CAN_3.RXIMR[20].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR21        CAN_3.RXIMR[21].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR22        CAN_3.RXIMR[22].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR23        CAN_3.RXIMR[23].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR24        CAN_3.RXIMR[24].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR25        CAN_3.RXIMR[25].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR26        CAN_3.RXIMR[26].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR27        CAN_3.RXIMR[27].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR28        CAN_3.RXIMR[28].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR29        CAN_3.RXIMR[29].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR30        CAN_3.RXIMR[30].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR31        CAN_3.RXIMR[31].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR32        CAN_3.RXIMR[32].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR33        CAN_3.RXIMR[33].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR34        CAN_3.RXIMR[34].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR35        CAN_3.RXIMR[35].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR36        CAN_3.RXIMR[36].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR37        CAN_3.RXIMR[37].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR38        CAN_3.RXIMR[38].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR39        CAN_3.RXIMR[39].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR40        CAN_3.RXIMR[40].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR41        CAN_3.RXIMR[41].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR42        CAN_3.RXIMR[42].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR43        CAN_3.RXIMR[43].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR44        CAN_3.RXIMR[44].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR45        CAN_3.RXIMR[45].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR46        CAN_3.RXIMR[46].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR47        CAN_3.RXIMR[47].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR48        CAN_3.RXIMR[48].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR49        CAN_3.RXIMR[49].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR50        CAN_3.RXIMR[50].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR51        CAN_3.RXIMR[51].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR52        CAN_3.RXIMR[52].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR53        CAN_3.RXIMR[53].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR54        CAN_3.RXIMR[54].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR55        CAN_3.RXIMR[55].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR56        CAN_3.RXIMR[56].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR57        CAN_3.RXIMR[57].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR58        CAN_3.RXIMR[58].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR59        CAN_3.RXIMR[59].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR60        CAN_3.RXIMR[60].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR61        CAN_3.RXIMR[61].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR62        CAN_3.RXIMR[62].R             /* Rx Individual Mask Registers */
#define CAN_3_RXIMR63        CAN_3.RXIMR[63].R             /* Rx Individual Mask Registers */
#define CAN_3_MECR           CAN_3.MECR.R                  /* Memory Error Control Register */
#define CAN_3_ERRIAR         CAN_3.ERRIAR.R                /* Error Injection Address Register */
#define CAN_3_ERRIDPR        CAN_3.ERRIDPR.R               /* Error Injection Data Pattern Register */
#define CAN_3_ERRIPPR        CAN_3.ERRIPPR.R               /* Error Injection Parity Pattern Register */
#define CAN_3_RERRAR         CAN_3.RERRAR.R                /* Error Report Address Register */
#define CAN_3_RERRDR         CAN_3.RERRDR.R                /* Error Report Data Register */
#define CAN_3_RERRSYNR       CAN_3.RERRSYNR.R              /* Error Report Syndrome Register */
#define CAN_3_ERRSR          CAN_3.ERRSR.R                 /* Error Status Register */

/* CGM */
#define CGM_PCS_SDUR         CGM.PCS_SDUR.R                /* PCS Switch Duration Register */
#define CGM_PCS_DIVC1        CGM.PCS_DIVC1.R               /* PCS Divider Change Register 1 */
#define CGM_PCS_DIVE1        CGM.PCS_DIVE1.R               /* PCS Divider End Register 1 */
#define CGM_PCS_DIVS1        CGM.PCS_DIVS1.R               /* PCS Divider Start Register 1 */
#define CGM_PCS_DIVC2        CGM.PCS_DIVC2.R               /* PCS Divider Change Register 2 */
#define CGM_PCS_DIVE2        CGM.PCS_DIVE2.R               /* PCS Divider End Register 2 */
#define CGM_PCS_DIVS2        CGM.PCS_DIVS2.R               /* PCS Divider Start Register 2 */
#define CGM_PCS_DIVC4        CGM.PCS_DIVC4.R               /* PCS Divider Change Register 4 */
#define CGM_PCS_DIVE4        CGM.PCS_DIVE4.R               /* PCS Divider End Register 4 */
#define CGM_PCS_DIVS4        CGM.PCS_DIVS4.R               /* PCS Divider Start Register 4 */
#define CGM_DIV_UPD_STAT     CGM.DIV_UPD_STAT.R            /* Divider Update Status Register */
#define CGM_SC_SS            CGM.SC_SS.R                   /* System Clock Select Status Register */
#define CGM_SC_DC0           CGM.SC_DC0.R                  /* System Clock Divider 0 Configuration Register */
#define CGM_SC_DC1           CGM.SC_DC1.R                  /* System Clock Divider 1 Configuration Register */
#define CGM_SC_DC2           CGM.SC_DC2.R                  /* System Clock Divider 2 Configuration Register */
#define CGM_SC_DC3           CGM.SC_DC3.R                  /* System Clock Divider 3 Configuration Register */
#define CGM_SC_DC4           CGM.SC_DC4.R                  /* System Clock Divider 4 Configuration Register */
#define CGM_SC_DC5           CGM.SC_DC5.R                  /* System Clock Divider 5 Configuration Register */
#define CGM_AC0_SC           CGM.AC0_SC.R                  /* Auxiliary Clock 0 Select Control Register */
#define CGM_AC0_SS           CGM.AC0_SS.R                  /* Auxiliary Clock 0 Select Status Register */
#define CGM_AC0_DC0          CGM.AC0_DC0.R                 /* Auxiliary Clock 0 Divider 0 Configuration Register */
#define CGM_AC0_DC2          CGM.AC0_DC2.R                 /* Auxiliary Clock 0 Divider 2 Configuration Register */
#define CGM_AC1_SC           CGM.AC1_SC.R                  /* Auxiliary Clock 1 Select Control Register */
#define CGM_AC1_SS           CGM.AC1_SS.R                  /* Auxiliary Clock 1 Select Status Register */
#define CGM_AC1_DC0          CGM.AC1_DC0.R                 /* Auxiliary Clock 1 Divider 0 Configuration Register */
#define CGM_AC2_SC           CGM.AC2_SC.R                  /* Auxiliary Clock 2 Select Control Register */
#define CGM_AC2_SS           CGM.AC2_SS.R                  /* Auxiliary Clock 2 Select Status Register */
#define CGM_AC2_DC0          CGM.AC2_DC0.R                 /* Auxiliary Clock 2 Divider 0 Configuration Register */
#define CGM_AC3_SC           CGM.AC3_SC.R                  /* Auxiliary Clock 3 Select Control Register */
#define CGM_AC3_SS           CGM.AC3_SS.R                  /* Auxiliary Clock 3 Select Status Register */
#define CGM_AC4_SC           CGM.AC4_SC.R                  /* Auxiliary Clock 4 Select Control Register */
#define CGM_AC4_SS           CGM.AC4_SS.R                  /* Auxiliary Clock 4 Select Status Register */
#define CGM_AC7_SC           CGM.AC7_SC.R                  /* Auxiliary Clock 7 Select Control Register */
#define CGM_AC7_SS           CGM.AC7_SS.R                  /* Auxiliary Clock 7 Select Status Register */
#define CGM_AC7_DC0          CGM.AC7_DC0.R                 /* Auxiliary Clock 7 Divider 0 Configuration Register */
#define CGM_AC8_SC           CGM.AC8_SC.R                  /* Auxiliary Clock 8 Select Control Register */
#define CGM_AC8_SS           CGM.AC8_SS.R                  /* Auxiliary Clock 8 Select Status Register */
#define CGM_AC8_DC0          CGM.AC8_DC0.R                 /* Auxiliary Clock 8 Divider 0 Configuration Register */
#define CGM_AC9_DC0          CGM.AC9_DC0.R                 /* Auxiliary Clock 9 Divider 0 Configuration Register */
#define CGM_AC10_SC          CGM.AC10_SC.R                 /* Auxiliary Clock 10 Select Control Register */
#define CGM_AC10_SS          CGM.AC10_SS.R                 /* Auxiliary Clock 10 Select Status Register */
#define CGM_AC10_DC0         CGM.AC10_DC0.R                /* Auxiliary Clock 10 Divider 0 Configuration Register */
#define CGM_AC11_SC          CGM.AC11_SC.R                 /* Auxiliary Clock 11 Select Control Register */
#define CGM_AC11_SS          CGM.AC11_SS.R                 /* Auxiliary Clock 11 Select Status Register */
#define CGM_AC11_DC0         CGM.AC11_DC0.R                /* Auxiliary Clock 11 Divider 0 Configuration Register */
#define CGM_AC12_SC          CGM.AC12_SC.R                 /* Auxiliary Clock 12 Select Control Register */
#define CGM_AC12_SS          CGM.AC12_SS.R                 /* Auxiliary Clock 12 Select Status Register */
#define CGM_AC12_DC0         CGM.AC12_DC0.R                /* Auxiliary Clock 12 Divider 0 Configuration Register */
#define CGM_AC13_SC          CGM.AC13_SC.R                 /* Auxiliary Clock 13 Select Control Register */
#define CGM_AC13_SS          CGM.AC13_SS.R                 /* Auxiliary Clock 13 Select Status Register */
#define CGM_AC13_DC0         CGM.AC13_DC0.R                /* Auxiliary Clock 13 Divider 0 Configuration Register */
#define CGM_AC14_DC0         CGM.AC14_DC0.R                /* Auxiliary Clock 14 Divider 0 Configuration Register */
#define CGM_AC15_SC          CGM.AC15_SC.R                 /* Aux Clock 15 Select Control */
#define CGM_AC15_SS          CGM.AC15_SS.R                 /* Auxiliary Clock 15 Select Control Register */
#define CGM_AC15_DC0         CGM.AC15_DC0.R                /* Auxiliary Clock 15 Divider 0 Configuration Register */

/* CMU */
#define CMU_0_CSR            CMU_0.CSR.R                   /* CMU Control Status Register */
#define CMU_0_FDR            CMU_0.FDR.R                   /* CMU Frequency Display Register */
#define CMU_0_HFREFR         CMU_0.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_0_LFREFR         CMU_0.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_0_ISR            CMU_0.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_0_MDR            CMU_0.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_1_CSR            CMU_1.CSR.R                   /* CMU Control Status Register */
#define CMU_1_FDR            CMU_1.FDR.R                   /* CMU Frequency Display Register */
#define CMU_1_HFREFR         CMU_1.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_1_LFREFR         CMU_1.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_1_ISR            CMU_1.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_1_MDR            CMU_1.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_10_CSR           CMU_10.CSR.R                  /* CMU Control Status Register */
#define CMU_10_FDR           CMU_10.FDR.R                  /* CMU Frequency Display Register */
#define CMU_10_HFREFR        CMU_10.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_10_LFREFR        CMU_10.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_10_ISR           CMU_10.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_10_MDR           CMU_10.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_11_CSR           CMU_11.CSR.R                  /* CMU Control Status Register */
#define CMU_11_FDR           CMU_11.FDR.R                  /* CMU Frequency Display Register */
#define CMU_11_HFREFR        CMU_11.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_11_LFREFR        CMU_11.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_11_ISR           CMU_11.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_11_MDR           CMU_11.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_12_CSR           CMU_12.CSR.R                  /* CMU Control Status Register */
#define CMU_12_FDR           CMU_12.FDR.R                  /* CMU Frequency Display Register */
#define CMU_12_HFREFR        CMU_12.HFREFR.R               /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_12_LFREFR        CMU_12.LFREFR.R               /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_12_ISR           CMU_12.ISR.R                  /* CMU Interrupt Status Register */
#define CMU_12_MDR           CMU_12.MDR.R                  /* CMU Measurement Duration Register */

#define CMU_2_CSR            CMU_2.CSR.R                   /* CMU Control Status Register */
#define CMU_2_FDR            CMU_2.FDR.R                   /* CMU Frequency Display Register */
#define CMU_2_HFREFR         CMU_2.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_2_LFREFR         CMU_2.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_2_ISR            CMU_2.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_2_MDR            CMU_2.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_3_CSR            CMU_3.CSR.R                   /* CMU Control Status Register */
#define CMU_3_FDR            CMU_3.FDR.R                   /* CMU Frequency Display Register */
#define CMU_3_HFREFR         CMU_3.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_3_LFREFR         CMU_3.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_3_ISR            CMU_3.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_3_MDR            CMU_3.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_5_CSR            CMU_5.CSR.R                   /* CMU Control Status Register */
#define CMU_5_FDR            CMU_5.FDR.R                   /* CMU Frequency Display Register */
#define CMU_5_HFREFR         CMU_5.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_5_LFREFR         CMU_5.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_5_ISR            CMU_5.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_5_MDR            CMU_5.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_6_CSR            CMU_6.CSR.R                   /* CMU Control Status Register */
#define CMU_6_FDR            CMU_6.FDR.R                   /* CMU Frequency Display Register */
#define CMU_6_HFREFR         CMU_6.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_6_LFREFR         CMU_6.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_6_ISR            CMU_6.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_6_MDR            CMU_6.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_7_CSR            CMU_7.CSR.R                   /* CMU Control Status Register */
#define CMU_7_FDR            CMU_7.FDR.R                   /* CMU Frequency Display Register */
#define CMU_7_HFREFR         CMU_7.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_7_LFREFR         CMU_7.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_7_ISR            CMU_7.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_7_MDR            CMU_7.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_8_CSR            CMU_8.CSR.R                   /* CMU Control Status Register */
#define CMU_8_FDR            CMU_8.FDR.R                   /* CMU Frequency Display Register */
#define CMU_8_HFREFR         CMU_8.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_8_LFREFR         CMU_8.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_8_ISR            CMU_8.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_8_MDR            CMU_8.MDR.R                   /* CMU Measurement Duration Register */

#define CMU_9_CSR            CMU_9.CSR.R                   /* CMU Control Status Register */
#define CMU_9_FDR            CMU_9.FDR.R                   /* CMU Frequency Display Register */
#define CMU_9_HFREFR         CMU_9.HFREFR.R                /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_9_LFREFR         CMU_9.LFREFR.R                /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_9_ISR            CMU_9.ISR.R                   /* CMU Interrupt Status Register */
#define CMU_9_MDR            CMU_9.MDR.R                   /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG1           CRC_0.CHANNEL[0].CFG.R        /* Configuration Register */
#define CRC_0_INP1           CRC_0.CHANNEL[0].INP.R        /* Input Register */
#define CRC_0_CSTAT1         CRC_0.CHANNEL[0].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP1          CRC_0.CHANNEL[0].OUTP.R       /* Output Register */
#define CRC_0_CFG2           CRC_0.CHANNEL[1].CFG.R        /* Configuration Register */
#define CRC_0_INP2           CRC_0.CHANNEL[1].INP.R        /* Input Register */
#define CRC_0_CSTAT2         CRC_0.CHANNEL[1].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP2          CRC_0.CHANNEL[1].OUTP.R       /* Output Register */
#define CRC_0_CFG3           CRC_0.CHANNEL[2].CFG.R        /* Configuration Register */
#define CRC_0_INP3           CRC_0.CHANNEL[2].INP.R        /* Input Register */
#define CRC_0_CSTAT3         CRC_0.CHANNEL[2].CSTAT.R      /* Current Status Register */
#define CRC_0_OUTP3          CRC_0.CHANNEL[2].OUTP.R       /* Output Register */

#define CRC_1_CFG1           CRC_1.CHANNEL[0].CFG.R        /* Configuration Register */
#define CRC_1_INP1           CRC_1.CHANNEL[0].INP.R        /* Input Register */
#define CRC_1_CSTAT1         CRC_1.CHANNEL[0].CSTAT.R      /* Current Status Register */
#define CRC_1_OUTP1          CRC_1.CHANNEL[0].OUTP.R       /* Output Register */
#define CRC_1_CFG2           CRC_1.CHANNEL[1].CFG.R        /* Configuration Register */
#define CRC_1_INP2           CRC_1.CHANNEL[1].INP.R        /* Input Register */
#define CRC_1_CSTAT2         CRC_1.CHANNEL[1].CSTAT.R      /* Current Status Register */
#define CRC_1_OUTP2          CRC_1.CHANNEL[1].OUTP.R       /* Output Register */
#define CRC_1_CFG3           CRC_1.CHANNEL[2].CFG.R        /* Configuration Register */
#define CRC_1_INP3           CRC_1.CHANNEL[2].INP.R        /* Input Register */
#define CRC_1_CSTAT3         CRC_1.CHANNEL[2].CSTAT.R      /* Current Status Register */
#define CRC_1_OUTP3          CRC_1.CHANNEL[2].OUTP.R       /* Output Register */

/* CTE */
#define CTE_CNTRL            CTE.CNTRL.R                   /* Control Register */
#define CTE_CNTRL1           CTE.CNTRL1.R                  /* CTE Control Register 1 */
#define CTE_LUT0_LSB0        CTE.LUT[0].LSB[0].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB1        CTE.LUT[0].LSB[1].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB2        CTE.LUT[0].LSB[2].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB3        CTE.LUT[0].LSB[3].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB4        CTE.LUT[0].LSB[4].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB5        CTE.LUT[0].LSB[5].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB6        CTE.LUT[0].LSB[6].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB7        CTE.LUT[0].LSB[7].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB8        CTE.LUT[0].LSB[8].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB9        CTE.LUT[0].LSB[9].R           /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB10       CTE.LUT[0].LSB[10].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB11       CTE.LUT[0].LSB[11].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB12       CTE.LUT[0].LSB[12].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB13       CTE.LUT[0].LSB[13].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB14       CTE.LUT[0].LSB[14].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB15       CTE.LUT[0].LSB[15].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB16       CTE.LUT[0].LSB[16].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB17       CTE.LUT[0].LSB[17].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB18       CTE.LUT[0].LSB[18].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB19       CTE.LUT[0].LSB[19].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB20       CTE.LUT[0].LSB[20].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB21       CTE.LUT[0].LSB[21].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB22       CTE.LUT[0].LSB[22].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB23       CTE.LUT[0].LSB[23].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB24       CTE.LUT[0].LSB[24].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB25       CTE.LUT[0].LSB[25].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB26       CTE.LUT[0].LSB[26].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB27       CTE.LUT[0].LSB[27].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB28       CTE.LUT[0].LSB[28].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB29       CTE.LUT[0].LSB[29].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB30       CTE.LUT[0].LSB[30].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_LSB31       CTE.LUT[0].LSB[31].R          /* First Timing Table Register (LSB) */
#define CTE_LUT0_MSB0        CTE.LUT[0].MSB[0].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB1        CTE.LUT[0].MSB[1].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB2        CTE.LUT[0].MSB[2].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB3        CTE.LUT[0].MSB[3].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB4        CTE.LUT[0].MSB[4].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB5        CTE.LUT[0].MSB[5].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB6        CTE.LUT[0].MSB[6].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB7        CTE.LUT[0].MSB[7].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB8        CTE.LUT[0].MSB[8].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB9        CTE.LUT[0].MSB[9].R           /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB10       CTE.LUT[0].MSB[10].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB11       CTE.LUT[0].MSB[11].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB12       CTE.LUT[0].MSB[12].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB13       CTE.LUT[0].MSB[13].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB14       CTE.LUT[0].MSB[14].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB15       CTE.LUT[0].MSB[15].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB16       CTE.LUT[0].MSB[16].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB17       CTE.LUT[0].MSB[17].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB18       CTE.LUT[0].MSB[18].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB19       CTE.LUT[0].MSB[19].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB20       CTE.LUT[0].MSB[20].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB21       CTE.LUT[0].MSB[21].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB22       CTE.LUT[0].MSB[22].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB23       CTE.LUT[0].MSB[23].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB24       CTE.LUT[0].MSB[24].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB25       CTE.LUT[0].MSB[25].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB26       CTE.LUT[0].MSB[26].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB27       CTE.LUT[0].MSB[27].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB28       CTE.LUT[0].MSB[28].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB29       CTE.LUT[0].MSB[29].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB30       CTE.LUT[0].MSB[30].R          /* First Timing Table Register (MSB) */
#define CTE_LUT0_MSB31       CTE.LUT[0].MSB[31].R          /* First Timing Table Register (MSB) */
#define CTE_LUT1_LSB0        CTE.LUT[1].LSB[0].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB1        CTE.LUT[1].LSB[1].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB2        CTE.LUT[1].LSB[2].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB3        CTE.LUT[1].LSB[3].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB4        CTE.LUT[1].LSB[4].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB5        CTE.LUT[1].LSB[5].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB6        CTE.LUT[1].LSB[6].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB7        CTE.LUT[1].LSB[7].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB8        CTE.LUT[1].LSB[8].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB9        CTE.LUT[1].LSB[9].R           /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB10       CTE.LUT[1].LSB[10].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB11       CTE.LUT[1].LSB[11].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB12       CTE.LUT[1].LSB[12].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB13       CTE.LUT[1].LSB[13].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB14       CTE.LUT[1].LSB[14].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB15       CTE.LUT[1].LSB[15].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB16       CTE.LUT[1].LSB[16].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB17       CTE.LUT[1].LSB[17].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB18       CTE.LUT[1].LSB[18].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB19       CTE.LUT[1].LSB[19].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB20       CTE.LUT[1].LSB[20].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB21       CTE.LUT[1].LSB[21].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB22       CTE.LUT[1].LSB[22].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB23       CTE.LUT[1].LSB[23].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB24       CTE.LUT[1].LSB[24].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB25       CTE.LUT[1].LSB[25].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB26       CTE.LUT[1].LSB[26].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB27       CTE.LUT[1].LSB[27].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB28       CTE.LUT[1].LSB[28].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB29       CTE.LUT[1].LSB[29].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB30       CTE.LUT[1].LSB[30].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_LSB31       CTE.LUT[1].LSB[31].R          /* Second Timing Table Register (LSB) */
#define CTE_LUT1_MSB0        CTE.LUT[1].MSB[0].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB1        CTE.LUT[1].MSB[1].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB2        CTE.LUT[1].MSB[2].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB3        CTE.LUT[1].MSB[3].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB4        CTE.LUT[1].MSB[4].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB5        CTE.LUT[1].MSB[5].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB6        CTE.LUT[1].MSB[6].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB7        CTE.LUT[1].MSB[7].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB8        CTE.LUT[1].MSB[8].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB9        CTE.LUT[1].MSB[9].R           /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB10       CTE.LUT[1].MSB[10].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB11       CTE.LUT[1].MSB[11].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB12       CTE.LUT[1].MSB[12].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB13       CTE.LUT[1].MSB[13].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB14       CTE.LUT[1].MSB[14].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB15       CTE.LUT[1].MSB[15].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB16       CTE.LUT[1].MSB[16].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB17       CTE.LUT[1].MSB[17].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB18       CTE.LUT[1].MSB[18].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB19       CTE.LUT[1].MSB[19].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB20       CTE.LUT[1].MSB[20].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB21       CTE.LUT[1].MSB[21].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB22       CTE.LUT[1].MSB[22].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB23       CTE.LUT[1].MSB[23].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB24       CTE.LUT[1].MSB[24].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB25       CTE.LUT[1].MSB[25].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB26       CTE.LUT[1].MSB[26].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB27       CTE.LUT[1].MSB[27].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB28       CTE.LUT[1].MSB[28].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB29       CTE.LUT[1].MSB[29].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB30       CTE.LUT[1].MSB[30].R          /* Second Timing Table Register (MSB) */
#define CTE_LUT1_MSB31       CTE.LUT[1].MSB[31].R          /* Second Timing Table Register (MSB) */
#define CTE_SIGTYPE00        CTE.SIGTYPE0[0].R             /* Signal Type Register 0 */
#define CTE_SIGTYPE01        CTE.SIGTYPE0[1].R             /* Signal Type Register 0 */
#define CTE_SIGTYPE10        CTE.SIGTYPE1[0].R             /* Signal Type Register 1 */
#define CTE_SIGTYPE11        CTE.SIGTYPE1[1].R             /* Signal Type Register 1 */
#define CTE_INTEN            CTE.INTEN.R                   /* CTE Interrupt Enable Register */
#define CTE_INTSTAT          CTE.INTSTAT.R                 /* CTE Interrupt Status Register */
#define CTE_CKSM_LSB         CTE.CKSM_LSB.R                /* LUT Checksum Register */
#define CTE_CKSM_MSB         CTE.CKSM_MSB.R                /* LUT Checksum Register */
#define CTE_DBG_REG          CTE.DBG_REG.R                 /* Debug Register */
#define CTE_LUT_DUR          CTE.LUT_DUR.R                 /* TT0 Execution Duration Register */
#define CTE_LUT_DUR1         CTE.LUT_DUR1.R                /* TT1 Execution Duration Register */
#define CTE_CLKSEL           CTE.CLKSEL.R                  /* Clock Select Register */

/* CTU */
#define CTU_0_TGSISR         CTU_0.TGSISR.R                /* Trigger Generator Subunit Input Selection Register */
#define CTU_0_TGSCR          CTU_0.TGSCR.R                 /* Trigger Generator Subunit Control Register */
#define CTU_0_T0CR           CTU_0.TCR[0].R                /* Trigger Compare Register */
#define CTU_0_T1CR           CTU_0.TCR[1].R                /* Trigger Compare Register */
#define CTU_0_T2CR           CTU_0.TCR[2].R                /* Trigger Compare Register */
#define CTU_0_T3CR           CTU_0.TCR[3].R                /* Trigger Compare Register */
#define CTU_0_T4CR           CTU_0.TCR[4].R                /* Trigger Compare Register */
#define CTU_0_T5CR           CTU_0.TCR[5].R                /* Trigger Compare Register */
#define CTU_0_T6CR           CTU_0.TCR[6].R                /* Trigger Compare Register */
#define CTU_0_T7CR           CTU_0.TCR[7].R                /* Trigger Compare Register */
#define CTU_0_TGSCCR         CTU_0.TGSCCR.R                /* TGS Counter Compare Register */
#define CTU_0_TGSCRR         CTU_0.TGSCRR.R                /* TGS Counter Reload Register */
#define CTU_0_CLCR1          CTU_0.CLCR1.R                 /* Commands List Control Register 1 */
#define CTU_0_CLCR2          CTU_0.CLCR2.R                 /* Commands List Control Register 2 */
#define CTU_0_THCR1          CTU_0.THCR1.R                 /* Trigger Handler Control Register 1 */
#define CTU_0_THCR2          CTU_0.THCR2.R                 /* Trigger Handler Control Register 2 */
#define CTU_0_CLR_A_1        CTU_0.CLR[0].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_1        CTU_0.CLR[0].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_1        CTU_0.CLR[0].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_2        CTU_0.CLR[1].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_2        CTU_0.CLR[1].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_2        CTU_0.CLR[1].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_3        CTU_0.CLR[2].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_3        CTU_0.CLR[2].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_3        CTU_0.CLR[2].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_4        CTU_0.CLR[3].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_4        CTU_0.CLR[3].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_4        CTU_0.CLR[3].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_5        CTU_0.CLR[4].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_5        CTU_0.CLR[4].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_5        CTU_0.CLR[4].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_6        CTU_0.CLR[5].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_6        CTU_0.CLR[5].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_6        CTU_0.CLR[5].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_7        CTU_0.CLR[6].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_7        CTU_0.CLR[6].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_7        CTU_0.CLR[6].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_8        CTU_0.CLR[7].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_8        CTU_0.CLR[7].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_8        CTU_0.CLR[7].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_9        CTU_0.CLR[8].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_9        CTU_0.CLR[8].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_9        CTU_0.CLR[8].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_10       CTU_0.CLR[9].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_10       CTU_0.CLR[9].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_10       CTU_0.CLR[9].C.R              /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_11       CTU_0.CLR[10].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_11       CTU_0.CLR[10].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_11       CTU_0.CLR[10].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_12       CTU_0.CLR[11].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_12       CTU_0.CLR[11].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_12       CTU_0.CLR[11].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_13       CTU_0.CLR[12].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_13       CTU_0.CLR[12].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_13       CTU_0.CLR[12].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_14       CTU_0.CLR[13].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_14       CTU_0.CLR[13].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_14       CTU_0.CLR[13].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_15       CTU_0.CLR[14].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_15       CTU_0.CLR[14].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_15       CTU_0.CLR[14].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_16       CTU_0.CLR[15].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_16       CTU_0.CLR[15].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_16       CTU_0.CLR[15].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_17       CTU_0.CLR[16].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_17       CTU_0.CLR[16].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_17       CTU_0.CLR[16].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_18       CTU_0.CLR[17].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_18       CTU_0.CLR[17].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_18       CTU_0.CLR[17].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_19       CTU_0.CLR[18].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_19       CTU_0.CLR[18].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_19       CTU_0.CLR[18].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_20       CTU_0.CLR[19].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_20       CTU_0.CLR[19].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_20       CTU_0.CLR[19].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_21       CTU_0.CLR[20].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_21       CTU_0.CLR[20].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_21       CTU_0.CLR[20].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_22       CTU_0.CLR[21].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_22       CTU_0.CLR[21].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_22       CTU_0.CLR[21].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_23       CTU_0.CLR[22].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_23       CTU_0.CLR[22].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_23       CTU_0.CLR[22].C.R             /* Command List Register C for self-test commands */
#define CTU_0_CLR_A_24       CTU_0.CLR[23].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_0_CLR_B_24       CTU_0.CLR[23].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_0_CLR_C_24       CTU_0.CLR[23].C.R             /* Command List Register C for self-test commands */
#define CTU_0_FDCR           CTU_0.FDCR.R                  /* FIFO DMA Control Register */
#define CTU_0_FCR            CTU_0.FCR.R                   /* FIFO Control Register */
#define CTU_0_FTH            CTU_0.FTH.R                   /* FIFO Threshold Register */
#define CTU_0_FST            CTU_0.FST.R                   /* FIFO Status Register */
#define CTU_0_FR0            CTU_0.FR[0].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FR1            CTU_0.FR[1].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FR2            CTU_0.FR[2].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FR3            CTU_0.FR[3].R                 /* FIFO Right Aligned Data Register */
#define CTU_0_FL0            CTU_0.FL[0].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_FL1            CTU_0.FL[1].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_FL2            CTU_0.FL[2].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_FL3            CTU_0.FL[3].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_0_EFR            CTU_0.EFR.R                   /* Error Flag Register */
#define CTU_0_IFR            CTU_0.IFR.R                   /* Interrupt Flag Register */
#define CTU_0_IR             CTU_0.IR.R                    /* Interrupt/DMA Register */
#define CTU_0_COTR           CTU_0.COTR.R                  /* Control ON Time Register */
#define CTU_0_CR             CTU_0.CR.R                    /* Control Register */
#define CTU_0_DFR            CTU_0.DFR.R                   /* Digital Filter Register */
#define CTU_0_EXPAR          CTU_0.EXPAR.R                 /* Expected Value A Register */
#define CTU_0_EXPBR          CTU_0.EXPBR.R                 /* Expected Value B Register */
#define CTU_0_CNTRNGR        CTU_0.CNTRNGR.R               /* Counter Range Register */
#define CTU_0_LISTCSR        CTU_0.LISTCSR.R               /* List Control/Status Register */

#define CTU_1_TGSISR         CTU_1.TGSISR.R                /* Trigger Generator Subunit Input Selection Register */
#define CTU_1_TGSCR          CTU_1.TGSCR.R                 /* Trigger Generator Subunit Control Register */
#define CTU_1_T0CR           CTU_1.TCR[0].R                /* Trigger Compare Register */
#define CTU_1_T1CR           CTU_1.TCR[1].R                /* Trigger Compare Register */
#define CTU_1_T2CR           CTU_1.TCR[2].R                /* Trigger Compare Register */
#define CTU_1_T3CR           CTU_1.TCR[3].R                /* Trigger Compare Register */
#define CTU_1_T4CR           CTU_1.TCR[4].R                /* Trigger Compare Register */
#define CTU_1_T5CR           CTU_1.TCR[5].R                /* Trigger Compare Register */
#define CTU_1_T6CR           CTU_1.TCR[6].R                /* Trigger Compare Register */
#define CTU_1_T7CR           CTU_1.TCR[7].R                /* Trigger Compare Register */
#define CTU_1_TGSCCR         CTU_1.TGSCCR.R                /* TGS Counter Compare Register */
#define CTU_1_TGSCRR         CTU_1.TGSCRR.R                /* TGS Counter Reload Register */
#define CTU_1_CLCR1          CTU_1.CLCR1.R                 /* Commands List Control Register 1 */
#define CTU_1_CLCR2          CTU_1.CLCR2.R                 /* Commands List Control Register 2 */
#define CTU_1_THCR1          CTU_1.THCR1.R                 /* Trigger Handler Control Register 1 */
#define CTU_1_THCR2          CTU_1.THCR2.R                 /* Trigger Handler Control Register 2 */
#define CTU_1_CLR_A_1        CTU_1.CLR[0].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_1        CTU_1.CLR[0].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_1        CTU_1.CLR[0].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_2        CTU_1.CLR[1].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_2        CTU_1.CLR[1].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_2        CTU_1.CLR[1].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_3        CTU_1.CLR[2].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_3        CTU_1.CLR[2].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_3        CTU_1.CLR[2].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_4        CTU_1.CLR[3].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_4        CTU_1.CLR[3].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_4        CTU_1.CLR[3].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_5        CTU_1.CLR[4].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_5        CTU_1.CLR[4].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_5        CTU_1.CLR[4].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_6        CTU_1.CLR[5].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_6        CTU_1.CLR[5].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_6        CTU_1.CLR[5].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_7        CTU_1.CLR[6].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_7        CTU_1.CLR[6].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_7        CTU_1.CLR[6].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_8        CTU_1.CLR[7].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_8        CTU_1.CLR[7].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_8        CTU_1.CLR[7].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_9        CTU_1.CLR[8].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_9        CTU_1.CLR[8].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_9        CTU_1.CLR[8].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_10       CTU_1.CLR[9].A.R              /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_10       CTU_1.CLR[9].B.R              /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_10       CTU_1.CLR[9].C.R              /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_11       CTU_1.CLR[10].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_11       CTU_1.CLR[10].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_11       CTU_1.CLR[10].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_12       CTU_1.CLR[11].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_12       CTU_1.CLR[11].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_12       CTU_1.CLR[11].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_13       CTU_1.CLR[12].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_13       CTU_1.CLR[12].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_13       CTU_1.CLR[12].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_14       CTU_1.CLR[13].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_14       CTU_1.CLR[13].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_14       CTU_1.CLR[13].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_15       CTU_1.CLR[14].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_15       CTU_1.CLR[14].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_15       CTU_1.CLR[14].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_16       CTU_1.CLR[15].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_16       CTU_1.CLR[15].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_16       CTU_1.CLR[15].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_17       CTU_1.CLR[16].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_17       CTU_1.CLR[16].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_17       CTU_1.CLR[16].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_18       CTU_1.CLR[17].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_18       CTU_1.CLR[17].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_18       CTU_1.CLR[17].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_19       CTU_1.CLR[18].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_19       CTU_1.CLR[18].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_19       CTU_1.CLR[18].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_20       CTU_1.CLR[19].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_20       CTU_1.CLR[19].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_20       CTU_1.CLR[19].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_21       CTU_1.CLR[20].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_21       CTU_1.CLR[20].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_21       CTU_1.CLR[20].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_22       CTU_1.CLR[21].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_22       CTU_1.CLR[21].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_22       CTU_1.CLR[21].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_23       CTU_1.CLR[22].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_23       CTU_1.CLR[22].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_23       CTU_1.CLR[22].C.R             /* Command List Register C for self-test commands */
#define CTU_1_CLR_A_24       CTU_1.CLR[23].A.R             /* Commands List Register A for ADC single-conversion mode commands */
#define CTU_1_CLR_B_24       CTU_1.CLR[23].B.R             /* Command List Register B for ADC dual-conversion mode commands */
#define CTU_1_CLR_C_24       CTU_1.CLR[23].C.R             /* Command List Register C for self-test commands */
#define CTU_1_FDCR           CTU_1.FDCR.R                  /* FIFO DMA Control Register */
#define CTU_1_FCR            CTU_1.FCR.R                   /* FIFO Control Register */
#define CTU_1_FTH            CTU_1.FTH.R                   /* FIFO Threshold Register */
#define CTU_1_FST            CTU_1.FST.R                   /* FIFO Status Register */
#define CTU_1_FR0            CTU_1.FR[0].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FR1            CTU_1.FR[1].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FR2            CTU_1.FR[2].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FR3            CTU_1.FR[3].R                 /* FIFO Right Aligned Data Register */
#define CTU_1_FL0            CTU_1.FL[0].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_FL1            CTU_1.FL[1].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_FL2            CTU_1.FL[2].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_FL3            CTU_1.FL[3].R                 /* FIFO Signed Left Aligned Data Register */
#define CTU_1_EFR            CTU_1.EFR.R                   /* Error Flag Register */
#define CTU_1_IFR            CTU_1.IFR.R                   /* Interrupt Flag Register */
#define CTU_1_IR             CTU_1.IR.R                    /* Interrupt/DMA Register */
#define CTU_1_COTR           CTU_1.COTR.R                  /* Control ON Time Register */
#define CTU_1_CR             CTU_1.CR.R                    /* Control Register */
#define CTU_1_DFR            CTU_1.DFR.R                   /* Digital Filter Register */
#define CTU_1_EXPAR          CTU_1.EXPAR.R                 /* Expected Value A Register */
#define CTU_1_EXPBR          CTU_1.EXPBR.R                 /* Expected Value B Register */
#define CTU_1_CNTRNGR        CTU_1.CNTRNGR.R               /* Counter Range Register */
#define CTU_1_LISTCSR        CTU_1.LISTCSR.R               /* List Control/Status Register */

/* DMA */
#define DMA_CR               DMA.CR.R                      /* Control Register */
#define DMA_ES               DMA.ES.R                      /* Error Status Register */
#define DMA_ERQ              DMA.ERQ.R                     /* Enable Request Register */
#define DMA_EEI              DMA.EEI.R                     /* Enable Error Interrupt Register */
#define DMA_SERQ             DMA.SERQ.R                    /* Set Enable Request Register */
#define DMA_CERQ             DMA.CERQ.R                    /* Clear Enable Request Register */
#define DMA_SEEI             DMA.SEEI.R                    /* Set Enable Error Interrupt Register */
#define DMA_CEEI             DMA.CEEI.R                    /* Clear Enable Error Interrupt Register */
#define DMA_CINT             DMA.CINT.R                    /* Clear Interrupt Request Register */
#define DMA_CERR             DMA.CERR.R                    /* Clear Error Register */
#define DMA_SSRT             DMA.SSRT.R                    /* Set START Bit Register */
#define DMA_CDNE             DMA.CDNE.R                    /* Clear DONE Status Bit Register */
#define DMA_INT              DMA.INT.R                     /* Interrupt Request Register */
#define DMA_ERR              DMA.ERR.R                     /* Error Register */
#define DMA_HRS              DMA.HRS.R                     /* Hardware Request Status Register */
#define DMA_GPORH            DMA.GPOR[0].R                 /* General-Purpose Output Register */
#define DMA_GPORL            DMA.GPOR[1].R                 /* General-Purpose Output Register */
#define DMA_DCHPRI0          DMA.DCHPRI[0].R               /* Channel n Priority Register */
#define DMA_DCHPRI1          DMA.DCHPRI[1].R               /* Channel n Priority Register */
#define DMA_DCHPRI2          DMA.DCHPRI[2].R               /* Channel n Priority Register */
#define DMA_DCHPRI3          DMA.DCHPRI[3].R               /* Channel n Priority Register */
#define DMA_DCHPRI4          DMA.DCHPRI[4].R               /* Channel n Priority Register */
#define DMA_DCHPRI5          DMA.DCHPRI[5].R               /* Channel n Priority Register */
#define DMA_DCHPRI6          DMA.DCHPRI[6].R               /* Channel n Priority Register */
#define DMA_DCHPRI7          DMA.DCHPRI[7].R               /* Channel n Priority Register */
#define DMA_DCHPRI8          DMA.DCHPRI[8].R               /* Channel n Priority Register */
#define DMA_DCHPRI9          DMA.DCHPRI[9].R               /* Channel n Priority Register */
#define DMA_DCHPRI10         DMA.DCHPRI[10].R              /* Channel n Priority Register */
#define DMA_DCHPRI11         DMA.DCHPRI[11].R              /* Channel n Priority Register */
#define DMA_DCHPRI12         DMA.DCHPRI[12].R              /* Channel n Priority Register */
#define DMA_DCHPRI13         DMA.DCHPRI[13].R              /* Channel n Priority Register */
#define DMA_DCHPRI14         DMA.DCHPRI[14].R              /* Channel n Priority Register */
#define DMA_DCHPRI15         DMA.DCHPRI[15].R              /* Channel n Priority Register */
#define DMA_DCHPRI16         DMA.DCHPRI[16].R              /* Channel n Priority Register */
#define DMA_DCHPRI17         DMA.DCHPRI[17].R              /* Channel n Priority Register */
#define DMA_DCHPRI18         DMA.DCHPRI[18].R              /* Channel n Priority Register */
#define DMA_DCHPRI19         DMA.DCHPRI[19].R              /* Channel n Priority Register */
#define DMA_DCHPRI20         DMA.DCHPRI[20].R              /* Channel n Priority Register */
#define DMA_DCHPRI21         DMA.DCHPRI[21].R              /* Channel n Priority Register */
#define DMA_DCHPRI22         DMA.DCHPRI[22].R              /* Channel n Priority Register */
#define DMA_DCHPRI23         DMA.DCHPRI[23].R              /* Channel n Priority Register */
#define DMA_DCHPRI24         DMA.DCHPRI[24].R              /* Channel n Priority Register */
#define DMA_DCHPRI25         DMA.DCHPRI[25].R              /* Channel n Priority Register */
#define DMA_DCHPRI26         DMA.DCHPRI[26].R              /* Channel n Priority Register */
#define DMA_DCHPRI27         DMA.DCHPRI[27].R              /* Channel n Priority Register */
#define DMA_DCHPRI28         DMA.DCHPRI[28].R              /* Channel n Priority Register */
#define DMA_DCHPRI29         DMA.DCHPRI[29].R              /* Channel n Priority Register */
#define DMA_DCHPRI30         DMA.DCHPRI[30].R              /* Channel n Priority Register */
#define DMA_DCHPRI31         DMA.DCHPRI[31].R              /* Channel n Priority Register */
#define DMA_DCHMID0          DMA.DCHMID[0].R               /* Channel n Master ID Register */
#define DMA_DCHMID1          DMA.DCHMID[1].R               /* Channel n Master ID Register */
#define DMA_DCHMID2          DMA.DCHMID[2].R               /* Channel n Master ID Register */
#define DMA_DCHMID3          DMA.DCHMID[3].R               /* Channel n Master ID Register */
#define DMA_DCHMID4          DMA.DCHMID[4].R               /* Channel n Master ID Register */
#define DMA_DCHMID5          DMA.DCHMID[5].R               /* Channel n Master ID Register */
#define DMA_DCHMID6          DMA.DCHMID[6].R               /* Channel n Master ID Register */
#define DMA_DCHMID7          DMA.DCHMID[7].R               /* Channel n Master ID Register */
#define DMA_DCHMID8          DMA.DCHMID[8].R               /* Channel n Master ID Register */
#define DMA_DCHMID9          DMA.DCHMID[9].R               /* Channel n Master ID Register */
#define DMA_DCHMID10         DMA.DCHMID[10].R              /* Channel n Master ID Register */
#define DMA_DCHMID11         DMA.DCHMID[11].R              /* Channel n Master ID Register */
#define DMA_DCHMID12         DMA.DCHMID[12].R              /* Channel n Master ID Register */
#define DMA_DCHMID13         DMA.DCHMID[13].R              /* Channel n Master ID Register */
#define DMA_DCHMID14         DMA.DCHMID[14].R              /* Channel n Master ID Register */
#define DMA_DCHMID15         DMA.DCHMID[15].R              /* Channel n Master ID Register */
#define DMA_DCHMID16         DMA.DCHMID[16].R              /* Channel n Master ID Register */
#define DMA_DCHMID17         DMA.DCHMID[17].R              /* Channel n Master ID Register */
#define DMA_DCHMID18         DMA.DCHMID[18].R              /* Channel n Master ID Register */
#define DMA_DCHMID19         DMA.DCHMID[19].R              /* Channel n Master ID Register */
#define DMA_DCHMID20         DMA.DCHMID[20].R              /* Channel n Master ID Register */
#define DMA_DCHMID21         DMA.DCHMID[21].R              /* Channel n Master ID Register */
#define DMA_DCHMID22         DMA.DCHMID[22].R              /* Channel n Master ID Register */
#define DMA_DCHMID23         DMA.DCHMID[23].R              /* Channel n Master ID Register */
#define DMA_DCHMID24         DMA.DCHMID[24].R              /* Channel n Master ID Register */
#define DMA_DCHMID25         DMA.DCHMID[25].R              /* Channel n Master ID Register */
#define DMA_DCHMID26         DMA.DCHMID[26].R              /* Channel n Master ID Register */
#define DMA_DCHMID27         DMA.DCHMID[27].R              /* Channel n Master ID Register */
#define DMA_DCHMID28         DMA.DCHMID[28].R              /* Channel n Master ID Register */
#define DMA_DCHMID29         DMA.DCHMID[29].R              /* Channel n Master ID Register */
#define DMA_DCHMID30         DMA.DCHMID[30].R              /* Channel n Master ID Register */
#define DMA_DCHMID31         DMA.DCHMID[31].R              /* Channel n Master ID Register */
#define DMA_TCD0_SADDR       DMA.TCD[0].SADDR.R            /* TCD Source Address */
#define DMA_TCD0_ATTR        DMA.TCD[0].ATTR.R             /* TCD Transfer Attributes */
#define DMA_TCD0_SOFF        DMA.TCD[0].SOFF.R             /* TCD Signed Source Address Offset */
#define DMA_TCD0_NBYTES_MLNO DMA.TCD[0].NBYTES.MLNO.R      /* TCD Minor Byte Count (Minor Loop Mapping Disabled) */
#define DMA_TCD0_NBYTES_MLOFFNO DMA.TCD[0].NBYTES.MLOFFNO.R /* TCD Signed Minor Loop Offset (Minor 