/*****************************************************************************/
/* FILE NAME: mcu_init.c                                                     */
/* COPYRIGHT (c) Freescale 2012                                              */
/* Copyright 2019 NXP                                              */
/* All Rights Reserved                                                       */
/* DESCRIPTION: Provides functions to Initilise MPC577xN MCU                 */
/*                                                                           */
/*****************************************************************************/

// TO DO
// determine PLL speeds
// determine divides for the system clocks
// determine divides for the aux clocks
// Check SMPU


//#include "typedefs.h"
#include "derivative.h" /* include peripheral declarations */


/******************** Configure the Mode and Clock Tree **********************/
void MC_MODE_INIT(void){

    MC_ME.ME.R = 0x000005E2;    // Enable mode transition to other modes

    /* Setting RUN Configuration Register ME_RUN_PC[0] */
    MC_ME.RUN_PC[0].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[1].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[2].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[3].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[4].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[5].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[6].R=0x000000FE;              /* Peripheral ON in every mode */
    MC_ME.RUN_PC[7].R=0x000000FE;              /* Peripheral ON in every mode */


    /* Configure System clock dividers */
    CGM.SC_DC0.R = 0x80010000;    // Z4, Checker core
//    CGM.SC_DC1.R = 0x80000000;    // Z7a
//    CGM.SC_DC2.R = 0x80000000;    // Z7b   
//    CGM.SC_DC3.R = 0x80030000;    // AIPS    
//    CGM.SC_DC4.R = 0x80010000;    // DMA

    //enable interrupts

    MC_ME.IM.R=0x3F;  /*Enable all interrupts*/

}
/******************************************************************************
 * Turn on 40Mz Oscillator in AFE
 ******************************************************************************/

void OSC_INIT (void)
{
    while (AFE.LVDSTS.B.BGOK !=1);    /* 1.2V Vref is present */
    /* Turn On XOSC - PLL's remain off */
    AFE.OSCDLY.R = 0x80;        // Set the EOCV value for OSC Stability

    MC_ME.DRUN_MC.B.XOSCON=1;     //Enable the EXTAL clk

    /* RE enter the drun mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;              /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);         /* Wait for mode entry to complete */

    while(AFE.OSCSTS.B.STS !=1);
}

/******************************************************************************
 * Configure Clock Divder setting
 ******************************************************************************/
void CGM_INIT (void)
{
    /* Enable and configure Aux clocks */

    /* Auxiliary Clock 0 */
    CGM.AC0_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for MC_CLK, SWG_CLK, ADC_CLK */

    CGM.AC0_DC0.B.DIV=1;        /* Divide by 2 */
    CGM.AC0_DC0.B.DE=1;         /* Enable Auxilliary Clock 0 divider 0 (Motor Control clock) (max 160Mhz)*/

    CGM.AC0_DC2.B.DIV=3;        /* Divide by 4 */
    CGM.AC0_DC2.B.DE=1;         /* Enable Auxilliary Clock 0 divider 2 (SARADC clock) (max 160Mhz)*/

    /* Auxiliary Clock 1 */
    CGM.AC1_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for FR_CLK */

    CGM.AC1_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC1_DC0.B.DE=1;         /* Enable Auxilliary Clock 1 divider 0 (FlexRay) (max 80Mhz)*/

    /* Auxiliary Clock 2 */
    CGM.AC2_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for CAN0_CLK */

    CGM.AC2_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC2_DC0.B.DE=1;         /* Enable Auxilliary Clock 2 divider 0 (CAN) (max 90Mhz)*/

    /* Auxiliary Clock 3 set in PLL0 routine */    
    /* Auxiliary Clock 4 set in PLL1 routine*/

    /* Auxiliary Clock 5 - NOT IMPLEMENTED */
    /* Auxiliary Clock 6 - NOT IMPLEMENTED */

    /* Auxiliary Clock 7 */
    CGM.AC7_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for SPT_CLK */

    CGM.AC7_DC0.B.DIV=0;        /* Divide by 1 */
    CGM.AC7_DC0.B.DE=1;         /* Enable Auxilliary Clock 7 divider 0 (SPT_CLK) (max 200Mhz)*/

    /* Auxiliary Clock 8 */
    CGM.AC8_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for LFAST_CLK */

    CGM.AC8_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC8_DC0.B.DE=1;         /* Enable Auxilliary Clock 8 divider 0 (LFAST_CLK)(max 320Mhz) */

    /* Auxiliary Clock 9 to be replaced by CLKOUT SEL later */
//   CGM.AC9_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for CLK_OUT1 */

//   CGM.AC9_DC0.B.DIV=3;        /* Divide by 4 */
//   CGM.AC9_DC0.B.DE=1;         /* Enable Auxilliary Clock 9 divider 0 (CLK_OUT1) */

    /* Auxiliary Clock 10 */
    CGM.AC10_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for ENET_CLK */

    CGM.AC10_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC10_DC0.B.DE=1;         /* Enable Auxilliary Clock 10 divider 0 (ENET_CLK) (max 50Mhz)*/

    /* Auxiliary Clock 11 */
    CGM.AC11_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for ENET_TIME_CLK (max 100Mhz)*/

    CGM.AC11_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC11_DC0.B.DE=1;         /* Enable Auxilliary Clock 11 divider 0 (ENET_TIME_CLK) */

    /* Auxiliary Clock 12 */
    CGM.AC12_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for LINIPS_CLK */

    CGM.AC12_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC12_DC0.B.DE=1;         /* Enable Auxilliary Clock 12 divider 0 (LINIPS_CLK) */

    /* Auxiliary Clock 13 */
    CGM.AC13_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for LIN_CLK */

    CGM.AC13_DC0.B.DIV=3;        /* Divide by 4 */
    CGM.AC13_DC0.B.DE=1;         /* Enable Auxilliary Clock 13 divider 0 (LIN_CLK) */

    /* Auxiliary Clock 14 to be replaced by CLKOUT SEL later*/
//   CGM.AC14_SC.B.SELCTL=2;      /* (PLL0_PHI_CLK) clock source for CLK_OUT0 */

//   CGM.AC14_DC0.B.DIV=3;        /* Divide by 4 */
//   CGM.AC14_DC0.B.DE=1;         /* Enable Auxilliary Clock 14 divider 0 (CLK_OUT0) (max 67Mhz)*/

}

/******************************************************************************
 * Turn on PLL_0
 ******************************************************************************/

void PLL_INIT_0(void)
{  

    MC_ME.DRUN_MC.B.PLL0ON=0;     //Disable PLL0 - debug only

    /* Route XOSC to the PLL's - IRC is default */
    CGM.AC3_SC.B.SELCTL=1;        /* Connect XOSC to PLL0 */

 //   PLLDIG.PLL0DV.R = 0x40022014;    /* Divider for PLL0 200Mhz - 0x40041014*/
    PLLDIG.PLL0DV.R = 0x40022010;
    PLLDIG.PLL0CR.R = 0x308;        /* Set PLL0 into Normal mode */

    MC_ME.DRUN_MC.B.PLL0ON=1;     //Enable PLL0
    /* RE  enter the drun mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;                 /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                    /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);        /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);      /* Check DRUN mode has been entered */

    //waiting for PLL0 to lock
    while(PLLDIG.PLL0SR.B.LOCK ==0);
    while(MC_ME.GS.B.S_PLL0 ==0);

}

/******************************************************************************
 * Turn on PLL_1
 ******************************************************************************/

void PLL_INIT_1(void)
{

    MC_ME.DRUN_MC.B.PLL1ON=0;     //Disable PLL1 - debug only

    /* Route XOSC to the PLL's - IRC is default */
    CGM.AC4_SC.B.SELCTL=0;               /* Connect XOSC to PLL1 */

    PLLDIG.PLL1DV.R = 0x30020;        /* Divider for PLL1 260Mhz*/
    PLLDIG.PLL1FD.R = 0x40000999;    /* Fractional Divider 6Mhz */    
    PLLDIG.PLL1CR.R = 0x8;        /* Set PLL1 into Normal mode */

    MC_ME.DRUN_MC.B.PLL1ON=1;         //Enable PLL1
    /* RE  enter the drun mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;                 /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                    /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);        /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);      /* Check DRUN mode has been entered */

//waiting for PLL1 to lock
    while(PLLDIG.PLL1SR.B.LOCK ==0);
    while(MC_ME.GS.B.S_PLL1 ==0);

}  
/******************************************************************************
 * Set the system clk frequency
 ******************************************************************************/
void SET_SYS_CLK (void){
//    MC_ME.DRUN_MC.B.SYSCLK=0;        /* IRC system CLK */
//    MC_ME.DRUN_MC.B.SYSCLK=1;        /* XOSC system CLK */
//    MC_ME.DRUN_MC.B.SYSCLK=2;        /* PLL0 system CLK */
//    MC_ME.DRUN_MC.B.SYSCLK=3;        /* SDPLL /2 (160Mhz) system CLK */
    MC_ME.DRUN_MC.B.SYSCLK=4;        /* PLL1 system CLK */
    
    /* RE  enter the drun mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;                 /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                    /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);        /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);      /* Check DRUN mode has been entered */
}

/******************************************************************************
 * Turn on SDPLL
 ******************************************************************************/

void SDPLL_INIT (void){

    uint32_t i=0;

    while (!AFE.LVDSTS.B.BGOK);    //check 1.25v rail is up

    AFE.PLLCTRL2.R = 0x6;
    for (i=0;i<0xFFFF;i++);

    while (AFE.PLLSTS.R == 0x4);  // check for cal error

    AFE.PLLCTRL2.R = 0x4f02; // Set FCAP = 58, start calibration
    for (i=0;i<0xFFFF;i++);

    while (AFE.PLLSTS.R == 0x4);  // check for cal error

    AFE.PLLCTRL1.R = 0x8081;        // Deaasert Reset_b

    MC_ME.DRUN_MC.B.SDPLLON=1;         //Enable PLL1
    /* RE  enter the drun mode, to update the configuration */
    MC_ME.MCTL.R = 0x30005AF0;                 /* Mode & Key */
    MC_ME.MCTL.R = 0x3000A50F;                    /* Mode & Key inverted */
    while(MC_ME.GS.B.S_MTRANS == 1);        /* Wait for mode entry to complete */
    while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);      /* Check DRUN mode has been entered */

}

/******************************************************************************
 * Turn on VREG Trimming
 ******************************************************************************/

void VREG_TRIM()
{
//    AFE.VREGCNTRL[2].R = 0x54;        /*  OverTrim VREG for the AFE ADC analog */
//    AFE.VREGCNTRL[3].R = 0x34;        /*  OverTrim VREG for the AFE ADC digital */
//    AFE.VREGCNTRL[4].R = 0x74;        /*  OverTrim VREG for the AFE ADC DAC */
}

/******************************************************************************
 * Calibrate the SDPLL
 ******************************************************************************/


void SDADC_CAL()
{
    AFE.ADCCTRL2.B.RT_PWRDN = 0;
    AFE.ADCTRIM.B.RMASK = 1;
    AFE.ADCTRIM.B.RMASK = 0;

    while(AFE.ADCTRIM.B.RESRDY);

 //   AFE.ADCCTRL2.B.TO_RST_B = 1;
    AFE.ADCTOT.R = 0x0000FFFF;

    while(!AFE.ADCTRIM.B.RESRDY);

    AFE.ADCCTRL7.R = 0x4000;    // Enable all channels
}

/******************************************************************************
 * Enable Clock Out
 ******************************************************************************/

void CLK_OUT(void)
{  

//    *(vuint32_t*)((0xFFC10028))= 0x0;        /* Set IRC to CLK_OUT on Pin PE9 on motherboard */    
//    *(vuint32_t*)((0xFFC10028))= 0x40;    /* Set XOSC to CLK_OUT on Pin PE9 */
//    *(vuint32_t*)((0xFFC10028))= 0x80;    /* Set PLL0 to CLK_OUT on Pin PE9 */
    *(vuint32_t*)((0xFFC10028))= 0x100;    /* Set PLL1 to CLK_OUT on Pin PE9 */
//    *(vuint32_t*)((0xFFC10028))= 0x280;    /* Set SDPLL to CLK_OUT on Pin PE9 */

//    CGM.AC14_DC0.B.DE =0x1;
//    CGM.AC14_DC0.B.DIV =0x7;
    CGM.AC14_DC0.R = 0x80130000;        //x20

//    SIUL2.MSCR[22].R =  0x32840001; /* PA15 as Sysclk 1 */
    SIUL2.MSCR[22].R =  0x22840001; /* PA15 as Sysclk 1 */

}

/******************************************************************************
 * Turn on both z7 Cores
 ******************************************************************************/
void CORE_INIT(void)
{  

    /* Enable cores if running from RAM or not using the BAF  to boot cores*/
    /* Enable Cores - Will start on next mode transistion */

    /* Enable or disable core 0 (Z4 - Lock Step Core) */
    MC_ME.CCTL1.R = 0x00FE;        /* enable core */
//      MC_ME.CCTL[1].R = 0x0000;    /* disable core */

    /* Enable or disable core 1 (z7a) */
    MC_ME.CCTL2.R = 0x00FE;        /* enable core */
//      MC_ME.CCTL[2].R = 0x0000;    /* disable core */


    /* Enable or disable core 2 (z7b)*/
    MC_ME.CCTL3.R = 0x00FE;        /* enable core */
//      MC_ME.CCTL[3].R = 0x0000;    /* disable core */


    /* FLASH: Set Start address for other cores: Will reset and start */
    MC_ME.CADDR1.R = 0x01000001;
    MC_ME.CADDR2.R = 0x01040001;
    MC_ME.CADDR3.R = 0x01080001;

    /* RAM: Set Start address for other cores: Will reset and start */
//   MC_ME.CADDR1.R = 0x40018001;
//   MC_ME.CADDR2.R = 0x40018001;
//   MC_ME.CADDR3.R = 0x4001C001;

}


/************** Configure the MPU - Make RAM and Flash Cachable **************/
void MPU_INIT(void)
{

/* Configure Flash region */
    //start address - beginning of small/medium flash blocks
    SMPU_0.RGD[0].WORD0.R = 0x00A00000;

    //end address - end of large flash blocks
    SMPU_0.RGD[0].WORD1.R = 0x02000000;

    //access control - all bus masters have rw access
    SMPU_0.RGD[0].WORD2.R = 0xFFFFFFFF;
 

    //region descriptor valid
    SMPU_0.RGD[0].WORD3.B.VLD = 1;

/* Configure RAM region */
    //start address - beginning of system RAM
    SMPU_0.RGD[1].WORD0.R = 0x40000000;

    //end address - end of local memory
    SMPU_0.RGD[1].WORD1.R = 0x50810000;

    //access control - all bus masters have rw access
    SMPU_0.RGD[1].WORD2.R = 0xFFFFFFFF;


    //region descriptor valid
    SMPU_0.RGD[1].WORD3.B.VLD = 1;

/* Enable the module */ 
    SMPU_0.CESR0.B.GVLD = 1; 

}/* MPU_Init */


/******************************************************************************
 * config AIPS to allows r/w access from all cores, all Nexus, eDMA
 check for gap in mem map
 ******************************************************************************/

void AIPS_INT (void){
    AIPS_0.MPRA.R = 0x77700007;
//    AIPS_0.MPRB.R = 0x77000007;
    AIPS_1.MPRA.R = 0x77700007;
//    AIPS_1.MPRB.R = 0x77000007;
}

/******************************************************************************
 * Toggle GPIO pin
 ******************************************************************************/
void PORT_TOGGLE (void){

    volatile uint32_t i=0;

    while(1){
        SIUL2.MSCR[4].R =  0x32840000;     /* GPIO 4 = PL0 on Motherboard */
        SIUL2.GPDO[4].B.PDO_4n = 0x1;      /* Toggle Pin PL0 */
        for (i=0;i<0xFFFF;i++);            /* delay to see port toggle */
        SIUL2.GPDO[4].B.PDO_4n = 0x0;      /* Toggle Pin PL0 */
        for (i=0;i<0xFFFF;i++);            /* delay to see port toggle */
    }

}

