/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import com.pemicro.corePlugin.JLink;
import com.pemicro.corePlugin.MyCallback;
import com.pemicro.corePlugin.PException;
import com.pemicro.debugView.CoreDebug;
import com.pemicro.forms.AddEthernetIP;
import com.pemicro.forms.AskProgramFlash;
import com.pemicro.forms.CProgStatus;
import com.pemicro.forms.Cycles;
import com.pemicro.forms.FirmwareUpdate;
import com.pemicro.forms.IPEKeys;
import com.pemicro.forms.InputQuery;
import com.pemicro.forms.InputWindow;
import com.pemicro.forms.MessageDialog;
import com.pemicro.forms.PickWindow;
import com.pemicro.forms.PowerDialog;
import com.pemicro.forms.UnsecureWindow;
import com.pemicro.forms.advProgrammingOptions.AdvProgrammingOptions;
import com.pemicro.forms.advProgrammingOptions.data.OptionsData;
import com.pemicro.forms.chip.ChipCommand;
import com.pemicro.forms.chip.ChipResponse;
import com.pemicro.forms.chip.ChipView;
import com.pemicro.forms.chip.ChipWindow;
import com.pemicro.forms.chip.SignalView;
import com.pemicro.forms.chip.SignalWindow;
import com.pemicro.forms.chip.data.ChipData;
import com.pemicro.forms.chip.data.PinData;
import com.pemicro.forms.connection.ConnectionAssistant;
import com.pemicro.forms.connection.Interface;
import com.pemicro.launch.LCFData;
import com.pemicro.menu.MenuData;
import com.pemicro.menu.PEMenu;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ProcessWindow {
    private final boolean SIGNAL_WINDOW_SUPPORT = true;
    private PickWindow pickWindow;
    private PowerDialog powerDialog;
    private InputQuery inputQuery;
    private MessageDialog messageDialog;
    private FirmwareUpdate firmwareUpdate;
    private AdvProgrammingOptions advProgrammingOptions;
    private Cycles cycles;
    private AddEthernetIP addEthernetIP;
    private AskProgramFlash askProgramFlash;
    private InputWindow inputWindow;
    private ConnectionAssistant connectionAssistant;
    private CProgStatus cprogStatus;
    private ChipWindow chipWindow;
    private SignalWindow signalWindow;
    private UnsecureWindow unsecureWindow;
    private JLink stream;
    private LinkedList<String> pickWindowList = new LinkedList();
    private LinkedList<LCFData> lcfDataList = new LinkedList();
    private int newMenuID = 0;
    private MyCallback callback;
    private PEMenu peMenu;
    ChipCommand command;
    ChipData chipData;
    boolean lcfManagerHasListener = false;

    public ProcessWindow(MyCallback callback) {
        this.callback = callback;
    }

    public void setCallback(MyCallback callback) {
        this.callback = callback;
    }

    public void configureProcessWindow(JLink stream) {
        this.stream = stream;
        switch (stream.getDialogNumber()) {
            case 1: {
                if (this.pickWindow != null) break;
                this.pickWindow = new PickWindow();
                break;
            }
            case 2: {
                if (this.powerDialog != null) break;
                this.powerDialog = new PowerDialog();
                break;
            }
            case 3: {
                if (this.inputQuery != null) break;
                this.inputQuery = new InputQuery();
                break;
            }
            case 4: {
                if (this.messageDialog != null) break;
                this.messageDialog = new MessageDialog();
                break;
            }
            case 5: {
                if (this.advProgrammingOptions != null) break;
                this.advProgrammingOptions = new AdvProgrammingOptions();
                break;
            }
            case 7: {
                if (this.firmwareUpdate != null) break;
                this.firmwareUpdate = new FirmwareUpdate();
                break;
            }
            case 8: {
                if (this.inputWindow != null) break;
                this.inputWindow = new InputWindow();
                break;
            }
            case 9: {
                if (this.cycles != null) break;
                this.cycles = new Cycles();
                break;
            }
            case 10: {
                if (this.inputWindow != null) break;
                this.inputWindow = new InputWindow();
                break;
            }
            case 11: {
                if (this.addEthernetIP != null) break;
                this.addEthernetIP = new AddEthernetIP();
                break;
            }
            case 13: {
                if (this.askProgramFlash != null) break;
                this.askProgramFlash = new AskProgramFlash();
                break;
            }
            case 16: {
                if (this.inputWindow != null) break;
                this.inputWindow = new InputWindow();
                break;
            }
            case 17: {
                if (this.connectionAssistant != null) break;
                this.connectionAssistant = new ConnectionAssistant();
                break;
            }
            case 20: {
                if (this.cprogStatus != null) break;
                this.cprogStatus = new CProgStatus();
                break;
            }
            case 21: {
                if (this.chipWindow != null) break;
                try {
                    this.chipData = new ChipData();
                    this.chipWindow = new ChipWindow();
                    this.signalWindow = SignalWindow.getInstance();
                    this.command = new ChipCommand();
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                }
                break;
            }
            case 48: {
                if (this.peMenu != null) break;
                PEMenu.setCallbackClient(this.callback);
                this.peMenu = new PEMenu();
                break;
            }
            case 26: {
                if (this.unsecureWindow != null) break;
                this.unsecureWindow = new UnsecureWindow();
            }
        }
    }

    public boolean processTpPickWindow() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("PickList: Incorrect stream formatting");
            }
            long numItems = this.stream.readLong();
            boolean[] newEnable = new boolean[(int)numItems];
            String headerString = this.stream.readString();
            short dfltChoice = this.stream.readWord();
            this.pickWindowList.clear();
            int tempWord = 1;
            while ((long)tempWord <= numItems) {
                String tempString = this.stream.readString();
                newEnable[tempWord - 1] = tempString.charAt(0) == 'T';
                String value = tempString.substring(1);
                this.pickWindowList.add(value);
                ++tempWord;
            }
            String[] newString = this.pickWindowList.toArray(new String[(int)numItems]);
            this.pickWindow.setItems(newString, newEnable, headerString, dfltChoice);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.pickWindow);
            this.stream.writeWord(this.pickWindow.getSelectionValue());
            if (this.pickWindow.isSelected()) {
                this.stream.writeByte((byte)24);
            } else {
                this.stream.writeByte((byte)99);
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processBdcPowerDialog() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("PickList: Incorrect stream formatting");
            }
            String tempHeaderString = this.stream.readString();
            String tempCaption = this.stream.readString();
            short tempPicChoice = this.stream.readWord();
            this.powerDialog.setItems(tempHeaderString, tempCaption, tempPicChoice);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.powerDialog);
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processInputQuery() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Input Query: Incorrect stream formatting");
            }
            String tempHeaderString = this.stream.readString();
            String tempCaption = this.stream.readString();
            String tempValue = this.stream.readString();
            this.inputQuery.setItems(tempHeaderString, tempCaption, tempValue);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.inputQuery);
            if (this.inputQuery.isNewInputSelected()) {
                this.stream.writeString(this.inputQuery.getInput());
            } else {
                this.stream.writeString(tempValue);
            }
            this.stream.writeBoolean(this.inputQuery.isNewInputSelected());
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processUnsecureWindow() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Unsecure Window: Incorrect stream formatting");
            }
            String header = this.stream.readString();
            String caption = this.stream.readString();
            String code = this.stream.readString();
            this.unsecureWindow.setHeader(header);
            this.unsecureWindow.setCaption(caption);
            this.unsecureWindow.setCode(code);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.unsecureWindow);
            if (this.unsecureWindow.getCodeChanged()) {
                this.stream.writeString(this.unsecureWindow.getCode());
            } else {
                this.stream.writeString(code);
            }
            this.stream.writeBoolean(this.unsecureWindow.getCodeChanged());
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processMessageDialog() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Message Dialog: Incorrect stream formatting");
            }
            String tempMessage = this.stream.readString();
            short tempButtons = this.stream.readWord();
            byte tempType = this.stream.readByte();
            this.messageDialog.setItems(tempMessage, tempButtons, tempType);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.messageDialog);
            this.stream.writeWord(this.messageDialog.getButtonPressed());
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processCProgStatus() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("CProg Status: Incorrect stream formatting");
            }
            this.cprogStatus.setFormCommand(this.stream.readByte());
            switch (this.cprogStatus.getFormCommand()) {
                case 0: {
                    this.cprogStatus.setTitle(this.stream.readString());
                    this.cprogStatus.setButtonString(this.stream.readString());
                    this.cprogStatus.setErrorString(this.stream.readString());
                    this.cprogStatus.setUrl(this.stream.readString());
                    this.cprogStatus.setStatusBar(this.stream.readString());
                    break;
                }
                case 1: {
                    this.cprogStatus.setCProgStatusItem(this.stream.readString());
                    this.cprogStatus.setStatusBar(this.stream.readString());
                    this.cprogStatus.setErrorString(this.stream.readString());
                    this.cprogStatus.setAddNewLine(this.stream.readBoolean());
                    this.cprogStatus.setErrorOccured(this.stream.readBoolean());
                }
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.cprogStatus);
            this.stream.writeBoolean(this.cprogStatus.getResultSucess());
            if (this.cprogStatus.getFormCommand() == 1 && this.cprogStatus.getErrorOccured()) {
                this.stream.writeBoolean(this.cprogStatus.getAbortRequest());
            }
            if (this.cprogStatus.getFormCommand() == 3) {
                this.stream.writeBoolean(this.cprogStatus.getAbortRequest());
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processChipWindow() {
        block35: {
            try {
                ChipResponse.setRequestUpdateAll(false);
                short api = this.stream.readWord();
                if (api != 1 && api != 2) {
                    throw new PException("Chip Window Status: Incorrect stream formatting");
                }
                ChipView.setChipWindowEnabled(true);
                if (ChipView.isChipViewVisible() || SignalView.isSignalViewVisible()) {
                    if (ChipView.isChipViewVisible() && (this.chipWindow.getForm() == null || this.chipWindow.getForm().isDisposed()) && (this.chipWindow.getForm() == null || this.chipWindow.getForm().isDisposed())) {
                        this.chipWindow.setForm(ChipView.getForm());
                        if (this.chipWindow.getForm() != null) {
                            ChipResponse.setRequestUpdateAll(true);
                        }
                    }
                    if (SignalView.isSignalViewVisible() && SignalView.JustOpened) {
                        SignalView.JustOpened = false;
                        ChipResponse.setRequestUpdateAll(true);
                    }
                    if (!ChipResponse.getRequestUpdateAll()) {
                        int i;
                        this.command = new ChipCommand();
                        this.chipData = new ChipData();
                        this.command.setChipCommand(this.stream.readWord());
                        this.chipData.setPackageType(this.stream.readString());
                        this.chipData.setNumOfPins(this.stream.readWord());
                        this.chipData.setNumOfSides(this.stream.readWord());
                        if (this.command.hasPinCommands()) {
                            this.command.setNumOfPinsToRedraw(this.stream.readWord());
                            int i2 = 0;
                            while (i2 < this.command.getNumOfPinsToRedraw()) {
                                this.command.setPinCommand(i2, this.stream.readWord());
                                short num = this.stream.readWord();
                                this.chipData.getPinData()[i2].setNumber(num);
                                this.chipData.getPinData(num).setPinType(this.stream.readByte() << 12);
                                this.chipData.getPinData(num).setDirection(this.stream.readByte() << 4);
                                this.chipData.getPinData(num).setValue(this.stream.readByte());
                                this.chipData.getPinData(num).setSignalName(this.stream.readString());
                                this.chipData.getPinData(num).setModuleName(this.stream.readString());
                                this.chipData.getPinData(num).setID(this.stream.readLong());
                                this.chipData.getPinData(num).setDataType(this.stream.readByte());
                                this.chipData.getPinData(num).setAnalogValue(this.stream.readLong());
                                this.chipData.getPinData(num).setAnalogMax(this.stream.readLong());
                                this.chipData.getPinData(num).setAnalogMin(this.stream.readLong());
                                this.chipData.getPinData(num).setControllable(this.stream.readBoolean());
                                if (api > 1) {
                                    this.chipData.getPinData(num).setDisplayed(this.stream.readBoolean());
                                }
                                ++i2;
                            }
                        }
                        this.chipData.setChipType(this.stream.readByte());
                        boolean update = false;
                        this.chipData.setDeviceName(this.stream.readString());
                        this.chipData.setFreq(this.stream.readString());
                        if (this.chipWindow.getChip() != null) {
                            boolean bl = update = !this.chipWindow.getChip().getDeviceName().equals(this.chipData.getDeviceName()) || !this.chipWindow.getChip().getFreq().equals(this.chipData.getFreq());
                        }
                        if (this.chipData.getChipType() == 1) {
                            this.chipData.setCycles(this.stream.readString());
                            if (this.chipWindow.getChip() != null) {
                                boolean bl = update = update || !this.chipWindow.getChip().getCycles().equals(this.chipData.getCycles());
                            }
                        }
                        if (this.command.getCommand() == 6) {
                            this.command.setVControlPinName(this.stream.readString());
                            this.command.setVControlMinValue(this.stream.readLong());
                            this.command.setVControlMaxValue(this.stream.readLong());
                            this.command.setVControlCurrentValue(this.stream.readLong());
                        }
                        if (this.command.getCommand() != 3 || this.command.getNumOfPinsToRedraw() != 0 || update) {
                            block34: {
                                try {
                                    try {
                                        ChipWindow.semaphore.acquire();
                                        SignalWindow.semaphore.acquire();
                                        this.chipWindow.offerChipQueue(this.command, this.chipData);
                                        this.signalWindow.offerChipQueue(this.command, this.chipData);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        ChipWindow.semaphore.release();
                                        SignalWindow.semaphore.release();
                                        break block34;
                                    }
                                }
                                catch (Throwable num) {
                                    ChipWindow.semaphore.release();
                                    SignalWindow.semaphore.release();
                                    throw num;
                                }
                                ChipWindow.semaphore.release();
                                SignalWindow.semaphore.release();
                            }
                            if (!this.chipWindow.threadIsRunning() && ChipView.isChipViewVisible()) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)this.chipWindow);
                            }
                            if (!this.signalWindow.threadIsRunning() && SignalView.isSignalViewVisible()) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)this.signalWindow);
                            }
                        }
                        this.stream.writeWord((short)21);
                        this.stream.writeWord((short)1);
                        if (this.command.getCommand() == 10) {
                            this.stream.writeWord((short)8);
                            this.stream.writeWord((short)this.chipData.getNumOfPins());
                            i = 0;
                            while (i < this.chipData.getNumOfPins()) {
                                int number = this.chipWindow.getChip().getData().getPinData()[i].getNumber();
                                this.stream.writeBoolean(this.chipWindow.getChip().getData().getPinData(number).isDisplayed());
                                this.stream.writeLong(this.chipWindow.getChip().getData().getPinData(number).getID());
                                this.stream.writeByte((byte)(this.chipWindow.getChip().getData().getPinData(number).getDirection() >> 4));
                                this.stream.writeByte((byte)this.chipWindow.getChip().getData().getPinData(number).getDataType());
                                this.stream.writeByte((byte)this.chipWindow.getChip().getData().getPinData(number).getDigitalValue());
                                this.stream.writeLong(this.chipWindow.getChip().getData().getPinData(number).getAnalogValue());
                                this.stream.writeLong(this.chipWindow.getChip().getData().getPinData(number).getAnalogMax());
                                this.stream.writeLong(this.chipWindow.getChip().getData().getPinData(number).getAnalogMin());
                                if (api == 1) {
                                    this.stream.writeString(this.chipWindow.getChip().getData().getPinData(number).getModuleName());
                                }
                                if (api > 1) {
                                    this.stream.writeString(this.chipWindow.getChip().getData().getPinData(number).getSignalName());
                                }
                                ++i;
                            }
                        }
                        if (ChipResponse.doubleClickOccured()) {
                            ChipResponse.setDoubleClickOccured(false);
                            CoreDebug.writeDebug(1, "CHIP WINDOW - REPLY  = PROCESS CLICKS\r\n");
                            this.stream.writeWord((short)2);
                            this.stream.writeWord((short)ChipResponse.getDoubleClickList().size());
                            i = 0;
                            while (i < ChipResponse.getDoubleClickList().size()) {
                                PinData data = ChipResponse.getDoubleClickList().remove();
                                this.stream.writeLong(data.getID());
                                this.stream.writeWord((short)data.getNumber());
                                this.stream.writeWord((short)data.getDirectionDoubleClickNum(true));
                                this.stream.writeWord((short)data.getValueDoubleClickNum(true));
                                ++i;
                            }
                        } else if (ChipResponse.controlChanged()) {
                            CoreDebug.writeDebug(1, "CHIP WINDOW - REPLY  = PROCESS CONTROL WINDOW");
                            this.stream.writeWord((short)5);
                            this.stream.writeWord(api);
                            int pinSelection = ChipResponse.getPinNumber();
                            this.stream.writeLong(ChipResponse.getPinID());
                            this.stream.writeWord((short)pinSelection);
                            this.stream.writeByte((byte)(ChipResponse.getPinDirection() >> 4));
                            this.stream.writeByte((byte)ChipResponse.getDataType());
                            this.stream.writeByte((byte)ChipResponse.getDigitalValue());
                            this.stream.writeLong(ChipResponse.getAnalogValue());
                            this.stream.writeLong(ChipResponse.getAnalogMax());
                            this.stream.writeLong(ChipResponse.getAnalogMin());
                            if (api == 1) {
                                this.stream.writeString(ChipResponse.getModuleName());
                            }
                            if (api > 1) {
                                this.stream.writeString(ChipResponse.getSignalName());
                            }
                            this.stream.writeBoolean(ChipResponse.getPinValueChanged());
                            this.stream.writeBoolean(ChipResponse.getPinDirectionChanged());
                            ChipResponse.reset();
                        } else {
                            CoreDebug.writeDebug(1, "CHIP WINDOW - REPLY  = OK");
                            this.stream.writeWord((short)0);
                        }
                        break block35;
                    }
                    CoreDebug.writeDebug(1, "CHIP WINDOW - REPLY  = REQUEST UPDATE ALL");
                    this.stream.writeWord((short)21);
                    this.stream.writeWord((short)1);
                    this.stream.writeWord((short)1);
                    break block35;
                }
                CoreDebug.writeDebug(1, "CHIP WINDOW - REPLY  = REQUEST STOP");
                this.stream.writeWord((short)21);
                this.stream.writeWord((short)1);
                this.stream.writeWord((short)7);
                ChipView.setChipWindowEnabled(false);
            }
            catch (PException e) {
                e.printStackTrace(System.out);
                return false;
            }
        }
        return true;
    }

    public boolean processAdvProgrammingOptions() {
        try {
            short api = this.stream.readWord();
            if (api != 1 && api != 2 && api != 3) {
                throw new PException("AdvProgrammingOptions: Incorrect stream formatting");
            }
            OptionsData data = new OptionsData();
            data.setApi(api);
            data.setFunction(this.stream.readByte());
            CoreDebug.writeDebug(1, "ADV PROGRAMMING OPTIONS COMMAND = " + data.getFunction());
            data.setArchitecture(this.stream.readString());
            data.setAskProgram(this.stream.readBoolean());
            data.setCurrentAlgorithmIndex(this.stream.readByte());
            data.setAltAlgorithm0(this.stream.readString());
            data.setAltAlgorithm1(this.stream.readString());
            data.setAltAlgorithm2(this.stream.readString());
            data.setAltAlgorithm3(this.stream.readString());
            data.setAltAlgorithm4(this.stream.readString());
            data.setAltAlgorithm5(this.stream.readString());
            data.setAltAlgorithm6(this.stream.readString());
            data.setAltAlgorithm7(this.stream.readString());
            data.setAltAlgorithm8(this.stream.readString());
            data.setAltAlgorithm9(this.stream.readString());
            data.setUserAlgorithm(this.stream.readString());
            data.setUseAlternativeAlgorithm(this.stream.readBoolean());
            data.setAutoSync(this.stream.readBoolean());
            data.setDoTrim(this.stream.readBoolean());
            if (api >= 2) {
                data.setCustomTrimHigh(this.stream.readString());
                data.setCustomTrimLow(this.stream.readString());
                data.setCustomTrimDefault(this.stream.readString());
                data.setCustomTrimOverride(this.stream.readString());
                data.setCustomTrimEnabled(this.stream.readBoolean());
                CoreDebug.writeDebug(1, "PROCESS WINDOW CUSTOM TRIM ENABLED = " + data.isCustomTrimEnabled());
            }
            data.setPreserveRange1(this.stream.readBoolean());
            data.setPreserveRange1Start(this.stream.readString());
            data.setPreserveRange1End(this.stream.readString());
            data.setPreserveRange2(this.stream.readBoolean());
            data.setPreserveRange2Start(this.stream.readString());
            data.setPreserveRange2End(this.stream.readString());
            data.setPreserveRange3(this.stream.readBoolean());
            data.setPreserveRange3Start(this.stream.readString());
            data.setPreserveRange3End(this.stream.readString());
            if (api >= 2) {
                data.setHasEEProm(this.stream.readBoolean());
            }
            data.setPreserveEEProm(this.stream.readBoolean());
            if (api >= 2) {
                data.setPreserveEEPromStart(this.stream.readString());
                data.setPreserveEEPromEnd(this.stream.readString());
            }
            data.setPreserve1StartError(this.stream.readString());
            data.setPreserve1EndError(this.stream.readString());
            data.setPreserve2StartError(this.stream.readString());
            data.setPreserve2EndError(this.stream.readString());
            data.setPreserve3StartError(this.stream.readString());
            data.setPreserve3EndError(this.stream.readString());
            if (api >= 2) {
                data.setPreserveEEPromStartError(this.stream.readString());
                data.setPreserveEEPromEndError(this.stream.readString());
            }
            data.setOverlap1and2Error(this.stream.readString());
            data.setOverlap1and3Error(this.stream.readString());
            data.setOverlap2and3Error(this.stream.readString());
            if (api >= 2) {
                data.setCustomTrimError(this.stream.readString());
                data.setEnableFlashProgDlg(this.stream.readBoolean());
            }
            if (api >= 3) {
                data.setPartitionEnabled(this.stream.readBoolean());
                data.setPartitionChecked(this.stream.readBoolean());
                data.setPartition(this.stream.readString());
                data.setPartitionDescription1(this.stream.readString());
                data.setPartitionDescription2(this.stream.readString());
                data.setPartitionDescription3(this.stream.readString());
            }
            this.advProgrammingOptions.setData(data);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.advProgrammingOptions);
            this.stream.writeWord((short)5);
            this.stream.writeWord(api);
            this.stream.writeByte((byte)this.advProgrammingOptions.getResponse().getCommand());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isAskProgram());
            this.stream.writeByte((byte)this.advProgrammingOptions.getResponse().getCurrentAlgorithmIdx());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getUserAlgorithm());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isUseAlternativeAlgorithm());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isAutoSync());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isDoTrim());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isPreserve1Checkbox());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserve1Start());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserve1End());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isPreserve2Checkbox());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserve2Start());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserve2End());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isPreserve3Checkbox());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserve3Start());
            this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserve3End());
            this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isPreserveEEProm());
            if (api >= 2) {
                CoreDebug.writeDebug(1, "SENDING TRIM ENABLED = " + this.advProgrammingOptions.getResponse().isCustomTrimEnabled());
                this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserveEEPromStart());
                this.stream.writeString(this.advProgrammingOptions.getResponse().getPreserveEEPromEnd());
                this.stream.writeString(this.advProgrammingOptions.getResponse().getCustomTrimText());
                this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isCustomTrimEnabled());
                this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isEnableFlashProgDlg());
            }
            if (api >= 3) {
                CoreDebug.writeDebug(1, "SENDING TRIM ENABLED = " + this.advProgrammingOptions.getResponse().isCustomTrimEnabled());
                this.stream.writeBoolean(this.advProgrammingOptions.getResponse().isPartitionChecked());
                this.stream.writeString(this.advProgrammingOptions.getResponse().getPartition());
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processFirmwareUpdate() {
        try {
            if (this.stream.readWord() > 2) {
                throw new PException("Firmware Update: Incorrect stream formatting");
            }
            String javaTitle = this.firmwareUpdate.javaTitle;
            String interfaceDetectedString = this.firmwareUpdate.interfaceDetectedString;
            String originalFirmwareString = this.firmwareUpdate.originalFirmwareString;
            String currentFirmwareString = this.firmwareUpdate.currentFirmwareString;
            String updateFirmwareString = this.firmwareUpdate.updateFirmwareString;
            String originalVersion = this.firmwareUpdate.originalVersion;
            String currentVersion = this.firmwareUpdate.currentVersion;
            String updateVersion = this.firmwareUpdate.updateVersion;
            short imageInt = this.firmwareUpdate.imageInt;
            short bkgColor = this.firmwareUpdate.bkgColor;
            String outs = "";
            byte javaFirmUpCmd = this.stream.readByte();
            switch (javaFirmUpCmd) {
                case 0: {
                    javaTitle = this.stream.readString();
                    interfaceDetectedString = this.stream.readString();
                    originalFirmwareString = this.stream.readString();
                    currentFirmwareString = this.stream.readString();
                    updateFirmwareString = this.stream.readString();
                    originalVersion = this.stream.readString();
                    currentVersion = this.stream.readString();
                    updateVersion = this.stream.readString();
                    imageInt = this.stream.readByte();
                    bkgColor = this.stream.readByte();
                    outs = "";
                    break;
                }
                case 1: {
                    outs = this.stream.readString();
                    break;
                }
                case 2: {
                    this.stream.readBoolean();
                    bkgColor = this.stream.readByte();
                    interfaceDetectedString = this.stream.readString();
                    currentVersion = this.stream.readString();
                }
            }
            this.firmwareUpdate.setItems(javaFirmUpCmd, javaTitle, interfaceDetectedString, originalFirmwareString, currentFirmwareString, updateFirmwareString, originalVersion, currentVersion, updateVersion, imageInt, bkgColor, outs);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.firmwareUpdate);
            this.stream.writeBoolean(true);
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processRS08Ports() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("RS08 Inputs: Incorrect stream formatting");
            }
            this.inputWindow.setTitle(this.stream.readString());
            this.inputWindow.setStyle(3);
            int numOfInputs = 5;
            String unit = this.stream.readString();
            this.inputWindow.setNumOfInputs(numOfInputs);
            int i = 0;
            while (i < numOfInputs) {
                this.inputWindow.getInputData()[i].setName(this.stream.readString());
                this.inputWindow.getInputData()[i].setValue(this.stream.readString());
                this.inputWindow.getInputData()[i].setEnabled(this.stream.readBoolean());
                this.inputWindow.getInputData()[i].setUnit(unit);
                ++i;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.inputWindow);
            String[] ir = this.inputWindow.getResponse().value;
            this.stream.writeByte((byte)this.inputWindow.getResponse().buttonPressed);
            int i2 = 0;
            while (i2 < ir.length) {
                this.stream.writeString(ir[i2]);
                ++i2;
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processCycles() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Cycles Ports: Incorrect stream formatting");
            }
            this.cycles.setFunctionType(this.stream.readWord());
            switch (this.cycles.getFunctionType()) {
                case 1: {
                    this.cycles.setExtOscLabelText(this.stream.readString());
                    this.cycles.setExtOscValueText(this.stream.readString());
                    this.cycles.setExtOscUnitsText(this.stream.readString());
                    this.cycles.setBusFreqLabelText(this.stream.readString());
                    this.cycles.setBusFreqValueText(this.stream.readString());
                    this.cycles.setBustFreqUnitsText(this.stream.readString());
                    this.cycles.setCgmxclkFreqLabelText(this.stream.readString());
                    this.cycles.setCgmxclkFreqValueText(this.stream.readString());
                    this.cycles.setCgmxclkFreqUnitsText(this.stream.readString());
                    this.cycles.setCyclesLabelText(this.stream.readString());
                    this.cycles.setCyclesValueText(this.stream.readString());
                    this.cycles.setModeLabelText(this.stream.readString());
                    this.cycles.setModeValueText(this.stream.readString());
                    this.cycles.setIoStateLabelText(this.stream.readString());
                    this.cycles.setIoStateValueText(this.stream.readString());
                    break;
                }
                case 2: {
                    this.cycles.setExtOscValueText(this.stream.readString());
                    this.cycles.setBusFreqValueText(this.stream.readString());
                    this.cycles.setCgmxclkFreqValueText(this.stream.readString());
                    this.cycles.setCyclesValueText(this.stream.readString());
                    this.cycles.setModeValueText(this.stream.readString());
                    this.cycles.setIoStateValueText(this.stream.readString());
                }
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.cycles);
            this.stream.writeWord((short)9);
            this.stream.writeWord((short)1);
            if (this.cycles.getFunctionType() == 2) {
                this.stream.writeBoolean(this.cycles.getShellExists());
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processHCS08Ports() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("HCS08 Inputs: Incorrect stream formatting");
            }
            this.inputWindow.setTitle(this.stream.readString());
            this.inputWindow.setStyle(3);
            int numOfInputs = 14;
            String unit = this.stream.readString();
            this.inputWindow.setNumOfInputs(numOfInputs);
            int i = 0;
            while (i < 12) {
                this.inputWindow.getInputData()[i].setName(this.stream.readString());
                this.inputWindow.getInputData()[i].setValue(this.stream.readString());
                this.inputWindow.getInputData()[i].setEnabled(this.stream.readBoolean());
                this.inputWindow.getInputData()[i].setUnit(unit);
                ++i;
            }
            unit = this.stream.readString();
            i = 12;
            while (i < numOfInputs) {
                this.inputWindow.getInputData()[i].setName(this.stream.readString());
                this.inputWindow.getInputData()[i].setValue(this.stream.readString());
                this.inputWindow.getInputData()[i].setEnabled(this.stream.readBoolean());
                this.inputWindow.getInputData()[i].setUnit(unit);
                ++i;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.inputWindow);
            String[] ir = this.inputWindow.getResponse().value;
            this.stream.writeByte((byte)this.inputWindow.getResponse().buttonPressed);
            int i2 = 0;
            while (i2 < ir.length) {
                this.stream.writeString(ir[i2]);
                ++i2;
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processAddEthernetIP() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Add Ethernet IP: Incorrect stream formatting");
            }
            int ipNum = this.stream.readByte();
            String[] ipElements = new String[ipNum];
            if (ipNum != 0) {
                int i = 0;
                while (i < ipNum) {
                    String ipElement;
                    ipElements[i] = ipElement = this.stream.readString();
                    ++i;
                }
            } else {
                ipElements = new String[]{""};
            }
            byte ipSelIdx = this.stream.readByte();
            this.addEthernetIP.setItems(ipNum, ipElements, ipSelIdx);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.addEthernetIP);
            this.stream.writeWord((short)11);
            this.stream.writeWord((short)1);
            this.stream.writeByte((byte)this.addEthernetIP.getIpFunction());
            this.stream.writeString(this.addEthernetIP.getIpSelection());
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processAskProgramFlash() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Ask Program Flash: Incorrect stream formatting");
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.askProgramFlash);
            this.stream.writeWord((short)13);
            this.stream.writeWord((short)1);
            this.stream.writeBoolean(this.askProgramFlash.getResult());
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processInputs() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Inputs: Incorrect stream formatting");
            }
            this.inputWindow.setTitle(this.stream.readString());
            this.inputWindow.setHeader(this.stream.readString());
            this.inputWindow.setStyle(0);
            int numOfInputs = this.stream.readWord();
            this.inputWindow.setNumOfInputs(numOfInputs);
            int i = 0;
            while (i < numOfInputs) {
                this.inputWindow.getInputData()[i].setEnabled(this.stream.readBoolean());
                this.inputWindow.getInputData()[i].setValue(this.stream.readString());
                this.inputWindow.getInputData()[i].setName(this.stream.readString());
                this.inputWindow.getInputData()[i].setUnit(this.stream.readString());
                this.inputWindow.getInputData()[i].setMax(this.stream.readString());
                this.inputWindow.getInputData()[i].setMin(this.stream.readString());
                ++i;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.inputWindow);
            this.stream.writeWord((short)16);
            this.stream.writeWord((short)1);
            String[] ir = this.inputWindow.getResponse().value;
            this.stream.writeByte((byte)numOfInputs);
            this.stream.writeByte((byte)this.inputWindow.getResponse().buttonPressed);
            int i2 = 0;
            while (i2 < ir.length) {
                this.stream.writeString(ir[i2]);
                ++i2;
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processConnectionAssistant() {
        try {
            void var10_14;
            void var10_12;
            short api = this.stream.readWord();
            if (api != 1 && api != 2) {
                throw new PException("Connection Assistant: Incorrect stream formatting");
            }
            this.connectionAssistant.setApi(api);
            String header = this.stream.readString();
            String caption = this.stream.readString();
            byte cmdType = this.stream.readByte();
            CoreDebug.writeDebug(1, "COMMAND  = " + cmdType);
            String arch = this.stream.readString();
            int numInterface = this.stream.readByte();
            Interface[] interfaces = new Interface[numInterface];
            CoreDebug.writeDebug(1, "NUMBER OF INTERFACES = " + numInterface);
            byte defaultInterface = this.stream.readByte();
            byte defaultDevice = this.stream.readByte();
            boolean bl = false;
            while (var10_12 < numInterface) {
                interfaces[var10_12] = new Interface(this.stream.readString());
                ++var10_12;
            }
            boolean bl2 = false;
            while (var10_14 < numInterface) {
                interfaces[var10_14].setDevinceCount(this.stream.readByte());
                int j = 0;
                while (j < interfaces[var10_14].getDeviceCount()) {
                    interfaces[var10_14].setDevice(j, this.stream.readString());
                    ++j;
                }
                ++var10_14;
            }
            if (api >= 2) {
                if (arch.toLowerCase().contains("s08") || arch.toLowerCase().contains("cfv1")) {
                    this.connectionAssistant.setDoProvidePower(this.stream.readBoolean());
                    this.connectionAssistant.setDoPowerOffOnExit(this.stream.readBoolean());
                    this.connectionAssistant.setPowerVoltage(this.stream.readString());
                    this.connectionAssistant.setPowerUpDelay(this.stream.readString());
                    this.connectionAssistant.setPowerDownDelay(this.stream.readString());
                } else {
                    this.connectionAssistant.setDefaultBdmFrequency(this.stream.readByte());
                    this.connectionAssistant.setDoDelayAfterReset(this.stream.readBoolean());
                    this.connectionAssistant.setDelayAfterReset(this.stream.readString());
                    if (api < 3) {
                        void var12_19;
                        byte by = this.stream.readByte();
                        String[] mlFreqs = new String[by];
                        boolean bl3 = false;
                        while (var12_19 < by) {
                            mlFreqs[var12_19] = this.stream.readString();
                            ++var12_19;
                        }
                        byte by2 = this.stream.readByte();
                        String[] cycloneFreqs = new String[by2];
                        int i3 = 0;
                        while (i3 < by2) {
                            cycloneFreqs[i3] = this.stream.readString();
                            ++i3;
                        }
                        int i = 0;
                        while (i < numInterface) {
                            if (interfaces[i].getName().toLowerCase().contains("cyclone") || interfaces[i].getName().toLowerCase().contains("tracelink")) {
                                interfaces[i].setBdmShiftFrequencyCount(by2);
                                interfaces[i].setBdmShiftFrequencies(cycloneFreqs);
                            } else {
                                interfaces[i].setBdmShiftFrequencyCount(by);
                                interfaces[i].setBdmShiftFrequencies(mlFreqs);
                            }
                            ++i;
                        }
                    } else {
                        this.connectionAssistant.setShiftFrequency(this.stream.readString());
                    }
                }
            }
            this.connectionAssistant.setHeader(header);
            this.connectionAssistant.setCaption(caption);
            this.connectionAssistant.setInterfaces(interfaces);
            this.connectionAssistant.setDefaultInterface(defaultInterface);
            this.connectionAssistant.setDefaultDevice(defaultDevice);
            this.connectionAssistant.setArchitecture(arch);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)this.connectionAssistant);
            this.stream.writeWord((short)17);
            this.stream.writeWord(api);
            this.stream.writeByte((byte)this.connectionAssistant.getButtonPressed());
            this.stream.writeByte((byte)this.connectionAssistant.getInterfaceIndex());
            this.stream.writeByte((byte)this.connectionAssistant.getDeviceIndex());
            if (api == 2) {
                if (arch.toLowerCase().contains("s08") || arch.toLowerCase().contains("cfv1")) {
                    this.stream.writeBoolean(this.connectionAssistant.getCyclonePowerGroup().getDoProvidePower());
                    this.stream.writeBoolean(this.connectionAssistant.getCyclonePowerGroup().getDoPowerOffOnExit());
                    this.stream.writeString(this.connectionAssistant.getCyclonePowerGroup().getPowerVoltage());
                    this.stream.writeString(this.connectionAssistant.getCyclonePowerGroup().getPowerUpDelay());
                    this.stream.writeString(this.connectionAssistant.getCyclonePowerGroup().getPowerDownDelay());
                } else {
                    if (api < 3) {
                        this.stream.writeByte((byte)this.connectionAssistant.getBdmSpeedGroup().getBdmFreqSelection());
                    } else {
                        this.stream.writeString(this.connectionAssistant.getShiftFrequency());
                    }
                    this.stream.writeBoolean(this.connectionAssistant.getBdmSpeedGroup().getDoDelayAfterReset());
                    this.stream.writeString(this.connectionAssistant.getBdmSpeedGroup().getDelayAfterReset());
                }
            }
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processMenuSetup() {
        try {
            block9: {
                if (this.stream.readWord() != 1) {
                    throw new PException("Menu Setup: Incorrect stream formatting");
                }
                MenuData menuData = new MenuData();
                menuData.setSession(this.stream.getSession());
                menuData.setCommand(this.stream.readLong());
                menuData.setParentID(this.stream.readLong());
                menuData.setName(this.stream.readString());
                menuData.setMenuID(this.newMenuID);
                menuData.setCallbackClient(this.callback);
                try {
                    try {
                        PEMenu.semaphore.acquire();
                        this.peMenu.offerMenuQueue(menuData);
                    }
                    catch (InterruptedException interruptedException) {
                        PEMenu.semaphore.release();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    PEMenu.semaphore.release();
                    throw throwable;
                }
                PEMenu.semaphore.release();
            }
            if (!this.peMenu.threadIsRunning() && PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)this.peMenu);
            }
            this.stream.writeWord((short)1);
            this.stream.writeLong(this.newMenuID++);
        }
        catch (PException e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processOpenURL() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Open URL: Incorrect stream formatting");
            }
            String url = this.stream.readString();
            Object[] browsers = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
            try {
                Class<?> d = Class.forName("java.awt.Desktop");
                d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
            }
            catch (Exception exception) {
                try {
                    if (IPEKeys.OS_NAME.startsWith("Mac OS")) {
                        Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                    } else if (IPEKeys.OS_NAME.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    } else {
                        String browser = null;
                        Object[] objectArray = browsers;
                        int n = browsers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String b = objectArray[n2];
                            if (browser == null && Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() != -1) {
                                Runtime.getRuntime().exec(new String[]{browser = b, url});
                            }
                            ++n2;
                        }
                        if (browser == null) {
                            throw new Exception(Arrays.toString(browsers));
                        }
                    }
                }
                catch (Exception e) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageBox mb = new MessageBox(new Shell());
                            mb.setMessage("Error attempting to launch web browser\n" + e.toString());
                            mb.open();
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processOpenView() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Open View: Incorrect stream formatting");
            }
            final String id = this.stream.readString();
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        activePage.showView("com.pemicro.core." + id);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            });
            this.stream.writeWord((short)1234);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processGetProjectPath() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("Project Path: Incorrect stream formatting");
            }
            String projectName = this.stream.readString();
            ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            String launchPath = "";
            String launchFileName = "";
            int i = 0;
            while (i < launches.length) {
                if (launches[i].getLaunchConfiguration().getName().equals(projectName)) {
                    launchPath = launches[i].getLaunchConfiguration().getLocation().toString();
                    launchFileName = launches[i].getLaunchConfiguration().getFile().getName();
                    break;
                }
                ++i;
            }
            CoreDebug.writeDebug(1, "Get Project Path: Path= " + launchPath + " launch Name= " + launchFileName);
            this.stream.writeWord((short)24);
            this.stream.writeWord((short)1);
            this.stream.writeString(launchPath);
            this.stream.writeString(launchFileName);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processLCFWrite() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("LCF Write: Incorrect stream formatting");
            }
            byte command = this.stream.readByte();
            LCFData lcfData = new LCFData();
            String lcfName = this.stream.readString();
            boolean exists = false;
            int i = 0;
            while (i < this.lcfDataList.size()) {
                if (this.lcfDataList.get(i).getName().equals(lcfName)) {
                    lcfData = this.lcfDataList.get(i);
                    exists = true;
                }
                ++i;
            }
            if (command == 0) {
                CoreDebug.writeDebug(1, "WRITE LCF: COMMAND = 0: BUFFER");
                int keyCount = this.stream.readWord();
                int i2 = 0;
                while (i2 < keyCount) {
                    String attributeName = this.stream.readString();
                    String value = this.stream.readString();
                    if (exists) {
                        lcfData.addKey(attributeName, value);
                    } else {
                        lcfData.setName(lcfName);
                        lcfData.addKey(attributeName, value);
                        this.lcfDataList.add(lcfData);
                    }
                    ++i2;
                }
            }
            if (command == 1) {
                CoreDebug.writeDebug(1, "WRITE LCF: COMMAND = 1: WRITE");
                i = 0;
                while (i < this.lcfDataList.size()) {
                    if (this.lcfDataList.get(i).getName().equals(lcfName)) {
                        lcfData = this.lcfDataList.get(i);
                        CoreDebug.writeDebug(1, "WRITE LCF: LCF FOUND: " + lcfName);
                        break;
                    }
                    ++i;
                }
                ILaunchConfigurationWorkingCopy conf = null;
                ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                int i3 = 0;
                while (i3 < launches.length) {
                    if (launches[i3].getLaunchConfiguration().getName().equals(lcfName)) {
                        conf = launches[i3].getLaunchConfiguration().getWorkingCopy();
                        CoreDebug.writeDebug(1, "LCF WRITE: Launch Configuration");
                        break;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < lcfData.getKeyList().size()) {
                    CoreDebug.writeDebug(1, String.format("LCF WRITE: Write - Att Name = %s , Att Value = %s", lcfData.getKey(i3).getAttributeName(), lcfData.getKey(i3).getValue()));
                    conf.setAttribute(lcfData.getKey(i3).getAttributeName(), lcfData.getKey(i3).getValue());
                    ++i3;
                }
                CoreDebug.writeDebug(1, "LCF WRITE: Saving Launch");
                conf.doSave();
            }
            if (!this.lcfManagerHasListener) {
                CoreDebug.writeDebug(1, "LCF WRITE: Add Launch Listerner");
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

                    public void launchesRemoved(ILaunch[] launches) {
                    }

                    public void launchesChanged(ILaunch[] launches) {
                    }

                    public void launchesAdded(ILaunch[] launches) {
                    }

                    public void launchesTerminated(ILaunch[] launches) {
                        try {
                            ILaunchConfigurationWorkingCopy conf = null;
                            String name = "";
                            int i = 0;
                            while (i < launches.length) {
                                if (launches[i].isTerminated()) {
                                    conf = launches[i].getLaunchConfiguration().getWorkingCopy();
                                    name = launches[i].getLaunchConfiguration().getName();
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < ProcessWindow.this.lcfDataList.size()) {
                                if (((LCFData)ProcessWindow.this.lcfDataList.get(i)).getName().toLowerCase().equals(name.toLowerCase())) {
                                    LCFData lcfData = (LCFData)ProcessWindow.this.lcfDataList.get(i);
                                    int j = 0;
                                    while (j < lcfData.getKeyList().size()) {
                                        conf.setAttribute(lcfData.getKey(j).getAttributeName(), lcfData.getKey(j).getValue());
                                        ++j;
                                    }
                                    conf.doSave();
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                });
                this.lcfManagerHasListener = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean processLCFRead() {
        try {
            if (this.stream.readWord() != 1) {
                throw new PException("LCF Read: Incorrect stream formatting");
            }
            String lcfName = this.stream.readString();
            short keyCount = this.stream.readWord();
            String[] keys = new String[keyCount];
            ILaunchConfiguration conf = null;
            ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            int i = 0;
            while (i < launches.length) {
                if (launches[i].getLaunchConfiguration().getName().equals(lcfName)) {
                    conf = launches[i].getLaunchConfiguration();
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < keyCount) {
                String attributeName = this.stream.readString();
                keys[i] = conf.getAttribute(attributeName, "");
                ++i;
            }
            this.stream.writeWord((short)27);
            this.stream.writeWord((short)1);
            i = 0;
            while (i < keyCount) {
                this.stream.writeString(keys[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean unsupportedCommand() {
        try {
            this.stream.writeString("Command is not supported with this version of the plugin.");
        }
        catch (PException e) {
            e.printStackTrace();
        }
        return false;
    }
}

