/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.e200.mbs.handler;

import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.sdk.ISDK;
import java.util.Arrays;
import java.util.List;

public class PExSDKhandler
implements IParameterHandler {
    private static final String MESSAGE_TEXT = "C++ Project is not compatible with PEx SDK";
    private static final String C_LANGUAGE = "c";
    private static final String CPP_LANGUAGE = "c++";
    private static final String C_CPP_LANGUAGE_SET = "c_cpp";

    public boolean isEnabled(String tag, AbstractContext context) {
        return false;
    }

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        return this.onEdit(tag, newValue, context);
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        if (newValue == null) {
            return null;
        }
        if (!(context instanceof CProjectMasterContext)) {
            return null;
        }
        CProjectMasterContext projectContext = (CProjectMasterContext)context;
        String warningMessage = "";
        ModelRegistry registry = context.getRegistry();
        ContextChange contextChange = new ContextChange(context, tag);
        String currentLang = projectContext.getStringValue("language");
        if (this.isPex((CProjectContext)projectContext)) {
            if (tag.equals("language") && CPP_LANGUAGE.equals(newValue) || tag.equals("sdks") && CPP_LANGUAGE.equals(currentLang)) {
                warningMessage = MESSAGE_TEXT;
            }
            DataSet dataSet = registry.getDataSet("languageSet", C_LANGUAGE);
            contextChange.addDataSet(dataSet);
        } else {
            DataSet languageDataSet = projectContext.getDataSet("language");
            if (languageDataSet != null && !languageDataSet.getValues().contains(CPP_LANGUAGE)) {
                DataSet dataSet = registry.getDataSet("languageSet", C_CPP_LANGUAGE_SET);
                contextChange.addDataSet(dataSet);
            }
        }
        ChangeResult result = new ChangeResult(Arrays.asList(contextChange));
        if (!warningMessage.isEmpty()) {
            result.setWarningMessage(warningMessage);
        }
        return result;
    }

    public Object parseValue(String tag, String value, AbstractContext context) {
        return null;
    }

    public boolean isPex(CProjectContext projectContext) {
        List sdkList = projectContext.getSdkList();
        for (IModelSDK sdk : sdkList) {
            if (!(sdk instanceof ISDK) || !((ISDK)sdk).isPex()) continue;
            return true;
        }
        return false;
    }
}

