/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKImportDialogHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class SDKImportDialog
extends TitleAreaDialog {
    private static final String USERHOME = "user.home";
    private static final String FILLER = "   ";
    private static final String DATA_LABEL = "label";
    private static final String DATA_BUTTON = "button";
    private static final String SOURCES = "sources.xml";
    private Text sourceField;
    private Text destinationField;
    private RadioButtonsArea radio;
    private String source = "";
    private String destination = "";
    private int mode = 0;
    private String sdkName = "";
    private String oldZipName = "";
    private final String standardMessage;
    private volatile boolean fromZip = true;
    private SDKImportDialogHandler handler;
    private static final String[][] values = new String[][]{{Messages.SDKImportDialog_FROM_ZIP, "A"}, {Messages.SDKImportDialog_FROM_DIR, "B"}};

    public SDKImportDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.standardMessage = Messages.SDKDialog_import_dialog_header_text;
        this.handler = new SDKImportDialogHandler(this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SDKDialog_import_dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(500, -1).applyTo((Control)composite);
        this.radio = new RadioButtonsArea(composite, Messages.SDKImportDialog_DATA_SOURCE, 3, values);
        GridDataFactory.fillDefaults().grab(true, false).hint(500, -1).span(3, 1).applyTo((Control)this.radio);
        this.radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKImportDialog.this.toggle(SDKImportDialog.this.radio.getSeletedIndex() == 0);
                SDKImportDialog.this.updateButtonsState();
            }
        });
        this.radio.setSelectedButton(0);
        Label locationLabel = new Label(composite, 16384);
        locationLabel.setText(Messages.SDKImportDialog_From_file);
        locationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sourceField = new Text(composite, 2060);
        this.sourceField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.SDKDialog_location_button_text);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location = SDKImportDialog.this.selectArchive();
                if (location != null) {
                    SDKImportDialog.this.sourceField.setText(location);
                }
                SDKImportDialog.this.updateButtonsState();
            }
        });
        this.sourceField.setData(DATA_BUTTON, (Object)browseButton);
        this.sourceField.setData(DATA_LABEL, (Object)locationLabel);
        this.setButtonLayoutData(browseButton);
        Label destinationLabel = new Label(composite, 16384);
        destinationLabel.setText(String.valueOf(Messages.SDKImportDialog_Into_dir) + FILLER);
        destinationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.destinationField = new Text(composite, 2060);
        this.destinationField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.destinationField.setText(System.getProperty(USERHOME));
        Button browse = new Button(composite, 8);
        browse.setText(Messages.SDKDialog_location_button_text);
        browse.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String location = SDKImportDialog.this.selectFolder();
                if (location != null) {
                    SDKImportDialog.this.destinationField.setText(location);
                }
                SDKImportDialog.this.updateButtonsState();
            }
        });
        this.destinationField.setData(DATA_BUTTON, (Object)browse);
        this.destinationField.setData(DATA_LABEL, (Object)destinationLabel);
        this.setButtonLayoutData(browse);
        this.setTitle(Messages.SDKDialog_import_dialog_title);
        this.setMessage(this.standardMessage);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.freescale.s32ds.cross.sdk.support.SDK_import_context");
        return composite;
    }

    private void toggle(boolean isZip) {
        this.fromZip = isZip;
        if (this.sourceField != null) {
            this.sourceField.setVisible(isZip);
            ((Control)this.sourceField.getData(DATA_BUTTON)).setVisible(isZip);
            ((Control)this.sourceField.getData(DATA_LABEL)).setVisible(isZip);
            ((Label)this.destinationField.getData(DATA_LABEL)).setText(isZip ? Messages.SDKImportDialog_Into_dir : Messages.SDKImportDialog_FROM_DIR_LABEL);
            this.setMessage(isZip ? this.standardMessage : Messages.SDKImportDialog_IMPORT_FROM_EXISTING);
        }
    }

    private String selectArchive() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText(Messages.SDKDialog_archive_selection_dialog_title);
        dialog.setFilterExtensions(new String[]{"*.zip"});
        return dialog.open();
    }

    private String selectFolder() {
        if (this.fromZip) {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0x10002000);
            dialog.setText(Messages.SDKDialog_folder_selection_dialog_title);
            dialog.setMessage(Messages.SDKDialog_folder_selection_dialog_header_text);
            return dialog.open();
        }
        FileDialog dialog = new FileDialog(this.getShell(), 0x10001000);
        dialog.setText(Messages.SDKImportDialog_STRUCTURE_SELECTION);
        dialog.setFilterNames(new String[]{SOURCES});
        dialog.setFilterExtensions(new String[]{SOURCES});
        String res = dialog.open();
        return res == null ? null : new File(res).getParent();
    }

    private void updateButtonsState() {
        Button okButton = this.getButton(0);
        if (this.radio.getSeletedIndex() == 0) {
            boolean enabled;
            String sourceText = this.sourceField.getText();
            String destText = this.destinationField.getText();
            boolean bl = enabled = !sourceText.isEmpty() && !destText.isEmpty() && this.handler.validateSDKDescriptor(sourceText);
            if (enabled && !this.oldZipName.equals(sourceText)) {
                this.sdkName = this.getNameFromZip(sourceText);
                enabled &= this.sdkName != null;
                this.oldZipName = sourceText;
            }
            okButton.setEnabled(enabled);
            if (enabled) {
                this.setErrorMessage(null);
            }
        } else {
            boolean enable = false;
            if (!this.destinationField.getText().isEmpty()) {
                File f = new File(this.destinationField.getText().trim());
                if (f.exists() && f.isDirectory()) {
                    if ((f = new File(f, SOURCES)).exists() && f.isFile() && f.canRead()) {
                        enable = true;
                    } else {
                        this.setMessage(String.format(Messages.SDKImportDialog_NO_XML, f.getParent()));
                    }
                } else {
                    this.setMessage(String.format(Messages.SDKImportDialog_NOT_A_DIR, f.toString()));
                }
            } else {
                this.setMessage(Messages.SDKDialog_folder_selection_dialog_header_text);
            }
            okButton.setEnabled(enable);
            if (enable) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
        }
    }

    public void create() {
        super.create();
        this.updateButtonsState();
    }

    protected void okPressed() {
        this.source = this.sourceField.getText();
        this.destination = this.destinationField.getText();
        this.mode = this.radio.getSeletedIndex();
        super.okPressed();
    }

    public String location() {
        return this.source;
    }

    public int mode() {
        return this.mode;
    }

    public String source() {
        return this.destination;
    }

    public String destination() {
        int cnt = 0;
        String result = String.valueOf(this.destination) + File.separatorChar + this.sdkName + File.separatorChar;
        while (new File(result).exists()) {
            result = String.valueOf(this.destination) + File.separatorChar + this.sdkName + cnt++ + File.separatorChar;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private String getNameFromZip(String archive) {
        try {
            var2_2 = null;
            var3_5 = null;
            try {
                zipFile = new ZipFile(archive);
                try {
                    e = zipFile.entries();
                    while (true) {
                        ze = e.nextElement();
                        if (!"sources.xml".equals(ze.getName())) {
                        }
                        stream = new ByteArrayInputStream(SDKUtils.toString(zipFile.getInputStream(ze)).getBytes("UTF-8"));
                        parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        list = parser.parse(stream).getDocumentElement().getChildNodes();
                        i = 0;
                        numItems = list.getLength();
                        while (i < numItems) {
                            if (list.item(i).getNodeType() == 1 && ((Element)list.item(i)).getNodeName().equals("sdk")) {
                                return ((Element)list.item(i)).getAttribute("name");
                            }
                            ++i;
                        }
                        break;
                    }
                }
                finally {
                    if (e.hasMoreElements()) ** continue;
                }
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                } else if (var2_2 != var3_6) {
                    var2_2.addSuppressed(var3_6);
                }
                throw var2_2;
            }
        }
        catch (Exception ex) {
            SDKSupportPlugin.error(Messages.SDKImportDialog_exception, ex);
        }
        return null;
    }
}

