/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.sdk.IContributedSDK;
import com.freescale.s32ds.cross.sdk.IExternalSDK;
import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.ISDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.AbstractSmartFilter;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.GlobalSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.sdk.internal.SDKLatestVersionFilter;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKAttachConfigurationsDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKEditDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKExportDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKImportDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKSelectDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKShowDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKTableViewerHolder;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKImportUICallbackHandler;
import com.nxp.s32ds.cle.ide.sdk.core.SDKExportHandler;
import com.nxp.s32ds.cle.ide.sdk.core.SDKImportHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.service.prefs.BackingStoreException;

public enum SDKManagementWidget {
    PROJECT(false){
        private Button attachButton;
        private boolean showAllForProject;
        private Button showAll = null;

        @Override
        protected TableViewer createTableViewer(Composite parent) {
            this.loadAvailableSDKs();
            TableViewer tv = SDKTableViewerHolder.newSelList(parent, this.project, this.selMap);
            return tv;
        }

        @Override
        protected void createExtraButtons(Composite parent) {
            new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.createAttachDetachButton(parent);
            this.createMakeGlobalButton(parent);
            this.createImportExportButtons(parent);
        }

        @Override
        protected void updateExtraButtonsState() {
            ISDK sdkFromSel = SDKManagementWidget.getSDKFromSel(this.viewer);
            this.makeGlobalButton.setEnabled(this.isSelectedSingle() && sdkFromSel instanceof IProjectLocalSDK && sdkFromSel.isAvailable());
            boolean isAttachable = this.selMap.isEmpty() || !SDKManagementWidget.canAttachSel(this.viewer) ? false : !this.getSelectedAttachable().isEmpty();
            this.attachButton.setEnabled(isAttachable);
            this.updateExportButtonState();
        }

        @Override
        public List<ISDK> getSDKs() {
            AvailableSDKFilter baseFiler;
            AvailableSDKFilter availableSDKFilter = baseFiler = this.showAllForProject ? new AvailableSDKFilter(this.project){

                @Override
                public IFilterOptions options() {
                    return null;
                }
            } : new AvailableSDKFilter(this.project);
            if (this.isLatestSDKVersionsOnly) {
                return SDKUtils.filter(new SDKLatestVersionFilter(baseFiler));
            }
            return SDKUtils.filter(baseFiler);
        }

        @Override
        protected void createFilterArea(Composite parent) {
            Composite filtersGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, true);
            filtersGroup.setLayout((Layout)layout);
            this.createShowAllSDKsFilterCheckbox(filtersGroup);
            this.createVersionFilterCheckbox(filtersGroup);
        }

        private void createShowAllSDKsFilterCheckbox(Composite parent) {
            this.showAllForProject = false;
            int originalSize = this.getSDKs().size();
            this.showAllForProject = true;
            int negateSize = this.getSDKs().size();
            this.showAllForProject = false;
            if (originalSize != negateSize) {
                this.showAll = new Button(parent, 32);
                this.showAll.setText(Messages.SDKManagementWidget_show_all_sdks);
                this.showAll.setSelection(false);
                this.showAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Button b = (Button)e.getSource();
                        showAllForProject = b.getSelection();
                        this.updateWidgetState();
                    }
                });
            }
        }

        @Override
        protected IFilterOptions getFilterOptions() {
            return AvailableSDKFilter.options(this.project);
        }

        @Override
        public void loadSDKVersionFilterPreference() {
            if (this.project != null) {
                IEclipsePreferences prefs = new ProjectScope(this.project).getNode(SDKSupportPlugin.getUniqueIdentifier());
                this.isLatestSDKVersionsOnly = prefs.getBoolean(SDKManagementWidget.FILTER_SDKS_PREF_KEY, false);
            }
        }

        @Override
        public void saveSDKVersionFilterPreference() {
            this.saveSDKVersionFilterProjectPreference();
        }

        @Override
        public boolean[] getCfgSelection(String sdkId) {
            Boolean[] res = null;
            res = sdkId.startsWith(SDKManagementWidget.OLD_PREF) ? (Boolean[])this.oldMap.get(sdkId.substring(SDKManagementWidget.OLD_PREF.length())) : (Boolean[])this.selMap.get(sdkId);
            if (res == null) {
                return null;
            }
            boolean[] out = new boolean[res.length];
            int i = 0;
            while (i < out.length) {
                out[i] = res[i] == null ? false : res[i];
                ++i;
            }
            return out;
        }

        private void loadAvailableSDKs() {
            this.selMap = this.makeData(this.project, SDKUtils.filter(new AvailableSDKFilter(this.project){

                @Override
                public IFilterOptions options() {
                    return null;
                }
            }));
            this.oldMap = SDKManagementWidget.copyData(this.selMap);
        }

        private void createAttachDetachButton(final Composite parent) {
            this.attachButton = new Button(parent, 8);
            this.attachButton.setText(Messages.SDKManagementWidget_attach_sdk_button_text);
            this.attachButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Map localMap = SDKManagementWidget.copyData(selMap);
                    SDKAttachConfigurationsDialog cnfDialog = new SDKAttachConfigurationsDialog(parent.getShell(), this.getSelectedAttachable(), project, localMap);
                    if (cnfDialog.open() == 0) {
                        this.synchData(localMap, selMap);
                    }
                    this.updateWidgetState();
                }
            });
            this.attachButton.setFont(parent.getFont());
            this.setButtonLayoutData(this.attachButton);
        }

        private void createMakeGlobalButton(Composite parent) {
            Font font = parent.getFont();
            this.makeGlobalButton = new Button(parent, 8);
            this.makeGlobalButton.setText(Messages.SDKManagementWidget_make_global_sdk_button_text);
            this.makeGlobalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SDKUtils.convert((IProjectLocalSDK)SDKManagementWidget.getSDKFromSel(viewer), ISDK.TYPE.EXTERNAL, new Object[0]);
                    ExternalSDK.storeExternalSDKs();
                    ProjectLocalSDK.storeProjectLocalSDKs();
                    this.updateWidgetState();
                }
            });
            this.makeGlobalButton.setFont(font);
            this.setButtonLayoutData(this.makeGlobalButton);
        }

        private List<ISDK> getSelectedAttachable() {
            ArrayList<ISDK> sdks = new ArrayList<ISDK>();
            if (!(this.viewer instanceof CheckboxTableViewer)) {
                TableItem[] tableItemArray = this.viewer.getTable().getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object data = item.getData();
                    if (data != null && data instanceof ISDK) {
                        ISDK sdk = (ISDK)data;
                        Boolean[] booleanArray = (Boolean[])this.selMap.get(sdk.getId());
                        int n3 = booleanArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Boolean state = booleanArray[n4];
                            if (state != null && CHECKER.checkLang(this.project, sdk)) {
                                sdks.add(sdk);
                                break;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            return sdks;
        }

        private void synchData(Map<String, Boolean[]> src, Map<String, Boolean[]> dst) {
            for (String s : src.keySet()) {
                Boolean[] a = src.get(s);
                Boolean[] b = dst.get(s);
                if (a == null || b == null || a.length != b.length) {
                    return;
                }
                boolean isAttachmentStatesChanged = false;
                int i = 0;
                while (i < a.length) {
                    if (a[i] != null && b[i] != null && !a[i].equals(b[i])) {
                        b[i] = a[i];
                        isAttachmentStatesChanged = true;
                    }
                    ++i;
                }
                if (!isAttachmentStatesChanged) continue;
                this.changedSDKAttachments.put(s, b);
            }
        }

        @Override
        public boolean isSDKAttachmentChanged(String sdkId) {
            return this.changedSDKAttachments.get(sdkId) != null;
        }

        @Override
        protected void processUnavailableSDKs(List<ISDK> sdks) {
            this.detachUnavailableSDKsFromProject(sdks);
        }

        private void detachUnavailableSDKsFromProject(List<ISDK> sdks) {
            sdks.stream().filter(sdk -> SDKAttach.isAttached(sdk, this.project)).forEach(sdk -> {
                Shell shell = EclipseUtils.getShell();
                shell.getDisplay().syncExec(() -> {
                    if (MessageDialog.openConfirm((Shell)shell, (String)Messages.SDKManagementWidget_detach_unavailable_sdk_confirmation_title, (String)String.format(Messages.SDKManagementWidget_detach_unavailable_sdk_confirmation_message, sdk.getBriefInfo(), this.project.getName()))) {
                        SDKAttach.detachFrom(sdk, this.project);
                    }
                });
            });
        }
    }
    ,
    WIZARD(false){
        private Set<ISDK> checkedSdkList = new LinkedHashSet<ISDK>();

        @Override
        protected TableViewer createTableViewer(Composite parent) {
            CheckboxTableViewer ctv = SDKTableViewerHolder.newCheckList(parent);
            ctv.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Object element = event.getElement();
                    if (!(element instanceof ISDK)) {
                        return;
                    }
                    if (event.getChecked()) {
                        checkedSdkList.add((ISDK)element);
                    } else if (checkedSdkList.contains((ISDK)element)) {
                        checkedSdkList.remove((ISDK)element);
                    }
                }
            });
            return ctv;
        }

        @Override
        protected void createExtraButtons(Composite parent) {
        }

        @Override
        protected void updateExtraButtonsState() {
        }

        @Override
        public List<ISDK> getSDKs() {
            AbstractSmartFilter abstractSmartFiler = new AbstractSmartFilter(){

                @Override
                public boolean accept(ISDK sdk) {
                    return !(sdk instanceof IProjectLocalSDK);
                }

                @Override
                public IFilterOptions options() {
                    return FilterOptions.createFilter(info);
                }
            };
            if (this.isLatestSDKVersionsOnly) {
                return SDKUtils.filter(new SDKLatestVersionFilter(abstractSmartFiler));
            }
            return SDKUtils.filter(abstractSmartFiler);
        }

        @Override
        protected void createFilterArea(Composite parent) {
            this.createVersionFilterCheckbox(parent);
        }

        @Override
        public void setFilterInfo(ISDKFilterInfo info) {
            this.info = info;
        }

        @Override
        public void loadSDKVersionFilterPreference() {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            this.isLatestSDKVersionsOnly = prefs.getBoolean(SDKManagementWidget.FILTER_SDKS_PREF_KEY, false);
        }

        @Override
        public void saveSDKVersionFilterPreference() {
            this.saveSDKVersionFilterGlobalPreference();
        }

        @Override
        public boolean[] getCfgSelection(String sdkId) {
            return null;
        }

        @Override
        public boolean isSDKAttachmentChanged(String sdkId) {
            return false;
        }

        @Override
        public void setSelected(Object[] selection) {
            if (selection == null || selection.length == 0) {
                return;
            }
            List<Object> selected = Arrays.asList(selection);
            TableItem[] tableItemArray = this.viewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof ISDK && selected.contains(data)) {
                    item.setChecked(true);
                    this.checkedSdkList.add((ISDK)data);
                }
                ++n2;
            }
        }

        @Override
        public List<ISDK> getSelectedToAttach() {
            return new ArrayList<ISDK>(this.checkedSdkList);
        }

        @Override
        public void cancelSelectedToAttach() {
            this.checkedSdkList.clear();
        }

        @Override
        protected void updateWidgetState() {
            super.updateWidgetState();
            CheckboxTableViewer tv = (CheckboxTableViewer)this.viewer;
            TableItem[] tableItemArray = tv.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISDK sdk;
                TableItem ti = tableItemArray[n2];
                if (ti.getData() instanceof ISDK && this.checkedSdkList.contains(sdk = (ISDK)ti.getData())) {
                    ti.setChecked(true);
                }
                ++n2;
            }
        }

        @Override
        protected void createAddButton(Composite groupComponent) {
        }

        @Override
        protected void createRemoveButton(Composite groupComponent) {
        }
    }
    ,
    LIST(false){

        @Override
        protected TableViewer createTableViewer(Composite parent) {
            return SDKTableViewerHolder.newList(parent);
        }

        @Override
        protected void createExtraButtons(Composite parent) {
            this.createImportExportButtons(parent);
            this.createShowButton(parent);
        }

        @Override
        protected void updateExtraButtonsState() {
            this.updateExportButtonState();
        }

        @Override
        public List<ISDK> getSDKs() {
            if (this.isLatestSDKVersionsOnly) {
                return SDKUtils.filter(new SDKLatestVersionFilter(true));
            }
            return SDKUtils.filter(new GlobalSDKFilter());
        }

        @Override
        protected void createFilterArea(Composite parent) {
            this.createVersionFilterCheckbox(parent);
        }

        @Override
        public void loadSDKVersionFilterPreference() {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            this.isLatestSDKVersionsOnly = prefs.getBoolean(SDKManagementWidget.FILTER_SDKS_PREF_KEY, false);
        }

        @Override
        public void saveSDKVersionFilterPreference() {
            this.saveSDKVersionFilterGlobalPreference();
        }

        @Override
        public boolean[] getCfgSelection(String sdkId) {
            return null;
        }

        private void createShowButton(final Composite parent) {
            this.showButton = new Button(parent, 8);
            this.showButton.setText(Messages.SDKManagementWidget_show_attached_button_text);
            this.showButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new SDKShowDialog(parent.getShell(), SDKManagementWidget.getSDKFromSel(viewer)).open();
                }
            });
            this.showButton.setFont(parent.getFont());
            this.setButtonLayoutData(this.showButton);
        }

        @Override
        public boolean isSDKAttachmentChanged(String sdkId) {
            return false;
        }
    };

    public static final ISDKCompatibilityChecker CHECKER;
    public static final String ERROR_COULD_NOT_REACH = "Couldn't reach here";
    public static final String OLD_PREF = "_?_";
    public static final int COLUMNS_OFFSET = 3;
    protected ISDKFilterInfo info = null;
    protected static final String FILTER_SDKS_PREF_KEY = "FILTER_SDKs_SHOW_LATEST_VERSIONS";
    protected static final String GIT_ERROR_TITLE;
    protected static final String GIT_EMPTY_REP;
    protected static final String GIT_LOCAL_BAD;
    private static final String GIT_LOAD_KEY = "GIT_LOAD_KEY";
    protected TableViewer viewer;
    protected IProject project = null;
    Map<String, Boolean[]> selMap = new LinkedHashMap<String, Boolean[]>();
    Map<String, Boolean[]> oldMap = null;
    protected Map<String, Boolean[]> changedSDKAttachments;
    private final boolean isReadOnly;
    protected Shell shell;
    public SDKSelectDialog holderDialog;
    private Button editButton;
    private Button removeButton;
    protected Button makeGlobalButton;
    protected Button importButton;
    protected Button exportButton;
    protected Button gitImportButton;
    protected Button showButton;
    protected Button showAllVersionsCheckbox;
    private FontMetrics fontMetrics;
    private int lastSelection = -1;
    protected boolean isLatestSDKVersionsOnly = false;

    static {
        CHECKER = new SDKCompatibilityChecker();
        GIT_ERROR_TITLE = Messages.SDKManagementWidget_cannot_clone_sdk;
        GIT_EMPTY_REP = Messages.SDKManagementWidget_git_path_not_set;
        GIT_LOCAL_BAD = Messages.SDKManagementWidget_git_path_not_valid;
    }

    protected abstract TableViewer createTableViewer(Composite var1);

    protected abstract void createExtraButtons(Composite var1);

    protected abstract void updateExtraButtonsState();

    public abstract List<ISDK> getSDKs();

    public abstract boolean[] getCfgSelection(String var1);

    public abstract void loadSDKVersionFilterPreference();

    public abstract void saveSDKVersionFilterPreference();

    public abstract boolean isSDKAttachmentChanged(String var1);

    private SDKManagementWidget(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        this.changedSDKAttachments = new HashMap<String, Boolean[]>();
        this.loadSDKVersionFilterPreference();
    }

    public Composite createContents(Composite parent) {
        this.shell = parent.getShell();
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        pageComponent.setLayoutData((Object)new GridData(1808));
        pageComponent.setFont(font);
        Composite tableComposite = new Composite(pageComponent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.minimumWidth = 600;
        data.minimumHeight = 300;
        tableComposite.setLayoutData((Object)data);
        this.viewer = this.createTableViewer(tableComposite);
        Table t = this.viewer.getTable();
        t.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SDKManagementWidget.this.updateEnabledState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (SDKManagementWidget.this.editButton != null && SDKManagementWidget.this.editButton.isEnabled()) {
                    SDKManagementWidget.this.editButton.notifyListeners(13, null);
                }
            }
        });
        t.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    if (SDKManagementWidget.this.removeButton != null && SDKManagementWidget.this.removeButton.isEnabled()) {
                        SDKManagementWidget.this.removeButton.notifyListeners(13, null);
                    }
                } else if (e.keyCode == 32) {
                    if (SDKManagementWidget.this.editButton != null && SDKManagementWidget.this.editButton.isEnabled()) {
                        SDKManagementWidget.this.editButton.notifyListeners(13, null);
                    }
                } else if (e.keyCode == 105 && (e.stateMask & 0x40000) != 0) {
                    SDKManagementWidget.this.sdkInfo();
                }
            }
        });
        t.setFont(font);
        this.setupMenu(t);
        if (!this.isReadOnly) {
            this.createButtonGroup(pageComponent);
        }
        this.createFilterArea(pageComponent);
        this.updateViewerInput();
        if (this.viewer.getTable().getItemCount() > 0) {
            this.viewer.getTable().setSelection(0);
            this.viewer.getTable().setFocus();
            this.updateEnabledState();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComponent, "com.freescale.s32ds.cross.sdk.support.SDK_MGMT_context");
        return pageComponent;
    }

    public boolean isSelected(ISDK sdk) {
        if (this.viewer instanceof CheckboxTableViewer) {
            return ((CheckboxTableViewer)this.viewer).getChecked((Object)sdk);
        }
        return false;
    }

    public List<ISDK> getSelected() {
        ArrayList<ISDK> sdks = new ArrayList<ISDK>();
        TableItem[] tableItemArray = this.viewer.getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (data != null && data instanceof ISDK) {
                sdks.add((ISDK)data);
            }
            ++n2;
        }
        return sdks;
    }

    public List<ISDK> getSelectedToAttach() {
        return Collections.emptyList();
    }

    public void cancelSelectedToAttach() {
    }

    public void updateSDKsAttachData() {
        if (this.project != null && !this.changedSDKAttachments.isEmpty()) {
            for (String sdkId : this.changedSDKAttachments.keySet()) {
                ISDK sdk = SDKUtils.getSDKbyID(sdkId);
                SDKAttach.changeAttachment(sdk, this.getCfgSelection(sdkId), this.getCfgSelection(OLD_PREF + sdkId), this.project, this);
            }
            this.changedSDKAttachments.clear();
            this.oldMap = SDKManagementWidget.copyData(this.selMap);
        }
    }

    public void restoreSDKAttachData(String sdkId, Boolean[] undoCfgSelection) {
        this.selMap.put(sdkId, undoCfgSelection);
        this.updateWidgetState();
    }

    private void setupMenu(Table t) {
        Menu m = new Menu((Control)t);
        MenuItem mi = new MenuItem(m, 8);
        mi.setText(Messages.SDKManagementWidget_reset);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKManagementWidget.this.resetTable();
            }
        });
        t.setMenu(m);
    }

    private void sdkInfo() {
        List<ISDK> sdks = this.getSelected();
        StringBuilder sb = new StringBuilder();
        if (sdks == null || sdks.size() == 0) {
            sb.append(Messages.SDKManagementWidget_NO_SDK);
        } else {
            for (ISDK sdk : sdks) {
                sb.append(sdk.toString()).append(' ').append(sdk.getStatusText()).append('\n').append('\n').append(sdk.getFilterOptions()).append('\n').append('\n').append(sdk.getEnv()).append("\n--------------\n\n");
            }
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        shell.getDisplay().syncExec(() -> {
            boolean bl = MessageDialog.open((int)2, (Shell)shell, (String)Messages.SDKManagementWidget_SDK_Status, (String)sb.toString(), (int)0);
        });
    }

    public void setFilterInfo(ISDKFilterInfo info) {
    }

    public void setSelected(Object[] selection) {
    }

    protected void saveSDKVersionFilterGlobalPreference() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.putBoolean(FILTER_SDKS_PREF_KEY, this.isLatestSDKVersionsOnly);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", bse.getMessage()));
        }
    }

    protected void saveSDKVersionFilterProjectPreference() {
        try {
            IEclipsePreferences prefs = new ProjectScope(this.project).getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.putBoolean(FILTER_SDKS_PREF_KEY, this.isLatestSDKVersionsOnly);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", bse.getMessage()));
        }
    }

    protected void createVersionFilterCheckbox(Composite parent) {
        this.showAllVersionsCheckbox = new Button(parent, 32);
        this.showAllVersionsCheckbox.setText(Messages.SDKManagementWidget_show_latest_sdk_versions_only);
        this.showAllVersionsCheckbox.setSelection(this.isLatestSDKVersionsOnly);
        this.showAllVersionsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                SDKManagementWidget.this.isLatestSDKVersionsOnly = b.getSelection();
                SDKManagementWidget.this.updateWidgetState();
            }
        });
    }

    protected void createFilterArea(Composite parent) {
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected void createImportExportButtons(Composite parent) {
        Font font = parent.getFont();
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.importButton = new Button(parent, 8);
        this.importButton.setText(Messages.SDKManagementWidget_import_sdk_button_text);
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SDKManagementWidget.this.performImportSDK();
            }
        });
        this.importButton.setFont(font);
        this.setButtonLayoutData(this.importButton);
        this.exportButton = new Button(parent, 8);
        this.exportButton.setText(Messages.SDKManagementWidget_export_sdk_button_text);
        this.exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SDKManagementWidget.this.performExportSDK();
            }
        });
        this.exportButton.setFont(font);
        this.setButtonLayoutData(this.exportButton);
    }

    private void removeSDK(Composite parent) {
        ISDK[] sdks = SDKManagementWidget.getSDKsForDelete(this.viewer);
        if (sdks != null) {
            ISDK sdk;
            StringBuilder names = new StringBuilder();
            ISDK[] iSDKArray = sdks;
            int n = sdks.length;
            int n2 = 0;
            while (n2 < n) {
                sdk = iSDKArray[n2];
                names.append('\n').append(sdk.getBriefInfo());
                ++n2;
            }
            if (MessageDialog.openConfirm((Shell)parent.getShell(), (String)Messages.SDKManagementWidget_remove_sdk_confirmation_title, (String)String.format(Messages.SDKManagementWidget_remove_sdk_confirmation_text, String.valueOf(names.toString()) + '\n'))) {
                iSDKArray = sdks;
                n = sdks.length;
                n2 = 0;
                while (n2 < n) {
                    sdk = iSDKArray[n2];
                    SDKUtils.remove(sdk);
                    this.selMap.remove(sdk.getId());
                    ++n2;
                }
                ImportSDK.storeImportSDKs();
                ExternalSDK.storeExternalSDKs();
                ProjectLocalSDK.storeProjectLocalSDKs();
                this.oldMap = SDKManagementWidget.copyData(this.selMap);
                this.updateWidgetState();
            }
        }
    }

    protected void updateExportButtonState() {
        ISDK sdkFromSel = SDKManagementWidget.getSDKFromSel(this.viewer);
        this.exportButton.setEnabled(this.isSelectedSingle() && sdkFromSel instanceof IExternalSDK && sdkFromSel.isAvailable());
    }

    protected void createButtonGroup(Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(groupComponent);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(parent.getFont());
        this.createAddButton(groupComponent);
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(Messages.SDKManagementWidget_edit_sdk_button_text);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISDK sdk = SDKManagementWidget.getSDKFromSel(SDKManagementWidget.this.viewer);
                boolean isContributed = sdk instanceof IContributedSDK;
                boolean isAttached = !SDKAttach.getAttached(sdk).isEmpty();
                IEnvironment originalEnv = sdk.getEnv();
                SDKEditDialog dialog = new SDKEditDialog(SDKManagementWidget.this.shell, isContributed || isAttached ? 3 : 2, sdk.getFilterOptions(), SDKManagementWidget.this.project);
                dialog.setSDKName(sdk.getName());
                dialog.setSDKVersion(sdk.getVersion());
                dialog.setSDKDescription(sdk.getDescription());
                dialog.setSDKEnv(originalEnv);
                dialog.setSourcePaths(sdk.getAll(0));
                dialog.setHeaderPaths(sdk.getAll(1));
                dialog.setBinaryPaths(sdk.getAll(2));
                dialog.setOtherPaths(sdk.getAll(3));
                dialog.setLDPaths(sdk.getAll(4));
                dialog.setDefSymbols(sdk.getDefSymbols());
                dialog.setHeads(sdk.getToolChainAliases(), sdk.getToolChainIDs());
                if (sdk instanceof GitSDK) {
                    dialog.setGitPath(((GitSDK)sdk).getGitPath());
                }
                if (dialog.open() == 1) {
                    SDKManagementWidget.this.updateWidgetState();
                    return;
                }
                IEnvironment newEnv = dialog.getSDKEnv();
                String maybeNewPath = dialog.getSDKPath();
                originalEnv.removeValue();
                if (!newEnv.isSystem()) {
                    newEnv.setValue(maybeNewPath, null, isContributed);
                }
                if (!isContributed) {
                    IExternalSDK extSDK = (IExternalSDK)sdk;
                    IFilterOptions fo = dialog.getFilter();
                    String tcId = fo.getToolChainID();
                    SDKHeader h = new SDKHeader(dialog.getSDKName(), dialog.getSDKVersion(), dialog.getSDKDescription(), dialog.getSDKPath(), fo.getLang().toString(), String.join((CharSequence)",", fo.getCores()), false, false, dialog.getSDKEnv());
                    extSDK.setHeader(h);
                    extSDK.setPaths(SDKManagementWidget.this.fillRoot(tcId, dialog));
                    extSDK.setFilterOptions(dialog.getFilter());
                }
                ExternalSDK.storeExternalSDKs();
                ProjectLocalSDK.storeProjectLocalSDKs();
                SDKManagementWidget.this.updateWidgetState();
            }
        });
        this.editButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.editButton);
        this.createRemoveButton(groupComponent);
        this.gitImportButton = (Button)new AtomicReference<Button>(new Button(groupComponent, 8), parent){
            {
                ((Button)this.get()).setText(Messages.SDKManagementWidget_Clone_from_git);
                ((Button)this.get()).setFont(composite.getFont());
                ((Button)this.get()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SDKManagementWidget.this.loadGitData(composite.getShell());
                    }
                });
                SDKManagementWidget.this.setButtonLayoutData((Button)this.get());
            }
        }.get();
        this.createExtraButtons(groupComponent);
        this.updateEnabledState();
    }

    private TCHolder fillRoot(String id, SDKEditDialog d) {
        TCHolder root = new TCHolder(id);
        root.srcs.addAll(Arrays.asList(d.getSourcePaths()[0]));
        root.hdrs.addAll(Arrays.asList(d.getHeaderPaths()[0]));
        root.bins.addAll(Arrays.asList(d.getBinaryPaths()[0]));
        root.oths.addAll(Arrays.asList(d.getOtherPaths()[0]));
        root.ldfs.addAll(Arrays.asList(d.getLDPaths()[0]));
        root.defs.addAll(Arrays.asList(d.getDefSymbols()[0]));
        return root;
    }

    protected void loadGitData(Shell shell) {
        ISDK xz = SDKManagementWidget.getSDKFromSel(this.viewer);
        if (!(xz instanceof GitSDK)) {
            return;
        }
        GitSDK sdk = (GitSDK)xz;
        if (sdk.getGitPath() == null || sdk.getGitPath().isEmpty()) {
            Status st = new Status(8, "com.freescale.s32ds.cross.sdk.support", GIT_EMPTY_REP);
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)GIT_ERROR_TITLE, null, (IStatus)st);
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(shell);
        String p = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support").get(GIT_LOAD_KEY, "");
        dialog.setFilterPath(p);
        dialog.setMessage(String.format(Messages.SDKManagementWidget_remote_url, sdk.getGitPath()));
        dialog.setText(Messages.SDKManagementWidget_select_dest_folder);
        String dir = dialog.open();
        if (dir == null || dir.isEmpty() || !new File(dir).isDirectory()) {
            Status st = new Status(8, "com.freescale.s32ds.cross.sdk.support", GIT_LOCAL_BAD);
            ErrorDialog.openError((Shell)shell, (String)GIT_ERROR_TITLE, (String)GIT_LOCAL_BAD, (IStatus)st);
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        prefs.put(GIT_LOAD_KEY, dir);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, false, monitor -> {
                try {
                    GitSDK.importFromGit(sdk, new File(dir), monitor, shell);
                    this.updateWidgetState();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            });
        }
        catch (Exception ex) {
            Status st = new Status(4, "com.freescale.s32ds.cross.sdk.support", ex.getMessage(), (Throwable)ex);
            SDKSupportPlugin.log((IStatus)st);
            ErrorDialog.openError((Shell)shell, (String)GIT_ERROR_TITLE, (String)ex.getMessage(), (IStatus)st);
        }
    }

    protected GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void updateViewerInput() {
        this.viewer.setInput(this.getSDKs());
    }

    protected void updateWidgetState() {
        Runnable update = () -> {
            Object[] saved = this.saveSelection();
            this.updateViewerInput();
            this.restoreSelection(saved);
            this.updateEnabledState();
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(update);
        } else {
            update.run();
        }
    }

    private Object[] saveSelection() {
        this.lastSelection = this.viewer.getTable().getSelectionIndex();
        return Arrays.asList(this.viewer.getTable().getSelection()).stream().map(ti -> String.valueOf(ti.getText(0)) + ti.getText(1)).toArray();
    }

    private void restoreSelection(Object[] saved) {
        if (saved != null && saved.length > 0) {
            ArrayList<TableItem> sel = new ArrayList<TableItem>();
            TableItem[] tis = this.viewer.getTable().getItems();
            Object[] objectArray = saved;
            int n = saved.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                TableItem[] tableItemArray = tis;
                int n3 = tis.length;
                int n4 = 0;
                while (n4 < n3) {
                    TableItem ti = tableItemArray[n4];
                    if ((String.valueOf(ti.getText(0)) + ti.getText(1)).equals(s)) {
                        sel.add(ti);
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (sel.size() > 0) {
                this.viewer.getTable().setSelection(sel.toArray(new TableItem[sel.size()]));
            } else {
                int max = this.viewer.getTable().getItemCount() - 1;
                this.viewer.getTable().setSelection(this.lastSelection != -1 && max >= this.lastSelection ? this.lastSelection : max);
            }
            this.viewer.getTable().setFocus();
        }
    }

    private void updateEnabledState() {
        Button b;
        if (this.isReadOnly) {
            return;
        }
        ISDK sdk = SDKManagementWidget.getSDKFromSel(this.viewer);
        boolean itemSelected = this.isSelectedSingle() && sdk != null;
        this.editButton.setEnabled(itemSelected);
        if (this.removeButton != null) {
            this.removeButton.setEnabled(SDKManagementWidget.getSDKsForDelete(this.viewer) != null);
        }
        this.gitImportButton.setEnabled(itemSelected && sdk instanceof GitSDK);
        if (this.holderDialog != null && (b = this.holderDialog.getOK()) != null) {
            b.setEnabled(this.checksAreOk());
        }
        this.updateExtraButtonsState();
    }

    private boolean checksAreOk() {
        this.holderDialog.setMessage("");
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked() && ti.getData() instanceof ISDK && ((ISDK)ti.getData()).getStatus() == ISDK.STATUS.HEAD) {
                this.holderDialog.setMessage(Messages.SDKManagementWidget_need_load_sources);
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected IFilterOptions getFilterOptions() {
        return null;
    }

    public void resetTable() {
        if (this.viewer != null) {
            Table table = this.viewer.getTable();
            int size = table.getColumnCount();
            int[] order = new int[size];
            int i = 0;
            while (i < size) {
                order[i] = i;
                ++i;
            }
            table.setColumnOrder(order);
            i = 0;
            while (i < size) {
                int len = SDKTableViewerHolder.COLUMN_SIZES[0];
                int last = SDKTableViewerHolder.COLUMN_SIZES.length - 1;
                if (i < last - 1) {
                    len = SDKTableViewerHolder.COLUMN_SIZES[i + 1];
                } else if (i == size - 1) {
                    len = SDKTableViewerHolder.COLUMN_SIZES[last];
                }
                this.viewer.getTable().getColumn(i).setWidth(len);
                ++i;
            }
            this.viewer.getTable().redraw();
        }
    }

    private static ISDK getSDKFromSel(TableViewer viewer) {
        TableItem[] items = viewer.getTable().getSelection();
        if (items != null && items.length > 0 && items[0].getData() instanceof ISDK) {
            return (ISDK)items[0].getData();
        }
        return null;
    }

    private static ISDK[] getSDKsForDelete(TableViewer viewer) {
        TableItem[] items = viewer.getTable().getSelection();
        ArrayList<ISDK> lst = new ArrayList<ISDK>();
        if (items != null && items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                Object obj = ti.getData();
                if (obj instanceof IExternalSDK || obj instanceof ImportSDK) {
                    lst.add((ISDK)obj);
                }
                ++n2;
            }
            if (lst.size() > 0) {
                return lst.toArray(new ISDK[lst.size()]);
            }
        }
        return null;
    }

    private static boolean canAttachSel(TableViewer viewer) {
        TableItem[] items = viewer.getTable().getSelection();
        if (items != null && items.length > 0) {
            int cnt = viewer.getTable().getColumnCount() - 1;
            int i = 3;
            while (i < cnt) {
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getData("ATTACH" + (i - 3)) != null) {
                        return true;
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return false;
    }

    protected Map<String, Boolean[]> makeData(IProject project, List<ISDK> sdks) {
        IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        LinkedHashMap<String, Boolean[]> data = new LinkedHashMap<String, Boolean[]>();
        ArrayList<ISDK> unabvailableSDKs = new ArrayList<ISDK>();
        for (ISDK sdk : sdks) {
            String id = sdk.getId();
            if (!sdk.isAvailable()) {
                data.put(id, new Boolean[cfgs.length]);
                unabvailableSDKs.add(sdk);
                continue;
            }
            data.put(id, CHECKER.checkToolchainsCompatibility(sdk, project));
        }
        if (!unabvailableSDKs.isEmpty()) {
            this.processUnavailableSDKs(unabvailableSDKs);
        }
        return data;
    }

    protected void processUnavailableSDKs(List<ISDK> sdks) {
    }

    private static Map<String, Boolean[]> copyData(Map<String, Boolean[]> map) {
        LinkedHashMap<String, Boolean[]> data = new LinkedHashMap<String, Boolean[]>();
        for (String s : map.keySet()) {
            Boolean[] a = map.get(s);
            Boolean[] b = new Boolean[a.length];
            System.arraycopy(a, 0, b, 0, a.length);
            data.put(s, b);
        }
        return data;
    }

    protected boolean isSelectedSingle() {
        return this.getSelected().size() == 1;
    }

    protected void createAddButton(Composite groupComponent) {
        Button addButton = new Button(groupComponent, 8);
        addButton.setText(Messages.SDKManagementWidget_add_sdk_button_text);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFilterOptions fo = SDKManagementWidget.this.getFilterOptions();
                SDKEditDialog dialog = new SDKEditDialog(SDKManagementWidget.this.shell, 1, fo, SDKManagementWidget.this.project);
                if (dialog.open() == 1) {
                    SDKManagementWidget.this.updateWidgetState();
                    return;
                }
                IFilterOptions newFilterOptions = dialog.getFilter();
                if (newFilterOptions == null) {
                    newFilterOptions = FilterOptions.createFilter(SDKManagementWidget.this.info);
                }
                SDKHeader h = new SDKHeader(dialog.getSDKName(), dialog.getSDKVersion(), dialog.getSDKDescription(), dialog.getSDKPath(), newFilterOptions.getLang().toString(), String.join((CharSequence)",", newFilterOptions.getCores()), false, false, dialog.getSDKEnv());
                String tcId = newFilterOptions.getToolChainID();
                TCHolder root = SDKManagementWidget.this.fillRoot(tcId, dialog);
                ExternalSDK sdk = SDKManagementWidget.this.project == null ? new ExternalSDK(h, root, newFilterOptions) : new ProjectLocalSDK(SDKManagementWidget.this.project, h, root, newFilterOptions);
                SDKUtils.add(sdk, true);
                ExternalSDK.storeExternalSDKs();
                ProjectLocalSDK.storeProjectLocalSDKs();
                SDKManagementWidget.this.updateWidgetState();
            }
        });
        addButton.setFont(groupComponent.getParent().getFont());
        this.setButtonLayoutData(addButton);
    }

    protected void createRemoveButton(final Composite groupComponent) {
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(Messages.SDKManagementWidget_remove_sdk_button_text);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKManagementWidget.this.removeSDK(groupComponent.getParent());
            }
        });
        this.removeButton.setFont(groupComponent.getParent().getFont());
        this.setButtonLayoutData(this.removeButton);
    }

    private void performImportSDK() {
        SDKImportDialog dialog = new SDKImportDialog(this.shell);
        if (dialog.open() != 0) {
            return;
        }
        SDKImportHandler h = new SDKImportHandler();
        h.setSDKImportUICallbackHandler(new SDKImportUICallbackHandler(this.shell));
        try {
            if (dialog.mode() == 0) {
                h.importSDK(dialog.destination(), dialog.location());
            } else {
                h.importSDK(dialog.source());
            }
            this.updateWidgetState();
        }
        catch (SDKLoadException sle) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", "SDK import exception", (Throwable)sle));
        }
    }

    private void performExportSDK() {
        IExternalSDK sdk = (IExternalSDK)SDKManagementWidget.getSDKFromSel(this.viewer);
        SDKExportDialog dialog = new SDKExportDialog(this.shell, sdk);
        if (dialog.open() == 0) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IProgressService ps = wb.getProgressService();
            try {
                String location = dialog.location();
                boolean isExportDescriptorOnly = !dialog.withContent();
                ps.run(false, false, pm -> new SDKExportHandler().exportSDK(location, sdk, isExportDescriptorOnly, pm));
            }
            catch (InterruptedException | InvocationTargetException e) {
                SDKSupportPlugin.error(e);
            }
        }
        this.updateWidgetState();
    }

    /* synthetic */ SDKManagementWidget(String string, int n, boolean bl, SDKManagementWidget sDKManagementWidget) {
        this(bl);
    }
}

