/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.availability;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.ISDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKNotAvailableException;
import org.eclipse.core.runtime.IPath;

public class SDKAvailabilityChecker
implements ISDKAvailabilityChecker {
    @Override
    public void checkAvailability(String sdkId) throws SDKNotAvailableException {
        ISDK sdk = SDKUtils.getSDKbyID(sdkId);
        if (sdk == null) {
            throw new SDKNotAvailableException(String.format("SDK %s is not found in workspace", sdkId));
        }
        IPath sdkPath = SDKSupportPlugin.getEclipsePath(sdk);
        if (sdkPath == null || sdkPath.isEmpty() || !sdkPath.toFile().exists()) {
            throw new SDKNotAvailableException(String.format("SDK %s is not found: invalid path: %s", sdkId, sdkPath != null ? sdkPath : ""));
        }
    }
}

