/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.suppliers;

import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.util.ArrayList;
import java.util.List;

public class ToolchainDefinition {
    public static final String GNU_TOOLS_FOR_ARM_EMBEDDED = "GNU Tools for ARM Embedded Processors";
    public static final String DEFAULT_TOOLCHAIN_NAME = "GNU Tools for ARM Embedded Processors";
    private String fName;
    private String fPrefix;
    private String fSuffix;
    private String fArchitecture;
    private String fCmdMake;
    private String fCmdRm;
    private String fCmdWinMake;
    private String fCmdWinRm;
    private String fCmdC;
    private String fCmdCpp;
    private String fCmdAr;
    private String fCmdObjcopy;
    private String fCmdObjdump;
    private String fCmdSize;
    private static String[] fArchitectures = new String[]{"ARM (AArch32)", "ARM64 (AArch64)"};
    private static List<ToolchainDefinition> fgList = new ArrayList<ToolchainDefinition>();

    static {
        fgList.add(new ToolchainDefinition("GNU Tools for ARM Embedded Processors", "arm-none-eabi-"));
        ToolchainDefinition tc = new ToolchainDefinition("Sourcery CodeBench Lite for ARM EABI", "arm-none-eabi-");
        if (OSFamily.WINDOWS.isCurrent()) {
            tc.setWin("cs-make", "cs-rm");
        }
        fgList.add(tc);
        tc = new ToolchainDefinition("Sourcery CodeBench Lite for ARM GNU/Linux", "arm-none-linux-gnueabi-");
        if (OSFamily.WINDOWS.isCurrent()) {
            tc.setWin("cs-make", "cs-rm");
        }
        fgList.add(tc);
        fgList.add(new ToolchainDefinition("devkitPro ARM EABI", "arm-eabi-"));
        fgList.add(new ToolchainDefinition("Yagarto, Summon, etc. ARM EABI", "arm-none-eabi-"));
        fgList.add(new ToolchainDefinition("Linaro ARMv7 Linux GNU EABI HF", "arm-linux-gnueabihf-"));
        fgList.add(new ToolchainDefinition("Linaro ARMv7 Big-Endian Linux GNU EABI HF", "armeb-linux-gnueabihf-"));
        fgList.add(new ToolchainDefinition("Linaro AArch64 bare-metal ELF", "aarch64-none-elf-", "aarch64"));
        fgList.add(new ToolchainDefinition("Linaro AArch64 big-endian bare-metal ELF", "aarch64_be-none-elf-", "aarch64"));
        fgList.add(new ToolchainDefinition("Linaro AArch64 Linux GNU", "aarch64-linux-gnu-", "aarch64"));
        fgList.add(new ToolchainDefinition("Linaro AArch64 big-endian Linux GNU", "aarch64_be-linux-gnu-", "aarch64"));
        fgList.add(new ToolchainDefinition("Custom", "arm-none-eabi-"));
    }

    public ToolchainDefinition(String sName, String sPrefix) {
        this.fName = sName;
        this.fPrefix = sPrefix;
        this.fSuffix = "";
        this.fArchitecture = "arm";
        this.fCmdMake = "make";
        this.fCmdRm = "rm";
        this.fCmdC = "gcc";
        this.fCmdCpp = "g++";
        this.fCmdAr = "ar";
        this.fCmdObjcopy = "objcopy";
        this.fCmdObjdump = "objdump";
        this.fCmdSize = "size";
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture) {
        this(sName, sPrefix);
        this.fArchitecture = sArchitecture;
    }

    public ToolchainDefinition(String sName, String sPrefix, String sArchitecture, String cmdMake, String cmdRm) {
        this(sName, sPrefix, sArchitecture);
        this.fArchitecture = sArchitecture;
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public void setWin(String cmdMake, String cmdRm) {
        this.fCmdMake = cmdMake;
        this.fCmdRm = cmdRm;
    }

    public String getName() {
        return this.fName;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public String getSuffix() {
        return this.fSuffix;
    }

    public String getArchitecture() {
        return this.fArchitecture;
    }

    public String getCmdMake() {
        return this.fCmdMake;
    }

    public String getCmdRm() {
        return this.fCmdRm;
    }

    public String getCmdWinMake() {
        return this.fCmdWinMake;
    }

    public String getCmdWinRm() {
        return this.fCmdWinRm;
    }

    public String getCmdC() {
        return this.fCmdC;
    }

    public String getCmdCpp() {
        return this.fCmdCpp;
    }

    public String getCmdAr() {
        return this.fCmdAr;
    }

    public String getCmdObjcopy() {
        return this.fCmdObjcopy;
    }

    public String getCmdObjdump() {
        return this.fCmdObjdump;
    }

    public String getCmdSize() {
        return this.fCmdSize;
    }

    public String getFullCmdC() {
        return String.valueOf(this.getPrefix()) + this.getCmdC() + this.getSuffix();
    }

    public String getFullName() {
        return String.valueOf(this.getName()) + " (" + this.getFullCmdC() + ")";
    }

    public static List<ToolchainDefinition> getList() {
        return fgList;
    }

    public static ToolchainDefinition getToolchain(int index) {
        return fgList.get(index);
    }

    public static ToolchainDefinition getToolchain(String index) {
        return fgList.get(Integer.parseInt(index));
    }

    public static int getSize() {
        return fgList.size();
    }

    public static int findToolchainByName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            if (td.fName.equals(sName)) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static int findToolchainByFullName(String sName) {
        int i = 0;
        for (ToolchainDefinition td : fgList) {
            String sFullName = td.getFullName();
            if (sFullName.equals(sName)) {
                return i;
            }
            ++i;
        }
        return ToolchainDefinition.getDefault();
    }

    public static int getDefault() {
        return 0;
    }

    public static String[] getArchitectures() {
        return fArchitectures;
    }

    public static String getArchitecture(int index) {
        return fArchitectures[index];
    }
}

