/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license;

import com.nxp.s32ds.ext.rcp.license.BrokenLicenseBackend;
import com.nxp.s32ds.ext.rcp.license.IFeatureId;
import com.nxp.s32ds.ext.rcp.license.ILicenseModel;
import com.nxp.s32ds.ext.rcp.license.ILicenseService;
import com.nxp.s32ds.ext.rcp.license.LicenseActivator;
import com.nxp.s32ds.ext.rcp.license.LicenseFeature;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import java.net.URI;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class CLLService
implements ILicenseService {
    private HashMap<String, ILicenseModel> lmodels = new HashMap();
    private LicenseFeature[] licenseFeatures = new LicenseFeature[0];
    private final ServiceTracker<IProxyService, IProxyService> proxyTracker = new ServiceTracker(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), IProxyService.class.getName(), null);
    public static final String PARAM_MODEL_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String PARAM_MODEL_HTTP_PROXY_USER = "http.proxyUser";
    public static final String PARAM_MODEL_HTTP_PROXY_PORT = "http.proxyPort";
    public static final String PARAM_MODEL_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String PARAM_MODEL_HTTP_PROXY_SET = "http.proxySet";
    private static final String PARAM_FEATURE_REQUIRED = "required";
    private static final String PARAM_FEATURE_PRODUCT_NAME = "productName";
    private static final String PARAM_FEATURE_ID = "featureId";
    private static final String PARAM_FEATURE_VERSION = "featureVersion";
    private static final String PARAM_FEATURE_LABEL = "featureLabel";
    private static final String PARAM_FEATURE_REFRESH = "refresh";
    private static final String PARAM_FEATURE_MODEL_ID = "modelId";
    private static final String PARAM_FEATURE_HOWTO_ACTIVATE = "howToActivate";
    private static final String PARAM_FEATURE_HOWTO_PROLONGE = "howToProlonge";

    public CLLService() {
        this.proxyTracker.open();
        IProxyService proxyService = (IProxyService)this.proxyTracker.getService();
        IProxyData[] proxyDataForHost = proxyService.select(URI.create("https://google.com/"));
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("license.")) continue;
            params.put(key, (String)entry.getValue());
        }
        IProxyData[] iProxyDataArray = proxyDataForHost;
        int n = proxyDataForHost.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyData data = iProxyDataArray[n2];
            if (data.getHost() != null) {
                params.put(PARAM_MODEL_HTTP_PROXY_SET, "true");
                params.put(PARAM_MODEL_HTTP_PROXY_HOST, data.getHost());
            }
            if (data.getUserId() != null) {
                params.put(PARAM_MODEL_HTTP_PROXY_USER, data.getUserId());
            }
            if (data.getPassword() != null) {
                params.put(PARAM_MODEL_HTTP_PROXY_PASSWORD, data.getPassword());
            }
            if (data.getHost() != null) {
                params.put(PARAM_MODEL_HTTP_PROXY_PORT, String.valueOf(data.getPort()));
            }
            ++n2;
        }
        this.loadExtensions(params);
    }

    @Override
    public LicenseFeature[] getFeatures() {
        return this.licenseFeatures;
    }

    public void loadExtensions(Map<String, String> params) {
        Object el;
        int n;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.nxp.s32ds.ext.rcp.license.setup");
        if (point == null) {
            return;
        }
        IConfigurationElement extensions = point.getExtensions();
        if (extensions == null || ((IExtension[])extensions).length == 0) {
            return;
        }
        HashSet<IConfigurationElement> licenseElements = new HashSet<IConfigurationElement>();
        IConfigurationElement iConfigurationElement = extensions;
        int n2 = ((IExtension[])iConfigurationElement).length;
        int n3 = 0;
        while (n3 < n2) {
            IExtension ext = iConfigurationElement[n3];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            n = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n) {
                el = iConfigurationElementArray[n4];
                if (el.getName().equals("license")) {
                    licenseElements.add((IConfigurationElement)el);
                }
                ++n4;
            }
            ++n3;
        }
        HashSet<String> productNames = new HashSet<String>();
        for (IConfigurationElement el2 : licenseElements) {
            productNames.add(el2.getAttribute(PARAM_FEATURE_PRODUCT_NAME));
        }
        el = extensions;
        int n5 = ((IExtension[])el).length;
        int n6 = 0;
        while (n6 < n5) {
            IConfigurationElement ext = el[n6];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n7 = iConfigurationElementArray.length;
            n = 0;
            while (n < n7) {
                IConfigurationElement el3 = iConfigurationElementArray[n];
                if (el3.getName().equals("licenseModel")) {
                    try {
                        this.createModel(el3, params, productNames);
                    }
                    catch (Throwable e) {
                        LicenseActivator.log(4, e.getMessage(), e);
                    }
                }
                ++n;
            }
            ++n6;
        }
        LinkedList<LicenseFeature> featureList = new LinkedList<LicenseFeature>();
        LinkedList<IFeatureId> disableFeature = new LinkedList<IFeatureId>();
        for (IConfigurationElement el4 : licenseElements) {
            try {
                LicenseFeature feature = this.createFeature(el4);
                if ("true".equals(el4.getAttribute("killerfeature"))) {
                    disableFeature.add(feature.getFeatureId());
                    continue;
                }
                featureList.add(feature);
            }
            catch (Throwable e) {
                LicenseActivator.log(4, e.getMessage(), e);
            }
        }
        Iterator fi = featureList.iterator();
        while (fi.hasNext()) {
            LicenseFeature f = (LicenseFeature)fi.next();
            if (!disableFeature.contains(f.getFeatureId())) continue;
            fi.remove();
        }
        this.licenseFeatures = featureList.toArray(new LicenseFeature[0]);
        this.init();
    }

    private void init() {
    }

    private void createModel(IConfigurationElement modelElement, Map<String, String> params, Set<String> products) throws Exception {
        String modelId = modelElement.getAttribute("id");
        if (this.lmodels.containsKey(modelId)) {
            return;
        }
        try {
            ILicenseModel model = (ILicenseModel)modelElement.createExecutableExtension("class");
            IConfigurationElement[] children = modelElement.getChildren();
            int j = 0;
            while (j < children.length) {
                if (children[j].getName().equals("setting")) {
                    AbstractMap.SimpleEntry<String, String> setting = new AbstractMap.SimpleEntry<String, String>(children[j].getAttribute("name"), children[j].getAttribute("value"));
                    params.put(setting.getKey(), setting.getValue());
                }
                ++j;
            }
            model.init(params, products);
            this.lmodels.put(modelId, model);
        }
        catch (Exception e) {
            LicenseActivator.log(4, e.getMessage(), e);
            this.lmodels.put(modelId, new BrokenLicenseBackend(e));
        }
    }

    private static Map<String, String> createParamMap(IConfigurationElement element, String ... paramNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = paramNames;
        int n = paramNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result.put(name, element.getAttribute(name));
            ++n2;
        }
        return result;
    }

    private LicenseFeature createFeature(IConfigurationElement element) throws Exception {
        IConfigurationElement[] htProlongeE;
        String modelId = element.getAttribute(PARAM_FEATURE_MODEL_ID);
        if (!this.lmodels.containsKey(modelId)) {
            String message = String.format("Model with id %s missing", modelId);
            LicenseActivator.log(4, message, new Exception(message));
        }
        Map<String, String> params = CLLService.createParamMap(element, PARAM_FEATURE_PRODUCT_NAME, PARAM_FEATURE_ID, PARAM_FEATURE_VERSION);
        ILicenseModel licenseModel = this.lmodels.get(modelId);
        IFeatureId fId = licenseModel.createFeatureId(params);
        LicenseFeature feature = new LicenseFeature(fId, licenseModel);
        feature.setLabel(element.getAttribute(PARAM_FEATURE_LABEL));
        if (element.getAttribute(PARAM_FEATURE_REFRESH) != null) {
            feature.setRefresh(Boolean.valueOf(element.getAttribute(PARAM_FEATURE_REFRESH)));
        }
        feature.setRequired(Boolean.valueOf(element.getAttribute(PARAM_FEATURE_REQUIRED)));
        IConfigurationElement[] htActivateE = element.getChildren(PARAM_FEATURE_HOWTO_ACTIVATE);
        if (htActivateE.length > 0) {
            feature.setHowToActivate(htActivateE[0].getValue());
        }
        if ((htProlongeE = element.getChildren(PARAM_FEATURE_HOWTO_PROLONGE)).length > 0) {
            feature.setHowToProlonge(htProlongeE[0].getValue());
        }
        return feature;
    }

    @Override
    public LicenseStatus getFeatureStatus(IFeatureId featureId) {
        LicenseFeature feature = this.getFeature(featureId);
        if (feature != null) {
            return feature.getStatus();
        }
        return null;
    }

    @Override
    public LicenseFeature getFeature(IFeatureId featureId) {
        LicenseFeature[] licenseFeatureArray = this.licenseFeatures;
        int n = this.licenseFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFeature lf = licenseFeatureArray[n2];
            if (lf.getLicenseFeatureId().equals(featureId)) {
                return lf;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void resetCaches() {
        LicenseFeature[] licenseFeatureArray = this.licenseFeatures;
        int n = this.licenseFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFeature f = licenseFeatureArray[n2];
            f.resetCache();
            ++n2;
        }
    }
}

