/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.api;

import com.pemicro.debug.gdbjtag.pne.Utils;
import com.pemicro.debug.gdbjtag.pne.api.FlashGDBConsoleListener;
import com.pemicro.debug.gdbjtag.pne.api.IPemicroUtil;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class PemicroUtil
implements IPemicroUtil {
    private FlashGDBConsoleListener consoleOutput = null;

    @Override
    public String convertFreescaleDevice(String freescaleDevice) {
        Pattern p = Pattern.compile("[MPS]([A-Z]+[A\\d]+[A-Z]+\\d+(?:M\\d+)?[AZ]?)[A-Zx]+(\\d+)");
        Matcher m = p.matcher(freescaleDevice);
        String pe_string = "";
        if (!m.find()) {
            return "";
        }
        pe_string = String.valueOf(m.group(1)) + 'M' + m.group(2);
        String family = PemicroUtil.getPemicroFamily(pe_string);
        if (family.isEmpty()) {
            return "";
        }
        pe_string = "NXP_" + family + "_" + pe_string;
        return pe_string;
    }

    @Override
    public ArrayList<String> getSupportedDeviceNames() {
        return Utils.getAvailableDevices();
    }

    @Override
    public boolean setPemicroDevice(String freescaleDevice, ILaunchConfigurationWorkingCopy config) {
        String pe_string = this.convertFreescaleDevice(freescaleDevice);
        if (pe_string.isEmpty()) {
            return false;
        }
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", pe_string);
        return true;
    }

    @Override
    public boolean setNativePemicroDevice(String pemicroDevice, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", pemicroDevice);
        return true;
    }

    @Override
    public ArrayList<IPemicroUtil.PemicroInterface> getPemicroInterfaces() {
        ArrayList<TabDebugger.HardwarePorts> detectedHardware = TabDebugger.getHardwarePorts();
        ArrayList<IPemicroUtil.PemicroInterface> result = new ArrayList<IPemicroUtil.PemicroInterface>();
        int i = 0;
        while (i < detectedHardware.size()) {
            TabDebugger.HardwarePorts currentIface = detectedHardware.get(i);
            int j = 0;
            while (j < currentIface.ports.size()) {
                IPemicroUtil.PemicroInterface temp = new IPemicroUtil.PemicroInterface();
                temp.interfaceEnum = IPemicroUtil.interfaceType.values()[i];
                temp.port = j;
                temp.humanString = currentIface.comboStrings.get(j);
                temp.portString = currentIface.ports.get(j);
                result.add(temp);
                ++j;
            }
            ++i;
        }
        return result;
    }

    @Override
    public String getGDBInterfaceString(IPemicroUtil.PemicroInterface selection) {
        String interfaceString = "";
        switch (selection.interfaceEnum) {
            case MULTILINK: {
                interfaceString = "-interface=USBMULTILINK -port=" + selection.portString;
                break;
            }
            case CYCLONE_SERIAL: {
                interfaceString = "-interface=CYCLONE -port=" + selection.portString;
                break;
            }
            case CYCLONE_USB: {
                interfaceString = "-interface=CYCLONE -port=" + selection.portString;
                break;
            }
            case CYCLONE_ETHERNET: {
                interfaceString = "-interface=CYCLONE -port=" + selection.portString;
                break;
            }
            case TRACELINK_USB: {
                interfaceString = "-interface=TRACELINK -port=" + selection.portString;
                break;
            }
            case TRACELINK_ETHERNET: {
                interfaceString = "-interface=TRACELINK -port=" + selection.portString;
                break;
            }
            case OPENSDA: {
                interfaceString = "-interface=OPENSDA -port=" + selection.portString;
            }
        }
        return interfaceString;
    }

    @Override
    public String previewGDBFlashCommands(ILaunchConfiguration configuration, ArrayList<String> userCommands) {
        ArrayList<String> serverLaunchCommands = null;
        String fullServerLaunchPath = "";
        boolean flashObjectFileFound = false;
        if (userCommands != null) {
            flashObjectFileFound = userCommands.toString().contains("-flashobjectfile");
        }
        if (configuration == null) {
            if (!flashObjectFileFound) {
                System.err.println("Error: -flashobjectfile not found in GDB parameters");
                return "";
            }
            serverLaunchCommands = new ArrayList<String>(userCommands);
            serverLaunchCommands.add(0, TabDebugger.getGdbServerCommand());
            serverLaunchCommands.add("-startserver");
            serverLaunchCommands.add("-singlesession");
        } else {
            serverLaunchCommands = new ArrayList<String>(Arrays.asList(TabDebugger.getGdbServerCommandLineArray(configuration)));
            serverLaunchCommands.addAll(userCommands);
            if (!flashObjectFileFound) {
                String holdObjectPath = new String(this.getLaunchConfigurationObjectFileName(configuration));
                serverLaunchCommands.add("-flashobjectfile=" + holdObjectPath);
            }
        }
        serverLaunchCommands.add(new String("-quitafterprogramming"));
        String serverPath = new String(serverLaunchCommands.get(0));
        serverLaunchCommands.remove(0);
        String serverLaunchCommandsString = new String(serverLaunchCommands.toString());
        serverLaunchCommandsString = serverLaunchCommandsString.substring(1, serverLaunchCommandsString.length() - 1);
        serverLaunchCommandsString = serverLaunchCommandsString.replace(",", " ");
        fullServerLaunchPath = new String(String.valueOf(serverPath) + " " + serverLaunchCommandsString);
        fullServerLaunchPath.replace("/", File.separator);
        fullServerLaunchPath.replace("\\", File.separator);
        return fullServerLaunchPath;
    }

    @Override
    public String getLaunchConfigurationObjectFileName(ILaunchConfiguration configuration) {
        String holdObjectPath = "";
        File objectPath = null;
        try {
            objectPath = Utils.getProjectOsPath(configuration);
            holdObjectPath = String.valueOf(objectPath.toString()) + File.separator + configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            holdObjectPath = holdObjectPath.replace("\\", File.separator);
            holdObjectPath = holdObjectPath.replace("/", File.separator);
        }
        catch (CoreException coreException) {
            holdObjectPath = "";
        }
        return holdObjectPath;
    }

    @Override
    public boolean launchGDBServerFlasher(String fullServerLaunchPath, FlashGDBConsoleListener listener) {
        boolean success = false;
        this.consoleOutput = listener;
        Runtime serverLaunch = Runtime.getRuntime();
        try {
            Process p = serverLaunch.exec(fullServerLaunchPath);
            String line = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (p.isAlive()) {
                line = reader.readLine();
                if (line == null) continue;
                if (line.contains("All Servers Running")) {
                    success = true;
                }
                if (this.consoleOutput == null) continue;
                this.consoleOutput.getBackConsoleString(line);
            }
            if (!success) {
                Utils.debugPrint("startGdbServerJob failed");
            }
            reader.close();
            p.destroy();
        }
        catch (IOException iOException) {
            System.err.println("A problem detected during FLASH programming by GDB Server. Please check your commandline parameters and make sure another instance of GDB server is not running");
        }
        return success;
    }

    @Override
    public void setInterfaceType(IPemicroUtil.PemicroInterface iface, ILaunchConfigurationWorkingCopy config) {
        String postfix = "";
        switch (iface.interfaceEnum) {
            case MULTILINK: {
                postfix = ".ml.";
                break;
            }
            case CYCLONE_SERIAL: {
                postfix = ".cyc_ser.";
                break;
            }
            case CYCLONE_USB: {
                postfix = ".cyc_usb.";
                break;
            }
            case CYCLONE_ETHERNET: {
                postfix = ".cyc_eth.";
                break;
            }
            case TRACELINK_USB: {
                postfix = ".trc_usb.";
                break;
            }
            case TRACELINK_ETHERNET: {
                postfix = ".trc_eth.";
                break;
            }
            case OPENSDA: {
                postfix = ".sda.";
            }
        }
        String attributeHeader = "com.pemicro.debug.gdbjtag.pne" + postfix;
        config.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT", iface.port);
        config.setAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT_STRING", iface.portString);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", iface.interfaceEnum.ordinal());
    }

    @Override
    public boolean setGdbClientPath(String path, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", path);
        return true;
    }

    @Override
    public boolean setSemihosting(IPemicroUtil.SemihostingConfiguration settings, ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihosting", settings.semihostingEnabled);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientTelnet", settings.telnetEnabled);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.enableSemihostingIoclientGdbClient", settings.gdbClientEnabled);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbServerTelnetPortNumber", settings.telnetPort);
        config.setAttribute("com.pemicro.debug.gdbjtag.pne.doGdbServerAllocateSemihostingConsole", settings.telnetConsoleEnabled);
        return true;
    }

    public static String getPemicroFamily(String deviceName) {
        if (deviceName.startsWith("WPR")) {
            return "Sensors";
        }
        Pattern p = Pattern.compile("K(?:L?\\d|[EMSVW])");
        Matcher m = p.matcher(deviceName);
        if (m.find()) {
            String family = m.group();
            return String.valueOf(family) + "x";
        }
        return "";
    }
}

