/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.ui.intrinsics.IIntrinsicsGroup;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclaration;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclarationException;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicsGroup;
import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainIntrinsicsHolder;
import com.freescale.s32ds.cross.core.ui.intrinsics.ToolchainsRoot;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

class ToolchainIntrinsicsParser {
    private static final String ELEMENT_INTRINSICS = "intrinsics";
    private static final String EXT_POINT_ID = "Intrinsics";
    private static final String ATTRIBUTE_GROUP = "group";
    private static final String ATTRIBUTE_FILE = "file";
    private static final String ELEMENT_TOOLCHAIN = "toolchain";
    private static final String ELEMENT_INTRINSIC = "intrinsic";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_RETURN = "returnType";
    private static final String ELEMENT_PARAMETER = "param";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_VALID_FOR = "valid-for";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_CHECK = "check";
    private static final String ATTRIBUTE_PROJECT_OPTIONS = "project_options";
    private static final String ELEMENT_PROJECT_OPTION = "project-option";
    private static String contributor = null;

    ToolchainIntrinsicsParser() {
    }

    static ToolchainsRoot parse() {
        ToolchainsRoot tcRoot = new ToolchainsRoot();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.core.Intrinsics");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                contributor = ext.getContributor().getName();
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ELEMENT_TOOLCHAIN.equals(ce.getName())) {
                        ToolchainIntrinsicsParser.parseToolchainElement(ce, tcRoot);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return tcRoot;
    }

    private static void parseToolchainElement(IConfigurationElement toolchainCE, ToolchainsRoot tcRoot) {
        IConfigurationElement[] intrinsics;
        IConfigurationElement[] groups;
        String toolchainId = toolchainCE.getAttribute(ATTRIBUTE_ID);
        if (toolchainId == null) {
            return;
        }
        String toolchainName = toolchainCE.getAttribute(ATTRIBUTE_NAME);
        ToolchainIntrinsicsHolder holder = new ToolchainIntrinsicsHolder(toolchainId);
        holder.setToolchainName(toolchainName);
        IConfigurationElement[] iConfigurationElementArray = groups = toolchainCE.getChildren(ELEMENT_INTRINSICS);
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            String path = c.getAttribute(ATTRIBUTE_FILE);
            if (path != null && !path.isEmpty()) {
                String groupName = c.getAttribute(ATTRIBUTE_NAME);
                if (Boolean.parseBoolean(c.getAttribute(ATTRIBUTE_GROUP))) {
                    IntrinsicsGroup group = new IntrinsicsGroup(groupName);
                    ToolchainIntrinsicsParser.parseIntrinsicsGroup(path, group);
                    holder.addIntrinsicsGroup(group);
                } else {
                    ToolchainIntrinsicsParser.parseIntrinsicsGroup(path, holder);
                }
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = intrinsics = toolchainCE.getChildren(ELEMENT_INTRINSIC);
        int n3 = intrinsics.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement c = iConfigurationElementArray2[n];
            ToolchainIntrinsicsParser.parseIntrinsicDefinition(c, holder);
            ++n;
        }
        tcRoot.addToolchainIntrinsicsHolder(holder);
    }

    private static void parseIntrinsicDefinition(IConfigurationElement builtinCE, ToolchainIntrinsicsHolder holder) {
        IConfigurationElement[] params;
        String fName = builtinCE.getAttribute(ATTRIBUTE_NAME);
        String fReturnType = builtinCE.getAttribute(ATTRIBUTE_RETURN);
        ArrayList<String> paramsList = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = params = builtinCE.getChildren(ELEMENT_PARAMETER);
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement param = iConfigurationElementArray[n2];
            paramsList.add(param.getAttribute(ATTRIBUTE_TYPE));
            ++n2;
        }
        String[] fParams = new String[paramsList.size()];
        fParams = paramsList.toArray(fParams);
        String fDescription = "";
        IConfigurationElement[] description = builtinCE.getChildren(ELEMENT_DESCRIPTION);
        if (description != null && description.length == 1) {
            fDescription = description[0].getValue();
        }
        ToolchainIntrinsicsParser.createIntrinsicDeclaration(holder, fName, fReturnType, fParams, fDescription);
    }

    private static void parseIntrinsicsGroup(String fileName, IIntrinsicsGroup group) {
        try {
            URL resolvedUrl = FileLocator.resolve((URL)Platform.getBundle((String)contributor).getEntry(fileName));
            InputStream is = resolvedUrl.openConnection().getInputStream();
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                Element root = parser.parse(bis).getDocumentElement();
                if (ELEMENT_INTRINSICS.equals(root.getNodeName())) {
                    String includeName = root.getAttribute("include");
                    ((IntrinsicsGroup)group).setInclude(includeName);
                    ToolchainIntrinsicsParser.parseValidForElement(group, root);
                    NodeList intrinsics = root.getElementsByTagName(ELEMENT_INTRINSIC);
                    int i = 0;
                    while (i < intrinsics.getLength()) {
                        Element intrinsic = (Element)intrinsics.item(i);
                        ToolchainIntrinsicsParser.parseIntrinsicDefinition(intrinsic, group);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.log((IStatus)new Status(4, "com.freescale.s32ds.cross.core", "Unable to load intrinsics from " + fileName, (Throwable)e));
        }
    }

    private static void parseValidForElement(IIntrinsicsGroup group, Element root) {
        NodeList projectOptions;
        Element checkOption;
        NodeList validForOptions = root.getElementsByTagName(ELEMENT_VALID_FOR);
        if (validForOptions != null && validForOptions.getLength() > 0 && ATTRIBUTE_PROJECT_OPTIONS.equals((checkOption = (Element)validForOptions.item(0)).getAttribute(ATTRIBUTE_CHECK)) && (projectOptions = root.getElementsByTagName(ELEMENT_PROJECT_OPTION)) != null && projectOptions.getLength() > 0) {
            Element projectOption = (Element)projectOptions.item(0);
            IntrinsicsGroup intrinsicsGroup = (IntrinsicsGroup)group;
            IntrinsicsGroup intrinsicsGroup2 = (IntrinsicsGroup)group;
            intrinsicsGroup2.getClass();
            intrinsicsGroup.setGroupValidator(new IntrinsicsGroup.SPGroupValidator(intrinsicsGroup2, projectOption.getAttribute(ATTRIBUTE_ID), projectOption.getAttribute(ATTRIBUTE_VALUE)));
        }
    }

    private static void parseIntrinsicDefinition(Element intrinsic, IIntrinsicsGroup holder) {
        String fName = intrinsic.getAttribute(ATTRIBUTE_NAME);
        String fReturnType = intrinsic.getAttribute(ATTRIBUTE_RETURN);
        ArrayList<String> paramsList = new ArrayList<String>();
        NodeList params = intrinsic.getElementsByTagName(ELEMENT_PARAMETER);
        int k = 0;
        while (k < params.getLength()) {
            paramsList.add(((Element)params.item(k)).getAttribute(ATTRIBUTE_TYPE));
            ++k;
        }
        String[] fParams = new String[paramsList.size()];
        fParams = paramsList.toArray(fParams);
        String fDescription = "";
        NodeList description = intrinsic.getElementsByTagName(ELEMENT_DESCRIPTION);
        if (description != null && description.getLength() > 0) {
            fDescription = ((Element)description.item(0)).getTextContent().trim();
        }
        ToolchainIntrinsicsParser.createIntrinsicDeclaration(holder, fName, fReturnType, fParams, fDescription);
    }

    private static void createIntrinsicDeclaration(IIntrinsicsGroup holder, String name, String returnType, String[] paramTypes, String description) {
        try {
            IntrinsicDeclaration declaration = IntrinsicDeclaration.create(holder).setName(name).setParameterTypes(paramTypes).setReturnType(returnType).setDescription(description);
            if (holder instanceof IntrinsicsGroup) {
                declaration.setInclude(((IntrinsicsGroup)holder).getInclude());
            }
            holder.addIntrinsicDeclaration(declaration);
        }
        catch (IntrinsicDeclarationException e) {
            Activator.logError(e.getMessage());
        }
    }
}

