/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.data;

import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureSlaveData;
import com.freescale.s32ds.cross.core.model.data.ObjectData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class CoreNatureMasterData
extends CoreNatureData {
    private List<CoreNatureSlaveData> slaves;

    public CoreNatureMasterData(IConfigurationElement ce, ConfigurationData parent, ModelRegistry registry) {
        super(ce, parent, registry);
    }

    @Override
    public void init() {
        String suffix;
        super.init();
        ConfigurationData suffixData = this.getAttributesDataMap().get("suffix");
        String string = suffix = suffixData != null ? suffixData.getStringValue("suffix") : null;
        if (suffix == null || suffix.isEmpty()) {
            int sIndex = this.getId().indexOf(95);
            if (sIndex >= 0 && sIndex + 1 < this.getId().length()) {
                suffix = this.getId().substring(sIndex + 1);
            }
            suffix = this.getUniqueSuffix(suffix);
            ConfigurationData sd = ConfigurationData.getData("suffix", suffix, this, true);
            this.addAttribute(sd);
        }
    }

    @Override
    public String getSuffix() {
        return this.getValue("suffix");
    }

    @Override
    public ProcessorData getProcessor() {
        return (ProcessorData)this.getParent().getParent();
    }

    @Override
    public List<CoreNatureSlaveData> getSlaves() {
        if (this.slaves == null) {
            this.slaves = new ArrayList<CoreNatureSlaveData>();
            List<ConfigurationData> elementRefRoots = this.getChildren();
            if (elementRefRoots.size() > 0) {
                ConfigurationData root = elementRefRoots.get(0);
                List<ConfigurationData> refs = root instanceof ObjectData ? ((ObjectData)root).getChildren() : root.getElements();
                for (ConfigurationData ref : refs) {
                    String coProcessorId = ref.getStringValue("coProcessorId");
                    ConfigurationData element = this.getRegistry().getData("coProcessor", coProcessorId);
                    if (!(element instanceof CoreNatureSlaveData)) continue;
                    CoreNatureSlaveData slave = (CoreNatureSlaveData)element;
                    slave.setMaster(this);
                    slave.setAlias(ref.getStringValue("alias"));
                    this.slaves.add(slave);
                }
            }
        }
        return Collections.unmodifiableList(this.slaves);
    }

    @Override
    public CoreNatureSlaveData getSlave(String alias) {
        List<CoreNatureSlaveData> svs = this.getSlaves();
        for (CoreNatureSlaveData sv : svs) {
            if (!sv.getAlias().equals(alias)) continue;
            return sv;
        }
        return null;
    }

    private String getUniqueSuffix(String suffix) {
        boolean executable = this instanceof CoreData;
        List<CoreNatureData> cs = this.getProcessor().getCoreNatures(executable);
        int i = 0;
        while (i < cs.size()) {
            CoreNatureData c = cs.get(i);
            if (this.equals(c)) break;
            if (c.getSuffix().equals(suffix)) {
                suffix = String.valueOf(suffix) + "_gen" + (i + 1);
            }
            ++i;
        }
        return suffix;
    }
}

