/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.intro.actions;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class OpenAbstractWizardAction
extends Action
implements IIntroAction {
    public static final String ERROR_MSG_WIZARD = "Unable to find wizard descriptor by id {0}";
    private static final String WIZARD_ID = "wizardId";
    Properties params = null;

    public void initialize(IIntroSite site, Properties params) {
        this.params = params;
    }

    protected abstract IWizardDescriptor getWizardDescriptor(String var1);

    public void run(IIntroSite site, Properties params) {
        String wizardID = params.getProperty(WIZARD_ID);
        if (wizardID == null || wizardID.isEmpty()) {
            String msg = NLS.bind((String)"The property {0} is not found", (Object)wizardID);
            Status status = new Status(4, "com.nxp.s32ds.ext.rcp.intro", msg);
            Log.log((IStatus)status);
            return;
        }
        IWizardDescriptor wizardDesc = this.getWizardDescriptor(wizardID);
        if (wizardDesc == null) {
            String msg = NLS.bind((String)ERROR_MSG_WIZARD, (Object)wizardID);
            Status status = new Status(4, "com.nxp.s32ds.ext.rcp.intro", msg);
            Log.log((IStatus)status);
            return;
        }
        try {
            this.openWizard(wizardDesc);
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus());
        }
    }

    private void openWizard(IWizardDescriptor wizardDesc) throws CoreException {
        Shell shell = Display.getDefault().getActiveShell();
        IWorkbenchWizard wizard = wizardDesc.createWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
            PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
        }
    }
}

