/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.ErrorPatternUtil;
import com.freescale.s32ds.cdt.core.FSLErrorParserManager;
import com.freescale.s32ds.cdt.core.IFSLErrorParser3;
import com.freescale.s32ds.cdt.core.IFSLErrorParser4;
import com.freescale.s32ds.cdt.core.errorParsers.CommonErrorParser;
import com.freescale.s32ds.cdt.core.errorParsers.Messages;
import com.freescale.s32ds.cdt.core.errorParsers.MwErrorPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.errorparsers.ErrorPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class GCCErrorParser
extends CommonErrorParser
implements IFSLErrorParser3,
IFSLErrorParser4 {
    private List<ProblemMarkerInfo> fErrors = new ArrayList<ProblemMarkerInfo>();
    private String regularExpression;
    private static final Pattern[] varPatterns = new Pattern[]{Pattern.compile(Messages.getString("GCCErrorParser_varPattern_undeclared", null)), Pattern.compile(Messages.getString("GCCErrorParser_varPattern_defdNotUsed", null)), Pattern.compile(Messages.getString("GCCErrorParser_varPattern_conflictTypes", null)), Pattern.compile(Messages.getString("GCCErrorParser_varPattern_parseError", null))};
    private static final MwErrorPattern gccVersionPattern = new MwErrorPattern(Messages.getString("GCCErrorParser_GCC_VERSION", null));
    private static final MwErrorPattern[] patterns = new MwErrorPattern[]{new MwErrorPattern(Messages.getString("GCCErrorParser_skip_UndeclaredOnlyOnce", null)), new MwErrorPattern(Messages.getString("GCCErrorParser_skip_forEachFunction", null)), new MwErrorPattern(Messages.getString("GCCErrorParser_skip_note", null)), new MwErrorPattern(Messages.getString("GCCErrorParser_sikp_instantiatedFromHere", null)), new MwErrorPattern(Messages.getString("GCCErrorParser_includeFileInfo", null)), new MwErrorPattern(Messages.getString("GCCErrorParser_syntaxErrorDoublePath", null), 2, 9, 10, 0, 0, 0){

        public int getSeverity(Matcher matcher) {
            return 2;
        }

        public String getFileName(Matcher matcher) {
            String filename;
            if (matcher.group(6) == null && (filename = matcher.group(3)) != null) {
                return filename;
            }
            if (matcher.group(3) == null && (filename = matcher.group(7)) != null) {
                return filename;
            }
            return null;
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_Warnings", null), 1, 2, 7, 0, 0, 5){

        public String getVarName(Matcher matcher) {
            String desc = this.getDesc(matcher);
            Matcher varMatcher = null;
            int i = 0;
            while (i < varPatterns.length) {
                varMatcher = varPatterns[i].matcher(desc);
                if (varMatcher.find()) break;
                varMatcher = null;
                ++i;
            }
            return varMatcher != null ? varMatcher.group(1) : null;
        }

        public int getSeverity(Matcher matcher) {
            String warningGroup = matcher.group(4);
            if (warningGroup != null && warningGroup.indexOf("arning") >= 0) {
                return 1;
            }
            if (warningGroup != null && warningGroup.indexOf("nformation") >= 0) {
                return 0;
            }
            return 2;
        }

        public String getDesc(Matcher matcher) {
            if (matcher.group(5) != null) {
                String separator = " ";
                if (matcher.group(7) != null) {
                    separator = matcher.group(7);
                }
                if (separator.length() == 0) {
                    separator = " ";
                }
                return String.valueOf(matcher.group(5)) + separator + matcher.group(8);
            }
            return matcher.group(8);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_Errors", null), 0, 3){

        public String getDesc(Matcher matcher) {
            return matcher.group(0);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_noInputFiles", null)){

        public int getSeverity(Matcher matcher) {
            return 3;
        }

        public String getDesc(Matcher matcher) {
            return matcher.group(0);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_noSuchFileOrDir", null)){

        public int getSeverity(Matcher matcher) {
            return 3;
        }

        public String getDesc(Matcher matcher) {
            return matcher.group(2);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_fileNotReconized", null)){

        public int getSeverity(Matcher matcher) {
            return 3;
        }

        public String getDesc(Matcher matcher) {
            return String.valueOf(matcher.group(1)) + matcher.group(3);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_unrecognizedCommandLineOption", null)){

        public int getSeverity(Matcher matcher) {
            String severity = matcher.group(2);
            if ("error".equals(severity)) {
                return 3;
            }
            return 1;
        }

        public String getDesc(Matcher matcher) {
            return String.valueOf(matcher.group(3)) + matcher.group(4);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_unrecognizedOption", null)){

        public int getSeverity(Matcher matcher) {
            return 3;
        }

        public String getDesc(Matcher matcher) {
            return String.valueOf(matcher.group(2)) + matcher.group(3);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_argumentMissing", null)){

        public int getSeverity(Matcher matcher) {
            return 3;
        }

        public String getDesc(Matcher matcher) {
            return matcher.group(0);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_argumentShouldBe", null)){

        public int getSeverity(Matcher matcher) {
            String severity = matcher.group(2);
            if ("error".equals(severity)) {
                return 3;
            }
            return 1;
        }

        public String getDesc(Matcher matcher) {
            return String.valueOf(matcher.group(1)) + matcher.group(3) + matcher.group(4) + matcher.group(5) + matcher.group(6);
        }
    }, new MwErrorPattern(Messages.getString("GCCErrorParser_makeProcessErrors", null)){

        public int getSeverity(Matcher matcher) {
            return 3;
        }

        public String getDesc(Matcher matcher) {
            return matcher.group(2);
        }
    }};

    public boolean processLine(String line, ErrorParserManager eoParser) {
        boolean matched = false;
        int i = 0;
        while (i < patterns.length) {
            Matcher matcher = patterns[i].getMatcher(line);
            if (matcher.find() && !gccVersionPattern.getMatcher(line).find()) {
                matched = this.recordError(line, patterns[i], matcher, eoParser);
                break;
            }
            ++i;
        }
        return matched;
    }

    protected boolean recordError(String line, MwErrorPattern pattern, Matcher matcher, ErrorParserManager parser) {
        int severity = pattern.getSeverity(matcher);
        if (severity == -1) {
            return true;
        }
        String desc = pattern.getDesc(matcher);
        String complexDesc = null;
        String filename = pattern.getFileName(matcher);
        IPath externalPath = null;
        IFile file = null;
        if (filename != null && (file = parser.findFileName(filename)) == null) {
            complexDesc = String.valueOf(filename) + " " + desc;
            file = parser.getProject();
            externalPath = pattern.getLocation(filename);
        }
        int lineNum = pattern.getLineNum(matcher);
        String varName = pattern.getVarName(matcher);
        String errorCode = pattern.getErrorCode(matcher);
        if (!this.mergeLastEntry((IResource)file, severity, lineNum, desc, errorCode)) {
            this.flush(parser);
            ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo((IResource)file, lineNum, complexDesc != null ? complexDesc : desc, severity, varName, externalPath);
            this.fErrors.add(problemMarkerInfo);
            if (parser instanceof FSLErrorParserManager) {
                ((FSLErrorParserManager)parser).addErrorMsgLine(line);
            } else {
                parser.addProblemMarker(problemMarkerInfo);
            }
        }
        return true;
    }

    public boolean mergeLastEntry(IResource file, int severity, int lineNumber, String desc, String errorCode) {
        if (this.fErrors.size() > 0 && file != null) {
            ProblemMarkerInfo mInfo = this.fErrors.get(this.fErrors.size() - 1);
            if (mInfo.file.equals((Object)file) && mInfo.lineNumber == lineNumber && errorCode == null) {
                if (severity > mInfo.severity) {
                    mInfo.severity = severity;
                    mInfo.description = String.valueOf(desc) + " (" + mInfo.description + ")";
                } else {
                    mInfo.description = mInfo.description.concat(" " + desc);
                }
                return true;
            }
        }
        return false;
    }

    public void flush(ErrorParserManager eoParser) {
        int i = 0;
        while (i < this.fErrors.size()) {
            ProblemMarkerInfo info = this.fErrors.get(i);
            eoParser.generateExternalMarker(info.file, info.lineNumber, info.description, info.severity, info.variableName, info.externalPath);
            ++i;
        }
        this.fErrors.clear();
    }

    public String getRegularExpresion() {
        if (patterns.length == 0) {
            return null;
        }
        if (this.regularExpression == null) {
            this.regularExpression = ErrorPatternUtil.createRegularExpression((ErrorPattern[])patterns);
        }
        return this.regularExpression;
    }

    public void shutdown() {
    }
}

