/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class OpsConfig
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        if (args == null || args.length < 3) {
            S32DSWizardPlugin.logWarning("Data for OpsConfig should contain more input parameters !");
            return;
        }
        IProject proj = wsp.getRoot().getProject(args[0].getSimpleValue());
        if (proj == null || !proj.exists()) {
            S32DSWizardPlugin.logWarning("Cannot open project " + args[0].getSimpleValue());
            return;
        }
        String name = args[1].getSimpleValue();
        IConfiguration cfg = null;
        IConfiguration[] iConfigurationArray = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject().getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equalsIgnoreCase(name)) {
                cfg = c;
                break;
            }
            ++n2;
        }
        if (cfg == null) {
            S32DSWizardPlugin.logWarning("Cannot find configuration " + name + " for project " + proj.getName());
            return;
        }
        IWorkspaceDescription wspd = wsp.getDescription();
        boolean autoBuilding = wspd.isAutoBuilding();
        wspd.setAutoBuilding(false);
        try {
            wsp.setDescription(wspd);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
        boolean dirty = false;
        if (args[2].getParameterType() == 1) {
            String id = args[2].getSimpleValue();
            String val = args[3].getSimpleValue();
            dirty |= this.setOptionForConfig(id, val, null, cfg);
        } else if (args[2].getParameterType() == 4) {
            ProcessArgument[][] processArgumentArray = args[2].getComplexArrayValue();
            int n3 = processArgumentArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ProcessArgument[] pa = processArgumentArray[n4];
                String id = pa[0].getSimpleValue();
                if (pa[1].getParameterType() == 1) {
                    dirty |= this.setOptionForConfig(id, pa[1].getSimpleValue(), null, cfg);
                } else if (pa[1].getParameterType() == 2) {
                    dirty |= this.setOptionForConfig(id, null, pa[1].getSimpleArrayValue(), cfg);
                } else {
                    S32DSWizardPlugin.logWarning("Bad type of parameter " + pa[1].getName() + " : " + pa[1].getParameterType());
                }
                ++n4;
            }
        } else {
            S32DSWizardPlugin.logWarning("Bad type of parameter " + args[2].getName() + " : " + args[2].getParameterType());
        }
        if (dirty) {
            ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
        }
        wspd.setAutoBuilding(autoBuilding);
        try {
            wsp.setDescription(wspd);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private boolean setOptionForConfig(String id, String value, String[] values, IConfiguration config) {
        boolean modified = false;
        id = id.toLowerCase();
        IToolChain toolChain = config.getToolChain();
        ITool[] tools = config.getTools();
        modified |= this.setOption(id, value, values, config, toolChain.getOptions(), (IHoldsOptions)toolChain);
        ITool[] iToolArray = tools;
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            modified |= this.setOption(id, value, values, config, tool.getOptions(), (IHoldsOptions)tool);
            ++n2;
        }
        return modified;
    }

    private boolean setOption(String id, String value, String[] values, IConfiguration config, IOption[] options, IHoldsOptions optionHolder) {
        boolean modified = false;
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (option.getBaseId().toLowerCase().matches(id) || option.getId().toLowerCase().matches(id)) {
                try {
                    if (values == null) {
                        if (option.getValueType() == 0) {
                            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option, (boolean)Boolean.valueOf(value));
                        } else {
                            ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option, (String)value);
                        }
                    } else {
                        ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option, (String[])values);
                    }
                    modified = true;
                }
                catch (BuildException e) {
                    S32DSWizardPlugin.log(e);
                }
            }
            ++n2;
        }
        return modified;
    }
}

