/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.UnnativeTouchpoint;
import com.nxp.s32ds.ext.rcp.p2.core.utils.MergeFPDevices;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class MergeAction
extends ProvisioningAction {
    public IStatus execute(Map<String, Object> parameters) {
        IStatus retCode = Status.CANCEL_STATUS;
        WeakHashMap<String, Object> localParameters = new WeakHashMap<String, Object>();
        localParameters.putAll(parameters);
        LazyBackupStore store = (LazyBackupStore)UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        if (store != null) {
            localParameters.put("backup", store);
        }
        if (localParameters.get("mergeBase") != null && localParameters.get("mergeExtra") != null) {
            retCode = MergeAction.mergeFiles(parameters);
        }
        return retCode;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    private static IStatus mergeFiles(Map<String, Object> parameters) {
        File baseMerge = new File((String)parameters.get("mergeBase"));
        File extraMerge = new File((String)parameters.get("mergeExtra"));
        IBackupStore store = (IBackupStore)parameters.get("backup");
        if (store != null) {
            try {
                store.backupCopy(baseMerge);
            }
            catch (IOException e) {
                Util.logError(e.getMessage());
            }
        }
        if (baseMerge.exists() && extraMerge.exists()) {
            if (Util.getExtension(baseMerge).equals("xml") && Util.getExtension(extraMerge).equals("xml")) {
                if (parameters.get("mergeExtraArgument") != null && ((String)parameters.get("mergeExtraArgument")).equalsIgnoreCase("FPDevices")) {
                    MergeFPDevices.mergeXMLFiles(baseMerge, extraMerge);
                    Util.log(1, String.format("FPDevices_MERGE: %s .%n", String.valueOf(extraMerge.getAbsolutePath()) + " -> " + baseMerge.getAbsolutePath()));
                } else {
                    Util.mergeXMLFiles(baseMerge, extraMerge);
                    Util.log(1, String.format("Classic_MERGE: %s .%n", String.valueOf(extraMerge.getAbsolutePath()) + " -> " + baseMerge.getAbsolutePath()));
                }
            } else {
                try {
                    Util.appendStream(new FileInputStream(extraMerge), true, new FileOutputStream(baseMerge, true), true);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.merge_failed, (Object)baseMerge.getPath()), (Throwable)e);
                }
            }
        } else {
            if (!baseMerge.exists()) {
                Util.logError(String.format("baseMerge: %s file not found!%n", extraMerge.getAbsolutePath()));
            }
            if (!extraMerge.exists()) {
                Util.logError(String.format("extraMerge: %s file not found!%n", baseMerge.getAbsolutePath()));
            }
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

