/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.gnu.arm.s32k116;

import com.freescale.s32ds.cross.core.model.IParameterHandler;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.data.DataSet;
import com.freescale.s32ds.cross.core.model.registry.ModelRegistry;
import com.freescale.s32ds.cross.gnu.arm.wizard.SDKContextUtil;
import java.util.Arrays;

public class PExSDKhandler
implements IParameterHandler {
    private static final String CORE_ID2 = "S32K116_M0plus_1";
    private static final String CORE_ID1 = "S32K116_M0plus";
    private static final String TEXT_WARNING = "C++ Project is not compatible with PEx SDK";
    private static final String C = "c";
    private static final String C_CPP = "c_cpp";
    private static final String CPP = "c++";

    public boolean isEnabled(String tag, AbstractContext context) {
        return false;
    }

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        return this.onEdit(tag, newValue, context);
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        if (newValue == null) {
            return null;
        }
        if (!(context instanceof CProjectMasterContext)) {
            return null;
        }
        CProjectMasterContext projectContext = (CProjectMasterContext)context;
        String coreNatureId = projectContext.getCoreNatureId();
        if (coreNatureId == null) {
            return null;
        }
        if (!coreNatureId.equals(CORE_ID1) && !coreNatureId.equals(CORE_ID2)) {
            return null;
        }
        String warningMessage = "";
        ModelRegistry registry = context.getRegistry();
        ContextChange contextChange = new ContextChange(context, tag);
        String currentLang = projectContext.getStringValue("language");
        if (SDKContextUtil.isPex((CProjectContext)projectContext)) {
            if (tag.equals("language") && CPP.equals(newValue) || tag.equals("sdks") && CPP.equals(currentLang)) {
                warningMessage = TEXT_WARNING;
            }
            DataSet dataSet = registry.getDataSet("languageSet", C);
            contextChange.addDataSet(dataSet);
        } else {
            DataSet languageDataSet = projectContext.getDataSet("language");
            if (languageDataSet != null && !languageDataSet.getValues().contains(CPP)) {
                DataSet dataSet = registry.getDataSet("languageSet", C_CPP);
                contextChange.addDataSet(dataSet);
            }
        }
        ChangeResult result = new ChangeResult(Arrays.asList(contextChange));
        if (!warningMessage.isEmpty()) {
            result.setWarningMessage(warningMessage);
        }
        return result;
    }

    public Object parseValue(String tag, String value, AbstractContext context) {
        return null;
    }
}

