/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExternalToolRunnerHelper
implements Closeable {
    private IProject project;
    private IConsole console;
    private OutputStream stdout = null;
    private OutputStream stderr = null;
    private boolean isStreamsOpen = false;
    private boolean isCancelled = false;
    private OutputStream consoleInfo = null;
    private long startTime = 0L;
    private long endTime = 0L;
    private ICommandLauncher launcher;
    private IPath buildCommand;
    private String[] args;
    private IPath pathToWorkingDirectory;
    private String[] environment;

    public ExternalToolRunnerHelper(IProject project) {
        this.project = project;
        this.console = CCorePlugin.getDefault().getConsole();
        this.console.start(project);
    }

    public void setLaunchParameters(ICommandLauncher launcher, IPath buildCommand, String[] args, IPath pathToWorkingDirectory, String[] environment) {
        this.launcher = launcher;
        launcher.setProject(this.project);
        launcher.showCommand(true);
        this.buildCommand = buildCommand;
        this.args = args;
        this.pathToWorkingDirectory = pathToWorkingDirectory;
        this.environment = environment;
    }

    public void prepareStreams(OutputStream outputStream) throws CoreException {
        this.isStreamsOpen = true;
        this.stdout = outputStream;
        this.stderr = this.console.getErrorStream();
    }

    public int execute(IProgressMonitor monitor) throws CoreException, IOException {
        int status = -1;
        String errMsg = null;
        Process process = this.launcher.execute(this.buildCommand, this.args, this.environment, this.pathToWorkingDirectory, monitor);
        if (process != null) {
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {}
        } else {
            errMsg = this.launcher.getErrorMessage();
        }
        if ((status = this.launcher.waitAndRead(this.stdout, (OutputStream)this.console.getOutputStream(), monitor)) != 0) {
            errMsg = this.launcher.getErrorMessage();
        }
        if (errMsg != null && !errMsg.isEmpty()) {
            this.stderr.write(errMsg.getBytes());
        }
        return status;
    }

    public void greeting(String msg) {
        this.startTime = System.currentTimeMillis();
        if (this.consoleInfo == null) {
            try {
                this.consoleInfo = this.console.getInfoStream();
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        this.toConsole(String.valueOf(ExternalToolRunnerHelper.timeStamp(this.startTime)) + "**** " + msg + " ****");
    }

    @Override
    public void close() throws IOException {
        block23: {
            if (!this.isStreamsOpen) {
                return;
            }
            try {
                try {
                    if (this.stdout != null) {
                        this.stdout.close();
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log((Throwable)e);
                    this.stdout = null;
                    try {
                        try {
                            if (this.stderr != null) {
                                this.stderr.close();
                            }
                        }
                        catch (Exception e2) {
                            CCorePlugin.log((Throwable)e2);
                            this.stderr = null;
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        this.stderr = null;
                        throw throwable;
                    }
                    this.stderr = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                block25: {
                    this.stdout = null;
                    try {
                        try {
                            if (this.stderr != null) {
                                this.stderr.close();
                            }
                        }
                        catch (Exception e) {
                            CCorePlugin.log((Throwable)e);
                            this.stderr = null;
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        this.stderr = null;
                        throw throwable2;
                    }
                    this.stderr = null;
                }
                throw throwable;
            }
            this.stdout = null;
            try {
                try {
                    if (this.stderr != null) {
                        this.stderr.close();
                    }
                }
                catch (Exception e) {
                    CCorePlugin.log((Throwable)e);
                    this.stderr = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                this.stderr = null;
                throw throwable;
            }
            this.stderr = null;
        }
        this.isStreamsOpen = false;
    }

    public void goodbye(String msg) {
        Assert.isTrue((this.startTime != 0L ? 1 : 0) != 0, (String)"Start time must be set before calling this method.");
        Assert.isTrue((this.consoleInfo != null ? 1 : 0) != 0, (String)"consoleInfo must be open with greetings(...) call before using this method.");
        this.endTime = System.currentTimeMillis();
        String duration = ExternalToolRunnerHelper.durationToString(this.endTime - this.startTime);
        String newMsg = this.isCancelled ? new String(String.valueOf(msg) + " Cancelled (took " + duration.toString() + ")") : new String(String.valueOf(msg) + " Finished (took " + duration.toString() + ")");
        String goodbye = String.valueOf('\n') + ExternalToolRunnerHelper.timeStamp(this.endTime) + newMsg + '\n';
        try {
            this.toConsole(goodbye);
        }
        finally {
            block13: {
                try {
                    try {
                        this.consoleInfo.close();
                    }
                    catch (Exception e) {
                        CCorePlugin.log((Throwable)e);
                        this.consoleInfo = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.consoleInfo = null;
                    throw throwable;
                }
                this.consoleInfo = null;
            }
        }
    }

    private void toConsole(String msg) {
        Assert.isNotNull((Object)this.console, (String)"Streams must be created and connected before calling this method");
        try {
            this.consoleInfo.write((String.valueOf(msg) + "\n").getBytes());
        }
        catch (Exception e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    private static String timeStamp(long time) {
        return String.valueOf(new SimpleDateFormat("HH:mm:ss").format(new Date(time))) + " ";
    }

    private static String durationToString(long duration) {
        long seconds;
        long minutes;
        long hours;
        String result = "";
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        if (days > 0L) {
            result = String.valueOf(result) + days + "d,";
        }
        if ((hours = TimeUnit.MILLISECONDS.toHours(duration) % 24L) > 0L) {
            result = String.valueOf(result) + hours + "h:";
        }
        if ((minutes = TimeUnit.MILLISECONDS.toMinutes(duration) % 60L) > 0L) {
            result = String.valueOf(result) + minutes + "m:";
        }
        if ((seconds = TimeUnit.MILLISECONDS.toSeconds(duration) % 60L) > 0L) {
            result = String.valueOf(result) + seconds + "s.";
        }
        long milliseconds = TimeUnit.MILLISECONDS.toMillis(duration) % 1000L;
        result = String.valueOf(result) + milliseconds + "ms";
        return result;
    }

    public void refreshProject(String configName) {
        try {
            RefreshScopeManager refreshManager = RefreshScopeManager.getInstance();
            IWorkspaceRunnable runnable = refreshManager.getRefreshRunnable(this.project, configName);
            ResourcesPlugin.getWorkspace().run(runnable, null, 1, null);
        }
        catch (CoreException coreException) {}
    }
}

