/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.view;

import com.freescale.s32ds.cdt.core.commanderview.ICommandHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommandExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CommandManager {
    private static final Command[] EMPTY_CMD_ARRAY = new Command[0];
    private static final String VISIBLE_CMDS_PREF = "visibleCmds";
    private static CommandManager instance;
    private Set<String> fVisibleCmdIds = new HashSet<String>();
    private Group[] fGroups;

    public static CommandManager getInstance() {
        if (instance == null) {
            instance = new CommandManager();
        }
        return instance;
    }

    private CommandManager() {
        CommandExtension.GroupElement[] contrGroups;
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName());
        String visibleCmdsPref = prefStore.getString(VISIBLE_CMDS_PREF);
        HashMap<String, Boolean> visibleCmds = new HashMap<String, Boolean>();
        if (!visibleCmdsPref.isEmpty()) {
            String[] stringArray = visibleCmdsPref.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String cmdpref = stringArray[n2];
                if (!cmdpref.isEmpty()) {
                    String[] segs = cmdpref.split("=");
                    visibleCmds.put(segs[0], segs[1].equals(Boolean.TRUE.toString()));
                }
                ++n2;
            }
        }
        LinkedList<Group> groups = new LinkedList<Group>();
        CommandExtension.GroupElement[] groupElementArray = contrGroups = CommandExtension.getContibutedGroups();
        int n = contrGroups.length;
        int n3 = 0;
        while (n3 < n) {
            CommandExtension.GroupElement groupContr = groupElementArray[n3];
            if (groupContr.after != null) {
                int i = 0;
                while (i < groups.size()) {
                    Group g = (Group)groups.get(i);
                    if (g.id.equals(groupContr.after)) {
                        if (++i < groups.size()) {
                            groups.add(i, groupContr.group);
                        }
                        break;
                    }
                    ++i;
                }
            } else {
                groups.add(groupContr.group);
            }
            ++n3;
        }
        this.fGroups = groups.toArray(new Group[groups.size()]);
        CommandExtension.CommandElement[] commandsContrib = CommandExtension.getContibutedCommands(true);
        Object[] objectArray = contrGroups;
        int n4 = contrGroups.length;
        n = 0;
        while (n < n4) {
            CommandExtension.GroupElement contr = objectArray[n];
            Group group = contr.group;
            group.children = this.getContributedCommands(commandsContrib, group.id);
            ++n;
        }
        objectArray = this.fGroups;
        n4 = this.fGroups.length;
        n = 0;
        while (n < n4) {
            Object group = objectArray[n];
            Command[] commandArray = ((Group)group).children;
            int n5 = ((Group)group).children.length;
            int n6 = 0;
            while (n6 < n5) {
                Command cmd = commandArray[n6];
                Boolean visible = (Boolean)visibleCmds.get(cmd.id);
                if (visible == null) {
                    visible = cmd.visibleByDefault;
                }
                this.setVisible(cmd, visible);
                Command[] commandArray2 = cmd.children;
                int n7 = cmd.children.length;
                int n8 = 0;
                while (n8 < n7) {
                    Command subCmd = commandArray2[n8];
                    visible = (Boolean)visibleCmds.get(subCmd.id);
                    if (visible == null) {
                        visible = subCmd.visibleByDefault;
                    }
                    this.setVisible(subCmd, visible);
                    ++n8;
                }
                ++n6;
            }
            ++n;
        }
    }

    private Command[] getContributedCommands(CommandExtension.CommandElement[] commandsContrib, String groupId) {
        ArrayList<Command> cmds = new ArrayList<Command>(10);
        HashMap<String, Command> cmdMap = new HashMap<String, Command>();
        CommandExtension.CommandElement[] commandElementArray = commandsContrib;
        int n = commandsContrib.length;
        int n2 = 0;
        while (n2 < n) {
            CommandExtension.CommandElement element = commandElementArray[n2];
            if (element.parent == null && element.group.equals(groupId)) {
                if (element.after != null) {
                    boolean found = false;
                    int index = 0;
                    for (Command cmd : cmds) {
                        if (cmd.id.equals(element.after)) {
                            found = true;
                            break;
                        }
                        ++index;
                    }
                    if (found) {
                        cmds.add(++index, element.command);
                    } else {
                        cmds.add(element.command);
                    }
                } else {
                    cmds.add(element.command);
                }
                cmdMap.put(element.command.id, element.command);
            }
            ++n2;
        }
        HashMap<String, ArrayList<Command>> childrenMap = new HashMap<String, ArrayList<Command>>();
        CommandExtension.CommandElement[] found = commandsContrib;
        int n3 = commandsContrib.length;
        n = 0;
        while (n < n3) {
            Command cmdParent;
            CommandExtension.CommandElement element = found[n];
            if (element.parent != null && (cmdParent = (Command)cmdMap.get(element.parent)) != null) {
                ArrayList<Command> children = (ArrayList<Command>)childrenMap.get(element.parent);
                if (children == null) {
                    children = new ArrayList<Command>(3);
                    childrenMap.put(element.parent, children);
                }
                if (element.after != null) {
                    boolean found2 = false;
                    int index = 0;
                    for (Command child : children) {
                        if (child.id.equals(element.after)) {
                            found2 = true;
                            break;
                        }
                        ++index;
                    }
                    if (found2) {
                        children.add(++index, element.command);
                    } else {
                        children.add(element.command);
                    }
                } else {
                    children.add(element.command);
                }
            }
            ++n;
        }
        for (Map.Entry entry : childrenMap.entrySet()) {
            Command cmd = (Command)cmdMap.get(entry.getKey());
            Command[] commandArray = cmd.children = ((List)entry.getValue()).toArray(new Command[((List)entry.getValue()).size()]);
            int n4 = cmd.children.length;
            int n5 = 0;
            while (n5 < n4) {
                Command child = commandArray[n5];
                child.parent = cmd;
                ++n5;
            }
        }
        return cmds.toArray(new Command[cmds.size()]);
    }

    public Group[] getGroups() {
        return this.fGroups;
    }

    void store() {
        StringBuilder pref = new StringBuilder();
        Group[] groupArray = this.fGroups;
        int n = this.fGroups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            this.addVisibleCmdsToPref(group.children, pref);
            ++n2;
        }
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName());
        prefStore.setValue(VISIBLE_CMDS_PREF, pref.toString());
    }

    private void addVisibleCmdsToPref(Command[] cmds, StringBuilder pref) {
        Command[] commandArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            Command cmd = commandArray[n2];
            pref.append(String.valueOf(cmd.id) + "=" + (this.isVisible(cmd) ? Boolean.TRUE.toString() : Boolean.FALSE.toString()) + ',');
            this.addVisibleCmdsToPref(cmd.children, pref);
            ++n2;
        }
    }

    public Command getCommandWithKeyBinding(char c) {
        if (c == '\u0000') {
            return null;
        }
        c = Character.toUpperCase(c);
        Group[] groupArray = this.fGroups;
        int n = this.fGroups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            Command[] commandArray = group.children;
            int n3 = group.children.length;
            int n4 = 0;
            while (n4 < n3) {
                Command cmd = commandArray[n4];
                if (cmd.keyBinding == c) {
                    return cmd;
                }
                Command[] commandArray2 = cmd.children;
                int n5 = cmd.children.length;
                int n6 = 0;
                while (n6 < n5) {
                    Command subCmd = commandArray2[n6];
                    if (subCmd.keyBinding == c) {
                        return subCmd;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public Command getCommandWithKeyBindingCmdId(String shortcutCmdId) {
        Group[] groupArray = this.fGroups;
        int n = this.fGroups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            Command[] commandArray = group.children;
            int n3 = group.children.length;
            int n4 = 0;
            while (n4 < n3) {
                Command cmd = commandArray[n4];
                if (shortcutCmdId.equals(cmd.keyBindingCmdId)) {
                    return cmd;
                }
                Command[] commandArray2 = cmd.children;
                int n5 = cmd.children.length;
                int n6 = 0;
                while (n6 < n5) {
                    Command subCmd = commandArray2[n6];
                    if (shortcutCmdId.equals(subCmd.keyBindingCmdId)) {
                        return subCmd;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    boolean isVisible(Command cmd) {
        return this.fVisibleCmdIds.contains(cmd.id);
    }

    void setVisible(Command cmd, boolean visible) {
        if (visible) {
            this.fVisibleCmdIds.add(cmd.id);
        } else {
            this.fVisibleCmdIds.remove(cmd.id);
        }
    }

    boolean hasVisibleCommands(Group group) {
        Command[] commandArray = group.children;
        int n = group.children.length;
        int n2 = 0;
        while (n2 < n) {
            Command cmd = commandArray[n2];
            if (this.isVisible(cmd)) {
                return true;
            }
            Command[] commandArray2 = cmd.children;
            int n3 = cmd.children.length;
            int n4 = 0;
            while (n4 < n3) {
                Command subCmd = commandArray2[n4];
                if (this.isVisible(subCmd)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    static /* synthetic */ Command[] access$0() {
        return EMPTY_CMD_ARRAY;
    }

    static class Base {
        public String label;
        public String id;
        public Command[] children = CommandManager.access$0();
        public Command parent;

        Base(String id, String label) {
            this.label = label;
            this.id = id;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Command
    extends Base {
        String tooltip;
        public ICommandHandler handler;
        private String imagePath;
        boolean visibleByDefault;
        public String pluginId;
        char keyBinding;
        String keyBindingCmdId;
        public String description;

        Command(String pluginId, String id, String label, ICommandHandler handler, String imagePath, String tooltip, String description, boolean visibleByDefault, Character keyBinding, String keyBindingCmdId) {
            super(id, label);
            this.visibleByDefault = visibleByDefault;
            this.handler = handler;
            this.pluginId = pluginId;
            this.imagePath = imagePath;
            this.tooltip = tooltip;
            if (keyBinding != null) {
                this.keyBinding = Character.toUpperCase(keyBinding.charValue());
                this.keyBindingCmdId = keyBindingCmdId;
            }
            this.description = description;
        }

        @Override
        public String toString() {
            return this.label;
        }

        public Image getIcon() {
            return this.imagePath != null ? Activator.getDefault().getImageFromPlugin(this.pluginId, this.imagePath) : null;
        }
    }

    public static class Group
    extends Base {
        Group(String id, String label) {
            super(id, label);
        }
    }
}

