/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class ForcedRemoveAction
extends ProvisioningAction {
    private static final String ACTION_REMOVE = "remove";

    public IStatus execute(Map<String, Object> parameters) {
        String path = (String)parameters.get("path");
        if (path == null) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", 0, NLS.bind((String)Messages.param_not_set, (Object)"path", (Object)ACTION_REMOVE), null);
        }
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath pathTemp = Util.getLocationIPath(location);
                IPath eclipsePath = Util.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(pathTemp)) {
                    pathTemp = pathTemp.removeLastSegments(1);
                    pathTemp = pathTemp.addTrailingSeparator();
                    String firstString = eclipsePath.toString();
                    String secondString = pathTemp.toString();
                    path = path.replace("\\", "/");
                    path = path.replace(firstString, secondString);
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", path));
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        File file = new File(path);
        try {
            Util.delete(file);
            return Status.OK_STATUS;
        }
        catch (IOException e) {
            Util.logError(e.getMessage(), e);
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }
}

