/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal.handler;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.ui.internal.RenameDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKImportPathResolveDialog;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class SDKImportUICallbackHandler {
    private Shell parent;
    private int importOrigin;

    public SDKImportUICallbackHandler(Shell parent) {
        this.parent = parent;
        this.importOrigin = -1;
    }

    public SDKHeader requestRename(SDKHeader sdkHeader, String errorMsg) {
        SDKHeader newSdkHeader = null;
        RenameDialog rd = new RenameDialog(this.parent, sdkHeader, errorMsg);
        if (rd.open() == 0) {
            newSdkHeader = new SDKHeader(rd.getSDKName(), rd.getSDKVersion(), sdkHeader);
        }
        return newSdkHeader;
    }

    public String requestSourceLocation(SDKHeader sdkHeader, File defaultLocation) {
        String selectedLocation = null;
        SDKImportPathResolveDialog prd = new SDKImportPathResolveDialog(this.parent, defaultLocation.toString(), sdkHeader);
        if (prd.open() == 0) {
            selectedLocation = prd.getSelectedLocation();
        } else {
            if (2 == this.importOrigin && prd.isDefaultLocation()) {
                selectedLocation = prd.getSelectedLocation();
                File folder = new File(prd.getSelectedLocation());
                if (!SDKUtils.deleteFolder(folder)) {
                    SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKImportUICallbackHandler_delete_SDK_folder_error, (Object)selectedLocation)));
                }
            }
            selectedLocation = null;
        }
        return selectedLocation;
    }

    public void setImportOrigin(int importOrigin) {
        this.importOrigin = importOrigin;
    }
}

