/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.BaseCommandLineGenerator2;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.CoreIDEMakefileGenerator;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLPathUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.FSLUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor4;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor5;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IToolConstants;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.LinkOrder;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.MakefileGeneratorUtil;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.ToolProxy;
import com.nxp.s32ds.ext.cdt.core.makefilegenerator.VariableRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ArgumentFileBuilder {
    private static final String EMPTY_STRING = new String();
    static final String LIBS_VARIABLE = "LIBS";
    static final String LIBS_QUOTED_VARIABLE = "LIBS_QUOTED";
    static final String USER_OBJS_VARIABLE = "USER_OBJS";
    static final String USER_OBJS_QUOTED_VARIABLE = "USER_OBJS_QUOTED";
    private int fEnabled = 0;
    private int fBuildCommandCounter = 0;
    List<BuildCommand> fBuildCommand = new LinkedList<BuildCommand>();
    List<BuildCommand> fOldCommand = new LinkedList<BuildCommand>();
    private HashMap<String, String> fBuildVarsAgregateValues = new HashMap();
    private HashMap<String, List<Object>> fBuildOutVars = new HashMap();
    List<String> nameList = new LinkedList<String>();
    private static final String MAKE_SINGLE_VAR_CHARS = "@%<?^+|*";

    public void enable() {
        ++this.fEnabled;
        this.fBuildCommandCounter = 1;
    }

    public void disable() {
        --this.fEnabled;
    }

    public boolean isEnabled() {
        return this.fEnabled > 0;
    }

    public void initialize(HashMap<String, String> buildVarsAgregateValues, HashMap<String, List<Object>> buildOutVars) {
        this.fBuildVarsAgregateValues = buildVarsAgregateValues;
        this.fBuildOutVars = buildOutVars;
    }

    BuildCommand getReducedBuildFlags(String[] argfileFlags, String[] cmdlineFlags, String additionalOption) {
        BuildCommand buildCommand = new BuildCommand();
        StringBuffer fileArgs = new StringBuffer();
        int i = 0;
        while (i < argfileFlags.length) {
            fileArgs.append(String.valueOf(argfileFlags[i]) + " ");
            ++i;
        }
        StringBuffer cmdArgs = new StringBuffer();
        cmdArgs.append(additionalOption);
        String[] stringArray = cmdlineFlags;
        int n = cmdlineFlags.length;
        int n2 = 0;
        while (n2 < n) {
            String cmdFlag = stringArray[n2];
            cmdArgs.append(" " + cmdFlag);
            ++n2;
        }
        buildCommand.buildCommand = cmdArgs.toString();
        buildCommand.fileArguments = fileArgs.toString();
        return buildCommand;
    }

    protected String[] getCompactedFlags(ITool tool, String relativePath, String targetName, String[] argfileFlags, String[] cmdlineFlags, IPath topBuildLocation) {
        return this.getCompactedFlags(tool, relativePath, targetName, argfileFlags, cmdlineFlags, topBuildLocation, true);
    }

    protected String[] getCompactedFlags(ITool tool, String relativePath, String targetName, String[] argfileFlags, String[] cmdlineFlags, IPath topBuildLocation, boolean overwriteExistingArgsFile) {
        String[] flags;
        if (this.isEnabled()) {
            String replacementFlag = MakefileGeneratorUtil.getReplacementFlag(tool);
            if (replacementFlag != null) {
                String fileName = this.getUniqueFileName(String.valueOf(relativePath) + targetName, topBuildLocation);
                if (!overwriteExistingArgsFile) {
                    boolean unique = false;
                    while (!unique) {
                        File f = topBuildLocation.append(fileName).toFile();
                        boolean bl = unique = !f.exists();
                        if (unique) continue;
                        this.addToNameList(fileName);
                        fileName = this.getUniqueFileName(String.valueOf(relativePath) + targetName, topBuildLocation);
                    }
                }
                String additionalOption = FSLPathUtil.quotePath(String.valueOf(replacementFlag) + fileName);
                BuildCommand buildCommand = this.getReducedBuildFlags(argfileFlags, cmdlineFlags, additionalOption);
                flags = new String[]{buildCommand.buildCommand};
                buildCommand.fileName = fileName;
                buildCommand.tool = tool;
                buildCommand.targetName = targetName;
                this.addToNameList(fileName);
                this.fBuildCommand.add(buildCommand);
            } else {
                flags = argfileFlags;
            }
        } else {
            flags = new String[argfileFlags.length + cmdlineFlags.length];
            int i = 0;
            while (i < argfileFlags.length) {
                flags[i] = argfileFlags[i];
                ++i;
            }
            i = 0;
            while (i < cmdlineFlags.length) {
                flags[i + argfileFlags.length] = cmdlineFlags[i];
                ++i;
            }
        }
        return flags;
    }

    void resetNameList() {
        this.nameList = new LinkedList<String>();
    }

    void addToNameList(String name) {
        this.nameList.add(name);
    }

    boolean isNameUnique(String name) {
        for (String item : this.nameList) {
            if (!item.equalsIgnoreCase(name)) continue;
            return false;
        }
        return true;
    }

    public String convertBuildCmd(ITool tool, String targetName, String buildCmd, IConfiguration config, String buildTargetExt, CoreIDEMakefileGenerator generator) {
        if (this.isEnabled() && this.fBuildCommand.size() > 0) {
            BuildCommand buildCommand = this.fBuildCommand.get(this.fBuildCommand.size() - 1);
            if (buildCommand.tool.equals(tool) && buildCommand.targetName != null && buildCommand.targetName.equals(targetName) && buildCmd.contains(buildCommand.buildCommand)) {
                boolean converted = false;
                IMakefileGeneratorContributor[] contributors = MakefileGeneratorUtil.getContributors(config.getManagedProject().getOwner().getProject(), tool);
                if (contributors != null && contributors.length > 0) {
                    IMakefileGeneratorContributor[] iMakefileGeneratorContributorArray = contributors;
                    int n = contributors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMakefileGeneratorContributor contributor = iMakefileGeneratorContributorArray[n2];
                        if (contributor != null) {
                            if (contributor instanceof IMakefileGeneratorContributor5) {
                                try {
                                    buildCmd = ((IMakefileGeneratorContributor5)contributor).convertBuildCmd(tool, buildCmd, buildCommand, this.fBuildOutVars, this.fBuildVarsAgregateValues, generator);
                                    converted = true;
                                }
                                catch (IMakefileGeneratorContributor.NotImplementedException notImplementedException) {}
                            } else if (contributor instanceof IMakefileGeneratorContributor4) {
                                try {
                                    buildCmd = ((IMakefileGeneratorContributor4)contributor).convertBuildCmd(tool, buildCmd, buildCommand, this.fBuildOutVars, this.fBuildVarsAgregateValues);
                                    converted = true;
                                }
                                catch (IMakefileGeneratorContributor.NotImplementedException notImplementedException) {}
                            }
                        }
                        ++n2;
                    }
                }
                if (!converted) {
                    int startOfIntermediateFlag;
                    String intermediateFlags;
                    int intermediateFlagsIndex;
                    String startGroupFlag = "-Xlinker --start-group";
                    String endGroupFlag = "--end-group";
                    int groupIndex = buildCmd.indexOf(startGroupFlag);
                    if (groupIndex != -1) {
                        int groupEnd = buildCmd.indexOf(endGroupFlag);
                        String subCmd = buildCmd.substring(groupIndex, groupEnd + endGroupFlag.length());
                        int tempIndex = subCmd.indexOf("$(");
                        StringBuilder tmpCmd = new StringBuilder();
                        while (tempIndex != -1) {
                            tmpCmd.append(subCmd.substring(0, tempIndex));
                            int endIndex = subCmd.indexOf(")");
                            String macro = subCmd.substring(tempIndex + "$(".length(), endIndex);
                            String value = this.getResolvedValues(config, macro, buildTargetExt);
                            if (value.equals(macro)) {
                                tmpCmd.append(subCmd.substring(tempIndex, endIndex + 1));
                            } else if (macro.startsWith("OBJS")) {
                                tmpCmd.insert(0, String.valueOf(value) + " ");
                            } else {
                                tmpCmd.append(value);
                            }
                            subCmd = subCmd.substring(endIndex + 1);
                            tempIndex = subCmd.indexOf("$(");
                        }
                        tmpCmd.append(subCmd);
                        buildCommand.fileArguments = String.valueOf(tmpCmd.toString()) + " " + buildCommand.fileArguments;
                        buildCmd = String.valueOf(buildCmd.substring(0, groupIndex)) + buildCmd.substring(groupEnd + endGroupFlag.length() + 1);
                    }
                    StringBuilder convertedCmd = new StringBuilder();
                    int index = this.getIndexOnArgumentBoundary(buildCmd, "$(", 0);
                    if (index != -1 && (intermediateFlagsIndex = buildCmd.indexOf(buildCommand.buildCommand, 0)) > 0 && intermediateFlagsIndex < index && (intermediateFlags = buildCmd.substring(startOfIntermediateFlag = intermediateFlagsIndex + buildCommand.buildCommand.length(), index).trim()).length() > 0) {
                        convertedCmd.append(buildCmd.substring(0, intermediateFlagsIndex));
                        convertedCmd.append(String.valueOf(intermediateFlags) + " ");
                        convertedCmd.append(String.valueOf(buildCommand.buildCommand) + " ");
                        buildCmd = buildCmd.substring(index);
                        index = this.getIndexOnArgumentBoundary(buildCmd, "$(", 0);
                    }
                    LinkOrder linkOrder = new LinkOrder(tool);
                    Set inputMacros = Stream.of(tool.getInputTypes()).map(IInputType::getBuildVariable).map(var -> var.concat("_QUOTED")).collect(Collectors.toSet());
                    boolean seenInputMacro = false;
                    while (index != -1) {
                        int end;
                        if (index > 0) {
                            convertedCmd.append(buildCmd.substring(0, index));
                            buildCmd = buildCmd.substring(index);
                            index = 0;
                        }
                        if ((end = buildCmd.indexOf(")", 2)) == -1) break;
                        String macro = buildCmd.substring(index + 2, end);
                        String value = null;
                        if (linkOrder.isEnabled() && inputMacros.contains(macro)) {
                            value = "";
                            if (!seenInputMacro) {
                                linkOrder.update(generator.getConfig());
                                try {
                                    value = BaseCommandLineGenerator2.getCustomLinkOrderInputs(tool, generator, false);
                                }
                                catch (BuildException e) {
                                    Activator.log((Exception)((Object)e));
                                }
                                seenInputMacro = true;
                            }
                        }
                        if (value == null) {
                            value = this.getResolvedValues(config, macro, buildTargetExt);
                        }
                        if (value.equals(macro)) {
                            convertedCmd.append(buildCmd.substring(0, end + 1));
                        } else {
                            buildCommand.fileArguments = macro.startsWith("OBJS") ? String.valueOf(value) + " " + buildCommand.fileArguments : String.valueOf(buildCommand.fileArguments) + " " + value;
                        }
                        buildCmd = buildCmd.substring(end + 1);
                        index = this.getIndexOnArgumentBoundary(buildCmd, "$(", index);
                    }
                    if (MakefileGeneratorUtil.supportsMacrosInArgumentFile(tool) && buildCommand.fileArguments != null && !buildCommand.fileArguments.isEmpty()) {
                        try {
                            String resolvedVar = CCorePlugin.getDefault().getCdtVariableManager().resolveValue("ProjDirPath", EMPTY_STRING, " ", ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)config));
                            buildCommand.fileArguments = VariableRegistry.getDefault().convertToRelativeMakefileFormat(buildCommand.fileArguments, "ProjDirPath", resolvedVar, generator.getExistingBuildVariableContainer());
                        }
                        catch (CdtVariableException e) {
                            e.printStackTrace();
                        }
                    }
                    if (buildCmd.length() > 0) {
                        convertedCmd.append(buildCmd);
                    }
                    return convertedCmd.toString();
                }
            }
        }
        return buildCmd;
    }

    private String getResolvedValues(IConfiguration config, String macro, String buildTargetExt) {
        StringBuilder builder = new StringBuilder();
        if (this.fBuildOutVars.containsKey(macro)) {
            String value = this.fBuildVarsAgregateValues.get(macro);
            if (value != null) {
                builder.append(value);
            }
        } else if (macro.equals(LIBS_VARIABLE) || macro.equals(LIBS_QUOTED_VARIABLE)) {
            String[] libs = config.getLibs(buildTargetExt);
            int i = 0;
            while (i < libs.length) {
                String string = libs[i];
                builder.append(String.valueOf(string) + " ");
                ++i;
            }
        } else if (macro.startsWith(USER_OBJS_VARIABLE)) {
            String[] userObjs = config.getUserObjects(buildTargetExt);
            int i = 0;
            while (i < userObjs.length) {
                String obj = new Path(userObjs[i]).toPortableString();
                builder.append(String.valueOf(FSLPathUtil.quotePath(obj)) + " ");
                ++i;
            }
        }
        if (builder.length() > 0) {
            return builder.toString().trim();
        }
        return macro;
    }

    private int getIndexOnArgumentBoundary(String buildCmd, String what, int i) {
        String[] arguments;
        String subString = buildCmd.substring(i);
        String[] stringArray = arguments = ToolProxy.mergeLinesWithQuotes(subString.split(" "));
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String argument = stringArray[n2];
            if (argument.startsWith(what)) {
                return buildCmd.indexOf(argument, i);
            }
            ++n2;
        }
        return -1;
    }

    public String[] convertFlags(String relativePath, IPath sourceLocation, ITool tool, IPath outputLocation, boolean needExplicitRuleForFile, String[] flags, String targetName, IPath topBuildLocation, VariableRegistry.StringContainer existingBuildVariables) {
        return this.convertFlags(relativePath, sourceLocation, tool, outputLocation, needExplicitRuleForFile, flags, targetName, topBuildLocation, true, existingBuildVariables);
    }

    public String[] convertFlags(String relativePath, IPath sourceLocation, ITool tool, IPath outputLocation, boolean needExplicitRuleForFile, String[] flags, String targetName, IPath topBuildLocation, boolean useVars, VariableRegistry.StringContainer existingBuildVariables) {
        return this.convertFlags(relativePath, sourceLocation, tool, outputLocation, needExplicitRuleForFile, flags, targetName, topBuildLocation, useVars, true, existingBuildVariables);
    }

    public String[] convertFlags(String relativePath, IPath sourceLocation, ITool tool, IPath outputLocation, boolean needExplicitRuleForFile, String[] flags, String targetName, IPath topBuildLocation, boolean useVars, boolean overwriteExistingArgsFile, VariableRegistry.StringContainer existingBuildVariables) {
        if (targetName == null) {
            return flags;
        }
        LinkedList<String> argfileFlagList = new LinkedList<String>();
        LinkedList<String> cmdlineFlagList = new LinkedList<String>();
        int i = 0;
        while (i < flags.length) {
            String[] subFlags;
            String flag = flags[i];
            String[] stringArray = subFlags = ToolProxy.mergeLinesWithQuotes(flag.split(" "));
            int n = subFlags.length;
            int n2 = 0;
            while (n2 < n) {
                String subflag = stringArray[n2];
                boolean commaSeparated = false;
                String[] tokens = new String[]{subflag};
                if (subflag.indexOf(",") > -1) {
                    commaSeparated = true;
                    tokens = subflag.split(",");
                }
                subflag = "";
                String[] stringArray2 = tokens;
                int n3 = tokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String token = stringArray2[n4];
                    try {
                        IBuildMacroProvider provider = ManagedBuildManager.getBuildMacroProvider();
                        String resolvedFlag = !needExplicitRuleForFile ? provider.resolveValueToMakefileFormat(token, EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)tool)) : provider.resolveValue(token, EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)tool));
                        resolvedFlag = resolvedFlag.trim();
                        if (resolvedFlag.length() > 0) {
                            token = resolvedFlag;
                        }
                        if (token.indexOf("/") != -1 || token.indexOf("\\") != -1) {
                            String[] strs = ToolProxy.mergeLinesWithQuotes(token.split(" "));
                            String unchangedFlag = token;
                            token = "";
                            int j = 0;
                            while (j < strs.length) {
                                String prefix = FSLPathUtil.getPrefixBeforeQuotes(strs[j]);
                                if (prefix != null) {
                                    strs[j] = strs[j].substring(prefix.length());
                                } else {
                                    int in = strs[j].indexOf("../");
                                    if (in != -1 && strs[j].indexOf("\"") == -1 && strs[j].startsWith("-")) {
                                        prefix = strs[j].substring(0, in);
                                        strs[j] = strs[j].substring(in);
                                    }
                                }
                                boolean isQuoted = FSLPathUtil.isQuoted(strs[j]);
                                Path p = new Path(FSLPathUtil.removeQuotes(strs[j]));
                                String newValue = p.toPortableString();
                                if (isQuoted) {
                                    newValue = FSLPathUtil.quotePath(newValue);
                                }
                                if (prefix != null) {
                                    newValue = String.valueOf(prefix) + newValue;
                                }
                                token = String.valueOf(token) + newValue;
                                if (j != strs.length - 1) {
                                    token = String.valueOf(token) + " ";
                                }
                                ++j;
                            }
                            String resolvedVar = provider.resolveValue("${ProjDirPath}", EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, outputLocation, null, (IBuildObject)tool));
                            if (MakefileGeneratorUtil.supportsMacrosInArgumentFile(tool)) {
                                String convertedFlag = VariableRegistry.getDefault().convertToRelativeMakefileFormat(token, "ProjDirPath", resolvedVar, existingBuildVariables);
                                if (token.equals(convertedFlag)) {
                                    token = unchangedFlag;
                                } else if (useVars) {
                                    token = convertedFlag;
                                }
                            }
                        }
                    }
                    catch (BuildMacroException e) {
                        e.printStackTrace();
                    }
                    subflag = String.valueOf(subflag) + token;
                    if (commaSeparated) {
                        subflag = String.valueOf(subflag) + ",";
                    }
                    ++n4;
                }
                if (commaSeparated && subflag.endsWith(",")) {
                    subflag = subflag.substring(0, subflag.length() - 1);
                }
                if (this.containsMakeVariable(subflag)) {
                    int pos = subflag.indexOf("$<");
                    if (pos != -1) {
                        subflag = String.valueOf(subflag.substring(0, pos)) + "\"" + subflag.substring(pos, subflag.length() - pos + 2) + "\"";
                    }
                    cmdlineFlagList.add(subflag);
                } else {
                    argfileFlagList.add(subflag);
                }
                ++n2;
            }
            ++i;
        }
        String[] argFlags = argfileFlagList.toArray(new String[argfileFlagList.size()]);
        String[] cmdFlags = cmdlineFlagList.toArray(new String[cmdlineFlagList.size()]);
        return this.getCompactedFlags(tool, relativePath, targetName, argFlags, cmdFlags, topBuildLocation, overwriteExistingArgsFile);
    }

    private boolean containsMakeVariable(String flag) {
        char nextChar;
        int dollarPos = flag.indexOf(36);
        return dollarPos != -1 && dollarPos < flag.length() && MAKE_SINGLE_VAR_CHARS.indexOf(nextChar = flag.charAt(dollarPos + 1)) != -1;
    }

    /*
     * Unable to fully structure code
     */
    String getUniqueFileName(String targetName, IPath topBuildLocation) {
        targetPath = new Path(targetName);
        if (targetPath.isAbsolute() || this.isOutsideProjectDirectory(targetPath, topBuildLocation)) {
            targetName = targetPath.lastSegment();
        }
        parentRelativeCharacters = new String[]{"../", "..\\"};
        i = 0;
        while (i < parentRelativeCharacters.length) {
            parentIndex = targetName.indexOf(parentRelativeCharacters[i]);
            while (parentIndex >= 0) {
                targetName = targetName.substring(parentIndex + parentRelativeCharacters[i].length());
                parentIndex = targetName.indexOf(parentRelativeCharacters[i]);
            }
            ++i;
        }
        dotIndex = targetName.lastIndexOf(46);
        if (dotIndex > 0) {
            targetName = targetName.substring(0, dotIndex);
        }
        if (!this.isNameUnique(String.valueOf(targetName) + ".args")) ** GOTO lbl20
        return String.valueOf(targetName) + ".args";
lbl-1000:
        // 1 sources

        {
            ++this.fBuildCommandCounter;
lbl20:
            // 2 sources

            ** while (!this.isNameUnique((String)(String.valueOf((Object)targetName) + "_" + this.fBuildCommandCounter + ".args")))
        }
lbl21:
        // 1 sources

        return String.valueOf(targetName) + "_" + this.fBuildCommandCounter + ".args";
    }

    private boolean isOutsideProjectDirectory(Path targetPath, IPath topBuildLocation) {
        if (targetPath.isAbsolute()) {
            return false;
        }
        IPath newPath = topBuildLocation.append((IPath)targetPath);
        return !topBuildLocation.isPrefixOf(newPath);
    }

    public void writeBuildCommands(IPath moduleOutputDir, IPath topBuildPath) throws CoreException {
        for (BuildCommand command : this.fBuildCommand) {
            IFile argumentFile = FSLPathUtil.createFile(topBuildPath.append(command.fileName));
            StringBuffer makeBuf = new StringBuffer();
            String[] flags = ToolProxy.mergeLinesWithQuotes(command.fileArguments.split(" "));
            int i = 0;
            while (i < flags.length) {
                if (i > 0) {
                    if (flags[i].startsWith("-") || flags[i].startsWith("\"")) {
                        makeBuf.append(IToolConstants.NEWLINE);
                    } else {
                        makeBuf.append(" ");
                    }
                }
                makeBuf.append(flags[i]);
                ++i;
            }
            FSLUtil.save(makeBuf, argumentFile);
        }
        this.fOldCommand = this.fBuildCommand;
        this.fBuildCommand = new LinkedList<BuildCommand>();
    }

    public void writeExternalBuildCommands(IPath moduleOutputDir, IPath topBuildPath) throws CoreException {
        for (BuildCommand command : this.fBuildCommand) {
            IPath path = topBuildPath.append(command.fileName);
            File argumentFile = path.toFile();
            try {
                if (!argumentFile.exists()) {
                    argumentFile.createNewFile();
                }
                FileOutputStream stream = new FileOutputStream(argumentFile);
                stream.write(command.fileArguments.getBytes());
                stream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.fOldCommand = this.fBuildCommand;
        this.fBuildCommand = new LinkedList<BuildCommand>();
    }

    public void deleteBuildCommandsFiles(IPath moduleOutputDir, IPath topBuildPath) throws CoreException {
        for (BuildCommand command : this.fOldCommand) {
            File file = topBuildPath.append(command.fileName).toFile();
            file.delete();
        }
    }

    public BuildCommand[] getBuildCommands() {
        return this.fBuildCommand.toArray(new BuildCommand[this.fBuildCommand.size()]);
    }

    public static class BuildCommand {
        public String buildCommand;
        public String fileArguments;
        public String fileName;
        public ITool tool;
        public String targetName;
    }
}

