/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.DynamicTemplateManager;
import com.freescale.s32ds.cross.core.model.DynamicTemplateSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.templateengine.Template;
import org.eclipse.cdt.ui.templateengine.TemplateEngineUI;

public class TemplateManager {
    private final Map<String, Template> templateMap = new HashMap<String, Template>();
    private final Map<String, IProjectType> projectTypeMap = new HashMap<String, IProjectType>();
    private final DynamicTemplateManager manager;
    private List<Template> templates;
    private List<IProjectType> projectTypes;

    public TemplateManager(DynamicTemplateSettings settings) {
        this.manager = new DynamicTemplateManager(settings);
        Template[] templateArray = TemplateEngineUI.getDefault().getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template t = templateArray[n2];
            this.templateMap.put(t.getTemplateInfo().getTemplateId(), t);
            ++n2;
        }
        for (Template t : this.manager.readDynamic()) {
            if (!t.getTemplateInfo().getProjectType().startsWith(settings.getPrefix())) continue;
            this.templateMap.put(t.getTemplateInfo().getTemplateId(), t);
        }
        Collection<String> suppressed = this.manager.getSuppressed();
        ArrayList<Template> registered = new ArrayList<Template>(this.templateMap.values());
        int i = registered.size() - 1;
        while (i >= 0) {
            Template t = (Template)registered.get(i);
            for (String id : suppressed) {
                if (!id.equals(t.getTemplateInfo().getTemplateId())) continue;
                Activator.logWarning("Suppressing template: " + id);
                this.templateMap.remove(t);
                break;
            }
            --i;
        }
        IProjectType[] pt = ManagedBuildManager.getDefinedProjectTypes();
        Arrays.sort(pt, new Comparator<IProjectType>(){

            @Override
            public int compare(IProjectType p0, IProjectType p1) {
                return p1.getName().compareTo(p0.getName());
            }
        });
        IProjectType[] iProjectTypeArray = pt;
        int n3 = pt.length;
        int n4 = 0;
        while (n4 < n3) {
            IProjectType p = iProjectTypeArray[n4];
            if (!p.isAbstract() && p.isSupported() && !p.isTestProjectType()) {
                this.projectTypeMap.put(p.getId(), p);
            }
            ++n4;
        }
    }

    public Template getTemplate(String templateInfoId) {
        return this.templateMap.get(templateInfoId);
    }

    public List<Template> getTemplates() {
        if (this.templates == null) {
            this.templates = new ArrayList<Template>(this.templateMap.values());
        }
        return this.templates;
    }

    public IProjectType getProjectType(String projectTypeId) {
        return this.projectTypeMap.get(projectTypeId);
    }

    public List<IProjectType> getProjectTypes() {
        if (this.projectTypes == null) {
            this.projectTypes = new ArrayList<IProjectType>(this.projectTypeMap.values());
        }
        return this.projectTypes;
    }

    public DynamicTemplateSettings getTemplateSettings() {
        return this.manager.getSettings();
    }
}

