/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.refactoring;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RenameUtils {
    static final String PROJECT_NAME_REGEX = "( .*[ \\/.\"_\\\\])|(:.*[}\\/._\\\\])|(\\/.*[}\\/.\"_])|(>.*[<.\\/_\\\\])|(\".*[ \\/.\"_\\\\])|(\\\\.*[}\\/.\"_\\\\])";

    public static String renameProjectOccurencesInFileName(String name, String search, String replace) {
        int leftSearchBoundary = 0;
        StringBuilder newName = new StringBuilder("");
        while (leftSearchBoundary < name.length()) {
            int index = name.indexOf(search, leftSearchBoundary);
            if (index == -1) {
                newName.append(name.substring(leftSearchBoundary));
                break;
            }
            if (RenameUtils.isProjectName(name, search, index)) {
                newName.append(name.substring(leftSearchBoundary, index)).append(replace);
            } else {
                newName.append(name.substring(leftSearchBoundary, index + search.length()));
            }
            leftSearchBoundary = index + search.length();
        }
        return newName.toString();
    }

    public static boolean isProjectName(String line, String oldName, int indexOfOldNameInLine) {
        String newLine = " " + line + " ";
        String oldNameWithNeighborSymbols = newLine.substring(indexOfOldNameInLine, indexOfOldNameInLine + oldName.length() + 2);
        Pattern pattern = Pattern.compile(PROJECT_NAME_REGEX);
        Matcher matcher = pattern.matcher(oldNameWithNeighborSymbols);
        return matcher.find();
    }
}

