/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKNotAvailableException;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectUpdater;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.nxp.s32ds.cle.ide.sdk.core.SDKDescriptorParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSDK
implements ISDK {
    private static final String CONFLICT_MARKER = "com.freescale.s32ds.cross.sdk.support.SDKConflictMarker";
    protected static final int FIELD_ID = 0;
    protected static final int FIELD_ALIAS = 1;
    protected IFilterOptions filterOptions;
    public SDKHeader head;
    public TCHolder root;
    public TCHolder[] toolchains;
    protected ISDK.TYPE type;

    public AbstractSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions, TCHolder[] tcs) {
        this.head = Objects.requireNonNull(head);
        this.root = root;
        this.filterOptions = filterOptions;
        this.toolchains = tcs;
    }

    @Override
    public SDKHeader getHeader() {
        return this.head;
    }

    @Override
    public void setHeader(SDKHeader head) {
        this.head = Objects.requireNonNull(head);
    }

    @Override
    public TCHolder getRoot() {
        return this.root;
    }

    public String getName() {
        return this.head.getName();
    }

    public String getVersion() {
        return this.head.getVersion();
    }

    public String getDescription() {
        String description = this.head.getDescription();
        return description == null ? "" : description;
    }

    @Override
    public IEnvironment getEnv() {
        return this.head.getEnv();
    }

    @Override
    public void setEnv(IEnvironment env) {
        this.head.setEnv(env);
    }

    @Override
    public TCHolder[] getToolchains() {
        return this.toolchains;
    }

    @Override
    public String[] getIncludePaths(String toolchainId) {
        return this.getPaths(this.getHeaders(toolchainId));
    }

    @Override
    public String[] getPaths(IExtendedPath[] array) {
        HashSet<String> paths = new HashSet<String>();
        IPath root = SDKSupportPlugin.getEclipsePath(this);
        IExtendedPath[] iExtendedPathArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath p = iExtendedPathArray[n2];
            IExtendedPath parent = p.toFile().isDirectory() ? p : p.removeLastSegments(1);
            IPath relative = parent.makeRelativeTo(root);
            paths.add(AbstractSDK.generatePathString(relative, this.getEnv().getName()));
            ++n2;
        }
        String[] res = new String[paths.size()];
        Iterator it = paths.iterator();
        int i = 0;
        while (i < res.length) {
            res[i] = ((String)it.next()).replace('\\', '/');
            ++i;
        }
        return res;
    }

    @Override
    public String[] getLocalPaths(IExtendedPath[] array, String local) {
        HashSet<String> paths = new HashSet<String>();
        String sdkdir = new Path(this.getEnv().getValue()).lastSegment();
        String prjpath = String.valueOf(local) + "/" + this.getName();
        IExtendedPath[] iExtendedPathArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String x;
            int n3;
            IExtendedPath p = iExtendedPathArray[n2];
            if (p.isCopy() && (n3 = (x = p.removeLastSegments(1).toOSString().replace('\\', '/')).indexOf(sdkdir)) >= 0) {
                paths.add(String.valueOf(prjpath) + x.substring(n3 + sdkdir.length()));
            }
            ++n2;
        }
        String[] res = new String[paths.size()];
        Iterator it = paths.iterator();
        int i = 0;
        while (i < res.length) {
            res[i] = ((String)it.next()).replace('\\', '/');
            ++i;
        }
        return res;
    }

    @Override
    public String[] getDefSymbols(String toolchainId) {
        String[] res = this.root.defs.toArray(new String[this.root.defs.size()]);
        if (this.toolchains == null || this.toolchains.length == 0) {
            return res;
        }
        ArrayList<String> ls = new ArrayList<String>();
        ls.addAll(this.root.defs);
        TCHolder[] tCHolderArray = this.toolchains;
        int n = this.toolchains.length;
        int n2 = 0;
        while (n2 < n) {
            TCHolder h = tCHolderArray[n2];
            String id = h.getTCId();
            if (id != null && id.startsWith(toolchainId)) {
                ls.addAll(h.defs);
            }
            ++n2;
        }
        return ls.toArray(res);
    }

    public static String generatePathString(IPath p, String name) {
        String s = p.toString();
        if (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return '\"' + SDKSupportPlugin.generateVariableExpression(name) + '/' + s + '\"';
    }

    @Override
    public IExtendedPath[] getSources(String toolchainId) {
        return this.union(this.root, this.toolchains, 0, toolchainId);
    }

    @Override
    public IExtendedPath[] getHeaders(String toolchainId) {
        return this.union(this.root, this.toolchains, 1, toolchainId);
    }

    @Override
    public IExtendedPath[] getBinaries(String toolchainId) {
        return this.union(this.root, this.toolchains, 2, toolchainId);
    }

    @Override
    public IExtendedPath[] getOtherResources(String toolchainId) {
        return this.union(this.root, this.toolchains, 3, toolchainId);
    }

    @Override
    public IExtendedPath[] getLinkerFiles(String toolchainId) {
        return this.union(this.root, this.toolchains, 4, toolchainId);
    }

    @Override
    public IExtendedPath[][] getResources(String tcId) {
        IExtendedPath[][] a = new IExtendedPath[][]{this.getSources(tcId), this.getBinaries(tcId), this.getHeaders(tcId), this.getOtherResources(tcId), this.getLinkerFiles(tcId)};
        return a;
    }

    @Override
    public IFilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    @Override
    public boolean isPex() {
        return this.head.isPEx();
    }

    @Override
    public String getStatusText() {
        return this.getStatus().toString();
    }

    public final String getId() {
        return this.head.getId();
    }

    public String toString() {
        IEnvironment ie = this.getEnv();
        return String.format("SDK[%s %s @ %s]", this.getName(), this.getVersion(), ie == null ? "NULL" : ie.getName());
    }

    @Override
    public void asXML(Document document, Element rootElement) throws ParserConfigurationException, UnsupportedEncodingException, TransformerException {
        IPath sdkPath = SDKSupportPlugin.getEclipsePath(this);
        if (sdkPath == null) {
            SDKSupportPlugin.log(String.format("NULL eclipse path for SDK: %s %s", this.getName(), this.getId()));
            Thread.dumpStack();
            return;
        }
        Element sdkElement = document.createElement("sdk");
        this.asXMLHead(document, sdkElement, sdkPath, String.join((CharSequence)",", this.getToolChainIDs()));
        this.asXMLExtra(document, sdkElement, sdkPath);
        this.root.asXML(document, sdkElement, sdkPath);
        rootElement.appendChild(sdkElement);
    }

    protected void asXMLExtra(Document document, Element sdkElement, IPath sdkPath) {
        if (this.toolchains != null && this.toolchains.length > 0) {
            TCHolder[] tCHolderArray = this.toolchains;
            int n = this.toolchains.length;
            int n2 = 0;
            while (n2 < n) {
                TCHolder h = tCHolderArray[n2];
                Element tcElement = document.createElement("toolchain");
                tcElement.setAttribute("id", h.getTCId());
                tcElement.setAttribute("alias", h.getTCAlias());
                h.asXML(document, tcElement, sdkPath);
                sdkElement.appendChild(tcElement);
                ++n2;
            }
        }
    }

    protected void asXMLHead(Document document, Element sdkElement, IPath sdkPath, String tcId) {
        sdkElement.setAttribute("id", SDKHeader.makeId(this.getName(), this.getVersion()));
        sdkElement.setAttribute("name", this.getName());
        sdkElement.setAttribute("version", this.getVersion());
        String description = this.getDescription();
        if (description != null) {
            sdkElement.setAttribute("description", description);
        }
        if (tcId != null) {
            sdkElement.setAttribute("toolchains", tcId);
        }
        Element envElement = document.createElement("env");
        IEnvironment env = this.getEnv();
        envElement.setAttribute("name", env.getName());
        envElement.setAttribute("value", this.getEnv().getValue());
        envElement.setAttribute("isSystem", String.valueOf(env.isSystem()));
        sdkElement.appendChild(envElement);
        IFilterOptions fopt = this.getFilterOptions();
        sdkElement.setAttribute("langs", IFilterOptions.lang2strMap.get((Object)(fopt == null ? IFilterOptions.ELang.UNKNOWN : fopt.getLang())));
        sdkElement.setAttribute("cores", String.join((CharSequence)",", fopt == null ? new String[]{} : fopt.getCores()));
        sdkElement.setAttribute("basePath", this.getEnv().getValue());
        if (this.isPex()) {
            sdkElement.setAttribute("pex", String.valueOf(this.isPex()));
        }
    }

    protected static IStatus parseSDKsString(String sdkDescriptors, IProject project, int origin, boolean isForceReload) {
        if (sdkDescriptors == null || sdkDescriptors.isEmpty()) {
            return Status.OK_STATUS;
        }
        try {
            List<ISDK> declaredSdkList = SDKDescriptorParser.loadSDKs(sdkDescriptors, project, null, origin);
            List<ISDK> conflictSdkList = SDKUtils.add(declaredSdkList, isForceReload);
            if (conflictSdkList == null || conflictSdkList.isEmpty()) {
                return Status.OK_STATUS;
            }
            String projectName = project != null ? project.getName() : null;
            for (ISDK sdk : conflictSdkList) {
                String message;
                String sdkId = sdk.getId();
                if (project == null || !project.isAccessible()) {
                    message = NLS.bind((String)Messages.AbstractSDK_sdk_id_conflict, (Object)sdkId);
                    SDKSupportPlugin.log(message);
                    continue;
                }
                message = NLS.bind((String)Messages.AbstractSDK_project_sdk_id_conflict, (Object[])new Object[]{projectName, sdkId});
                SDKSupportPlugin.log(message);
                AbstractSDK.createConflictedSdkMarker((IResource)project, message, sdkId);
                IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                if (buildInfo == null) continue;
                IConfiguration[] iConfigurationArray = buildInfo.getManagedProject().getConfigurations();
                int n = iConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfiguration cfg = iConfigurationArray[n2];
                    ProjectUpdater.updateOptions(cfg, sdk, true);
                    ++n2;
                }
            }
            SDKUtils.cleanUnusedSdkEnvironmentVariables();
        }
        catch (SDKLoadException sle) {
            SDKSupportPlugin.error(sle);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static void parseSDKsString(String sdksString, IProject project, int origin) {
        AbstractSDK.parseSDKsString(sdksString, project, origin, false);
    }

    public static List<ISDK> load(File f, int origin) {
        try {
            return AbstractSDK.loadXML(SDKUtils.toString(new FileInputStream(f)), null, f.getParent(), origin);
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
            return new ArrayList<ISDK>();
        }
    }

    public static List<ISDK> loadXML(String sdkString, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        if (sdkString == null || sdkString.length() == 0) {
            return result;
        }
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sdkString.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(Messages.AbstractSDK_exception, e);
            return result;
        }
        if (!root.getNodeName().equals("sdks")) {
            SDKSupportPlugin.error(Messages.AbstractSDK_bad_format, null);
            return result;
        }
        NodeList list = root.getChildNodes();
        int i = 0;
        int numItems = list.getLength();
        while (i < numItems) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (!element.getNodeName().equals("sdk")) {
                    SDKSupportPlugin.error(String.format(Messages.AbstractSDK_bad_xml, node.getNodeName()), null);
                } else {
                    boolean createVar = origin != 3 && origin != 2;
                    SDKHeader hdr = new SDKHeader(createVar, element);
                    TCHolder rootHolder = new TCHolder(null);
                    String sym = element.getAttribute("symbols");
                    List<String> list2 = rootHolder.defs = sym == null || sym.trim().isEmpty() ? new ArrayList<String>() : Arrays.asList(sym.split(","));
                    if (hdr.getEnv() == null && createVar) {
                        hdr.setEnv(SDKSupportPlugin.createEnvironment(hdr.getName(), hdr.getVersion(), false, true, alterEnvValue, hdr.getDescription()));
                    }
                    ArrayList<TCHolder> tclst = new ArrayList<TCHolder>();
                    NodeList children = element.getChildNodes();
                    int x = 0;
                    while (x < children.getLength()) {
                        Node n = children.item(x);
                        if (n.getNodeType() == 1) {
                            Element e;
                            String path = hdr.getBasePath();
                            if ((path == null || path.trim().isEmpty()) && hdr.getEnv() != null) {
                                path = hdr.getEnv().getValue();
                            }
                            if ((e = (Element)n).getNodeName().equals("toolchain")) {
                                TCHolder dht = new TCHolder(e, path, alterEnvValue);
                                if (!dht.isEmpty()) {
                                    tclst.add(dht);
                                }
                            } else {
                                rootHolder.process(e, path, alterEnvValue);
                            }
                        }
                        ++x;
                    }
                    IFilterOptions filter = FilterOptions.createFilterOptions(hdr.getLangs(), hdr.getObsoleteToolchainIds(), hdr.getCores());
                    TCHolder[] tcs = null;
                    if (!tclst.isEmpty()) {
                        tcs = tclst.toArray(new TCHolder[tclst.size()]);
                        String s = String.join((CharSequence)",", AbstractSDK.getFields(tcs, 0));
                        filter = FilterOptions.createFilterOptions(hdr.getLangs(), s, hdr.getCores());
                    }
                    switch (origin) {
                        case 2: 
                        case 3: 
                        case 6: {
                            result.add(new ImportSDK(hdr, rootHolder, filter, tcs, alterEnvValue));
                            break;
                        }
                        case 1: {
                            result.add(new GitSDK(hdr, rootHolder, filter, tcs));
                            break;
                        }
                        case 4: {
                            result.add(new ExternalSDK(hdr, rootHolder, filter));
                            break;
                        }
                        case 5: {
                            result.add(new ProjectLocalSDK(project, hdr, rootHolder, filter));
                            break;
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static String getSDKsString(List<ISDK> sdks) {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootElement = document.createElement("sdks");
            document.appendChild(rootElement);
            for (ISDK sdk : sdks) {
                sdk.asXML(document, rootElement);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return s.toString("UTF8");
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            SDKSupportPlugin.error(Messages.AbstractSDK_exception_store, e);
            return "";
        }
    }

    @Override
    public ISDK.TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isAvailable() {
        try {
            new SDKAvailabilityChecker().checkAvailability(this.getId());
        }
        catch (SDKNotAvailableException sDKNotAvailableException) {
            return false;
        }
        return true;
    }

    @Override
    public String getBriefInfo() {
        return this.getName() + ' ' + this.getVersion() + ' ' + '@' + ' ' + this.getEnv().getName() + ' ' + '(' + this.getType().getName() + ')';
    }

    protected static String[] getFields(TCHolder[] tcs, int field) {
        if (tcs == null || tcs.length == 0) {
            return ZERO_ARR;
        }
        String[] res = new String[tcs.length];
        int i = 0;
        while (i < tcs.length) {
            switch (field) {
                case 0: {
                    res[i] = tcs[i].getTCId();
                    break;
                }
                case 1: {
                    res[i] = tcs[i].getTCAlias();
                    break;
                }
                default: {
                    SDKSupportPlugin.log(String.format(Messages.AbstractSDK_bad_field, field));
                }
            }
            ++i;
        }
        return res;
    }

    protected IExtendedPath[] union(TCHolder root, TCHolder[] tcHolders, int type, String tc) {
        LinkedHashSet result = new LinkedHashSet();
        if (root != null) {
            Stream.of(root.get(type)).forEach(path -> {
                boolean bl = result.add(path);
            });
        }
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        if (tcHolders != null && tc != null) {
            Stream.of(tcHolders).filter(tch -> "all_toolchains".equals(tc) || checker.checkToolchainsCompatibility(tch.getTCId(), tc).isOK()).flatMap(tch -> Stream.of(tch.get(type))).forEach(path -> {
                boolean bl = result.add(path);
            });
        }
        return result.toArray(TCHolder.EMPTY_PATHS);
    }

    private static void createConflictedSdkMarker(IResource resource, String message, String sdkId) {
        try {
            IMarker marker = SDKUtils.createErrorMarker(CONFLICT_MARKER, resource, message);
            marker.setAttribute("sdkId", (Object)sdkId);
        }
        catch (CoreException ce) {
            SDKSupportPlugin.error(NLS.bind((String)Messages.AbstractSDK_error_creating_conflict_marker, null), ce);
        }
    }
}

