/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.listeners;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ProjectDeleteListener
implements IResourceChangeListener {
    public static final String OTHER_PROJECTS_WORKING_SET_NAME = "Other Projects";
    Map<String, URI> projectLocationMap = new HashMap<String, URI>();
    Map<String, List<IWorkingSet>> projectWorkingSetsMap = new HashMap<String, List<IWorkingSet>>();

    public void resourceChanged(IResourceChangeEvent event) {
        int eventType = event.getType();
        IResource resource = event.getResource();
        if (eventType == 4 && resource != null && resource.getType() == 4) {
            this.registerProjectLocation(resource);
            this.registerProjectWorkingSets(resource);
        } else if (eventType == 1 && resource == null && event.getDelta() != null) {
            this.handlePostChangeEvent(event);
        }
    }

    private void handlePostChangeEvent(IResourceChangeEvent event) {
        IResourceDelta[] childDeltas;
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = childDeltas = delta.getAffectedChildren();
        int n = childDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            this.handleDeletedProject(childDelta);
            ++n2;
        }
    }

    private void handleDeletedProject(IResourceDelta resourceDelta) {
        List<IWorkingSet> workingSets;
        IResource resource = resourceDelta.getResource();
        if (!(resource instanceof IProject)) {
            return;
        }
        URI locationURI = this.unregisterProjectLocation(resource);
        if (locationURI != null) {
            URI workspaceLocationURI = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
            File workspaceFolder = new File(workspaceLocationURI.getPath());
            File file = new File(locationURI.getPath());
            File projectParentFolder = file.getParentFile();
            String[] childfiles = projectParentFolder.list();
            if (workspaceFolder.compareTo(projectParentFolder) != 0 && childfiles != null && childfiles.length == 0) {
                projectParentFolder.delete();
            }
        }
        if ((workingSets = this.unregisterProjectWorkingSets(resource)) != null) {
            for (IWorkingSet workingSet : workingSets) {
                this.removeProjectFromWorkingSet(resource, workingSet);
                if (!this.isEmpty(workingSet)) continue;
                this.getWorkingSetManager().removeWorkingSet(workingSet);
            }
        }
    }

    private void registerProjectLocation(IResource resource) {
        if (resource.getLocationURI() != null) {
            this.projectLocationMap.put(resource.getName(), resource.getLocationURI());
        }
    }

    private void registerProjectWorkingSets(IResource resource) {
        IWorkingSet[] workingSets;
        IWorkingSet[] iWorkingSetArray = workingSets = this.getWorkingSetManager().getWorkingSets();
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (!OTHER_PROJECTS_WORKING_SET_NAME.equals(workingSet.getName()) && Arrays.asList(workingSet.getElements()).contains(resource)) {
                if (!this.projectWorkingSetsMap.containsKey(resource.getName())) {
                    this.projectWorkingSetsMap.put(resource.getName(), new ArrayList());
                }
                this.projectWorkingSetsMap.get(resource.getName()).add(workingSet);
            }
            ++n2;
        }
    }

    private URI unregisterProjectLocation(IResource resource) {
        return this.projectLocationMap.remove(resource.getName());
    }

    private List<IWorkingSet> unregisterProjectWorkingSets(IResource resource) {
        return this.projectWorkingSetsMap.remove(resource.getName());
    }

    private IWorkingSetManager getWorkingSetManager() {
        return PlatformUI.getWorkbench().getWorkingSetManager();
    }

    private void removeProjectFromWorkingSet(IResource resource, IWorkingSet workingSet) {
        ArrayList<IAdaptable> projects = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        projects.remove(resource);
        workingSet.setElements(projects.toArray(new IAdaptable[0]));
    }

    private boolean isEmpty(IWorkingSet workingSet) {
        if (OTHER_PROJECTS_WORKING_SET_NAME.equals(workingSet.getName())) {
            return false;
        }
        IAdaptable[] elements = workingSet.getElements();
        if (elements.length == 0) {
            return true;
        }
        int deletedCount = 0;
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            if (element instanceof IProject && !((IProject)element).exists()) {
                ++deletedCount;
            }
            ++n2;
        }
        return deletedCount >= elements.length && this.getWorkingSetManager().getWorkingSet(workingSet.getName()) != null;
    }
}

