/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import com.pemicro.forms.JFS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CProgStatus
implements Runnable {
    public static final int CreateForm = 0;
    public static final int UpdateForm = 1;
    public static final int CloseForm = 2;
    public static final int CheckAbort = 3;
    private List statusList;
    protected Shell shell;
    private Shell parentShell;
    private Display disp;
    private Button abortButton;
    private Label errorLabel;
    private Label statusBarLabel;
    private Label urlLabel;
    private boolean abortRequest = false;
    private short formCommand;
    private String title;
    private String buttonString;
    private String errorString;
    private String url;
    private String statusBar;
    private String cProgStatusItem;
    private boolean addNewLine = false;
    private boolean errorOccured = false;
    boolean resultSuccess = false;

    public void setFormCommand(short formCommand) {
        this.formCommand = formCommand;
    }

    public short getFormCommand() {
        return this.formCommand;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setButtonString(String buttonString) {
        this.buttonString = buttonString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStatusBar(String statusBar) {
        this.statusBar = statusBar;
    }

    public void setCProgStatusItem(String cProgStatusItem) {
        this.cProgStatusItem = cProgStatusItem;
    }

    public void setAddNewLine(boolean addNewLine) {
        this.addNewLine = addNewLine;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    public boolean getErrorOccured() {
        return this.errorOccured;
    }

    public void run() {
        this.disp = PlatformUI.getWorkbench().getDisplay();
        this.resultSuccess = false;
        switch (this.formCommand) {
            case 0: {
                this.abortRequest = false;
                this.parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                this.shell = new Shell(this.parentShell, 18528);
                this.createContents();
                this.shell.open();
                this.shell.layout();
                this.resultSuccess = true;
                break;
            }
            case 1: {
                this.updateContents();
                if (this.errorOccured) {
                    while (!this.abortRequest) {
                        if (this.disp.readAndDispatch()) continue;
                        this.disp.sleep();
                    }
                }
                this.resultSuccess = true;
                break;
            }
            case 2: {
                this.close();
                this.resultSuccess = true;
            }
        }
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    public boolean getResultSucess() {
        return this.resultSuccess;
    }

    public boolean getAbortRequest() {
        return this.abortRequest;
    }

    protected void updateContents() {
        this.refreshStatusList();
        this.refreshStatusBar();
        this.refreshErrorLabel();
    }

    void refreshStatusList() {
        if (this.addNewLine || this.statusList.getItemCount() == 0) {
            this.statusList.add(this.cProgStatusItem);
        } else {
            String old = this.statusList.getItem(this.statusList.getItemCount() - 1);
            String newS = String.valueOf(old) + this.cProgStatusItem;
            this.statusList.setItem(this.statusList.getItemCount() - 1, newS);
        }
        this.statusList.setSelection(this.statusList.getItemCount() - 1);
    }

    void refreshErrorLabel() {
        this.errorLabel.setText(this.errorString);
        this.errorLabel.pack();
    }

    void refreshStatusBar() {
        this.statusBarLabel.setText(this.statusBar);
        if (this.errorOccured) {
            this.statusBarLabel.setForeground(new Color((Device)this.disp, JFS.RED));
        } else {
            this.statusBarLabel.setForeground(new Color((Device)this.disp, JFS.BLACK));
        }
    }

    void refreshURL() {
        this.urlLabel.setText(this.url);
        this.urlLabel.pack();
    }

    protected void createContents() {
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        GridLayout layout = new GridLayout(3, false);
        this.shell.setLayout((Layout)layout);
        int shellX = bounds.x + (bounds.width - this.shell.getSize().x) / 2;
        int shellY = bounds.y + (bounds.height - this.shell.getSize().y) / 2;
        int shellWidth = 845;
        int shellHeight = 395;
        Rectangle shellBounds = new Rectangle(shellX, shellY, shellWidth, shellHeight);
        this.shell.setBounds(shellBounds);
        this.shell.setText(this.title);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                CProgStatus.this.abortRequest = true;
                CProgStatus.this.shell.setVisible(false);
                event.doit = CProgStatus.this.formCommand == 2;
            }
        });
        this.abortButton = new Button((Composite)this.shell, 0);
        this.abortButton.setText(this.buttonString);
        this.abortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CProgStatus.this.abortButton.setEnabled(false);
                CProgStatus.this.abortRequest = true;
            }
        });
        GridData data = new GridData(768);
        this.errorLabel = new Label((Composite)this.shell, 0);
        this.errorLabel.setForeground(new Color((Device)this.disp, JFS.RED));
        this.refreshErrorLabel();
        this.errorLabel.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 128;
        this.urlLabel = new Label((Composite)this.shell, 0);
        this.urlLabel.setFont(new Font((Device)this.disp, JFS.CPROG_URL_FONT));
        this.urlLabel.setForeground(new Color((Device)this.disp, JFS.GRAY));
        this.refreshURL();
        this.urlLabel.setLayoutData((Object)data);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.statusList = new List((Composite)this.shell, 2560);
        this.statusList.setFont(new Font((Device)this.disp, JFS.CPROG_LIST_FONT));
        this.statusList.removeAll();
        this.statusList.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.statusBarLabel = new Label((Composite)this.shell, 2112);
        this.refreshStatusBar();
        this.statusBarLabel.setLayoutData((Object)data);
    }
}

