/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SDKDefinedSymbolValidator
implements IValidator {
    private static final String SPACE = " ";
    private static final String EQUAL = "=";
    private static final String QUOTE = "\"";
    private static final int SYMBOL_LENGTH = 512;
    private static final Pattern SYMBOL_NAME_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z_0-9]*$");
    private boolean isInitialInput;
    private List<String> existingSymbols;

    public IStatus validate(Object value) {
        if (!(value instanceof String)) {
            return ValidationStatus.error((String)"Unexpected input");
        }
        String text = ((String)value).trim();
        if (text == null || text.isEmpty()) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_empty_error, null));
        }
        if (!this.isInitialInput && this.existingSymbols != null && this.existingSymbols.contains(text)) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_already_exists, null));
        }
        if (text.length() > 512) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_too_long, (Object)512));
        }
        String[] splittedSymbol = text.split(EQUAL, 2);
        if (splittedSymbol.length > 0) {
            String symbolValue;
            String symbolName = splittedSymbol[0];
            if (symbolName.isEmpty()) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_must_start_with_letter, null));
            }
            Matcher matcher = SYMBOL_NAME_PATTERN.matcher(symbolName);
            matcher.reset(symbolName.substring(0, 1));
            if (!matcher.matches()) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_must_start_with_letter, null));
            }
            matcher.reset(symbolName);
            if (!matcher.matches()) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_has_invalid_characters, null));
            }
            if (!(splittedSymbol.length <= 1 || !(symbolValue = splittedSymbol[1]).contains(SPACE) || symbolValue.startsWith(QUOTE) && symbolValue.endsWith(QUOTE))) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDefinedSymbolValidator_symbol_value_with_spaces_must_be_quoted, null));
            }
        }
        if (this.isInitialInput) {
            this.isInitialInput = false;
        }
        return Status.OK_STATUS;
    }

    public void setIsInitialInput(boolean isInitialInput) {
        this.isInitialInput = isInitialInput;
    }

    public void setExistingSymbols(List<String> existingSymbols) {
        this.existingSymbols = existingSymbols;
    }
}

