/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.GitProgressMonitor;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.freescale.s32ds.cross.sdk.internal.StorableSDK;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class GitSDK
extends StorableSDK {
    protected String localPath = null;
    protected ISDK.STATUS gitstate = null;

    public GitSDK(SDKHeader head) {
        super(head, new TCHolder(null), null, null);
        this.gitstate = ISDK.STATUS.HEAD;
        IEnvironment en = SDKSupportPlugin.getEnvironment(this.getName(), this.getVersion());
        if (en.exists()) {
            this.localPath = en.getValue();
            this.gitstate = this.setLocalPath(this.localPath, null) == null ? ISDK.STATUS.READY : ISDK.STATUS.HEAD;
        }
        this.type = ISDK.TYPE.GIT;
    }

    public GitSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions, TCHolder[] hs) {
        super(head, root, filterOptions, hs);
        this.gitstate = ISDK.STATUS.READY;
        this.type = ISDK.TYPE.GIT;
    }

    @Override
    public ISDK.STATUS getStatus() {
        return this.gitstate;
    }

    public String getGitPath() {
        return this.head.gitpath;
    }

    public String getGitBranch() {
        return this.head.gitbranch == null ? "" : this.head.gitbranch;
    }

    public String getGitLabel() {
        return this.head.gitlabel == null ? "" : this.head.gitlabel;
    }

    @Override
    public IEnvironment getEnv() {
        return SDKSupportPlugin.getEnvironment(this.getName(), this.getVersion());
    }

    public static void importFromGit(GitSDK sdk, File target, IProgressMonitor monitor, Shell shell) throws InvalidRemoteException, TransportException, GitAPIException, IOException, SDKLoadException, TransformerException, ParserConfigurationException {
        String branch = sdk.getGitBranch();
        String label = sdk.getGitLabel();
        if (label != null && !label.isEmpty()) {
            branch = label;
        }
        if (branch == null || branch.isEmpty()) {
            branch = "master";
        }
        if (target.isDirectory()) {
            SDKUtils.rmdir(target);
            target.delete();
        }
        Git.cloneRepository().setURI(sdk.getGitPath()).setBranch(branch).setDirectory(target).setProgressMonitor((ProgressMonitor)new GitProgressMonitor(monitor)).call().close();
        sdk.stateChange(4, false, null, target.getAbsolutePath());
        sdk.gitstate = sdk.setLocalPath(target.getAbsolutePath(), shell) == null ? ISDK.STATUS.READY : ISDK.STATUS.HEAD;
        sdk.stateChange(4, true, null, target.getAbsolutePath());
    }
}

