/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ProjectChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (1 == event.getType()) {
            IResource target;
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            int deltasLength = 0;
            IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
            if (resourceDeltas == null || (deltasLength = resourceDeltas.length) == 0) {
                return;
            }
            if (deltasLength == 1 && (target = resourceDeltas[0].getResource()) instanceof IProject) {
                IResourceDelta rd = resourceDeltas[0];
                IProject prj = (IProject)target;
                if (2 == rd.getKind()) {
                    this.removeProjectLocalSDKs(prj);
                } else if (1 == rd.getKind()) {
                    this.reloadProjectLocalSDKs(prj, prj);
                } else if (4 == rd.getKind() && 16384 == rd.getFlags()) {
                    if (prj.isOpen()) {
                        this.loadProjectLocalSDKs(prj, false);
                    } else {
                        this.removeProjectLocalSDKs(prj);
                    }
                }
            }
        }
    }

    private void reloadProjectLocalSDKs(final IProject source, final IProject target) {
        WorkspaceJob wj = new WorkspaceJob("Reload project local SDK"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    target.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    SDKSupportPlugin.log((IStatus)new Status(2, "com.freescale.s32ds.cross.sdk.support", "Internal error while project refresh", (Throwable)e));
                }
                for (ISDK sdk : ProjectLocalSDK.getProjectLocalSDKs(source)) {
                    if (!(sdk instanceof IProjectLocalSDK)) continue;
                    SDKUtils.remove(sdk, source, false);
                }
                ProjectLocalSDK.loadProjectLocalPersistedSDK(target, true);
                SDKAttach.getAttachedVerbose(target);
                return Status.OK_STATUS;
            }
        };
        wj.setRule((ISchedulingRule)target);
        wj.schedule();
    }

    private void removeProjectLocalSDKs(final IProject project) {
        for (final ISDK sdk : ProjectLocalSDK.getProjectLocalSDKs(project)) {
            if (!(sdk instanceof IProjectLocalSDK)) continue;
            WorkspaceJob wj = new WorkspaceJob("Delete project local SDK"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    SDKUtils.remove(sdk, project, false);
                    return Status.OK_STATUS;
                }
            };
            wj.setRule((ISchedulingRule)project);
            wj.schedule();
        }
    }

    private void loadProjectLocalSDKs(final IProject project, final boolean isForceReload) {
        WorkspaceJob wj = new WorkspaceJob("Load project local SDKs"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ProjectLocalSDK.loadProjectLocalPersistedSDK(project, isForceReload);
                SDKAttach.getAttachedVerbose(project);
                return Status.OK_STATUS;
            }
        };
        wj.setRule((ISchedulingRule)project);
        wj.schedule();
    }
}

