/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.ui.intrinsics.IIntrinsicsGroup;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclarationException;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclarationValidator;
import java.util.Arrays;

class IntrinsicDeclaration
implements Comparable<IntrinsicDeclaration> {
    private static final String L_BRACKET = "(";
    private static final String R_BRACKET = ")";
    private static final String SIGNATURE_SEPARATOR = " : ";
    private String name;
    private String[] parameterTypes;
    private String returnType;
    private String description;
    private String include;
    private IIntrinsicsGroup holder;

    private IntrinsicDeclaration(IIntrinsicsGroup holder) {
        this.holder = holder;
    }

    String getSignature() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(L_BRACKET);
        sb.append(this.getParameterTypesAsString());
        sb.append(R_BRACKET);
        sb.append(SIGNATURE_SEPARATOR);
        sb.append(this.returnType);
        return sb.toString();
    }

    String getName() {
        return this.name;
    }

    IntrinsicDeclaration setName(String name) throws IntrinsicDeclarationException {
        IntrinsicDeclarationValidator.validateName(name);
        this.name = name;
        return this;
    }

    String[] getParameterTypes() {
        return this.parameterTypes;
    }

    IntrinsicDeclaration setParameterTypes(String[] parameterTypes) throws IntrinsicDeclarationException {
        IntrinsicDeclarationValidator.validateParameterTypes(parameterTypes);
        this.parameterTypes = parameterTypes;
        return this;
    }

    String getParameterTypesAsString() {
        if (this.parameterTypes != null && this.parameterTypes.length > 0) {
            String paramsString = Arrays.toString(this.parameterTypes);
            return paramsString.substring(1, paramsString.length() - 1);
        }
        return "";
    }

    String getReturnType() {
        return this.returnType;
    }

    IntrinsicDeclaration setReturnType(String returnType) throws IntrinsicDeclarationException {
        IntrinsicDeclarationValidator.validateReturnType(returnType);
        this.returnType = returnType.isEmpty() || returnType.equalsIgnoreCase("void") ? "void" : returnType;
        return this;
    }

    String getDescription() {
        return this.description == null ? "" : this.description;
    }

    IntrinsicDeclaration setDescription(String description) throws IntrinsicDeclarationException {
        IntrinsicDeclarationValidator.validateDescription(description);
        this.description = description;
        return this;
    }

    IntrinsicDeclaration setInclude(String include) {
        this.include = include;
        return this;
    }

    String getInclude() {
        return this.include != null ? this.include : "";
    }

    IIntrinsicsGroup getHolder() {
        return this.holder;
    }

    @Override
    public int compareTo(IntrinsicDeclaration bifd) {
        return this.name.compareTo(bifd.name);
    }

    static IntrinsicDeclaration create(IIntrinsicsGroup holder) {
        return new IntrinsicDeclaration(holder);
    }
}

