/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.tools.AbstractActionFilesHandler;
import com.freescale.s32ds.cross.core.tools.Disassembler;
import com.freescale.s32ds.cross.core.tools.GeneratedMakefileBuilder2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.AdapterUtil;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.ResourceUtil;

public class DisassembleFilesHandler
extends AbstractActionFilesHandler {
    protected static final IContentType asm_source = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.asmSource");
    protected static final IContentType c_source = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cSource");
    protected static final IContentType cpp_source = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.cxxSource");
    protected static final IContentType binary_file = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.binaryFile");
    protected List<IFile> selectedSourceFiles;
    protected List<IFile> selectedBinaryFiles;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile fileFromActiveEditor = DisassembleFilesHandler.getFileFromActiveEditor(event);
        if (fileFromActiveEditor != null) {
            this.selectedSourceFiles.add(fileFromActiveEditor);
        }
        List<Object> outputBinaryFiles = null;
        if (!this.selectedSourceFiles.isEmpty()) {
            BuildFilesJob buildFilesJob = new BuildFilesJob(this.selectedSourceFiles);
            buildFilesJob.schedule();
            try {
                buildFilesJob.join();
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            outputBinaryFiles = buildFilesJob.getOutputBinaryFiles();
        }
        outputBinaryFiles = outputBinaryFiles == null ? Collections.emptyList() : outputBinaryFiles;
        List<IFile> binaryFiles = Stream.concat(outputBinaryFiles.stream(), this.selectedBinaryFiles.stream()).distinct().collect(Collectors.toList());
        new DisassembleFilesJob(binaryFiles).schedule();
        return null;
    }

    private static IFile getFileFromActiveEditor(ExecutionEvent event) throws ExecutionException {
        IEditorInput editorInput;
        IResource resource;
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof ITextSelection && (resource = ResourceUtil.getResource((IEditorInput)(editorInput = HandlerUtil.getActiveEditorInputChecked((ExecutionEvent)event)))) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    @Override
    protected boolean shouldBeEnabled(Object evaluationContext) {
        IStructuredSelection selection = DisassembleFilesHandler.convertSelection((IEvaluationContext)evaluationContext, null);
        if (selection.isEmpty()) {
            return false;
        }
        ArrayList<IFile> sources = new ArrayList<IFile>();
        ArrayList<IFile> binaries = new ArrayList<IFile>();
        for (Object next : selection) {
            IConfiguration config;
            IManagedBuildInfo buildInfo;
            IContentDescription contentDescription;
            IContentType contentType;
            IFile file;
            block17: {
                block16: {
                    file = (IFile)AdapterUtil.adapt(next, IFile.class);
                    if (file == null) {
                        return false;
                    }
                    contentType = null;
                    try {
                        if (file.exists()) break block16;
                        return false;
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        return false;
                    }
                }
                contentDescription = file.getContentDescription();
                if (contentDescription != null) break block17;
                return false;
            }
            contentType = contentDescription.getContentType();
            if (contentType.isKindOf(c_source) || contentType.isKindOf(cpp_source) || contentType.isKindOf(asm_source)) {
                buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject());
                if (buildInfo != null) {
                    config = buildInfo.getDefaultConfiguration();
                    if (CDataUtil.isExcluded((IPath)file.getProjectRelativePath(), (ICSourceEntry[])config.getSourceEntries())) {
                        return false;
                    }
                    try {
                        IBuildDescription des = BuildDescriptionManager.createBuildDescription((IConfiguration)config, null, (int)0);
                        if (des.getBuildResource((IResource)file) == null) {
                            return false;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                        return false;
                    }
                    sources.add(file);
                }
            } else if (contentType.isKindOf(binary_file) && (buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject())) != null) {
                config = buildInfo.getDefaultConfiguration();
                IPath pathToProject = config.getOwner().getProject().getLocation();
                CBuildData buildData = config.getBuildData();
                ICOutputEntry[] outputDirectories = buildData.getOutputDirectories();
                IPath pathToOutputDirectory = outputDirectories[0].getFullPath();
                IPath pathToBuildDirectory = null;
                pathToBuildDirectory = pathToOutputDirectory.isEmpty() ? buildData.getBuilderCWD() : pathToProject.append(outputDirectories[0].getFullPath());
                if (!pathToBuildDirectory.isPrefixOf(file.getLocation())) {
                    return false;
                }
                binaries.add(file);
            }
            if (DisassembleFilesHandler.hasDisassembler(file)) continue;
            return false;
        }
        this.selectedSourceFiles = sources;
        this.selectedBinaryFiles = binaries;
        return true;
    }

    public static boolean hasDisassembler(IFile file) {
        if (file == null) {
            return false;
        }
        if (file.getFileExtension() == null) {
            return false;
        }
        if (file.getLocation() == null) {
            return false;
        }
        IProject project = file.getProject();
        if (!ManagedBuildManager.manages((IResource)project)) {
            return false;
        }
        IManagedBuildInfo builderInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (builderInfo == null) {
            return false;
        }
        IConfiguration configuration = builderInfo.getDefaultConfiguration();
        if (configuration == null) {
            return false;
        }
        String projectType = DisassembleFilesHandler.getProjectTypeID(builderInfo);
        if (projectType.equals("")) {
            return false;
        }
        ITool disassembler = Disassembler.getDisassembler(configuration, file);
        return disassembler != null;
    }

    public static class BuildFilesJob
    extends Job {
        private final List<IFile> files;
        private List<IFile> outputBinaryFiles;

        public List<IFile> getOutputBinaryFiles() {
            return this.outputBinaryFiles;
        }

        public BuildFilesJob(List<IFile> filesToBuild) {
            super("Building Files");
            this.files = filesToBuild;
        }

        protected IStatus run(IProgressMonitor monitor) {
            GeneratedMakefileBuilder2 builder = new GeneratedMakefileBuilder2();
            IStatus status = builder.invokeInternalBuilder(this.files, monitor);
            this.outputBinaryFiles = builder.getOutputBinaryFiles();
            return status;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }

    public static class DisassembleFilesJob
    extends Job {
        private final List<IFile> files;

        public DisassembleFilesJob(List<IFile> filesToDisassemble) {
            super("Disassembling Files");
            this.files = filesToDisassemble;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                Job[] jobs;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] jobArray = jobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job != this && job instanceof DisassembleFilesJob) {
                        job.cancel();
                    }
                    ++n2;
                }
            }
            Disassembler disassembler = new Disassembler();
            try {
                disassembler.disassembleFiles(this.files, monitor);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

