/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.context;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.AffectType;
import com.freescale.s32ds.cross.core.model.ContextType;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.ExecutableContext;
import com.freescale.s32ds.cross.core.model.context.GeneralContext;
import com.freescale.s32ds.cross.core.model.context.LibraryContext;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreTypeData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;

public class ProcessorContext
extends AbstractContext {
    private final Map<String, ConfigurationData> dataMap = new HashMap<String, ConfigurationData>();
    private final List<CoreNatureData> coreNatures;
    private final List<CoreNatureConfiguration> coreNatureConfigurations = new ArrayList<CoreNatureConfiguration>();
    private final Map<String, CProjectContext> projectContextMap = new LinkedHashMap<String, CProjectContext>();
    private final ContextType projectContextType;
    private String currentCoreNatureId;
    private final ProcessorConfiguration configuration;

    public ProcessorContext(ProcessorConfiguration configuration, GeneralContext parent) {
        super(configuration.getProcessor(), parent.getRegistry().getContextDefinition(configuration.isExecutable() ? ContextType.PROCESSOR_EXECUTABLE : ContextType.PROCESSOR_LIBRARY), CoreNatureConfiguration.getContextParts(configuration.getCoreNatureConfigurations(), configuration.getProcessor(), configuration.isExecutable()), parent.getRegistry(), parent);
        if (!this.getProcessor().isProcessor()) {
            Activator.logWarning("Incorrect ProcessorContext creation " + this.getProcessor().getId());
        }
        this.configuration = configuration;
        this.coreNatures = new ArrayList<CoreNatureData>();
        Class expected = configuration.isExecutable() ? CoreData.class : CoreTypeData.class;
        for (CoreNatureConfiguration cConfiguration : configuration.getCoreNatureConfigurations()) {
            CoreNatureData cNature = cConfiguration.getCoreNature();
            if (cNature.getClass().equals(expected)) {
                this.coreNatures.add(cNature);
                this.coreNatureConfigurations.add(cConfiguration);
                CProjectMasterContext projectContext = configuration.isExecutable() ? new ExecutableContext(cConfiguration, this) : new LibraryContext(cConfiguration, this);
                this.projectContextMap.put(cNature.getId(), projectContext);
                continue;
            }
            Activator.logWarning("Incorrect coreNature " + cNature + " " + cNature.getClass().getSimpleName() + " " + configuration.isExecutable());
        }
        ContextType contextType = this.projectContextType = configuration.isExecutable() ? ContextType.PROJECT_EXECUTABLE : ContextType.PROJECT_LIBRARY;
        if (this.coreNatures.size() > 0) {
            this.currentCoreNatureId = this.coreNatures.get(0).getId();
        }
    }

    public ProcessorConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<CoreNatureConfiguration> getCoreNatureConfigurations() {
        return Collections.unmodifiableList(this.coreNatureConfigurations);
    }

    @Override
    public void initData() {
        super.initData();
        for (CProjectContext pc : this.projectContextMap.values()) {
            pc.initData();
        }
    }

    @Override
    public List<AbstractContext> getChildren() {
        return new ArrayList<AbstractContext>(this.projectContextMap.values());
    }

    @Override
    public AbstractContext getMainChildContext() {
        return this.isExecutable() ? this.getAutoStartProjectContext() : null;
    }

    @Override
    public void reset() {
        for (CProjectContext pc : this.projectContextMap.values()) {
            pc.reset();
        }
    }

    @Override
    public GeneralContext getParent() {
        return (GeneralContext)super.getParent();
    }

    @Override
    public boolean isAffected(String tag) {
        Parameter parameter = this.getParameter(tag);
        boolean affect = AffectType.isAffected(parameter, this.getCoreNatures(), this.isExecutable());
        return affect;
    }

    public List<IToolChain> getSelectedToolChains() {
        return this.getParent().getSelectedToolChains();
    }

    public boolean isExecutable() {
        return ContextType.PROCESSOR_EXECUTABLE == this.getContextType();
    }

    public ContextType getProjectContextType() {
        return this.projectContextType;
    }

    public Map<String, ConfigurationData> getDataMap() {
        return this.dataMap;
    }

    public ProcessorData getProcessor() {
        return (ProcessorData)this.getRootData();
    }

    public FamilyData getFamily() {
        return (FamilyData)this.getRootData().getElement("family");
    }

    public String getProcessorId() {
        return this.getProcessor().getId();
    }

    public CProjectContext getProjectContext(String coreNatureId) {
        return this.projectContextMap.get(coreNatureId);
    }

    public Map<String, CProjectContext> getProjectContextMap() {
        return Collections.unmodifiableMap(this.projectContextMap);
    }

    public List<CProjectContext> getProjectContexts() {
        return new ArrayList<CProjectContext>(this.projectContextMap.values());
    }

    public CProjectContext getAutoStartProjectContext() {
        if (this.isExecutable()) {
            List<CProjectContext> pcs = this.getProjectContexts();
            for (CProjectContext pc : pcs) {
                if (!pc.isAutoStart()) continue;
                return pc;
            }
        }
        return null;
    }

    public CProjectContext getDefaultEnabledProjectContext() {
        CProjectContext autoStart = this.getAutoStartProjectContext();
        if (autoStart != null) {
            return autoStart;
        }
        List<CProjectContext> pcs = this.getProjectContexts();
        return pcs.size() > 0 ? pcs.get(0) : null;
    }

    public List<CoreNatureData> getCoreNatures() {
        return Collections.unmodifiableList(this.coreNatures);
    }

    public ProjectContext getProjectContext(IProject project) {
        if (project == null) {
            return null;
        }
        for (CProjectContext context : this.projectContextMap.values()) {
            if (project.equals((Object)context.getProject())) {
                return context;
            }
            List<ProjectContext> rcs = context.getRelatedContexts();
            for (ProjectContext related : rcs) {
                if (!project.equals((Object)related.getProject())) continue;
                return related;
            }
        }
        return null;
    }

    public String getCurrentCoreNatureId() {
        return this.currentCoreNatureId;
    }

    public void setCurrentCoreNatureId(String currentCoreNatureId) {
        this.currentCoreNatureId = currentCoreNatureId;
    }

    public CProjectContext getCurrentProjectContext() {
        return this.getProjectContext(this.currentCoreNatureId);
    }

    public List<ProjectContext> getResultProjectContexts() {
        ArrayList<ProjectContext> result = new ArrayList<ProjectContext>();
        List<CProjectContext> active = this.getActiveProjectContexts();
        for (CProjectContext context : active) {
            result.add(context);
            List<ProjectContext> relatedContexts = context.getRelatedContexts();
            for (ProjectContext related : relatedContexts) {
                result.add(related);
            }
        }
        return result;
    }

    public List<CProjectContext> getActiveProjectContexts() {
        ArrayList<CProjectContext> result = new ArrayList<CProjectContext>();
        for (CProjectContext pc : this.projectContextMap.values()) {
            if (!pc.isActive()) continue;
            result.add(pc);
        }
        return result;
    }

    public boolean isMultiple() {
        return this.projectContextMap.size() > 1;
    }

    public static List<ConfigurationData> getCoreNatures(ConfigurationData processor, ContextType contextType) {
        return ContextType.PROCESSOR_EXECUTABLE == contextType ? processor.getElements("core") : processor.getElements("coreType");
    }

    public static ConfigurationData findAutostartCoreNature(ConfigurationData processor, ContextType contextType) {
        List<ConfigurationData> coreNatures = ProcessorContext.getCoreNatures(processor, contextType);
        for (ConfigurationData coreNature : coreNatures) {
            if (!coreNature.getBooleanValue("autoStart").booleanValue()) continue;
            return coreNature;
        }
        return null;
    }

    public String getProjectName(String coreNatureId) {
        CProjectContext pc = this.getProjectContext(coreNatureId);
        return pc != null ? pc.getProjectName() : "";
    }

    public String getProjectBaseName() {
        return this.getParent().getProjectBaseName();
    }

    public String getKey() {
        return this.configuration.getKey();
    }
}

