/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.commanderview;

import com.freescale.s32ds.cdt.core.commanderview.ICommandHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public abstract class CommanderWizardHandler
implements ICommandHandler {
    private final String wizardId;
    private final String categoryId;

    public CommanderWizardHandler(String categogyId, String wizardId) {
        this.categoryId = categogyId;
        this.wizardId = wizardId;
    }

    @Override
    public void execute(Map<String, ?> context) {
        IWizardDescriptor wizardDescr = this.findWizardDescriptor();
        try {
            IWorkbenchWizard wiz = wizardDescr.createWizard();
            IWorkbenchWindow window = (IWorkbenchWindow)context.get("workbenchWindow");
            WizardDialog dlg = new WizardDialog(window.getShell(), (IWizard)wiz);
            dlg.create();
            window.getWorkbench().getHelpSystem().setHelp((Control)dlg.getShell(), "org.eclipse.ui.new_wizard_context");
            dlg.open();
        }
        catch (CoreException exc) {
            Activator.log(exc);
        }
    }

    private IWizardDescriptor findWizardDescriptor() {
        IWizardRegistry registry = PlatformUI.getWorkbench().getNewWizardRegistry();
        IWizardCategory sCategory = registry.findCategory(this.categoryId);
        if (sCategory == null) {
            return null;
        }
        return sCategory.findWizard(this.wizardId);
    }

    @Override
    public boolean isEnabled(Map<String, ?> context) {
        return this.findWizardDescriptor() != null;
    }

    @Override
    public boolean supported() {
        return this.findWizardDescriptor() != null;
    }
}

