package com.nxp.s32ds.cross.sdk.s32k1xx_2_9_2.pexconf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Map;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SdkAttachStatusHandler;
import com.freescale.s32ds.cross.sdk.internal.hook.ProcessorExpertFileAdjuster;

public abstract class APExConfig implements ISDKHook {
	protected static final int MODE_BEFORE_ATTACH_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_BEFORE;
	protected static final int MODE_AFTER_ATTACH_ALL = ISDKHook.STATE_ATTACH_ALL + ISDKHook.TIME_AFTER;

	private static final String ATTACH_CONFIRMATION_MESSAGE = "Project's structure and settings can be changed after this SDK will be attached to it. Are you sure to continue?"; //$NON-NLS-1$

	private boolean isAdjustPExFile = false;

	@Override
	public IStatus checkPreconditions(int mode, ISDK sdk, Map<String, Object> context) {
		if (mode == MODE_BEFORE_ATTACH_ALL) {
			IStatus status = new Status(IStatus.WARNING, SDKSupportPlugin.getUniqueIdentifier(),
					SdkAttachStatusHandler.CHECK_ATTACH_PRECONDITIONS, ATTACH_CONFIRMATION_MESSAGE, null);
			return status;
		}
		return Status.OK_STATUS;
	}

	@Override
	public void stateChange(int mode, ISDK sdk, Object cfg, String path) {
		if (mode == MODE_BEFORE_ATTACH_ALL) {
			IFile pexFile = new ProcessorExpertFileAdjuster().getProcessorExpertFile(sdk, getProject(cfg));
			if (pexFile != null && pexFile.exists()) {
				try (BufferedReader br = new BufferedReader(
						new InputStreamReader(new FileInputStream(new File(pexFile.getLocationURI()))))) {
					String line = null;
					do {
						line = br.readLine();
					} while (line == null || line.trim().isEmpty());
					isAdjustPExFile = (line.startsWith("<?xml") || "<PEproject>".equals(line));
				} catch (Exception e) {
					Activator.log(e);
				}
			}
		}
	}

	protected IProject getProject(Object cfg) {
		IProject curProject = null;
		if (cfg instanceof ICConfigurationDescription) {
			ICConfigurationDescription cfgd = (ICConfigurationDescription) cfg;
			curProject = cfgd.getProjectDescription().getProject();
		} else if (cfg instanceof IConfiguration) {
			curProject = (IProject) ((IConfiguration) cfg)
					.getManagedProject().getOwner();
		} else {
			Activator.log(new IllegalArgumentException("Fail to invoke PExConfig Hook")); //$NON-NLS-1$
		}
		return curProject;
	}

	protected void adjustPExFile(ISDK sdk, IProject project) {
		if (isAdjustPExFile) {
			new PExFileAdjuster().adjustPExFile(sdk, project);
		}
	}
}
