
    bl    main
    .ltorg
    .size Reset_Handler, . - Reset_Handler

    .align	1
    .thumb
    .weak DefaultISR
    .type DefaultISR, $function
DefaultISR:
    b	DefaultISR
    .size DefaultISR, . - DefaultISR

;    Macro to define default handlers. Default handler
;    will be weak symbol and just dead loops. They can be
;    overwritten by other handlers
    .macro def_irq_handler	handler_name
    .weak handler_name
    .set  handler_name, DefaultISR
    .endm

; Exception Handlers
        def_irq_handler    NMI_Handler                                   ;NMI Handler
        def_irq_handler    HardFault_Handler                             ;Hard Fault Handler
        def_irq_handler    MemManage_Handler                             ;MPU Fault Handler
        def_irq_handler    BusFault_Handler                              ;Bus Fault Handler
        def_irq_handler    UsageFault_Handler                            ;Usage Fault Handler
        def_irq_handler    exception_trap                                ; SVCall 
        def_irq_handler    interrupt_trap                                

    .end
