/*****************************************************************************/
/* Version: GCC for ARM Embedded Processors                                  */
/*****************************************************************************/
    .arch armv6-m

     .thumb

    .section .isr_vector, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
    .long   __StackTop                                      /* Top of Stack */
    .long   Reset_Handler                                   /* Reset Handler */
    .long   NMI_Handler                                     /* NMI Handler*/
    .long   HardFault_Handler                               /* Hard Fault Handler*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   SVC_Handler                                     /* SVCall Handler*/
    .long   0                                               /* Reserved*/
    .long   0                                               /* Reserved*/
    .long   PendSV_Handler                                  /* PendSV Handler*/
    .long   SysTick_Handler                                 /* SysTick Handler*/

                                                            /* External Interrupts*/
    .long   CPU2CPU_int0_IRQHandler                         /* CPU to CPU int0 interrupt*/
    .long   CPU2CPU_int1_IRQHandler                         /* CPU to CPU int1 interrupt*/
    .long   CPU2CPU_int2_IRQHandler                         /* CPU to CPU int2 interrupt*/
    .long   CPU2CPU_int3_IRQHandler                         /* CPU to CPU int3 interrupt*/
    .long   Reserved20_IRQHandler                           /* Reserved interrupt*/
    .long   Directed_CM0_IRQHandler                         /* Directed CM0+ interrupt*/
    .long   Reserved22_IRQHandler                           /* Reserved interrupt*/   
    .long   Reserved23_IRQHandler                           /* Reserved interrupt*/     
    .long   DMA0_IRQHandler                                 /* DMA transfer complete channels 0-15 */
    .long   DMA0_Error_IRQHandler                           /* DMA error interrupt channels 0-15*/
    .long   ERM_errors_IRQHandler                           /* CM4, SRAM, GRAM, IOP RAM, or Flash ECC/ Parity errors*/
    .long   FXOSC_SXOSC_IRQHandler                          /* Fast External Oscillator/Slow external oscillator*/
    .long   SWT_2_IRQHandler                                /* Watchdog for CM0+ core*/
    .long   Reserved29_IRQHandler                           /* Reserved interrupt*/
    .long   CMP0_IRQHandler                                 /* Analog Comparator_0*/
    .long   PIT_IRQHandler                                  /* Peridoc Interrupt Timer*/
    .long   SIUL2_IRQHandler                                /* System Integration Unit*/
    .long   SPI2_IRQHandler                                 /* Deserial Serial Peripheral Interface*/    
    .long   ADC_IRQHandler                                  /* Analog to digital converter*/  
    .long   SEG_LCD_IRQHandler                              /* Segment LCD controller*/  
    .long   SMC_IRQHandler                                  /* Stepper Motor Controller*/  
    .long   SSD0_IRQHandler                                 /* Stepper Stall detect 0*/  
    .long   SSD1_IRQHandler                                 /* Stepper Stall detect 1*/  
    .long   SSD2_IRQHandler                                 /* Stepper Stall detect 2*/  
    .long   SSD3_IRQHandler                                 /* Stepper Stall detect 3*/  
    .long   SSD4_IRQHandler                                 /* Stepper Stall detect 4*/  
    .long   SSD5_IRQHandler                                 /* Stepper Stall detect 5*/  
    .long   FTM_IRQHandler                                  /* Flex Timer 0 */  
    .long   MC_ME_IOP_INT_IRQHandler                        /* Magic Carpet Mode Entry / IOP_INT*/ 
    .long   MC_RGM_IRQHandler                               /* Magic Carpet Reset Generation*/ 
    .long   RTC_IRQHandler                                  /* real time clock*/ 
    .long   WKPU_IRQHandler                                 /* Wake up unit*/ 
 
    .size    __isr_vector, . - __isr_vector

    .section .init_handler, "a"
    .thumb

/* Reset Handler */

    .thumb_func
    .align 2
    .globl   Reset_Handler
    .type    Reset_Handler, %function
Reset_Handler:
    cpsid   i               // Mask interrupts

    // Init the rest of the registers
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7

    // Initialize the stack pointer
    ldr     r0,=__StackTop
    mov     r13,r0

    cpsie   i               // Unmask interrupts

    .extern init_data
    bl      init_data
        
    /* jump to main */
        /* jump to startup */
#ifndef __START
#ifdef __EWL__
#define __START  __thumb_startup
#else
#define __START _start
#endif
#endif
        bl	__START

  .align	1
  .thumb_func
  .weak	Default_Handler
  .type	Default_Handler, %function
Default_Handler:
  b	.
  .size	Default_Handler, . - Default_Handler

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
  .macro	def_irq_handler	handler_name
  .weak	\handler_name
  .set	\handler_name, Default_Handler
  .endm

/* Exception Handlers */
    def_irq_handler    NMI_Handler
    def_irq_handler    HardFault_Handler
    def_irq_handler    SVC_Handler
    def_irq_handler    PendSV_Handler
    def_irq_handler    SysTick_Handler
    def_irq_handler    CPU2CPU_int0_IRQHandler                 
    def_irq_handler    CPU2CPU_int1_IRQHandler                 
    def_irq_handler    CPU2CPU_int2_IRQHandler                 
    def_irq_handler    CPU2CPU_int3_IRQHandler                 
    def_irq_handler    Reserved20_IRQHandler                   
    def_irq_handler    Directed_CM0_IRQHandler                 
    def_irq_handler    Reserved22_IRQHandler                   
    def_irq_handler    Reserved23_IRQHandler                   
    def_irq_handler    DMA0_IRQHandler                         
    def_irq_handler    DMA0_Error_IRQHandler                   
    def_irq_handler    ERM_errors_IRQHandler                   
    def_irq_handler    FXOSC_SXOSC_IRQHandler                  
    def_irq_handler    SWT_2_IRQHandler                        
    def_irq_handler    Reserved29_IRQHandler                   
    def_irq_handler    CMP0_IRQHandler                         
    def_irq_handler    PIT_IRQHandler                          
    def_irq_handler    SIUL2_IRQHandler                        
    def_irq_handler    SPI2_IRQHandler                         
    def_irq_handler    ADC_IRQHandler                          
    def_irq_handler    SEG_LCD_IRQHandler                      
    def_irq_handler    SMC_IRQHandler                          
    def_irq_handler    SSD0_IRQHandler                         
    def_irq_handler    SSD1_IRQHandler                         
    def_irq_handler    SSD2_IRQHandler                         
    def_irq_handler    SSD3_IRQHandler                         
    def_irq_handler    SSD4_IRQHandler                         
    def_irq_handler    SSD5_IRQHandler                         
    def_irq_handler    FTM_IRQHandler                          
    def_irq_handler    MC_ME_IOP_INT_IRQHandler                
    def_irq_handler    MC_RGM_IRQHandler                       
    def_irq_handler    RTC_IRQHandler                          
    def_irq_handler    WKPU_IRQHandler                         
    def_irq_handler    DefaultISR
   
    .end
